// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --version 6

// RUN: %clang_cc1        -triple aarch64-none-linux-gnu -target-feature +neon -O2 -Werror -Wall -emit-llvm -o - %s | FileCheck %s
// RUN: %clang_cc1 -x c++ -triple aarch64-none-linux-gnu -target-feature +neon -O2 -Werror -Wall -emit-llvm -o - %s | FileCheck %s -check-prefix CHECK-CXX

// RUN: %clang_cc1        -triple aarch64-none-linux-gnu -target-feature +neon -O2 -Werror -Wall -S -o /dev/null %s

// REQUIRES: aarch64-registered-target

#include <arm_neon.h>

// CHECK-LABEL: define dso_local <8 x i8> @vector_init_test(
// CHECK-SAME: <1 x i8> [[X:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[VECINIT14:%.*]] = shufflevector <1 x i8> [[X]], <1 x i8> poison, <8 x i32> zeroinitializer
// CHECK-NEXT:    ret <8 x i8> [[VECINIT14]]
//
// CHECK-CXX-LABEL: define dso_local <8 x i8> @_Z16vector_init_testu6__mfp8(
// CHECK-CXX-SAME: <1 x i8> [[X:%.*]]) local_unnamed_addr #[[ATTR0:[0-9]+]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    [[VECINIT14:%.*]] = shufflevector <1 x i8> [[X]], <1 x i8> poison, <8 x i32> zeroinitializer
// CHECK-CXX-NEXT:    ret <8 x i8> [[VECINIT14]]
//
mfloat8x8_t vector_init_test(__mfp8 x) {
   return (mfloat8x8_t) {x, x, x, x, x, x, x, x};
}

struct S {
    __mfp8 x;
};

struct S s;

// CHECK-LABEL: define dso_local void @f(
// CHECK-SAME: <1 x i8> [[X:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    store <1 x i8> [[X]], ptr @s, align 1, !tbaa [[__MFP8_TBAA6:![0-9]+]]
// CHECK-NEXT:    ret void
//
// CHECK-CXX-LABEL: define dso_local void @_Z1fu6__mfp8(
// CHECK-CXX-SAME: <1 x i8> [[X:%.*]]) local_unnamed_addr #[[ATTR1:[0-9]+]] {
// CHECK-CXX-NEXT:  [[ENTRY:.*:]]
// CHECK-CXX-NEXT:    store <1 x i8> [[X]], ptr @s, align 1, !tbaa [[__MFP8_TBAA6:![0-9]+]]
// CHECK-CXX-NEXT:    ret void
//
void f(__mfp8 x) {
    s = (struct S){x};
}
//.
// CHECK: [[META4:![0-9]+]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// CHECK: [[META5]] = !{!"Simple C/C++ TBAA"}
// CHECK: [[__MFP8_TBAA6]] = !{[[META7:![0-9]+]], [[META7]], i64 0}
// CHECK: [[META7]] = !{!"__mfp8", [[META4]], i64 0}
//.
// CHECK-CXX: [[META4:![0-9]+]] = !{!"omnipotent char", [[META5:![0-9]+]], i64 0}
// CHECK-CXX: [[META5]] = !{!"Simple C++ TBAA"}
// CHECK-CXX: [[__MFP8_TBAA6]] = !{[[META7:![0-9]+]], [[META7]], i64 0}
// CHECK-CXX: [[META7]] = !{!"__mfp8", [[META4]], i64 0}
//.
