;; NOTE: Assertions have been generated by update_lit_checks.py --all-items and should not be edited.
;; RUN: foreach %s %t wasm-ctor-eval --ctors=test --kept-exports=test --quiet -all -S -o - | filecheck %s

;; Test that we can precompute continuations.

(module
  (type $f (func))
  (type $k (cont $f))

  (tag $more)

  (global $g (mut i32) (i32.const 0))

  (func $run (param $k (ref $k))
    ;; Run a coroutine, continuing to resume it until it is complete.
    ;; start
    (loop $loop
      (block $on (result (ref $k))
        (resume $k (on $more $on)
          (local.get $k)
        )
        ;; stop
        (return)
      )
      ;; continue
      (local.set $k)
      (br $loop)
    )
    (unreachable)
  )

  (func $cont
    ;; increment the global three times, around suspends.
    (global.set $g (i32.add (global.get $g) (i32.const 1)))
    (suspend $more)
    (global.set $g (i32.add (global.get $g) (i32.const 1)))
    (suspend $more)
    (global.set $g (i32.add (global.get $g) (i32.const 1)))
  )

  (func $test (export "test") (result i32)
    ;; All of this can be computed, leaving a return of 3.
    (call $run
      (cont.new $k (ref.func $cont))
    )
    (global.get $g)
  )
)
;; CHECK:      (type $0 (func (result i32)))

;; CHECK:      (export "test" (func $test_3))

;; CHECK:      (func $test_3 (type $0) (result i32)
;; CHECK-NEXT:  (i32.const 3)
;; CHECK-NEXT: )
