///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoQueryException.cc
// ---------------------
// Cego procedure exception container class
//      
// Design and Implementation by Bjoern Lemke
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoQueryException
//
// Description: Data structure description for cego procedure exception
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoQueryException.h"

CegoQueryException::CegoQueryException(CegoException excep, const Chain& module, int line, const Chain& msg) : Exception(module, line, msg)
{
    _excep = excep;
}

CegoQueryException::CegoQueryException(CegoException excep, const Chain& module, int line, const Chain& msg, const Exception& e) : Exception(module, line, msg, e)
{
    _excep = excep;
}

CegoQueryException::~CegoQueryException()
{
}
    
CegoException CegoQueryException::getException() const
{
    return _excep;
}

CegoQueryException& CegoQueryException::operator = ( const CegoQueryException& qe)
{
    _excep = qe._excep;
    return (*this);
}

bool CegoQueryException::operator == ( const CegoQueryException& qe)
{
    if ( _excep == qe._excep )
	return true;
    return false;
}

Chain CegoQueryException::toChain() const
{
    Chain s("N/A");
    return s;
}
    
ostream& operator << (ostream& s, const CegoQueryException& qe)
{    
    s << qe.toChain();
    return s;
}
