///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoProcIfStmt.cc  
// -----------------    
// Cego procedure if statement class implementation
//                                                 
// Design and Implementation by Bjoern Lemke               
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoProcIfStmt
// 
// Description: Stored procedure if-statement block handling
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// cego includes
#include "CegoProcIfStmt.h"
#include "CegoDatabaseFormater.h"

CegoProcIfStmt::CegoProcIfStmt(ListT<CegoProcCond*>& condList,
				   ListT<CegoProcBlock*>& ifBlockList,
				   CegoProcBlock *pBlock) : CegoProcStmt(pBlock)
{
    _condList = condList;
    _ifBlockList = ifBlockList;
}

CegoProcIfStmt::~CegoProcIfStmt()  
{
    CegoProcCond** pCond = _condList.First();
    
    while  ( pCond )
    {
	delete *pCond;
	pCond = _condList.Next();
    }

    CegoProcBlock** pBlock = _ifBlockList.First();
    while ( pBlock )
    {
	delete *pBlock;
	pBlock = _ifBlockList.Next();
    }  
}

CegoException CegoProcIfStmt::execute()
{
    CegoProcCond** pCond = _condList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    while ( pCond )
    {	
	(*pCond)->setBlock(getParentBlock());

	try
	{
	    
	    if ( (*pCond)->eval() == true )
	    {
		return (*pBlock)->execute();		
	    }
	    else
	    {
		pCond = _condList.Next();
		pBlock = _ifBlockList.Next();
	    }
	}
	catch ( Exception e )
	{
	    Chain excepMsg;
	    e.pop(excepMsg);
	    getParentBlock()->setExceptionMsg(excepMsg);
	    return COREOP_EXCEP;
	}
    }
    
    if ( pBlock )
    { 
	return (*pBlock)->execute();
    }
    
    return NONE_EXCEP;
}

Chain CegoProcIfStmt::toChain(const Chain& indent) const
{
    Chain s;

    CegoProcCond** pCond = _condList.First();
    CegoProcBlock** pBlock = _ifBlockList.First();
    
    s = indent + Chain("if ");
    
    while ( pCond )
    {
	s += (*pCond)->toChain();	
	s += Chain("\n") + indent + Chain("then\n");	    
	s += (*pBlock)->toChain(indent + Chain(DEFAULTINDENT));
	
	pCond = _condList.Next();
	pBlock = _ifBlockList.Next();
	if ( pCond )
	    s += indent + Chain("elsif ");
	else if ( pBlock == 0 )
	    s += indent + Chain("end");
    }
    if ( pBlock )
    {
	s += indent + Chain("else\n");
	s += (*pBlock)->toChain(indent + Chain(DEFAULTINDENT));
	s += indent + Chain("end");
    }

    return s;
}

Chain CegoProcIfStmt::dbFormat(CegoDatabaseFormater *pForm) const
{
    return pForm->formatProcIfStmt(_condList, _ifBlockList);
}
