///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoOrderNode.cc
// ----------------
// Cego order node class implementation
//     
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// Class: CegoOrderNode
//
// Description: Tuple ordering handle
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// LFC INCLUDES
#include <lfcbase/Exception.h>

// CEGO INCLUDES
#include "CegoOrderNode.h"

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoOrderNode::CegoOrderNode()
{
}

CegoOrderNode::CegoOrderNode(ListT<CegoFieldValue>& key, ListT<CegoFieldValue>& tuple, ListT<Ordering>* pOrdering)
{
    _key = key;
    _tuple = tuple;
    _pOrdering = pOrdering;
}

CegoOrderNode::~CegoOrderNode()
{
}

ListT<CegoFieldValue>& CegoOrderNode::getKey()
{
    return _key;
}

ListT<CegoFieldValue>& CegoOrderNode::getTuple()
{
    return _tuple;
}

CegoOrderNode& CegoOrderNode::operator = ( const CegoOrderNode& n)
{
    _key = n._key;
    _tuple = n._tuple;
    _pOrdering = n._pOrdering;
    return (*this);
}

bool CegoOrderNode::operator == ( const CegoOrderNode& n)
{
    Ordering *pOrd = _pOrdering->First();
    CegoFieldValue* pFV1 = _key.First();
    CegoFieldValue* pFV2 = n._key.First();

    while ( pOrd && pFV1 && pFV2 )
    {
	if ( *pFV1 < *pFV2 )
	{
	    return false;
	}
	else if ( *pFV1 > *pFV2 )
	{
	    return false;
	}

	pOrd = _pOrdering->Next();
	pFV1 = _key.Next();
	pFV2 = n._key.Next();
    }

    return true;
}

bool CegoOrderNode::operator > ( const CegoOrderNode& n)
{
    Ordering *pOrd = _pOrdering->First();

    CegoFieldValue* pFV1 = _key.First();
    CegoFieldValue* pFV2 = n._key.First();

    while ( pOrd && pFV1 && pFV2 )
    {
	if ( *pFV1 < *pFV2 )
	{
	    if ( *pOrd == ASC )
	    {
		return false;
	    }
	    else
	    {
		return true;
	    }
	}
	else if ( *pFV1 > *pFV2 )
	{
	    if ( *pOrd == ASC )
	    {
		return true;
	    }
	    else
	    {
		return false;
	    }
	}

	pOrd = _pOrdering->Next();
	pFV1 = _key.Next();
	pFV2 = n._key.Next();
    }

    return false;
}

bool CegoOrderNode::operator < ( const CegoOrderNode& n)
{
    Ordering *pOrd = _pOrdering->First();
    CegoFieldValue* pFV1 = _key.First();
    CegoFieldValue* pFV2 = n._key.First();

    while ( pOrd && pFV1 && pFV2 )
    {
	if ( *pFV1 < *pFV2 )
	{
	    if ( *pOrd == ASC )
		return true;
	    else
		return false;
	}
	else if ( *pFV1 > *pFV2 )
	{
	    if ( *pOrd == ASC )
		return false;
	    else
		return true;
	}

	pOrd = _pOrdering->Next();
	pFV1 = _key.Next();
	pFV2 = n._key.Next();
    }

    return false;
}
