///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDecodableObject.cc 
// ----------------------
// Cego decodable object entry implementation
//     
// Design and Implementation by Bjoern Lemke               
//     
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoDecodableObject
//
// Description: Super class for any database object, which is decodable
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoDecodableObject.h"

CegoDecodableObject::CegoDecodableObject()
{
    _isLocal = true;
}

CegoDecodableObject::CegoDecodableObject(const CegoDecodableObject& co) : CegoObject(co)
{
    _isLocal = true;
}

CegoDecodableObject::CegoDecodableObject(CegoObject::ObjectType type, const Chain& objName, int tabSetId) : CegoObject(type, objName, tabSetId)
{
    _isLocal = true;
}

CegoDecodableObject::~CegoDecodableObject()
{   
}

CegoDecodableObject& CegoDecodableObject::operator = ( const CegoDecodableObject& deo)
{
    CegoObject::operator=(deo);
    _isLocal = deo._isLocal;
    _tableSet = deo._tableSet;
    return (*this);
}

bool CegoDecodableObject::operator == ( const CegoDecodableObject& deo)
{
    return CegoObject::operator==(deo);
}
