///////////////////////////////////////////////////////////////////////////////
//                                                         
// CegoDataPointer.cc
// ------------------
// Cego data pointer class implementation
//     
// Design and Implementation by Bjoern Lemke
//
// (C)opyright 2000-2019 Bjoern Lemke
//
// IMPLEMENTATION MODULE
//
// Class: CegoDataPointer
//
// Description: The CegoDataPointer class represents the location of a data entry in any data file.
//              The class provides also encoding and decoding methods to store the pointer information
//              into the database. 
//
// Status: CLEAN
//
///////////////////////////////////////////////////////////////////////////////

// CEGO INCLUDES
#include "CegoDataPointer.h"

// POSIX INCLUDES
#include <string.h>
#include <stdlib.h>

CegoDataPointer::CegoDataPointer()
{
    _pageId = 0;
    _offset = 0;
}

CegoDataPointer::CegoDataPointer(PageIdType pageId, int offset)
{
    _pageId = pageId;
    _offset = offset;
}

CegoDataPointer::~CegoDataPointer()
{
}

int CegoDataPointer::getEncodingLength()
{
    return ( sizeof(PageIdType) + sizeof(int));
}

void CegoDataPointer::setPageId(PageIdType pageId)
{
    _pageId = pageId;
}

PageIdType CegoDataPointer::getPageId() const
{
    return _pageId;
}
 
void CegoDataPointer::setOffset(int offset)
{
    _offset = offset;
}

int CegoDataPointer::getOffset() const
{
    return _offset;
}

void CegoDataPointer::encode(void* p) const
{
    char* pI = (char*)p;
    memcpy(pI, &_pageId, sizeof(PageIdType));
    pI+=sizeof(PageIdType);
    memcpy(pI, &_offset, sizeof(int));
}

void CegoDataPointer::decode(void* p)
{
    char* pI = (char*)p;
    memcpy(&_pageId, pI, sizeof(PageIdType));
    pI+=sizeof(PageIdType);
    memcpy(&_offset, pI, sizeof(int));
}

CegoDataPointer& CegoDataPointer::operator = ( const CegoDataPointer& d)
{
    _pageId = d._pageId;
    _offset = d._offset;
    return (*this);
}

bool CegoDataPointer::operator == ( const CegoDataPointer& d) const
{
    if ( _pageId == d._pageId && _offset == d._offset )
	return true;
    return false;
}

bool CegoDataPointer::operator != ( const CegoDataPointer& d) const
{
    if ( _pageId != d._pageId || _offset != d._offset )
	return true;
    return false;
}

Chain CegoDataPointer::toChain() const
{
    Chain s;
    s = "[" + Chain(getPageId()) + "," + Chain(getOffset()) + "]";
    return s;
}

ostream& operator << (ostream& s, const CegoDataPointer& dp)
{
    s << "[" << dp.getPageId() << "," << dp.getOffset() << "]";
    return s;
}
