--
-- ### Advanced foreign key checks
--
 
-- one-dimensional fkey
 
drop if exists table t1;
drop if exists table t2;
 
create table t1 ( primary a int not null, b int );
create table t2 ( primary c int not null, d int );
alter table t2 add foreign key fk1 ( d ) references t1 ( a );
create btree b2 on t2(d);
 
tableinfo t2;
 
insert into t1 values ( 1, 22);
insert into t1 values ( 2, 33);
insert into t1 values ( 3, 44);
insert into t1 values ( 4, 55);
insert into t1 values ( 7, 99);
 
insert into t2 values ( 1, 1);
-- insert into t2 values ( 2, 2);
insert into t2 values ( 3, 3);
 
update t1 set b = 23, a = 8 where a = 2;
update t2 set d = 5 + 2 where d = 3;
update t2 set c = 55 where d = 1;
 
insert into t2 values ( 15, 8);
update t1 set b = 111, a = 9 where a = 3;
 
select * from t1;
select * from t2;

drop table t2;
drop table t1;

-- two-dimensional fkey
create table t1 ( primary a int not null, primary b int not null);
create table t2 ( primary c int not null, d int );
 
alter table t2 add foreign key fk1 ( c, d ) references t1 ( a, b );
insert into t1 values ( 1, 22);
insert into t1 values ( 2, 33);
insert into t1 values ( 3, 44);
insert into t1 values ( 4, 55);
insert into t1 values ( 7, 99);
 
insert into t2 values ( 1, 22);
insert into t2 values ( 2, 33);
insert into t2 values ( 7, 99);

drop table t2;
drop table t1;

