%feature("docstring") OT::ComposedFunction
"Composed function.

Available constructor:
    ComposedFunction(*f, g*)

The function is the composed function :math:`f\\circ g`.

Parameters
----------
f,g : two :class:`~openturns.Function`
    The functions to compose.

Examples
--------
>>> import openturns as ot
>>> g = ot.SymbolicFunction(['x1', 'x2'],
...                           ['x1 + x2','3 * x1 * x2'])
>>> f = ot.SymbolicFunction(['x1', 'x2'], ['2 * x1 - x2'])
>>> composed = ot.ComposedFunction(f, g)
>>> print(composed([3, 4]))
[-22]"
