%define OT_SpaceFillingMinDist_doc
"Space filling minimal distance criterion.

Notes
-----
Compute the criterion based on the minimal distance of sample points:

.. math::
    :nowrap:

    \\begin{equation*}
      \\phi_{min}(\\mat{X}) = \\min_{i \\neq j} \\norm{ \\vect{x}^{(i)} - \\vect{x}^{(j)} }
    \\end{equation*}


If at least one of the sample points does not belong to the unit cube
(i.e. not all components belong to the interval :math:`[0,1]`),
then the whole sample is rescaled.
Letting :math:`\\vect{M}` (resp. :math:`\\vect{m}`) denote the point
containing the component-wise maximum (resp. minimum) values of the sample,
the actual formula is in this case:

.. math::
    :nowrap:

    \\begin{equation*}
      \\phi_{min}(X) = \\min_{i \\neq j} \\norm{ \\frac{\\vect{x}^{(i)} - \\vect{x}^{(j)}}{\\vect{M} - \\vect{m}} }
    \\end{equation*}
"
%enddef
%feature("docstring") OT::SpaceFillingMinDist
OT_SpaceFillingMinDist_doc
// ---------------------------------------------------------------------
%define OT_SpaceFillingMinDist_evaluate_doc
"Compute the MinDist criterion for a specific design.

Parameters
----------
design : :class:`~openturns.Sample` or 2-d array like
    The design

Returns
-------
crit : float
    The MinDist criterion

Examples
--------
>>> import openturns as ot
>>> # Build an LHS using openturns class
>>> lhs = ot.LHSExperiment(ot.Uniform(), 100)
>>> design = lhs.generate()
>>> # Compute the MinDist criterion
>>> crit = ot.SpaceFillingMinDist().evaluate(design)"
%enddef
%feature("docstring") OT::SpaceFillingMinDist::evaluate
OT_SpaceFillingMinDist_evaluate_doc
// ---------------------------------------------------------------------
