/*
 @licstart  The following is the entire license notice for the JavaScript code in this file.

 The MIT License (MIT)

 Copyright (C) 1997-2020 by Dimitri van Heesch

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 and associated documentation files (the "Software"), to deal in the Software without restriction,
 including without limitation the rights to use, copy, modify, merge, publish, distribute,
 sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or
 substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

 @licend  The above is the entire license notice for the JavaScript code in this file
*/
var NAVTREE =
[
  [ "GeographicLib", "index.html", [
    [ "GeographicLib library", "index.html", "index" ],
    [ "Introduction", "intro.html", null ],
    [ "Installing GeographicLib", "install.html", [
      [ "Installation with cmake", "install.html#cmake", null ],
      [ "Installation using the autoconfigure tools", "install.html#autoconf", null ],
      [ "Using a binary installer", "install.html#binaryinst", [
        [ "Windows", "install.html#binaryinstwin", null ],
        [ "MacOSX", "install.html#binaryinstosx", null ],
        [ "Linux", "install.html#binaryinstlin", null ]
      ] ],
      [ "Maintainer tasks", "install.html#maintainer", null ]
    ] ],
    [ "Getting started", "start.html", null ],
    [ "Utility programs", "utilities.html", null ],
    [ "Code organization", "organization.html", null ],
    [ "GeographicLib in other languages", "other.html", [
      [ "Implementations in other languages", "other.html#implement", null ],
      [ "Using wrappers to invoke GeographicLib", "other.html#wrappers", null ],
      [ "Maxima routines", "other.html#maxima", null ]
    ] ],
    [ "Geoid height", "geoid.html", [
      [ "Installing the geoid datasets", "geoid.html#geoidinst", null ],
      [ "The format of the geoid data files", "geoid.html#geoidformat", null ],
      [ "Interpolating the geoid data", "geoid.html#geoidinterp", null ],
      [ "Caching the geoid data", "geoid.html#geoidcache", null ],
      [ "Test data for geoids", "geoid.html#testgeoid", null ]
    ] ],
    [ "Gravity models", "gravity.html", [
      [ "Installing the gravity models", "gravity.html#gravityinst", null ],
      [ "The format of the gravity model files", "gravity.html#gravityformat", null ],
      [ "Comments on the NGA harmonic synthesis code", "gravity.html#gravitynga", null ],
      [ "Details of the geoid height and anomaly calculations", "gravity.html#gravitygeoid", null ],
      [ "The effect of the mass of the atmosphere", "gravity.html#gravityatmos", null ],
      [ "Geoid heights on a multi-processor system", "gravity.html#gravityparallel", null ]
    ] ],
    [ "Normal gravity", "normalgravity.html", [
      [ "Ellipsoidal coordinates", "normalgravity.html#normalgravcoords", null ],
      [ "The normal potential", "normalgravity.html#normalgravpot", null ],
      [ "The mass distribution", "normalgravity.html#normalgravmass", null ],
      [ "The surface gravity", "normalgravity.html#normalgravsurf", null ],
      [ "The mean gravity", "normalgravity.html#normalgravmean", null ],
      [ "Possible values of the dynamical form factor", "normalgravity.html#normalgravj2", null ]
    ] ],
    [ "Magnetic models", "magnetic.html", [
      [ "Installing the magnetic field models", "magnetic.html#magneticinst", null ],
      [ "The format of the magnetic model files", "magnetic.html#magneticformat", null ]
    ] ],
    [ "Geodesics on an ellipsoid of revolution", "geodesic.html", [
      [ "Test data for geodesics", "geodesic.html#testgeod", null ],
      [ "Expansions for geodesics", "geodesic.html#geodseries", null ],
      [ "Geodesics in terms of elliptic integrals", "geodesic.html#geodellip", null ],
      [ "Parameters for the meridian", "geodesic.html#meridian", null ],
      [ "Short geodesics", "geodesic.html#geodshort", [
        [ "Bowring's method", "geodesic.html#bowring", null ],
        [ "Bessel's auxiliary sphere", "geodesic.html#auxsphere", null ],
        [ "Estimating the accuracy", "geodesic.html#shorterr", null ]
      ] ]
    ] ],
    [ "Finding nearest neighbors", "nearest.html", null ],
    [ "Geodesics on a triaxial ellipsoid", "triaxial.html", [
      [ "Triaxial coordinate systems", "triaxial.html#triaxial-coords", null ],
      [ "Jacobi's solution", "triaxial.html#triaxial-jacobi", null ],
      [ "Survey of triaxial geodesics", "triaxial.html#triaxial-survey", null ],
      [ "The stability of closed geodesics", "triaxial.html#triaxial-stab", null ],
      [ "The inverse problem", "triaxial.html#triaxial-inverse", null ],
      [ "Jacobi's conformal projection", "triaxial.html#triaxial-conformal", null ]
    ] ],
    [ "Jacobi's conformal projection", "jacobi.html", [
      [ "Conformal projection", "jacobi.html#jacobi-conformal", null ],
      [ "The projection in terms of elliptic integrals", "jacobi.html#jacobi-elliptic", null ],
      [ "Properties of the projection", "jacobi.html#jacobi-properties", null ],
      [ "Limiting cases", "jacobi.html#jacobi-limiting", null ],
      [ "Conformal mapping of an ellipsoid to a sphere", "jacobi.html#jacobi-sphere", null ],
      [ "An implementation of the projection", "jacobi.html#jacobi-implementation", null ]
    ] ],
    [ "Rhumb lines", "rhumb.html", [
      [ "Formulation of the rhumb line problem", "rhumb.html#rhumbform", null ],
      [ "Determining the auxiliary latitudes", "rhumb.html#rhumblat", null ],
      [ "The area under a rhumb line", "rhumb.html#rhumbarea", null ],
      [ "Use of divided differences", "rhumb.html#divideddiffs", null ],
      [ "Clenshaw evaluation of differenced sums", "rhumb.html#dividedclenshaw", null ],
      [ "Plate carrée areas", "rhumb.html#platecarreearea", null ]
    ] ],
    [ "Great Ellipses", "greatellipse.html", [
      [ "Solution of great ellipse problems", "greatellipse.html#geformulation", null ],
      [ "The area under a great ellipse", "greatellipse.html#gearea", null ],
      [ "Great ellipses vs geodesics", "greatellipse.html#gevsgeodesic", null ]
    ] ],
    [ "Transverse Mercator projection", "transversemercator.html", [
      [ "Test data for the transverse Mercator projection", "transversemercator.html#testmerc", null ],
      [ "Series approximation for transverse Mercator", "transversemercator.html#tmseries", null ],
      [ "Figures from paper on transverse Mercator projection", "transversemercator.html#tmfigures", null ]
    ] ],
    [ "Geocentric coordinates", "geocentric.html", null ],
    [ "Auxiliary latitudes", "auxlat.html", [
      [ "Series approximations for conversions", "auxlat.html#auxlatformula", null ],
      [ "Series approximations in tabular form", "auxlat.html#auxlattable", null ],
      [ "Truncation errors", "auxlat.html#auxlaterror", null ]
    ] ],
    [ "Support for high precision arithmetic", "highprec.html", null ],
    [ "Change log", "changes.html", null ],
    [ "Deprecated List", "deprecated.html", null ],
    [ "Namespaces", "namespaces.html", [
      [ "Namespace List", "namespaces.html", "namespaces_dup" ],
      [ "Namespace Members", "namespacemembers.html", [
        [ "All", "namespacemembers.html", null ],
        [ "Functions", "namespacemembers_func.html", null ]
      ] ]
    ] ],
    [ "Classes", "annotated.html", [
      [ "Class List", "annotated.html", "annotated_dup" ],
      [ "Class Hierarchy", "hierarchy.html", "hierarchy" ],
      [ "Class Members", "functions.html", [
        [ "All", "functions.html", "functions_dup" ],
        [ "Functions", "functions_func.html", "functions_func" ],
        [ "Variables", "functions_vars.html", null ],
        [ "Typedefs", "functions_type.html", null ],
        [ "Enumerations", "functions_enum.html", null ],
        [ "Enumerator", "functions_eval.html", null ],
        [ "Related Symbols", "functions_rela.html", null ]
      ] ]
    ] ],
    [ "Files", "files.html", [
      [ "File List", "files.html", "files_dup" ],
      [ "File Members", "globals.html", [
        [ "All", "globals.html", null ],
        [ "Functions", "globals_func.html", null ],
        [ "Typedefs", "globals_type.html", null ],
        [ "Macros", "globals_defs.html", null ]
      ] ]
    ] ]
  ] ]
];

var NAVTREEINDEX =
[
"Accumulator_8cpp.html",
"classGeographicLib_1_1Accumulator.html#a0d33929445d260b16ad18c18d4112358",
"classGeographicLib_1_1Constants.html#a4ec5a9d91ab0ccbd3bd921cda4bfc836",
"classGeographicLib_1_1EllipticFunction.html#aaf778aa0b82cbb4e44a5e2886814d264",
"classGeographicLib_1_1Geodesic.html#ae66c9cecfcbbcb1da52cb408e69f65de",
"classGeographicLib_1_1GeodesicLineExact.html#a7e4d18e189f3515bc3140db6f7f42302a142d2e27181d0cd31e015795772877a6",
"classGeographicLib_1_1GravityModel.html#aa49d04f9f21c06cb652b9977196fcffe",
"classGeographicLib_1_1Math.html#a794518e19e5af9699ae0758462b7a5c6",
"classGeographicLib_1_1Rhumb.html#abce42c564f55b44aba8fcf96c521d46d",
"classGeographicLib_1_1UTMUPS.html#aa21ec1bc26f691e0a6f2ccc44debe6f0"
];

var SYNCONMSG = 'click to disable panel synchronization';
var SYNCOFFMSG = 'click to enable panel synchronization';
var LISTOFALLMEMBERS = 'List of all members';