/* Test diagnostics for various bad initializers.  */
/* Origin: Joseph Myers <joseph@codesourcery.com> */
/* { dg-do compile } */
/* { dg-options "-std=gnu99" } */

void f(void);
void g(void) = f; /* { dg-error "error: function 'g' is initialized like a variable" } */

void h(a)
     int a = 1; /* { dg-error "error: parameter 'a' is initialized" } */
{
  struct s x = { 0 }; /* { dg-error "error: variable 'x' has initializer but incomplete type" } */
  /* { dg-warning "excess elements|near init" "" { target *-*-* } 12 } */
  /* { dg-error "storage size" "" { target *-*-* } 12 } */
}

char s[1] = "x";
char s1[1] = { "x" };
char t[1] = "xy"; /* { dg-warning "warning: initializer-string for array of chars is too long" } */
char t1[1] = { "xy" }; /* { dg-warning "warning: initializer-string for array of chars is too long" } */
char u[1] = { "x", "x" }; /* { dg-error "error: excess elements in char array initializer" } */
/* { dg-error "near init" "" { target *-*-* } 21 } */

int i = { }; /* { dg-error "error: empty scalar initializer" } */
/* { dg-error "near init" "" { target *-*-* } 24 } */

int j = { 1 };

int k = { 1, 2 }; /* { dg-warning "warning: excess elements in scalar initializer" } */
/* { dg-warning "near init" "" { target *-*-* } 29 } */

int a1[1] = { [1] = 0 }; /* { dg-error "error: array index in initializer exceeds array bounds" } */
/* { dg-error "near init" "" { target *-*-* } 32 } */
int a2[1] = { [-1] = 0 }; /* { dg-error "error: array index in initializer exceeds array bounds" } */
/* { dg-error "near init" "" { target *-*-* } 34 } */
int a3[1] = { [0 ... 1] = 0 }; /* { dg-error "error: array index range in initializer exceeds array bounds" } */
/* { dg-error "near init" "" { target *-*-* } 36 } */
int a4[2] = { [1 ... 0] = 0 }; /* { dg-error "error: empty index range in initializer" } */
/* { dg-error "near init" "" { target *-*-* } 38 } */
int a5[2] = { [0 ... 2] = 0 }; /* { dg-error "error: array index range in initializer exceeds array bounds" } */
/* { dg-error "near init" "" { target *-*-* } 40 } */
int a6[2] = { [-1 ... 1] = 0 }; /* { dg-error "error: array index in initializer exceeds array bounds" } */
/* { dg-error "near init" "" { target *-*-* } 42 } */
int a7[] = { [-1 ... 1] = 0 }; /* { dg-error "error: array index in initializer exceeds array bounds" } */
/* { dg-error "near init" "" { target *-*-* } 44 } */
