import highendivisystem 1.0
import QtQuick.Studio.Components 1.0
import QtQuick.Controls 2.15
import QtQuick.Layouts 1.11
import QtGraphicalEffects 1.0
import QtQuick3D.Effects 1.15
import QtQuick.Studio.Effects 1.0
import QtQuick.Timeline 1.0
import FlowView 1.0
import QtMultimedia 5.15
import QtQuick3D 1.15
import QtQuick 2.15
import QtQuick.VirtualKeyboard 2.1
import QtLocation 5.6
import QtPositioning 5.6


Model {
    id: doorbackleft
    source: "asset_imports/Quick3DAssets/BakedCar2/meshes/door_rear_left.mesh"
    property bool isOpen: true
    eulerRotation.x: -90
    DefaultMaterial {
        id: defaultMaterial3
        opacity: 0
        diffuseColor: "#040404"
    }
    
    DefaultMaterial {
        id: cubeMaterial3
        emissiveFactor: 0
        emissiveColor: "#ffffff"
        specularTint: "#000000"
        specularAmount: 0.4
        diffuseMap: element6
        diffuseColor: "#7b8f91"
        Texture {
            id: element6
            source: "doorRL.png"
        }


    }

    Model {
        id: cube
        source: "asset_imports/Quick3DAssets/CarWindows/meshes/door_rear_left_window.mesh"
        materials: cubeMaterial
        DefaultMaterial {
            id: cubeMaterial
            specularAmount: 0
            diffuseMap: texture1
            diffuseColor: "#ffffff"

            Texture {
                id: texture1
                source: "img/rlwindow.png"
                positionV: rlwindowslider.value
                positionU: 0
            }
        }
    }
    states: [
        State {
            name: "closed"
            when: !doorbackleft.isOpen
        },
        State {
            name: "open"
            when: doorbackleft.isOpen

            PropertyChanges {
                target: doorbackleft
                eulerRotation.y: -35
            }
        }
    ]
    transitions: Transition {
        NumberAnimation
        {
            properties: "eulerRotation.y"
            easing.type: Easing.InOutQuad
            duration: 500
        }

    }
    z: 922.0249
    materials: [cubeMaterial3, defaultMaterial3]
}


