/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Studio.Components 1.0
import QtQuick.Studio.Effects 1.0

Item {
    id: navigationSport
    width: 700
    height: 156
    property alias _91kmText: _91km.text
    property alias _47minText: _47min.text
    property alias _0859Text: _0859.text
    property bool night: false
    property bool show: true
    property color color1: night ? "black" : "white"
    property color color2: night ? "white" : "black"

    Item {
        id: info
        x: 140
        y: 113
        width: 420
        height: 43
        visible: show
        Item {
            id: base
            x: 0
            y: 0
            width: 420
            height: 43
            Image {
                id: base1
                x: 0
                y: 0
                source: "../images/assets/Base1.png"
                layer.enabled: true
                layer.effect: ColorOverlayEffect {
                    id: colorOverlay
                    color: color1
                }
            }
        }

        Rectangle {
            id: time
            x: 61
            y: 10
            width: 91
            height: 28
            color: "transparent"
            layer.enabled: true
            layer.effect: ColorOverlayEffect {
                id: colorOverlay1
                color: color2
            }
            Rectangle {
                id: time_16
                x: 0
                y: 6
                width: 16
                height: 16
                color: "transparent"
                SvgPathItem {
                    id: vector
                    x: 0
                    y: 0
                    width: 16
                    height: 16
                    fillColor: "transparent"
                    strokeColor: "transparent"
                    strokeWidth: 1
                    path: "M 0 0 L 16 0 L 16 16 L 0 16 L 0 0 Z"
                }

                SvgPathItem {
                    id: vector1
                    x: 1
                    y: 1
                    width: 13
                    height: 13
                    fillColor: "#ffffff"
                    strokeColor: "transparent"
                    strokeWidth: 1
                    path: "M 6.660000164985649 0 C 2.9800000022252333 0 0 2.986666394551594 0 6.666666030883789 C 0 10.346665667215984 2.9800000022252333 13.333332061767578 6.660000164985649 13.333332061767578 C 10.34666714731852 13.333332061767578 13.333333969116211 10.346665667215984 13.333333969116211 6.666666030883789 C 13.333333969116211 2.986666394551594 10.34666714731852 0 6.660000164985649 0 Z M 6.6666669845581055 11.99999885559082 C 3.7200001265207905 11.99999885559082 1.333333396911621 9.613332467397049 1.333333396911621 6.666666030883789 C 1.333333396911621 3.719999594370529 3.7200001265207905 1.3333332061767578 6.6666669845581055 1.3333332061767578 C 9.61333384259542 1.3333332061767578 12.00000057220459 3.719999594370529 12.00000057220459 6.666666030883789 C 12.00000057220459 9.613332467397049 9.61333384259542 11.99999885559082 6.6666669845581055 11.99999885559082 Z M 7.00000033378601 3.3333330154418945 L 6.000000286102295 3.3333330154418945 L 6.000000286102295 7.333332633972168 L 9.5000004529953 9.433332179387435 L 10.000000476837158 8.61333256276448 L 7.00000033378601 6.833332681655883 L 7.00000033378601 3.3333330154418945 Z"
                }
                clip: true
            }

            Text {
                id: _47min
                x: 24
                y: -1
                width: 68
                height: 28
                color: "#ffffff"
                text: "47min"
                font.pixelSize: 20
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                font.family: "Exo 2"
                font.weight: Font.Bold
            }
        }

        Rectangle {
            id: distance
            x: 289
            y: 13
            width: 70
            height: 22
            color: "transparent"
            layer.enabled: true
            layer.effect: ColorOverlayEffect {
                id: colorOverlay2
                color: color2
            }
            Rectangle {
                id: map_16
                x: 0
                y: 3
                width: 16
                height: 16
                color: "transparent"
                SvgPathItem {
                    id: vector2
                    x: 0
                    y: 0
                    width: 16
                    height: 16
                    fillColor: "transparent"
                    strokeColor: "transparent"
                    strokeWidth: 1
                    path: "M 0 0 L 16 0 L 16 16 L 0 16 L 0 0 Z"
                }

                SvgPathItem {
                    id: vector3
                    x: 2
                    y: 2
                    width: 12
                    height: 12
                    fillColor: "#ffffff"
                    strokeColor: "transparent"
                    strokeWidth: 1
                    path: "M 8 1.5533330415968578 L 4 0.1533333222717416 L 0 1.4999997673964938 L 0 12.299997329711914 L 4 10.746664288115056 L 8 12.146664325331562 L 12 10.79999756231542 L 12 0 L 8 1.5533330415968578 Z M 8 10.746664288115056 L 4 9.339998704243367 L 4 1.5599998598175981 L 8 2.966666079472065 L 8 10.746664288115056 Z"
                }
                clip: true
            }

            Text {
                id: _91km
                x: 24
                y: 0
                width: 47
                height: 22
                color: "#ffffff"
                text: "91km"
                font.pixelSize: 16
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                font.family: "Open Sans"
                font.weight: Font.Normal
            }
        }

        Rectangle {
            id: eTA
            x: 188
            y: 13
            width: 65
            height: 22
            color: "transparent"
            layer.enabled: true
            layer.effect: ColorOverlayEffect {
                id: colorOverlay3
                color: color2
            }
            Rectangle {
                id: flagcheckered_16
                x: 0
                y: 3
                width: 16
                height: 16
                color: "transparent"
                Item {
                    id: group
                    x: 0
                    y: 0
                    width: 16
                    height: 16
                    SvgPathItem {
                        id: vector4
                        x: 0
                        y: 0
                        width: 16
                        height: 16
                        fillColor: "transparent"
                        strokeColor: "transparent"
                        strokeWidth: 1
                        path: "M 0 0 L 16 0 L 16 16 L 0 16 L 0 0 Z"
                    }
                }

                Item {
                    id: group1
                    x: 3
                    y: 3
                    width: 9
                    height: 11
                    Item {
                        id: group2
                        x: 0
                        y: 0
                        width: 9
                        height: 11
                        SvgPathItem {
                            id: vector5
                            x: 0
                            y: 0
                            width: 9
                            height: 11
                            fillColor: "#ffffff"
                            strokeColor: "transparent"
                            strokeWidth: 1
                            path: "M 4.000000272478376 1.3333330154418945 L 2.6666668483189175 1.3333330154418945 L 2.6666668483189175 0 L 4.000000272478376 0 L 4.000000272478376 1.3333330154418945 Z M 6.666667120797294 0 L 5.333333696637835 0 L 5.333333696637835 1.3333330154418945 L 6.666667120797294 1.3333330154418945 L 6.666667120797294 0 Z M 2.6666668483189175 6.666665077209473 L 4.000000272478376 6.666665077209473 L 4.000000272478376 5.333332061767578 L 2.6666668483189175 5.333332061767578 L 2.6666668483189175 6.666665077209473 Z M 9.333333969116211 3.9999990463256836 L 9.333333969116211 2.666666030883789 L 8.000000544956752 2.666666030883789 L 8.000000544956752 3.9999990463256836 L 9.333333969116211 3.9999990463256836 Z M 9.333333969116211 6.666665077209473 L 9.333333969116211 5.333332061767578 L 8.000000544956752 5.333332061767578 L 8.000000544956752 6.666665077209473 L 9.333333969116211 6.666665077209473 Z M 5.333333696637835 6.666665077209473 L 6.666667120797294 6.666665077209473 L 6.666667120797294 5.333332061767578 L 5.333333696637835 5.333332061767578 L 5.333333696637835 6.666665077209473 Z M 9.333333969116211 0 L 8.000000544956752 0 L 8.000000544956752 1.3333330154418945 L 9.333333969116211 1.3333330154418945 L 9.333333969116211 0 Z M 5.333333696637835 2.666666030883789 L 5.333333696637835 1.3333330154418945 L 4.000000272478376 1.3333330154418945 L 4.000000272478376 2.666666030883789 L 5.333333696637835 2.666666030883789 Z M 1.3333334241594588 3.9999990463256836 L 1.3333334241594588 2.666666030883789 L 2.6666668483189175 2.666666030883789 L 2.6666668483189175 1.3333330154418945 L 1.3333334241594588 1.3333330154418945 L 1.3333334241594588 0 L 0 0 L 0 10.666664123535156 L 1.3333334241594588 10.666664123535156 L 1.3333334241594588 5.333332061767578 L 2.6666668483189175 5.333332061767578 L 2.6666668483189175 3.9999990463256836 L 1.3333334241594588 3.9999990463256836 Z M 6.666667120797294 5.333332061767578 L 8.000000544956752 5.333332061767578 L 8.000000544956752 3.9999990463256836 L 6.666667120797294 3.9999990463256836 L 6.666667120797294 5.333332061767578 Z M 4.000000272478376 3.9999990463256836 L 4.000000272478376 5.333332061767578 L 5.333333696637835 5.333332061767578 L 5.333333696637835 3.9999990463256836 L 4.000000272478376 3.9999990463256836 Z M 2.6666668483189175 2.666666030883789 L 2.6666668483189175 3.9999990463256836 L 4.000000272478376 3.9999990463256836 L 4.000000272478376 2.666666030883789 L 2.6666668483189175 2.666666030883789 Z M 5.333333696637835 3.9999990463256836 L 6.666667120797294 3.9999990463256836 L 6.666667120797294 2.666666030883789 L 5.333333696637835 2.666666030883789 L 5.333333696637835 3.9999990463256836 Z M 6.666667120797294 1.3333330154418945 L 6.666667120797294 2.666666030883789 L 8.000000544956752 2.666666030883789 L 8.000000544956752 1.3333330154418945 L 6.666667120797294 1.3333330154418945 Z"
                        }
                    }
                }
                clip: true
            }

            Text {
                id: _0859
                x: 24
                y: 0
                width: 42
                height: 22
                color: "#ffffff"
                text: "08:59"
                font.pixelSize: 16
                horizontalAlignment: Text.AlignLeft
                verticalAlignment: Text.AlignVCenter
                font.family: "Open Sans"
                font.weight: Font.Normal
            }
        }
    }

    Item {
        id: directions
        x: 64
        y: 0
        width: 573
        height: 119
        visible: show

        Image {
            id: directions1
            x: 0
            y: 0
            width: 573
            height: 114
            source: "../images/assets/Directions2.png"
        }
    }
    states: [
        State {
            name: "day"
            when: !globalNightMode

            PropertyChanges {
                target: directions1
                source: "../images/assets/Directions2_dark.png"
            }
        },
        State {
            name: "night"
            when: globalNightMode

            PropertyChanges {
                target: directions1
                source: "../images/assets/Directions2.png"
            }
        }
    ]
}

/*##^##
Designer {
    D{i:0;height:156;width:700}
}
##^##*/

