/****************************************************************************
**
** Copyright (C) 2022 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Outrun demo.
**
** $QT_BEGIN_LICENSE:GPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 or (at your option) any later version
** approved by the KDE Free Qt Foundation. The licenses are as published by
** the Free Software Foundation and appearing in the file LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

import QtQuick
import QtQuick.Studio.Effects 1.0

Rectangle {
    id: chargingmenu4
    width: 1920
    height: 720
    color: "#00ffffff"
    property alias _87Text: _87.text
    property alias _102Text: _102.text
    property alias kmText: km.text
    property alias kWText: kW.text
    property alias power1Text: power1.text
    property alias time1Text: time1.text
    property alias _24Text: _24.text
    property alias range1Text: range1.text
    property alias minText: min.text
    property real charge: 0
    clip: true

    Item {
        id: time
        x: 1539
        y: 166
        width: 77
        height: 84
        visible: true
        Text {
            id: time1
            x: 0
            y: 0
            width: 61
            height: 35
            visible: true
            color: globalNightMode?  "#ffffff": "#000000"
            text: "Time"
            font.pixelSize: 26
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }

        Text {
            id: _87
            x: 0
            y: 43
            width: 36
            height: 41
            visible: true
            color: globalNightMode?  "#ffffff": "#000000"
            text: "87"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            fontSizeMode: Text.HorizontalFit
            font.family: "Open Sans"
            font.weight: Font.Bold
        }

        Text {
            id: min
            x: 41
            y: 54
            width: 37
            height: 27
            visible: true
            color: globalNightMode?  "#ffffff": "#000000"
            text: "min"
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }
    }

    Item {
        id: range
        x: 1539
        y: 286
        width: 90
        height: 84
        visible: true
        Text {
            id: range1
            x: 0
            y: 0
            width: 77
            height: 35
            color: globalNightMode?  "#ffffff": "#000000"
            text: "Range"
            font.pixelSize: 26
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }

        Text {
            id: _102
            x: 0
            y: 43
            width: 53
            height: 41
            color: globalNightMode?  "#ffffff": "#000000"
            text: "102"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            fontSizeMode: Text.HorizontalFit
            font.family: "Open Sans"
            font.weight: Font.Bold
        }

        Text {
            id: km
            x: 60
            y: 54
            width: 31
            height: 27
            color: globalNightMode?  "#ffffff": "#000000"
            text: "km"
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }
    }

    Item {
        id: power
        x: 1539
        y: 406
        width: 77
        height: 84
        visible: true
        Text {
            id: power1
            x: 0
            y: 0
            width: 78
            height: 35
            color: globalNightMode?  "#ffffff": "#000000"
            text: "Power"
            font.pixelSize: 26
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }

        Text {
            id: _24
            x: 0
            y: 43
            width: 36
            height: 41
            color: globalNightMode?  "#ffffff": "#000000"
            text: "24"
            font.pixelSize: 30
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            fontSizeMode: Text.HorizontalFit
            font.family: "Open Sans"
            font.weight: Font.Bold
        }

        Text {
            id: kW
            x: 43
            y: 54
            width: 31
            height: 27
            color: globalNightMode?  "#ffffff": "#000000"
            text: "kW"
            font.pixelSize: 20
            horizontalAlignment: Text.AlignLeft
            verticalAlignment: Text.AlignTop
            font.family: "Open Sans"
            font.weight: Font.Normal
        }
    }

    Item {
        id: battery
        x: 193
        y: 233
        width: 447
        height: 329
        visible: true
        Item {
            id: effects
            x: -27
            y: 139
            width: 474
            height: 167

            Item {
                id: shadow1
                x: 23
                y: 0
                width: 338
                height: 8
                Image {
                    id: shadow11
                    x: -10
                    y: -10
                    width: 455
                    height: 18
                    source: "../images/assets/Shadow11.png"
                }
            }
        }

        Item {
            id: _37
            x: 0
            y: -77
            width: 447
            height: 276

            Text {
                id: text1
                y: 30
                height: 246
                color: globalNightMode?  "#ffffff": "#000000"
                text: charge.toString()
                anchors.left: parent.left
                anchors.right: parent.right
                anchors.bottom: parent.bottom
                font.pixelSize: 160
                horizontalAlignment: Text.AlignRight
                font.styleName: "ExtraBold"
                font.family: "Exo 2"
                anchors.rightMargin: 99
                anchors.leftMargin: 0
                anchors.bottomMargin: 0
            }

            Text {
                id: text2
                y: 78
                height: 132
                color: globalNightMode?  "#ffffff": "#000000"
                text: "%"

                anchors.left: parent.left
                anchors.right: parent.right
                anchors.bottom: parent.bottom
                font.pixelSize: 104
                horizontalAlignment: Text.AlignRight
                anchors.rightMargin: 8
                anchors.leftMargin: 0
                anchors.bottomMargin: 66
                font.styleName: "ExtraBold"
                font.family: "Exo 2"
            }

            Rectangle {
                id: bolt_48
                x: 19
                y: 114
                width: 48
                height: 48
                color: "transparent"
                Item {
                    id: group
                    x: 0
                    y: 0
                    width: 48
                    height: 48
                    Item {
                        id: vector
                        x: 0
                        y: 0
                        width: 48
                        height: 48
                        Image {
                            id: vector1
                            x: 0
                            y: 0
                            source: "../images/assets/Vector1.png"
                        }
                    }
                }

                Item {
                    id: group1
                    x: 14
                    y: 6
                    width: 20
                    height: 36
                    Item {
                        id: vector2
                        x: 0
                        y: 0
                        width: 20
                        height: 36
                        Image {
                            id: vector11
                            x: 0
                            y: 0
                            source: globalNightMode? "../images/assets/Vector1_1.png" : "../images/assets/Vector1_1_black.png"
                        }
                    }
                }
                clip: true
            }

        }
        ShaderEffectSource {
            id: digitalSpeedSource
            sourceItem: _37
            textureSize: Qt.size(_37.width / 2, _37.height / 2)
            visible: false
            // No mirroring means texture is vertically flipped
            textureMirroring: ShaderEffectSource.NoMirroring
        }
        FastBlurEffect {
            id: blurEffect
            anchors.top: _37.bottom
            anchors.topMargin: -125
            width: _37.width
            height: _37.height
            source: digitalSpeedSource
            radius: 32
            opacity: 0.265
            z: -1
        }
    }
}

/*##^##
Designer {
    D{i:0;formeditorZoom:0.66;height:720;width:1920}D{i:2;uuid:"f6ef0ea0-0ce6-5d8e-ac8e-acf4ebc63355"}
D{i:3;uuid:"f2c71d24-7e98-5bfa-8f06-35a827c8e1b1"}D{i:4;uuid:"aa580b41-0e24-5de8-b210-8643b846d024"}
D{i:1;uuid:"441b1207-500d-5697-bd9a-8a81d2843bd7"}D{i:6;uuid:"12a63a46-6112-584b-87cc-fdbce4bb6996"}
D{i:7;uuid:"0285119b-21dd-5da6-b29a-156af3cd9c22"}D{i:8;uuid:"48ded8b7-b70c-5519-bf62-77d374eff3e8"}
D{i:5;uuid:"0b506cb8-cb43-5438-beb4-1cd42866f92a"}D{i:10;uuid:"ec50639f-a827-5eb1-a0a8-be2afcc76596"}
D{i:11;uuid:"c94df0a7-2f96-5e55-b01a-50137d73ca30"}D{i:12;uuid:"cf185851-c64c-576c-9091-e8b6b736f4a9"}
D{i:9;uuid:"c6127cc0-8be3-5cea-8a33-a60f8c443272"}D{i:16;uuid:"e41bda11-4bd0-50ff-a925-b31c26969fa4-1"}
D{i:15;uuid:"e41bda11-4bd0-50ff-a925-b31c26969fa4"}D{i:14;uuid:"40cea2ca-823e-51c2-9d38-8e2901455061"}
D{i:19}D{i:23;uuid:"adc77644-f23a-5d0a-ac10-551ed18cc7ec-1"}D{i:22;uuid:"adc77644-f23a-5d0a-ac10-551ed18cc7ec"}
D{i:21;uuid:"713dcd1b-8ce0-5d20-a0e3-9fe56f750d11"}D{i:26;uuid:"0a472c06-fbe2-55af-9af3-d640f1ee1751-1"}
D{i:25;uuid:"0a472c06-fbe2-55af-9af3-d640f1ee1751"}D{i:24;uuid:"79173e63-af14-59da-80b0-58ab17d1e94c"}
D{i:20;uuid:"da7db832-f1b2-5aff-b613-0dfb1afc3182"}D{i:17;uuid:"f6c2c65e-6575-59e0-ae86-606eecf05cad"}
D{i:13;uuid:"7b05cc15-e6ca-52c1-ad01-3056d3b9c1f7"}
}
##^##*/

