import QtQuick
import QtQuick3D
Node {
    id: rootNode
    Node {
        id: wheel_new
        x: 0
        y: 0
        z: 0
        Model {
            id: newTire_Rim_low
            x: -2.71566
            y: 0.0490364
            z: 0.0161346
            rotation: Qt.quaternion(-1.37679e-07, -0.707107, -1.37679e-07, 0.707107)
            scale.x: 100
            scale.y: 100
            scale.z: 100
            source: "meshes/newTire_Rim_low.mesh"
            materials: principledMaterial

            PrincipledMaterial {
                id: principledMaterial
                specularMap: automotive4
                roughness: 0.3
                metalness: 0
                specularTint: 0
                specularAmount: 1
                lightProbe: car_day_hdr
                normalStrength: 0
                minHeightMapSamples: 0
                maxHeightMapSamples: 0
                normalMap: finilizedTire_Normal
                baseColorMap: finilizedTire_Color
                baseColor: "#e6e6e6"

                Texture {
                    id: finilizedTire_Color
                    source: "../../../images/wheelNew/FinilizedTire_Color.png"
                    generateMipmaps: true
                }



                Texture {
                    id: finilizedTire_Normal
                    source: "../../../images/wheelNew/FinilizedTire_Normal.png"
                    generateMipmaps: true

                }

                Texture {
                    id: car_day_hdr
                    source: "../../../images/hdri/car_day_hdr.hdr"
                    generateMipmaps: true
                    mappingMode: Texture.LightProbe
                }

                Texture {
                    id: automotive4
                    source: "../../../images/piece-nb-41.hdr"
                    magFilter: Texture.Nearest
                    minFilter: Texture.Nearest
                    generateMipmaps: true
                    mappingMode: Texture.LightProbe
                }
            }
        }
        Model {
            id: newTire_Bolts_low
            x: -2.65905
            y: 0.0490364
            z: 0.0161346
            rotation: Qt.quaternion(0.672548, 0.218356, -0.672548, -0.218356)
            scale.x: 100
            scale.y: 100
            scale.z: 100
            source: "meshes/newTire_Bolts_low.mesh"
            materials: principledMaterial1

            PrincipledMaterial {
                id: principledMaterial1
                specularReflectionMap: car_day_hdr
                roughness: 0.3
                metalness: 0.2
                lightProbe: car_day_hdr
                baseColor: "#404040"
            }
        }
        Model {
            id: newTire_Brake_low
            x: 10.7507
            y: -0.196146
            z: -0.0645386
            rotation: Qt.quaternion(-1.06605e-07, -1.68691e-07, 0.707799, 0.706413)
            scale.x: 100
            scale.y: 100
            scale.z: 100
            source: "meshes/newTire_Brake_low.mesh"
            materials: principledMaterial
        }
        Model {
            id: newTire_Rubber_low
            x: -2.71566
            y: 0.0490364
            z: 0.0161346
            rotation: Qt.quaternion(0.707107, -0.707107, 0, 0)
            scale.x: 100
            scale.y: 100
            scale.z: 100
            source: "meshes/newTire_Rubber_low.mesh"
            materials: rubber_tire

            PrincipledMaterial {
                id: rubber_tire
                specularAmount: 0.6
                lightProbe: car_day_hdr
                roughness: 0.5
                metalness: 0.3
                normalMap: finilizedTire_Normal
                baseColor: "#121212"
            }
        }
        Model {
            id: newTire_Qt_low
            x: -11.437
            y: 0.049
            z: 0.01613
            rotation: Qt.quaternion(0.707107, 1.54543e-08, -0.707107, 1.54543e-08)
            scale.x: 261.05624
            scale.y: 261.05624
            scale.z: 261.05624
            source: "meshes/newTire_Qt_low.mesh"
            materials: principledMaterial
        }
    }
    states: [
        State {
            name: "day"
            when: !globalNightMode

            PropertyChanges {
                target: principledMaterial
                specularAmount: 1
                baseColor: "#ffffff"
            }

            PropertyChanges {
                target: finilizedTire_Color
                generateMipmaps: true
            }

            PropertyChanges {
                target: finilizedTire_Normal
                generateMipmaps: true
            }

            PropertyChanges {
                target: car_day_hdr
                generateMipmaps: true
            }

            PropertyChanges {
                target: rubber_tire
                baseColor: "#1d1d1d"
            }
        },
        State {
            name: "night"
            when: globalNightMode

            PropertyChanges {
                target: principledMaterial
                roughness: 0.1
                metalness: 0.2
                specularAmount: 1
                baseColor: "#7b7197"
            }

            PropertyChanges {
                target: rubber_tire
                baseColor: "#040404"
            }

            PropertyChanges {
                target: principledMaterial1
                metalness: 0.7
                baseColor: "#24212f"
            }

            PropertyChanges {
                target: automotive4
                source: "../../../images/piece-nb-41.hdr"
                positionV: 0.2
            }
        }
    ]
    transitions: [
        Transition {
            id: transition
            ParallelAnimation {
                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: rubber_tire
                        property: "baseColor"
                        duration: 2000
                    }
                }
            }

            ParallelAnimation {
                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: principledMaterial
                        property: "metalness"
                        duration: 2000
                    }
                }

                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: principledMaterial
                        property: "baseColor"
                        duration: 2000
                    }
                }

                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: principledMaterial
                        property: "roughness"
                        duration: 2000
                    }
                }

                SequentialAnimation {
                    PauseAnimation {
                        duration: 50
                    }

                    PropertyAnimation {
                        target: principledMaterial
                        property: "specularAmount"
                        duration: 2000
                    }
                }
            }
            to: "*"
            from: "*"
        }
    ]
}
