import QtQuick
import QtQuick.Controls
import QtQuick.Shapes
import QtQuick.Timeline
import QtQuick.Studio.Components
import QtQuick.Studio.DesignEffects
import DesignEffectsDemo

Item {
    id: root
    width: 1920
    height: 1080

    Rectangle {
        id: bCK
        anchors.fill: parent
        gradient: Gradient {
            GradientStop {
                position: 0
                color: "#f0dab8"
            }

            GradientStop {
                position: 1
                color: "#c872de"
            }
            orientation: Gradient.Vertical
        }

        EllipseItem {
            id: ellipse
            x: 1070
            y: 180
            width: 150
            height: 150
            gradient: LinearGradient {
                y2: ellipse.height * 1
                y1: ellipse.height * 0
                x2: ellipse.width * 1
                x1: ellipse.width * 0
                GradientStop {
                    position: 0
                    color: "#868ee1"
                }

                GradientStop {
                    position: 1
                    color: "#ce5c3d"
                }
            }
            strokeColor: "#00ff0000"
        }

        EllipseItem {
            id: ellipse1
            x: 777
            y: 389
            width: 150
            height: 150
            strokeColor: "#00ff0000"
            gradient: LinearGradient {
                y2: ellipse1.height * 1
                y1: ellipse1.height * 0
                x2: ellipse1.width * 1
                x1: ellipse1.width * 0
                GradientStop {
                    position: 0
                    color: "#868ee1"
                }

                GradientStop {
                    position: 1
                    color: "#ce5c3d"
                }
            }
        }
    }
    RectangleItem {
        id: rectangle
        x: 839
        y: 255
        width: 324
        height: 208
        fillColor: "#5bD9D9D9"
        strokeColor: "#00ff0000"
        adjustBorderRadius: true

        DesignEffect {
            id: de1
            layerBlurRadius: 0
            backgroundBlurRadius: 60
            backgroundLayer: bCK

            effects: [
                DesignInnerShadow {
                    id: is1
                    color: "#efffffff"
                    blur: 4
                    spread: 0
                    offsetY: 1
                    offsetX: -1
                }
            ]
        }
    }
}
