// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================

/* Copyright (C) 2010 Denali Software Inc.  All rights reserved              */
/* THIS FILE IS AUTOMATICALLY GENERATED BY DENALI BLUEPRINT, DO NOT EDIT     */


#ifndef _BT_COEX_REG_REG_H_
#define _BT_COEX_REG_REG_H_


/* macros for BTCOEXCTRL */
#define BTCOEXCTRL_ADDRESS                                                                0x00000000
#define BTCOEXCTRL_OFFSET                                                                 0x00000000
#define BTCOEXCTRL_GAP_MSB                                                                         7
#define BTCOEXCTRL_GAP_LSB                                                                         0
#define BTCOEXCTRL_GAP_MASK                                                               0x000000ff
#define BTCOEXCTRL_GAP_GET(x)                                              (((x) & 0x000000ff) >> 0)
#define BTCOEXCTRL_GAP_SET(x)                                              (((x) << 0) & 0x000000ff)
#define BTCOEXCTRL_CLK_CNT_EN_MSB                                                                  8
#define BTCOEXCTRL_CLK_CNT_EN_LSB                                                                  8
#define BTCOEXCTRL_CLK_CNT_EN_MASK                                                        0x00000100
#define BTCOEXCTRL_CLK_CNT_EN_GET(x)                                       (((x) & 0x00000100) >> 8)
#define BTCOEXCTRL_CLK_CNT_EN_SET(x)                                       (((x) << 8) & 0x00000100)
#define BTCOEXCTRL_FRAME_CNT_EN_MSB                                                                9
#define BTCOEXCTRL_FRAME_CNT_EN_LSB                                                                9
#define BTCOEXCTRL_FRAME_CNT_EN_MASK                                                      0x00000200
#define BTCOEXCTRL_FRAME_CNT_EN_GET(x)                                     (((x) & 0x00000200) >> 9)
#define BTCOEXCTRL_FRAME_CNT_EN_SET(x)                                     (((x) << 9) & 0x00000200)
#define BTCOEXCTRL_IDLE_CNT_EN_MSB                                                                10
#define BTCOEXCTRL_IDLE_CNT_EN_LSB                                                                10
#define BTCOEXCTRL_IDLE_CNT_EN_MASK                                                       0x00000400
#define BTCOEXCTRL_IDLE_CNT_EN_GET(x)                                     (((x) & 0x00000400) >> 10)
#define BTCOEXCTRL_IDLE_CNT_EN_SET(x)                                     (((x) << 10) & 0x00000400)
#define BTCOEXCTRL_SYNC_DET_EN_MSB                                                                11
#define BTCOEXCTRL_SYNC_DET_EN_LSB                                                                11
#define BTCOEXCTRL_SYNC_DET_EN_MASK                                                       0x00000800
#define BTCOEXCTRL_SYNC_DET_EN_GET(x)                                     (((x) & 0x00000800) >> 11)
#define BTCOEXCTRL_SYNC_DET_EN_SET(x)                                     (((x) << 11) & 0x00000800)
#define BTCOEXCTRL_PRIORITY_TIME_MSB                                                              17
#define BTCOEXCTRL_PRIORITY_TIME_LSB                                                              12
#define BTCOEXCTRL_PRIORITY_TIME_MASK                                                     0x0003f000
#define BTCOEXCTRL_PRIORITY_TIME_GET(x)                                   (((x) & 0x0003f000) >> 12)
#define BTCOEXCTRL_PRIORITY_TIME_SET(x)                                   (((x) << 12) & 0x0003f000)
#define BTCOEXCTRL_FREQ_TIME_MSB                                                                  22
#define BTCOEXCTRL_FREQ_TIME_LSB                                                                  18
#define BTCOEXCTRL_FREQ_TIME_MASK                                                         0x007c0000
#define BTCOEXCTRL_FREQ_TIME_GET(x)                                       (((x) & 0x007c0000) >> 18)
#define BTCOEXCTRL_FREQ_TIME_SET(x)                                       (((x) << 18) & 0x007c0000)
#define BTCOEXCTRL_PTA_MODE_MSB                                                                   24
#define BTCOEXCTRL_PTA_MODE_LSB                                                                   23
#define BTCOEXCTRL_PTA_MODE_MASK                                                          0x01800000
#define BTCOEXCTRL_PTA_MODE_GET(x)                                        (((x) & 0x01800000) >> 23)
#define BTCOEXCTRL_PTA_MODE_SET(x)                                        (((x) << 23) & 0x01800000)
#define BTCOEXCTRL_WBSYNC_ON_BEACON_MSB                                                           25
#define BTCOEXCTRL_WBSYNC_ON_BEACON_LSB                                                           25
#define BTCOEXCTRL_WBSYNC_ON_BEACON_MASK                                                  0x02000000
#define BTCOEXCTRL_WBSYNC_ON_BEACON_GET(x)                                (((x) & 0x02000000) >> 25)
#define BTCOEXCTRL_WBSYNC_ON_BEACON_SET(x)                                (((x) << 25) & 0x02000000)
#define BTCOEXCTRL_RFGAIN_VALID_SRC_MSB                                                           28
#define BTCOEXCTRL_RFGAIN_VALID_SRC_LSB                                                           28
#define BTCOEXCTRL_RFGAIN_VALID_SRC_MASK                                                  0x10000000
#define BTCOEXCTRL_RFGAIN_VALID_SRC_GET(x)                                (((x) & 0x10000000) >> 28)
#define BTCOEXCTRL_RFGAIN_VALID_SRC_SET(x)                                (((x) << 28) & 0x10000000)

/* macros for WBSYNC_PRIORITY1 */
#define WBSYNC_PRIORITY1_ADDRESS                                                          0x00000004
#define WBSYNC_PRIORITY1_OFFSET                                                           0x00000004
#define WBSYNC_PRIORITY1_BITMAP_MSB                                                               31
#define WBSYNC_PRIORITY1_BITMAP_LSB                                                                0
#define WBSYNC_PRIORITY1_BITMAP_MASK                                                      0xffffffff
#define WBSYNC_PRIORITY1_BITMAP_GET(x)                                     (((x) & 0xffffffff) >> 0)
#define WBSYNC_PRIORITY1_BITMAP_SET(x)                                     (((x) << 0) & 0xffffffff)

/* macros for WBSYNC_PRIORITY2 */
#define WBSYNC_PRIORITY2_ADDRESS                                                          0x00000008
#define WBSYNC_PRIORITY2_OFFSET                                                           0x00000008
#define WBSYNC_PRIORITY2_BITMAP_MSB                                                               31
#define WBSYNC_PRIORITY2_BITMAP_LSB                                                                0
#define WBSYNC_PRIORITY2_BITMAP_MASK                                                      0xffffffff
#define WBSYNC_PRIORITY2_BITMAP_GET(x)                                     (((x) & 0xffffffff) >> 0)
#define WBSYNC_PRIORITY2_BITMAP_SET(x)                                     (((x) << 0) & 0xffffffff)

/* macros for WBSYNC_PRIORITY3 */
#define WBSYNC_PRIORITY3_ADDRESS                                                          0x0000000c
#define WBSYNC_PRIORITY3_OFFSET                                                           0x0000000c
#define WBSYNC_PRIORITY3_BITMAP_MSB                                                               31
#define WBSYNC_PRIORITY3_BITMAP_LSB                                                                0
#define WBSYNC_PRIORITY3_BITMAP_MASK                                                      0xffffffff
#define WBSYNC_PRIORITY3_BITMAP_GET(x)                                     (((x) & 0xffffffff) >> 0)
#define WBSYNC_PRIORITY3_BITMAP_SET(x)                                     (((x) << 0) & 0xffffffff)

/* macros for BTCOEX0 */
#define BTCOEX0_ADDRESS                                                                   0x00000010
#define BTCOEX0_OFFSET                                                                    0x00000010
#define BTCOEX0_SYNC_DUR_MSB                                                                       7
#define BTCOEX0_SYNC_DUR_LSB                                                                       0
#define BTCOEX0_SYNC_DUR_MASK                                                             0x000000ff
#define BTCOEX0_SYNC_DUR_GET(x)                                            (((x) & 0x000000ff) >> 0)
#define BTCOEX0_SYNC_DUR_SET(x)                                            (((x) << 0) & 0x000000ff)

/* macros for BTCOEX1 */
#define BTCOEX1_ADDRESS                                                                   0x00000014
#define BTCOEX1_OFFSET                                                                    0x00000014
#define BTCOEX1_CLK_THRES_MSB                                                                     20
#define BTCOEX1_CLK_THRES_LSB                                                                      0
#define BTCOEX1_CLK_THRES_MASK                                                            0x001fffff
#define BTCOEX1_CLK_THRES_GET(x)                                           (((x) & 0x001fffff) >> 0)
#define BTCOEX1_CLK_THRES_SET(x)                                           (((x) << 0) & 0x001fffff)

/* macros for BTCOEX2 */
#define BTCOEX2_ADDRESS                                                                   0x00000018
#define BTCOEX2_OFFSET                                                                    0x00000018
#define BTCOEX2_FRAME_THRES_MSB                                                                    7
#define BTCOEX2_FRAME_THRES_LSB                                                                    0
#define BTCOEX2_FRAME_THRES_MASK                                                          0x000000ff
#define BTCOEX2_FRAME_THRES_GET(x)                                         (((x) & 0x000000ff) >> 0)
#define BTCOEX2_FRAME_THRES_SET(x)                                         (((x) << 0) & 0x000000ff)

/* macros for BTCOEX3 */
#define BTCOEX3_ADDRESS                                                                   0x0000001c
#define BTCOEX3_OFFSET                                                                    0x0000001c
#define BTCOEX3_CLK_CNT_MSB                                                                       20
#define BTCOEX3_CLK_CNT_LSB                                                                        0
#define BTCOEX3_CLK_CNT_MASK                                                              0x001fffff
#define BTCOEX3_CLK_CNT_GET(x)                                             (((x) & 0x001fffff) >> 0)
#define BTCOEX3_CLK_CNT_SET(x)                                             (((x) << 0) & 0x001fffff)

/* macros for BTCOEX4 */
#define BTCOEX4_ADDRESS                                                                   0x00000020
#define BTCOEX4_OFFSET                                                                    0x00000020
#define BTCOEX4_FRAME_CNT_MSB                                                                      7
#define BTCOEX4_FRAME_CNT_LSB                                                                      0
#define BTCOEX4_FRAME_CNT_MASK                                                            0x000000ff
#define BTCOEX4_FRAME_CNT_GET(x)                                           (((x) & 0x000000ff) >> 0)
#define BTCOEX4_FRAME_CNT_SET(x)                                           (((x) << 0) & 0x000000ff)

/* macros for BTCOEX5 */
#define BTCOEX5_ADDRESS                                                                   0x00000024
#define BTCOEX5_OFFSET                                                                    0x00000024
#define BTCOEX5_IDLE_CNT_MSB                                                                      15
#define BTCOEX5_IDLE_CNT_LSB                                                                       0
#define BTCOEX5_IDLE_CNT_MASK                                                             0x0000ffff
#define BTCOEX5_IDLE_CNT_GET(x)                                            (((x) & 0x0000ffff) >> 0)
#define BTCOEX5_IDLE_CNT_SET(x)                                            (((x) << 0) & 0x0000ffff)

/* macros for BTCOEX6 */
#define BTCOEX6_ADDRESS                                                                   0x00000028
#define BTCOEX6_OFFSET                                                                    0x00000028
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_MSB                                                         31
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_LSB                                                          0
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_MASK                                                0xffffffff
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_GET(x)                               (((x) & 0xffffffff) >> 0)
#define BTCOEX6_IDLE_RESET_LVL_BITMAP_SET(x)                               (((x) << 0) & 0xffffffff)

/* macros for LOCK */
#define LOCK_ADDRESS                                                                      0x0000002c
#define LOCK_OFFSET                                                                       0x0000002c
#define LOCK_TUNLOCK_MASTER_MSB                                                                    7
#define LOCK_TUNLOCK_MASTER_LSB                                                                    0
#define LOCK_TUNLOCK_MASTER_MASK                                                          0x000000ff
#define LOCK_TUNLOCK_MASTER_GET(x)                                         (((x) & 0x000000ff) >> 0)
#define LOCK_TUNLOCK_MASTER_SET(x)                                         (((x) << 0) & 0x000000ff)
#define LOCK_TLOCK_MASTER_MSB                                                                     15
#define LOCK_TLOCK_MASTER_LSB                                                                      8
#define LOCK_TLOCK_MASTER_MASK                                                            0x0000ff00
#define LOCK_TLOCK_MASTER_GET(x)                                           (((x) & 0x0000ff00) >> 8)
#define LOCK_TLOCK_MASTER_SET(x)                                           (((x) << 8) & 0x0000ff00)
#define LOCK_TUNLOCK_SLAVE_MSB                                                                    23
#define LOCK_TUNLOCK_SLAVE_LSB                                                                    16
#define LOCK_TUNLOCK_SLAVE_MASK                                                           0x00ff0000
#define LOCK_TUNLOCK_SLAVE_GET(x)                                         (((x) & 0x00ff0000) >> 16)
#define LOCK_TUNLOCK_SLAVE_SET(x)                                         (((x) << 16) & 0x00ff0000)
#define LOCK_TLOCK_SLAVE_MSB                                                                      31
#define LOCK_TLOCK_SLAVE_LSB                                                                      24
#define LOCK_TLOCK_SLAVE_MASK                                                             0xff000000
#define LOCK_TLOCK_SLAVE_GET(x)                                           (((x) & 0xff000000) >> 24)
#define LOCK_TLOCK_SLAVE_SET(x)                                           (((x) << 24) & 0xff000000)

/* macros for NOLOCK_PRIORITY */
#define NOLOCK_PRIORITY_ADDRESS                                                           0x00000030
#define NOLOCK_PRIORITY_OFFSET                                                            0x00000030
#define NOLOCK_PRIORITY_BITMAP_MSB                                                                31
#define NOLOCK_PRIORITY_BITMAP_LSB                                                                 0
#define NOLOCK_PRIORITY_BITMAP_MASK                                                       0xffffffff
#define NOLOCK_PRIORITY_BITMAP_GET(x)                                      (((x) & 0xffffffff) >> 0)
#define NOLOCK_PRIORITY_BITMAP_SET(x)                                      (((x) << 0) & 0xffffffff)

/* macros for WBSYNC */
#define WBSYNC_ADDRESS                                                                    0x00000034
#define WBSYNC_OFFSET                                                                     0x00000034
#define WBSYNC_BTCLOCK_MSB                                                                        31
#define WBSYNC_BTCLOCK_LSB                                                                         0
#define WBSYNC_BTCLOCK_MASK                                                               0xffffffff
#define WBSYNC_BTCLOCK_GET(x)                                              (((x) & 0xffffffff) >> 0)

/* macros for WBSYNC1 */
#define WBSYNC1_ADDRESS                                                                   0x00000038
#define WBSYNC1_OFFSET                                                                    0x00000038
#define WBSYNC1_BTCLOCK_MSB                                                                       31
#define WBSYNC1_BTCLOCK_LSB                                                                        0
#define WBSYNC1_BTCLOCK_MASK                                                              0xffffffff
#define WBSYNC1_BTCLOCK_GET(x)                                             (((x) & 0xffffffff) >> 0)

/* macros for WBSYNC2 */
#define WBSYNC2_ADDRESS                                                                   0x0000003c
#define WBSYNC2_OFFSET                                                                    0x0000003c
#define WBSYNC2_BTCLOCK_MSB                                                                       31
#define WBSYNC2_BTCLOCK_LSB                                                                        0
#define WBSYNC2_BTCLOCK_MASK                                                              0xffffffff
#define WBSYNC2_BTCLOCK_GET(x)                                             (((x) & 0xffffffff) >> 0)

/* macros for WBSYNC3 */
#define WBSYNC3_ADDRESS                                                                   0x00000040
#define WBSYNC3_OFFSET                                                                    0x00000040
#define WBSYNC3_BTCLOCK_MSB                                                                       31
#define WBSYNC3_BTCLOCK_LSB                                                                        0
#define WBSYNC3_BTCLOCK_MASK                                                              0xffffffff
#define WBSYNC3_BTCLOCK_GET(x)                                             (((x) & 0xffffffff) >> 0)

/* macros for WB_TIMER_TARGET */
#define WB_TIMER_TARGET_ADDRESS                                                           0x00000044
#define WB_TIMER_TARGET_OFFSET                                                            0x00000044
#define WB_TIMER_TARGET_VALUE_MSB                                                                 31
#define WB_TIMER_TARGET_VALUE_LSB                                                                  0
#define WB_TIMER_TARGET_VALUE_MASK                                                        0xffffffff
#define WB_TIMER_TARGET_VALUE_GET(x)                                       (((x) & 0xffffffff) >> 0)
#define WB_TIMER_TARGET_VALUE_SET(x)                                       (((x) << 0) & 0xffffffff)

/* macros for WB_TIMER_SLOP */
#define WB_TIMER_SLOP_ADDRESS                                                             0x00000048
#define WB_TIMER_SLOP_OFFSET                                                              0x00000048
#define WB_TIMER_SLOP_VALUE_MSB                                                                    9
#define WB_TIMER_SLOP_VALUE_LSB                                                                    0
#define WB_TIMER_SLOP_VALUE_MASK                                                          0x000003ff
#define WB_TIMER_SLOP_VALUE_GET(x)                                         (((x) & 0x000003ff) >> 0)
#define WB_TIMER_SLOP_VALUE_SET(x)                                         (((x) << 0) & 0x000003ff)

/* macros for BTCOEX_INT_EN */
#define BTCOEX_INT_EN_ADDRESS                                                             0x0000004c
#define BTCOEX_INT_EN_OFFSET                                                              0x0000004c
#define BTCOEX_INT_EN_CLK_CNT_MSB                                                                  0
#define BTCOEX_INT_EN_CLK_CNT_LSB                                                                  0
#define BTCOEX_INT_EN_CLK_CNT_MASK                                                        0x00000001
#define BTCOEX_INT_EN_CLK_CNT_GET(x)                                       (((x) & 0x00000001) >> 0)
#define BTCOEX_INT_EN_CLK_CNT_SET(x)                                       (((x) << 0) & 0x00000001)
#define BTCOEX_INT_EN_FRAME_CNT_MSB                                                                1
#define BTCOEX_INT_EN_FRAME_CNT_LSB                                                                1
#define BTCOEX_INT_EN_FRAME_CNT_MASK                                                      0x00000002
#define BTCOEX_INT_EN_FRAME_CNT_GET(x)                                     (((x) & 0x00000002) >> 1)
#define BTCOEX_INT_EN_FRAME_CNT_SET(x)                                     (((x) << 1) & 0x00000002)
#define BTCOEX_INT_EN_END_MSB                                                                      2
#define BTCOEX_INT_EN_END_LSB                                                                      2
#define BTCOEX_INT_EN_END_MASK                                                            0x00000004
#define BTCOEX_INT_EN_END_GET(x)                                           (((x) & 0x00000004) >> 2)
#define BTCOEX_INT_EN_END_SET(x)                                           (((x) << 2) & 0x00000004)
#define BTCOEX_INT_EN_SYNC_MSB                                                                     3
#define BTCOEX_INT_EN_SYNC_LSB                                                                     3
#define BTCOEX_INT_EN_SYNC_MASK                                                           0x00000008
#define BTCOEX_INT_EN_SYNC_GET(x)                                          (((x) & 0x00000008) >> 3)
#define BTCOEX_INT_EN_SYNC_SET(x)                                          (((x) << 3) & 0x00000008)
#define BTCOEX_INT_EN_NOSYNC_MSB                                                                   4
#define BTCOEX_INT_EN_NOSYNC_LSB                                                                   4
#define BTCOEX_INT_EN_NOSYNC_MASK                                                         0x00000010
#define BTCOEX_INT_EN_NOSYNC_GET(x)                                        (((x) & 0x00000010) >> 4)
#define BTCOEX_INT_EN_NOSYNC_SET(x)                                        (((x) << 4) & 0x00000010)
#define BTCOEX_INT_EN_WB_TIMER_MSB                                                                 7
#define BTCOEX_INT_EN_WB_TIMER_LSB                                                                 7
#define BTCOEX_INT_EN_WB_TIMER_MASK                                                       0x00000080
#define BTCOEX_INT_EN_WB_TIMER_GET(x)                                      (((x) & 0x00000080) >> 7)
#define BTCOEX_INT_EN_WB_TIMER_SET(x)                                      (((x) << 7) & 0x00000080)
#define BTCOEX_INT_EN_ST_MESG_RECV_MSB                                                             8
#define BTCOEX_INT_EN_ST_MESG_RECV_LSB                                                             8
#define BTCOEX_INT_EN_ST_MESG_RECV_MASK                                                   0x00000100
#define BTCOEX_INT_EN_ST_MESG_RECV_GET(x)                                  (((x) & 0x00000100) >> 8)
#define BTCOEX_INT_EN_ST_MESG_RECV_SET(x)                                  (((x) << 8) & 0x00000100)
#define BTCOEX_INT_EN_I2C_MESG_SENT_MSB                                                            9
#define BTCOEX_INT_EN_I2C_MESG_SENT_LSB                                                            9
#define BTCOEX_INT_EN_I2C_MESG_SENT_MASK                                                  0x00000200
#define BTCOEX_INT_EN_I2C_MESG_SENT_GET(x)                                 (((x) & 0x00000200) >> 9)
#define BTCOEX_INT_EN_I2C_MESG_SENT_SET(x)                                 (((x) << 9) & 0x00000200)
#define BTCOEX_INT_EN_I2C_TX_FAILED_MSB                                                           10
#define BTCOEX_INT_EN_I2C_TX_FAILED_LSB                                                           10
#define BTCOEX_INT_EN_I2C_TX_FAILED_MASK                                                  0x00000400
#define BTCOEX_INT_EN_I2C_TX_FAILED_GET(x)                                (((x) & 0x00000400) >> 10)
#define BTCOEX_INT_EN_I2C_TX_FAILED_SET(x)                                (((x) << 10) & 0x00000400)
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_MSB                                                       11
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_LSB                                                       11
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_MASK                                              0x00000800
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_GET(x)                            (((x) & 0x00000800) >> 11)
#define BTCOEX_INT_EN_I2C_RECV_OVERFLOW_SET(x)                            (((x) << 11) & 0x00000800)

/* macros for BTCOEX_INT_STAT */
#define BTCOEX_INT_STAT_ADDRESS                                                           0x00000050
#define BTCOEX_INT_STAT_OFFSET                                                            0x00000050
#define BTCOEX_INT_STAT_CLK_CNT_MSB                                                                0
#define BTCOEX_INT_STAT_CLK_CNT_LSB                                                                0
#define BTCOEX_INT_STAT_CLK_CNT_MASK                                                      0x00000001
#define BTCOEX_INT_STAT_CLK_CNT_GET(x)                                     (((x) & 0x00000001) >> 0)
#define BTCOEX_INT_STAT_CLK_CNT_SET(x)                                     (((x) << 0) & 0x00000001)
#define BTCOEX_INT_STAT_FRAME_CNT_MSB                                                              1
#define BTCOEX_INT_STAT_FRAME_CNT_LSB                                                              1
#define BTCOEX_INT_STAT_FRAME_CNT_MASK                                                    0x00000002
#define BTCOEX_INT_STAT_FRAME_CNT_GET(x)                                   (((x) & 0x00000002) >> 1)
#define BTCOEX_INT_STAT_FRAME_CNT_SET(x)                                   (((x) << 1) & 0x00000002)
#define BTCOEX_INT_STAT_END_MSB                                                                    2
#define BTCOEX_INT_STAT_END_LSB                                                                    2
#define BTCOEX_INT_STAT_END_MASK                                                          0x00000004
#define BTCOEX_INT_STAT_END_GET(x)                                         (((x) & 0x00000004) >> 2)
#define BTCOEX_INT_STAT_END_SET(x)                                         (((x) << 2) & 0x00000004)
#define BTCOEX_INT_STAT_SYNC_MSB                                                                   3
#define BTCOEX_INT_STAT_SYNC_LSB                                                                   3
#define BTCOEX_INT_STAT_SYNC_MASK                                                         0x00000008
#define BTCOEX_INT_STAT_SYNC_GET(x)                                        (((x) & 0x00000008) >> 3)
#define BTCOEX_INT_STAT_SYNC_SET(x)                                        (((x) << 3) & 0x00000008)
#define BTCOEX_INT_STAT_NOSYNC_MSB                                                                 4
#define BTCOEX_INT_STAT_NOSYNC_LSB                                                                 4
#define BTCOEX_INT_STAT_NOSYNC_MASK                                                       0x00000010
#define BTCOEX_INT_STAT_NOSYNC_GET(x)                                      (((x) & 0x00000010) >> 4)
#define BTCOEX_INT_STAT_NOSYNC_SET(x)                                      (((x) << 4) & 0x00000010)
#define BTCOEX_INT_STAT_BTPRIORITY_MSB                                                             5
#define BTCOEX_INT_STAT_BTPRIORITY_LSB                                                             5
#define BTCOEX_INT_STAT_BTPRIORITY_MASK                                                   0x00000020
#define BTCOEX_INT_STAT_BTPRIORITY_GET(x)                                  (((x) & 0x00000020) >> 5)
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_MSB                                                       6
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_LSB                                                       6
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_MASK                                             0x00000040
#define BTCOEX_INT_STAT_BTPRIORITY_STOMP_GET(x)                            (((x) & 0x00000040) >> 6)
#define BTCOEX_INT_STAT_WB_TIMER_MSB                                                               7
#define BTCOEX_INT_STAT_WB_TIMER_LSB                                                               7
#define BTCOEX_INT_STAT_WB_TIMER_MASK                                                     0x00000080
#define BTCOEX_INT_STAT_WB_TIMER_GET(x)                                    (((x) & 0x00000080) >> 7)
#define BTCOEX_INT_STAT_WB_TIMER_SET(x)                                    (((x) << 7) & 0x00000080)
#define BTCOEX_INT_STAT_I2C_MESG_RECV_MSB                                                          8
#define BTCOEX_INT_STAT_I2C_MESG_RECV_LSB                                                          8
#define BTCOEX_INT_STAT_I2C_MESG_RECV_MASK                                                0x00000100
#define BTCOEX_INT_STAT_I2C_MESG_RECV_GET(x)                               (((x) & 0x00000100) >> 8)
#define BTCOEX_INT_STAT_I2C_MESG_RECV_SET(x)                               (((x) << 8) & 0x00000100)
#define BTCOEX_INT_STAT_I2C_MESG_SENT_MSB                                                          9
#define BTCOEX_INT_STAT_I2C_MESG_SENT_LSB                                                          9
#define BTCOEX_INT_STAT_I2C_MESG_SENT_MASK                                                0x00000200
#define BTCOEX_INT_STAT_I2C_MESG_SENT_GET(x)                               (((x) & 0x00000200) >> 9)
#define BTCOEX_INT_STAT_I2C_MESG_SENT_SET(x)                               (((x) << 9) & 0x00000200)
#define BTCOEX_INT_STAT_I2C_TX_FAILED_MSB                                                         10
#define BTCOEX_INT_STAT_I2C_TX_FAILED_LSB                                                         10
#define BTCOEX_INT_STAT_I2C_TX_FAILED_MASK                                                0x00000400
#define BTCOEX_INT_STAT_I2C_TX_FAILED_GET(x)                              (((x) & 0x00000400) >> 10)
#define BTCOEX_INT_STAT_I2C_TX_FAILED_SET(x)                              (((x) << 10) & 0x00000400)
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_MSB                                                     11
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_LSB                                                     11
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_MASK                                            0x00000800
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_GET(x)                          (((x) & 0x00000800) >> 11)
#define BTCOEX_INT_STAT_I2C_RECV_OVERFLOW_SET(x)                          (((x) << 11) & 0x00000800)

/* macros for BTPRIORITY_INT_EN */
#define BTPRIORITY_INT_EN_ADDRESS                                                         0x00000054
#define BTPRIORITY_INT_EN_OFFSET                                                          0x00000054
#define BTPRIORITY_INT_EN_BITMAP_MSB                                                              31
#define BTPRIORITY_INT_EN_BITMAP_LSB                                                               0
#define BTPRIORITY_INT_EN_BITMAP_MASK                                                     0xffffffff
#define BTPRIORITY_INT_EN_BITMAP_GET(x)                                    (((x) & 0xffffffff) >> 0)
#define BTPRIORITY_INT_EN_BITMAP_SET(x)                                    (((x) << 0) & 0xffffffff)

/* macros for BTPRIORITY_INT_STAT */
#define BTPRIORITY_INT_STAT_ADDRESS                                                       0x00000058
#define BTPRIORITY_INT_STAT_OFFSET                                                        0x00000058
#define BTPRIORITY_INT_STAT_BITMAP_MSB                                                            31
#define BTPRIORITY_INT_STAT_BITMAP_LSB                                                             0
#define BTPRIORITY_INT_STAT_BITMAP_MASK                                                   0xffffffff
#define BTPRIORITY_INT_STAT_BITMAP_GET(x)                                  (((x) & 0xffffffff) >> 0)
#define BTPRIORITY_INT_STAT_BITMAP_SET(x)                                  (((x) << 0) & 0xffffffff)

/* macros for BTPRIORITY_STOMP_INT_EN */
#define BTPRIORITY_STOMP_INT_EN_ADDRESS                                                   0x0000005c
#define BTPRIORITY_STOMP_INT_EN_OFFSET                                                    0x0000005c
#define BTPRIORITY_STOMP_INT_EN_BITMAP_MSB                                                        31
#define BTPRIORITY_STOMP_INT_EN_BITMAP_LSB                                                         0
#define BTPRIORITY_STOMP_INT_EN_BITMAP_MASK                                               0xffffffff
#define BTPRIORITY_STOMP_INT_EN_BITMAP_GET(x)                              (((x) & 0xffffffff) >> 0)
#define BTPRIORITY_STOMP_INT_EN_BITMAP_SET(x)                              (((x) << 0) & 0xffffffff)

/* macros for BTPRIORITY_STOMP_INT_STAT */
#define BTPRIORITY_STOMP_INT_STAT_ADDRESS                                                 0x00000060
#define BTPRIORITY_STOMP_INT_STAT_OFFSET                                                  0x00000060
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_MSB                                                      31
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_LSB                                                       0
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_MASK                                             0xffffffff
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_GET(x)                            (((x) & 0xffffffff) >> 0)
#define BTPRIORITY_STOMP_INT_STAT_BITMAP_SET(x)                            (((x) << 0) & 0xffffffff)

/* macros for ST_64_BIT */
#define ST_64_BIT_ADDRESS                                                                 0x00000064
#define ST_64_BIT_OFFSET                                                                  0x00000064
#define ST_64_BIT_MODE_MSB                                                                         0
#define ST_64_BIT_MODE_LSB                                                                         0
#define ST_64_BIT_MODE_MASK                                                               0x00000001
#define ST_64_BIT_MODE_GET(x)                                              (((x) & 0x00000001) >> 0)
#define ST_64_BIT_MODE_SET(x)                                              (((x) << 0) & 0x00000001)
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_MSB                                                         5
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_LSB                                                         1
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_MASK                                               0x0000003e
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_GET(x)                              (((x) & 0x0000003e) >> 1)
#define ST_64_BIT_SOC_CLK_DIVIDE_RATIO_SET(x)                              (((x) << 1) & 0x0000003e)
#define ST_64_BIT_CLOCK_GATE_MSB                                                                   6
#define ST_64_BIT_CLOCK_GATE_LSB                                                                   6
#define ST_64_BIT_CLOCK_GATE_MASK                                                         0x00000040
#define ST_64_BIT_CLOCK_GATE_GET(x)                                        (((x) & 0x00000040) >> 6)
#define ST_64_BIT_CLOCK_GATE_SET(x)                                        (((x) << 6) & 0x00000040)
#define ST_64_BIT_DRIVE_MODE_MSB                                                                   7
#define ST_64_BIT_DRIVE_MODE_LSB                                                                   7
#define ST_64_BIT_DRIVE_MODE_MASK                                                         0x00000080
#define ST_64_BIT_DRIVE_MODE_GET(x)                                        (((x) & 0x00000080) >> 7)
#define ST_64_BIT_DRIVE_MODE_SET(x)                                        (((x) << 7) & 0x00000080)
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_MSB                                                      8
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_LSB                                                      8
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_MASK                                            0x00000100
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_GET(x)                           (((x) & 0x00000100) >> 8)
#define ST_64_BIT_REQ_ACK_NOT_PULLED_DOWN_SET(x)                           (((x) << 8) & 0x00000100)
#define ST_64_BIT_TIMEOUT_MSB                                                                     26
#define ST_64_BIT_TIMEOUT_LSB                                                                      9
#define ST_64_BIT_TIMEOUT_MASK                                                            0x07fffe00
#define ST_64_BIT_TIMEOUT_GET(x)                                           (((x) & 0x07fffe00) >> 9)
#define ST_64_BIT_TIMEOUT_SET(x)                                           (((x) << 9) & 0x07fffe00)

/* macros for MESSAGE_WR */
#define MESSAGE_WR_ADDRESS                                                                0x00000068
#define MESSAGE_WR_OFFSET                                                                 0x00000068
#define MESSAGE_WR_TYPE_MSB                                                                       31
#define MESSAGE_WR_TYPE_LSB                                                                        0
#define MESSAGE_WR_TYPE_MASK                                                              0xffffffff
#define MESSAGE_WR_TYPE_GET(x)                                             (((x) & 0xffffffff) >> 0)
#define MESSAGE_WR_TYPE_SET(x)                                             (((x) << 0) & 0xffffffff)

/* macros for MESSAGE_WR_P */
#define MESSAGE_WR_P_ADDRESS                                                              0x0000006c
#define MESSAGE_WR_P_OFFSET                                                               0x0000006c
#define MESSAGE_WR_P_PARAMETER_MSB                                                                31
#define MESSAGE_WR_P_PARAMETER_LSB                                                                 0
#define MESSAGE_WR_P_PARAMETER_MASK                                                       0xffffffff
#define MESSAGE_WR_P_PARAMETER_GET(x)                                      (((x) & 0xffffffff) >> 0)
#define MESSAGE_WR_P_PARAMETER_SET(x)                                      (((x) << 0) & 0xffffffff)

/* macros for MESSAGE_RD */
#define MESSAGE_RD_ADDRESS                                                                0x00000070
#define MESSAGE_RD_OFFSET                                                                 0x00000070
#define MESSAGE_RD_TYPE_MSB                                                                       31
#define MESSAGE_RD_TYPE_LSB                                                                        0
#define MESSAGE_RD_TYPE_MASK                                                              0xffffffff
#define MESSAGE_RD_TYPE_GET(x)                                             (((x) & 0xffffffff) >> 0)
#define MESSAGE_RD_TYPE_SET(x)                                             (((x) << 0) & 0xffffffff)

/* macros for MESSAGE_RD_P */
#define MESSAGE_RD_P_ADDRESS                                                              0x00000074
#define MESSAGE_RD_P_OFFSET                                                               0x00000074
#define MESSAGE_RD_P_PARAMETER_MSB                                                                31
#define MESSAGE_RD_P_PARAMETER_LSB                                                                 0
#define MESSAGE_RD_P_PARAMETER_MASK                                                       0xffffffff
#define MESSAGE_RD_P_PARAMETER_GET(x)                                      (((x) & 0xffffffff) >> 0)
#define MESSAGE_RD_P_PARAMETER_SET(x)                                      (((x) << 0) & 0xffffffff)

/* macros for BTPRIORITY_INT */
#define BTPRIORITY_INT_ADDRESS                                                            0x00000078
#define BTPRIORITY_INT_OFFSET                                                             0x00000078
#define BTPRIORITY_INT_DELAY_MSB                                                                   7
#define BTPRIORITY_INT_DELAY_LSB                                                                   0
#define BTPRIORITY_INT_DELAY_MASK                                                         0x000000ff
#define BTPRIORITY_INT_DELAY_GET(x)                                        (((x) & 0x000000ff) >> 0)
#define BTPRIORITY_INT_DELAY_SET(x)                                        (((x) << 0) & 0x000000ff)

/* macros for SCO_PARAMS */
#define SCO_PARAMS_ADDRESS                                                                0x0000007c
#define SCO_PARAMS_OFFSET                                                                 0x0000007c
#define SCO_PARAMS_PERIOD_MSB                                                                     13
#define SCO_PARAMS_PERIOD_LSB                                                                      0
#define SCO_PARAMS_PERIOD_MASK                                                            0x00003fff
#define SCO_PARAMS_PERIOD_GET(x)                                           (((x) & 0x00003fff) >> 0)
#define SCO_PARAMS_PERIOD_SET(x)                                           (((x) << 0) & 0x00003fff)
#define SCO_PARAMS_SLOP_MSB                                                                       23
#define SCO_PARAMS_SLOP_LSB                                                                       14
#define SCO_PARAMS_SLOP_MASK                                                              0x00ffc000
#define SCO_PARAMS_SLOP_GET(x)                                            (((x) & 0x00ffc000) >> 14)
#define SCO_PARAMS_SLOP_SET(x)                                            (((x) << 14) & 0x00ffc000)

/* macros for SCO_PRIORITY */
#define SCO_PRIORITY_ADDRESS                                                              0x00000080
#define SCO_PRIORITY_OFFSET                                                               0x00000080
#define SCO_PRIORITY_BITMAP_MSB                                                                   31
#define SCO_PRIORITY_BITMAP_LSB                                                                    0
#define SCO_PRIORITY_BITMAP_MASK                                                          0xffffffff
#define SCO_PRIORITY_BITMAP_GET(x)                                         (((x) & 0xffffffff) >> 0)
#define SCO_PRIORITY_BITMAP_SET(x)                                         (((x) << 0) & 0xffffffff)

/* macros for SCO_SYNC */
#define SCO_SYNC_ADDRESS                                                                  0x00000084
#define SCO_SYNC_OFFSET                                                                   0x00000084
#define SCO_SYNC_BTCLOCK_MSB                                                                      31
#define SCO_SYNC_BTCLOCK_LSB                                                                       0
#define SCO_SYNC_BTCLOCK_MASK                                                             0xffffffff
#define SCO_SYNC_BTCLOCK_GET(x)                                            (((x) & 0xffffffff) >> 0)
#define SCO_SYNC_BTCLOCK_SET(x)                                            (((x) << 0) & 0xffffffff)

/* macros for BTCOEX_RAW_STAT */
#define BTCOEX_RAW_STAT_ADDRESS                                                           0x00000088
#define BTCOEX_RAW_STAT_OFFSET                                                            0x00000088
#define BTCOEX_RAW_STAT_CLK_CNT_MSB                                                                0
#define BTCOEX_RAW_STAT_CLK_CNT_LSB                                                                0
#define BTCOEX_RAW_STAT_CLK_CNT_MASK                                                      0x00000001
#define BTCOEX_RAW_STAT_CLK_CNT_GET(x)                                     (((x) & 0x00000001) >> 0)
#define BTCOEX_RAW_STAT_CLK_CNT_SET(x)                                     (((x) << 0) & 0x00000001)
#define BTCOEX_RAW_STAT_FRAME_CNT_MSB                                                              1
#define BTCOEX_RAW_STAT_FRAME_CNT_LSB                                                              1
#define BTCOEX_RAW_STAT_FRAME_CNT_MASK                                                    0x00000002
#define BTCOEX_RAW_STAT_FRAME_CNT_GET(x)                                   (((x) & 0x00000002) >> 1)
#define BTCOEX_RAW_STAT_FRAME_CNT_SET(x)                                   (((x) << 1) & 0x00000002)
#define BTCOEX_RAW_STAT_END_MSB                                                                    2
#define BTCOEX_RAW_STAT_END_LSB                                                                    2
#define BTCOEX_RAW_STAT_END_MASK                                                          0x00000004
#define BTCOEX_RAW_STAT_END_GET(x)                                         (((x) & 0x00000004) >> 2)
#define BTCOEX_RAW_STAT_END_SET(x)                                         (((x) << 2) & 0x00000004)
#define BTCOEX_RAW_STAT_SYNC_MSB                                                                   3
#define BTCOEX_RAW_STAT_SYNC_LSB                                                                   3
#define BTCOEX_RAW_STAT_SYNC_MASK                                                         0x00000008
#define BTCOEX_RAW_STAT_SYNC_GET(x)                                        (((x) & 0x00000008) >> 3)
#define BTCOEX_RAW_STAT_SYNC_SET(x)                                        (((x) << 3) & 0x00000008)
#define BTCOEX_RAW_STAT_NOSYNC_MSB                                                                 4
#define BTCOEX_RAW_STAT_NOSYNC_LSB                                                                 4
#define BTCOEX_RAW_STAT_NOSYNC_MASK                                                       0x00000010
#define BTCOEX_RAW_STAT_NOSYNC_GET(x)                                      (((x) & 0x00000010) >> 4)
#define BTCOEX_RAW_STAT_NOSYNC_SET(x)                                      (((x) << 4) & 0x00000010)
#define BTCOEX_RAW_STAT_WB_TIMER_MSB                                                               7
#define BTCOEX_RAW_STAT_WB_TIMER_LSB                                                               7
#define BTCOEX_RAW_STAT_WB_TIMER_MASK                                                     0x00000080
#define BTCOEX_RAW_STAT_WB_TIMER_GET(x)                                    (((x) & 0x00000080) >> 7)
#define BTCOEX_RAW_STAT_WB_TIMER_SET(x)                                    (((x) << 7) & 0x00000080)

/* macros for BTPRIORITY_RAW_STAT */
#define BTPRIORITY_RAW_STAT_ADDRESS                                                       0x0000008c
#define BTPRIORITY_RAW_STAT_OFFSET                                                        0x0000008c
#define BTPRIORITY_RAW_STAT_BITMAP_MSB                                                            31
#define BTPRIORITY_RAW_STAT_BITMAP_LSB                                                             0
#define BTPRIORITY_RAW_STAT_BITMAP_MASK                                                   0xffffffff
#define BTPRIORITY_RAW_STAT_BITMAP_GET(x)                                  (((x) & 0xffffffff) >> 0)
#define BTPRIORITY_RAW_STAT_BITMAP_SET(x)                                  (((x) << 0) & 0xffffffff)

/* macros for BTPRIORITY_STOMP_RAW_STAT */
#define BTPRIORITY_STOMP_RAW_STAT_ADDRESS                                                 0x00000090
#define BTPRIORITY_STOMP_RAW_STAT_OFFSET                                                  0x00000090
#define BTPRIORITY_STOMP_RAW_STAT_BITMAP_MSB                                                      31
#define BTPRIORITY_STOMP_RAW_STAT_BITMAP_LSB                                                       0
#define BTPRIORITY_STOMP_RAW_STAT_BITMAP_MASK                                             0xffffffff
#define BTPRIORITY_STOMP_RAW_STAT_BITMAP_GET(x)                            (((x) & 0xffffffff) >> 0)
#define BTPRIORITY_STOMP_RAW_STAT_BITMAP_SET(x)                            (((x) << 0) & 0xffffffff)


#ifndef __ASSEMBLER__

typedef struct bt_coex_reg_reg_s {
  volatile unsigned int BTCOEXCTRL;                                    /*        0x0 - 0x4        */
  volatile unsigned int WBSYNC_PRIORITY1;                              /*        0x4 - 0x8        */
  volatile unsigned int WBSYNC_PRIORITY2;                              /*        0x8 - 0xc        */
  volatile unsigned int WBSYNC_PRIORITY3;                              /*        0xc - 0x10       */
  volatile unsigned int BTCOEX0;                                       /*       0x10 - 0x14       */
  volatile unsigned int BTCOEX1;                                       /*       0x14 - 0x18       */
  volatile unsigned int BTCOEX2;                                       /*       0x18 - 0x1c       */
  volatile unsigned int BTCOEX3;                                       /*       0x1c - 0x20       */
  volatile unsigned int BTCOEX4;                                       /*       0x20 - 0x24       */
  volatile unsigned int BTCOEX5;                                       /*       0x24 - 0x28       */
  volatile unsigned int BTCOEX6;                                       /*       0x28 - 0x2c       */
  volatile unsigned int LOCK;                                          /*       0x2c - 0x30       */
  volatile unsigned int NOLOCK_PRIORITY;                               /*       0x30 - 0x34       */
  volatile unsigned int WBSYNC;                                        /*       0x34 - 0x38       */
  volatile unsigned int WBSYNC1;                                       /*       0x38 - 0x3c       */
  volatile unsigned int WBSYNC2;                                       /*       0x3c - 0x40       */
  volatile unsigned int WBSYNC3;                                       /*       0x40 - 0x44       */
  volatile unsigned int WB_TIMER_TARGET;                               /*       0x44 - 0x48       */
  volatile unsigned int WB_TIMER_SLOP;                                 /*       0x48 - 0x4c       */
  volatile unsigned int BTCOEX_INT_EN;                                 /*       0x4c - 0x50       */
  volatile unsigned int BTCOEX_INT_STAT;                               /*       0x50 - 0x54       */
  volatile unsigned int BTPRIORITY_INT_EN;                             /*       0x54 - 0x58       */
  volatile unsigned int BTPRIORITY_INT_STAT;                           /*       0x58 - 0x5c       */
  volatile unsigned int BTPRIORITY_STOMP_INT_EN;                       /*       0x5c - 0x60       */
  volatile unsigned int BTPRIORITY_STOMP_INT_STAT;                     /*       0x60 - 0x64       */
  volatile unsigned int ST_64_BIT;                                     /*       0x64 - 0x68       */
  volatile unsigned int MESSAGE_WR;                                    /*       0x68 - 0x6c       */
  volatile unsigned int MESSAGE_WR_P;                                  /*       0x6c - 0x70       */
  volatile unsigned int MESSAGE_RD;                                    /*       0x70 - 0x74       */
  volatile unsigned int MESSAGE_RD_P;                                  /*       0x74 - 0x78       */
  volatile unsigned int BTPRIORITY_INT;                                /*       0x78 - 0x7c       */
  volatile unsigned int SCO_PARAMS;                                    /*       0x7c - 0x80       */
  volatile unsigned int SCO_PRIORITY;                                  /*       0x80 - 0x84       */
  volatile unsigned int SCO_SYNC;                                      /*       0x84 - 0x88       */
  volatile unsigned int BTCOEX_RAW_STAT;                               /*       0x88 - 0x8c       */
  volatile unsigned int BTPRIORITY_RAW_STAT;                           /*       0x8c - 0x90       */
  volatile unsigned int BTPRIORITY_STOMP_RAW_STAT;                     /*       0x90 - 0x94       */
} bt_coex_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _BT_COEX_REG_REG_H_ */
