// ------------------------------------------------------------------
// Copyright (c) 2004-2007 Atheros Corporation.  All rights reserved.
// 
//
// Permission to use, copy, modify, and/or distribute this software for any
// purpose with or without fee is hereby granted, provided that the above
// copyright notice and this permission notice appear in all copies.
//
// THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
// WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
// ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
// WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
// ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
// OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
//
//
// ------------------------------------------------------------------
//===================================================================
// Author(s): ="Atheros"
//===================================================================


#ifndef _MBOX_WLAN_REG_REG_H_
#define _MBOX_WLAN_REG_REG_H_

#define WLAN_MBOX_FIFO_ADDRESS                   0x00000000
#define WLAN_MBOX_FIFO_OFFSET                    0x00000000
#define WLAN_MBOX_FIFO_DATA_MSB                  19
#define WLAN_MBOX_FIFO_DATA_LSB                  0
#define WLAN_MBOX_FIFO_DATA_MASK                 0x000fffff
#define WLAN_MBOX_FIFO_DATA_GET(x)               (((x) & WLAN_MBOX_FIFO_DATA_MASK) >> WLAN_MBOX_FIFO_DATA_LSB)
#define WLAN_MBOX_FIFO_DATA_SET(x)               (((x) << WLAN_MBOX_FIFO_DATA_LSB) & WLAN_MBOX_FIFO_DATA_MASK)

#define WLAN_MBOX_FIFO_STATUS_ADDRESS            0x00000010
#define WLAN_MBOX_FIFO_STATUS_OFFSET             0x00000010
#define WLAN_MBOX_FIFO_STATUS_EMPTY_MSB          19
#define WLAN_MBOX_FIFO_STATUS_EMPTY_LSB          16
#define WLAN_MBOX_FIFO_STATUS_EMPTY_MASK         0x000f0000
#define WLAN_MBOX_FIFO_STATUS_EMPTY_GET(x)       (((x) & WLAN_MBOX_FIFO_STATUS_EMPTY_MASK) >> WLAN_MBOX_FIFO_STATUS_EMPTY_LSB)
#define WLAN_MBOX_FIFO_STATUS_EMPTY_SET(x)       (((x) << WLAN_MBOX_FIFO_STATUS_EMPTY_LSB) & WLAN_MBOX_FIFO_STATUS_EMPTY_MASK)
#define WLAN_MBOX_FIFO_STATUS_FULL_MSB           15
#define WLAN_MBOX_FIFO_STATUS_FULL_LSB           12
#define WLAN_MBOX_FIFO_STATUS_FULL_MASK          0x0000f000
#define WLAN_MBOX_FIFO_STATUS_FULL_GET(x)        (((x) & WLAN_MBOX_FIFO_STATUS_FULL_MASK) >> WLAN_MBOX_FIFO_STATUS_FULL_LSB)
#define WLAN_MBOX_FIFO_STATUS_FULL_SET(x)        (((x) << WLAN_MBOX_FIFO_STATUS_FULL_LSB) & WLAN_MBOX_FIFO_STATUS_FULL_MASK)

#define WLAN_MBOX_DMA_POLICY_ADDRESS             0x00000014
#define WLAN_MBOX_DMA_POLICY_OFFSET              0x00000014
#define WLAN_MBOX_DMA_POLICY_TX_QUANTUM_MSB      3
#define WLAN_MBOX_DMA_POLICY_TX_QUANTUM_LSB      3
#define WLAN_MBOX_DMA_POLICY_TX_QUANTUM_MASK     0x00000008
#define WLAN_MBOX_DMA_POLICY_TX_QUANTUM_GET(x)   (((x) & WLAN_MBOX_DMA_POLICY_TX_QUANTUM_MASK) >> WLAN_MBOX_DMA_POLICY_TX_QUANTUM_LSB)
#define WLAN_MBOX_DMA_POLICY_TX_QUANTUM_SET(x)   (((x) << WLAN_MBOX_DMA_POLICY_TX_QUANTUM_LSB) & WLAN_MBOX_DMA_POLICY_TX_QUANTUM_MASK)
#define WLAN_MBOX_DMA_POLICY_TX_ORDER_MSB        2
#define WLAN_MBOX_DMA_POLICY_TX_ORDER_LSB        2
#define WLAN_MBOX_DMA_POLICY_TX_ORDER_MASK       0x00000004
#define WLAN_MBOX_DMA_POLICY_TX_ORDER_GET(x)     (((x) & WLAN_MBOX_DMA_POLICY_TX_ORDER_MASK) >> WLAN_MBOX_DMA_POLICY_TX_ORDER_LSB)
#define WLAN_MBOX_DMA_POLICY_TX_ORDER_SET(x)     (((x) << WLAN_MBOX_DMA_POLICY_TX_ORDER_LSB) & WLAN_MBOX_DMA_POLICY_TX_ORDER_MASK)
#define WLAN_MBOX_DMA_POLICY_RX_QUANTUM_MSB      1
#define WLAN_MBOX_DMA_POLICY_RX_QUANTUM_LSB      1
#define WLAN_MBOX_DMA_POLICY_RX_QUANTUM_MASK     0x00000002
#define WLAN_MBOX_DMA_POLICY_RX_QUANTUM_GET(x)   (((x) & WLAN_MBOX_DMA_POLICY_RX_QUANTUM_MASK) >> WLAN_MBOX_DMA_POLICY_RX_QUANTUM_LSB)
#define WLAN_MBOX_DMA_POLICY_RX_QUANTUM_SET(x)   (((x) << WLAN_MBOX_DMA_POLICY_RX_QUANTUM_LSB) & WLAN_MBOX_DMA_POLICY_RX_QUANTUM_MASK)
#define WLAN_MBOX_DMA_POLICY_RX_ORDER_MSB        0
#define WLAN_MBOX_DMA_POLICY_RX_ORDER_LSB        0
#define WLAN_MBOX_DMA_POLICY_RX_ORDER_MASK       0x00000001
#define WLAN_MBOX_DMA_POLICY_RX_ORDER_GET(x)     (((x) & WLAN_MBOX_DMA_POLICY_RX_ORDER_MASK) >> WLAN_MBOX_DMA_POLICY_RX_ORDER_LSB)
#define WLAN_MBOX_DMA_POLICY_RX_ORDER_SET(x)     (((x) << WLAN_MBOX_DMA_POLICY_RX_ORDER_LSB) & WLAN_MBOX_DMA_POLICY_RX_ORDER_MASK)

#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS 0x00000018
#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_OFFSET 0x00000018
#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX0_DMA_RX_CONTROL_ADDRESS        0x0000001c
#define WLAN_MBOX0_DMA_RX_CONTROL_OFFSET         0x0000001c
#define WLAN_MBOX0_DMA_RX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX0_DMA_RX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX0_DMA_RX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX0_DMA_RX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX0_DMA_RX_CONTROL_RESUME_MASK) >> WLAN_MBOX0_DMA_RX_CONTROL_RESUME_LSB)
#define WLAN_MBOX0_DMA_RX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX0_DMA_RX_CONTROL_RESUME_LSB) & WLAN_MBOX0_DMA_RX_CONTROL_RESUME_MASK)
#define WLAN_MBOX0_DMA_RX_CONTROL_START_MSB      1
#define WLAN_MBOX0_DMA_RX_CONTROL_START_LSB      1
#define WLAN_MBOX0_DMA_RX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX0_DMA_RX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX0_DMA_RX_CONTROL_START_MASK) >> WLAN_MBOX0_DMA_RX_CONTROL_START_LSB)
#define WLAN_MBOX0_DMA_RX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX0_DMA_RX_CONTROL_START_LSB) & WLAN_MBOX0_DMA_RX_CONTROL_START_MASK)
#define WLAN_MBOX0_DMA_RX_CONTROL_STOP_MSB       0
#define WLAN_MBOX0_DMA_RX_CONTROL_STOP_LSB       0
#define WLAN_MBOX0_DMA_RX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX0_DMA_RX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX0_DMA_RX_CONTROL_STOP_MASK) >> WLAN_MBOX0_DMA_RX_CONTROL_STOP_LSB)
#define WLAN_MBOX0_DMA_RX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX0_DMA_RX_CONTROL_STOP_LSB) & WLAN_MBOX0_DMA_RX_CONTROL_STOP_MASK)

#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS 0x00000020
#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_OFFSET 0x00000020
#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX0_DMA_TX_CONTROL_ADDRESS        0x00000024
#define WLAN_MBOX0_DMA_TX_CONTROL_OFFSET         0x00000024
#define WLAN_MBOX0_DMA_TX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX0_DMA_TX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX0_DMA_TX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX0_DMA_TX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX0_DMA_TX_CONTROL_RESUME_MASK) >> WLAN_MBOX0_DMA_TX_CONTROL_RESUME_LSB)
#define WLAN_MBOX0_DMA_TX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX0_DMA_TX_CONTROL_RESUME_LSB) & WLAN_MBOX0_DMA_TX_CONTROL_RESUME_MASK)
#define WLAN_MBOX0_DMA_TX_CONTROL_START_MSB      1
#define WLAN_MBOX0_DMA_TX_CONTROL_START_LSB      1
#define WLAN_MBOX0_DMA_TX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX0_DMA_TX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX0_DMA_TX_CONTROL_START_MASK) >> WLAN_MBOX0_DMA_TX_CONTROL_START_LSB)
#define WLAN_MBOX0_DMA_TX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX0_DMA_TX_CONTROL_START_LSB) & WLAN_MBOX0_DMA_TX_CONTROL_START_MASK)
#define WLAN_MBOX0_DMA_TX_CONTROL_STOP_MSB       0
#define WLAN_MBOX0_DMA_TX_CONTROL_STOP_LSB       0
#define WLAN_MBOX0_DMA_TX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX0_DMA_TX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX0_DMA_TX_CONTROL_STOP_MASK) >> WLAN_MBOX0_DMA_TX_CONTROL_STOP_LSB)
#define WLAN_MBOX0_DMA_TX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX0_DMA_TX_CONTROL_STOP_LSB) & WLAN_MBOX0_DMA_TX_CONTROL_STOP_MASK)

#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS 0x00000028
#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_OFFSET 0x00000028
#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX1_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX1_DMA_RX_CONTROL_ADDRESS        0x0000002c
#define WLAN_MBOX1_DMA_RX_CONTROL_OFFSET         0x0000002c
#define WLAN_MBOX1_DMA_RX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX1_DMA_RX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX1_DMA_RX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX1_DMA_RX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX1_DMA_RX_CONTROL_RESUME_MASK) >> WLAN_MBOX1_DMA_RX_CONTROL_RESUME_LSB)
#define WLAN_MBOX1_DMA_RX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX1_DMA_RX_CONTROL_RESUME_LSB) & WLAN_MBOX1_DMA_RX_CONTROL_RESUME_MASK)
#define WLAN_MBOX1_DMA_RX_CONTROL_START_MSB      1
#define WLAN_MBOX1_DMA_RX_CONTROL_START_LSB      1
#define WLAN_MBOX1_DMA_RX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX1_DMA_RX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX1_DMA_RX_CONTROL_START_MASK) >> WLAN_MBOX1_DMA_RX_CONTROL_START_LSB)
#define WLAN_MBOX1_DMA_RX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX1_DMA_RX_CONTROL_START_LSB) & WLAN_MBOX1_DMA_RX_CONTROL_START_MASK)
#define WLAN_MBOX1_DMA_RX_CONTROL_STOP_MSB       0
#define WLAN_MBOX1_DMA_RX_CONTROL_STOP_LSB       0
#define WLAN_MBOX1_DMA_RX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX1_DMA_RX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX1_DMA_RX_CONTROL_STOP_MASK) >> WLAN_MBOX1_DMA_RX_CONTROL_STOP_LSB)
#define WLAN_MBOX1_DMA_RX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX1_DMA_RX_CONTROL_STOP_LSB) & WLAN_MBOX1_DMA_RX_CONTROL_STOP_MASK)

#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS 0x00000030
#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_OFFSET 0x00000030
#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX1_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX1_DMA_TX_CONTROL_ADDRESS        0x00000034
#define WLAN_MBOX1_DMA_TX_CONTROL_OFFSET         0x00000034
#define WLAN_MBOX1_DMA_TX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX1_DMA_TX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX1_DMA_TX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX1_DMA_TX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX1_DMA_TX_CONTROL_RESUME_MASK) >> WLAN_MBOX1_DMA_TX_CONTROL_RESUME_LSB)
#define WLAN_MBOX1_DMA_TX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX1_DMA_TX_CONTROL_RESUME_LSB) & WLAN_MBOX1_DMA_TX_CONTROL_RESUME_MASK)
#define WLAN_MBOX1_DMA_TX_CONTROL_START_MSB      1
#define WLAN_MBOX1_DMA_TX_CONTROL_START_LSB      1
#define WLAN_MBOX1_DMA_TX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX1_DMA_TX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX1_DMA_TX_CONTROL_START_MASK) >> WLAN_MBOX1_DMA_TX_CONTROL_START_LSB)
#define WLAN_MBOX1_DMA_TX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX1_DMA_TX_CONTROL_START_LSB) & WLAN_MBOX1_DMA_TX_CONTROL_START_MASK)
#define WLAN_MBOX1_DMA_TX_CONTROL_STOP_MSB       0
#define WLAN_MBOX1_DMA_TX_CONTROL_STOP_LSB       0
#define WLAN_MBOX1_DMA_TX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX1_DMA_TX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX1_DMA_TX_CONTROL_STOP_MASK) >> WLAN_MBOX1_DMA_TX_CONTROL_STOP_LSB)
#define WLAN_MBOX1_DMA_TX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX1_DMA_TX_CONTROL_STOP_LSB) & WLAN_MBOX1_DMA_TX_CONTROL_STOP_MASK)

#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS 0x00000038
#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_OFFSET 0x00000038
#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX2_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX2_DMA_RX_CONTROL_ADDRESS        0x0000003c
#define WLAN_MBOX2_DMA_RX_CONTROL_OFFSET         0x0000003c
#define WLAN_MBOX2_DMA_RX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX2_DMA_RX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX2_DMA_RX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX2_DMA_RX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX2_DMA_RX_CONTROL_RESUME_MASK) >> WLAN_MBOX2_DMA_RX_CONTROL_RESUME_LSB)
#define WLAN_MBOX2_DMA_RX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX2_DMA_RX_CONTROL_RESUME_LSB) & WLAN_MBOX2_DMA_RX_CONTROL_RESUME_MASK)
#define WLAN_MBOX2_DMA_RX_CONTROL_START_MSB      1
#define WLAN_MBOX2_DMA_RX_CONTROL_START_LSB      1
#define WLAN_MBOX2_DMA_RX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX2_DMA_RX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX2_DMA_RX_CONTROL_START_MASK) >> WLAN_MBOX2_DMA_RX_CONTROL_START_LSB)
#define WLAN_MBOX2_DMA_RX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX2_DMA_RX_CONTROL_START_LSB) & WLAN_MBOX2_DMA_RX_CONTROL_START_MASK)
#define WLAN_MBOX2_DMA_RX_CONTROL_STOP_MSB       0
#define WLAN_MBOX2_DMA_RX_CONTROL_STOP_LSB       0
#define WLAN_MBOX2_DMA_RX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX2_DMA_RX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX2_DMA_RX_CONTROL_STOP_MASK) >> WLAN_MBOX2_DMA_RX_CONTROL_STOP_LSB)
#define WLAN_MBOX2_DMA_RX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX2_DMA_RX_CONTROL_STOP_LSB) & WLAN_MBOX2_DMA_RX_CONTROL_STOP_MASK)

#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS 0x00000040
#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_OFFSET 0x00000040
#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX2_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX2_DMA_TX_CONTROL_ADDRESS        0x00000044
#define WLAN_MBOX2_DMA_TX_CONTROL_OFFSET         0x00000044
#define WLAN_MBOX2_DMA_TX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX2_DMA_TX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX2_DMA_TX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX2_DMA_TX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX2_DMA_TX_CONTROL_RESUME_MASK) >> WLAN_MBOX2_DMA_TX_CONTROL_RESUME_LSB)
#define WLAN_MBOX2_DMA_TX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX2_DMA_TX_CONTROL_RESUME_LSB) & WLAN_MBOX2_DMA_TX_CONTROL_RESUME_MASK)
#define WLAN_MBOX2_DMA_TX_CONTROL_START_MSB      1
#define WLAN_MBOX2_DMA_TX_CONTROL_START_LSB      1
#define WLAN_MBOX2_DMA_TX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX2_DMA_TX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX2_DMA_TX_CONTROL_START_MASK) >> WLAN_MBOX2_DMA_TX_CONTROL_START_LSB)
#define WLAN_MBOX2_DMA_TX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX2_DMA_TX_CONTROL_START_LSB) & WLAN_MBOX2_DMA_TX_CONTROL_START_MASK)
#define WLAN_MBOX2_DMA_TX_CONTROL_STOP_MSB       0
#define WLAN_MBOX2_DMA_TX_CONTROL_STOP_LSB       0
#define WLAN_MBOX2_DMA_TX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX2_DMA_TX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX2_DMA_TX_CONTROL_STOP_MASK) >> WLAN_MBOX2_DMA_TX_CONTROL_STOP_LSB)
#define WLAN_MBOX2_DMA_TX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX2_DMA_TX_CONTROL_STOP_LSB) & WLAN_MBOX2_DMA_TX_CONTROL_STOP_MASK)

#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS 0x00000048
#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_OFFSET 0x00000048
#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX3_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX3_DMA_RX_CONTROL_ADDRESS        0x0000004c
#define WLAN_MBOX3_DMA_RX_CONTROL_OFFSET         0x0000004c
#define WLAN_MBOX3_DMA_RX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX3_DMA_RX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX3_DMA_RX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX3_DMA_RX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX3_DMA_RX_CONTROL_RESUME_MASK) >> WLAN_MBOX3_DMA_RX_CONTROL_RESUME_LSB)
#define WLAN_MBOX3_DMA_RX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX3_DMA_RX_CONTROL_RESUME_LSB) & WLAN_MBOX3_DMA_RX_CONTROL_RESUME_MASK)
#define WLAN_MBOX3_DMA_RX_CONTROL_START_MSB      1
#define WLAN_MBOX3_DMA_RX_CONTROL_START_LSB      1
#define WLAN_MBOX3_DMA_RX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX3_DMA_RX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX3_DMA_RX_CONTROL_START_MASK) >> WLAN_MBOX3_DMA_RX_CONTROL_START_LSB)
#define WLAN_MBOX3_DMA_RX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX3_DMA_RX_CONTROL_START_LSB) & WLAN_MBOX3_DMA_RX_CONTROL_START_MASK)
#define WLAN_MBOX3_DMA_RX_CONTROL_STOP_MSB       0
#define WLAN_MBOX3_DMA_RX_CONTROL_STOP_LSB       0
#define WLAN_MBOX3_DMA_RX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX3_DMA_RX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX3_DMA_RX_CONTROL_STOP_MASK) >> WLAN_MBOX3_DMA_RX_CONTROL_STOP_LSB)
#define WLAN_MBOX3_DMA_RX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX3_DMA_RX_CONTROL_STOP_LSB) & WLAN_MBOX3_DMA_RX_CONTROL_STOP_MASK)

#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS 0x00000050
#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_OFFSET 0x00000050
#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_MBOX3_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_MBOX3_DMA_TX_CONTROL_ADDRESS        0x00000054
#define WLAN_MBOX3_DMA_TX_CONTROL_OFFSET         0x00000054
#define WLAN_MBOX3_DMA_TX_CONTROL_RESUME_MSB     2
#define WLAN_MBOX3_DMA_TX_CONTROL_RESUME_LSB     2
#define WLAN_MBOX3_DMA_TX_CONTROL_RESUME_MASK    0x00000004
#define WLAN_MBOX3_DMA_TX_CONTROL_RESUME_GET(x)  (((x) & WLAN_MBOX3_DMA_TX_CONTROL_RESUME_MASK) >> WLAN_MBOX3_DMA_TX_CONTROL_RESUME_LSB)
#define WLAN_MBOX3_DMA_TX_CONTROL_RESUME_SET(x)  (((x) << WLAN_MBOX3_DMA_TX_CONTROL_RESUME_LSB) & WLAN_MBOX3_DMA_TX_CONTROL_RESUME_MASK)
#define WLAN_MBOX3_DMA_TX_CONTROL_START_MSB      1
#define WLAN_MBOX3_DMA_TX_CONTROL_START_LSB      1
#define WLAN_MBOX3_DMA_TX_CONTROL_START_MASK     0x00000002
#define WLAN_MBOX3_DMA_TX_CONTROL_START_GET(x)   (((x) & WLAN_MBOX3_DMA_TX_CONTROL_START_MASK) >> WLAN_MBOX3_DMA_TX_CONTROL_START_LSB)
#define WLAN_MBOX3_DMA_TX_CONTROL_START_SET(x)   (((x) << WLAN_MBOX3_DMA_TX_CONTROL_START_LSB) & WLAN_MBOX3_DMA_TX_CONTROL_START_MASK)
#define WLAN_MBOX3_DMA_TX_CONTROL_STOP_MSB       0
#define WLAN_MBOX3_DMA_TX_CONTROL_STOP_LSB       0
#define WLAN_MBOX3_DMA_TX_CONTROL_STOP_MASK      0x00000001
#define WLAN_MBOX3_DMA_TX_CONTROL_STOP_GET(x)    (((x) & WLAN_MBOX3_DMA_TX_CONTROL_STOP_MASK) >> WLAN_MBOX3_DMA_TX_CONTROL_STOP_LSB)
#define WLAN_MBOX3_DMA_TX_CONTROL_STOP_SET(x)    (((x) << WLAN_MBOX3_DMA_TX_CONTROL_STOP_LSB) & WLAN_MBOX3_DMA_TX_CONTROL_STOP_MASK)

#define WLAN_MBOX_INT_STATUS_ADDRESS             0x00000058
#define WLAN_MBOX_INT_STATUS_OFFSET              0x00000058
#define WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_MSB 31
#define WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_LSB 28
#define WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_MASK 0xf0000000
#define WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_GET(x) (((x) & WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_MASK) >> WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_LSB)
#define WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_SET(x) (((x) << WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_LSB) & WLAN_MBOX_INT_STATUS_RX_DMA_COMPLETE_MASK)
#define WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MSB 27
#define WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB 24
#define WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK 0x0f000000
#define WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_GET(x) (((x) & WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK) >> WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB)
#define WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_SET(x) (((x) << WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB) & WLAN_MBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK)
#define WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_MSB 23
#define WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_LSB 20
#define WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_MASK 0x00f00000
#define WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_GET(x) (((x) & WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_MASK) >> WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_LSB)
#define WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_SET(x) (((x) << WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_LSB) & WLAN_MBOX_INT_STATUS_TX_DMA_COMPLETE_MASK)
#define WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_MSB 19
#define WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_LSB 19
#define WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_MASK 0x00080000
#define WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_GET(x) (((x) & WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_MASK) >> WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_LSB)
#define WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_SET(x) (((x) << WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_LSB) & WLAN_MBOX_INT_STATUS_NO_RX_MBOX_DATA_AVA_MASK)
#define WLAN_MBOX_INT_STATUS_FRAME_DONE_MSB      18
#define WLAN_MBOX_INT_STATUS_FRAME_DONE_LSB      18
#define WLAN_MBOX_INT_STATUS_FRAME_DONE_MASK     0x00040000
#define WLAN_MBOX_INT_STATUS_FRAME_DONE_GET(x)   (((x) & WLAN_MBOX_INT_STATUS_FRAME_DONE_MASK) >> WLAN_MBOX_INT_STATUS_FRAME_DONE_LSB)
#define WLAN_MBOX_INT_STATUS_FRAME_DONE_SET(x)   (((x) << WLAN_MBOX_INT_STATUS_FRAME_DONE_LSB) & WLAN_MBOX_INT_STATUS_FRAME_DONE_MASK)
#define WLAN_MBOX_INT_STATUS_TX_OVERFLOW_MSB     17
#define WLAN_MBOX_INT_STATUS_TX_OVERFLOW_LSB     17
#define WLAN_MBOX_INT_STATUS_TX_OVERFLOW_MASK    0x00020000
#define WLAN_MBOX_INT_STATUS_TX_OVERFLOW_GET(x)  (((x) & WLAN_MBOX_INT_STATUS_TX_OVERFLOW_MASK) >> WLAN_MBOX_INT_STATUS_TX_OVERFLOW_LSB)
#define WLAN_MBOX_INT_STATUS_TX_OVERFLOW_SET(x)  (((x) << WLAN_MBOX_INT_STATUS_TX_OVERFLOW_LSB) & WLAN_MBOX_INT_STATUS_TX_OVERFLOW_MASK)
#define WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_MSB    16
#define WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_LSB    16
#define WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_MASK   0x00010000
#define WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_GET(x) (((x) & WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_MASK) >> WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_LSB)
#define WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_SET(x) (((x) << WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_LSB) & WLAN_MBOX_INT_STATUS_RX_UNDERFLOW_MASK)
#define WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_MSB    15
#define WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_LSB    12
#define WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_MASK   0x0000f000
#define WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_GET(x) (((x) & WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_MASK) >> WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_LSB)
#define WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_SET(x) (((x) << WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_LSB) & WLAN_MBOX_INT_STATUS_TX_NOT_EMPTY_MASK)
#define WLAN_MBOX_INT_STATUS_RX_NOT_FULL_MSB     11
#define WLAN_MBOX_INT_STATUS_RX_NOT_FULL_LSB     8
#define WLAN_MBOX_INT_STATUS_RX_NOT_FULL_MASK    0x00000f00
#define WLAN_MBOX_INT_STATUS_RX_NOT_FULL_GET(x)  (((x) & WLAN_MBOX_INT_STATUS_RX_NOT_FULL_MASK) >> WLAN_MBOX_INT_STATUS_RX_NOT_FULL_LSB)
#define WLAN_MBOX_INT_STATUS_RX_NOT_FULL_SET(x)  (((x) << WLAN_MBOX_INT_STATUS_RX_NOT_FULL_LSB) & WLAN_MBOX_INT_STATUS_RX_NOT_FULL_MASK)
#define WLAN_MBOX_INT_STATUS_HOST_MSB            7
#define WLAN_MBOX_INT_STATUS_HOST_LSB            0
#define WLAN_MBOX_INT_STATUS_HOST_MASK           0x000000ff
#define WLAN_MBOX_INT_STATUS_HOST_GET(x)         (((x) & WLAN_MBOX_INT_STATUS_HOST_MASK) >> WLAN_MBOX_INT_STATUS_HOST_LSB)
#define WLAN_MBOX_INT_STATUS_HOST_SET(x)         (((x) << WLAN_MBOX_INT_STATUS_HOST_LSB) & WLAN_MBOX_INT_STATUS_HOST_MASK)

#define WLAN_MBOX_INT_ENABLE_ADDRESS             0x0000005c
#define WLAN_MBOX_INT_ENABLE_OFFSET              0x0000005c
#define WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_MSB 31
#define WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB 28
#define WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK 0xf0000000
#define WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_GET(x) (((x) & WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK) >> WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB)
#define WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_SET(x) (((x) << WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB) & WLAN_MBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK)
#define WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MSB 27
#define WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB 24
#define WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK 0x0f000000
#define WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_GET(x) (((x) & WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK) >> WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB)
#define WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_SET(x) (((x) << WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB) & WLAN_MBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK)
#define WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_MSB 23
#define WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB 20
#define WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK 0x00f00000
#define WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_GET(x) (((x) & WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK) >> WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB)
#define WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_SET(x) (((x) << WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB) & WLAN_MBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK)
#define WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_MSB 19
#define WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_LSB 19
#define WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_MASK 0x00080000
#define WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_GET(x) (((x) & WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_MASK) >> WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_LSB)
#define WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_SET(x) (((x) << WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_LSB) & WLAN_MBOX_INT_ENABLE_NO_RX_MBOX_DATA_AVA_MASK)
#define WLAN_MBOX_INT_ENABLE_FRAME_DONE_MSB      18
#define WLAN_MBOX_INT_ENABLE_FRAME_DONE_LSB      18
#define WLAN_MBOX_INT_ENABLE_FRAME_DONE_MASK     0x00040000
#define WLAN_MBOX_INT_ENABLE_FRAME_DONE_GET(x)   (((x) & WLAN_MBOX_INT_ENABLE_FRAME_DONE_MASK) >> WLAN_MBOX_INT_ENABLE_FRAME_DONE_LSB)
#define WLAN_MBOX_INT_ENABLE_FRAME_DONE_SET(x)   (((x) << WLAN_MBOX_INT_ENABLE_FRAME_DONE_LSB) & WLAN_MBOX_INT_ENABLE_FRAME_DONE_MASK)
#define WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_MSB     17
#define WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_LSB     17
#define WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_MASK    0x00020000
#define WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_GET(x)  (((x) & WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_MASK) >> WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_LSB)
#define WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_SET(x)  (((x) << WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_LSB) & WLAN_MBOX_INT_ENABLE_TX_OVERFLOW_MASK)
#define WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_MSB    16
#define WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_LSB    16
#define WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_MASK   0x00010000
#define WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_GET(x) (((x) & WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_MASK) >> WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_LSB)
#define WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_SET(x) (((x) << WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_LSB) & WLAN_MBOX_INT_ENABLE_RX_UNDERFLOW_MASK)
#define WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_MSB    15
#define WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_LSB    12
#define WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_MASK   0x0000f000
#define WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_GET(x) (((x) & WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_MASK) >> WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_LSB)
#define WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_SET(x) (((x) << WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_LSB) & WLAN_MBOX_INT_ENABLE_TX_NOT_EMPTY_MASK)
#define WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_MSB     11
#define WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_LSB     8
#define WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_MASK    0x00000f00
#define WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_GET(x)  (((x) & WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_MASK) >> WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_LSB)
#define WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_SET(x)  (((x) << WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_LSB) & WLAN_MBOX_INT_ENABLE_RX_NOT_FULL_MASK)
#define WLAN_MBOX_INT_ENABLE_HOST_MSB            7
#define WLAN_MBOX_INT_ENABLE_HOST_LSB            0
#define WLAN_MBOX_INT_ENABLE_HOST_MASK           0x000000ff
#define WLAN_MBOX_INT_ENABLE_HOST_GET(x)         (((x) & WLAN_MBOX_INT_ENABLE_HOST_MASK) >> WLAN_MBOX_INT_ENABLE_HOST_LSB)
#define WLAN_MBOX_INT_ENABLE_HOST_SET(x)         (((x) << WLAN_MBOX_INT_ENABLE_HOST_LSB) & WLAN_MBOX_INT_ENABLE_HOST_MASK)

#define WLAN_INT_HOST_ADDRESS                    0x00000060
#define WLAN_INT_HOST_OFFSET                     0x00000060
#define WLAN_INT_HOST_VECTOR_MSB                 7
#define WLAN_INT_HOST_VECTOR_LSB                 0
#define WLAN_INT_HOST_VECTOR_MASK                0x000000ff
#define WLAN_INT_HOST_VECTOR_GET(x)              (((x) & WLAN_INT_HOST_VECTOR_MASK) >> WLAN_INT_HOST_VECTOR_LSB)
#define WLAN_INT_HOST_VECTOR_SET(x)              (((x) << WLAN_INT_HOST_VECTOR_LSB) & WLAN_INT_HOST_VECTOR_MASK)

#define WLAN_LOCAL_COUNT_ADDRESS                 0x00000080
#define WLAN_LOCAL_COUNT_OFFSET                  0x00000080
#define WLAN_LOCAL_COUNT_VALUE_MSB               7
#define WLAN_LOCAL_COUNT_VALUE_LSB               0
#define WLAN_LOCAL_COUNT_VALUE_MASK              0x000000ff
#define WLAN_LOCAL_COUNT_VALUE_GET(x)            (((x) & WLAN_LOCAL_COUNT_VALUE_MASK) >> WLAN_LOCAL_COUNT_VALUE_LSB)
#define WLAN_LOCAL_COUNT_VALUE_SET(x)            (((x) << WLAN_LOCAL_COUNT_VALUE_LSB) & WLAN_LOCAL_COUNT_VALUE_MASK)

#define WLAN_COUNT_INC_ADDRESS                   0x000000a0
#define WLAN_COUNT_INC_OFFSET                    0x000000a0
#define WLAN_COUNT_INC_VALUE_MSB                 7
#define WLAN_COUNT_INC_VALUE_LSB                 0
#define WLAN_COUNT_INC_VALUE_MASK                0x000000ff
#define WLAN_COUNT_INC_VALUE_GET(x)              (((x) & WLAN_COUNT_INC_VALUE_MASK) >> WLAN_COUNT_INC_VALUE_LSB)
#define WLAN_COUNT_INC_VALUE_SET(x)              (((x) << WLAN_COUNT_INC_VALUE_LSB) & WLAN_COUNT_INC_VALUE_MASK)

#define WLAN_LOCAL_SCRATCH_ADDRESS               0x000000c0
#define WLAN_LOCAL_SCRATCH_OFFSET                0x000000c0
#define WLAN_LOCAL_SCRATCH_VALUE_MSB             7
#define WLAN_LOCAL_SCRATCH_VALUE_LSB             0
#define WLAN_LOCAL_SCRATCH_VALUE_MASK            0x000000ff
#define WLAN_LOCAL_SCRATCH_VALUE_GET(x)          (((x) & WLAN_LOCAL_SCRATCH_VALUE_MASK) >> WLAN_LOCAL_SCRATCH_VALUE_LSB)
#define WLAN_LOCAL_SCRATCH_VALUE_SET(x)          (((x) << WLAN_LOCAL_SCRATCH_VALUE_LSB) & WLAN_LOCAL_SCRATCH_VALUE_MASK)

#define WLAN_USE_LOCAL_BUS_ADDRESS               0x000000e0
#define WLAN_USE_LOCAL_BUS_OFFSET                0x000000e0
#define WLAN_USE_LOCAL_BUS_PIN_INIT_MSB          0
#define WLAN_USE_LOCAL_BUS_PIN_INIT_LSB          0
#define WLAN_USE_LOCAL_BUS_PIN_INIT_MASK         0x00000001
#define WLAN_USE_LOCAL_BUS_PIN_INIT_GET(x)       (((x) & WLAN_USE_LOCAL_BUS_PIN_INIT_MASK) >> WLAN_USE_LOCAL_BUS_PIN_INIT_LSB)
#define WLAN_USE_LOCAL_BUS_PIN_INIT_SET(x)       (((x) << WLAN_USE_LOCAL_BUS_PIN_INIT_LSB) & WLAN_USE_LOCAL_BUS_PIN_INIT_MASK)

#define WLAN_SDIO_CONFIG_ADDRESS                 0x000000e4
#define WLAN_SDIO_CONFIG_OFFSET                  0x000000e4
#define WLAN_SDIO_CONFIG_CCCR_IOR1_MSB           0
#define WLAN_SDIO_CONFIG_CCCR_IOR1_LSB           0
#define WLAN_SDIO_CONFIG_CCCR_IOR1_MASK          0x00000001
#define WLAN_SDIO_CONFIG_CCCR_IOR1_GET(x)        (((x) & WLAN_SDIO_CONFIG_CCCR_IOR1_MASK) >> WLAN_SDIO_CONFIG_CCCR_IOR1_LSB)
#define WLAN_SDIO_CONFIG_CCCR_IOR1_SET(x)        (((x) << WLAN_SDIO_CONFIG_CCCR_IOR1_LSB) & WLAN_SDIO_CONFIG_CCCR_IOR1_MASK)

#define WLAN_MBOX_DEBUG_ADDRESS                  0x000000e8
#define WLAN_MBOX_DEBUG_OFFSET                   0x000000e8
#define WLAN_MBOX_DEBUG_SEL_MSB                  2
#define WLAN_MBOX_DEBUG_SEL_LSB                  0
#define WLAN_MBOX_DEBUG_SEL_MASK                 0x00000007
#define WLAN_MBOX_DEBUG_SEL_GET(x)               (((x) & WLAN_MBOX_DEBUG_SEL_MASK) >> WLAN_MBOX_DEBUG_SEL_LSB)
#define WLAN_MBOX_DEBUG_SEL_SET(x)               (((x) << WLAN_MBOX_DEBUG_SEL_LSB) & WLAN_MBOX_DEBUG_SEL_MASK)

#define WLAN_MBOX_FIFO_RESET_ADDRESS             0x000000ec
#define WLAN_MBOX_FIFO_RESET_OFFSET              0x000000ec
#define WLAN_MBOX_FIFO_RESET_INIT_MSB            0
#define WLAN_MBOX_FIFO_RESET_INIT_LSB            0
#define WLAN_MBOX_FIFO_RESET_INIT_MASK           0x00000001
#define WLAN_MBOX_FIFO_RESET_INIT_GET(x)         (((x) & WLAN_MBOX_FIFO_RESET_INIT_MASK) >> WLAN_MBOX_FIFO_RESET_INIT_LSB)
#define WLAN_MBOX_FIFO_RESET_INIT_SET(x)         (((x) << WLAN_MBOX_FIFO_RESET_INIT_LSB) & WLAN_MBOX_FIFO_RESET_INIT_MASK)

#define WLAN_MBOX_TXFIFO_POP_ADDRESS             0x000000f0
#define WLAN_MBOX_TXFIFO_POP_OFFSET              0x000000f0
#define WLAN_MBOX_TXFIFO_POP_DATA_MSB            0
#define WLAN_MBOX_TXFIFO_POP_DATA_LSB            0
#define WLAN_MBOX_TXFIFO_POP_DATA_MASK           0x00000001
#define WLAN_MBOX_TXFIFO_POP_DATA_GET(x)         (((x) & WLAN_MBOX_TXFIFO_POP_DATA_MASK) >> WLAN_MBOX_TXFIFO_POP_DATA_LSB)
#define WLAN_MBOX_TXFIFO_POP_DATA_SET(x)         (((x) << WLAN_MBOX_TXFIFO_POP_DATA_LSB) & WLAN_MBOX_TXFIFO_POP_DATA_MASK)

#define WLAN_MBOX_RXFIFO_POP_ADDRESS             0x00000100
#define WLAN_MBOX_RXFIFO_POP_OFFSET              0x00000100
#define WLAN_MBOX_RXFIFO_POP_DATA_MSB            0
#define WLAN_MBOX_RXFIFO_POP_DATA_LSB            0
#define WLAN_MBOX_RXFIFO_POP_DATA_MASK           0x00000001
#define WLAN_MBOX_RXFIFO_POP_DATA_GET(x)         (((x) & WLAN_MBOX_RXFIFO_POP_DATA_MASK) >> WLAN_MBOX_RXFIFO_POP_DATA_LSB)
#define WLAN_MBOX_RXFIFO_POP_DATA_SET(x)         (((x) << WLAN_MBOX_RXFIFO_POP_DATA_LSB) & WLAN_MBOX_RXFIFO_POP_DATA_MASK)

#define WLAN_SDIO_DEBUG_ADDRESS                  0x00000110
#define WLAN_SDIO_DEBUG_OFFSET                   0x00000110
#define WLAN_SDIO_DEBUG_SEL_MSB                  3
#define WLAN_SDIO_DEBUG_SEL_LSB                  0
#define WLAN_SDIO_DEBUG_SEL_MASK                 0x0000000f
#define WLAN_SDIO_DEBUG_SEL_GET(x)               (((x) & WLAN_SDIO_DEBUG_SEL_MASK) >> WLAN_SDIO_DEBUG_SEL_LSB)
#define WLAN_SDIO_DEBUG_SEL_SET(x)               (((x) << WLAN_SDIO_DEBUG_SEL_LSB) & WLAN_SDIO_DEBUG_SEL_MASK)

#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS 0x00000114
#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_OFFSET 0x00000114
#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_GMBOX0_DMA_RX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_GMBOX0_DMA_RX_CONTROL_ADDRESS       0x00000118
#define WLAN_GMBOX0_DMA_RX_CONTROL_OFFSET        0x00000118
#define WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_MSB    2
#define WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_LSB    2
#define WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_MASK   0x00000004
#define WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_GET(x) (((x) & WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_MASK) >> WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_LSB)
#define WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_SET(x) (((x) << WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_LSB) & WLAN_GMBOX0_DMA_RX_CONTROL_RESUME_MASK)
#define WLAN_GMBOX0_DMA_RX_CONTROL_START_MSB     1
#define WLAN_GMBOX0_DMA_RX_CONTROL_START_LSB     1
#define WLAN_GMBOX0_DMA_RX_CONTROL_START_MASK    0x00000002
#define WLAN_GMBOX0_DMA_RX_CONTROL_START_GET(x)  (((x) & WLAN_GMBOX0_DMA_RX_CONTROL_START_MASK) >> WLAN_GMBOX0_DMA_RX_CONTROL_START_LSB)
#define WLAN_GMBOX0_DMA_RX_CONTROL_START_SET(x)  (((x) << WLAN_GMBOX0_DMA_RX_CONTROL_START_LSB) & WLAN_GMBOX0_DMA_RX_CONTROL_START_MASK)
#define WLAN_GMBOX0_DMA_RX_CONTROL_STOP_MSB      0
#define WLAN_GMBOX0_DMA_RX_CONTROL_STOP_LSB      0
#define WLAN_GMBOX0_DMA_RX_CONTROL_STOP_MASK     0x00000001
#define WLAN_GMBOX0_DMA_RX_CONTROL_STOP_GET(x)   (((x) & WLAN_GMBOX0_DMA_RX_CONTROL_STOP_MASK) >> WLAN_GMBOX0_DMA_RX_CONTROL_STOP_LSB)
#define WLAN_GMBOX0_DMA_RX_CONTROL_STOP_SET(x)   (((x) << WLAN_GMBOX0_DMA_RX_CONTROL_STOP_LSB) & WLAN_GMBOX0_DMA_RX_CONTROL_STOP_MASK)

#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS 0x0000011c
#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_OFFSET 0x0000011c
#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MSB 27
#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB 2
#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK 0x0ffffffc
#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_GET(x) (((x) & WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK) >> WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB)
#define WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_SET(x) (((x) << WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_LSB) & WLAN_GMBOX0_DMA_TX_DESCRIPTOR_BASE_ADDRESS_MASK)

#define WLAN_GMBOX0_DMA_TX_CONTROL_ADDRESS       0x00000120
#define WLAN_GMBOX0_DMA_TX_CONTROL_OFFSET        0x00000120
#define WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_MSB    2
#define WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_LSB    2
#define WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_MASK   0x00000004
#define WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_GET(x) (((x) & WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_MASK) >> WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_LSB)
#define WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_SET(x) (((x) << WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_LSB) & WLAN_GMBOX0_DMA_TX_CONTROL_RESUME_MASK)
#define WLAN_GMBOX0_DMA_TX_CONTROL_START_MSB     1
#define WLAN_GMBOX0_DMA_TX_CONTROL_START_LSB     1
#define WLAN_GMBOX0_DMA_TX_CONTROL_START_MASK    0x00000002
#define WLAN_GMBOX0_DMA_TX_CONTROL_START_GET(x)  (((x) & WLAN_GMBOX0_DMA_TX_CONTROL_START_MASK) >> WLAN_GMBOX0_DMA_TX_CONTROL_START_LSB)
#define WLAN_GMBOX0_DMA_TX_CONTROL_START_SET(x)  (((x) << WLAN_GMBOX0_DMA_TX_CONTROL_START_LSB) & WLAN_GMBOX0_DMA_TX_CONTROL_START_MASK)
#define WLAN_GMBOX0_DMA_TX_CONTROL_STOP_MSB      0
#define WLAN_GMBOX0_DMA_TX_CONTROL_STOP_LSB      0
#define WLAN_GMBOX0_DMA_TX_CONTROL_STOP_MASK     0x00000001
#define WLAN_GMBOX0_DMA_TX_CONTROL_STOP_GET(x)   (((x) & WLAN_GMBOX0_DMA_TX_CONTROL_STOP_MASK) >> WLAN_GMBOX0_DMA_TX_CONTROL_STOP_LSB)
#define WLAN_GMBOX0_DMA_TX_CONTROL_STOP_SET(x)   (((x) << WLAN_GMBOX0_DMA_TX_CONTROL_STOP_LSB) & WLAN_GMBOX0_DMA_TX_CONTROL_STOP_MASK)

#define WLAN_GMBOX_INT_STATUS_ADDRESS            0x00000124
#define WLAN_GMBOX_INT_STATUS_OFFSET             0x00000124
#define WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_MSB    6
#define WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_LSB    6
#define WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_MASK   0x00000040
#define WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_MASK) >> WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_LSB)
#define WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_LSB) & WLAN_GMBOX_INT_STATUS_TX_OVERFLOW_MASK)
#define WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_MSB   5
#define WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_LSB   5
#define WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_MASK  0x00000020
#define WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_MASK) >> WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_LSB)
#define WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_LSB) & WLAN_GMBOX_INT_STATUS_RX_UNDERFLOW_MASK)
#define WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_MSB 4
#define WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_LSB 4
#define WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_MASK 0x00000010
#define WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_MASK) >> WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_LSB)
#define WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_LSB) & WLAN_GMBOX_INT_STATUS_RX_DMA_COMPLETE_MASK)
#define WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MSB 3
#define WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB 3
#define WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK 0x00000008
#define WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK) >> WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB)
#define WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_LSB) & WLAN_GMBOX_INT_STATUS_TX_DMA_EOM_COMPLETE_MASK)
#define WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_MSB 2
#define WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_LSB 2
#define WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_MASK 0x00000004
#define WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_MASK) >> WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_LSB)
#define WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_LSB) & WLAN_GMBOX_INT_STATUS_TX_DMA_COMPLETE_MASK)
#define WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_MSB   1
#define WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_LSB   1
#define WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_MASK  0x00000002
#define WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_MASK) >> WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_LSB)
#define WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_LSB) & WLAN_GMBOX_INT_STATUS_TX_NOT_EMPTY_MASK)
#define WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_MSB    0
#define WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_LSB    0
#define WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_MASK   0x00000001
#define WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_GET(x) (((x) & WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_MASK) >> WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_LSB)
#define WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_SET(x) (((x) << WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_LSB) & WLAN_GMBOX_INT_STATUS_RX_NOT_FULL_MASK)

#define WLAN_GMBOX_INT_ENABLE_ADDRESS            0x00000128
#define WLAN_GMBOX_INT_ENABLE_OFFSET             0x00000128
#define WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_MSB    6
#define WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_LSB    6
#define WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_MASK   0x00000040
#define WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_MASK) >> WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_LSB)
#define WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_LSB) & WLAN_GMBOX_INT_ENABLE_TX_OVERFLOW_MASK)
#define WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_MSB   5
#define WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_LSB   5
#define WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_MASK  0x00000020
#define WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_MASK) >> WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_LSB)
#define WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_LSB) & WLAN_GMBOX_INT_ENABLE_RX_UNDERFLOW_MASK)
#define WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_MSB 4
#define WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB 4
#define WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK 0x00000010
#define WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK) >> WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB)
#define WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_LSB) & WLAN_GMBOX_INT_ENABLE_RX_DMA_COMPLETE_MASK)
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MSB 3
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB 3
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK 0x00000008
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK) >> WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB)
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_LSB) & WLAN_GMBOX_INT_ENABLE_TX_DMA_EOM_COMPLETE_MASK)
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_MSB 2
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB 2
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK 0x00000004
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK) >> WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB)
#define WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_LSB) & WLAN_GMBOX_INT_ENABLE_TX_DMA_COMPLETE_MASK)
#define WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_MSB   1
#define WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_LSB   1
#define WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_MASK  0x00000002
#define WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_MASK) >> WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_LSB)
#define WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_LSB) & WLAN_GMBOX_INT_ENABLE_TX_NOT_EMPTY_MASK)
#define WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_MSB    0
#define WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_LSB    0
#define WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_MASK   0x00000001
#define WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_GET(x) (((x) & WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_MASK) >> WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_LSB)
#define WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_SET(x) (((x) << WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_LSB) & WLAN_GMBOX_INT_ENABLE_RX_NOT_FULL_MASK)

#define STE_MODE_ADDRESS                         0x0000012c
#define STE_MODE_OFFSET                          0x0000012c
#define STE_MODE_SPI_CTRL_EN_MSB                 6
#define STE_MODE_SPI_CTRL_EN_LSB                 6
#define STE_MODE_SPI_CTRL_EN_MASK                0x00000040
#define STE_MODE_SPI_CTRL_EN_GET(x)              (((x) & STE_MODE_SPI_CTRL_EN_MASK) >> STE_MODE_SPI_CTRL_EN_LSB)
#define STE_MODE_SPI_CTRL_EN_SET(x)              (((x) << STE_MODE_SPI_CTRL_EN_LSB) & STE_MODE_SPI_CTRL_EN_MASK)
#define STE_MODE_RST_MSB                         5
#define STE_MODE_RST_LSB                         5
#define STE_MODE_RST_MASK                        0x00000020
#define STE_MODE_RST_GET(x)                      (((x) & STE_MODE_RST_MASK) >> STE_MODE_RST_LSB)
#define STE_MODE_RST_SET(x)                      (((x) << STE_MODE_RST_LSB) & STE_MODE_RST_MASK)
#define STE_MODE_SWAP_MSB                        4
#define STE_MODE_SWAP_LSB                        4
#define STE_MODE_SWAP_MASK                       0x00000010
#define STE_MODE_SWAP_GET(x)                     (((x) & STE_MODE_SWAP_MASK) >> STE_MODE_SWAP_LSB)
#define STE_MODE_SWAP_SET(x)                     (((x) << STE_MODE_SWAP_LSB) & STE_MODE_SWAP_MASK)
#define STE_MODE_SEL_16BIT_MSB                   3
#define STE_MODE_SEL_16BIT_LSB                   3
#define STE_MODE_SEL_16BIT_MASK                  0x00000008
#define STE_MODE_SEL_16BIT_GET(x)                (((x) & STE_MODE_SEL_16BIT_MASK) >> STE_MODE_SEL_16BIT_LSB)
#define STE_MODE_SEL_16BIT_SET(x)                (((x) << STE_MODE_SEL_16BIT_LSB) & STE_MODE_SEL_16BIT_MASK)
#define STE_MODE_PHA_POL_MSB                     2
#define STE_MODE_PHA_POL_LSB                     1
#define STE_MODE_PHA_POL_MASK                    0x00000006
#define STE_MODE_PHA_POL_GET(x)                  (((x) & STE_MODE_PHA_POL_MASK) >> STE_MODE_PHA_POL_LSB)
#define STE_MODE_PHA_POL_SET(x)                  (((x) << STE_MODE_PHA_POL_LSB) & STE_MODE_PHA_POL_MASK)
#define STE_MODE_SEL_MSB                         0
#define STE_MODE_SEL_LSB                         0
#define STE_MODE_SEL_MASK                        0x00000001
#define STE_MODE_SEL_GET(x)                      (((x) & STE_MODE_SEL_MASK) >> STE_MODE_SEL_LSB)
#define STE_MODE_SEL_SET(x)                      (((x) << STE_MODE_SEL_LSB) & STE_MODE_SEL_MASK)

#define WLAN_HOST_IF_WINDOW_ADDRESS              0x00002000
#define WLAN_HOST_IF_WINDOW_OFFSET               0x00002000
#define WLAN_HOST_IF_WINDOW_DATA_MSB             7
#define WLAN_HOST_IF_WINDOW_DATA_LSB             0
#define WLAN_HOST_IF_WINDOW_DATA_MASK            0x000000ff
#define WLAN_HOST_IF_WINDOW_DATA_GET(x)          (((x) & WLAN_HOST_IF_WINDOW_DATA_MASK) >> WLAN_HOST_IF_WINDOW_DATA_LSB)
#define WLAN_HOST_IF_WINDOW_DATA_SET(x)          (((x) << WLAN_HOST_IF_WINDOW_DATA_LSB) & WLAN_HOST_IF_WINDOW_DATA_MASK)


#ifndef __ASSEMBLER__

typedef struct mbox_wlan_reg_reg_s {
  volatile unsigned int wlan_mbox_fifo[4];
  volatile unsigned int wlan_mbox_fifo_status;
  volatile unsigned int wlan_mbox_dma_policy;
  volatile unsigned int wlan_mbox0_dma_rx_descriptor_base;
  volatile unsigned int wlan_mbox0_dma_rx_control;
  volatile unsigned int wlan_mbox0_dma_tx_descriptor_base;
  volatile unsigned int wlan_mbox0_dma_tx_control;
  volatile unsigned int wlan_mbox1_dma_rx_descriptor_base;
  volatile unsigned int wlan_mbox1_dma_rx_control;
  volatile unsigned int wlan_mbox1_dma_tx_descriptor_base;
  volatile unsigned int wlan_mbox1_dma_tx_control;
  volatile unsigned int wlan_mbox2_dma_rx_descriptor_base;
  volatile unsigned int wlan_mbox2_dma_rx_control;
  volatile unsigned int wlan_mbox2_dma_tx_descriptor_base;
  volatile unsigned int wlan_mbox2_dma_tx_control;
  volatile unsigned int wlan_mbox3_dma_rx_descriptor_base;
  volatile unsigned int wlan_mbox3_dma_rx_control;
  volatile unsigned int wlan_mbox3_dma_tx_descriptor_base;
  volatile unsigned int wlan_mbox3_dma_tx_control;
  volatile unsigned int wlan_mbox_int_status;
  volatile unsigned int wlan_mbox_int_enable;
  volatile unsigned int wlan_int_host;
  unsigned char pad0[28]; /* pad to 0x80 */
  volatile unsigned int wlan_local_count[8];
  volatile unsigned int wlan_count_inc[8];
  volatile unsigned int wlan_local_scratch[8];
  volatile unsigned int wlan_use_local_bus;
  volatile unsigned int wlan_sdio_config;
  volatile unsigned int wlan_mbox_debug;
  volatile unsigned int wlan_mbox_fifo_reset;
  volatile unsigned int wlan_mbox_txfifo_pop[4];
  volatile unsigned int wlan_mbox_rxfifo_pop[4];
  volatile unsigned int wlan_sdio_debug;
  volatile unsigned int wlan_gmbox0_dma_rx_descriptor_base;
  volatile unsigned int wlan_gmbox0_dma_rx_control;
  volatile unsigned int wlan_gmbox0_dma_tx_descriptor_base;
  volatile unsigned int wlan_gmbox0_dma_tx_control;
  volatile unsigned int wlan_gmbox_int_status;
  volatile unsigned int wlan_gmbox_int_enable;
  volatile unsigned int ste_mode;
  unsigned char pad1[7888]; /* pad to 0x2000 */
  volatile unsigned int wlan_host_if_window[2048];
} mbox_wlan_reg_reg_t;

#endif /* __ASSEMBLER__ */

#endif /* _MBOX_WLAN_REG_H_ */
