static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2008 Hans Petter Jansson <hpj@copyleft.no>                       \n"
" *           2012 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_int  (red_levels, _(\"Red levels\"), 6)                              \n"
"    description(_(\"Number of levels for red channel\"))                      \n"
"    value_range (2, 65536)                                                    \n"
"    ui_gamma (3.0)                                                            \n"
"                                                                              \n"
"property_int  (green_levels, _(\"Green levels\"), 7)                          \n"
"    description(_(\"Number of levels for green channel\"))                    \n"
"    value_range (2, 65536)                                                    \n"
"    ui_gamma (3.0)                                                            \n"
"                                                                              \n"
"property_int  (blue_levels, _(\"Blue levels\"), 6)                            \n"
"    description(_(\"Number of levels for blue channel\"))                     \n"
"    value_range (2, 65536)                                                    \n"
"    ui_gamma (3.0)                                                            \n"
"                                                                              \n"
"property_int  (alpha_levels, _(\"Alpha levels\"), 256)                        \n"
"    description(_(\"Number of levels for alpha channel\"))                    \n"
"    value_range (2, 65536)                                                    \n"
"    ui_gamma (3.0)                                                            \n"
"                                                                              \n"
"property_enum (dither_method, _(\"Dithering method\"),                        \n"
"               GeglDitherMethod, gegl_dither_method, GEGL_DITHER_FLOYD_STEINBERG)\n"
"    description (_(\"The dithering method to use\"))                          \n"
"                                                                              \n"
"property_seed (seed, _(\"Random seed\"), rand)                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_FILTER                                                        \n"
"#define GEGL_OP_NAME     dither                                               \n"
"#define GEGL_OP_C_SOURCE dither.c                                             \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#define REDUCE_16B(value) (((value) & ((1 << 17) - 1)) - 65536)               \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"R'G'B'A u16\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A u16\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static inline guint                                                           \n"
"quantize_value (guint value,                                                  \n"
"                guint n_levels)                                               \n"
"{                                                                             \n"
"  float recip = 65535.0 / n_levels;                                           \n"
"  return floorf (value / recip) * recip;                                      \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_floyd_steinberg (GeglBuffer          *input,                          \n"
"                         GeglBuffer          *output,                         \n"
"                         const GeglRectangle *result,                         \n"
"                         guint               *channel_levels)                 \n"
"{                                                                             \n"
"  GeglRectangle  line_rect;                                                   \n"
"  guint16       *line_buf;                                                    \n"
"  gdouble       *error_buf [2];                                               \n"
"  gint           y;                                                           \n"
"                                                                              \n"
"  line_rect.x      = result->x;                                               \n"
"  line_rect.y      = result->y;                                               \n"
"  line_rect.width  = result->width;                                           \n"
"  line_rect.height = 1;                                                       \n"
"                                                                              \n"
"  line_buf      = g_new  (guint16, line_rect.width * 4);                      \n"
"  error_buf [0] = g_new0 (gdouble, line_rect.width * 4);                      \n"
"  error_buf [1] = g_new0 (gdouble, line_rect.width * 4);                      \n"
"                                                                              \n"
"  for (y = 0; y < result->height; y++)                                        \n"
"    {                                                                         \n"
"      gdouble  *error_buf_swap;                                               \n"
"      gint      step;                                                         \n"
"      gint      start_x;                                                      \n"
"      gint      end_x;                                                        \n"
"      gint      x;                                                            \n"
"                                                                              \n"
"      /* Serpentine scanning; reverse direction every row */                  \n"
"                                                                              \n"
"      if (y & 1)                                                              \n"
"        {                                                                     \n"
"          start_x = result->width - 1;                                        \n"
"          end_x   = -1;                                                       \n"
"          step    = -1;                                                       \n"
"        }                                                                     \n"
"      else                                                                    \n"
"        {                                                                     \n"
"          start_x = 0;                                                        \n"
"          end_x   = result->width;                                            \n"
"          step    = 1;                                                        \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* Pull input row */                                                    \n"
"                                                                              \n"
"      gegl_buffer_get (input, &line_rect, 1.0, babl_format (\"R'G'B'A u16\"), line_buf,\n"
"                       GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                 \n"
"                                                                              \n"
"      /* Process the row */                                                   \n"
"                                                                              \n"
"      for (x = start_x; x != end_x; x += step)                                \n"
"        {                                                                     \n"
"          guint16  *pixel = &line_buf [x * 4];                                \n"
"          guint     ch;                                                       \n"
"                                                                              \n"
"          for (ch = 0; ch < 4; ch++)                                          \n"
"            {                                                                 \n"
"              gdouble value;                                                  \n"
"              gdouble value_clamped;                                          \n"
"              gdouble quantized;                                              \n"
"              gdouble qerror;                                                 \n"
"                                                                              \n"
"              value         = pixel [ch] + error_buf [0] [x * 4 + ch];        \n"
"              value_clamped = CLAMP (value, 0.0, 65535.0);                    \n"
"              quantized     = quantize_value ((guint) (value_clamped + 0.5 * 65536 / channel_levels[ch] ), channel_levels [ch]);\n"
"              qerror        = value - quantized;                              \n"
"                                                                              \n"
"              pixel [ch] = (guint16) quantized;                               \n"
"                                                                              \n"
"              /* Distribute the error */                                      \n"
"                                                                              \n"
"              error_buf [1] [x * 4 + ch] += qerror * 5.0 / 16.0;  /* Down */  \n"
"                                                                              \n"
"              if (x + step >= 0 && x + step < result->width)                  \n"
"                {                                                             \n"
"                  error_buf [0] [(x + step) * 4 + ch] += qerror * 6.0 / 16.0;  /* Ahead */\n"
"                  error_buf [1] [(x + step) * 4 + ch] += qerror * 1.0 / 16.0;  /* Down, ahead */\n"
"                }                                                             \n"
"                                                                              \n"
"              if (x - step >= 0 && x - step < result->width)                  \n"
"                {                                                             \n"
"                  error_buf [1] [(x - step) * 4 + ch] += qerror * 3.0 / 16.0;  /* Down, behind */\n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"      /* Swap error accumulation rows */                                      \n"
"                                                                              \n"
"      error_buf_swap = error_buf [0];                                         \n"
"      error_buf [0]  = error_buf [1];                                         \n"
"      error_buf [1]  = error_buf_swap;                                        \n"
"                                                                              \n"
"      /* Clear error buffer for next-plus-one line */                         \n"
"                                                                              \n"
"      memset (error_buf [1], 0, line_rect.width * 4 * sizeof (gdouble));      \n"
"                                                                              \n"
"      /* Push output row */                                                   \n"
"                                                                              \n"
"      gegl_buffer_set (output, &line_rect, 0, babl_format (\"R'G'B'A u16\"), line_buf, GEGL_AUTO_ROWSTRIDE);\n"
"      line_rect.y++;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  g_free (line_buf);                                                          \n"
"  g_free (error_buf [0]);                                                     \n"
"  g_free (error_buf [1]);                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static const gdouble bayer_matrix_8x8 [] =                                    \n"
"{                                                                             \n"
"   1, 49, 13, 61,  4, 52, 16, 64,                                             \n"
"  33, 17, 45, 29, 36, 20, 48, 32,                                             \n"
"   9, 57,  5, 53, 12, 60,  8, 56,                                             \n"
"  41, 25, 37, 21, 44, 28, 40, 24,                                             \n"
"   3, 51, 15, 63,  2, 50, 14, 62,                                             \n"
"  35, 19, 47, 31, 34, 18, 46, 30,                                             \n"
"  11, 59,  7, 55, 10, 58,  6, 54,                                             \n"
"  43, 27, 39, 23, 42, 26, 38, 22                                              \n"
"};                                                                            \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_bayer (GeglBufferIterator *gi,                                    \n"
"                   guint               channel_levels [4],                    \n"
"                   gint                y)                                     \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"                                                                              \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gdouble bayer;                                                      \n"
"          gdouble value;                                                      \n"
"          gdouble value_clamped;                                              \n"
"          gdouble quantized;                                                  \n"
"                                                                              \n"
"          bayer         = bayer_matrix_8x8 [((gi->roi->y + y) % 8) * 8 + ((gi->roi->x + x) % 8)];\n"
"          bayer         = ((bayer - 32) * 65536.0 / 65.0) / channel_levels [ch];\n"
"          value         = data_in [pixel + ch] + bayer;                       \n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_arithmetic_add (GeglBufferIterator *gi,                           \n"
"                            guint               channel_levels [4],           \n"
"                            gint                y)                            \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"                                                                              \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gint u = gi->roi->x + x;                                            \n"
"          gint v = gi->roi->y + y;                                            \n"
"          gfloat mask;                                                        \n"
"          gfloat value;                                                       \n"
"          gfloat value_clamped;                                               \n"
"          gfloat quantized;                                                   \n"
"          mask         = (((u+ch * 67) + v * 236) * 119) & 255;               \n"
"          mask         = ((mask - 128) * 65536.0 / 256.0) / channel_levels [ch];\n"
"          value         = data_in [pixel + ch] + mask;                        \n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_arithmetic_xor (GeglBufferIterator *gi,                           \n"
"                            guint               channel_levels [4],           \n"
"                            gint                y)                            \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"                                                                              \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gint u = gi->roi->x + x;                                            \n"
"          gint v = gi->roi->y + y;                                            \n"
"          gfloat mask;                                                        \n"
"          gfloat value;                                                       \n"
"          gfloat value_clamped;                                               \n"
"          gfloat quantized;                                                   \n"
"          mask         = (((u+ch * 17) ^ v * 149) * 1234) & 511;              \n"
"          mask         = ((mask - 257) * 65536.0 / 512.0) / channel_levels [ch];\n"
"          value         = data_in [pixel + ch] + mask;                        \n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_arithmetic_add_covariant (GeglBufferIterator *gi,                 \n"
"                                      guint               channel_levels [4], \n"
"                                      gint                y)                  \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"                                                                              \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gint u = gi->roi->x + x;                                            \n"
"          gint v = gi->roi->y + y;                                            \n"
"          gfloat mask;                                                        \n"
"          gfloat value;                                                       \n"
"          gfloat value_clamped;                                               \n"
"          gfloat quantized;                                                   \n"
"          mask         = ((u+ v * 236) * 119) & 255;                          \n"
"          mask         = ((mask - 128) * 65536.0 / 256.0) / channel_levels [ch];\n"
"          value         = data_in [pixel + ch] + mask;                        \n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_arithmetic_xor_covariant (GeglBufferIterator *gi,                 \n"
"                                      guint               channel_levels [4], \n"
"                                      gint                y)                  \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"                                                                              \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gint u = gi->roi->x + x;                                            \n"
"          gint v = gi->roi->y + y;                                            \n"
"          gfloat mask;                                                        \n"
"          gfloat value;                                                       \n"
"          gfloat value_clamped;                                               \n"
"          gfloat quantized;                                                   \n"
"          mask         = ((u ^ v * 149) * 1234) & 511;                        \n"
"          mask         = ((mask - 257) * 65536.0 / 512.0) / channel_levels [ch];\n"
"          value         = data_in [pixel + ch] + mask;                        \n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_random_covariant (GeglBufferIterator *gi,                         \n"
"                              guint               channel_levels [4],         \n"
"                              gint                y,                          \n"
"                              GeglRandom         *rand)                       \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"      gint  r = REDUCE_16B (gegl_random_int (rand, gi->roi->x + x,            \n"
"                                             gi->roi->y + y, 0, 0)) - (1<<15);\n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gfloat value;                                                       \n"
"          gfloat value_clamped;                                               \n"
"          gfloat quantized;                                                   \n"
"                                                                              \n"
"          value         = data_in [pixel + ch] + (r * 1.0) / channel_levels [ch];\n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_random (GeglBufferIterator *gi,                                   \n"
"                    guint               channel_levels [4],                   \n"
"                    gint                y,                                    \n"
"                    GeglRandom         *rand)                                 \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          gdouble value;                                                      \n"
"          gdouble value_clamped;                                              \n"
"          gdouble quantized;                                                  \n"
"          gint    r = REDUCE_16B (gegl_random_int (rand, gi->roi->x + x,      \n"
"                                                   gi->roi->y + y, 0, ch)) - (1<<15);\n"
"                                                                              \n"
"          value         = data_in [pixel + ch] + (r * 1.0) / channel_levels [ch];\n"
"          value_clamped = CLAMP (value, 0.0, 65535.0);                        \n"
"          quantized     = quantize_value ((guint) (value_clamped + 65536 * 0.5 / channel_levels[ch] ),\n"
"                                          channel_levels [ch]);               \n"
"                                                                              \n"
"          data_out [pixel + ch] = (guint16) quantized;                        \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void inline                                                            \n"
"process_row_no_dither (GeglBufferIterator *gi,                                \n"
"                       guint               channel_levels [4],                \n"
"                       guint               y)                                 \n"
"{                                                                             \n"
"  guint16 *data_in  = (guint16*) gi->data [0];                                \n"
"  guint16 *data_out = (guint16*) gi->data [1];                                \n"
"  guint x;                                                                    \n"
"  for (x = 0; x < gi->roi->width; x++)                                        \n"
"    {                                                                         \n"
"      guint pixel = 4 * (gi->roi->width * y + x);                             \n"
"      guint ch;                                                               \n"
"      for (ch = 0; ch < 4; ch++)                                              \n"
"        {                                                                     \n"
"          data_out [pixel + ch] = (guint16)                                   \n"
"             quantize_value ((guint) (data_in[pixel + ch] + 65536 * 0.5 / channel_levels[ch] ),\n"
"                             channel_levels [ch]);                            \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"process_standard (GeglBuffer          *input,                                 \n"
"                  GeglBuffer          *output,                                \n"
"                  const GeglRectangle *result,                                \n"
"                  guint               *channel_levels,                        \n"
"                  GeglRandom          *rand,                                  \n"
"                  GeglDitherMethod     dither_method)                         \n"
"{                                                                             \n"
"  GeglBufferIterator *gi;                                                     \n"
"                                                                              \n"
"  gi = gegl_buffer_iterator_new (input, result, 0, babl_format (\"R'G'B'A u16\"),\n"
"                                 GEGL_ACCESS_READ, GEGL_ABYSS_NONE);          \n"
"                                                                              \n"
"  gegl_buffer_iterator_add (gi, output, result, 0, babl_format (\"R'G'B'A u16\"),\n"
"                            GEGL_ACCESS_WRITE, GEGL_ABYSS_NONE);              \n"
"                                                                              \n"
"  while (gegl_buffer_iterator_next (gi))                                      \n"
"    {                                                                         \n"
"      guint    y;                                                             \n"
"      switch (dither_method)                                                  \n"
"        {                                                                     \n"
"          case GEGL_DITHER_NONE:                                              \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_no_dither (gi, channel_levels, y);                  \n"
"            break;                                                            \n"
"          case GEGL_DITHER_RANDOM:                                            \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_random (gi, channel_levels, y, rand);               \n"
"            break;                                                            \n"
"          case GEGL_DITHER_RANDOM_COVARIANT:                                  \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_random_covariant (gi, channel_levels, y, rand);     \n"
"             break;                                                           \n"
"          case GEGL_DITHER_BAYER:                                             \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_bayer (gi, channel_levels, y);                      \n"
"            break;                                                            \n"
"          case GEGL_DITHER_FLOYD_STEINBERG:                                   \n"
"            /* Done separately */                                             \n"
"            break;                                                            \n"
"          case GEGL_DITHER_ARITHMETIC_ADD:                                    \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_arithmetic_add (gi, channel_levels, y);             \n"
"            break;                                                            \n"
"          case GEGL_DITHER_ARITHMETIC_XOR:                                    \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_arithmetic_xor (gi, channel_levels, y);             \n"
"            break;                                                            \n"
"          case GEGL_DITHER_ARITHMETIC_ADD_COVARIANT:                          \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_arithmetic_add_covariant (gi, channel_levels, y);   \n"
"            break;                                                            \n"
"          case GEGL_DITHER_ARITHMETIC_XOR_COVARIANT:                          \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_arithmetic_xor_covariant (gi, channel_levels, y);   \n"
"            break;                                                            \n"
"          default:                                                            \n"
"            for (y = 0; y < gi->roi->height; y++)                             \n"
"              process_row_no_dither (gi, channel_levels, y);                  \n"
"        }                                                                     \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_required_for_output (GeglOperation       *self,                           \n"
"                         const gchar         *input_pad,                      \n"
"                         const GeglRectangle *roi)                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (self);                                 \n"
"                                                                              \n"
"  if (o->dither_method == GEGL_DITHER_FLOYD_STEINBERG)                        \n"
"    return *gegl_operation_source_get_bounding_box (self, \"input\");         \n"
"  else                                                                        \n"
"    return *roi;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *self,                                 \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (self);                                 \n"
"                                                                              \n"
"  if (o->dither_method == GEGL_DITHER_FLOYD_STEINBERG)                        \n"
"    return *gegl_operation_source_get_bounding_box (self, \"input\");         \n"
"  else                                                                        \n"
"    return *roi;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  guint       channel_levels [4];                                             \n"
"                                                                              \n"
"  channel_levels [0] = o->red_levels;                                         \n"
"  channel_levels [1] = o->green_levels;                                       \n"
"  channel_levels [2] = o->blue_levels;                                        \n"
"  channel_levels [3] = o->alpha_levels;                                       \n"
"                                                                              \n"
"  if (o->dither_method != GEGL_DITHER_FLOYD_STEINBERG)                        \n"
"    process_standard (input, output, result, channel_levels,                  \n"
"                      o->rand, o->dither_method);                             \n"
"  else                                                                        \n"
"    process_floyd_steinberg (input, output, result, channel_levels);          \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"  gchar                    *composition = \"<?xml version='1.0' encoding='UTF-8'?>\"\n"
"    \"<gegl>\"                                                                \n"
"    \"<node operation='gegl:color-reduction'>\"                               \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='red-levels'>4</param>\"                                \n"
"    \"    <param name='green-levels'>4</param>\"                              \n"
"    \"    <param name='blue-levels'>4</param>\"                               \n"
"    \"    <param name='alpha-levels'>4</param>\"                              \n"
"    \"    <param name='dither-method'>floyd-steinberg</param>\"               \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"<node operation='gegl:load'>\"                                          \n"
"    \"  <params>\"                                                            \n"
"    \"    <param name='path'>standard-input.png</param>\"                     \n"
"    \"  </params>\"                                                           \n"
"    \"</node>\"                                                               \n"
"    \"</gegl>\";                                                              \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_required_for_output = get_required_for_output;         \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  filter_class->process = process;                                            \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:dither\",                                         \n"
"    \"compat-name\", \"gegl:color-reduction\",                                \n"
"    \"title\",       _(\"Dither\"),                                           \n"
"    \"categories\",  \"dither\",                                              \n"
"    \"reference-hash\", \"eb9e2dc74369d32d195b2ed5c4acde44\",                 \n"
"    \"description\", _(\"Reduce the number of colors in the image, by reducing \"\n"
"                     \"the levels per channel (colors and alpha). Different dithering methods \"\n"
"                     \"can be specified to counteract quantization induced banding.\"),\n"
"    \"reference-composition\", composition,                                   \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
