static const char* color_to_alpha_cl_source =
"__kernel void cl_color_to_alpha(__global const float4 *in,                    \n"
"                                __global       float4 *out,                   \n"
"                                float4                color)                  \n"
"{                                                                             \n"
"  int gid = get_global_id(0);                                                 \n"
"  float4 in_v = in[gid];                                                      \n"
"  float4 out_v = in_v;                                                        \n"
"  float4 alpha;                                                               \n"
"                                                                              \n"
"  alpha.w = in_v.w;                                                           \n"
"                                                                              \n"
"  /*First component*/                                                         \n"
"  if ( color.x < 0.00001f )                                                   \n"
"    alpha.x = in_v.x;                                                         \n"
"  else if ( in_v.x > color.x + 0.00001f )                                     \n"
"    alpha.x = (in_v.x - color.x) / (1.0f - color.x);                          \n"
"  else if ( in_v.x < color.x - 0.00001f )                                     \n"
"    alpha.x = (color.x - in_v.x) / color.x;                                   \n"
"  else                                                                        \n"
"    alpha.x = 0.0f;                                                           \n"
"  /*Second component*/                                                        \n"
"  if ( color.y < 0.00001f )                                                   \n"
"    alpha.y = in_v.y;                                                         \n"
"  else if ( in_v.y > color.y + 0.00001f )                                     \n"
"    alpha.y = (in_v.y - color.y) / (1.0f - color.y);                          \n"
"  else if ( in_v.y < color.y - 0.00001f )                                     \n"
"    alpha.y = (color.y - in_v.y) / color.y;                                   \n"
"  else                                                                        \n"
"    alpha.y = 0.0f;                                                           \n"
"  /*Third component*/                                                         \n"
"  if ( color.z < 0.00001f )                                                   \n"
"    alpha.z = in_v.z;                                                         \n"
"  else if ( in_v.z > color.z + 0.00001f )                                     \n"
"    alpha.z = (in_v.z - color.z) / (1.0f - color.z);                          \n"
"  else if ( in_v.z < color.z - 0.00001f )                                     \n"
"    alpha.z = (color.z - in_v.z) / color.z;                                   \n"
"  else                                                                        \n"
"    alpha.z = 0.0f;                                                           \n"
"                                                                              \n"
"  if (alpha.x > alpha.y)                                                      \n"
"    {                                                                         \n"
"      if (alpha.x > alpha.z)                                                  \n"
"        out_v.w = alpha.x;                                                    \n"
"      else                                                                    \n"
"        out_v.w = alpha.z;                                                    \n"
"    }                                                                         \n"
"  else if (alpha.y > alpha.z)                                                 \n"
"    {                                                                         \n"
"      out_v.w = alpha.y;                                                      \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      out_v.w = alpha.z;                                                      \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (out_v.w >= 0.00001f)                                                    \n"
"    {                                                                         \n"
"      out_v.xyz = (out_v.xyz - color.xyz) / out_v.www + color.xyz;            \n"
"      out_v.w *= alpha.w;                                                     \n"
"    }                                                                         \n"
"                                                                              \n"
"    out[gid] = out_v;                                                         \n"
"}                                                                             \n"
;
