i3(1)
=====
Michael Stapelberg <michael+i3@stapelberg.de>
v3.epsilon, March 2010

== NAME

i3 - an improved dynamic, tiling window manager

== SYNOPSIS

i3 [-a] [-c configfile] [-C] [-d <loglevel>] [-v] [-V]

== OPTIONS

-a::
Disables autostart.

-c::
Specifies an alternate configuration file path.

-C::
Check the configuration file for validity and exit.

-d::
Specifies the debug loglevel. To see the most output, use -d all.

-v::
Display version number (and date of the last commit).

-V::
Be verbose.

== DESCRIPTION

=== INTRODUCTION

i3 was created because wmii, our favorite window manager at the time, didn’t
provide some features we wanted (multi-monitor done right, for example), had
some bugs, didn’t progress since quite some time and wasn’t easy to hack at all
(source code comments/documentation completely lacking). Still, we think the
wmii developers and contributors did a great job. Thank you for inspiring us to
create i3.

Please be aware that i3 is primarily targeted at advanced users and developers.

=== IMPORTANT NOTE TO nVidia BINARY DRIVER USERS

If you are using the nVidia binary graphics driver (also known as 'blob')
you need to use the +--force-xinerama+ flag (in your .xsession) when starting
i3, like so:

----------------------------------------------
exec i3 --force-xinerama -V >>~/.i3/i3log 2>&1
----------------------------------------------

See also docs/multi-monitor for the full explanation.

=== TERMINOLOGY

Client::
A client is X11-speak for a window.

Table::
Your workspace is managed using a table. You can move windows around and create
new columns (move a client to the right) or rows (move it to the bottom)
implicitly.
+
By "snapping" a client in a specific direction, you increase its colspan/rowspan.

Container::
A container contains a variable number of clients. Each cell of the table is a
container.
+
Containers can be used in various modes. The default mode is called "default"
and just resizes each client equally so that it fits.

Workspace::
A workspace is a set of clients (technically speaking, it’s just a table).
Other window managers call this "Virtual Desktops".
+
In i3, each workspace is assigned to a specific virtual screen. By default,
screen 1 has workspace 1, screen 2 has workspace 2 and so on… However, when you
create a new workspace (by simply switching to it), it’ll be assigned the
screen you are currently on.

Output::
Using XRandR, you can have an X11 screen spanning multiple real monitors.
Furthermore, you can set them up in cloning mode or with positions (monitor 1
is left of monitor 2).
+
i3 uses the RandR API to query which outputs are available and which screens
are connected to these outputs.

== KEYBINDINGS

Here is a short overview of the default keybindings:

j/k/l/;::
Direction keys (left, down, up, right). They are on your homerow (see the mark
on your "j" key). Alternatively, you can use the cursor keys.

Mod1+<direction>::
Focus window in <direction>.

Mod3+<direction>::
Focus container in <direction>.

Mod1+Shift+<direction>::
Move window to <direction>.

Mod3+Shift+<direction>::
Move container to <direction>.

Mod1+Control+<direction>::
Snap container to <direction>.

Mod1+<number>::
Switch to workspace <number>.

Mod1+Shift+<number>::
Move window to workspace <number>.

Mod1+f::
Toggle fullscreen mode.

Mod1+h::
Enable stacking layout for the current container.

Mod1+e::
Enable default layout for the current container.

Mod1+Shift+Space::
Toggle tiling/floating for the current window.

Mod1+t::
Select the first tiling window if the current window is floating and vice-versa.

Mod1+Shift+q::
Kills the current window. This is equivalent to "clicking on the close button",
meaning a polite request to the application to close this window. For example,
Firefox will save its session upon such a request. If the application does not
support that, the window will be killed and it depends on the application what
happens.

Mod1+Shift+r::
Restarts i3 in place (without losing any windows, but at this time, the layout
and placement of windows is not retained).

Mod1+Shift+e::
Exits i3.

== FILES

=== \~/.i3/config (or ~/.config/i3/config)

When starting, i3 looks for configuration files in the following order:

1. ~/.config/i3/config (or $XDG_CONFIG_HOME/i3/config if set)
2. /etc/xdg/i3/config (or $XDG_CONFIG_DIRS/i3/config if set)
3. ~/.i3/config
4. /etc/i3/config

You can specify a custom path using the -c option.

.Sample configuration
-------------------------------------------------------------
font -misc-fixed-medium-r-normal--13-120-75-75-C-70-iso10646-1

# Start terminal (Mod1+Enter)
bind Mod1+36 exec /usr/bin/urxvt

# Start dmenu (Mod1+v)
bind Mod1+55 exec /usr/bin/dmenu_run

# Kill current client (Mod1+Shift+q)
bind Mod1+Shift+24 kill

# Beamer on/off
bind Mod1+73 exec /home/michael/toggle_beamer.sh

# Screen locking
bind Mod1+68 exec /usr/bin/i3lock

# Restart i3 inplace (Mod1+Shift+r)
bind Mod1+Shift+27 restart

# Exit i3 (Mod1+Shift+e)
bind Mod1+Shift+26 exit

# Brightness
bind Mod1+97 exec sudo sh -c "echo up > /proc/acpi/ibm/brightness"
bind Mod1+103 exec sudo sh -c "echo down > /proc/acpi/ibm/brightness"

# Fullscreen (Mod1+f)
bind Mod1+41 f

# Stacking (Mod1+h)
bind Mod1+43 s

# Default (Mod1+e)
bind Mod1+26 d

# Toggle tiling/floating of the current window (Mod1+Shift+Space)
bind Mod1+Shift+65 t

# Go into the tiling layer / floating layer, depending on whether
# the current window is tiling / floating (Mod1+t)
bind Mod1+28 focus ft

# Focus (Mod1+j/k/l/;)
bind Mod1+44 h
bind Mod1+45 j
bind Mod1+46 k
bind Mod1+47 l

# Focus Container (Mod3+j/k/l/;)
bind Mod3+44 wch
bind Mod3+45 wcj
bind Mod3+46 wck
bind Mod3+47 wcl

# Snap (Mod1+Control+j/k/l/;)
bind Mod1+Control+44 sh
bind Mod1+Control+45 sj
bind Mod1+Control+46 sk
bind Mod1+Control+47 sl

# Move (Mod1+Shift+j/k/l/;)
bind Mod1+Shift+44 mh
bind Mod1+Shift+45 mj
bind Mod1+Shift+46 mk
bind Mod1+Shift+47 ml

# Move Container (Mod3+Shift+j/k/l/;)
bind Mod3+Shift+44 wcmh
bind Mod3+Shift+45 wcmj
bind Mod3+Shift+46 wcmk
bind Mod3+Shift+47 wcml

# Workspaces
bind Mod1+10 1
bind Mod1+11 2
...

# Move to Workspace
bind Mod1+Shift+10 1
bind Mod1+Shift+11 2
...
-------------------------------------------------------------

=== ~/.xsession

This file is where you should configure your locales and start i3. It is run by
your login manager (xdm, slim, gdm, …) as soon as you login.

.Sample xsession
-------------------------------------------------------------
# Disable DPMS turning off the screen
xset dpms force on
xset s off

# Disable bell
xset -b

# Enable zapping (C-A-<Bksp> kills X)
setxkbmap -option terminate:ctrl_alt_bksp

# Enforce correct locales from the beginning
unset LC_COLLATE
export LC_CTYPE=de_DE.UTF-8
export LC_TIME=de_DE.UTF-8
export LC_NUMERIC=de_DE.UTF-8
export LC_MONETARY=de_DE.UTF-8
export LC_MESSAGES=C
export LC_PAPER=de_DE.UTF-8
export LC_NAME=de_DE.UTF-8
export LC_ADDRESS=de_DE.UTF-8
export LC_TELEPHONE=de_DE.UTF-8
export LC_MEASUREMENT=de_DE.UTF-8
export LC_IDENTIFICATION=de_DE.UTF-8

# Use XToolkit in java applications
export AWT_TOOLKIT=XToolkit

# Set background color
xsetroot -solid "#333333"

# Enable core dumps in case something goes wrong
ulimit -c unlimited

# Start i3 and log to ~/.i3/logfile
echo "Starting at $(date)" >> ~/.i3/logfile
exec /usr/bin/i3 -V -d all >> ~/.i3/logfile
-------------------------------------------------------------

== TODO

There is still lot of work to do. Please check our bugtracker for up-to-date
information about tasks which are still not finished.

== SEE ALSO

You should have a copy of the userguide (featuring nice screenshots/graphics
which is why this is not integrated into this manpage), the debugging guide,
and the "how to hack" guide. If you are building from source, run:
 +make -C docs+

You can also access these documents online at http://i3.zekjur.net/

i3-input(1), i3-msg(1), i3-wsbar(1)

== AUTHOR

Michael Stapelberg and contributors
