/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceInternal;

import com.zeroc.Ice.ConnectionInfo;
import com.zeroc.Ice.DatagramLimitException;
import com.zeroc.Ice.LocalException;
import com.zeroc.Ice.SocketException;
import com.zeroc.Ice.UDPConnectionInfo;
import com.zeroc.IceInternal.BufSizeWarnInfo;
import com.zeroc.IceInternal.Buffer;
import com.zeroc.IceInternal.EndpointI;
import com.zeroc.IceInternal.Network;
import com.zeroc.IceInternal.ProtocolInstance;
import com.zeroc.IceInternal.ReadyCallback;
import com.zeroc.IceInternal.Transceiver;
import com.zeroc.IceUtilInternal.Assert;
import com.zeroc.IceUtilInternal.StringUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.nio.channels.SelectableChannel;
import java.util.LinkedList;
import java.util.List;

final class UdpMulticastClientTransceiver
implements Transceiver {
    private ProtocolInstance _instance;
    private InetSocketAddress _addr;
    private String _mcastInterface;
    private MulticastSocket _socket;
    private int _size;
    private int _newSize;
    private Thread _thread;
    private LinkedList<Buffer> _buffers = new LinkedList();
    private LocalException _exception;
    private ReadyCallback _readyCallback;

    @Override
    public SelectableChannel fd() {
        return null;
    }

    @Override
    public void setReadyCallback(ReadyCallback callback) {
        assert (this._readyCallback == null && callback != null);
        this._readyCallback = callback;
        this._thread.start();
    }

    @Override
    public int initialize(Buffer readBuffer, Buffer writeBuffer) {
        return 0;
    }

    @Override
    public int closing(boolean initiator, LocalException ex) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Thread thread;
        MulticastSocket socket;
        UdpMulticastClientTransceiver udpMulticastClientTransceiver = this;
        synchronized (udpMulticastClientTransceiver) {
            socket = this._socket;
            this._socket = null;
            thread = this._thread;
            this._thread = null;
            if (thread != null) {
                this.notifyAll();
            }
        }
        if (thread != null) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (socket != null) {
            socket.close();
        }
    }

    @Override
    public EndpointI bind() {
        return null;
    }

    @Override
    public synchronized int write(Buffer buf) {
        if (this._exception != null) {
            throw this._exception;
        }
        if (!buf.b.hasRemaining()) {
            return 0;
        }
        assert (buf.b.position() == 0);
        assert (this._socket != null);
        assert (Math.min(65507, this._size - 28) >= buf.size());
        this._buffers.add(new Buffer(buf, true));
        this.notifyAll();
        return 0;
    }

    @Override
    public synchronized int read(Buffer buf) {
        throw new SocketException();
    }

    @Override
    public String protocol() {
        return this._instance.protocol();
    }

    @Override
    public synchronized String toString() {
        if (this._socket == null) {
            return "<closed>";
        }
        return "multicast address = " + Network.addrToString(this._addr);
    }

    @Override
    public String toDetailedString() {
        StringBuilder s = new StringBuilder(this.toString());
        List<String> intfs = Network.getInterfacesForMulticast(this._mcastInterface, Network.getProtocolSupport(this._addr));
        if (!intfs.isEmpty()) {
            s.append("\nlocal interfaces = ");
            s.append(StringUtil.joinString(intfs, ", "));
        }
        return s.toString();
    }

    @Override
    public synchronized ConnectionInfo getInfo() {
        UDPConnectionInfo info = new UDPConnectionInfo();
        if (this._socket != null) {
            info.mcastAddress = this._addr.getAddress().getHostAddress();
            info.mcastPort = this._addr.getPort();
            info.sndSize = this._size;
        }
        return info;
    }

    @Override
    public synchronized void checkSendSize(Buffer buf) {
        int packetSize = Math.min(65507, this._size - 28);
        if (packetSize < buf.size()) {
            throw new DatagramLimitException();
        }
    }

    @Override
    public synchronized void setBufferSize(int rcvSize, int sndSize) {
        this.setBufSize(sndSize);
    }

    UdpMulticastClientTransceiver(ProtocolInstance instance, InetSocketAddress addr, String mcastInterface, int mcastTtl) {
        assert (addr.getAddress().isMulticastAddress());
        this._instance = instance;
        this._addr = addr;
        this._mcastInterface = mcastInterface;
        try {
            this._socket = new MulticastSocket();
            this._size = this._socket.getSendBufferSize();
            this._newSize = -1;
            this.setBufSize(-1);
            if (this._newSize != -1) {
                this.updateBufSize();
            }
            if (mcastInterface.length() > 0) {
                this._socket.setNetworkInterface(Network.getInterface(mcastInterface));
            }
            if (mcastTtl != -1) {
                this._socket.setTimeToLive(mcastTtl);
            }
            this._socket.connect(addr);
            this._thread = new Thread(){

                @Override
                public void run() {
                    this.setName("IceUDPMulticast.WriteThread");
                    UdpMulticastClientTransceiver.this.runWriteThread();
                }
            };
        }
        catch (Exception ex) {
            if (this._socket != null) {
                this._socket.close();
            }
            this._socket = null;
            if (ex instanceof LocalException) {
                throw (LocalException)ex;
            }
            throw new SocketException(ex);
        }
    }

    private synchronized void exception(LocalException ex) {
        if (this._exception == null) {
            this._exception = ex;
        }
    }

    private void setBufSize(int sz) {
        assert (this._socket != null);
        if (sz == -1) {
            sz = this._instance.properties().getPropertyAsIntWithDefault("Ice.UDP.SndSize", this._size);
        }
        if (sz < 42) {
            this._instance.logger().warning("Invalid Ice.UDP.SndSize value of " + sz + " adjusted to " + this._size);
        } else if (sz != this._size) {
            this._newSize = sz;
        }
    }

    private void updateBufSize() {
        try {
            this._socket.setSendBufferSize(this._newSize);
            this._size = this._socket.getSendBufferSize();
            if (this._size < this._newSize) {
                BufSizeWarnInfo winfo = this._instance.getBufSizeWarn((short)3);
                if (!winfo.sndWarn || winfo.sndSize != this._newSize) {
                    this._instance.logger().warning("UDP send buffer size: requested size of " + this._newSize + " adjusted to " + this._size);
                    this._instance.setSndBufSizeWarn((short)3, this._newSize);
                }
            }
        }
        catch (IOException ex) {
            if (this._socket != null) {
                this._socket.close();
            }
            this._socket = null;
            throw new SocketException(ex);
        }
    }

    protected synchronized void finalize() throws Throwable {
        try {
            Assert.FinalizerAssert(this._socket == null);
        }
        catch (Exception exception) {
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void runWriteThread() {
        try {
            DatagramPacket p = new DatagramPacket(new byte[0], 0);
            p.setSocketAddress(this._addr);
            while (true) {
                UdpMulticastClientTransceiver udpMulticastClientTransceiver = this;
                // MONITORENTER : udpMulticastClientTransceiver
                while (this._socket != null && this._exception == null && this._buffers.isEmpty()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                if (this._socket == null || this._exception != null) {
                    // MONITOREXIT : udpMulticastClientTransceiver
                    return;
                }
                if (this._newSize != -1) {
                    this.updateBufSize();
                    this._newSize = -1;
                }
                MulticastSocket socket = this._socket;
                Buffer buf = this._buffers.removeFirst();
                // MONITOREXIT : udpMulticastClientTransceiver
                assert (buf != null);
                if (buf.b.hasRemaining()) {
                    int offset;
                    byte[] arr;
                    if (buf.b.hasArray()) {
                        arr = buf.b.array();
                        offset = buf.b.arrayOffset();
                    } else {
                        arr = new byte[buf.b.limit()];
                        offset = 0;
                        buf.b.get(arr);
                    }
                    p.setData(arr, offset, buf.b.limit());
                    socket.send(p);
                }
                udpMulticastClientTransceiver = this;
                // MONITORENTER : udpMulticastClientTransceiver
                this._readyCallback.ready(4, !this._buffers.isEmpty());
                // MONITOREXIT : udpMulticastClientTransceiver
            }
        }
        catch (IOException ex) {
            this.exception(new SocketException(ex));
        }
    }
}

