/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.TMUtil;

public interface Index
extends Node.Cookie {
    public int getNodesCount();

    public Node[] getNodes();

    public int indexOf(Node var1);

    public void reorder();

    public void reorder(int[] var1);

    public void move(int var1, int var2);

    public void exchange(int var1, int var2);

    public void moveUp(int var1);

    public void moveDown(int var1);

    public void addChangeListener(ChangeListener var1);

    public void removeChangeListener(ChangeListener var1);

    public static abstract class KeysChildren<T>
    extends Children.Keys<T> {
        private Index support;
        protected final List<T> list;

        public KeysChildren(List<T> list) {
            this.list = list;
            this.update();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Index getIndex() {
            KeysChildren keysChildren = this;
            synchronized (keysChildren) {
                if (this.support == null) {
                    this.support = this.createIndex();
                }
                return this.support;
            }
        }

        protected Index createIndex() {
            return new Support(){

                @Override
                public Node[] getNodes() {
                    List<Node> list = Arrays.asList(this.getNodes());
                    if (nodes != null) {
                        list.removeAll(nodes);
                    }
                    return list.toArray(new Node[list.size()]);
                }

                @Override
                public int getNodesCount() {
                    return list.size();
                }

                @Override
                public void reorder(int[] nArray) {
                    this.reorder(nArray);
                    this.update();
                    this.fireChangeEvent(new ChangeEvent(this));
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reorder(int[] nArray) {
            Object object = this.lock();
            synchronized (object) {
                ArrayList<T> arrayList = new ArrayList<T>(this.list);
                for (int i = 0; i < arrayList.size(); ++i) {
                    this.list.set(nArray[i], arrayList.get(i));
                }
            }
        }

        protected Object lock() {
            return this.list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void update() {
            ArrayList<T> arrayList;
            Object object = this.lock();
            synchronized (object) {
                arrayList = new ArrayList<T>(this.list);
            }
            super.setKeys(arrayList);
        }
    }

    public static class ArrayChildren
    extends Children.Array
    implements Index {
        protected Index support = new Support(){

            @Override
            public Node[] getNodes() {
                return this.getNodes();
            }

            @Override
            public int getNodesCount() {
                return this.getNodesCount();
            }

            @Override
            public void reorder(int[] nArray) {
                this.reorder(nArray);
                this.fireChangeEvent(new ChangeEvent(this));
            }
        };

        public ArrayChildren() {
            this((List<Node>)null);
        }

        private ArrayChildren(List<Node> list) {
            super(list);
        }

        protected List<Node> initCollection() {
            return new ArrayList<Node>();
        }

        @Override
        public void reorder(final int[] nArray) {
            MUTEX.postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    Node[] nodeArray = nodes.toArray(new Node[nodes.size()]);
                    List list = (List)nodes;
                    for (int i = 0; i < nodeArray.length; ++i) {
                        list.set(nArray[i], nodeArray[i]);
                    }
                    this.refresh();
                }
            });
        }

        @Override
        public void reorder() {
            try {
                PR.enterReadAccess();
                Support.showIndexedCustomizer(this);
            }
            finally {
                PR.exitReadAccess();
            }
        }

        @Override
        public void move(int n, int n2) {
            this.support.move(n, n2);
        }

        @Override
        public void exchange(int n, int n2) {
            this.support.exchange(n, n2);
        }

        @Override
        public void moveUp(int n) {
            this.support.exchange(n, n - 1);
        }

        @Override
        public void moveDown(int n) {
            this.support.exchange(n, n + 1);
        }

        @Override
        public int indexOf(Node node) {
            try {
                PR.enterReadAccess();
                int n = ((List)this.nodes).indexOf(node);
                return n;
            }
            finally {
                PR.exitReadAccess();
            }
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            this.support.addChangeListener(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            this.support.removeChangeListener(changeListener);
        }
    }

    public static abstract class Support
    implements Index {
        private HashSet<ChangeListener> listeners;

        @Override
        public void move(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            if (n == n2) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i < n && i < n2 || i > n && i > n2 ? i : (i > n && i < n2 ? i - 1 : i + 1);
            }
            nArray[n] = n2;
            nArray[n2] = n < n2 ? n2 - 1 : n2 + 1;
            this.reorder(nArray);
        }

        @Override
        public void exchange(int n, int n2) {
            int[] nArray = new int[this.getNodesCount()];
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = i;
            }
            nArray[n] = n2;
            nArray[n2] = n;
            this.reorder(nArray);
        }

        @Override
        public void moveUp(int n) {
            this.exchange(n, n - 1);
        }

        @Override
        public void moveDown(int n) {
            this.exchange(n, n + 1);
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                this.listeners = new HashSet();
            }
            this.listeners.add(changeListener);
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
            if (this.listeners == null) {
                return;
            }
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void fireChangeEvent(ChangeEvent changeEvent) {
            HashSet hashSet;
            if (this.listeners == null) {
                return;
            }
            Object object = this;
            synchronized (object) {
                hashSet = (HashSet)this.listeners.clone();
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                ((ChangeListener)object.next()).stateChanged(changeEvent);
            }
        }

        @Override
        public abstract Node[] getNodes();

        @Override
        public int indexOf(Node node) {
            Node[] nodeArray = this.getNodes();
            for (int i = 0; i < nodeArray.length; ++i) {
                if (!node.equals(nodeArray[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void reorder() {
            Support.showIndexedCustomizer(this);
        }

        public static void showIndexedCustomizer(Index index) {
            TMUtil.showIndexedCustomizer(index);
        }

        @Override
        public abstract int getNodesCount();

        @Override
        public abstract void reorder(int[] var1);
    }
}

