# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.2.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

"""
The smartcard.scard module is a simple wrapper on top of the C language
PCSC SCardXXX API.

The smartcard.scard module is the lower layer of the pyscard
framework that provides a higher level interface.

You should avoid using the L{smartcard.scard} package directly, and use the
pyscard directly because:

 - smartcard.scard being a C wrapper, the code tends to look like C code
   written in python syntax

 - the smartcard package provides higher level abstractions (e.g.
   L{CardType}, L{CardConnection}), and makes programming easier since it is
   totally written in Python

You can still use the smartcard.scard package if you want to write your
own framework, or if you want to perform quick-and-dirty port of C
language programs using SCardXXX calls, or if there are features of
SCardXXX API that you want to use and that are not available in the
pyscard library.

Introduction

The smartcard.scard module is a Python wrapper around PCSC smart card base
services.  On Windows, the wrapper is performed around the smart card base
components winscard library.  On linux and OS X, the wrapper is performed
around the PCSC-lite library.


The smartcard.scard module provides mapping for the following API functions,
depending on the Operating System::

    =============================== ======= =======
    Function                        Windows  Linux 
                                             OS X  
    =============================== ======= =======
    GetOpenCardName                                
    SCardAddReaderToGroup              Y           
    SCardBeginTransaction              Y       Y   
    SCardCancel                        Y       Y   
    SCardConnect                       Y       Y   
    SCardControl                       Y       Y   
    SCardDisconnect                    Y       Y   
    SCardEndTransaction                Y       Y   
    SCardEstablishContext              Y       Y   
    SCardForgetCardType                Y           
    SCardForgetReader                  Y           
    SCardForgetReaderGroup             Y           
    SCardFreeMemory                                
    SCardGetAttrib                     Y       Y   
    SCardGetCardTypeProviderName       Y           
    SCardGetErrorMessage               Y       Y   
    SCardGetProviderId                             
    SCardGetStatusChange               Y       Y   
    SCardIntroduceCardType             Y           
    SCardIntroduceReader               Y           
    SCardIntroduceReaderGroup          Y           
    SCardIsValidContext                Y       Y   
    SCardListCards                     Y           
    SCardListInterfaces                Y           
    SCardListReaderGroups              Y       Y   
    SCardListReaders                   Y       Y   
    SCardLocateCards                   Y           
    SCardReconnect                     Y       Y   
    SCardReleaseContext                Y       Y   
    SCardRemoveReaderFromGroup         Y           
    SCardSetAttrib                     Y       Y   
    SCardSetCartTypeProviderName                   
    SCardStatus                        Y       Y   
    SCardTransmit                      Y       Y   
    SCardUIDlgSelectCard                           
    =============================== ======= =======

Comments, bug reports, improvements welcome.

-------------------------------------------------------------------------------

Copyright 2001-2012 gemalto
@Author: Jean-Daniel Aussel, mailto:jean-daniel.aussel@gemalto.com
@Author: Ludovic Rousseau, mailto:ludovic.rousseau@free.fr

This file is part of pyscard.

pyscard is free software; you can redistribute it and/or modify it
under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation; either version 2.1 of the License, or (at
your option) any later version.

pyscard is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
License for more details.

You should have received a copy of the GNU Lesser General Public License
along with pyscard; if not, write to the Free Software Foundation,
Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA

"""

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _scard
else:
    import _scard

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)



def SCardIsValidContext(hcontext):
    r"""
    SCardIsValidContext( hcontext) -> SCARDRETCODE

    This function determines whether a smart card context handle is still
    valid.  After a smart card context handle has been set by
    L{SCardEstablishContext()}, it may become not valid if the resource manager
    service has been shut down.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # valid context?
    >>> hresult = SCardIsValidContext(hcontext)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardIsValidContext(hcontext)

def SCardGetAttrib(hcard, dwAttrId):
    r"""
    SCardGetAttrib( hcard,  dwAttrId) -> SCARDRETCODE

    This function get an attribute from the IFD Handler.

    The possible attributes are::
        ======================================== ======= =======
        Attribute                                Windows  PCSC  
                                                          lite
        ======================================== ======= =======
        SCARD_ATTR_ASYNC_PROTOCOL_TYPES                     Y   
        SCARD_ATTR_ATR_STRING                       Y       Y   
        SCARD_ATTR_CHANNEL_ID                       Y       Y   
        SCARD_ATTR_CHARACTERISTICS                  Y       Y   
        SCARD_ATTR_CURRENT_BWT                      Y       Y   
        SCARD_ATTR_CURRENT_CLK                      Y       Y   
        SCARD_ATTR_CURRENT_CWT                      Y       Y   
        SCARD_ATTR_CURRENT_D                        Y       Y   
        SCARD_ATTR_CURRENT_EBC_ENCODING             Y       Y   
        SCARD_ATTR_CURRENT_F                        Y       Y   
        SCARD_ATTR_CURRENT_IFSC                     Y       Y   
        SCARD_ATTR_CURRENT_IFSD                     Y       Y   
        SCARD_ATTR_CURRENT_IO_STATE                 Y       Y   
        SCARD_ATTR_CURRENT_N                        Y       Y   
        SCARD_ATTR_CURRENT_PROTOCOL_TYPE            Y       Y   
        SCARD_ATTR_CURRENT_W                        Y       Y   
        SCARD_ATTR_DEFAULT_CLK                      Y       Y   
        SCARD_ATTR_DEFAULT_DATA_RATE                Y       Y   
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_A           Y       Y   
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_W           Y       Y   
        SCARD_ATTR_DEVICE_IN_USE                    Y       Y   
        SCARD_ATTR_DEVICE_SYSTEM_NAME_A             Y       Y   
        SCARD_ATTR_DEVICE_SYSTEM_NAME_W             Y       Y   
        SCARD_ATTR_DEVICE_UNIT                      Y       Y   
        SCARD_ATTR_ESC_AUTHREQUEST                  Y       Y   
        SCARD_ATTR_ESC_CANCEL                       Y       Y   
        SCARD_ATTR_ESC_RESET                        Y       Y   
        SCARD_ATTR_EXTENDED_BWT                     Y       Y   
        SCARD_ATTR_ICC_INTERFACE_STATUS             Y       Y   
        SCARD_ATTR_ICC_PRESENCE                     Y       Y   
        SCARD_ATTR_ICC_TYPE_PER_ATR                 Y       Y   
        SCARD_ATTR_MAXINPUT                         Y       Y   
        SCARD_ATTR_MAX_CLK                          Y       Y   
        SCARD_ATTR_MAX_DATA_RATE                    Y       Y   
        SCARD_ATTR_MAX_IFSD                         Y       Y   
        SCARD_ATTR_POWER_MGMT_SUPPORT               Y       Y   
        SCARD_ATTR_SUPRESS_T1_IFS_REQUEST           Y       Y   
        SCARD_ATTR_SYNC_PROTOCOL_TYPES                      Y   
        SCARD_ATTR_USER_AUTH_INPUT_DEVICE           Y       Y   
        SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE         Y       Y   
        SCARD_ATTR_VENDOR_IFD_SERIAL_NO             Y       Y   
        SCARD_ATTR_VENDOR_IFD_TYPE                  Y       Y   
        SCARD_ATTR_VENDOR_IFD_VERSION               Y       Y   
        SCARD_ATTR_VENDOR_NAME                      Y       Y   
        ======================================== ======= =======

    Not all the dwAttrId values listed above may be implemented in the IFD
    Handler you are using.  And some dwAttrId values not listed here may be
    implemented.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # get attribute
    >>> hresult, attrib = SCardGetAttrib(hcard, SCARD_ATTR_ATR_STRING)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> print(attrib)

    """
    return _scard.SCardGetAttrib(hcard, dwAttrId)

def SCardSetAttrib(hcard, dwAttrId, ATTRIBUTESIN):
    r"""
    SCardSetAttrib( hcard,  dwAttrId, BYTELIST * ATTRIBUTESIN) -> SCARDRETCODE

    This function sets an attribute from the IFD Handler. Not all
    attributes are supported by all readers nor can they be set at all
    times.

    The possible attributes are::
        ======================================== ======= =======
        Attribute                                Windows  PCSC  
                                                          lite
        ======================================== ======= =======
        SCARD_ATTR_ASYNC_PROTOCOL_TYPES                     Y   
        SCARD_ATTR_ATR_STRING                       Y       Y   
        SCARD_ATTR_CHANNEL_ID                       Y       Y   
        SCARD_ATTR_CHARACTERISTICS                  Y       Y   
        SCARD_ATTR_CURRENT_BWT                      Y       Y   
        SCARD_ATTR_CURRENT_CLK                      Y       Y   
        SCARD_ATTR_CURRENT_CWT                      Y       Y   
        SCARD_ATTR_CURRENT_D                        Y       Y   
        SCARD_ATTR_CURRENT_EBC_ENCODING             Y       Y   
        SCARD_ATTR_CURRENT_F                        Y       Y   
        SCARD_ATTR_CURRENT_IFSC                     Y       Y   
        SCARD_ATTR_CURRENT_IFSD                     Y       Y   
        SCARD_ATTR_CURRENT_IO_STATE                 Y       Y   
        SCARD_ATTR_CURRENT_N                        Y       Y   
        SCARD_ATTR_CURRENT_PROTOCOL_TYPE            Y       Y   
        SCARD_ATTR_CURRENT_W                        Y       Y   
        SCARD_ATTR_DEFAULT_CLK                      Y       Y   
        SCARD_ATTR_DEFAULT_DATA_RATE                Y       Y   
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_A           Y       Y   
        SCARD_ATTR_DEVICE_FRIENDLY_NAME_W           Y       Y   
        SCARD_ATTR_DEVICE_IN_USE                    Y       Y   
        SCARD_ATTR_DEVICE_SYSTEM_NAME_A             Y       Y   
        SCARD_ATTR_DEVICE_SYSTEM_NAME_W             Y       Y   
        SCARD_ATTR_DEVICE_UNIT                      Y       Y   
        SCARD_ATTR_ESC_AUTHREQUEST                  Y       Y   
        SCARD_ATTR_ESC_CANCEL                       Y       Y   
        SCARD_ATTR_ESC_RESET                        Y       Y   
        SCARD_ATTR_EXTENDED_BWT                     Y       Y   
        SCARD_ATTR_ICC_INTERFACE_STATUS             Y       Y   
        SCARD_ATTR_ICC_PRESENCE                     Y       Y   
        SCARD_ATTR_ICC_TYPE_PER_ATR                 Y       Y   
        SCARD_ATTR_MAXINPUT                         Y       Y   
        SCARD_ATTR_MAX_CLK                          Y       Y   
        SCARD_ATTR_MAX_DATA_RATE                    Y       Y   
        SCARD_ATTR_MAX_IFSD                         Y       Y   
        SCARD_ATTR_POWER_MGMT_SUPPORT               Y       Y   
        SCARD_ATTR_SUPRESS_T1_IFS_REQUEST           Y       Y   
        SCARD_ATTR_SYNC_PROTOCOL_TYPES                      Y   
        SCARD_ATTR_USER_AUTH_INPUT_DEVICE           Y       Y   
        SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE         Y       Y   
        SCARD_ATTR_VENDOR_IFD_SERIAL_NO             Y       Y   
        SCARD_ATTR_VENDOR_IFD_TYPE                  Y       Y   
        SCARD_ATTR_VENDOR_IFD_VERSION               Y       Y   
        SCARD_ATTR_VENDOR_NAME                      Y       Y   
        ======================================== ======= =======

    Not all the dwAttrId values listed above may be implemented in the
    IFD Handler you are using.  And some dwAttrId values not listed here
    may be implemented.

    >>> from smartcard.scard import *
    >>> ... establish context and connect to card ...
    >>> hresult, attrib = SCardSetAttrib(hcard, SCARD_ATTR_VENDOR_NAME, ['G', 'e', 'm', 'a', 'l', 't', 'o'])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>      print('Failed to set attribute')
    >>> ...

    """
    return _scard.SCardSetAttrib(hcard, dwAttrId, ATTRIBUTESIN)

def SCardControl(hcard, dwControlCode, inbuffer):
    r"""
    SCardControl( hcard,  dwControlCode, byte[] inbuffer) -> SCARDRETCODE

    This function sends a control command to the reader connected to by
    L{SCardConnect()}.  It returns a result and the control response.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # control
    >>> CMD = [0x12, 0x34]
    >>> hresult, response = SCardControl(hcard, 42, CMD)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardControl(hcard, dwControlCode, inbuffer)

def SCardBeginTransaction(hcard):
    r"""
    SCardBeginTransaction( hcard) -> SCARDRETCODE

    This function establishes a temporary exclusive access mode for doing a
    series of commands or transaction.  You might want to use this when you
    are selecting a few files and then writing a large file so you can make
    sure that another application will not change the current file.

    If another application has a lock on this reader or this application is
    in SCARD_SHARE_EXCLUSIVE there will be no action taken.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # begin transaction
    >>> hresult = SCardBeginTransaction(hcard)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardBeginTransaction(hcard)

def SCardCancel(hcontext):
    r"""
    SCardCancel( hcontext) -> SCARDRETCODE

    This function cancels all pending blocking requests on the
    L{SCardGetStatusChange()} function.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> ... establish context ...
    >>> hresult = SCardCancel(hcard)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    ...
    """
    return _scard.SCardCancel(hcontext)

def SCardConnect(hcontext, readername, dwShareMode, dwPreferredProtocols):
    r"""
    SCardConnect( hcontext,  readername,  dwShareMode,  dwPreferredProtocols) -> SCARDRETCODE

    This function establishes a connection to the friendly name of the reader
    specified in readername.  The first connection will power up and
    perform a reset on the card.

    Value of dwShareMode:
     - SCARD_SHARE_SHARED      This application will allow others to share the reader
     - SCARD_SHARE_EXCLUSIVE   This application will NOT allow others to share the reader
     - SCARD_SHARE_DIRECT      Direct control of the reader, even without a card

    SCARD_SHARE_DIRECT can be used before using L{SCardControl()} to
    send control commands to the reader even if a card is not present in
    the reader.

    Value of dwPreferredProtocols:
     - SCARD_PROTOCOL_T0               Use the T=0 protocol
     - SCARD_PROTOCOL_T1               Use the T=1 protocol
     - SCARD_PROTOCOL_RAW              Use with memory type cards

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardConnect(hcontext, readername, dwShareMode, dwPreferredProtocols)

def SCardDisconnect(hcard, dwDisposition):
    r"""
    SCardDisconnect( hcard,  dwDisposition) -> SCARDRETCODE

    This function terminates a connection to the connection made through
    L{SCardConnect()}.

    Value of disposition:
     - SCARD_LEAVE_CARD        Do nothing
     - SCARD_RESET_CARD        Reset the card (warm reset)
     - SCARD_UNPOWER_CARD      Unpower the card (cold reset)
     - SCARD_EJECT_CARD        Eject the card

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # disconnect
    >>> hresult = SCardDisconnect(hcard, SCARD_UNPOWER_CARD)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardDisconnect(hcard, dwDisposition)

def SCardEndTransaction(hcard, dwDisposition):
    r"""
    SCardEndTransaction( hcard,  dwDisposition) -> SCARDRETCODE

    This function ends a previously begun transaction.  The calling
    application must be the owner of the previously begun transaction or an
    error will occur.

    Value of disposition:
     - SCARD_LEAVE_CARD        Do nothing
     - SCARD_RESET_CARD        Reset the card
     - SCARD_UNPOWER_CARD      Unpower the card
     - SCARD_EJECT_CARD        Eject the card

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # begin transaction
    >>> hresult = SCardBeginTransaction(hcard)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # end transaction
    >>> hresult = SCardEndTransaction(hcard, SCARD_LEAVE_CARD)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardEndTransaction(hcard, dwDisposition)

def SCardEstablishContext(dwScope):
    r"""
    SCardEstablishContext( dwScope) -> SCARDRETCODE

    This function creates a communication context to the PC/SC Resource
    Manager.  This must be the first PC/SC function called in a PC/SC application.

    Value of dwScope:
     - SCARD_SCOPE_USER        Operations performed within the scope of the User
     - SCARD_SCOPE_TERMINAL    Not used
     - SCARD_SCOPE_GLOBAL      Not used
     - SCARD_SCOPE_SYSTEM      Operations performed within the scope of the system

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)

    """
    return _scard.SCardEstablishContext(dwScope)

def SCardGetStatusChange(hcontext, dwTimeout, readerstatelist):
    r"""
    SCardGetStatusChange( hcontext,  dwTimeout, tuple[] readerstatelist) -> SCARDRETCODE

    This function receives a structure or list of tuples containing reader
    states. A READERSTATE hast three fields (readername, state, atr).
    It then blocks for a change in state to occur on any of the OR'd
    values contained in the current state for a maximum blocking time of
    dwTimeout or forever if INFINITE is used.  The new event state will be
    contained in state.  A status change might be a card insertion or
    removal event, a change in ATR, etc.

    Value of state:
     - SCARD_STATE_UNAWARE         The application is unaware of the current state, and would like to know. The use of this value results in an immediate return from state transition monitoring services. This is represented by all bits set to zero
     - SCARD_STATE_IGNORE          This reader should be ignored
     - SCARD_STATE_CHANGED         There is a difference between the state believed by the application, and the state known by the resource manager. When this bit is set, the application may assume a significant state change has occurred on this reader
     - SCARD_STATE_UNKNOWN         The given reader name is not recognized by the resource manager. If this bit is set, then SCARD_STATE_CHANGED and SCARD_STATE_IGNORE will also be set
     - SCARD_STATE_UNAVAILABLE     The actual state of this reader is not available. If this bit is set, then all the following bits are clear
     - SCARD_STATE_EMPTY           There is no card in the reader. If this bit is set, all the following bits will be clear
     - SCARD_STATE_PRESENT         There is a card in the reader
     - SCARD_STATE_ATRMATCH        There is a card in the reader with an ATR matching one of the target cards. If this bit is set, SCARD_STATE_PRESENT will also be set. This bit is only returned on the SCardLocateCards function
     - SCARD_STATE_EXCLUSIVE       The card in the reader is allocated for exclusive use by another application. If this bit is set, SCARD_STATE_PRESENT will also be set
     - SCARD_STATE_INUSE           The card in the reader is in use by one or more other applications, but may be connected to in shared mode. If this bit is set, SCARD_STATE_PRESENT will also be set
     - SCARD_STATE_MUTE            There is an unresponsive card in the reader

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # get status change
    >>> readerstates = list()
    >>> for reader in readers:
    >>>     readerstates.append((reader, SCARD_STATE_UNAWARE))
    >>> 
    >>> hresult, newstates = SCardGetStatusChange(hcontext, INFINITE, readerstates)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> for state in newstates:
    >>>     reader, eventstate, atr = state
    >>>     print(f'Reader: {reader}:', end='')
    >>>     if eventstate & SCARD_STATE_PRESENT:
    >>>         print(' Card present')
    >>>     if eventstate & SCARD_STATE_EMPTY:
    >>>         print(' Reader empty')
    >>> 
    >>> print('insert or remove a card')
    >>> # wait for card move
    >>> readerstates = newstates
    >>> hresult, newstates = SCardGetStatusChange(hcontext, INFINITE, readerstates)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardGetStatusChange(hcontext, dwTimeout, readerstatelist)

def SCardListReaders(hcontext, readergroups):
    r"""
    SCardListReaders( hcontext, [] readergroups) -> SCARDRETCODE

    This function returns a list of currently available readers on the system.
    A list of group can be provided in input to list readers in a given
    group only.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> for reader in readers:
    >>>     print(reader)

    """
    return _scard.SCardListReaders(hcontext, readergroups)

def SCardListReaderGroups(hcontext):
    r"""
    SCardListReaderGroups( hcontext) -> SCARDRETCODE

    This function returns a list of currently available reader groups on the
    system.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> hresult, readerGroups = SCardListReaderGroups(hcontext)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> print('PCSC Reader groups:', readerGroups)

    """
    return _scard.SCardListReaderGroups(hcontext)

def SCardReconnect(hcard, dwShareMode, dwPreferredProtocols, dwInitialization):
    r"""
    SCardReconnect( hcard,  dwShareMode,  dwPreferredProtocols,  dwInitialization) -> SCARDRETCODE

    This function reestablishes a connection to a reader that was previously
    connected to using L{SCardConnect()}.  In a multi application environment it
    is possible for an application to reset the card in shared mode.  When
    this occurs any other application trying to access certain commands will
    be returned the value SCARD_W_RESET_CARD.  When this occurs
    L{SCardReconnect()} must be called in order to acknowledge that the card was
    reset and allow it to change it's state accordingly.

    Value of dwShareMode:
     - SCARD_SHARE_SHARED      This application will allow others to share the reader
     - SCARD_SHARE_EXCLUSIVE   This application will NOT allow others to share the reader

    Value of dwPreferredProtocols:
     - SCARD_PROTOCOL_T0               Use the T=0 protocol
     - SCARD_PROTOCOL_T1               Use the T=1 protocol
     - SCARD_PROTOCOL_RAW              Use with memory type cards

    dwPreferredProtocols is a bit mask of acceptable protocols for the connection. You can use (SCARD_PROTOCOL_T0 | SCARD_PROTOCOL_T1) if you do not have a preferred protocol.

    Value of dwInitialization:
     - SCARD_LEAVE_CARD            Do nothing
     - SCARD_RESET_CARD            Reset the card (warm reset)
     - SCARD_UNPOWER_CARD          Unpower the card (cold reset)
     - SCARD_EJECT_CARD            Eject the card

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # reconnect
    >>> hresult, activeProtocol = SCardReconnect(hcard, SCARD_SHARE_EXCLUSIVE, SCARD_PROTOCOL_T0, SCARD_RESET_CARD)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)

    """
    return _scard.SCardReconnect(hcard, dwShareMode, dwPreferredProtocols, dwInitialization)

def SCardReleaseContext(hcontext):
    r"""
    SCardReleaseContext( hcontext) -> SCARDRETCODE

    Release a PC/SC context estabished by L{SCardEstablishContext()}.

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # release context
    >>> hresult = SCardReleaseContext(hcontext)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ReleaseContextException(hresult)

    """
    return _scard.SCardReleaseContext(hcontext)

def SCardStatus(hcard):
    r"""
    SCardStatus( hcard) -> SCARDRETCODE

    This function returns the current status of the reader connected to by
    hcard.  The reader friendly name is returned, as well as the state,
    protocol and ATR.  The state is a DWORD possibly OR'd with the following
    values:

    Value of pdwState:
     - SCARD_ABSENT        There is no card in the reader
     - SCARD_PRESENT       There is a card in the reader, but it has not been moved into position for use
     - SCARD_SWALLOWED     There is a card in the reader in position for use. The card is not powered
     - SCARD_POWERED       Power is being provided to the card, but the reader driver is unaware of the mode of the card
     - SCARD_NEGOTIABLE    The card has been reset and is awaiting PTS negotiation
     - SCARD_SPECIFIC      The card has been reset and specific communication protocols have been established

    Value of pdwProtocol:
     - SCARD_PROTOCOL_T0       Use the T=0 protocol
     - SCARD_PROTOCOL_T1       Use the T=1 protocol

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> from smartcard.util import toHexString
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # status
    >>> hresult, reader, state, protocol, atr = SCardStatus(hcard)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> print('Reader:', reader)
    >>> print('State: 0x%04X' % state)
    >>> print('Protocol:', protocol)
    >>> print('ATR:', toHexString(atr))

    """
    return _scard.SCardStatus(hcard)

def SCardTransmit(hcard, pioSendPci, apducommand):
    r"""
    SCardTransmit( hcard, unsigned long pioSendPci, byte[] apducommand) -> SCARDRETCODE

    This function sends an APDU to the smart card contained in the reader
    connected to by L{SCardConnect()}.
    It returns a result and the card APDU response.

    Value of pioSendPci:
     - SCARD_PCI_T0            Pre-defined T=0 PCI structure
     - SCARD_PCI_T1            Pre-defined T=1 PCI structure

    >>> from smartcard.scard import *
    >>> from smartcard.pcsc import *
    >>> from smartcard.util import toHexString
    >>> 
    >>> # establish context
    >>> hresult, hcontext = SCardEstablishContext(SCARD_SCOPE_USER)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.EstablishContextException(hresult)
    >>> 
    >>> # list readers
    >>> hresult, readers = SCardListReaders(hcontext, [])
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.ListReadersException(hresult)
    >>> 
    >>> # connect
    >>> hresult, hcard, dwActiveProtocol = SCardConnect(
    >>>     hcontext, readers[0], SCARD_SHARE_SHARED, SCARD_PROTOCOL_T0)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> 
    >>> # transmit
    >>> SELECT = [0xA0, 0xA4, 0x00, 0x00, 0x02]
    >>> DF_TELECOM = [0x7F, 0x10]
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     raise PCSCExceptions.BaseSCardException(hresult)
    >>> print(toHexString(response))

    """
    return _scard.SCardTransmit(hcard, pioSendPci, apducommand)

def SCARD_CTL_CODE(code):
    r"""
    SCARD_CTL_CODE(long code) -> long

    This function returns the value of a control code

    >>> from smartcard.scard import *
    >>> ...
    >>> CM_IOCTL_GET_FEATURE_REQUEST = SCARD_CTL_CODE(3400)
    >>> ...

    """
    return _scard.SCARD_CTL_CODE(code)

def SCardGetErrorMessage(lErrCode):
    r"""
    SCardGetErrorMessage(long lErrCode) -> ERRORSTRING

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
    return _scard.SCardGetErrorMessage(lErrCode)

error = _scard.error

SCARD_SCOPE_USER = _scard.SCARD_SCOPE_USER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_SCOPE_TERMINAL = _scard.SCARD_SCOPE_TERMINAL
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_SCOPE_SYSTEM = _scard.SCARD_SCOPE_SYSTEM
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_SHARE_SHARED = _scard.SCARD_SHARE_SHARED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_SHARE_EXCLUSIVE = _scard.SCARD_SHARE_EXCLUSIVE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_SHARE_DIRECT = _scard.SCARD_SHARE_DIRECT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_LEAVE_CARD = _scard.SCARD_LEAVE_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_RESET_CARD = _scard.SCARD_RESET_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_UNPOWER_CARD = _scard.SCARD_UNPOWER_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_EJECT_CARD = _scard.SCARD_EJECT_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_UNAWARE = _scard.SCARD_STATE_UNAWARE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_IGNORE = _scard.SCARD_STATE_IGNORE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_CHANGED = _scard.SCARD_STATE_CHANGED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_UNKNOWN = _scard.SCARD_STATE_UNKNOWN
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_UNAVAILABLE = _scard.SCARD_STATE_UNAVAILABLE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_EMPTY = _scard.SCARD_STATE_EMPTY
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_PRESENT = _scard.SCARD_STATE_PRESENT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_ATRMATCH = _scard.SCARD_STATE_ATRMATCH
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_EXCLUSIVE = _scard.SCARD_STATE_EXCLUSIVE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_INUSE = _scard.SCARD_STATE_INUSE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_MUTE = _scard.SCARD_STATE_MUTE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_STATE_UNPOWERED = _scard.SCARD_STATE_UNPOWERED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_UNSET = _scard.SCARD_PROTOCOL_UNSET
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_T0 = _scard.SCARD_PROTOCOL_T0
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_T1 = _scard.SCARD_PROTOCOL_T1
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_RAW = _scard.SCARD_PROTOCOL_RAW
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_T15 = _scard.SCARD_PROTOCOL_T15
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_ANY = _scard.SCARD_PROTOCOL_ANY
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_UNDEFINED = _scard.SCARD_PROTOCOL_UNDEFINED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_OPTIMAL = _scard.SCARD_PROTOCOL_OPTIMAL
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_Tx = _scard.SCARD_PROTOCOL_Tx
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PROTOCOL_DEFAULT = _scard.SCARD_PROTOCOL_DEFAULT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PCI_T0 = _scard.SCARD_PCI_T0
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PCI_T1 = _scard.SCARD_PCI_T1
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_PCI_RAW = _scard.SCARD_PCI_RAW
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_VENDOR_NAME = _scard.SCARD_ATTR_VENDOR_NAME
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_VENDOR_IFD_TYPE = _scard.SCARD_ATTR_VENDOR_IFD_TYPE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_VENDOR_IFD_VERSION = _scard.SCARD_ATTR_VENDOR_IFD_VERSION
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_VENDOR_IFD_SERIAL_NO = _scard.SCARD_ATTR_VENDOR_IFD_SERIAL_NO
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CHANNEL_ID = _scard.SCARD_ATTR_CHANNEL_ID
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ASYNC_PROTOCOL_TYPES = _scard.SCARD_ATTR_ASYNC_PROTOCOL_TYPES
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEFAULT_CLK = _scard.SCARD_ATTR_DEFAULT_CLK
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_MAX_CLK = _scard.SCARD_ATTR_MAX_CLK
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEFAULT_DATA_RATE = _scard.SCARD_ATTR_DEFAULT_DATA_RATE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_MAX_DATA_RATE = _scard.SCARD_ATTR_MAX_DATA_RATE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_MAX_IFSD = _scard.SCARD_ATTR_MAX_IFSD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_SYNC_PROTOCOL_TYPES = _scard.SCARD_ATTR_SYNC_PROTOCOL_TYPES
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_POWER_MGMT_SUPPORT = _scard.SCARD_ATTR_POWER_MGMT_SUPPORT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE = _scard.SCARD_ATTR_USER_TO_CARD_AUTH_DEVICE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_USER_AUTH_INPUT_DEVICE = _scard.SCARD_ATTR_USER_AUTH_INPUT_DEVICE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CHARACTERISTICS = _scard.SCARD_ATTR_CHARACTERISTICS
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_PROTOCOL_TYPE = _scard.SCARD_ATTR_CURRENT_PROTOCOL_TYPE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_CLK = _scard.SCARD_ATTR_CURRENT_CLK
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_F = _scard.SCARD_ATTR_CURRENT_F
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_D = _scard.SCARD_ATTR_CURRENT_D
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_N = _scard.SCARD_ATTR_CURRENT_N
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_W = _scard.SCARD_ATTR_CURRENT_W
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_IFSC = _scard.SCARD_ATTR_CURRENT_IFSC
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_IFSD = _scard.SCARD_ATTR_CURRENT_IFSD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_BWT = _scard.SCARD_ATTR_CURRENT_BWT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_CWT = _scard.SCARD_ATTR_CURRENT_CWT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_EBC_ENCODING = _scard.SCARD_ATTR_CURRENT_EBC_ENCODING
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_EXTENDED_BWT = _scard.SCARD_ATTR_EXTENDED_BWT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ICC_PRESENCE = _scard.SCARD_ATTR_ICC_PRESENCE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ICC_INTERFACE_STATUS = _scard.SCARD_ATTR_ICC_INTERFACE_STATUS
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_CURRENT_IO_STATE = _scard.SCARD_ATTR_CURRENT_IO_STATE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ATR_STRING = _scard.SCARD_ATTR_ATR_STRING
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ICC_TYPE_PER_ATR = _scard.SCARD_ATTR_ICC_TYPE_PER_ATR
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ESC_RESET = _scard.SCARD_ATTR_ESC_RESET
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ESC_CANCEL = _scard.SCARD_ATTR_ESC_CANCEL
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_ESC_AUTHREQUEST = _scard.SCARD_ATTR_ESC_AUTHREQUEST
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_MAXINPUT = _scard.SCARD_ATTR_MAXINPUT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_UNIT = _scard.SCARD_ATTR_DEVICE_UNIT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_IN_USE = _scard.SCARD_ATTR_DEVICE_IN_USE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_FRIENDLY_NAME_A = _scard.SCARD_ATTR_DEVICE_FRIENDLY_NAME_A
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_SYSTEM_NAME_A = _scard.SCARD_ATTR_DEVICE_SYSTEM_NAME_A
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_FRIENDLY_NAME_W = _scard.SCARD_ATTR_DEVICE_FRIENDLY_NAME_W
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_SYSTEM_NAME_W = _scard.SCARD_ATTR_DEVICE_SYSTEM_NAME_W
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_SUPRESS_T1_IFS_REQUEST = _scard.SCARD_ATTR_SUPRESS_T1_IFS_REQUEST
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_FRIENDLY_NAME = _scard.SCARD_ATTR_DEVICE_FRIENDLY_NAME
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_ATTR_DEVICE_SYSTEM_NAME = _scard.SCARD_ATTR_DEVICE_SYSTEM_NAME
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_S_SUCCESS = _scard.SCARD_S_SUCCESS
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_F_INTERNAL_ERROR = _scard.SCARD_F_INTERNAL_ERROR
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_CANCELLED = _scard.SCARD_E_CANCELLED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INVALID_HANDLE = _scard.SCARD_E_INVALID_HANDLE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INVALID_PARAMETER = _scard.SCARD_E_INVALID_PARAMETER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INVALID_TARGET = _scard.SCARD_E_INVALID_TARGET
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_MEMORY = _scard.SCARD_E_NO_MEMORY
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_F_WAITED_TOO_LONG = _scard.SCARD_F_WAITED_TOO_LONG
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INSUFFICIENT_BUFFER = _scard.SCARD_E_INSUFFICIENT_BUFFER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_UNKNOWN_READER = _scard.SCARD_E_UNKNOWN_READER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_TIMEOUT = _scard.SCARD_E_TIMEOUT
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_SHARING_VIOLATION = _scard.SCARD_E_SHARING_VIOLATION
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_SMARTCARD = _scard.SCARD_E_NO_SMARTCARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_UNKNOWN_CARD = _scard.SCARD_E_UNKNOWN_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_CANT_DISPOSE = _scard.SCARD_E_CANT_DISPOSE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_PROTO_MISMATCH = _scard.SCARD_E_PROTO_MISMATCH
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NOT_READY = _scard.SCARD_E_NOT_READY
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INVALID_VALUE = _scard.SCARD_E_INVALID_VALUE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_SYSTEM_CANCELLED = _scard.SCARD_E_SYSTEM_CANCELLED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_F_COMM_ERROR = _scard.SCARD_F_COMM_ERROR
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_F_UNKNOWN_ERROR = _scard.SCARD_F_UNKNOWN_ERROR
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INVALID_ATR = _scard.SCARD_E_INVALID_ATR
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NOT_TRANSACTED = _scard.SCARD_E_NOT_TRANSACTED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_READER_UNAVAILABLE = _scard.SCARD_E_READER_UNAVAILABLE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_PCI_TOO_SMALL = _scard.SCARD_E_PCI_TOO_SMALL
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_READER_UNSUPPORTED = _scard.SCARD_E_READER_UNSUPPORTED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_DUPLICATE_READER = _scard.SCARD_E_DUPLICATE_READER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_CARD_UNSUPPORTED = _scard.SCARD_E_CARD_UNSUPPORTED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_SERVICE = _scard.SCARD_E_NO_SERVICE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_SERVICE_STOPPED = _scard.SCARD_E_SERVICE_STOPPED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_READERS_AVAILABLE = _scard.SCARD_E_NO_READERS_AVAILABLE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_UNSUPPORTED_FEATURE = _scard.SCARD_E_UNSUPPORTED_FEATURE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_UNSUPPORTED_CARD = _scard.SCARD_W_UNSUPPORTED_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_UNRESPONSIVE_CARD = _scard.SCARD_W_UNRESPONSIVE_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_UNPOWERED_CARD = _scard.SCARD_W_UNPOWERED_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_RESET_CARD = _scard.SCARD_W_RESET_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_REMOVED_CARD = _scard.SCARD_W_REMOVED_CARD
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_SECURITY_VIOLATION = _scard.SCARD_W_SECURITY_VIOLATION
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_WRONG_CHV = _scard.SCARD_W_WRONG_CHV
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_CHV_BLOCKED = _scard.SCARD_W_CHV_BLOCKED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_EOF = _scard.SCARD_W_EOF
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_CANCELLED_BY_USER = _scard.SCARD_W_CANCELLED_BY_USER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_W_CARD_NOT_AUTHENTICATED = _scard.SCARD_W_CARD_NOT_AUTHENTICATED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_UNEXPECTED = _scard.SCARD_E_UNEXPECTED
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_ICC_INSTALLATION = _scard.SCARD_E_ICC_INSTALLATION
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_ICC_CREATEORDER = _scard.SCARD_E_ICC_CREATEORDER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_DIR_NOT_FOUND = _scard.SCARD_E_DIR_NOT_FOUND
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_FILE_NOT_FOUND = _scard.SCARD_E_FILE_NOT_FOUND
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_DIR = _scard.SCARD_E_NO_DIR
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_FILE = _scard.SCARD_E_NO_FILE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_ACCESS = _scard.SCARD_E_NO_ACCESS
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_WRITE_TOO_MANY = _scard.SCARD_E_WRITE_TOO_MANY
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_BAD_SEEK = _scard.SCARD_E_BAD_SEEK
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_INVALID_CHV = _scard.SCARD_E_INVALID_CHV
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_UNKNOWN_RES_MNG = _scard.SCARD_E_UNKNOWN_RES_MNG
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_SUCH_CERTIFICATE = _scard.SCARD_E_NO_SUCH_CERTIFICATE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_CERTIFICATE_UNAVAILABLE = _scard.SCARD_E_CERTIFICATE_UNAVAILABLE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_COMM_DATA_LOST = _scard.SCARD_E_COMM_DATA_LOST
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_NO_KEY_CONTAINER = _scard.SCARD_E_NO_KEY_CONTAINER
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_E_SERVER_TOO_BUSY = _scard.SCARD_E_SERVER_TOO_BUSY
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
INVALID_HANDLE = _scard.INVALID_HANDLE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
SCARD_P_SHUTDOWN = _scard.SCARD_P_SHUTDOWN
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
INFINITE = _scard.INFINITE
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
resourceManager = _scard.resourceManager
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """
resourceManagerSubType = _scard.resourceManagerSubType
r"""

    This function return a human readable text for the given PC/SC error code.

    >>> from smartcard.scard import *
    >>> ...
    >>> hresult, response = SCardTransmit(hcard, SCARD_PCI_T0, SELECT + DF_TELECOM)
    >>> if hresult != SCARD_S_SUCCESS:
    >>>     print('Failed to transmit:', SCardGetErrorMessage(hresult))
    >>> ...

    """

