# ------------------------------------------------------------
# This file was generated using create_markov_trace_data.py
#
# on    : Version 2022.3.1
# under : Sage SageMath version 9.6.beta7, Release Date: 2022-04-02
# using : Python 3.10.3
# ------------------------------------------------------------

# generated data function for cubic Hecke algebra
def read_markov_irr(bas_ele, variables, num_strands=4):
    r"""
    Return precomputed Markov trace coefficients.

    This code has been generated by ``create_markov_trace_data.py`` (from
    the `database_cubic_hecke repository  <https://github.com/soehms/database_cubic_hecke>`__),
    please don't edit.

    INPUT:

    - ``bas_ele`` -- instance of enum :class:`MarkovTraceModuleBasis`
    - ``variables`` -- tuple consisting of the variables used in
      the coefficients
    - ``num_strands`` -- integer indicating the number of strands (default 4)


    OUTPUT:

    A list of the coefficients. The i'th member corresponds to the i'th
    irreducible character

    EXAMPLES::

        >>> from database_cubic_hecke.markov_trace_coeffs_irr import read_markov_irr
        >>> from sympy import var, I, sqrt
        >>> zeta3 = (sqrt(3)*I-1)/2
        >>> a, b, c, s = var('a, b, c, s')
        >>> variables = (a, b, c, s, zeta3)
        >>> read_markov_irr('U1', variables, num_strands=2) # doctest: +NORMALIZE_WHITESPACE
        [(a*b*c + a*s**2)/(a**2*s - a*b*s - a*c*s + b*c*s),
         (-a*b*c - b*s**2)/(a*b*s - a*c*s - b**2*s + b*c*s),
         (a*b*c + c*s**2)/(a*b*s - a*c*s - b*c*s + c**2*s)]

    """

    a, b, c, s, zeta3 = variables
    data = {}
    data[2] = {'U1': [(a*b*c + a*s**2)/(a**2*s - a*b*s - a*c*s + b*c*s), (-a*b*c -
        b*s**2)/(a*b*s - b**2*s - a*c*s + b*c*s), (a*b*c +
        c*s**2)/(a*b*s - a*c*s - b*c*s + c**2*s)], 'U2': [(-a*b -
        a*c)/(a**2 - a*b - a*c + b*c), (a*b + b*c)/(a*b - b**2 - a*c +
        b*c), (-a*c - b*c)/(a*b - a*c - b*c + c**2)]}
    data[3] = {'U1': [(-2*a**5*b**3*c**2 - 2*a**5*b**2*c**3 - a**3*b**4*c**3 -
        a**3*b**3*c**4 + a**2*b**4*c**4 + a**6*b*c*s**2 -
        3*a**5*b**2*c*s**2 - a**4*b**3*c*s**2 - 3*a**5*b*c**2*s**2 -
        3*a**4*b**2*c**2*s**2 - 3*a**3*b**3*c**2*s**2 -
        a**4*b*c**3*s**2 - 3*a**3*b**2*c**3*s**2 + a**2*b**3*c**3*s**2
        + a**6*s**4 - a**5*b*s**4 - a**5*c*s**4 - 2*a**3*b**2*c*s**4 -
        2*a**3*b*c**2*s**4)/(a**8*s**2 - 2*a**7*b*s**2 +
        2*a**6*b**2*s**2 - a**5*b**3*s**2 - 2*a**7*c*s**2 +
        5*a**6*b*c*s**2 - 6*a**5*b**2*c*s**2 + 4*a**4*b**3*c*s**2 -
        a**3*b**4*c*s**2 + 2*a**6*c**2*s**2 - 6*a**5*b*c**2*s**2 +
        8*a**4*b**2*c**2*s**2 - 6*a**3*b**3*c**2*s**2 +
        2*a**2*b**4*c**2*s**2 - a**5*c**3*s**2 + 4*a**4*b*c**3*s**2 -
        6*a**3*b**2*c**3*s**2 + 5*a**2*b**3*c**3*s**2 -
        2*a*b**4*c**3*s**2 - a**3*b*c**4*s**2 + 2*a**2*b**2*c**4*s**2
        - 2*a*b**3*c**4*s**2 + b**4*c**4*s**2), (a**4*b**4*c**2 -
        a**4*b**3*c**3 - a**3*b**4*c**3 - 2*a**3*b**2*c**5 -
        2*a**2*b**3*c**5 + a**3*b**3*c**2*s**2 - 3*a**3*b**2*c**3*s**2
        - 3*a**2*b**3*c**3*s**2 - a**3*b*c**4*s**2 -
        3*a**2*b**2*c**4*s**2 - a*b**3*c**4*s**2 - 3*a**2*b*c**5*s**2
        - 3*a*b**2*c**5*s**2 + a*b*c**6*s**2 - 2*a**2*b*c**3*s**4 -
        2*a*b**2*c**3*s**4 - a*c**5*s**4 - b*c**5*s**4 +
        c**6*s**4)/(a**4*b**4*s**2 - 2*a**4*b**3*c*s**2 -
        2*a**3*b**4*c*s**2 + 2*a**4*b**2*c**2*s**2 +
        5*a**3*b**3*c**2*s**2 + 2*a**2*b**4*c**2*s**2 -
        a**4*b*c**3*s**2 - 6*a**3*b**2*c**3*s**2 -
        6*a**2*b**3*c**3*s**2 - a*b**4*c**3*s**2 + 4*a**3*b*c**4*s**2
        + 8*a**2*b**2*c**4*s**2 + 4*a*b**3*c**4*s**2 - a**3*c**5*s**2
        - 6*a**2*b*c**5*s**2 - 6*a*b**2*c**5*s**2 - b**3*c**5*s**2 +
        2*a**2*c**6*s**2 + 5*a*b*c**6*s**2 + 2*b**2*c**6*s**2 -
        2*a*c**7*s**2 - 2*b*c**7*s**2 + c**8*s**2), (2*a**3*b**5*c**2
        + a**4*b**3*c**3 + 2*a**2*b**5*c**3 - a**4*b**2*c**4 +
        a**3*b**3*c**4 + a**3*b**4*c*s**2 + 3*a**2*b**5*c*s**2 -
        a*b**6*c*s**2 + 3*a**3*b**3*c**2*s**2 + 3*a**2*b**4*c**2*s**2
        + 3*a*b**5*c**2*s**2 - a**3*b**2*c**3*s**2 +
        3*a**2*b**3*c**3*s**2 + a*b**4*c**3*s**2 + a*b**5*s**4 -
        b**6*s**4 + 2*a**2*b**3*c*s**4 + b**5*c*s**4 +
        2*a*b**3*c**2*s**4)/(a**3*b**5*s**2 - 2*a**2*b**6*s**2 +
        2*a*b**7*s**2 - b**8*s**2 + a**4*b**3*c*s**2 -
        4*a**3*b**4*c*s**2 + 6*a**2*b**5*c*s**2 - 5*a*b**6*c*s**2 +
        2*b**7*c*s**2 - 2*a**4*b**2*c**2*s**2 + 6*a**3*b**3*c**2*s**2
        - 8*a**2*b**4*c**2*s**2 + 6*a*b**5*c**2*s**2 -
        2*b**6*c**2*s**2 + 2*a**4*b*c**3*s**2 - 5*a**3*b**2*c**3*s**2
        + 6*a**2*b**3*c**3*s**2 - 4*a*b**4*c**3*s**2 + b**5*c**3*s**2
        - a**4*c**4*s**2 + 2*a**3*b*c**4*s**2 - 2*a**2*b**2*c**4*s**2
        + a*b**3*c**4*s**2), (-a**4*b**2*c**2 - a**3*b**3*c**2 -
        a**3*b**2*c**3 - 2*a**2*b**3*c**3 - 2*a**3*b**2*c*s**2 -
        a**2*b**3*c*s**2 - 2*a**3*b*c**2*s**2 - 5*a**2*b**2*c**2*s**2
        - 2*a*b**3*c**2*s**2 - a**2*b*c**3*s**2 - 2*a*b**2*c**3*s**2 -
        2*a**2*b*c*s**4 - a*b**2*c*s**4 - a*b*c**2*s**4 -
        b**2*c**2*s**4)/(a**4*b**2*s**2 - a**3*b**3*s**2 -
        a**4*b*c*s**2 + 2*a**2*b**3*c*s**2 - a*b**4*c*s**2 +
        a**4*c**2*s**2 - 2*a**2*b**2*c**2*s**2 + b**4*c**2*s**2 -
        a**3*c**3*s**2 + 2*a**2*b*c**3*s**2 - b**3*c**3*s**2 -
        a*b*c**4*s**2 + b**2*c**4*s**2), (-2*a**3*b**3*c**2 -
        a**3*b**2*c**3 - a**2*b**3*c**3 - a**2*b**2*c**4 -
        2*a**3*b**2*c*s**2 - 2*a**2*b**3*c*s**2 - a**3*b*c**2*s**2 -
        5*a**2*b**2*c**2*s**2 - a*b**3*c**2*s**2 - 2*a**2*b*c**3*s**2
        - 2*a*b**2*c**3*s**2 - a**2*b**2*s**4 - a**2*b*c*s**4 -
        a*b**2*c*s**4 - 2*a*b*c**2*s**4)/(a**4*b**2*s**2 -
        a**3*b**3*s**2 + a**2*b**4*s**2 - a**4*b*c*s**2 -
        a*b**4*c*s**2 + 2*a**3*b*c**2*s**2 - 2*a**2*b**2*c**2*s**2 +
        2*a*b**3*c**2*s**2 - a**3*c**3*s**2 - b**3*c**3*s**2 +
        a**2*c**4*s**2 - a*b*c**4*s**2 + b**2*c**4*s**2),
        (a**3*b**3*c**2 + a**2*b**4*c**2 + 2*a**3*b**2*c**3 +
        a**2*b**3*c**3 + a**3*b**2*c*s**2 + 2*a**2*b**3*c*s**2 +
        2*a**3*b*c**2*s**2 + 5*a**2*b**2*c**2*s**2 +
        2*a*b**3*c**2*s**2 + 2*a**2*b*c**3*s**2 + a*b**2*c**3*s**2 +
        a**2*b*c*s**4 + 2*a*b**2*c*s**4 + a**2*c**2*s**4 +
        a*b*c**2*s**4)/(a**3*b**3*s**2 - a**2*b**4*s**2 +
        a**4*b*c*s**2 - 2*a**3*b**2*c*s**2 + a*b**4*c*s**2 -
        a**4*c**2*s**2 + 2*a**2*b**2*c**2*s**2 - b**4*c**2*s**2 +
        a**3*c**3*s**2 - 2*a*b**2*c**3*s**2 + b**3*c**3*s**2 -
        a**2*c**4*s**2 + a*b*c**4*s**2), (-a**3*b**3*c**2 -
        a**3*b**2*c**3 - a**2*b**3*c**3 - a**3*b**2*c*s**2 -
        a**2*b**3*c*s**2 - a**3*b*c**2*s**2 - 5*a**2*b**2*c**2*s**2 -
        a*b**3*c**2*s**2 - a**2*b*c**3*s**2 - a*b**2*c**3*s**2 -
        a**2*b*c*s**4 - a*b**2*c*s**4 - a*b*c**2*s**4)/(a**3*b**3*s**2
        + a**4*b*c*s**2 + a*b**4*c*s**2 + 2*a**2*b**2*c**2*s**2 +
        a**3*c**3*s**2 + b**3*c**3*s**2 + a*b*c**4*s**2)], 'U2':
        [(3*a**5*b**3*c + 6*a**5*b**2*c**2 + 2*a**4*b**3*c**2 +
        2*a**3*b**4*c**2 + 3*a**5*b*c**3 + 2*a**4*b**2*c**3 +
        4*a**3*b**3*c**3 - a**2*b**4*c**3 + 2*a**3*b**2*c**4 -
        a**2*b**3*c**4 - a**6*b*s**2 + 2*a**5*b**2*s**2 - a**6*c*s**2
        + 4*a**5*b*c*s**2 + 2*a**4*b**2*c*s**2 + 3*a**3*b**3*c*s**2 +
        2*a**5*c**2*s**2 + 2*a**4*b*c**2*s**2 + 6*a**3*b**2*c**2*s**2
        + 3*a**3*b*c**3*s**2)/(a**8*s - 2*a**7*b*s + 2*a**6*b**2*s -
        a**5*b**3*s - 2*a**7*c*s + 5*a**6*b*c*s - 6*a**5*b**2*c*s +
        4*a**4*b**3*c*s - a**3*b**4*c*s + 2*a**6*c**2*s -
        6*a**5*b*c**2*s + 8*a**4*b**2*c**2*s - 6*a**3*b**3*c**2*s +
        2*a**2*b**4*c**2*s - a**5*c**3*s + 4*a**4*b*c**3*s -
        6*a**3*b**2*c**3*s + 5*a**2*b**3*c**3*s - 2*a*b**4*c**3*s -
        a**3*b*c**4*s + 2*a**2*b**2*c**4*s - 2*a*b**3*c**4*s +
        b**4*c**4*s), (-a**4*b**3*c**2 - a**3*b**4*c**2 +
        2*a**4*b**2*c**3 + 4*a**3*b**3*c**3 + 2*a**2*b**4*c**3 +
        2*a**3*b**2*c**4 + 2*a**2*b**3*c**4 + 3*a**3*b*c**5 +
        6*a**2*b**2*c**5 + 3*a*b**3*c**5 + 3*a**3*b*c**3*s**2 +
        6*a**2*b**2*c**3*s**2 + 3*a*b**3*c**3*s**2 +
        2*a**2*b*c**4*s**2 + 2*a*b**2*c**4*s**2 + 2*a**2*c**5*s**2 +
        4*a*b*c**5*s**2 + 2*b**2*c**5*s**2 - a*c**6*s**2 -
        b*c**6*s**2)/(a**4*b**4*s - 2*a**4*b**3*c*s - 2*a**3*b**4*c*s
        + 2*a**4*b**2*c**2*s + 5*a**3*b**3*c**2*s + 2*a**2*b**4*c**2*s
        - a**4*b*c**3*s - 6*a**3*b**2*c**3*s - 6*a**2*b**3*c**3*s -
        a*b**4*c**3*s + 4*a**3*b*c**4*s + 8*a**2*b**2*c**4*s +
        4*a*b**3*c**4*s - a**3*c**5*s - 6*a**2*b*c**5*s -
        6*a*b**2*c**5*s - b**3*c**5*s + 2*a**2*c**6*s + 5*a*b*c**6*s +
        2*b**2*c**6*s - 2*a*c**7*s - 2*b*c**7*s + c**8*s),
        (-3*a**3*b**5*c - 2*a**4*b**3*c**2 - 2*a**3*b**4*c**2 -
        6*a**2*b**5*c**2 + a**4*b**2*c**3 - 4*a**3*b**3*c**3 -
        2*a**2*b**4*c**3 - 3*a*b**5*c**3 + a**3*b**2*c**4 -
        2*a**2*b**3*c**4 - 2*a**2*b**5*s**2 + a*b**6*s**2 -
        3*a**3*b**3*c*s**2 - 2*a**2*b**4*c*s**2 - 4*a*b**5*c*s**2 +
        b**6*c*s**2 - 6*a**2*b**3*c**2*s**2 - 2*a*b**4*c**2*s**2 -
        2*b**5*c**2*s**2 - 3*a*b**3*c**3*s**2)/(a**3*b**5*s -
        2*a**2*b**6*s + 2*a*b**7*s - b**8*s + a**4*b**3*c*s -
        4*a**3*b**4*c*s + 6*a**2*b**5*c*s - 5*a*b**6*c*s + 2*b**7*c*s
        - 2*a**4*b**2*c**2*s + 6*a**3*b**3*c**2*s - 8*a**2*b**4*c**2*s
        + 6*a*b**5*c**2*s - 2*b**6*c**2*s + 2*a**4*b*c**3*s -
        5*a**3*b**2*c**3*s + 6*a**2*b**3*c**3*s - 4*a*b**4*c**3*s +
        b**5*c**3*s - a**4*c**4*s + 2*a**3*b*c**4*s -
        2*a**2*b**2*c**4*s + a*b**3*c**4*s), (a**4*b**2*c +
        a**3*b**3*c + a**4*b*c**2 + 5*a**3*b**2*c**2 +
        4*a**2*b**3*c**2 + a**3*b*c**3 + 4*a**2*b**2*c**3 +
        3*a*b**3*c**3 + 3*a**3*b*c*s**2 + 4*a**2*b**2*c*s**2 +
        a*b**3*c*s**2 + 4*a**2*b*c**2*s**2 + 5*a*b**2*c**2*s**2 +
        b**3*c**2*s**2 + a*b*c**3*s**2 + b**2*c**3*s**2)/(a**4*b**2*s
        - a**3*b**3*s - a**4*b*c*s + 2*a**2*b**3*c*s - a*b**4*c*s +
        a**4*c**2*s - 2*a**2*b**2*c**2*s + b**4*c**2*s - a**3*c**3*s +
        2*a**2*b*c**3*s - b**3*c**3*s - a*b*c**4*s + b**2*c**4*s),
        (3*a**3*b**3*c + 4*a**3*b**2*c**2 + 4*a**2*b**3*c**2 +
        a**3*b*c**3 + 5*a**2*b**2*c**3 + a*b**3*c**3 + a**2*b*c**4 +
        a*b**2*c**4 + a**3*b**2*s**2 + a**2*b**3*s**2 + a**3*b*c*s**2
        + 5*a**2*b**2*c*s**2 + a*b**3*c*s**2 + 4*a**2*b*c**2*s**2 +
        4*a*b**2*c**2*s**2 + 3*a*b*c**3*s**2)/(a**4*b**2*s -
        a**3*b**3*s + a**2*b**4*s - a**4*b*c*s - a*b**4*c*s +
        2*a**3*b*c**2*s - 2*a**2*b**2*c**2*s + 2*a*b**3*c**2*s -
        a**3*c**3*s - b**3*c**3*s + a**2*c**4*s - a*b*c**4*s +
        b**2*c**4*s), (-a**3*b**3*c - a**2*b**4*c - 4*a**3*b**2*c**2 -
        5*a**2*b**3*c**2 - a*b**4*c**2 - 3*a**3*b*c**3 -
        4*a**2*b**2*c**3 - a*b**3*c**3 - a**3*b*c*s**2 -
        4*a**2*b**2*c*s**2 - 3*a*b**3*c*s**2 - a**3*c**2*s**2 -
        5*a**2*b*c**2*s**2 - 4*a*b**2*c**2*s**2 - a**2*c**3*s**2 -
        a*b*c**3*s**2)/(a**3*b**3*s - a**2*b**4*s + a**4*b*c*s -
        2*a**3*b**2*c*s + a*b**4*c*s - a**4*c**2*s +
        2*a**2*b**2*c**2*s - b**4*c**2*s + a**3*c**3*s -
        2*a*b**2*c**3*s + b**3*c**3*s - a**2*c**4*s + a*b*c**4*s),
        (a**3*b**3*c + 3*a**3*b**2*c**2 + 3*a**2*b**3*c**2 +
        a**3*b*c**3 + 3*a**2*b**2*c**3 + a*b**3*c**3 + a**3*b*c*s**2 +
        3*a**2*b**2*c*s**2 + a*b**3*c*s**2 + 3*a**2*b*c**2*s**2 +
        3*a*b**2*c**2*s**2 + a*b*c**3*s**2)/(a**3*b**3*s + a**4*b*c*s
        + a*b**4*c*s + 2*a**2*b**2*c**2*s + a**3*c**3*s + b**3*c**3*s
        + a*b*c**4*s)], 'U3': [(-a**5*b**3 - 3*a**5*b**2*c -
        a**4*b**3*c - a**3*b**4*c - 3*a**5*b*c**2 - 2*a**4*b**2*c**2 -
        3*a**3*b**3*c**2 - a**5*c**3 - a**4*b*c**3 - 3*a**3*b**2*c**3
        - a**3*b*c**4)/(a**8 - 2*a**7*b + 2*a**6*b**2 - a**5*b**3 -
        2*a**7*c + 5*a**6*b*c - 6*a**5*b**2*c + 4*a**4*b**3*c -
        a**3*b**4*c + 2*a**6*c**2 - 6*a**5*b*c**2 + 8*a**4*b**2*c**2 -
        6*a**3*b**3*c**2 + 2*a**2*b**4*c**2 - a**5*c**3 +
        4*a**4*b*c**3 - 6*a**3*b**2*c**3 + 5*a**2*b**3*c**3 -
        2*a*b**4*c**3 - a**3*b*c**4 + 2*a**2*b**2*c**4 - 2*a*b**3*c**4
        + b**4*c**4), (-a**4*b*c**3 - 3*a**3*b**2*c**3 -
        3*a**2*b**3*c**3 - a*b**4*c**3 - a**3*b*c**4 -
        2*a**2*b**2*c**4 - a*b**3*c**4 - a**3*c**5 - 3*a**2*b*c**5 -
        3*a*b**2*c**5 - b**3*c**5)/(a**4*b**4 - 2*a**4*b**3*c -
        2*a**3*b**4*c + 2*a**4*b**2*c**2 + 5*a**3*b**3*c**2 +
        2*a**2*b**4*c**2 - a**4*b*c**3 - 6*a**3*b**2*c**3 -
        6*a**2*b**3*c**3 - a*b**4*c**3 + 4*a**3*b*c**4 +
        8*a**2*b**2*c**4 + 4*a*b**3*c**4 - a**3*c**5 - 6*a**2*b*c**5 -
        6*a*b**2*c**5 - b**3*c**5 + 2*a**2*c**6 + 5*a*b*c**6 +
        2*b**2*c**6 - 2*a*c**7 - 2*b*c**7 + c**8), (a**3*b**5 +
        a**4*b**3*c + a**3*b**4*c + 3*a**2*b**5*c + 3*a**3*b**3*c**2 +
        2*a**2*b**4*c**2 + 3*a*b**5*c**2 + 3*a**2*b**3*c**3 +
        a*b**4*c**3 + b**5*c**3 + a*b**3*c**4)/(a**3*b**5 -
        2*a**2*b**6 + 2*a*b**7 - b**8 + a**4*b**3*c - 4*a**3*b**4*c +
        6*a**2*b**5*c - 5*a*b**6*c + 2*b**7*c - 2*a**4*b**2*c**2 +
        6*a**3*b**3*c**2 - 8*a**2*b**4*c**2 + 6*a*b**5*c**2 -
        2*b**6*c**2 + 2*a**4*b*c**3 - 5*a**3*b**2*c**3 +
        6*a**2*b**3*c**3 - 4*a*b**4*c**3 + b**5*c**3 - a**4*c**4 +
        2*a**3*b*c**4 - 2*a**2*b**2*c**4 + a*b**3*c**4), (-a**4*b*c -
        2*a**3*b**2*c - a**2*b**3*c - 2*a**3*b*c**2 - 4*a**2*b**2*c**2
        - 2*a*b**3*c**2 - a**2*b*c**3 - 2*a*b**2*c**3 -
        b**3*c**3)/(a**4*b**2 - a**3*b**3 - a**4*b*c + 2*a**2*b**3*c -
        a*b**4*c + a**4*c**2 - 2*a**2*b**2*c**2 + b**4*c**2 -
        a**3*c**3 + 2*a**2*b*c**3 - b**3*c**3 - a*b*c**4 + b**2*c**4),
        (-a**3*b**3 - 2*a**3*b**2*c - 2*a**2*b**3*c - a**3*b*c**2 -
        4*a**2*b**2*c**2 - a*b**3*c**2 - 2*a**2*b*c**3 - 2*a*b**2*c**3
        - a*b*c**4)/(a**4*b**2 - a**3*b**3 + a**2*b**4 - a**4*b*c -
        a*b**4*c + 2*a**3*b*c**2 - 2*a**2*b**2*c**2 + 2*a*b**3*c**2 -
        a**3*c**3 - b**3*c**3 + a**2*c**4 - a*b*c**4 + b**2*c**4),
        (a**3*b**2*c + 2*a**2*b**3*c + a*b**4*c + 2*a**3*b*c**2 +
        4*a**2*b**2*c**2 + 2*a*b**3*c**2 + a**3*c**3 + 2*a**2*b*c**3 +
        a*b**2*c**3)/(a**3*b**3 - a**2*b**4 + a**4*b*c - 2*a**3*b**2*c
        + a*b**4*c - a**4*c**2 + 2*a**2*b**2*c**2 - b**4*c**2 +
        a**3*c**3 - 2*a*b**2*c**3 + b**3*c**3 - a**2*c**4 + a*b*c**4),
        (-a**3*b**2*c - a**2*b**3*c - a**3*b*c**2 - 2*a**2*b**2*c**2 -
        a*b**3*c**2 - a**2*b*c**3 - a*b**2*c**3)/(a**3*b**3 + a**4*b*c
        + a*b**4*c + 2*a**2*b**2*c**2 + a**3*c**3 + b**3*c**3 +
        a*b*c**4)], 'K4': [a**4*b**2*c**2/(a**8 - 2*a**7*b +
        2*a**6*b**2 - a**5*b**3 - 2*a**7*c + 5*a**6*b*c -
        6*a**5*b**2*c + 4*a**4*b**3*c - a**3*b**4*c + 2*a**6*c**2 -
        6*a**5*b*c**2 + 8*a**4*b**2*c**2 - 6*a**3*b**3*c**2 +
        2*a**2*b**4*c**2 - a**5*c**3 + 4*a**4*b*c**3 -
        6*a**3*b**2*c**3 + 5*a**2*b**3*c**3 - 2*a*b**4*c**3 -
        a**3*b*c**4 + 2*a**2*b**2*c**4 - 2*a*b**3*c**4 + b**4*c**4),
        a**2*b**2*c**4/(a**4*b**4 - 2*a**4*b**3*c - 2*a**3*b**4*c +
        2*a**4*b**2*c**2 + 5*a**3*b**3*c**2 + 2*a**2*b**4*c**2 -
        a**4*b*c**3 - 6*a**3*b**2*c**3 - 6*a**2*b**3*c**3 -
        a*b**4*c**3 + 4*a**3*b*c**4 + 8*a**2*b**2*c**4 + 4*a*b**3*c**4
        - a**3*c**5 - 6*a**2*b*c**5 - 6*a*b**2*c**5 - b**3*c**5 +
        2*a**2*c**6 + 5*a*b*c**6 + 2*b**2*c**6 - 2*a*c**7 - 2*b*c**7 +
        c**8), (-a**2*b**4*c**2)/(a**3*b**5 - 2*a**2*b**6 + 2*a*b**7 -
        b**8 + a**4*b**3*c - 4*a**3*b**4*c + 6*a**2*b**5*c -
        5*a*b**6*c + 2*b**7*c - 2*a**4*b**2*c**2 + 6*a**3*b**3*c**2 -
        8*a**2*b**4*c**2 + 6*a*b**5*c**2 - 2*b**6*c**2 + 2*a**4*b*c**3
        - 5*a**3*b**2*c**3 + 6*a**2*b**3*c**3 - 4*a*b**4*c**3 +
        b**5*c**3 - a**4*c**4 + 2*a**3*b*c**4 - 2*a**2*b**2*c**4 +
        a*b**3*c**4), a**2*b**2*c**2/(a**4*b**2 - a**3*b**3 - a**4*b*c
        + 2*a**2*b**3*c - a*b**4*c + a**4*c**2 - 2*a**2*b**2*c**2 +
        b**4*c**2 - a**3*c**3 + 2*a**2*b*c**3 - b**3*c**3 - a*b*c**4 +
        b**2*c**4), a**2*b**2*c**2/(a**4*b**2 - a**3*b**3 + a**2*b**4
        - a**4*b*c - a*b**4*c + 2*a**3*b*c**2 - 2*a**2*b**2*c**2 +
        2*a*b**3*c**2 - a**3*c**3 - b**3*c**3 + a**2*c**4 - a*b*c**4 +
        b**2*c**4), (-a**2*b**2*c**2)/(a**3*b**3 - a**2*b**4 +
        a**4*b*c - 2*a**3*b**2*c + a*b**4*c - a**4*c**2 +
        2*a**2*b**2*c**2 - b**4*c**2 + a**3*c**3 - 2*a*b**2*c**3 +
        b**3*c**3 - a**2*c**4 + a*b*c**4), a**2*b**2*c**2/(a**3*b**3 +
        a**4*b*c + a*b**4*c + 2*a**2*b**2*c**2 + a**3*c**3 + b**3*c**3
        + a*b*c**4)]}
    data[4] = {'U1': [(2*a**20*b**7*c**2 + 2*a**19*b**8*c**2 + 9*a**20*b**6*c**3 +
        12*a**19*b**7*c**3 + 9*a**18*b**8*c**3 + 17*a**20*b**5*c**4 +
        28*a**19*b**6*c**4 + 39*a**18*b**7*c**4 + 9*a**17*b**8*c**4 +
        4*a**16*b**9*c**4 - a**15*b**10*c**4 + 17*a**20*b**4*c**5 +
        36*a**19*b**5*c**5 + 71*a**18*b**6*c**5 + 31*a**17*b**7*c**5 +
        25*a**16*b**8*c**5 - 6*a**15*b**9*c**5 + 4*a**14*b**10*c**5 -
        a**13*b**11*c**5 + 9*a**20*b**3*c**6 + 28*a**19*b**4*c**6 +
        71*a**18*b**5*c**6 + 44*a**17*b**6*c**6 + 54*a**16*b**7*c**6 -
        10*a**15*b**8*c**6 + 15*a**14*b**9*c**6 - 6*a**13*b**10*c**6 +
        3*a**12*b**11*c**6 + 2*a**20*b**2*c**7 + 12*a**19*b**3*c**7 +
        39*a**18*b**4*c**7 + 31*a**17*b**5*c**7 + 54*a**16*b**6*c**7 -
        10*a**15*b**7*c**7 + 27*a**14*b**8*c**7 - 17*a**13*b**9*c**7 +
        14*a**12*b**10*c**7 + 4*a**10*b**12*c**7 + 2*a**19*b**2*c**8 +
        9*a**18*b**3*c**8 + 9*a**17*b**4*c**8 + 25*a**16*b**5*c**8 -
        10*a**15*b**6*c**8 + 27*a**14*b**7*c**8 - 24*a**13*b**8*c**8 +
        26*a**12*b**9*c**8 + 5*a**11*b**10*c**8 + 24*a**10*b**11*c**8
        + 3*a**9*b**12*c**8 + 4*a**16*b**4*c**9 - 6*a**15*b**5*c**9 +
        15*a**14*b**6*c**9 - 17*a**13*b**7*c**9 + 26*a**12*b**8*c**9 +
        11*a**11*b**9*c**9 + 52*a**10*b**10*c**9 + 21*a**9*b**11*c**9
        + 7*a**8*b**12*c**9 - a**7*b**13*c**9 - a**15*b**4*c**10 +
        4*a**14*b**5*c**10 - 6*a**13*b**6*c**10 + 14*a**12*b**7*c**10
        + 5*a**11*b**8*c**10 + 52*a**10*b**9*c**10 +
        33*a**9*b**10*c**10 + 21*a**8*b**11*c**10 + a**7*b**12*c**10 +
        a**6*b**13*c**10 - a**13*b**5*c**11 + 3*a**12*b**6*c**11 +
        24*a**10*b**8*c**11 + 21*a**9*b**9*c**11 + 21*a**8*b**10*c**11
        + 4*a**7*b**11*c**11 + 4*a**10*b**7*c**12 + 3*a**9*b**8*c**12
        + 7*a**8*b**9*c**12 + a**7*b**10*c**12 - a**4*b**13*c**12 -
        a**7*b**9*c**13 + a**6*b**10*c**13 - a**4*b**12*c**13 +
        a**3*b**13*c**13 + 2*a**20*b**6*c*s**2 + 4*a**19*b**7*c*s**2 +
        2*a**18*b**8*c*s**2 - 2*a**21*b**4*c**2*s**2 +
        13*a**20*b**5*c**2*s**2 + 15*a**19*b**6*c**2*s**2 +
        21*a**18*b**7*c**2*s**2 + 9*a**17*b**8*c**2*s**2 -
        4*a**21*b**3*c**3*s**2 + 26*a**20*b**4*c**3*s**2 +
        29*a**19*b**5*c**3*s**2 + 56*a**18*b**6*c**3*s**2 +
        35*a**17*b**7*c**3*s**2 + 19*a**16*b**8*c**3*s**2 +
        2*a**15*b**9*c**3*s**2 - a**14*b**10*c**3*s**2 -
        2*a**21*b**2*c**4*s**2 + 26*a**20*b**3*c**4*s**2 +
        34*a**19*b**4*c**4*s**2 + 80*a**18*b**5*c**4*s**2 +
        45*a**17*b**6*c**4*s**2 + 65*a**16*b**7*c**4*s**2 +
        11*a**15*b**8*c**4*s**2 + 9*a**14*b**9*c**4*s**2 +
        a**13*b**10*c**4*s**2 - a**12*b**11*c**4*s**2 +
        13*a**20*b**2*c**5*s**2 + 29*a**19*b**3*c**5*s**2 +
        80*a**18*b**4*c**5*s**2 + 42*a**17*b**5*c**5*s**2 +
        98*a**16*b**6*c**5*s**2 + 22*a**15*b**7*c**5*s**2 +
        39*a**14*b**8*c**5*s**2 + 3*a**13*b**9*c**5*s**2 +
        8*a**12*b**10*c**5*s**2 + a**11*b**11*c**5*s**2 +
        2*a**20*b*c**6*s**2 + 15*a**19*b**2*c**6*s**2 +
        56*a**18*b**3*c**6*s**2 + 45*a**17*b**4*c**6*s**2 +
        98*a**16*b**5*c**6*s**2 + 25*a**15*b**6*c**6*s**2 +
        67*a**14*b**7*c**6*s**2 - 6*a**13*b**8*c**6*s**2 +
        32*a**12*b**9*c**6*s**2 + 4*a**11*b**10*c**6*s**2 +
        11*a**10*b**11*c**6*s**2 + 3*a**9*b**12*c**6*s**2 +
        4*a**19*b*c**7*s**2 + 21*a**18*b**2*c**7*s**2 +
        35*a**17*b**3*c**7*s**2 + 65*a**16*b**4*c**7*s**2 +
        22*a**15*b**5*c**7*s**2 + 67*a**14*b**6*c**7*s**2 -
        17*a**13*b**7*c**7*s**2 + 47*a**12*b**8*c**7*s**2 +
        6*a**11*b**9*c**7*s**2 + 38*a**10*b**10*c**7*s**2 +
        14*a**9*b**11*c**7*s**2 + 6*a**8*b**12*c**7*s**2 +
        2*a**18*b*c**8*s**2 + 9*a**17*b**2*c**8*s**2 +
        19*a**16*b**3*c**8*s**2 + 11*a**15*b**4*c**8*s**2 +
        39*a**14*b**5*c**8*s**2 - 6*a**13*b**6*c**8*s**2 +
        47*a**12*b**7*c**8*s**2 + 6*a**11*b**8*c**8*s**2 +
        61*a**10*b**9*c**8*s**2 + 30*a**9*b**10*c**8*s**2 +
        22*a**8*b**11*c**8*s**2 + 2*a**7*b**12*c**8*s**2 +
        2*a**15*b**3*c**9*s**2 + 9*a**14*b**4*c**9*s**2 +
        3*a**13*b**5*c**9*s**2 + 32*a**12*b**6*c**9*s**2 +
        6*a**11*b**7*c**9*s**2 + 61*a**10*b**8*c**9*s**2 +
        36*a**9*b**9*c**9*s**2 + 42*a**8*b**10*c**9*s**2 +
        13*a**7*b**11*c**9*s**2 + 4*a**6*b**12*c**9*s**2 -
        a**14*b**3*c**10*s**2 + a**13*b**4*c**10*s**2 +
        8*a**12*b**5*c**10*s**2 + 4*a**11*b**6*c**10*s**2 +
        38*a**10*b**7*c**10*s**2 + 30*a**9*b**8*c**10*s**2 +
        42*a**8*b**9*c**10*s**2 + 25*a**7*b**10*c**10*s**2 +
        10*a**6*b**11*c**10*s**2 + a**5*b**12*c**10*s**2 -
        a**12*b**4*c**11*s**2 + a**11*b**5*c**11*s**2 +
        11*a**10*b**6*c**11*s**2 + 14*a**9*b**7*c**11*s**2 +
        22*a**8*b**8*c**11*s**2 + 13*a**7*b**9*c**11*s**2 +
        10*a**6*b**10*c**11*s**2 - 3*a**4*b**12*c**11*s**2 +
        3*a**9*b**6*c**12*s**2 + 6*a**8*b**7*c**12*s**2 +
        2*a**7*b**8*c**12*s**2 + 4*a**6*b**9*c**12*s**2 +
        a**5*b**10*c**12*s**2 - 3*a**4*b**11*c**12*s**2 +
        a**3*b**12*c**12*s**2 + a**22*b**2*c*s**4 -
        4*a**21*b**3*c*s**4 + 5*a**20*b**4*c*s**4 -
        9*a**19*b**5*c*s**4 - 11*a**18*b**6*c*s**4 -
        5*a**17*b**7*c*s**4 + a**22*b*c**2*s**4 -
        7*a**21*b**2*c**2*s**4 + 9*a**20*b**3*c**2*s**4 -
        28*a**19*b**4*c**2*s**4 - 65*a**18*b**5*c**2*s**4 -
        75*a**17*b**6*c**2*s**4 - 17*a**16*b**7*c**2*s**4 +
        2*a**15*b**8*c**2*s**4 - 4*a**21*b*c**3*s**4 +
        9*a**20*b**2*c**3*s**4 - 41*a**19*b**3*c**3*s**4 -
        135*a**18*b**4*c**3*s**4 - 259*a**17*b**5*c**3*s**4 -
        132*a**16*b**6*c**3*s**4 - 34*a**15*b**7*c**3*s**4 +
        12*a**14*b**8*c**3*s**4 + 6*a**13*b**9*c**3*s**4 +
        5*a**20*b*c**4*s**4 - 28*a**19*b**2*c**4*s**4 -
        135*a**18*b**3*c**4*s**4 - 373*a**17*b**4*c**4*s**4 -
        313*a**16*b**5*c**4*s**4 - 159*a**15*b**6*c**4*s**4 +
        16*a**14*b**7*c**4*s**4 + 20*a**13*b**8*c**4*s**4 +
        18*a**12*b**9*c**4*s**4 + 5*a**11*b**10*c**4*s**4 -
        9*a**19*b*c**5*s**4 - 65*a**18*b**2*c**5*s**4 -
        259*a**17*b**3*c**5*s**4 - 313*a**16*b**4*c**5*s**4 -
        250*a**15*b**5*c**5*s**4 - 8*a**14*b**6*c**5*s**4 +
        14*a**13*b**7*c**5*s**4 + 52*a**12*b**8*c**5*s**4 +
        14*a**11*b**9*c**5*s**4 + 5*a**10*b**10*c**5*s**4 -
        11*a**18*b*c**6*s**4 - 75*a**17*b**2*c**6*s**4 -
        132*a**16*b**3*c**6*s**4 - 159*a**15*b**4*c**6*s**4 -
        8*a**14*b**5*c**6*s**4 + 66*a**12*b**7*c**6*s**4 +
        2*a**11*b**8*c**6*s**4 - 23*a**10*b**9*c**6*s**4 -
        45*a**9*b**10*c**6*s**4 - 13*a**8*b**11*c**6*s**4 -
        5*a**17*b*c**7*s**4 - 17*a**16*b**2*c**7*s**4 -
        34*a**15*b**3*c**7*s**4 + 16*a**14*b**4*c**7*s**4 +
        14*a**13*b**5*c**7*s**4 + 66*a**12*b**6*c**7*s**4 -
        13*a**11*b**7*c**7*s**4 - 96*a**10*b**8*c**7*s**4 -
        208*a**9*b**9*c**7*s**4 - 129*a**8*b**10*c**7*s**4 -
        32*a**7*b**11*c**7*s**4 + 2*a**15*b**2*c**8*s**4 +
        12*a**14*b**3*c**8*s**4 + 20*a**13*b**4*c**8*s**4 +
        52*a**12*b**5*c**8*s**4 + 2*a**11*b**6*c**8*s**4 -
        96*a**10*b**7*c**8*s**4 - 331*a**9*b**8*c**8*s**4 -
        324*a**8*b**9*c**8*s**4 - 142*a**7*b**10*c**8*s**4 -
        15*a**6*b**11*c**8*s**4 + 6*a**13*b**3*c**9*s**4 +
        18*a**12*b**4*c**9*s**4 + 14*a**11*b**5*c**9*s**4 -
        23*a**10*b**6*c**9*s**4 - 208*a**9*b**7*c**9*s**4 -
        324*a**8*b**8*c**9*s**4 - 214*a**7*b**9*c**9*s**4 -
        41*a**6*b**10*c**9*s**4 + 2*a**5*b**11*c**9*s**4 +
        5*a**11*b**4*c**10*s**4 + 5*a**10*b**5*c**10*s**4 -
        45*a**9*b**6*c**10*s**4 - 129*a**8*b**7*c**10*s**4 -
        142*a**7*b**8*c**10*s**4 - 41*a**6*b**9*c**10*s**4 +
        3*a**5*b**10*c**10*s**4 - 2*a**4*b**11*c**10*s**4 -
        13*a**8*b**6*c**11*s**4 - 32*a**7*b**7*c**11*s**4 -
        15*a**6*b**8*c**11*s**4 + 2*a**5*b**9*c**11*s**4 -
        2*a**4*b**10*c**11*s**4 + a**22*b*s**6 - 2*a**21*b**2*s**6 +
        2*a**20*b**3*s**6 - a**19*b**4*s**6 + a**22*c*s**6 -
        3*a**21*b*c*s**6 + 4*a**20*b**2*c*s**6 - 5*a**19*b**3*c*s**6 +
        5*a**18*b**4*c*s**6 - 5*a**17*b**5*c*s**6 +
        2*a**16*b**6*c*s**6 - 2*a**21*c**2*s**6 + 4*a**20*b*c**2*s**6
        - 8*a**19*b**2*c**2*s**6 + 12*a**18*b**3*c**2*s**6 -
        12*a**17*b**4*c**2*s**6 + 12*a**16*b**5*c**2*s**6 -
        6*a**15*b**6*c**2*s**6 + 4*a**14*b**7*c**2*s**6 +
        2*a**20*c**3*s**6 - 5*a**19*b*c**3*s**6 +
        12*a**18*b**2*c**3*s**6 - 14*a**17*b**3*c**3*s**6 +
        26*a**16*b**4*c**3*s**6 - 14*a**15*b**5*c**3*s**6 +
        15*a**14*b**6*c**3*s**6 - 5*a**13*b**7*c**3*s**6 +
        5*a**12*b**8*c**3*s**6 - a**19*c**4*s**6 + 5*a**18*b*c**4*s**6
        - 12*a**17*b**2*c**4*s**6 + 26*a**16*b**3*c**4*s**6 -
        18*a**15*b**4*c**4*s**6 + 28*a**14*b**5*c**4*s**6 -
        15*a**13*b**6*c**4*s**6 + 16*a**12*b**7*c**4*s**6 -
        2*a**11*b**8*c**4*s**6 + 3*a**10*b**9*c**4*s**6 -
        5*a**17*b*c**5*s**6 + 12*a**16*b**2*c**5*s**6 -
        14*a**15*b**3*c**5*s**6 + 28*a**14*b**4*c**5*s**6 -
        20*a**13*b**5*c**5*s**6 + 24*a**12*b**6*c**5*s**6 -
        7*a**11*b**7*c**5*s**6 + 8*a**10*b**8*c**5*s**6 -
        3*a**9*b**9*c**5*s**6 + 2*a**16*b*c**6*s**6 -
        6*a**15*b**2*c**6*s**6 + 15*a**14*b**3*c**6*s**6 -
        15*a**13*b**4*c**6*s**6 + 24*a**12*b**5*c**6*s**6 -
        11*a**11*b**6*c**6*s**6 + 12*a**10*b**7*c**6*s**6 -
        4*a**9*b**8*c**6*s**6 - a**7*b**10*c**6*s**6 +
        4*a**14*b**2*c**7*s**6 - 5*a**13*b**3*c**7*s**6 +
        16*a**12*b**4*c**7*s**6 - 7*a**11*b**5*c**7*s**6 +
        12*a**10*b**6*c**7*s**6 + 8*a**8*b**8*c**7*s**6 +
        2*a**7*b**9*c**7*s**6 - a**6*b**10*c**7*s**6 +
        5*a**12*b**3*c**8*s**6 - 2*a**11*b**4*c**8*s**6 +
        8*a**10*b**5*c**8*s**6 - 4*a**9*b**6*c**8*s**6 +
        8*a**8*b**7*c**8*s**6 + 6*a**7*b**8*c**8*s**6 -
        3*a**6*b**9*c**8*s**6 + 3*a**10*b**4*c**9*s**6 -
        3*a**9*b**5*c**9*s**6 + 2*a**7*b**7*c**9*s**6 -
        3*a**6*b**8*c**9*s**6 - a**7*b**6*c**10*s**6 -
        a**6*b**7*c**10*s**6)/(a**25*b*s**3 - 3*a**24*b**2*s**3 +
        5*a**23*b**3*s**3 - 6*a**22*b**4*s**3 + 5*a**21*b**5*s**3 -
        3*a**20*b**6*s**3 + a**19*b**7*s**3 + a**25*c*s**3 -
        5*a**24*b*c*s**3 + 13*a**23*b**2*c*s**3 - 23*a**22*b**3*c*s**3
        + 30*a**21*b**4*c*s**3 - 30*a**20*b**5*c*s**3 +
        23*a**19*b**6*c*s**3 - 13*a**18*b**7*c*s**3 +
        5*a**17*b**8*c*s**3 - a**16*b**9*c*s**3 - 3*a**24*c**2*s**3 +
        13*a**23*b*c**2*s**3 - 33*a**22*b**2*c**2*s**3 +
        60*a**21*b**3*c**2*s**3 - 83*a**20*b**4*c**2*s**3 +
        91*a**19*b**5*c**2*s**3 - 79*a**18*b**6*c**2*s**3 +
        54*a**17*b**7*c**2*s**3 - 28*a**16*b**8*c**2*s**3 +
        10*a**15*b**9*c**2*s**3 - 2*a**14*b**10*c**2*s**3 +
        5*a**23*c**3*s**3 - 23*a**22*b*c**3*s**3 +
        60*a**21*b**2*c**3*s**3 - 113*a**20*b**3*c**3*s**3 +
        164*a**19*b**4*c**3*s**3 - 191*a**18*b**5*c**3*s**3 +
        180*a**17*b**6*c**3*s**3 - 137*a**16*b**7*c**3*s**3 +
        83*a**15*b**8*c**3*s**3 - 38*a**14*b**9*c**3*s**3 +
        12*a**13*b**10*c**3*s**3 - 2*a**12*b**11*c**3*s**3 -
        6*a**22*c**4*s**3 + 30*a**21*b*c**4*s**3 -
        83*a**20*b**2*c**4*s**3 + 164*a**19*b**3*c**4*s**3 -
        250*a**18*b**4*c**4*s**3 + 307*a**17*b**5*c**4*s**3 -
        308*a**16*b**6*c**4*s**3 + 253*a**15*b**7*c**4*s**3 -
        169*a**14*b**8*c**4*s**3 + 89*a**13*b**9*c**4*s**3 -
        35*a**12*b**10*c**4*s**3 + 9*a**11*b**11*c**4*s**3 -
        a**10*b**12*c**4*s**3 + 5*a**21*c**5*s**3 -
        30*a**20*b*c**5*s**3 + 91*a**19*b**2*c**5*s**3 -
        191*a**18*b**3*c**5*s**3 + 307*a**17*b**4*c**5*s**3 -
        395*a**16*b**5*c**5*s**3 + 417*a**15*b**6*c**5*s**3 -
        363*a**14*b**7*c**5*s**3 + 260*a**13*b**8*c**5*s**3 -
        151*a**12*b**9*c**5*s**3 + 68*a**11*b**10*c**5*s**3 -
        22*a**10*b**11*c**5*s**3 + 4*a**9*b**12*c**5*s**3 -
        3*a**20*c**6*s**3 + 23*a**19*b*c**6*s**3 -
        79*a**18*b**2*c**6*s**3 + 180*a**17*b**3*c**6*s**3 -
        308*a**16*b**4*c**6*s**3 + 417*a**15*b**5*c**6*s**3 -
        461*a**14*b**6*c**6*s**3 + 420*a**13*b**7*c**6*s**3 -
        316*a**12*b**8*c**6*s**3 + 195*a**11*b**9*c**6*s**3 -
        96*a**10*b**10*c**6*s**3 + 36*a**9*b**11*c**6*s**3 -
        9*a**8*b**12*c**6*s**3 + a**7*b**13*c**6*s**3 +
        a**19*c**7*s**3 - 13*a**18*b*c**7*s**3 +
        54*a**17*b**2*c**7*s**3 - 137*a**16*b**3*c**7*s**3 +
        253*a**15*b**4*c**7*s**3 - 363*a**14*b**5*c**7*s**3 +
        420*a**13*b**6*c**7*s**3 - 398*a**12*b**7*c**7*s**3 +
        310*a**11*b**8*c**7*s**3 - 198*a**10*b**9*c**7*s**3 +
        102*a**9*b**10*c**7*s**3 - 41*a**8*b**11*c**7*s**3 +
        12*a**7*b**12*c**7*s**3 - 2*a**6*b**13*c**7*s**3 +
        5*a**17*b*c**8*s**3 - 28*a**16*b**2*c**8*s**3 +
        83*a**15*b**3*c**8*s**3 - 169*a**14*b**4*c**8*s**3 +
        260*a**13*b**5*c**8*s**3 - 316*a**12*b**6*c**8*s**3 +
        310*a**11*b**7*c**8*s**3 - 247*a**10*b**8*c**8*s**3 +
        159*a**9*b**9*c**8*s**3 - 82*a**8*b**10*c**8*s**3 +
        33*a**7*b**11*c**8*s**3 - 10*a**6*b**12*c**8*s**3 +
        2*a**5*b**13*c**8*s**3 - a**16*b*c**9*s**3 +
        10*a**15*b**2*c**9*s**3 - 38*a**14*b**3*c**9*s**3 +
        89*a**13*b**4*c**9*s**3 - 151*a**12*b**5*c**9*s**3 +
        195*a**11*b**6*c**9*s**3 - 198*a**10*b**7*c**9*s**3 +
        159*a**9*b**8*c**9*s**3 - 99*a**8*b**9*c**9*s**3 +
        47*a**7*b**10*c**9*s**3 - 16*a**6*b**11*c**9*s**3 +
        4*a**5*b**12*c**9*s**3 - a**4*b**13*c**9*s**3 -
        2*a**14*b**2*c**10*s**3 + 12*a**13*b**3*c**10*s**3 -
        35*a**12*b**4*c**10*s**3 + 68*a**11*b**5*c**10*s**3 -
        96*a**10*b**6*c**10*s**3 + 102*a**9*b**7*c**10*s**3 -
        82*a**8*b**8*c**10*s**3 + 47*a**7*b**9*c**10*s**3 -
        16*a**6*b**10*c**10*s**3 + 3*a**4*b**12*c**10*s**3 -
        a**3*b**13*c**10*s**3 - 2*a**12*b**3*c**11*s**3 +
        9*a**11*b**4*c**11*s**3 - 22*a**10*b**5*c**11*s**3 +
        36*a**9*b**6*c**11*s**3 - 41*a**8*b**7*c**11*s**3 +
        33*a**7*b**8*c**11*s**3 - 16*a**6*b**9*c**11*s**3 +
        7*a**4*b**11*c**11*s**3 - 6*a**3*b**12*c**11*s**3 +
        2*a**2*b**13*c**11*s**3 - a**10*b**4*c**12*s**3 +
        4*a**9*b**5*c**12*s**3 - 9*a**8*b**6*c**12*s**3 +
        12*a**7*b**7*c**12*s**3 - 10*a**6*b**8*c**12*s**3 +
        4*a**5*b**9*c**12*s**3 + 3*a**4*b**10*c**12*s**3 -
        6*a**3*b**11*c**12*s**3 + 5*a**2*b**12*c**12*s**3 -
        2*a*b**13*c**12*s**3 + a**7*b**6*c**13*s**3 -
        2*a**6*b**7*c**13*s**3 + 2*a**5*b**8*c**13*s**3 -
        a**4*b**9*c**13*s**3 - a**3*b**10*c**13*s**3 +
        2*a**2*b**11*c**13*s**3 - 2*a*b**12*c**13*s**3 +
        b**13*c**13*s**3), (a**13*b**13*c**3 - a**13*b**12*c**4 -
        a**12*b**13*c**4 + a**13*b**10*c**6 + a**10*b**13*c**6 -
        a**13*b**9*c**7 + a**12*b**10*c**7 + 4*a**11*b**11*c**7 +
        a**10*b**12*c**7 - a**9*b**13*c**7 + 7*a**12*b**9*c**8 +
        21*a**11*b**10*c**8 + 21*a**10*b**11*c**8 + 7*a**9*b**12*c**8
        + 3*a**12*b**8*c**9 + 21*a**11*b**9*c**9 + 33*a**10*b**10*c**9
        + 21*a**9*b**11*c**9 + 3*a**8*b**12*c**9 + 4*a**12*b**7*c**10
        + 24*a**11*b**8*c**10 + 52*a**10*b**9*c**10 +
        52*a**9*b**10*c**10 + 24*a**8*b**11*c**10 + 4*a**7*b**12*c**10
        + 5*a**10*b**8*c**11 + 11*a**9*b**9*c**11 + 5*a**8*b**10*c**11
        + 3*a**11*b**6*c**12 + 14*a**10*b**7*c**12 +
        26*a**9*b**8*c**12 + 26*a**8*b**9*c**12 + 14*a**7*b**10*c**12
        + 3*a**6*b**11*c**12 - a**11*b**5*c**13 - 6*a**10*b**6*c**13 -
        17*a**9*b**7*c**13 - 24*a**8*b**8*c**13 - 17*a**7*b**9*c**13 -
        6*a**6*b**10*c**13 - a**5*b**11*c**13 + 4*a**10*b**5*c**14 +
        15*a**9*b**6*c**14 + 27*a**8*b**7*c**14 + 27*a**7*b**8*c**14 +
        15*a**6*b**9*c**14 + 4*a**5*b**10*c**14 - a**10*b**4*c**15 -
        6*a**9*b**5*c**15 - 10*a**8*b**6*c**15 - 10*a**7*b**7*c**15 -
        10*a**6*b**8*c**15 - 6*a**5*b**9*c**15 - a**4*b**10*c**15 +
        4*a**9*b**4*c**16 + 25*a**8*b**5*c**16 + 54*a**7*b**6*c**16 +
        54*a**6*b**7*c**16 + 25*a**5*b**8*c**16 + 4*a**4*b**9*c**16 +
        9*a**8*b**4*c**17 + 31*a**7*b**5*c**17 + 44*a**6*b**6*c**17 +
        31*a**5*b**7*c**17 + 9*a**4*b**8*c**17 + 9*a**8*b**3*c**18 +
        39*a**7*b**4*c**18 + 71*a**6*b**5*c**18 + 71*a**5*b**6*c**18 +
        39*a**4*b**7*c**18 + 9*a**3*b**8*c**18 + 2*a**8*b**2*c**19 +
        12*a**7*b**3*c**19 + 28*a**6*b**4*c**19 + 36*a**5*b**5*c**19 +
        28*a**4*b**6*c**19 + 12*a**3*b**7*c**19 + 2*a**2*b**8*c**19 +
        2*a**7*b**2*c**20 + 9*a**6*b**3*c**20 + 17*a**5*b**4*c**20 +
        17*a**4*b**5*c**20 + 9*a**3*b**6*c**20 + 2*a**2*b**7*c**20 +
        a**12*b**12*c**3*s**2 - 3*a**12*b**11*c**4*s**2 -
        3*a**11*b**12*c**4*s**2 + a**12*b**10*c**5*s**2 +
        a**10*b**12*c**5*s**2 + 4*a**12*b**9*c**6*s**2 +
        10*a**11*b**10*c**6*s**2 + 10*a**10*b**11*c**6*s**2 +
        4*a**9*b**12*c**6*s**2 + 2*a**12*b**8*c**7*s**2 +
        13*a**11*b**9*c**7*s**2 + 25*a**10*b**10*c**7*s**2 +
        13*a**9*b**11*c**7*s**2 + 2*a**8*b**12*c**7*s**2 +
        6*a**12*b**7*c**8*s**2 + 22*a**11*b**8*c**8*s**2 +
        42*a**10*b**9*c**8*s**2 + 42*a**9*b**10*c**8*s**2 +
        22*a**8*b**11*c**8*s**2 + 6*a**7*b**12*c**8*s**2 +
        3*a**12*b**6*c**9*s**2 + 14*a**11*b**7*c**9*s**2 +
        30*a**10*b**8*c**9*s**2 + 36*a**9*b**9*c**9*s**2 +
        30*a**8*b**10*c**9*s**2 + 14*a**7*b**11*c**9*s**2 +
        3*a**6*b**12*c**9*s**2 + 11*a**11*b**6*c**10*s**2 +
        38*a**10*b**7*c**10*s**2 + 61*a**9*b**8*c**10*s**2 +
        61*a**8*b**9*c**10*s**2 + 38*a**7*b**10*c**10*s**2 +
        11*a**6*b**11*c**10*s**2 + a**11*b**5*c**11*s**2 +
        4*a**10*b**6*c**11*s**2 + 6*a**9*b**7*c**11*s**2 +
        6*a**8*b**8*c**11*s**2 + 6*a**7*b**9*c**11*s**2 +
        4*a**6*b**10*c**11*s**2 + a**5*b**11*c**11*s**2 -
        a**11*b**4*c**12*s**2 + 8*a**10*b**5*c**12*s**2 +
        32*a**9*b**6*c**12*s**2 + 47*a**8*b**7*c**12*s**2 +
        47*a**7*b**8*c**12*s**2 + 32*a**6*b**9*c**12*s**2 +
        8*a**5*b**10*c**12*s**2 - a**4*b**11*c**12*s**2 +
        a**10*b**4*c**13*s**2 + 3*a**9*b**5*c**13*s**2 -
        6*a**8*b**6*c**13*s**2 - 17*a**7*b**7*c**13*s**2 -
        6*a**6*b**8*c**13*s**2 + 3*a**5*b**9*c**13*s**2 +
        a**4*b**10*c**13*s**2 - a**10*b**3*c**14*s**2 +
        9*a**9*b**4*c**14*s**2 + 39*a**8*b**5*c**14*s**2 +
        67*a**7*b**6*c**14*s**2 + 67*a**6*b**7*c**14*s**2 +
        39*a**5*b**8*c**14*s**2 + 9*a**4*b**9*c**14*s**2 -
        a**3*b**10*c**14*s**2 + 2*a**9*b**3*c**15*s**2 +
        11*a**8*b**4*c**15*s**2 + 22*a**7*b**5*c**15*s**2 +
        25*a**6*b**6*c**15*s**2 + 22*a**5*b**7*c**15*s**2 +
        11*a**4*b**8*c**15*s**2 + 2*a**3*b**9*c**15*s**2 +
        19*a**8*b**3*c**16*s**2 + 65*a**7*b**4*c**16*s**2 +
        98*a**6*b**5*c**16*s**2 + 98*a**5*b**6*c**16*s**2 +
        65*a**4*b**7*c**16*s**2 + 19*a**3*b**8*c**16*s**2 +
        9*a**8*b**2*c**17*s**2 + 35*a**7*b**3*c**17*s**2 +
        45*a**6*b**4*c**17*s**2 + 42*a**5*b**5*c**17*s**2 +
        45*a**4*b**6*c**17*s**2 + 35*a**3*b**7*c**17*s**2 +
        9*a**2*b**8*c**17*s**2 + 2*a**8*b*c**18*s**2 +
        21*a**7*b**2*c**18*s**2 + 56*a**6*b**3*c**18*s**2 +
        80*a**5*b**4*c**18*s**2 + 80*a**4*b**5*c**18*s**2 +
        56*a**3*b**6*c**18*s**2 + 21*a**2*b**7*c**18*s**2 +
        2*a*b**8*c**18*s**2 + 4*a**7*b*c**19*s**2 +
        15*a**6*b**2*c**19*s**2 + 29*a**5*b**3*c**19*s**2 +
        34*a**4*b**4*c**19*s**2 + 29*a**3*b**5*c**19*s**2 +
        15*a**2*b**6*c**19*s**2 + 4*a*b**7*c**19*s**2 +
        2*a**6*b*c**20*s**2 + 13*a**5*b**2*c**20*s**2 +
        26*a**4*b**3*c**20*s**2 + 26*a**3*b**4*c**20*s**2 +
        13*a**2*b**5*c**20*s**2 + 2*a*b**6*c**20*s**2 -
        2*a**4*b**2*c**21*s**2 - 4*a**3*b**3*c**21*s**2 -
        2*a**2*b**4*c**21*s**2 - 2*a**11*b**10*c**4*s**4 -
        2*a**10*b**11*c**4*s**4 + 2*a**11*b**9*c**5*s**4 +
        3*a**10*b**10*c**5*s**4 + 2*a**9*b**11*c**5*s**4 -
        15*a**11*b**8*c**6*s**4 - 41*a**10*b**9*c**6*s**4 -
        41*a**9*b**10*c**6*s**4 - 15*a**8*b**11*c**6*s**4 -
        32*a**11*b**7*c**7*s**4 - 142*a**10*b**8*c**7*s**4 -
        214*a**9*b**9*c**7*s**4 - 142*a**8*b**10*c**7*s**4 -
        32*a**7*b**11*c**7*s**4 - 13*a**11*b**6*c**8*s**4 -
        129*a**10*b**7*c**8*s**4 - 324*a**9*b**8*c**8*s**4 -
        324*a**8*b**9*c**8*s**4 - 129*a**7*b**10*c**8*s**4 -
        13*a**6*b**11*c**8*s**4 - 45*a**10*b**6*c**9*s**4 -
        208*a**9*b**7*c**9*s**4 - 331*a**8*b**8*c**9*s**4 -
        208*a**7*b**9*c**9*s**4 - 45*a**6*b**10*c**9*s**4 +
        5*a**10*b**5*c**10*s**4 - 23*a**9*b**6*c**10*s**4 -
        96*a**8*b**7*c**10*s**4 - 96*a**7*b**8*c**10*s**4 -
        23*a**6*b**9*c**10*s**4 + 5*a**5*b**10*c**10*s**4 +
        5*a**10*b**4*c**11*s**4 + 14*a**9*b**5*c**11*s**4 +
        2*a**8*b**6*c**11*s**4 - 13*a**7*b**7*c**11*s**4 +
        2*a**6*b**8*c**11*s**4 + 14*a**5*b**9*c**11*s**4 +
        5*a**4*b**10*c**11*s**4 + 18*a**9*b**4*c**12*s**4 +
        52*a**8*b**5*c**12*s**4 + 66*a**7*b**6*c**12*s**4 +
        66*a**6*b**7*c**12*s**4 + 52*a**5*b**8*c**12*s**4 +
        18*a**4*b**9*c**12*s**4 + 6*a**9*b**3*c**13*s**4 +
        20*a**8*b**4*c**13*s**4 + 14*a**7*b**5*c**13*s**4 +
        14*a**5*b**7*c**13*s**4 + 20*a**4*b**8*c**13*s**4 +
        6*a**3*b**9*c**13*s**4 + 12*a**8*b**3*c**14*s**4 +
        16*a**7*b**4*c**14*s**4 - 8*a**6*b**5*c**14*s**4 -
        8*a**5*b**6*c**14*s**4 + 16*a**4*b**7*c**14*s**4 +
        12*a**3*b**8*c**14*s**4 + 2*a**8*b**2*c**15*s**4 -
        34*a**7*b**3*c**15*s**4 - 159*a**6*b**4*c**15*s**4 -
        250*a**5*b**5*c**15*s**4 - 159*a**4*b**6*c**15*s**4 -
        34*a**3*b**7*c**15*s**4 + 2*a**2*b**8*c**15*s**4 -
        17*a**7*b**2*c**16*s**4 - 132*a**6*b**3*c**16*s**4 -
        313*a**5*b**4*c**16*s**4 - 313*a**4*b**5*c**16*s**4 -
        132*a**3*b**6*c**16*s**4 - 17*a**2*b**7*c**16*s**4 -
        5*a**7*b*c**17*s**4 - 75*a**6*b**2*c**17*s**4 -
        259*a**5*b**3*c**17*s**4 - 373*a**4*b**4*c**17*s**4 -
        259*a**3*b**5*c**17*s**4 - 75*a**2*b**6*c**17*s**4 -
        5*a*b**7*c**17*s**4 - 11*a**6*b*c**18*s**4 -
        65*a**5*b**2*c**18*s**4 - 135*a**4*b**3*c**18*s**4 -
        135*a**3*b**4*c**18*s**4 - 65*a**2*b**5*c**18*s**4 -
        11*a*b**6*c**18*s**4 - 9*a**5*b*c**19*s**4 -
        28*a**4*b**2*c**19*s**4 - 41*a**3*b**3*c**19*s**4 -
        28*a**2*b**4*c**19*s**4 - 9*a*b**5*c**19*s**4 +
        5*a**4*b*c**20*s**4 + 9*a**3*b**2*c**20*s**4 +
        9*a**2*b**3*c**20*s**4 + 5*a*b**4*c**20*s**4 -
        4*a**3*b*c**21*s**4 - 7*a**2*b**2*c**21*s**4 -
        4*a*b**3*c**21*s**4 + a**2*b*c**22*s**4 + a*b**2*c**22*s**4 -
        a**10*b**7*c**6*s**6 - 3*a**9*b**8*c**6*s**6 -
        3*a**8*b**9*c**6*s**6 - a**7*b**10*c**6*s**6 -
        a**10*b**6*c**7*s**6 + 2*a**9*b**7*c**7*s**6 +
        6*a**8*b**8*c**7*s**6 + 2*a**7*b**9*c**7*s**6 -
        a**6*b**10*c**7*s**6 + 8*a**8*b**7*c**8*s**6 +
        8*a**7*b**8*c**8*s**6 - 3*a**9*b**5*c**9*s**6 -
        4*a**8*b**6*c**9*s**6 - 4*a**6*b**8*c**9*s**6 -
        3*a**5*b**9*c**9*s**6 + 3*a**9*b**4*c**10*s**6 +
        8*a**8*b**5*c**10*s**6 + 12*a**7*b**6*c**10*s**6 +
        12*a**6*b**7*c**10*s**6 + 8*a**5*b**8*c**10*s**6 +
        3*a**4*b**9*c**10*s**6 - 2*a**8*b**4*c**11*s**6 -
        7*a**7*b**5*c**11*s**6 - 11*a**6*b**6*c**11*s**6 -
        7*a**5*b**7*c**11*s**6 - 2*a**4*b**8*c**11*s**6 +
        5*a**8*b**3*c**12*s**6 + 16*a**7*b**4*c**12*s**6 +
        24*a**6*b**5*c**12*s**6 + 24*a**5*b**6*c**12*s**6 +
        16*a**4*b**7*c**12*s**6 + 5*a**3*b**8*c**12*s**6 -
        5*a**7*b**3*c**13*s**6 - 15*a**6*b**4*c**13*s**6 -
        20*a**5*b**5*c**13*s**6 - 15*a**4*b**6*c**13*s**6 -
        5*a**3*b**7*c**13*s**6 + 4*a**7*b**2*c**14*s**6 +
        15*a**6*b**3*c**14*s**6 + 28*a**5*b**4*c**14*s**6 +
        28*a**4*b**5*c**14*s**6 + 15*a**3*b**6*c**14*s**6 +
        4*a**2*b**7*c**14*s**6 - 6*a**6*b**2*c**15*s**6 -
        14*a**5*b**3*c**15*s**6 - 18*a**4*b**4*c**15*s**6 -
        14*a**3*b**5*c**15*s**6 - 6*a**2*b**6*c**15*s**6 +
        2*a**6*b*c**16*s**6 + 12*a**5*b**2*c**16*s**6 +
        26*a**4*b**3*c**16*s**6 + 26*a**3*b**4*c**16*s**6 +
        12*a**2*b**5*c**16*s**6 + 2*a*b**6*c**16*s**6 -
        5*a**5*b*c**17*s**6 - 12*a**4*b**2*c**17*s**6 -
        14*a**3*b**3*c**17*s**6 - 12*a**2*b**4*c**17*s**6 -
        5*a*b**5*c**17*s**6 + 5*a**4*b*c**18*s**6 +
        12*a**3*b**2*c**18*s**6 + 12*a**2*b**3*c**18*s**6 +
        5*a*b**4*c**18*s**6 - a**4*c**19*s**6 - 5*a**3*b*c**19*s**6 -
        8*a**2*b**2*c**19*s**6 - 5*a*b**3*c**19*s**6 - b**4*c**19*s**6
        + 2*a**3*c**20*s**6 + 4*a**2*b*c**20*s**6 +
        4*a*b**2*c**20*s**6 + 2*b**3*c**20*s**6 - 2*a**2*c**21*s**6 -
        3*a*b*c**21*s**6 - 2*b**2*c**21*s**6 + a*c**22*s**6 +
        b*c**22*s**6)/(a**13*b**13*s**3 - 2*a**13*b**12*c*s**3 -
        2*a**12*b**13*c*s**3 + 2*a**13*b**11*c**2*s**3 +
        5*a**12*b**12*c**2*s**3 + 2*a**11*b**13*c**2*s**3 -
        a**13*b**10*c**3*s**3 - 6*a**12*b**11*c**3*s**3 -
        6*a**11*b**12*c**3*s**3 - a**10*b**13*c**3*s**3 -
        a**13*b**9*c**4*s**3 + 3*a**12*b**10*c**4*s**3 +
        7*a**11*b**11*c**4*s**3 + 3*a**10*b**12*c**4*s**3 -
        a**9*b**13*c**4*s**3 + 2*a**13*b**8*c**5*s**3 +
        4*a**12*b**9*c**5*s**3 + 4*a**9*b**12*c**5*s**3 +
        2*a**8*b**13*c**5*s**3 - 2*a**13*b**7*c**6*s**3 -
        10*a**12*b**8*c**6*s**3 - 16*a**11*b**9*c**6*s**3 -
        16*a**10*b**10*c**6*s**3 - 16*a**9*b**11*c**6*s**3 -
        10*a**8*b**12*c**6*s**3 - 2*a**7*b**13*c**6*s**3 +
        a**13*b**6*c**7*s**3 + 12*a**12*b**7*c**7*s**3 +
        33*a**11*b**8*c**7*s**3 + 47*a**10*b**9*c**7*s**3 +
        47*a**9*b**10*c**7*s**3 + 33*a**8*b**11*c**7*s**3 +
        12*a**7*b**12*c**7*s**3 + a**6*b**13*c**7*s**3 -
        9*a**12*b**6*c**8*s**3 - 41*a**11*b**7*c**8*s**3 -
        82*a**10*b**8*c**8*s**3 - 99*a**9*b**9*c**8*s**3 -
        82*a**8*b**10*c**8*s**3 - 41*a**7*b**11*c**8*s**3 -
        9*a**6*b**12*c**8*s**3 + 4*a**12*b**5*c**9*s**3 +
        36*a**11*b**6*c**9*s**3 + 102*a**10*b**7*c**9*s**3 +
        159*a**9*b**8*c**9*s**3 + 159*a**8*b**9*c**9*s**3 +
        102*a**7*b**10*c**9*s**3 + 36*a**6*b**11*c**9*s**3 +
        4*a**5*b**12*c**9*s**3 - a**12*b**4*c**10*s**3 -
        22*a**11*b**5*c**10*s**3 - 96*a**10*b**6*c**10*s**3 -
        198*a**9*b**7*c**10*s**3 - 247*a**8*b**8*c**10*s**3 -
        198*a**7*b**9*c**10*s**3 - 96*a**6*b**10*c**10*s**3 -
        22*a**5*b**11*c**10*s**3 - a**4*b**12*c**10*s**3 +
        9*a**11*b**4*c**11*s**3 + 68*a**10*b**5*c**11*s**3 +
        195*a**9*b**6*c**11*s**3 + 310*a**8*b**7*c**11*s**3 +
        310*a**7*b**8*c**11*s**3 + 195*a**6*b**9*c**11*s**3 +
        68*a**5*b**10*c**11*s**3 + 9*a**4*b**11*c**11*s**3 -
        2*a**11*b**3*c**12*s**3 - 35*a**10*b**4*c**12*s**3 -
        151*a**9*b**5*c**12*s**3 - 316*a**8*b**6*c**12*s**3 -
        398*a**7*b**7*c**12*s**3 - 316*a**6*b**8*c**12*s**3 -
        151*a**5*b**9*c**12*s**3 - 35*a**4*b**10*c**12*s**3 -
        2*a**3*b**11*c**12*s**3 + 12*a**10*b**3*c**13*s**3 +
        89*a**9*b**4*c**13*s**3 + 260*a**8*b**5*c**13*s**3 +
        420*a**7*b**6*c**13*s**3 + 420*a**6*b**7*c**13*s**3 +
        260*a**5*b**8*c**13*s**3 + 89*a**4*b**9*c**13*s**3 +
        12*a**3*b**10*c**13*s**3 - 2*a**10*b**2*c**14*s**3 -
        38*a**9*b**3*c**14*s**3 - 169*a**8*b**4*c**14*s**3 -
        363*a**7*b**5*c**14*s**3 - 461*a**6*b**6*c**14*s**3 -
        363*a**5*b**7*c**14*s**3 - 169*a**4*b**8*c**14*s**3 -
        38*a**3*b**9*c**14*s**3 - 2*a**2*b**10*c**14*s**3 +
        10*a**9*b**2*c**15*s**3 + 83*a**8*b**3*c**15*s**3 +
        253*a**7*b**4*c**15*s**3 + 417*a**6*b**5*c**15*s**3 +
        417*a**5*b**6*c**15*s**3 + 253*a**4*b**7*c**15*s**3 +
        83*a**3*b**8*c**15*s**3 + 10*a**2*b**9*c**15*s**3 -
        a**9*b*c**16*s**3 - 28*a**8*b**2*c**16*s**3 -
        137*a**7*b**3*c**16*s**3 - 308*a**6*b**4*c**16*s**3 -
        395*a**5*b**5*c**16*s**3 - 308*a**4*b**6*c**16*s**3 -
        137*a**3*b**7*c**16*s**3 - 28*a**2*b**8*c**16*s**3 -
        a*b**9*c**16*s**3 + 5*a**8*b*c**17*s**3 +
        54*a**7*b**2*c**17*s**3 + 180*a**6*b**3*c**17*s**3 +
        307*a**5*b**4*c**17*s**3 + 307*a**4*b**5*c**17*s**3 +
        180*a**3*b**6*c**17*s**3 + 54*a**2*b**7*c**17*s**3 +
        5*a*b**8*c**17*s**3 - 13*a**7*b*c**18*s**3 -
        79*a**6*b**2*c**18*s**3 - 191*a**5*b**3*c**18*s**3 -
        250*a**4*b**4*c**18*s**3 - 191*a**3*b**5*c**18*s**3 -
        79*a**2*b**6*c**18*s**3 - 13*a*b**7*c**18*s**3 +
        a**7*c**19*s**3 + 23*a**6*b*c**19*s**3 +
        91*a**5*b**2*c**19*s**3 + 164*a**4*b**3*c**19*s**3 +
        164*a**3*b**4*c**19*s**3 + 91*a**2*b**5*c**19*s**3 +
        23*a*b**6*c**19*s**3 + b**7*c**19*s**3 - 3*a**6*c**20*s**3 -
        30*a**5*b*c**20*s**3 - 83*a**4*b**2*c**20*s**3 -
        113*a**3*b**3*c**20*s**3 - 83*a**2*b**4*c**20*s**3 -
        30*a*b**5*c**20*s**3 - 3*b**6*c**20*s**3 + 5*a**5*c**21*s**3 +
        30*a**4*b*c**21*s**3 + 60*a**3*b**2*c**21*s**3 +
        60*a**2*b**3*c**21*s**3 + 30*a*b**4*c**21*s**3 +
        5*b**5*c**21*s**3 - 6*a**4*c**22*s**3 - 23*a**3*b*c**22*s**3 -
        33*a**2*b**2*c**22*s**3 - 23*a*b**3*c**22*s**3 -
        6*b**4*c**22*s**3 + 5*a**3*c**23*s**3 + 13*a**2*b*c**23*s**3 +
        13*a*b**2*c**23*s**3 + 5*b**3*c**23*s**3 - 3*a**2*c**24*s**3 -
        5*a*b*c**24*s**3 - 3*b**2*c**24*s**3 + a*c**25*s**3 +
        b*c**25*s**3), (2*a**8*b**19*c**2 + 2*a**7*b**20*c**2 +
        9*a**8*b**18*c**3 + 12*a**7*b**19*c**3 + 9*a**6*b**20*c**3 -
        a**10*b**15*c**4 + 4*a**9*b**16*c**4 + 9*a**8*b**17*c**4 +
        39*a**7*b**18*c**4 + 28*a**6*b**19*c**4 + 17*a**5*b**20*c**4 -
        a**11*b**13*c**5 + 4*a**10*b**14*c**5 - 6*a**9*b**15*c**5 +
        25*a**8*b**16*c**5 + 31*a**7*b**17*c**5 + 71*a**6*b**18*c**5 +
        36*a**5*b**19*c**5 + 17*a**4*b**20*c**5 + 3*a**11*b**12*c**6 -
        6*a**10*b**13*c**6 + 15*a**9*b**14*c**6 - 10*a**8*b**15*c**6 +
        54*a**7*b**16*c**6 + 44*a**6*b**17*c**6 + 71*a**5*b**18*c**6 +
        28*a**4*b**19*c**6 + 9*a**3*b**20*c**6 + 4*a**12*b**10*c**7 +
        14*a**10*b**12*c**7 - 17*a**9*b**13*c**7 + 27*a**8*b**14*c**7
        - 10*a**7*b**15*c**7 + 54*a**6*b**16*c**7 + 31*a**5*b**17*c**7
        + 39*a**4*b**18*c**7 + 12*a**3*b**19*c**7 + 2*a**2*b**20*c**7
        + 3*a**12*b**9*c**8 + 24*a**11*b**10*c**8 + 5*a**10*b**11*c**8
        + 26*a**9*b**12*c**8 - 24*a**8*b**13*c**8 + 27*a**7*b**14*c**8
        - 10*a**6*b**15*c**8 + 25*a**5*b**16*c**8 + 9*a**4*b**17*c**8
        + 9*a**3*b**18*c**8 + 2*a**2*b**19*c**8 - a**13*b**7*c**9 +
        7*a**12*b**8*c**9 + 21*a**11*b**9*c**9 + 52*a**10*b**10*c**9 +
        11*a**9*b**11*c**9 + 26*a**8*b**12*c**9 - 17*a**7*b**13*c**9 +
        15*a**6*b**14*c**9 - 6*a**5*b**15*c**9 + 4*a**4*b**16*c**9 +
        a**13*b**6*c**10 + a**12*b**7*c**10 + 21*a**11*b**8*c**10 +
        33*a**10*b**9*c**10 + 52*a**9*b**10*c**10 + 5*a**8*b**11*c**10
        + 14*a**7*b**12*c**10 - 6*a**6*b**13*c**10 +
        4*a**5*b**14*c**10 - a**4*b**15*c**10 + 4*a**11*b**7*c**11 +
        21*a**10*b**8*c**11 + 21*a**9*b**9*c**11 + 24*a**8*b**10*c**11
        + 3*a**6*b**12*c**11 - a**5*b**13*c**11 - a**13*b**4*c**12 +
        a**10*b**7*c**12 + 7*a**9*b**8*c**12 + 3*a**8*b**9*c**12 +
        4*a**7*b**10*c**12 + a**13*b**3*c**13 - a**12*b**4*c**13 +
        a**10*b**6*c**13 - a**9*b**7*c**13 + 2*a**8*b**18*c*s**2 +
        4*a**7*b**19*c*s**2 + 2*a**6*b**20*c*s**2 +
        9*a**8*b**17*c**2*s**2 + 21*a**7*b**18*c**2*s**2 +
        15*a**6*b**19*c**2*s**2 + 13*a**5*b**20*c**2*s**2 -
        2*a**4*b**21*c**2*s**2 - a**10*b**14*c**3*s**2 +
        2*a**9*b**15*c**3*s**2 + 19*a**8*b**16*c**3*s**2 +
        35*a**7*b**17*c**3*s**2 + 56*a**6*b**18*c**3*s**2 +
        29*a**5*b**19*c**3*s**2 + 26*a**4*b**20*c**3*s**2 -
        4*a**3*b**21*c**3*s**2 - a**11*b**12*c**4*s**2 +
        a**10*b**13*c**4*s**2 + 9*a**9*b**14*c**4*s**2 +
        11*a**8*b**15*c**4*s**2 + 65*a**7*b**16*c**4*s**2 +
        45*a**6*b**17*c**4*s**2 + 80*a**5*b**18*c**4*s**2 +
        34*a**4*b**19*c**4*s**2 + 26*a**3*b**20*c**4*s**2 -
        2*a**2*b**21*c**4*s**2 + a**11*b**11*c**5*s**2 +
        8*a**10*b**12*c**5*s**2 + 3*a**9*b**13*c**5*s**2 +
        39*a**8*b**14*c**5*s**2 + 22*a**7*b**15*c**5*s**2 +
        98*a**6*b**16*c**5*s**2 + 42*a**5*b**17*c**5*s**2 +
        80*a**4*b**18*c**5*s**2 + 29*a**3*b**19*c**5*s**2 +
        13*a**2*b**20*c**5*s**2 + 3*a**12*b**9*c**6*s**2 +
        11*a**11*b**10*c**6*s**2 + 4*a**10*b**11*c**6*s**2 +
        32*a**9*b**12*c**6*s**2 - 6*a**8*b**13*c**6*s**2 +
        67*a**7*b**14*c**6*s**2 + 25*a**6*b**15*c**6*s**2 +
        98*a**5*b**16*c**6*s**2 + 45*a**4*b**17*c**6*s**2 +
        56*a**3*b**18*c**6*s**2 + 15*a**2*b**19*c**6*s**2 +
        2*a*b**20*c**6*s**2 + 6*a**12*b**8*c**7*s**2 +
        14*a**11*b**9*c**7*s**2 + 38*a**10*b**10*c**7*s**2 +
        6*a**9*b**11*c**7*s**2 + 47*a**8*b**12*c**7*s**2 -
        17*a**7*b**13*c**7*s**2 + 67*a**6*b**14*c**7*s**2 +
        22*a**5*b**15*c**7*s**2 + 65*a**4*b**16*c**7*s**2 +
        35*a**3*b**17*c**7*s**2 + 21*a**2*b**18*c**7*s**2 +
        4*a*b**19*c**7*s**2 + 2*a**12*b**7*c**8*s**2 +
        22*a**11*b**8*c**8*s**2 + 30*a**10*b**9*c**8*s**2 +
        61*a**9*b**10*c**8*s**2 + 6*a**8*b**11*c**8*s**2 +
        47*a**7*b**12*c**8*s**2 - 6*a**6*b**13*c**8*s**2 +
        39*a**5*b**14*c**8*s**2 + 11*a**4*b**15*c**8*s**2 +
        19*a**3*b**16*c**8*s**2 + 9*a**2*b**17*c**8*s**2 +
        2*a*b**18*c**8*s**2 + 4*a**12*b**6*c**9*s**2 +
        13*a**11*b**7*c**9*s**2 + 42*a**10*b**8*c**9*s**2 +
        36*a**9*b**9*c**9*s**2 + 61*a**8*b**10*c**9*s**2 +
        6*a**7*b**11*c**9*s**2 + 32*a**6*b**12*c**9*s**2 +
        3*a**5*b**13*c**9*s**2 + 9*a**4*b**14*c**9*s**2 +
        2*a**3*b**15*c**9*s**2 + a**12*b**5*c**10*s**2 +
        10*a**11*b**6*c**10*s**2 + 25*a**10*b**7*c**10*s**2 +
        42*a**9*b**8*c**10*s**2 + 30*a**8*b**9*c**10*s**2 +
        38*a**7*b**10*c**10*s**2 + 4*a**6*b**11*c**10*s**2 +
        8*a**5*b**12*c**10*s**2 + a**4*b**13*c**10*s**2 -
        a**3*b**14*c**10*s**2 - 3*a**12*b**4*c**11*s**2 +
        10*a**10*b**6*c**11*s**2 + 13*a**9*b**7*c**11*s**2 +
        22*a**8*b**8*c**11*s**2 + 14*a**7*b**9*c**11*s**2 +
        11*a**6*b**10*c**11*s**2 + a**5*b**11*c**11*s**2 -
        a**4*b**12*c**11*s**2 + a**12*b**3*c**12*s**2 -
        3*a**11*b**4*c**12*s**2 + a**10*b**5*c**12*s**2 +
        4*a**9*b**6*c**12*s**2 + 2*a**8*b**7*c**12*s**2 +
        6*a**7*b**8*c**12*s**2 + 3*a**6*b**9*c**12*s**2 -
        5*a**7*b**17*c*s**4 - 11*a**6*b**18*c*s**4 -
        9*a**5*b**19*c*s**4 + 5*a**4*b**20*c*s**4 -
        4*a**3*b**21*c*s**4 + a**2*b**22*c*s**4 +
        2*a**8*b**15*c**2*s**4 - 17*a**7*b**16*c**2*s**4 -
        75*a**6*b**17*c**2*s**4 - 65*a**5*b**18*c**2*s**4 -
        28*a**4*b**19*c**2*s**4 + 9*a**3*b**20*c**2*s**4 -
        7*a**2*b**21*c**2*s**4 + a*b**22*c**2*s**4 +
        6*a**9*b**13*c**3*s**4 + 12*a**8*b**14*c**3*s**4 -
        34*a**7*b**15*c**3*s**4 - 132*a**6*b**16*c**3*s**4 -
        259*a**5*b**17*c**3*s**4 - 135*a**4*b**18*c**3*s**4 -
        41*a**3*b**19*c**3*s**4 + 9*a**2*b**20*c**3*s**4 -
        4*a*b**21*c**3*s**4 + 5*a**10*b**11*c**4*s**4 +
        18*a**9*b**12*c**4*s**4 + 20*a**8*b**13*c**4*s**4 +
        16*a**7*b**14*c**4*s**4 - 159*a**6*b**15*c**4*s**4 -
        313*a**5*b**16*c**4*s**4 - 373*a**4*b**17*c**4*s**4 -
        135*a**3*b**18*c**4*s**4 - 28*a**2*b**19*c**4*s**4 +
        5*a*b**20*c**4*s**4 + 5*a**10*b**10*c**5*s**4 +
        14*a**9*b**11*c**5*s**4 + 52*a**8*b**12*c**5*s**4 +
        14*a**7*b**13*c**5*s**4 - 8*a**6*b**14*c**5*s**4 -
        250*a**5*b**15*c**5*s**4 - 313*a**4*b**16*c**5*s**4 -
        259*a**3*b**17*c**5*s**4 - 65*a**2*b**18*c**5*s**4 -
        9*a*b**19*c**5*s**4 - 13*a**11*b**8*c**6*s**4 -
        45*a**10*b**9*c**6*s**4 - 23*a**9*b**10*c**6*s**4 +
        2*a**8*b**11*c**6*s**4 + 66*a**7*b**12*c**6*s**4 -
        8*a**5*b**14*c**6*s**4 - 159*a**4*b**15*c**6*s**4 -
        132*a**3*b**16*c**6*s**4 - 75*a**2*b**17*c**6*s**4 -
        11*a*b**18*c**6*s**4 - 32*a**11*b**7*c**7*s**4 -
        129*a**10*b**8*c**7*s**4 - 208*a**9*b**9*c**7*s**4 -
        96*a**8*b**10*c**7*s**4 - 13*a**7*b**11*c**7*s**4 +
        66*a**6*b**12*c**7*s**4 + 14*a**5*b**13*c**7*s**4 +
        16*a**4*b**14*c**7*s**4 - 34*a**3*b**15*c**7*s**4 -
        17*a**2*b**16*c**7*s**4 - 5*a*b**17*c**7*s**4 -
        15*a**11*b**6*c**8*s**4 - 142*a**10*b**7*c**8*s**4 -
        324*a**9*b**8*c**8*s**4 - 331*a**8*b**9*c**8*s**4 -
        96*a**7*b**10*c**8*s**4 + 2*a**6*b**11*c**8*s**4 +
        52*a**5*b**12*c**8*s**4 + 20*a**4*b**13*c**8*s**4 +
        12*a**3*b**14*c**8*s**4 + 2*a**2*b**15*c**8*s**4 +
        2*a**11*b**5*c**9*s**4 - 41*a**10*b**6*c**9*s**4 -
        214*a**9*b**7*c**9*s**4 - 324*a**8*b**8*c**9*s**4 -
        208*a**7*b**9*c**9*s**4 - 23*a**6*b**10*c**9*s**4 +
        14*a**5*b**11*c**9*s**4 + 18*a**4*b**12*c**9*s**4 +
        6*a**3*b**13*c**9*s**4 - 2*a**11*b**4*c**10*s**4 +
        3*a**10*b**5*c**10*s**4 - 41*a**9*b**6*c**10*s**4 -
        142*a**8*b**7*c**10*s**4 - 129*a**7*b**8*c**10*s**4 -
        45*a**6*b**9*c**10*s**4 + 5*a**5*b**10*c**10*s**4 +
        5*a**4*b**11*c**10*s**4 - 2*a**10*b**4*c**11*s**4 +
        2*a**9*b**5*c**11*s**4 - 15*a**8*b**6*c**11*s**4 -
        32*a**7*b**7*c**11*s**4 - 13*a**6*b**8*c**11*s**4 -
        a**4*b**19*s**6 + 2*a**3*b**20*s**6 - 2*a**2*b**21*s**6 +
        a*b**22*s**6 + 2*a**6*b**16*c*s**6 - 5*a**5*b**17*c*s**6 +
        5*a**4*b**18*c*s**6 - 5*a**3*b**19*c*s**6 +
        4*a**2*b**20*c*s**6 - 3*a*b**21*c*s**6 + b**22*c*s**6 +
        4*a**7*b**14*c**2*s**6 - 6*a**6*b**15*c**2*s**6 +
        12*a**5*b**16*c**2*s**6 - 12*a**4*b**17*c**2*s**6 +
        12*a**3*b**18*c**2*s**6 - 8*a**2*b**19*c**2*s**6 +
        4*a*b**20*c**2*s**6 - 2*b**21*c**2*s**6 +
        5*a**8*b**12*c**3*s**6 - 5*a**7*b**13*c**3*s**6 +
        15*a**6*b**14*c**3*s**6 - 14*a**5*b**15*c**3*s**6 +
        26*a**4*b**16*c**3*s**6 - 14*a**3*b**17*c**3*s**6 +
        12*a**2*b**18*c**3*s**6 - 5*a*b**19*c**3*s**6 +
        2*b**20*c**3*s**6 + 3*a**9*b**10*c**4*s**6 -
        2*a**8*b**11*c**4*s**6 + 16*a**7*b**12*c**4*s**6 -
        15*a**6*b**13*c**4*s**6 + 28*a**5*b**14*c**4*s**6 -
        18*a**4*b**15*c**4*s**6 + 26*a**3*b**16*c**4*s**6 -
        12*a**2*b**17*c**4*s**6 + 5*a*b**18*c**4*s**6 -
        b**19*c**4*s**6 - 3*a**9*b**9*c**5*s**6 +
        8*a**8*b**10*c**5*s**6 - 7*a**7*b**11*c**5*s**6 +
        24*a**6*b**12*c**5*s**6 - 20*a**5*b**13*c**5*s**6 +
        28*a**4*b**14*c**5*s**6 - 14*a**3*b**15*c**5*s**6 +
        12*a**2*b**16*c**5*s**6 - 5*a*b**17*c**5*s**6 -
        a**10*b**7*c**6*s**6 - 4*a**8*b**9*c**6*s**6 +
        12*a**7*b**10*c**6*s**6 - 11*a**6*b**11*c**6*s**6 +
        24*a**5*b**12*c**6*s**6 - 15*a**4*b**13*c**6*s**6 +
        15*a**3*b**14*c**6*s**6 - 6*a**2*b**15*c**6*s**6 +
        2*a*b**16*c**6*s**6 - a**10*b**6*c**7*s**6 +
        2*a**9*b**7*c**7*s**6 + 8*a**8*b**8*c**7*s**6 +
        12*a**6*b**10*c**7*s**6 - 7*a**5*b**11*c**7*s**6 +
        16*a**4*b**12*c**7*s**6 - 5*a**3*b**13*c**7*s**6 +
        4*a**2*b**14*c**7*s**6 - 3*a**9*b**6*c**8*s**6 +
        6*a**8*b**7*c**8*s**6 + 8*a**7*b**8*c**8*s**6 -
        4*a**6*b**9*c**8*s**6 + 8*a**5*b**10*c**8*s**6 -
        2*a**4*b**11*c**8*s**6 + 5*a**3*b**12*c**8*s**6 -
        3*a**8*b**6*c**9*s**6 + 2*a**7*b**7*c**9*s**6 -
        3*a**5*b**9*c**9*s**6 + 3*a**4*b**10*c**9*s**6 -
        a**7*b**6*c**10*s**6 - a**6*b**7*c**10*s**6)/(a**7*b**19*s**3
        - 3*a**6*b**20*s**3 + 5*a**5*b**21*s**3 - 6*a**4*b**22*s**3 +
        5*a**3*b**23*s**3 - 3*a**2*b**24*s**3 + a*b**25*s**3 -
        a**9*b**16*c*s**3 + 5*a**8*b**17*c*s**3 - 13*a**7*b**18*c*s**3
        + 23*a**6*b**19*c*s**3 - 30*a**5*b**20*c*s**3 +
        30*a**4*b**21*c*s**3 - 23*a**3*b**22*c*s**3 +
        13*a**2*b**23*c*s**3 - 5*a*b**24*c*s**3 + b**25*c*s**3 -
        2*a**10*b**14*c**2*s**3 + 10*a**9*b**15*c**2*s**3 -
        28*a**8*b**16*c**2*s**3 + 54*a**7*b**17*c**2*s**3 -
        79*a**6*b**18*c**2*s**3 + 91*a**5*b**19*c**2*s**3 -
        83*a**4*b**20*c**2*s**3 + 60*a**3*b**21*c**2*s**3 -
        33*a**2*b**22*c**2*s**3 + 13*a*b**23*c**2*s**3 -
        3*b**24*c**2*s**3 - 2*a**11*b**12*c**3*s**3 +
        12*a**10*b**13*c**3*s**3 - 38*a**9*b**14*c**3*s**3 +
        83*a**8*b**15*c**3*s**3 - 137*a**7*b**16*c**3*s**3 +
        180*a**6*b**17*c**3*s**3 - 191*a**5*b**18*c**3*s**3 +
        164*a**4*b**19*c**3*s**3 - 113*a**3*b**20*c**3*s**3 +
        60*a**2*b**21*c**3*s**3 - 23*a*b**22*c**3*s**3 +
        5*b**23*c**3*s**3 - a**12*b**10*c**4*s**3 +
        9*a**11*b**11*c**4*s**3 - 35*a**10*b**12*c**4*s**3 +
        89*a**9*b**13*c**4*s**3 - 169*a**8*b**14*c**4*s**3 +
        253*a**7*b**15*c**4*s**3 - 308*a**6*b**16*c**4*s**3 +
        307*a**5*b**17*c**4*s**3 - 250*a**4*b**18*c**4*s**3 +
        164*a**3*b**19*c**4*s**3 - 83*a**2*b**20*c**4*s**3 +
        30*a*b**21*c**4*s**3 - 6*b**22*c**4*s**3 +
        4*a**12*b**9*c**5*s**3 - 22*a**11*b**10*c**5*s**3 +
        68*a**10*b**11*c**5*s**3 - 151*a**9*b**12*c**5*s**3 +
        260*a**8*b**13*c**5*s**3 - 363*a**7*b**14*c**5*s**3 +
        417*a**6*b**15*c**5*s**3 - 395*a**5*b**16*c**5*s**3 +
        307*a**4*b**17*c**5*s**3 - 191*a**3*b**18*c**5*s**3 +
        91*a**2*b**19*c**5*s**3 - 30*a*b**20*c**5*s**3 +
        5*b**21*c**5*s**3 + a**13*b**7*c**6*s**3 -
        9*a**12*b**8*c**6*s**3 + 36*a**11*b**9*c**6*s**3 -
        96*a**10*b**10*c**6*s**3 + 195*a**9*b**11*c**6*s**3 -
        316*a**8*b**12*c**6*s**3 + 420*a**7*b**13*c**6*s**3 -
        461*a**6*b**14*c**6*s**3 + 417*a**5*b**15*c**6*s**3 -
        308*a**4*b**16*c**6*s**3 + 180*a**3*b**17*c**6*s**3 -
        79*a**2*b**18*c**6*s**3 + 23*a*b**19*c**6*s**3 -
        3*b**20*c**6*s**3 - 2*a**13*b**6*c**7*s**3 +
        12*a**12*b**7*c**7*s**3 - 41*a**11*b**8*c**7*s**3 +
        102*a**10*b**9*c**7*s**3 - 198*a**9*b**10*c**7*s**3 +
        310*a**8*b**11*c**7*s**3 - 398*a**7*b**12*c**7*s**3 +
        420*a**6*b**13*c**7*s**3 - 363*a**5*b**14*c**7*s**3 +
        253*a**4*b**15*c**7*s**3 - 137*a**3*b**16*c**7*s**3 +
        54*a**2*b**17*c**7*s**3 - 13*a*b**18*c**7*s**3 +
        b**19*c**7*s**3 + 2*a**13*b**5*c**8*s**3 -
        10*a**12*b**6*c**8*s**3 + 33*a**11*b**7*c**8*s**3 -
        82*a**10*b**8*c**8*s**3 + 159*a**9*b**9*c**8*s**3 -
        247*a**8*b**10*c**8*s**3 + 310*a**7*b**11*c**8*s**3 -
        316*a**6*b**12*c**8*s**3 + 260*a**5*b**13*c**8*s**3 -
        169*a**4*b**14*c**8*s**3 + 83*a**3*b**15*c**8*s**3 -
        28*a**2*b**16*c**8*s**3 + 5*a*b**17*c**8*s**3 -
        a**13*b**4*c**9*s**3 + 4*a**12*b**5*c**9*s**3 -
        16*a**11*b**6*c**9*s**3 + 47*a**10*b**7*c**9*s**3 -
        99*a**9*b**8*c**9*s**3 + 159*a**8*b**9*c**9*s**3 -
        198*a**7*b**10*c**9*s**3 + 195*a**6*b**11*c**9*s**3 -
        151*a**5*b**12*c**9*s**3 + 89*a**4*b**13*c**9*s**3 -
        38*a**3*b**14*c**9*s**3 + 10*a**2*b**15*c**9*s**3 -
        a*b**16*c**9*s**3 - a**13*b**3*c**10*s**3 +
        3*a**12*b**4*c**10*s**3 - 16*a**10*b**6*c**10*s**3 +
        47*a**9*b**7*c**10*s**3 - 82*a**8*b**8*c**10*s**3 +
        102*a**7*b**9*c**10*s**3 - 96*a**6*b**10*c**10*s**3 +
        68*a**5*b**11*c**10*s**3 - 35*a**4*b**12*c**10*s**3 +
        12*a**3*b**13*c**10*s**3 - 2*a**2*b**14*c**10*s**3 +
        2*a**13*b**2*c**11*s**3 - 6*a**12*b**3*c**11*s**3 +
        7*a**11*b**4*c**11*s**3 - 16*a**9*b**6*c**11*s**3 +
        33*a**8*b**7*c**11*s**3 - 41*a**7*b**8*c**11*s**3 +
        36*a**6*b**9*c**11*s**3 - 22*a**5*b**10*c**11*s**3 +
        9*a**4*b**11*c**11*s**3 - 2*a**3*b**12*c**11*s**3 -
        2*a**13*b*c**12*s**3 + 5*a**12*b**2*c**12*s**3 -
        6*a**11*b**3*c**12*s**3 + 3*a**10*b**4*c**12*s**3 +
        4*a**9*b**5*c**12*s**3 - 10*a**8*b**6*c**12*s**3 +
        12*a**7*b**7*c**12*s**3 - 9*a**6*b**8*c**12*s**3 +
        4*a**5*b**9*c**12*s**3 - a**4*b**10*c**12*s**3 +
        a**13*c**13*s**3 - 2*a**12*b*c**13*s**3 +
        2*a**11*b**2*c**13*s**3 - a**10*b**3*c**13*s**3 -
        a**9*b**4*c**13*s**3 + 2*a**8*b**5*c**13*s**3 -
        2*a**7*b**6*c**13*s**3 + a**6*b**7*c**13*s**3),
        (2*a**12*b**6*c**3 + 5*a**11*b**7*c**3 + 2*a**10*b**8*c**3 -
        a**9*b**9*c**3 + 5*a**12*b**5*c**4 + 18*a**11*b**6*c**4 +
        21*a**10*b**7*c**4 + 7*a**9*b**8*c**4 + a**7*b**10*c**4 +
        5*a**12*b**4*c**5 + 26*a**11*b**5*c**5 + 39*a**10*b**6*c**5 +
        32*a**9*b**7*c**5 + 19*a**8*b**8*c**5 + 15*a**7*b**9*c**5 +
        6*a**6*b**10*c**5 + 2*a**12*b**3*c**6 + 18*a**11*b**4*c**6 +
        39*a**10*b**5*c**6 + 36*a**9*b**6*c**6 + 29*a**8*b**7*c**6 +
        42*a**7*b**8*c**6 + 40*a**6*b**9*c**6 + 14*a**5*b**10*c**6 +
        5*a**11*b**3*c**7 + 21*a**10*b**4*c**7 + 32*a**9*b**5*c**7 +
        29*a**8*b**6*c**7 + 40*a**7*b**7*c**7 + 58*a**6*b**8*c**7 +
        48*a**5*b**9*c**7 + 16*a**4*b**10*c**7 + 2*a**10*b**3*c**8 +
        7*a**9*b**4*c**8 + 19*a**8*b**5*c**8 + 42*a**7*b**6*c**8 +
        58*a**6*b**7*c**8 + 53*a**5*b**8*c**8 + 32*a**4*b**9*c**8 +
        9*a**3*b**10*c**8 - a**9*b**3*c**9 + 15*a**7*b**5*c**9 +
        40*a**6*b**6*c**9 + 48*a**5*b**7*c**9 + 32*a**4*b**8*c**9 +
        12*a**3*b**9*c**9 + 2*a**2*b**10*c**9 + a**7*b**4*c**10 +
        6*a**6*b**5*c**10 + 14*a**5*b**6*c**10 + 16*a**4*b**7*c**10 +
        9*a**3*b**8*c**10 + 2*a**2*b**9*c**10 + 2*a**12*b**5*c**2*s**2
        + 8*a**11*b**6*c**2*s**2 + 8*a**10*b**7*c**2*s**2 +
        a**9*b**8*c**2*s**2 - a**8*b**9*c**2*s**2 +
        5*a**12*b**4*c**3*s**2 + 17*a**11*b**5*c**3*s**2 +
        39*a**10*b**6*c**3*s**2 + 33*a**9*b**7*c**3*s**2 +
        9*a**8*b**8*c**3*s**2 + a**7*b**9*c**3*s**2 +
        a**6*b**10*c**3*s**2 + 5*a**12*b**3*c**4*s**2 +
        17*a**11*b**4*c**4*s**2 + 32*a**10*b**5*c**4*s**2 +
        58*a**9*b**6*c**4*s**2 + 67*a**8*b**7*c**4*s**2 +
        44*a**7*b**8*c**4*s**2 + 21*a**6*b**9*c**4*s**2 +
        6*a**5*b**10*c**4*s**2 + 2*a**12*b**2*c**5*s**2 +
        17*a**11*b**3*c**5*s**2 + 32*a**10*b**4*c**5*s**2 +
        24*a**9*b**5*c**5*s**2 + 46*a**8*b**6*c**5*s**2 +
        88*a**7*b**7*c**5*s**2 + 92*a**6*b**8*c**5*s**2 +
        55*a**5*b**9*c**5*s**2 + 14*a**4*b**10*c**5*s**2 +
        8*a**11*b**2*c**6*s**2 + 39*a**10*b**3*c**6*s**2 +
        58*a**9*b**4*c**6*s**2 + 46*a**8*b**5*c**6*s**2 +
        42*a**7*b**6*c**6*s**2 + 62*a**6*b**7*c**6*s**2 +
        89*a**5*b**8*c**6*s**2 + 66*a**4*b**9*c**6*s**2 +
        16*a**3*b**10*c**6*s**2 + 8*a**10*b**2*c**7*s**2 +
        33*a**9*b**3*c**7*s**2 + 67*a**8*b**4*c**7*s**2 +
        88*a**7*b**5*c**7*s**2 + 62*a**6*b**6*c**7*s**2 +
        35*a**5*b**7*c**7*s**2 + 54*a**4*b**8*c**7*s**2 +
        46*a**3*b**9*c**7*s**2 + 9*a**2*b**10*c**7*s**2 +
        a**9*b**2*c**8*s**2 + 9*a**8*b**3*c**8*s**2 +
        44*a**7*b**4*c**8*s**2 + 92*a**6*b**5*c**8*s**2 +
        89*a**5*b**6*c**8*s**2 + 54*a**4*b**7*c**8*s**2 +
        38*a**3*b**8*c**8*s**2 + 19*a**2*b**9*c**8*s**2 +
        2*a*b**10*c**8*s**2 - a**8*b**2*c**9*s**2 +
        a**7*b**3*c**9*s**2 + 21*a**6*b**4*c**9*s**2 +
        55*a**5*b**5*c**9*s**2 + 66*a**4*b**6*c**9*s**2 +
        46*a**3*b**7*c**9*s**2 + 19*a**2*b**8*c**9*s**2 +
        4*a*b**9*c**9*s**2 + a**6*b**3*c**10*s**2 +
        6*a**5*b**4*c**10*s**2 + 14*a**4*b**5*c**10*s**2 +
        16*a**3*b**6*c**10*s**2 + 9*a**2*b**7*c**10*s**2 +
        2*a*b**8*c**10*s**2 - 15*a**11*b**4*c**2*s**4 -
        32*a**10*b**5*c**2*s**4 - 20*a**9*b**6*c**2*s**4 +
        a**8*b**7*c**2*s**4 + 4*a**7*b**8*c**2*s**4 -
        30*a**11*b**3*c**3*s**4 - 141*a**10*b**4*c**3*s**4 -
        185*a**9*b**5*c**3*s**4 - 72*a**8*b**6*c**3*s**4 +
        17*a**7*b**7*c**3*s**4 + 9*a**6*b**8*c**3*s**4 -
        2*a**5*b**9*c**3*s**4 - 15*a**11*b**2*c**4*s**4 -
        141*a**10*b**3*c**4*s**4 - 360*a**9*b**4*c**4*s**4 -
        339*a**8*b**5*c**4*s**4 - 102*a**7*b**6*c**4*s**4 -
        10*a**6*b**7*c**4*s**4 - 23*a**5*b**8*c**4*s**4 -
        10*a**4*b**9*c**4*s**4 - 32*a**10*b**2*c**5*s**4 -
        185*a**9*b**3*c**5*s**4 - 339*a**8*b**4*c**5*s**4 -
        276*a**7*b**5*c**5*s**4 - 198*a**6*b**6*c**5*s**4 -
        192*a**5*b**7*c**5*s**4 - 105*a**4*b**8*c**5*s**4 -
        21*a**3*b**9*c**5*s**4 - 20*a**9*b**2*c**6*s**4 -
        72*a**8*b**3*c**6*s**4 - 102*a**7*b**4*c**6*s**4 -
        198*a**6*b**5*c**6*s**4 - 385*a**5*b**6*c**6*s**4 -
        357*a**4*b**7*c**6*s**4 - 138*a**3*b**8*c**6*s**4 -
        18*a**2*b**9*c**6*s**4 + a**8*b**2*c**7*s**4 +
        17*a**7*b**3*c**7*s**4 - 10*a**6*b**4*c**7*s**4 -
        192*a**5*b**5*c**7*s**4 - 357*a**4*b**6*c**7*s**4 -
        260*a**3*b**7*c**7*s**4 - 72*a**2*b**8*c**7*s**4 -
        6*a*b**9*c**7*s**4 + 4*a**7*b**2*c**8*s**4 +
        9*a**6*b**3*c**8*s**4 - 23*a**5*b**4*c**8*s**4 -
        105*a**4*b**5*c**8*s**4 - 138*a**3*b**6*c**8*s**4 -
        72*a**2*b**7*c**8*s**4 - 11*a*b**8*c**8*s**4 -
        2*a**5*b**3*c**9*s**4 - 10*a**4*b**4*c**9*s**4 -
        21*a**3*b**5*c**9*s**4 - 18*a**2*b**6*c**9*s**4 -
        6*a*b**7*c**9*s**4 - a**10*b**3*c**2*s**6 +
        5*a**8*b**5*c**2*s**6 + 5*a**7*b**6*c**2*s**6 +
        a**6*b**7*c**2*s**6 - a**10*b**2*c**3*s**6 -
        a**9*b**3*c**3*s**6 + 4*a**8*b**4*c**3*s**6 +
        10*a**7*b**5*c**3*s**6 + 10*a**6*b**6*c**3*s**6 +
        5*a**5*b**7*c**3*s**6 + a**4*b**8*c**3*s**6 +
        4*a**8*b**3*c**4*s**6 - a**7*b**4*c**4*s**6 -
        3*a**6*b**5*c**4*s**6 + 9*a**5*b**6*c**4*s**6 +
        10*a**4*b**7*c**4*s**6 + 3*a**3*b**8*c**4*s**6 +
        5*a**8*b**2*c**5*s**6 + 10*a**7*b**3*c**5*s**6 -
        3*a**6*b**4*c**5*s**6 - 5*a**5*b**5*c**5*s**6 +
        4*a**4*b**6*c**5*s**6 + 8*a**3*b**7*c**5*s**6 +
        2*a**2*b**8*c**5*s**6 + 5*a**7*b**2*c**6*s**6 +
        10*a**6*b**3*c**6*s**6 + 9*a**5*b**4*c**6*s**6 +
        4*a**4*b**5*c**6*s**6 + a**6*b**2*c**7*s**6 +
        5*a**5*b**3*c**7*s**6 + 10*a**4*b**4*c**7*s**6 +
        8*a**3*b**5*c**7*s**6 - a*b**7*c**7*s**6 + a**4*b**3*c**8*s**6
        + 3*a**3*b**4*c**8*s**6 +
        2*a**2*b**5*c**8*s**6)/(a**13*b**5*s**3 - a**12*b**6*s**3 -
        a**11*b**7*s**3 + a**10*b**8*s**3 - 2*a**13*b**4*c*s**3 +
        2*a**12*b**5*c*s**3 + 4*a**11*b**6*c*s**3 -
        4*a**10*b**7*c*s**3 - 2*a**9*b**8*c*s**3 + 2*a**8*b**9*c*s**3
        + a**13*b**3*c**2*s**3 - 2*a**12*b**4*c**2*s**3 -
        6*a**11*b**5*c**2*s**3 + 8*a**10*b**6*c**2*s**3 +
        7*a**9*b**7*c**2*s**3 - 8*a**8*b**8*c**2*s**3 -
        2*a**7*b**9*c**2*s**3 + 2*a**6*b**10*c**2*s**3 +
        a**13*b**2*c**3*s**3 + 2*a**12*b**3*c**3*s**3 +
        3*a**11*b**4*c**3*s**3 - 11*a**10*b**5*c**3*s**3 -
        10*a**9*b**6*c**3*s**3 + 17*a**8*b**7*c**3*s**3 +
        7*a**7*b**8*c**3*s**3 - 9*a**6*b**9*c**3*s**3 -
        a**5*b**10*c**3*s**3 + a**4*b**11*c**3*s**3 -
        2*a**13*b*c**4*s**3 - 2*a**12*b**2*c**4*s**3 +
        3*a**11*b**3*c**4*s**3 + 12*a**10*b**4*c**4*s**3 +
        5*a**9*b**5*c**4*s**3 - 25*a**8*b**6*c**4*s**3 -
        10*a**7*b**7*c**4*s**3 + 21*a**6*b**8*c**4*s**3 +
        4*a**5*b**9*c**4*s**3 - 6*a**4*b**10*c**4*s**3 +
        a**13*c**5*s**3 + 2*a**12*b*c**5*s**3 - 6*a**11*b**2*c**5*s**3
        - 11*a**10*b**3*c**5*s**3 + 5*a**9*b**4*c**5*s**3 +
        28*a**8*b**5*c**5*s**3 + 5*a**7*b**6*c**5*s**3 -
        33*a**6*b**7*c**5*s**3 - 6*a**5*b**8*c**5*s**3 +
        16*a**4*b**9*c**5*s**3 + a**3*b**10*c**5*s**3 -
        2*a**2*b**11*c**5*s**3 - a**12*c**6*s**3 + 4*a**11*b*c**6*s**3
        + 8*a**10*b**2*c**6*s**3 - 10*a**9*b**3*c**6*s**3 -
        25*a**8*b**4*c**6*s**3 + 5*a**7*b**5*c**6*s**3 +
        38*a**6*b**6*c**6*s**3 + 3*a**5*b**7*c**6*s**3 -
        27*a**4*b**8*c**6*s**3 - 2*a**3*b**9*c**6*s**3 +
        7*a**2*b**10*c**6*s**3 - a**11*c**7*s**3 - 4*a**10*b*c**7*s**3
        + 7*a**9*b**2*c**7*s**3 + 17*a**8*b**3*c**7*s**3 -
        10*a**7*b**4*c**7*s**3 - 33*a**6*b**5*c**7*s**3 +
        3*a**5*b**6*c**7*s**3 + 32*a**4*b**7*c**7*s**3 +
        a**3*b**8*c**7*s**3 - 13*a**2*b**9*c**7*s**3 + b**11*c**7*s**3
        + a**10*c**8*s**3 - 2*a**9*b*c**8*s**3 - 8*a**8*b**2*c**8*s**3
        + 7*a**7*b**3*c**8*s**3 + 21*a**6*b**4*c**8*s**3 -
        6*a**5*b**5*c**8*s**3 - 27*a**4*b**6*c**8*s**3 +
        a**3*b**7*c**8*s**3 + 16*a**2*b**8*c**8*s**3 -
        3*b**10*c**8*s**3 + 2*a**8*b*c**9*s**3 - 2*a**7*b**2*c**9*s**3
        - 9*a**6*b**3*c**9*s**3 + 4*a**5*b**4*c**9*s**3 +
        16*a**4*b**5*c**9*s**3 - 2*a**3*b**6*c**9*s**3 -
        13*a**2*b**7*c**9*s**3 + 4*b**9*c**9*s**3 +
        2*a**6*b**2*c**10*s**3 - a**5*b**3*c**10*s**3 -
        6*a**4*b**4*c**10*s**3 + a**3*b**5*c**10*s**3 +
        7*a**2*b**6*c**10*s**3 - 3*b**8*c**10*s**3 +
        a**4*b**3*c**11*s**3 - 2*a**2*b**5*c**11*s**3 +
        b**7*c**11*s**3), (2*a**10*b**9*c**2 + 2*a**9*b**10*c**2 +
        9*a**10*b**8*c**3 + 12*a**9*b**9*c**3 + 9*a**8*b**10*c**3 +
        16*a**10*b**7*c**4 + 32*a**9*b**8*c**4 + 32*a**8*b**9*c**4 +
        16*a**7*b**10*c**4 + 14*a**10*b**6*c**5 + 48*a**9*b**7*c**5 +
        53*a**8*b**8*c**5 + 48*a**7*b**9*c**5 + 14*a**6*b**10*c**5 +
        6*a**10*b**5*c**6 + 40*a**9*b**6*c**6 + 58*a**8*b**7*c**6 +
        58*a**7*b**8*c**6 + 40*a**6*b**9*c**6 + 6*a**5*b**10*c**6 +
        a**10*b**4*c**7 + 15*a**9*b**5*c**7 + 42*a**8*b**6*c**7 +
        40*a**7*b**7*c**7 + 42*a**6*b**8*c**7 + 15*a**5*b**9*c**7 +
        a**4*b**10*c**7 + 19*a**8*b**5*c**8 + 29*a**7*b**6*c**8 +
        29*a**6*b**7*c**8 + 19*a**5*b**8*c**8 - a**9*b**3*c**9 +
        7*a**8*b**4*c**9 + 32*a**7*b**5*c**9 + 36*a**6*b**6*c**9 +
        32*a**5*b**7*c**9 + 7*a**4*b**8*c**9 - a**3*b**9*c**9 +
        2*a**8*b**3*c**10 + 21*a**7*b**4*c**10 + 39*a**6*b**5*c**10 +
        39*a**5*b**6*c**10 + 21*a**4*b**7*c**10 + 2*a**3*b**8*c**10 +
        5*a**7*b**3*c**11 + 18*a**6*b**4*c**11 + 26*a**5*b**5*c**11 +
        18*a**4*b**6*c**11 + 5*a**3*b**7*c**11 + 2*a**6*b**3*c**12 +
        5*a**5*b**4*c**12 + 5*a**4*b**5*c**12 + 2*a**3*b**6*c**12 +
        2*a**10*b**8*c*s**2 + 4*a**9*b**9*c*s**2 + 2*a**8*b**10*c*s**2
        + 9*a**10*b**7*c**2*s**2 + 19*a**9*b**8*c**2*s**2 +
        19*a**8*b**9*c**2*s**2 + 9*a**7*b**10*c**2*s**2 +
        16*a**10*b**6*c**3*s**2 + 46*a**9*b**7*c**3*s**2 +
        38*a**8*b**8*c**3*s**2 + 46*a**7*b**9*c**3*s**2 +
        16*a**6*b**10*c**3*s**2 + 14*a**10*b**5*c**4*s**2 +
        66*a**9*b**6*c**4*s**2 + 54*a**8*b**7*c**4*s**2 +
        54*a**7*b**8*c**4*s**2 + 66*a**6*b**9*c**4*s**2 +
        14*a**5*b**10*c**4*s**2 + 6*a**10*b**4*c**5*s**2 +
        55*a**9*b**5*c**5*s**2 + 89*a**8*b**6*c**5*s**2 +
        35*a**7*b**7*c**5*s**2 + 89*a**6*b**8*c**5*s**2 +
        55*a**5*b**9*c**5*s**2 + 6*a**4*b**10*c**5*s**2 +
        a**10*b**3*c**6*s**2 + 21*a**9*b**4*c**6*s**2 +
        92*a**8*b**5*c**6*s**2 + 62*a**7*b**6*c**6*s**2 +
        62*a**6*b**7*c**6*s**2 + 92*a**5*b**8*c**6*s**2 +
        21*a**4*b**9*c**6*s**2 + a**3*b**10*c**6*s**2 +
        a**9*b**3*c**7*s**2 + 44*a**8*b**4*c**7*s**2 +
        88*a**7*b**5*c**7*s**2 + 42*a**6*b**6*c**7*s**2 +
        88*a**5*b**7*c**7*s**2 + 44*a**4*b**8*c**7*s**2 +
        a**3*b**9*c**7*s**2 - a**9*b**2*c**8*s**2 +
        9*a**8*b**3*c**8*s**2 + 67*a**7*b**4*c**8*s**2 +
        46*a**6*b**5*c**8*s**2 + 46*a**5*b**6*c**8*s**2 +
        67*a**4*b**7*c**8*s**2 + 9*a**3*b**8*c**8*s**2 -
        a**2*b**9*c**8*s**2 + a**8*b**2*c**9*s**2 +
        33*a**7*b**3*c**9*s**2 + 58*a**6*b**4*c**9*s**2 +
        24*a**5*b**5*c**9*s**2 + 58*a**4*b**6*c**9*s**2 +
        33*a**3*b**7*c**9*s**2 + a**2*b**8*c**9*s**2 +
        8*a**7*b**2*c**10*s**2 + 39*a**6*b**3*c**10*s**2 +
        32*a**5*b**4*c**10*s**2 + 32*a**4*b**5*c**10*s**2 +
        39*a**3*b**6*c**10*s**2 + 8*a**2*b**7*c**10*s**2 +
        8*a**6*b**2*c**11*s**2 + 17*a**5*b**3*c**11*s**2 +
        17*a**4*b**4*c**11*s**2 + 17*a**3*b**5*c**11*s**2 +
        8*a**2*b**6*c**11*s**2 + 2*a**5*b**2*c**12*s**2 +
        5*a**4*b**3*c**12*s**2 + 5*a**3*b**4*c**12*s**2 +
        2*a**2*b**5*c**12*s**2 - 6*a**9*b**7*c*s**4 -
        11*a**8*b**8*c*s**4 - 6*a**7*b**9*c*s**4 -
        18*a**9*b**6*c**2*s**4 - 72*a**8*b**7*c**2*s**4 -
        72*a**7*b**8*c**2*s**4 - 18*a**6*b**9*c**2*s**4 -
        21*a**9*b**5*c**3*s**4 - 138*a**8*b**6*c**3*s**4 -
        260*a**7*b**7*c**3*s**4 - 138*a**6*b**8*c**3*s**4 -
        21*a**5*b**9*c**3*s**4 - 10*a**9*b**4*c**4*s**4 -
        105*a**8*b**5*c**4*s**4 - 357*a**7*b**6*c**4*s**4 -
        357*a**6*b**7*c**4*s**4 - 105*a**5*b**8*c**4*s**4 -
        10*a**4*b**9*c**4*s**4 - 2*a**9*b**3*c**5*s**4 -
        23*a**8*b**4*c**5*s**4 - 192*a**7*b**5*c**5*s**4 -
        385*a**6*b**6*c**5*s**4 - 192*a**5*b**7*c**5*s**4 -
        23*a**4*b**8*c**5*s**4 - 2*a**3*b**9*c**5*s**4 +
        9*a**8*b**3*c**6*s**4 - 10*a**7*b**4*c**6*s**4 -
        198*a**6*b**5*c**6*s**4 - 198*a**5*b**6*c**6*s**4 -
        10*a**4*b**7*c**6*s**4 + 9*a**3*b**8*c**6*s**4 +
        4*a**8*b**2*c**7*s**4 + 17*a**7*b**3*c**7*s**4 -
        102*a**6*b**4*c**7*s**4 - 276*a**5*b**5*c**7*s**4 -
        102*a**4*b**6*c**7*s**4 + 17*a**3*b**7*c**7*s**4 +
        4*a**2*b**8*c**7*s**4 + a**7*b**2*c**8*s**4 -
        72*a**6*b**3*c**8*s**4 - 339*a**5*b**4*c**8*s**4 -
        339*a**4*b**5*c**8*s**4 - 72*a**3*b**6*c**8*s**4 +
        a**2*b**7*c**8*s**4 - 20*a**6*b**2*c**9*s**4 -
        185*a**5*b**3*c**9*s**4 - 360*a**4*b**4*c**9*s**4 -
        185*a**3*b**5*c**9*s**4 - 20*a**2*b**6*c**9*s**4 -
        32*a**5*b**2*c**10*s**4 - 141*a**4*b**3*c**10*s**4 -
        141*a**3*b**4*c**10*s**4 - 32*a**2*b**5*c**10*s**4 -
        15*a**4*b**2*c**11*s**4 - 30*a**3*b**3*c**11*s**4 -
        15*a**2*b**4*c**11*s**4 - a**7*b**7*c*s**6 +
        2*a**8*b**5*c**2*s**6 + 2*a**5*b**8*c**2*s**6 +
        3*a**8*b**4*c**3*s**6 + 8*a**7*b**5*c**3*s**6 +
        8*a**5*b**7*c**3*s**6 + 3*a**4*b**8*c**3*s**6 +
        a**8*b**3*c**4*s**6 + 10*a**7*b**4*c**4*s**6 +
        4*a**6*b**5*c**4*s**6 + 4*a**5*b**6*c**4*s**6 +
        10*a**4*b**7*c**4*s**6 + a**3*b**8*c**4*s**6 +
        5*a**7*b**3*c**5*s**6 + 9*a**6*b**4*c**5*s**6 -
        5*a**5*b**5*c**5*s**6 + 9*a**4*b**6*c**5*s**6 +
        5*a**3*b**7*c**5*s**6 + a**7*b**2*c**6*s**6 +
        10*a**6*b**3*c**6*s**6 - 3*a**5*b**4*c**6*s**6 -
        3*a**4*b**5*c**6*s**6 + 10*a**3*b**6*c**6*s**6 +
        a**2*b**7*c**6*s**6 + 5*a**6*b**2*c**7*s**6 +
        10*a**5*b**3*c**7*s**6 - a**4*b**4*c**7*s**6 +
        10*a**3*b**5*c**7*s**6 + 5*a**2*b**6*c**7*s**6 +
        5*a**5*b**2*c**8*s**6 + 4*a**4*b**3*c**8*s**6 +
        4*a**3*b**4*c**8*s**6 + 5*a**2*b**5*c**8*s**6 -
        a**3*b**3*c**9*s**6 - a**3*b**2*c**10*s**6 -
        a**2*b**3*c**10*s**6)/(a**11*b**7*s**3 - 3*a**10*b**8*s**3 +
        4*a**9*b**9*s**3 - 3*a**8*b**10*s**3 + a**7*b**11*s**3 -
        2*a**11*b**5*c**2*s**3 + 7*a**10*b**6*c**2*s**3 -
        13*a**9*b**7*c**2*s**3 + 16*a**8*b**8*c**2*s**3 -
        13*a**7*b**9*c**2*s**3 + 7*a**6*b**10*c**2*s**3 -
        2*a**5*b**11*c**2*s**3 + a**10*b**5*c**3*s**3 -
        2*a**9*b**6*c**3*s**3 + a**8*b**7*c**3*s**3 +
        a**7*b**8*c**3*s**3 - 2*a**6*b**9*c**3*s**3 +
        a**5*b**10*c**3*s**3 + a**11*b**3*c**4*s**3 -
        6*a**10*b**4*c**4*s**3 + 16*a**9*b**5*c**4*s**3 -
        27*a**8*b**6*c**4*s**3 + 32*a**7*b**7*c**4*s**3 -
        27*a**6*b**8*c**4*s**3 + 16*a**5*b**9*c**4*s**3 -
        6*a**4*b**10*c**4*s**3 + a**3*b**11*c**4*s**3 -
        a**10*b**3*c**5*s**3 + 4*a**9*b**4*c**5*s**3 -
        6*a**8*b**5*c**5*s**3 + 3*a**7*b**6*c**5*s**3 +
        3*a**6*b**7*c**5*s**3 - 6*a**5*b**8*c**5*s**3 +
        4*a**4*b**9*c**5*s**3 - a**3*b**10*c**5*s**3 +
        2*a**10*b**2*c**6*s**3 - 9*a**9*b**3*c**6*s**3 +
        21*a**8*b**4*c**6*s**3 - 33*a**7*b**5*c**6*s**3 +
        38*a**6*b**6*c**6*s**3 - 33*a**5*b**7*c**6*s**3 +
        21*a**4*b**8*c**6*s**3 - 9*a**3*b**9*c**6*s**3 +
        2*a**2*b**10*c**6*s**3 - 2*a**9*b**2*c**7*s**3 +
        7*a**8*b**3*c**7*s**3 - 10*a**7*b**4*c**7*s**3 +
        5*a**6*b**5*c**7*s**3 + 5*a**5*b**6*c**7*s**3 -
        10*a**4*b**7*c**7*s**3 + 7*a**3*b**8*c**7*s**3 -
        2*a**2*b**9*c**7*s**3 + 2*a**9*b*c**8*s**3 -
        8*a**8*b**2*c**8*s**3 + 17*a**7*b**3*c**8*s**3 -
        25*a**6*b**4*c**8*s**3 + 28*a**5*b**5*c**8*s**3 -
        25*a**4*b**6*c**8*s**3 + 17*a**3*b**7*c**8*s**3 -
        8*a**2*b**8*c**8*s**3 + 2*a*b**9*c**8*s**3 -
        2*a**8*b*c**9*s**3 + 7*a**7*b**2*c**9*s**3 -
        10*a**6*b**3*c**9*s**3 + 5*a**5*b**4*c**9*s**3 +
        5*a**4*b**5*c**9*s**3 - 10*a**3*b**6*c**9*s**3 +
        7*a**2*b**7*c**9*s**3 - 2*a*b**8*c**9*s**3 + a**8*c**10*s**3 -
        4*a**7*b*c**10*s**3 + 8*a**6*b**2*c**10*s**3 -
        11*a**5*b**3*c**10*s**3 + 12*a**4*b**4*c**10*s**3 -
        11*a**3*b**5*c**10*s**3 + 8*a**2*b**6*c**10*s**3 -
        4*a*b**7*c**10*s**3 + b**8*c**10*s**3 - a**7*c**11*s**3 +
        4*a**6*b*c**11*s**3 - 6*a**5*b**2*c**11*s**3 +
        3*a**4*b**3*c**11*s**3 + 3*a**3*b**4*c**11*s**3 -
        6*a**2*b**5*c**11*s**3 + 4*a*b**6*c**11*s**3 - b**7*c**11*s**3
        - a**6*c**12*s**3 + 2*a**5*b*c**12*s**3 -
        2*a**4*b**2*c**12*s**3 + 2*a**3*b**3*c**12*s**3 -
        2*a**2*b**4*c**12*s**3 + 2*a*b**5*c**12*s**3 - b**6*c**12*s**3
        + a**5*c**13*s**3 - 2*a**4*b*c**13*s**3 + a**3*b**2*c**13*s**3
        + a**2*b**3*c**13*s**3 - 2*a*b**4*c**13*s**3 +
        b**5*c**13*s**3), (-a**9*b**9*c**3 + 2*a**8*b**10*c**3 +
        5*a**7*b**11*c**3 + 2*a**6*b**12*c**3 + a**10*b**7*c**4 +
        7*a**8*b**9*c**4 + 21*a**7*b**10*c**4 + 18*a**6*b**11*c**4 +
        5*a**5*b**12*c**4 + 6*a**10*b**6*c**5 + 15*a**9*b**7*c**5 +
        19*a**8*b**8*c**5 + 32*a**7*b**9*c**5 + 39*a**6*b**10*c**5 +
        26*a**5*b**11*c**5 + 5*a**4*b**12*c**5 + 14*a**10*b**5*c**6 +
        40*a**9*b**6*c**6 + 42*a**8*b**7*c**6 + 29*a**7*b**8*c**6 +
        36*a**6*b**9*c**6 + 39*a**5*b**10*c**6 + 18*a**4*b**11*c**6 +
        2*a**3*b**12*c**6 + 16*a**10*b**4*c**7 + 48*a**9*b**5*c**7 +
        58*a**8*b**6*c**7 + 40*a**7*b**7*c**7 + 29*a**6*b**8*c**7 +
        32*a**5*b**9*c**7 + 21*a**4*b**10*c**7 + 5*a**3*b**11*c**7 +
        9*a**10*b**3*c**8 + 32*a**9*b**4*c**8 + 53*a**8*b**5*c**8 +
        58*a**7*b**6*c**8 + 42*a**6*b**7*c**8 + 19*a**5*b**8*c**8 +
        7*a**4*b**9*c**8 + 2*a**3*b**10*c**8 + 2*a**10*b**2*c**9 +
        12*a**9*b**3*c**9 + 32*a**8*b**4*c**9 + 48*a**7*b**5*c**9 +
        40*a**6*b**6*c**9 + 15*a**5*b**7*c**9 - a**3*b**9*c**9 +
        2*a**9*b**2*c**10 + 9*a**8*b**3*c**10 + 16*a**7*b**4*c**10 +
        14*a**6*b**5*c**10 + 6*a**5*b**6*c**10 + a**4*b**7*c**10 -
        a**9*b**8*c**2*s**2 + a**8*b**9*c**2*s**2 +
        8*a**7*b**10*c**2*s**2 + 8*a**6*b**11*c**2*s**2 +
        2*a**5*b**12*c**2*s**2 + a**10*b**6*c**3*s**2 +
        a**9*b**7*c**3*s**2 + 9*a**8*b**8*c**3*s**2 +
        33*a**7*b**9*c**3*s**2 + 39*a**6*b**10*c**3*s**2 +
        17*a**5*b**11*c**3*s**2 + 5*a**4*b**12*c**3*s**2 +
        6*a**10*b**5*c**4*s**2 + 21*a**9*b**6*c**4*s**2 +
        44*a**8*b**7*c**4*s**2 + 67*a**7*b**8*c**4*s**2 +
        58*a**6*b**9*c**4*s**2 + 32*a**5*b**10*c**4*s**2 +
        17*a**4*b**11*c**4*s**2 + 5*a**3*b**12*c**4*s**2 +
        14*a**10*b**4*c**5*s**2 + 55*a**9*b**5*c**5*s**2 +
        92*a**8*b**6*c**5*s**2 + 88*a**7*b**7*c**5*s**2 +
        46*a**6*b**8*c**5*s**2 + 24*a**5*b**9*c**5*s**2 +
        32*a**4*b**10*c**5*s**2 + 17*a**3*b**11*c**5*s**2 +
        2*a**2*b**12*c**5*s**2 + 16*a**10*b**3*c**6*s**2 +
        66*a**9*b**4*c**6*s**2 + 89*a**8*b**5*c**6*s**2 +
        62*a**7*b**6*c**6*s**2 + 42*a**6*b**7*c**6*s**2 +
        46*a**5*b**8*c**6*s**2 + 58*a**4*b**9*c**6*s**2 +
        39*a**3*b**10*c**6*s**2 + 8*a**2*b**11*c**6*s**2 +
        9*a**10*b**2*c**7*s**2 + 46*a**9*b**3*c**7*s**2 +
        54*a**8*b**4*c**7*s**2 + 35*a**7*b**5*c**7*s**2 +
        62*a**6*b**6*c**7*s**2 + 88*a**5*b**7*c**7*s**2 +
        67*a**4*b**8*c**7*s**2 + 33*a**3*b**9*c**7*s**2 +
        8*a**2*b**10*c**7*s**2 + 2*a**10*b*c**8*s**2 +
        19*a**9*b**2*c**8*s**2 + 38*a**8*b**3*c**8*s**2 +
        54*a**7*b**4*c**8*s**2 + 89*a**6*b**5*c**8*s**2 +
        92*a**5*b**6*c**8*s**2 + 44*a**4*b**7*c**8*s**2 +
        9*a**3*b**8*c**8*s**2 + a**2*b**9*c**8*s**2 +
        4*a**9*b*c**9*s**2 + 19*a**8*b**2*c**9*s**2 +
        46*a**7*b**3*c**9*s**2 + 66*a**6*b**4*c**9*s**2 +
        55*a**5*b**5*c**9*s**2 + 21*a**4*b**6*c**9*s**2 +
        a**3*b**7*c**9*s**2 - a**2*b**8*c**9*s**2 +
        2*a**8*b*c**10*s**2 + 9*a**7*b**2*c**10*s**2 +
        16*a**6*b**3*c**10*s**2 + 14*a**5*b**4*c**10*s**2 +
        6*a**4*b**5*c**10*s**2 + a**3*b**6*c**10*s**2 +
        4*a**8*b**7*c**2*s**4 + a**7*b**8*c**2*s**4 -
        20*a**6*b**9*c**2*s**4 - 32*a**5*b**10*c**2*s**4 -
        15*a**4*b**11*c**2*s**4 - 2*a**9*b**5*c**3*s**4 +
        9*a**8*b**6*c**3*s**4 + 17*a**7*b**7*c**3*s**4 -
        72*a**6*b**8*c**3*s**4 - 185*a**5*b**9*c**3*s**4 -
        141*a**4*b**10*c**3*s**4 - 30*a**3*b**11*c**3*s**4 -
        10*a**9*b**4*c**4*s**4 - 23*a**8*b**5*c**4*s**4 -
        10*a**7*b**6*c**4*s**4 - 102*a**6*b**7*c**4*s**4 -
        339*a**5*b**8*c**4*s**4 - 360*a**4*b**9*c**4*s**4 -
        141*a**3*b**10*c**4*s**4 - 15*a**2*b**11*c**4*s**4 -
        21*a**9*b**3*c**5*s**4 - 105*a**8*b**4*c**5*s**4 -
        192*a**7*b**5*c**5*s**4 - 198*a**6*b**6*c**5*s**4 -
        276*a**5*b**7*c**5*s**4 - 339*a**4*b**8*c**5*s**4 -
        185*a**3*b**9*c**5*s**4 - 32*a**2*b**10*c**5*s**4 -
        18*a**9*b**2*c**6*s**4 - 138*a**8*b**3*c**6*s**4 -
        357*a**7*b**4*c**6*s**4 - 385*a**6*b**5*c**6*s**4 -
        198*a**5*b**6*c**6*s**4 - 102*a**4*b**7*c**6*s**4 -
        72*a**3*b**8*c**6*s**4 - 20*a**2*b**9*c**6*s**4 -
        6*a**9*b*c**7*s**4 - 72*a**8*b**2*c**7*s**4 -
        260*a**7*b**3*c**7*s**4 - 357*a**6*b**4*c**7*s**4 -
        192*a**5*b**5*c**7*s**4 - 10*a**4*b**6*c**7*s**4 +
        17*a**3*b**7*c**7*s**4 + a**2*b**8*c**7*s**4 -
        11*a**8*b*c**8*s**4 - 72*a**7*b**2*c**8*s**4 -
        138*a**6*b**3*c**8*s**4 - 105*a**5*b**4*c**8*s**4 -
        23*a**4*b**5*c**8*s**4 + 9*a**3*b**6*c**8*s**4 +
        4*a**2*b**7*c**8*s**4 - 6*a**7*b*c**9*s**4 -
        18*a**6*b**2*c**9*s**4 - 21*a**5*b**3*c**9*s**4 -
        10*a**4*b**4*c**9*s**4 - 2*a**3*b**5*c**9*s**4 +
        a**7*b**6*c**2*s**6 + 5*a**6*b**7*c**2*s**6 +
        5*a**5*b**8*c**2*s**6 - a**3*b**10*c**2*s**6 +
        a**8*b**4*c**3*s**6 + 5*a**7*b**5*c**3*s**6 +
        10*a**6*b**6*c**3*s**6 + 10*a**5*b**7*c**3*s**6 +
        4*a**4*b**8*c**3*s**6 - a**3*b**9*c**3*s**6 -
        a**2*b**10*c**3*s**6 + 3*a**8*b**3*c**4*s**6 +
        10*a**7*b**4*c**4*s**6 + 9*a**6*b**5*c**4*s**6 -
        3*a**5*b**6*c**4*s**6 - a**4*b**7*c**4*s**6 +
        4*a**3*b**8*c**4*s**6 + 2*a**8*b**2*c**5*s**6 +
        8*a**7*b**3*c**5*s**6 + 4*a**6*b**4*c**5*s**6 -
        5*a**5*b**5*c**5*s**6 - 3*a**4*b**6*c**5*s**6 +
        10*a**3*b**7*c**5*s**6 + 5*a**2*b**8*c**5*s**6 +
        4*a**5*b**4*c**6*s**6 + 9*a**4*b**5*c**6*s**6 +
        10*a**3*b**6*c**6*s**6 + 5*a**2*b**7*c**6*s**6 -
        a**7*b*c**7*s**6 + 8*a**5*b**3*c**7*s**6 +
        10*a**4*b**4*c**7*s**6 + 5*a**3*b**5*c**7*s**6 +
        a**2*b**6*c**7*s**6 + 2*a**5*b**2*c**8*s**6 +
        3*a**4*b**3*c**8*s**6 + a**3*b**4*c**8*s**6)/(a**8*b**10*s**3
        - a**7*b**11*s**3 - a**6*b**12*s**3 + a**5*b**13*s**3 +
        2*a**9*b**8*c*s**3 - 2*a**8*b**9*c*s**3 - 4*a**7*b**10*c*s**3
        + 4*a**6*b**11*c*s**3 + 2*a**5*b**12*c*s**3 -
        2*a**4*b**13*c*s**3 + 2*a**10*b**6*c**2*s**3 -
        2*a**9*b**7*c**2*s**3 - 8*a**8*b**8*c**2*s**3 +
        7*a**7*b**9*c**2*s**3 + 8*a**6*b**10*c**2*s**3 -
        6*a**5*b**11*c**2*s**3 - 2*a**4*b**12*c**2*s**3 +
        a**3*b**13*c**2*s**3 + a**11*b**4*c**3*s**3 -
        a**10*b**5*c**3*s**3 - 9*a**9*b**6*c**3*s**3 +
        7*a**8*b**7*c**3*s**3 + 17*a**7*b**8*c**3*s**3 -
        10*a**6*b**9*c**3*s**3 - 11*a**5*b**10*c**3*s**3 +
        3*a**4*b**11*c**3*s**3 + 2*a**3*b**12*c**3*s**3 +
        a**2*b**13*c**3*s**3 - 6*a**10*b**4*c**4*s**3 +
        4*a**9*b**5*c**4*s**3 + 21*a**8*b**6*c**4*s**3 -
        10*a**7*b**7*c**4*s**3 - 25*a**6*b**8*c**4*s**3 +
        5*a**5*b**9*c**4*s**3 + 12*a**4*b**10*c**4*s**3 +
        3*a**3*b**11*c**4*s**3 - 2*a**2*b**12*c**4*s**3 -
        2*a*b**13*c**4*s**3 - 2*a**11*b**2*c**5*s**3 +
        a**10*b**3*c**5*s**3 + 16*a**9*b**4*c**5*s**3 -
        6*a**8*b**5*c**5*s**3 - 33*a**7*b**6*c**5*s**3 +
        5*a**6*b**7*c**5*s**3 + 28*a**5*b**8*c**5*s**3 +
        5*a**4*b**9*c**5*s**3 - 11*a**3*b**10*c**5*s**3 -
        6*a**2*b**11*c**5*s**3 + 2*a*b**12*c**5*s**3 + b**13*c**5*s**3
        + 7*a**10*b**2*c**6*s**3 - 2*a**9*b**3*c**6*s**3 -
        27*a**8*b**4*c**6*s**3 + 3*a**7*b**5*c**6*s**3 +
        38*a**6*b**6*c**6*s**3 + 5*a**5*b**7*c**6*s**3 -
        25*a**4*b**8*c**6*s**3 - 10*a**3*b**9*c**6*s**3 +
        8*a**2*b**10*c**6*s**3 + 4*a*b**11*c**6*s**3 - b**12*c**6*s**3
        + a**11*c**7*s**3 - 13*a**9*b**2*c**7*s**3 +
        a**8*b**3*c**7*s**3 + 32*a**7*b**4*c**7*s**3 +
        3*a**6*b**5*c**7*s**3 - 33*a**5*b**6*c**7*s**3 -
        10*a**4*b**7*c**7*s**3 + 17*a**3*b**8*c**7*s**3 +
        7*a**2*b**9*c**7*s**3 - 4*a*b**10*c**7*s**3 - b**11*c**7*s**3
        - 3*a**10*c**8*s**3 + 16*a**8*b**2*c**8*s**3 +
        a**7*b**3*c**8*s**3 - 27*a**6*b**4*c**8*s**3 -
        6*a**5*b**5*c**8*s**3 + 21*a**4*b**6*c**8*s**3 +
        7*a**3*b**7*c**8*s**3 - 8*a**2*b**8*c**8*s**3 -
        2*a*b**9*c**8*s**3 + b**10*c**8*s**3 + 4*a**9*c**9*s**3 -
        13*a**7*b**2*c**9*s**3 - 2*a**6*b**3*c**9*s**3 +
        16*a**5*b**4*c**9*s**3 + 4*a**4*b**5*c**9*s**3 -
        9*a**3*b**6*c**9*s**3 - 2*a**2*b**7*c**9*s**3 +
        2*a*b**8*c**9*s**3 - 3*a**8*c**10*s**3 +
        7*a**6*b**2*c**10*s**3 + a**5*b**3*c**10*s**3 -
        6*a**4*b**4*c**10*s**3 - a**3*b**5*c**10*s**3 +
        2*a**2*b**6*c**10*s**3 + a**7*c**11*s**3 -
        2*a**5*b**2*c**11*s**3 + a**3*b**4*c**11*s**3),
        (-2*a**8*b**7*c**2 - 2*a**7*b**8*c**2 - 10*a**8*b**6*c**3 -
        18*a**7*b**7*c**3 - 10*a**6*b**8*c**3 - 19*a**8*b**5*c**4 -
        53*a**7*b**6*c**4 - 53*a**6*b**7*c**4 - 19*a**5*b**8*c**4 -
        19*a**8*b**4*c**5 - 74*a**7*b**5*c**5 - 103*a**6*b**6*c**5 -
        74*a**5*b**7*c**5 - 19*a**4*b**8*c**5 - 10*a**8*b**3*c**6 -
        53*a**7*b**4*c**6 - 103*a**6*b**5*c**6 - 103*a**5*b**6*c**6 -
        53*a**4*b**7*c**6 - 10*a**3*b**8*c**6 - 2*a**8*b**2*c**7 -
        18*a**7*b**3*c**7 - 53*a**6*b**4*c**7 - 74*a**5*b**5*c**7 -
        53*a**4*b**6*c**7 - 18*a**3*b**7*c**7 - 2*a**2*b**8*c**7 -
        2*a**7*b**2*c**8 - 10*a**6*b**3*c**8 - 19*a**5*b**4*c**8 -
        19*a**4*b**5*c**8 - 10*a**3*b**6*c**8 - 2*a**2*b**7*c**8 -
        2*a**8*b**6*c*s**2 - 4*a**7*b**7*c*s**2 - 2*a**6*b**8*c*s**2 -
        10*a**8*b**5*c**2*s**2 - 27*a**7*b**6*c**2*s**2 -
        27*a**6*b**7*c**2*s**2 - 10*a**5*b**8*c**2*s**2 -
        19*a**8*b**4*c**3*s**2 - 66*a**7*b**5*c**3*s**2 -
        89*a**6*b**6*c**3*s**2 - 66*a**5*b**7*c**3*s**2 -
        19*a**4*b**8*c**3*s**2 - 19*a**8*b**3*c**4*s**2 -
        84*a**7*b**4*c**4*s**2 - 128*a**6*b**5*c**4*s**2 -
        128*a**5*b**6*c**4*s**2 - 84*a**4*b**7*c**4*s**2 -
        19*a**3*b**8*c**4*s**2 - 10*a**8*b**2*c**5*s**2 -
        66*a**7*b**3*c**5*s**2 - 128*a**6*b**4*c**5*s**2 -
        135*a**5*b**5*c**5*s**2 - 128*a**4*b**6*c**5*s**2 -
        66*a**3*b**7*c**5*s**2 - 10*a**2*b**8*c**5*s**2 -
        2*a**8*b*c**6*s**2 - 27*a**7*b**2*c**6*s**2 -
        89*a**6*b**3*c**6*s**2 - 128*a**5*b**4*c**6*s**2 -
        128*a**4*b**5*c**6*s**2 - 89*a**3*b**6*c**6*s**2 -
        27*a**2*b**7*c**6*s**2 - 2*a*b**8*c**6*s**2 -
        4*a**7*b*c**7*s**2 - 27*a**6*b**2*c**7*s**2 -
        66*a**5*b**3*c**7*s**2 - 84*a**4*b**4*c**7*s**2 -
        66*a**3*b**5*c**7*s**2 - 27*a**2*b**6*c**7*s**2 -
        4*a*b**7*c**7*s**2 - 2*a**6*b*c**8*s**2 -
        10*a**5*b**2*c**8*s**2 - 19*a**4*b**3*c**8*s**2 -
        19*a**3*b**4*c**8*s**2 - 10*a**2*b**5*c**8*s**2 -
        2*a*b**6*c**8*s**2 + 6*a**7*b**5*c*s**4 + 11*a**6*b**6*c*s**4
        + 6*a**5*b**7*c*s**4 + 29*a**7*b**4*c**2*s**4 +
        92*a**6*b**5*c**2*s**4 + 92*a**5*b**6*c**2*s**4 +
        29*a**4*b**7*c**2*s**4 + 47*a**7*b**3*c**3*s**4 +
        238*a**6*b**4*c**3*s**4 + 389*a**5*b**5*c**3*s**4 +
        238*a**4*b**6*c**3*s**4 + 47*a**3*b**7*c**3*s**4 +
        29*a**7*b**2*c**4*s**4 + 238*a**6*b**3*c**4*s**4 +
        615*a**5*b**4*c**4*s**4 + 615*a**4*b**5*c**4*s**4 +
        238*a**3*b**6*c**4*s**4 + 29*a**2*b**7*c**4*s**4 +
        6*a**7*b*c**5*s**4 + 92*a**6*b**2*c**5*s**4 +
        389*a**5*b**3*c**5*s**4 + 615*a**4*b**4*c**5*s**4 +
        389*a**3*b**5*c**5*s**4 + 92*a**2*b**6*c**5*s**4 +
        6*a*b**7*c**5*s**4 + 11*a**6*b*c**6*s**4 +
        92*a**5*b**2*c**6*s**4 + 238*a**4*b**3*c**6*s**4 +
        238*a**3*b**4*c**6*s**4 + 92*a**2*b**5*c**6*s**4 +
        11*a*b**6*c**6*s**4 + 6*a**5*b*c**7*s**4 +
        29*a**4*b**2*c**7*s**4 + 47*a**3*b**3*c**7*s**4 +
        29*a**2*b**4*c**7*s**4 + 6*a*b**5*c**7*s**4 + a**5*b**5*c*s**6
        - 2*a**6*b**3*c**2*s**6 - 5*a**5*b**4*c**2*s**6 -
        5*a**4*b**5*c**2*s**6 - 2*a**3*b**6*c**2*s**6 -
        2*a**6*b**2*c**3*s**6 - 14*a**5*b**3*c**3*s**6 -
        19*a**4*b**4*c**3*s**6 - 14*a**3*b**5*c**3*s**6 -
        2*a**2*b**6*c**3*s**6 - 5*a**5*b**2*c**4*s**6 -
        19*a**4*b**3*c**4*s**6 - 19*a**3*b**4*c**4*s**6 -
        5*a**2*b**5*c**4*s**6 + a**5*b*c**5*s**6 -
        5*a**4*b**2*c**5*s**6 - 14*a**3*b**3*c**5*s**6 -
        5*a**2*b**4*c**5*s**6 + a*b**5*c**5*s**6 -
        2*a**3*b**2*c**6*s**6 - 2*a**2*b**3*c**6*s**6)/(a**8*b**6*s**3
        - 2*a**7*b**7*s**3 + a**6*b**8*s**3 + a**9*b**4*c*s**3 -
        3*a**8*b**5*c*s**3 + 2*a**7*b**6*c*s**3 + 2*a**6*b**7*c*s**3 -
        3*a**5*b**8*c*s**3 + a**4*b**9*c*s**3 - a**9*b**3*c**2*s**3 +
        5*a**7*b**5*c**2*s**3 - 8*a**6*b**6*c**2*s**3 +
        5*a**5*b**7*c**2*s**3 - a**3*b**9*c**2*s**3 -
        a**9*b**2*c**3*s**3 + 4*a**8*b**3*c**3*s**3 -
        5*a**7*b**4*c**3*s**3 + 2*a**6*b**5*c**3*s**3 +
        2*a**5*b**6*c**3*s**3 - 5*a**4*b**7*c**3*s**3 +
        4*a**3*b**8*c**3*s**3 - a**2*b**9*c**3*s**3 + a**9*b*c**4*s**3
        - 5*a**7*b**3*c**4*s**3 + 6*a**6*b**4*c**4*s**3 -
        4*a**5*b**5*c**4*s**3 + 6*a**4*b**6*c**4*s**3 -
        5*a**3*b**7*c**4*s**3 + a*b**9*c**4*s**3 - 3*a**8*b*c**5*s**3
        + 5*a**7*b**2*c**5*s**3 + 2*a**6*b**3*c**5*s**3 -
        4*a**5*b**4*c**5*s**3 - 4*a**4*b**5*c**5*s**3 +
        2*a**3*b**6*c**5*s**3 + 5*a**2*b**7*c**5*s**3 -
        3*a*b**8*c**5*s**3 + a**8*c**6*s**3 + 2*a**7*b*c**6*s**3 -
        8*a**6*b**2*c**6*s**3 + 2*a**5*b**3*c**6*s**3 +
        6*a**4*b**4*c**6*s**3 + 2*a**3*b**5*c**6*s**3 -
        8*a**2*b**6*c**6*s**3 + 2*a*b**7*c**6*s**3 + b**8*c**6*s**3 -
        2*a**7*c**7*s**3 + 2*a**6*b*c**7*s**3 + 5*a**5*b**2*c**7*s**3
        - 5*a**4*b**3*c**7*s**3 - 5*a**3*b**4*c**7*s**3 +
        5*a**2*b**5*c**7*s**3 + 2*a*b**6*c**7*s**3 - 2*b**7*c**7*s**3
        + a**6*c**8*s**3 - 3*a**5*b*c**8*s**3 + 4*a**3*b**3*c**8*s**3
        - 3*a*b**5*c**8*s**3 + b**6*c**8*s**3 + a**4*b*c**9*s**3 -
        a**3*b**2*c**9*s**3 - a**2*b**3*c**9*s**3 + a*b**4*c**9*s**3),
        (-2*a**8*b**12*c**2 - 2*a**7*b**13*c**2 - 9*a**8*b**11*c**3 -
        12*a**7*b**12*c**3 - 9*a**6*b**13*c**3 - 13*a**8*b**10*c**4 -
        35*a**7*b**11*c**4 - 31*a**6*b**12*c**4 - 17*a**5*b**13*c**4 -
        10*a**8*b**9*c**5 - 45*a**7*b**10*c**5 - 60*a**6*b**11*c**5 -
        45*a**5*b**12*c**5 - 17*a**4*b**13*c**5 - 9*a**8*b**8*c**6 -
        29*a**7*b**9*c**6 - 66*a**6*b**10*c**6 - 58*a**5*b**11*c**6 -
        37*a**4*b**12*c**6 - 9*a**3*b**13*c**6 - 7*a**8*b**7*c**7 -
        21*a**7*b**8*c**7 - 34*a**6*b**9*c**7 - 48*a**5*b**10*c**7 -
        29*a**4*b**11*c**7 - 15*a**3*b**12*c**7 - 2*a**2*b**13*c**7 -
        5*a**8*b**6*c**8 - 26*a**7*b**7*c**8 - 25*a**6*b**8*c**8 -
        21*a**5*b**9*c**8 - 13*a**4*b**10*c**8 - 4*a**3*b**11*c**8 -
        2*a**2*b**12*c**8 - 5*a**8*b**5*c**9 - 27*a**7*b**6*c**9 -
        46*a**6*b**7*c**9 - 26*a**5*b**8*c**9 - 10*a**4*b**9*c**9 +
        a**3*b**10*c**9 + a**2*b**11*c**9 - 2*a**8*b**4*c**10 -
        16*a**7*b**5*c**10 - 41*a**6*b**6*c**10 - 43*a**5*b**7*c**10 -
        17*a**4*b**8*c**10 - 5*a**3*b**9*c**10 - 6*a**7*b**4*c**11 -
        16*a**6*b**5*c**11 - 27*a**5*b**6*c**11 - 17*a**4*b**7*c**11 -
        5*a**3*b**8*c**11 - a**2*b**9*c**11 - a**7*b**3*c**12 -
        3*a**6*b**4*c**12 - 4*a**5*b**5*c**12 - 5*a**4*b**6*c**12 -
        a**3*b**7*c**12 - a**6*b**3*c**13 + a**4*b**5*c**13 -
        2*a**8*b**11*c*s**2 - 4*a**7*b**12*c*s**2 -
        2*a**6*b**13*c*s**2 - 9*a**8*b**10*c**2*s**2 -
        19*a**7*b**11*c**2*s**2 - 17*a**6*b**12*c**2*s**2 -
        11*a**5*b**13*c**2*s**2 - 13*a**8*b**9*c**3*s**2 -
        43*a**7*b**10*c**3*s**2 - 43*a**6*b**11*c**3*s**2 -
        43*a**5*b**12*c**3*s**2 - 20*a**4*b**13*c**3*s**2 -
        10*a**8*b**8*c**4*s**2 - 45*a**7*b**9*c**4*s**2 -
        71*a**6*b**10*c**4*s**2 - 62*a**5*b**11*c**4*s**2 -
        62*a**4*b**12*c**4*s**2 - 18*a**3*b**13*c**4*s**2 -
        9*a**8*b**7*c**5*s**2 - 38*a**7*b**8*c**5*s**2 -
        71*a**6*b**9*c**5*s**2 - 84*a**5*b**10*c**5*s**2 -
        71*a**4*b**11*c**5*s**2 - 53*a**3*b**12*c**5*s**2 -
        9*a**2*b**13*c**5*s**2 - 7*a**8*b**6*c**6*s**2 -
        42*a**7*b**7*c**6*s**2 - 63*a**6*b**8*c**6*s**2 -
        88*a**5*b**9*c**6*s**2 - 77*a**4*b**10*c**6*s**2 -
        50*a**3*b**11*c**6*s**2 - 23*a**2*b**12*c**6*s**2 -
        2*a*b**13*c**6*s**2 - 5*a**8*b**5*c**7*s**2 -
        32*a**7*b**6*c**7*s**2 - 72*a**6*b**7*c**7*s**2 -
        66*a**5*b**8*c**7*s**2 - 75*a**4*b**9*c**7*s**2 -
        38*a**3*b**10*c**7*s**2 - 16*a**2*b**11*c**7*s**2 -
        4*a*b**12*c**7*s**2 - 5*a**8*b**4*c**8*s**2 -
        24*a**7*b**5*c**8*s**2 - 61*a**6*b**6*c**8*s**2 -
        69*a**5*b**7*c**8*s**2 - 46*a**4*b**8*c**8*s**2 -
        32*a**3*b**9*c**8*s**2 - 4*a**2*b**10*c**8*s**2 -
        a*b**11*c**8*s**2 - 2*a**8*b**3*c**9*s**2 -
        21*a**7*b**4*c**9*s**2 - 46*a**6*b**5*c**9*s**2 -
        62*a**5*b**6*c**9*s**2 - 50*a**4*b**7*c**9*s**2 -
        22*a**3*b**8*c**9*s**2 - 6*a**2*b**9*c**9*s**2 +
        a*b**10*c**9*s**2 - 9*a**7*b**3*c**10*s**2 -
        32*a**6*b**4*c**10*s**2 - 38*a**5*b**5*c**10*s**2 -
        43*a**4*b**6*c**10*s**2 - 27*a**3*b**7*c**10*s**2 -
        8*a**2*b**8*c**10*s**2 - a*b**9*c**10*s**2 -
        a**7*b**2*c**11*s**2 - 12*a**6*b**3*c**11*s**2 -
        16*a**5*b**4*c**11*s**2 - 15*a**4*b**5*c**11*s**2 -
        16*a**3*b**6*c**11*s**2 - 6*a**2*b**7*c**11*s**2 -
        a*b**8*c**11*s**2 - 2*a**6*b**2*c**12*s**2 -
        4*a**5*b**3*c**12*s**2 - 3*a**4*b**4*c**12*s**2 -
        3*a**3*b**5*c**12*s**2 - 2*a**2*b**6*c**12*s**2 +
        6*a**7*b**10*c*s**4 + 13*a**6*b**11*c*s**4 +
        6*a**5*b**12*c*s**4 - 2*a**4*b**13*c*s**4 +
        22*a**7*b**9*c**2*s**4 + 71*a**6*b**10*c**2*s**4 +
        75*a**5*b**11*c**2*s**4 + 15*a**4*b**12*c**2*s**4 -
        3*a**3*b**13*c**2*s**4 + 32*a**7*b**8*c**3*s**4 +
        145*a**6*b**9*c**3*s**4 + 236*a**5*b**10*c**3*s**4 +
        144*a**4*b**11*c**3*s**4 + 22*a**3*b**12*c**3*s**4 -
        a**2*b**13*c**3*s**4 + 14*a**7*b**7*c**4*s**4 +
        137*a**6*b**8*c**4*s**4 + 319*a**5*b**9*c**4*s**4 +
        324*a**4*b**10*c**4*s**4 + 134*a**3*b**11*c**4*s**4 +
        16*a**2*b**12*c**4*s**4 - a**7*b**6*c**5*s**4 +
        39*a**6*b**7*c**5*s**4 + 208*a**5*b**8*c**5*s**4 +
        293*a**4*b**9*c**5*s**4 + 214*a**3*b**10*c**5*s**4 +
        61*a**2*b**11*c**5*s**4 + 5*a*b**12*c**5*s**4 +
        14*a**7*b**5*c**6*s**4 + 25*a**6*b**6*c**6*s**4 +
        67*a**5*b**7*c**6*s**4 + 122*a**4*b**8*c**6*s**4 +
        100*a**3*b**9*c**6*s**4 + 60*a**2*b**10*c**6*s**4 +
        10*a*b**11*c**6*s**4 + 22*a**7*b**4*c**7*s**4 +
        118*a**6*b**5*c**7*s**4 + 161*a**5*b**6*c**7*s**4 +
        114*a**4*b**7*c**7*s**4 + 23*a**3*b**8*c**7*s**4 -
        4*a**2*b**9*c**7*s**4 + 4*a*b**10*c**7*s**4 +
        8*a**7*b**3*c**8*s**4 + 109*a**6*b**4*c**8*s**4 +
        302*a**5*b**5*c**8*s**4 + 286*a**4*b**6*c**8*s**4 +
        116*a**3*b**7*c**8*s**4 + 4*a**2*b**8*c**8*s**4 -
        5*a*b**9*c**8*s**4 + 26*a**6*b**3*c**9*s**4 +
        185*a**5*b**4*c**9*s**4 + 318*a**4*b**5*c**9*s**4 +
        188*a**3*b**6*c**9*s**4 + 50*a**2*b**7*c**9*s**4 +
        3*a*b**8*c**9*s**4 - a**6*b**2*c**10*s**4 +
        32*a**5*b**3*c**10*s**4 + 135*a**4*b**4*c**10*s**4 +
        133*a**3*b**5*c**10*s**4 + 41*a**2*b**6*c**10*s**4 +
        6*a*b**7*c**10*s**4 - 2*a**5*b**2*c**11*s**4 +
        15*a**4*b**3*c**11*s**4 + 32*a**3*b**4*c**11*s**4 +
        15*a**2*b**5*c**11*s**4 + a**5*b**11*s**6 - a**4*b**12*s**6 +
        a**6*b**9*c*s**6 + a**5*b**10*c*s**6 + a**4*b**11*c*s**6 -
        2*a**3*b**12*c*s**6 + a**6*b**8*c**2*s**6 -
        2*a**5*b**9*c**2*s**6 - 2*a**3*b**11*c**2*s**6 -
        a**2*b**12*c**2*s**6 - 2*a**6*b**7*c**3*s**6 -
        3*a**5*b**8*c**3*s**6 - 11*a**4*b**9*c**3*s**6 -
        3*a**3*b**10*c**3*s**6 - 3*a**2*b**11*c**3*s**6 -
        2*a**6*b**6*c**4*s**6 - 5*a**5*b**7*c**4*s**6 -
        9*a**4*b**8*c**4*s**6 - 12*a**3*b**9*c**4*s**6 -
        a**2*b**10*c**4*s**6 - a*b**11*c**4*s**6 + a**6*b**5*c**5*s**6
        - 5*a**5*b**6*c**5*s**6 - 3*a**4*b**7*c**5*s**6 -
        12*a**3*b**8*c**5*s**6 - 4*a**2*b**9*c**5*s**6 -
        a**6*b**4*c**6*s**6 - a**5*b**5*c**6*s**6 -
        7*a**4*b**6*c**6*s**6 - a**3*b**7*c**6*s**6 -
        7*a**2*b**8*c**6*s**6 + a*b**9*c**6*s**6 -
        2*a**6*b**3*c**7*s**6 - 5*a**5*b**4*c**7*s**6 -
        11*a**4*b**5*c**7*s**6 - 8*a**3*b**6*c**7*s**6 -
        3*a*b**8*c**7*s**6 - 3*a**5*b**3*c**8*s**6 -
        7*a**4*b**4*c**8*s**6 - 10*a**3*b**5*c**8*s**6 +
        a**2*b**6*c**8*s**6 + a*b**7*c**8*s**6 - 2*a**3*b**4*c**9*s**6
        + 3*a*b**6*c**9*s**6 + a**3*b**3*c**10*s**6 +
        a**2*b**4*c**10*s**6)/(a**8*b**11*s**3 - 2*a**7*b**12*s**3 +
        2*a**6*b**13*s**3 - 2*a**5*b**14*s**3 + a**4*b**15*s**3 +
        a**9*b**9*c*s**3 - 3*a**8*b**10*c*s**3 + 4*a**7*b**11*c*s**3 -
        4*a**6*b**12*c*s**3 + 3*a**5*b**13*c*s**3 - a**4*b**14*c*s**3
        - a**9*b**8*c**2*s**3 + a**8*b**9*c**2*s**3 -
        a**6*b**11*c**2*s**3 + 3*a**5*b**12*c**2*s**3 -
        3*a**4*b**13*c**2*s**3 + 2*a**3*b**14*c**2*s**3 -
        a**2*b**15*c**2*s**3 - a**9*b**7*c**3*s**3 +
        4*a**8*b**8*c**3*s**3 - 7*a**7*b**9*c**3*s**3 +
        10*a**6*b**10*c**3*s**3 - 11*a**5*b**11*c**3*s**3 +
        8*a**4*b**12*c**3*s**3 - 5*a**3*b**13*c**3*s**3 +
        2*a**2*b**14*c**3*s**3 + 2*a**9*b**6*c**4*s**3 -
        5*a**8*b**7*c**4*s**3 + 7*a**7*b**8*c**4*s**3 -
        10*a**6*b**9*c**4*s**3 + 9*a**5*b**10*c**4*s**3 -
        5*a**4*b**11*c**4*s**3 + 3*a**3*b**12*c**4*s**3 -
        a*b**14*c**4*s**3 - a**9*b**5*c**5*s**3 +
        2*a**7*b**7*c**5*s**3 - 2*a**6*b**8*c**5*s**3 +
        6*a**5*b**9*c**5*s**3 - 8*a**4*b**10*c**5*s**3 +
        6*a**3*b**11*c**5*s**3 - 6*a**2*b**12*c**5*s**3 +
        3*a*b**13*c**5*s**3 - a**9*b**4*c**6*s**3 +
        5*a**8*b**5*c**6*s**3 - 8*a**7*b**6*c**6*s**3 +
        11*a**6*b**7*c**6*s**3 - 16*a**5*b**8*c**6*s**3 +
        15*a**4*b**9*c**6*s**3 - 12*a**3*b**10*c**6*s**3 +
        9*a**2*b**11*c**6*s**3 - 3*a*b**12*c**6*s**3 +
        a**9*b**3*c**7*s**3 - 3*a**8*b**4*c**7*s**3 +
        3*a**7*b**5*c**7*s**3 - 5*a**6*b**6*c**7*s**3 +
        8*a**5*b**7*c**7*s**3 - 6*a**4*b**8*c**7*s**3 +
        5*a**3*b**9*c**7*s**3 - 3*a**2*b**10*c**7*s**3 -
        a*b**11*c**7*s**3 + b**12*c**7*s**3 - a**8*b**3*c**8*s**3 +
        4*a**7*b**4*c**8*s**3 - 4*a**6*b**5*c**8*s**3 +
        4*a**5*b**6*c**8*s**3 - 7*a**4*b**7*c**8*s**3 +
        6*a**3*b**8*c**8*s**3 - 6*a**2*b**9*c**8*s**3 +
        6*a*b**10*c**8*s**3 - 2*b**11*c**8*s**3 +
        2*a**8*b**2*c**9*s**3 - 4*a**7*b**3*c**9*s**3 +
        3*a**6*b**4*c**9*s**3 - 6*a**5*b**5*c**9*s**3 +
        9*a**4*b**6*c**9*s**3 - 8*a**3*b**7*c**9*s**3 +
        9*a**2*b**8*c**9*s**3 - 6*a*b**9*c**9*s**3 + b**10*c**9*s**3 -
        a**8*b*c**10*s**3 + 2*a**6*b**3*c**10*s**3 +
        a**5*b**4*c**10*s**3 - 2*a**4*b**5*c**10*s**3 +
        2*a**3*b**6*c**10*s**3 - 4*a**2*b**7*c**10*s**3 +
        a*b**8*c**10*s**3 + b**9*c**10*s**3 + 2*a**7*b*c**11*s**3 -
        3*a**6*b**2*c**11*s**3 + a**5*b**3*c**11*s**3 -
        2*a**4*b**4*c**11*s**3 + 2*a**3*b**5*c**11*s**3 -
        a**2*b**6*c**11*s**3 + 3*a*b**7*c**11*s**3 - 2*b**8*c**11*s**3
        - a**7*c**12*s**3 + a**5*b**2*c**12*s**3 +
        a**4*b**3*c**12*s**3 - a**3*b**4*c**12*s**3 +
        2*a**2*b**5*c**12*s**3 - 3*a*b**6*c**12*s**3 + b**7*c**12*s**3
        + a**6*c**13*s**3 - a**5*b*c**13*s**3 - a**2*b**4*c**13*s**3 +
        a*b**5*c**13*s**3), (-2*a**13*b**7*c**2 - 2*a**12*b**8*c**2 +
        a**11*b**9*c**2 - a**9*b**11*c**2 - 9*a**13*b**6*c**3 -
        15*a**12*b**7*c**3 - 4*a**11*b**8*c**3 + a**10*b**9*c**3 -
        5*a**9*b**10*c**3 - 5*a**8*b**11*c**3 - a**7*b**12*c**3 -
        17*a**13*b**5*c**4 - 37*a**12*b**6*c**4 - 29*a**11*b**7*c**4 -
        13*a**10*b**8*c**4 - 10*a**9*b**9*c**4 - 17*a**8*b**10*c**4 -
        17*a**7*b**11*c**4 - 5*a**6*b**12*c**4 + a**5*b**13*c**4 -
        17*a**13*b**4*c**5 - 45*a**12*b**5*c**5 - 58*a**11*b**6*c**5 -
        48*a**10*b**7*c**5 - 21*a**9*b**8*c**5 - 26*a**8*b**9*c**5 -
        43*a**7*b**10*c**5 - 27*a**6*b**11*c**5 - 4*a**5*b**12*c**5 -
        9*a**13*b**3*c**6 - 31*a**12*b**4*c**6 - 60*a**11*b**5*c**6 -
        66*a**10*b**6*c**6 - 34*a**9*b**7*c**6 - 25*a**8*b**8*c**6 -
        46*a**7*b**9*c**6 - 41*a**6*b**10*c**6 - 16*a**5*b**11*c**6 -
        3*a**4*b**12*c**6 - a**3*b**13*c**6 - 2*a**13*b**2*c**7 -
        12*a**12*b**3*c**7 - 35*a**11*b**4*c**7 - 45*a**10*b**5*c**7 -
        29*a**9*b**6*c**7 - 21*a**8*b**7*c**7 - 26*a**7*b**8*c**7 -
        27*a**6*b**9*c**7 - 16*a**5*b**10*c**7 - 6*a**4*b**11*c**7 -
        a**3*b**12*c**7 - 2*a**12*b**2*c**8 - 9*a**11*b**3*c**8 -
        13*a**10*b**4*c**8 - 10*a**9*b**5*c**8 - 9*a**8*b**6*c**8 -
        7*a**7*b**7*c**8 - 5*a**6*b**8*c**8 - 5*a**5*b**9*c**8 -
        2*a**4*b**10*c**8 - 2*a**13*b**6*c*s**2 - 4*a**12*b**7*c*s**2
        - a**11*b**8*c*s**2 + a**10*b**9*c*s**2 - a**9*b**10*c*s**2 -
        a**8*b**11*c*s**2 - 9*a**13*b**5*c**2*s**2 -
        23*a**12*b**6*c**2*s**2 - 16*a**11*b**7*c**2*s**2 -
        4*a**10*b**8*c**2*s**2 - 6*a**9*b**9*c**2*s**2 -
        8*a**8*b**10*c**2*s**2 - 6*a**7*b**11*c**2*s**2 -
        2*a**6*b**12*c**2*s**2 - 18*a**13*b**4*c**3*s**2 -
        53*a**12*b**5*c**3*s**2 - 50*a**11*b**6*c**3*s**2 -
        38*a**10*b**7*c**3*s**2 - 32*a**9*b**8*c**3*s**2 -
        22*a**8*b**9*c**3*s**2 - 27*a**7*b**10*c**3*s**2 -
        16*a**6*b**11*c**3*s**2 - 3*a**5*b**12*c**3*s**2 -
        20*a**13*b**3*c**4*s**2 - 62*a**12*b**4*c**4*s**2 -
        71*a**11*b**5*c**4*s**2 - 77*a**10*b**6*c**4*s**2 -
        75*a**9*b**7*c**4*s**2 - 46*a**8*b**8*c**4*s**2 -
        50*a**7*b**9*c**4*s**2 - 43*a**6*b**10*c**4*s**2 -
        15*a**5*b**11*c**4*s**2 - 3*a**4*b**12*c**4*s**2 -
        11*a**13*b**2*c**5*s**2 - 43*a**12*b**3*c**5*s**2 -
        62*a**11*b**4*c**5*s**2 - 84*a**10*b**5*c**5*s**2 -
        88*a**9*b**6*c**5*s**2 - 66*a**8*b**7*c**5*s**2 -
        69*a**7*b**8*c**5*s**2 - 62*a**6*b**9*c**5*s**2 -
        38*a**5*b**10*c**5*s**2 - 16*a**4*b**11*c**5*s**2 -
        4*a**3*b**12*c**5*s**2 - 2*a**13*b*c**6*s**2 -
        17*a**12*b**2*c**6*s**2 - 43*a**11*b**3*c**6*s**2 -
        71*a**10*b**4*c**6*s**2 - 71*a**9*b**5*c**6*s**2 -
        63*a**8*b**6*c**6*s**2 - 72*a**7*b**7*c**6*s**2 -
        61*a**6*b**8*c**6*s**2 - 46*a**5*b**9*c**6*s**2 -
        32*a**4*b**10*c**6*s**2 - 12*a**3*b**11*c**6*s**2 -
        2*a**2*b**12*c**6*s**2 - 4*a**12*b*c**7*s**2 -
        19*a**11*b**2*c**7*s**2 - 43*a**10*b**3*c**7*s**2 -
        45*a**9*b**4*c**7*s**2 - 38*a**8*b**5*c**7*s**2 -
        42*a**7*b**6*c**7*s**2 - 32*a**6*b**7*c**7*s**2 -
        24*a**5*b**8*c**7*s**2 - 21*a**4*b**9*c**7*s**2 -
        9*a**3*b**10*c**7*s**2 - a**2*b**11*c**7*s**2 -
        2*a**11*b*c**8*s**2 - 9*a**10*b**2*c**8*s**2 -
        13*a**9*b**3*c**8*s**2 - 10*a**8*b**4*c**8*s**2 -
        9*a**7*b**5*c**8*s**2 - 7*a**6*b**6*c**8*s**2 -
        5*a**5*b**7*c**8*s**2 - 5*a**4*b**8*c**8*s**2 -
        2*a**3*b**9*c**8*s**2 + 5*a**12*b**5*c*s**4 +
        10*a**11*b**6*c*s**4 + 4*a**10*b**7*c*s**4 -
        5*a**9*b**8*c*s**4 + 3*a**8*b**9*c*s**4 + 6*a**7*b**10*c*s**4
        - a**13*b**3*c**2*s**4 + 16*a**12*b**4*c**2*s**4 +
        61*a**11*b**5*c**2*s**4 + 60*a**10*b**6*c**2*s**4 -
        4*a**9*b**7*c**2*s**4 + 4*a**8*b**8*c**2*s**4 +
        50*a**7*b**9*c**2*s**4 + 41*a**6*b**10*c**2*s**4 +
        15*a**5*b**11*c**2*s**4 - 3*a**13*b**2*c**3*s**4 +
        22*a**12*b**3*c**3*s**4 + 134*a**11*b**4*c**3*s**4 +
        214*a**10*b**5*c**3*s**4 + 100*a**9*b**6*c**3*s**4 +
        23*a**8*b**7*c**3*s**4 + 116*a**7*b**8*c**3*s**4 +
        188*a**6*b**9*c**3*s**4 + 133*a**5*b**10*c**3*s**4 +
        32*a**4*b**11*c**3*s**4 - 2*a**13*b*c**4*s**4 +
        15*a**12*b**2*c**4*s**4 + 144*a**11*b**3*c**4*s**4 +
        324*a**10*b**4*c**4*s**4 + 293*a**9*b**5*c**4*s**4 +
        122*a**8*b**6*c**4*s**4 + 114*a**7*b**7*c**4*s**4 +
        286*a**6*b**8*c**4*s**4 + 318*a**5*b**9*c**4*s**4 +
        135*a**4*b**10*c**4*s**4 + 15*a**3*b**11*c**4*s**4 +
        6*a**12*b*c**5*s**4 + 75*a**11*b**2*c**5*s**4 +
        236*a**10*b**3*c**5*s**4 + 319*a**9*b**4*c**5*s**4 +
        208*a**8*b**5*c**5*s**4 + 67*a**7*b**6*c**5*s**4 +
        161*a**6*b**7*c**5*s**4 + 302*a**5*b**8*c**5*s**4 +
        185*a**4*b**9*c**5*s**4 + 32*a**3*b**10*c**5*s**4 -
        2*a**2*b**11*c**5*s**4 + 13*a**11*b*c**6*s**4 +
        71*a**10*b**2*c**6*s**4 + 145*a**9*b**3*c**6*s**4 +
        137*a**8*b**4*c**6*s**4 + 39*a**7*b**5*c**6*s**4 +
        25*a**6*b**6*c**6*s**4 + 118*a**5*b**7*c**6*s**4 +
        109*a**4*b**8*c**6*s**4 + 26*a**3*b**9*c**6*s**4 -
        a**2*b**10*c**6*s**4 + 6*a**10*b*c**7*s**4 +
        22*a**9*b**2*c**7*s**4 + 32*a**8*b**3*c**7*s**4 +
        14*a**7*b**4*c**7*s**4 - a**6*b**5*c**7*s**4 +
        14*a**5*b**6*c**7*s**4 + 22*a**4*b**7*c**7*s**4 +
        8*a**3*b**8*c**7*s**4 - a**11*b**4*c*s**6 + a**9*b**6*c*s**6 -
        3*a**8*b**7*c*s**6 + a**7*b**8*c*s**6 + 3*a**6*b**9*c*s**6 -
        a**12*b**2*c**2*s**6 - 3*a**11*b**3*c**2*s**6 -
        a**10*b**4*c**2*s**6 - 4*a**9*b**5*c**2*s**6 -
        7*a**8*b**6*c**2*s**6 + a**6*b**8*c**2*s**6 +
        a**4*b**10*c**2*s**6 - 2*a**12*b*c**3*s**6 -
        2*a**11*b**2*c**3*s**6 - 3*a**10*b**3*c**3*s**6 -
        12*a**9*b**4*c**3*s**6 - 12*a**8*b**5*c**3*s**6 -
        a**7*b**6*c**3*s**6 - 8*a**6*b**7*c**3*s**6 -
        10*a**5*b**8*c**3*s**6 - 2*a**4*b**9*c**3*s**6 +
        a**3*b**10*c**3*s**6 - a**12*c**4*s**6 + a**11*b*c**4*s**6 -
        11*a**9*b**3*c**4*s**6 - 9*a**8*b**4*c**4*s**6 -
        3*a**7*b**5*c**4*s**6 - 7*a**6*b**6*c**4*s**6 -
        11*a**5*b**7*c**4*s**6 - 7*a**4*b**8*c**4*s**6 +
        a**11*c**5*s**6 + a**10*b*c**5*s**6 - 2*a**9*b**2*c**5*s**6 -
        3*a**8*b**3*c**5*s**6 - 5*a**7*b**4*c**5*s**6 -
        5*a**6*b**5*c**5*s**6 - a**5*b**6*c**5*s**6 -
        5*a**4*b**7*c**5*s**6 - 3*a**3*b**8*c**5*s**6 +
        a**9*b*c**6*s**6 + a**8*b**2*c**6*s**6 - 2*a**7*b**3*c**6*s**6
        - 2*a**6*b**4*c**6*s**6 + a**5*b**5*c**6*s**6 -
        a**4*b**6*c**6*s**6 - 2*a**3*b**7*c**6*s**6)/(a**12*b**7*s**3
        - 2*a**11*b**8*s**3 + a**10*b**9*s**3 + a**9*b**10*s**3 -
        2*a**8*b**11*s**3 + a**7*b**12*s**3 - a**14*b**4*c*s**3 +
        3*a**13*b**5*c*s**3 - 3*a**12*b**6*c*s**3 - a**11*b**7*c*s**3
        + 6*a**10*b**8*c*s**3 - 6*a**9*b**9*c*s**3 + a**8*b**10*c*s**3
        + 3*a**7*b**11*c*s**3 - 3*a**6*b**12*c*s**3 +
        a**5*b**13*c*s**3 - a**15*b**2*c**2*s**3 +
        2*a**14*b**3*c**2*s**3 - 6*a**12*b**5*c**2*s**3 +
        9*a**11*b**6*c**2*s**3 - 3*a**10*b**7*c**2*s**3 -
        6*a**9*b**8*c**2*s**3 + 9*a**8*b**9*c**2*s**3 -
        4*a**7*b**10*c**2*s**3 - a**6*b**11*c**2*s**3 +
        2*a**5*b**12*c**2*s**3 - a**4*b**13*c**2*s**3 +
        2*a**14*b**2*c**3*s**3 - 5*a**13*b**3*c**3*s**3 +
        3*a**12*b**4*c**3*s**3 + 6*a**11*b**5*c**3*s**3 -
        12*a**10*b**6*c**3*s**3 + 5*a**9*b**7*c**3*s**3 +
        6*a**8*b**8*c**3*s**3 - 8*a**7*b**9*c**3*s**3 +
        2*a**6*b**10*c**3*s**3 + 2*a**5*b**11*c**3*s**3 -
        a**4*b**12*c**3*s**3 + a**15*c**4*s**3 - a**14*b*c**4*s**3 -
        3*a**13*b**2*c**4*s**3 + 8*a**12*b**3*c**4*s**3 -
        5*a**11*b**4*c**4*s**3 - 8*a**10*b**5*c**4*s**3 +
        15*a**9*b**6*c**4*s**3 - 6*a**8*b**7*c**4*s**3 -
        7*a**7*b**8*c**4*s**3 + 9*a**6*b**9*c**4*s**3 -
        2*a**5*b**10*c**4*s**3 - 2*a**4*b**11*c**4*s**3 +
        a**3*b**12*c**4*s**3 - 2*a**14*c**5*s**3 + 3*a**13*b*c**5*s**3
        + 3*a**12*b**2*c**5*s**3 - 11*a**11*b**3*c**5*s**3 +
        9*a**10*b**4*c**5*s**3 + 6*a**9*b**5*c**5*s**3 -
        16*a**8*b**6*c**5*s**3 + 8*a**7*b**7*c**5*s**3 +
        4*a**6*b**8*c**5*s**3 - 6*a**5*b**9*c**5*s**3 +
        a**4*b**10*c**5*s**3 + a**3*b**11*c**5*s**3 +
        a**2*b**12*c**5*s**3 - a*b**13*c**5*s**3 + 2*a**13*c**6*s**3 -
        4*a**12*b*c**6*s**3 - a**11*b**2*c**6*s**3 +
        10*a**10*b**3*c**6*s**3 - 10*a**9*b**4*c**6*s**3 -
        2*a**8*b**5*c**6*s**3 + 11*a**7*b**6*c**6*s**3 -
        5*a**6*b**7*c**6*s**3 - 4*a**5*b**8*c**6*s**3 +
        3*a**4*b**9*c**6*s**3 + 2*a**3*b**10*c**6*s**3 -
        3*a**2*b**11*c**6*s**3 + b**13*c**6*s**3 - 2*a**12*c**7*s**3 +
        4*a**11*b*c**7*s**3 - 7*a**9*b**3*c**7*s**3 +
        7*a**8*b**4*c**7*s**3 + 2*a**7*b**5*c**7*s**3 -
        8*a**6*b**6*c**7*s**3 + 3*a**5*b**7*c**7*s**3 +
        4*a**4*b**8*c**7*s**3 - 4*a**3*b**9*c**7*s**3 +
        2*a*b**11*c**7*s**3 - b**12*c**7*s**3 + a**11*c**8*s**3 -
        3*a**10*b*c**8*s**3 + a**9*b**2*c**8*s**3 +
        4*a**8*b**3*c**8*s**3 - 5*a**7*b**4*c**8*s**3 +
        5*a**5*b**6*c**8*s**3 - 3*a**4*b**7*c**8*s**3 -
        a**3*b**8*c**8*s**3 + 2*a**2*b**9*c**8*s**3 -
        a*b**10*c**8*s**3 + a**9*b*c**9*s**3 - a**8*b**2*c**9*s**3 -
        a**7*b**3*c**9*s**3 + 2*a**6*b**4*c**9*s**3 -
        a**5*b**5*c**9*s**3 - a**4*b**6*c**9*s**3 +
        a**3*b**7*c**9*s**3), (-a**13*b**6*c**3 - a**12*b**7*c**3 -
        3*a**12*b**6*c**4 - 6*a**11*b**7*c**4 - 2*a**10*b**8*c**4 +
        a**13*b**4*c**5 - 4*a**12*b**5*c**5 - 16*a**11*b**6*c**5 -
        16*a**10*b**7*c**5 - 5*a**9*b**8*c**5 - 5*a**12*b**4*c**6 -
        27*a**11*b**5*c**6 - 41*a**10*b**6*c**6 - 27*a**9*b**7*c**6 -
        5*a**8*b**8*c**6 - a**12*b**3*c**7 - 17*a**11*b**4*c**7 -
        43*a**10*b**5*c**7 - 46*a**9*b**6*c**7 - 26*a**8*b**7*c**7 -
        7*a**7*b**8*c**7 - 5*a**11*b**3*c**8 - 17*a**10*b**4*c**8 -
        26*a**9*b**5*c**8 - 25*a**8*b**6*c**8 - 21*a**7*b**7*c**8 -
        9*a**6*b**8*c**8 - a**11*b**2*c**9 - 5*a**10*b**3*c**9 -
        10*a**9*b**4*c**9 - 21*a**8*b**5*c**9 - 34*a**7*b**6*c**9 -
        29*a**6*b**7*c**9 - 10*a**5*b**8*c**9 + a**9*b**3*c**10 -
        13*a**8*b**4*c**10 - 48*a**7*b**5*c**10 - 66*a**6*b**6*c**10 -
        45*a**5*b**7*c**10 - 13*a**4*b**8*c**10 + a**9*b**2*c**11 -
        4*a**8*b**3*c**11 - 29*a**7*b**4*c**11 - 58*a**6*b**5*c**11 -
        60*a**5*b**6*c**11 - 35*a**4*b**7*c**11 - 9*a**3*b**8*c**11 -
        2*a**8*b**2*c**12 - 15*a**7*b**3*c**12 - 37*a**6*b**4*c**12 -
        45*a**5*b**5*c**12 - 31*a**4*b**6*c**12 - 12*a**3*b**7*c**12 -
        2*a**2*b**8*c**12 - 2*a**7*b**2*c**13 - 9*a**6*b**3*c**13 -
        17*a**5*b**4*c**13 - 17*a**4*b**5*c**13 - 9*a**3*b**6*c**13 -
        2*a**2*b**7*c**13 - 2*a**12*b**6*c**2*s**2 -
        a**11*b**7*c**2*s**2 - 4*a**12*b**5*c**3*s**2 -
        12*a**11*b**6*c**3*s**2 - 9*a**10*b**7*c**3*s**2 -
        2*a**9*b**8*c**3*s**2 - 3*a**12*b**4*c**4*s**2 -
        16*a**11*b**5*c**4*s**2 - 32*a**10*b**6*c**4*s**2 -
        21*a**9*b**7*c**4*s**2 - 5*a**8*b**8*c**4*s**2 -
        3*a**12*b**3*c**5*s**2 - 15*a**11*b**4*c**5*s**2 -
        38*a**10*b**5*c**5*s**2 - 46*a**9*b**6*c**5*s**2 -
        24*a**8*b**7*c**5*s**2 - 5*a**7*b**8*c**5*s**2 -
        2*a**12*b**2*c**6*s**2 - 16*a**11*b**3*c**6*s**2 -
        43*a**10*b**4*c**6*s**2 - 62*a**9*b**5*c**6*s**2 -
        61*a**8*b**6*c**6*s**2 - 32*a**7*b**7*c**6*s**2 -
        7*a**6*b**8*c**6*s**2 - 6*a**11*b**2*c**7*s**2 -
        27*a**10*b**3*c**7*s**2 - 50*a**9*b**4*c**7*s**2 -
        69*a**8*b**5*c**7*s**2 - 72*a**7*b**6*c**7*s**2 -
        42*a**6*b**7*c**7*s**2 - 9*a**5*b**8*c**7*s**2 -
        a**11*b*c**8*s**2 - 8*a**10*b**2*c**8*s**2 -
        22*a**9*b**3*c**8*s**2 - 46*a**8*b**4*c**8*s**2 -
        66*a**7*b**5*c**8*s**2 - 63*a**6*b**6*c**8*s**2 -
        38*a**5*b**7*c**8*s**2 - 10*a**4*b**8*c**8*s**2 -
        a**10*b*c**9*s**2 - 6*a**9*b**2*c**9*s**2 -
        32*a**8*b**3*c**9*s**2 - 75*a**7*b**4*c**9*s**2 -
        88*a**6*b**5*c**9*s**2 - 71*a**5*b**6*c**9*s**2 -
        45*a**4*b**7*c**9*s**2 - 13*a**3*b**8*c**9*s**2 +
        a**9*b*c**10*s**2 - 4*a**8*b**2*c**10*s**2 -
        38*a**7*b**3*c**10*s**2 - 77*a**6*b**4*c**10*s**2 -
        84*a**5*b**5*c**10*s**2 - 71*a**4*b**6*c**10*s**2 -
        43*a**3*b**7*c**10*s**2 - 9*a**2*b**8*c**10*s**2 -
        a**8*b*c**11*s**2 - 16*a**7*b**2*c**11*s**2 -
        50*a**6*b**3*c**11*s**2 - 71*a**5*b**4*c**11*s**2 -
        62*a**4*b**5*c**11*s**2 - 43*a**3*b**6*c**11*s**2 -
        19*a**2*b**7*c**11*s**2 - 2*a*b**8*c**11*s**2 -
        4*a**7*b*c**12*s**2 - 23*a**6*b**2*c**12*s**2 -
        53*a**5*b**3*c**12*s**2 - 62*a**4*b**4*c**12*s**2 -
        43*a**3*b**5*c**12*s**2 - 17*a**2*b**6*c**12*s**2 -
        4*a*b**7*c**12*s**2 - 2*a**6*b*c**13*s**2 -
        9*a**5*b**2*c**13*s**2 - 18*a**4*b**3*c**13*s**2 -
        20*a**3*b**4*c**13*s**2 - 11*a**2*b**5*c**13*s**2 -
        2*a*b**6*c**13*s**2 - 2*a**11*b**5*c**2*s**4 -
        a**10*b**6*c**2*s**4 + 15*a**11*b**4*c**3*s**4 +
        32*a**10*b**5*c**3*s**4 + 26*a**9*b**6*c**3*s**4 +
        8*a**8*b**7*c**3*s**4 + 32*a**11*b**3*c**4*s**4 +
        135*a**10*b**4*c**4*s**4 + 185*a**9*b**5*c**4*s**4 +
        109*a**8*b**6*c**4*s**4 + 22*a**7*b**7*c**4*s**4 +
        15*a**11*b**2*c**5*s**4 + 133*a**10*b**3*c**5*s**4 +
        318*a**9*b**4*c**5*s**4 + 302*a**8*b**5*c**5*s**4 +
        118*a**7*b**6*c**5*s**4 + 14*a**6*b**7*c**5*s**4 +
        41*a**10*b**2*c**6*s**4 + 188*a**9*b**3*c**6*s**4 +
        286*a**8*b**4*c**6*s**4 + 161*a**7*b**5*c**6*s**4 +
        25*a**6*b**6*c**6*s**4 - a**5*b**7*c**6*s**4 +
        6*a**10*b*c**7*s**4 + 50*a**9*b**2*c**7*s**4 +
        116*a**8*b**3*c**7*s**4 + 114*a**7*b**4*c**7*s**4 +
        67*a**6*b**5*c**7*s**4 + 39*a**5*b**6*c**7*s**4 +
        14*a**4*b**7*c**7*s**4 + 3*a**9*b*c**8*s**4 +
        4*a**8*b**2*c**8*s**4 + 23*a**7*b**3*c**8*s**4 +
        122*a**6*b**4*c**8*s**4 + 208*a**5*b**5*c**8*s**4 +
        137*a**4*b**6*c**8*s**4 + 32*a**3*b**7*c**8*s**4 -
        5*a**8*b*c**9*s**4 - 4*a**7*b**2*c**9*s**4 +
        100*a**6*b**3*c**9*s**4 + 293*a**5*b**4*c**9*s**4 +
        319*a**4*b**5*c**9*s**4 + 145*a**3*b**6*c**9*s**4 +
        22*a**2*b**7*c**9*s**4 + 4*a**7*b*c**10*s**4 +
        60*a**6*b**2*c**10*s**4 + 214*a**5*b**3*c**10*s**4 +
        324*a**4*b**4*c**10*s**4 + 236*a**3*b**5*c**10*s**4 +
        71*a**2*b**6*c**10*s**4 + 6*a*b**7*c**10*s**4 +
        10*a**6*b*c**11*s**4 + 61*a**5*b**2*c**11*s**4 +
        134*a**4*b**3*c**11*s**4 + 144*a**3*b**4*c**11*s**4 +
        75*a**2*b**5*c**11*s**4 + 13*a*b**6*c**11*s**4 +
        5*a**5*b*c**12*s**4 + 16*a**4*b**2*c**12*s**4 +
        22*a**3*b**3*c**12*s**4 + 15*a**2*b**4*c**12*s**4 +
        6*a*b**5*c**12*s**4 - a**3*b**2*c**13*s**4 -
        3*a**2*b**3*c**13*s**4 - 2*a*b**4*c**13*s**4 +
        a**10*b**3*c**3*s**6 - 3*a**8*b**5*c**3*s**6 -
        2*a**7*b**6*c**3*s**6 + a**10*b**2*c**4*s**6 -
        2*a**9*b**3*c**4*s**6 - 7*a**8*b**4*c**4*s**6 -
        5*a**7*b**5*c**4*s**6 - a**6*b**6*c**4*s**6 -
        10*a**8*b**3*c**5*s**6 - 11*a**7*b**4*c**5*s**6 -
        a**6*b**5*c**5*s**6 + a**5*b**6*c**5*s**6 + 3*a**9*b*c**6*s**6
        + a**8*b**2*c**6*s**6 - 8*a**7*b**3*c**6*s**6 -
        7*a**6*b**4*c**6*s**6 - 5*a**5*b**5*c**6*s**6 -
        2*a**4*b**6*c**6*s**6 + a**8*b*c**7*s**6 - a**6*b**3*c**7*s**6
        - 3*a**5*b**4*c**7*s**6 - 5*a**4*b**5*c**7*s**6 -
        2*a**3*b**6*c**7*s**6 - 3*a**7*b*c**8*s**6 -
        7*a**6*b**2*c**8*s**6 - 12*a**5*b**3*c**8*s**6 -
        9*a**4*b**4*c**8*s**6 - 3*a**3*b**5*c**8*s**6 +
        a**2*b**6*c**8*s**6 + a**6*b*c**9*s**6 - 4*a**5*b**2*c**9*s**6
        - 12*a**4*b**3*c**9*s**6 - 11*a**3*b**4*c**9*s**6 -
        2*a**2*b**5*c**9*s**6 + a*b**6*c**9*s**6 -
        a**4*b**2*c**10*s**6 - 3*a**3*b**3*c**10*s**6 +
        a*b**5*c**10*s**6 - a**4*b*c**11*s**6 - 3*a**3*b**2*c**11*s**6
        - 2*a**2*b**3*c**11*s**6 + a*b**4*c**11*s**6 + b**5*c**11*s**6
        - a**2*b**2*c**12*s**6 - 2*a*b**3*c**12*s**6 -
        b**4*c**12*s**6)/(a**13*b**6*s**3 - a**12*b**7*s**3 -
        a**13*b**5*c*s**3 + 2*a**11*b**7*c*s**3 - a**10*b**8*c*s**3 +
        a**12*b**5*c**2*s**3 - 3*a**11*b**6*c**2*s**3 +
        2*a**9*b**8*c**2*s**3 + a**12*b**4*c**3*s**3 +
        a**11*b**5*c**3*s**3 + 2*a**10*b**6*c**3*s**3 -
        4*a**9*b**7*c**3*s**3 - a**8*b**8*c**3*s**3 +
        a**7*b**9*c**3*s**3 - a**13*b**2*c**4*s**3 -
        a**12*b**3*c**4*s**3 - 2*a**11*b**4*c**4*s**3 +
        a**10*b**5*c**4*s**3 + 3*a**9*b**6*c**4*s**3 +
        4*a**8*b**7*c**4*s**3 - 3*a**7*b**8*c**4*s**3 -
        a**6*b**9*c**4*s**3 + a**13*b*c**5*s**3 +
        2*a**12*b**2*c**5*s**3 + 2*a**11*b**3*c**5*s**3 -
        2*a**10*b**4*c**5*s**3 - 6*a**9*b**5*c**5*s**3 -
        4*a**8*b**6*c**5*s**3 + 3*a**7*b**7*c**5*s**3 +
        5*a**6*b**8*c**5*s**3 - a**5*b**9*c**5*s**3 -
        3*a**12*b*c**6*s**3 - a**11*b**2*c**6*s**3 +
        2*a**10*b**3*c**6*s**3 + 9*a**9*b**4*c**6*s**3 +
        4*a**8*b**5*c**6*s**3 - 5*a**7*b**6*c**6*s**3 -
        8*a**6*b**7*c**6*s**3 + 2*a**4*b**9*c**6*s**3 +
        a**12*c**7*s**3 + 3*a**11*b*c**7*s**3 - 4*a**10*b**2*c**7*s**3
        - 8*a**9*b**3*c**7*s**3 - 7*a**8*b**4*c**7*s**3 +
        8*a**7*b**5*c**7*s**3 + 11*a**6*b**6*c**7*s**3 +
        2*a**5*b**7*c**7*s**3 - 5*a**4*b**8*c**7*s**3 -
        a**3*b**9*c**7*s**3 - 2*a**11*c**8*s**3 + a**10*b*c**8*s**3 +
        9*a**9*b**2*c**8*s**3 + 6*a**8*b**3*c**8*s**3 -
        6*a**7*b**4*c**8*s**3 - 16*a**6*b**5*c**8*s**3 -
        2*a**5*b**6*c**8*s**3 + 7*a**4*b**7*c**8*s**3 +
        4*a**3*b**8*c**8*s**3 - a**2*b**9*c**8*s**3 + a**10*c**9*s**3
        - 6*a**9*b*c**9*s**3 - 6*a**8*b**2*c**9*s**3 +
        5*a**7*b**3*c**9*s**3 + 15*a**6*b**4*c**9*s**3 +
        6*a**5*b**5*c**9*s**3 - 10*a**4*b**6*c**9*s**3 -
        7*a**3*b**7*c**9*s**3 + a**2*b**8*c**9*s**3 + a*b**9*c**9*s**3
        + a**9*c**10*s**3 + 6*a**8*b*c**10*s**3 -
        3*a**7*b**2*c**10*s**3 - 12*a**6*b**3*c**10*s**3 -
        8*a**5*b**4*c**10*s**3 + 9*a**4*b**5*c**10*s**3 +
        10*a**3*b**6*c**10*s**3 - 3*a*b**8*c**10*s**3 -
        2*a**8*c**11*s**3 - a**7*b*c**11*s**3 + 9*a**6*b**2*c**11*s**3
        + 6*a**5*b**3*c**11*s**3 - 5*a**4*b**4*c**11*s**3 -
        11*a**3*b**5*c**11*s**3 - a**2*b**6*c**11*s**3 +
        4*a*b**7*c**11*s**3 + b**8*c**11*s**3 + a**7*c**12*s**3 -
        3*a**6*b*c**12*s**3 - 6*a**5*b**2*c**12*s**3 +
        3*a**4*b**3*c**12*s**3 + 8*a**3*b**4*c**12*s**3 +
        3*a**2*b**5*c**12*s**3 - 4*a*b**6*c**12*s**3 -
        2*b**7*c**12*s**3 + 3*a**5*b*c**13*s**3 -
        5*a**3*b**3*c**13*s**3 - 3*a**2*b**4*c**13*s**3 +
        3*a*b**5*c**13*s**3 + 2*b**6*c**13*s**3 - a**4*b*c**14*s**3 +
        2*a**3*b**2*c**14*s**3 + 2*a**2*b**3*c**14*s**3 -
        a*b**4*c**14*s**3 - 2*b**5*c**14*s**3 - a**2*b**2*c**15*s**3 +
        b**4*c**15*s**3), (a**7*b**12*c**3 + a**6*b**13*c**3 +
        2*a**8*b**10*c**4 + 6*a**7*b**11*c**4 + 3*a**6*b**12*c**4 +
        5*a**8*b**9*c**5 + 16*a**7*b**10*c**5 + 16*a**6*b**11*c**5 +
        4*a**5*b**12*c**5 - a**4*b**13*c**5 + 5*a**8*b**8*c**6 +
        27*a**7*b**9*c**6 + 41*a**6*b**10*c**6 + 27*a**5*b**11*c**6 +
        5*a**4*b**12*c**6 + 7*a**8*b**7*c**7 + 26*a**7*b**8*c**7 +
        46*a**6*b**9*c**7 + 43*a**5*b**10*c**7 + 17*a**4*b**11*c**7 +
        a**3*b**12*c**7 + 9*a**8*b**6*c**8 + 21*a**7*b**7*c**8 +
        25*a**6*b**8*c**8 + 26*a**5*b**9*c**8 + 17*a**4*b**10*c**8 +
        5*a**3*b**11*c**8 + 10*a**8*b**5*c**9 + 29*a**7*b**6*c**9 +
        34*a**6*b**7*c**9 + 21*a**5*b**8*c**9 + 10*a**4*b**9*c**9 +
        5*a**3*b**10*c**9 + a**2*b**11*c**9 + 13*a**8*b**4*c**10 +
        45*a**7*b**5*c**10 + 66*a**6*b**6*c**10 + 48*a**5*b**7*c**10 +
        13*a**4*b**8*c**10 - a**3*b**9*c**10 + 9*a**8*b**3*c**11 +
        35*a**7*b**4*c**11 + 60*a**6*b**5*c**11 + 58*a**5*b**6*c**11 +
        29*a**4*b**7*c**11 + 4*a**3*b**8*c**11 - a**2*b**9*c**11 +
        2*a**8*b**2*c**12 + 12*a**7*b**3*c**12 + 31*a**6*b**4*c**12 +
        45*a**5*b**5*c**12 + 37*a**4*b**6*c**12 + 15*a**3*b**7*c**12 +
        2*a**2*b**8*c**12 + 2*a**7*b**2*c**13 + 9*a**6*b**3*c**13 +
        17*a**5*b**4*c**13 + 17*a**4*b**5*c**13 + 9*a**3*b**6*c**13 +
        2*a**2*b**7*c**13 + a**7*b**11*c**2*s**2 +
        2*a**6*b**12*c**2*s**2 + 2*a**8*b**9*c**3*s**2 +
        9*a**7*b**10*c**3*s**2 + 12*a**6*b**11*c**3*s**2 +
        4*a**5*b**12*c**3*s**2 + 5*a**8*b**8*c**4*s**2 +
        21*a**7*b**9*c**4*s**2 + 32*a**6*b**10*c**4*s**2 +
        16*a**5*b**11*c**4*s**2 + 3*a**4*b**12*c**4*s**2 +
        5*a**8*b**7*c**5*s**2 + 24*a**7*b**8*c**5*s**2 +
        46*a**6*b**9*c**5*s**2 + 38*a**5*b**10*c**5*s**2 +
        15*a**4*b**11*c**5*s**2 + 3*a**3*b**12*c**5*s**2 +
        7*a**8*b**6*c**6*s**2 + 32*a**7*b**7*c**6*s**2 +
        61*a**6*b**8*c**6*s**2 + 62*a**5*b**9*c**6*s**2 +
        43*a**4*b**10*c**6*s**2 + 16*a**3*b**11*c**6*s**2 +
        2*a**2*b**12*c**6*s**2 + 9*a**8*b**5*c**7*s**2 +
        42*a**7*b**6*c**7*s**2 + 72*a**6*b**7*c**7*s**2 +
        69*a**5*b**8*c**7*s**2 + 50*a**4*b**9*c**7*s**2 +
        27*a**3*b**10*c**7*s**2 + 6*a**2*b**11*c**7*s**2 +
        10*a**8*b**4*c**8*s**2 + 38*a**7*b**5*c**8*s**2 +
        63*a**6*b**6*c**8*s**2 + 66*a**5*b**7*c**8*s**2 +
        46*a**4*b**8*c**8*s**2 + 22*a**3*b**9*c**8*s**2 +
        8*a**2*b**10*c**8*s**2 + a*b**11*c**8*s**2 +
        13*a**8*b**3*c**9*s**2 + 45*a**7*b**4*c**9*s**2 +
        71*a**6*b**5*c**9*s**2 + 88*a**5*b**6*c**9*s**2 +
        75*a**4*b**7*c**9*s**2 + 32*a**3*b**8*c**9*s**2 +
        6*a**2*b**9*c**9*s**2 + a*b**10*c**9*s**2 +
        9*a**8*b**2*c**10*s**2 + 43*a**7*b**3*c**10*s**2 +
        71*a**6*b**4*c**10*s**2 + 84*a**5*b**5*c**10*s**2 +
        77*a**4*b**6*c**10*s**2 + 38*a**3*b**7*c**10*s**2 +
        4*a**2*b**8*c**10*s**2 - a*b**9*c**10*s**2 +
        2*a**8*b*c**11*s**2 + 19*a**7*b**2*c**11*s**2 +
        43*a**6*b**3*c**11*s**2 + 62*a**5*b**4*c**11*s**2 +
        71*a**4*b**5*c**11*s**2 + 50*a**3*b**6*c**11*s**2 +
        16*a**2*b**7*c**11*s**2 + a*b**8*c**11*s**2 +
        4*a**7*b*c**12*s**2 + 17*a**6*b**2*c**12*s**2 +
        43*a**5*b**3*c**12*s**2 + 62*a**4*b**4*c**12*s**2 +
        53*a**3*b**5*c**12*s**2 + 23*a**2*b**6*c**12*s**2 +
        4*a*b**7*c**12*s**2 + 2*a**6*b*c**13*s**2 +
        11*a**5*b**2*c**13*s**2 + 20*a**4*b**3*c**13*s**2 +
        18*a**3*b**4*c**13*s**2 + 9*a**2*b**5*c**13*s**2 +
        2*a*b**6*c**13*s**2 + a**6*b**10*c**2*s**4 +
        2*a**5*b**11*c**2*s**4 - 8*a**7*b**8*c**3*s**4 -
        26*a**6*b**9*c**3*s**4 - 32*a**5*b**10*c**3*s**4 -
        15*a**4*b**11*c**3*s**4 - 22*a**7*b**7*c**4*s**4 -
        109*a**6*b**8*c**4*s**4 - 185*a**5*b**9*c**4*s**4 -
        135*a**4*b**10*c**4*s**4 - 32*a**3*b**11*c**4*s**4 -
        14*a**7*b**6*c**5*s**4 - 118*a**6*b**7*c**5*s**4 -
        302*a**5*b**8*c**5*s**4 - 318*a**4*b**9*c**5*s**4 -
        133*a**3*b**10*c**5*s**4 - 15*a**2*b**11*c**5*s**4 +
        a**7*b**5*c**6*s**4 - 25*a**6*b**6*c**6*s**4 -
        161*a**5*b**7*c**6*s**4 - 286*a**4*b**8*c**6*s**4 -
        188*a**3*b**9*c**6*s**4 - 41*a**2*b**10*c**6*s**4 -
        14*a**7*b**4*c**7*s**4 - 39*a**6*b**5*c**7*s**4 -
        67*a**5*b**6*c**7*s**4 - 114*a**4*b**7*c**7*s**4 -
        116*a**3*b**8*c**7*s**4 - 50*a**2*b**9*c**7*s**4 -
        6*a*b**10*c**7*s**4 - 32*a**7*b**3*c**8*s**4 -
        137*a**6*b**4*c**8*s**4 - 208*a**5*b**5*c**8*s**4 -
        122*a**4*b**6*c**8*s**4 - 23*a**3*b**7*c**8*s**4 -
        4*a**2*b**8*c**8*s**4 - 3*a*b**9*c**8*s**4 -
        22*a**7*b**2*c**9*s**4 - 145*a**6*b**3*c**9*s**4 -
        319*a**5*b**4*c**9*s**4 - 293*a**4*b**5*c**9*s**4 -
        100*a**3*b**6*c**9*s**4 + 4*a**2*b**7*c**9*s**4 +
        5*a*b**8*c**9*s**4 - 6*a**7*b*c**10*s**4 -
        71*a**6*b**2*c**10*s**4 - 236*a**5*b**3*c**10*s**4 -
        324*a**4*b**4*c**10*s**4 - 214*a**3*b**5*c**10*s**4 -
        60*a**2*b**6*c**10*s**4 - 4*a*b**7*c**10*s**4 -
        13*a**6*b*c**11*s**4 - 75*a**5*b**2*c**11*s**4 -
        144*a**4*b**3*c**11*s**4 - 134*a**3*b**4*c**11*s**4 -
        61*a**2*b**5*c**11*s**4 - 10*a*b**6*c**11*s**4 -
        6*a**5*b*c**12*s**4 - 15*a**4*b**2*c**12*s**4 -
        22*a**3*b**3*c**12*s**4 - 16*a**2*b**4*c**12*s**4 -
        5*a*b**5*c**12*s**4 + 2*a**4*b*c**13*s**4 +
        3*a**3*b**2*c**13*s**4 + a**2*b**3*c**13*s**4 +
        2*a**6*b**7*c**3*s**6 + 3*a**5*b**8*c**3*s**6 -
        a**3*b**10*c**3*s**6 + a**6*b**6*c**4*s**6 +
        5*a**5*b**7*c**4*s**6 + 7*a**4*b**8*c**4*s**6 +
        2*a**3*b**9*c**4*s**6 - a**2*b**10*c**4*s**6 -
        a**6*b**5*c**5*s**6 + a**5*b**6*c**5*s**6 +
        11*a**4*b**7*c**5*s**6 + 10*a**3*b**8*c**5*s**6 +
        2*a**6*b**4*c**6*s**6 + 5*a**5*b**5*c**6*s**6 +
        7*a**4*b**6*c**6*s**6 + 8*a**3*b**7*c**6*s**6 -
        a**2*b**8*c**6*s**6 - 3*a*b**9*c**6*s**6 +
        2*a**6*b**3*c**7*s**6 + 5*a**5*b**4*c**7*s**6 +
        3*a**4*b**5*c**7*s**6 + a**3*b**6*c**7*s**6 - a*b**8*c**7*s**6
        - a**6*b**2*c**8*s**6 + 3*a**5*b**3*c**8*s**6 +
        9*a**4*b**4*c**8*s**6 + 12*a**3*b**5*c**8*s**6 +
        7*a**2*b**6*c**8*s**6 + 3*a*b**7*c**8*s**6 - a**6*b*c**9*s**6
        + 2*a**5*b**2*c**9*s**6 + 11*a**4*b**3*c**9*s**6 +
        12*a**3*b**4*c**9*s**6 + 4*a**2*b**5*c**9*s**6 -
        a*b**6*c**9*s**6 - a**5*b*c**10*s**6 + 3*a**3*b**3*c**10*s**6
        + a**2*b**4*c**10*s**6 - a**5*c**11*s**6 - a**4*b*c**11*s**6 +
        2*a**3*b**2*c**11*s**6 + 3*a**2*b**3*c**11*s**6 +
        a*b**4*c**11*s**6 + a**4*c**12*s**6 + 2*a**3*b*c**12*s**6 +
        a**2*b**2*c**12*s**6)/(a**7*b**12*s**3 - a**6*b**13*s**3 +
        a**8*b**10*c*s**3 - 2*a**7*b**11*c*s**3 + a**5*b**13*c*s**3 -
        2*a**8*b**9*c**2*s**3 + 3*a**6*b**11*c**2*s**3 -
        a**5*b**12*c**2*s**3 - a**9*b**7*c**3*s**3 +
        a**8*b**8*c**3*s**3 + 4*a**7*b**9*c**3*s**3 -
        2*a**6*b**10*c**3*s**3 - a**5*b**11*c**3*s**3 -
        a**4*b**12*c**3*s**3 + a**9*b**6*c**4*s**3 +
        3*a**8*b**7*c**4*s**3 - 4*a**7*b**8*c**4*s**3 -
        3*a**6*b**9*c**4*s**3 - a**5*b**10*c**4*s**3 +
        2*a**4*b**11*c**4*s**3 + a**3*b**12*c**4*s**3 +
        a**2*b**13*c**4*s**3 + a**9*b**5*c**5*s**3 -
        5*a**8*b**6*c**5*s**3 - 3*a**7*b**7*c**5*s**3 +
        4*a**6*b**8*c**5*s**3 + 6*a**5*b**9*c**5*s**3 +
        2*a**4*b**10*c**5*s**3 - 2*a**3*b**11*c**5*s**3 -
        2*a**2*b**12*c**5*s**3 - a*b**13*c**5*s**3 -
        2*a**9*b**4*c**6*s**3 + 8*a**7*b**6*c**6*s**3 +
        5*a**6*b**7*c**6*s**3 - 4*a**5*b**8*c**6*s**3 -
        9*a**4*b**9*c**6*s**3 - 2*a**3*b**10*c**6*s**3 +
        a**2*b**11*c**6*s**3 + 3*a*b**12*c**6*s**3 +
        a**9*b**3*c**7*s**3 + 5*a**8*b**4*c**7*s**3 -
        2*a**7*b**5*c**7*s**3 - 11*a**6*b**6*c**7*s**3 -
        8*a**5*b**7*c**7*s**3 + 7*a**4*b**8*c**7*s**3 +
        8*a**3*b**9*c**7*s**3 + 4*a**2*b**10*c**7*s**3 -
        3*a*b**11*c**7*s**3 - b**12*c**7*s**3 + a**9*b**2*c**8*s**3 -
        4*a**8*b**3*c**8*s**3 - 7*a**7*b**4*c**8*s**3 +
        2*a**6*b**5*c**8*s**3 + 16*a**5*b**6*c**8*s**3 +
        6*a**4*b**7*c**8*s**3 - 6*a**3*b**8*c**8*s**3 -
        9*a**2*b**9*c**8*s**3 - a*b**10*c**8*s**3 + 2*b**11*c**8*s**3
        - a**9*b*c**9*s**3 - a**8*b**2*c**9*s**3 +
        7*a**7*b**3*c**9*s**3 + 10*a**6*b**4*c**9*s**3 -
        6*a**5*b**5*c**9*s**3 - 15*a**4*b**6*c**9*s**3 -
        5*a**3*b**7*c**9*s**3 + 6*a**2*b**8*c**9*s**3 +
        6*a*b**9*c**9*s**3 - b**10*c**9*s**3 + 3*a**8*b*c**10*s**3 -
        10*a**6*b**3*c**10*s**3 - 9*a**5*b**4*c**10*s**3 +
        8*a**4*b**5*c**10*s**3 + 12*a**3*b**6*c**10*s**3 +
        3*a**2*b**7*c**10*s**3 - 6*a*b**8*c**10*s**3 - b**9*c**10*s**3
        - a**8*c**11*s**3 - 4*a**7*b*c**11*s**3 + a**6*b**2*c**11*s**3
        + 11*a**5*b**3*c**11*s**3 + 5*a**4*b**4*c**11*s**3 -
        6*a**3*b**5*c**11*s**3 - 9*a**2*b**6*c**11*s**3 +
        a*b**7*c**11*s**3 + 2*b**8*c**11*s**3 + 2*a**7*c**12*s**3 +
        4*a**6*b*c**12*s**3 - 3*a**5*b**2*c**12*s**3 -
        8*a**4*b**3*c**12*s**3 - 3*a**3*b**4*c**12*s**3 +
        6*a**2*b**5*c**12*s**3 + 3*a*b**6*c**12*s**3 - b**7*c**12*s**3
        - 2*a**6*c**13*s**3 - 3*a**5*b*c**13*s**3 +
        3*a**4*b**2*c**13*s**3 + 5*a**3*b**3*c**13*s**3 -
        3*a*b**5*c**13*s**3 + 2*a**5*c**14*s**3 + a**4*b*c**14*s**3 -
        2*a**3*b**2*c**14*s**3 - 2*a**2*b**3*c**14*s**3 +
        a*b**4*c**14*s**3 - a**4*c**15*s**3 + a**2*b**2*c**15*s**3),
        (-2*a**13*b**7*c**2 - 2*a**12*b**8*c**2 - 9*a**13*b**6*c**3 -
        12*a**12*b**7*c**3 - 9*a**11*b**8*c**3 - 17*a**13*b**5*c**4 -
        31*a**12*b**6*c**4 - 35*a**11*b**7*c**4 - 13*a**10*b**8*c**4 -
        17*a**13*b**4*c**5 - 45*a**12*b**5*c**5 - 60*a**11*b**6*c**5 -
        45*a**10*b**7*c**5 - 10*a**9*b**8*c**5 - 9*a**13*b**3*c**6 -
        37*a**12*b**4*c**6 - 58*a**11*b**5*c**6 - 66*a**10*b**6*c**6 -
        29*a**9*b**7*c**6 - 9*a**8*b**8*c**6 - 2*a**13*b**2*c**7 -
        15*a**12*b**3*c**7 - 29*a**11*b**4*c**7 - 48*a**10*b**5*c**7 -
        34*a**9*b**6*c**7 - 21*a**8*b**7*c**7 - 7*a**7*b**8*c**7 -
        2*a**12*b**2*c**8 - 4*a**11*b**3*c**8 - 13*a**10*b**4*c**8 -
        21*a**9*b**5*c**8 - 25*a**8*b**6*c**8 - 26*a**7*b**7*c**8 -
        5*a**6*b**8*c**8 + a**11*b**2*c**9 + a**10*b**3*c**9 -
        10*a**9*b**4*c**9 - 26*a**8*b**5*c**9 - 46*a**7*b**6*c**9 -
        27*a**6*b**7*c**9 - 5*a**5*b**8*c**9 - 5*a**9*b**3*c**10 -
        17*a**8*b**4*c**10 - 43*a**7*b**5*c**10 - 41*a**6*b**6*c**10 -
        16*a**5*b**7*c**10 - 2*a**4*b**8*c**10 - a**9*b**2*c**11 -
        5*a**8*b**3*c**11 - 17*a**7*b**4*c**11 - 27*a**6*b**5*c**11 -
        16*a**5*b**6*c**11 - 6*a**4*b**7*c**11 - a**7*b**3*c**12 -
        5*a**6*b**4*c**12 - 4*a**5*b**5*c**12 - 3*a**4*b**6*c**12 -
        a**3*b**7*c**12 + a**5*b**4*c**13 - a**3*b**6*c**13 -
        2*a**13*b**6*c*s**2 - 4*a**12*b**7*c*s**2 -
        2*a**11*b**8*c*s**2 - 11*a**13*b**5*c**2*s**2 -
        17*a**12*b**6*c**2*s**2 - 19*a**11*b**7*c**2*s**2 -
        9*a**10*b**8*c**2*s**2 - 20*a**13*b**4*c**3*s**2 -
        43*a**12*b**5*c**3*s**2 - 43*a**11*b**6*c**3*s**2 -
        43*a**10*b**7*c**3*s**2 - 13*a**9*b**8*c**3*s**2 -
        18*a**13*b**3*c**4*s**2 - 62*a**12*b**4*c**4*s**2 -
        62*a**11*b**5*c**4*s**2 - 71*a**10*b**6*c**4*s**2 -
        45*a**9*b**7*c**4*s**2 - 10*a**8*b**8*c**4*s**2 -
        9*a**13*b**2*c**5*s**2 - 53*a**12*b**3*c**5*s**2 -
        71*a**11*b**4*c**5*s**2 - 84*a**10*b**5*c**5*s**2 -
        71*a**9*b**6*c**5*s**2 - 38*a**8*b**7*c**5*s**2 -
        9*a**7*b**8*c**5*s**2 - 2*a**13*b*c**6*s**2 -
        23*a**12*b**2*c**6*s**2 - 50*a**11*b**3*c**6*s**2 -
        77*a**10*b**4*c**6*s**2 - 88*a**9*b**5*c**6*s**2 -
        63*a**8*b**6*c**6*s**2 - 42*a**7*b**7*c**6*s**2 -
        7*a**6*b**8*c**6*s**2 - 4*a**12*b*c**7*s**2 -
        16*a**11*b**2*c**7*s**2 - 38*a**10*b**3*c**7*s**2 -
        75*a**9*b**4*c**7*s**2 - 66*a**8*b**5*c**7*s**2 -
        72*a**7*b**6*c**7*s**2 - 32*a**6*b**7*c**7*s**2 -
        5*a**5*b**8*c**7*s**2 - a**11*b*c**8*s**2 -
        4*a**10*b**2*c**8*s**2 - 32*a**9*b**3*c**8*s**2 -
        46*a**8*b**4*c**8*s**2 - 69*a**7*b**5*c**8*s**2 -
        61*a**6*b**6*c**8*s**2 - 24*a**5*b**7*c**8*s**2 -
        5*a**4*b**8*c**8*s**2 + a**10*b*c**9*s**2 -
        6*a**9*b**2*c**9*s**2 - 22*a**8*b**3*c**9*s**2 -
        50*a**7*b**4*c**9*s**2 - 62*a**6*b**5*c**9*s**2 -
        46*a**5*b**6*c**9*s**2 - 21*a**4*b**7*c**9*s**2 -
        2*a**3*b**8*c**9*s**2 - a**9*b*c**10*s**2 -
        8*a**8*b**2*c**10*s**2 - 27*a**7*b**3*c**10*s**2 -
        43*a**6*b**4*c**10*s**2 - 38*a**5*b**5*c**10*s**2 -
        32*a**4*b**6*c**10*s**2 - 9*a**3*b**7*c**10*s**2 -
        a**8*b*c**11*s**2 - 6*a**7*b**2*c**11*s**2 -
        16*a**6*b**3*c**11*s**2 - 15*a**5*b**4*c**11*s**2 -
        16*a**4*b**5*c**11*s**2 - 12*a**3*b**6*c**11*s**2 -
        a**2*b**7*c**11*s**2 - 2*a**6*b**2*c**12*s**2 -
        3*a**5*b**3*c**12*s**2 - 3*a**4*b**4*c**12*s**2 -
        4*a**3*b**5*c**12*s**2 - 2*a**2*b**6*c**12*s**2 -
        2*a**13*b**4*c*s**4 + 6*a**12*b**5*c*s**4 +
        13*a**11*b**6*c*s**4 + 6*a**10*b**7*c*s**4 -
        3*a**13*b**3*c**2*s**4 + 15*a**12*b**4*c**2*s**4 +
        75*a**11*b**5*c**2*s**4 + 71*a**10*b**6*c**2*s**4 +
        22*a**9*b**7*c**2*s**4 - a**13*b**2*c**3*s**4 +
        22*a**12*b**3*c**3*s**4 + 144*a**11*b**4*c**3*s**4 +
        236*a**10*b**5*c**3*s**4 + 145*a**9*b**6*c**3*s**4 +
        32*a**8*b**7*c**3*s**4 + 16*a**12*b**2*c**4*s**4 +
        134*a**11*b**3*c**4*s**4 + 324*a**10*b**4*c**4*s**4 +
        319*a**9*b**5*c**4*s**4 + 137*a**8*b**6*c**4*s**4 +
        14*a**7*b**7*c**4*s**4 + 5*a**12*b*c**5*s**4 +
        61*a**11*b**2*c**5*s**4 + 214*a**10*b**3*c**5*s**4 +
        293*a**9*b**4*c**5*s**4 + 208*a**8*b**5*c**5*s**4 +
        39*a**7*b**6*c**5*s**4 - a**6*b**7*c**5*s**4 +
        10*a**11*b*c**6*s**4 + 60*a**10*b**2*c**6*s**4 +
        100*a**9*b**3*c**6*s**4 + 122*a**8*b**4*c**6*s**4 +
        67*a**7*b**5*c**6*s**4 + 25*a**6*b**6*c**6*s**4 +
        14*a**5*b**7*c**6*s**4 + 4*a**10*b*c**7*s**4 -
        4*a**9*b**2*c**7*s**4 + 23*a**8*b**3*c**7*s**4 +
        114*a**7*b**4*c**7*s**4 + 161*a**6*b**5*c**7*s**4 +
        118*a**5*b**6*c**7*s**4 + 22*a**4*b**7*c**7*s**4 -
        5*a**9*b*c**8*s**4 + 4*a**8*b**2*c**8*s**4 +
        116*a**7*b**3*c**8*s**4 + 286*a**6*b**4*c**8*s**4 +
        302*a**5*b**5*c**8*s**4 + 109*a**4*b**6*c**8*s**4 +
        8*a**3*b**7*c**8*s**4 + 3*a**8*b*c**9*s**4 +
        50*a**7*b**2*c**9*s**4 + 188*a**6*b**3*c**9*s**4 +
        318*a**5*b**4*c**9*s**4 + 185*a**4*b**5*c**9*s**4 +
        26*a**3*b**6*c**9*s**4 + 6*a**7*b*c**10*s**4 +
        41*a**6*b**2*c**10*s**4 + 133*a**5*b**3*c**10*s**4 +
        135*a**4*b**4*c**10*s**4 + 32*a**3*b**5*c**10*s**4 -
        a**2*b**6*c**10*s**4 + 15*a**5*b**2*c**11*s**4 +
        32*a**4*b**3*c**11*s**4 + 15*a**3*b**4*c**11*s**4 -
        2*a**2*b**5*c**11*s**4 - a**12*b**4*s**6 + a**11*b**5*s**6 -
        2*a**12*b**3*c*s**6 + a**11*b**4*c*s**6 + a**10*b**5*c*s**6 +
        a**9*b**6*c*s**6 - a**12*b**2*c**2*s**6 -
        2*a**11*b**3*c**2*s**6 - 2*a**9*b**5*c**2*s**6 +
        a**8*b**6*c**2*s**6 - 3*a**11*b**2*c**3*s**6 -
        3*a**10*b**3*c**3*s**6 - 11*a**9*b**4*c**3*s**6 -
        3*a**8*b**5*c**3*s**6 - 2*a**7*b**6*c**3*s**6 -
        a**11*b*c**4*s**6 - a**10*b**2*c**4*s**6 -
        12*a**9*b**3*c**4*s**6 - 9*a**8*b**4*c**4*s**6 -
        5*a**7*b**5*c**4*s**6 - 2*a**6*b**6*c**4*s**6 -
        4*a**9*b**2*c**5*s**6 - 12*a**8*b**3*c**5*s**6 -
        3*a**7*b**4*c**5*s**6 - 5*a**6*b**5*c**5*s**6 +
        a**5*b**6*c**5*s**6 + a**9*b*c**6*s**6 - 7*a**8*b**2*c**6*s**6
        - a**7*b**3*c**6*s**6 - 7*a**6*b**4*c**6*s**6 -
        a**5*b**5*c**6*s**6 - a**4*b**6*c**6*s**6 - 3*a**8*b*c**7*s**6
        - 8*a**6*b**3*c**7*s**6 - 11*a**5*b**4*c**7*s**6 -
        5*a**4*b**5*c**7*s**6 - 2*a**3*b**6*c**7*s**6 +
        a**7*b*c**8*s**6 + a**6*b**2*c**8*s**6 -
        10*a**5*b**3*c**8*s**6 - 7*a**4*b**4*c**8*s**6 -
        3*a**3*b**5*c**8*s**6 + 3*a**6*b*c**9*s**6 -
        2*a**4*b**3*c**9*s**6 + a**4*b**2*c**10*s**6 +
        a**3*b**3*c**10*s**6)/(a**15*b**4*s**3 - 2*a**14*b**5*s**3 +
        2*a**13*b**6*s**3 - 2*a**12*b**7*s**3 + a**11*b**8*s**3 -
        a**14*b**4*c*s**3 + 3*a**13*b**5*c*s**3 - 4*a**12*b**6*c*s**3
        + 4*a**11*b**7*c*s**3 - 3*a**10*b**8*c*s**3 + a**9*b**9*c*s**3
        - a**15*b**2*c**2*s**3 + 2*a**14*b**3*c**2*s**3 -
        3*a**13*b**4*c**2*s**3 + 3*a**12*b**5*c**2*s**3 -
        a**11*b**6*c**2*s**3 + a**9*b**8*c**2*s**3 -
        a**8*b**9*c**2*s**3 + 2*a**14*b**2*c**3*s**3 -
        5*a**13*b**3*c**3*s**3 + 8*a**12*b**4*c**3*s**3 -
        11*a**11*b**5*c**3*s**3 + 10*a**10*b**6*c**3*s**3 -
        7*a**9*b**7*c**3*s**3 + 4*a**8*b**8*c**3*s**3 -
        a**7*b**9*c**3*s**3 - a**14*b*c**4*s**3 +
        3*a**12*b**3*c**4*s**3 - 5*a**11*b**4*c**4*s**3 +
        9*a**10*b**5*c**4*s**3 - 10*a**9*b**6*c**4*s**3 +
        7*a**8*b**7*c**4*s**3 - 5*a**7*b**8*c**4*s**3 +
        2*a**6*b**9*c**4*s**3 + 3*a**13*b*c**5*s**3 -
        6*a**12*b**2*c**5*s**3 + 6*a**11*b**3*c**5*s**3 -
        8*a**10*b**4*c**5*s**3 + 6*a**9*b**5*c**5*s**3 -
        2*a**8*b**6*c**5*s**3 + 2*a**7*b**7*c**5*s**3 -
        a**5*b**9*c**5*s**3 - 3*a**12*b*c**6*s**3 +
        9*a**11*b**2*c**6*s**3 - 12*a**10*b**3*c**6*s**3 +
        15*a**9*b**4*c**6*s**3 - 16*a**8*b**5*c**6*s**3 +
        11*a**7*b**6*c**6*s**3 - 8*a**6*b**7*c**6*s**3 +
        5*a**5*b**8*c**6*s**3 - a**4*b**9*c**6*s**3 + a**12*c**7*s**3
        - a**11*b*c**7*s**3 - 3*a**10*b**2*c**7*s**3 +
        5*a**9*b**3*c**7*s**3 - 6*a**8*b**4*c**7*s**3 +
        8*a**7*b**5*c**7*s**3 - 5*a**6*b**6*c**7*s**3 +
        3*a**5*b**7*c**7*s**3 - 3*a**4*b**8*c**7*s**3 +
        a**3*b**9*c**7*s**3 - 2*a**11*c**8*s**3 + 6*a**10*b*c**8*s**3
        - 6*a**9*b**2*c**8*s**3 + 6*a**8*b**3*c**8*s**3 -
        7*a**7*b**4*c**8*s**3 + 4*a**6*b**5*c**8*s**3 -
        4*a**5*b**6*c**8*s**3 + 4*a**4*b**7*c**8*s**3 -
        a**3*b**8*c**8*s**3 + a**10*c**9*s**3 - 6*a**9*b*c**9*s**3 +
        9*a**8*b**2*c**9*s**3 - 8*a**7*b**3*c**9*s**3 +
        9*a**6*b**4*c**9*s**3 - 6*a**5*b**5*c**9*s**3 +
        3*a**4*b**6*c**9*s**3 - 4*a**3*b**7*c**9*s**3 +
        2*a**2*b**8*c**9*s**3 + a**9*c**10*s**3 + a**8*b*c**10*s**3 -
        4*a**7*b**2*c**10*s**3 + 2*a**6*b**3*c**10*s**3 -
        2*a**5*b**4*c**10*s**3 + a**4*b**5*c**10*s**3 +
        2*a**3*b**6*c**10*s**3 - a*b**8*c**10*s**3 - 2*a**8*c**11*s**3
        + 3*a**7*b*c**11*s**3 - a**6*b**2*c**11*s**3 +
        2*a**5*b**3*c**11*s**3 - 2*a**4*b**4*c**11*s**3 +
        a**3*b**5*c**11*s**3 - 3*a**2*b**6*c**11*s**3 +
        2*a*b**7*c**11*s**3 + a**7*c**12*s**3 - 3*a**6*b*c**12*s**3 +
        2*a**5*b**2*c**12*s**3 - a**4*b**3*c**12*s**3 +
        a**3*b**4*c**12*s**3 + a**2*b**5*c**12*s**3 - b**7*c**12*s**3
        + a**5*b*c**13*s**3 - a**4*b**2*c**13*s**3 - a*b**5*c**13*s**3
        + b**6*c**13*s**3), (-a**11*b**9*c**2 + a**9*b**11*c**2 -
        2*a**8*b**12*c**2 - 2*a**7*b**13*c**2 - a**12*b**7*c**3 -
        5*a**11*b**8*c**3 - 5*a**10*b**9*c**3 + a**9*b**10*c**3 -
        4*a**8*b**11*c**3 - 15*a**7*b**12*c**3 - 9*a**6*b**13*c**3 +
        a**13*b**5*c**4 - 5*a**12*b**6*c**4 - 17*a**11*b**7*c**4 -
        17*a**10*b**8*c**4 - 10*a**9*b**9*c**4 - 13*a**8*b**10*c**4 -
        29*a**7*b**11*c**4 - 37*a**6*b**12*c**4 - 17*a**5*b**13*c**4 -
        4*a**12*b**5*c**5 - 27*a**11*b**6*c**5 - 43*a**10*b**7*c**5 -
        26*a**9*b**8*c**5 - 21*a**8*b**9*c**5 - 48*a**7*b**10*c**5 -
        58*a**6*b**11*c**5 - 45*a**5*b**12*c**5 - 17*a**4*b**13*c**5 -
        a**13*b**3*c**6 - 3*a**12*b**4*c**6 - 16*a**11*b**5*c**6 -
        41*a**10*b**6*c**6 - 46*a**9*b**7*c**6 - 25*a**8*b**8*c**6 -
        34*a**7*b**9*c**6 - 66*a**6*b**10*c**6 - 60*a**5*b**11*c**6 -
        31*a**4*b**12*c**6 - 9*a**3*b**13*c**6 - a**12*b**3*c**7 -
        6*a**11*b**4*c**7 - 16*a**10*b**5*c**7 - 27*a**9*b**6*c**7 -
        26*a**8*b**7*c**7 - 21*a**7*b**8*c**7 - 29*a**6*b**9*c**7 -
        45*a**5*b**10*c**7 - 35*a**4*b**11*c**7 - 12*a**3*b**12*c**7 -
        2*a**2*b**13*c**7 - 2*a**10*b**4*c**8 - 5*a**9*b**5*c**8 -
        5*a**8*b**6*c**8 - 7*a**7*b**7*c**8 - 9*a**6*b**8*c**8 -
        10*a**5*b**9*c**8 - 13*a**4*b**10*c**8 - 9*a**3*b**11*c**8 -
        2*a**2*b**12*c**8 - a**11*b**8*c*s**2 - a**10*b**9*c*s**2 +
        a**9*b**10*c*s**2 - a**8*b**11*c*s**2 - 4*a**7*b**12*c*s**2 -
        2*a**6*b**13*c*s**2 - 2*a**12*b**6*c**2*s**2 -
        6*a**11*b**7*c**2*s**2 - 8*a**10*b**8*c**2*s**2 -
        6*a**9*b**9*c**2*s**2 - 4*a**8*b**10*c**2*s**2 -
        16*a**7*b**11*c**2*s**2 - 23*a**6*b**12*c**2*s**2 -
        9*a**5*b**13*c**2*s**2 - 3*a**12*b**5*c**3*s**2 -
        16*a**11*b**6*c**3*s**2 - 27*a**10*b**7*c**3*s**2 -
        22*a**9*b**8*c**3*s**2 - 32*a**8*b**9*c**3*s**2 -
        38*a**7*b**10*c**3*s**2 - 50*a**6*b**11*c**3*s**2 -
        53*a**5*b**12*c**3*s**2 - 18*a**4*b**13*c**3*s**2 -
        3*a**12*b**4*c**4*s**2 - 15*a**11*b**5*c**4*s**2 -
        43*a**10*b**6*c**4*s**2 - 50*a**9*b**7*c**4*s**2 -
        46*a**8*b**8*c**4*s**2 - 75*a**7*b**9*c**4*s**2 -
        77*a**6*b**10*c**4*s**2 - 71*a**5*b**11*c**4*s**2 -
        62*a**4*b**12*c**4*s**2 - 20*a**3*b**13*c**4*s**2 -
        4*a**12*b**3*c**5*s**2 - 16*a**11*b**4*c**5*s**2 -
        38*a**10*b**5*c**5*s**2 - 62*a**9*b**6*c**5*s**2 -
        69*a**8*b**7*c**5*s**2 - 66*a**7*b**8*c**5*s**2 -
        88*a**6*b**9*c**5*s**2 - 84*a**5*b**10*c**5*s**2 -
        62*a**4*b**11*c**5*s**2 - 43*a**3*b**12*c**5*s**2 -
        11*a**2*b**13*c**5*s**2 - 2*a**12*b**2*c**6*s**2 -
        12*a**11*b**3*c**6*s**2 - 32*a**10*b**4*c**6*s**2 -
        46*a**9*b**5*c**6*s**2 - 61*a**8*b**6*c**6*s**2 -
        72*a**7*b**7*c**6*s**2 - 63*a**6*b**8*c**6*s**2 -
        71*a**5*b**9*c**6*s**2 - 71*a**4*b**10*c**6*s**2 -
        43*a**3*b**11*c**6*s**2 - 17*a**2*b**12*c**6*s**2 -
        2*a*b**13*c**6*s**2 - a**11*b**2*c**7*s**2 -
        9*a**10*b**3*c**7*s**2 - 21*a**9*b**4*c**7*s**2 -
        24*a**8*b**5*c**7*s**2 - 32*a**7*b**6*c**7*s**2 -
        42*a**6*b**7*c**7*s**2 - 38*a**5*b**8*c**7*s**2 -
        45*a**4*b**9*c**7*s**2 - 43*a**3*b**10*c**7*s**2 -
        19*a**2*b**11*c**7*s**2 - 4*a*b**12*c**7*s**2 -
        2*a**9*b**3*c**8*s**2 - 5*a**8*b**4*c**8*s**2 -
        5*a**7*b**5*c**8*s**2 - 7*a**6*b**6*c**8*s**2 -
        9*a**5*b**7*c**8*s**2 - 10*a**4*b**8*c**8*s**2 -
        13*a**3*b**9*c**8*s**2 - 9*a**2*b**10*c**8*s**2 -
        2*a*b**11*c**8*s**2 + 6*a**10*b**7*c*s**4 + 3*a**9*b**8*c*s**4
        - 5*a**8*b**9*c*s**4 + 4*a**7*b**10*c*s**4 +
        10*a**6*b**11*c*s**4 + 5*a**5*b**12*c*s**4 +
        15*a**11*b**5*c**2*s**4 + 41*a**10*b**6*c**2*s**4 +
        50*a**9*b**7*c**2*s**4 + 4*a**8*b**8*c**2*s**4 -
        4*a**7*b**9*c**2*s**4 + 60*a**6*b**10*c**2*s**4 +
        61*a**5*b**11*c**2*s**4 + 16*a**4*b**12*c**2*s**4 -
        a**3*b**13*c**2*s**4 + 32*a**11*b**4*c**3*s**4 +
        133*a**10*b**5*c**3*s**4 + 188*a**9*b**6*c**3*s**4 +
        116*a**8*b**7*c**3*s**4 + 23*a**7*b**8*c**3*s**4 +
        100*a**6*b**9*c**3*s**4 + 214*a**5*b**10*c**3*s**4 +
        134*a**4*b**11*c**3*s**4 + 22*a**3*b**12*c**3*s**4 -
        3*a**2*b**13*c**3*s**4 + 15*a**11*b**3*c**4*s**4 +
        135*a**10*b**4*c**4*s**4 + 318*a**9*b**5*c**4*s**4 +
        286*a**8*b**6*c**4*s**4 + 114*a**7*b**7*c**4*s**4 +
        122*a**6*b**8*c**4*s**4 + 293*a**5*b**9*c**4*s**4 +
        324*a**4*b**10*c**4*s**4 + 144*a**3*b**11*c**4*s**4 +
        15*a**2*b**12*c**4*s**4 - 2*a*b**13*c**4*s**4 -
        2*a**11*b**2*c**5*s**4 + 32*a**10*b**3*c**5*s**4 +
        185*a**9*b**4*c**5*s**4 + 302*a**8*b**5*c**5*s**4 +
        161*a**7*b**6*c**5*s**4 + 67*a**6*b**7*c**5*s**4 +
        208*a**5*b**8*c**5*s**4 + 319*a**4*b**9*c**5*s**4 +
        236*a**3*b**10*c**5*s**4 + 75*a**2*b**11*c**5*s**4 +
        6*a*b**12*c**5*s**4 - a**10*b**2*c**6*s**4 +
        26*a**9*b**3*c**6*s**4 + 109*a**8*b**4*c**6*s**4 +
        118*a**7*b**5*c**6*s**4 + 25*a**6*b**6*c**6*s**4 +
        39*a**5*b**7*c**6*s**4 + 137*a**4*b**8*c**6*s**4 +
        145*a**3*b**9*c**6*s**4 + 71*a**2*b**10*c**6*s**4 +
        13*a*b**11*c**6*s**4 + 8*a**8*b**3*c**7*s**4 +
        22*a**7*b**4*c**7*s**4 + 14*a**6*b**5*c**7*s**4 -
        a**5*b**6*c**7*s**4 + 14*a**4*b**7*c**7*s**4 +
        32*a**3*b**8*c**7*s**4 + 22*a**2*b**9*c**7*s**4 +
        6*a*b**10*c**7*s**4 + 3*a**9*b**6*c*s**6 + a**8*b**7*c*s**6 -
        3*a**7*b**8*c*s**6 + a**6*b**9*c*s**6 - a**4*b**11*c*s**6 +
        a**10*b**4*c**2*s**6 + a**8*b**6*c**2*s**6 -
        7*a**6*b**8*c**2*s**6 - 4*a**5*b**9*c**2*s**6 -
        a**4*b**10*c**2*s**6 - 3*a**3*b**11*c**2*s**6 -
        a**2*b**12*c**2*s**6 + a**10*b**3*c**3*s**6 -
        2*a**9*b**4*c**3*s**6 - 10*a**8*b**5*c**3*s**6 -
        8*a**7*b**6*c**3*s**6 - a**6*b**7*c**3*s**6 -
        12*a**5*b**8*c**3*s**6 - 12*a**4*b**9*c**3*s**6 -
        3*a**3*b**10*c**3*s**6 - 2*a**2*b**11*c**3*s**6 -
        2*a*b**12*c**3*s**6 - 7*a**8*b**4*c**4*s**6 -
        11*a**7*b**5*c**4*s**6 - 7*a**6*b**6*c**4*s**6 -
        3*a**5*b**7*c**4*s**6 - 9*a**4*b**8*c**4*s**6 -
        11*a**3*b**9*c**4*s**6 + a*b**11*c**4*s**6 - b**12*c**4*s**6 -
        3*a**8*b**3*c**5*s**6 - 5*a**7*b**4*c**5*s**6 -
        a**6*b**5*c**5*s**6 - 5*a**5*b**6*c**5*s**6 -
        5*a**4*b**7*c**5*s**6 - 3*a**3*b**8*c**5*s**6 -
        2*a**2*b**9*c**5*s**6 + a*b**10*c**5*s**6 + b**11*c**5*s**6 -
        2*a**7*b**3*c**6*s**6 - a**6*b**4*c**6*s**6 +
        a**5*b**5*c**6*s**6 - 2*a**4*b**6*c**6*s**6 -
        2*a**3*b**7*c**6*s**6 + a**2*b**8*c**6*s**6 +
        a*b**9*c**6*s**6)/(a**12*b**7*s**3 - 2*a**11*b**8*s**3 +
        a**10*b**9*s**3 + a**9*b**10*s**3 - 2*a**8*b**11*s**3 +
        a**7*b**12*s**3 + a**13*b**5*c*s**3 - 3*a**12*b**6*c*s**3 +
        3*a**11*b**7*c*s**3 + a**10*b**8*c*s**3 - 6*a**9*b**9*c*s**3 +
        6*a**8*b**10*c*s**3 - a**7*b**11*c*s**3 - 3*a**6*b**12*c*s**3
        + 3*a**5*b**13*c*s**3 - a**4*b**14*c*s**3 -
        a**13*b**4*c**2*s**3 + 2*a**12*b**5*c**2*s**3 -
        a**11*b**6*c**2*s**3 - 4*a**10*b**7*c**2*s**3 +
        9*a**9*b**8*c**2*s**3 - 6*a**8*b**9*c**2*s**3 -
        3*a**7*b**10*c**2*s**3 + 9*a**6*b**11*c**2*s**3 -
        6*a**5*b**12*c**2*s**3 + 2*a**3*b**14*c**2*s**3 -
        a**2*b**15*c**2*s**3 - a**12*b**4*c**3*s**3 +
        2*a**11*b**5*c**3*s**3 + 2*a**10*b**6*c**3*s**3 -
        8*a**9*b**7*c**3*s**3 + 6*a**8*b**8*c**3*s**3 +
        5*a**7*b**9*c**3*s**3 - 12*a**6*b**10*c**3*s**3 +
        6*a**5*b**11*c**3*s**3 + 3*a**4*b**12*c**3*s**3 -
        5*a**3*b**13*c**3*s**3 + 2*a**2*b**14*c**3*s**3 +
        a**12*b**3*c**4*s**3 - 2*a**11*b**4*c**4*s**3 -
        2*a**10*b**5*c**4*s**3 + 9*a**9*b**6*c**4*s**3 -
        7*a**8*b**7*c**4*s**3 - 6*a**7*b**8*c**4*s**3 +
        15*a**6*b**9*c**4*s**3 - 8*a**5*b**10*c**4*s**3 -
        5*a**4*b**11*c**4*s**3 + 8*a**3*b**12*c**4*s**3 -
        3*a**2*b**13*c**4*s**3 - a*b**14*c**4*s**3 + b**15*c**4*s**3 -
        a**13*b*c**5*s**3 + a**12*b**2*c**5*s**3 +
        a**11*b**3*c**5*s**3 + a**10*b**4*c**5*s**3 -
        6*a**9*b**5*c**5*s**3 + 4*a**8*b**6*c**5*s**3 +
        8*a**7*b**7*c**5*s**3 - 16*a**6*b**8*c**5*s**3 +
        6*a**5*b**9*c**5*s**3 + 9*a**4*b**10*c**5*s**3 -
        11*a**3*b**11*c**5*s**3 + 3*a**2*b**12*c**5*s**3 +
        3*a*b**13*c**5*s**3 - 2*b**14*c**5*s**3 + a**13*c**6*s**3 -
        3*a**11*b**2*c**6*s**3 + 2*a**10*b**3*c**6*s**3 +
        3*a**9*b**4*c**6*s**3 - 4*a**8*b**5*c**6*s**3 -
        5*a**7*b**6*c**6*s**3 + 11*a**6*b**7*c**6*s**3 -
        2*a**5*b**8*c**6*s**3 - 10*a**4*b**9*c**6*s**3 +
        10*a**3*b**10*c**6*s**3 - a**2*b**11*c**6*s**3 -
        4*a*b**12*c**6*s**3 + 2*b**13*c**6*s**3 - a**12*c**7*s**3 +
        2*a**11*b*c**7*s**3 - 4*a**9*b**3*c**7*s**3 +
        4*a**8*b**4*c**7*s**3 + 3*a**7*b**5*c**7*s**3 -
        8*a**6*b**6*c**7*s**3 + 2*a**5*b**7*c**7*s**3 +
        7*a**4*b**8*c**7*s**3 - 7*a**3*b**9*c**7*s**3 +
        4*a*b**11*c**7*s**3 - 2*b**12*c**7*s**3 - a**10*b*c**8*s**3 +
        2*a**9*b**2*c**8*s**3 - a**8*b**3*c**8*s**3 -
        3*a**7*b**4*c**8*s**3 + 5*a**6*b**5*c**8*s**3 -
        5*a**4*b**7*c**8*s**3 + 4*a**3*b**8*c**8*s**3 +
        a**2*b**9*c**8*s**3 - 3*a*b**10*c**8*s**3 + b**11*c**8*s**3 +
        a**7*b**3*c**9*s**3 - a**6*b**4*c**9*s**3 -
        a**5*b**5*c**9*s**3 + 2*a**4*b**6*c**9*s**3 -
        a**3*b**7*c**9*s**3 - a**2*b**8*c**9*s**3 + a*b**9*c**9*s**3),
        (3*a**8*b**8*c**3 + 4*a**7*b**9*c**3 + a**6*b**10*c**3 +
        10*a**8*b**7*c**4 + 22*a**7*b**8*c**4 + 16*a**6*b**9*c**4 +
        4*a**5*b**10*c**4 + 13*a**8*b**6*c**5 + 45*a**7*b**7*c**5 +
        51*a**6*b**8*c**5 + 28*a**5*b**9*c**5 + 5*a**4*b**10*c**5 +
        13*a**8*b**5*c**6 + 49*a**7*b**6*c**6 + 76*a**6*b**7*c**6 +
        59*a**5*b**8*c**6 + 21*a**4*b**9*c**6 + 2*a**3*b**10*c**6 +
        13*a**8*b**4*c**7 + 47*a**7*b**5*c**7 + 76*a**6*b**6*c**7 +
        71*a**5*b**7*c**7 + 35*a**4*b**8*c**7 + 7*a**3*b**9*c**7 +
        8*a**8*b**3*c**8 + 36*a**7*b**4*c**8 + 65*a**6*b**5*c**8 +
        64*a**5*b**6*c**8 + 37*a**4*b**7*c**8 + 11*a**3*b**8*c**8 +
        a**2*b**9*c**8 + 2*a**8*b**2*c**9 + 15*a**7*b**3*c**9 +
        38*a**6*b**4*c**9 + 47*a**5*b**5*c**9 + 32*a**4*b**6*c**9 +
        12*a**3*b**7*c**9 + 2*a**2*b**8*c**9 + 2*a**7*b**2*c**10 +
        9*a**6*b**3*c**10 + 16*a**5*b**4*c**10 + 14*a**4*b**5*c**10 +
        6*a**3*b**6*c**10 + a**2*b**7*c**10 + 3*a**8*b**7*c**2*s**2 +
        8*a**7*b**8*c**2*s**2 + 6*a**6*b**9*c**2*s**2 +
        a**5*b**10*c**2*s**2 + 10*a**8*b**6*c**3*s**2 +
        34*a**7*b**7*c**3*s**2 + 40*a**6*b**8*c**3*s**2 +
        17*a**5*b**9*c**3*s**2 + 4*a**4*b**10*c**3*s**2 +
        13*a**8*b**5*c**4*s**2 + 53*a**7*b**6*c**4*s**2 +
        84*a**6*b**7*c**4*s**2 + 67*a**5*b**8*c**4*s**2 +
        28*a**4*b**9*c**4*s**2 + 5*a**3*b**10*c**4*s**2 +
        13*a**8*b**4*c**5*s**2 + 52*a**7*b**5*c**5*s**2 +
        93*a**6*b**6*c**5*s**2 + 106*a**5*b**7*c**5*s**2 +
        78*a**4*b**8*c**5*s**2 + 26*a**3*b**9*c**5*s**2 +
        2*a**2*b**10*c**5*s**2 + 13*a**8*b**3*c**6*s**2 +
        56*a**7*b**4*c**6*s**2 + 91*a**6*b**5*c**6*s**2 +
        103*a**5*b**6*c**6*s**2 + 99*a**4*b**7*c**6*s**2 +
        54*a**3*b**8*c**6*s**2 + 10*a**2*b**9*c**6*s**2 +
        8*a**8*b**2*c**7*s**2 + 49*a**7*b**3*c**7*s**2 +
        91*a**6*b**4*c**7*s**2 + 96*a**5*b**5*c**7*s**2 +
        84*a**4*b**6*c**7*s**2 + 56*a**3*b**7*c**7*s**2 +
        17*a**2*b**8*c**7*s**2 + a*b**9*c**7*s**2 + 2*a**8*b*c**8*s**2
        + 22*a**7*b**2*c**8*s**2 + 63*a**6*b**3*c**8*s**2 +
        92*a**5*b**4*c**8*s**2 + 88*a**4*b**5*c**8*s**2 +
        57*a**3*b**6*c**8*s**2 + 21*a**2*b**7*c**8*s**2 +
        3*a*b**8*c**8*s**2 + 4*a**7*b*c**9*s**2 +
        22*a**6*b**2*c**9*s**2 + 52*a**5*b**3*c**9*s**2 +
        65*a**4*b**4*c**9*s**2 + 47*a**3*b**5*c**9*s**2 +
        18*a**2*b**6*c**9*s**2 + 3*a*b**7*c**9*s**2 +
        2*a**6*b*c**10*s**2 + 9*a**5*b**2*c**10*s**2 +
        16*a**4*b**3*c**10*s**2 + 14*a**3*b**4*c**10*s**2 +
        6*a**2*b**5*c**10*s**2 + a*b**6*c**10*s**2 -
        8*a**7*b**6*c**2*s**4 - 22*a**6*b**7*c**2*s**4 -
        23*a**5*b**8*c**2*s**4 - 9*a**4*b**9*c**2*s**4 -
        28*a**7*b**5*c**3*s**4 - 111*a**6*b**6*c**3*s**4 -
        155*a**5*b**7*c**3*s**4 - 93*a**4*b**8*c**3*s**4 -
        17*a**3*b**9*c**3*s**4 - 36*a**7*b**4*c**4*s**4 -
        194*a**6*b**5*c**4*s**4 - 368*a**5*b**6*c**4*s**4 -
        298*a**4*b**7*c**4*s**4 - 96*a**3*b**8*c**4*s**4 -
        8*a**2*b**9*c**4*s**4 - 26*a**7*b**3*c**5*s**4 -
        177*a**6*b**4*c**5*s**4 - 436*a**5*b**5*c**5*s**4 -
        466*a**4*b**6*c**5*s**4 - 212*a**3*b**7*c**5*s**4 -
        31*a**2*b**8*c**5*s**4 - 14*a**7*b**2*c**6*s**4 -
        116*a**6*b**3*c**6*s**4 - 345*a**5*b**4*c**6*s**4 -
        458*a**4*b**5*c**6*s**4 - 282*a**3*b**6*c**6*s**4 -
        71*a**2*b**7*c**6*s**4 - 4*a*b**8*c**6*s**4 -
        5*a**7*b*c**7*s**4 - 53*a**6*b**2*c**7*s**4 -
        197*a**5*b**3*c**7*s**4 - 305*a**4*b**4*c**7*s**4 -
        229*a**3*b**5*c**7*s**4 - 80*a**2*b**6*c**7*s**4 -
        10*a*b**7*c**7*s**4 - 9*a**6*b*c**8*s**4 -
        59*a**5*b**2*c**8*s**4 - 117*a**4*b**3*c**8*s**4 -
        102*a**3*b**4*c**8*s**4 - 42*a**2*b**5*c**8*s**4 -
        7*a*b**6*c**8*s**4 - 6*a**5*b*c**9*s**4 -
        18*a**4*b**2*c**9*s**4 - 21*a**3*b**3*c**9*s**4 -
        10*a**2*b**4*c**9*s**4 - 2*a*b**5*c**9*s**4 +
        a**6*b**5*c**2*s**6 + 3*a**5*b**6*c**2*s**6 +
        4*a**4*b**7*c**2*s**6 + 2*a**3*b**8*c**2*s**6 +
        5*a**5*b**5*c**3*s**6 + 12*a**4*b**6*c**3*s**6 +
        9*a**3*b**7*c**3*s**6 + 2*a**2*b**8*c**3*s**6 +
        a**5*b**4*c**4*s**6 + 9*a**4*b**5*c**4*s**6 +
        10*a**3*b**6*c**4*s**6 + 2*a**2*b**7*c**4*s**6 +
        2*a**6*b**2*c**5*s**6 + 6*a**5*b**3*c**5*s**6 +
        7*a**4*b**4*c**5*s**6 + 8*a**3*b**5*c**5*s**6 -
        a**2*b**6*c**5*s**6 - a*b**7*c**5*s**6 + a**6*b*c**6*s**6 +
        6*a**5*b**2*c**6*s**6 + 11*a**4*b**3*c**6*s**6 +
        10*a**3*b**4*c**6*s**6 + 2*a**2*b**5*c**6*s**6 -
        2*a*b**6*c**6*s**6 + a**5*b*c**7*s**6 + 5*a**4*b**2*c**7*s**6
        + 10*a**3*b**3*c**7*s**6 + 6*a**2*b**4*c**7*s**6 +
        a*b**5*c**7*s**6 + 2*a**3*b**2*c**8*s**6 +
        3*a**2*b**3*c**8*s**6 + a*b**4*c**8*s**6)/(a**9*b**7*s**3 -
        a**8*b**8*s**3 - a**7*b**9*s**3 + a**6*b**10*s**3 -
        a**9*b**6*c*s**3 + a**8*b**7*c*s**3 + 2*a**7*b**8*c*s**3 -
        2*a**6*b**9*c*s**3 - a**5*b**10*c*s**3 + a**4*b**11*c*s**3 -
        a**9*b**5*c**2*s**3 + 2*a**6*b**8*c**2*s**3 +
        a**5*b**9*c**2*s**3 - 2*a**4*b**10*c**2*s**3 +
        2*a**9*b**4*c**3*s**3 - 4*a**7*b**6*c**3*s**3 -
        a**6*b**7*c**3*s**3 + 2*a**5*b**8*c**3*s**3 +
        2*a**4*b**9*c**3*s**3 - a**2*b**11*c**3*s**3 -
        a**9*b**3*c**4*s**3 + 4*a**7*b**5*c**4*s**3 -
        4*a**5*b**7*c**4*s**3 - a**4*b**8*c**4*s**3 +
        a**3*b**9*c**4*s**3 + a**2*b**10*c**4*s**3 -
        a**9*b**2*c**5*s**3 + a**7*b**4*c**5*s**3 +
        a**6*b**5*c**5*s**3 + a**5*b**6*c**5*s**3 -
        2*a**4*b**7*c**5*s**3 - a**3*b**8*c**5*s**3 +
        a**2*b**9*c**5*s**3 + a**9*b*c**6*s**3 + a**8*b**2*c**6*s**3 -
        4*a**7*b**3*c**6*s**3 - 3*a**6*b**4*c**6*s**3 +
        4*a**5*b**5*c**6*s**3 + 5*a**4*b**6*c**6*s**3 -
        a**3*b**7*c**6*s**3 - 4*a**2*b**8*c**6*s**3 + b**10*c**6*s**3
        - a**8*b*c**7*s**3 + 2*a**7*b**2*c**7*s**3 +
        3*a**6*b**3*c**7*s**3 - 4*a**5*b**4*c**7*s**3 -
        5*a**4*b**5*c**7*s**3 + 2*a**3*b**6*c**7*s**3 +
        5*a**2*b**7*c**7*s**3 - 2*b**9*c**7*s**3 + a**7*b*c**8*s**3 -
        a**6*b**2*c**8*s**3 + a**4*b**4*c**8*s**3 -
        a**3*b**5*c**8*s**3 - a**2*b**6*c**8*s**3 + b**8*c**8*s**3 -
        a**7*c**9*s**3 - a**6*b*c**9*s**3 + 2*a**5*b**2*c**9*s**3 +
        3*a**4*b**3*c**9*s**3 - a**3*b**4*c**9*s**3 -
        3*a**2*b**5*c**9*s**3 + b**7*c**9*s**3 + a**6*c**10*s**3 -
        a**5*b*c**10*s**3 - 3*a**4*b**2*c**10*s**3 +
        a**3*b**3*c**10*s**3 + 4*a**2*b**4*c**10*s**3 -
        2*b**6*c**10*s**3 + a**4*b*c**11*s**3 - 2*a**2*b**3*c**11*s**3
        + b**5*c**11*s**3), (a**9*b**8*c**2 + 2*a**8*b**9*c**2 +
        a**7*b**10*c**2 + 2*a**10*b**6*c**3 + 7*a**9*b**7*c**3 +
        11*a**8*b**8*c**3 + 12*a**7*b**9*c**3 + 6*a**6*b**10*c**3 +
        5*a**10*b**5*c**4 + 21*a**9*b**6*c**4 + 35*a**8*b**7*c**4 +
        37*a**7*b**8*c**4 + 32*a**6*b**9*c**4 + 14*a**5*b**10*c**4 +
        4*a**10*b**4*c**5 + 28*a**9*b**5*c**5 + 59*a**8*b**6*c**5 +
        71*a**7*b**7*c**5 + 64*a**6*b**8*c**5 + 47*a**5*b**9*c**5 +
        16*a**4*b**10*c**5 + a**10*b**3*c**6 + 16*a**9*b**4*c**6 +
        51*a**8*b**5*c**6 + 76*a**7*b**6*c**6 + 76*a**6*b**7*c**6 +
        65*a**5*b**8*c**6 + 38*a**4*b**9*c**6 + 9*a**3*b**10*c**6 +
        4*a**9*b**3*c**7 + 22*a**8*b**4*c**7 + 45*a**7*b**5*c**7 +
        49*a**6*b**6*c**7 + 47*a**5*b**7*c**7 + 36*a**4*b**8*c**7 +
        15*a**3*b**9*c**7 + 2*a**2*b**10*c**7 + 3*a**8*b**3*c**8 +
        10*a**7*b**4*c**8 + 13*a**6*b**5*c**8 + 13*a**5*b**6*c**8 +
        13*a**4*b**7*c**8 + 8*a**3*b**8*c**8 + 2*a**2*b**9*c**8 +
        a**9*b**7*c*s**2 + 3*a**8*b**8*c*s**2 + 3*a**7*b**9*c*s**2 +
        a**6*b**10*c*s**2 + 2*a**10*b**5*c**2*s**2 +
        10*a**9*b**6*c**2*s**2 + 17*a**8*b**7*c**2*s**2 +
        21*a**7*b**8*c**2*s**2 + 18*a**6*b**9*c**2*s**2 +
        6*a**5*b**10*c**2*s**2 + 5*a**10*b**4*c**3*s**2 +
        26*a**9*b**5*c**3*s**2 + 54*a**8*b**6*c**3*s**2 +
        56*a**7*b**7*c**3*s**2 + 57*a**6*b**8*c**3*s**2 +
        47*a**5*b**9*c**3*s**2 + 14*a**4*b**10*c**3*s**2 +
        4*a**10*b**3*c**4*s**2 + 28*a**9*b**4*c**4*s**2 +
        78*a**8*b**5*c**4*s**2 + 99*a**7*b**6*c**4*s**2 +
        84*a**6*b**7*c**4*s**2 + 88*a**5*b**8*c**4*s**2 +
        65*a**4*b**9*c**4*s**2 + 16*a**3*b**10*c**4*s**2 +
        a**10*b**2*c**5*s**2 + 17*a**9*b**3*c**5*s**2 +
        67*a**8*b**4*c**5*s**2 + 106*a**7*b**5*c**5*s**2 +
        103*a**6*b**6*c**5*s**2 + 96*a**5*b**7*c**5*s**2 +
        92*a**4*b**8*c**5*s**2 + 52*a**3*b**9*c**5*s**2 +
        9*a**2*b**10*c**5*s**2 + 6*a**9*b**2*c**6*s**2 +
        40*a**8*b**3*c**6*s**2 + 84*a**7*b**4*c**6*s**2 +
        93*a**6*b**5*c**6*s**2 + 91*a**5*b**6*c**6*s**2 +
        91*a**4*b**7*c**6*s**2 + 63*a**3*b**8*c**6*s**2 +
        22*a**2*b**9*c**6*s**2 + 2*a*b**10*c**6*s**2 +
        8*a**8*b**2*c**7*s**2 + 34*a**7*b**3*c**7*s**2 +
        53*a**6*b**4*c**7*s**2 + 52*a**5*b**5*c**7*s**2 +
        56*a**4*b**6*c**7*s**2 + 49*a**3*b**7*c**7*s**2 +
        22*a**2*b**8*c**7*s**2 + 4*a*b**9*c**7*s**2 +
        3*a**7*b**2*c**8*s**2 + 10*a**6*b**3*c**8*s**2 +
        13*a**5*b**4*c**8*s**2 + 13*a**4*b**5*c**8*s**2 +
        13*a**3*b**6*c**8*s**2 + 8*a**2*b**7*c**8*s**2 +
        2*a*b**8*c**8*s**2 - 4*a**8*b**6*c*s**4 - 10*a**7*b**7*c*s**4
        - 7*a**6*b**8*c*s**4 - 2*a**5*b**9*c*s**4 -
        8*a**9*b**4*c**2*s**4 - 31*a**8*b**5*c**2*s**4 -
        71*a**7*b**6*c**2*s**4 - 80*a**6*b**7*c**2*s**4 -
        42*a**5*b**8*c**2*s**4 - 10*a**4*b**9*c**2*s**4 -
        17*a**9*b**3*c**3*s**4 - 96*a**8*b**4*c**3*s**4 -
        212*a**7*b**5*c**3*s**4 - 282*a**6*b**6*c**3*s**4 -
        229*a**5*b**7*c**3*s**4 - 102*a**4*b**8*c**3*s**4 -
        21*a**3*b**9*c**3*s**4 - 9*a**9*b**2*c**4*s**4 -
        93*a**8*b**3*c**4*s**4 - 298*a**7*b**4*c**4*s**4 -
        466*a**6*b**5*c**4*s**4 - 458*a**5*b**6*c**4*s**4 -
        305*a**4*b**7*c**4*s**4 - 117*a**3*b**8*c**4*s**4 -
        18*a**2*b**9*c**4*s**4 - 23*a**8*b**2*c**5*s**4 -
        155*a**7*b**3*c**5*s**4 - 368*a**6*b**4*c**5*s**4 -
        436*a**5*b**5*c**5*s**4 - 345*a**4*b**6*c**5*s**4 -
        197*a**3*b**7*c**5*s**4 - 59*a**2*b**8*c**5*s**4 -
        6*a*b**9*c**5*s**4 - 22*a**7*b**2*c**6*s**4 -
        111*a**6*b**3*c**6*s**4 - 194*a**5*b**4*c**6*s**4 -
        177*a**4*b**5*c**6*s**4 - 116*a**3*b**6*c**6*s**4 -
        53*a**2*b**7*c**6*s**4 - 9*a*b**8*c**6*s**4 -
        8*a**6*b**2*c**7*s**4 - 28*a**5*b**3*c**7*s**4 -
        36*a**4*b**4*c**7*s**4 - 26*a**3*b**5*c**7*s**4 -
        14*a**2*b**6*c**7*s**4 - 5*a*b**7*c**7*s**4 - a**7*b**5*c*s**6
        - 2*a**6*b**6*c*s**6 + a**5*b**7*c*s**6 + a**4*b**8*c*s**6 +
        2*a**8*b**3*c**2*s**6 + 2*a**7*b**4*c**2*s**6 -
        a**6*b**5*c**2*s**6 + 2*a**5*b**6*c**2*s**6 +
        6*a**4*b**7*c**2*s**6 + 3*a**3*b**8*c**2*s**6 +
        2*a**8*b**2*c**3*s**6 + 9*a**7*b**3*c**3*s**6 +
        10*a**6*b**4*c**3*s**6 + 8*a**5*b**5*c**3*s**6 +
        10*a**4*b**6*c**3*s**6 + 10*a**3*b**7*c**3*s**6 +
        2*a**2*b**8*c**3*s**6 + 4*a**7*b**2*c**4*s**6 +
        12*a**6*b**3*c**4*s**6 + 9*a**5*b**4*c**4*s**6 +
        7*a**4*b**5*c**4*s**6 + 11*a**3*b**6*c**4*s**6 +
        5*a**2*b**7*c**4*s**6 + 3*a**6*b**2*c**5*s**6 +
        5*a**5*b**3*c**5*s**6 + a**4*b**4*c**5*s**6 +
        6*a**3*b**5*c**5*s**6 + 6*a**2*b**6*c**5*s**6 +
        a*b**7*c**5*s**6 + a**5*b**2*c**6*s**6 + 2*a**2*b**5*c**6*s**6
        + a*b**6*c**6*s**6)/(a**10*b**6*s**3 - 2*a**9*b**7*s**3 +
        a**8*b**8*s**3 + a**7*b**9*s**3 - 2*a**6*b**10*s**3 +
        a**5*b**11*s**3 - a**11*b**3*c**2*s**3 + a**10*b**4*c**2*s**3
        + a**9*b**5*c**2*s**3 - 4*a**8*b**6*c**2*s**3 +
        5*a**7*b**7*c**2*s**3 - a**6*b**8*c**2*s**3 -
        3*a**5*b**9*c**2*s**3 + 4*a**4*b**10*c**2*s**3 -
        2*a**3*b**11*c**2*s**3 + a**9*b**4*c**3*s**3 -
        a**8*b**5*c**3*s**3 - a**7*b**6*c**3*s**3 +
        2*a**6*b**7*c**3*s**3 - a**5*b**8*c**3*s**3 -
        a**4*b**9*c**3*s**3 + a**3*b**10*c**3*s**3 + a**11*b*c**4*s**3
        - 2*a**10*b**2*c**4*s**3 + 2*a**9*b**3*c**4*s**3 -
        a**8*b**4*c**4*s**3 - 2*a**7*b**5*c**4*s**3 +
        5*a**6*b**6*c**4*s**3 - 5*a**5*b**7*c**4*s**3 +
        a**4*b**8*c**4*s**3 + 3*a**3*b**9*c**4*s**3 -
        3*a**2*b**10*c**4*s**3 + a*b**11*c**4*s**3 - a**10*b*c**5*s**3
        + a**9*b**2*c**5*s**3 + 2*a**8*b**3*c**5*s**3 -
        4*a**7*b**4*c**5*s**3 + a**6*b**5*c**5*s**3 +
        4*a**5*b**6*c**5*s**3 - 4*a**4*b**7*c**5*s**3 +
        2*a**2*b**9*c**5*s**3 - a*b**10*c**5*s**3 + a**10*c**6*s**3 -
        2*a**9*b*c**6*s**3 + 2*a**8*b**2*c**6*s**3 -
        a**7*b**3*c**6*s**3 + a**5*b**5*c**6*s**3 -
        3*a**4*b**6*c**6*s**3 + 3*a**3*b**7*c**6*s**3 -
        a**2*b**8*c**6*s**3 - a*b**9*c**6*s**3 + b**10*c**6*s**3 -
        a**9*c**7*s**3 + 2*a**8*b*c**7*s**3 - 4*a**6*b**3*c**7*s**3 +
        4*a**5*b**4*c**7*s**3 + a**4*b**5*c**7*s**3 -
        4*a**3*b**6*c**7*s**3 + 2*a**2*b**7*c**7*s**3 +
        a*b**8*c**7*s**3 - b**9*c**7*s**3 - a**8*c**8*s**3 +
        a**7*b*c**8*s**3 + a**2*b**6*c**8*s**3 - a*b**7*c**8*s**3 +
        a**7*c**9*s**3 - a**6*b*c**9*s**3 - a**5*b**2*c**9*s**3 +
        2*a**4*b**3*c**9*s**3 - a**3*b**4*c**9*s**3 -
        a**2*b**5*c**9*s**3 + a*b**6*c**9*s**3), (2*a**10*b**7*c**2 +
        2*a**9*b**8*c**2 + 9*a**10*b**6*c**3 + 15*a**9*b**7*c**3 +
        8*a**8*b**8*c**3 + 16*a**10*b**5*c**4 + 38*a**9*b**6*c**4 +
        36*a**8*b**7*c**4 + 13*a**7*b**8*c**4 + 14*a**10*b**4*c**5 +
        47*a**9*b**5*c**5 + 65*a**8*b**6*c**5 + 47*a**7*b**7*c**5 +
        13*a**6*b**8*c**5 + 6*a**10*b**3*c**6 + 32*a**9*b**4*c**6 +
        64*a**8*b**5*c**6 + 76*a**7*b**6*c**6 + 49*a**6*b**7*c**6 +
        13*a**5*b**8*c**6 + a**10*b**2*c**7 + 12*a**9*b**3*c**7 +
        37*a**8*b**4*c**7 + 71*a**7*b**5*c**7 + 76*a**6*b**6*c**7 +
        45*a**5*b**7*c**7 + 10*a**4*b**8*c**7 + 2*a**9*b**2*c**8 +
        11*a**8*b**3*c**8 + 35*a**7*b**4*c**8 + 59*a**6*b**5*c**8 +
        51*a**5*b**6*c**8 + 22*a**4*b**7*c**8 + 3*a**3*b**8*c**8 +
        a**8*b**2*c**9 + 7*a**7*b**3*c**9 + 21*a**6*b**4*c**9 +
        28*a**5*b**5*c**9 + 16*a**4*b**6*c**9 + 4*a**3*b**7*c**9 +
        2*a**6*b**3*c**10 + 5*a**5*b**4*c**10 + 4*a**4*b**5*c**10 +
        a**3*b**6*c**10 + 2*a**10*b**6*c*s**2 + 4*a**9*b**7*c*s**2 +
        2*a**8*b**8*c*s**2 + 9*a**10*b**5*c**2*s**2 +
        22*a**9*b**6*c**2*s**2 + 22*a**8*b**7*c**2*s**2 +
        8*a**7*b**8*c**2*s**2 + 16*a**10*b**4*c**3*s**2 +
        52*a**9*b**5*c**3*s**2 + 63*a**8*b**6*c**3*s**2 +
        49*a**7*b**7*c**3*s**2 + 13*a**6*b**8*c**3*s**2 +
        14*a**10*b**3*c**4*s**2 + 65*a**9*b**4*c**4*s**2 +
        92*a**8*b**5*c**4*s**2 + 91*a**7*b**6*c**4*s**2 +
        56*a**6*b**7*c**4*s**2 + 13*a**5*b**8*c**4*s**2 +
        6*a**10*b**2*c**5*s**2 + 47*a**9*b**3*c**5*s**2 +
        88*a**8*b**4*c**5*s**2 + 96*a**7*b**5*c**5*s**2 +
        91*a**6*b**6*c**5*s**2 + 52*a**5*b**7*c**5*s**2 +
        13*a**4*b**8*c**5*s**2 + a**10*b*c**6*s**2 +
        18*a**9*b**2*c**6*s**2 + 57*a**8*b**3*c**6*s**2 +
        84*a**7*b**4*c**6*s**2 + 103*a**6*b**5*c**6*s**2 +
        93*a**5*b**6*c**6*s**2 + 53*a**4*b**7*c**6*s**2 +
        10*a**3*b**8*c**6*s**2 + 3*a**9*b*c**7*s**2 +
        21*a**8*b**2*c**7*s**2 + 56*a**7*b**3*c**7*s**2 +
        99*a**6*b**4*c**7*s**2 + 106*a**5*b**5*c**7*s**2 +
        84*a**4*b**6*c**7*s**2 + 34*a**3*b**7*c**7*s**2 +
        3*a**2*b**8*c**7*s**2 + 3*a**8*b*c**8*s**2 +
        17*a**7*b**2*c**8*s**2 + 54*a**6*b**3*c**8*s**2 +
        78*a**5*b**4*c**8*s**2 + 67*a**4*b**5*c**8*s**2 +
        40*a**3*b**6*c**8*s**2 + 8*a**2*b**7*c**8*s**2 +
        a**7*b*c**9*s**2 + 10*a**6*b**2*c**9*s**2 +
        26*a**5*b**3*c**9*s**2 + 28*a**4*b**4*c**9*s**2 +
        17*a**3*b**5*c**9*s**2 + 6*a**2*b**6*c**9*s**2 +
        2*a**5*b**2*c**10*s**2 + 5*a**4*b**3*c**10*s**2 +
        4*a**3*b**4*c**10*s**2 + a**2*b**5*c**10*s**2 -
        6*a**9*b**5*c*s**4 - 9*a**8*b**6*c*s**4 - 5*a**7*b**7*c*s**4 -
        18*a**9*b**4*c**2*s**4 - 59*a**8*b**5*c**2*s**4 -
        53*a**7*b**6*c**2*s**4 - 14*a**6*b**7*c**2*s**4 -
        21*a**9*b**3*c**3*s**4 - 117*a**8*b**4*c**3*s**4 -
        197*a**7*b**5*c**3*s**4 - 116*a**6*b**6*c**3*s**4 -
        26*a**5*b**7*c**3*s**4 - 10*a**9*b**2*c**4*s**4 -
        102*a**8*b**3*c**4*s**4 - 305*a**7*b**4*c**4*s**4 -
        345*a**6*b**5*c**4*s**4 - 177*a**5*b**6*c**4*s**4 -
        36*a**4*b**7*c**4*s**4 - 2*a**9*b*c**5*s**4 -
        42*a**8*b**2*c**5*s**4 - 229*a**7*b**3*c**5*s**4 -
        458*a**6*b**4*c**5*s**4 - 436*a**5*b**5*c**5*s**4 -
        194*a**4*b**6*c**5*s**4 - 28*a**3*b**7*c**5*s**4 -
        7*a**8*b*c**6*s**4 - 80*a**7*b**2*c**6*s**4 -
        282*a**6*b**3*c**6*s**4 - 466*a**5*b**4*c**6*s**4 -
        368*a**4*b**5*c**6*s**4 - 111*a**3*b**6*c**6*s**4 -
        8*a**2*b**7*c**6*s**4 - 10*a**7*b*c**7*s**4 -
        71*a**6*b**2*c**7*s**4 - 212*a**5*b**3*c**7*s**4 -
        298*a**4*b**4*c**7*s**4 - 155*a**3*b**5*c**7*s**4 -
        22*a**2*b**6*c**7*s**4 - 4*a**6*b*c**8*s**4 -
        31*a**5*b**2*c**8*s**4 - 96*a**4*b**3*c**8*s**4 -
        93*a**3*b**4*c**8*s**4 - 23*a**2*b**5*c**8*s**4 -
        8*a**4*b**2*c**9*s**4 - 17*a**3*b**3*c**9*s**4 -
        9*a**2*b**4*c**9*s**4 + a**7*b**5*c*s**6 + a**6*b**6*c*s**6 +
        2*a**8*b**3*c**2*s**6 + 5*a**7*b**4*c**2*s**6 +
        6*a**6*b**5*c**2*s**6 + 2*a**5*b**6*c**2*s**6 +
        3*a**8*b**2*c**3*s**6 + 10*a**7*b**3*c**3*s**6 +
        11*a**6*b**4*c**3*s**6 + 6*a**5*b**5*c**3*s**6 +
        a**8*b*c**4*s**6 + 6*a**7*b**2*c**4*s**6 +
        10*a**6*b**3*c**4*s**6 + 7*a**5*b**4*c**4*s**6 +
        a**4*b**5*c**4*s**6 + a**7*b*c**5*s**6 + 2*a**6*b**2*c**5*s**6
        + 8*a**5*b**3*c**5*s**6 + 9*a**4*b**4*c**5*s**6 +
        5*a**3*b**5*c**5*s**6 + a**2*b**6*c**5*s**6 -
        2*a**6*b*c**6*s**6 - a**5*b**2*c**6*s**6 +
        10*a**4*b**3*c**6*s**6 + 12*a**3*b**4*c**6*s**6 +
        3*a**2*b**5*c**6*s**6 - a**5*b*c**7*s**6 +
        2*a**4*b**2*c**7*s**6 + 9*a**3*b**3*c**7*s**6 +
        4*a**2*b**4*c**7*s**6 + 2*a**3*b**2*c**8*s**6 +
        2*a**2*b**3*c**8*s**6)/(a**10*b**6*s**3 - a**9*b**7*s**3 +
        a**11*b**4*c*s**3 - a**10*b**5*c*s**3 - a**9*b**6*c*s**3 +
        a**8*b**7*c*s**3 - a**7*b**8*c*s**3 + a**6*b**9*c*s**3 -
        3*a**10*b**4*c**2*s**3 + 2*a**9*b**5*c**2*s**3 -
        a**8*b**6*c**2*s**3 + 2*a**7*b**7*c**2*s**3 +
        a**6*b**8*c**2*s**3 - a**5*b**9*c**2*s**3 -
        2*a**11*b**2*c**3*s**3 + a**10*b**3*c**3*s**3 +
        3*a**9*b**4*c**3*s**3 + 3*a**7*b**6*c**3*s**3 -
        4*a**6*b**7*c**3*s**3 - a**4*b**9*c**3*s**3 +
        4*a**10*b**2*c**4*s**3 - a**9*b**3*c**4*s**3 +
        a**8*b**4*c**4*s**3 - 4*a**7*b**5*c**4*s**3 -
        3*a**6*b**6*c**4*s**3 + a**5*b**7*c**4*s**3 +
        2*a**3*b**9*c**4*s**3 + a**11*c**5*s**3 -
        3*a**9*b**2*c**5*s**3 - a**8*b**3*c**5*s**3 -
        5*a**7*b**4*c**5*s**3 + 4*a**6*b**5*c**5*s**3 +
        a**5*b**6*c**5*s**3 + 4*a**4*b**7*c**5*s**3 -
        a**2*b**9*c**5*s**3 - 2*a**10*c**6*s**3 - a**8*b**2*c**6*s**3
        + 2*a**7*b**3*c**6*s**3 + 5*a**6*b**4*c**6*s**3 +
        a**5*b**5*c**6*s**3 - 4*a**3*b**7*c**6*s**3 - a*b**9*c**6*s**3
        + a**9*c**7*s**3 + 5*a**7*b**2*c**7*s**3 - a**6*b**3*c**7*s**3
        - 2*a**5*b**4*c**7*s**3 - 4*a**4*b**5*c**7*s**3 -
        a**3*b**6*c**7*s**3 + a*b**8*c**7*s**3 + b**9*c**7*s**3 +
        a**8*c**8*s**3 - 4*a**6*b**2*c**8*s**3 - a**5*b**3*c**8*s**3 -
        a**4*b**4*c**8*s**3 + 2*a**3*b**5*c**8*s**3 +
        2*a**2*b**6*c**8*s**3 + 2*a*b**7*c**8*s**3 - b**8*c**8*s**3 -
        2*a**7*c**9*s**3 + a**5*b**2*c**9*s**3 + a**4*b**3*c**9*s**3 +
        2*a**3*b**4*c**9*s**3 + a**2*b**5*c**9*s**3 -
        2*a*b**6*c**9*s**3 - b**7*c**9*s**3 + a**6*c**10*s**3 +
        a**4*b**2*c**10*s**3 - 2*a**2*b**4*c**10*s**3 -
        a*b**5*c**10*s**3 + b**6*c**10*s**3 - a**3*b**2*c**11*s**3 +
        a*b**4*c**11*s**3), (-2*a**8*b**9*c**2 - 2*a**7*b**10*c**2 -
        8*a**8*b**8*c**3 - 15*a**7*b**9*c**3 - 9*a**6*b**10*c**3 -
        13*a**8*b**7*c**4 - 36*a**7*b**8*c**4 - 38*a**6*b**9*c**4 -
        16*a**5*b**10*c**4 - 13*a**8*b**6*c**5 - 47*a**7*b**7*c**5 -
        65*a**6*b**8*c**5 - 47*a**5*b**9*c**5 - 14*a**4*b**10*c**5 -
        13*a**8*b**5*c**6 - 49*a**7*b**6*c**6 - 76*a**6*b**7*c**6 -
        64*a**5*b**8*c**6 - 32*a**4*b**9*c**6 - 6*a**3*b**10*c**6 -
        10*a**8*b**4*c**7 - 45*a**7*b**5*c**7 - 76*a**6*b**6*c**7 -
        71*a**5*b**7*c**7 - 37*a**4*b**8*c**7 - 12*a**3*b**9*c**7 -
        a**2*b**10*c**7 - 3*a**8*b**3*c**8 - 22*a**7*b**4*c**8 -
        51*a**6*b**5*c**8 - 59*a**5*b**6*c**8 - 35*a**4*b**7*c**8 -
        11*a**3*b**8*c**8 - 2*a**2*b**9*c**8 - 4*a**7*b**3*c**9 -
        16*a**6*b**4*c**9 - 28*a**5*b**5*c**9 - 21*a**4*b**6*c**9 -
        7*a**3*b**7*c**9 - a**2*b**8*c**9 - a**6*b**3*c**10 -
        4*a**5*b**4*c**10 - 5*a**4*b**5*c**10 - 2*a**3*b**6*c**10 -
        2*a**8*b**8*c*s**2 - 4*a**7*b**9*c*s**2 - 2*a**6*b**10*c*s**2
        - 8*a**8*b**7*c**2*s**2 - 22*a**7*b**8*c**2*s**2 -
        22*a**6*b**9*c**2*s**2 - 9*a**5*b**10*c**2*s**2 -
        13*a**8*b**6*c**3*s**2 - 49*a**7*b**7*c**3*s**2 -
        63*a**6*b**8*c**3*s**2 - 52*a**5*b**9*c**3*s**2 -
        16*a**4*b**10*c**3*s**2 - 13*a**8*b**5*c**4*s**2 -
        56*a**7*b**6*c**4*s**2 - 91*a**6*b**7*c**4*s**2 -
        92*a**5*b**8*c**4*s**2 - 65*a**4*b**9*c**4*s**2 -
        14*a**3*b**10*c**4*s**2 - 13*a**8*b**4*c**5*s**2 -
        52*a**7*b**5*c**5*s**2 - 91*a**6*b**6*c**5*s**2 -
        96*a**5*b**7*c**5*s**2 - 88*a**4*b**8*c**5*s**2 -
        47*a**3*b**9*c**5*s**2 - 6*a**2*b**10*c**5*s**2 -
        10*a**8*b**3*c**6*s**2 - 53*a**7*b**4*c**6*s**2 -
        93*a**6*b**5*c**6*s**2 - 103*a**5*b**6*c**6*s**2 -
        84*a**4*b**7*c**6*s**2 - 57*a**3*b**8*c**6*s**2 -
        18*a**2*b**9*c**6*s**2 - a*b**10*c**6*s**2 -
        3*a**8*b**2*c**7*s**2 - 34*a**7*b**3*c**7*s**2 -
        84*a**6*b**4*c**7*s**2 - 106*a**5*b**5*c**7*s**2 -
        99*a**4*b**6*c**7*s**2 - 56*a**3*b**7*c**7*s**2 -
        21*a**2*b**8*c**7*s**2 - 3*a*b**9*c**7*s**2 -
        8*a**7*b**2*c**8*s**2 - 40*a**6*b**3*c**8*s**2 -
        67*a**5*b**4*c**8*s**2 - 78*a**4*b**5*c**8*s**2 -
        54*a**3*b**6*c**8*s**2 - 17*a**2*b**7*c**8*s**2 -
        3*a*b**8*c**8*s**2 - 6*a**6*b**2*c**9*s**2 -
        17*a**5*b**3*c**9*s**2 - 28*a**4*b**4*c**9*s**2 -
        26*a**3*b**5*c**9*s**2 - 10*a**2*b**6*c**9*s**2 -
        a*b**7*c**9*s**2 - a**5*b**2*c**10*s**2 -
        4*a**4*b**3*c**10*s**2 - 5*a**3*b**4*c**10*s**2 -
        2*a**2*b**5*c**10*s**2 + 5*a**7*b**7*c*s**4 +
        9*a**6*b**8*c*s**4 + 6*a**5*b**9*c*s**4 +
        14*a**7*b**6*c**2*s**4 + 53*a**6*b**7*c**2*s**4 +
        59*a**5*b**8*c**2*s**4 + 18*a**4*b**9*c**2*s**4 +
        26*a**7*b**5*c**3*s**4 + 116*a**6*b**6*c**3*s**4 +
        197*a**5*b**7*c**3*s**4 + 117*a**4*b**8*c**3*s**4 +
        21*a**3*b**9*c**3*s**4 + 36*a**7*b**4*c**4*s**4 +
        177*a**6*b**5*c**4*s**4 + 345*a**5*b**6*c**4*s**4 +
        305*a**4*b**7*c**4*s**4 + 102*a**3*b**8*c**4*s**4 +
        10*a**2*b**9*c**4*s**4 + 28*a**7*b**3*c**5*s**4 +
        194*a**6*b**4*c**5*s**4 + 436*a**5*b**5*c**5*s**4 +
        458*a**4*b**6*c**5*s**4 + 229*a**3*b**7*c**5*s**4 +
        42*a**2*b**8*c**5*s**4 + 2*a*b**9*c**5*s**4 +
        8*a**7*b**2*c**6*s**4 + 111*a**6*b**3*c**6*s**4 +
        368*a**5*b**4*c**6*s**4 + 466*a**4*b**5*c**6*s**4 +
        282*a**3*b**6*c**6*s**4 + 80*a**2*b**7*c**6*s**4 +
        7*a*b**8*c**6*s**4 + 22*a**6*b**2*c**7*s**4 +
        155*a**5*b**3*c**7*s**4 + 298*a**4*b**4*c**7*s**4 +
        212*a**3*b**5*c**7*s**4 + 71*a**2*b**6*c**7*s**4 +
        10*a*b**7*c**7*s**4 + 23*a**5*b**2*c**8*s**4 +
        93*a**4*b**3*c**8*s**4 + 96*a**3*b**4*c**8*s**4 +
        31*a**2*b**5*c**8*s**4 + 4*a*b**6*c**8*s**4 +
        9*a**4*b**2*c**9*s**4 + 17*a**3*b**3*c**9*s**4 +
        8*a**2*b**4*c**9*s**4 - a**6*b**6*c*s**6 - a**5*b**7*c*s**6 -
        2*a**6*b**5*c**2*s**6 - 6*a**5*b**6*c**2*s**6 -
        5*a**4*b**7*c**2*s**6 - 2*a**3*b**8*c**2*s**6 -
        6*a**5*b**5*c**3*s**6 - 11*a**4*b**6*c**3*s**6 -
        10*a**3*b**7*c**3*s**6 - 3*a**2*b**8*c**3*s**6 -
        a**5*b**4*c**4*s**6 - 7*a**4*b**5*c**4*s**6 -
        10*a**3*b**6*c**4*s**6 - 6*a**2*b**7*c**4*s**6 -
        a*b**8*c**4*s**6 - a**6*b**2*c**5*s**6 - 5*a**5*b**3*c**5*s**6
        - 9*a**4*b**4*c**5*s**6 - 8*a**3*b**5*c**5*s**6 -
        2*a**2*b**6*c**5*s**6 - a*b**7*c**5*s**6 -
        3*a**5*b**2*c**6*s**6 - 12*a**4*b**3*c**6*s**6 -
        10*a**3*b**4*c**6*s**6 + a**2*b**5*c**6*s**6 +
        2*a*b**6*c**6*s**6 - 4*a**4*b**2*c**7*s**6 -
        9*a**3*b**3*c**7*s**6 - 2*a**2*b**4*c**7*s**6 +
        a*b**5*c**7*s**6 - 2*a**3*b**2*c**8*s**6 -
        2*a**2*b**3*c**8*s**6)/(a**7*b**9*s**3 - a**6*b**10*s**3 -
        a**9*b**6*c*s**3 + a**8*b**7*c*s**3 - a**7*b**8*c*s**3 +
        a**6*b**9*c*s**3 + a**5*b**10*c*s**3 - a**4*b**11*c*s**3 +
        a**9*b**5*c**2*s**3 - a**8*b**6*c**2*s**3 -
        2*a**7*b**7*c**2*s**3 + a**6*b**8*c**2*s**3 -
        2*a**5*b**9*c**2*s**3 + 3*a**4*b**10*c**2*s**3 +
        a**9*b**4*c**3*s**3 + 4*a**7*b**6*c**3*s**3 -
        3*a**6*b**7*c**3*s**3 - 3*a**4*b**9*c**3*s**3 -
        a**3*b**10*c**3*s**3 + 2*a**2*b**11*c**3*s**3 -
        2*a**9*b**3*c**4*s**3 - a**7*b**5*c**4*s**3 +
        3*a**6*b**6*c**4*s**3 + 4*a**5*b**7*c**4*s**3 -
        a**4*b**8*c**4*s**3 + a**3*b**9*c**4*s**3 -
        4*a**2*b**10*c**4*s**3 + a**9*b**2*c**5*s**3 -
        4*a**7*b**4*c**5*s**3 - a**6*b**5*c**5*s**3 -
        4*a**5*b**6*c**5*s**3 + 5*a**4*b**7*c**5*s**3 +
        a**3*b**8*c**5*s**3 + 3*a**2*b**9*c**5*s**3 - b**11*c**5*s**3
        + a**9*b*c**6*s**3 + 4*a**7*b**3*c**6*s**3 -
        a**5*b**5*c**6*s**3 - 5*a**4*b**6*c**6*s**3 -
        2*a**3*b**7*c**6*s**3 + a**2*b**8*c**6*s**3 +
        2*b**10*c**6*s**3 - a**9*c**7*s**3 - a**8*b*c**7*s**3 +
        a**6*b**3*c**7*s**3 + 4*a**5*b**4*c**7*s**3 +
        2*a**4*b**5*c**7*s**3 + a**3*b**6*c**7*s**3 -
        5*a**2*b**7*c**7*s**3 - b**9*c**7*s**3 + a**8*c**8*s**3 -
        2*a**7*b*c**8*s**3 - 2*a**6*b**2*c**8*s**3 -
        2*a**5*b**3*c**8*s**3 + a**4*b**4*c**8*s**3 +
        a**3*b**5*c**8*s**3 + 4*a**2*b**6*c**8*s**3 - b**8*c**8*s**3 +
        a**7*c**9*s**3 + 2*a**6*b*c**9*s**3 - a**5*b**2*c**9*s**3 -
        2*a**4*b**3*c**9*s**3 - a**3*b**4*c**9*s**3 -
        a**2*b**5*c**9*s**3 + 2*b**7*c**9*s**3 - a**6*c**10*s**3 +
        a**5*b*c**10*s**3 + 2*a**4*b**2*c**10*s**3 -
        a**2*b**4*c**10*s**3 - b**6*c**10*s**3 - a**4*b*c**11*s**3 +
        a**2*b**3*c**11*s**3), (a**10*b**6*c**3 + 4*a**9*b**7*c**3 +
        3*a**8*b**8*c**3 + 4*a**10*b**5*c**4 + 16*a**9*b**6*c**4 +
        22*a**8*b**7*c**4 + 10*a**7*b**8*c**4 + 5*a**10*b**4*c**5 +
        28*a**9*b**5*c**5 + 51*a**8*b**6*c**5 + 45*a**7*b**7*c**5 +
        13*a**6*b**8*c**5 + 2*a**10*b**3*c**6 + 21*a**9*b**4*c**6 +
        59*a**8*b**5*c**6 + 76*a**7*b**6*c**6 + 49*a**6*b**7*c**6 +
        13*a**5*b**8*c**6 + 7*a**9*b**3*c**7 + 35*a**8*b**4*c**7 +
        71*a**7*b**5*c**7 + 76*a**6*b**6*c**7 + 47*a**5*b**7*c**7 +
        13*a**4*b**8*c**7 + a**9*b**2*c**8 + 11*a**8*b**3*c**8 +
        37*a**7*b**4*c**8 + 64*a**6*b**5*c**8 + 65*a**5*b**6*c**8 +
        36*a**4*b**7*c**8 + 8*a**3*b**8*c**8 + 2*a**8*b**2*c**9 +
        12*a**7*b**3*c**9 + 32*a**6*b**4*c**9 + 47*a**5*b**5*c**9 +
        38*a**4*b**6*c**9 + 15*a**3*b**7*c**9 + 2*a**2*b**8*c**9 +
        a**7*b**2*c**10 + 6*a**6*b**3*c**10 + 14*a**5*b**4*c**10 +
        16*a**4*b**5*c**10 + 9*a**3*b**6*c**10 + 2*a**2*b**7*c**10 +
        a**10*b**5*c**2*s**2 + 6*a**9*b**6*c**2*s**2 +
        8*a**8*b**7*c**2*s**2 + 3*a**7*b**8*c**2*s**2 +
        4*a**10*b**4*c**3*s**2 + 17*a**9*b**5*c**3*s**2 +
        40*a**8*b**6*c**3*s**2 + 34*a**7*b**7*c**3*s**2 +
        10*a**6*b**8*c**3*s**2 + 5*a**10*b**3*c**4*s**2 +
        28*a**9*b**4*c**4*s**2 + 67*a**8*b**5*c**4*s**2 +
        84*a**7*b**6*c**4*s**2 + 53*a**6*b**7*c**4*s**2 +
        13*a**5*b**8*c**4*s**2 + 2*a**10*b**2*c**5*s**2 +
        26*a**9*b**3*c**5*s**2 + 78*a**8*b**4*c**5*s**2 +
        106*a**7*b**5*c**5*s**2 + 93*a**6*b**6*c**5*s**2 +
        52*a**5*b**7*c**5*s**2 + 13*a**4*b**8*c**5*s**2 +
        10*a**9*b**2*c**6*s**2 + 54*a**8*b**3*c**6*s**2 +
        99*a**7*b**4*c**6*s**2 + 103*a**6*b**5*c**6*s**2 +
        91*a**5*b**6*c**6*s**2 + 56*a**4*b**7*c**6*s**2 +
        13*a**3*b**8*c**6*s**2 + a**9*b*c**7*s**2 +
        17*a**8*b**2*c**7*s**2 + 56*a**7*b**3*c**7*s**2 +
        84*a**6*b**4*c**7*s**2 + 96*a**5*b**5*c**7*s**2 +
        91*a**4*b**6*c**7*s**2 + 49*a**3*b**7*c**7*s**2 +
        8*a**2*b**8*c**7*s**2 + 3*a**8*b*c**8*s**2 +
        21*a**7*b**2*c**8*s**2 + 57*a**6*b**3*c**8*s**2 +
        88*a**5*b**4*c**8*s**2 + 92*a**4*b**5*c**8*s**2 +
        63*a**3*b**6*c**8*s**2 + 22*a**2*b**7*c**8*s**2 +
        2*a*b**8*c**8*s**2 + 3*a**7*b*c**9*s**2 +
        18*a**6*b**2*c**9*s**2 + 47*a**5*b**3*c**9*s**2 +
        65*a**4*b**4*c**9*s**2 + 52*a**3*b**5*c**9*s**2 +
        22*a**2*b**6*c**9*s**2 + 4*a*b**7*c**9*s**2 +
        a**6*b*c**10*s**2 + 6*a**5*b**2*c**10*s**2 +
        14*a**4*b**3*c**10*s**2 + 16*a**3*b**4*c**10*s**2 +
        9*a**2*b**5*c**10*s**2 + 2*a*b**6*c**10*s**2 -
        9*a**9*b**4*c**2*s**4 - 23*a**8*b**5*c**2*s**4 -
        22*a**7*b**6*c**2*s**4 - 8*a**6*b**7*c**2*s**4 -
        17*a**9*b**3*c**3*s**4 - 93*a**8*b**4*c**3*s**4 -
        155*a**7*b**5*c**3*s**4 - 111*a**6*b**6*c**3*s**4 -
        28*a**5*b**7*c**3*s**4 - 8*a**9*b**2*c**4*s**4 -
        96*a**8*b**3*c**4*s**4 - 298*a**7*b**4*c**4*s**4 -
        368*a**6*b**5*c**4*s**4 - 194*a**5*b**6*c**4*s**4 -
        36*a**4*b**7*c**4*s**4 - 31*a**8*b**2*c**5*s**4 -
        212*a**7*b**3*c**5*s**4 - 466*a**6*b**4*c**5*s**4 -
        436*a**5*b**5*c**5*s**4 - 177*a**4*b**6*c**5*s**4 -
        26*a**3*b**7*c**5*s**4 - 4*a**8*b*c**6*s**4 -
        71*a**7*b**2*c**6*s**4 - 282*a**6*b**3*c**6*s**4 -
        458*a**5*b**4*c**6*s**4 - 345*a**4*b**5*c**6*s**4 -
        116*a**3*b**6*c**6*s**4 - 14*a**2*b**7*c**6*s**4 -
        10*a**7*b*c**7*s**4 - 80*a**6*b**2*c**7*s**4 -
        229*a**5*b**3*c**7*s**4 - 305*a**4*b**4*c**7*s**4 -
        197*a**3*b**5*c**7*s**4 - 53*a**2*b**6*c**7*s**4 -
        5*a*b**7*c**7*s**4 - 7*a**6*b*c**8*s**4 -
        42*a**5*b**2*c**8*s**4 - 102*a**4*b**3*c**8*s**4 -
        117*a**3*b**4*c**8*s**4 - 59*a**2*b**5*c**8*s**4 -
        9*a*b**6*c**8*s**4 - 2*a**5*b*c**9*s**4 -
        10*a**4*b**2*c**9*s**4 - 21*a**3*b**3*c**9*s**4 -
        18*a**2*b**4*c**9*s**4 - 6*a*b**5*c**9*s**4 +
        2*a**8*b**3*c**2*s**6 + 4*a**7*b**4*c**2*s**6 +
        3*a**6*b**5*c**2*s**6 + a**5*b**6*c**2*s**6 +
        2*a**8*b**2*c**3*s**6 + 9*a**7*b**3*c**3*s**6 +
        12*a**6*b**4*c**3*s**6 + 5*a**5*b**5*c**3*s**6 +
        2*a**7*b**2*c**4*s**6 + 10*a**6*b**3*c**4*s**6 +
        9*a**5*b**4*c**4*s**6 + a**4*b**5*c**4*s**6 - a**7*b*c**5*s**6
        - a**6*b**2*c**5*s**6 + 8*a**5*b**3*c**5*s**6 +
        7*a**4*b**4*c**5*s**6 + 6*a**3*b**5*c**5*s**6 +
        2*a**2*b**6*c**5*s**6 - 2*a**6*b*c**6*s**6 +
        2*a**5*b**2*c**6*s**6 + 10*a**4*b**3*c**6*s**6 +
        11*a**3*b**4*c**6*s**6 + 6*a**2*b**5*c**6*s**6 +
        a*b**6*c**6*s**6 + a**5*b*c**7*s**6 + 6*a**4*b**2*c**7*s**6 +
        10*a**3*b**3*c**7*s**6 + 5*a**2*b**4*c**7*s**6 +
        a*b**5*c**7*s**6 + a**4*b*c**8*s**6 + 3*a**3*b**2*c**8*s**6 +
        2*a**2*b**3*c**8*s**6)/(a**10*b**6*s**3 - a**9*b**7*s**3 -
        a**8*b**8*s**3 + a**7*b**9*s**3 + a**11*b**4*c*s**3 -
        a**10*b**5*c*s**3 - 2*a**9*b**6*c*s**3 + 2*a**8*b**7*c*s**3 +
        a**7*b**8*c*s**3 - a**6*b**9*c*s**3 - 2*a**10*b**4*c**2*s**3 +
        a**9*b**5*c**2*s**3 + 2*a**8*b**6*c**2*s**3 -
        a**5*b**9*c**2*s**3 - a**11*b**2*c**3*s**3 +
        2*a**9*b**4*c**3*s**3 + 2*a**8*b**5*c**3*s**3 -
        a**7*b**6*c**3*s**3 - 4*a**6*b**7*c**3*s**3 +
        2*a**4*b**9*c**3*s**3 + a**10*b**2*c**4*s**3 +
        a**9*b**3*c**4*s**3 - a**8*b**4*c**4*s**3 -
        4*a**7*b**5*c**4*s**3 + 4*a**5*b**7*c**4*s**3 -
        a**3*b**9*c**4*s**3 + a**9*b**2*c**5*s**3 -
        a**8*b**3*c**5*s**3 - 2*a**7*b**4*c**5*s**3 +
        a**6*b**5*c**5*s**3 + a**5*b**6*c**5*s**3 +
        a**4*b**7*c**5*s**3 - a**2*b**9*c**5*s**3 + a**10*c**6*s**3 -
        4*a**8*b**2*c**6*s**3 - a**7*b**3*c**6*s**3 +
        5*a**6*b**4*c**6*s**3 + 4*a**5*b**5*c**6*s**3 -
        3*a**4*b**6*c**6*s**3 - 4*a**3*b**7*c**6*s**3 +
        a**2*b**8*c**6*s**3 + a*b**9*c**6*s**3 - 2*a**9*c**7*s**3 +
        5*a**7*b**2*c**7*s**3 + 2*a**6*b**3*c**7*s**3 -
        5*a**5*b**4*c**7*s**3 - 4*a**4*b**5*c**7*s**3 +
        3*a**3*b**6*c**7*s**3 + 2*a**2*b**7*c**7*s**3 -
        a*b**8*c**7*s**3 + a**8*c**8*s**3 - a**6*b**2*c**8*s**3 -
        a**5*b**3*c**8*s**3 + a**4*b**4*c**8*s**3 -
        a**2*b**6*c**8*s**3 + a*b**7*c**8*s**3 + a**7*c**9*s**3 -
        3*a**5*b**2*c**9*s**3 - a**4*b**3*c**9*s**3 +
        3*a**3*b**4*c**9*s**3 + 2*a**2*b**5*c**9*s**3 -
        a*b**6*c**9*s**3 - b**7*c**9*s**3 - 2*a**6*c**10*s**3 +
        4*a**4*b**2*c**10*s**3 + a**3*b**3*c**10*s**3 -
        3*a**2*b**4*c**10*s**3 - a*b**5*c**10*s**3 + b**6*c**10*s**3 +
        a**5*c**11*s**3 - 2*a**3*b**2*c**11*s**3 + a*b**4*c**11*s**3),
        (a**10*b**7*c**2 + 2*a**9*b**8*c**2 + a**8*b**9*c**2 +
        6*a**10*b**6*c**3 + 12*a**9*b**7*c**3 + 11*a**8*b**8*c**3 +
        7*a**7*b**9*c**3 + 2*a**6*b**10*c**3 + 14*a**10*b**5*c**4 +
        32*a**9*b**6*c**4 + 37*a**8*b**7*c**4 + 35*a**7*b**8*c**4 +
        21*a**6*b**9*c**4 + 5*a**5*b**10*c**4 + 16*a**10*b**4*c**5 +
        47*a**9*b**5*c**5 + 64*a**8*b**6*c**5 + 71*a**7*b**7*c**5 +
        59*a**6*b**8*c**5 + 28*a**5*b**9*c**5 + 4*a**4*b**10*c**5 +
        9*a**10*b**3*c**6 + 38*a**9*b**4*c**6 + 65*a**8*b**5*c**6 +
        76*a**7*b**6*c**6 + 76*a**6*b**7*c**6 + 51*a**5*b**8*c**6 +
        16*a**4*b**9*c**6 + a**3*b**10*c**6 + 2*a**10*b**2*c**7 +
        15*a**9*b**3*c**7 + 36*a**8*b**4*c**7 + 47*a**7*b**5*c**7 +
        49*a**6*b**6*c**7 + 45*a**5*b**7*c**7 + 22*a**4*b**8*c**7 +
        4*a**3*b**9*c**7 + 2*a**9*b**2*c**8 + 8*a**8*b**3*c**8 +
        13*a**7*b**4*c**8 + 13*a**6*b**5*c**8 + 13*a**5*b**6*c**8 +
        10*a**4*b**7*c**8 + 3*a**3*b**8*c**8 + a**10*b**6*c*s**2 +
        3*a**9*b**7*c*s**2 + 3*a**8*b**8*c*s**2 + a**7*b**9*c*s**2 +
        6*a**10*b**5*c**2*s**2 + 18*a**9*b**6*c**2*s**2 +
        21*a**8*b**7*c**2*s**2 + 17*a**7*b**8*c**2*s**2 +
        10*a**6*b**9*c**2*s**2 + 2*a**5*b**10*c**2*s**2 +
        14*a**10*b**4*c**3*s**2 + 47*a**9*b**5*c**3*s**2 +
        57*a**8*b**6*c**3*s**2 + 56*a**7*b**7*c**3*s**2 +
        54*a**6*b**8*c**3*s**2 + 26*a**5*b**9*c**3*s**2 +
        5*a**4*b**10*c**3*s**2 + 16*a**10*b**3*c**4*s**2 +
        65*a**9*b**4*c**4*s**2 + 88*a**8*b**5*c**4*s**2 +
        84*a**7*b**6*c**4*s**2 + 99*a**6*b**7*c**4*s**2 +
        78*a**5*b**8*c**4*s**2 + 28*a**4*b**9*c**4*s**2 +
        4*a**3*b**10*c**4*s**2 + 9*a**10*b**2*c**5*s**2 +
        52*a**9*b**3*c**5*s**2 + 92*a**8*b**4*c**5*s**2 +
        96*a**7*b**5*c**5*s**2 + 103*a**6*b**6*c**5*s**2 +
        106*a**5*b**7*c**5*s**2 + 67*a**4*b**8*c**5*s**2 +
        17*a**3*b**9*c**5*s**2 + a**2*b**10*c**5*s**2 +
        2*a**10*b*c**6*s**2 + 22*a**9*b**2*c**6*s**2 +
        63*a**8*b**3*c**6*s**2 + 91*a**7*b**4*c**6*s**2 +
        91*a**6*b**5*c**6*s**2 + 93*a**5*b**6*c**6*s**2 +
        84*a**4*b**7*c**6*s**2 + 40*a**3*b**8*c**6*s**2 +
        6*a**2*b**9*c**6*s**2 + 4*a**9*b*c**7*s**2 +
        22*a**8*b**2*c**7*s**2 + 49*a**7*b**3*c**7*s**2 +
        56*a**6*b**4*c**7*s**2 + 52*a**5*b**5*c**7*s**2 +
        53*a**4*b**6*c**7*s**2 + 34*a**3*b**7*c**7*s**2 +
        8*a**2*b**8*c**7*s**2 + 2*a**8*b*c**8*s**2 +
        8*a**7*b**2*c**8*s**2 + 13*a**6*b**3*c**8*s**2 +
        13*a**5*b**4*c**8*s**2 + 13*a**4*b**5*c**8*s**2 +
        10*a**3*b**6*c**8*s**2 + 3*a**2*b**7*c**8*s**2 -
        2*a**9*b**5*c*s**4 - 7*a**8*b**6*c*s**4 - 10*a**7*b**7*c*s**4
        - 4*a**6*b**8*c*s**4 - 10*a**9*b**4*c**2*s**4 -
        42*a**8*b**5*c**2*s**4 - 80*a**7*b**6*c**2*s**4 -
        71*a**6*b**7*c**2*s**4 - 31*a**5*b**8*c**2*s**4 -
        8*a**4*b**9*c**2*s**4 - 21*a**9*b**3*c**3*s**4 -
        102*a**8*b**4*c**3*s**4 - 229*a**7*b**5*c**3*s**4 -
        282*a**6*b**6*c**3*s**4 - 212*a**5*b**7*c**3*s**4 -
        96*a**4*b**8*c**3*s**4 - 17*a**3*b**9*c**3*s**4 -
        18*a**9*b**2*c**4*s**4 - 117*a**8*b**3*c**4*s**4 -
        305*a**7*b**4*c**4*s**4 - 458*a**6*b**5*c**4*s**4 -
        466*a**5*b**6*c**4*s**4 - 298*a**4*b**7*c**4*s**4 -
        93*a**3*b**8*c**4*s**4 - 9*a**2*b**9*c**4*s**4 -
        6*a**9*b*c**5*s**4 - 59*a**8*b**2*c**5*s**4 -
        197*a**7*b**3*c**5*s**4 - 345*a**6*b**4*c**5*s**4 -
        436*a**5*b**5*c**5*s**4 - 368*a**4*b**6*c**5*s**4 -
        155*a**3*b**7*c**5*s**4 - 23*a**2*b**8*c**5*s**4 -
        9*a**8*b*c**6*s**4 - 53*a**7*b**2*c**6*s**4 -
        116*a**6*b**3*c**6*s**4 - 177*a**5*b**4*c**6*s**4 -
        194*a**4*b**5*c**6*s**4 - 111*a**3*b**6*c**6*s**4 -
        22*a**2*b**7*c**6*s**4 - 5*a**7*b*c**7*s**4 -
        14*a**6*b**2*c**7*s**4 - 26*a**5*b**3*c**7*s**4 -
        36*a**4*b**4*c**7*s**4 - 28*a**3*b**5*c**7*s**4 -
        8*a**2*b**6*c**7*s**4 + a**8*b**4*c*s**6 + a**7*b**5*c*s**6 -
        2*a**6*b**6*c*s**6 - a**5*b**7*c*s**6 + 3*a**8*b**3*c**2*s**6
        + 6*a**7*b**4*c**2*s**6 + 2*a**6*b**5*c**2*s**6 -
        a**5*b**6*c**2*s**6 + 2*a**4*b**7*c**2*s**6 +
        2*a**3*b**8*c**2*s**6 + 2*a**8*b**2*c**3*s**6 +
        10*a**7*b**3*c**3*s**6 + 10*a**6*b**4*c**3*s**6 +
        8*a**5*b**5*c**3*s**6 + 10*a**4*b**6*c**3*s**6 +
        9*a**3*b**7*c**3*s**6 + 2*a**2*b**8*c**3*s**6 +
        5*a**7*b**2*c**4*s**6 + 11*a**6*b**3*c**4*s**6 +
        7*a**5*b**4*c**4*s**6 + 9*a**4*b**5*c**4*s**6 +
        12*a**3*b**6*c**4*s**6 + 4*a**2*b**7*c**4*s**6 +
        a**7*b*c**5*s**6 + 6*a**6*b**2*c**5*s**6 +
        6*a**5*b**3*c**5*s**6 + a**4*b**4*c**5*s**6 +
        5*a**3*b**5*c**5*s**6 + 3*a**2*b**6*c**5*s**6 +
        a**6*b*c**6*s**6 + 2*a**5*b**2*c**6*s**6 +
        a**2*b**5*c**6*s**6)/(a**11*b**5*s**3 - 2*a**10*b**6*s**3 +
        a**9*b**7*s**3 + a**8*b**8*s**3 - 2*a**7*b**9*s**3 +
        a**6*b**10*s**3 - 2*a**11*b**3*c**2*s**3 +
        4*a**10*b**4*c**2*s**3 - 3*a**9*b**5*c**2*s**3 -
        a**8*b**6*c**2*s**3 + 5*a**7*b**7*c**2*s**3 -
        4*a**6*b**8*c**2*s**3 + a**5*b**9*c**2*s**3 +
        a**4*b**10*c**2*s**3 - a**3*b**11*c**2*s**3 +
        a**10*b**3*c**3*s**3 - a**9*b**4*c**3*s**3 -
        a**8*b**5*c**3*s**3 + 2*a**7*b**6*c**3*s**3 -
        a**6*b**7*c**3*s**3 - a**5*b**8*c**3*s**3 +
        a**4*b**9*c**3*s**3 + a**11*b*c**4*s**3 -
        3*a**10*b**2*c**4*s**3 + 3*a**9*b**3*c**4*s**3 +
        a**8*b**4*c**4*s**3 - 5*a**7*b**5*c**4*s**3 +
        5*a**6*b**6*c**4*s**3 - 2*a**5*b**7*c**4*s**3 -
        a**4*b**8*c**4*s**3 + 2*a**3*b**9*c**4*s**3 -
        2*a**2*b**10*c**4*s**3 + a*b**11*c**4*s**3 - a**10*b*c**5*s**3
        + 2*a**9*b**2*c**5*s**3 - 4*a**7*b**4*c**5*s**3 +
        4*a**6*b**5*c**5*s**3 + a**5*b**6*c**5*s**3 -
        4*a**4*b**7*c**5*s**3 + 2*a**3*b**8*c**5*s**3 +
        a**2*b**9*c**5*s**3 - a*b**10*c**5*s**3 + a**10*c**6*s**3 -
        a**9*b*c**6*s**3 - a**8*b**2*c**6*s**3 + 3*a**7*b**3*c**6*s**3
        - 3*a**6*b**4*c**6*s**3 + a**5*b**5*c**6*s**3 -
        a**3*b**7*c**6*s**3 + 2*a**2*b**8*c**6*s**3 -
        2*a*b**9*c**6*s**3 + b**10*c**6*s**3 - a**9*c**7*s**3 +
        a**8*b*c**7*s**3 + 2*a**7*b**2*c**7*s**3 -
        4*a**6*b**3*c**7*s**3 + a**5*b**4*c**7*s**3 +
        4*a**4*b**5*c**7*s**3 - 4*a**3*b**6*c**7*s**3 +
        2*a*b**8*c**7*s**3 - b**9*c**7*s**3 - a**7*b*c**8*s**3 +
        a**6*b**2*c**8*s**3 + a*b**7*c**8*s**3 - b**8*c**8*s**3 +
        a**6*b*c**9*s**3 - a**5*b**2*c**9*s**3 - a**4*b**3*c**9*s**3 +
        2*a**3*b**4*c**9*s**3 - a**2*b**5*c**9*s**3 - a*b**6*c**9*s**3
        + b**7*c**9*s**3), (2*a**10*b**7*c**2 + 2*a**9*b**8*c**2 +
        8*a**10*b**6*c**3 + 15*a**9*b**7*c**3 + 8*a**8*b**8*c**3 +
        a**7*b**9*c**3 + 14*a**10*b**5*c**4 + 35*a**9*b**6*c**4 +
        37*a**8*b**7*c**4 + 19*a**7*b**8*c**4 + 4*a**6*b**9*c**4 +
        14*a**10*b**4*c**5 + 44*a**9*b**5*c**5 + 66*a**8*b**6*c**5 +
        61*a**7*b**7*c**5 + 32*a**6*b**8*c**5 + 7*a**5*b**9*c**5 +
        8*a**10*b**3*c**6 + 35*a**9*b**4*c**6 + 66*a**8*b**5*c**6 +
        87*a**7*b**6*c**6 + 74*a**6*b**7*c**6 + 36*a**5*b**8*c**6 +
        6*a**4*b**9*c**6 + 2*a**10*b**2*c**7 + 15*a**9*b**3*c**7 +
        37*a**8*b**4*c**7 + 61*a**7*b**5*c**7 + 74*a**6*b**6*c**7 +
        56*a**5*b**7*c**7 + 20*a**4*b**8*c**7 + 2*a**3*b**9*c**7 +
        2*a**9*b**2*c**8 + 8*a**8*b**3*c**8 + 19*a**7*b**4*c**8 +
        32*a**6*b**5*c**8 + 36*a**5*b**6*c**8 + 20*a**4*b**7*c**8 +
        4*a**3*b**8*c**8 + a**7*b**3*c**9 + 4*a**6*b**4*c**9 +
        7*a**5*b**5*c**9 + 6*a**4*b**6*c**9 + 2*a**3*b**7*c**9 +
        2*a**10*b**6*c*s**2 + 4*a**9*b**7*c*s**2 + 2*a**8*b**8*c*s**2
        + 8*a**10*b**5*c**2*s**2 + 22*a**9*b**6*c**2*s**2 +
        21*a**8*b**7*c**2*s**2 + 9*a**7*b**8*c**2*s**2 +
        a**6*b**9*c**2*s**2 + 14*a**10*b**4*c**3*s**2 +
        49*a**9*b**5*c**3*s**2 + 61*a**8*b**6*c**3*s**2 +
        47*a**7*b**7*c**3*s**2 + 22*a**6*b**8*c**3*s**2 +
        4*a**5*b**9*c**3*s**2 + 14*a**10*b**3*c**4*s**2 +
        61*a**9*b**4*c**4*s**2 + 90*a**8*b**5*c**4*s**2 +
        91*a**7*b**6*c**4*s**2 + 74*a**6*b**7*c**4*s**2 +
        33*a**5*b**8*c**4*s**2 + 7*a**4*b**9*c**4*s**2 +
        8*a**10*b**2*c**5*s**2 + 49*a**9*b**3*c**5*s**2 +
        90*a**8*b**4*c**5*s**2 + 108*a**7*b**5*c**5*s**2 +
        116*a**6*b**6*c**5*s**2 + 89*a**5*b**7*c**5*s**2 +
        37*a**4*b**8*c**5*s**2 + 6*a**3*b**9*c**5*s**2 +
        2*a**10*b*c**6*s**2 + 22*a**9*b**2*c**6*s**2 +
        61*a**8*b**3*c**6*s**2 + 91*a**7*b**4*c**6*s**2 +
        116*a**6*b**5*c**6*s**2 + 118*a**5*b**6*c**6*s**2 +
        81*a**4*b**7*c**6*s**2 + 26*a**3*b**8*c**6*s**2 +
        2*a**2*b**9*c**6*s**2 + 4*a**9*b*c**7*s**2 +
        21*a**8*b**2*c**7*s**2 + 47*a**7*b**3*c**7*s**2 +
        74*a**6*b**4*c**7*s**2 + 89*a**5*b**5*c**7*s**2 +
        81*a**4*b**6*c**7*s**2 + 41*a**3*b**7*c**7*s**2 +
        7*a**2*b**8*c**7*s**2 + 2*a**8*b*c**8*s**2 +
        9*a**7*b**2*c**8*s**2 + 22*a**6*b**3*c**8*s**2 +
        33*a**5*b**4*c**8*s**2 + 37*a**4*b**5*c**8*s**2 +
        26*a**3*b**6*c**8*s**2 + 7*a**2*b**7*c**8*s**2 +
        a**6*b**2*c**9*s**2 + 4*a**5*b**3*c**9*s**2 +
        7*a**4*b**4*c**9*s**2 + 6*a**3*b**5*c**9*s**2 +
        2*a**2*b**6*c**9*s**2 - 5*a**9*b**5*c*s**4 -
        9*a**8*b**6*c*s**4 - 6*a**7*b**7*c*s**4 -
        14*a**9*b**4*c**2*s**4 - 53*a**8*b**5*c**2*s**4 -
        66*a**7*b**6*c**2*s**4 - 28*a**6*b**7*c**2*s**4 -
        4*a**5*b**8*c**2*s**4 - 19*a**9*b**3*c**3*s**4 -
        106*a**8*b**4*c**3*s**4 - 215*a**7*b**5*c**3*s**4 -
        188*a**6*b**6*c**3*s**4 - 84*a**5*b**7*c**3*s**4 -
        17*a**4*b**8*c**3*s**4 - 14*a**9*b**2*c**4*s**4 -
        106*a**8*b**3*c**4*s**4 - 305*a**7*b**4*c**4*s**4 -
        429*a**6*b**5*c**4*s**4 - 331*a**5*b**6*c**4*s**4 -
        141*a**4*b**7*c**4*s**4 - 21*a**3*b**8*c**4*s**4 -
        5*a**9*b*c**5*s**4 - 53*a**8*b**2*c**5*s**4 -
        215*a**7*b**3*c**5*s**4 - 429*a**6*b**4*c**5*s**4 -
        510*a**5*b**5*c**5*s**4 - 342*a**4*b**6*c**5*s**4 -
        102*a**3*b**7*c**5*s**4 - 8*a**2*b**8*c**5*s**4 -
        9*a**8*b*c**6*s**4 - 66*a**7*b**2*c**6*s**4 -
        188*a**6*b**3*c**6*s**4 - 331*a**5*b**4*c**6*s**4 -
        342*a**4*b**5*c**6*s**4 - 158*a**3*b**6*c**6*s**4 -
        23*a**2*b**7*c**6*s**4 - 6*a**7*b*c**7*s**4 -
        28*a**6*b**2*c**7*s**4 - 84*a**5*b**3*c**7*s**4 -
        141*a**4*b**4*c**7*s**4 - 102*a**3*b**5*c**7*s**4 -
        23*a**2*b**6*c**7*s**4 - 4*a**5*b**2*c**8*s**4 -
        17*a**4*b**3*c**8*s**4 - 21*a**3*b**4*c**8*s**4 -
        8*a**2*b**5*c**8*s**4 + a**8*b**4*c*s**6 + a**7*b**5*c*s**6 +
        2*a**8*b**3*c**2*s**6 + 6*a**7*b**4*c**2*s**6 +
        3*a**6*b**5*c**2*s**6 - a**5*b**6*c**2*s**6 -
        a**4*b**7*c**2*s**6 + 2*a**8*b**2*c**3*s**6 +
        9*a**7*b**3*c**3*s**6 + 11*a**6*b**4*c**3*s**6 +
        5*a**5*b**5*c**3*s**6 + a**3*b**7*c**3*s**6 + a**8*b*c**4*s**6
        + 6*a**7*b**2*c**4*s**6 + 11*a**6*b**3*c**4*s**6 +
        13*a**5*b**4*c**4*s**6 + 12*a**4*b**5*c**4*s**6 +
        7*a**3*b**6*c**4*s**6 + 2*a**2*b**7*c**4*s**6 +
        a**7*b*c**5*s**6 + 3*a**6*b**2*c**5*s**6 +
        5*a**5*b**3*c**5*s**6 + 12*a**4*b**4*c**5*s**6 +
        12*a**3*b**5*c**5*s**6 + 3*a**2*b**6*c**5*s**6 -
        a**5*b**2*c**6*s**6 + 7*a**3*b**4*c**6*s**6 +
        3*a**2*b**5*c**6*s**6 - a**4*b**2*c**7*s**6 +
        a**3*b**3*c**7*s**6 + 2*a**2*b**4*c**7*s**6)/(a**9*b**7*s**3 -
        a**8*b**8*s**3 - a**11*b**4*c*s**3 + a**10*b**5*c*s**3 -
        a**9*b**6*c*s**3 + a**8*b**7*c*s**3 + a**7*b**8*c*s**3 -
        a**6*b**9*c*s**3 + a**11*b**3*c**2*s**3 - a**10*b**4*c**2*s**3
        - 2*a**9*b**5*c**2*s**3 + a**8*b**6*c**2*s**3 -
        a**7*b**7*c**2*s**3 + 2*a**6*b**8*c**2*s**3 +
        a**5*b**9*c**2*s**3 - a**4*b**10*c**2*s**3 +
        a**11*b**2*c**3*s**3 + 2*a**9*b**4*c**3*s**3 -
        a**8*b**5*c**3*s**3 - 3*a**7*b**6*c**3*s**3 -
        a**5*b**8*c**3*s**3 + 2*a**4*b**9*c**3*s**3 -
        a**11*b*c**4*s**3 - a**10*b**2*c**4*s**3 +
        2*a**9*b**3*c**4*s**3 + 3*a**7*b**5*c**4*s**3 -
        a**6*b**6*c**4*s**3 - 2*a**5*b**7*c**4*s**3 -
        a**4*b**8*c**4*s**3 + a**2*b**10*c**4*s**3 + a**10*b*c**5*s**3
        - 2*a**9*b**2*c**5*s**3 - a**8*b**3*c**5*s**3 +
        3*a**7*b**4*c**5*s**3 + 2*a**5*b**6*c**5*s**3 -
        a**4*b**7*c**5*s**3 - a**3*b**8*c**5*s**3 -
        a**2*b**9*c**5*s**3 - a**9*b*c**6*s**3 + a**8*b**2*c**6*s**3 -
        3*a**7*b**3*c**6*s**3 - a**6*b**4*c**6*s**3 +
        2*a**5*b**5*c**6*s**3 + 2*a**4*b**6*c**6*s**3 +
        a**3*b**7*c**6*s**3 - a**2*b**8*c**6*s**3 + a**9*c**7*s**3 +
        a**8*b*c**7*s**3 - a**7*b**2*c**7*s**3 - 2*a**5*b**4*c**7*s**3
        - a**4*b**5*c**7*s**3 + a**3*b**6*c**7*s**3 +
        2*a**2*b**7*c**7*s**3 - b**9*c**7*s**3 - a**8*c**8*s**3 +
        a**7*b*c**8*s**3 + 2*a**6*b**2*c**8*s**3 - a**5*b**3*c**8*s**3
        - a**4*b**4*c**8*s**3 - a**3*b**5*c**8*s**3 -
        a**2*b**6*c**8*s**3 + 2*b**8*c**8*s**3 - a**6*b*c**9*s**3 +
        a**5*b**2*c**9*s**3 + 2*a**4*b**3*c**9*s**3 -
        a**2*b**5*c**9*s**3 - b**7*c**9*s**3 - a**4*b**2*c**10*s**3 +
        a**2*b**4*c**10*s**3), (-2*a**9*b**7*c**3 - 4*a**8*b**8*c**3 -
        2*a**7*b**9*c**3 - 6*a**9*b**6*c**4 - 20*a**8*b**7*c**4 -
        20*a**7*b**8*c**4 - 6*a**6*b**9*c**4 - 7*a**9*b**5*c**5 -
        36*a**8*b**6*c**5 - 56*a**7*b**7*c**5 - 36*a**6*b**8*c**5 -
        7*a**5*b**9*c**5 - 4*a**9*b**4*c**6 - 32*a**8*b**5*c**6 -
        74*a**7*b**6*c**6 - 74*a**6*b**7*c**6 - 32*a**5*b**8*c**6 -
        4*a**4*b**9*c**6 - a**9*b**3*c**7 - 19*a**8*b**4*c**7 -
        61*a**7*b**5*c**7 - 87*a**6*b**6*c**7 - 61*a**5*b**7*c**7 -
        19*a**4*b**8*c**7 - a**3*b**9*c**7 - 8*a**8*b**3*c**8 -
        37*a**7*b**4*c**8 - 66*a**6*b**5*c**8 - 66*a**5*b**6*c**8 -
        37*a**4*b**7*c**8 - 8*a**3*b**8*c**8 - 2*a**8*b**2*c**9 -
        15*a**7*b**3*c**9 - 35*a**6*b**4*c**9 - 44*a**5*b**5*c**9 -
        35*a**4*b**6*c**9 - 15*a**3*b**7*c**9 - 2*a**2*b**8*c**9 -
        2*a**7*b**2*c**10 - 8*a**6*b**3*c**10 - 14*a**5*b**4*c**10 -
        14*a**4*b**5*c**10 - 8*a**3*b**6*c**10 - 2*a**2*b**7*c**10 -
        2*a**9*b**6*c**2*s**2 - 7*a**8*b**7*c**2*s**2 -
        7*a**7*b**8*c**2*s**2 - 2*a**6*b**9*c**2*s**2 -
        6*a**9*b**5*c**3*s**2 - 26*a**8*b**6*c**3*s**2 -
        41*a**7*b**7*c**3*s**2 - 26*a**6*b**8*c**3*s**2 -
        6*a**5*b**9*c**3*s**2 - 7*a**9*b**4*c**4*s**2 -
        37*a**8*b**5*c**4*s**2 - 81*a**7*b**6*c**4*s**2 -
        81*a**6*b**7*c**4*s**2 - 37*a**5*b**8*c**4*s**2 -
        7*a**4*b**9*c**4*s**2 - 4*a**9*b**3*c**5*s**2 -
        33*a**8*b**4*c**5*s**2 - 89*a**7*b**5*c**5*s**2 -
        118*a**6*b**6*c**5*s**2 - 89*a**5*b**7*c**5*s**2 -
        33*a**4*b**8*c**5*s**2 - 4*a**3*b**9*c**5*s**2 -
        a**9*b**2*c**6*s**2 - 22*a**8*b**3*c**6*s**2 -
        74*a**7*b**4*c**6*s**2 - 116*a**6*b**5*c**6*s**2 -
        116*a**5*b**6*c**6*s**2 - 74*a**4*b**7*c**6*s**2 -
        22*a**3*b**8*c**6*s**2 - a**2*b**9*c**6*s**2 -
        9*a**8*b**2*c**7*s**2 - 47*a**7*b**3*c**7*s**2 -
        91*a**6*b**4*c**7*s**2 - 108*a**5*b**5*c**7*s**2 -
        91*a**4*b**6*c**7*s**2 - 47*a**3*b**7*c**7*s**2 -
        9*a**2*b**8*c**7*s**2 - 2*a**8*b*c**8*s**2 -
        21*a**7*b**2*c**8*s**2 - 61*a**6*b**3*c**8*s**2 -
        90*a**5*b**4*c**8*s**2 - 90*a**4*b**5*c**8*s**2 -
        61*a**3*b**6*c**8*s**2 - 21*a**2*b**7*c**8*s**2 -
        2*a*b**8*c**8*s**2 - 4*a**7*b*c**9*s**2 -
        22*a**6*b**2*c**9*s**2 - 49*a**5*b**3*c**9*s**2 -
        61*a**4*b**4*c**9*s**2 - 49*a**3*b**5*c**9*s**2 -
        22*a**2*b**6*c**9*s**2 - 4*a*b**7*c**9*s**2 -
        2*a**6*b*c**10*s**2 - 8*a**5*b**2*c**10*s**2 -
        14*a**4*b**3*c**10*s**2 - 14*a**3*b**4*c**10*s**2 -
        8*a**2*b**5*c**10*s**2 - 2*a*b**6*c**10*s**2 +
        8*a**8*b**5*c**2*s**4 + 23*a**7*b**6*c**2*s**4 +
        23*a**6*b**7*c**2*s**4 + 8*a**5*b**8*c**2*s**4 +
        21*a**8*b**4*c**3*s**4 + 102*a**7*b**5*c**3*s**4 +
        158*a**6*b**6*c**3*s**4 + 102*a**5*b**7*c**3*s**4 +
        21*a**4*b**8*c**3*s**4 + 17*a**8*b**3*c**4*s**4 +
        141*a**7*b**4*c**4*s**4 + 342*a**6*b**5*c**4*s**4 +
        342*a**5*b**6*c**4*s**4 + 141*a**4*b**7*c**4*s**4 +
        17*a**3*b**8*c**4*s**4 + 4*a**8*b**2*c**5*s**4 +
        84*a**7*b**3*c**5*s**4 + 331*a**6*b**4*c**5*s**4 +
        510*a**5*b**5*c**5*s**4 + 331*a**4*b**6*c**5*s**4 +
        84*a**3*b**7*c**5*s**4 + 4*a**2*b**8*c**5*s**4 +
        28*a**7*b**2*c**6*s**4 + 188*a**6*b**3*c**6*s**4 +
        429*a**5*b**4*c**6*s**4 + 429*a**4*b**5*c**6*s**4 +
        188*a**3*b**6*c**6*s**4 + 28*a**2*b**7*c**6*s**4 +
        6*a**7*b*c**7*s**4 + 66*a**6*b**2*c**7*s**4 +
        215*a**5*b**3*c**7*s**4 + 305*a**4*b**4*c**7*s**4 +
        215*a**3*b**5*c**7*s**4 + 66*a**2*b**6*c**7*s**4 +
        6*a*b**7*c**7*s**4 + 9*a**6*b*c**8*s**4 +
        53*a**5*b**2*c**8*s**4 + 106*a**4*b**3*c**8*s**4 +
        106*a**3*b**4*c**8*s**4 + 53*a**2*b**5*c**8*s**4 +
        9*a*b**6*c**8*s**4 + 5*a**5*b*c**9*s**4 +
        14*a**4*b**2*c**9*s**4 + 19*a**3*b**3*c**9*s**4 +
        14*a**2*b**4*c**9*s**4 + 5*a*b**5*c**9*s**4 -
        2*a**7*b**4*c**2*s**6 - 3*a**6*b**5*c**2*s**6 -
        3*a**5*b**6*c**2*s**6 - 2*a**4*b**7*c**2*s**6 -
        a**7*b**3*c**3*s**6 - 7*a**6*b**4*c**3*s**6 -
        12*a**5*b**5*c**3*s**6 - 7*a**4*b**6*c**3*s**6 -
        a**3*b**7*c**3*s**6 + a**7*b**2*c**4*s**6 -
        12*a**5*b**4*c**4*s**6 - 12*a**4*b**5*c**4*s**6 +
        a**2*b**7*c**4*s**6 + a**6*b**2*c**5*s**6 -
        5*a**5*b**3*c**5*s**6 - 13*a**4*b**4*c**5*s**6 -
        5*a**3*b**5*c**5*s**6 + a**2*b**6*c**5*s**6 -
        3*a**5*b**2*c**6*s**6 - 11*a**4*b**3*c**6*s**6 -
        11*a**3*b**4*c**6*s**6 - 3*a**2*b**5*c**6*s**6 -
        a**5*b*c**7*s**6 - 6*a**4*b**2*c**7*s**6 -
        9*a**3*b**3*c**7*s**6 - 6*a**2*b**4*c**7*s**6 -
        a*b**5*c**7*s**6 - a**4*b*c**8*s**6 - 2*a**3*b**2*c**8*s**6 -
        2*a**2*b**3*c**8*s**6 - a*b**4*c**8*s**6)/(a**9*b**7*s**3 -
        2*a**8*b**8*s**3 + a**7*b**9*s**3 - a**10*b**4*c**2*s**3 +
        a**9*b**5*c**2*s**3 + a**8*b**6*c**2*s**3 -
        2*a**7*b**7*c**2*s**3 + a**6*b**8*c**2*s**3 +
        a**5*b**9*c**2*s**3 - a**4*b**10*c**2*s**3 +
        a**8*b**5*c**3*s**3 - a**7*b**6*c**3*s**3 -
        a**6*b**7*c**3*s**3 + a**5*b**8*c**3*s**3 +
        a**10*b**2*c**4*s**3 - 2*a**9*b**3*c**4*s**3 +
        a**8*b**4*c**4*s**3 + a**7*b**5*c**4*s**3 -
        2*a**6*b**6*c**4*s**3 + a**5*b**7*c**4*s**3 +
        a**4*b**8*c**4*s**3 - 2*a**3*b**9*c**4*s**3 +
        a**2*b**10*c**4*s**3 - a**9*b**2*c**5*s**3 +
        a**8*b**3*c**5*s**3 + 2*a**7*b**4*c**5*s**3 -
        2*a**6*b**5*c**5*s**3 - 2*a**5*b**6*c**5*s**3 +
        2*a**4*b**7*c**5*s**3 + a**3*b**8*c**5*s**3 -
        a**2*b**9*c**5*s**3 + a**9*b*c**6*s**3 - 2*a**8*b**2*c**6*s**3
        + a**6*b**4*c**6*s**3 + a**4*b**6*c**6*s**3 -
        2*a**2*b**8*c**6*s**3 + a*b**9*c**6*s**3 - a**8*b*c**7*s**3 +
        a**7*b**2*c**7*s**3 + 3*a**6*b**3*c**7*s**3 -
        3*a**5*b**4*c**7*s**3 - 3*a**4*b**5*c**7*s**3 +
        3*a**3*b**6*c**7*s**3 + a**2*b**7*c**7*s**3 - a*b**8*c**7*s**3
        + a**8*c**8*s**3 - a**7*b*c**8*s**3 - a**6*b**2*c**8*s**3 +
        a**5*b**3*c**8*s**3 + a**3*b**5*c**8*s**3 -
        a**2*b**6*c**8*s**3 - a*b**7*c**8*s**3 + b**8*c**8*s**3 -
        a**7*c**9*s**3 + a**6*b*c**9*s**3 + 2*a**5*b**2*c**9*s**3 -
        2*a**4*b**3*c**9*s**3 - 2*a**3*b**4*c**9*s**3 +
        2*a**2*b**5*c**9*s**3 + a*b**6*c**9*s**3 - b**7*c**9*s**3 -
        a**5*b*c**10*s**3 + a**4*b**2*c**10*s**3 +
        a**2*b**4*c**10*s**3 - a*b**5*c**10*s**3 + a**4*b*c**11*s**3 -
        a**3*b**2*c**11*s**3 - a**2*b**3*c**11*s**3 +
        a*b**4*c**11*s**3), (-2*a**8*b**9*c**2 - 2*a**7*b**10*c**2 -
        a**9*b**7*c**3 - 8*a**8*b**8*c**3 - 15*a**7*b**9*c**3 -
        8*a**6*b**10*c**3 - 4*a**9*b**6*c**4 - 19*a**8*b**7*c**4 -
        37*a**7*b**8*c**4 - 35*a**6*b**9*c**4 - 14*a**5*b**10*c**4 -
        7*a**9*b**5*c**5 - 32*a**8*b**6*c**5 - 61*a**7*b**7*c**5 -
        66*a**6*b**8*c**5 - 44*a**5*b**9*c**5 - 14*a**4*b**10*c**5 -
        6*a**9*b**4*c**6 - 36*a**8*b**5*c**6 - 74*a**7*b**6*c**6 -
        87*a**6*b**7*c**6 - 66*a**5*b**8*c**6 - 35*a**4*b**9*c**6 -
        8*a**3*b**10*c**6 - 2*a**9*b**3*c**7 - 20*a**8*b**4*c**7 -
        56*a**7*b**5*c**7 - 74*a**6*b**6*c**7 - 61*a**5*b**7*c**7 -
        37*a**4*b**8*c**7 - 15*a**3*b**9*c**7 - 2*a**2*b**10*c**7 -
        4*a**8*b**3*c**8 - 20*a**7*b**4*c**8 - 36*a**6*b**5*c**8 -
        32*a**5*b**6*c**8 - 19*a**4*b**7*c**8 - 8*a**3*b**8*c**8 -
        2*a**2*b**9*c**8 - 2*a**7*b**3*c**9 - 6*a**6*b**4*c**9 -
        7*a**5*b**5*c**9 - 4*a**4*b**6*c**9 - a**3*b**7*c**9 -
        2*a**8*b**8*c*s**2 - 4*a**7*b**9*c*s**2 - 2*a**6*b**10*c*s**2
        - a**9*b**6*c**2*s**2 - 9*a**8*b**7*c**2*s**2 -
        21*a**7*b**8*c**2*s**2 - 22*a**6*b**9*c**2*s**2 -
        8*a**5*b**10*c**2*s**2 - 4*a**9*b**5*c**3*s**2 -
        22*a**8*b**6*c**3*s**2 - 47*a**7*b**7*c**3*s**2 -
        61*a**6*b**8*c**3*s**2 - 49*a**5*b**9*c**3*s**2 -
        14*a**4*b**10*c**3*s**2 - 7*a**9*b**4*c**4*s**2 -
        33*a**8*b**5*c**4*s**2 - 74*a**7*b**6*c**4*s**2 -
        91*a**6*b**7*c**4*s**2 - 90*a**5*b**8*c**4*s**2 -
        61*a**4*b**9*c**4*s**2 - 14*a**3*b**10*c**4*s**2 -
        6*a**9*b**3*c**5*s**2 - 37*a**8*b**4*c**5*s**2 -
        89*a**7*b**5*c**5*s**2 - 116*a**6*b**6*c**5*s**2 -
        108*a**5*b**7*c**5*s**2 - 90*a**4*b**8*c**5*s**2 -
        49*a**3*b**9*c**5*s**2 - 8*a**2*b**10*c**5*s**2 -
        2*a**9*b**2*c**6*s**2 - 26*a**8*b**3*c**6*s**2 -
        81*a**7*b**4*c**6*s**2 - 118*a**6*b**5*c**6*s**2 -
        116*a**5*b**6*c**6*s**2 - 91*a**4*b**7*c**6*s**2 -
        61*a**3*b**8*c**6*s**2 - 22*a**2*b**9*c**6*s**2 -
        2*a*b**10*c**6*s**2 - 7*a**8*b**2*c**7*s**2 -
        41*a**7*b**3*c**7*s**2 - 81*a**6*b**4*c**7*s**2 -
        89*a**5*b**5*c**7*s**2 - 74*a**4*b**6*c**7*s**2 -
        47*a**3*b**7*c**7*s**2 - 21*a**2*b**8*c**7*s**2 -
        4*a*b**9*c**7*s**2 - 7*a**7*b**2*c**8*s**2 -
        26*a**6*b**3*c**8*s**2 - 37*a**5*b**4*c**8*s**2 -
        33*a**4*b**5*c**8*s**2 - 22*a**3*b**6*c**8*s**2 -
        9*a**2*b**7*c**8*s**2 - 2*a*b**8*c**8*s**2 -
        2*a**6*b**2*c**9*s**2 - 6*a**5*b**3*c**9*s**2 -
        7*a**4*b**4*c**9*s**2 - 4*a**3*b**5*c**9*s**2 -
        a**2*b**6*c**9*s**2 + 6*a**7*b**7*c*s**4 + 9*a**6*b**8*c*s**4
        + 5*a**5*b**9*c*s**4 + 4*a**8*b**5*c**2*s**4 +
        28*a**7*b**6*c**2*s**4 + 66*a**6*b**7*c**2*s**4 +
        53*a**5*b**8*c**2*s**4 + 14*a**4*b**9*c**2*s**4 +
        17*a**8*b**4*c**3*s**4 + 84*a**7*b**5*c**3*s**4 +
        188*a**6*b**6*c**3*s**4 + 215*a**5*b**7*c**3*s**4 +
        106*a**4*b**8*c**3*s**4 + 19*a**3*b**9*c**3*s**4 +
        21*a**8*b**3*c**4*s**4 + 141*a**7*b**4*c**4*s**4 +
        331*a**6*b**5*c**4*s**4 + 429*a**5*b**6*c**4*s**4 +
        305*a**4*b**7*c**4*s**4 + 106*a**3*b**8*c**4*s**4 +
        14*a**2*b**9*c**4*s**4 + 8*a**8*b**2*c**5*s**4 +
        102*a**7*b**3*c**5*s**4 + 342*a**6*b**4*c**5*s**4 +
        510*a**5*b**5*c**5*s**4 + 429*a**4*b**6*c**5*s**4 +
        215*a**3*b**7*c**5*s**4 + 53*a**2*b**8*c**5*s**4 +
        5*a*b**9*c**5*s**4 + 23*a**7*b**2*c**6*s**4 +
        158*a**6*b**3*c**6*s**4 + 342*a**5*b**4*c**6*s**4 +
        331*a**4*b**5*c**6*s**4 + 188*a**3*b**6*c**6*s**4 +
        66*a**2*b**7*c**6*s**4 + 9*a*b**8*c**6*s**4 +
        23*a**6*b**2*c**7*s**4 + 102*a**5*b**3*c**7*s**4 +
        141*a**4*b**4*c**7*s**4 + 84*a**3*b**5*c**7*s**4 +
        28*a**2*b**6*c**7*s**4 + 6*a*b**7*c**7*s**4 +
        8*a**5*b**2*c**8*s**4 + 21*a**4*b**3*c**8*s**4 +
        17*a**3*b**4*c**8*s**4 + 4*a**2*b**5*c**8*s**4 -
        a**5*b**7*c*s**6 - a**4*b**8*c*s**6 + a**7*b**4*c**2*s**6 +
        a**6*b**5*c**2*s**6 - 3*a**5*b**6*c**2*s**6 -
        6*a**4*b**7*c**2*s**6 - 2*a**3*b**8*c**2*s**6 -
        a**7*b**3*c**3*s**6 - 5*a**5*b**5*c**3*s**6 -
        11*a**4*b**6*c**3*s**6 - 9*a**3*b**7*c**3*s**6 -
        2*a**2*b**8*c**3*s**6 - 2*a**7*b**2*c**4*s**6 -
        7*a**6*b**3*c**4*s**6 - 12*a**5*b**4*c**4*s**6 -
        13*a**4*b**5*c**4*s**6 - 11*a**3*b**6*c**4*s**6 -
        6*a**2*b**7*c**4*s**6 - a*b**8*c**4*s**6 -
        3*a**6*b**2*c**5*s**6 - 12*a**5*b**3*c**5*s**6 -
        12*a**4*b**4*c**5*s**6 - 5*a**3*b**5*c**5*s**6 -
        3*a**2*b**6*c**5*s**6 - a*b**7*c**5*s**6 -
        3*a**5*b**2*c**6*s**6 - 7*a**4*b**3*c**6*s**6 +
        a**2*b**5*c**6*s**6 - 2*a**4*b**2*c**7*s**6 -
        a**3*b**3*c**7*s**6 + a**2*b**4*c**7*s**6)/(a**8*b**8*s**3 -
        a**7*b**9*s**3 + a**9*b**6*c*s**3 - a**8*b**7*c*s**3 -
        a**7*b**8*c*s**3 + a**6*b**9*c*s**3 - a**5*b**10*c*s**3 +
        a**4*b**11*c*s**3 + a**10*b**4*c**2*s**3 - a**9*b**5*c**2*s**3
        - 2*a**8*b**6*c**2*s**3 + a**7*b**7*c**2*s**3 -
        a**6*b**8*c**2*s**3 + 2*a**5*b**9*c**2*s**3 +
        a**4*b**10*c**2*s**3 - a**3*b**11*c**2*s**3 -
        2*a**9*b**4*c**3*s**3 + a**8*b**5*c**3*s**3 +
        3*a**6*b**7*c**3*s**3 + a**5*b**8*c**3*s**3 -
        2*a**4*b**9*c**3*s**3 - a**2*b**11*c**3*s**3 -
        a**10*b**2*c**4*s**3 + a**8*b**4*c**4*s**3 +
        2*a**7*b**5*c**4*s**3 + a**6*b**6*c**4*s**3 -
        3*a**5*b**7*c**4*s**3 - 2*a**3*b**9*c**4*s**3 +
        a**2*b**10*c**4*s**3 + a*b**11*c**4*s**3 + a**9*b**2*c**5*s**3
        + a**8*b**3*c**5*s**3 + a**7*b**4*c**5*s**3 -
        2*a**6*b**5*c**5*s**3 - 3*a**4*b**7*c**5*s**3 +
        a**3*b**8*c**5*s**3 + 2*a**2*b**9*c**5*s**3 -
        a*b**10*c**5*s**3 + a**8*b**2*c**6*s**3 - a**7*b**3*c**6*s**3
        - 2*a**6*b**4*c**6*s**3 - 2*a**5*b**5*c**6*s**3 +
        a**4*b**6*c**6*s**3 + 3*a**3*b**7*c**6*s**3 -
        a**2*b**8*c**6*s**3 + a*b**9*c**6*s**3 + a**9*c**7*s**3 -
        2*a**7*b**2*c**7*s**3 - a**6*b**3*c**7*s**3 +
        a**5*b**4*c**7*s**3 + 2*a**4*b**5*c**7*s**3 +
        a**2*b**7*c**7*s**3 - a*b**8*c**7*s**3 - b**9*c**7*s**3 -
        2*a**8*c**8*s**3 + a**6*b**2*c**8*s**3 + a**5*b**3*c**8*s**3 +
        a**4*b**4*c**8*s**3 + a**3*b**5*c**8*s**3 -
        2*a**2*b**6*c**8*s**3 - a*b**7*c**8*s**3 + b**8*c**8*s**3 +
        a**7*c**9*s**3 + a**5*b**2*c**9*s**3 - 2*a**3*b**4*c**9*s**3 -
        a**2*b**5*c**9*s**3 + a*b**6*c**9*s**3 - a**4*b**2*c**10*s**3
        + a**2*b**4*c**10*s**3), (a**8*b**7*c**2 + a**7*b**8*c**2 +
        (1/3*zeta3 + 11/3)*a**8*b**6*c**3 + (2/3*zeta3 +
        22/3)*a**7*b**7*c**3 + (1/3*zeta3 + 11/3)*a**6*b**8*c**3 +
        (2/3*zeta3 + 16/3)*a**8*b**5*c**4 + (10/3*zeta3 +
        53/3)*a**7*b**6*c**4 + (10/3*zeta3 + 53/3)*a**6*b**7*c**4 +
        (2/3*zeta3 + 16/3)*a**5*b**8*c**4 + (2/3*zeta3 +
        16/3)*a**8*b**4*c**5 + (17/3*zeta3 + 67/3)*a**7*b**5*c**5 +
        (8*zeta3 + 33)*a**6*b**6*c**5 + (17/3*zeta3 +
        67/3)*a**5*b**7*c**5 + (2/3*zeta3 + 16/3)*a**4*b**8*c**5 +
        (1/3*zeta3 + 11/3)*a**8*b**3*c**6 + (10/3*zeta3 +
        53/3)*a**7*b**4*c**6 + (8*zeta3 + 33)*a**6*b**5*c**6 +
        (8*zeta3 + 33)*a**5*b**6*c**6 + (10/3*zeta3 +
        53/3)*a**4*b**7*c**6 + (1/3*zeta3 + 11/3)*a**3*b**8*c**6 +
        a**8*b**2*c**7 + (2/3*zeta3 + 22/3)*a**7*b**3*c**7 +
        (10/3*zeta3 + 53/3)*a**6*b**4*c**7 + (17/3*zeta3 +
        67/3)*a**5*b**5*c**7 + (10/3*zeta3 + 53/3)*a**4*b**6*c**7 +
        (2/3*zeta3 + 22/3)*a**3*b**7*c**7 + a**2*b**8*c**7 +
        a**7*b**2*c**8 + (1/3*zeta3 + 11/3)*a**6*b**3*c**8 +
        (2/3*zeta3 + 16/3)*a**5*b**4*c**8 + (2/3*zeta3 +
        16/3)*a**4*b**5*c**8 + (1/3*zeta3 + 11/3)*a**3*b**6*c**8 +
        a**2*b**7*c**8 + a**8*b**6*c*s**2 + 2*a**7*b**7*c*s**2 +
        a**6*b**8*c*s**2 + (1/3*zeta3 + 11/3)*a**8*b**5*c**2*s**2 +
        (zeta3 + 10)*a**7*b**6*c**2*s**2 + (zeta3 +
        10)*a**6*b**7*c**2*s**2 + (1/3*zeta3 +
        11/3)*a**5*b**8*c**2*s**2 + (2/3*zeta3 +
        16/3)*a**8*b**4*c**3*s**2 + (7/3*zeta3 +
        53/3)*a**7*b**5*c**3*s**2 + (5*zeta3 + 25)*a**6*b**6*c**3*s**2
        + (7/3*zeta3 + 53/3)*a**5*b**7*c**3*s**2 + (2/3*zeta3 +
        16/3)*a**4*b**8*c**3*s**2 + (2/3*zeta3 +
        16/3)*a**8*b**3*c**4*s**2 + (8/3*zeta3 +
        55/3)*a**7*b**4*c**4*s**2 + (22/3*zeta3 +
        86/3)*a**6*b**5*c**4*s**2 + (22/3*zeta3 +
        86/3)*a**5*b**6*c**4*s**2 + (8/3*zeta3 +
        55/3)*a**4*b**7*c**4*s**2 + (2/3*zeta3 +
        16/3)*a**3*b**8*c**4*s**2 + (1/3*zeta3 +
        11/3)*a**8*b**2*c**5*s**2 + (7/3*zeta3 +
        53/3)*a**7*b**3*c**5*s**2 + (22/3*zeta3 +
        86/3)*a**6*b**4*c**5*s**2 + (9*zeta3 + 30)*a**5*b**5*c**5*s**2
        + (22/3*zeta3 + 86/3)*a**4*b**6*c**5*s**2 + (7/3*zeta3 +
        53/3)*a**3*b**7*c**5*s**2 + (1/3*zeta3 +
        11/3)*a**2*b**8*c**5*s**2 + a**8*b*c**6*s**2 + (zeta3 +
        10)*a**7*b**2*c**6*s**2 + (5*zeta3 + 25)*a**6*b**3*c**6*s**2 +
        (22/3*zeta3 + 86/3)*a**5*b**4*c**6*s**2 + (22/3*zeta3 +
        86/3)*a**4*b**5*c**6*s**2 + (5*zeta3 + 25)*a**3*b**6*c**6*s**2
        + (zeta3 + 10)*a**2*b**7*c**6*s**2 + a*b**8*c**6*s**2 +
        2*a**7*b*c**7*s**2 + (zeta3 + 10)*a**6*b**2*c**7*s**2 +
        (7/3*zeta3 + 53/3)*a**5*b**3*c**7*s**2 + (8/3*zeta3 +
        55/3)*a**4*b**4*c**7*s**2 + (7/3*zeta3 +
        53/3)*a**3*b**5*c**7*s**2 + (zeta3 + 10)*a**2*b**6*c**7*s**2 +
        2*a*b**7*c**7*s**2 + a**6*b*c**8*s**2 + (1/3*zeta3 +
        11/3)*a**5*b**2*c**8*s**2 + (2/3*zeta3 +
        16/3)*a**4*b**3*c**8*s**2 + (2/3*zeta3 +
        16/3)*a**3*b**4*c**8*s**2 + (1/3*zeta3 +
        11/3)*a**2*b**5*c**8*s**2 + a*b**6*c**8*s**2 + (-2/3*zeta3 -
        10/3)*a**7*b**5*c*s**4 + (-5/3*zeta3 - 19/3)*a**6*b**6*c*s**4
        + (-2/3*zeta3 - 10/3)*a**5*b**7*c*s**4 + (-16/3*zeta3 -
        41/3)*a**7*b**4*c**2*s**4 + (-50/3*zeta3 -
        133/3)*a**6*b**5*c**2*s**4 + (-50/3*zeta3 -
        133/3)*a**5*b**6*c**2*s**4 + (-16/3*zeta3 -
        41/3)*a**4*b**7*c**2*s**4 + (-9*zeta3 -
        21)*a**7*b**3*c**3*s**4 + (-47*zeta3 -
        102)*a**6*b**4*c**3*s**4 + (-217/3*zeta3 -
        488/3)*a**5*b**5*c**3*s**4 + (-47*zeta3 -
        102)*a**4*b**6*c**3*s**4 + (-9*zeta3 - 21)*a**3*b**7*c**3*s**4
        + (-16/3*zeta3 - 41/3)*a**7*b**2*c**4*s**4 + (-47*zeta3 -
        102)*a**6*b**3*c**4*s**4 + (-349/3*zeta3 -
        728/3)*a**5*b**4*c**4*s**4 + (-349/3*zeta3 -
        728/3)*a**4*b**5*c**4*s**4 + (-47*zeta3 -
        102)*a**3*b**6*c**4*s**4 + (-16/3*zeta3 -
        41/3)*a**2*b**7*c**4*s**4 + (-2/3*zeta3 -
        10/3)*a**7*b*c**5*s**4 + (-50/3*zeta3 -
        133/3)*a**6*b**2*c**5*s**4 + (-217/3*zeta3 -
        488/3)*a**5*b**3*c**5*s**4 + (-349/3*zeta3 -
        728/3)*a**4*b**4*c**5*s**4 + (-217/3*zeta3 -
        488/3)*a**3*b**5*c**5*s**4 + (-50/3*zeta3 -
        133/3)*a**2*b**6*c**5*s**4 + (-2/3*zeta3 -
        10/3)*a*b**7*c**5*s**4 + (-5/3*zeta3 - 19/3)*a**6*b*c**6*s**4
        + (-50/3*zeta3 - 133/3)*a**5*b**2*c**6*s**4 + (-47*zeta3 -
        102)*a**4*b**3*c**6*s**4 + (-47*zeta3 -
        102)*a**3*b**4*c**6*s**4 + (-50/3*zeta3 -
        133/3)*a**2*b**5*c**6*s**4 + (-5/3*zeta3 -
        19/3)*a*b**6*c**6*s**4 + (-2/3*zeta3 - 10/3)*a**5*b*c**7*s**4
        + (-16/3*zeta3 - 41/3)*a**4*b**2*c**7*s**4 + (-9*zeta3 -
        21)*a**3*b**3*c**7*s**4 + (-16/3*zeta3 -
        41/3)*a**2*b**4*c**7*s**4 + (-2/3*zeta3 -
        10/3)*a*b**5*c**7*s**4 + (-2/3*zeta3 - 1/3)*a**6*b**4*c*s**6 +
        (-5/3*zeta3 - 4/3)*a**5*b**5*c*s**6 + (-2/3*zeta3 -
        1/3)*a**4*b**6*c*s**6 + (-2/3*zeta3 - 1/3)*a**6*b**3*c**2*s**6
        + (-8/3*zeta3 - 4/3)*a**5*b**4*c**2*s**6 + (-8/3*zeta3 -
        4/3)*a**4*b**5*c**2*s**6 + (-2/3*zeta3 -
        1/3)*a**3*b**6*c**2*s**6 + (-2/3*zeta3 -
        1/3)*a**6*b**2*c**3*s**6 + (-2/3*zeta3 +
        2/3)*a**5*b**3*c**3*s**6 + (zeta3 + 2)*a**4*b**4*c**3*s**6 +
        (-2/3*zeta3 + 2/3)*a**3*b**5*c**3*s**6 + (-2/3*zeta3 -
        1/3)*a**2*b**6*c**3*s**6 + (-2/3*zeta3 - 1/3)*a**6*b*c**4*s**6
        + (-8/3*zeta3 - 4/3)*a**5*b**2*c**4*s**6 + (zeta3 +
        2)*a**4*b**3*c**4*s**6 + (zeta3 + 2)*a**3*b**4*c**4*s**6 +
        (-8/3*zeta3 - 4/3)*a**2*b**5*c**4*s**6 + (-2/3*zeta3 -
        1/3)*a*b**6*c**4*s**6 + (-5/3*zeta3 - 4/3)*a**5*b*c**5*s**6 +
        (-8/3*zeta3 - 4/3)*a**4*b**2*c**5*s**6 + (-2/3*zeta3 +
        2/3)*a**3*b**3*c**5*s**6 + (-8/3*zeta3 -
        4/3)*a**2*b**4*c**5*s**6 + (-5/3*zeta3 - 4/3)*a*b**5*c**5*s**6
        + (-2/3*zeta3 - 1/3)*a**4*b*c**6*s**6 + (-2/3*zeta3 -
        1/3)*a**3*b**2*c**6*s**6 + (-2/3*zeta3 -
        1/3)*a**2*b**3*c**6*s**6 + (-2/3*zeta3 -
        1/3)*a*b**4*c**6*s**6)/(a**8*b**6*s**3 - a**7*b**7*s**3 +
        a**6*b**8*s**3 + (zeta3 + 1)*a**9*b**4*c*s**3 + (-zeta3 -
        1)*a**8*b**5*c*s**3 + (zeta3 + 1)*a**7*b**6*c*s**3 + (zeta3 +
        1)*a**6*b**7*c*s**3 + (-zeta3 - 1)*a**5*b**8*c*s**3 + (zeta3 +
        1)*a**4*b**9*c*s**3 - a**7*b**5*c**2*s**3 +
        a**6*b**6*c**2*s**3 - a**5*b**7*c**2*s**3 + (-zeta3 +
        1)*a**8*b**3*c**3*s**3 + zeta3*a**7*b**4*c**3*s**3 + (-zeta3 +
        1)*a**6*b**5*c**3*s**3 + (-zeta3 + 1)*a**5*b**6*c**3*s**3 +
        zeta3*a**4*b**7*c**3*s**3 + (-zeta3 + 1)*a**3*b**8*c**3*s**3 +
        (zeta3 + 1)*a**9*b*c**4*s**3 + zeta3*a**7*b**3*c**4*s**3 +
        (3*zeta3 + 3)*a**6*b**4*c**4*s**3 + (-zeta3 -
        2)*a**5*b**5*c**4*s**3 + (3*zeta3 + 3)*a**4*b**6*c**4*s**3 +
        zeta3*a**3*b**7*c**4*s**3 + (zeta3 + 1)*a*b**9*c**4*s**3 +
        (-zeta3 - 1)*a**8*b*c**5*s**3 - a**7*b**2*c**5*s**3 + (-zeta3
        + 1)*a**6*b**3*c**5*s**3 + (-zeta3 - 2)*a**5*b**4*c**5*s**3 +
        (-zeta3 - 2)*a**4*b**5*c**5*s**3 + (-zeta3 +
        1)*a**3*b**6*c**5*s**3 - a**2*b**7*c**5*s**3 + (-zeta3 -
        1)*a*b**8*c**5*s**3 + a**8*c**6*s**3 + (zeta3 +
        1)*a**7*b*c**6*s**3 + a**6*b**2*c**6*s**3 + (-zeta3 +
        1)*a**5*b**3*c**6*s**3 + (3*zeta3 + 3)*a**4*b**4*c**6*s**3 +
        (-zeta3 + 1)*a**3*b**5*c**6*s**3 + a**2*b**6*c**6*s**3 +
        (zeta3 + 1)*a*b**7*c**6*s**3 + b**8*c**6*s**3 - a**7*c**7*s**3
        + (zeta3 + 1)*a**6*b*c**7*s**3 - a**5*b**2*c**7*s**3 +
        zeta3*a**4*b**3*c**7*s**3 + zeta3*a**3*b**4*c**7*s**3 -
        a**2*b**5*c**7*s**3 + (zeta3 + 1)*a*b**6*c**7*s**3 -
        b**7*c**7*s**3 + a**6*c**8*s**3 + (-zeta3 -
        1)*a**5*b*c**8*s**3 + (-zeta3 + 1)*a**3*b**3*c**8*s**3 +
        (-zeta3 - 1)*a*b**5*c**8*s**3 + b**6*c**8*s**3 + (zeta3 +
        1)*a**4*b*c**9*s**3 + (zeta3 + 1)*a*b**4*c**9*s**3),
        (a**8*b**7*c**2 + a**7*b**8*c**2 + (-1/3*zeta3 +
        10/3)*a**8*b**6*c**3 + (-2/3*zeta3 + 20/3)*a**7*b**7*c**3 +
        (-1/3*zeta3 + 10/3)*a**6*b**8*c**3 + (-2/3*zeta3 +
        14/3)*a**8*b**5*c**4 + (-10/3*zeta3 + 43/3)*a**7*b**6*c**4 +
        (-10/3*zeta3 + 43/3)*a**6*b**7*c**4 + (-2/3*zeta3 +
        14/3)*a**5*b**8*c**4 + (-2/3*zeta3 + 14/3)*a**8*b**4*c**5 +
        (-17/3*zeta3 + 50/3)*a**7*b**5*c**5 + (-8*zeta3 +
        25)*a**6*b**6*c**5 + (-17/3*zeta3 + 50/3)*a**5*b**7*c**5 +
        (-2/3*zeta3 + 14/3)*a**4*b**8*c**5 + (-1/3*zeta3 +
        10/3)*a**8*b**3*c**6 + (-10/3*zeta3 + 43/3)*a**7*b**4*c**6 +
        (-8*zeta3 + 25)*a**6*b**5*c**6 + (-8*zeta3 +
        25)*a**5*b**6*c**6 + (-10/3*zeta3 + 43/3)*a**4*b**7*c**6 +
        (-1/3*zeta3 + 10/3)*a**3*b**8*c**6 + a**8*b**2*c**7 +
        (-2/3*zeta3 + 20/3)*a**7*b**3*c**7 + (-10/3*zeta3 +
        43/3)*a**6*b**4*c**7 + (-17/3*zeta3 + 50/3)*a**5*b**5*c**7 +
        (-10/3*zeta3 + 43/3)*a**4*b**6*c**7 + (-2/3*zeta3 +
        20/3)*a**3*b**7*c**7 + a**2*b**8*c**7 + a**7*b**2*c**8 +
        (-1/3*zeta3 + 10/3)*a**6*b**3*c**8 + (-2/3*zeta3 +
        14/3)*a**5*b**4*c**8 + (-2/3*zeta3 + 14/3)*a**4*b**5*c**8 +
        (-1/3*zeta3 + 10/3)*a**3*b**6*c**8 + a**2*b**7*c**8 +
        a**8*b**6*c*s**2 + 2*a**7*b**7*c*s**2 + a**6*b**8*c*s**2 +
        (-1/3*zeta3 + 10/3)*a**8*b**5*c**2*s**2 + (-zeta3 +
        9)*a**7*b**6*c**2*s**2 + (-zeta3 + 9)*a**6*b**7*c**2*s**2 +
        (-1/3*zeta3 + 10/3)*a**5*b**8*c**2*s**2 + (-2/3*zeta3 +
        14/3)*a**8*b**4*c**3*s**2 + (-7/3*zeta3 +
        46/3)*a**7*b**5*c**3*s**2 + (-5*zeta3 +
        20)*a**6*b**6*c**3*s**2 + (-7/3*zeta3 +
        46/3)*a**5*b**7*c**3*s**2 + (-2/3*zeta3 +
        14/3)*a**4*b**8*c**3*s**2 + (-2/3*zeta3 +
        14/3)*a**8*b**3*c**4*s**2 + (-8/3*zeta3 +
        47/3)*a**7*b**4*c**4*s**2 + (-22/3*zeta3 +
        64/3)*a**6*b**5*c**4*s**2 + (-22/3*zeta3 +
        64/3)*a**5*b**6*c**4*s**2 + (-8/3*zeta3 +
        47/3)*a**4*b**7*c**4*s**2 + (-2/3*zeta3 +
        14/3)*a**3*b**8*c**4*s**2 + (-1/3*zeta3 +
        10/3)*a**8*b**2*c**5*s**2 + (-7/3*zeta3 +
        46/3)*a**7*b**3*c**5*s**2 + (-22/3*zeta3 +
        64/3)*a**6*b**4*c**5*s**2 + (-9*zeta3 +
        21)*a**5*b**5*c**5*s**2 + (-22/3*zeta3 +
        64/3)*a**4*b**6*c**5*s**2 + (-7/3*zeta3 +
        46/3)*a**3*b**7*c**5*s**2 + (-1/3*zeta3 +
        10/3)*a**2*b**8*c**5*s**2 + a**8*b*c**6*s**2 + (-zeta3 +
        9)*a**7*b**2*c**6*s**2 + (-5*zeta3 + 20)*a**6*b**3*c**6*s**2 +
        (-22/3*zeta3 + 64/3)*a**5*b**4*c**6*s**2 + (-22/3*zeta3 +
        64/3)*a**4*b**5*c**6*s**2 + (-5*zeta3 +
        20)*a**3*b**6*c**6*s**2 + (-zeta3 + 9)*a**2*b**7*c**6*s**2 +
        a*b**8*c**6*s**2 + 2*a**7*b*c**7*s**2 + (-zeta3 +
        9)*a**6*b**2*c**7*s**2 + (-7/3*zeta3 +
        46/3)*a**5*b**3*c**7*s**2 + (-8/3*zeta3 +
        47/3)*a**4*b**4*c**7*s**2 + (-7/3*zeta3 +
        46/3)*a**3*b**5*c**7*s**2 + (-zeta3 + 9)*a**2*b**6*c**7*s**2 +
        2*a*b**7*c**7*s**2 + a**6*b*c**8*s**2 + (-1/3*zeta3 +
        10/3)*a**5*b**2*c**8*s**2 + (-2/3*zeta3 +
        14/3)*a**4*b**3*c**8*s**2 + (-2/3*zeta3 +
        14/3)*a**3*b**4*c**8*s**2 + (-1/3*zeta3 +
        10/3)*a**2*b**5*c**8*s**2 + a*b**6*c**8*s**2 + (2/3*zeta3 -
        8/3)*a**7*b**5*c*s**4 + (5/3*zeta3 - 14/3)*a**6*b**6*c*s**4 +
        (2/3*zeta3 - 8/3)*a**5*b**7*c*s**4 + (16/3*zeta3 -
        25/3)*a**7*b**4*c**2*s**4 + (50/3*zeta3 -
        83/3)*a**6*b**5*c**2*s**4 + (50/3*zeta3 -
        83/3)*a**5*b**6*c**2*s**4 + (16/3*zeta3 -
        25/3)*a**4*b**7*c**2*s**4 + (9*zeta3 - 12)*a**7*b**3*c**3*s**4
        + (47*zeta3 - 55)*a**6*b**4*c**3*s**4 + (217/3*zeta3 -
        271/3)*a**5*b**5*c**3*s**4 + (47*zeta3 -
        55)*a**4*b**6*c**3*s**4 + (9*zeta3 - 12)*a**3*b**7*c**3*s**4 +
        (16/3*zeta3 - 25/3)*a**7*b**2*c**4*s**4 + (47*zeta3 -
        55)*a**6*b**3*c**4*s**4 + (349/3*zeta3 -
        379/3)*a**5*b**4*c**4*s**4 + (349/3*zeta3 -
        379/3)*a**4*b**5*c**4*s**4 + (47*zeta3 -
        55)*a**3*b**6*c**4*s**4 + (16/3*zeta3 -
        25/3)*a**2*b**7*c**4*s**4 + (2/3*zeta3 - 8/3)*a**7*b*c**5*s**4
        + (50/3*zeta3 - 83/3)*a**6*b**2*c**5*s**4 + (217/3*zeta3 -
        271/3)*a**5*b**3*c**5*s**4 + (349/3*zeta3 -
        379/3)*a**4*b**4*c**5*s**4 + (217/3*zeta3 -
        271/3)*a**3*b**5*c**5*s**4 + (50/3*zeta3 -
        83/3)*a**2*b**6*c**5*s**4 + (2/3*zeta3 - 8/3)*a*b**7*c**5*s**4
        + (5/3*zeta3 - 14/3)*a**6*b*c**6*s**4 + (50/3*zeta3 -
        83/3)*a**5*b**2*c**6*s**4 + (47*zeta3 -
        55)*a**4*b**3*c**6*s**4 + (47*zeta3 - 55)*a**3*b**4*c**6*s**4
        + (50/3*zeta3 - 83/3)*a**2*b**5*c**6*s**4 + (5/3*zeta3 -
        14/3)*a*b**6*c**6*s**4 + (2/3*zeta3 - 8/3)*a**5*b*c**7*s**4 +
        (16/3*zeta3 - 25/3)*a**4*b**2*c**7*s**4 + (9*zeta3 -
        12)*a**3*b**3*c**7*s**4 + (16/3*zeta3 -
        25/3)*a**2*b**4*c**7*s**4 + (2/3*zeta3 - 8/3)*a*b**5*c**7*s**4
        + (2/3*zeta3 + 1/3)*a**6*b**4*c*s**6 + (5/3*zeta3 +
        1/3)*a**5*b**5*c*s**6 + (2/3*zeta3 + 1/3)*a**4*b**6*c*s**6 +
        (2/3*zeta3 + 1/3)*a**6*b**3*c**2*s**6 + (8/3*zeta3 +
        4/3)*a**5*b**4*c**2*s**6 + (8/3*zeta3 +
        4/3)*a**4*b**5*c**2*s**6 + (2/3*zeta3 +
        1/3)*a**3*b**6*c**2*s**6 + (2/3*zeta3 +
        1/3)*a**6*b**2*c**3*s**6 + (2/3*zeta3 +
        4/3)*a**5*b**3*c**3*s**6 + (-zeta3 + 1)*a**4*b**4*c**3*s**6 +
        (2/3*zeta3 + 4/3)*a**3*b**5*c**3*s**6 + (2/3*zeta3 +
        1/3)*a**2*b**6*c**3*s**6 + (2/3*zeta3 + 1/3)*a**6*b*c**4*s**6
        + (8/3*zeta3 + 4/3)*a**5*b**2*c**4*s**6 + (-zeta3 +
        1)*a**4*b**3*c**4*s**6 + (-zeta3 + 1)*a**3*b**4*c**4*s**6 +
        (8/3*zeta3 + 4/3)*a**2*b**5*c**4*s**6 + (2/3*zeta3 +
        1/3)*a*b**6*c**4*s**6 + (5/3*zeta3 + 1/3)*a**5*b*c**5*s**6 +
        (8/3*zeta3 + 4/3)*a**4*b**2*c**5*s**6 + (2/3*zeta3 +
        4/3)*a**3*b**3*c**5*s**6 + (8/3*zeta3 +
        4/3)*a**2*b**4*c**5*s**6 + (5/3*zeta3 + 1/3)*a*b**5*c**5*s**6
        + (2/3*zeta3 + 1/3)*a**4*b*c**6*s**6 + (2/3*zeta3 +
        1/3)*a**3*b**2*c**6*s**6 + (2/3*zeta3 +
        1/3)*a**2*b**3*c**6*s**6 + (2/3*zeta3 +
        1/3)*a*b**4*c**6*s**6)/(a**8*b**6*s**3 - a**7*b**7*s**3 +
        a**6*b**8*s**3 + (-zeta3)*a**9*b**4*c*s**3 +
        zeta3*a**8*b**5*c*s**3 + (-zeta3)*a**7*b**6*c*s**3 +
        (-zeta3)*a**6*b**7*c*s**3 + zeta3*a**5*b**8*c*s**3 +
        (-zeta3)*a**4*b**9*c*s**3 - a**7*b**5*c**2*s**3 +
        a**6*b**6*c**2*s**3 - a**5*b**7*c**2*s**3 + (zeta3 +
        2)*a**8*b**3*c**3*s**3 + (-zeta3 - 1)*a**7*b**4*c**3*s**3 +
        (zeta3 + 2)*a**6*b**5*c**3*s**3 + (zeta3 +
        2)*a**5*b**6*c**3*s**3 + (-zeta3 - 1)*a**4*b**7*c**3*s**3 +
        (zeta3 + 2)*a**3*b**8*c**3*s**3 + (-zeta3)*a**9*b*c**4*s**3 +
        (-zeta3 - 1)*a**7*b**3*c**4*s**3 +
        (-3*zeta3)*a**6*b**4*c**4*s**3 + (zeta3 -
        1)*a**5*b**5*c**4*s**3 + (-3*zeta3)*a**4*b**6*c**4*s**3 +
        (-zeta3 - 1)*a**3*b**7*c**4*s**3 + (-zeta3)*a*b**9*c**4*s**3 +
        zeta3*a**8*b*c**5*s**3 - a**7*b**2*c**5*s**3 + (zeta3 +
        2)*a**6*b**3*c**5*s**3 + (zeta3 - 1)*a**5*b**4*c**5*s**3 +
        (zeta3 - 1)*a**4*b**5*c**5*s**3 + (zeta3 +
        2)*a**3*b**6*c**5*s**3 - a**2*b**7*c**5*s**3 +
        zeta3*a*b**8*c**5*s**3 + a**8*c**6*s**3 +
        (-zeta3)*a**7*b*c**6*s**3 + a**6*b**2*c**6*s**3 + (zeta3 +
        2)*a**5*b**3*c**6*s**3 + (-3*zeta3)*a**4*b**4*c**6*s**3 +
        (zeta3 + 2)*a**3*b**5*c**6*s**3 + a**2*b**6*c**6*s**3 +
        (-zeta3)*a*b**7*c**6*s**3 + b**8*c**6*s**3 - a**7*c**7*s**3 +
        (-zeta3)*a**6*b*c**7*s**3 - a**5*b**2*c**7*s**3 + (-zeta3 -
        1)*a**4*b**3*c**7*s**3 + (-zeta3 - 1)*a**3*b**4*c**7*s**3 -
        a**2*b**5*c**7*s**3 + (-zeta3)*a*b**6*c**7*s**3 -
        b**7*c**7*s**3 + a**6*c**8*s**3 + zeta3*a**5*b*c**8*s**3 +
        (zeta3 + 2)*a**3*b**3*c**8*s**3 + zeta3*a*b**5*c**8*s**3 +
        b**6*c**8*s**3 + (-zeta3)*a**4*b*c**9*s**3 +
        (-zeta3)*a*b**4*c**9*s**3)], 'U2': [(-2*a**20*b**7*c -
        2*a**19*b**8*c - 11*a**20*b**6*c**2 - 11*a**19*b**7*c**2 -
        11*a**18*b**8*c**2 - 26*a**20*b**5*c**3 - 24*a**19*b**6*c**3 -
        47*a**18*b**7*c**3 - 10*a**17*b**8*c**3 - 8*a**16*b**9*c**3 +
        a**15*b**10*c**3 - 34*a**20*b**4*c**4 - 31*a**19*b**5*c**4 -
        86*a**18*b**6*c**4 - 28*a**17*b**7*c**4 - 46*a**16*b**8*c**4 +
        4*a**15*b**9*c**4 - 10*a**14*b**10*c**4 + a**13*b**11*c**4 -
        26*a**20*b**3*c**5 - 31*a**19*b**4*c**5 - 100*a**18*b**5*c**5
        - 33*a**17*b**6*c**5 - 103*a**16*b**7*c**5 + 5*a**15*b**8*c**5
        - 42*a**14*b**9*c**5 + 2*a**13*b**10*c**5 - 8*a**12*b**11*c**5
        - 11*a**20*b**2*c**6 - 24*a**19*b**3*c**6 - 86*a**18*b**4*c**6
        - 33*a**17*b**5*c**6 - 130*a**16*b**6*c**6 + 3*a**15*b**7*c**6
        - 84*a**14*b**8*c**6 + 12*a**13*b**9*c**6 -
        35*a**12*b**10*c**6 + a**11*b**11*c**6 - 6*a**10*b**12*c**6 -
        2*a**20*b*c**7 - 11*a**19*b**2*c**7 - 47*a**18*b**3*c**7 -
        28*a**17*b**4*c**7 - 103*a**16*b**5*c**7 + 3*a**15*b**6*c**7 -
        104*a**14*b**7*c**7 + 31*a**13*b**8*c**7 - 64*a**12*b**9*c**7
        + 7*a**11*b**10*c**7 - 24*a**10*b**11*c**7 + 2*a**9*b**12*c**7
        - 2*a**19*b*c**8 - 11*a**18*b**2*c**8 - 10*a**17*b**3*c**8 -
        46*a**16*b**4*c**8 + 5*a**15*b**5*c**8 - 84*a**14*b**6*c**8 +
        31*a**13*b**7*c**8 - 74*a**12*b**8*c**8 + 16*a**11*b**9*c**8 -
        51*a**10*b**10*c**8 + a**9*b**11*c**8 - a**8*b**12*c**8 +
        3*a**7*b**13*c**8 - 8*a**16*b**3*c**9 + 4*a**15*b**4*c**9 -
        42*a**14*b**5*c**9 + 12*a**13*b**6*c**9 - 64*a**12*b**7*c**9 +
        16*a**11*b**8*c**9 - 66*a**10*b**9*c**9 - 10*a**9*b**10*c**9 -
        16*a**8*b**11*c**9 + 3*a**7*b**12*c**9 - a**6*b**13*c**9 +
        a**15*b**3*c**10 - 10*a**14*b**4*c**10 + 2*a**13*b**5*c**10 -
        35*a**12*b**6*c**10 + 7*a**11*b**7*c**10 - 51*a**10*b**8*c**10
        - 10*a**9*b**9*c**10 - 30*a**8*b**10*c**10 -
        7*a**7*b**11*c**10 - 4*a**6*b**12*c**10 - a**5*b**13*c**10 +
        a**13*b**4*c**11 - 8*a**12*b**5*c**11 + a**11*b**6*c**11 -
        24*a**10*b**7*c**11 + a**9*b**8*c**11 - 16*a**8*b**9*c**11 -
        7*a**7*b**10*c**11 - 6*a**6*b**11*c**11 + 2*a**4*b**13*c**11 -
        6*a**10*b**6*c**12 + 2*a**9*b**7*c**12 - a**8*b**8*c**12 +
        3*a**7*b**9*c**12 - 4*a**6*b**10*c**12 + 4*a**4*b**12*c**12 -
        a**3*b**13*c**12 + 3*a**7*b**8*c**13 - a**6*b**9*c**13 -
        a**5*b**10*c**13 + 2*a**4*b**11*c**13 - a**3*b**12*c**13 +
        3*a**21*b**4*c*s**2 - 6*a**20*b**5*c*s**2 +
        15*a**19*b**6*c*s**2 + 6*a**18*b**7*c*s**2 +
        9*a**21*b**3*c**2*s**2 - 17*a**20*b**4*c**2*s**2 +
        64*a**19*b**5*c**2*s**2 + 75*a**18*b**6*c**2*s**2 +
        53*a**17*b**7*c**2*s**2 - 6*a**16*b**8*c**2*s**2 -
        2*a**15*b**9*c**2*s**2 + 9*a**21*b**2*c**3*s**2 -
        22*a**20*b**3*c**3*s**2 + 121*a**19*b**4*c**3*s**2 +
        237*a**18*b**5*c**3*s**2 + 297*a**17*b**6*c**3*s**2 +
        58*a**16*b**7*c**3*s**2 + 5*a**15*b**8*c**3*s**2 -
        24*a**14*b**9*c**3*s**2 - 3*a**13*b**10*c**3*s**2 +
        3*a**21*b*c**4*s**2 - 17*a**20*b**2*c**4*s**2 +
        121*a**19*b**3*c**4*s**2 + 336*a**18*b**4*c**4*s**2 +
        622*a**17*b**5*c**4*s**2 + 293*a**16*b**6*c**4*s**2 +
        109*a**15*b**7*c**4*s**2 - 85*a**14*b**8*c**4*s**2 -
        27*a**13*b**9*c**4*s**2 - 25*a**12*b**10*c**4*s**2 -
        2*a**11*b**11*c**4*s**2 - 6*a**20*b*c**5*s**2 +
        64*a**19*b**2*c**5*s**2 + 237*a**18*b**3*c**5*s**2 +
        622*a**17*b**4*c**5*s**2 + 458*a**16*b**5*c**5*s**2 +
        287*a**15*b**6*c**5*s**2 - 114*a**14*b**7*c**5*s**2 -
        45*a**13*b**8*c**5*s**2 - 100*a**12*b**9*c**5*s**2 -
        11*a**11*b**10*c**5*s**2 - 8*a**10*b**11*c**5*s**2 +
        15*a**19*b*c**6*s**2 + 75*a**18*b**2*c**6*s**2 +
        297*a**17*b**3*c**6*s**2 + 293*a**16*b**4*c**6*s**2 +
        287*a**15*b**5*c**6*s**2 - 106*a**14*b**6*c**6*s**2 -
        20*a**13*b**7*c**6*s**2 - 162*a**12*b**8*c**6*s**2 +
        14*a**11*b**9*c**6*s**2 + 24*a**10*b**10*c**6*s**2 +
        39*a**9*b**11*c**6*s**2 + 4*a**8*b**12*c**6*s**2 +
        6*a**18*b*c**7*s**2 + 53*a**17*b**2*c**7*s**2 +
        58*a**16*b**3*c**7*s**2 + 109*a**15*b**4*c**7*s**2 -
        114*a**14*b**5*c**7*s**2 - 20*a**13*b**6*c**7*s**2 -
        174*a**12*b**7*c**7*s**2 + 82*a**11*b**8*c**7*s**2 +
        175*a**10*b**9*c**7*s**2 + 259*a**9*b**10*c**7*s**2 +
        99*a**8*b**11*c**7*s**2 + 17*a**7*b**12*c**7*s**2 -
        6*a**16*b**2*c**8*s**2 + 5*a**15*b**3*c**8*s**2 -
        85*a**14*b**4*c**8*s**2 - 45*a**13*b**5*c**8*s**2 -
        162*a**12*b**6*c**8*s**2 + 82*a**11*b**7*c**8*s**2 +
        286*a**10*b**8*c**8*s**2 + 582*a**9*b**9*c**8*s**2 +
        376*a**8*b**10*c**8*s**2 + 116*a**7*b**11*c**8*s**2 +
        7*a**6*b**12*c**8*s**2 - 2*a**15*b**2*c**9*s**2 -
        24*a**14*b**3*c**9*s**2 - 27*a**13*b**4*c**9*s**2 -
        100*a**12*b**5*c**9*s**2 + 14*a**11*b**6*c**9*s**2 +
        175*a**10*b**7*c**9*s**2 + 582*a**9*b**8*c**9*s**2 +
        562*a**8*b**9*c**9*s**2 + 262*a**7*b**10*c**9*s**2 +
        33*a**6*b**11*c**9*s**2 - 3*a**5*b**12*c**9*s**2 -
        3*a**13*b**3*c**10*s**2 - 25*a**12*b**4*c**10*s**2 -
        11*a**11*b**5*c**10*s**2 + 24*a**10*b**6*c**10*s**2 +
        259*a**9*b**7*c**10*s**2 + 376*a**8*b**8*c**10*s**2 +
        262*a**7*b**9*c**10*s**2 + 52*a**6*b**10*c**10*s**2 -
        5*a**5*b**11*c**10*s**2 + 3*a**4*b**12*c**10*s**2 -
        2*a**11*b**4*c**11*s**2 - 8*a**10*b**5*c**11*s**2 +
        39*a**9*b**6*c**11*s**2 + 99*a**8*b**7*c**11*s**2 +
        116*a**7*b**8*c**11*s**2 + 33*a**6*b**9*c**11*s**2 -
        5*a**5*b**10*c**11*s**2 + 6*a**4*b**11*c**11*s**2 +
        4*a**8*b**6*c**12*s**2 + 17*a**7*b**7*c**12*s**2 +
        7*a**6*b**8*c**12*s**2 - 3*a**5*b**9*c**12*s**2 +
        3*a**4*b**10*c**12*s**2 - a**22*b**2*s**4 + 3*a**21*b**3*s**4
        - 4*a**20*b**4*s**4 + 3*a**19*b**5*s**4 - 2*a**22*b*c*s**4 +
        8*a**21*b**2*c*s**4 - 10*a**20*b**3*c*s**4 +
        12*a**19*b**4*c*s**4 + 6*a**18*b**5*c*s**4 +
        20*a**17*b**6*c*s**4 - 2*a**16*b**7*c*s**4 - a**22*c**2*s**4 +
        8*a**21*b*c**2*s**4 - 12*a**20*b**2*c**2*s**4 +
        23*a**19*b**3*c**2*s**4 + 21*a**18*b**4*c**2*s**4 +
        96*a**17*b**5*c**2*s**4 + 22*a**16*b**6*c**2*s**4 +
        15*a**15*b**7*c**2*s**4 - 10*a**14*b**8*c**2*s**4 +
        3*a**21*c**3*s**4 - 10*a**20*b*c**3*s**4 +
        23*a**19*b**2*c**3*s**4 + 30*a**18*b**3*c**3*s**4 +
        188*a**17*b**4*c**3*s**4 + 101*a**16*b**5*c**3*s**4 +
        88*a**15*b**6*c**3*s**4 - 30*a**14*b**7*c**3*s**4 -
        2*a**13*b**8*c**3*s**4 - 13*a**12*b**9*c**3*s**4 -
        4*a**20*c**4*s**4 + 12*a**19*b*c**4*s**4 +
        21*a**18*b**2*c**4*s**4 + 188*a**17*b**3*c**4*s**4 +
        154*a**16*b**4*c**4*s**4 + 188*a**15*b**5*c**4*s**4 -
        32*a**14*b**6*c**4*s**4 + 7*a**13*b**7*c**4*s**4 -
        52*a**12*b**8*c**4*s**4 - 5*a**11*b**9*c**4*s**4 -
        8*a**10*b**10*c**4*s**4 + 3*a**19*c**5*s**4 +
        6*a**18*b*c**5*s**4 + 96*a**17*b**2*c**5*s**4 +
        101*a**16*b**3*c**5*s**4 + 188*a**15*b**4*c**5*s**4 -
        24*a**14*b**5*c**5*s**4 + 31*a**13*b**6*c**5*s**4 -
        88*a**12*b**7*c**5*s**4 - 4*a**11*b**8*c**5*s**4 -
        21*a**10*b**9*c**5*s**4 + 8*a**9*b**10*c**5*s**4 +
        20*a**17*b*c**6*s**4 + 22*a**16*b**2*c**6*s**4 +
        88*a**15*b**3*c**6*s**4 - 32*a**14*b**4*c**6*s**4 +
        31*a**13*b**5*c**6*s**4 - 98*a**12*b**6*c**6*s**4 +
        11*a**11*b**7*c**6*s**4 - 12*a**10*b**8*c**6*s**4 +
        63*a**9*b**9*c**6*s**4 + 32*a**8*b**10*c**6*s**4 +
        10*a**7*b**11*c**6*s**4 - 2*a**16*b*c**7*s**4 +
        15*a**15*b**2*c**7*s**4 - 30*a**14*b**3*c**7*s**4 +
        7*a**13*b**4*c**7*s**4 - 88*a**12*b**5*c**7*s**4 +
        11*a**11*b**6*c**7*s**4 + 2*a**10*b**7*c**7*s**4 +
        149*a**9*b**8*c**7*s**4 + 135*a**8*b**9*c**7*s**4 +
        67*a**7*b**10*c**7*s**4 + 10*a**6*b**11*c**7*s**4 -
        10*a**14*b**2*c**8*s**4 - 2*a**13*b**3*c**8*s**4 -
        52*a**12*b**4*c**8*s**4 - 4*a**11*b**5*c**8*s**4 -
        12*a**10*b**6*c**8*s**4 + 149*a**9*b**7*c**8*s**4 +
        206*a**8*b**8*c**8*s**4 + 151*a**7*b**9*c**8*s**4 +
        40*a**6*b**10*c**8*s**4 - 13*a**12*b**3*c**9*s**4 -
        5*a**11*b**4*c**9*s**4 - 21*a**10*b**5*c**9*s**4 +
        63*a**9*b**6*c**9*s**4 + 135*a**8*b**7*c**9*s**4 +
        151*a**7*b**8*c**9*s**4 + 60*a**6*b**9*c**9*s**4 -
        8*a**10*b**4*c**10*s**4 + 8*a**9*b**5*c**10*s**4 +
        32*a**8*b**6*c**10*s**4 + 67*a**7*b**7*c**10*s**4 +
        40*a**6*b**8*c**10*s**4 + 10*a**7*b**6*c**11*s**4 +
        10*a**6*b**7*c**11*s**4)/(a**25*b*s**2 - 3*a**24*b**2*s**2 +
        5*a**23*b**3*s**2 - 6*a**22*b**4*s**2 + 5*a**21*b**5*s**2 -
        3*a**20*b**6*s**2 + a**19*b**7*s**2 + a**25*c*s**2 -
        5*a**24*b*c*s**2 + 13*a**23*b**2*c*s**2 - 23*a**22*b**3*c*s**2
        + 30*a**21*b**4*c*s**2 - 30*a**20*b**5*c*s**2 +
        23*a**19*b**6*c*s**2 - 13*a**18*b**7*c*s**2 +
        5*a**17*b**8*c*s**2 - a**16*b**9*c*s**2 - 3*a**24*c**2*s**2 +
        13*a**23*b*c**2*s**2 - 33*a**22*b**2*c**2*s**2 +
        60*a**21*b**3*c**2*s**2 - 83*a**20*b**4*c**2*s**2 +
        91*a**19*b**5*c**2*s**2 - 79*a**18*b**6*c**2*s**2 +
        54*a**17*b**7*c**2*s**2 - 28*a**16*b**8*c**2*s**2 +
        10*a**15*b**9*c**2*s**2 - 2*a**14*b**10*c**2*s**2 +
        5*a**23*c**3*s**2 - 23*a**22*b*c**3*s**2 +
        60*a**21*b**2*c**3*s**2 - 113*a**20*b**3*c**3*s**2 +
        164*a**19*b**4*c**3*s**2 - 191*a**18*b**5*c**3*s**2 +
        180*a**17*b**6*c**3*s**2 - 137*a**16*b**7*c**3*s**2 +
        83*a**15*b**8*c**3*s**2 - 38*a**14*b**9*c**3*s**2 +
        12*a**13*b**10*c**3*s**2 - 2*a**12*b**11*c**3*s**2 -
        6*a**22*c**4*s**2 + 30*a**21*b*c**4*s**2 -
        83*a**20*b**2*c**4*s**2 + 164*a**19*b**3*c**4*s**2 -
        250*a**18*b**4*c**4*s**2 + 307*a**17*b**5*c**4*s**2 -
        308*a**16*b**6*c**4*s**2 + 253*a**15*b**7*c**4*s**2 -
        169*a**14*b**8*c**4*s**2 + 89*a**13*b**9*c**4*s**2 -
        35*a**12*b**10*c**4*s**2 + 9*a**11*b**11*c**4*s**2 -
        a**10*b**12*c**4*s**2 + 5*a**21*c**5*s**2 -
        30*a**20*b*c**5*s**2 + 91*a**19*b**2*c**5*s**2 -
        191*a**18*b**3*c**5*s**2 + 307*a**17*b**4*c**5*s**2 -
        395*a**16*b**5*c**5*s**2 + 417*a**15*b**6*c**5*s**2 -
        363*a**14*b**7*c**5*s**2 + 260*a**13*b**8*c**5*s**2 -
        151*a**12*b**9*c**5*s**2 + 68*a**11*b**10*c**5*s**2 -
        22*a**10*b**11*c**5*s**2 + 4*a**9*b**12*c**5*s**2 -
        3*a**20*c**6*s**2 + 23*a**19*b*c**6*s**2 -
        79*a**18*b**2*c**6*s**2 + 180*a**17*b**3*c**6*s**2 -
        308*a**16*b**4*c**6*s**2 + 417*a**15*b**5*c**6*s**2 -
        461*a**14*b**6*c**6*s**2 + 420*a**13*b**7*c**6*s**2 -
        316*a**12*b**8*c**6*s**2 + 195*a**11*b**9*c**6*s**2 -
        96*a**10*b**10*c**6*s**2 + 36*a**9*b**11*c**6*s**2 -
        9*a**8*b**12*c**6*s**2 + a**7*b**13*c**6*s**2 +
        a**19*c**7*s**2 - 13*a**18*b*c**7*s**2 +
        54*a**17*b**2*c**7*s**2 - 137*a**16*b**3*c**7*s**2 +
        253*a**15*b**4*c**7*s**2 - 363*a**14*b**5*c**7*s**2 +
        420*a**13*b**6*c**7*s**2 - 398*a**12*b**7*c**7*s**2 +
        310*a**11*b**8*c**7*s**2 - 198*a**10*b**9*c**7*s**2 +
        102*a**9*b**10*c**7*s**2 - 41*a**8*b**11*c**7*s**2 +
        12*a**7*b**12*c**7*s**2 - 2*a**6*b**13*c**7*s**2 +
        5*a**17*b*c**8*s**2 - 28*a**16*b**2*c**8*s**2 +
        83*a**15*b**3*c**8*s**2 - 169*a**14*b**4*c**8*s**2 +
        260*a**13*b**5*c**8*s**2 - 316*a**12*b**6*c**8*s**2 +
        310*a**11*b**7*c**8*s**2 - 247*a**10*b**8*c**8*s**2 +
        159*a**9*b**9*c**8*s**2 - 82*a**8*b**10*c**8*s**2 +
        33*a**7*b**11*c**8*s**2 - 10*a**6*b**12*c**8*s**2 +
        2*a**5*b**13*c**8*s**2 - a**16*b*c**9*s**2 +
        10*a**15*b**2*c**9*s**2 - 38*a**14*b**3*c**9*s**2 +
        89*a**13*b**4*c**9*s**2 - 151*a**12*b**5*c**9*s**2 +
        195*a**11*b**6*c**9*s**2 - 198*a**10*b**7*c**9*s**2 +
        159*a**9*b**8*c**9*s**2 - 99*a**8*b**9*c**9*s**2 +
        47*a**7*b**10*c**9*s**2 - 16*a**6*b**11*c**9*s**2 +
        4*a**5*b**12*c**9*s**2 - a**4*b**13*c**9*s**2 -
        2*a**14*b**2*c**10*s**2 + 12*a**13*b**3*c**10*s**2 -
        35*a**12*b**4*c**10*s**2 + 68*a**11*b**5*c**10*s**2 -
        96*a**10*b**6*c**10*s**2 + 102*a**9*b**7*c**10*s**2 -
        82*a**8*b**8*c**10*s**2 + 47*a**7*b**9*c**10*s**2 -
        16*a**6*b**10*c**10*s**2 + 3*a**4*b**12*c**10*s**2 -
        a**3*b**13*c**10*s**2 - 2*a**12*b**3*c**11*s**2 +
        9*a**11*b**4*c**11*s**2 - 22*a**10*b**5*c**11*s**2 +
        36*a**9*b**6*c**11*s**2 - 41*a**8*b**7*c**11*s**2 +
        33*a**7*b**8*c**11*s**2 - 16*a**6*b**9*c**11*s**2 +
        7*a**4*b**11*c**11*s**2 - 6*a**3*b**12*c**11*s**2 +
        2*a**2*b**13*c**11*s**2 - a**10*b**4*c**12*s**2 +
        4*a**9*b**5*c**12*s**2 - 9*a**8*b**6*c**12*s**2 +
        12*a**7*b**7*c**12*s**2 - 10*a**6*b**8*c**12*s**2 +
        4*a**5*b**9*c**12*s**2 + 3*a**4*b**10*c**12*s**2 -
        6*a**3*b**11*c**12*s**2 + 5*a**2*b**12*c**12*s**2 -
        2*a*b**13*c**12*s**2 + a**7*b**6*c**13*s**2 -
        2*a**6*b**7*c**13*s**2 + 2*a**5*b**8*c**13*s**2 -
        a**4*b**9*c**13*s**2 - a**3*b**10*c**13*s**2 +
        2*a**2*b**11*c**13*s**2 - 2*a*b**12*c**13*s**2 +
        b**13*c**13*s**2), (-a**13*b**12*c**3 - a**12*b**13*c**3 +
        2*a**13*b**11*c**4 + 4*a**12*b**12*c**4 + 2*a**11*b**13*c**4 -
        a**13*b**10*c**5 - a**10*b**13*c**5 - a**13*b**9*c**6 -
        4*a**12*b**10*c**6 - 6*a**11*b**11*c**6 - 4*a**10*b**12*c**6 -
        a**9*b**13*c**6 + 3*a**13*b**8*c**7 + 3*a**12*b**9*c**7 -
        7*a**11*b**10*c**7 - 7*a**10*b**11*c**7 + 3*a**9*b**12*c**7 +
        3*a**8*b**13*c**7 - a**12*b**8*c**8 - 16*a**11*b**9*c**8 -
        30*a**10*b**10*c**8 - 16*a**9*b**11*c**8 - a**8*b**12*c**8 +
        2*a**12*b**7*c**9 + a**11*b**8*c**9 - 10*a**10*b**9*c**9 -
        10*a**9*b**10*c**9 + a**8*b**11*c**9 + 2*a**7*b**12*c**9 -
        6*a**12*b**6*c**10 - 24*a**11*b**7*c**10 - 51*a**10*b**8*c**10
        - 66*a**9*b**9*c**10 - 51*a**8*b**10*c**10 -
        24*a**7*b**11*c**10 - 6*a**6*b**12*c**10 + a**11*b**6*c**11 +
        7*a**10*b**7*c**11 + 16*a**9*b**8*c**11 + 16*a**8*b**9*c**11 +
        7*a**7*b**10*c**11 + a**6*b**11*c**11 - 8*a**11*b**5*c**12 -
        35*a**10*b**6*c**12 - 64*a**9*b**7*c**12 - 74*a**8*b**8*c**12
        - 64*a**7*b**9*c**12 - 35*a**6*b**10*c**12 -
        8*a**5*b**11*c**12 + a**11*b**4*c**13 + 2*a**10*b**5*c**13 +
        12*a**9*b**6*c**13 + 31*a**8*b**7*c**13 + 31*a**7*b**8*c**13 +
        12*a**6*b**9*c**13 + 2*a**5*b**10*c**13 + a**4*b**11*c**13 -
        10*a**10*b**4*c**14 - 42*a**9*b**5*c**14 - 84*a**8*b**6*c**14
        - 104*a**7*b**7*c**14 - 84*a**6*b**8*c**14 -
        42*a**5*b**9*c**14 - 10*a**4*b**10*c**14 + a**10*b**3*c**15 +
        4*a**9*b**4*c**15 + 5*a**8*b**5*c**15 + 3*a**7*b**6*c**15 +
        3*a**6*b**7*c**15 + 5*a**5*b**8*c**15 + 4*a**4*b**9*c**15 +
        a**3*b**10*c**15 - 8*a**9*b**3*c**16 - 46*a**8*b**4*c**16 -
        103*a**7*b**5*c**16 - 130*a**6*b**6*c**16 -
        103*a**5*b**7*c**16 - 46*a**4*b**8*c**16 - 8*a**3*b**9*c**16 -
        10*a**8*b**3*c**17 - 28*a**7*b**4*c**17 - 33*a**6*b**5*c**17 -
        33*a**5*b**6*c**17 - 28*a**4*b**7*c**17 - 10*a**3*b**8*c**17 -
        11*a**8*b**2*c**18 - 47*a**7*b**3*c**18 - 86*a**6*b**4*c**18 -
        100*a**5*b**5*c**18 - 86*a**4*b**6*c**18 - 47*a**3*b**7*c**18
        - 11*a**2*b**8*c**18 - 2*a**8*b*c**19 - 11*a**7*b**2*c**19 -
        24*a**6*b**3*c**19 - 31*a**5*b**4*c**19 - 31*a**4*b**5*c**19 -
        24*a**3*b**6*c**19 - 11*a**2*b**7*c**19 - 2*a*b**8*c**19 -
        2*a**7*b*c**20 - 11*a**6*b**2*c**20 - 26*a**5*b**3*c**20 -
        34*a**4*b**4*c**20 - 26*a**3*b**5*c**20 - 11*a**2*b**6*c**20 -
        2*a*b**7*c**20 + 3*a**12*b**10*c**4*s**2 +
        6*a**11*b**11*c**4*s**2 + 3*a**10*b**12*c**4*s**2 -
        3*a**12*b**9*c**5*s**2 - 5*a**11*b**10*c**5*s**2 -
        5*a**10*b**11*c**5*s**2 - 3*a**9*b**12*c**5*s**2 +
        7*a**12*b**8*c**6*s**2 + 33*a**11*b**9*c**6*s**2 +
        52*a**10*b**10*c**6*s**2 + 33*a**9*b**11*c**6*s**2 +
        7*a**8*b**12*c**6*s**2 + 17*a**12*b**7*c**7*s**2 +
        116*a**11*b**8*c**7*s**2 + 262*a**10*b**9*c**7*s**2 +
        262*a**9*b**10*c**7*s**2 + 116*a**8*b**11*c**7*s**2 +
        17*a**7*b**12*c**7*s**2 + 4*a**12*b**6*c**8*s**2 +
        99*a**11*b**7*c**8*s**2 + 376*a**10*b**8*c**8*s**2 +
        562*a**9*b**9*c**8*s**2 + 376*a**8*b**10*c**8*s**2 +
        99*a**7*b**11*c**8*s**2 + 4*a**6*b**12*c**8*s**2 +
        39*a**11*b**6*c**9*s**2 + 259*a**10*b**7*c**9*s**2 +
        582*a**9*b**8*c**9*s**2 + 582*a**8*b**9*c**9*s**2 +
        259*a**7*b**10*c**9*s**2 + 39*a**6*b**11*c**9*s**2 -
        8*a**11*b**5*c**10*s**2 + 24*a**10*b**6*c**10*s**2 +
        175*a**9*b**7*c**10*s**2 + 286*a**8*b**8*c**10*s**2 +
        175*a**7*b**9*c**10*s**2 + 24*a**6*b**10*c**10*s**2 -
        8*a**5*b**11*c**10*s**2 - 2*a**11*b**4*c**11*s**2 -
        11*a**10*b**5*c**11*s**2 + 14*a**9*b**6*c**11*s**2 +
        82*a**8*b**7*c**11*s**2 + 82*a**7*b**8*c**11*s**2 +
        14*a**6*b**9*c**11*s**2 - 11*a**5*b**10*c**11*s**2 -
        2*a**4*b**11*c**11*s**2 - 25*a**10*b**4*c**12*s**2 -
        100*a**9*b**5*c**12*s**2 - 162*a**8*b**6*c**12*s**2 -
        174*a**7*b**7*c**12*s**2 - 162*a**6*b**8*c**12*s**2 -
        100*a**5*b**9*c**12*s**2 - 25*a**4*b**10*c**12*s**2 -
        3*a**10*b**3*c**13*s**2 - 27*a**9*b**4*c**13*s**2 -
        45*a**8*b**5*c**13*s**2 - 20*a**7*b**6*c**13*s**2 -
        20*a**6*b**7*c**13*s**2 - 45*a**5*b**8*c**13*s**2 -
        27*a**4*b**9*c**13*s**2 - 3*a**3*b**10*c**13*s**2 -
        24*a**9*b**3*c**14*s**2 - 85*a**8*b**4*c**14*s**2 -
        114*a**7*b**5*c**14*s**2 - 106*a**6*b**6*c**14*s**2 -
        114*a**5*b**7*c**14*s**2 - 85*a**4*b**8*c**14*s**2 -
        24*a**3*b**9*c**14*s**2 - 2*a**9*b**2*c**15*s**2 +
        5*a**8*b**3*c**15*s**2 + 109*a**7*b**4*c**15*s**2 +
        287*a**6*b**5*c**15*s**2 + 287*a**5*b**6*c**15*s**2 +
        109*a**4*b**7*c**15*s**2 + 5*a**3*b**8*c**15*s**2 -
        2*a**2*b**9*c**15*s**2 - 6*a**8*b**2*c**16*s**2 +
        58*a**7*b**3*c**16*s**2 + 293*a**6*b**4*c**16*s**2 +
        458*a**5*b**5*c**16*s**2 + 293*a**4*b**6*c**16*s**2 +
        58*a**3*b**7*c**16*s**2 - 6*a**2*b**8*c**16*s**2 +
        53*a**7*b**2*c**17*s**2 + 297*a**6*b**3*c**17*s**2 +
        622*a**5*b**4*c**17*s**2 + 622*a**4*b**5*c**17*s**2 +
        297*a**3*b**6*c**17*s**2 + 53*a**2*b**7*c**17*s**2 +
        6*a**7*b*c**18*s**2 + 75*a**6*b**2*c**18*s**2 +
        237*a**5*b**3*c**18*s**2 + 336*a**4*b**4*c**18*s**2 +
        237*a**3*b**5*c**18*s**2 + 75*a**2*b**6*c**18*s**2 +
        6*a*b**7*c**18*s**2 + 15*a**6*b*c**19*s**2 +
        64*a**5*b**2*c**19*s**2 + 121*a**4*b**3*c**19*s**2 +
        121*a**3*b**4*c**19*s**2 + 64*a**2*b**5*c**19*s**2 +
        15*a*b**6*c**19*s**2 - 6*a**5*b*c**20*s**2 -
        17*a**4*b**2*c**20*s**2 - 22*a**3*b**3*c**20*s**2 -
        17*a**2*b**4*c**20*s**2 - 6*a*b**5*c**20*s**2 +
        3*a**4*b*c**21*s**2 + 9*a**3*b**2*c**21*s**2 +
        9*a**2*b**3*c**21*s**2 + 3*a*b**4*c**21*s**2 +
        10*a**11*b**7*c**6*s**4 + 40*a**10*b**8*c**6*s**4 +
        60*a**9*b**9*c**6*s**4 + 40*a**8*b**10*c**6*s**4 +
        10*a**7*b**11*c**6*s**4 + 10*a**11*b**6*c**7*s**4 +
        67*a**10*b**7*c**7*s**4 + 151*a**9*b**8*c**7*s**4 +
        151*a**8*b**9*c**7*s**4 + 67*a**7*b**10*c**7*s**4 +
        10*a**6*b**11*c**7*s**4 + 32*a**10*b**6*c**8*s**4 +
        135*a**9*b**7*c**8*s**4 + 206*a**8*b**8*c**8*s**4 +
        135*a**7*b**9*c**8*s**4 + 32*a**6*b**10*c**8*s**4 +
        8*a**10*b**5*c**9*s**4 + 63*a**9*b**6*c**9*s**4 +
        149*a**8*b**7*c**9*s**4 + 149*a**7*b**8*c**9*s**4 +
        63*a**6*b**9*c**9*s**4 + 8*a**5*b**10*c**9*s**4 -
        8*a**10*b**4*c**10*s**4 - 21*a**9*b**5*c**10*s**4 -
        12*a**8*b**6*c**10*s**4 + 2*a**7*b**7*c**10*s**4 -
        12*a**6*b**8*c**10*s**4 - 21*a**5*b**9*c**10*s**4 -
        8*a**4*b**10*c**10*s**4 - 5*a**9*b**4*c**11*s**4 -
        4*a**8*b**5*c**11*s**4 + 11*a**7*b**6*c**11*s**4 +
        11*a**6*b**7*c**11*s**4 - 4*a**5*b**8*c**11*s**4 -
        5*a**4*b**9*c**11*s**4 - 13*a**9*b**3*c**12*s**4 -
        52*a**8*b**4*c**12*s**4 - 88*a**7*b**5*c**12*s**4 -
        98*a**6*b**6*c**12*s**4 - 88*a**5*b**7*c**12*s**4 -
        52*a**4*b**8*c**12*s**4 - 13*a**3*b**9*c**12*s**4 -
        2*a**8*b**3*c**13*s**4 + 7*a**7*b**4*c**13*s**4 +
        31*a**6*b**5*c**13*s**4 + 31*a**5*b**6*c**13*s**4 +
        7*a**4*b**7*c**13*s**4 - 2*a**3*b**8*c**13*s**4 -
        10*a**8*b**2*c**14*s**4 - 30*a**7*b**3*c**14*s**4 -
        32*a**6*b**4*c**14*s**4 - 24*a**5*b**5*c**14*s**4 -
        32*a**4*b**6*c**14*s**4 - 30*a**3*b**7*c**14*s**4 -
        10*a**2*b**8*c**14*s**4 + 15*a**7*b**2*c**15*s**4 +
        88*a**6*b**3*c**15*s**4 + 188*a**5*b**4*c**15*s**4 +
        188*a**4*b**5*c**15*s**4 + 88*a**3*b**6*c**15*s**4 +
        15*a**2*b**7*c**15*s**4 - 2*a**7*b*c**16*s**4 +
        22*a**6*b**2*c**16*s**4 + 101*a**5*b**3*c**16*s**4 +
        154*a**4*b**4*c**16*s**4 + 101*a**3*b**5*c**16*s**4 +
        22*a**2*b**6*c**16*s**4 - 2*a*b**7*c**16*s**4 +
        20*a**6*b*c**17*s**4 + 96*a**5*b**2*c**17*s**4 +
        188*a**4*b**3*c**17*s**4 + 188*a**3*b**4*c**17*s**4 +
        96*a**2*b**5*c**17*s**4 + 20*a*b**6*c**17*s**4 +
        6*a**5*b*c**18*s**4 + 21*a**4*b**2*c**18*s**4 +
        30*a**3*b**3*c**18*s**4 + 21*a**2*b**4*c**18*s**4 +
        6*a*b**5*c**18*s**4 + 3*a**5*c**19*s**4 + 12*a**4*b*c**19*s**4
        + 23*a**3*b**2*c**19*s**4 + 23*a**2*b**3*c**19*s**4 +
        12*a*b**4*c**19*s**4 + 3*b**5*c**19*s**4 - 4*a**4*c**20*s**4 -
        10*a**3*b*c**20*s**4 - 12*a**2*b**2*c**20*s**4 -
        10*a*b**3*c**20*s**4 - 4*b**4*c**20*s**4 + 3*a**3*c**21*s**4 +
        8*a**2*b*c**21*s**4 + 8*a*b**2*c**21*s**4 + 3*b**3*c**21*s**4
        - a**2*c**22*s**4 - 2*a*b*c**22*s**4 -
        b**2*c**22*s**4)/(a**13*b**13*s**2 - 2*a**13*b**12*c*s**2 -
        2*a**12*b**13*c*s**2 + 2*a**13*b**11*c**2*s**2 +
        5*a**12*b**12*c**2*s**2 + 2*a**11*b**13*c**2*s**2 -
        a**13*b**10*c**3*s**2 - 6*a**12*b**11*c**3*s**2 -
        6*a**11*b**12*c**3*s**2 - a**10*b**13*c**3*s**2 -
        a**13*b**9*c**4*s**2 + 3*a**12*b**10*c**4*s**2 +
        7*a**11*b**11*c**4*s**2 + 3*a**10*b**12*c**4*s**2 -
        a**9*b**13*c**4*s**2 + 2*a**13*b**8*c**5*s**2 +
        4*a**12*b**9*c**5*s**2 + 4*a**9*b**12*c**5*s**2 +
        2*a**8*b**13*c**5*s**2 - 2*a**13*b**7*c**6*s**2 -
        10*a**12*b**8*c**6*s**2 - 16*a**11*b**9*c**6*s**2 -
        16*a**10*b**10*c**6*s**2 - 16*a**9*b**11*c**6*s**2 -
        10*a**8*b**12*c**6*s**2 - 2*a**7*b**13*c**6*s**2 +
        a**13*b**6*c**7*s**2 + 12*a**12*b**7*c**7*s**2 +
        33*a**11*b**8*c**7*s**2 + 47*a**10*b**9*c**7*s**2 +
        47*a**9*b**10*c**7*s**2 + 33*a**8*b**11*c**7*s**2 +
        12*a**7*b**12*c**7*s**2 + a**6*b**13*c**7*s**2 -
        9*a**12*b**6*c**8*s**2 - 41*a**11*b**7*c**8*s**2 -
        82*a**10*b**8*c**8*s**2 - 99*a**9*b**9*c**8*s**2 -
        82*a**8*b**10*c**8*s**2 - 41*a**7*b**11*c**8*s**2 -
        9*a**6*b**12*c**8*s**2 + 4*a**12*b**5*c**9*s**2 +
        36*a**11*b**6*c**9*s**2 + 102*a**10*b**7*c**9*s**2 +
        159*a**9*b**8*c**9*s**2 + 159*a**8*b**9*c**9*s**2 +
        102*a**7*b**10*c**9*s**2 + 36*a**6*b**11*c**9*s**2 +
        4*a**5*b**12*c**9*s**2 - a**12*b**4*c**10*s**2 -
        22*a**11*b**5*c**10*s**2 - 96*a**10*b**6*c**10*s**2 -
        198*a**9*b**7*c**10*s**2 - 247*a**8*b**8*c**10*s**2 -
        198*a**7*b**9*c**10*s**2 - 96*a**6*b**10*c**10*s**2 -
        22*a**5*b**11*c**10*s**2 - a**4*b**12*c**10*s**2 +
        9*a**11*b**4*c**11*s**2 + 68*a**10*b**5*c**11*s**2 +
        195*a**9*b**6*c**11*s**2 + 310*a**8*b**7*c**11*s**2 +
        310*a**7*b**8*c**11*s**2 + 195*a**6*b**9*c**11*s**2 +
        68*a**5*b**10*c**11*s**2 + 9*a**4*b**11*c**11*s**2 -
        2*a**11*b**3*c**12*s**2 - 35*a**10*b**4*c**12*s**2 -
        151*a**9*b**5*c**12*s**2 - 316*a**8*b**6*c**12*s**2 -
        398*a**7*b**7*c**12*s**2 - 316*a**6*b**8*c**12*s**2 -
        151*a**5*b**9*c**12*s**2 - 35*a**4*b**10*c**12*s**2 -
        2*a**3*b**11*c**12*s**2 + 12*a**10*b**3*c**13*s**2 +
        89*a**9*b**4*c**13*s**2 + 260*a**8*b**5*c**13*s**2 +
        420*a**7*b**6*c**13*s**2 + 420*a**6*b**7*c**13*s**2 +
        260*a**5*b**8*c**13*s**2 + 89*a**4*b**9*c**13*s**2 +
        12*a**3*b**10*c**13*s**2 - 2*a**10*b**2*c**14*s**2 -
        38*a**9*b**3*c**14*s**2 - 169*a**8*b**4*c**14*s**2 -
        363*a**7*b**5*c**14*s**2 - 461*a**6*b**6*c**14*s**2 -
        363*a**5*b**7*c**14*s**2 - 169*a**4*b**8*c**14*s**2 -
        38*a**3*b**9*c**14*s**2 - 2*a**2*b**10*c**14*s**2 +
        10*a**9*b**2*c**15*s**2 + 83*a**8*b**3*c**15*s**2 +
        253*a**7*b**4*c**15*s**2 + 417*a**6*b**5*c**15*s**2 +
        417*a**5*b**6*c**15*s**2 + 253*a**4*b**7*c**15*s**2 +
        83*a**3*b**8*c**15*s**2 + 10*a**2*b**9*c**15*s**2 -
        a**9*b*c**16*s**2 - 28*a**8*b**2*c**16*s**2 -
        137*a**7*b**3*c**16*s**2 - 308*a**6*b**4*c**16*s**2 -
        395*a**5*b**5*c**16*s**2 - 308*a**4*b**6*c**16*s**2 -
        137*a**3*b**7*c**16*s**2 - 28*a**2*b**8*c**16*s**2 -
        a*b**9*c**16*s**2 + 5*a**8*b*c**17*s**2 +
        54*a**7*b**2*c**17*s**2 + 180*a**6*b**3*c**17*s**2 +
        307*a**5*b**4*c**17*s**2 + 307*a**4*b**5*c**17*s**2 +
        180*a**3*b**6*c**17*s**2 + 54*a**2*b**7*c**17*s**2 +
        5*a*b**8*c**17*s**2 - 13*a**7*b*c**18*s**2 -
        79*a**6*b**2*c**18*s**2 - 191*a**5*b**3*c**18*s**2 -
        250*a**4*b**4*c**18*s**2 - 191*a**3*b**5*c**18*s**2 -
        79*a**2*b**6*c**18*s**2 - 13*a*b**7*c**18*s**2 +
        a**7*c**19*s**2 + 23*a**6*b*c**19*s**2 +
        91*a**5*b**2*c**19*s**2 + 164*a**4*b**3*c**19*s**2 +
        164*a**3*b**4*c**19*s**2 + 91*a**2*b**5*c**19*s**2 +
        23*a*b**6*c**19*s**2 + b**7*c**19*s**2 - 3*a**6*c**20*s**2 -
        30*a**5*b*c**20*s**2 - 83*a**4*b**2*c**20*s**2 -
        113*a**3*b**3*c**20*s**2 - 83*a**2*b**4*c**20*s**2 -
        30*a*b**5*c**20*s**2 - 3*b**6*c**20*s**2 + 5*a**5*c**21*s**2 +
        30*a**4*b*c**21*s**2 + 60*a**3*b**2*c**21*s**2 +
        60*a**2*b**3*c**21*s**2 + 30*a*b**4*c**21*s**2 +
        5*b**5*c**21*s**2 - 6*a**4*c**22*s**2 - 23*a**3*b*c**22*s**2 -
        33*a**2*b**2*c**22*s**2 - 23*a*b**3*c**22*s**2 -
        6*b**4*c**22*s**2 + 5*a**3*c**23*s**2 + 13*a**2*b*c**23*s**2 +
        13*a*b**2*c**23*s**2 + 5*b**3*c**23*s**2 - 3*a**2*c**24*s**2 -
        5*a*b*c**24*s**2 - 3*b**2*c**24*s**2 + a*c**25*s**2 +
        b*c**25*s**2), (-2*a**8*b**19*c - 2*a**7*b**20*c -
        11*a**8*b**18*c**2 - 11*a**7*b**19*c**2 - 11*a**6*b**20*c**2 +
        a**10*b**15*c**3 - 8*a**9*b**16*c**3 - 10*a**8*b**17*c**3 -
        47*a**7*b**18*c**3 - 24*a**6*b**19*c**3 - 26*a**5*b**20*c**3 +
        a**11*b**13*c**4 - 10*a**10*b**14*c**4 + 4*a**9*b**15*c**4 -
        46*a**8*b**16*c**4 - 28*a**7*b**17*c**4 - 86*a**6*b**18*c**4 -
        31*a**5*b**19*c**4 - 34*a**4*b**20*c**4 - 8*a**11*b**12*c**5 +
        2*a**10*b**13*c**5 - 42*a**9*b**14*c**5 + 5*a**8*b**15*c**5 -
        103*a**7*b**16*c**5 - 33*a**6*b**17*c**5 - 100*a**5*b**18*c**5
        - 31*a**4*b**19*c**5 - 26*a**3*b**20*c**5 - 6*a**12*b**10*c**6
        + a**11*b**11*c**6 - 35*a**10*b**12*c**6 + 12*a**9*b**13*c**6
        - 84*a**8*b**14*c**6 + 3*a**7*b**15*c**6 - 130*a**6*b**16*c**6
        - 33*a**5*b**17*c**6 - 86*a**4*b**18*c**6 - 24*a**3*b**19*c**6
        - 11*a**2*b**20*c**6 + 2*a**12*b**9*c**7 - 24*a**11*b**10*c**7
        + 7*a**10*b**11*c**7 - 64*a**9*b**12*c**7 + 31*a**8*b**13*c**7
        - 104*a**7*b**14*c**7 + 3*a**6*b**15*c**7 -
        103*a**5*b**16*c**7 - 28*a**4*b**17*c**7 - 47*a**3*b**18*c**7
        - 11*a**2*b**19*c**7 - 2*a*b**20*c**7 + 3*a**13*b**7*c**8 -
        a**12*b**8*c**8 + a**11*b**9*c**8 - 51*a**10*b**10*c**8 +
        16*a**9*b**11*c**8 - 74*a**8*b**12*c**8 + 31*a**7*b**13*c**8 -
        84*a**6*b**14*c**8 + 5*a**5*b**15*c**8 - 46*a**4*b**16*c**8 -
        10*a**3*b**17*c**8 - 11*a**2*b**18*c**8 - 2*a*b**19*c**8 -
        a**13*b**6*c**9 + 3*a**12*b**7*c**9 - 16*a**11*b**8*c**9 -
        10*a**10*b**9*c**9 - 66*a**9*b**10*c**9 + 16*a**8*b**11*c**9 -
        64*a**7*b**12*c**9 + 12*a**6*b**13*c**9 - 42*a**5*b**14*c**9 +
        4*a**4*b**15*c**9 - 8*a**3*b**16*c**9 - a**13*b**5*c**10 -
        4*a**12*b**6*c**10 - 7*a**11*b**7*c**10 - 30*a**10*b**8*c**10
        - 10*a**9*b**9*c**10 - 51*a**8*b**10*c**10 +
        7*a**7*b**11*c**10 - 35*a**6*b**12*c**10 + 2*a**5*b**13*c**10
        - 10*a**4*b**14*c**10 + a**3*b**15*c**10 + 2*a**13*b**4*c**11
        - 6*a**11*b**6*c**11 - 7*a**10*b**7*c**11 - 16*a**9*b**8*c**11
        + a**8*b**9*c**11 - 24*a**7*b**10*c**11 + a**6*b**11*c**11 -
        8*a**5*b**12*c**11 + a**4*b**13*c**11 - a**13*b**3*c**12 +
        4*a**12*b**4*c**12 - 4*a**10*b**6*c**12 + 3*a**9*b**7*c**12 -
        a**8*b**8*c**12 + 2*a**7*b**9*c**12 - 6*a**6*b**10*c**12 -
        a**12*b**3*c**13 + 2*a**11*b**4*c**13 - a**10*b**5*c**13 -
        a**9*b**6*c**13 + 3*a**8*b**7*c**13 + 6*a**7*b**18*c*s**2 +
        15*a**6*b**19*c*s**2 - 6*a**5*b**20*c*s**2 +
        3*a**4*b**21*c*s**2 - 2*a**9*b**15*c**2*s**2 -
        6*a**8*b**16*c**2*s**2 + 53*a**7*b**17*c**2*s**2 +
        75*a**6*b**18*c**2*s**2 + 64*a**5*b**19*c**2*s**2 -
        17*a**4*b**20*c**2*s**2 + 9*a**3*b**21*c**2*s**2 -
        3*a**10*b**13*c**3*s**2 - 24*a**9*b**14*c**3*s**2 +
        5*a**8*b**15*c**3*s**2 + 58*a**7*b**16*c**3*s**2 +
        297*a**6*b**17*c**3*s**2 + 237*a**5*b**18*c**3*s**2 +
        121*a**4*b**19*c**3*s**2 - 22*a**3*b**20*c**3*s**2 +
        9*a**2*b**21*c**3*s**2 - 2*a**11*b**11*c**4*s**2 -
        25*a**10*b**12*c**4*s**2 - 27*a**9*b**13*c**4*s**2 -
        85*a**8*b**14*c**4*s**2 + 109*a**7*b**15*c**4*s**2 +
        293*a**6*b**16*c**4*s**2 + 622*a**5*b**17*c**4*s**2 +
        336*a**4*b**18*c**4*s**2 + 121*a**3*b**19*c**4*s**2 -
        17*a**2*b**20*c**4*s**2 + 3*a*b**21*c**4*s**2 -
        8*a**11*b**10*c**5*s**2 - 11*a**10*b**11*c**5*s**2 -
        100*a**9*b**12*c**5*s**2 - 45*a**8*b**13*c**5*s**2 -
        114*a**7*b**14*c**5*s**2 + 287*a**6*b**15*c**5*s**2 +
        458*a**5*b**16*c**5*s**2 + 622*a**4*b**17*c**5*s**2 +
        237*a**3*b**18*c**5*s**2 + 64*a**2*b**19*c**5*s**2 -
        6*a*b**20*c**5*s**2 + 4*a**12*b**8*c**6*s**2 +
        39*a**11*b**9*c**6*s**2 + 24*a**10*b**10*c**6*s**2 +
        14*a**9*b**11*c**6*s**2 - 162*a**8*b**12*c**6*s**2 -
        20*a**7*b**13*c**6*s**2 - 106*a**6*b**14*c**6*s**2 +
        287*a**5*b**15*c**6*s**2 + 293*a**4*b**16*c**6*s**2 +
        297*a**3*b**17*c**6*s**2 + 75*a**2*b**18*c**6*s**2 +
        15*a*b**19*c**6*s**2 + 17*a**12*b**7*c**7*s**2 +
        99*a**11*b**8*c**7*s**2 + 259*a**10*b**9*c**7*s**2 +
        175*a**9*b**10*c**7*s**2 + 82*a**8*b**11*c**7*s**2 -
        174*a**7*b**12*c**7*s**2 - 20*a**6*b**13*c**7*s**2 -
        114*a**5*b**14*c**7*s**2 + 109*a**4*b**15*c**7*s**2 +
        58*a**3*b**16*c**7*s**2 + 53*a**2*b**17*c**7*s**2 +
        6*a*b**18*c**7*s**2 + 7*a**12*b**6*c**8*s**2 +
        116*a**11*b**7*c**8*s**2 + 376*a**10*b**8*c**8*s**2 +
        582*a**9*b**9*c**8*s**2 + 286*a**8*b**10*c**8*s**2 +
        82*a**7*b**11*c**8*s**2 - 162*a**6*b**12*c**8*s**2 -
        45*a**5*b**13*c**8*s**2 - 85*a**4*b**14*c**8*s**2 +
        5*a**3*b**15*c**8*s**2 - 6*a**2*b**16*c**8*s**2 -
        3*a**12*b**5*c**9*s**2 + 33*a**11*b**6*c**9*s**2 +
        262*a**10*b**7*c**9*s**2 + 562*a**9*b**8*c**9*s**2 +
        582*a**8*b**9*c**9*s**2 + 175*a**7*b**10*c**9*s**2 +
        14*a**6*b**11*c**9*s**2 - 100*a**5*b**12*c**9*s**2 -
        27*a**4*b**13*c**9*s**2 - 24*a**3*b**14*c**9*s**2 -
        2*a**2*b**15*c**9*s**2 + 3*a**12*b**4*c**10*s**2 -
        5*a**11*b**5*c**10*s**2 + 52*a**10*b**6*c**10*s**2 +
        262*a**9*b**7*c**10*s**2 + 376*a**8*b**8*c**10*s**2 +
        259*a**7*b**9*c**10*s**2 + 24*a**6*b**10*c**10*s**2 -
        11*a**5*b**11*c**10*s**2 - 25*a**4*b**12*c**10*s**2 -
        3*a**3*b**13*c**10*s**2 + 6*a**11*b**4*c**11*s**2 -
        5*a**10*b**5*c**11*s**2 + 33*a**9*b**6*c**11*s**2 +
        116*a**8*b**7*c**11*s**2 + 99*a**7*b**8*c**11*s**2 +
        39*a**6*b**9*c**11*s**2 - 8*a**5*b**10*c**11*s**2 -
        2*a**4*b**11*c**11*s**2 + 3*a**10*b**4*c**12*s**2 -
        3*a**9*b**5*c**12*s**2 + 7*a**8*b**6*c**12*s**2 +
        17*a**7*b**7*c**12*s**2 + 4*a**6*b**8*c**12*s**2 +
        3*a**5*b**19*s**4 - 4*a**4*b**20*s**4 + 3*a**3*b**21*s**4 -
        a**2*b**22*s**4 - 2*a**7*b**16*c*s**4 + 20*a**6*b**17*c*s**4 +
        6*a**5*b**18*c*s**4 + 12*a**4*b**19*c*s**4 -
        10*a**3*b**20*c*s**4 + 8*a**2*b**21*c*s**4 - 2*a*b**22*c*s**4
        - 10*a**8*b**14*c**2*s**4 + 15*a**7*b**15*c**2*s**4 +
        22*a**6*b**16*c**2*s**4 + 96*a**5*b**17*c**2*s**4 +
        21*a**4*b**18*c**2*s**4 + 23*a**3*b**19*c**2*s**4 -
        12*a**2*b**20*c**2*s**4 + 8*a*b**21*c**2*s**4 -
        b**22*c**2*s**4 - 13*a**9*b**12*c**3*s**4 -
        2*a**8*b**13*c**3*s**4 - 30*a**7*b**14*c**3*s**4 +
        88*a**6*b**15*c**3*s**4 + 101*a**5*b**16*c**3*s**4 +
        188*a**4*b**17*c**3*s**4 + 30*a**3*b**18*c**3*s**4 +
        23*a**2*b**19*c**3*s**4 - 10*a*b**20*c**3*s**4 +
        3*b**21*c**3*s**4 - 8*a**10*b**10*c**4*s**4 -
        5*a**9*b**11*c**4*s**4 - 52*a**8*b**12*c**4*s**4 +
        7*a**7*b**13*c**4*s**4 - 32*a**6*b**14*c**4*s**4 +
        188*a**5*b**15*c**4*s**4 + 154*a**4*b**16*c**4*s**4 +
        188*a**3*b**17*c**4*s**4 + 21*a**2*b**18*c**4*s**4 +
        12*a*b**19*c**4*s**4 - 4*b**20*c**4*s**4 +
        8*a**10*b**9*c**5*s**4 - 21*a**9*b**10*c**5*s**4 -
        4*a**8*b**11*c**5*s**4 - 88*a**7*b**12*c**5*s**4 +
        31*a**6*b**13*c**5*s**4 - 24*a**5*b**14*c**5*s**4 +
        188*a**4*b**15*c**5*s**4 + 101*a**3*b**16*c**5*s**4 +
        96*a**2*b**17*c**5*s**4 + 6*a*b**18*c**5*s**4 +
        3*b**19*c**5*s**4 + 10*a**11*b**7*c**6*s**4 +
        32*a**10*b**8*c**6*s**4 + 63*a**9*b**9*c**6*s**4 -
        12*a**8*b**10*c**6*s**4 + 11*a**7*b**11*c**6*s**4 -
        98*a**6*b**12*c**6*s**4 + 31*a**5*b**13*c**6*s**4 -
        32*a**4*b**14*c**6*s**4 + 88*a**3*b**15*c**6*s**4 +
        22*a**2*b**16*c**6*s**4 + 20*a*b**17*c**6*s**4 +
        10*a**11*b**6*c**7*s**4 + 67*a**10*b**7*c**7*s**4 +
        135*a**9*b**8*c**7*s**4 + 149*a**8*b**9*c**7*s**4 +
        2*a**7*b**10*c**7*s**4 + 11*a**6*b**11*c**7*s**4 -
        88*a**5*b**12*c**7*s**4 + 7*a**4*b**13*c**7*s**4 -
        30*a**3*b**14*c**7*s**4 + 15*a**2*b**15*c**7*s**4 -
        2*a*b**16*c**7*s**4 + 40*a**10*b**6*c**8*s**4 +
        151*a**9*b**7*c**8*s**4 + 206*a**8*b**8*c**8*s**4 +
        149*a**7*b**9*c**8*s**4 - 12*a**6*b**10*c**8*s**4 -
        4*a**5*b**11*c**8*s**4 - 52*a**4*b**12*c**8*s**4 -
        2*a**3*b**13*c**8*s**4 - 10*a**2*b**14*c**8*s**4 +
        60*a**9*b**6*c**9*s**4 + 151*a**8*b**7*c**9*s**4 +
        135*a**7*b**8*c**9*s**4 + 63*a**6*b**9*c**9*s**4 -
        21*a**5*b**10*c**9*s**4 - 5*a**4*b**11*c**9*s**4 -
        13*a**3*b**12*c**9*s**4 + 40*a**8*b**6*c**10*s**4 +
        67*a**7*b**7*c**10*s**4 + 32*a**6*b**8*c**10*s**4 +
        8*a**5*b**9*c**10*s**4 - 8*a**4*b**10*c**10*s**4 +
        10*a**7*b**6*c**11*s**4 +
        10*a**6*b**7*c**11*s**4)/(a**7*b**19*s**2 - 3*a**6*b**20*s**2
        + 5*a**5*b**21*s**2 - 6*a**4*b**22*s**2 + 5*a**3*b**23*s**2 -
        3*a**2*b**24*s**2 + a*b**25*s**2 - a**9*b**16*c*s**2 +
        5*a**8*b**17*c*s**2 - 13*a**7*b**18*c*s**2 +
        23*a**6*b**19*c*s**2 - 30*a**5*b**20*c*s**2 +
        30*a**4*b**21*c*s**2 - 23*a**3*b**22*c*s**2 +
        13*a**2*b**23*c*s**2 - 5*a*b**24*c*s**2 + b**25*c*s**2 -
        2*a**10*b**14*c**2*s**2 + 10*a**9*b**15*c**2*s**2 -
        28*a**8*b**16*c**2*s**2 + 54*a**7*b**17*c**2*s**2 -
        79*a**6*b**18*c**2*s**2 + 91*a**5*b**19*c**2*s**2 -
        83*a**4*b**20*c**2*s**2 + 60*a**3*b**21*c**2*s**2 -
        33*a**2*b**22*c**2*s**2 + 13*a*b**23*c**2*s**2 -
        3*b**24*c**2*s**2 - 2*a**11*b**12*c**3*s**2 +
        12*a**10*b**13*c**3*s**2 - 38*a**9*b**14*c**3*s**2 +
        83*a**8*b**15*c**3*s**2 - 137*a**7*b**16*c**3*s**2 +
        180*a**6*b**17*c**3*s**2 - 191*a**5*b**18*c**3*s**2 +
        164*a**4*b**19*c**3*s**2 - 113*a**3*b**20*c**3*s**2 +
        60*a**2*b**21*c**3*s**2 - 23*a*b**22*c**3*s**2 +
        5*b**23*c**3*s**2 - a**12*b**10*c**4*s**2 +
        9*a**11*b**11*c**4*s**2 - 35*a**10*b**12*c**4*s**2 +
        89*a**9*b**13*c**4*s**2 - 169*a**8*b**14*c**4*s**2 +
        253*a**7*b**15*c**4*s**2 - 308*a**6*b**16*c**4*s**2 +
        307*a**5*b**17*c**4*s**2 - 250*a**4*b**18*c**4*s**2 +
        164*a**3*b**19*c**4*s**2 - 83*a**2*b**20*c**4*s**2 +
        30*a*b**21*c**4*s**2 - 6*b**22*c**4*s**2 +
        4*a**12*b**9*c**5*s**2 - 22*a**11*b**10*c**5*s**2 +
        68*a**10*b**11*c**5*s**2 - 151*a**9*b**12*c**5*s**2 +
        260*a**8*b**13*c**5*s**2 - 363*a**7*b**14*c**5*s**2 +
        417*a**6*b**15*c**5*s**2 - 395*a**5*b**16*c**5*s**2 +
        307*a**4*b**17*c**5*s**2 - 191*a**3*b**18*c**5*s**2 +
        91*a**2*b**19*c**5*s**2 - 30*a*b**20*c**5*s**2 +
        5*b**21*c**5*s**2 + a**13*b**7*c**6*s**2 -
        9*a**12*b**8*c**6*s**2 + 36*a**11*b**9*c**6*s**2 -
        96*a**10*b**10*c**6*s**2 + 195*a**9*b**11*c**6*s**2 -
        316*a**8*b**12*c**6*s**2 + 420*a**7*b**13*c**6*s**2 -
        461*a**6*b**14*c**6*s**2 + 417*a**5*b**15*c**6*s**2 -
        308*a**4*b**16*c**6*s**2 + 180*a**3*b**17*c**6*s**2 -
        79*a**2*b**18*c**6*s**2 + 23*a*b**19*c**6*s**2 -
        3*b**20*c**6*s**2 - 2*a**13*b**6*c**7*s**2 +
        12*a**12*b**7*c**7*s**2 - 41*a**11*b**8*c**7*s**2 +
        102*a**10*b**9*c**7*s**2 - 198*a**9*b**10*c**7*s**2 +
        310*a**8*b**11*c**7*s**2 - 398*a**7*b**12*c**7*s**2 +
        420*a**6*b**13*c**7*s**2 - 363*a**5*b**14*c**7*s**2 +
        253*a**4*b**15*c**7*s**2 - 137*a**3*b**16*c**7*s**2 +
        54*a**2*b**17*c**7*s**2 - 13*a*b**18*c**7*s**2 +
        b**19*c**7*s**2 + 2*a**13*b**5*c**8*s**2 -
        10*a**12*b**6*c**8*s**2 + 33*a**11*b**7*c**8*s**2 -
        82*a**10*b**8*c**8*s**2 + 159*a**9*b**9*c**8*s**2 -
        247*a**8*b**10*c**8*s**2 + 310*a**7*b**11*c**8*s**2 -
        316*a**6*b**12*c**8*s**2 + 260*a**5*b**13*c**8*s**2 -
        169*a**4*b**14*c**8*s**2 + 83*a**3*b**15*c**8*s**2 -
        28*a**2*b**16*c**8*s**2 + 5*a*b**17*c**8*s**2 -
        a**13*b**4*c**9*s**2 + 4*a**12*b**5*c**9*s**2 -
        16*a**11*b**6*c**9*s**2 + 47*a**10*b**7*c**9*s**2 -
        99*a**9*b**8*c**9*s**2 + 159*a**8*b**9*c**9*s**2 -
        198*a**7*b**10*c**9*s**2 + 195*a**6*b**11*c**9*s**2 -
        151*a**5*b**12*c**9*s**2 + 89*a**4*b**13*c**9*s**2 -
        38*a**3*b**14*c**9*s**2 + 10*a**2*b**15*c**9*s**2 -
        a*b**16*c**9*s**2 - a**13*b**3*c**10*s**2 +
        3*a**12*b**4*c**10*s**2 - 16*a**10*b**6*c**10*s**2 +
        47*a**9*b**7*c**10*s**2 - 82*a**8*b**8*c**10*s**2 +
        102*a**7*b**9*c**10*s**2 - 96*a**6*b**10*c**10*s**2 +
        68*a**5*b**11*c**10*s**2 - 35*a**4*b**12*c**10*s**2 +
        12*a**3*b**13*c**10*s**2 - 2*a**2*b**14*c**10*s**2 +
        2*a**13*b**2*c**11*s**2 - 6*a**12*b**3*c**11*s**2 +
        7*a**11*b**4*c**11*s**2 - 16*a**9*b**6*c**11*s**2 +
        33*a**8*b**7*c**11*s**2 - 41*a**7*b**8*c**11*s**2 +
        36*a**6*b**9*c**11*s**2 - 22*a**5*b**10*c**11*s**2 +
        9*a**4*b**11*c**11*s**2 - 2*a**3*b**12*c**11*s**2 -
        2*a**13*b*c**12*s**2 + 5*a**12*b**2*c**12*s**2 -
        6*a**11*b**3*c**12*s**2 + 3*a**10*b**4*c**12*s**2 +
        4*a**9*b**5*c**12*s**2 - 10*a**8*b**6*c**12*s**2 +
        12*a**7*b**7*c**12*s**2 - 9*a**6*b**8*c**12*s**2 +
        4*a**5*b**9*c**12*s**2 - a**4*b**10*c**12*s**2 +
        a**13*c**13*s**2 - 2*a**12*b*c**13*s**2 +
        2*a**11*b**2*c**13*s**2 - a**10*b**3*c**13*s**2 -
        a**9*b**4*c**13*s**2 + 2*a**8*b**5*c**13*s**2 -
        2*a**7*b**6*c**13*s**2 + a**6*b**7*c**13*s**2),
        (-2*a**10*b**6*c**2 - 3*a**9*b**7*c**2 + a**8*b**8*c**2 +
        a**11*b**4*c**3 - 2*a**10*b**5*c**3 - 13*a**9*b**6*c**3 -
        8*a**8*b**7*c**3 - a**6*b**9*c**3 + a**11*b**3*c**4 +
        a**10*b**4*c**4 - 6*a**9*b**5*c**4 - 15*a**8*b**6*c**4 -
        17*a**7*b**7*c**4 - 15*a**6*b**8*c**4 - 6*a**5*b**9*c**4 -
        2*a**10*b**3*c**5 - 6*a**9*b**4*c**5 + a**8*b**5*c**5 -
        4*a**7*b**6*c**5 - 29*a**6*b**7*c**5 - 32*a**5*b**8*c**5 -
        14*a**4*b**9*c**5 - 2*a**10*b**2*c**6 - 13*a**9*b**3*c**6 -
        15*a**8*b**4*c**6 - 4*a**7*b**5*c**6 - 6*a**6*b**6*c**6 -
        15*a**5*b**7*c**6 - 27*a**4*b**8*c**6 - 16*a**3*b**9*c**6 -
        3*a**9*b**2*c**7 - 8*a**8*b**3*c**7 - 17*a**7*b**4*c**7 -
        29*a**6*b**5*c**7 - 15*a**5*b**6*c**7 - 3*a**4*b**7*c**7 -
        14*a**3*b**8*c**7 - 9*a**2*b**9*c**7 + a**8*b**2*c**8 -
        15*a**6*b**4*c**8 - 32*a**5*b**5*c**8 - 27*a**4*b**6*c**8 -
        14*a**3*b**7*c**8 - 7*a**2*b**8*c**8 - 2*a*b**9*c**8 -
        a**6*b**3*c**9 - 6*a**5*b**4*c**9 - 14*a**4*b**5*c**9 -
        16*a**3*b**6*c**9 - 9*a**2*b**7*c**9 - 2*a*b**8*c**9 +
        7*a**10*b**4*c**2*s**2 + 20*a**9*b**5*c**2*s**2 +
        7*a**8*b**6*c**2*s**2 - 5*a**7*b**7*c**2*s**2 -
        a**6*b**8*c**2*s**2 + 14*a**10*b**3*c**3*s**2 +
        91*a**9*b**4*c**3*s**2 + 109*a**8*b**5*c**3*s**2 +
        9*a**7*b**6*c**3*s**2 - 27*a**6*b**7*c**3*s**2 -
        4*a**5*b**8*c**3*s**2 + 7*a**10*b**2*c**4*s**2 +
        91*a**9*b**3*c**4*s**2 + 228*a**8*b**4*c**4*s**2 +
        161*a**7*b**5*c**4*s**2 - 2*a**6*b**6*c**4*s**2 -
        15*a**5*b**7*c**4*s**2 + 4*a**4*b**8*c**4*s**2 +
        20*a**9*b**2*c**5*s**2 + 109*a**8*b**3*c**5*s**2 +
        161*a**7*b**4*c**5*s**2 + 96*a**6*b**5*c**5*s**2 +
        93*a**5*b**6*c**5*s**2 + 95*a**4*b**7*c**5*s**2 +
        27*a**3*b**8*c**5*s**2 + 7*a**8*b**2*c**6*s**2 +
        9*a**7*b**3*c**6*s**2 - 2*a**6*b**4*c**6*s**2 +
        93*a**5*b**5*c**6*s**2 + 230*a**4*b**6*c**6*s**2 +
        163*a**3*b**7*c**6*s**2 + 29*a**2*b**8*c**6*s**2 -
        5*a**7*b**2*c**7*s**2 - 27*a**6*b**3*c**7*s**2 -
        15*a**5*b**4*c**7*s**2 + 95*a**4*b**5*c**7*s**2 +
        163*a**3*b**6*c**7*s**2 + 82*a**2*b**7*c**7*s**2 +
        9*a*b**8*c**7*s**2 - a**6*b**2*c**8*s**2 -
        4*a**5*b**3*c**8*s**2 + 4*a**4*b**4*c**8*s**2 +
        27*a**3*b**5*c**8*s**2 + 29*a**2*b**6*c**8*s**2 +
        9*a*b**7*c**8*s**2 + 10*a**9*b**3*c**2*s**4 +
        22*a**8*b**4*c**2*s**4 + 7*a**7*b**5*c**2*s**4 -
        8*a**6*b**6*c**2*s**4 - 3*a**5*b**7*c**2*s**4 +
        10*a**9*b**2*c**3*s**4 + 55*a**8*b**3*c**3*s**4 +
        69*a**7*b**4*c**3*s**4 + 10*a**6*b**5*c**3*s**4 -
        17*a**5*b**6*c**3*s**4 - 4*a**4*b**7*c**3*s**4 +
        22*a**8*b**2*c**4*s**4 + 69*a**7*b**3*c**4*s**4 +
        59*a**6*b**4*c**4*s**4 + 19*a**5*b**5*c**4*s**4 +
        13*a**4*b**6*c**4*s**4 + 8*a**3*b**7*c**4*s**4 +
        a**2*b**8*c**4*s**4 + 7*a**7*b**2*c**5*s**4 +
        10*a**6*b**3*c**5*s**4 + 19*a**5*b**4*c**5*s**4 +
        58*a**4*b**5*c**5*s**4 + 65*a**3*b**6*c**5*s**4 +
        22*a**2*b**7*c**5*s**4 + 2*a*b**8*c**5*s**4 -
        8*a**6*b**2*c**6*s**4 - 17*a**5*b**3*c**6*s**4 +
        13*a**4*b**4*c**6*s**4 + 65*a**3*b**5*c**6*s**4 +
        55*a**2*b**6*c**6*s**4 + 13*a*b**7*c**6*s**4 -
        3*a**5*b**2*c**7*s**4 - 4*a**4*b**3*c**7*s**4 +
        8*a**3*b**4*c**7*s**4 + 22*a**2*b**5*c**7*s**4 +
        13*a*b**6*c**7*s**4 + b**7*c**7*s**4 + a**2*b**4*c**8*s**4 +
        2*a*b**5*c**8*s**4)/(a**11*b**5*s**2 - 2*a**10*b**6*s**2 +
        a**9*b**7*s**2 - 2*a**11*b**4*c*s**2 + 3*a**10*b**5*c*s**2 +
        2*a**9*b**6*c*s**2 - 5*a**8*b**7*c*s**2 + 2*a**7*b**8*c*s**2 +
        a**11*b**3*c**2*s**2 - a**10*b**4*c**2*s**2 -
        6*a**9*b**5*c**2*s**2 + 9*a**8*b**6*c**2*s**2 +
        a**7*b**7*c**2*s**2 - 6*a**6*b**8*c**2*s**2 +
        2*a**5*b**9*c**2*s**2 + a**11*b**2*c**3*s**2 +
        3*a**9*b**4*c**3*s**2 - 7*a**8*b**5*c**3*s**2 -
        6*a**7*b**6*c**3*s**2 + 13*a**6*b**7*c**3*s**2 -
        a**5*b**8*c**3*s**2 - 4*a**4*b**9*c**3*s**2 +
        a**3*b**10*c**3*s**2 - 2*a**11*b*c**4*s**2 -
        a**10*b**2*c**4*s**2 + 3*a**9*b**3*c**4*s**2 +
        6*a**8*b**4*c**4*s**2 + 3*a**7*b**5*c**4*s**2 -
        15*a**6*b**6*c**4*s**2 - 2*a**5*b**7*c**4*s**2 +
        11*a**4*b**8*c**4*s**2 - 2*a**3*b**9*c**4*s**2 -
        a**2*b**10*c**4*s**2 + a**11*c**5*s**2 + 3*a**10*b*c**5*s**2 -
        6*a**9*b**2*c**5*s**2 - 7*a**8*b**3*c**5*s**2 +
        3*a**7*b**4*c**5*s**2 + 16*a**6*b**5*c**5*s**2 +
        a**5*b**6*c**5*s**2 - 17*a**4*b**7*c**5*s**2 +
        2*a**3*b**8*c**5*s**2 + 5*a**2*b**9*c**5*s**2 -
        a*b**10*c**5*s**2 - 2*a**10*c**6*s**2 + 2*a**9*b*c**6*s**2 +
        9*a**8*b**2*c**6*s**2 - 6*a**7*b**3*c**6*s**2 -
        15*a**6*b**4*c**6*s**2 + a**5*b**5*c**6*s**2 +
        20*a**4*b**6*c**6*s**2 - a**3*b**7*c**6*s**2 -
        11*a**2*b**8*c**6*s**2 + 2*a*b**9*c**6*s**2 + b**10*c**6*s**2
        + a**9*c**7*s**2 - 5*a**8*b*c**7*s**2 + a**7*b**2*c**7*s**2 +
        13*a**6*b**3*c**7*s**2 - 2*a**5*b**4*c**7*s**2 -
        17*a**4*b**5*c**7*s**2 - a**3*b**6*c**7*s**2 +
        14*a**2*b**7*c**7*s**2 - a*b**8*c**7*s**2 - 3*b**9*c**7*s**2 +
        2*a**7*b*c**8*s**2 - 6*a**6*b**2*c**8*s**2 -
        a**5*b**3*c**8*s**2 + 11*a**4*b**4*c**8*s**2 +
        2*a**3*b**5*c**8*s**2 - 11*a**2*b**6*c**8*s**2 -
        a*b**7*c**8*s**2 + 4*b**8*c**8*s**2 + 2*a**5*b**2*c**9*s**2 -
        4*a**4*b**3*c**9*s**2 - 2*a**3*b**4*c**9*s**2 +
        5*a**2*b**5*c**9*s**2 + 2*a*b**6*c**9*s**2 - 3*b**7*c**9*s**2
        + a**3*b**3*c**10*s**2 - a**2*b**4*c**10*s**2 -
        a*b**5*c**10*s**2 + b**6*c**10*s**2), (-2*a**9*b**8*c -
        2*a**8*b**9*c - 9*a**9*b**7*c**2 - 7*a**8*b**8*c**2 -
        9*a**7*b**9*c**2 - 16*a**9*b**6*c**3 - 14*a**8*b**7*c**3 -
        14*a**7*b**8*c**3 - 16*a**6*b**9*c**3 - 14*a**9*b**5*c**4 -
        27*a**8*b**6*c**4 - 3*a**7*b**7*c**4 - 27*a**6*b**8*c**4 -
        14*a**5*b**9*c**4 - 6*a**9*b**4*c**5 - 32*a**8*b**5*c**5 -
        15*a**7*b**6*c**5 - 15*a**6*b**7*c**5 - 32*a**5*b**8*c**5 -
        6*a**4*b**9*c**5 - a**9*b**3*c**6 - 15*a**8*b**4*c**6 -
        29*a**7*b**5*c**6 - 6*a**6*b**6*c**6 - 29*a**5*b**7*c**6 -
        15*a**4*b**8*c**6 - a**3*b**9*c**6 - 17*a**7*b**4*c**7 -
        4*a**6*b**5*c**7 - 4*a**5*b**6*c**7 - 17*a**4*b**7*c**7 +
        a**8*b**2*c**8 - 8*a**7*b**3*c**8 - 15*a**6*b**4*c**8 +
        a**5*b**5*c**8 - 15*a**4*b**6*c**8 - 8*a**3*b**7*c**8 +
        a**2*b**8*c**8 - 3*a**7*b**2*c**9 - 13*a**6*b**3*c**9 -
        6*a**5*b**4*c**9 - 6*a**4*b**5*c**9 - 13*a**3*b**6*c**9 -
        3*a**2*b**7*c**9 - 2*a**6*b**2*c**10 - 2*a**5*b**3*c**10 +
        a**4*b**4*c**10 - 2*a**3*b**5*c**10 - 2*a**2*b**6*c**10 +
        a**4*b**3*c**11 + a**3*b**4*c**11 + 9*a**8*b**7*c*s**2 +
        9*a**7*b**8*c*s**2 + 29*a**8*b**6*c**2*s**2 +
        82*a**7*b**7*c**2*s**2 + 29*a**6*b**8*c**2*s**2 +
        27*a**8*b**5*c**3*s**2 + 163*a**7*b**6*c**3*s**2 +
        163*a**6*b**7*c**3*s**2 + 27*a**5*b**8*c**3*s**2 +
        4*a**8*b**4*c**4*s**2 + 95*a**7*b**5*c**4*s**2 +
        230*a**6*b**6*c**4*s**2 + 95*a**5*b**7*c**4*s**2 +
        4*a**4*b**8*c**4*s**2 - 4*a**8*b**3*c**5*s**2 -
        15*a**7*b**4*c**5*s**2 + 93*a**6*b**5*c**5*s**2 +
        93*a**5*b**6*c**5*s**2 - 15*a**4*b**7*c**5*s**2 -
        4*a**3*b**8*c**5*s**2 - a**8*b**2*c**6*s**2 -
        27*a**7*b**3*c**6*s**2 - 2*a**6*b**4*c**6*s**2 +
        96*a**5*b**5*c**6*s**2 - 2*a**4*b**6*c**6*s**2 -
        27*a**3*b**7*c**6*s**2 - a**2*b**8*c**6*s**2 -
        5*a**7*b**2*c**7*s**2 + 9*a**6*b**3*c**7*s**2 +
        161*a**5*b**4*c**7*s**2 + 161*a**4*b**5*c**7*s**2 +
        9*a**3*b**6*c**7*s**2 - 5*a**2*b**7*c**7*s**2 +
        7*a**6*b**2*c**8*s**2 + 109*a**5*b**3*c**8*s**2 +
        228*a**4*b**4*c**8*s**2 + 109*a**3*b**5*c**8*s**2 +
        7*a**2*b**6*c**8*s**2 + 20*a**5*b**2*c**9*s**2 +
        91*a**4*b**3*c**9*s**2 + 91*a**3*b**4*c**9*s**2 +
        20*a**2*b**5*c**9*s**2 + 7*a**4*b**2*c**10*s**2 +
        14*a**3*b**3*c**10*s**2 + 7*a**2*b**4*c**10*s**2 +
        a**7*b**7*s**4 + 2*a**8*b**5*c*s**4 + 13*a**7*b**6*c*s**4 +
        13*a**6*b**7*c*s**4 + 2*a**5*b**8*c*s**4 + a**8*b**4*c**2*s**4
        + 22*a**7*b**5*c**2*s**4 + 55*a**6*b**6*c**2*s**4 +
        22*a**5*b**7*c**2*s**4 + a**4*b**8*c**2*s**4 +
        8*a**7*b**4*c**3*s**4 + 65*a**6*b**5*c**3*s**4 +
        65*a**5*b**6*c**3*s**4 + 8*a**4*b**7*c**3*s**4 -
        4*a**7*b**3*c**4*s**4 + 13*a**6*b**4*c**4*s**4 +
        58*a**5*b**5*c**4*s**4 + 13*a**4*b**6*c**4*s**4 -
        4*a**3*b**7*c**4*s**4 - 3*a**7*b**2*c**5*s**4 -
        17*a**6*b**3*c**5*s**4 + 19*a**5*b**4*c**5*s**4 +
        19*a**4*b**5*c**5*s**4 - 17*a**3*b**6*c**5*s**4 -
        3*a**2*b**7*c**5*s**4 - 8*a**6*b**2*c**6*s**4 +
        10*a**5*b**3*c**6*s**4 + 59*a**4*b**4*c**6*s**4 +
        10*a**3*b**5*c**6*s**4 - 8*a**2*b**6*c**6*s**4 +
        7*a**5*b**2*c**7*s**4 + 69*a**4*b**3*c**7*s**4 +
        69*a**3*b**4*c**7*s**4 + 7*a**2*b**5*c**7*s**4 +
        22*a**4*b**2*c**8*s**4 + 55*a**3*b**3*c**8*s**4 +
        22*a**2*b**4*c**8*s**4 + 10*a**3*b**2*c**9*s**4 +
        10*a**2*b**3*c**9*s**4)/(a**10*b**6*s**2 - 3*a**9*b**7*s**2 +
        4*a**8*b**8*s**2 - 3*a**7*b**9*s**2 + a**6*b**10*s**2 -
        a**10*b**5*c*s**2 + 2*a**9*b**6*c*s**2 - a**8*b**7*c*s**2 -
        a**7*b**8*c*s**2 + 2*a**6*b**9*c*s**2 - a**5*b**10*c*s**2 -
        a**10*b**4*c**2*s**2 + 5*a**9*b**5*c**2*s**2 -
        11*a**8*b**6*c**2*s**2 + 14*a**7*b**7*c**2*s**2 -
        11*a**6*b**8*c**2*s**2 + 5*a**5*b**9*c**2*s**2 -
        a**4*b**10*c**2*s**2 + a**10*b**3*c**3*s**2 -
        2*a**9*b**4*c**3*s**2 + 2*a**8*b**5*c**3*s**2 -
        a**7*b**6*c**3*s**2 - a**6*b**7*c**3*s**2 +
        2*a**5*b**8*c**3*s**2 - 2*a**4*b**9*c**3*s**2 +
        a**3*b**10*c**3*s**2 - 4*a**9*b**3*c**4*s**2 +
        11*a**8*b**4*c**4*s**2 - 17*a**7*b**5*c**4*s**2 +
        20*a**6*b**6*c**4*s**2 - 17*a**5*b**7*c**4*s**2 +
        11*a**4*b**8*c**4*s**2 - 4*a**3*b**9*c**4*s**2 +
        2*a**9*b**2*c**5*s**2 - a**8*b**3*c**5*s**2 -
        2*a**7*b**4*c**5*s**2 + a**6*b**5*c**5*s**2 +
        a**5*b**6*c**5*s**2 - 2*a**4*b**7*c**5*s**2 -
        a**3*b**8*c**5*s**2 + 2*a**2*b**9*c**5*s**2 -
        6*a**8*b**2*c**6*s**2 + 13*a**7*b**3*c**6*s**2 -
        15*a**6*b**4*c**6*s**2 + 16*a**5*b**5*c**6*s**2 -
        15*a**4*b**6*c**6*s**2 + 13*a**3*b**7*c**6*s**2 -
        6*a**2*b**8*c**6*s**2 + 2*a**8*b*c**7*s**2 +
        a**7*b**2*c**7*s**2 - 6*a**6*b**3*c**7*s**2 +
        3*a**5*b**4*c**7*s**2 + 3*a**4*b**5*c**7*s**2 -
        6*a**3*b**6*c**7*s**2 + a**2*b**7*c**7*s**2 +
        2*a*b**8*c**7*s**2 - 5*a**7*b*c**8*s**2 +
        9*a**6*b**2*c**8*s**2 - 7*a**5*b**3*c**8*s**2 +
        6*a**4*b**4*c**8*s**2 - 7*a**3*b**5*c**8*s**2 +
        9*a**2*b**6*c**8*s**2 - 5*a*b**7*c**8*s**2 + a**7*c**9*s**2 +
        2*a**6*b*c**9*s**2 - 6*a**5*b**2*c**9*s**2 +
        3*a**4*b**3*c**9*s**2 + 3*a**3*b**4*c**9*s**2 -
        6*a**2*b**5*c**9*s**2 + 2*a*b**6*c**9*s**2 + b**7*c**9*s**2 -
        2*a**6*c**10*s**2 + 3*a**5*b*c**10*s**2 - a**4*b**2*c**10*s**2
        - a**2*b**4*c**10*s**2 + 3*a*b**5*c**10*s**2 -
        2*b**6*c**10*s**2 + a**5*c**11*s**2 - 2*a**4*b*c**11*s**2 +
        a**3*b**2*c**11*s**2 + a**2*b**3*c**11*s**2 -
        2*a*b**4*c**11*s**2 + b**5*c**11*s**2), (a**8*b**8*c**2 -
        3*a**7*b**9*c**2 - 2*a**6*b**10*c**2 - a**9*b**6*c**3 -
        8*a**7*b**8*c**3 - 13*a**6*b**9*c**3 - 2*a**5*b**10*c**3 +
        a**4*b**11*c**3 - 6*a**9*b**5*c**4 - 15*a**8*b**6*c**4 -
        17*a**7*b**7*c**4 - 15*a**6*b**8*c**4 - 6*a**5*b**9*c**4 +
        a**4*b**10*c**4 + a**3*b**11*c**4 - 14*a**9*b**4*c**5 -
        32*a**8*b**5*c**5 - 29*a**7*b**6*c**5 - 4*a**6*b**7*c**5 +
        a**5*b**8*c**5 - 6*a**4*b**9*c**5 - 2*a**3*b**10*c**5 -
        16*a**9*b**3*c**6 - 27*a**8*b**4*c**6 - 15*a**7*b**5*c**6 -
        6*a**6*b**6*c**6 - 4*a**5*b**7*c**6 - 15*a**4*b**8*c**6 -
        13*a**3*b**9*c**6 - 2*a**2*b**10*c**6 - 9*a**9*b**2*c**7 -
        14*a**8*b**3*c**7 - 3*a**7*b**4*c**7 - 15*a**6*b**5*c**7 -
        29*a**5*b**6*c**7 - 17*a**4*b**7*c**7 - 8*a**3*b**8*c**7 -
        3*a**2*b**9*c**7 - 2*a**9*b*c**8 - 7*a**8*b**2*c**8 -
        14*a**7*b**3*c**8 - 27*a**6*b**4*c**8 - 32*a**5*b**5*c**8 -
        15*a**4*b**6*c**8 + a**2*b**8*c**8 - 2*a**8*b*c**9 -
        9*a**7*b**2*c**9 - 16*a**6*b**3*c**9 - 14*a**5*b**4*c**9 -
        6*a**4*b**5*c**9 - a**3*b**6*c**9 - a**8*b**6*c**2*s**2 -
        5*a**7*b**7*c**2*s**2 + 7*a**6*b**8*c**2*s**2 +
        20*a**5*b**9*c**2*s**2 + 7*a**4*b**10*c**2*s**2 -
        4*a**8*b**5*c**3*s**2 - 27*a**7*b**6*c**3*s**2 +
        9*a**6*b**7*c**3*s**2 + 109*a**5*b**8*c**3*s**2 +
        91*a**4*b**9*c**3*s**2 + 14*a**3*b**10*c**3*s**2 +
        4*a**8*b**4*c**4*s**2 - 15*a**7*b**5*c**4*s**2 -
        2*a**6*b**6*c**4*s**2 + 161*a**5*b**7*c**4*s**2 +
        228*a**4*b**8*c**4*s**2 + 91*a**3*b**9*c**4*s**2 +
        7*a**2*b**10*c**4*s**2 + 27*a**8*b**3*c**5*s**2 +
        95*a**7*b**4*c**5*s**2 + 93*a**6*b**5*c**5*s**2 +
        96*a**5*b**6*c**5*s**2 + 161*a**4*b**7*c**5*s**2 +
        109*a**3*b**8*c**5*s**2 + 20*a**2*b**9*c**5*s**2 +
        29*a**8*b**2*c**6*s**2 + 163*a**7*b**3*c**6*s**2 +
        230*a**6*b**4*c**6*s**2 + 93*a**5*b**5*c**6*s**2 -
        2*a**4*b**6*c**6*s**2 + 9*a**3*b**7*c**6*s**2 +
        7*a**2*b**8*c**6*s**2 + 9*a**8*b*c**7*s**2 +
        82*a**7*b**2*c**7*s**2 + 163*a**6*b**3*c**7*s**2 +
        95*a**5*b**4*c**7*s**2 - 15*a**4*b**5*c**7*s**2 -
        27*a**3*b**6*c**7*s**2 - 5*a**2*b**7*c**7*s**2 +
        9*a**7*b*c**8*s**2 + 29*a**6*b**2*c**8*s**2 +
        27*a**5*b**3*c**8*s**2 + 4*a**4*b**4*c**8*s**2 -
        4*a**3*b**5*c**8*s**2 - a**2*b**6*c**8*s**2 -
        3*a**7*b**5*c**2*s**4 - 8*a**6*b**6*c**2*s**4 +
        7*a**5*b**7*c**2*s**4 + 22*a**4*b**8*c**2*s**4 +
        10*a**3*b**9*c**2*s**4 - 4*a**7*b**4*c**3*s**4 -
        17*a**6*b**5*c**3*s**4 + 10*a**5*b**6*c**3*s**4 +
        69*a**4*b**7*c**3*s**4 + 55*a**3*b**8*c**3*s**4 +
        10*a**2*b**9*c**3*s**4 + a**8*b**2*c**4*s**4 +
        8*a**7*b**3*c**4*s**4 + 13*a**6*b**4*c**4*s**4 +
        19*a**5*b**5*c**4*s**4 + 59*a**4*b**6*c**4*s**4 +
        69*a**3*b**7*c**4*s**4 + 22*a**2*b**8*c**4*s**4 +
        2*a**8*b*c**5*s**4 + 22*a**7*b**2*c**5*s**4 +
        65*a**6*b**3*c**5*s**4 + 58*a**5*b**4*c**5*s**4 +
        19*a**4*b**5*c**5*s**4 + 10*a**3*b**6*c**5*s**4 +
        7*a**2*b**7*c**5*s**4 + 13*a**7*b*c**6*s**4 +
        55*a**6*b**2*c**6*s**4 + 65*a**5*b**3*c**6*s**4 +
        13*a**4*b**4*c**6*s**4 - 17*a**3*b**5*c**6*s**4 -
        8*a**2*b**6*c**6*s**4 + a**7*c**7*s**4 + 13*a**6*b*c**7*s**4 +
        22*a**5*b**2*c**7*s**4 + 8*a**4*b**3*c**7*s**4 -
        4*a**3*b**4*c**7*s**4 - 3*a**2*b**5*c**7*s**4 +
        2*a**5*b*c**8*s**4 + a**4*b**2*c**8*s**4)/(a**7*b**9*s**2 -
        2*a**6*b**10*s**2 + a**5*b**11*s**2 + 2*a**8*b**7*c*s**2 -
        5*a**7*b**8*c*s**2 + 2*a**6*b**9*c*s**2 + 3*a**5*b**10*c*s**2
        - 2*a**4*b**11*c*s**2 + 2*a**9*b**5*c**2*s**2 -
        6*a**8*b**6*c**2*s**2 + a**7*b**7*c**2*s**2 +
        9*a**6*b**8*c**2*s**2 - 6*a**5*b**9*c**2*s**2 -
        a**4*b**10*c**2*s**2 + a**3*b**11*c**2*s**2 +
        a**10*b**3*c**3*s**2 - 4*a**9*b**4*c**3*s**2 -
        a**8*b**5*c**3*s**2 + 13*a**7*b**6*c**3*s**2 -
        6*a**6*b**7*c**3*s**2 - 7*a**5*b**8*c**3*s**2 +
        3*a**4*b**9*c**3*s**2 + a**2*b**11*c**3*s**2 -
        a**10*b**2*c**4*s**2 - 2*a**9*b**3*c**4*s**2 +
        11*a**8*b**4*c**4*s**2 - 2*a**7*b**5*c**4*s**2 -
        15*a**6*b**6*c**4*s**2 + 3*a**5*b**7*c**4*s**2 +
        6*a**4*b**8*c**4*s**2 + 3*a**3*b**9*c**4*s**2 -
        a**2*b**10*c**4*s**2 - 2*a*b**11*c**4*s**2 - a**10*b*c**5*s**2
        + 5*a**9*b**2*c**5*s**2 + 2*a**8*b**3*c**5*s**2 -
        17*a**7*b**4*c**5*s**2 + a**6*b**5*c**5*s**2 +
        16*a**5*b**6*c**5*s**2 + 3*a**4*b**7*c**5*s**2 -
        7*a**3*b**8*c**5*s**2 - 6*a**2*b**9*c**5*s**2 +
        3*a*b**10*c**5*s**2 + b**11*c**5*s**2 + a**10*c**6*s**2 +
        2*a**9*b*c**6*s**2 - 11*a**8*b**2*c**6*s**2 -
        a**7*b**3*c**6*s**2 + 20*a**6*b**4*c**6*s**2 +
        a**5*b**5*c**6*s**2 - 15*a**4*b**6*c**6*s**2 -
        6*a**3*b**7*c**6*s**2 + 9*a**2*b**8*c**6*s**2 +
        2*a*b**9*c**6*s**2 - 2*b**10*c**6*s**2 - 3*a**9*c**7*s**2 -
        a**8*b*c**7*s**2 + 14*a**7*b**2*c**7*s**2 -
        a**6*b**3*c**7*s**2 - 17*a**5*b**4*c**7*s**2 -
        2*a**4*b**5*c**7*s**2 + 13*a**3*b**6*c**7*s**2 +
        a**2*b**7*c**7*s**2 - 5*a*b**8*c**7*s**2 + b**9*c**7*s**2 +
        4*a**8*c**8*s**2 - a**7*b*c**8*s**2 - 11*a**6*b**2*c**8*s**2 +
        2*a**5*b**3*c**8*s**2 + 11*a**4*b**4*c**8*s**2 -
        a**3*b**5*c**8*s**2 - 6*a**2*b**6*c**8*s**2 +
        2*a*b**7*c**8*s**2 - 3*a**7*c**9*s**2 + 2*a**6*b*c**9*s**2 +
        5*a**5*b**2*c**9*s**2 - 2*a**4*b**3*c**9*s**2 -
        4*a**3*b**4*c**9*s**2 + 2*a**2*b**5*c**9*s**2 +
        a**6*c**10*s**2 - a**5*b*c**10*s**2 - a**4*b**2*c**10*s**2 +
        a**3*b**3*c**10*s**2), (2*a**8*b**7*c + 2*a**7*b**8*c +
        11*a**8*b**6*c**2 + 20*a**7*b**7*c**2 + 11*a**6*b**8*c**2 +
        23*a**8*b**5*c**3 + 60*a**7*b**6*c**3 + 60*a**6*b**7*c**3 +
        23*a**5*b**8*c**3 + 28*a**8*b**4*c**4 + 90*a**7*b**5*c**4 +
        120*a**6*b**6*c**4 + 90*a**5*b**7*c**4 + 28*a**4*b**8*c**4 +
        23*a**8*b**3*c**5 + 90*a**7*b**4*c**5 + 140*a**6*b**5*c**5 +
        140*a**5*b**6*c**5 + 90*a**4*b**7*c**5 + 23*a**3*b**8*c**5 +
        11*a**8*b**2*c**6 + 60*a**7*b**3*c**6 + 120*a**6*b**4*c**6 +
        140*a**5*b**5*c**6 + 120*a**4*b**6*c**6 + 60*a**3*b**7*c**6 +
        11*a**2*b**8*c**6 + 2*a**8*b*c**7 + 20*a**7*b**2*c**7 +
        60*a**6*b**3*c**7 + 90*a**5*b**4*c**7 + 90*a**4*b**5*c**7 +
        60*a**3*b**6*c**7 + 20*a**2*b**7*c**7 + 2*a*b**8*c**7 +
        2*a**7*b*c**8 + 11*a**6*b**2*c**8 + 23*a**5*b**3*c**8 +
        28*a**4*b**4*c**8 + 23*a**3*b**5*c**8 + 11*a**2*b**6*c**8 +
        2*a*b**7*c**8 - a**8*b**5*c*s**2 - 7*a**7*b**6*c*s**2 -
        7*a**6*b**7*c*s**2 - a**5*b**8*c*s**2 - 6*a**8*b**4*c**2*s**2
        - 56*a**7*b**5*c**2*s**2 - 104*a**6*b**6*c**2*s**2 -
        56*a**5*b**7*c**2*s**2 - 6*a**4*b**8*c**2*s**2 -
        10*a**8*b**3*c**3*s**2 - 139*a**7*b**4*c**3*s**2 -
        402*a**6*b**5*c**3*s**2 - 402*a**5*b**6*c**3*s**2 -
        139*a**4*b**7*c**3*s**2 - 10*a**3*b**8*c**3*s**2 -
        6*a**8*b**2*c**4*s**2 - 139*a**7*b**3*c**4*s**2 -
        614*a**6*b**4*c**4*s**2 - 970*a**5*b**5*c**4*s**2 -
        614*a**4*b**6*c**4*s**2 - 139*a**3*b**7*c**4*s**2 -
        6*a**2*b**8*c**4*s**2 - a**8*b*c**5*s**2 -
        56*a**7*b**2*c**5*s**2 - 402*a**6*b**3*c**5*s**2 -
        970*a**5*b**4*c**5*s**2 - 970*a**4*b**5*c**5*s**2 -
        402*a**3*b**6*c**5*s**2 - 56*a**2*b**7*c**5*s**2 -
        a*b**8*c**5*s**2 - 7*a**7*b*c**6*s**2 -
        104*a**6*b**2*c**6*s**2 - 402*a**5*b**3*c**6*s**2 -
        614*a**4*b**4*c**6*s**2 - 402*a**3*b**5*c**6*s**2 -
        104*a**2*b**6*c**6*s**2 - 7*a*b**7*c**6*s**2 -
        7*a**6*b*c**7*s**2 - 56*a**5*b**2*c**7*s**2 -
        139*a**4*b**3*c**7*s**2 - 139*a**3*b**4*c**7*s**2 -
        56*a**2*b**5*c**7*s**2 - 7*a*b**6*c**7*s**2 - a**5*b*c**8*s**2
        - 6*a**4*b**2*c**8*s**2 - 10*a**3*b**3*c**8*s**2 -
        6*a**2*b**4*c**8*s**2 - a*b**5*c**8*s**2 - 3*a**7*b**4*c*s**4
        - 12*a**6*b**5*c*s**4 - 12*a**5*b**6*c*s**4 -
        3*a**4*b**7*c*s**4 - 9*a**7*b**3*c**2*s**4 -
        54*a**6*b**4*c**2*s**4 - 92*a**5*b**5*c**2*s**4 -
        54*a**4*b**6*c**2*s**4 - 9*a**3*b**7*c**2*s**4 -
        9*a**7*b**2*c**3*s**4 - 86*a**6*b**3*c**3*s**4 -
        230*a**5*b**4*c**3*s**4 - 230*a**4*b**5*c**3*s**4 -
        86*a**3*b**6*c**3*s**4 - 9*a**2*b**7*c**3*s**4 -
        3*a**7*b*c**4*s**4 - 54*a**6*b**2*c**4*s**4 -
        230*a**5*b**3*c**4*s**4 - 362*a**4*b**4*c**4*s**4 -
        230*a**3*b**5*c**4*s**4 - 54*a**2*b**6*c**4*s**4 -
        3*a*b**7*c**4*s**4 - 12*a**6*b*c**5*s**4 -
        92*a**5*b**2*c**5*s**4 - 230*a**4*b**3*c**5*s**4 -
        230*a**3*b**4*c**5*s**4 - 92*a**2*b**5*c**5*s**4 -
        12*a*b**6*c**5*s**4 - 12*a**5*b*c**6*s**4 -
        54*a**4*b**2*c**6*s**4 - 86*a**3*b**3*c**6*s**4 -
        54*a**2*b**4*c**6*s**4 - 12*a*b**5*c**6*s**4 -
        3*a**4*b*c**7*s**4 - 9*a**3*b**2*c**7*s**4 -
        9*a**2*b**3*c**7*s**4 - 3*a*b**4*c**7*s**4)/(a**8*b**6*s**2 -
        2*a**7*b**7*s**2 + a**6*b**8*s**2 + a**9*b**4*c*s**2 -
        3*a**8*b**5*c*s**2 + 2*a**7*b**6*c*s**2 + 2*a**6*b**7*c*s**2 -
        3*a**5*b**8*c*s**2 + a**4*b**9*c*s**2 - a**9*b**3*c**2*s**2 +
        5*a**7*b**5*c**2*s**2 - 8*a**6*b**6*c**2*s**2 +
        5*a**5*b**7*c**2*s**2 - a**3*b**9*c**2*s**2 -
        a**9*b**2*c**3*s**2 + 4*a**8*b**3*c**3*s**2 -
        5*a**7*b**4*c**3*s**2 + 2*a**6*b**5*c**3*s**2 +
        2*a**5*b**6*c**3*s**2 - 5*a**4*b**7*c**3*s**2 +
        4*a**3*b**8*c**3*s**2 - a**2*b**9*c**3*s**2 + a**9*b*c**4*s**2
        - 5*a**7*b**3*c**4*s**2 + 6*a**6*b**4*c**4*s**2 -
        4*a**5*b**5*c**4*s**2 + 6*a**4*b**6*c**4*s**2 -
        5*a**3*b**7*c**4*s**2 + a*b**9*c**4*s**2 - 3*a**8*b*c**5*s**2
        + 5*a**7*b**2*c**5*s**2 + 2*a**6*b**3*c**5*s**2 -
        4*a**5*b**4*c**5*s**2 - 4*a**4*b**5*c**5*s**2 +
        2*a**3*b**6*c**5*s**2 + 5*a**2*b**7*c**5*s**2 -
        3*a*b**8*c**5*s**2 + a**8*c**6*s**2 + 2*a**7*b*c**6*s**2 -
        8*a**6*b**2*c**6*s**2 + 2*a**5*b**3*c**6*s**2 +
        6*a**4*b**4*c**6*s**2 + 2*a**3*b**5*c**6*s**2 -
        8*a**2*b**6*c**6*s**2 + 2*a*b**7*c**6*s**2 + b**8*c**6*s**2 -
        2*a**7*c**7*s**2 + 2*a**6*b*c**7*s**2 + 5*a**5*b**2*c**7*s**2
        - 5*a**4*b**3*c**7*s**2 - 5*a**3*b**4*c**7*s**2 +
        5*a**2*b**5*c**7*s**2 + 2*a*b**6*c**7*s**2 - 2*b**7*c**7*s**2
        + a**6*c**8*s**2 - 3*a**5*b*c**8*s**2 + 4*a**3*b**3*c**8*s**2
        - 3*a*b**5*c**8*s**2 + b**6*c**8*s**2 + a**4*b*c**9*s**2 -
        a**3*b**2*c**9*s**2 - a**2*b**3*c**9*s**2 + a*b**4*c**9*s**2),
        (2*a**8*b**11*c + 2*a**7*b**12*c + 9*a**8*b**10*c**2 +
        9*a**7*b**11*c**2 + 11*a**6*b**12*c**2 + 9*a**8*b**9*c**3 +
        30*a**7*b**10*c**3 + 20*a**6*b**11*c**3 + 26*a**5*b**12*c**3 +
        5*a**8*b**8*c**4 + 29*a**7*b**9*c**4 + 44*a**6*b**10*c**4 +
        33*a**5*b**11*c**4 + 34*a**4*b**12*c**4 + 12*a**8*b**7*c**5 +
        18*a**7*b**8*c**5 + 51*a**6*b**9*c**5 + 45*a**5*b**10*c**5 +
        39*a**4*b**11*c**5 + 26*a**3*b**12*c**5 + 8*a**8*b**6*c**6 +
        35*a**7*b**7*c**6 + 29*a**6*b**8*c**6 + 61*a**5*b**9*c**6 +
        32*a**4*b**10*c**6 + 26*a**3*b**11*c**6 + 11*a**2*b**12*c**6 +
        22*a**7*b**6*c**7 + 38*a**6*b**7*c**7 + 22*a**5*b**8*c**7 +
        39*a**4*b**9*c**7 + 8*a**3*b**10*c**7 + 7*a**2*b**11*c**7 +
        2*a*b**12*c**7 + 3*a**8*b**4*c**8 + 8*a**7*b**5*c**8 +
        34*a**6*b**6*c**8 + 24*a**5*b**7*c**8 + 9*a**4*b**8*c**8 +
        10*a**3*b**9*c**8 - 3*a**2*b**10*c**8 + 2*a**8*b**3*c**9 +
        11*a**7*b**4*c**9 + 17*a**6*b**5*c**9 + 34*a**5*b**6*c**9 +
        15*a**4*b**7*c**9 + 7*a**3*b**8*c**9 + 2*a**2*b**9*c**9 -
        a*b**10*c**9 + 7*a**7*b**3*c**10 + 10*a**6*b**4*c**10 +
        7*a**5*b**5*c**10 + 16*a**4*b**6*c**10 + 6*a**3*b**7*c**10 +
        4*a**2*b**8*c**10 + a*b**9*c**10 + a**7*b**2*c**11 +
        6*a**6*b**3*c**11 - 4*a**4*b**5*c**11 + 2*a**3*b**6*c**11 +
        a**6*b**2*c**12 + a**5*b**3*c**12 - 2*a**4*b**4*c**12 -
        2*a**3*b**5*c**12 - 9*a**7*b**10*c*s**2 - 12*a**6*b**11*c*s**2
        + 3*a**5*b**12*c*s**2 - 4*a**8*b**8*c**2*s**2 -
        33*a**7*b**9*c**2*s**2 - 83*a**6*b**10*c**2*s**2 -
        45*a**5*b**11*c**2*s**2 + 7*a**4*b**12*c**2*s**2 -
        5*a**8*b**7*c**3*s**2 - 60*a**7*b**8*c**3*s**2 -
        168*a**6*b**9*c**3*s**2 - 220*a**5*b**10*c**3*s**2 -
        72*a**4*b**11*c**3*s**2 + 5*a**3*b**12*c**3*s**2 +
        3*a**8*b**6*c**4*s**2 - 28*a**7*b**7*c**4*s**2 -
        170*a**6*b**8*c**4*s**2 - 292*a**5*b**9*c**4*s**2 -
        263*a**4*b**10*c**4*s**2 - 59*a**3*b**11*c**4*s**2 +
        a**2*b**12*c**4*s**2 + a**8*b**5*c**5*s**2 +
        21*a**7*b**6*c**5*s**2 - 40*a**6*b**7*c**5*s**2 -
        167*a**5*b**8*c**5*s**2 - 211*a**4*b**9*c**5*s**2 -
        156*a**3*b**10*c**5*s**2 - 24*a**2*b**11*c**5*s**2 -
        5*a**8*b**4*c**6*s**2 - 25*a**7*b**5*c**6*s**2 +
        a**6*b**6*c**6*s**2 - 33*a**5*b**7*c**6*s**2 -
        32*a**4*b**8*c**6*s**2 - 44*a**3*b**9*c**6*s**2 -
        42*a**2*b**10*c**6*s**2 - 4*a*b**11*c**6*s**2 -
        2*a**8*b**3*c**7*s**2 - 53*a**7*b**4*c**7*s**2 -
        159*a**6*b**5*c**7*s**2 - 134*a**5*b**6*c**7*s**2 -
        62*a**4*b**7*c**7*s**2 + 32*a**3*b**8*c**7*s**2 +
        15*a**2*b**9*c**7*s**2 - 3*a*b**10*c**7*s**2 -
        16*a**7*b**3*c**8*s**2 - 159*a**6*b**4*c**8*s**2 -
        319*a**5*b**5*c**8*s**2 - 230*a**4*b**6*c**8*s**2 -
        80*a**3*b**7*c**8*s**2 + 9*a**2*b**8*c**8*s**2 +
        5*a*b**9*c**8*s**2 + a**7*b**2*c**9*s**2 -
        34*a**6*b**3*c**9*s**2 - 198*a**5*b**4*c**9*s**2 -
        270*a**4*b**5*c**9*s**2 - 141*a**3*b**6*c**9*s**2 -
        38*a**2*b**7*c**9*s**2 - 2*a*b**8*c**9*s**2 +
        4*a**6*b**2*c**10*s**2 - 27*a**5*b**3*c**10*s**2 -
        104*a**4*b**4*c**10*s**2 - 91*a**3*b**5*c**10*s**2 -
        28*a**2*b**6*c**10*s**2 - 4*a*b**7*c**10*s**2 +
        3*a**5*b**2*c**11*s**2 - 7*a**4*b**3*c**11*s**2 -
        17*a**3*b**4*c**11*s**2 - 7*a**2*b**5*c**11*s**2 -
        2*a**6*b**10*s**4 + a**4*b**12*s**4 - 4*a**7*b**8*c*s**4 -
        12*a**6*b**9*c*s**4 - 18*a**5*b**10*c*s**4 + a**4*b**11*c*s**4
        + 2*a**3*b**12*c*s**4 - 5*a**7*b**7*c**2*s**4 -
        31*a**6*b**8*c**2*s**4 - 54*a**5*b**9*c**2*s**4 -
        43*a**4*b**10*c**2*s**4 + a**3*b**11*c**2*s**4 +
        a**2*b**12*c**2*s**4 - 28*a**6*b**7*c**3*s**4 -
        76*a**5*b**8*c**3*s**4 - 94*a**4*b**9*c**3*s**4 -
        48*a**3*b**10*c**3*s**4 - a**2*b**11*c**3*s**4 +
        2*a**7*b**5*c**4*s**4 + 5*a**6*b**6*c**4*s**4 -
        48*a**5*b**7*c**4*s**4 - 74*a**4*b**8*c**4*s**4 -
        79*a**3*b**9*c**4*s**4 - 27*a**2*b**10*c**4*s**4 -
        a*b**11*c**4*s**4 - 3*a**7*b**4*c**5*s**4 +
        3*a**6*b**5*c**5*s**4 + 10*a**5*b**6*c**5*s**4 -
        29*a**4*b**7*c**5*s**4 - 17*a**3*b**8*c**5*s**4 -
        32*a**2*b**9*c**5*s**4 - 6*a*b**10*c**5*s**4 -
        2*a**7*b**3*c**6*s**4 - 28*a**6*b**4*c**6*s**4 -
        28*a**5*b**5*c**6*s**4 - 12*a**4*b**6*c**6*s**4 -
        2*a**3*b**7*c**6*s**4 + 16*a**2*b**8*c**6*s**4 -
        5*a*b**9*c**6*s**4 - 16*a**6*b**3*c**7*s**4 -
        84*a**5*b**4*c**7*s**4 - 80*a**4*b**5*c**7*s**4 -
        42*a**3*b**6*c**7*s**4 - a**2*b**7*c**7*s**4 +
        8*a*b**8*c**7*s**4 - 36*a**5*b**3*c**8*s**4 -
        106*a**4*b**4*c**8*s**4 - 73*a**3*b**5*c**8*s**4 -
        33*a**2*b**6*c**8*s**4 - 3*a*b**7*c**8*s**4 -
        32*a**4*b**3*c**9*s**4 - 57*a**3*b**4*c**9*s**4 -
        22*a**2*b**5*c**9*s**4 - 8*a*b**6*c**9*s**4 -
        10*a**3*b**3*c**10*s**4 -
        10*a**2*b**4*c**10*s**4)/(a**8*b**10*s**2 - 2*a**7*b**11*s**2
        + 2*a**6*b**12*s**2 - 2*a**5*b**13*s**2 + a**4*b**14*s**2 +
        a**9*b**8*c*s**2 - 4*a**8*b**9*c*s**2 + 6*a**7*b**10*c*s**2 -
        6*a**6*b**11*c*s**2 + 5*a**5*b**12*c*s**2 -
        2*a**4*b**13*c*s**2 - 2*a**9*b**7*c**2*s**2 +
        5*a**8*b**8*c**2*s**2 - 6*a**7*b**9*c**2*s**2 +
        5*a**6*b**10*c**2*s**2 - 2*a**5*b**11*c**2*s**2 -
        a**4*b**12*c**2*s**2 + 2*a**3*b**13*c**2*s**2 -
        a**2*b**14*c**2*s**2 + a**9*b**6*c**3*s**2 -
        a**8*b**7*c**3*s**2 - a**7*b**8*c**3*s**2 +
        5*a**6*b**9*c**3*s**2 - 9*a**5*b**10*c**3*s**2 +
        9*a**4*b**11*c**3*s**2 - 7*a**3*b**12*c**3*s**2 +
        3*a**2*b**13*c**3*s**2 + a**9*b**5*c**4*s**2 -
        4*a**8*b**6*c**4*s**2 + 8*a**7*b**7*c**4*s**2 -
        15*a**6*b**8*c**4*s**2 + 18*a**5*b**9*c**4*s**2 -
        14*a**4*b**10*c**4*s**2 + 10*a**3*b**11*c**4*s**2 -
        3*a**2*b**12*c**4*s**2 - a*b**13*c**4*s**2 -
        2*a**9*b**4*c**5*s**2 + 4*a**8*b**5*c**5*s**2 -
        6*a**7*b**6*c**5*s**2 + 13*a**6*b**7*c**5*s**2 -
        12*a**5*b**8*c**5*s**2 + 6*a**4*b**9*c**5*s**2 -
        4*a**3*b**10*c**5*s**2 - 3*a**2*b**11*c**5*s**2 +
        4*a*b**12*c**5*s**2 + a**9*b**3*c**6*s**2 +
        a**8*b**4*c**6*s**2 - 2*a**7*b**5*c**6*s**2 -
        2*a**6*b**6*c**6*s**2 - 4*a**5*b**7*c**6*s**2 +
        9*a**4*b**8*c**6*s**2 - 8*a**3*b**9*c**6*s**2 +
        12*a**2*b**10*c**6*s**2 - 7*a*b**11*c**6*s**2 -
        4*a**8*b**3*c**7*s**2 + 5*a**7*b**4*c**7*s**2 -
        3*a**6*b**5*c**7*s**2 + 12*a**5*b**6*c**7*s**2 -
        15*a**4*b**7*c**7*s**2 + 13*a**3*b**8*c**7*s**2 -
        15*a**2*b**9*c**7*s**2 + 6*a*b**10*c**7*s**2 + b**11*c**7*s**2
        + 3*a**8*b**2*c**8*s**2 - a**7*b**3*c**8*s**2 -
        a**6*b**4*c**8*s**2 - 8*a**5*b**5*c**8*s**2 +
        8*a**4*b**6*c**8*s**2 - 7*a**3*b**7*c**8*s**2 +
        9*a**2*b**8*c**8*s**2 - 3*b**10*c**8*s**2 - a**8*b*c**9*s**2 -
        3*a**7*b**2*c**9*s**2 + 4*a**6*b**3*c**9*s**2 +
        2*a**5*b**4*c**9*s**2 + a**4*b**5*c**9*s**2 -
        a**3*b**6*c**9*s**2 - 6*a*b**8*c**9*s**2 + 4*b**9*c**9*s**2 +
        3*a**7*b*c**10*s**2 - 2*a**6*b**2*c**10*s**2 -
        a**5*b**3*c**10*s**2 - 3*a**4*b**4*c**10*s**2 +
        3*a**3*b**5*c**10*s**2 - 4*a**2*b**6*c**10*s**2 +
        7*a*b**7*c**10*s**2 - 3*b**8*c**10*s**2 - a**7*c**11*s**2 -
        a**6*b*c**11*s**2 + 2*a**5*b**2*c**11*s**2 +
        a**4*b**3*c**11*s**2 - a**3*b**4*c**11*s**2 +
        3*a**2*b**5*c**11*s**2 - 4*a*b**6*c**11*s**2 + b**7*c**11*s**2
        + a**6*c**12*s**2 - a**5*b*c**12*s**2 - a**2*b**4*c**12*s**2 +
        a*b**5*c**12*s**2), (2*a**12*b**7*c - a**10*b**9*c +
        a**9*b**10*c + 11*a**12*b**6*c**2 + 7*a**11*b**7*c**2 -
        3*a**10*b**8*c**2 + 2*a**9*b**9*c**2 + 4*a**8*b**10*c**2 +
        26*a**12*b**5*c**3 + 26*a**11*b**6*c**3 + 8*a**10*b**7*c**3 +
        10*a**9*b**8*c**3 + 7*a**8*b**9*c**3 + 6*a**7*b**10*c**3 +
        2*a**6*b**11*c**3 - 2*a**5*b**12*c**3 + 34*a**12*b**4*c**4 +
        39*a**11*b**5*c**4 + 32*a**10*b**6*c**4 + 39*a**9*b**7*c**4 +
        9*a**8*b**8*c**4 + 15*a**7*b**9*c**4 + 16*a**6*b**10*c**4 -
        4*a**5*b**11*c**4 - 2*a**4*b**12*c**4 + 26*a**12*b**3*c**5 +
        33*a**11*b**4*c**5 + 45*a**10*b**5*c**5 + 61*a**9*b**6*c**5 +
        22*a**8*b**7*c**5 + 24*a**7*b**8*c**5 + 34*a**6*b**9*c**5 +
        7*a**5*b**10*c**5 + a**3*b**12*c**5 + 11*a**12*b**2*c**6 +
        20*a**11*b**3*c**6 + 44*a**10*b**4*c**6 + 51*a**9*b**5*c**6 +
        29*a**8*b**6*c**6 + 38*a**7*b**7*c**6 + 34*a**6*b**8*c**6 +
        17*a**5*b**9*c**6 + 10*a**4*b**10*c**6 + 6*a**3*b**11*c**6 +
        a**2*b**12*c**6 + 2*a**12*b*c**7 + 9*a**11*b**2*c**7 +
        30*a**10*b**3*c**7 + 29*a**9*b**4*c**7 + 18*a**8*b**5*c**7 +
        35*a**7*b**6*c**7 + 22*a**6*b**7*c**7 + 8*a**5*b**8*c**7 +
        11*a**4*b**9*c**7 + 7*a**3*b**10*c**7 + a**2*b**11*c**7 +
        2*a**11*b*c**8 + 9*a**10*b**2*c**8 + 9*a**9*b**3*c**8 +
        5*a**8*b**4*c**8 + 12*a**7*b**5*c**8 + 8*a**6*b**6*c**8 +
        3*a**4*b**8*c**8 + 2*a**3*b**9*c**8 - 4*a**11*b**6*c*s**2 -
        3*a**10*b**7*c*s**2 + 5*a**9*b**8*c*s**2 - 2*a**8*b**9*c*s**2
        - 4*a**7*b**10*c*s**2 + a**12*b**4*c**2*s**2 -
        24*a**11*b**5*c**2*s**2 - 42*a**10*b**6*c**2*s**2 +
        15*a**9*b**7*c**2*s**2 + 9*a**8*b**8*c**2*s**2 -
        38*a**7*b**9*c**2*s**2 - 28*a**6*b**10*c**2*s**2 -
        7*a**5*b**11*c**2*s**2 + 5*a**12*b**3*c**3*s**2 -
        59*a**11*b**4*c**3*s**2 - 156*a**10*b**5*c**3*s**2 -
        44*a**9*b**6*c**3*s**2 + 32*a**8*b**7*c**3*s**2 -
        80*a**7*b**8*c**3*s**2 - 141*a**6*b**9*c**3*s**2 -
        91*a**5*b**10*c**3*s**2 - 17*a**4*b**11*c**3*s**2 +
        7*a**12*b**2*c**4*s**2 - 72*a**11*b**3*c**4*s**2 -
        263*a**10*b**4*c**4*s**2 - 211*a**9*b**5*c**4*s**2 -
        32*a**8*b**6*c**4*s**2 - 62*a**7*b**7*c**4*s**2 -
        230*a**6*b**8*c**4*s**2 - 270*a**5*b**9*c**4*s**2 -
        104*a**4*b**10*c**4*s**2 - 7*a**3*b**11*c**4*s**2 +
        3*a**12*b*c**5*s**2 - 45*a**11*b**2*c**5*s**2 -
        220*a**10*b**3*c**5*s**2 - 292*a**9*b**4*c**5*s**2 -
        167*a**8*b**5*c**5*s**2 - 33*a**7*b**6*c**5*s**2 -
        134*a**6*b**7*c**5*s**2 - 319*a**5*b**8*c**5*s**2 -
        198*a**4*b**9*c**5*s**2 - 27*a**3*b**10*c**5*s**2 +
        3*a**2*b**11*c**5*s**2 - 12*a**11*b*c**6*s**2 -
        83*a**10*b**2*c**6*s**2 - 168*a**9*b**3*c**6*s**2 -
        170*a**8*b**4*c**6*s**2 - 40*a**7*b**5*c**6*s**2 +
        a**6*b**6*c**6*s**2 - 159*a**5*b**7*c**6*s**2 -
        159*a**4*b**8*c**6*s**2 - 34*a**3*b**9*c**6*s**2 +
        4*a**2*b**10*c**6*s**2 - 9*a**10*b*c**7*s**2 -
        33*a**9*b**2*c**7*s**2 - 60*a**8*b**3*c**7*s**2 -
        28*a**7*b**4*c**7*s**2 + 21*a**6*b**5*c**7*s**2 -
        25*a**5*b**6*c**7*s**2 - 53*a**4*b**7*c**7*s**2 -
        16*a**3*b**8*c**7*s**2 + a**2*b**9*c**7*s**2 -
        4*a**8*b**2*c**8*s**2 - 5*a**7*b**3*c**8*s**2 +
        3*a**6*b**4*c**8*s**2 + a**5*b**5*c**8*s**2 -
        5*a**4*b**6*c**8*s**2 - 2*a**3*b**7*c**8*s**2 -
        a**11*b**4*c*s**4 - 6*a**10*b**5*c*s**4 - 5*a**9*b**6*c*s**4 +
        8*a**8*b**7*c*s**4 - 3*a**7*b**8*c*s**4 - 8*a**6*b**9*c*s**4 +
        a**12*b**2*c**2*s**4 - a**11*b**3*c**2*s**4 -
        27*a**10*b**4*c**2*s**4 - 32*a**9*b**5*c**2*s**4 +
        16*a**8*b**6*c**2*s**4 - a**7*b**7*c**2*s**4 -
        33*a**6*b**8*c**2*s**4 - 22*a**5*b**9*c**2*s**4 -
        10*a**4*b**10*c**2*s**4 + 2*a**12*b*c**3*s**4 +
        a**11*b**2*c**3*s**4 - 48*a**10*b**3*c**3*s**4 -
        79*a**9*b**4*c**3*s**4 - 17*a**8*b**5*c**3*s**4 -
        2*a**7*b**6*c**3*s**4 - 42*a**6*b**7*c**3*s**4 -
        73*a**5*b**8*c**3*s**4 - 57*a**4*b**9*c**3*s**4 -
        10*a**3*b**10*c**3*s**4 + a**12*c**4*s**4 + a**11*b*c**4*s**4
        - 43*a**10*b**2*c**4*s**4 - 94*a**9*b**3*c**4*s**4 -
        74*a**8*b**4*c**4*s**4 - 29*a**7*b**5*c**4*s**4 -
        12*a**6*b**6*c**4*s**4 - 80*a**5*b**7*c**4*s**4 -
        106*a**4*b**8*c**4*s**4 - 32*a**3*b**9*c**4*s**4 -
        18*a**10*b*c**5*s**4 - 54*a**9*b**2*c**5*s**4 -
        76*a**8*b**3*c**5*s**4 - 48*a**7*b**4*c**5*s**4 +
        10*a**6*b**5*c**5*s**4 - 28*a**5*b**6*c**5*s**4 -
        84*a**4*b**7*c**5*s**4 - 36*a**3*b**8*c**5*s**4 -
        2*a**10*c**6*s**4 - 12*a**9*b*c**6*s**4 -
        31*a**8*b**2*c**6*s**4 - 28*a**7*b**3*c**6*s**4 +
        5*a**6*b**4*c**6*s**4 + 3*a**5*b**5*c**6*s**4 -
        28*a**4*b**6*c**6*s**4 - 16*a**3*b**7*c**6*s**4 -
        4*a**8*b*c**7*s**4 - 5*a**7*b**2*c**7*s**4 +
        2*a**5*b**4*c**7*s**4 - 3*a**4*b**5*c**7*s**4 -
        2*a**3*b**6*c**7*s**4)/(a**11*b**7*s**2 - 3*a**10*b**8*s**2 +
        4*a**9*b**9*s**2 - 3*a**8*b**10*s**2 + a**7*b**11*s**2 -
        a**13*b**4*c*s**2 + 4*a**12*b**5*c*s**2 - 7*a**11*b**6*c*s**2
        + 6*a**10*b**7*c*s**2 - 6*a**8*b**9*c*s**2 +
        7*a**7*b**10*c*s**2 - 4*a**6*b**11*c*s**2 + a**5*b**12*c*s**2
        - a**14*b**2*c**2*s**2 + 3*a**13*b**3*c**2*s**2 -
        3*a**12*b**4*c**2*s**2 - 3*a**11*b**5*c**2*s**2 +
        12*a**10*b**6*c**2*s**2 - 15*a**9*b**7*c**2*s**2 +
        9*a**8*b**8*c**2*s**2 - 4*a**6*b**10*c**2*s**2 +
        3*a**5*b**11*c**2*s**2 - a**4*b**12*c**2*s**2 +
        2*a**13*b**2*c**3*s**2 - 7*a**12*b**3*c**3*s**2 +
        10*a**11*b**4*c**3*s**2 - 4*a**10*b**5*c**3*s**2 -
        8*a**9*b**6*c**3*s**2 + 13*a**8*b**7*c**3*s**2 -
        7*a**7*b**8*c**3*s**2 - a**6*b**9*c**3*s**2 +
        3*a**5*b**10*c**3*s**2 - a**4*b**11*c**3*s**2 +
        a**14*c**4*s**2 - 2*a**13*b*c**4*s**2 - a**12*b**2*c**4*s**2 +
        9*a**11*b**3*c**4*s**2 - 14*a**10*b**4*c**4*s**2 +
        6*a**9*b**5*c**4*s**2 + 9*a**8*b**6*c**4*s**2 -
        15*a**7*b**7*c**4*s**2 + 8*a**6*b**8*c**4*s**2 +
        a**5*b**9*c**4*s**2 - 3*a**4*b**10*c**4*s**2 +
        a**3*b**11*c**4*s**2 - 2*a**13*c**5*s**2 + 5*a**12*b*c**5*s**2
        - 2*a**11*b**2*c**5*s**2 - 9*a**10*b**3*c**5*s**2 +
        18*a**9*b**4*c**5*s**2 - 12*a**8*b**5*c**5*s**2 -
        4*a**7*b**6*c**5*s**2 + 12*a**6*b**7*c**5*s**2 -
        8*a**5*b**8*c**5*s**2 + 2*a**4*b**9*c**5*s**2 -
        a**3*b**10*c**5*s**2 + 2*a**2*b**11*c**5*s**2 -
        a*b**12*c**5*s**2 + 2*a**12*c**6*s**2 - 6*a**11*b*c**6*s**2 +
        5*a**10*b**2*c**6*s**2 + 5*a**9*b**3*c**6*s**2 -
        15*a**8*b**4*c**6*s**2 + 13*a**7*b**5*c**6*s**2 -
        2*a**6*b**6*c**6*s**2 - 3*a**5*b**7*c**6*s**2 -
        a**4*b**8*c**6*s**2 + 4*a**3*b**9*c**6*s**2 -
        2*a**2*b**10*c**6*s**2 - a*b**11*c**6*s**2 + b**12*c**6*s**2 -
        2*a**11*c**7*s**2 + 6*a**10*b*c**7*s**2 -
        6*a**9*b**2*c**7*s**2 - a**8*b**3*c**7*s**2 +
        8*a**7*b**4*c**7*s**2 - 6*a**6*b**5*c**7*s**2 -
        2*a**5*b**6*c**7*s**2 + 5*a**4*b**7*c**7*s**2 -
        a**3*b**8*c**7*s**2 - 3*a**2*b**9*c**7*s**2 +
        3*a*b**10*c**7*s**2 - b**11*c**7*s**2 + a**10*c**8*s**2 -
        4*a**9*b*c**8*s**2 + 5*a**8*b**2*c**8*s**2 -
        a**7*b**3*c**8*s**2 - 4*a**6*b**4*c**8*s**2 +
        4*a**5*b**5*c**8*s**2 + a**4*b**6*c**8*s**2 -
        4*a**3*b**7*c**8*s**2 + 3*a**2*b**8*c**8*s**2 -
        a*b**9*c**8*s**2 + a**8*b*c**9*s**2 - 2*a**7*b**2*c**9*s**2 +
        a**6*b**3*c**9*s**2 + a**5*b**4*c**9*s**2 -
        2*a**4*b**5*c**9*s**2 + a**3*b**6*c**9*s**2), (a**12*b**6*c**2
        + a**11*b**7*c**2 + a**12*b**5*c**3 + 6*a**11*b**6*c**3 +
        7*a**10*b**7*c**3 + 2*a**9*b**8*c**3 - 2*a**12*b**4*c**4 +
        10*a**10*b**6*c**4 + 11*a**9*b**7*c**4 + 3*a**8*b**8*c**4 -
        2*a**12*b**3*c**5 - 4*a**11*b**4*c**5 + 7*a**10*b**5*c**5 +
        17*a**9*b**6*c**5 + 8*a**8*b**7*c**5 + 2*a**11*b**3*c**6 +
        16*a**10*b**4*c**6 + 34*a**9*b**5*c**6 + 34*a**8*b**6*c**6 +
        22*a**7*b**7*c**6 + 8*a**6*b**8*c**6 + 6*a**10*b**3*c**7 +
        15*a**9*b**4*c**7 + 24*a**8*b**5*c**7 + 38*a**7*b**6*c**7 +
        35*a**6*b**7*c**7 + 12*a**5*b**8*c**7 + 4*a**10*b**2*c**8 +
        7*a**9*b**3*c**8 + 9*a**8*b**4*c**8 + 22*a**7*b**5*c**8 +
        29*a**6*b**6*c**8 + 18*a**5*b**7*c**8 + 5*a**4*b**8*c**8 +
        a**10*b*c**9 + 2*a**9*b**2*c**9 + 10*a**8*b**3*c**9 +
        39*a**7*b**4*c**9 + 61*a**6*b**5*c**9 + 51*a**5*b**6*c**9 +
        29*a**4*b**7*c**9 + 9*a**3*b**8*c**9 - a**9*b*c**10 -
        3*a**8*b**2*c**10 + 8*a**7*b**3*c**10 + 32*a**6*b**4*c**10 +
        45*a**5*b**5*c**10 + 44*a**4*b**6*c**10 + 30*a**3*b**7*c**10 +
        9*a**2*b**8*c**10 + 7*a**7*b**2*c**11 + 26*a**6*b**3*c**11 +
        39*a**5*b**4*c**11 + 33*a**4*b**5*c**11 + 20*a**3*b**6*c**11 +
        9*a**2*b**7*c**11 + 2*a*b**8*c**11 + 2*a**7*b*c**12 +
        11*a**6*b**2*c**12 + 26*a**5*b**3*c**12 + 34*a**4*b**4*c**12 +
        26*a**3*b**5*c**12 + 11*a**2*b**6*c**12 + 2*a*b**7*c**12 +
        3*a**11*b**5*c**2*s**2 + 4*a**10*b**6*c**2*s**2 +
        a**9*b**7*c**2*s**2 - 7*a**11*b**4*c**3*s**2 -
        27*a**10*b**5*c**3*s**2 - 34*a**9*b**6*c**3*s**2 -
        16*a**8*b**7*c**3*s**2 - 2*a**7*b**8*c**3*s**2 -
        17*a**11*b**3*c**4*s**2 - 104*a**10*b**4*c**4*s**2 -
        198*a**9*b**5*c**4*s**2 - 159*a**8*b**6*c**4*s**2 -
        53*a**7*b**7*c**4*s**2 - 5*a**6*b**8*c**4*s**2 -
        7*a**11*b**2*c**5*s**2 - 91*a**10*b**3*c**5*s**2 -
        270*a**9*b**4*c**5*s**2 - 319*a**8*b**5*c**5*s**2 -
        159*a**7*b**6*c**5*s**2 - 25*a**6*b**7*c**5*s**2 +
        a**5*b**8*c**5*s**2 - 28*a**10*b**2*c**6*s**2 -
        141*a**9*b**3*c**6*s**2 - 230*a**8*b**4*c**6*s**2 -
        134*a**7*b**5*c**6*s**2 + a**6*b**6*c**6*s**2 +
        21*a**5*b**7*c**6*s**2 + 3*a**4*b**8*c**6*s**2 -
        4*a**10*b*c**7*s**2 - 38*a**9*b**2*c**7*s**2 -
        80*a**8*b**3*c**7*s**2 - 62*a**7*b**4*c**7*s**2 -
        33*a**6*b**5*c**7*s**2 - 40*a**5*b**6*c**7*s**2 -
        28*a**4*b**7*c**7*s**2 - 5*a**3*b**8*c**7*s**2 -
        2*a**9*b*c**8*s**2 + 9*a**8*b**2*c**8*s**2 +
        32*a**7*b**3*c**8*s**2 - 32*a**6*b**4*c**8*s**2 -
        167*a**5*b**5*c**8*s**2 - 170*a**4*b**6*c**8*s**2 -
        60*a**3*b**7*c**8*s**2 - 4*a**2*b**8*c**8*s**2 +
        5*a**8*b*c**9*s**2 + 15*a**7*b**2*c**9*s**2 -
        44*a**6*b**3*c**9*s**2 - 211*a**5*b**4*c**9*s**2 -
        292*a**4*b**5*c**9*s**2 - 168*a**3*b**6*c**9*s**2 -
        33*a**2*b**7*c**9*s**2 - 3*a**7*b*c**10*s**2 -
        42*a**6*b**2*c**10*s**2 - 156*a**5*b**3*c**10*s**2 -
        263*a**4*b**4*c**10*s**2 - 220*a**3*b**5*c**10*s**2 -
        83*a**2*b**6*c**10*s**2 - 9*a*b**7*c**10*s**2 -
        4*a**6*b*c**11*s**2 - 24*a**5*b**2*c**11*s**2 -
        59*a**4*b**3*c**11*s**2 - 72*a**3*b**4*c**11*s**2 -
        45*a**2*b**5*c**11*s**2 - 12*a*b**6*c**11*s**2 +
        a**4*b**2*c**12*s**2 + 5*a**3*b**3*c**12*s**2 +
        7*a**2*b**4*c**12*s**2 + 3*a*b**5*c**12*s**2 -
        10*a**10*b**3*c**3*s**4 - 32*a**9*b**4*c**3*s**4 -
        36*a**8*b**5*c**3*s**4 - 16*a**7*b**6*c**3*s**4 -
        2*a**6*b**7*c**3*s**4 - 10*a**10*b**2*c**4*s**4 -
        57*a**9*b**3*c**4*s**4 - 106*a**8*b**4*c**4*s**4 -
        84*a**7*b**5*c**4*s**4 - 28*a**6*b**6*c**4*s**4 -
        3*a**5*b**7*c**4*s**4 - 22*a**9*b**2*c**5*s**4 -
        73*a**8*b**3*c**5*s**4 - 80*a**7*b**4*c**5*s**4 -
        28*a**6*b**5*c**5*s**4 + 3*a**5*b**6*c**5*s**4 +
        2*a**4*b**7*c**5*s**4 - 8*a**9*b*c**6*s**4 -
        33*a**8*b**2*c**6*s**4 - 42*a**7*b**3*c**6*s**4 -
        12*a**6*b**4*c**6*s**4 + 10*a**5*b**5*c**6*s**4 +
        5*a**4*b**6*c**6*s**4 - 3*a**8*b*c**7*s**4 -
        a**7*b**2*c**7*s**4 - 2*a**6*b**3*c**7*s**4 -
        29*a**5*b**4*c**7*s**4 - 48*a**4*b**5*c**7*s**4 -
        28*a**3*b**6*c**7*s**4 - 5*a**2*b**7*c**7*s**4 +
        8*a**7*b*c**8*s**4 + 16*a**6*b**2*c**8*s**4 -
        17*a**5*b**3*c**8*s**4 - 74*a**4*b**4*c**8*s**4 -
        76*a**3*b**5*c**8*s**4 - 31*a**2*b**6*c**8*s**4 -
        4*a*b**7*c**8*s**4 - 5*a**6*b*c**9*s**4 -
        32*a**5*b**2*c**9*s**4 - 79*a**4*b**3*c**9*s**4 -
        94*a**3*b**4*c**9*s**4 - 54*a**2*b**5*c**9*s**4 -
        12*a*b**6*c**9*s**4 - 6*a**5*b*c**10*s**4 -
        27*a**4*b**2*c**10*s**4 - 48*a**3*b**3*c**10*s**4 -
        43*a**2*b**4*c**10*s**4 - 18*a*b**5*c**10*s**4 -
        2*b**6*c**10*s**4 - a**4*b*c**11*s**4 - a**3*b**2*c**11*s**4 +
        a**2*b**3*c**11*s**4 + a*b**4*c**11*s**4 +
        a**2*b**2*c**12*s**4 + 2*a*b**3*c**12*s**4 +
        b**4*c**12*s**4)/(a**12*b**6*s**2 - a**11*b**7*s**2 -
        a**12*b**5*c*s**2 - a**11*b**6*c*s**2 + 3*a**10*b**7*c*s**2 -
        a**9*b**8*c*s**2 + 2*a**11*b**5*c**2*s**2 -
        2*a**10*b**6*c**2*s**2 - 3*a**9*b**7*c**2*s**2 +
        3*a**8*b**8*c**2*s**2 + a**11*b**4*c**3*s**2 -
        a**10*b**5*c**3*s**2 + 4*a**9*b**6*c**3*s**2 -
        a**8*b**7*c**3*s**2 - 4*a**7*b**8*c**3*s**2 +
        a**6*b**9*c**3*s**2 - a**12*b**2*c**4*s**2 -
        a**11*b**3*c**4*s**2 - 3*a**10*b**4*c**4*s**2 +
        2*a**9*b**5*c**4*s**2 - a**8*b**6*c**4*s**2 +
        5*a**7*b**7*c**4*s**2 + a**6*b**8*c**4*s**2 -
        2*a**5*b**9*c**4*s**2 + a**12*b*c**5*s**2 +
        3*a**11*b**2*c**5*s**2 + 3*a**10*b**3*c**5*s**2 +
        a**9*b**4*c**5*s**2 - 8*a**8*b**5*c**5*s**2 -
        3*a**7*b**6*c**5*s**2 - 2*a**6*b**7*c**5*s**2 +
        4*a**5*b**8*c**5*s**2 + a**4*b**9*c**5*s**2 -
        4*a**11*b*c**6*s**2 - 4*a**10*b**2*c**6*s**2 -
        a**9*b**3*c**6*s**2 + 8*a**8*b**4*c**6*s**2 +
        12*a**7*b**5*c**6*s**2 - 2*a**6*b**6*c**6*s**2 -
        6*a**5*b**7*c**6*s**2 - 4*a**4*b**8*c**6*s**2 +
        a**3*b**9*c**6*s**2 + a**11*c**7*s**2 + 7*a**10*b*c**7*s**2 -
        7*a**8*b**3*c**7*s**2 - 15*a**7*b**4*c**7*s**2 -
        4*a**6*b**5*c**7*s**2 + 13*a**5*b**6*c**7*s**2 +
        8*a**4*b**7*c**7*s**2 - a**3*b**8*c**7*s**2 -
        2*a**2*b**9*c**7*s**2 - 3*a**10*c**8*s**2 - 6*a**9*b*c**8*s**2
        + 9*a**8*b**2*c**8*s**2 + 13*a**7*b**3*c**8*s**2 +
        9*a**6*b**4*c**8*s**2 - 12*a**5*b**5*c**8*s**2 -
        15*a**4*b**6*c**8*s**2 - a**3*b**7*c**8*s**2 +
        5*a**2*b**8*c**8*s**2 + a*b**9*c**8*s**2 + 4*a**9*c**9*s**2 -
        15*a**7*b**2*c**9*s**2 - 8*a**6*b**3*c**9*s**2 +
        6*a**5*b**4*c**9*s**2 + 18*a**4*b**5*c**9*s**2 +
        5*a**3*b**6*c**9*s**2 - 6*a**2*b**7*c**9*s**2 -
        4*a*b**8*c**9*s**2 - 3*a**8*c**10*s**2 + 6*a**7*b*c**10*s**2 +
        12*a**6*b**2*c**10*s**2 - 4*a**5*b**3*c**10*s**2 -
        14*a**4*b**4*c**10*s**2 - 9*a**3*b**5*c**10*s**2 +
        5*a**2*b**6*c**10*s**2 + 6*a*b**7*c**10*s**2 + b**8*c**10*s**2
        + a**7*c**11*s**2 - 7*a**6*b*c**11*s**2 -
        3*a**5*b**2*c**11*s**2 + 10*a**4*b**3*c**11*s**2 +
        9*a**3*b**4*c**11*s**2 - 2*a**2*b**5*c**11*s**2 -
        6*a*b**6*c**11*s**2 - 2*b**7*c**11*s**2 + 4*a**5*b*c**12*s**2
        - 3*a**4*b**2*c**12*s**2 - 7*a**3*b**3*c**12*s**2 -
        a**2*b**4*c**12*s**2 + 5*a*b**5*c**12*s**2 + 2*b**6*c**12*s**2
        - a**4*b*c**13*s**2 + 3*a**3*b**2*c**13*s**2 +
        2*a**2*b**3*c**13*s**2 - 2*a*b**4*c**13*s**2 -
        2*b**5*c**13*s**2 - a**2*b**2*c**14*s**2 + b**4*c**14*s**2),
        (-a**7*b**11*c**2 - a**6*b**12*c**2 - 2*a**8*b**9*c**3 -
        7*a**7*b**10*c**3 - 6*a**6*b**11*c**3 - a**5*b**12*c**3 -
        3*a**8*b**8*c**4 - 11*a**7*b**9*c**4 - 10*a**6*b**10*c**4 +
        2*a**4*b**12*c**4 - 8*a**7*b**8*c**5 - 17*a**6*b**9*c**5 -
        7*a**5*b**10*c**5 + 4*a**4*b**11*c**5 + 2*a**3*b**12*c**5 -
        8*a**8*b**6*c**6 - 22*a**7*b**7*c**6 - 34*a**6*b**8*c**6 -
        34*a**5*b**9*c**6 - 16*a**4*b**10*c**6 - 2*a**3*b**11*c**6 -
        12*a**8*b**5*c**7 - 35*a**7*b**6*c**7 - 38*a**6*b**7*c**7 -
        24*a**5*b**8*c**7 - 15*a**4*b**9*c**7 - 6*a**3*b**10*c**7 -
        5*a**8*b**4*c**8 - 18*a**7*b**5*c**8 - 29*a**6*b**6*c**8 -
        22*a**5*b**7*c**8 - 9*a**4*b**8*c**8 - 7*a**3*b**9*c**8 -
        4*a**2*b**10*c**8 - 9*a**8*b**3*c**9 - 29*a**7*b**4*c**9 -
        51*a**6*b**5*c**9 - 61*a**5*b**6*c**9 - 39*a**4*b**7*c**9 -
        10*a**3*b**8*c**9 - 2*a**2*b**9*c**9 - a*b**10*c**9 -
        9*a**8*b**2*c**10 - 30*a**7*b**3*c**10 - 44*a**6*b**4*c**10 -
        45*a**5*b**5*c**10 - 32*a**4*b**6*c**10 - 8*a**3*b**7*c**10 +
        3*a**2*b**8*c**10 + a*b**9*c**10 - 2*a**8*b*c**11 -
        9*a**7*b**2*c**11 - 20*a**6*b**3*c**11 - 33*a**5*b**4*c**11 -
        39*a**4*b**5*c**11 - 26*a**3*b**6*c**11 - 7*a**2*b**7*c**11 -
        2*a**7*b*c**12 - 11*a**6*b**2*c**12 - 26*a**5*b**3*c**12 -
        34*a**4*b**4*c**12 - 26*a**3*b**5*c**12 - 11*a**2*b**6*c**12 -
        2*a*b**7*c**12 - a**7*b**9*c**2*s**2 - 4*a**6*b**10*c**2*s**2
        - 3*a**5*b**11*c**2*s**2 + 2*a**8*b**7*c**3*s**2 +
        16*a**7*b**8*c**3*s**2 + 34*a**6*b**9*c**3*s**2 +
        27*a**5*b**10*c**3*s**2 + 7*a**4*b**11*c**3*s**2 +
        5*a**8*b**6*c**4*s**2 + 53*a**7*b**7*c**4*s**2 +
        159*a**6*b**8*c**4*s**2 + 198*a**5*b**9*c**4*s**2 +
        104*a**4*b**10*c**4*s**2 + 17*a**3*b**11*c**4*s**2 -
        a**8*b**5*c**5*s**2 + 25*a**7*b**6*c**5*s**2 +
        159*a**6*b**7*c**5*s**2 + 319*a**5*b**8*c**5*s**2 +
        270*a**4*b**9*c**5*s**2 + 91*a**3*b**10*c**5*s**2 +
        7*a**2*b**11*c**5*s**2 - 3*a**8*b**4*c**6*s**2 -
        21*a**7*b**5*c**6*s**2 - a**6*b**6*c**6*s**2 +
        134*a**5*b**7*c**6*s**2 + 230*a**4*b**8*c**6*s**2 +
        141*a**3*b**9*c**6*s**2 + 28*a**2*b**10*c**6*s**2 +
        5*a**8*b**3*c**7*s**2 + 28*a**7*b**4*c**7*s**2 +
        40*a**6*b**5*c**7*s**2 + 33*a**5*b**6*c**7*s**2 +
        62*a**4*b**7*c**7*s**2 + 80*a**3*b**8*c**7*s**2 +
        38*a**2*b**9*c**7*s**2 + 4*a*b**10*c**7*s**2 +
        4*a**8*b**2*c**8*s**2 + 60*a**7*b**3*c**8*s**2 +
        170*a**6*b**4*c**8*s**2 + 167*a**5*b**5*c**8*s**2 +
        32*a**4*b**6*c**8*s**2 - 32*a**3*b**7*c**8*s**2 -
        9*a**2*b**8*c**8*s**2 + 2*a*b**9*c**8*s**2 +
        33*a**7*b**2*c**9*s**2 + 168*a**6*b**3*c**9*s**2 +
        292*a**5*b**4*c**9*s**2 + 211*a**4*b**5*c**9*s**2 +
        44*a**3*b**6*c**9*s**2 - 15*a**2*b**7*c**9*s**2 -
        5*a*b**8*c**9*s**2 + 9*a**7*b*c**10*s**2 +
        83*a**6*b**2*c**10*s**2 + 220*a**5*b**3*c**10*s**2 +
        263*a**4*b**4*c**10*s**2 + 156*a**3*b**5*c**10*s**2 +
        42*a**2*b**6*c**10*s**2 + 3*a*b**7*c**10*s**2 +
        12*a**6*b*c**11*s**2 + 45*a**5*b**2*c**11*s**2 +
        72*a**4*b**3*c**11*s**2 + 59*a**3*b**4*c**11*s**2 +
        24*a**2*b**5*c**11*s**2 + 4*a*b**6*c**11*s**2 -
        3*a**5*b*c**12*s**2 - 7*a**4*b**2*c**12*s**2 -
        5*a**3*b**3*c**12*s**2 - a**2*b**4*c**12*s**2 +
        2*a**7*b**6*c**3*s**4 + 16*a**6*b**7*c**3*s**4 +
        36*a**5*b**8*c**3*s**4 + 32*a**4*b**9*c**3*s**4 +
        10*a**3*b**10*c**3*s**4 + 3*a**7*b**5*c**4*s**4 +
        28*a**6*b**6*c**4*s**4 + 84*a**5*b**7*c**4*s**4 +
        106*a**4*b**8*c**4*s**4 + 57*a**3*b**9*c**4*s**4 +
        10*a**2*b**10*c**4*s**4 - 2*a**7*b**4*c**5*s**4 -
        3*a**6*b**5*c**5*s**4 + 28*a**5*b**6*c**5*s**4 +
        80*a**4*b**7*c**5*s**4 + 73*a**3*b**8*c**5*s**4 +
        22*a**2*b**9*c**5*s**4 - 5*a**6*b**4*c**6*s**4 -
        10*a**5*b**5*c**6*s**4 + 12*a**4*b**6*c**6*s**4 +
        42*a**3*b**7*c**6*s**4 + 33*a**2*b**8*c**6*s**4 +
        8*a*b**9*c**6*s**4 + 5*a**7*b**2*c**7*s**4 +
        28*a**6*b**3*c**7*s**4 + 48*a**5*b**4*c**7*s**4 +
        29*a**4*b**5*c**7*s**4 + 2*a**3*b**6*c**7*s**4 +
        a**2*b**7*c**7*s**4 + 3*a*b**8*c**7*s**4 + 4*a**7*b*c**8*s**4
        + 31*a**6*b**2*c**8*s**4 + 76*a**5*b**3*c**8*s**4 +
        74*a**4*b**4*c**8*s**4 + 17*a**3*b**5*c**8*s**4 -
        16*a**2*b**6*c**8*s**4 - 8*a*b**7*c**8*s**4 +
        12*a**6*b*c**9*s**4 + 54*a**5*b**2*c**9*s**4 +
        94*a**4*b**3*c**9*s**4 + 79*a**3*b**4*c**9*s**4 +
        32*a**2*b**5*c**9*s**4 + 5*a*b**6*c**9*s**4 +
        2*a**6*c**10*s**4 + 18*a**5*b*c**10*s**4 +
        43*a**4*b**2*c**10*s**4 + 48*a**3*b**3*c**10*s**4 +
        27*a**2*b**4*c**10*s**4 + 6*a*b**5*c**10*s**4 -
        a**4*b*c**11*s**4 - a**3*b**2*c**11*s**4 +
        a**2*b**3*c**11*s**4 + a*b**4*c**11*s**4 - a**4*c**12*s**4 -
        2*a**3*b*c**12*s**4 - a**2*b**2*c**12*s**4)/(a**7*b**11*s**2 -
        a**6*b**12*s**2 + a**8*b**9*c*s**2 - 3*a**7*b**10*c*s**2 +
        a**6*b**11*c*s**2 + a**5*b**12*c*s**2 - 3*a**8*b**8*c**2*s**2
        + 3*a**7*b**9*c**2*s**2 + 2*a**6*b**10*c**2*s**2 -
        2*a**5*b**11*c**2*s**2 - a**9*b**6*c**3*s**2 +
        4*a**8*b**7*c**3*s**2 + a**7*b**8*c**3*s**2 -
        4*a**6*b**9*c**3*s**2 + a**5*b**10*c**3*s**2 -
        a**4*b**11*c**3*s**2 + 2*a**9*b**5*c**4*s**2 -
        a**8*b**6*c**4*s**2 - 5*a**7*b**7*c**4*s**2 +
        a**6*b**8*c**4*s**2 - 2*a**5*b**9*c**4*s**2 +
        3*a**4*b**10*c**4*s**2 + a**3*b**11*c**4*s**2 +
        a**2*b**12*c**4*s**2 - a**9*b**4*c**5*s**2 -
        4*a**8*b**5*c**5*s**2 + 2*a**7*b**6*c**5*s**2 +
        3*a**6*b**7*c**5*s**2 + 8*a**5*b**8*c**5*s**2 -
        a**4*b**9*c**5*s**2 - 3*a**3*b**10*c**5*s**2 -
        3*a**2*b**11*c**5*s**2 - a*b**12*c**5*s**2 -
        a**9*b**3*c**6*s**2 + 4*a**8*b**4*c**6*s**2 +
        6*a**7*b**5*c**6*s**2 + 2*a**6*b**6*c**6*s**2 -
        12*a**5*b**7*c**6*s**2 - 8*a**4*b**8*c**6*s**2 +
        a**3*b**9*c**6*s**2 + 4*a**2*b**10*c**6*s**2 +
        4*a*b**11*c**6*s**2 + 2*a**9*b**2*c**7*s**2 +
        a**8*b**3*c**7*s**2 - 8*a**7*b**4*c**7*s**2 -
        13*a**6*b**5*c**7*s**2 + 4*a**5*b**6*c**7*s**2 +
        15*a**4*b**7*c**7*s**2 + 7*a**3*b**8*c**7*s**2 -
        7*a*b**10*c**7*s**2 - b**11*c**7*s**2 - a**9*b*c**8*s**2 -
        5*a**8*b**2*c**8*s**2 + a**7*b**3*c**8*s**2 +
        15*a**6*b**4*c**8*s**2 + 12*a**5*b**5*c**8*s**2 -
        9*a**4*b**6*c**8*s**2 - 13*a**3*b**7*c**8*s**2 -
        9*a**2*b**8*c**8*s**2 + 6*a*b**9*c**8*s**2 + 3*b**10*c**8*s**2
        + 4*a**8*b*c**9*s**2 + 6*a**7*b**2*c**9*s**2 -
        5*a**6*b**3*c**9*s**2 - 18*a**5*b**4*c**9*s**2 -
        6*a**4*b**5*c**9*s**2 + 8*a**3*b**6*c**9*s**2 +
        15*a**2*b**7*c**9*s**2 - 4*b**9*c**9*s**2 - a**8*c**10*s**2 -
        6*a**7*b*c**10*s**2 - 5*a**6*b**2*c**10*s**2 +
        9*a**5*b**3*c**10*s**2 + 14*a**4*b**4*c**10*s**2 +
        4*a**3*b**5*c**10*s**2 - 12*a**2*b**6*c**10*s**2 -
        6*a*b**7*c**10*s**2 + 3*b**8*c**10*s**2 + 2*a**7*c**11*s**2 +
        6*a**6*b*c**11*s**2 + 2*a**5*b**2*c**11*s**2 -
        9*a**4*b**3*c**11*s**2 - 10*a**3*b**4*c**11*s**2 +
        3*a**2*b**5*c**11*s**2 + 7*a*b**6*c**11*s**2 - b**7*c**11*s**2
        - 2*a**6*c**12*s**2 - 5*a**5*b*c**12*s**2 +
        a**4*b**2*c**12*s**2 + 7*a**3*b**3*c**12*s**2 +
        3*a**2*b**4*c**12*s**2 - 4*a*b**5*c**12*s**2 +
        2*a**5*c**13*s**2 + 2*a**4*b*c**13*s**2 -
        2*a**3*b**2*c**13*s**2 - 3*a**2*b**3*c**13*s**2 +
        a*b**4*c**13*s**2 - a**4*c**14*s**2 + a**2*b**2*c**14*s**2),
        (2*a**12*b**7*c + 2*a**11*b**8*c + 11*a**12*b**6*c**2 +
        9*a**11*b**7*c**2 + 9*a**10*b**8*c**2 + 26*a**12*b**5*c**3 +
        20*a**11*b**6*c**3 + 30*a**10*b**7*c**3 + 9*a**9*b**8*c**3 +
        34*a**12*b**4*c**4 + 33*a**11*b**5*c**4 + 44*a**10*b**6*c**4 +
        29*a**9*b**7*c**4 + 5*a**8*b**8*c**4 + 26*a**12*b**3*c**5 +
        39*a**11*b**4*c**5 + 45*a**10*b**5*c**5 + 51*a**9*b**6*c**5 +
        18*a**8*b**7*c**5 + 12*a**7*b**8*c**5 + 11*a**12*b**2*c**6 +
        26*a**11*b**3*c**6 + 32*a**10*b**4*c**6 + 61*a**9*b**5*c**6 +
        29*a**8*b**6*c**6 + 35*a**7*b**7*c**6 + 8*a**6*b**8*c**6 +
        2*a**12*b*c**7 + 7*a**11*b**2*c**7 + 8*a**10*b**3*c**7 +
        39*a**9*b**4*c**7 + 22*a**8*b**5*c**7 + 38*a**7*b**6*c**7 +
        22*a**6*b**7*c**7 - 3*a**10*b**2*c**8 + 10*a**9*b**3*c**8 +
        9*a**8*b**4*c**8 + 24*a**7*b**5*c**8 + 34*a**6*b**6*c**8 +
        8*a**5*b**7*c**8 + 3*a**4*b**8*c**8 - a**10*b*c**9 +
        2*a**9*b**2*c**9 + 7*a**8*b**3*c**9 + 15*a**7*b**4*c**9 +
        34*a**6*b**5*c**9 + 17*a**5*b**6*c**9 + 11*a**4*b**7*c**9 +
        2*a**3*b**8*c**9 + a**9*b*c**10 + 4*a**8*b**2*c**10 +
        6*a**7*b**3*c**10 + 16*a**6*b**4*c**10 + 7*a**5*b**5*c**10 +
        10*a**4*b**6*c**10 + 7*a**3*b**7*c**10 + 2*a**6*b**3*c**11 -
        4*a**5*b**4*c**11 + 6*a**3*b**6*c**11 + a**2*b**7*c**11 -
        2*a**5*b**3*c**12 - 2*a**4*b**4*c**12 + a**3*b**5*c**12 +
        a**2*b**6*c**12 + 3*a**12*b**5*c*s**2 - 12*a**11*b**6*c*s**2 -
        9*a**10*b**7*c*s**2 + 7*a**12*b**4*c**2*s**2 -
        45*a**11*b**5*c**2*s**2 - 83*a**10*b**6*c**2*s**2 -
        33*a**9*b**7*c**2*s**2 - 4*a**8*b**8*c**2*s**2 +
        5*a**12*b**3*c**3*s**2 - 72*a**11*b**4*c**3*s**2 -
        220*a**10*b**5*c**3*s**2 - 168*a**9*b**6*c**3*s**2 -
        60*a**8*b**7*c**3*s**2 - 5*a**7*b**8*c**3*s**2 +
        a**12*b**2*c**4*s**2 - 59*a**11*b**3*c**4*s**2 -
        263*a**10*b**4*c**4*s**2 - 292*a**9*b**5*c**4*s**2 -
        170*a**8*b**6*c**4*s**2 - 28*a**7*b**7*c**4*s**2 +
        3*a**6*b**8*c**4*s**2 - 24*a**11*b**2*c**5*s**2 -
        156*a**10*b**3*c**5*s**2 - 211*a**9*b**4*c**5*s**2 -
        167*a**8*b**5*c**5*s**2 - 40*a**7*b**6*c**5*s**2 +
        21*a**6*b**7*c**5*s**2 + a**5*b**8*c**5*s**2 -
        4*a**11*b*c**6*s**2 - 42*a**10*b**2*c**6*s**2 -
        44*a**9*b**3*c**6*s**2 - 32*a**8*b**4*c**6*s**2 -
        33*a**7*b**5*c**6*s**2 + a**6*b**6*c**6*s**2 -
        25*a**5*b**7*c**6*s**2 - 5*a**4*b**8*c**6*s**2 -
        3*a**10*b*c**7*s**2 + 15*a**9*b**2*c**7*s**2 +
        32*a**8*b**3*c**7*s**2 - 62*a**7*b**4*c**7*s**2 -
        134*a**6*b**5*c**7*s**2 - 159*a**5*b**6*c**7*s**2 -
        53*a**4*b**7*c**7*s**2 - 2*a**3*b**8*c**7*s**2 +
        5*a**9*b*c**8*s**2 + 9*a**8*b**2*c**8*s**2 -
        80*a**7*b**3*c**8*s**2 - 230*a**6*b**4*c**8*s**2 -
        319*a**5*b**5*c**8*s**2 - 159*a**4*b**6*c**8*s**2 -
        16*a**3*b**7*c**8*s**2 - 2*a**8*b*c**9*s**2 -
        38*a**7*b**2*c**9*s**2 - 141*a**6*b**3*c**9*s**2 -
        270*a**5*b**4*c**9*s**2 - 198*a**4*b**5*c**9*s**2 -
        34*a**3*b**6*c**9*s**2 + a**2*b**7*c**9*s**2 -
        4*a**7*b*c**10*s**2 - 28*a**6*b**2*c**10*s**2 -
        91*a**5*b**3*c**10*s**2 - 104*a**4*b**4*c**10*s**2 -
        27*a**3*b**5*c**10*s**2 + 4*a**2*b**6*c**10*s**2 -
        7*a**5*b**2*c**11*s**2 - 17*a**4*b**3*c**11*s**2 -
        7*a**3*b**4*c**11*s**2 + 3*a**2*b**5*c**11*s**2 +
        a**12*b**4*s**4 - 2*a**10*b**6*s**4 + 2*a**12*b**3*c*s**4 +
        a**11*b**4*c*s**4 - 18*a**10*b**5*c*s**4 - 12*a**9*b**6*c*s**4
        - 4*a**8*b**7*c*s**4 + a**12*b**2*c**2*s**4 +
        a**11*b**3*c**2*s**4 - 43*a**10*b**4*c**2*s**4 -
        54*a**9*b**5*c**2*s**4 - 31*a**8*b**6*c**2*s**4 -
        5*a**7*b**7*c**2*s**4 - a**11*b**2*c**3*s**4 -
        48*a**10*b**3*c**3*s**4 - 94*a**9*b**4*c**3*s**4 -
        76*a**8*b**5*c**3*s**4 - 28*a**7*b**6*c**3*s**4 -
        a**11*b*c**4*s**4 - 27*a**10*b**2*c**4*s**4 -
        79*a**9*b**3*c**4*s**4 - 74*a**8*b**4*c**4*s**4 -
        48*a**7*b**5*c**4*s**4 + 5*a**6*b**6*c**4*s**4 +
        2*a**5*b**7*c**4*s**4 - 6*a**10*b*c**5*s**4 -
        32*a**9*b**2*c**5*s**4 - 17*a**8*b**3*c**5*s**4 -
        29*a**7*b**4*c**5*s**4 + 10*a**6*b**5*c**5*s**4 +
        3*a**5*b**6*c**5*s**4 - 3*a**4*b**7*c**5*s**4 -
        5*a**9*b*c**6*s**4 + 16*a**8*b**2*c**6*s**4 -
        2*a**7*b**3*c**6*s**4 - 12*a**6*b**4*c**6*s**4 -
        28*a**5*b**5*c**6*s**4 - 28*a**4*b**6*c**6*s**4 -
        2*a**3*b**7*c**6*s**4 + 8*a**8*b*c**7*s**4 -
        a**7*b**2*c**7*s**4 - 42*a**6*b**3*c**7*s**4 -
        80*a**5*b**4*c**7*s**4 - 84*a**4*b**5*c**7*s**4 -
        16*a**3*b**6*c**7*s**4 - 3*a**7*b*c**8*s**4 -
        33*a**6*b**2*c**8*s**4 - 73*a**5*b**3*c**8*s**4 -
        106*a**4*b**4*c**8*s**4 - 36*a**3*b**5*c**8*s**4 -
        8*a**6*b*c**9*s**4 - 22*a**5*b**2*c**9*s**4 -
        57*a**4*b**3*c**9*s**4 - 32*a**3*b**4*c**9*s**4 -
        10*a**4*b**2*c**10*s**4 -
        10*a**3*b**3*c**10*s**4)/(a**14*b**4*s**2 - 2*a**13*b**5*s**2
        + 2*a**12*b**6*s**2 - 2*a**11*b**7*s**2 + a**10*b**8*s**2 -
        2*a**13*b**4*c*s**2 + 5*a**12*b**5*c*s**2 -
        6*a**11*b**6*c*s**2 + 6*a**10*b**7*c*s**2 - 4*a**9*b**8*c*s**2
        + a**8*b**9*c*s**2 - a**14*b**2*c**2*s**2 +
        2*a**13*b**3*c**2*s**2 - a**12*b**4*c**2*s**2 -
        2*a**11*b**5*c**2*s**2 + 5*a**10*b**6*c**2*s**2 -
        6*a**9*b**7*c**2*s**2 + 5*a**8*b**8*c**2*s**2 -
        2*a**7*b**9*c**2*s**2 + 3*a**13*b**2*c**3*s**2 -
        7*a**12*b**3*c**3*s**2 + 9*a**11*b**4*c**3*s**2 -
        9*a**10*b**5*c**3*s**2 + 5*a**9*b**6*c**3*s**2 -
        a**8*b**7*c**3*s**2 - a**7*b**8*c**3*s**2 +
        a**6*b**9*c**3*s**2 - a**13*b*c**4*s**2 -
        3*a**12*b**2*c**4*s**2 + 10*a**11*b**3*c**4*s**2 -
        14*a**10*b**4*c**4*s**2 + 18*a**9*b**5*c**4*s**2 -
        15*a**8*b**6*c**4*s**2 + 8*a**7*b**7*c**4*s**2 -
        4*a**6*b**8*c**4*s**2 + a**5*b**9*c**4*s**2 +
        4*a**12*b*c**5*s**2 - 3*a**11*b**2*c**5*s**2 -
        4*a**10*b**3*c**5*s**2 + 6*a**9*b**4*c**5*s**2 -
        12*a**8*b**5*c**5*s**2 + 13*a**7*b**6*c**5*s**2 -
        6*a**6*b**7*c**5*s**2 + 4*a**5*b**8*c**5*s**2 -
        2*a**4*b**9*c**5*s**2 - 7*a**11*b*c**6*s**2 +
        12*a**10*b**2*c**6*s**2 - 8*a**9*b**3*c**6*s**2 +
        9*a**8*b**4*c**6*s**2 - 4*a**7*b**5*c**6*s**2 -
        2*a**6*b**6*c**6*s**2 - 2*a**5*b**7*c**6*s**2 +
        a**4*b**8*c**6*s**2 + a**3*b**9*c**6*s**2 + a**11*c**7*s**2 +
        6*a**10*b*c**7*s**2 - 15*a**9*b**2*c**7*s**2 +
        13*a**8*b**3*c**7*s**2 - 15*a**7*b**4*c**7*s**2 +
        12*a**6*b**5*c**7*s**2 - 3*a**5*b**6*c**7*s**2 +
        5*a**4*b**7*c**7*s**2 - 4*a**3*b**8*c**7*s**2 -
        3*a**10*c**8*s**2 + 9*a**8*b**2*c**8*s**2 -
        7*a**7*b**3*c**8*s**2 + 8*a**6*b**4*c**8*s**2 -
        8*a**5*b**5*c**8*s**2 - a**4*b**6*c**8*s**2 -
        a**3*b**7*c**8*s**2 + 3*a**2*b**8*c**8*s**2 + 4*a**9*c**9*s**2
        - 6*a**8*b*c**9*s**2 - a**6*b**3*c**9*s**2 +
        a**5*b**4*c**9*s**2 + 2*a**4*b**5*c**9*s**2 +
        4*a**3*b**6*c**9*s**2 - 3*a**2*b**7*c**9*s**2 -
        a*b**8*c**9*s**2 - 3*a**8*c**10*s**2 + 7*a**7*b*c**10*s**2 -
        4*a**6*b**2*c**10*s**2 + 3*a**5*b**3*c**10*s**2 -
        3*a**4*b**4*c**10*s**2 - a**3*b**5*c**10*s**2 -
        2*a**2*b**6*c**10*s**2 + 3*a*b**7*c**10*s**2 + a**7*c**11*s**2
        - 4*a**6*b*c**11*s**2 + 3*a**5*b**2*c**11*s**2 -
        a**4*b**3*c**11*s**2 + a**3*b**4*c**11*s**2 +
        2*a**2*b**5*c**11*s**2 - a*b**6*c**11*s**2 - b**7*c**11*s**2 +
        a**5*b*c**12*s**2 - a**4*b**2*c**12*s**2 - a*b**5*c**12*s**2 +
        b**6*c**12*s**2), (a**10*b**9*c - a**9*b**10*c +
        2*a**7*b**12*c + 4*a**10*b**8*c**2 + 2*a**9*b**9*c**2 -
        3*a**8*b**10*c**2 + 7*a**7*b**11*c**2 + 11*a**6*b**12*c**2 -
        2*a**12*b**5*c**3 + 2*a**11*b**6*c**3 + 6*a**10*b**7*c**3 +
        7*a**9*b**8*c**3 + 10*a**8*b**9*c**3 + 8*a**7*b**10*c**3 +
        26*a**6*b**11*c**3 + 26*a**5*b**12*c**3 - 2*a**12*b**4*c**4 -
        4*a**11*b**5*c**4 + 16*a**10*b**6*c**4 + 15*a**9*b**7*c**4 +
        9*a**8*b**8*c**4 + 39*a**7*b**9*c**4 + 32*a**6*b**10*c**4 +
        39*a**5*b**11*c**4 + 34*a**4*b**12*c**4 + a**12*b**3*c**5 +
        7*a**10*b**5*c**5 + 34*a**9*b**6*c**5 + 24*a**8*b**7*c**5 +
        22*a**7*b**8*c**5 + 61*a**6*b**9*c**5 + 45*a**5*b**10*c**5 +
        33*a**4*b**11*c**5 + 26*a**3*b**12*c**5 + a**12*b**2*c**6 +
        6*a**11*b**3*c**6 + 10*a**10*b**4*c**6 + 17*a**9*b**5*c**6 +
        34*a**8*b**6*c**6 + 38*a**7*b**7*c**6 + 29*a**6*b**8*c**6 +
        51*a**5*b**9*c**6 + 44*a**4*b**10*c**6 + 20*a**3*b**11*c**6 +
        11*a**2*b**12*c**6 + a**11*b**2*c**7 + 7*a**10*b**3*c**7 +
        11*a**9*b**4*c**7 + 8*a**8*b**5*c**7 + 22*a**7*b**6*c**7 +
        35*a**6*b**7*c**7 + 18*a**5*b**8*c**7 + 29*a**4*b**9*c**7 +
        30*a**3*b**10*c**7 + 9*a**2*b**11*c**7 + 2*a*b**12*c**7 +
        2*a**9*b**3*c**8 + 3*a**8*b**4*c**8 + 8*a**6*b**6*c**8 +
        12*a**5*b**7*c**8 + 5*a**4*b**8*c**8 + 9*a**3*b**9*c**8 +
        9*a**2*b**10*c**8 + 2*a*b**11*c**8 - 4*a**10*b**7*c*s**2 -
        2*a**9*b**8*c*s**2 + 5*a**8*b**9*c*s**2 - 3*a**7*b**10*c*s**2
        - 4*a**6*b**11*c*s**2 - 7*a**11*b**5*c**2*s**2 -
        28*a**10*b**6*c**2*s**2 - 38*a**9*b**7*c**2*s**2 +
        9*a**8*b**8*c**2*s**2 + 15*a**7*b**9*c**2*s**2 -
        42*a**6*b**10*c**2*s**2 - 24*a**5*b**11*c**2*s**2 +
        a**4*b**12*c**2*s**2 - 17*a**11*b**4*c**3*s**2 -
        91*a**10*b**5*c**3*s**2 - 141*a**9*b**6*c**3*s**2 -
        80*a**8*b**7*c**3*s**2 + 32*a**7*b**8*c**3*s**2 -
        44*a**6*b**9*c**3*s**2 - 156*a**5*b**10*c**3*s**2 -
        59*a**4*b**11*c**3*s**2 + 5*a**3*b**12*c**3*s**2 -
        7*a**11*b**3*c**4*s**2 - 104*a**10*b**4*c**4*s**2 -
        270*a**9*b**5*c**4*s**2 - 230*a**8*b**6*c**4*s**2 -
        62*a**7*b**7*c**4*s**2 - 32*a**6*b**8*c**4*s**2 -
        211*a**5*b**9*c**4*s**2 - 263*a**4*b**10*c**4*s**2 -
        72*a**3*b**11*c**4*s**2 + 7*a**2*b**12*c**4*s**2 +
        3*a**11*b**2*c**5*s**2 - 27*a**10*b**3*c**5*s**2 -
        198*a**9*b**4*c**5*s**2 - 319*a**8*b**5*c**5*s**2 -
        134*a**7*b**6*c**5*s**2 - 33*a**6*b**7*c**5*s**2 -
        167*a**5*b**8*c**5*s**2 - 292*a**4*b**9*c**5*s**2 -
        220*a**3*b**10*c**5*s**2 - 45*a**2*b**11*c**5*s**2 +
        3*a*b**12*c**5*s**2 + 4*a**10*b**2*c**6*s**2 -
        34*a**9*b**3*c**6*s**2 - 159*a**8*b**4*c**6*s**2 -
        159*a**7*b**5*c**6*s**2 + a**6*b**6*c**6*s**2 -
        40*a**5*b**7*c**6*s**2 - 170*a**4*b**8*c**6*s**2 -
        168*a**3*b**9*c**6*s**2 - 83*a**2*b**10*c**6*s**2 -
        12*a*b**11*c**6*s**2 + a**9*b**2*c**7*s**2 -
        16*a**8*b**3*c**7*s**2 - 53*a**7*b**4*c**7*s**2 -
        25*a**6*b**5*c**7*s**2 + 21*a**5*b**6*c**7*s**2 -
        28*a**4*b**7*c**7*s**2 - 60*a**3*b**8*c**7*s**2 -
        33*a**2*b**9*c**7*s**2 - 9*a*b**10*c**7*s**2 -
        2*a**7*b**3*c**8*s**2 - 5*a**6*b**4*c**8*s**2 +
        a**5*b**5*c**8*s**2 + 3*a**4*b**6*c**8*s**2 -
        5*a**3*b**7*c**8*s**2 - 4*a**2*b**8*c**8*s**2 -
        8*a**9*b**6*c*s**4 - 3*a**8*b**7*c*s**4 + 8*a**7*b**8*c*s**4 -
        5*a**6*b**9*c*s**4 - 6*a**5*b**10*c*s**4 - a**4*b**11*c*s**4 -
        10*a**10*b**4*c**2*s**4 - 22*a**9*b**5*c**2*s**4 -
        33*a**8*b**6*c**2*s**4 - a**7*b**7*c**2*s**4 +
        16*a**6*b**8*c**2*s**4 - 32*a**5*b**9*c**2*s**4 -
        27*a**4*b**10*c**2*s**4 - a**3*b**11*c**2*s**4 +
        a**2*b**12*c**2*s**4 - 10*a**10*b**3*c**3*s**4 -
        57*a**9*b**4*c**3*s**4 - 73*a**8*b**5*c**3*s**4 -
        42*a**7*b**6*c**3*s**4 - 2*a**6*b**7*c**3*s**4 -
        17*a**5*b**8*c**3*s**4 - 79*a**4*b**9*c**3*s**4 -
        48*a**3*b**10*c**3*s**4 + a**2*b**11*c**3*s**4 +
        2*a*b**12*c**3*s**4 - 32*a**9*b**3*c**4*s**4 -
        106*a**8*b**4*c**4*s**4 - 80*a**7*b**5*c**4*s**4 -
        12*a**6*b**6*c**4*s**4 - 29*a**5*b**7*c**4*s**4 -
        74*a**4*b**8*c**4*s**4 - 94*a**3*b**9*c**4*s**4 -
        43*a**2*b**10*c**4*s**4 + a*b**11*c**4*s**4 + b**12*c**4*s**4
        - 36*a**8*b**3*c**5*s**4 - 84*a**7*b**4*c**5*s**4 -
        28*a**6*b**5*c**5*s**4 + 10*a**5*b**6*c**5*s**4 -
        48*a**4*b**7*c**5*s**4 - 76*a**3*b**8*c**5*s**4 -
        54*a**2*b**9*c**5*s**4 - 18*a*b**10*c**5*s**4 -
        16*a**7*b**3*c**6*s**4 - 28*a**6*b**4*c**6*s**4 +
        3*a**5*b**5*c**6*s**4 + 5*a**4*b**6*c**6*s**4 -
        28*a**3*b**7*c**6*s**4 - 31*a**2*b**8*c**6*s**4 -
        12*a*b**9*c**6*s**4 - 2*b**10*c**6*s**4 -
        2*a**6*b**3*c**7*s**4 - 3*a**5*b**4*c**7*s**4 +
        2*a**4*b**5*c**7*s**4 - 5*a**2*b**7*c**7*s**4 -
        4*a*b**8*c**7*s**4)/(a**11*b**7*s**2 - 3*a**10*b**8*s**2 +
        4*a**9*b**9*s**2 - 3*a**8*b**10*s**2 + a**7*b**11*s**2 +
        a**12*b**5*c*s**2 - 4*a**11*b**6*c*s**2 + 7*a**10*b**7*c*s**2
        - 6*a**9*b**8*c*s**2 + 6*a**7*b**10*c*s**2 -
        7*a**6*b**11*c*s**2 + 4*a**5*b**12*c*s**2 - a**4*b**13*c*s**2
        - a**12*b**4*c**2*s**2 + 3*a**11*b**5*c**2*s**2 -
        4*a**10*b**6*c**2*s**2 + 9*a**8*b**8*c**2*s**2 -
        15*a**7*b**9*c**2*s**2 + 12*a**6*b**10*c**2*s**2 -
        3*a**5*b**11*c**2*s**2 - 3*a**4*b**12*c**2*s**2 +
        3*a**3*b**13*c**2*s**2 - a**2*b**14*c**2*s**2 -
        a**11*b**4*c**3*s**2 + 3*a**10*b**5*c**3*s**2 -
        a**9*b**6*c**3*s**2 - 7*a**8*b**7*c**3*s**2 +
        13*a**7*b**8*c**3*s**2 - 8*a**6*b**9*c**3*s**2 -
        4*a**5*b**10*c**3*s**2 + 10*a**4*b**11*c**3*s**2 -
        7*a**3*b**12*c**3*s**2 + 2*a**2*b**13*c**3*s**2 +
        a**11*b**3*c**4*s**2 - 3*a**10*b**4*c**4*s**2 +
        a**9*b**5*c**4*s**2 + 8*a**8*b**6*c**4*s**2 -
        15*a**7*b**7*c**4*s**2 + 9*a**6*b**8*c**4*s**2 +
        6*a**5*b**9*c**4*s**2 - 14*a**4*b**10*c**4*s**2 +
        9*a**3*b**11*c**4*s**2 - a**2*b**12*c**4*s**2 -
        2*a*b**13*c**4*s**2 + b**14*c**4*s**2 - a**12*b*c**5*s**2 +
        2*a**11*b**2*c**5*s**2 - a**10*b**3*c**5*s**2 +
        2*a**9*b**4*c**5*s**2 - 8*a**8*b**5*c**5*s**2 +
        12*a**7*b**6*c**5*s**2 - 4*a**6*b**7*c**5*s**2 -
        12*a**5*b**8*c**5*s**2 + 18*a**4*b**9*c**5*s**2 -
        9*a**3*b**10*c**5*s**2 - 2*a**2*b**11*c**5*s**2 +
        5*a*b**12*c**5*s**2 - 2*b**13*c**5*s**2 + a**12*c**6*s**2 -
        a**11*b*c**6*s**2 - 2*a**10*b**2*c**6*s**2 +
        4*a**9*b**3*c**6*s**2 - a**8*b**4*c**6*s**2 -
        3*a**7*b**5*c**6*s**2 - 2*a**6*b**6*c**6*s**2 +
        13*a**5*b**7*c**6*s**2 - 15*a**4*b**8*c**6*s**2 +
        5*a**3*b**9*c**6*s**2 + 5*a**2*b**10*c**6*s**2 -
        6*a*b**11*c**6*s**2 + 2*b**12*c**6*s**2 - a**11*c**7*s**2 +
        3*a**10*b*c**7*s**2 - 3*a**9*b**2*c**7*s**2 -
        a**8*b**3*c**7*s**2 + 5*a**7*b**4*c**7*s**2 -
        2*a**6*b**5*c**7*s**2 - 6*a**5*b**6*c**7*s**2 +
        8*a**4*b**7*c**7*s**2 - a**3*b**8*c**7*s**2 -
        6*a**2*b**9*c**7*s**2 + 6*a*b**10*c**7*s**2 -
        2*b**11*c**7*s**2 - a**9*b*c**8*s**2 + 3*a**8*b**2*c**8*s**2 -
        4*a**7*b**3*c**8*s**2 + a**6*b**4*c**8*s**2 +
        4*a**5*b**5*c**8*s**2 - 4*a**4*b**6*c**8*s**2 -
        a**3*b**7*c**8*s**2 + 5*a**2*b**8*c**8*s**2 -
        4*a*b**9*c**8*s**2 + b**10*c**8*s**2 + a**6*b**3*c**9*s**2 -
        2*a**5*b**4*c**9*s**2 + a**4*b**5*c**9*s**2 +
        a**3*b**6*c**9*s**2 - 2*a**2*b**7*c**9*s**2 +
        a*b**8*c**9*s**2), (-3*a**7*b**7*c**2 - a**6*b**8*c**2 -
        9*a**7*b**6*c**3 - 12*a**6*b**7*c**3 - 2*a**5*b**8*c**3 -
        8*a**7*b**5*c**4 - 25*a**6*b**6*c**4 - 20*a**5*b**7*c**4 -
        4*a**4*b**8*c**4 - 8*a**7*b**4*c**5 - 18*a**6*b**5*c**5 -
        31*a**5*b**6*c**5 - 24*a**4*b**7*c**5 - 5*a**3*b**8*c**5 -
        12*a**7*b**3*c**6 - 23*a**6*b**4*c**6 - 20*a**5*b**5*c**6 -
        25*a**4*b**6*c**6 - 16*a**3*b**7*c**6 - 2*a**2*b**8*c**6 -
        8*a**7*b**2*c**7 - 27*a**6*b**3*c**7 - 28*a**5*b**4*c**7 -
        17*a**4*b**5*c**7 - 13*a**3*b**6*c**7 - 5*a**2*b**7*c**7 -
        2*a**7*b*c**8 - 14*a**6*b**2*c**8 - 29*a**5*b**3*c**8 -
        28*a**4*b**4*c**8 - 16*a**3*b**5*c**8 - 6*a**2*b**6*c**8 -
        a*b**7*c**8 - 2*a**6*b*c**9 - 9*a**5*b**2*c**9 -
        16*a**4*b**3*c**9 - 14*a**3*b**4*c**9 - 6*a**2*b**5*c**9 -
        a*b**6*c**9 + a**7*b**5*c**2*s**2 + 10*a**6*b**6*c**2*s**2 +
        14*a**5*b**7*c**2*s**2 + 3*a**4*b**8*c**2*s**2 +
        5*a**7*b**4*c**3*s**2 + 46*a**6*b**5*c**3*s**2 +
        86*a**5*b**6*c**3*s**2 + 50*a**4*b**7*c**3*s**2 +
        5*a**3*b**8*c**3*s**2 + 5*a**7*b**3*c**4*s**2 +
        69*a**6*b**4*c**4*s**2 + 184*a**5*b**5*c**4*s**2 +
        166*a**4*b**6*c**4*s**2 + 48*a**3*b**7*c**4*s**2 +
        2*a**2*b**8*c**4*s**2 + a**7*b**2*c**5*s**2 +
        44*a**6*b**3*c**5*s**2 + 184*a**5*b**4*c**5*s**2 +
        243*a**4*b**5*c**5*s**2 + 115*a**3*b**6*c**5*s**2 +
        14*a**2*b**7*c**5*s**2 + 17*a**6*b**2*c**6*s**2 +
        114*a**5*b**3*c**6*s**2 + 210*a**4*b**4*c**6*s**2 +
        150*a**3*b**5*c**6*s**2 + 37*a**2*b**6*c**6*s**2 +
        a*b**7*c**6*s**2 + 4*a**6*b*c**7*s**2 + 43*a**5*b**2*c**7*s**2
        + 107*a**4*b**3*c**7*s**2 + 102*a**3*b**4*c**7*s**2 +
        41*a**2*b**5*c**7*s**2 + 5*a*b**6*c**7*s**2 +
        5*a**5*b*c**8*s**2 + 20*a**4*b**2*c**8*s**2 +
        25*a**3*b**3*c**8*s**2 + 12*a**2*b**4*c**8*s**2 +
        2*a*b**5*c**8*s**2 + 3*a**6*b**4*c**2*s**4 +
        12*a**5*b**5*c**2*s**4 + 11*a**4*b**6*c**2*s**4 +
        2*a**3*b**7*c**2*s**4 + 6*a**6*b**3*c**3*s**4 +
        35*a**5*b**4*c**3*s**4 + 54*a**4*b**5*c**3*s**4 +
        26*a**3*b**6*c**3*s**4 + 2*a**2*b**7*c**3*s**4 +
        2*a**6*b**2*c**4*s**4 + 30*a**5*b**3*c**4*s**4 +
        78*a**4*b**4*c**4*s**4 + 66*a**3*b**5*c**4*s**4 +
        15*a**2*b**6*c**4*s**4 + a**6*b*c**5*s**4 +
        14*a**5*b**2*c**5*s**4 + 57*a**4*b**3*c**5*s**4 +
        73*a**3*b**4*c**5*s**4 + 35*a**2*b**5*c**5*s**4 +
        3*a*b**6*c**5*s**4 + 6*a**5*b*c**6*s**4 +
        29*a**4*b**2*c**6*s**4 + 46*a**3*b**3*c**6*s**4 +
        31*a**2*b**4*c**6*s**4 + 9*a*b**5*c**6*s**4 +
        8*a**4*b*c**7*s**4 + 16*a**3*b**2*c**7*s**4 +
        10*a**2*b**3*c**7*s**4 + 3*a*b**4*c**7*s**4 +
        2*a**3*b*c**8*s**4 + a**2*b**2*c**8*s**4)/(a**8*b**6*s**2 -
        2*a**7*b**7*s**2 + a**6*b**8*s**2 - 2*a**8*b**5*c*s**2 +
        4*a**7*b**6*c*s**2 - a**6*b**7*c*s**2 - 2*a**5*b**8*c*s**2 +
        a**4*b**9*c*s**2 + a**8*b**4*c**2*s**2 - 3*a**7*b**5*c**2*s**2
        + 5*a**5*b**7*c**2*s**2 - 3*a**4*b**8*c**2*s**2 +
        a**8*b**3*c**3*s**2 + a**7*b**4*c**3*s**2 -
        2*a**6*b**5*c**3*s**2 - 4*a**5*b**6*c**3*s**2 +
        4*a**4*b**7*c**3*s**2 + a**3*b**8*c**3*s**2 -
        a**2*b**9*c**3*s**2 - 2*a**8*b**2*c**4*s**2 +
        5*a**6*b**4*c**4*s**2 + a**5*b**5*c**4*s**2 -
        5*a**4*b**6*c**4*s**2 - a**3*b**7*c**4*s**2 +
        2*a**2*b**8*c**4*s**2 + a**8*b*c**5*s**2 + a**7*b**2*c**5*s**2
        - 5*a**6*b**3*c**5*s**2 + 5*a**4*b**5*c**5*s**2 -
        a**3*b**6*c**5*s**2 - a**2*b**7*c**5*s**2 - a**7*b*c**6*s**2 +
        a**6*b**2*c**6*s**2 + a**5*b**3*c**6*s**2 -
        2*a**4*b**4*c**6*s**2 + 3*a**3*b**5*c**6*s**2 -
        2*a**2*b**6*c**6*s**2 - a*b**7*c**6*s**2 + b**8*c**6*s**2 +
        2*a**6*b*c**7*s**2 - a**5*b**2*c**7*s**2 -
        2*a**4*b**3*c**7*s**2 - 4*a**3*b**4*c**7*s**2 +
        5*a**2*b**5*c**7*s**2 + 3*a*b**6*c**7*s**2 - 3*b**7*c**7*s**2
        - a**6*c**8*s**2 - a**5*b*c**8*s**2 + 4*a**4*b**2*c**8*s**2 +
        3*a**3*b**3*c**8*s**2 - 5*a**2*b**4*c**8*s**2 -
        4*a*b**5*c**8*s**2 + 4*b**6*c**8*s**2 + a**5*c**9*s**2 -
        2*a**4*b*c**9*s**2 - 2*a**3*b**2*c**9*s**2 +
        3*a**2*b**3*c**9*s**2 + 3*a*b**4*c**9*s**2 - 3*b**5*c**9*s**2
        + a**3*b*c**10*s**2 - a**2*b**2*c**10*s**2 - a*b**3*c**10*s**2
        + b**4*c**10*s**2), (-a**7*b**8*c - a**6*b**9*c -
        2*a**8*b**6*c**2 - 5*a**7*b**7*c**2 - 6*a**6*b**8*c**2 -
        6*a**5*b**9*c**2 - 5*a**8*b**5*c**3 - 16*a**7*b**6*c**3 -
        13*a**6*b**7*c**3 - 16*a**5*b**8*c**3 - 14*a**4*b**9*c**3 -
        4*a**8*b**4*c**4 - 24*a**7*b**5*c**4 - 25*a**6*b**6*c**4 -
        17*a**5*b**7*c**4 - 28*a**4*b**8*c**4 - 16*a**3*b**9*c**4 -
        2*a**8*b**3*c**5 - 20*a**7*b**4*c**5 - 31*a**6*b**5*c**5 -
        20*a**5*b**6*c**5 - 28*a**4*b**7*c**5 - 29*a**3*b**8*c**5 -
        9*a**2*b**9*c**5 - a**8*b**2*c**6 - 12*a**7*b**3*c**6 -
        25*a**6*b**4*c**6 - 18*a**5*b**5*c**6 - 23*a**4*b**6*c**6 -
        27*a**3*b**7*c**6 - 14*a**2*b**8*c**6 - 2*a*b**9*c**6 -
        3*a**7*b**2*c**7 - 9*a**6*b**3*c**7 - 8*a**5*b**4*c**7 -
        8*a**4*b**5*c**7 - 12*a**3*b**6*c**7 - 8*a**2*b**7*c**7 -
        2*a*b**8*c**7 + a**7*b**6*c*s**2 + 5*a**6*b**7*c*s**2 +
        2*a**5*b**8*c*s**2 + 2*a**8*b**4*c**2*s**2 +
        14*a**7*b**5*c**2*s**2 + 37*a**6*b**6*c**2*s**2 +
        41*a**5*b**7*c**2*s**2 + 12*a**4*b**8*c**2*s**2 +
        5*a**8*b**3*c**3*s**2 + 48*a**7*b**4*c**3*s**2 +
        115*a**6*b**5*c**3*s**2 + 150*a**5*b**6*c**3*s**2 +
        102*a**4*b**7*c**3*s**2 + 25*a**3*b**8*c**3*s**2 +
        3*a**8*b**2*c**4*s**2 + 50*a**7*b**3*c**4*s**2 +
        166*a**6*b**4*c**4*s**2 + 243*a**5*b**5*c**4*s**2 +
        210*a**4*b**6*c**4*s**2 + 107*a**3*b**7*c**4*s**2 +
        20*a**2*b**8*c**4*s**2 + 14*a**7*b**2*c**5*s**2 +
        86*a**6*b**3*c**5*s**2 + 184*a**5*b**4*c**5*s**2 +
        184*a**4*b**5*c**5*s**2 + 114*a**3*b**6*c**5*s**2 +
        43*a**2*b**7*c**5*s**2 + 5*a*b**8*c**5*s**2 +
        10*a**6*b**2*c**6*s**2 + 46*a**5*b**3*c**6*s**2 +
        69*a**4*b**4*c**6*s**2 + 44*a**3*b**5*c**6*s**2 +
        17*a**2*b**6*c**6*s**2 + 4*a*b**7*c**6*s**2 +
        a**5*b**2*c**7*s**2 + 5*a**4*b**3*c**7*s**2 +
        5*a**3*b**4*c**7*s**2 + a**2*b**5*c**7*s**2 +
        3*a**6*b**5*c*s**4 + 9*a**5*b**6*c*s**4 + 3*a**4*b**7*c*s**4 +
        2*a**7*b**3*c**2*s**4 + 15*a**6*b**4*c**2*s**4 +
        35*a**5*b**5*c**2*s**4 + 31*a**4*b**6*c**2*s**4 +
        10*a**3*b**7*c**2*s**4 + a**2*b**8*c**2*s**4 +
        2*a**7*b**2*c**3*s**4 + 26*a**6*b**3*c**3*s**4 +
        66*a**5*b**4*c**3*s**4 + 73*a**4*b**5*c**3*s**4 +
        46*a**3*b**6*c**3*s**4 + 16*a**2*b**7*c**3*s**4 +
        2*a*b**8*c**3*s**4 + 11*a**6*b**2*c**4*s**4 +
        54*a**5*b**3*c**4*s**4 + 78*a**4*b**4*c**4*s**4 +
        57*a**3*b**5*c**4*s**4 + 29*a**2*b**6*c**4*s**4 +
        8*a*b**7*c**4*s**4 + 12*a**5*b**2*c**5*s**4 +
        35*a**4*b**3*c**5*s**4 + 30*a**3*b**4*c**5*s**4 +
        14*a**2*b**5*c**5*s**4 + 6*a*b**6*c**5*s**4 +
        3*a**4*b**2*c**6*s**4 + 6*a**3*b**3*c**6*s**4 +
        2*a**2*b**4*c**6*s**4 + a*b**5*c**6*s**4)/(a**8*b**6*s**2 -
        3*a**7*b**7*s**2 + 4*a**6*b**8*s**2 - 3*a**5*b**9*s**2 +
        a**4*b**10*s**2 - a**7*b**6*c*s**2 + 3*a**6*b**7*c*s**2 -
        4*a**5*b**8*c*s**2 + 3*a**4*b**9*c*s**2 - a**3*b**10*c*s**2 -
        a**9*b**3*c**2*s**2 + 2*a**8*b**4*c**2*s**2 -
        a**7*b**5*c**2*s**2 - 2*a**6*b**6*c**2*s**2 +
        5*a**5*b**7*c**2*s**2 - 5*a**4*b**8*c**2*s**2 +
        3*a**3*b**9*c**2*s**2 - a**2*b**10*c**2*s**2 +
        a**8*b**3*c**3*s**2 - a**7*b**4*c**3*s**2 -
        a**6*b**5*c**3*s**2 + 3*a**5*b**6*c**3*s**2 -
        4*a**4*b**7*c**3*s**2 + 3*a**3*b**8*c**3*s**2 -
        2*a**2*b**9*c**3*s**2 + a*b**10*c**3*s**2 + a**9*b*c**4*s**2 -
        3*a**8*b**2*c**4*s**2 + 4*a**7*b**3*c**4*s**2 -
        5*a**6*b**4*c**4*s**2 + 5*a**5*b**5*c**4*s**2 -
        2*a**4*b**6*c**4*s**2 - 2*a**3*b**7*c**4*s**2 +
        4*a**2*b**8*c**4*s**2 - 2*a*b**9*c**4*s**2 -
        2*a**8*b*c**5*s**2 + 5*a**7*b**2*c**5*s**2 -
        4*a**6*b**3*c**5*s**2 + a**5*b**4*c**5*s**2 +
        a**3*b**6*c**5*s**2 - a**2*b**7*c**5*s**2 - a*b**8*c**5*s**2 +
        b**9*c**5*s**2 + a**8*c**6*s**2 - a**7*b*c**6*s**2 -
        2*a**5*b**3*c**6*s**2 + 5*a**4*b**4*c**6*s**2 -
        5*a**3*b**5*c**6*s**2 + a**2*b**6*c**6*s**2 +
        2*a*b**7*c**6*s**2 - b**8*c**6*s**2 - 2*a**7*c**7*s**2 +
        4*a**6*b*c**7*s**2 - 3*a**5*b**2*c**7*s**2 +
        a**4*b**3*c**7*s**2 + a**2*b**5*c**7*s**2 - a*b**6*c**7*s**2 +
        a**6*c**8*s**2 - 2*a**5*b*c**8*s**2 + a**4*b**2*c**8*s**2 +
        a**3*b**3*c**8*s**2 - 2*a**2*b**4*c**8*s**2 +
        a*b**5*c**8*s**2), (-2*a**9*b**6*c - 2*a**8*b**7*c -
        9*a**9*b**5*c**2 - 14*a**8*b**6*c**2 - 8*a**7*b**7*c**2 -
        16*a**9*b**4*c**3 - 29*a**8*b**5*c**3 - 27*a**7*b**6*c**3 -
        12*a**6*b**7*c**3 - 14*a**9*b**3*c**4 - 28*a**8*b**4*c**4 -
        28*a**7*b**5*c**4 - 23*a**6*b**6*c**4 - 8*a**5*b**7*c**4 -
        6*a**9*b**2*c**5 - 16*a**8*b**3*c**5 - 17*a**7*b**4*c**5 -
        20*a**6*b**5*c**5 - 18*a**5*b**6*c**5 - 8*a**4*b**7*c**5 -
        a**9*b*c**6 - 6*a**8*b**2*c**6 - 13*a**7*b**3*c**6 -
        25*a**6*b**4*c**6 - 31*a**5*b**5*c**6 - 25*a**4*b**6*c**6 -
        9*a**3*b**7*c**6 - a**8*b*c**7 - 5*a**7*b**2*c**7 -
        16*a**6*b**3*c**7 - 24*a**5*b**4*c**7 - 20*a**4*b**5*c**7 -
        12*a**3*b**6*c**7 - 3*a**2*b**7*c**7 - 2*a**6*b**2*c**8 -
        5*a**5*b**3*c**8 - 4*a**4*b**4*c**8 - 2*a**3*b**5*c**8 -
        a**2*b**6*c**8 + 5*a**8*b**5*c*s**2 + 4*a**7*b**6*c*s**2 +
        20*a**8*b**4*c**2*s**2 + 43*a**7*b**5*c**2*s**2 +
        17*a**6*b**6*c**2*s**2 + a**5*b**7*c**2*s**2 +
        25*a**8*b**3*c**3*s**2 + 107*a**7*b**4*c**3*s**2 +
        114*a**6*b**5*c**3*s**2 + 44*a**5*b**6*c**3*s**2 +
        5*a**4*b**7*c**3*s**2 + 12*a**8*b**2*c**4*s**2 +
        102*a**7*b**3*c**4*s**2 + 210*a**6*b**4*c**4*s**2 +
        184*a**5*b**5*c**4*s**2 + 69*a**4*b**6*c**4*s**2 +
        5*a**3*b**7*c**4*s**2 + 2*a**8*b*c**5*s**2 +
        41*a**7*b**2*c**5*s**2 + 150*a**6*b**3*c**5*s**2 +
        243*a**5*b**4*c**5*s**2 + 184*a**4*b**5*c**5*s**2 +
        46*a**3*b**6*c**5*s**2 + a**2*b**7*c**5*s**2 +
        5*a**7*b*c**6*s**2 + 37*a**6*b**2*c**6*s**2 +
        115*a**5*b**3*c**6*s**2 + 166*a**4*b**4*c**6*s**2 +
        86*a**3*b**5*c**6*s**2 + 10*a**2*b**6*c**6*s**2 +
        a**6*b*c**7*s**2 + 14*a**5*b**2*c**7*s**2 +
        48*a**4*b**3*c**7*s**2 + 50*a**3*b**4*c**7*s**2 +
        14*a**2*b**5*c**7*s**2 + 2*a**4*b**2*c**8*s**2 +
        5*a**3*b**3*c**8*s**2 + 3*a**2*b**4*c**8*s**2 +
        2*a**8*b**3*c*s**4 + 8*a**7*b**4*c*s**4 + 6*a**6*b**5*c*s**4 +
        a**5*b**6*c*s**4 + a**8*b**2*c**2*s**4 +
        16*a**7*b**3*c**2*s**4 + 29*a**6*b**4*c**2*s**4 +
        14*a**5*b**5*c**2*s**4 + 2*a**4*b**6*c**2*s**4 +
        10*a**7*b**2*c**3*s**4 + 46*a**6*b**3*c**3*s**4 +
        57*a**5*b**4*c**3*s**4 + 30*a**4*b**5*c**3*s**4 +
        6*a**3*b**6*c**3*s**4 + 3*a**7*b*c**4*s**4 +
        31*a**6*b**2*c**4*s**4 + 73*a**5*b**3*c**4*s**4 +
        78*a**4*b**4*c**4*s**4 + 35*a**3*b**5*c**4*s**4 +
        3*a**2*b**6*c**4*s**4 + 9*a**6*b*c**5*s**4 +
        35*a**5*b**2*c**5*s**4 + 66*a**4*b**3*c**5*s**4 +
        54*a**3*b**4*c**5*s**4 + 12*a**2*b**5*c**5*s**4 +
        3*a**5*b*c**6*s**4 + 15*a**4*b**2*c**6*s**4 +
        26*a**3*b**3*c**6*s**4 + 11*a**2*b**4*c**6*s**4 +
        2*a**3*b**2*c**7*s**4 + 2*a**2*b**3*c**7*s**4)/(a**9*b**5*s**2
        - a**8*b**6*s**2 + a**10*b**3*c*s**2 - 2*a**9*b**4*c*s**2 -
        a**8*b**5*c*s**2 + 2*a**7*b**6*c*s**2 - a**6*b**7*c*s**2 +
        a**5*b**8*c*s**2 - a**10*b**2*c**2*s**2 -
        2*a**9*b**3*c**2*s**2 + 4*a**8*b**4*c**2*s**2 -
        a**7*b**5*c**2*s**2 + a**6*b**6*c**2*s**2 +
        a**5*b**7*c**2*s**2 - 2*a**4*b**8*c**2*s**2 -
        a**10*b*c**3*s**2 + 3*a**9*b**2*c**3*s**2 +
        3*a**8*b**3*c**3*s**2 - 2*a**7*b**4*c**3*s**2 +
        a**6*b**5*c**3*s**2 - 5*a**5*b**6*c**3*s**2 +
        a**3*b**8*c**3*s**2 + a**10*c**4*s**2 + 3*a**9*b*c**4*s**2 -
        5*a**8*b**2*c**4*s**2 - 4*a**7*b**3*c**4*s**2 -
        2*a**6*b**4*c**4*s**2 + 5*a**4*b**6*c**4*s**2 +
        a**3*b**7*c**4*s**2 + a**2*b**8*c**4*s**2 - 3*a**9*c**5*s**2 -
        4*a**8*b*c**5*s**2 + 5*a**7*b**2*c**5*s**2 +
        3*a**6*b**3*c**5*s**2 + 5*a**5*b**4*c**5*s**2 +
        a**4*b**5*c**5*s**2 - 2*a**3*b**6*c**5*s**2 -
        3*a**2*b**7*c**5*s**2 - 2*a*b**8*c**5*s**2 + 4*a**8*c**6*s**2
        + 3*a**7*b*c**6*s**2 - 2*a**6*b**2*c**6*s**2 -
        a**5*b**3*c**6*s**2 - 5*a**4*b**4*c**6*s**2 -
        4*a**3*b**5*c**6*s**2 + 4*a*b**7*c**6*s**2 + b**8*c**6*s**2 -
        3*a**7*c**7*s**2 - a**6*b*c**7*s**2 - a**5*b**2*c**7*s**2 -
        a**4*b**3*c**7*s**2 + 4*a**3*b**4*c**7*s**2 +
        5*a**2*b**5*c**7*s**2 - a*b**6*c**7*s**2 - 2*b**7*c**7*s**2 +
        a**6*c**8*s**2 + 2*a**4*b**2*c**8*s**2 + a**3*b**3*c**8*s**2 -
        3*a**2*b**4*c**8*s**2 - 2*a*b**5*c**8*s**2 + b**6*c**8*s**2 -
        a**3*b**2*c**9*s**2 + a*b**4*c**9*s**2), (2*a**7*b**8*c +
        2*a**6*b**9*c + 8*a**7*b**7*c**2 + 14*a**6*b**8*c**2 +
        9*a**5*b**9*c**2 + 12*a**7*b**6*c**3 + 27*a**6*b**7*c**3 +
        29*a**5*b**8*c**3 + 16*a**4*b**9*c**3 + 8*a**7*b**5*c**4 +
        23*a**6*b**6*c**4 + 28*a**5*b**7*c**4 + 28*a**4*b**8*c**4 +
        14*a**3*b**9*c**4 + 8*a**7*b**4*c**5 + 18*a**6*b**5*c**5 +
        20*a**5*b**6*c**5 + 17*a**4*b**7*c**5 + 16*a**3*b**8*c**5 +
        6*a**2*b**9*c**5 + 9*a**7*b**3*c**6 + 25*a**6*b**4*c**6 +
        31*a**5*b**5*c**6 + 25*a**4*b**6*c**6 + 13*a**3*b**7*c**6 +
        6*a**2*b**8*c**6 + a*b**9*c**6 + 3*a**7*b**2*c**7 +
        12*a**6*b**3*c**7 + 20*a**5*b**4*c**7 + 24*a**4*b**5*c**7 +
        16*a**3*b**6*c**7 + 5*a**2*b**7*c**7 + a*b**8*c**7 +
        a**6*b**2*c**8 + 2*a**5*b**3*c**8 + 4*a**4*b**4*c**8 +
        5*a**3*b**5*c**8 + 2*a**2*b**6*c**8 - 4*a**6*b**7*c*s**2 -
        5*a**5*b**8*c*s**2 - a**7*b**5*c**2*s**2 -
        17*a**6*b**6*c**2*s**2 - 43*a**5*b**7*c**2*s**2 -
        20*a**4*b**8*c**2*s**2 - 5*a**7*b**4*c**3*s**2 -
        44*a**6*b**5*c**3*s**2 - 114*a**5*b**6*c**3*s**2 -
        107*a**4*b**7*c**3*s**2 - 25*a**3*b**8*c**3*s**2 -
        5*a**7*b**3*c**4*s**2 - 69*a**6*b**4*c**4*s**2 -
        184*a**5*b**5*c**4*s**2 - 210*a**4*b**6*c**4*s**2 -
        102*a**3*b**7*c**4*s**2 - 12*a**2*b**8*c**4*s**2 -
        a**7*b**2*c**5*s**2 - 46*a**6*b**3*c**5*s**2 -
        184*a**5*b**4*c**5*s**2 - 243*a**4*b**5*c**5*s**2 -
        150*a**3*b**6*c**5*s**2 - 41*a**2*b**7*c**5*s**2 -
        2*a*b**8*c**5*s**2 - 10*a**6*b**2*c**6*s**2 -
        86*a**5*b**3*c**6*s**2 - 166*a**4*b**4*c**6*s**2 -
        115*a**3*b**5*c**6*s**2 - 37*a**2*b**6*c**6*s**2 -
        5*a*b**7*c**6*s**2 - 14*a**5*b**2*c**7*s**2 -
        50*a**4*b**3*c**7*s**2 - 48*a**3*b**4*c**7*s**2 -
        14*a**2*b**5*c**7*s**2 - a*b**6*c**7*s**2 -
        3*a**4*b**2*c**8*s**2 - 5*a**3*b**3*c**8*s**2 -
        2*a**2*b**4*c**8*s**2 - a**6*b**5*c*s**4 - 6*a**5*b**6*c*s**4
        - 8*a**4*b**7*c*s**4 - 2*a**3*b**8*c*s**4 -
        2*a**6*b**4*c**2*s**4 - 14*a**5*b**5*c**2*s**4 -
        29*a**4*b**6*c**2*s**4 - 16*a**3*b**7*c**2*s**4 -
        a**2*b**8*c**2*s**4 - 6*a**6*b**3*c**3*s**4 -
        30*a**5*b**4*c**3*s**4 - 57*a**4*b**5*c**3*s**4 -
        46*a**3*b**6*c**3*s**4 - 10*a**2*b**7*c**3*s**4 -
        3*a**6*b**2*c**4*s**4 - 35*a**5*b**3*c**4*s**4 -
        78*a**4*b**4*c**4*s**4 - 73*a**3*b**5*c**4*s**4 -
        31*a**2*b**6*c**4*s**4 - 3*a*b**7*c**4*s**4 -
        12*a**5*b**2*c**5*s**4 - 54*a**4*b**3*c**5*s**4 -
        66*a**3*b**4*c**5*s**4 - 35*a**2*b**5*c**5*s**4 -
        9*a*b**6*c**5*s**4 - 11*a**4*b**2*c**6*s**4 -
        26*a**3*b**3*c**6*s**4 - 15*a**2*b**4*c**6*s**4 -
        3*a*b**5*c**6*s**4 - 2*a**3*b**2*c**7*s**4 -
        2*a**2*b**3*c**7*s**4)/(a**6*b**8*s**2 - a**5*b**9*s**2 -
        a**8*b**5*c*s**2 + a**7*b**6*c*s**2 - 2*a**6*b**7*c*s**2 +
        a**5*b**8*c*s**2 + 2*a**4*b**9*c*s**2 - a**3*b**10*c*s**2 +
        2*a**8*b**4*c**2*s**2 - a**7*b**5*c**2*s**2 -
        a**6*b**6*c**2*s**2 + a**5*b**7*c**2*s**2 -
        4*a**4*b**8*c**2*s**2 + 2*a**3*b**9*c**2*s**2 +
        a**2*b**10*c**2*s**2 - a**8*b**3*c**3*s**2 +
        5*a**6*b**5*c**3*s**2 - a**5*b**6*c**3*s**2 +
        2*a**4*b**7*c**3*s**2 - 3*a**3*b**8*c**3*s**2 -
        3*a**2*b**9*c**3*s**2 + a*b**10*c**3*s**2 -
        a**8*b**2*c**4*s**2 - a**7*b**3*c**4*s**2 -
        5*a**6*b**4*c**4*s**2 + 2*a**4*b**6*c**4*s**2 +
        4*a**3*b**7*c**4*s**2 + 5*a**2*b**8*c**4*s**2 -
        3*a*b**9*c**4*s**2 - b**10*c**4*s**2 + 2*a**8*b*c**5*s**2 +
        3*a**7*b**2*c**5*s**2 + 2*a**6*b**3*c**5*s**2 -
        a**5*b**4*c**5*s**2 - 5*a**4*b**5*c**5*s**2 -
        3*a**3*b**6*c**5*s**2 - 5*a**2*b**7*c**5*s**2 +
        4*a*b**8*c**5*s**2 + 3*b**9*c**5*s**2 - a**8*c**6*s**2 -
        4*a**7*b*c**6*s**2 + 4*a**5*b**3*c**6*s**2 +
        5*a**4*b**4*c**6*s**2 + a**3*b**5*c**6*s**2 +
        2*a**2*b**6*c**6*s**2 - 3*a*b**7*c**6*s**2 - 4*b**8*c**6*s**2
        + 2*a**7*c**7*s**2 + a**6*b*c**7*s**2 - 5*a**5*b**2*c**7*s**2
        - 4*a**4*b**3*c**7*s**2 + a**3*b**4*c**7*s**2 +
        a**2*b**5*c**7*s**2 + a*b**6*c**7*s**2 + 3*b**7*c**7*s**2 -
        a**6*c**8*s**2 + 2*a**5*b*c**8*s**2 + 3*a**4*b**2*c**8*s**2 -
        a**3*b**3*c**8*s**2 - 2*a**2*b**4*c**8*s**2 - b**6*c**8*s**2 -
        a**4*b*c**9*s**2 + a**2*b**3*c**9*s**2), (-a**8*b**6*c**2 -
        3*a**7*b**7*c**2 - 2*a**8*b**5*c**3 - 12*a**7*b**6*c**3 -
        9*a**6*b**7*c**3 - 4*a**8*b**4*c**4 - 20*a**7*b**5*c**4 -
        25*a**6*b**6*c**4 - 8*a**5*b**7*c**4 - 5*a**8*b**3*c**5 -
        24*a**7*b**4*c**5 - 31*a**6*b**5*c**5 - 18*a**5*b**6*c**5 -
        8*a**4*b**7*c**5 - 2*a**8*b**2*c**6 - 16*a**7*b**3*c**6 -
        25*a**6*b**4*c**6 - 20*a**5*b**5*c**6 - 23*a**4*b**6*c**6 -
        12*a**3*b**7*c**6 - 5*a**7*b**2*c**7 - 13*a**6*b**3*c**7 -
        17*a**5*b**4*c**7 - 28*a**4*b**5*c**7 - 27*a**3*b**6*c**7 -
        8*a**2*b**7*c**7 - a**7*b*c**8 - 6*a**6*b**2*c**8 -
        16*a**5*b**3*c**8 - 28*a**4*b**4*c**8 - 29*a**3*b**5*c**8 -
        14*a**2*b**6*c**8 - 2*a*b**7*c**8 - a**6*b*c**9 -
        6*a**5*b**2*c**9 - 14*a**4*b**3*c**9 - 16*a**3*b**4*c**9 -
        9*a**2*b**5*c**9 - 2*a*b**6*c**9 + 3*a**8*b**4*c**2*s**2 +
        14*a**7*b**5*c**2*s**2 + 10*a**6*b**6*c**2*s**2 +
        a**5*b**7*c**2*s**2 + 5*a**8*b**3*c**3*s**2 +
        50*a**7*b**4*c**3*s**2 + 86*a**6*b**5*c**3*s**2 +
        46*a**5*b**6*c**3*s**2 + 5*a**4*b**7*c**3*s**2 +
        2*a**8*b**2*c**4*s**2 + 48*a**7*b**3*c**4*s**2 +
        166*a**6*b**4*c**4*s**2 + 184*a**5*b**5*c**4*s**2 +
        69*a**4*b**6*c**4*s**2 + 5*a**3*b**7*c**4*s**2 +
        14*a**7*b**2*c**5*s**2 + 115*a**6*b**3*c**5*s**2 +
        243*a**5*b**4*c**5*s**2 + 184*a**4*b**5*c**5*s**2 +
        44*a**3*b**6*c**5*s**2 + a**2*b**7*c**5*s**2 +
        a**7*b*c**6*s**2 + 37*a**6*b**2*c**6*s**2 +
        150*a**5*b**3*c**6*s**2 + 210*a**4*b**4*c**6*s**2 +
        114*a**3*b**5*c**6*s**2 + 17*a**2*b**6*c**6*s**2 +
        5*a**6*b*c**7*s**2 + 41*a**5*b**2*c**7*s**2 +
        102*a**4*b**3*c**7*s**2 + 107*a**3*b**4*c**7*s**2 +
        43*a**2*b**5*c**7*s**2 + 4*a*b**6*c**7*s**2 +
        2*a**5*b*c**8*s**2 + 12*a**4*b**2*c**8*s**2 +
        25*a**3*b**3*c**8*s**2 + 20*a**2*b**4*c**8*s**2 +
        5*a*b**5*c**8*s**2 + 2*a**7*b**3*c**2*s**4 +
        11*a**6*b**4*c**2*s**4 + 12*a**5*b**5*c**2*s**4 +
        3*a**4*b**6*c**2*s**4 + 2*a**7*b**2*c**3*s**4 +
        26*a**6*b**3*c**3*s**4 + 54*a**5*b**4*c**3*s**4 +
        35*a**4*b**5*c**3*s**4 + 6*a**3*b**6*c**3*s**4 +
        15*a**6*b**2*c**4*s**4 + 66*a**5*b**3*c**4*s**4 +
        78*a**4*b**4*c**4*s**4 + 30*a**3*b**5*c**4*s**4 +
        2*a**2*b**6*c**4*s**4 + 3*a**6*b*c**5*s**4 +
        35*a**5*b**2*c**5*s**4 + 73*a**4*b**3*c**5*s**4 +
        57*a**3*b**4*c**5*s**4 + 14*a**2*b**5*c**5*s**4 +
        a*b**6*c**5*s**4 + 9*a**5*b*c**6*s**4 + 31*a**4*b**2*c**6*s**4
        + 46*a**3*b**3*c**6*s**4 + 29*a**2*b**4*c**6*s**4 +
        6*a*b**5*c**6*s**4 + 3*a**4*b*c**7*s**4 +
        10*a**3*b**2*c**7*s**4 + 16*a**2*b**3*c**7*s**4 +
        8*a*b**4*c**7*s**4 + a**2*b**2*c**8*s**4 +
        2*a*b**3*c**8*s**4)/(a**8*b**6*s**2 - 2*a**7*b**7*s**2 +
        a**6*b**8*s**2 + a**9*b**4*c*s**2 - 2*a**8*b**5*c*s**2 -
        a**7*b**6*c*s**2 + 4*a**6*b**7*c*s**2 - 2*a**5*b**8*c*s**2 -
        3*a**8*b**4*c**2*s**2 + 5*a**7*b**5*c**2*s**2 -
        3*a**5*b**7*c**2*s**2 + a**4*b**8*c**2*s**2 -
        a**9*b**2*c**3*s**2 + a**8*b**3*c**3*s**2 +
        4*a**7*b**4*c**3*s**2 - 4*a**6*b**5*c**3*s**2 -
        2*a**5*b**6*c**3*s**2 + a**4*b**7*c**3*s**2 +
        a**3*b**8*c**3*s**2 + 2*a**8*b**2*c**4*s**2 -
        a**7*b**3*c**4*s**2 - 5*a**6*b**4*c**4*s**2 +
        a**5*b**5*c**4*s**2 + 5*a**4*b**6*c**4*s**2 -
        2*a**2*b**8*c**4*s**2 - a**7*b**2*c**5*s**2 -
        a**6*b**3*c**5*s**2 + 5*a**5*b**4*c**5*s**2 -
        5*a**3*b**6*c**5*s**2 + a**2*b**7*c**5*s**2 + a*b**8*c**5*s**2
        + a**8*c**6*s**2 - a**7*b*c**6*s**2 - 2*a**6*b**2*c**6*s**2 +
        3*a**5*b**3*c**6*s**2 - 2*a**4*b**4*c**6*s**2 +
        a**3*b**5*c**6*s**2 + a**2*b**6*c**6*s**2 - a*b**7*c**6*s**2 -
        3*a**7*c**7*s**2 + 3*a**6*b*c**7*s**2 + 5*a**5*b**2*c**7*s**2
        - 4*a**4*b**3*c**7*s**2 - 2*a**3*b**4*c**7*s**2 -
        a**2*b**5*c**7*s**2 + 2*a*b**6*c**7*s**2 + 4*a**6*c**8*s**2 -
        4*a**5*b*c**8*s**2 - 5*a**4*b**2*c**8*s**2 +
        3*a**3*b**3*c**8*s**2 + 4*a**2*b**4*c**8*s**2 -
        a*b**5*c**8*s**2 - b**6*c**8*s**2 - 3*a**5*c**9*s**2 +
        3*a**4*b*c**9*s**2 + 3*a**3*b**2*c**9*s**2 -
        2*a**2*b**3*c**9*s**2 - 2*a*b**4*c**9*s**2 + b**5*c**9*s**2 +
        a**4*c**10*s**2 - a**3*b*c**10*s**2 - a**2*b**2*c**10*s**2 +
        a*b**3*c**10*s**2), (-a**9*b**6*c - a**8*b**7*c -
        6*a**9*b**5*c**2 - 6*a**8*b**6*c**2 - 5*a**7*b**7*c**2 -
        2*a**6*b**8*c**2 - 14*a**9*b**4*c**3 - 16*a**8*b**5*c**3 -
        13*a**7*b**6*c**3 - 16*a**6*b**7*c**3 - 5*a**5*b**8*c**3 -
        16*a**9*b**3*c**4 - 28*a**8*b**4*c**4 - 17*a**7*b**5*c**4 -
        25*a**6*b**6*c**4 - 24*a**5*b**7*c**4 - 4*a**4*b**8*c**4 -
        9*a**9*b**2*c**5 - 29*a**8*b**3*c**5 - 28*a**7*b**4*c**5 -
        20*a**6*b**5*c**5 - 31*a**5*b**6*c**5 - 20*a**4*b**7*c**5 -
        2*a**3*b**8*c**5 - 2*a**9*b*c**6 - 14*a**8*b**2*c**6 -
        27*a**7*b**3*c**6 - 23*a**6*b**4*c**6 - 18*a**5*b**5*c**6 -
        25*a**4*b**6*c**6 - 12*a**3*b**7*c**6 - a**2*b**8*c**6 -
        2*a**8*b*c**7 - 8*a**7*b**2*c**7 - 12*a**6*b**3*c**7 -
        8*a**5*b**4*c**7 - 8*a**4*b**5*c**7 - 9*a**3*b**6*c**7 -
        3*a**2*b**7*c**7 + 2*a**8*b**5*c*s**2 + 5*a**7*b**6*c*s**2 +
        a**6*b**7*c*s**2 + 12*a**8*b**4*c**2*s**2 +
        41*a**7*b**5*c**2*s**2 + 37*a**6*b**6*c**2*s**2 +
        14*a**5*b**7*c**2*s**2 + 2*a**4*b**8*c**2*s**2 +
        25*a**8*b**3*c**3*s**2 + 102*a**7*b**4*c**3*s**2 +
        150*a**6*b**5*c**3*s**2 + 115*a**5*b**6*c**3*s**2 +
        48*a**4*b**7*c**3*s**2 + 5*a**3*b**8*c**3*s**2 +
        20*a**8*b**2*c**4*s**2 + 107*a**7*b**3*c**4*s**2 +
        210*a**6*b**4*c**4*s**2 + 243*a**5*b**5*c**4*s**2 +
        166*a**4*b**6*c**4*s**2 + 50*a**3*b**7*c**4*s**2 +
        3*a**2*b**8*c**4*s**2 + 5*a**8*b*c**5*s**2 +
        43*a**7*b**2*c**5*s**2 + 114*a**6*b**3*c**5*s**2 +
        184*a**5*b**4*c**5*s**2 + 184*a**4*b**5*c**5*s**2 +
        86*a**3*b**6*c**5*s**2 + 14*a**2*b**7*c**5*s**2 +
        4*a**7*b*c**6*s**2 + 17*a**6*b**2*c**6*s**2 +
        44*a**5*b**3*c**6*s**2 + 69*a**4*b**4*c**6*s**2 +
        46*a**3*b**5*c**6*s**2 + 10*a**2*b**6*c**6*s**2 +
        a**5*b**2*c**7*s**2 + 5*a**4*b**3*c**7*s**2 +
        5*a**3*b**4*c**7*s**2 + a**2*b**5*c**7*s**2 +
        3*a**7*b**4*c*s**4 + 9*a**6*b**5*c*s**4 + 3*a**5*b**6*c*s**4 +
        a**8*b**2*c**2*s**4 + 10*a**7*b**3*c**2*s**4 +
        31*a**6*b**4*c**2*s**4 + 35*a**5*b**5*c**2*s**4 +
        15*a**4*b**6*c**2*s**4 + 2*a**3*b**7*c**2*s**4 +
        2*a**8*b*c**3*s**4 + 16*a**7*b**2*c**3*s**4 +
        46*a**6*b**3*c**3*s**4 + 73*a**5*b**4*c**3*s**4 +
        66*a**4*b**5*c**3*s**4 + 26*a**3*b**6*c**3*s**4 +
        2*a**2*b**7*c**3*s**4 + 8*a**7*b*c**4*s**4 +
        29*a**6*b**2*c**4*s**4 + 57*a**5*b**3*c**4*s**4 +
        78*a**4*b**4*c**4*s**4 + 54*a**3*b**5*c**4*s**4 +
        11*a**2*b**6*c**4*s**4 + 6*a**6*b*c**5*s**4 +
        14*a**5*b**2*c**5*s**4 + 30*a**4*b**3*c**5*s**4 +
        35*a**3*b**4*c**5*s**4 + 12*a**2*b**5*c**5*s**4 +
        a**5*b*c**6*s**4 + 2*a**4*b**2*c**6*s**4 +
        6*a**3*b**3*c**6*s**4 +
        3*a**2*b**4*c**6*s**4)/(a**10*b**4*s**2 - 3*a**9*b**5*s**2 +
        4*a**8*b**6*s**2 - 3*a**7*b**7*s**2 + a**6*b**8*s**2 -
        a**10*b**3*c*s**2 + 3*a**9*b**4*c*s**2 - 4*a**8*b**5*c*s**2 +
        3*a**7*b**6*c*s**2 - a**6*b**7*c*s**2 - a**10*b**2*c**2*s**2 +
        3*a**9*b**3*c**2*s**2 - 5*a**8*b**4*c**2*s**2 +
        5*a**7*b**5*c**2*s**2 - 2*a**6*b**6*c**2*s**2 -
        a**5*b**7*c**2*s**2 + 2*a**4*b**8*c**2*s**2 -
        a**3*b**9*c**2*s**2 + a**10*b*c**3*s**2 -
        2*a**9*b**2*c**3*s**2 + 3*a**8*b**3*c**3*s**2 -
        4*a**7*b**4*c**3*s**2 + 3*a**6*b**5*c**3*s**2 -
        a**5*b**6*c**3*s**2 - a**4*b**7*c**3*s**2 +
        a**3*b**8*c**3*s**2 - 2*a**9*b*c**4*s**2 +
        4*a**8*b**2*c**4*s**2 - 2*a**7*b**3*c**4*s**2 -
        2*a**6*b**4*c**4*s**2 + 5*a**5*b**5*c**4*s**2 -
        5*a**4*b**6*c**4*s**2 + 4*a**3*b**7*c**4*s**2 -
        3*a**2*b**8*c**4*s**2 + a*b**9*c**4*s**2 + a**9*c**5*s**2 -
        a**8*b*c**5*s**2 - a**7*b**2*c**5*s**2 + a**6*b**3*c**5*s**2 +
        a**4*b**5*c**5*s**2 - 4*a**3*b**6*c**5*s**2 +
        5*a**2*b**7*c**5*s**2 - 2*a*b**8*c**5*s**2 - a**8*c**6*s**2 +
        2*a**7*b*c**6*s**2 + a**6*b**2*c**6*s**2 -
        5*a**5*b**3*c**6*s**2 + 5*a**4*b**4*c**6*s**2 -
        2*a**3*b**5*c**6*s**2 - a*b**7*c**6*s**2 + b**8*c**6*s**2 -
        a**6*b*c**7*s**2 + a**5*b**2*c**7*s**2 + a**3*b**4*c**7*s**2 -
        3*a**2*b**5*c**7*s**2 + 4*a*b**6*c**7*s**2 - 2*b**7*c**7*s**2
        + a**5*b*c**8*s**2 - 2*a**4*b**2*c**8*s**2 +
        a**3*b**3*c**8*s**2 + a**2*b**4*c**8*s**2 - 2*a*b**5*c**8*s**2
        + b**6*c**8*s**2), (-2*a**10*b**7*c - 2*a**9*b**8*c -
        10*a**10*b**6*c**2 - 18*a**9*b**7*c**2 - 9*a**8*b**8*c**2 -
        a**7*b**9*c**2 - 22*a**10*b**5*c**3 - 50*a**9*b**6*c**3 -
        46*a**8*b**7*c**3 - 21*a**7*b**8*c**3 - 4*a**6*b**9*c**3 -
        28*a**10*b**4*c**4 - 74*a**9*b**5*c**4 - 88*a**8*b**6*c**4 -
        69*a**7*b**7*c**4 - 33*a**6*b**8*c**4 - 6*a**5*b**9*c**4 -
        22*a**10*b**3*c**5 - 74*a**9*b**4*c**5 - 102*a**8*b**5*c**5 -
        105*a**7*b**6*c**5 - 88*a**6*b**7*c**5 - 41*a**5*b**8*c**5 -
        7*a**4*b**9*c**5 - 10*a**10*b**2*c**6 - 50*a**9*b**3*c**6 -
        88*a**8*b**4*c**6 - 105*a**7*b**5*c**6 - 118*a**6*b**6*c**6 -
        96*a**5*b**7*c**6 - 40*a**4*b**8*c**6 - 6*a**3*b**9*c**6 -
        2*a**10*b*c**7 - 18*a**9*b**2*c**7 - 46*a**8*b**3*c**7 -
        69*a**7*b**4*c**7 - 88*a**6*b**5*c**7 - 96*a**5*b**6*c**7 -
        66*a**4*b**7*c**7 - 21*a**3*b**8*c**7 - 2*a**2*b**9*c**7 -
        2*a**9*b*c**8 - 9*a**8*b**2*c**8 - 21*a**7*b**3*c**8 -
        33*a**6*b**4*c**8 - 41*a**5*b**5*c**8 - 40*a**4*b**6*c**8 -
        21*a**3*b**7*c**8 - 4*a**2*b**8*c**8 - a**7*b**2*c**9 -
        4*a**6*b**3*c**9 - 6*a**5*b**4*c**9 - 7*a**4*b**5*c**9 -
        6*a**3*b**6*c**9 - 2*a**2*b**7*c**9 + 4*a**9*b**6*c*s**2 +
        6*a**8*b**7*c*s**2 + a**7*b**8*c*s**2 + 20*a**9*b**5*c**2*s**2
        + 58*a**8*b**6*c**2*s**2 + 47*a**7*b**7*c**2*s**2 +
        11*a**6*b**8*c**2*s**2 + a**5*b**9*c**2*s**2 +
        40*a**9*b**4*c**3*s**2 + 177*a**8*b**5*c**3*s**2 +
        253*a**7*b**6*c**3*s**2 + 160*a**6*b**7*c**3*s**2 +
        49*a**5*b**8*c**3*s**2 + 5*a**4*b**9*c**3*s**2 +
        40*a**9*b**3*c**4*s**2 + 250*a**8*b**4*c**4*s**2 +
        530*a**7*b**5*c**4*s**2 + 554*a**6*b**6*c**4*s**2 +
        316*a**5*b**7*c**4*s**2 + 86*a**4*b**8*c**4*s**2 +
        6*a**3*b**9*c**4*s**2 + 20*a**9*b**2*c**5*s**2 +
        177*a**8*b**3*c**5*s**2 + 530*a**7*b**4*c**5*s**2 +
        810*a**6*b**5*c**5*s**2 + 709*a**5*b**6*c**5*s**2 +
        328*a**4*b**7*c**5*s**2 + 60*a**3*b**8*c**5*s**2 +
        2*a**2*b**9*c**5*s**2 + 4*a**9*b*c**6*s**2 +
        58*a**8*b**2*c**6*s**2 + 253*a**7*b**3*c**6*s**2 +
        554*a**6*b**4*c**6*s**2 + 709*a**5*b**5*c**6*s**2 +
        494*a**4*b**6*c**6*s**2 + 154*a**3*b**7*c**6*s**2 +
        14*a**2*b**8*c**6*s**2 + 6*a**8*b*c**7*s**2 +
        47*a**7*b**2*c**7*s**2 + 160*a**6*b**3*c**7*s**2 +
        316*a**5*b**4*c**7*s**2 + 328*a**4*b**5*c**7*s**2 +
        154*a**3*b**6*c**7*s**2 + 24*a**2*b**7*c**7*s**2 +
        a**7*b*c**8*s**2 + 11*a**6*b**2*c**8*s**2 +
        49*a**5*b**3*c**8*s**2 + 86*a**4*b**4*c**8*s**2 +
        60*a**3*b**5*c**8*s**2 + 14*a**2*b**6*c**8*s**2 +
        a**5*b**2*c**9*s**2 + 5*a**4*b**3*c**9*s**2 +
        6*a**3*b**4*c**9*s**2 + 2*a**2*b**5*c**9*s**2 +
        a**9*b**4*c*s**4 + 6*a**8*b**5*c*s**4 + 9*a**7*b**6*c*s**4 +
        3*a**6*b**7*c*s**4 + 2*a**9*b**3*c**2*s**4 +
        20*a**8*b**4*c**2*s**4 + 49*a**7*b**5*c**2*s**4 +
        45*a**6*b**6*c**2*s**4 + 17*a**5*b**7*c**2*s**4 +
        3*a**4*b**8*c**2*s**4 + 2*a**9*b**2*c**3*s**4 +
        28*a**8*b**3*c**3*s**4 + 100*a**7*b**4*c**3*s**4 +
        149*a**6*b**5*c**3*s**4 + 111*a**5*b**6*c**3*s**4 +
        42*a**4*b**7*c**3*s**4 + 5*a**3*b**8*c**3*s**4 +
        a**9*b*c**4*s**4 + 20*a**8*b**2*c**4*s**4 +
        100*a**7*b**3*c**4*s**4 + 214*a**6*b**4*c**4*s**4 +
        246*a**5*b**5*c**4*s**4 + 154*a**4*b**6*c**4*s**4 +
        42*a**3*b**7*c**4*s**4 + 2*a**2*b**8*c**4*s**4 +
        6*a**8*b*c**5*s**4 + 49*a**7*b**2*c**5*s**4 +
        149*a**6*b**3*c**5*s**4 + 246*a**5*b**4*c**5*s**4 +
        230*a**4*b**5*c**5*s**4 + 104*a**3*b**6*c**5*s**4 +
        14*a**2*b**7*c**5*s**4 + 9*a**7*b*c**6*s**4 +
        45*a**6*b**2*c**6*s**4 + 111*a**5*b**3*c**6*s**4 +
        154*a**4*b**4*c**6*s**4 + 104*a**3*b**5*c**6*s**4 +
        24*a**2*b**6*c**6*s**4 + 3*a**6*b*c**7*s**4 +
        17*a**5*b**2*c**7*s**4 + 42*a**4*b**3*c**7*s**4 +
        42*a**3*b**4*c**7*s**4 + 14*a**2*b**5*c**7*s**4 +
        3*a**4*b**2*c**8*s**4 + 5*a**3*b**3*c**8*s**4 +
        2*a**2*b**4*c**8*s**4)/(a**9*b**7*s**2 - a**8*b**8*s**2 -
        a**11*b**4*c*s**2 + a**10*b**5*c*s**2 - a**9*b**6*c*s**2 +
        a**8*b**7*c*s**2 + a**7*b**8*c*s**2 - a**6*b**9*c*s**2 +
        a**11*b**3*c**2*s**2 - a**10*b**4*c**2*s**2 -
        2*a**9*b**5*c**2*s**2 + a**8*b**6*c**2*s**2 -
        a**7*b**7*c**2*s**2 + 2*a**6*b**8*c**2*s**2 +
        a**5*b**9*c**2*s**2 - a**4*b**10*c**2*s**2 +
        a**11*b**2*c**3*s**2 + 2*a**9*b**4*c**3*s**2 -
        a**8*b**5*c**3*s**2 - 3*a**7*b**6*c**3*s**2 -
        a**5*b**8*c**3*s**2 + 2*a**4*b**9*c**3*s**2 -
        a**11*b*c**4*s**2 - a**10*b**2*c**4*s**2 +
        2*a**9*b**3*c**4*s**2 + 3*a**7*b**5*c**4*s**2 -
        a**6*b**6*c**4*s**2 - 2*a**5*b**7*c**4*s**2 -
        a**4*b**8*c**4*s**2 + a**2*b**10*c**4*s**2 + a**10*b*c**5*s**2
        - 2*a**9*b**2*c**5*s**2 - a**8*b**3*c**5*s**2 +
        3*a**7*b**4*c**5*s**2 + 2*a**5*b**6*c**5*s**2 -
        a**4*b**7*c**5*s**2 - a**3*b**8*c**5*s**2 -
        a**2*b**9*c**5*s**2 - a**9*b*c**6*s**2 + a**8*b**2*c**6*s**2 -
        3*a**7*b**3*c**6*s**2 - a**6*b**4*c**6*s**2 +
        2*a**5*b**5*c**6*s**2 + 2*a**4*b**6*c**6*s**2 +
        a**3*b**7*c**6*s**2 - a**2*b**8*c**6*s**2 + a**9*c**7*s**2 +
        a**8*b*c**7*s**2 - a**7*b**2*c**7*s**2 - 2*a**5*b**4*c**7*s**2
        - a**4*b**5*c**7*s**2 + a**3*b**6*c**7*s**2 +
        2*a**2*b**7*c**7*s**2 - b**9*c**7*s**2 - a**8*c**8*s**2 +
        a**7*b*c**8*s**2 + 2*a**6*b**2*c**8*s**2 - a**5*b**3*c**8*s**2
        - a**4*b**4*c**8*s**2 - a**3*b**5*c**8*s**2 -
        a**2*b**6*c**8*s**2 + 2*b**8*c**8*s**2 - a**6*b*c**9*s**2 +
        a**5*b**2*c**9*s**2 + 2*a**4*b**3*c**9*s**2 -
        a**2*b**5*c**9*s**2 - b**7*c**9*s**2 - a**4*b**2*c**10*s**2 +
        a**2*b**4*c**10*s**2), (2*a**9*b**7*c**2 + 4*a**8*b**8*c**2 +
        2*a**7*b**9*c**2 + 6*a**9*b**6*c**3 + 21*a**8*b**7*c**3 +
        21*a**7*b**8*c**3 + 6*a**6*b**9*c**3 + 7*a**9*b**5*c**4 +
        40*a**8*b**6*c**4 + 66*a**7*b**7*c**4 + 40*a**6*b**8*c**4 +
        7*a**5*b**9*c**4 + 6*a**9*b**4*c**5 + 41*a**8*b**5*c**5 +
        96*a**7*b**6*c**5 + 96*a**6*b**7*c**5 + 41*a**5*b**8*c**5 +
        6*a**4*b**9*c**5 + 4*a**9*b**3*c**6 + 33*a**8*b**4*c**6 +
        88*a**7*b**5*c**6 + 118*a**6*b**6*c**6 + 88*a**5*b**7*c**6 +
        33*a**4*b**8*c**6 + 4*a**3*b**9*c**6 + a**9*b**2*c**7 +
        21*a**8*b**3*c**7 + 69*a**7*b**4*c**7 + 105*a**6*b**5*c**7 +
        105*a**5*b**6*c**7 + 69*a**4*b**7*c**7 + 21*a**3*b**8*c**7 +
        a**2*b**9*c**7 + 9*a**8*b**2*c**8 + 46*a**7*b**3*c**8 +
        88*a**6*b**4*c**8 + 102*a**5*b**5*c**8 + 88*a**4*b**6*c**8 +
        46*a**3*b**7*c**8 + 9*a**2*b**8*c**8 + 2*a**8*b*c**9 +
        18*a**7*b**2*c**9 + 50*a**6*b**3*c**9 + 74*a**5*b**4*c**9 +
        74*a**4*b**5*c**9 + 50*a**3*b**6*c**9 + 18*a**2*b**7*c**9 +
        2*a*b**8*c**9 + 2*a**7*b*c**10 + 10*a**6*b**2*c**10 +
        22*a**5*b**3*c**10 + 28*a**4*b**4*c**10 + 22*a**3*b**5*c**10 +
        10*a**2*b**6*c**10 + 2*a*b**7*c**10 - 2*a**9*b**5*c**2*s**2 -
        14*a**8*b**6*c**2*s**2 - 24*a**7*b**7*c**2*s**2 -
        14*a**6*b**8*c**2*s**2 - 2*a**5*b**9*c**2*s**2 -
        6*a**9*b**4*c**3*s**2 - 60*a**8*b**5*c**3*s**2 -
        154*a**7*b**6*c**3*s**2 - 154*a**6*b**7*c**3*s**2 -
        60*a**5*b**8*c**3*s**2 - 6*a**4*b**9*c**3*s**2 -
        5*a**9*b**3*c**4*s**2 - 86*a**8*b**4*c**4*s**2 -
        328*a**7*b**5*c**4*s**2 - 494*a**6*b**6*c**4*s**2 -
        328*a**5*b**7*c**4*s**2 - 86*a**4*b**8*c**4*s**2 -
        5*a**3*b**9*c**4*s**2 - a**9*b**2*c**5*s**2 -
        49*a**8*b**3*c**5*s**2 - 316*a**7*b**4*c**5*s**2 -
        709*a**6*b**5*c**5*s**2 - 709*a**5*b**6*c**5*s**2 -
        316*a**4*b**7*c**5*s**2 - 49*a**3*b**8*c**5*s**2 -
        a**2*b**9*c**5*s**2 - 11*a**8*b**2*c**6*s**2 -
        160*a**7*b**3*c**6*s**2 - 554*a**6*b**4*c**6*s**2 -
        810*a**5*b**5*c**6*s**2 - 554*a**4*b**6*c**6*s**2 -
        160*a**3*b**7*c**6*s**2 - 11*a**2*b**8*c**6*s**2 -
        a**8*b*c**7*s**2 - 47*a**7*b**2*c**7*s**2 -
        253*a**6*b**3*c**7*s**2 - 530*a**5*b**4*c**7*s**2 -
        530*a**4*b**5*c**7*s**2 - 253*a**3*b**6*c**7*s**2 -
        47*a**2*b**7*c**7*s**2 - a*b**8*c**7*s**2 - 6*a**7*b*c**8*s**2
        - 58*a**6*b**2*c**8*s**2 - 177*a**5*b**3*c**8*s**2 -
        250*a**4*b**4*c**8*s**2 - 177*a**3*b**5*c**8*s**2 -
        58*a**2*b**6*c**8*s**2 - 6*a*b**7*c**8*s**2 -
        4*a**6*b*c**9*s**2 - 20*a**5*b**2*c**9*s**2 -
        40*a**4*b**3*c**9*s**2 - 40*a**3*b**4*c**9*s**2 -
        20*a**2*b**5*c**9*s**2 - 4*a*b**6*c**9*s**2 -
        2*a**8*b**4*c**2*s**4 - 14*a**7*b**5*c**2*s**4 -
        24*a**6*b**6*c**2*s**4 - 14*a**5*b**7*c**2*s**4 -
        2*a**4*b**8*c**2*s**4 - 5*a**8*b**3*c**3*s**4 -
        42*a**7*b**4*c**3*s**4 - 104*a**6*b**5*c**3*s**4 -
        104*a**5*b**6*c**3*s**4 - 42*a**4*b**7*c**3*s**4 -
        5*a**3*b**8*c**3*s**4 - 3*a**8*b**2*c**4*s**4 -
        42*a**7*b**3*c**4*s**4 - 154*a**6*b**4*c**4*s**4 -
        230*a**5*b**5*c**4*s**4 - 154*a**4*b**6*c**4*s**4 -
        42*a**3*b**7*c**4*s**4 - 3*a**2*b**8*c**4*s**4 -
        17*a**7*b**2*c**5*s**4 - 111*a**6*b**3*c**5*s**4 -
        246*a**5*b**4*c**5*s**4 - 246*a**4*b**5*c**5*s**4 -
        111*a**3*b**6*c**5*s**4 - 17*a**2*b**7*c**5*s**4 -
        3*a**7*b*c**6*s**4 - 45*a**6*b**2*c**6*s**4 -
        149*a**5*b**3*c**6*s**4 - 214*a**4*b**4*c**6*s**4 -
        149*a**3*b**5*c**6*s**4 - 45*a**2*b**6*c**6*s**4 -
        3*a*b**7*c**6*s**4 - 9*a**6*b*c**7*s**4 -
        49*a**5*b**2*c**7*s**4 - 100*a**4*b**3*c**7*s**4 -
        100*a**3*b**4*c**7*s**4 - 49*a**2*b**5*c**7*s**4 -
        9*a*b**6*c**7*s**4 - 6*a**5*b*c**8*s**4 -
        20*a**4*b**2*c**8*s**4 - 28*a**3*b**3*c**8*s**4 -
        20*a**2*b**4*c**8*s**4 - 6*a*b**5*c**8*s**4 - a**4*b*c**9*s**4
        - 2*a**3*b**2*c**9*s**4 - 2*a**2*b**3*c**9*s**4 -
        a*b**4*c**9*s**4)/(a**9*b**7*s**2 - 2*a**8*b**8*s**2 +
        a**7*b**9*s**2 - a**10*b**4*c**2*s**2 + a**9*b**5*c**2*s**2 +
        a**8*b**6*c**2*s**2 - 2*a**7*b**7*c**2*s**2 +
        a**6*b**8*c**2*s**2 + a**5*b**9*c**2*s**2 -
        a**4*b**10*c**2*s**2 + a**8*b**5*c**3*s**2 -
        a**7*b**6*c**3*s**2 - a**6*b**7*c**3*s**2 +
        a**5*b**8*c**3*s**2 + a**10*b**2*c**4*s**2 -
        2*a**9*b**3*c**4*s**2 + a**8*b**4*c**4*s**2 +
        a**7*b**5*c**4*s**2 - 2*a**6*b**6*c**4*s**2 +
        a**5*b**7*c**4*s**2 + a**4*b**8*c**4*s**2 -
        2*a**3*b**9*c**4*s**2 + a**2*b**10*c**4*s**2 -
        a**9*b**2*c**5*s**2 + a**8*b**3*c**5*s**2 +
        2*a**7*b**4*c**5*s**2 - 2*a**6*b**5*c**5*s**2 -
        2*a**5*b**6*c**5*s**2 + 2*a**4*b**7*c**5*s**2 +
        a**3*b**8*c**5*s**2 - a**2*b**9*c**5*s**2 + a**9*b*c**6*s**2 -
        2*a**8*b**2*c**6*s**2 + a**6*b**4*c**6*s**2 +
        a**4*b**6*c**6*s**2 - 2*a**2*b**8*c**6*s**2 + a*b**9*c**6*s**2
        - a**8*b*c**7*s**2 + a**7*b**2*c**7*s**2 +
        3*a**6*b**3*c**7*s**2 - 3*a**5*b**4*c**7*s**2 -
        3*a**4*b**5*c**7*s**2 + 3*a**3*b**6*c**7*s**2 +
        a**2*b**7*c**7*s**2 - a*b**8*c**7*s**2 + a**8*c**8*s**2 -
        a**7*b*c**8*s**2 - a**6*b**2*c**8*s**2 + a**5*b**3*c**8*s**2 +
        a**3*b**5*c**8*s**2 - a**2*b**6*c**8*s**2 - a*b**7*c**8*s**2 +
        b**8*c**8*s**2 - a**7*c**9*s**2 + a**6*b*c**9*s**2 +
        2*a**5*b**2*c**9*s**2 - 2*a**4*b**3*c**9*s**2 -
        2*a**3*b**4*c**9*s**2 + 2*a**2*b**5*c**9*s**2 +
        a*b**6*c**9*s**2 - b**7*c**9*s**2 - a**5*b*c**10*s**2 +
        a**4*b**2*c**10*s**2 + a**2*b**4*c**10*s**2 -
        a*b**5*c**10*s**2 + a**4*b*c**11*s**2 - a**3*b**2*c**11*s**2 -
        a**2*b**3*c**11*s**2 + a*b**4*c**11*s**2), (2*a**8*b**9*c +
        2*a**7*b**10*c + a**9*b**7*c**2 + 9*a**8*b**8*c**2 +
        18*a**7*b**9*c**2 + 10*a**6*b**10*c**2 + 4*a**9*b**6*c**3 +
        21*a**8*b**7*c**3 + 46*a**7*b**8*c**3 + 50*a**6*b**9*c**3 +
        22*a**5*b**10*c**3 + 6*a**9*b**5*c**4 + 33*a**8*b**6*c**4 +
        69*a**7*b**7*c**4 + 88*a**6*b**8*c**4 + 74*a**5*b**9*c**4 +
        28*a**4*b**10*c**4 + 7*a**9*b**4*c**5 + 41*a**8*b**5*c**5 +
        88*a**7*b**6*c**5 + 105*a**6*b**7*c**5 + 102*a**5*b**8*c**5 +
        74*a**4*b**9*c**5 + 22*a**3*b**10*c**5 + 6*a**9*b**3*c**6 +
        40*a**8*b**4*c**6 + 96*a**7*b**5*c**6 + 118*a**6*b**6*c**6 +
        105*a**5*b**7*c**6 + 88*a**4*b**8*c**6 + 50*a**3*b**9*c**6 +
        10*a**2*b**10*c**6 + 2*a**9*b**2*c**7 + 21*a**8*b**3*c**7 +
        66*a**7*b**4*c**7 + 96*a**6*b**5*c**7 + 88*a**5*b**6*c**7 +
        69*a**4*b**7*c**7 + 46*a**3*b**8*c**7 + 18*a**2*b**9*c**7 +
        2*a*b**10*c**7 + 4*a**8*b**2*c**8 + 21*a**7*b**3*c**8 +
        40*a**6*b**4*c**8 + 41*a**5*b**5*c**8 + 33*a**4*b**6*c**8 +
        21*a**3*b**7*c**8 + 9*a**2*b**8*c**8 + 2*a*b**9*c**8 +
        2*a**7*b**2*c**9 + 6*a**6*b**3*c**9 + 7*a**5*b**4*c**9 +
        6*a**4*b**5*c**9 + 4*a**3*b**6*c**9 + a**2*b**7*c**9 -
        a**8*b**7*c*s**2 - 6*a**7*b**8*c*s**2 - 4*a**6*b**9*c*s**2 -
        a**9*b**5*c**2*s**2 - 11*a**8*b**6*c**2*s**2 -
        47*a**7*b**7*c**2*s**2 - 58*a**6*b**8*c**2*s**2 -
        20*a**5*b**9*c**2*s**2 - 5*a**9*b**4*c**3*s**2 -
        49*a**8*b**5*c**3*s**2 - 160*a**7*b**6*c**3*s**2 -
        253*a**6*b**7*c**3*s**2 - 177*a**5*b**8*c**3*s**2 -
        40*a**4*b**9*c**3*s**2 - 6*a**9*b**3*c**4*s**2 -
        86*a**8*b**4*c**4*s**2 - 316*a**7*b**5*c**4*s**2 -
        554*a**6*b**6*c**4*s**2 - 530*a**5*b**7*c**4*s**2 -
        250*a**4*b**8*c**4*s**2 - 40*a**3*b**9*c**4*s**2 -
        2*a**9*b**2*c**5*s**2 - 60*a**8*b**3*c**5*s**2 -
        328*a**7*b**4*c**5*s**2 - 709*a**6*b**5*c**5*s**2 -
        810*a**5*b**6*c**5*s**2 - 530*a**4*b**7*c**5*s**2 -
        177*a**3*b**8*c**5*s**2 - 20*a**2*b**9*c**5*s**2 -
        14*a**8*b**2*c**6*s**2 - 154*a**7*b**3*c**6*s**2 -
        494*a**6*b**4*c**6*s**2 - 709*a**5*b**5*c**6*s**2 -
        554*a**4*b**6*c**6*s**2 - 253*a**3*b**7*c**6*s**2 -
        58*a**2*b**8*c**6*s**2 - 4*a*b**9*c**6*s**2 -
        24*a**7*b**2*c**7*s**2 - 154*a**6*b**3*c**7*s**2 -
        328*a**5*b**4*c**7*s**2 - 316*a**4*b**5*c**7*s**2 -
        160*a**3*b**6*c**7*s**2 - 47*a**2*b**7*c**7*s**2 -
        6*a*b**8*c**7*s**2 - 14*a**6*b**2*c**8*s**2 -
        60*a**5*b**3*c**8*s**2 - 86*a**4*b**4*c**8*s**2 -
        49*a**3*b**5*c**8*s**2 - 11*a**2*b**6*c**8*s**2 -
        a*b**7*c**8*s**2 - 2*a**5*b**2*c**9*s**2 -
        6*a**4*b**3*c**9*s**2 - 5*a**3*b**4*c**9*s**2 -
        a**2*b**5*c**9*s**2 - 3*a**7*b**6*c*s**4 - 9*a**6*b**7*c*s**4
        - 6*a**5*b**8*c*s**4 - a**4*b**9*c*s**4 -
        3*a**8*b**4*c**2*s**4 - 17*a**7*b**5*c**2*s**4 -
        45*a**6*b**6*c**2*s**4 - 49*a**5*b**7*c**2*s**4 -
        20*a**4*b**8*c**2*s**4 - 2*a**3*b**9*c**2*s**4 -
        5*a**8*b**3*c**3*s**4 - 42*a**7*b**4*c**3*s**4 -
        111*a**6*b**5*c**3*s**4 - 149*a**5*b**6*c**3*s**4 -
        100*a**4*b**7*c**3*s**4 - 28*a**3*b**8*c**3*s**4 -
        2*a**2*b**9*c**3*s**4 - 2*a**8*b**2*c**4*s**4 -
        42*a**7*b**3*c**4*s**4 - 154*a**6*b**4*c**4*s**4 -
        246*a**5*b**5*c**4*s**4 - 214*a**4*b**6*c**4*s**4 -
        100*a**3*b**7*c**4*s**4 - 20*a**2*b**8*c**4*s**4 -
        a*b**9*c**4*s**4 - 14*a**7*b**2*c**5*s**4 -
        104*a**6*b**3*c**5*s**4 - 230*a**5*b**4*c**5*s**4 -
        246*a**4*b**5*c**5*s**4 - 149*a**3*b**6*c**5*s**4 -
        49*a**2*b**7*c**5*s**4 - 6*a*b**8*c**5*s**4 -
        24*a**6*b**2*c**6*s**4 - 104*a**5*b**3*c**6*s**4 -
        154*a**4*b**4*c**6*s**4 - 111*a**3*b**5*c**6*s**4 -
        45*a**2*b**6*c**6*s**4 - 9*a*b**7*c**6*s**4 -
        14*a**5*b**2*c**7*s**4 - 42*a**4*b**3*c**7*s**4 -
        42*a**3*b**4*c**7*s**4 - 17*a**2*b**5*c**7*s**4 -
        3*a*b**6*c**7*s**4 - 2*a**4*b**2*c**8*s**4 -
        5*a**3*b**3*c**8*s**4 - 3*a**2*b**4*c**8*s**4)/(a**8*b**8*s**2
        - a**7*b**9*s**2 + a**9*b**6*c*s**2 - a**8*b**7*c*s**2 -
        a**7*b**8*c*s**2 + a**6*b**9*c*s**2 - a**5*b**10*c*s**2 +
        a**4*b**11*c*s**2 + a**10*b**4*c**2*s**2 - a**9*b**5*c**2*s**2
        - 2*a**8*b**6*c**2*s**2 + a**7*b**7*c**2*s**2 -
        a**6*b**8*c**2*s**2 + 2*a**5*b**9*c**2*s**2 +
        a**4*b**10*c**2*s**2 - a**3*b**11*c**2*s**2 -
        2*a**9*b**4*c**3*s**2 + a**8*b**5*c**3*s**2 +
        3*a**6*b**7*c**3*s**2 + a**5*b**8*c**3*s**2 -
        2*a**4*b**9*c**3*s**2 - a**2*b**11*c**3*s**2 -
        a**10*b**2*c**4*s**2 + a**8*b**4*c**4*s**2 +
        2*a**7*b**5*c**4*s**2 + a**6*b**6*c**4*s**2 -
        3*a**5*b**7*c**4*s**2 - 2*a**3*b**9*c**4*s**2 +
        a**2*b**10*c**4*s**2 + a*b**11*c**4*s**2 + a**9*b**2*c**5*s**2
        + a**8*b**3*c**5*s**2 + a**7*b**4*c**5*s**2 -
        2*a**6*b**5*c**5*s**2 - 3*a**4*b**7*c**5*s**2 +
        a**3*b**8*c**5*s**2 + 2*a**2*b**9*c**5*s**2 -
        a*b**10*c**5*s**2 + a**8*b**2*c**6*s**2 - a**7*b**3*c**6*s**2
        - 2*a**6*b**4*c**6*s**2 - 2*a**5*b**5*c**6*s**2 +
        a**4*b**6*c**6*s**2 + 3*a**3*b**7*c**6*s**2 -
        a**2*b**8*c**6*s**2 + a*b**9*c**6*s**2 + a**9*c**7*s**2 -
        2*a**7*b**2*c**7*s**2 - a**6*b**3*c**7*s**2 +
        a**5*b**4*c**7*s**2 + 2*a**4*b**5*c**7*s**2 +
        a**2*b**7*c**7*s**2 - a*b**8*c**7*s**2 - b**9*c**7*s**2 -
        2*a**8*c**8*s**2 + a**6*b**2*c**8*s**2 + a**5*b**3*c**8*s**2 +
        a**4*b**4*c**8*s**2 + a**3*b**5*c**8*s**2 -
        2*a**2*b**6*c**8*s**2 - a*b**7*c**8*s**2 + b**8*c**8*s**2 +
        a**7*c**9*s**2 + a**5*b**2*c**9*s**2 - 2*a**3*b**4*c**9*s**2 -
        a**2*b**5*c**9*s**2 + a*b**6*c**9*s**2 - a**4*b**2*c**10*s**2
        + a**2*b**4*c**10*s**2), (-a**8*b**7*c - a**7*b**8*c -
        4*a**8*b**6*c**2 - 8*a**7*b**7*c**2 - 4*a**6*b**8*c**2 +
        (zeta3 - 5)*a**8*b**5*c**3 + (zeta3 - 17)*a**7*b**6*c**3 +
        (zeta3 - 17)*a**6*b**7*c**3 + (zeta3 - 5)*a**5*b**8*c**3 +
        (2*zeta3 - 4)*a**8*b**4*c**4 + (10/3*zeta3 -
        49/3)*a**7*b**5*c**4 + (8/3*zeta3 - 74/3)*a**6*b**6*c**4 +
        (10/3*zeta3 - 49/3)*a**5*b**7*c**4 + (2*zeta3 -
        4)*a**4*b**8*c**4 + (zeta3 - 5)*a**8*b**3*c**5 + (10/3*zeta3 -
        49/3)*a**7*b**4*c**5 + (10/3*zeta3 - 70/3)*a**6*b**5*c**5 +
        (10/3*zeta3 - 70/3)*a**5*b**6*c**5 + (10/3*zeta3 -
        49/3)*a**4*b**7*c**5 + (zeta3 - 5)*a**3*b**8*c**5 -
        4*a**8*b**2*c**6 + (zeta3 - 17)*a**7*b**3*c**6 + (8/3*zeta3 -
        74/3)*a**6*b**4*c**6 + (10/3*zeta3 - 70/3)*a**5*b**5*c**6 +
        (8/3*zeta3 - 74/3)*a**4*b**6*c**6 + (zeta3 -
        17)*a**3*b**7*c**6 - 4*a**2*b**8*c**6 - a**8*b*c**7 -
        8*a**7*b**2*c**7 + (zeta3 - 17)*a**6*b**3*c**7 + (10/3*zeta3 -
        49/3)*a**5*b**4*c**7 + (10/3*zeta3 - 49/3)*a**4*b**5*c**7 +
        (zeta3 - 17)*a**3*b**6*c**7 - 8*a**2*b**7*c**7 - a*b**8*c**7 -
        a**7*b*c**8 - 4*a**6*b**2*c**8 + (zeta3 - 5)*a**5*b**3*c**8 +
        (2*zeta3 - 4)*a**4*b**4*c**8 + (zeta3 - 5)*a**3*b**5*c**8 -
        4*a**2*b**6*c**8 - a*b**7*c**8 + (1/3*zeta3 +
        2/3)*a**8*b**5*c*s**2 + (5/3*zeta3 + 13/3)*a**7*b**6*c*s**2 +
        (5/3*zeta3 + 13/3)*a**6*b**7*c*s**2 + (1/3*zeta3 +
        2/3)*a**5*b**8*c*s**2 + (2*zeta3 + 4)*a**8*b**4*c**2*s**2 +
        (44/3*zeta3 + 94/3)*a**7*b**5*c**2*s**2 + (76/3*zeta3 +
        164/3)*a**6*b**6*c**2*s**2 + (44/3*zeta3 +
        94/3)*a**5*b**7*c**2*s**2 + (2*zeta3 + 4)*a**4*b**8*c**2*s**2
        + (10/3*zeta3 + 20/3)*a**8*b**3*c**3*s**2 + (109/3*zeta3 +
        221/3)*a**7*b**4*c**3*s**2 + (283/3*zeta3 +
        569/3)*a**6*b**5*c**3*s**2 + (283/3*zeta3 +
        569/3)*a**5*b**6*c**3*s**2 + (109/3*zeta3 +
        221/3)*a**4*b**7*c**3*s**2 + (10/3*zeta3 +
        20/3)*a**3*b**8*c**3*s**2 + (2*zeta3 + 4)*a**8*b**2*c**4*s**2
        + (109/3*zeta3 + 221/3)*a**7*b**3*c**4*s**2 + (424/3*zeta3 +
        836/3)*a**6*b**4*c**4*s**2 + (214*zeta3 +
        418)*a**5*b**5*c**4*s**2 + (424/3*zeta3 +
        836/3)*a**4*b**6*c**4*s**2 + (109/3*zeta3 +
        221/3)*a**3*b**7*c**4*s**2 + (2*zeta3 + 4)*a**2*b**8*c**4*s**2
        + (1/3*zeta3 + 2/3)*a**8*b*c**5*s**2 + (44/3*zeta3 +
        94/3)*a**7*b**2*c**5*s**2 + (283/3*zeta3 +
        569/3)*a**6*b**3*c**5*s**2 + (214*zeta3 +
        418)*a**5*b**4*c**5*s**2 + (214*zeta3 +
        418)*a**4*b**5*c**5*s**2 + (283/3*zeta3 +
        569/3)*a**3*b**6*c**5*s**2 + (44/3*zeta3 +
        94/3)*a**2*b**7*c**5*s**2 + (1/3*zeta3 + 2/3)*a*b**8*c**5*s**2
        + (5/3*zeta3 + 13/3)*a**7*b*c**6*s**2 + (76/3*zeta3 +
        164/3)*a**6*b**2*c**6*s**2 + (283/3*zeta3 +
        569/3)*a**5*b**3*c**6*s**2 + (424/3*zeta3 +
        836/3)*a**4*b**4*c**6*s**2 + (283/3*zeta3 +
        569/3)*a**3*b**5*c**6*s**2 + (76/3*zeta3 +
        164/3)*a**2*b**6*c**6*s**2 + (5/3*zeta3 +
        13/3)*a*b**7*c**6*s**2 + (5/3*zeta3 + 13/3)*a**6*b*c**7*s**2 +
        (44/3*zeta3 + 94/3)*a**5*b**2*c**7*s**2 + (109/3*zeta3 +
        221/3)*a**4*b**3*c**7*s**2 + (109/3*zeta3 +
        221/3)*a**3*b**4*c**7*s**2 + (44/3*zeta3 +
        94/3)*a**2*b**5*c**7*s**2 + (5/3*zeta3 +
        13/3)*a*b**6*c**7*s**2 + (1/3*zeta3 + 2/3)*a**5*b*c**8*s**2 +
        (2*zeta3 + 4)*a**4*b**2*c**8*s**2 + (10/3*zeta3 +
        20/3)*a**3*b**3*c**8*s**2 + (2*zeta3 + 4)*a**2*b**4*c**8*s**2
        + (1/3*zeta3 + 2/3)*a*b**5*c**8*s**2 + (zeta3 +
        2)*a**7*b**4*c*s**4 + (4*zeta3 + 8)*a**6*b**5*c*s**4 +
        (4*zeta3 + 8)*a**5*b**6*c*s**4 + (zeta3 + 2)*a**4*b**7*c*s**4
        + (8/3*zeta3 + 16/3)*a**7*b**3*c**2*s**4 + (47/3*zeta3 +
        91/3)*a**6*b**4*c**2*s**4 + (26*zeta3 +
        50)*a**5*b**5*c**2*s**4 + (47/3*zeta3 +
        91/3)*a**4*b**6*c**2*s**4 + (8/3*zeta3 +
        16/3)*a**3*b**7*c**2*s**4 + (8/3*zeta3 +
        16/3)*a**7*b**2*c**3*s**4 + (70/3*zeta3 +
        134/3)*a**6*b**3*c**3*s**4 + (172/3*zeta3 +
        326/3)*a**5*b**4*c**3*s**4 + (172/3*zeta3 +
        326/3)*a**4*b**5*c**3*s**4 + (70/3*zeta3 +
        134/3)*a**3*b**6*c**3*s**4 + (8/3*zeta3 +
        16/3)*a**2*b**7*c**3*s**4 + (zeta3 + 2)*a**7*b*c**4*s**4 +
        (47/3*zeta3 + 91/3)*a**6*b**2*c**4*s**4 + (172/3*zeta3 +
        326/3)*a**5*b**3*c**4*s**4 + (256/3*zeta3 +
        482/3)*a**4*b**4*c**4*s**4 + (172/3*zeta3 +
        326/3)*a**3*b**5*c**4*s**4 + (47/3*zeta3 +
        91/3)*a**2*b**6*c**4*s**4 + (zeta3 + 2)*a*b**7*c**4*s**4 +
        (4*zeta3 + 8)*a**6*b*c**5*s**4 + (26*zeta3 +
        50)*a**5*b**2*c**5*s**4 + (172/3*zeta3 +
        326/3)*a**4*b**3*c**5*s**4 + (172/3*zeta3 +
        326/3)*a**3*b**4*c**5*s**4 + (26*zeta3 +
        50)*a**2*b**5*c**5*s**4 + (4*zeta3 + 8)*a*b**6*c**5*s**4 +
        (4*zeta3 + 8)*a**5*b*c**6*s**4 + (47/3*zeta3 +
        91/3)*a**4*b**2*c**6*s**4 + (70/3*zeta3 +
        134/3)*a**3*b**3*c**6*s**4 + (47/3*zeta3 +
        91/3)*a**2*b**4*c**6*s**4 + (4*zeta3 + 8)*a*b**5*c**6*s**4 +
        (zeta3 + 2)*a**4*b*c**7*s**4 + (8/3*zeta3 +
        16/3)*a**3*b**2*c**7*s**4 + (8/3*zeta3 +
        16/3)*a**2*b**3*c**7*s**4 + (zeta3 +
        2)*a*b**4*c**7*s**4)/(a**8*b**6*s**2 - a**7*b**7*s**2 +
        a**6*b**8*s**2 + (zeta3 + 1)*a**9*b**4*c*s**2 + (-zeta3 -
        1)*a**8*b**5*c*s**2 + (zeta3 + 1)*a**7*b**6*c*s**2 + (zeta3 +
        1)*a**6*b**7*c*s**2 + (-zeta3 - 1)*a**5*b**8*c*s**2 + (zeta3 +
        1)*a**4*b**9*c*s**2 - a**7*b**5*c**2*s**2 +
        a**6*b**6*c**2*s**2 - a**5*b**7*c**2*s**2 + (-zeta3 +
        1)*a**8*b**3*c**3*s**2 + zeta3*a**7*b**4*c**3*s**2 + (-zeta3 +
        1)*a**6*b**5*c**3*s**2 + (-zeta3 + 1)*a**5*b**6*c**3*s**2 +
        zeta3*a**4*b**7*c**3*s**2 + (-zeta3 + 1)*a**3*b**8*c**3*s**2 +
        (zeta3 + 1)*a**9*b*c**4*s**2 + zeta3*a**7*b**3*c**4*s**2 +
        (3*zeta3 + 3)*a**6*b**4*c**4*s**2 + (-zeta3 -
        2)*a**5*b**5*c**4*s**2 + (3*zeta3 + 3)*a**4*b**6*c**4*s**2 +
        zeta3*a**3*b**7*c**4*s**2 + (zeta3 + 1)*a*b**9*c**4*s**2 +
        (-zeta3 - 1)*a**8*b*c**5*s**2 - a**7*b**2*c**5*s**2 + (-zeta3
        + 1)*a**6*b**3*c**5*s**2 + (-zeta3 - 2)*a**5*b**4*c**5*s**2 +
        (-zeta3 - 2)*a**4*b**5*c**5*s**2 + (-zeta3 +
        1)*a**3*b**6*c**5*s**2 - a**2*b**7*c**5*s**2 + (-zeta3 -
        1)*a*b**8*c**5*s**2 + a**8*c**6*s**2 + (zeta3 +
        1)*a**7*b*c**6*s**2 + a**6*b**2*c**6*s**2 + (-zeta3 +
        1)*a**5*b**3*c**6*s**2 + (3*zeta3 + 3)*a**4*b**4*c**6*s**2 +
        (-zeta3 + 1)*a**3*b**5*c**6*s**2 + a**2*b**6*c**6*s**2 +
        (zeta3 + 1)*a*b**7*c**6*s**2 + b**8*c**6*s**2 - a**7*c**7*s**2
        + (zeta3 + 1)*a**6*b*c**7*s**2 - a**5*b**2*c**7*s**2 +
        zeta3*a**4*b**3*c**7*s**2 + zeta3*a**3*b**4*c**7*s**2 -
        a**2*b**5*c**7*s**2 + (zeta3 + 1)*a*b**6*c**7*s**2 -
        b**7*c**7*s**2 + a**6*c**8*s**2 + (-zeta3 -
        1)*a**5*b*c**8*s**2 + (-zeta3 + 1)*a**3*b**3*c**8*s**2 +
        (-zeta3 - 1)*a*b**5*c**8*s**2 + b**6*c**8*s**2 + (zeta3 +
        1)*a**4*b*c**9*s**2 + (zeta3 + 1)*a*b**4*c**9*s**2),
        (-a**8*b**7*c - a**7*b**8*c - 4*a**8*b**6*c**2 -
        8*a**7*b**7*c**2 - 4*a**6*b**8*c**2 + (-zeta3 -
        6)*a**8*b**5*c**3 + (-zeta3 - 18)*a**7*b**6*c**3 + (-zeta3 -
        18)*a**6*b**7*c**3 + (-zeta3 - 6)*a**5*b**8*c**3 + (-2*zeta3 -
        6)*a**8*b**4*c**4 + (-10/3*zeta3 - 59/3)*a**7*b**5*c**4 +
        (-8/3*zeta3 - 82/3)*a**6*b**6*c**4 + (-10/3*zeta3 -
        59/3)*a**5*b**7*c**4 + (-2*zeta3 - 6)*a**4*b**8*c**4 + (-zeta3
        - 6)*a**8*b**3*c**5 + (-10/3*zeta3 - 59/3)*a**7*b**4*c**5 +
        (-10/3*zeta3 - 80/3)*a**6*b**5*c**5 + (-10/3*zeta3 -
        80/3)*a**5*b**6*c**5 + (-10/3*zeta3 - 59/3)*a**4*b**7*c**5 +
        (-zeta3 - 6)*a**3*b**8*c**5 - 4*a**8*b**2*c**6 + (-zeta3 -
        18)*a**7*b**3*c**6 + (-8/3*zeta3 - 82/3)*a**6*b**4*c**6 +
        (-10/3*zeta3 - 80/3)*a**5*b**5*c**6 + (-8/3*zeta3 -
        82/3)*a**4*b**6*c**6 + (-zeta3 - 18)*a**3*b**7*c**6 -
        4*a**2*b**8*c**6 - a**8*b*c**7 - 8*a**7*b**2*c**7 + (-zeta3 -
        18)*a**6*b**3*c**7 + (-10/3*zeta3 - 59/3)*a**5*b**4*c**7 +
        (-10/3*zeta3 - 59/3)*a**4*b**5*c**7 + (-zeta3 -
        18)*a**3*b**6*c**7 - 8*a**2*b**7*c**7 - a*b**8*c**7 -
        a**7*b*c**8 - 4*a**6*b**2*c**8 + (-zeta3 - 6)*a**5*b**3*c**8 +
        (-2*zeta3 - 6)*a**4*b**4*c**8 + (-zeta3 - 6)*a**3*b**5*c**8 -
        4*a**2*b**6*c**8 - a*b**7*c**8 + (-1/3*zeta3 +
        1/3)*a**8*b**5*c*s**2 + (-5/3*zeta3 + 8/3)*a**7*b**6*c*s**2 +
        (-5/3*zeta3 + 8/3)*a**6*b**7*c*s**2 + (-1/3*zeta3 +
        1/3)*a**5*b**8*c*s**2 + (-2*zeta3 + 2)*a**8*b**4*c**2*s**2 +
        (-44/3*zeta3 + 50/3)*a**7*b**5*c**2*s**2 + (-76/3*zeta3 +
        88/3)*a**6*b**6*c**2*s**2 + (-44/3*zeta3 +
        50/3)*a**5*b**7*c**2*s**2 + (-2*zeta3 + 2)*a**4*b**8*c**2*s**2
        + (-10/3*zeta3 + 10/3)*a**8*b**3*c**3*s**2 + (-109/3*zeta3 +
        112/3)*a**7*b**4*c**3*s**2 + (-283/3*zeta3 +
        286/3)*a**6*b**5*c**3*s**2 + (-283/3*zeta3 +
        286/3)*a**5*b**6*c**3*s**2 + (-109/3*zeta3 +
        112/3)*a**4*b**7*c**3*s**2 + (-10/3*zeta3 +
        10/3)*a**3*b**8*c**3*s**2 + (-2*zeta3 + 2)*a**8*b**2*c**4*s**2
        + (-109/3*zeta3 + 112/3)*a**7*b**3*c**4*s**2 + (-424/3*zeta3 +
        412/3)*a**6*b**4*c**4*s**2 + (-214*zeta3 +
        204)*a**5*b**5*c**4*s**2 + (-424/3*zeta3 +
        412/3)*a**4*b**6*c**4*s**2 + (-109/3*zeta3 +
        112/3)*a**3*b**7*c**4*s**2 + (-2*zeta3 +
        2)*a**2*b**8*c**4*s**2 + (-1/3*zeta3 + 1/3)*a**8*b*c**5*s**2 +
        (-44/3*zeta3 + 50/3)*a**7*b**2*c**5*s**2 + (-283/3*zeta3 +
        286/3)*a**6*b**3*c**5*s**2 + (-214*zeta3 +
        204)*a**5*b**4*c**5*s**2 + (-214*zeta3 +
        204)*a**4*b**5*c**5*s**2 + (-283/3*zeta3 +
        286/3)*a**3*b**6*c**5*s**2 + (-44/3*zeta3 +
        50/3)*a**2*b**7*c**5*s**2 + (-1/3*zeta3 +
        1/3)*a*b**8*c**5*s**2 + (-5/3*zeta3 + 8/3)*a**7*b*c**6*s**2 +
        (-76/3*zeta3 + 88/3)*a**6*b**2*c**6*s**2 + (-283/3*zeta3 +
        286/3)*a**5*b**3*c**6*s**2 + (-424/3*zeta3 +
        412/3)*a**4*b**4*c**6*s**2 + (-283/3*zeta3 +
        286/3)*a**3*b**5*c**6*s**2 + (-76/3*zeta3 +
        88/3)*a**2*b**6*c**6*s**2 + (-5/3*zeta3 +
        8/3)*a*b**7*c**6*s**2 + (-5/3*zeta3 + 8/3)*a**6*b*c**7*s**2 +
        (-44/3*zeta3 + 50/3)*a**5*b**2*c**7*s**2 + (-109/3*zeta3 +
        112/3)*a**4*b**3*c**7*s**2 + (-109/3*zeta3 +
        112/3)*a**3*b**4*c**7*s**2 + (-44/3*zeta3 +
        50/3)*a**2*b**5*c**7*s**2 + (-5/3*zeta3 +
        8/3)*a*b**6*c**7*s**2 + (-1/3*zeta3 + 1/3)*a**5*b*c**8*s**2 +
        (-2*zeta3 + 2)*a**4*b**2*c**8*s**2 + (-10/3*zeta3 +
        10/3)*a**3*b**3*c**8*s**2 + (-2*zeta3 + 2)*a**2*b**4*c**8*s**2
        + (-1/3*zeta3 + 1/3)*a*b**5*c**8*s**2 + (-zeta3 +
        1)*a**7*b**4*c*s**4 + (-4*zeta3 + 4)*a**6*b**5*c*s**4 +
        (-4*zeta3 + 4)*a**5*b**6*c*s**4 + (-zeta3 +
        1)*a**4*b**7*c*s**4 + (-8/3*zeta3 + 8/3)*a**7*b**3*c**2*s**4 +
        (-47/3*zeta3 + 44/3)*a**6*b**4*c**2*s**4 + (-26*zeta3 +
        24)*a**5*b**5*c**2*s**4 + (-47/3*zeta3 +
        44/3)*a**4*b**6*c**2*s**4 + (-8/3*zeta3 +
        8/3)*a**3*b**7*c**2*s**4 + (-8/3*zeta3 +
        8/3)*a**7*b**2*c**3*s**4 + (-70/3*zeta3 +
        64/3)*a**6*b**3*c**3*s**4 + (-172/3*zeta3 +
        154/3)*a**5*b**4*c**3*s**4 + (-172/3*zeta3 +
        154/3)*a**4*b**5*c**3*s**4 + (-70/3*zeta3 +
        64/3)*a**3*b**6*c**3*s**4 + (-8/3*zeta3 +
        8/3)*a**2*b**7*c**3*s**4 + (-zeta3 + 1)*a**7*b*c**4*s**4 +
        (-47/3*zeta3 + 44/3)*a**6*b**2*c**4*s**4 + (-172/3*zeta3 +
        154/3)*a**5*b**3*c**4*s**4 + (-256/3*zeta3 +
        226/3)*a**4*b**4*c**4*s**4 + (-172/3*zeta3 +
        154/3)*a**3*b**5*c**4*s**4 + (-47/3*zeta3 +
        44/3)*a**2*b**6*c**4*s**4 + (-zeta3 + 1)*a*b**7*c**4*s**4 +
        (-4*zeta3 + 4)*a**6*b*c**5*s**4 + (-26*zeta3 +
        24)*a**5*b**2*c**5*s**4 + (-172/3*zeta3 +
        154/3)*a**4*b**3*c**5*s**4 + (-172/3*zeta3 +
        154/3)*a**3*b**4*c**5*s**4 + (-26*zeta3 +
        24)*a**2*b**5*c**5*s**4 + (-4*zeta3 + 4)*a*b**6*c**5*s**4 +
        (-4*zeta3 + 4)*a**5*b*c**6*s**4 + (-47/3*zeta3 +
        44/3)*a**4*b**2*c**6*s**4 + (-70/3*zeta3 +
        64/3)*a**3*b**3*c**6*s**4 + (-47/3*zeta3 +
        44/3)*a**2*b**4*c**6*s**4 + (-4*zeta3 + 4)*a*b**5*c**6*s**4 +
        (-zeta3 + 1)*a**4*b*c**7*s**4 + (-8/3*zeta3 +
        8/3)*a**3*b**2*c**7*s**4 + (-8/3*zeta3 +
        8/3)*a**2*b**3*c**7*s**4 + (-zeta3 +
        1)*a*b**4*c**7*s**4)/(a**8*b**6*s**2 - a**7*b**7*s**2 +
        a**6*b**8*s**2 + (-zeta3)*a**9*b**4*c*s**2 +
        zeta3*a**8*b**5*c*s**2 + (-zeta3)*a**7*b**6*c*s**2 +
        (-zeta3)*a**6*b**7*c*s**2 + zeta3*a**5*b**8*c*s**2 +
        (-zeta3)*a**4*b**9*c*s**2 - a**7*b**5*c**2*s**2 +
        a**6*b**6*c**2*s**2 - a**5*b**7*c**2*s**2 + (zeta3 +
        2)*a**8*b**3*c**3*s**2 + (-zeta3 - 1)*a**7*b**4*c**3*s**2 +
        (zeta3 + 2)*a**6*b**5*c**3*s**2 + (zeta3 +
        2)*a**5*b**6*c**3*s**2 + (-zeta3 - 1)*a**4*b**7*c**3*s**2 +
        (zeta3 + 2)*a**3*b**8*c**3*s**2 + (-zeta3)*a**9*b*c**4*s**2 +
        (-zeta3 - 1)*a**7*b**3*c**4*s**2 +
        (-3*zeta3)*a**6*b**4*c**4*s**2 + (zeta3 -
        1)*a**5*b**5*c**4*s**2 + (-3*zeta3)*a**4*b**6*c**4*s**2 +
        (-zeta3 - 1)*a**3*b**7*c**4*s**2 + (-zeta3)*a*b**9*c**4*s**2 +
        zeta3*a**8*b*c**5*s**2 - a**7*b**2*c**5*s**2 + (zeta3 +
        2)*a**6*b**3*c**5*s**2 + (zeta3 - 1)*a**5*b**4*c**5*s**2 +
        (zeta3 - 1)*a**4*b**5*c**5*s**2 + (zeta3 +
        2)*a**3*b**6*c**5*s**2 - a**2*b**7*c**5*s**2 +
        zeta3*a*b**8*c**5*s**2 + a**8*c**6*s**2 +
        (-zeta3)*a**7*b*c**6*s**2 + a**6*b**2*c**6*s**2 + (zeta3 +
        2)*a**5*b**3*c**6*s**2 + (-3*zeta3)*a**4*b**4*c**6*s**2 +
        (zeta3 + 2)*a**3*b**5*c**6*s**2 + a**2*b**6*c**6*s**2 +
        (-zeta3)*a*b**7*c**6*s**2 + b**8*c**6*s**2 - a**7*c**7*s**2 +
        (-zeta3)*a**6*b*c**7*s**2 - a**5*b**2*c**7*s**2 + (-zeta3 -
        1)*a**4*b**3*c**7*s**2 + (-zeta3 - 1)*a**3*b**4*c**7*s**2 -
        a**2*b**5*c**7*s**2 + (-zeta3)*a*b**6*c**7*s**2 -
        b**7*c**7*s**2 + a**6*c**8*s**2 + zeta3*a**5*b*c**8*s**2 +
        (zeta3 + 2)*a**3*b**3*c**8*s**2 + zeta3*a*b**5*c**8*s**2 +
        b**6*c**8*s**2 + (-zeta3)*a**4*b*c**9*s**2 +
        (-zeta3)*a*b**4*c**9*s**2)], 'U3': [(-6*a**19*b**7*c -
        36*a**19*b**6*c**2 - 21*a**18*b**7*c**2 - 10*a**17*b**8*c**2 +
        5*a**16*b**9*c**2 - 90*a**19*b**5*c**3 - 105*a**18*b**6*c**3 -
        87*a**17*b**7*c**3 + 6*a**16*b**8*c**3 + 3*a**15*b**9*c**3 +
        9*a**14*b**10*c**3 - 120*a**19*b**4*c**4 - 210*a**18*b**5*c**4
        - 258*a**17*b**6*c**4 - 55*a**16*b**7*c**4 -
        11*a**15*b**8*c**4 + 45*a**14*b**9*c**4 + 9*a**13*b**10*c**4 +
        8*a**12*b**11*c**4 - 90*a**19*b**3*c**5 - 210*a**18*b**4*c**5
        - 362*a**17*b**5*c**5 - 160*a**16*b**6*c**5 -
        74*a**15*b**7*c**5 + 88*a**14*b**8*c**5 + 28*a**13*b**9*c**5 +
        41*a**12*b**10*c**5 + 2*a**11*b**11*c**5 + 3*a**10*b**12*c**5
        - 36*a**19*b**2*c**6 - 105*a**18*b**3*c**6 -
        258*a**17*b**4*c**6 - 160*a**16*b**5*c**6 -
        120*a**15*b**6*c**6 + 102*a**14*b**7*c**6 + 30*a**13*b**8*c**6
        + 82*a**12*b**9*c**6 - 11*a**11*b**10*c**6 -
        5*a**10*b**11*c**6 - 9*a**9*b**12*c**6 - 6*a**19*b*c**7 -
        21*a**18*b**2*c**7 - 87*a**17*b**3*c**7 - 55*a**16*b**4*c**7 -
        74*a**15*b**5*c**7 + 102*a**14*b**6*c**7 + 22*a**13*b**7*c**7
        + 97*a**12*b**8*c**7 - 63*a**11*b**9*c**7 -
        76*a**10*b**10*c**7 - 81*a**9*b**11*c**7 - 21*a**8*b**12*c**7
        - 3*a**7*b**13*c**7 - 10*a**17*b**2*c**8 + 6*a**16*b**3*c**8 -
        11*a**15*b**4*c**8 + 88*a**14*b**5*c**8 + 30*a**13*b**6*c**8 +
        97*a**12*b**7*c**8 - 100*a**11*b**8*c**8 - 182*a**10*b**9*c**8
        - 244*a**9*b**10*c**8 - 112*a**8*b**11*c**8 -
        27*a**7*b**12*c**8 - a**6*b**13*c**8 + 5*a**16*b**2*c**9 +
        3*a**15*b**3*c**9 + 45*a**14*b**4*c**9 + 28*a**13*b**5*c**9 +
        82*a**12*b**6*c**9 - 63*a**11*b**7*c**9 - 182*a**10*b**8*c**9
        - 344*a**9*b**9*c**9 - 231*a**8*b**10*c**9 -
        81*a**7*b**11*c**9 - 7*a**6*b**12*c**9 + a**5*b**13*c**9 +
        9*a**14*b**3*c**10 + 9*a**13*b**4*c**10 + 41*a**12*b**5*c**10
        - 11*a**11*b**6*c**10 - 76*a**10*b**7*c**10 -
        244*a**9*b**8*c**10 - 231*a**8*b**9*c**10 -
        114*a**7*b**10*c**10 - 16*a**6*b**11*c**10 +
        2*a**5*b**12*c**10 - a**4*b**13*c**10 + 8*a**12*b**4*c**11 +
        2*a**11*b**5*c**11 - 5*a**10*b**6*c**11 - 81*a**9*b**7*c**11 -
        112*a**8*b**8*c**11 - 81*a**7*b**9*c**11 - 16*a**6*b**10*c**11
        + 2*a**5*b**11*c**11 - 3*a**4*b**12*c**11 + 3*a**10*b**5*c**12
        - 9*a**9*b**6*c**12 - 21*a**8*b**7*c**12 - 27*a**7*b**8*c**12
        - 7*a**6*b**9*c**12 + 2*a**5*b**10*c**12 - 3*a**4*b**11*c**12
        - 3*a**7*b**7*c**13 - a**6*b**8*c**13 + a**5*b**9*c**13 -
        a**4*b**10*c**13 - a**21*b**4*s**2 + 2*a**20*b**5*s**2 -
        3*a**19*b**6*s**2 - 4*a**21*b**3*c*s**2 + 7*a**20*b**4*c*s**2
        - 16*a**19*b**5*c*s**2 - 12*a**18*b**6*c*s**2 -
        12*a**17*b**7*c*s**2 + 3*a**16*b**8*c*s**2 -
        6*a**21*b**2*c**2*s**2 + 11*a**20*b**3*c**2*s**2 -
        38*a**19*b**4*c**2*s**2 - 57*a**18*b**5*c**2*s**2 -
        85*a**17*b**6*c**2*s**2 - 10*a**16*b**7*c**2*s**2 -
        3*a**15*b**8*c**2*s**2 + 8*a**14*b**9*c**2*s**2 -
        4*a**21*b*c**3*s**2 + 11*a**20*b**2*c**3*s**2 -
        50*a**19*b**3*c**3*s**2 - 111*a**18*b**4*c**3*s**2 -
        230*a**17*b**5*c**3*s**2 - 96*a**16*b**6*c**3*s**2 -
        44*a**15*b**7*c**3*s**2 + 35*a**14*b**8*c**3*s**2 +
        8*a**13*b**9*c**3*s**2 + 9*a**12*b**10*c**3*s**2 -
        a**21*c**4*s**2 + 7*a**20*b*c**4*s**2 -
        38*a**19*b**2*c**4*s**2 - 111*a**18*b**3*c**4*s**2 -
        314*a**17*b**4*c**4*s**2 - 217*a**16*b**5*c**4*s**2 -
        149*a**15*b**6*c**4*s**2 + 55*a**14*b**7*c**4*s**2 +
        23*a**13*b**8*c**4*s**2 + 47*a**12*b**9*c**4*s**2 +
        7*a**11*b**10*c**4*s**2 + 5*a**10*b**11*c**4*s**2 +
        2*a**20*c**5*s**2 - 16*a**19*b*c**5*s**2 -
        57*a**18*b**2*c**5*s**2 - 230*a**17*b**3*c**5*s**2 -
        217*a**16*b**4*c**5*s**2 - 216*a**15*b**5*c**5*s**2 +
        46*a**14*b**6*c**5*s**2 + 19*a**13*b**7*c**5*s**2 +
        98*a**12*b**8*c**5*s**2 + 16*a**11*b**9*c**5*s**2 +
        14*a**10*b**10*c**5*s**2 - 5*a**9*b**11*c**5*s**2 -
        3*a**19*c**6*s**2 - 12*a**18*b*c**6*s**2 -
        85*a**17*b**2*c**6*s**2 - 96*a**16*b**3*c**6*s**2 -
        149*a**15*b**4*c**6*s**2 + 46*a**14*b**5*c**6*s**2 +
        8*a**13*b**6*c**6*s**2 + 122*a**12*b**7*c**6*s**2 -
        13*a**10*b**9*c**6*s**2 - 61*a**9*b**10*c**6*s**2 -
        25*a**8*b**11*c**6*s**2 - 6*a**7*b**12*c**6*s**2 -
        12*a**17*b*c**7*s**2 - 10*a**16*b**2*c**7*s**2 -
        44*a**15*b**3*c**7*s**2 + 55*a**14*b**4*c**7*s**2 +
        19*a**13*b**5*c**7*s**2 + 122*a**12*b**6*c**7*s**2 -
        18*a**11*b**7*c**7*s**2 - 74*a**10*b**8*c**7*s**2 -
        202*a**9*b**9*c**7*s**2 - 137*a**8*b**10*c**7*s**2 -
        51*a**7*b**11*c**7*s**2 - 6*a**6*b**12*c**7*s**2 +
        3*a**16*b*c**8*s**2 - 3*a**15*b**2*c**8*s**2 +
        35*a**14*b**3*c**8*s**2 + 23*a**13*b**4*c**8*s**2 +
        98*a**12*b**5*c**8*s**2 - 74*a**10*b**7*c**8*s**2 -
        292*a**9*b**8*c**8*s**2 - 286*a**8*b**9*c**8*s**2 -
        150*a**7*b**10*c**8*s**2 - 30*a**6*b**11*c**8*s**2 +
        8*a**14*b**2*c**9*s**2 + 8*a**13*b**3*c**9*s**2 +
        47*a**12*b**4*c**9*s**2 + 16*a**11*b**5*c**9*s**2 -
        13*a**10*b**6*c**9*s**2 - 202*a**9*b**7*c**9*s**2 -
        286*a**8*b**8*c**9*s**2 - 210*a**7*b**9*c**9*s**2 -
        60*a**6*b**10*c**9*s**2 + 9*a**12*b**3*c**10*s**2 +
        7*a**11*b**4*c**10*s**2 + 14*a**10*b**5*c**10*s**2 -
        61*a**9*b**6*c**10*s**2 - 137*a**8*b**7*c**10*s**2 -
        150*a**7*b**8*c**10*s**2 - 60*a**6*b**9*c**10*s**2 +
        5*a**10*b**4*c**11*s**2 - 5*a**9*b**5*c**11*s**2 -
        25*a**8*b**6*c**11*s**2 - 51*a**7*b**7*c**11*s**2 -
        30*a**6*b**8*c**11*s**2 - 6*a**7*b**6*c**12*s**2 -
        6*a**6*b**7*c**12*s**2)/(a**25*b*s - 3*a**24*b**2*s +
        5*a**23*b**3*s - 6*a**22*b**4*s + 5*a**21*b**5*s -
        3*a**20*b**6*s + a**19*b**7*s + a**25*c*s - 5*a**24*b*c*s +
        13*a**23*b**2*c*s - 23*a**22*b**3*c*s + 30*a**21*b**4*c*s -
        30*a**20*b**5*c*s + 23*a**19*b**6*c*s - 13*a**18*b**7*c*s +
        5*a**17*b**8*c*s - a**16*b**9*c*s - 3*a**24*c**2*s +
        13*a**23*b*c**2*s - 33*a**22*b**2*c**2*s +
        60*a**21*b**3*c**2*s - 83*a**20*b**4*c**2*s +
        91*a**19*b**5*c**2*s - 79*a**18*b**6*c**2*s +
        54*a**17*b**7*c**2*s - 28*a**16*b**8*c**2*s +
        10*a**15*b**9*c**2*s - 2*a**14*b**10*c**2*s + 5*a**23*c**3*s -
        23*a**22*b*c**3*s + 60*a**21*b**2*c**3*s -
        113*a**20*b**3*c**3*s + 164*a**19*b**4*c**3*s -
        191*a**18*b**5*c**3*s + 180*a**17*b**6*c**3*s -
        137*a**16*b**7*c**3*s + 83*a**15*b**8*c**3*s -
        38*a**14*b**9*c**3*s + 12*a**13*b**10*c**3*s -
        2*a**12*b**11*c**3*s - 6*a**22*c**4*s + 30*a**21*b*c**4*s -
        83*a**20*b**2*c**4*s + 164*a**19*b**3*c**4*s -
        250*a**18*b**4*c**4*s + 307*a**17*b**5*c**4*s -
        308*a**16*b**6*c**4*s + 253*a**15*b**7*c**4*s -
        169*a**14*b**8*c**4*s + 89*a**13*b**9*c**4*s -
        35*a**12*b**10*c**4*s + 9*a**11*b**11*c**4*s -
        a**10*b**12*c**4*s + 5*a**21*c**5*s - 30*a**20*b*c**5*s +
        91*a**19*b**2*c**5*s - 191*a**18*b**3*c**5*s +
        307*a**17*b**4*c**5*s - 395*a**16*b**5*c**5*s +
        417*a**15*b**6*c**5*s - 363*a**14*b**7*c**5*s +
        260*a**13*b**8*c**5*s - 151*a**12*b**9*c**5*s +
        68*a**11*b**10*c**5*s - 22*a**10*b**11*c**5*s +
        4*a**9*b**12*c**5*s - 3*a**20*c**6*s + 23*a**19*b*c**6*s -
        79*a**18*b**2*c**6*s + 180*a**17*b**3*c**6*s -
        308*a**16*b**4*c**6*s + 417*a**15*b**5*c**6*s -
        461*a**14*b**6*c**6*s + 420*a**13*b**7*c**6*s -
        316*a**12*b**8*c**6*s + 195*a**11*b**9*c**6*s -
        96*a**10*b**10*c**6*s + 36*a**9*b**11*c**6*s -
        9*a**8*b**12*c**6*s + a**7*b**13*c**6*s + a**19*c**7*s -
        13*a**18*b*c**7*s + 54*a**17*b**2*c**7*s -
        137*a**16*b**3*c**7*s + 253*a**15*b**4*c**7*s -
        363*a**14*b**5*c**7*s + 420*a**13*b**6*c**7*s -
        398*a**12*b**7*c**7*s + 310*a**11*b**8*c**7*s -
        198*a**10*b**9*c**7*s + 102*a**9*b**10*c**7*s -
        41*a**8*b**11*c**7*s + 12*a**7*b**12*c**7*s -
        2*a**6*b**13*c**7*s + 5*a**17*b*c**8*s - 28*a**16*b**2*c**8*s
        + 83*a**15*b**3*c**8*s - 169*a**14*b**4*c**8*s +
        260*a**13*b**5*c**8*s - 316*a**12*b**6*c**8*s +
        310*a**11*b**7*c**8*s - 247*a**10*b**8*c**8*s +
        159*a**9*b**9*c**8*s - 82*a**8*b**10*c**8*s +
        33*a**7*b**11*c**8*s - 10*a**6*b**12*c**8*s +
        2*a**5*b**13*c**8*s - a**16*b*c**9*s + 10*a**15*b**2*c**9*s -
        38*a**14*b**3*c**9*s + 89*a**13*b**4*c**9*s -
        151*a**12*b**5*c**9*s + 195*a**11*b**6*c**9*s -
        198*a**10*b**7*c**9*s + 159*a**9*b**8*c**9*s -
        99*a**8*b**9*c**9*s + 47*a**7*b**10*c**9*s -
        16*a**6*b**11*c**9*s + 4*a**5*b**12*c**9*s - a**4*b**13*c**9*s
        - 2*a**14*b**2*c**10*s + 12*a**13*b**3*c**10*s -
        35*a**12*b**4*c**10*s + 68*a**11*b**5*c**10*s -
        96*a**10*b**6*c**10*s + 102*a**9*b**7*c**10*s -
        82*a**8*b**8*c**10*s + 47*a**7*b**9*c**10*s -
        16*a**6*b**10*c**10*s + 3*a**4*b**12*c**10*s -
        a**3*b**13*c**10*s - 2*a**12*b**3*c**11*s +
        9*a**11*b**4*c**11*s - 22*a**10*b**5*c**11*s +
        36*a**9*b**6*c**11*s - 41*a**8*b**7*c**11*s +
        33*a**7*b**8*c**11*s - 16*a**6*b**9*c**11*s +
        7*a**4*b**11*c**11*s - 6*a**3*b**12*c**11*s +
        2*a**2*b**13*c**11*s - a**10*b**4*c**12*s +
        4*a**9*b**5*c**12*s - 9*a**8*b**6*c**12*s +
        12*a**7*b**7*c**12*s - 10*a**6*b**8*c**12*s +
        4*a**5*b**9*c**12*s + 3*a**4*b**10*c**12*s -
        6*a**3*b**11*c**12*s + 5*a**2*b**12*c**12*s -
        2*a*b**13*c**12*s + a**7*b**6*c**13*s - 2*a**6*b**7*c**13*s +
        2*a**5*b**8*c**13*s - a**4*b**9*c**13*s - a**3*b**10*c**13*s +
        2*a**2*b**11*c**13*s - 2*a*b**12*c**13*s + b**13*c**13*s),
        (-a**13*b**10*c**4 - 3*a**12*b**11*c**4 - 3*a**11*b**12*c**4 -
        a**10*b**13*c**4 + a**13*b**9*c**5 + 2*a**12*b**10*c**5 +
        2*a**11*b**11*c**5 + 2*a**10*b**12*c**5 + a**9*b**13*c**5 -
        a**13*b**8*c**6 - 7*a**12*b**9*c**6 - 16*a**11*b**10*c**6 -
        16*a**10*b**11*c**6 - 7*a**9*b**12*c**6 - a**8*b**13*c**6 -
        3*a**13*b**7*c**7 - 27*a**12*b**8*c**7 - 81*a**11*b**9*c**7 -
        114*a**10*b**10*c**7 - 81*a**9*b**11*c**7 - 27*a**8*b**12*c**7
        - 3*a**7*b**13*c**7 - 21*a**12*b**7*c**8 - 112*a**11*b**8*c**8
        - 231*a**10*b**9*c**8 - 231*a**9*b**10*c**8 -
        112*a**8*b**11*c**8 - 21*a**7*b**12*c**8 - 9*a**12*b**6*c**9 -
        81*a**11*b**7*c**9 - 244*a**10*b**8*c**9 - 344*a**9*b**9*c**9
        - 244*a**8*b**10*c**9 - 81*a**7*b**11*c**9 - 9*a**6*b**12*c**9
        + 3*a**12*b**5*c**10 - 5*a**11*b**6*c**10 -
        76*a**10*b**7*c**10 - 182*a**9*b**8*c**10 -
        182*a**8*b**9*c**10 - 76*a**7*b**10*c**10 - 5*a**6*b**11*c**10
        + 3*a**5*b**12*c**10 + 2*a**11*b**5*c**11 -
        11*a**10*b**6*c**11 - 63*a**9*b**7*c**11 - 100*a**8*b**8*c**11
        - 63*a**7*b**9*c**11 - 11*a**6*b**10*c**11 +
        2*a**5*b**11*c**11 + 8*a**11*b**4*c**12 + 41*a**10*b**5*c**12
        + 82*a**9*b**6*c**12 + 97*a**8*b**7*c**12 + 97*a**7*b**8*c**12
        + 82*a**6*b**9*c**12 + 41*a**5*b**10*c**12 +
        8*a**4*b**11*c**12 + 9*a**10*b**4*c**13 + 28*a**9*b**5*c**13 +
        30*a**8*b**6*c**13 + 22*a**7*b**7*c**13 + 30*a**6*b**8*c**13 +
        28*a**5*b**9*c**13 + 9*a**4*b**10*c**13 + 9*a**10*b**3*c**14 +
        45*a**9*b**4*c**14 + 88*a**8*b**5*c**14 + 102*a**7*b**6*c**14
        + 102*a**6*b**7*c**14 + 88*a**5*b**8*c**14 +
        45*a**4*b**9*c**14 + 9*a**3*b**10*c**14 + 3*a**9*b**3*c**15 -
        11*a**8*b**4*c**15 - 74*a**7*b**5*c**15 - 120*a**6*b**6*c**15
        - 74*a**5*b**7*c**15 - 11*a**4*b**8*c**15 + 3*a**3*b**9*c**15
        + 5*a**9*b**2*c**16 + 6*a**8*b**3*c**16 - 55*a**7*b**4*c**16 -
        160*a**6*b**5*c**16 - 160*a**5*b**6*c**16 - 55*a**4*b**7*c**16
        + 6*a**3*b**8*c**16 + 5*a**2*b**9*c**16 - 10*a**8*b**2*c**17 -
        87*a**7*b**3*c**17 - 258*a**6*b**4*c**17 - 362*a**5*b**5*c**17
        - 258*a**4*b**6*c**17 - 87*a**3*b**7*c**17 -
        10*a**2*b**8*c**17 - 21*a**7*b**2*c**18 - 105*a**6*b**3*c**18
        - 210*a**5*b**4*c**18 - 210*a**4*b**5*c**18 -
        105*a**3*b**6*c**18 - 21*a**2*b**7*c**18 - 6*a**7*b*c**19 -
        36*a**6*b**2*c**19 - 90*a**5*b**3*c**19 - 120*a**4*b**4*c**19
        - 90*a**3*b**5*c**19 - 36*a**2*b**6*c**19 - 6*a*b**7*c**19 -
        6*a**12*b**7*c**6*s**2 - 30*a**11*b**8*c**6*s**2 -
        60*a**10*b**9*c**6*s**2 - 60*a**9*b**10*c**6*s**2 -
        30*a**8*b**11*c**6*s**2 - 6*a**7*b**12*c**6*s**2 -
        6*a**12*b**6*c**7*s**2 - 51*a**11*b**7*c**7*s**2 -
        150*a**10*b**8*c**7*s**2 - 210*a**9*b**9*c**7*s**2 -
        150*a**8*b**10*c**7*s**2 - 51*a**7*b**11*c**7*s**2 -
        6*a**6*b**12*c**7*s**2 - 25*a**11*b**6*c**8*s**2 -
        137*a**10*b**7*c**8*s**2 - 286*a**9*b**8*c**8*s**2 -
        286*a**8*b**9*c**8*s**2 - 137*a**7*b**10*c**8*s**2 -
        25*a**6*b**11*c**8*s**2 - 5*a**11*b**5*c**9*s**2 -
        61*a**10*b**6*c**9*s**2 - 202*a**9*b**7*c**9*s**2 -
        292*a**8*b**8*c**9*s**2 - 202*a**7*b**9*c**9*s**2 -
        61*a**6*b**10*c**9*s**2 - 5*a**5*b**11*c**9*s**2 +
        5*a**11*b**4*c**10*s**2 + 14*a**10*b**5*c**10*s**2 -
        13*a**9*b**6*c**10*s**2 - 74*a**8*b**7*c**10*s**2 -
        74*a**7*b**8*c**10*s**2 - 13*a**6*b**9*c**10*s**2 +
        14*a**5*b**10*c**10*s**2 + 5*a**4*b**11*c**10*s**2 +
        7*a**10*b**4*c**11*s**2 + 16*a**9*b**5*c**11*s**2 -
        18*a**7*b**7*c**11*s**2 + 16*a**5*b**9*c**11*s**2 +
        7*a**4*b**10*c**11*s**2 + 9*a**10*b**3*c**12*s**2 +
        47*a**9*b**4*c**12*s**2 + 98*a**8*b**5*c**12*s**2 +
        122*a**7*b**6*c**12*s**2 + 122*a**6*b**7*c**12*s**2 +
        98*a**5*b**8*c**12*s**2 + 47*a**4*b**9*c**12*s**2 +
        9*a**3*b**10*c**12*s**2 + 8*a**9*b**3*c**13*s**2 +
        23*a**8*b**4*c**13*s**2 + 19*a**7*b**5*c**13*s**2 +
        8*a**6*b**6*c**13*s**2 + 19*a**5*b**7*c**13*s**2 +
        23*a**4*b**8*c**13*s**2 + 8*a**3*b**9*c**13*s**2 +
        8*a**9*b**2*c**14*s**2 + 35*a**8*b**3*c**14*s**2 +
        55*a**7*b**4*c**14*s**2 + 46*a**6*b**5*c**14*s**2 +
        46*a**5*b**6*c**14*s**2 + 55*a**4*b**7*c**14*s**2 +
        35*a**3*b**8*c**14*s**2 + 8*a**2*b**9*c**14*s**2 -
        3*a**8*b**2*c**15*s**2 - 44*a**7*b**3*c**15*s**2 -
        149*a**6*b**4*c**15*s**2 - 216*a**5*b**5*c**15*s**2 -
        149*a**4*b**6*c**15*s**2 - 44*a**3*b**7*c**15*s**2 -
        3*a**2*b**8*c**15*s**2 + 3*a**8*b*c**16*s**2 -
        10*a**7*b**2*c**16*s**2 - 96*a**6*b**3*c**16*s**2 -
        217*a**5*b**4*c**16*s**2 - 217*a**4*b**5*c**16*s**2 -
        96*a**3*b**6*c**16*s**2 - 10*a**2*b**7*c**16*s**2 +
        3*a*b**8*c**16*s**2 - 12*a**7*b*c**17*s**2 -
        85*a**6*b**2*c**17*s**2 - 230*a**5*b**3*c**17*s**2 -
        314*a**4*b**4*c**17*s**2 - 230*a**3*b**5*c**17*s**2 -
        85*a**2*b**6*c**17*s**2 - 12*a*b**7*c**17*s**2 -
        12*a**6*b*c**18*s**2 - 57*a**5*b**2*c**18*s**2 -
        111*a**4*b**3*c**18*s**2 - 111*a**3*b**4*c**18*s**2 -
        57*a**2*b**5*c**18*s**2 - 12*a*b**6*c**18*s**2 -
        3*a**6*c**19*s**2 - 16*a**5*b*c**19*s**2 -
        38*a**4*b**2*c**19*s**2 - 50*a**3*b**3*c**19*s**2 -
        38*a**2*b**4*c**19*s**2 - 16*a*b**5*c**19*s**2 -
        3*b**6*c**19*s**2 + 2*a**5*c**20*s**2 + 7*a**4*b*c**20*s**2 +
        11*a**3*b**2*c**20*s**2 + 11*a**2*b**3*c**20*s**2 +
        7*a*b**4*c**20*s**2 + 2*b**5*c**20*s**2 - a**4*c**21*s**2 -
        4*a**3*b*c**21*s**2 - 6*a**2*b**2*c**21*s**2 -
        4*a*b**3*c**21*s**2 - b**4*c**21*s**2)/(a**13*b**13*s -
        2*a**13*b**12*c*s - 2*a**12*b**13*c*s + 2*a**13*b**11*c**2*s +
        5*a**12*b**12*c**2*s + 2*a**11*b**13*c**2*s -
        a**13*b**10*c**3*s - 6*a**12*b**11*c**3*s -
        6*a**11*b**12*c**3*s - a**10*b**13*c**3*s - a**13*b**9*c**4*s
        + 3*a**12*b**10*c**4*s + 7*a**11*b**11*c**4*s +
        3*a**10*b**12*c**4*s - a**9*b**13*c**4*s + 2*a**13*b**8*c**5*s
        + 4*a**12*b**9*c**5*s + 4*a**9*b**12*c**5*s +
        2*a**8*b**13*c**5*s - 2*a**13*b**7*c**6*s -
        10*a**12*b**8*c**6*s - 16*a**11*b**9*c**6*s -
        16*a**10*b**10*c**6*s - 16*a**9*b**11*c**6*s -
        10*a**8*b**12*c**6*s - 2*a**7*b**13*c**6*s + a**13*b**6*c**7*s
        + 12*a**12*b**7*c**7*s + 33*a**11*b**8*c**7*s +
        47*a**10*b**9*c**7*s + 47*a**9*b**10*c**7*s +
        33*a**8*b**11*c**7*s + 12*a**7*b**12*c**7*s +
        a**6*b**13*c**7*s - 9*a**12*b**6*c**8*s - 41*a**11*b**7*c**8*s
        - 82*a**10*b**8*c**8*s - 99*a**9*b**9*c**8*s -
        82*a**8*b**10*c**8*s - 41*a**7*b**11*c**8*s -
        9*a**6*b**12*c**8*s + 4*a**12*b**5*c**9*s +
        36*a**11*b**6*c**9*s + 102*a**10*b**7*c**9*s +
        159*a**9*b**8*c**9*s + 159*a**8*b**9*c**9*s +
        102*a**7*b**10*c**9*s + 36*a**6*b**11*c**9*s +
        4*a**5*b**12*c**9*s - a**12*b**4*c**10*s -
        22*a**11*b**5*c**10*s - 96*a**10*b**6*c**10*s -
        198*a**9*b**7*c**10*s - 247*a**8*b**8*c**10*s -
        198*a**7*b**9*c**10*s - 96*a**6*b**10*c**10*s -
        22*a**5*b**11*c**10*s - a**4*b**12*c**10*s +
        9*a**11*b**4*c**11*s + 68*a**10*b**5*c**11*s +
        195*a**9*b**6*c**11*s + 310*a**8*b**7*c**11*s +
        310*a**7*b**8*c**11*s + 195*a**6*b**9*c**11*s +
        68*a**5*b**10*c**11*s + 9*a**4*b**11*c**11*s -
        2*a**11*b**3*c**12*s - 35*a**10*b**4*c**12*s -
        151*a**9*b**5*c**12*s - 316*a**8*b**6*c**12*s -
        398*a**7*b**7*c**12*s - 316*a**6*b**8*c**12*s -
        151*a**5*b**9*c**12*s - 35*a**4*b**10*c**12*s -
        2*a**3*b**11*c**12*s + 12*a**10*b**3*c**13*s +
        89*a**9*b**4*c**13*s + 260*a**8*b**5*c**13*s +
        420*a**7*b**6*c**13*s + 420*a**6*b**7*c**13*s +
        260*a**5*b**8*c**13*s + 89*a**4*b**9*c**13*s +
        12*a**3*b**10*c**13*s - 2*a**10*b**2*c**14*s -
        38*a**9*b**3*c**14*s - 169*a**8*b**4*c**14*s -
        363*a**7*b**5*c**14*s - 461*a**6*b**6*c**14*s -
        363*a**5*b**7*c**14*s - 169*a**4*b**8*c**14*s -
        38*a**3*b**9*c**14*s - 2*a**2*b**10*c**14*s +
        10*a**9*b**2*c**15*s + 83*a**8*b**3*c**15*s +
        253*a**7*b**4*c**15*s + 417*a**6*b**5*c**15*s +
        417*a**5*b**6*c**15*s + 253*a**4*b**7*c**15*s +
        83*a**3*b**8*c**15*s + 10*a**2*b**9*c**15*s - a**9*b*c**16*s -
        28*a**8*b**2*c**16*s - 137*a**7*b**3*c**16*s -
        308*a**6*b**4*c**16*s - 395*a**5*b**5*c**16*s -
        308*a**4*b**6*c**16*s - 137*a**3*b**7*c**16*s -
        28*a**2*b**8*c**16*s - a*b**9*c**16*s + 5*a**8*b*c**17*s +
        54*a**7*b**2*c**17*s + 180*a**6*b**3*c**17*s +
        307*a**5*b**4*c**17*s + 307*a**4*b**5*c**17*s +
        180*a**3*b**6*c**17*s + 54*a**2*b**7*c**17*s +
        5*a*b**8*c**17*s - 13*a**7*b*c**18*s - 79*a**6*b**2*c**18*s -
        191*a**5*b**3*c**18*s - 250*a**4*b**4*c**18*s -
        191*a**3*b**5*c**18*s - 79*a**2*b**6*c**18*s -
        13*a*b**7*c**18*s + a**7*c**19*s + 23*a**6*b*c**19*s +
        91*a**5*b**2*c**19*s + 164*a**4*b**3*c**19*s +
        164*a**3*b**4*c**19*s + 91*a**2*b**5*c**19*s +
        23*a*b**6*c**19*s + b**7*c**19*s - 3*a**6*c**20*s -
        30*a**5*b*c**20*s - 83*a**4*b**2*c**20*s -
        113*a**3*b**3*c**20*s - 83*a**2*b**4*c**20*s -
        30*a*b**5*c**20*s - 3*b**6*c**20*s + 5*a**5*c**21*s +
        30*a**4*b*c**21*s + 60*a**3*b**2*c**21*s +
        60*a**2*b**3*c**21*s + 30*a*b**4*c**21*s + 5*b**5*c**21*s -
        6*a**4*c**22*s - 23*a**3*b*c**22*s - 33*a**2*b**2*c**22*s -
        23*a*b**3*c**22*s - 6*b**4*c**22*s + 5*a**3*c**23*s +
        13*a**2*b*c**23*s + 13*a*b**2*c**23*s + 5*b**3*c**23*s -
        3*a**2*c**24*s - 5*a*b*c**24*s - 3*b**2*c**24*s + a*c**25*s +
        b*c**25*s), (-6*a**7*b**19*c + 5*a**9*b**16*c**2 -
        10*a**8*b**17*c**2 - 21*a**7*b**18*c**2 - 36*a**6*b**19*c**2 +
        9*a**10*b**14*c**3 + 3*a**9*b**15*c**3 + 6*a**8*b**16*c**3 -
        87*a**7*b**17*c**3 - 105*a**6*b**18*c**3 - 90*a**5*b**19*c**3
        + 8*a**11*b**12*c**4 + 9*a**10*b**13*c**4 + 45*a**9*b**14*c**4
        - 11*a**8*b**15*c**4 - 55*a**7*b**16*c**4 -
        258*a**6*b**17*c**4 - 210*a**5*b**18*c**4 -
        120*a**4*b**19*c**4 + 3*a**12*b**10*c**5 + 2*a**11*b**11*c**5
        + 41*a**10*b**12*c**5 + 28*a**9*b**13*c**5 +
        88*a**8*b**14*c**5 - 74*a**7*b**15*c**5 - 160*a**6*b**16*c**5
        - 362*a**5*b**17*c**5 - 210*a**4*b**18*c**5 -
        90*a**3*b**19*c**5 - 9*a**12*b**9*c**6 - 5*a**11*b**10*c**6 -
        11*a**10*b**11*c**6 + 82*a**9*b**12*c**6 + 30*a**8*b**13*c**6
        + 102*a**7*b**14*c**6 - 120*a**6*b**15*c**6 -
        160*a**5*b**16*c**6 - 258*a**4*b**17*c**6 -
        105*a**3*b**18*c**6 - 36*a**2*b**19*c**6 - 3*a**13*b**7*c**7 -
        21*a**12*b**8*c**7 - 81*a**11*b**9*c**7 - 76*a**10*b**10*c**7
        - 63*a**9*b**11*c**7 + 97*a**8*b**12*c**7 + 22*a**7*b**13*c**7
        + 102*a**6*b**14*c**7 - 74*a**5*b**15*c**7 -
        55*a**4*b**16*c**7 - 87*a**3*b**17*c**7 - 21*a**2*b**18*c**7 -
        6*a*b**19*c**7 - a**13*b**6*c**8 - 27*a**12*b**7*c**8 -
        112*a**11*b**8*c**8 - 244*a**10*b**9*c**8 -
        182*a**9*b**10*c**8 - 100*a**8*b**11*c**8 + 97*a**7*b**12*c**8
        + 30*a**6*b**13*c**8 + 88*a**5*b**14*c**8 - 11*a**4*b**15*c**8
        + 6*a**3*b**16*c**8 - 10*a**2*b**17*c**8 + a**13*b**5*c**9 -
        7*a**12*b**6*c**9 - 81*a**11*b**7*c**9 - 231*a**10*b**8*c**9 -
        344*a**9*b**9*c**9 - 182*a**8*b**10*c**9 - 63*a**7*b**11*c**9
        + 82*a**6*b**12*c**9 + 28*a**5*b**13*c**9 + 45*a**4*b**14*c**9
        + 3*a**3*b**15*c**9 + 5*a**2*b**16*c**9 - a**13*b**4*c**10 +
        2*a**12*b**5*c**10 - 16*a**11*b**6*c**10 -
        114*a**10*b**7*c**10 - 231*a**9*b**8*c**10 -
        244*a**8*b**9*c**10 - 76*a**7*b**10*c**10 -
        11*a**6*b**11*c**10 + 41*a**5*b**12*c**10 + 9*a**4*b**13*c**10
        + 9*a**3*b**14*c**10 - 3*a**12*b**4*c**11 + 2*a**11*b**5*c**11
        - 16*a**10*b**6*c**11 - 81*a**9*b**7*c**11 -
        112*a**8*b**8*c**11 - 81*a**7*b**9*c**11 - 5*a**6*b**10*c**11
        + 2*a**5*b**11*c**11 + 8*a**4*b**12*c**11 - 3*a**11*b**4*c**12
        + 2*a**10*b**5*c**12 - 7*a**9*b**6*c**12 - 27*a**8*b**7*c**12
        - 21*a**7*b**8*c**12 - 9*a**6*b**9*c**12 + 3*a**5*b**10*c**12
        - a**10*b**4*c**13 + a**9*b**5*c**13 - a**8*b**6*c**13 -
        3*a**7*b**7*c**13 - 3*a**6*b**19*s**2 + 2*a**5*b**20*s**2 -
        a**4*b**21*s**2 + 3*a**8*b**16*c*s**2 - 12*a**7*b**17*c*s**2 -
        12*a**6*b**18*c*s**2 - 16*a**5*b**19*c*s**2 +
        7*a**4*b**20*c*s**2 - 4*a**3*b**21*c*s**2 +
        8*a**9*b**14*c**2*s**2 - 3*a**8*b**15*c**2*s**2 -
        10*a**7*b**16*c**2*s**2 - 85*a**6*b**17*c**2*s**2 -
        57*a**5*b**18*c**2*s**2 - 38*a**4*b**19*c**2*s**2 +
        11*a**3*b**20*c**2*s**2 - 6*a**2*b**21*c**2*s**2 +
        9*a**10*b**12*c**3*s**2 + 8*a**9*b**13*c**3*s**2 +
        35*a**8*b**14*c**3*s**2 - 44*a**7*b**15*c**3*s**2 -
        96*a**6*b**16*c**3*s**2 - 230*a**5*b**17*c**3*s**2 -
        111*a**4*b**18*c**3*s**2 - 50*a**3*b**19*c**3*s**2 +
        11*a**2*b**20*c**3*s**2 - 4*a*b**21*c**3*s**2 +
        5*a**11*b**10*c**4*s**2 + 7*a**10*b**11*c**4*s**2 +
        47*a**9*b**12*c**4*s**2 + 23*a**8*b**13*c**4*s**2 +
        55*a**7*b**14*c**4*s**2 - 149*a**6*b**15*c**4*s**2 -
        217*a**5*b**16*c**4*s**2 - 314*a**4*b**17*c**4*s**2 -
        111*a**3*b**18*c**4*s**2 - 38*a**2*b**19*c**4*s**2 +
        7*a*b**20*c**4*s**2 - b**21*c**4*s**2 - 5*a**11*b**9*c**5*s**2
        + 14*a**10*b**10*c**5*s**2 + 16*a**9*b**11*c**5*s**2 +
        98*a**8*b**12*c**5*s**2 + 19*a**7*b**13*c**5*s**2 +
        46*a**6*b**14*c**5*s**2 - 216*a**5*b**15*c**5*s**2 -
        217*a**4*b**16*c**5*s**2 - 230*a**3*b**17*c**5*s**2 -
        57*a**2*b**18*c**5*s**2 - 16*a*b**19*c**5*s**2 +
        2*b**20*c**5*s**2 - 6*a**12*b**7*c**6*s**2 -
        25*a**11*b**8*c**6*s**2 - 61*a**10*b**9*c**6*s**2 -
        13*a**9*b**10*c**6*s**2 + 122*a**7*b**12*c**6*s**2 +
        8*a**6*b**13*c**6*s**2 + 46*a**5*b**14*c**6*s**2 -
        149*a**4*b**15*c**6*s**2 - 96*a**3*b**16*c**6*s**2 -
        85*a**2*b**17*c**6*s**2 - 12*a*b**18*c**6*s**2 -
        3*b**19*c**6*s**2 - 6*a**12*b**6*c**7*s**2 -
        51*a**11*b**7*c**7*s**2 - 137*a**10*b**8*c**7*s**2 -
        202*a**9*b**9*c**7*s**2 - 74*a**8*b**10*c**7*s**2 -
        18*a**7*b**11*c**7*s**2 + 122*a**6*b**12*c**7*s**2 +
        19*a**5*b**13*c**7*s**2 + 55*a**4*b**14*c**7*s**2 -
        44*a**3*b**15*c**7*s**2 - 10*a**2*b**16*c**7*s**2 -
        12*a*b**17*c**7*s**2 - 30*a**11*b**6*c**8*s**2 -
        150*a**10*b**7*c**8*s**2 - 286*a**9*b**8*c**8*s**2 -
        292*a**8*b**9*c**8*s**2 - 74*a**7*b**10*c**8*s**2 +
        98*a**5*b**12*c**8*s**2 + 23*a**4*b**13*c**8*s**2 +
        35*a**3*b**14*c**8*s**2 - 3*a**2*b**15*c**8*s**2 +
        3*a*b**16*c**8*s**2 - 60*a**10*b**6*c**9*s**2 -
        210*a**9*b**7*c**9*s**2 - 286*a**8*b**8*c**9*s**2 -
        202*a**7*b**9*c**9*s**2 - 13*a**6*b**10*c**9*s**2 +
        16*a**5*b**11*c**9*s**2 + 47*a**4*b**12*c**9*s**2 +
        8*a**3*b**13*c**9*s**2 + 8*a**2*b**14*c**9*s**2 -
        60*a**9*b**6*c**10*s**2 - 150*a**8*b**7*c**10*s**2 -
        137*a**7*b**8*c**10*s**2 - 61*a**6*b**9*c**10*s**2 +
        14*a**5*b**10*c**10*s**2 + 7*a**4*b**11*c**10*s**2 +
        9*a**3*b**12*c**10*s**2 - 30*a**8*b**6*c**11*s**2 -
        51*a**7*b**7*c**11*s**2 - 25*a**6*b**8*c**11*s**2 -
        5*a**5*b**9*c**11*s**2 + 5*a**4*b**10*c**11*s**2 -
        6*a**7*b**6*c**12*s**2 - 6*a**6*b**7*c**12*s**2)/(a**7*b**19*s
        - 3*a**6*b**20*s + 5*a**5*b**21*s - 6*a**4*b**22*s +
        5*a**3*b**23*s - 3*a**2*b**24*s + a*b**25*s - a**9*b**16*c*s +
        5*a**8*b**17*c*s - 13*a**7*b**18*c*s + 23*a**6*b**19*c*s -
        30*a**5*b**20*c*s + 30*a**4*b**21*c*s - 23*a**3*b**22*c*s +
        13*a**2*b**23*c*s - 5*a*b**24*c*s + b**25*c*s -
        2*a**10*b**14*c**2*s + 10*a**9*b**15*c**2*s -
        28*a**8*b**16*c**2*s + 54*a**7*b**17*c**2*s -
        79*a**6*b**18*c**2*s + 91*a**5*b**19*c**2*s -
        83*a**4*b**20*c**2*s + 60*a**3*b**21*c**2*s -
        33*a**2*b**22*c**2*s + 13*a*b**23*c**2*s - 3*b**24*c**2*s -
        2*a**11*b**12*c**3*s + 12*a**10*b**13*c**3*s -
        38*a**9*b**14*c**3*s + 83*a**8*b**15*c**3*s -
        137*a**7*b**16*c**3*s + 180*a**6*b**17*c**3*s -
        191*a**5*b**18*c**3*s + 164*a**4*b**19*c**3*s -
        113*a**3*b**20*c**3*s + 60*a**2*b**21*c**3*s -
        23*a*b**22*c**3*s + 5*b**23*c**3*s - a**12*b**10*c**4*s +
        9*a**11*b**11*c**4*s - 35*a**10*b**12*c**4*s +
        89*a**9*b**13*c**4*s - 169*a**8*b**14*c**4*s +
        253*a**7*b**15*c**4*s - 308*a**6*b**16*c**4*s +
        307*a**5*b**17*c**4*s - 250*a**4*b**18*c**4*s +
        164*a**3*b**19*c**4*s - 83*a**2*b**20*c**4*s +
        30*a*b**21*c**4*s - 6*b**22*c**4*s + 4*a**12*b**9*c**5*s -
        22*a**11*b**10*c**5*s + 68*a**10*b**11*c**5*s -
        151*a**9*b**12*c**5*s + 260*a**8*b**13*c**5*s -
        363*a**7*b**14*c**5*s + 417*a**6*b**15*c**5*s -
        395*a**5*b**16*c**5*s + 307*a**4*b**17*c**5*s -
        191*a**3*b**18*c**5*s + 91*a**2*b**19*c**5*s -
        30*a*b**20*c**5*s + 5*b**21*c**5*s + a**13*b**7*c**6*s -
        9*a**12*b**8*c**6*s + 36*a**11*b**9*c**6*s -
        96*a**10*b**10*c**6*s + 195*a**9*b**11*c**6*s -
        316*a**8*b**12*c**6*s + 420*a**7*b**13*c**6*s -
        461*a**6*b**14*c**6*s + 417*a**5*b**15*c**6*s -
        308*a**4*b**16*c**6*s + 180*a**3*b**17*c**6*s -
        79*a**2*b**18*c**6*s + 23*a*b**19*c**6*s - 3*b**20*c**6*s -
        2*a**13*b**6*c**7*s + 12*a**12*b**7*c**7*s -
        41*a**11*b**8*c**7*s + 102*a**10*b**9*c**7*s -
        198*a**9*b**10*c**7*s + 310*a**8*b**11*c**7*s -
        398*a**7*b**12*c**7*s + 420*a**6*b**13*c**7*s -
        363*a**5*b**14*c**7*s + 253*a**4*b**15*c**7*s -
        137*a**3*b**16*c**7*s + 54*a**2*b**17*c**7*s -
        13*a*b**18*c**7*s + b**19*c**7*s + 2*a**13*b**5*c**8*s -
        10*a**12*b**6*c**8*s + 33*a**11*b**7*c**8*s -
        82*a**10*b**8*c**8*s + 159*a**9*b**9*c**8*s -
        247*a**8*b**10*c**8*s + 310*a**7*b**11*c**8*s -
        316*a**6*b**12*c**8*s + 260*a**5*b**13*c**8*s -
        169*a**4*b**14*c**8*s + 83*a**3*b**15*c**8*s -
        28*a**2*b**16*c**8*s + 5*a*b**17*c**8*s - a**13*b**4*c**9*s +
        4*a**12*b**5*c**9*s - 16*a**11*b**6*c**9*s +
        47*a**10*b**7*c**9*s - 99*a**9*b**8*c**9*s +
        159*a**8*b**9*c**9*s - 198*a**7*b**10*c**9*s +
        195*a**6*b**11*c**9*s - 151*a**5*b**12*c**9*s +
        89*a**4*b**13*c**9*s - 38*a**3*b**14*c**9*s +
        10*a**2*b**15*c**9*s - a*b**16*c**9*s - a**13*b**3*c**10*s +
        3*a**12*b**4*c**10*s - 16*a**10*b**6*c**10*s +
        47*a**9*b**7*c**10*s - 82*a**8*b**8*c**10*s +
        102*a**7*b**9*c**10*s - 96*a**6*b**10*c**10*s +
        68*a**5*b**11*c**10*s - 35*a**4*b**12*c**10*s +
        12*a**3*b**13*c**10*s - 2*a**2*b**14*c**10*s +
        2*a**13*b**2*c**11*s - 6*a**12*b**3*c**11*s +
        7*a**11*b**4*c**11*s - 16*a**9*b**6*c**11*s +
        33*a**8*b**7*c**11*s - 41*a**7*b**8*c**11*s +
        36*a**6*b**9*c**11*s - 22*a**5*b**10*c**11*s +
        9*a**4*b**11*c**11*s - 2*a**3*b**12*c**11*s -
        2*a**13*b*c**12*s + 5*a**12*b**2*c**12*s -
        6*a**11*b**3*c**12*s + 3*a**10*b**4*c**12*s +
        4*a**9*b**5*c**12*s - 10*a**8*b**6*c**12*s +
        12*a**7*b**7*c**12*s - 9*a**6*b**8*c**12*s +
        4*a**5*b**9*c**12*s - a**4*b**10*c**12*s + a**13*c**13*s -
        2*a**12*b*c**13*s + 2*a**11*b**2*c**13*s - a**10*b**3*c**13*s
        - a**9*b**4*c**13*s + 2*a**8*b**5*c**13*s -
        2*a**7*b**6*c**13*s + a**6*b**7*c**13*s), (-a**11*b**4*c**2 -
        5*a**10*b**5*c**2 - 4*a**9*b**6*c**2 + a**8*b**7*c**2 +
        a**7*b**8*c**2 - 2*a**11*b**3*c**3 - 22*a**10*b**4*c**3 -
        42*a**9*b**5*c**3 - 18*a**8*b**6*c**3 + 11*a**7*b**7*c**3 +
        7*a**6*b**8*c**3 - a**11*b**2*c**4 - 22*a**10*b**3*c**4 -
        82*a**9*b**4*c**4 - 98*a**8*b**5*c**4 - 24*a**7*b**6*c**4 +
        21*a**6*b**7*c**4 + 8*a**5*b**8*c**4 - 5*a**10*b**2*c**5 -
        42*a**9*b**3*c**5 - 98*a**8*b**4*c**5 - 86*a**7*b**5*c**5 -
        36*a**6*b**6*c**5 - 25*a**5*b**7*c**5 - 14*a**4*b**8*c**5 -
        4*a**9*b**2*c**6 - 18*a**8*b**3*c**6 - 24*a**7*b**4*c**6 -
        36*a**6*b**5*c**6 - 90*a**5*b**6*c**6 - 99*a**4*b**7*c**6 -
        35*a**3*b**8*c**6 + a**8*b**2*c**7 + 11*a**7*b**3*c**7 +
        21*a**6*b**4*c**7 - 25*a**5*b**5*c**7 - 99*a**4*b**6*c**7 -
        88*a**3*b**7*c**7 - 25*a**2*b**8*c**7 + a**7*b**2*c**8 +
        7*a**6*b**3*c**8 + 8*a**5*b**4*c**8 - 14*a**4*b**5*c**8 -
        35*a**3*b**6*c**8 - 25*a**2*b**7*c**8 - 6*a*b**8*c**8 -
        6*a**10*b**3*c**2*s**2 - 19*a**9*b**4*c**2*s**2 -
        16*a**8*b**5*c**2*s**2 + 2*a**7*b**6*c**2*s**2 +
        6*a**6*b**7*c**2*s**2 + a**5*b**8*c**2*s**2 -
        6*a**10*b**2*c**3*s**2 - 44*a**9*b**3*c**3*s**2 -
        85*a**8*b**4*c**3*s**2 - 47*a**7*b**5*c**3*s**2 +
        14*a**6*b**6*c**3*s**2 + 16*a**5*b**7*c**3*s**2 +
        2*a**4*b**8*c**3*s**2 - 19*a**9*b**2*c**4*s**2 -
        85*a**8*b**3*c**4*s**2 - 116*a**7*b**4*c**4*s**2 -
        51*a**6*b**5*c**4*s**2 - 2*a**5*b**6*c**4*s**2 -
        3*a**4*b**7*c**4*s**2 - 2*a**3*b**8*c**4*s**2 -
        16*a**8*b**2*c**5*s**2 - 47*a**7*b**3*c**5*s**2 -
        51*a**6*b**4*c**5*s**2 - 58*a**5*b**5*c**5*s**2 -
        77*a**4*b**6*c**5*s**2 - 47*a**3*b**7*c**5*s**2 -
        8*a**2*b**8*c**5*s**2 + 2*a**7*b**2*c**6*s**2 +
        14*a**6*b**3*c**6*s**2 - 2*a**5*b**4*c**6*s**2 -
        77*a**4*b**5*c**6*s**2 - 108*a**3*b**6*c**6*s**2 -
        51*a**2*b**7*c**6*s**2 - 6*a*b**8*c**6*s**2 +
        6*a**6*b**2*c**7*s**2 + 16*a**5*b**3*c**7*s**2 -
        3*a**4*b**4*c**7*s**2 - 47*a**3*b**5*c**7*s**2 -
        51*a**2*b**6*c**7*s**2 - 18*a*b**7*c**7*s**2 - b**8*c**7*s**2
        + a**5*b**2*c**8*s**2 + 2*a**4*b**3*c**8*s**2 -
        2*a**3*b**4*c**8*s**2 - 8*a**2*b**5*c**8*s**2 -
        6*a*b**6*c**8*s**2 - b**7*c**8*s**2)/(a**11*b**5*s -
        2*a**10*b**6*s + a**9*b**7*s - 2*a**11*b**4*c*s +
        3*a**10*b**5*c*s + 2*a**9*b**6*c*s - 5*a**8*b**7*c*s +
        2*a**7*b**8*c*s + a**11*b**3*c**2*s - a**10*b**4*c**2*s -
        6*a**9*b**5*c**2*s + 9*a**8*b**6*c**2*s + a**7*b**7*c**2*s -
        6*a**6*b**8*c**2*s + 2*a**5*b**9*c**2*s + a**11*b**2*c**3*s +
        3*a**9*b**4*c**3*s - 7*a**8*b**5*c**3*s - 6*a**7*b**6*c**3*s +
        13*a**6*b**7*c**3*s - a**5*b**8*c**3*s - 4*a**4*b**9*c**3*s +
        a**3*b**10*c**3*s - 2*a**11*b*c**4*s - a**10*b**2*c**4*s +
        3*a**9*b**3*c**4*s + 6*a**8*b**4*c**4*s + 3*a**7*b**5*c**4*s -
        15*a**6*b**6*c**4*s - 2*a**5*b**7*c**4*s + 11*a**4*b**8*c**4*s
        - 2*a**3*b**9*c**4*s - a**2*b**10*c**4*s + a**11*c**5*s +
        3*a**10*b*c**5*s - 6*a**9*b**2*c**5*s - 7*a**8*b**3*c**5*s +
        3*a**7*b**4*c**5*s + 16*a**6*b**5*c**5*s + a**5*b**6*c**5*s -
        17*a**4*b**7*c**5*s + 2*a**3*b**8*c**5*s + 5*a**2*b**9*c**5*s
        - a*b**10*c**5*s - 2*a**10*c**6*s + 2*a**9*b*c**6*s +
        9*a**8*b**2*c**6*s - 6*a**7*b**3*c**6*s - 15*a**6*b**4*c**6*s
        + a**5*b**5*c**6*s + 20*a**4*b**6*c**6*s - a**3*b**7*c**6*s -
        11*a**2*b**8*c**6*s + 2*a*b**9*c**6*s + b**10*c**6*s +
        a**9*c**7*s - 5*a**8*b*c**7*s + a**7*b**2*c**7*s +
        13*a**6*b**3*c**7*s - 2*a**5*b**4*c**7*s - 17*a**4*b**5*c**7*s
        - a**3*b**6*c**7*s + 14*a**2*b**7*c**7*s - a*b**8*c**7*s -
        3*b**9*c**7*s + 2*a**7*b*c**8*s - 6*a**6*b**2*c**8*s -
        a**5*b**3*c**8*s + 11*a**4*b**4*c**8*s + 2*a**3*b**5*c**8*s -
        11*a**2*b**6*c**8*s - a*b**7*c**8*s + 4*b**8*c**8*s +
        2*a**5*b**2*c**9*s - 4*a**4*b**3*c**9*s - 2*a**3*b**4*c**9*s +
        5*a**2*b**5*c**9*s + 2*a*b**6*c**9*s - 3*b**7*c**9*s +
        a**3*b**3*c**10*s - a**2*b**4*c**10*s - a*b**5*c**10*s +
        b**6*c**10*s), (-6*a**8*b**8*c - 25*a**8*b**7*c**2 -
        25*a**7*b**8*c**2 - 35*a**8*b**6*c**3 - 88*a**7*b**7*c**3 -
        35*a**6*b**8*c**3 - 14*a**8*b**5*c**4 - 99*a**7*b**6*c**4 -
        99*a**6*b**7*c**4 - 14*a**5*b**8*c**4 + 8*a**8*b**4*c**5 -
        25*a**7*b**5*c**5 - 90*a**6*b**6*c**5 - 25*a**5*b**7*c**5 +
        8*a**4*b**8*c**5 + 7*a**8*b**3*c**6 + 21*a**7*b**4*c**6 -
        36*a**6*b**5*c**6 - 36*a**5*b**6*c**6 + 21*a**4*b**7*c**6 +
        7*a**3*b**8*c**6 + a**8*b**2*c**7 + 11*a**7*b**3*c**7 -
        24*a**6*b**4*c**7 - 86*a**5*b**5*c**7 - 24*a**4*b**6*c**7 +
        11*a**3*b**7*c**7 + a**2*b**8*c**7 + a**7*b**2*c**8 -
        18*a**6*b**3*c**8 - 98*a**5*b**4*c**8 - 98*a**4*b**5*c**8 -
        18*a**3*b**6*c**8 + a**2*b**7*c**8 - 4*a**6*b**2*c**9 -
        42*a**5*b**3*c**9 - 82*a**4*b**4*c**9 - 42*a**3*b**5*c**9 -
        4*a**2*b**6*c**9 - 5*a**5*b**2*c**10 - 22*a**4*b**3*c**10 -
        22*a**3*b**4*c**10 - 5*a**2*b**5*c**10 - a**4*b**2*c**11 -
        2*a**3*b**3*c**11 - a**2*b**4*c**11 - a**8*b**7*s**2 -
        a**7*b**8*s**2 - 6*a**8*b**6*c*s**2 - 18*a**7*b**7*c*s**2 -
        6*a**6*b**8*c*s**2 - 8*a**8*b**5*c**2*s**2 -
        51*a**7*b**6*c**2*s**2 - 51*a**6*b**7*c**2*s**2 -
        8*a**5*b**8*c**2*s**2 - 2*a**8*b**4*c**3*s**2 -
        47*a**7*b**5*c**3*s**2 - 108*a**6*b**6*c**3*s**2 -
        47*a**5*b**7*c**3*s**2 - 2*a**4*b**8*c**3*s**2 +
        2*a**8*b**3*c**4*s**2 - 3*a**7*b**4*c**4*s**2 -
        77*a**6*b**5*c**4*s**2 - 77*a**5*b**6*c**4*s**2 -
        3*a**4*b**7*c**4*s**2 + 2*a**3*b**8*c**4*s**2 +
        a**8*b**2*c**5*s**2 + 16*a**7*b**3*c**5*s**2 -
        2*a**6*b**4*c**5*s**2 - 58*a**5*b**5*c**5*s**2 -
        2*a**4*b**6*c**5*s**2 + 16*a**3*b**7*c**5*s**2 +
        a**2*b**8*c**5*s**2 + 6*a**7*b**2*c**6*s**2 +
        14*a**6*b**3*c**6*s**2 - 51*a**5*b**4*c**6*s**2 -
        51*a**4*b**5*c**6*s**2 + 14*a**3*b**6*c**6*s**2 +
        6*a**2*b**7*c**6*s**2 + 2*a**6*b**2*c**7*s**2 -
        47*a**5*b**3*c**7*s**2 - 116*a**4*b**4*c**7*s**2 -
        47*a**3*b**5*c**7*s**2 + 2*a**2*b**6*c**7*s**2 -
        16*a**5*b**2*c**8*s**2 - 85*a**4*b**3*c**8*s**2 -
        85*a**3*b**4*c**8*s**2 - 16*a**2*b**5*c**8*s**2 -
        19*a**4*b**2*c**9*s**2 - 44*a**3*b**3*c**9*s**2 -
        19*a**2*b**4*c**9*s**2 - 6*a**3*b**2*c**10*s**2 -
        6*a**2*b**3*c**10*s**2)/(a**10*b**6*s - 3*a**9*b**7*s +
        4*a**8*b**8*s - 3*a**7*b**9*s + a**6*b**10*s - a**10*b**5*c*s
        + 2*a**9*b**6*c*s - a**8*b**7*c*s - a**7*b**8*c*s +
        2*a**6*b**9*c*s - a**5*b**10*c*s - a**10*b**4*c**2*s +
        5*a**9*b**5*c**2*s - 11*a**8*b**6*c**2*s + 14*a**7*b**7*c**2*s
        - 11*a**6*b**8*c**2*s + 5*a**5*b**9*c**2*s - a**4*b**10*c**2*s
        + a**10*b**3*c**3*s - 2*a**9*b**4*c**3*s + 2*a**8*b**5*c**3*s
        - a**7*b**6*c**3*s - a**6*b**7*c**3*s + 2*a**5*b**8*c**3*s -
        2*a**4*b**9*c**3*s + a**3*b**10*c**3*s - 4*a**9*b**3*c**4*s +
        11*a**8*b**4*c**4*s - 17*a**7*b**5*c**4*s +
        20*a**6*b**6*c**4*s - 17*a**5*b**7*c**4*s +
        11*a**4*b**8*c**4*s - 4*a**3*b**9*c**4*s + 2*a**9*b**2*c**5*s
        - a**8*b**3*c**5*s - 2*a**7*b**4*c**5*s + a**6*b**5*c**5*s +
        a**5*b**6*c**5*s - 2*a**4*b**7*c**5*s - a**3*b**8*c**5*s +
        2*a**2*b**9*c**5*s - 6*a**8*b**2*c**6*s + 13*a**7*b**3*c**6*s
        - 15*a**6*b**4*c**6*s + 16*a**5*b**5*c**6*s -
        15*a**4*b**6*c**6*s + 13*a**3*b**7*c**6*s - 6*a**2*b**8*c**6*s
        + 2*a**8*b*c**7*s + a**7*b**2*c**7*s - 6*a**6*b**3*c**7*s +
        3*a**5*b**4*c**7*s + 3*a**4*b**5*c**7*s - 6*a**3*b**6*c**7*s +
        a**2*b**7*c**7*s + 2*a*b**8*c**7*s - 5*a**7*b*c**8*s +
        9*a**6*b**2*c**8*s - 7*a**5*b**3*c**8*s + 6*a**4*b**4*c**8*s -
        7*a**3*b**5*c**8*s + 9*a**2*b**6*c**8*s - 5*a*b**7*c**8*s +
        a**7*c**9*s + 2*a**6*b*c**9*s - 6*a**5*b**2*c**9*s +
        3*a**4*b**3*c**9*s + 3*a**3*b**4*c**9*s - 6*a**2*b**5*c**9*s +
        2*a*b**6*c**9*s + b**7*c**9*s - 2*a**6*c**10*s +
        3*a**5*b*c**10*s - a**4*b**2*c**10*s - a**2*b**4*c**10*s +
        3*a*b**5*c**10*s - 2*b**6*c**10*s + a**5*c**11*s -
        2*a**4*b*c**11*s + a**3*b**2*c**11*s + a**2*b**3*c**11*s -
        2*a*b**4*c**11*s + b**5*c**11*s), (a**8*b**7*c**2 +
        a**7*b**8*c**2 - 4*a**6*b**9*c**2 - 5*a**5*b**10*c**2 -
        a**4*b**11*c**2 + 7*a**8*b**6*c**3 + 11*a**7*b**7*c**3 -
        18*a**6*b**8*c**3 - 42*a**5*b**9*c**3 - 22*a**4*b**10*c**3 -
        2*a**3*b**11*c**3 + 8*a**8*b**5*c**4 + 21*a**7*b**6*c**4 -
        24*a**6*b**7*c**4 - 98*a**5*b**8*c**4 - 82*a**4*b**9*c**4 -
        22*a**3*b**10*c**4 - a**2*b**11*c**4 - 14*a**8*b**4*c**5 -
        25*a**7*b**5*c**5 - 36*a**6*b**6*c**5 - 86*a**5*b**7*c**5 -
        98*a**4*b**8*c**5 - 42*a**3*b**9*c**5 - 5*a**2*b**10*c**5 -
        35*a**8*b**3*c**6 - 99*a**7*b**4*c**6 - 90*a**6*b**5*c**6 -
        36*a**5*b**6*c**6 - 24*a**4*b**7*c**6 - 18*a**3*b**8*c**6 -
        4*a**2*b**9*c**6 - 25*a**8*b**2*c**7 - 88*a**7*b**3*c**7 -
        99*a**6*b**4*c**7 - 25*a**5*b**5*c**7 + 21*a**4*b**6*c**7 +
        11*a**3*b**7*c**7 + a**2*b**8*c**7 - 6*a**8*b*c**8 -
        25*a**7*b**2*c**8 - 35*a**6*b**3*c**8 - 14*a**5*b**4*c**8 +
        8*a**4*b**5*c**8 + 7*a**3*b**6*c**8 + a**2*b**7*c**8 +
        a**8*b**5*c**2*s**2 + 6*a**7*b**6*c**2*s**2 +
        2*a**6*b**7*c**2*s**2 - 16*a**5*b**8*c**2*s**2 -
        19*a**4*b**9*c**2*s**2 - 6*a**3*b**10*c**2*s**2 +
        2*a**8*b**4*c**3*s**2 + 16*a**7*b**5*c**3*s**2 +
        14*a**6*b**6*c**3*s**2 - 47*a**5*b**7*c**3*s**2 -
        85*a**4*b**8*c**3*s**2 - 44*a**3*b**9*c**3*s**2 -
        6*a**2*b**10*c**3*s**2 - 2*a**8*b**3*c**4*s**2 -
        3*a**7*b**4*c**4*s**2 - 2*a**6*b**5*c**4*s**2 -
        51*a**5*b**6*c**4*s**2 - 116*a**4*b**7*c**4*s**2 -
        85*a**3*b**8*c**4*s**2 - 19*a**2*b**9*c**4*s**2 -
        8*a**8*b**2*c**5*s**2 - 47*a**7*b**3*c**5*s**2 -
        77*a**6*b**4*c**5*s**2 - 58*a**5*b**5*c**5*s**2 -
        51*a**4*b**6*c**5*s**2 - 47*a**3*b**7*c**5*s**2 -
        16*a**2*b**8*c**5*s**2 - 6*a**8*b*c**6*s**2 -
        51*a**7*b**2*c**6*s**2 - 108*a**6*b**3*c**6*s**2 -
        77*a**5*b**4*c**6*s**2 - 2*a**4*b**5*c**6*s**2 +
        14*a**3*b**6*c**6*s**2 + 2*a**2*b**7*c**6*s**2 -
        a**8*c**7*s**2 - 18*a**7*b*c**7*s**2 - 51*a**6*b**2*c**7*s**2
        - 47*a**5*b**3*c**7*s**2 - 3*a**4*b**4*c**7*s**2 +
        16*a**3*b**5*c**7*s**2 + 6*a**2*b**6*c**7*s**2 -
        a**7*c**8*s**2 - 6*a**6*b*c**8*s**2 - 8*a**5*b**2*c**8*s**2 -
        2*a**4*b**3*c**8*s**2 + 2*a**3*b**4*c**8*s**2 +
        a**2*b**5*c**8*s**2)/(a**7*b**9*s - 2*a**6*b**10*s +
        a**5*b**11*s + 2*a**8*b**7*c*s - 5*a**7*b**8*c*s +
        2*a**6*b**9*c*s + 3*a**5*b**10*c*s - 2*a**4*b**11*c*s +
        2*a**9*b**5*c**2*s - 6*a**8*b**6*c**2*s + a**7*b**7*c**2*s +
        9*a**6*b**8*c**2*s - 6*a**5*b**9*c**2*s - a**4*b**10*c**2*s +
        a**3*b**11*c**2*s + a**10*b**3*c**3*s - 4*a**9*b**4*c**3*s -
        a**8*b**5*c**3*s + 13*a**7*b**6*c**3*s - 6*a**6*b**7*c**3*s -
        7*a**5*b**8*c**3*s + 3*a**4*b**9*c**3*s + a**2*b**11*c**3*s -
        a**10*b**2*c**4*s - 2*a**9*b**3*c**4*s + 11*a**8*b**4*c**4*s -
        2*a**7*b**5*c**4*s - 15*a**6*b**6*c**4*s + 3*a**5*b**7*c**4*s
        + 6*a**4*b**8*c**4*s + 3*a**3*b**9*c**4*s - a**2*b**10*c**4*s
        - 2*a*b**11*c**4*s - a**10*b*c**5*s + 5*a**9*b**2*c**5*s +
        2*a**8*b**3*c**5*s - 17*a**7*b**4*c**5*s + a**6*b**5*c**5*s +
        16*a**5*b**6*c**5*s + 3*a**4*b**7*c**5*s - 7*a**3*b**8*c**5*s
        - 6*a**2*b**9*c**5*s + 3*a*b**10*c**5*s + b**11*c**5*s +
        a**10*c**6*s + 2*a**9*b*c**6*s - 11*a**8*b**2*c**6*s -
        a**7*b**3*c**6*s + 20*a**6*b**4*c**6*s + a**5*b**5*c**6*s -
        15*a**4*b**6*c**6*s - 6*a**3*b**7*c**6*s + 9*a**2*b**8*c**6*s
        + 2*a*b**9*c**6*s - 2*b**10*c**6*s - 3*a**9*c**7*s -
        a**8*b*c**7*s + 14*a**7*b**2*c**7*s - a**6*b**3*c**7*s -
        17*a**5*b**4*c**7*s - 2*a**4*b**5*c**7*s + 13*a**3*b**6*c**7*s
        + a**2*b**7*c**7*s - 5*a*b**8*c**7*s + b**9*c**7*s +
        4*a**8*c**8*s - a**7*b*c**8*s - 11*a**6*b**2*c**8*s +
        2*a**5*b**3*c**8*s + 11*a**4*b**4*c**8*s - a**3*b**5*c**8*s -
        6*a**2*b**6*c**8*s + 2*a*b**7*c**8*s - 3*a**7*c**9*s +
        2*a**6*b*c**9*s + 5*a**5*b**2*c**9*s - 2*a**4*b**3*c**9*s -
        4*a**3*b**4*c**9*s + 2*a**2*b**5*c**9*s + a**6*c**10*s -
        a**5*b*c**10*s - a**4*b**2*c**10*s + a**3*b**3*c**10*s),
        (a**8*b**6*c + 2*a**7*b**7*c + a**6*b**8*c + 8*a**8*b**5*c**2
        + 28*a**7*b**6*c**2 + 28*a**6*b**7*c**2 + 8*a**5*b**8*c**2 +
        19*a**8*b**4*c**3 + 101*a**7*b**5*c**3 + 164*a**6*b**6*c**3 +
        101*a**5*b**7*c**3 + 19*a**4*b**8*c**3 + 19*a**8*b**3*c**4 +
        150*a**7*b**4*c**4 + 363*a**6*b**5*c**4 + 363*a**5*b**6*c**4 +
        150*a**4*b**7*c**4 + 19*a**3*b**8*c**4 + 8*a**8*b**2*c**5 +
        101*a**7*b**3*c**5 + 363*a**6*b**4*c**5 + 540*a**5*b**5*c**5 +
        363*a**4*b**6*c**5 + 101*a**3*b**7*c**5 + 8*a**2*b**8*c**5 +
        a**8*b*c**6 + 28*a**7*b**2*c**6 + 164*a**6*b**3*c**6 +
        363*a**5*b**4*c**6 + 363*a**4*b**5*c**6 + 164*a**3*b**6*c**6 +
        28*a**2*b**7*c**6 + a*b**8*c**6 + 2*a**7*b*c**7 +
        28*a**6*b**2*c**7 + 101*a**5*b**3*c**7 + 150*a**4*b**4*c**7 +
        101*a**3*b**5*c**7 + 28*a**2*b**6*c**7 + 2*a*b**7*c**7 +
        a**6*b*c**8 + 8*a**5*b**2*c**8 + 19*a**4*b**3*c**8 +
        19*a**3*b**4*c**8 + 8*a**2*b**5*c**8 + a*b**6*c**8 +
        a**8*b**4*c*s**2 + 7*a**7*b**5*c*s**2 + 12*a**6*b**6*c*s**2 +
        7*a**5*b**7*c*s**2 + a**4*b**8*c*s**2 + 3*a**8*b**3*c**2*s**2
        + 32*a**7*b**4*c**2*s**2 + 85*a**6*b**5*c**2*s**2 +
        85*a**5*b**6*c**2*s**2 + 32*a**4*b**7*c**2*s**2 +
        3*a**3*b**8*c**2*s**2 + 3*a**8*b**2*c**3*s**2 +
        50*a**7*b**3*c**3*s**2 + 199*a**6*b**4*c**3*s**2 +
        304*a**5*b**5*c**3*s**2 + 199*a**4*b**6*c**3*s**2 +
        50*a**3*b**7*c**3*s**2 + 3*a**2*b**8*c**3*s**2 +
        a**8*b*c**4*s**2 + 32*a**7*b**2*c**4*s**2 +
        199*a**6*b**3*c**4*s**2 + 452*a**5*b**4*c**4*s**2 +
        452*a**4*b**5*c**4*s**2 + 199*a**3*b**6*c**4*s**2 +
        32*a**2*b**7*c**4*s**2 + a*b**8*c**4*s**2 + 7*a**7*b*c**5*s**2
        + 85*a**6*b**2*c**5*s**2 + 304*a**5*b**3*c**5*s**2 +
        452*a**4*b**4*c**5*s**2 + 304*a**3*b**5*c**5*s**2 +
        85*a**2*b**6*c**5*s**2 + 7*a*b**7*c**5*s**2 +
        12*a**6*b*c**6*s**2 + 85*a**5*b**2*c**6*s**2 +
        199*a**4*b**3*c**6*s**2 + 199*a**3*b**4*c**6*s**2 +
        85*a**2*b**5*c**6*s**2 + 12*a*b**6*c**6*s**2 +
        7*a**5*b*c**7*s**2 + 32*a**4*b**2*c**7*s**2 +
        50*a**3*b**3*c**7*s**2 + 32*a**2*b**4*c**7*s**2 +
        7*a*b**5*c**7*s**2 + a**4*b*c**8*s**2 + 3*a**3*b**2*c**8*s**2
        + 3*a**2*b**3*c**8*s**2 + a*b**4*c**8*s**2)/(a**8*b**6*s -
        2*a**7*b**7*s + a**6*b**8*s + a**9*b**4*c*s - 3*a**8*b**5*c*s
        + 2*a**7*b**6*c*s + 2*a**6*b**7*c*s - 3*a**5*b**8*c*s +
        a**4*b**9*c*s - a**9*b**3*c**2*s + 5*a**7*b**5*c**2*s -
        8*a**6*b**6*c**2*s + 5*a**5*b**7*c**2*s - a**3*b**9*c**2*s -
        a**9*b**2*c**3*s + 4*a**8*b**3*c**3*s - 5*a**7*b**4*c**3*s +
        2*a**6*b**5*c**3*s + 2*a**5*b**6*c**3*s - 5*a**4*b**7*c**3*s +
        4*a**3*b**8*c**3*s - a**2*b**9*c**3*s + a**9*b*c**4*s -
        5*a**7*b**3*c**4*s + 6*a**6*b**4*c**4*s - 4*a**5*b**5*c**4*s +
        6*a**4*b**6*c**4*s - 5*a**3*b**7*c**4*s + a*b**9*c**4*s -
        3*a**8*b*c**5*s + 5*a**7*b**2*c**5*s + 2*a**6*b**3*c**5*s -
        4*a**5*b**4*c**5*s - 4*a**4*b**5*c**5*s + 2*a**3*b**6*c**5*s +
        5*a**2*b**7*c**5*s - 3*a*b**8*c**5*s + a**8*c**6*s +
        2*a**7*b*c**6*s - 8*a**6*b**2*c**6*s + 2*a**5*b**3*c**6*s +
        6*a**4*b**4*c**6*s + 2*a**3*b**5*c**6*s - 8*a**2*b**6*c**6*s +
        2*a*b**7*c**6*s + b**8*c**6*s - 2*a**7*c**7*s +
        2*a**6*b*c**7*s + 5*a**5*b**2*c**7*s - 5*a**4*b**3*c**7*s -
        5*a**3*b**4*c**7*s + 5*a**2*b**5*c**7*s + 2*a*b**6*c**7*s -
        2*b**7*c**7*s + a**6*c**8*s - 3*a**5*b*c**8*s +
        4*a**3*b**3*c**8*s - 3*a*b**5*c**8*s + b**6*c**8*s +
        a**4*b*c**9*s - a**3*b**2*c**9*s - a**2*b**3*c**9*s +
        a*b**4*c**9*s), (6*a**7*b**11*c + 5*a**8*b**9*c**2 +
        20*a**7*b**10*c**2 + 31*a**6*b**11*c**2 + 11*a**8*b**8*c**3 +
        45*a**7*b**9*c**3 + 87*a**6*b**10*c**3 + 65*a**5*b**11*c**3 +
        2*a**8*b**7*c**4 + 50*a**7*b**8*c**4 + 114*a**6*b**9*c**4 +
        148*a**5*b**10*c**4 + 70*a**4*b**11*c**4 - 5*a**8*b**6*c**5 +
        2*a**7*b**7*c**5 + 75*a**6*b**8*c**5 + 116*a**5*b**9*c**5 +
        122*a**4*b**10*c**5 + 40*a**3*b**11*c**5 + 5*a**8*b**5*c**6 -
        5*a**7*b**6*c**6 + 4*a**6*b**7*c**6 + 39*a**5*b**8*c**6 +
        38*a**4*b**9*c**6 + 48*a**3*b**10*c**6 + 11*a**2*b**11*c**6 +
        8*a**8*b**4*c**7 + 43*a**7*b**5*c**7 + 45*a**6*b**6*c**7 +
        34*a**5*b**7*c**7 - 12*a**3*b**9*c**7 + 7*a**2*b**10*c**7 +
        a*b**11*c**7 + 2*a**8*b**3*c**8 + 39*a**7*b**4*c**8 +
        120*a**6*b**5*c**8 + 121*a**5*b**6*c**8 + 67*a**4*b**7*c**8 -
        9*a**2*b**9*c**8 + 7*a**7*b**3*c**9 + 73*a**6*b**4*c**9 +
        151*a**5*b**5*c**9 + 119*a**4*b**6*c**9 + 51*a**3*b**7*c**9 +
        4*a**2*b**8*c**9 - a*b**9*c**9 - a**7*b**2*c**10 +
        9*a**6*b**3*c**10 + 64*a**5*b**4*c**10 + 90*a**4*b**5*c**10 +
        50*a**3*b**6*c**10 + 15*a**2*b**7*c**10 + a*b**8*c**10 -
        2*a**6*b**2*c**11 + 5*a**5*b**3*c**11 + 25*a**4*b**4*c**11 +
        22*a**3*b**5*c**11 + 7*a**2*b**6*c**11 + a*b**7*c**11 -
        a**5*b**2*c**12 + a**4*b**3*c**12 + 3*a**3*b**4*c**12 +
        a**2*b**5*c**12 + a**7*b**10*s**2 + 2*a**6*b**11*s**2 -
        a**5*b**12*s**2 + a**8*b**8*c*s**2 + 7*a**7*b**9*c*s**2 +
        18*a**6*b**10*c*s**2 + 9*a**5*b**11*c*s**2 -
        3*a**4*b**12*c*s**2 + 2*a**8*b**7*c**2*s**2 +
        19*a**7*b**8*c**2*s**2 + 49*a**6*b**9*c**2*s**2 +
        64*a**5*b**10*c**2*s**2 + 17*a**4*b**11*c**2*s**2 -
        3*a**3*b**12*c**2*s**2 + 17*a**7*b**7*c**3*s**2 +
        72*a**6*b**8*c**3*s**2 + 118*a**5*b**9*c**3*s**2 +
        101*a**4*b**10*c**3*s**2 + 17*a**3*b**11*c**3*s**2 -
        a**2*b**12*c**3*s**2 - a**8*b**5*c**4*s**2 -
        5*a**7*b**6*c**4*s**2 + 39*a**6*b**7*c**4*s**2 +
        106*a**5*b**8*c**4*s**2 + 131*a**4*b**9*c**4*s**2 +
        83*a**3*b**10*c**4*s**2 + 9*a**2*b**11*c**4*s**2 +
        a**8*b**4*c**5*s**2 - 2*a**7*b**5*c**5*s**2 -
        14*a**6*b**6*c**5*s**2 + 36*a**5*b**7*c**5*s**2 +
        58*a**4*b**8*c**5*s**2 + 68*a**3*b**9*c**5*s**2 +
        35*a**2*b**10*c**5*s**2 + 2*a*b**11*c**5*s**2 +
        a**8*b**3*c**6*s**2 + 17*a**7*b**4*c**6*s**2 +
        28*a**6*b**5*c**6*s**2 + 12*a**5*b**6*c**6*s**2 +
        21*a**4*b**7*c**6*s**2 - 7*a**3*b**8*c**6*s**2 +
        12*a**2*b**9*c**6*s**2 + 6*a*b**10*c**6*s**2 +
        10*a**7*b**3*c**7*s**2 + 72*a**6*b**4*c**7*s**2 +
        108*a**5*b**5*c**7*s**2 + 73*a**4*b**6*c**7*s**2 +
        23*a**3*b**7*c**7*s**2 - 17*a**2*b**8*c**7*s**2 -
        a*b**9*c**7*s**2 + 30*a**6*b**3*c**8*s**2 +
        130*a**5*b**4*c**8*s**2 + 148*a**4*b**5*c**8*s**2 +
        84*a**3*b**6*c**8*s**2 + 20*a**2*b**7*c**8*s**2 -
        4*a*b**8*c**8*s**2 + 40*a**5*b**3*c**9*s**2 +
        113*a**4*b**4*c**9*s**2 + 88*a**3*b**5*c**9*s**2 +
        37*a**2*b**6*c**9*s**2 + 6*a*b**7*c**9*s**2 +
        25*a**4*b**3*c**10*s**2 + 45*a**3*b**4*c**10*s**2 +
        19*a**2*b**5*c**10*s**2 + 5*a*b**6*c**10*s**2 +
        6*a**3*b**3*c**11*s**2 + 6*a**2*b**4*c**11*s**2)/(a**8*b**10*s
        - 2*a**7*b**11*s + 2*a**6*b**12*s - 2*a**5*b**13*s +
        a**4*b**14*s + a**9*b**8*c*s - 4*a**8*b**9*c*s +
        6*a**7*b**10*c*s - 6*a**6*b**11*c*s + 5*a**5*b**12*c*s -
        2*a**4*b**13*c*s - 2*a**9*b**7*c**2*s + 5*a**8*b**8*c**2*s -
        6*a**7*b**9*c**2*s + 5*a**6*b**10*c**2*s - 2*a**5*b**11*c**2*s
        - a**4*b**12*c**2*s + 2*a**3*b**13*c**2*s - a**2*b**14*c**2*s
        + a**9*b**6*c**3*s - a**8*b**7*c**3*s - a**7*b**8*c**3*s +
        5*a**6*b**9*c**3*s - 9*a**5*b**10*c**3*s + 9*a**4*b**11*c**3*s
        - 7*a**3*b**12*c**3*s + 3*a**2*b**13*c**3*s + a**9*b**5*c**4*s
        - 4*a**8*b**6*c**4*s + 8*a**7*b**7*c**4*s -
        15*a**6*b**8*c**4*s + 18*a**5*b**9*c**4*s -
        14*a**4*b**10*c**4*s + 10*a**3*b**11*c**4*s -
        3*a**2*b**12*c**4*s - a*b**13*c**4*s - 2*a**9*b**4*c**5*s +
        4*a**8*b**5*c**5*s - 6*a**7*b**6*c**5*s + 13*a**6*b**7*c**5*s
        - 12*a**5*b**8*c**5*s + 6*a**4*b**9*c**5*s -
        4*a**3*b**10*c**5*s - 3*a**2*b**11*c**5*s + 4*a*b**12*c**5*s +
        a**9*b**3*c**6*s + a**8*b**4*c**6*s - 2*a**7*b**5*c**6*s -
        2*a**6*b**6*c**6*s - 4*a**5*b**7*c**6*s + 9*a**4*b**8*c**6*s -
        8*a**3*b**9*c**6*s + 12*a**2*b**10*c**6*s - 7*a*b**11*c**6*s -
        4*a**8*b**3*c**7*s + 5*a**7*b**4*c**7*s - 3*a**6*b**5*c**7*s +
        12*a**5*b**6*c**7*s - 15*a**4*b**7*c**7*s +
        13*a**3*b**8*c**7*s - 15*a**2*b**9*c**7*s + 6*a*b**10*c**7*s +
        b**11*c**7*s + 3*a**8*b**2*c**8*s - a**7*b**3*c**8*s -
        a**6*b**4*c**8*s - 8*a**5*b**5*c**8*s + 8*a**4*b**6*c**8*s -
        7*a**3*b**7*c**8*s + 9*a**2*b**8*c**8*s - 3*b**10*c**8*s -
        a**8*b*c**9*s - 3*a**7*b**2*c**9*s + 4*a**6*b**3*c**9*s +
        2*a**5*b**4*c**9*s + a**4*b**5*c**9*s - a**3*b**6*c**9*s -
        6*a*b**8*c**9*s + 4*b**9*c**9*s + 3*a**7*b*c**10*s -
        2*a**6*b**2*c**10*s - a**5*b**3*c**10*s - 3*a**4*b**4*c**10*s
        + 3*a**3*b**5*c**10*s - 4*a**2*b**6*c**10*s + 7*a*b**7*c**10*s
        - 3*b**8*c**10*s - a**7*c**11*s - a**6*b*c**11*s +
        2*a**5*b**2*c**11*s + a**4*b**3*c**11*s - a**3*b**4*c**11*s +
        3*a**2*b**5*c**11*s - 4*a*b**6*c**11*s + b**7*c**11*s +
        a**6*c**12*s - a**5*b*c**12*s - a**2*b**4*c**12*s +
        a*b**5*c**12*s), (a**11*b**7*c - a**9*b**9*c + a**8*b**10*c +
        a**7*b**11*c + 11*a**11*b**6*c**2 + 7*a**10*b**7*c**2 -
        9*a**9*b**8*c**2 + 4*a**8*b**9*c**2 + 15*a**7*b**10*c**2 +
        7*a**6*b**11*c**2 + a**5*b**12*c**2 + 40*a**11*b**5*c**3 +
        48*a**10*b**6*c**3 - 12*a**9*b**7*c**3 + 51*a**7*b**9*c**3 +
        50*a**6*b**10*c**3 + 22*a**5*b**11*c**3 + 3*a**4*b**12*c**3 +
        70*a**11*b**4*c**4 + 122*a**10*b**5*c**4 + 38*a**9*b**6*c**4 +
        67*a**7*b**8*c**4 + 119*a**6*b**9*c**4 + 90*a**5*b**10*c**4 +
        25*a**4*b**11*c**4 + a**3*b**12*c**4 + 65*a**11*b**3*c**5 +
        148*a**10*b**4*c**5 + 116*a**9*b**5*c**5 + 39*a**8*b**6*c**5 +
        34*a**7*b**7*c**5 + 121*a**6*b**8*c**5 + 151*a**5*b**9*c**5 +
        64*a**4*b**10*c**5 + 5*a**3*b**11*c**5 - a**2*b**12*c**5 +
        31*a**11*b**2*c**6 + 87*a**10*b**3*c**6 + 114*a**9*b**4*c**6 +
        75*a**8*b**5*c**6 + 4*a**7*b**6*c**6 + 45*a**6*b**7*c**6 +
        120*a**5*b**8*c**6 + 73*a**4*b**9*c**6 + 9*a**3*b**10*c**6 -
        2*a**2*b**11*c**6 + 6*a**11*b*c**7 + 20*a**10*b**2*c**7 +
        45*a**9*b**3*c**7 + 50*a**8*b**4*c**7 + 2*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 43*a**5*b**7*c**7 + 39*a**4*b**8*c**7 +
        7*a**3*b**9*c**7 - a**2*b**10*c**7 + 5*a**9*b**2*c**8 +
        11*a**8*b**3*c**8 + 2*a**7*b**4*c**8 - 5*a**6*b**5*c**8 +
        5*a**5*b**6*c**8 + 8*a**4*b**7*c**8 + 2*a**3*b**8*c**8 +
        2*a**11*b**5*c*s**2 + 6*a**10*b**6*c*s**2 - a**9*b**7*c*s**2 -
        4*a**8*b**8*c*s**2 + 6*a**7*b**9*c*s**2 + 5*a**6*b**10*c*s**2
        - a**12*b**3*c**2*s**2 + 9*a**11*b**4*c**2*s**2 +
        35*a**10*b**5*c**2*s**2 + 12*a**9*b**6*c**2*s**2 -
        17*a**8*b**7*c**2*s**2 + 20*a**7*b**8*c**2*s**2 +
        37*a**6*b**9*c**2*s**2 + 19*a**5*b**10*c**2*s**2 +
        6*a**4*b**11*c**2*s**2 - 3*a**12*b**2*c**3*s**2 +
        17*a**11*b**3*c**3*s**2 + 83*a**10*b**4*c**3*s**2 +
        68*a**9*b**5*c**3*s**2 - 7*a**8*b**6*c**3*s**2 +
        23*a**7*b**7*c**3*s**2 + 84*a**6*b**8*c**3*s**2 +
        88*a**5*b**9*c**3*s**2 + 45*a**4*b**10*c**3*s**2 +
        6*a**3*b**11*c**3*s**2 - 3*a**12*b*c**4*s**2 +
        17*a**11*b**2*c**4*s**2 + 101*a**10*b**3*c**4*s**2 +
        131*a**9*b**4*c**4*s**2 + 58*a**8*b**5*c**4*s**2 +
        21*a**7*b**6*c**4*s**2 + 73*a**6*b**7*c**4*s**2 +
        148*a**5*b**8*c**4*s**2 + 113*a**4*b**9*c**4*s**2 +
        25*a**3*b**10*c**4*s**2 - a**12*c**5*s**2 +
        9*a**11*b*c**5*s**2 + 64*a**10*b**2*c**5*s**2 +
        118*a**9*b**3*c**5*s**2 + 106*a**8*b**4*c**5*s**2 +
        36*a**7*b**5*c**5*s**2 + 12*a**6*b**6*c**5*s**2 +
        108*a**5*b**7*c**5*s**2 + 130*a**4*b**8*c**5*s**2 +
        40*a**3*b**9*c**5*s**2 + 2*a**11*c**6*s**2 +
        18*a**10*b*c**6*s**2 + 49*a**9*b**2*c**6*s**2 +
        72*a**8*b**3*c**6*s**2 + 39*a**7*b**4*c**6*s**2 -
        14*a**6*b**5*c**6*s**2 + 28*a**5*b**6*c**6*s**2 +
        72*a**4*b**7*c**6*s**2 + 30*a**3*b**8*c**6*s**2 +
        a**10*c**7*s**2 + 7*a**9*b*c**7*s**2 + 19*a**8*b**2*c**7*s**2
        + 17*a**7*b**3*c**7*s**2 - 5*a**6*b**4*c**7*s**2 -
        2*a**5*b**5*c**7*s**2 + 17*a**4*b**6*c**7*s**2 +
        10*a**3*b**7*c**7*s**2 + a**8*b*c**8*s**2 +
        2*a**7*b**2*c**8*s**2 - a**5*b**4*c**8*s**2 +
        a**4*b**5*c**8*s**2 + a**3*b**6*c**8*s**2)/(a**11*b**7*s -
        3*a**10*b**8*s + 4*a**9*b**9*s - 3*a**8*b**10*s + a**7*b**11*s
        - a**13*b**4*c*s + 4*a**12*b**5*c*s - 7*a**11*b**6*c*s +
        6*a**10*b**7*c*s - 6*a**8*b**9*c*s + 7*a**7*b**10*c*s -
        4*a**6*b**11*c*s + a**5*b**12*c*s - a**14*b**2*c**2*s +
        3*a**13*b**3*c**2*s - 3*a**12*b**4*c**2*s -
        3*a**11*b**5*c**2*s + 12*a**10*b**6*c**2*s -
        15*a**9*b**7*c**2*s + 9*a**8*b**8*c**2*s - 4*a**6*b**10*c**2*s
        + 3*a**5*b**11*c**2*s - a**4*b**12*c**2*s +
        2*a**13*b**2*c**3*s - 7*a**12*b**3*c**3*s +
        10*a**11*b**4*c**3*s - 4*a**10*b**5*c**3*s -
        8*a**9*b**6*c**3*s + 13*a**8*b**7*c**3*s - 7*a**7*b**8*c**3*s
        - a**6*b**9*c**3*s + 3*a**5*b**10*c**3*s - a**4*b**11*c**3*s +
        a**14*c**4*s - 2*a**13*b*c**4*s - a**12*b**2*c**4*s +
        9*a**11*b**3*c**4*s - 14*a**10*b**4*c**4*s +
        6*a**9*b**5*c**4*s + 9*a**8*b**6*c**4*s - 15*a**7*b**7*c**4*s
        + 8*a**6*b**8*c**4*s + a**5*b**9*c**4*s - 3*a**4*b**10*c**4*s
        + a**3*b**11*c**4*s - 2*a**13*c**5*s + 5*a**12*b*c**5*s -
        2*a**11*b**2*c**5*s - 9*a**10*b**3*c**5*s +
        18*a**9*b**4*c**5*s - 12*a**8*b**5*c**5*s - 4*a**7*b**6*c**5*s
        + 12*a**6*b**7*c**5*s - 8*a**5*b**8*c**5*s +
        2*a**4*b**9*c**5*s - a**3*b**10*c**5*s + 2*a**2*b**11*c**5*s -
        a*b**12*c**5*s + 2*a**12*c**6*s - 6*a**11*b*c**6*s +
        5*a**10*b**2*c**6*s + 5*a**9*b**3*c**6*s - 15*a**8*b**4*c**6*s
        + 13*a**7*b**5*c**6*s - 2*a**6*b**6*c**6*s -
        3*a**5*b**7*c**6*s - a**4*b**8*c**6*s + 4*a**3*b**9*c**6*s -
        2*a**2*b**10*c**6*s - a*b**11*c**6*s + b**12*c**6*s -
        2*a**11*c**7*s + 6*a**10*b*c**7*s - 6*a**9*b**2*c**7*s -
        a**8*b**3*c**7*s + 8*a**7*b**4*c**7*s - 6*a**6*b**5*c**7*s -
        2*a**5*b**6*c**7*s + 5*a**4*b**7*c**7*s - a**3*b**8*c**7*s -
        3*a**2*b**9*c**7*s + 3*a*b**10*c**7*s - b**11*c**7*s +
        a**10*c**8*s - 4*a**9*b*c**8*s + 5*a**8*b**2*c**8*s -
        a**7*b**3*c**8*s - 4*a**6*b**4*c**8*s + 4*a**5*b**5*c**8*s +
        a**4*b**6*c**8*s - 4*a**3*b**7*c**8*s + 3*a**2*b**8*c**8*s -
        a*b**9*c**8*s + a**8*b*c**9*s - 2*a**7*b**2*c**9*s +
        a**6*b**3*c**9*s + a**5*b**4*c**9*s - 2*a**4*b**5*c**9*s +
        a**3*b**6*c**9*s), (-a**12*b**5*c**2 - 2*a**11*b**6*c**2 -
        a**10*b**7*c**2 + a**12*b**4*c**3 + 5*a**11*b**5*c**3 +
        9*a**10*b**6*c**3 + 7*a**9*b**7*c**3 + 2*a**8*b**8*c**3 +
        3*a**12*b**3*c**4 + 25*a**11*b**4*c**4 + 64*a**10*b**5*c**4 +
        73*a**9*b**6*c**4 + 39*a**8*b**7*c**4 + 8*a**7*b**8*c**4 +
        a**12*b**2*c**5 + 22*a**11*b**3*c**5 + 90*a**10*b**4*c**5 +
        151*a**9*b**5*c**5 + 120*a**8*b**6*c**5 + 43*a**7*b**7*c**5 +
        5*a**6*b**8*c**5 + 7*a**11*b**2*c**6 + 50*a**10*b**3*c**6 +
        119*a**9*b**4*c**6 + 121*a**8*b**5*c**6 + 45*a**7*b**6*c**6 -
        5*a**6*b**7*c**6 - 5*a**5*b**8*c**6 + a**11*b*c**7 +
        15*a**10*b**2*c**7 + 51*a**9*b**3*c**7 + 67*a**8*b**4*c**7 +
        34*a**7*b**5*c**7 + 4*a**6*b**6*c**7 + 2*a**5*b**7*c**7 +
        2*a**4*b**8*c**7 + a**10*b*c**8 + 4*a**9*b**2*c**8 +
        39*a**6*b**5*c**8 + 75*a**5*b**6*c**8 + 50*a**4*b**7*c**8 +
        11*a**3*b**8*c**8 - a**9*b*c**9 - 9*a**8*b**2*c**9 -
        12*a**7*b**3*c**9 + 38*a**6*b**4*c**9 + 116*a**5*b**5*c**9 +
        114*a**4*b**6*c**9 + 45*a**3*b**7*c**9 + 5*a**2*b**8*c**9 +
        7*a**7*b**2*c**10 + 48*a**6*b**3*c**10 + 122*a**5*b**4*c**10 +
        148*a**4*b**5*c**10 + 87*a**3*b**6*c**10 + 20*a**2*b**7*c**10
        + a**7*b*c**11 + 11*a**6*b**2*c**11 + 40*a**5*b**3*c**11 +
        70*a**4*b**4*c**11 + 65*a**3*b**5*c**11 + 31*a**2*b**6*c**11 +
        6*a*b**7*c**11 + 6*a**11*b**3*c**3*s**2 +
        25*a**10*b**4*c**3*s**2 + 40*a**9*b**5*c**3*s**2 +
        30*a**8*b**6*c**3*s**2 + 10*a**7*b**7*c**3*s**2 +
        a**6*b**8*c**3*s**2 + 6*a**11*b**2*c**4*s**2 +
        45*a**10*b**3*c**4*s**2 + 113*a**9*b**4*c**4*s**2 +
        130*a**8*b**5*c**4*s**2 + 72*a**7*b**6*c**4*s**2 +
        17*a**6*b**7*c**4*s**2 + a**5*b**8*c**4*s**2 +
        19*a**10*b**2*c**5*s**2 + 88*a**9*b**3*c**5*s**2 +
        148*a**8*b**4*c**5*s**2 + 108*a**7*b**5*c**5*s**2 +
        28*a**6*b**6*c**5*s**2 - 2*a**5*b**7*c**5*s**2 -
        a**4*b**8*c**5*s**2 + 5*a**10*b*c**6*s**2 +
        37*a**9*b**2*c**6*s**2 + 84*a**8*b**3*c**6*s**2 +
        73*a**7*b**4*c**6*s**2 + 12*a**6*b**5*c**6*s**2 -
        14*a**5*b**6*c**6*s**2 - 5*a**4*b**7*c**6*s**2 +
        6*a**9*b*c**7*s**2 + 20*a**8*b**2*c**7*s**2 +
        23*a**7*b**3*c**7*s**2 + 21*a**6*b**4*c**7*s**2 +
        36*a**5*b**5*c**7*s**2 + 39*a**4*b**6*c**7*s**2 +
        17*a**3*b**7*c**7*s**2 + 2*a**2*b**8*c**7*s**2 -
        4*a**8*b*c**8*s**2 - 17*a**7*b**2*c**8*s**2 -
        7*a**6*b**3*c**8*s**2 + 58*a**5*b**4*c**8*s**2 +
        106*a**4*b**5*c**8*s**2 + 72*a**3*b**6*c**8*s**2 +
        19*a**2*b**7*c**8*s**2 + a*b**8*c**8*s**2 - a**7*b*c**9*s**2 +
        12*a**6*b**2*c**9*s**2 + 68*a**5*b**3*c**9*s**2 +
        131*a**4*b**4*c**9*s**2 + 118*a**3*b**5*c**9*s**2 +
        49*a**2*b**6*c**9*s**2 + 7*a*b**7*c**9*s**2 +
        6*a**6*b*c**10*s**2 + 35*a**5*b**2*c**10*s**2 +
        83*a**4*b**3*c**10*s**2 + 101*a**3*b**4*c**10*s**2 +
        64*a**2*b**5*c**10*s**2 + 18*a*b**6*c**10*s**2 +
        b**7*c**10*s**2 + 2*a**5*b*c**11*s**2 + 9*a**4*b**2*c**11*s**2
        + 17*a**3*b**3*c**11*s**2 + 17*a**2*b**4*c**11*s**2 +
        9*a*b**5*c**11*s**2 + 2*b**6*c**11*s**2 - a**3*b**2*c**12*s**2
        - 3*a**2*b**3*c**12*s**2 - 3*a*b**4*c**12*s**2 -
        b**5*c**12*s**2)/(a**12*b**6*s - a**11*b**7*s - a**12*b**5*c*s
        - a**11*b**6*c*s + 3*a**10*b**7*c*s - a**9*b**8*c*s +
        2*a**11*b**5*c**2*s - 2*a**10*b**6*c**2*s - 3*a**9*b**7*c**2*s
        + 3*a**8*b**8*c**2*s + a**11*b**4*c**3*s - a**10*b**5*c**3*s +
        4*a**9*b**6*c**3*s - a**8*b**7*c**3*s - 4*a**7*b**8*c**3*s +
        a**6*b**9*c**3*s - a**12*b**2*c**4*s - a**11*b**3*c**4*s -
        3*a**10*b**4*c**4*s + 2*a**9*b**5*c**4*s - a**8*b**6*c**4*s +
        5*a**7*b**7*c**4*s + a**6*b**8*c**4*s - 2*a**5*b**9*c**4*s +
        a**12*b*c**5*s + 3*a**11*b**2*c**5*s + 3*a**10*b**3*c**5*s +
        a**9*b**4*c**5*s - 8*a**8*b**5*c**5*s - 3*a**7*b**6*c**5*s -
        2*a**6*b**7*c**5*s + 4*a**5*b**8*c**5*s + a**4*b**9*c**5*s -
        4*a**11*b*c**6*s - 4*a**10*b**2*c**6*s - a**9*b**3*c**6*s +
        8*a**8*b**4*c**6*s + 12*a**7*b**5*c**6*s - 2*a**6*b**6*c**6*s
        - 6*a**5*b**7*c**6*s - 4*a**4*b**8*c**6*s + a**3*b**9*c**6*s +
        a**11*c**7*s + 7*a**10*b*c**7*s - 7*a**8*b**3*c**7*s -
        15*a**7*b**4*c**7*s - 4*a**6*b**5*c**7*s + 13*a**5*b**6*c**7*s
        + 8*a**4*b**7*c**7*s - a**3*b**8*c**7*s - 2*a**2*b**9*c**7*s -
        3*a**10*c**8*s - 6*a**9*b*c**8*s + 9*a**8*b**2*c**8*s +
        13*a**7*b**3*c**8*s + 9*a**6*b**4*c**8*s - 12*a**5*b**5*c**8*s
        - 15*a**4*b**6*c**8*s - a**3*b**7*c**8*s + 5*a**2*b**8*c**8*s
        + a*b**9*c**8*s + 4*a**9*c**9*s - 15*a**7*b**2*c**9*s -
        8*a**6*b**3*c**9*s + 6*a**5*b**4*c**9*s + 18*a**4*b**5*c**9*s
        + 5*a**3*b**6*c**9*s - 6*a**2*b**7*c**9*s - 4*a*b**8*c**9*s -
        3*a**8*c**10*s + 6*a**7*b*c**10*s + 12*a**6*b**2*c**10*s -
        4*a**5*b**3*c**10*s - 14*a**4*b**4*c**10*s -
        9*a**3*b**5*c**10*s + 5*a**2*b**6*c**10*s + 6*a*b**7*c**10*s +
        b**8*c**10*s + a**7*c**11*s - 7*a**6*b*c**11*s -
        3*a**5*b**2*c**11*s + 10*a**4*b**3*c**11*s +
        9*a**3*b**4*c**11*s - 2*a**2*b**5*c**11*s - 6*a*b**6*c**11*s -
        2*b**7*c**11*s + 4*a**5*b*c**12*s - 3*a**4*b**2*c**12*s -
        7*a**3*b**3*c**12*s - a**2*b**4*c**12*s + 5*a*b**5*c**12*s +
        2*b**6*c**12*s - a**4*b*c**13*s + 3*a**3*b**2*c**13*s +
        2*a**2*b**3*c**13*s - 2*a*b**4*c**13*s - 2*b**5*c**13*s -
        a**2*b**2*c**14*s + b**4*c**14*s), (a**7*b**10*c**2 +
        2*a**6*b**11*c**2 + a**5*b**12*c**2 - 2*a**8*b**8*c**3 -
        7*a**7*b**9*c**3 - 9*a**6*b**10*c**3 - 5*a**5*b**11*c**3 -
        a**4*b**12*c**3 - 8*a**8*b**7*c**4 - 39*a**7*b**8*c**4 -
        73*a**6*b**9*c**4 - 64*a**5*b**10*c**4 - 25*a**4*b**11*c**4 -
        3*a**3*b**12*c**4 - 5*a**8*b**6*c**5 - 43*a**7*b**7*c**5 -
        120*a**6*b**8*c**5 - 151*a**5*b**9*c**5 - 90*a**4*b**10*c**5 -
        22*a**3*b**11*c**5 - a**2*b**12*c**5 + 5*a**8*b**5*c**6 +
        5*a**7*b**6*c**6 - 45*a**6*b**7*c**6 - 121*a**5*b**8*c**6 -
        119*a**4*b**9*c**6 - 50*a**3*b**10*c**6 - 7*a**2*b**11*c**6 -
        2*a**8*b**4*c**7 - 2*a**7*b**5*c**7 - 4*a**6*b**6*c**7 -
        34*a**5*b**7*c**7 - 67*a**4*b**8*c**7 - 51*a**3*b**9*c**7 -
        15*a**2*b**10*c**7 - a*b**11*c**7 - 11*a**8*b**3*c**8 -
        50*a**7*b**4*c**8 - 75*a**6*b**5*c**8 - 39*a**5*b**6*c**8 -
        4*a**2*b**9*c**8 - a*b**10*c**8 - 5*a**8*b**2*c**9 -
        45*a**7*b**3*c**9 - 114*a**6*b**4*c**9 - 116*a**5*b**5*c**9 -
        38*a**4*b**6*c**9 + 12*a**3*b**7*c**9 + 9*a**2*b**8*c**9 +
        a*b**9*c**9 - 20*a**7*b**2*c**10 - 87*a**6*b**3*c**10 -
        148*a**5*b**4*c**10 - 122*a**4*b**5*c**10 - 48*a**3*b**6*c**10
        - 7*a**2*b**7*c**10 - 6*a**7*b*c**11 - 31*a**6*b**2*c**11 -
        65*a**5*b**3*c**11 - 70*a**4*b**4*c**11 - 40*a**3*b**5*c**11 -
        11*a**2*b**6*c**11 - a*b**7*c**11 - a**8*b**6*c**3*s**2 -
        10*a**7*b**7*c**3*s**2 - 30*a**6*b**8*c**3*s**2 -
        40*a**5*b**9*c**3*s**2 - 25*a**4*b**10*c**3*s**2 -
        6*a**3*b**11*c**3*s**2 - a**8*b**5*c**4*s**2 -
        17*a**7*b**6*c**4*s**2 - 72*a**6*b**7*c**4*s**2 -
        130*a**5*b**8*c**4*s**2 - 113*a**4*b**9*c**4*s**2 -
        45*a**3*b**10*c**4*s**2 - 6*a**2*b**11*c**4*s**2 +
        a**8*b**4*c**5*s**2 + 2*a**7*b**5*c**5*s**2 -
        28*a**6*b**6*c**5*s**2 - 108*a**5*b**7*c**5*s**2 -
        148*a**4*b**8*c**5*s**2 - 88*a**3*b**9*c**5*s**2 -
        19*a**2*b**10*c**5*s**2 + 5*a**7*b**4*c**6*s**2 +
        14*a**6*b**5*c**6*s**2 - 12*a**5*b**6*c**6*s**2 -
        73*a**4*b**7*c**6*s**2 - 84*a**3*b**8*c**6*s**2 -
        37*a**2*b**9*c**6*s**2 - 5*a*b**10*c**6*s**2 -
        2*a**8*b**2*c**7*s**2 - 17*a**7*b**3*c**7*s**2 -
        39*a**6*b**4*c**7*s**2 - 36*a**5*b**5*c**7*s**2 -
        21*a**4*b**6*c**7*s**2 - 23*a**3*b**7*c**7*s**2 -
        20*a**2*b**8*c**7*s**2 - 6*a*b**9*c**7*s**2 - a**8*b*c**8*s**2
        - 19*a**7*b**2*c**8*s**2 - 72*a**6*b**3*c**8*s**2 -
        106*a**5*b**4*c**8*s**2 - 58*a**4*b**5*c**8*s**2 +
        7*a**3*b**6*c**8*s**2 + 17*a**2*b**7*c**8*s**2 +
        4*a*b**8*c**8*s**2 - 7*a**7*b*c**9*s**2 -
        49*a**6*b**2*c**9*s**2 - 118*a**5*b**3*c**9*s**2 -
        131*a**4*b**4*c**9*s**2 - 68*a**3*b**5*c**9*s**2 -
        12*a**2*b**6*c**9*s**2 + a*b**7*c**9*s**2 - a**7*c**10*s**2 -
        18*a**6*b*c**10*s**2 - 64*a**5*b**2*c**10*s**2 -
        101*a**4*b**3*c**10*s**2 - 83*a**3*b**4*c**10*s**2 -
        35*a**2*b**5*c**10*s**2 - 6*a*b**6*c**10*s**2 -
        2*a**6*c**11*s**2 - 9*a**5*b*c**11*s**2 -
        17*a**4*b**2*c**11*s**2 - 17*a**3*b**3*c**11*s**2 -
        9*a**2*b**4*c**11*s**2 - 2*a*b**5*c**11*s**2 + a**5*c**12*s**2
        + 3*a**4*b*c**12*s**2 + 3*a**3*b**2*c**12*s**2 +
        a**2*b**3*c**12*s**2)/(a**7*b**11*s - a**6*b**12*s +
        a**8*b**9*c*s - 3*a**7*b**10*c*s + a**6*b**11*c*s +
        a**5*b**12*c*s - 3*a**8*b**8*c**2*s + 3*a**7*b**9*c**2*s +
        2*a**6*b**10*c**2*s - 2*a**5*b**11*c**2*s - a**9*b**6*c**3*s +
        4*a**8*b**7*c**3*s + a**7*b**8*c**3*s - 4*a**6*b**9*c**3*s +
        a**5*b**10*c**3*s - a**4*b**11*c**3*s + 2*a**9*b**5*c**4*s -
        a**8*b**6*c**4*s - 5*a**7*b**7*c**4*s + a**6*b**8*c**4*s -
        2*a**5*b**9*c**4*s + 3*a**4*b**10*c**4*s + a**3*b**11*c**4*s +
        a**2*b**12*c**4*s - a**9*b**4*c**5*s - 4*a**8*b**5*c**5*s +
        2*a**7*b**6*c**5*s + 3*a**6*b**7*c**5*s + 8*a**5*b**8*c**5*s -
        a**4*b**9*c**5*s - 3*a**3*b**10*c**5*s - 3*a**2*b**11*c**5*s -
        a*b**12*c**5*s - a**9*b**3*c**6*s + 4*a**8*b**4*c**6*s +
        6*a**7*b**5*c**6*s + 2*a**6*b**6*c**6*s - 12*a**5*b**7*c**6*s
        - 8*a**4*b**8*c**6*s + a**3*b**9*c**6*s + 4*a**2*b**10*c**6*s
        + 4*a*b**11*c**6*s + 2*a**9*b**2*c**7*s + a**8*b**3*c**7*s -
        8*a**7*b**4*c**7*s - 13*a**6*b**5*c**7*s + 4*a**5*b**6*c**7*s
        + 15*a**4*b**7*c**7*s + 7*a**3*b**8*c**7*s - 7*a*b**10*c**7*s
        - b**11*c**7*s - a**9*b*c**8*s - 5*a**8*b**2*c**8*s +
        a**7*b**3*c**8*s + 15*a**6*b**4*c**8*s + 12*a**5*b**5*c**8*s -
        9*a**4*b**6*c**8*s - 13*a**3*b**7*c**8*s - 9*a**2*b**8*c**8*s
        + 6*a*b**9*c**8*s + 3*b**10*c**8*s + 4*a**8*b*c**9*s +
        6*a**7*b**2*c**9*s - 5*a**6*b**3*c**9*s - 18*a**5*b**4*c**9*s
        - 6*a**4*b**5*c**9*s + 8*a**3*b**6*c**9*s +
        15*a**2*b**7*c**9*s - 4*b**9*c**9*s - a**8*c**10*s -
        6*a**7*b*c**10*s - 5*a**6*b**2*c**10*s + 9*a**5*b**3*c**10*s +
        14*a**4*b**4*c**10*s + 4*a**3*b**5*c**10*s -
        12*a**2*b**6*c**10*s - 6*a*b**7*c**10*s + 3*b**8*c**10*s +
        2*a**7*c**11*s + 6*a**6*b*c**11*s + 2*a**5*b**2*c**11*s -
        9*a**4*b**3*c**11*s - 10*a**3*b**4*c**11*s +
        3*a**2*b**5*c**11*s + 7*a*b**6*c**11*s - b**7*c**11*s -
        2*a**6*c**12*s - 5*a**5*b*c**12*s + a**4*b**2*c**12*s +
        7*a**3*b**3*c**12*s + 3*a**2*b**4*c**12*s - 4*a*b**5*c**12*s +
        2*a**5*c**13*s + 2*a**4*b*c**13*s - 2*a**3*b**2*c**13*s -
        3*a**2*b**3*c**13*s + a*b**4*c**13*s - a**4*c**14*s +
        a**2*b**2*c**14*s), (6*a**11*b**7*c + 31*a**11*b**6*c**2 +
        20*a**10*b**7*c**2 + 5*a**9*b**8*c**2 + 65*a**11*b**5*c**3 +
        87*a**10*b**6*c**3 + 45*a**9*b**7*c**3 + 11*a**8*b**8*c**3 +
        70*a**11*b**4*c**4 + 148*a**10*b**5*c**4 + 114*a**9*b**6*c**4
        + 50*a**8*b**7*c**4 + 2*a**7*b**8*c**4 + 40*a**11*b**3*c**5 +
        122*a**10*b**4*c**5 + 116*a**9*b**5*c**5 + 75*a**8*b**6*c**5 +
        2*a**7*b**7*c**5 - 5*a**6*b**8*c**5 + 11*a**11*b**2*c**6 +
        48*a**10*b**3*c**6 + 38*a**9*b**4*c**6 + 39*a**8*b**5*c**6 +
        4*a**7*b**6*c**6 - 5*a**6*b**7*c**6 + 5*a**5*b**8*c**6 +
        a**11*b*c**7 + 7*a**10*b**2*c**7 - 12*a**9*b**3*c**7 +
        34*a**7*b**5*c**7 + 45*a**6*b**6*c**7 + 43*a**5*b**7*c**7 +
        8*a**4*b**8*c**7 - 9*a**9*b**2*c**8 + 67*a**7*b**4*c**8 +
        121*a**6*b**5*c**8 + 120*a**5*b**6*c**8 + 39*a**4*b**7*c**8 +
        2*a**3*b**8*c**8 - a**9*b*c**9 + 4*a**8*b**2*c**9 +
        51*a**7*b**3*c**9 + 119*a**6*b**4*c**9 + 151*a**5*b**5*c**9 +
        73*a**4*b**6*c**9 + 7*a**3*b**7*c**9 + a**8*b*c**10 +
        15*a**7*b**2*c**10 + 50*a**6*b**3*c**10 + 90*a**5*b**4*c**10 +
        64*a**4*b**5*c**10 + 9*a**3*b**6*c**10 - a**2*b**7*c**10 +
        a**7*b*c**11 + 7*a**6*b**2*c**11 + 22*a**5*b**3*c**11 +
        25*a**4*b**4*c**11 + 5*a**3*b**5*c**11 - 2*a**2*b**6*c**11 +
        a**5*b**2*c**12 + 3*a**4*b**3*c**12 + a**3*b**4*c**12 -
        a**2*b**5*c**12 - a**12*b**5*s**2 + 2*a**11*b**6*s**2 +
        a**10*b**7*s**2 - 3*a**12*b**4*c*s**2 + 9*a**11*b**5*c*s**2 +
        18*a**10*b**6*c*s**2 + 7*a**9*b**7*c*s**2 + a**8*b**8*c*s**2 -
        3*a**12*b**3*c**2*s**2 + 17*a**11*b**4*c**2*s**2 +
        64*a**10*b**5*c**2*s**2 + 49*a**9*b**6*c**2*s**2 +
        19*a**8*b**7*c**2*s**2 + 2*a**7*b**8*c**2*s**2 -
        a**12*b**2*c**3*s**2 + 17*a**11*b**3*c**3*s**2 +
        101*a**10*b**4*c**3*s**2 + 118*a**9*b**5*c**3*s**2 +
        72*a**8*b**6*c**3*s**2 + 17*a**7*b**7*c**3*s**2 +
        9*a**11*b**2*c**4*s**2 + 83*a**10*b**3*c**4*s**2 +
        131*a**9*b**4*c**4*s**2 + 106*a**8*b**5*c**4*s**2 +
        39*a**7*b**6*c**4*s**2 - 5*a**6*b**7*c**4*s**2 -
        a**5*b**8*c**4*s**2 + 2*a**11*b*c**5*s**2 +
        35*a**10*b**2*c**5*s**2 + 68*a**9*b**3*c**5*s**2 +
        58*a**8*b**4*c**5*s**2 + 36*a**7*b**5*c**5*s**2 -
        14*a**6*b**6*c**5*s**2 - 2*a**5*b**7*c**5*s**2 +
        a**4*b**8*c**5*s**2 + 6*a**10*b*c**6*s**2 +
        12*a**9*b**2*c**6*s**2 - 7*a**8*b**3*c**6*s**2 +
        21*a**7*b**4*c**6*s**2 + 12*a**6*b**5*c**6*s**2 +
        28*a**5*b**6*c**6*s**2 + 17*a**4*b**7*c**6*s**2 +
        a**3*b**8*c**6*s**2 - a**9*b*c**7*s**2 -
        17*a**8*b**2*c**7*s**2 + 23*a**7*b**3*c**7*s**2 +
        73*a**6*b**4*c**7*s**2 + 108*a**5*b**5*c**7*s**2 +
        72*a**4*b**6*c**7*s**2 + 10*a**3*b**7*c**7*s**2 -
        4*a**8*b*c**8*s**2 + 20*a**7*b**2*c**8*s**2 +
        84*a**6*b**3*c**8*s**2 + 148*a**5*b**4*c**8*s**2 +
        130*a**4*b**5*c**8*s**2 + 30*a**3*b**6*c**8*s**2 +
        6*a**7*b*c**9*s**2 + 37*a**6*b**2*c**9*s**2 +
        88*a**5*b**3*c**9*s**2 + 113*a**4*b**4*c**9*s**2 +
        40*a**3*b**5*c**9*s**2 + 5*a**6*b*c**10*s**2 +
        19*a**5*b**2*c**10*s**2 + 45*a**4*b**3*c**10*s**2 +
        25*a**3*b**4*c**10*s**2 + 6*a**4*b**2*c**11*s**2 +
        6*a**3*b**3*c**11*s**2)/(a**14*b**4*s - 2*a**13*b**5*s +
        2*a**12*b**6*s - 2*a**11*b**7*s + a**10*b**8*s -
        2*a**13*b**4*c*s + 5*a**12*b**5*c*s - 6*a**11*b**6*c*s +
        6*a**10*b**7*c*s - 4*a**9*b**8*c*s + a**8*b**9*c*s -
        a**14*b**2*c**2*s + 2*a**13*b**3*c**2*s - a**12*b**4*c**2*s -
        2*a**11*b**5*c**2*s + 5*a**10*b**6*c**2*s - 6*a**9*b**7*c**2*s
        + 5*a**8*b**8*c**2*s - 2*a**7*b**9*c**2*s +
        3*a**13*b**2*c**3*s - 7*a**12*b**3*c**3*s +
        9*a**11*b**4*c**3*s - 9*a**10*b**5*c**3*s + 5*a**9*b**6*c**3*s
        - a**8*b**7*c**3*s - a**7*b**8*c**3*s + a**6*b**9*c**3*s -
        a**13*b*c**4*s - 3*a**12*b**2*c**4*s + 10*a**11*b**3*c**4*s -
        14*a**10*b**4*c**4*s + 18*a**9*b**5*c**4*s -
        15*a**8*b**6*c**4*s + 8*a**7*b**7*c**4*s - 4*a**6*b**8*c**4*s
        + a**5*b**9*c**4*s + 4*a**12*b*c**5*s - 3*a**11*b**2*c**5*s -
        4*a**10*b**3*c**5*s + 6*a**9*b**4*c**5*s - 12*a**8*b**5*c**5*s
        + 13*a**7*b**6*c**5*s - 6*a**6*b**7*c**5*s +
        4*a**5*b**8*c**5*s - 2*a**4*b**9*c**5*s - 7*a**11*b*c**6*s +
        12*a**10*b**2*c**6*s - 8*a**9*b**3*c**6*s + 9*a**8*b**4*c**6*s
        - 4*a**7*b**5*c**6*s - 2*a**6*b**6*c**6*s - 2*a**5*b**7*c**6*s
        + a**4*b**8*c**6*s + a**3*b**9*c**6*s + a**11*c**7*s +
        6*a**10*b*c**7*s - 15*a**9*b**2*c**7*s + 13*a**8*b**3*c**7*s -
        15*a**7*b**4*c**7*s + 12*a**6*b**5*c**7*s - 3*a**5*b**6*c**7*s
        + 5*a**4*b**7*c**7*s - 4*a**3*b**8*c**7*s - 3*a**10*c**8*s +
        9*a**8*b**2*c**8*s - 7*a**7*b**3*c**8*s + 8*a**6*b**4*c**8*s -
        8*a**5*b**5*c**8*s - a**4*b**6*c**8*s - a**3*b**7*c**8*s +
        3*a**2*b**8*c**8*s + 4*a**9*c**9*s - 6*a**8*b*c**9*s -
        a**6*b**3*c**9*s + a**5*b**4*c**9*s + 2*a**4*b**5*c**9*s +
        4*a**3*b**6*c**9*s - 3*a**2*b**7*c**9*s - a*b**8*c**9*s -
        3*a**8*c**10*s + 7*a**7*b*c**10*s - 4*a**6*b**2*c**10*s +
        3*a**5*b**3*c**10*s - 3*a**4*b**4*c**10*s - a**3*b**5*c**10*s
        - 2*a**2*b**6*c**10*s + 3*a*b**7*c**10*s + a**7*c**11*s -
        4*a**6*b*c**11*s + 3*a**5*b**2*c**11*s - a**4*b**3*c**11*s +
        a**3*b**4*c**11*s + 2*a**2*b**5*c**11*s - a*b**6*c**11*s -
        b**7*c**11*s + a**5*b*c**12*s - a**4*b**2*c**12*s -
        a*b**5*c**12*s + b**6*c**12*s), (a**11*b**7*c + a**10*b**8*c -
        a**9*b**9*c + a**7*b**11*c + a**12*b**5*c**2 +
        7*a**11*b**6*c**2 + 15*a**10*b**7*c**2 + 4*a**9*b**8*c**2 -
        9*a**8*b**9*c**2 + 7*a**7*b**10*c**2 + 11*a**6*b**11*c**2 +
        3*a**12*b**4*c**3 + 22*a**11*b**5*c**3 + 50*a**10*b**6*c**3 +
        51*a**9*b**7*c**3 - 12*a**7*b**9*c**3 + 48*a**6*b**10*c**3 +
        40*a**5*b**11*c**3 + a**12*b**3*c**4 + 25*a**11*b**4*c**4 +
        90*a**10*b**5*c**4 + 119*a**9*b**6*c**4 + 67*a**8*b**7*c**4 +
        38*a**6*b**9*c**4 + 122*a**5*b**10*c**4 + 70*a**4*b**11*c**4 -
        a**12*b**2*c**5 + 5*a**11*b**3*c**5 + 64*a**10*b**4*c**5 +
        151*a**9*b**5*c**5 + 121*a**8*b**6*c**5 + 34*a**7*b**7*c**5 +
        39*a**6*b**8*c**5 + 116*a**5*b**9*c**5 + 148*a**4*b**10*c**5 +
        65*a**3*b**11*c**5 - 2*a**11*b**2*c**6 + 9*a**10*b**3*c**6 +
        73*a**9*b**4*c**6 + 120*a**8*b**5*c**6 + 45*a**7*b**6*c**6 +
        4*a**6*b**7*c**6 + 75*a**5*b**8*c**6 + 114*a**4*b**9*c**6 +
        87*a**3*b**10*c**6 + 31*a**2*b**11*c**6 - a**10*b**2*c**7 +
        7*a**9*b**3*c**7 + 39*a**8*b**4*c**7 + 43*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 2*a**5*b**7*c**7 + 50*a**4*b**8*c**7 +
        45*a**3*b**9*c**7 + 20*a**2*b**10*c**7 + 6*a*b**11*c**7 +
        2*a**8*b**3*c**8 + 8*a**7*b**4*c**8 + 5*a**6*b**5*c**8 -
        5*a**5*b**6*c**8 + 2*a**4*b**7*c**8 + 11*a**3*b**8*c**8 +
        5*a**2*b**9*c**8 + 5*a**10*b**6*c*s**2 + 6*a**9*b**7*c*s**2 -
        4*a**8*b**8*c*s**2 - a**7*b**9*c*s**2 + 6*a**6*b**10*c*s**2 +
        2*a**5*b**11*c*s**2 + 6*a**11*b**4*c**2*s**2 +
        19*a**10*b**5*c**2*s**2 + 37*a**9*b**6*c**2*s**2 +
        20*a**8*b**7*c**2*s**2 - 17*a**7*b**8*c**2*s**2 +
        12*a**6*b**9*c**2*s**2 + 35*a**5*b**10*c**2*s**2 +
        9*a**4*b**11*c**2*s**2 - a**3*b**12*c**2*s**2 +
        6*a**11*b**3*c**3*s**2 + 45*a**10*b**4*c**3*s**2 +
        88*a**9*b**5*c**3*s**2 + 84*a**8*b**6*c**3*s**2 +
        23*a**7*b**7*c**3*s**2 - 7*a**6*b**8*c**3*s**2 +
        68*a**5*b**9*c**3*s**2 + 83*a**4*b**10*c**3*s**2 +
        17*a**3*b**11*c**3*s**2 - 3*a**2*b**12*c**3*s**2 +
        25*a**10*b**3*c**4*s**2 + 113*a**9*b**4*c**4*s**2 +
        148*a**8*b**5*c**4*s**2 + 73*a**7*b**6*c**4*s**2 +
        21*a**6*b**7*c**4*s**2 + 58*a**5*b**8*c**4*s**2 +
        131*a**4*b**9*c**4*s**2 + 101*a**3*b**10*c**4*s**2 +
        17*a**2*b**11*c**4*s**2 - 3*a*b**12*c**4*s**2 +
        40*a**9*b**3*c**5*s**2 + 130*a**8*b**4*c**5*s**2 +
        108*a**7*b**5*c**5*s**2 + 12*a**6*b**6*c**5*s**2 +
        36*a**5*b**7*c**5*s**2 + 106*a**4*b**8*c**5*s**2 +
        118*a**3*b**9*c**5*s**2 + 64*a**2*b**10*c**5*s**2 +
        9*a*b**11*c**5*s**2 - b**12*c**5*s**2 + 30*a**8*b**3*c**6*s**2
        + 72*a**7*b**4*c**6*s**2 + 28*a**6*b**5*c**6*s**2 -
        14*a**5*b**6*c**6*s**2 + 39*a**4*b**7*c**6*s**2 +
        72*a**3*b**8*c**6*s**2 + 49*a**2*b**9*c**6*s**2 +
        18*a*b**10*c**6*s**2 + 2*b**11*c**6*s**2 +
        10*a**7*b**3*c**7*s**2 + 17*a**6*b**4*c**7*s**2 -
        2*a**5*b**5*c**7*s**2 - 5*a**4*b**6*c**7*s**2 +
        17*a**3*b**7*c**7*s**2 + 19*a**2*b**8*c**7*s**2 +
        7*a*b**9*c**7*s**2 + b**10*c**7*s**2 + a**6*b**3*c**8*s**2 +
        a**5*b**4*c**8*s**2 - a**4*b**5*c**8*s**2 +
        2*a**2*b**7*c**8*s**2 + a*b**8*c**8*s**2)/(a**11*b**7*s -
        3*a**10*b**8*s + 4*a**9*b**9*s - 3*a**8*b**10*s + a**7*b**11*s
        + a**12*b**5*c*s - 4*a**11*b**6*c*s + 7*a**10*b**7*c*s -
        6*a**9*b**8*c*s + 6*a**7*b**10*c*s - 7*a**6*b**11*c*s +
        4*a**5*b**12*c*s - a**4*b**13*c*s - a**12*b**4*c**2*s +
        3*a**11*b**5*c**2*s - 4*a**10*b**6*c**2*s + 9*a**8*b**8*c**2*s
        - 15*a**7*b**9*c**2*s + 12*a**6*b**10*c**2*s -
        3*a**5*b**11*c**2*s - 3*a**4*b**12*c**2*s +
        3*a**3*b**13*c**2*s - a**2*b**14*c**2*s - a**11*b**4*c**3*s +
        3*a**10*b**5*c**3*s - a**9*b**6*c**3*s - 7*a**8*b**7*c**3*s +
        13*a**7*b**8*c**3*s - 8*a**6*b**9*c**3*s - 4*a**5*b**10*c**3*s
        + 10*a**4*b**11*c**3*s - 7*a**3*b**12*c**3*s +
        2*a**2*b**13*c**3*s + a**11*b**3*c**4*s - 3*a**10*b**4*c**4*s
        + a**9*b**5*c**4*s + 8*a**8*b**6*c**4*s - 15*a**7*b**7*c**4*s
        + 9*a**6*b**8*c**4*s + 6*a**5*b**9*c**4*s -
        14*a**4*b**10*c**4*s + 9*a**3*b**11*c**4*s - a**2*b**12*c**4*s
        - 2*a*b**13*c**4*s + b**14*c**4*s - a**12*b*c**5*s +
        2*a**11*b**2*c**5*s - a**10*b**3*c**5*s + 2*a**9*b**4*c**5*s -
        8*a**8*b**5*c**5*s + 12*a**7*b**6*c**5*s - 4*a**6*b**7*c**5*s
        - 12*a**5*b**8*c**5*s + 18*a**4*b**9*c**5*s -
        9*a**3*b**10*c**5*s - 2*a**2*b**11*c**5*s + 5*a*b**12*c**5*s -
        2*b**13*c**5*s + a**12*c**6*s - a**11*b*c**6*s -
        2*a**10*b**2*c**6*s + 4*a**9*b**3*c**6*s - a**8*b**4*c**6*s -
        3*a**7*b**5*c**6*s - 2*a**6*b**6*c**6*s + 13*a**5*b**7*c**6*s
        - 15*a**4*b**8*c**6*s + 5*a**3*b**9*c**6*s +
        5*a**2*b**10*c**6*s - 6*a*b**11*c**6*s + 2*b**12*c**6*s -
        a**11*c**7*s + 3*a**10*b*c**7*s - 3*a**9*b**2*c**7*s -
        a**8*b**3*c**7*s + 5*a**7*b**4*c**7*s - 2*a**6*b**5*c**7*s -
        6*a**5*b**6*c**7*s + 8*a**4*b**7*c**7*s - a**3*b**8*c**7*s -
        6*a**2*b**9*c**7*s + 6*a*b**10*c**7*s - 2*b**11*c**7*s -
        a**9*b*c**8*s + 3*a**8*b**2*c**8*s - 4*a**7*b**3*c**8*s +
        a**6*b**4*c**8*s + 4*a**5*b**5*c**8*s - 4*a**4*b**6*c**8*s -
        a**3*b**7*c**8*s + 5*a**2*b**8*c**8*s - 4*a*b**9*c**8*s +
        b**10*c**8*s + a**6*b**3*c**9*s - 2*a**5*b**4*c**9*s +
        a**4*b**5*c**9*s + a**3*b**6*c**9*s - 2*a**2*b**7*c**9*s +
        a*b**8*c**9*s), (-a**7*b**6*c**2 - 4*a**6*b**7*c**2 -
        3*a**5*b**8*c**2 - 7*a**7*b**5*c**3 - 24*a**6*b**6*c**3 -
        26*a**5*b**7*c**3 - 9*a**4*b**8*c**3 - 12*a**7*b**4*c**4 -
        54*a**6*b**5*c**4 - 79*a**5*b**6*c**4 - 45*a**4*b**7*c**4 -
        8*a**3*b**8*c**4 - 7*a**7*b**3*c**5 - 56*a**6*b**4*c**5 -
        117*a**5*b**5*c**5 - 95*a**4*b**6*c**5 - 29*a**3*b**7*c**5 -
        2*a**2*b**8*c**5 - a**7*b**2*c**6 - 30*a**6*b**3*c**6 -
        98*a**5*b**4*c**6 - 115*a**4*b**5*c**6 - 54*a**3*b**6*c**6 -
        8*a**2*b**7*c**6 - 9*a**6*b**2*c**7 - 46*a**5*b**3*c**7 -
        78*a**4*b**4*c**7 - 55*a**3*b**5*c**7 - 15*a**2*b**6*c**7 -
        a*b**7*c**7 - a**6*b*c**8 - 9*a**5*b**2*c**8 -
        22*a**4*b**3*c**8 - 22*a**3*b**4*c**8 - 9*a**2*b**5*c**8 -
        a*b**6*c**8 - a**7*b**4*c**2*s**2 - 8*a**6*b**5*c**2*s**2 -
        14*a**5*b**6*c**2*s**2 - 8*a**4*b**7*c**2*s**2 -
        a**3*b**8*c**2*s**2 - 2*a**7*b**3*c**3*s**2 -
        22*a**6*b**4*c**3*s**2 - 56*a**5*b**5*c**3*s**2 -
        52*a**4*b**6*c**3*s**2 - 17*a**3*b**7*c**3*s**2 -
        a**2*b**8*c**3*s**2 - a**7*b**2*c**4*s**2 -
        20*a**6*b**3*c**4*s**2 - 79*a**5*b**4*c**4*s**2 -
        110*a**4*b**5*c**4*s**2 - 59*a**3*b**6*c**4*s**2 -
        9*a**2*b**7*c**4*s**2 - 8*a**6*b**2*c**5*s**2 -
        56*a**5*b**3*c**5*s**2 - 116*a**4*b**4*c**5*s**2 -
        95*a**3*b**5*c**5*s**2 - 28*a**2*b**6*c**5*s**2 -
        a*b**7*c**5*s**2 - 2*a**6*b*c**6*s**2 - 25*a**5*b**2*c**6*s**2
        - 72*a**4*b**3*c**6*s**2 - 83*a**3*b**4*c**6*s**2 -
        40*a**2*b**5*c**6*s**2 - 6*a*b**6*c**6*s**2 -
        6*a**5*b*c**7*s**2 - 25*a**4*b**2*c**7*s**2 -
        37*a**3*b**3*c**7*s**2 - 24*a**2*b**4*c**7*s**2 -
        6*a*b**5*c**7*s**2 - 3*a**4*b*c**8*s**2 -
        6*a**3*b**2*c**8*s**2 - 4*a**2*b**3*c**8*s**2 -
        a*b**4*c**8*s**2)/(a**8*b**6*s - 2*a**7*b**7*s + a**6*b**8*s -
        2*a**8*b**5*c*s + 4*a**7*b**6*c*s - a**6*b**7*c*s -
        2*a**5*b**8*c*s + a**4*b**9*c*s + a**8*b**4*c**2*s -
        3*a**7*b**5*c**2*s + 5*a**5*b**7*c**2*s - 3*a**4*b**8*c**2*s +
        a**8*b**3*c**3*s + a**7*b**4*c**3*s - 2*a**6*b**5*c**3*s -
        4*a**5*b**6*c**3*s + 4*a**4*b**7*c**3*s + a**3*b**8*c**3*s -
        a**2*b**9*c**3*s - 2*a**8*b**2*c**4*s + 5*a**6*b**4*c**4*s +
        a**5*b**5*c**4*s - 5*a**4*b**6*c**4*s - a**3*b**7*c**4*s +
        2*a**2*b**8*c**4*s + a**8*b*c**5*s + a**7*b**2*c**5*s -
        5*a**6*b**3*c**5*s + 5*a**4*b**5*c**5*s - a**3*b**6*c**5*s -
        a**2*b**7*c**5*s - a**7*b*c**6*s + a**6*b**2*c**6*s +
        a**5*b**3*c**6*s - 2*a**4*b**4*c**6*s + 3*a**3*b**5*c**6*s -
        2*a**2*b**6*c**6*s - a*b**7*c**6*s + b**8*c**6*s +
        2*a**6*b*c**7*s - a**5*b**2*c**7*s - 2*a**4*b**3*c**7*s -
        4*a**3*b**4*c**7*s + 5*a**2*b**5*c**7*s + 3*a*b**6*c**7*s -
        3*b**7*c**7*s - a**6*c**8*s - a**5*b*c**8*s +
        4*a**4*b**2*c**8*s + 3*a**3*b**3*c**8*s - 5*a**2*b**4*c**8*s -
        4*a*b**5*c**8*s + 4*b**6*c**8*s + a**5*c**9*s -
        2*a**4*b*c**9*s - 2*a**3*b**2*c**9*s + 3*a**2*b**3*c**9*s +
        3*a*b**4*c**9*s - 3*b**5*c**9*s + a**3*b*c**10*s -
        a**2*b**2*c**10*s - a*b**3*c**10*s + b**4*c**10*s),
        (-a**7*b**7*c - a**6*b**8*c - 2*a**8*b**5*c**2 -
        8*a**7*b**6*c**2 - 15*a**6*b**7*c**2 - 9*a**5*b**8*c**2 -
        8*a**8*b**4*c**3 - 29*a**7*b**5*c**3 - 54*a**6*b**6*c**3 -
        55*a**5*b**7*c**3 - 22*a**4*b**8*c**3 - 9*a**8*b**3*c**4 -
        45*a**7*b**4*c**4 - 95*a**6*b**5*c**4 - 115*a**5*b**6*c**4 -
        78*a**4*b**7*c**4 - 22*a**3*b**8*c**4 - 3*a**8*b**2*c**5 -
        26*a**7*b**3*c**5 - 79*a**6*b**4*c**5 - 117*a**5*b**5*c**5 -
        98*a**4*b**6*c**5 - 46*a**3*b**7*c**5 - 9*a**2*b**8*c**5 -
        4*a**7*b**2*c**6 - 24*a**6*b**3*c**6 - 54*a**5*b**4*c**6 -
        56*a**4*b**5*c**6 - 30*a**3*b**6*c**6 - 9*a**2*b**7*c**6 -
        a*b**8*c**6 - a**6*b**2*c**7 - 7*a**5*b**3*c**7 -
        12*a**4*b**4*c**7 - 7*a**3*b**5*c**7 - a**2*b**6*c**7 -
        a**7*b**5*c*s**2 - 6*a**6*b**6*c*s**2 - 6*a**5*b**7*c*s**2 -
        a**4*b**8*c*s**2 - a**8*b**3*c**2*s**2 - 9*a**7*b**4*c**2*s**2
        - 28*a**6*b**5*c**2*s**2 - 40*a**5*b**6*c**2*s**2 -
        24*a**4*b**7*c**2*s**2 - 4*a**3*b**8*c**2*s**2 -
        a**8*b**2*c**3*s**2 - 17*a**7*b**3*c**3*s**2 -
        59*a**6*b**4*c**3*s**2 - 95*a**5*b**5*c**3*s**2 -
        83*a**4*b**6*c**3*s**2 - 37*a**3*b**7*c**3*s**2 -
        6*a**2*b**8*c**3*s**2 - 8*a**7*b**2*c**4*s**2 -
        52*a**6*b**3*c**4*s**2 - 110*a**5*b**4*c**4*s**2 -
        116*a**4*b**5*c**4*s**2 - 72*a**3*b**6*c**4*s**2 -
        25*a**2*b**7*c**4*s**2 - 3*a*b**8*c**4*s**2 -
        14*a**6*b**2*c**5*s**2 - 56*a**5*b**3*c**5*s**2 -
        79*a**4*b**4*c**5*s**2 - 56*a**3*b**5*c**5*s**2 -
        25*a**2*b**6*c**5*s**2 - 6*a*b**7*c**5*s**2 -
        8*a**5*b**2*c**6*s**2 - 22*a**4*b**3*c**6*s**2 -
        20*a**3*b**4*c**6*s**2 - 8*a**2*b**5*c**6*s**2 -
        2*a*b**6*c**6*s**2 - a**4*b**2*c**7*s**2 -
        2*a**3*b**3*c**7*s**2 - a**2*b**4*c**7*s**2)/(a**8*b**6*s -
        3*a**7*b**7*s + 4*a**6*b**8*s - 3*a**5*b**9*s + a**4*b**10*s -
        a**7*b**6*c*s + 3*a**6*b**7*c*s - 4*a**5*b**8*c*s +
        3*a**4*b**9*c*s - a**3*b**10*c*s - a**9*b**3*c**2*s +
        2*a**8*b**4*c**2*s - a**7*b**5*c**2*s - 2*a**6*b**6*c**2*s +
        5*a**5*b**7*c**2*s - 5*a**4*b**8*c**2*s + 3*a**3*b**9*c**2*s -
        a**2*b**10*c**2*s + a**8*b**3*c**3*s - a**7*b**4*c**3*s -
        a**6*b**5*c**3*s + 3*a**5*b**6*c**3*s - 4*a**4*b**7*c**3*s +
        3*a**3*b**8*c**3*s - 2*a**2*b**9*c**3*s + a*b**10*c**3*s +
        a**9*b*c**4*s - 3*a**8*b**2*c**4*s + 4*a**7*b**3*c**4*s -
        5*a**6*b**4*c**4*s + 5*a**5*b**5*c**4*s - 2*a**4*b**6*c**4*s -
        2*a**3*b**7*c**4*s + 4*a**2*b**8*c**4*s - 2*a*b**9*c**4*s -
        2*a**8*b*c**5*s + 5*a**7*b**2*c**5*s - 4*a**6*b**3*c**5*s +
        a**5*b**4*c**5*s + a**3*b**6*c**5*s - a**2*b**7*c**5*s -
        a*b**8*c**5*s + b**9*c**5*s + a**8*c**6*s - a**7*b*c**6*s -
        2*a**5*b**3*c**6*s + 5*a**4*b**4*c**6*s - 5*a**3*b**5*c**6*s +
        a**2*b**6*c**6*s + 2*a*b**7*c**6*s - b**8*c**6*s -
        2*a**7*c**7*s + 4*a**6*b*c**7*s - 3*a**5*b**2*c**7*s +
        a**4*b**3*c**7*s + a**2*b**5*c**7*s - a*b**6*c**7*s +
        a**6*c**8*s - 2*a**5*b*c**8*s + a**4*b**2*c**8*s +
        a**3*b**3*c**8*s - 2*a**2*b**4*c**8*s + a*b**5*c**8*s),
        (-a**8*b**6*c - 9*a**8*b**5*c**2 - 9*a**7*b**6*c**2 -
        a**6*b**7*c**2 - 22*a**8*b**4*c**3 - 46*a**7*b**5*c**3 -
        30*a**6*b**6*c**3 - 7*a**5*b**7*c**3 - 22*a**8*b**3*c**4 -
        78*a**7*b**4*c**4 - 98*a**6*b**5*c**4 - 56*a**5*b**6*c**4 -
        12*a**4*b**7*c**4 - 9*a**8*b**2*c**5 - 55*a**7*b**3*c**5 -
        115*a**6*b**4*c**5 - 117*a**5*b**5*c**5 - 54*a**4*b**6*c**5 -
        7*a**3*b**7*c**5 - a**8*b*c**6 - 15*a**7*b**2*c**6 -
        54*a**6*b**3*c**6 - 95*a**5*b**4*c**6 - 79*a**4*b**5*c**6 -
        24*a**3*b**6*c**6 - a**2*b**7*c**6 - a**7*b*c**7 -
        8*a**6*b**2*c**7 - 29*a**5*b**3*c**7 - 45*a**4*b**4*c**7 -
        26*a**3*b**5*c**7 - 4*a**2*b**6*c**7 - 2*a**5*b**2*c**8 -
        8*a**4*b**3*c**8 - 9*a**3*b**4*c**8 - 3*a**2*b**5*c**8 -
        3*a**8*b**4*c*s**2 - 6*a**7*b**5*c*s**2 - 2*a**6*b**6*c*s**2 -
        6*a**8*b**3*c**2*s**2 - 25*a**7*b**4*c**2*s**2 -
        25*a**6*b**5*c**2*s**2 - 8*a**5*b**6*c**2*s**2 -
        a**4*b**7*c**2*s**2 - 4*a**8*b**2*c**3*s**2 -
        37*a**7*b**3*c**3*s**2 - 72*a**6*b**4*c**3*s**2 -
        56*a**5*b**5*c**3*s**2 - 20*a**4*b**6*c**3*s**2 -
        2*a**3*b**7*c**3*s**2 - a**8*b*c**4*s**2 -
        24*a**7*b**2*c**4*s**2 - 83*a**6*b**3*c**4*s**2 -
        116*a**5*b**4*c**4*s**2 - 79*a**4*b**5*c**4*s**2 -
        22*a**3*b**6*c**4*s**2 - a**2*b**7*c**4*s**2 -
        6*a**7*b*c**5*s**2 - 40*a**6*b**2*c**5*s**2 -
        95*a**5*b**3*c**5*s**2 - 110*a**4*b**4*c**5*s**2 -
        56*a**3*b**5*c**5*s**2 - 8*a**2*b**6*c**5*s**2 -
        6*a**6*b*c**6*s**2 - 28*a**5*b**2*c**6*s**2 -
        59*a**4*b**3*c**6*s**2 - 52*a**3*b**4*c**6*s**2 -
        14*a**2*b**5*c**6*s**2 - a**5*b*c**7*s**2 -
        9*a**4*b**2*c**7*s**2 - 17*a**3*b**3*c**7*s**2 -
        8*a**2*b**4*c**7*s**2 - a**3*b**2*c**8*s**2 -
        a**2*b**3*c**8*s**2)/(a**9*b**5*s - a**8*b**6*s +
        a**10*b**3*c*s - 2*a**9*b**4*c*s - a**8*b**5*c*s +
        2*a**7*b**6*c*s - a**6*b**7*c*s + a**5*b**8*c*s -
        a**10*b**2*c**2*s - 2*a**9*b**3*c**2*s + 4*a**8*b**4*c**2*s -
        a**7*b**5*c**2*s + a**6*b**6*c**2*s + a**5*b**7*c**2*s -
        2*a**4*b**8*c**2*s - a**10*b*c**3*s + 3*a**9*b**2*c**3*s +
        3*a**8*b**3*c**3*s - 2*a**7*b**4*c**3*s + a**6*b**5*c**3*s -
        5*a**5*b**6*c**3*s + a**3*b**8*c**3*s + a**10*c**4*s +
        3*a**9*b*c**4*s - 5*a**8*b**2*c**4*s - 4*a**7*b**3*c**4*s -
        2*a**6*b**4*c**4*s + 5*a**4*b**6*c**4*s + a**3*b**7*c**4*s +
        a**2*b**8*c**4*s - 3*a**9*c**5*s - 4*a**8*b*c**5*s +
        5*a**7*b**2*c**5*s + 3*a**6*b**3*c**5*s + 5*a**5*b**4*c**5*s +
        a**4*b**5*c**5*s - 2*a**3*b**6*c**5*s - 3*a**2*b**7*c**5*s -
        2*a*b**8*c**5*s + 4*a**8*c**6*s + 3*a**7*b*c**6*s -
        2*a**6*b**2*c**6*s - a**5*b**3*c**6*s - 5*a**4*b**4*c**6*s -
        4*a**3*b**5*c**6*s + 4*a*b**7*c**6*s + b**8*c**6*s -
        3*a**7*c**7*s - a**6*b*c**7*s - a**5*b**2*c**7*s -
        a**4*b**3*c**7*s + 4*a**3*b**4*c**7*s + 5*a**2*b**5*c**7*s -
        a*b**6*c**7*s - 2*b**7*c**7*s + a**6*c**8*s +
        2*a**4*b**2*c**8*s + a**3*b**3*c**8*s - 3*a**2*b**4*c**8*s -
        2*a*b**5*c**8*s + b**6*c**8*s - a**3*b**2*c**9*s +
        a*b**4*c**9*s), (a**6*b**8*c + a**7*b**6*c**2 +
        9*a**6*b**7*c**2 + 9*a**5*b**8*c**2 + 7*a**7*b**5*c**3 +
        30*a**6*b**6*c**3 + 46*a**5*b**7*c**3 + 22*a**4*b**8*c**3 +
        12*a**7*b**4*c**4 + 56*a**6*b**5*c**4 + 98*a**5*b**6*c**4 +
        78*a**4*b**7*c**4 + 22*a**3*b**8*c**4 + 7*a**7*b**3*c**5 +
        54*a**6*b**4*c**5 + 117*a**5*b**5*c**5 + 115*a**4*b**6*c**5 +
        55*a**3*b**7*c**5 + 9*a**2*b**8*c**5 + a**7*b**2*c**6 +
        24*a**6*b**3*c**6 + 79*a**5*b**4*c**6 + 95*a**4*b**5*c**6 +
        54*a**3*b**6*c**6 + 15*a**2*b**7*c**6 + a*b**8*c**6 +
        4*a**6*b**2*c**7 + 26*a**5*b**3*c**7 + 45*a**4*b**4*c**7 +
        29*a**3*b**5*c**7 + 8*a**2*b**6*c**7 + a*b**7*c**7 +
        3*a**5*b**2*c**8 + 9*a**4*b**3*c**8 + 8*a**3*b**4*c**8 +
        2*a**2*b**5*c**8 + 2*a**6*b**6*c*s**2 + 6*a**5*b**7*c*s**2 +
        3*a**4*b**8*c*s**2 + a**7*b**4*c**2*s**2 +
        8*a**6*b**5*c**2*s**2 + 25*a**5*b**6*c**2*s**2 +
        25*a**4*b**7*c**2*s**2 + 6*a**3*b**8*c**2*s**2 +
        2*a**7*b**3*c**3*s**2 + 20*a**6*b**4*c**3*s**2 +
        56*a**5*b**5*c**3*s**2 + 72*a**4*b**6*c**3*s**2 +
        37*a**3*b**7*c**3*s**2 + 4*a**2*b**8*c**3*s**2 +
        a**7*b**2*c**4*s**2 + 22*a**6*b**3*c**4*s**2 +
        79*a**5*b**4*c**4*s**2 + 116*a**4*b**5*c**4*s**2 +
        83*a**3*b**6*c**4*s**2 + 24*a**2*b**7*c**4*s**2 +
        a*b**8*c**4*s**2 + 8*a**6*b**2*c**5*s**2 +
        56*a**5*b**3*c**5*s**2 + 110*a**4*b**4*c**5*s**2 +
        95*a**3*b**5*c**5*s**2 + 40*a**2*b**6*c**5*s**2 +
        6*a*b**7*c**5*s**2 + 14*a**5*b**2*c**6*s**2 +
        52*a**4*b**3*c**6*s**2 + 59*a**3*b**4*c**6*s**2 +
        28*a**2*b**5*c**6*s**2 + 6*a*b**6*c**6*s**2 +
        8*a**4*b**2*c**7*s**2 + 17*a**3*b**3*c**7*s**2 +
        9*a**2*b**4*c**7*s**2 + a*b**5*c**7*s**2 + a**3*b**2*c**8*s**2
        + a**2*b**3*c**8*s**2)/(a**6*b**8*s - a**5*b**9*s -
        a**8*b**5*c*s + a**7*b**6*c*s - 2*a**6*b**7*c*s +
        a**5*b**8*c*s + 2*a**4*b**9*c*s - a**3*b**10*c*s +
        2*a**8*b**4*c**2*s - a**7*b**5*c**2*s - a**6*b**6*c**2*s +
        a**5*b**7*c**2*s - 4*a**4*b**8*c**2*s + 2*a**3*b**9*c**2*s +
        a**2*b**10*c**2*s - a**8*b**3*c**3*s + 5*a**6*b**5*c**3*s -
        a**5*b**6*c**3*s + 2*a**4*b**7*c**3*s - 3*a**3*b**8*c**3*s -
        3*a**2*b**9*c**3*s + a*b**10*c**3*s - a**8*b**2*c**4*s -
        a**7*b**3*c**4*s - 5*a**6*b**4*c**4*s + 2*a**4*b**6*c**4*s +
        4*a**3*b**7*c**4*s + 5*a**2*b**8*c**4*s - 3*a*b**9*c**4*s -
        b**10*c**4*s + 2*a**8*b*c**5*s + 3*a**7*b**2*c**5*s +
        2*a**6*b**3*c**5*s - a**5*b**4*c**5*s - 5*a**4*b**5*c**5*s -
        3*a**3*b**6*c**5*s - 5*a**2*b**7*c**5*s + 4*a*b**8*c**5*s +
        3*b**9*c**5*s - a**8*c**6*s - 4*a**7*b*c**6*s +
        4*a**5*b**3*c**6*s + 5*a**4*b**4*c**6*s + a**3*b**5*c**6*s +
        2*a**2*b**6*c**6*s - 3*a*b**7*c**6*s - 4*b**8*c**6*s +
        2*a**7*c**7*s + a**6*b*c**7*s - 5*a**5*b**2*c**7*s -
        4*a**4*b**3*c**7*s + a**3*b**4*c**7*s + a**2*b**5*c**7*s +
        a*b**6*c**7*s + 3*b**7*c**7*s - a**6*c**8*s + 2*a**5*b*c**8*s
        + 3*a**4*b**2*c**8*s - a**3*b**3*c**8*s - 2*a**2*b**4*c**8*s -
        b**6*c**8*s - a**4*b*c**9*s + a**2*b**3*c**9*s),
        (-3*a**8*b**5*c**2 - 4*a**7*b**6*c**2 - a**6*b**7*c**2 -
        9*a**8*b**4*c**3 - 26*a**7*b**5*c**3 - 24*a**6*b**6*c**3 -
        7*a**5*b**7*c**3 - 8*a**8*b**3*c**4 - 45*a**7*b**4*c**4 -
        79*a**6*b**5*c**4 - 54*a**5*b**6*c**4 - 12*a**4*b**7*c**4 -
        2*a**8*b**2*c**5 - 29*a**7*b**3*c**5 - 95*a**6*b**4*c**5 -
        117*a**5*b**5*c**5 - 56*a**4*b**6*c**5 - 7*a**3*b**7*c**5 -
        8*a**7*b**2*c**6 - 54*a**6*b**3*c**6 - 115*a**5*b**4*c**6 -
        98*a**4*b**5*c**6 - 30*a**3*b**6*c**6 - a**2*b**7*c**6 -
        a**7*b*c**7 - 15*a**6*b**2*c**7 - 55*a**5*b**3*c**7 -
        78*a**4*b**4*c**7 - 46*a**3*b**5*c**7 - 9*a**2*b**6*c**7 -
        a**6*b*c**8 - 9*a**5*b**2*c**8 - 22*a**4*b**3*c**8 -
        22*a**3*b**4*c**8 - 9*a**2*b**5*c**8 - a*b**6*c**8 -
        a**8*b**3*c**2*s**2 - 8*a**7*b**4*c**2*s**2 -
        14*a**6*b**5*c**2*s**2 - 8*a**5*b**6*c**2*s**2 -
        a**4*b**7*c**2*s**2 - a**8*b**2*c**3*s**2 -
        17*a**7*b**3*c**3*s**2 - 52*a**6*b**4*c**3*s**2 -
        56*a**5*b**5*c**3*s**2 - 22*a**4*b**6*c**3*s**2 -
        2*a**3*b**7*c**3*s**2 - 9*a**7*b**2*c**4*s**2 -
        59*a**6*b**3*c**4*s**2 - 110*a**5*b**4*c**4*s**2 -
        79*a**4*b**5*c**4*s**2 - 20*a**3*b**6*c**4*s**2 -
        a**2*b**7*c**4*s**2 - a**7*b*c**5*s**2 -
        28*a**6*b**2*c**5*s**2 - 95*a**5*b**3*c**5*s**2 -
        116*a**4*b**4*c**5*s**2 - 56*a**3*b**5*c**5*s**2 -
        8*a**2*b**6*c**5*s**2 - 6*a**6*b*c**6*s**2 -
        40*a**5*b**2*c**6*s**2 - 83*a**4*b**3*c**6*s**2 -
        72*a**3*b**4*c**6*s**2 - 25*a**2*b**5*c**6*s**2 -
        2*a*b**6*c**6*s**2 - 6*a**5*b*c**7*s**2 -
        24*a**4*b**2*c**7*s**2 - 37*a**3*b**3*c**7*s**2 -
        25*a**2*b**4*c**7*s**2 - 6*a*b**5*c**7*s**2 - a**4*b*c**8*s**2
        - 4*a**3*b**2*c**8*s**2 - 6*a**2*b**3*c**8*s**2 -
        3*a*b**4*c**8*s**2)/(a**8*b**6*s - 2*a**7*b**7*s + a**6*b**8*s
        + a**9*b**4*c*s - 2*a**8*b**5*c*s - a**7*b**6*c*s +
        4*a**6*b**7*c*s - 2*a**5*b**8*c*s - 3*a**8*b**4*c**2*s +
        5*a**7*b**5*c**2*s - 3*a**5*b**7*c**2*s + a**4*b**8*c**2*s -
        a**9*b**2*c**3*s + a**8*b**3*c**3*s + 4*a**7*b**4*c**3*s -
        4*a**6*b**5*c**3*s - 2*a**5*b**6*c**3*s + a**4*b**7*c**3*s +
        a**3*b**8*c**3*s + 2*a**8*b**2*c**4*s - a**7*b**3*c**4*s -
        5*a**6*b**4*c**4*s + a**5*b**5*c**4*s + 5*a**4*b**6*c**4*s -
        2*a**2*b**8*c**4*s - a**7*b**2*c**5*s - a**6*b**3*c**5*s +
        5*a**5*b**4*c**5*s - 5*a**3*b**6*c**5*s + a**2*b**7*c**5*s +
        a*b**8*c**5*s + a**8*c**6*s - a**7*b*c**6*s -
        2*a**6*b**2*c**6*s + 3*a**5*b**3*c**6*s - 2*a**4*b**4*c**6*s +
        a**3*b**5*c**6*s + a**2*b**6*c**6*s - a*b**7*c**6*s -
        3*a**7*c**7*s + 3*a**6*b*c**7*s + 5*a**5*b**2*c**7*s -
        4*a**4*b**3*c**7*s - 2*a**3*b**4*c**7*s - a**2*b**5*c**7*s +
        2*a*b**6*c**7*s + 4*a**6*c**8*s - 4*a**5*b*c**8*s -
        5*a**4*b**2*c**8*s + 3*a**3*b**3*c**8*s + 4*a**2*b**4*c**8*s -
        a*b**5*c**8*s - b**6*c**8*s - 3*a**5*c**9*s + 3*a**4*b*c**9*s
        + 3*a**3*b**2*c**9*s - 2*a**2*b**3*c**9*s - 2*a*b**4*c**9*s +
        b**5*c**9*s + a**4*c**10*s - a**3*b*c**10*s -
        a**2*b**2*c**10*s + a*b**3*c**10*s), (-a**8*b**6*c -
        a**7*b**7*c - 9*a**8*b**5*c**2 - 15*a**7*b**6*c**2 -
        8*a**6*b**7*c**2 - 2*a**5*b**8*c**2 - 22*a**8*b**4*c**3 -
        55*a**7*b**5*c**3 - 54*a**6*b**6*c**3 - 29*a**5*b**7*c**3 -
        8*a**4*b**8*c**3 - 22*a**8*b**3*c**4 - 78*a**7*b**4*c**4 -
        115*a**6*b**5*c**4 - 95*a**5*b**6*c**4 - 45*a**4*b**7*c**4 -
        9*a**3*b**8*c**4 - 9*a**8*b**2*c**5 - 46*a**7*b**3*c**5 -
        98*a**6*b**4*c**5 - 117*a**5*b**5*c**5 - 79*a**4*b**6*c**5 -
        26*a**3*b**7*c**5 - 3*a**2*b**8*c**5 - a**8*b*c**6 -
        9*a**7*b**2*c**6 - 30*a**6*b**3*c**6 - 56*a**5*b**4*c**6 -
        54*a**4*b**5*c**6 - 24*a**3*b**6*c**6 - 4*a**2*b**7*c**6 -
        a**6*b**2*c**7 - 7*a**5*b**3*c**7 - 12*a**4*b**4*c**7 -
        7*a**3*b**5*c**7 - a**2*b**6*c**7 - a**8*b**4*c*s**2 -
        6*a**7*b**5*c*s**2 - 6*a**6*b**6*c*s**2 - a**5*b**7*c*s**2 -
        4*a**8*b**3*c**2*s**2 - 24*a**7*b**4*c**2*s**2 -
        40*a**6*b**5*c**2*s**2 - 28*a**5*b**6*c**2*s**2 -
        9*a**4*b**7*c**2*s**2 - a**3*b**8*c**2*s**2 -
        6*a**8*b**2*c**3*s**2 - 37*a**7*b**3*c**3*s**2 -
        83*a**6*b**4*c**3*s**2 - 95*a**5*b**5*c**3*s**2 -
        59*a**4*b**6*c**3*s**2 - 17*a**3*b**7*c**3*s**2 -
        a**2*b**8*c**3*s**2 - 3*a**8*b*c**4*s**2 -
        25*a**7*b**2*c**4*s**2 - 72*a**6*b**3*c**4*s**2 -
        116*a**5*b**4*c**4*s**2 - 110*a**4*b**5*c**4*s**2 -
        52*a**3*b**6*c**4*s**2 - 8*a**2*b**7*c**4*s**2 -
        6*a**7*b*c**5*s**2 - 25*a**6*b**2*c**5*s**2 -
        56*a**5*b**3*c**5*s**2 - 79*a**4*b**4*c**5*s**2 -
        56*a**3*b**5*c**5*s**2 - 14*a**2*b**6*c**5*s**2 -
        2*a**6*b*c**6*s**2 - 8*a**5*b**2*c**6*s**2 -
        20*a**4*b**3*c**6*s**2 - 22*a**3*b**4*c**6*s**2 -
        8*a**2*b**5*c**6*s**2 - a**4*b**2*c**7*s**2 -
        2*a**3*b**3*c**7*s**2 - a**2*b**4*c**7*s**2)/(a**10*b**4*s -
        3*a**9*b**5*s + 4*a**8*b**6*s - 3*a**7*b**7*s + a**6*b**8*s -
        a**10*b**3*c*s + 3*a**9*b**4*c*s - 4*a**8*b**5*c*s +
        3*a**7*b**6*c*s - a**6*b**7*c*s - a**10*b**2*c**2*s +
        3*a**9*b**3*c**2*s - 5*a**8*b**4*c**2*s + 5*a**7*b**5*c**2*s -
        2*a**6*b**6*c**2*s - a**5*b**7*c**2*s + 2*a**4*b**8*c**2*s -
        a**3*b**9*c**2*s + a**10*b*c**3*s - 2*a**9*b**2*c**3*s +
        3*a**8*b**3*c**3*s - 4*a**7*b**4*c**3*s + 3*a**6*b**5*c**3*s -
        a**5*b**6*c**3*s - a**4*b**7*c**3*s + a**3*b**8*c**3*s -
        2*a**9*b*c**4*s + 4*a**8*b**2*c**4*s - 2*a**7*b**3*c**4*s -
        2*a**6*b**4*c**4*s + 5*a**5*b**5*c**4*s - 5*a**4*b**6*c**4*s +
        4*a**3*b**7*c**4*s - 3*a**2*b**8*c**4*s + a*b**9*c**4*s +
        a**9*c**5*s - a**8*b*c**5*s - a**7*b**2*c**5*s +
        a**6*b**3*c**5*s + a**4*b**5*c**5*s - 4*a**3*b**6*c**5*s +
        5*a**2*b**7*c**5*s - 2*a*b**8*c**5*s - a**8*c**6*s +
        2*a**7*b*c**6*s + a**6*b**2*c**6*s - 5*a**5*b**3*c**6*s +
        5*a**4*b**4*c**6*s - 2*a**3*b**5*c**6*s - a*b**7*c**6*s +
        b**8*c**6*s - a**6*b*c**7*s + a**5*b**2*c**7*s +
        a**3*b**4*c**7*s - 3*a**2*b**5*c**7*s + 4*a*b**6*c**7*s -
        2*b**7*c**7*s + a**5*b*c**8*s - 2*a**4*b**2*c**8*s +
        a**3*b**3*c**8*s + a**2*b**4*c**8*s - 2*a*b**5*c**8*s +
        b**6*c**8*s), (-a**9*b**7*c - a**8*b**8*c - 10*a**9*b**6*c**2
        - 18*a**8*b**7*c**2 - 9*a**7*b**8*c**2 - a**6*b**9*c**2 -
        31*a**9*b**5*c**3 - 83*a**8*b**6*c**3 - 81*a**7*b**7*c**3 -
        36*a**6*b**8*c**3 - 7*a**5*b**9*c**3 - 44*a**9*b**4*c**4 -
        166*a**8*b**5*c**4 - 246*a**7*b**6*c**4 - 187*a**6*b**7*c**4 -
        76*a**5*b**8*c**4 - 13*a**4*b**9*c**4 - 31*a**9*b**3*c**5 -
        166*a**8*b**4*c**5 - 348*a**7*b**5*c**5 - 388*a**6*b**6*c**5 -
        245*a**5*b**7*c**5 - 79*a**4*b**8*c**5 - 9*a**3*b**9*c**5 -
        10*a**9*b**2*c**6 - 83*a**8*b**3*c**6 - 246*a**7*b**4*c**6 -
        388*a**6*b**5*c**6 - 352*a**5*b**6*c**6 - 172*a**4*b**7*c**6 -
        37*a**3*b**8*c**6 - 2*a**2*b**9*c**6 - a**9*b*c**7 -
        18*a**8*b**2*c**7 - 81*a**7*b**3*c**7 - 187*a**6*b**4*c**7 -
        245*a**5*b**5*c**7 - 172*a**4*b**6*c**7 - 56*a**3*b**7*c**7 -
        6*a**2*b**8*c**7 - a**8*b*c**8 - 9*a**7*b**2*c**8 -
        36*a**6*b**3*c**8 - 76*a**5*b**4*c**8 - 79*a**4*b**5*c**8 -
        37*a**3*b**6*c**8 - 6*a**2*b**7*c**8 - a**6*b**2*c**9 -
        7*a**5*b**3*c**9 - 13*a**4*b**4*c**9 - 9*a**3*b**5*c**9 -
        2*a**2*b**6*c**9 - 2*a**9*b**5*c*s**2 - 7*a**8*b**6*c*s**2 -
        6*a**7*b**7*c*s**2 - a**6*b**8*c*s**2 - 7*a**9*b**4*c**2*s**2
        - 35*a**8*b**5*c**2*s**2 - 53*a**7*b**6*c**2*s**2 -
        33*a**6*b**7*c**2*s**2 - 9*a**5*b**8*c**2*s**2 -
        a**4*b**9*c**2*s**2 - 10*a**9*b**3*c**3*s**2 -
        70*a**8*b**4*c**3*s**2 - 157*a**7*b**5*c**3*s**2 -
        164*a**6*b**6*c**3*s**2 - 90*a**5*b**7*c**3*s**2 -
        25*a**4*b**8*c**3*s**2 - 2*a**3*b**9*c**3*s**2 -
        7*a**9*b**2*c**4*s**2 - 70*a**8*b**3*c**4*s**2 -
        220*a**7*b**4*c**4*s**2 - 334*a**6*b**5*c**4*s**2 -
        282*a**5*b**6*c**4*s**2 - 130*a**4*b**7*c**4*s**2 -
        26*a**3*b**8*c**4*s**2 - a**2*b**9*c**4*s**2 -
        2*a**9*b*c**5*s**2 - 35*a**8*b**2*c**5*s**2 -
        157*a**7*b**3*c**5*s**2 - 334*a**6*b**4*c**5*s**2 -
        402*a**5*b**5*c**5*s**2 - 272*a**4*b**6*c**5*s**2 -
        89*a**3*b**7*c**5*s**2 - 9*a**2*b**8*c**5*s**2 -
        7*a**8*b*c**6*s**2 - 53*a**7*b**2*c**6*s**2 -
        164*a**6*b**3*c**6*s**2 - 282*a**5*b**4*c**6*s**2 -
        272*a**4*b**5*c**6*s**2 - 130*a**3*b**6*c**6*s**2 -
        22*a**2*b**7*c**6*s**2 - 6*a**7*b*c**7*s**2 -
        33*a**6*b**2*c**7*s**2 - 90*a**5*b**3*c**7*s**2 -
        130*a**4*b**4*c**7*s**2 - 89*a**3*b**5*c**7*s**2 -
        22*a**2*b**6*c**7*s**2 - a**6*b*c**8*s**2 -
        9*a**5*b**2*c**8*s**2 - 25*a**4*b**3*c**8*s**2 -
        26*a**3*b**4*c**8*s**2 - 9*a**2*b**5*c**8*s**2 -
        a**4*b**2*c**9*s**2 - 2*a**3*b**3*c**9*s**2 -
        a**2*b**4*c**9*s**2)/(a**9*b**7*s - a**8*b**8*s -
        a**11*b**4*c*s + a**10*b**5*c*s - a**9*b**6*c*s +
        a**8*b**7*c*s + a**7*b**8*c*s - a**6*b**9*c*s +
        a**11*b**3*c**2*s - a**10*b**4*c**2*s - 2*a**9*b**5*c**2*s +
        a**8*b**6*c**2*s - a**7*b**7*c**2*s + 2*a**6*b**8*c**2*s +
        a**5*b**9*c**2*s - a**4*b**10*c**2*s + a**11*b**2*c**3*s +
        2*a**9*b**4*c**3*s - a**8*b**5*c**3*s - 3*a**7*b**6*c**3*s -
        a**5*b**8*c**3*s + 2*a**4*b**9*c**3*s - a**11*b*c**4*s -
        a**10*b**2*c**4*s + 2*a**9*b**3*c**4*s + 3*a**7*b**5*c**4*s -
        a**6*b**6*c**4*s - 2*a**5*b**7*c**4*s - a**4*b**8*c**4*s +
        a**2*b**10*c**4*s + a**10*b*c**5*s - 2*a**9*b**2*c**5*s -
        a**8*b**3*c**5*s + 3*a**7*b**4*c**5*s + 2*a**5*b**6*c**5*s -
        a**4*b**7*c**5*s - a**3*b**8*c**5*s - a**2*b**9*c**5*s -
        a**9*b*c**6*s + a**8*b**2*c**6*s - 3*a**7*b**3*c**6*s -
        a**6*b**4*c**6*s + 2*a**5*b**5*c**6*s + 2*a**4*b**6*c**6*s +
        a**3*b**7*c**6*s - a**2*b**8*c**6*s + a**9*c**7*s +
        a**8*b*c**7*s - a**7*b**2*c**7*s - 2*a**5*b**4*c**7*s -
        a**4*b**5*c**7*s + a**3*b**6*c**7*s + 2*a**2*b**7*c**7*s -
        b**9*c**7*s - a**8*c**8*s + a**7*b*c**8*s + 2*a**6*b**2*c**8*s
        - a**5*b**3*c**8*s - a**4*b**4*c**8*s - a**3*b**5*c**8*s -
        a**2*b**6*c**8*s + 2*b**8*c**8*s - a**6*b*c**9*s +
        a**5*b**2*c**9*s + 2*a**4*b**3*c**9*s - a**2*b**5*c**9*s -
        b**7*c**9*s - a**4*b**2*c**10*s + a**2*b**4*c**10*s),
        (2*a**9*b**6*c**2 + 6*a**8*b**7*c**2 + 6*a**7*b**8*c**2 +
        2*a**6*b**9*c**2 + 9*a**9*b**5*c**3 + 37*a**8*b**6*c**3 +
        56*a**7*b**7*c**3 + 37*a**6*b**8*c**3 + 9*a**5*b**9*c**3 +
        13*a**9*b**4*c**4 + 79*a**8*b**5*c**4 + 172*a**7*b**6*c**4 +
        172*a**6*b**7*c**4 + 79*a**5*b**8*c**4 + 13*a**4*b**9*c**4 +
        7*a**9*b**3*c**5 + 76*a**8*b**4*c**5 + 245*a**7*b**5*c**5 +
        352*a**6*b**6*c**5 + 245*a**5*b**7*c**5 + 76*a**4*b**8*c**5 +
        7*a**3*b**9*c**5 + a**9*b**2*c**6 + 36*a**8*b**3*c**6 +
        187*a**7*b**4*c**6 + 388*a**6*b**5*c**6 + 388*a**5*b**6*c**6 +
        187*a**4*b**7*c**6 + 36*a**3*b**8*c**6 + a**2*b**9*c**6 +
        9*a**8*b**2*c**7 + 81*a**7*b**3*c**7 + 246*a**6*b**4*c**7 +
        348*a**5*b**5*c**7 + 246*a**4*b**6*c**7 + 81*a**3*b**7*c**7 +
        9*a**2*b**8*c**7 + a**8*b*c**8 + 18*a**7*b**2*c**8 +
        83*a**6*b**3*c**8 + 166*a**5*b**4*c**8 + 166*a**4*b**5*c**8 +
        83*a**3*b**6*c**8 + 18*a**2*b**7*c**8 + a*b**8*c**8 +
        a**7*b*c**9 + 10*a**6*b**2*c**9 + 31*a**5*b**3*c**9 +
        44*a**4*b**4*c**9 + 31*a**3*b**5*c**9 + 10*a**2*b**6*c**9 +
        a*b**7*c**9 + a**9*b**4*c**2*s**2 + 9*a**8*b**5*c**2*s**2 +
        22*a**7*b**6*c**2*s**2 + 22*a**6*b**7*c**2*s**2 +
        9*a**5*b**8*c**2*s**2 + a**4*b**9*c**2*s**2 +
        2*a**9*b**3*c**3*s**2 + 26*a**8*b**4*c**3*s**2 +
        89*a**7*b**5*c**3*s**2 + 130*a**6*b**6*c**3*s**2 +
        89*a**5*b**7*c**3*s**2 + 26*a**4*b**8*c**3*s**2 +
        2*a**3*b**9*c**3*s**2 + a**9*b**2*c**4*s**2 +
        25*a**8*b**3*c**4*s**2 + 130*a**7*b**4*c**4*s**2 +
        272*a**6*b**5*c**4*s**2 + 272*a**5*b**6*c**4*s**2 +
        130*a**4*b**7*c**4*s**2 + 25*a**3*b**8*c**4*s**2 +
        a**2*b**9*c**4*s**2 + 9*a**8*b**2*c**5*s**2 +
        90*a**7*b**3*c**5*s**2 + 282*a**6*b**4*c**5*s**2 +
        402*a**5*b**5*c**5*s**2 + 282*a**4*b**6*c**5*s**2 +
        90*a**3*b**7*c**5*s**2 + 9*a**2*b**8*c**5*s**2 +
        a**8*b*c**6*s**2 + 33*a**7*b**2*c**6*s**2 +
        164*a**6*b**3*c**6*s**2 + 334*a**5*b**4*c**6*s**2 +
        334*a**4*b**5*c**6*s**2 + 164*a**3*b**6*c**6*s**2 +
        33*a**2*b**7*c**6*s**2 + a*b**8*c**6*s**2 + 6*a**7*b*c**7*s**2
        + 53*a**6*b**2*c**7*s**2 + 157*a**5*b**3*c**7*s**2 +
        220*a**4*b**4*c**7*s**2 + 157*a**3*b**5*c**7*s**2 +
        53*a**2*b**6*c**7*s**2 + 6*a*b**7*c**7*s**2 +
        7*a**6*b*c**8*s**2 + 35*a**5*b**2*c**8*s**2 +
        70*a**4*b**3*c**8*s**2 + 70*a**3*b**4*c**8*s**2 +
        35*a**2*b**5*c**8*s**2 + 7*a*b**6*c**8*s**2 +
        2*a**5*b*c**9*s**2 + 7*a**4*b**2*c**9*s**2 +
        10*a**3*b**3*c**9*s**2 + 7*a**2*b**4*c**9*s**2 +
        2*a*b**5*c**9*s**2)/(a**9*b**7*s - 2*a**8*b**8*s + a**7*b**9*s
        - a**10*b**4*c**2*s + a**9*b**5*c**2*s + a**8*b**6*c**2*s -
        2*a**7*b**7*c**2*s + a**6*b**8*c**2*s + a**5*b**9*c**2*s -
        a**4*b**10*c**2*s + a**8*b**5*c**3*s - a**7*b**6*c**3*s -
        a**6*b**7*c**3*s + a**5*b**8*c**3*s + a**10*b**2*c**4*s -
        2*a**9*b**3*c**4*s + a**8*b**4*c**4*s + a**7*b**5*c**4*s -
        2*a**6*b**6*c**4*s + a**5*b**7*c**4*s + a**4*b**8*c**4*s -
        2*a**3*b**9*c**4*s + a**2*b**10*c**4*s - a**9*b**2*c**5*s +
        a**8*b**3*c**5*s + 2*a**7*b**4*c**5*s - 2*a**6*b**5*c**5*s -
        2*a**5*b**6*c**5*s + 2*a**4*b**7*c**5*s + a**3*b**8*c**5*s -
        a**2*b**9*c**5*s + a**9*b*c**6*s - 2*a**8*b**2*c**6*s +
        a**6*b**4*c**6*s + a**4*b**6*c**6*s - 2*a**2*b**8*c**6*s +
        a*b**9*c**6*s - a**8*b*c**7*s + a**7*b**2*c**7*s +
        3*a**6*b**3*c**7*s - 3*a**5*b**4*c**7*s - 3*a**4*b**5*c**7*s +
        3*a**3*b**6*c**7*s + a**2*b**7*c**7*s - a*b**8*c**7*s +
        a**8*c**8*s - a**7*b*c**8*s - a**6*b**2*c**8*s +
        a**5*b**3*c**8*s + a**3*b**5*c**8*s - a**2*b**6*c**8*s -
        a*b**7*c**8*s + b**8*c**8*s - a**7*c**9*s + a**6*b*c**9*s +
        2*a**5*b**2*c**9*s - 2*a**4*b**3*c**9*s - 2*a**3*b**4*c**9*s +
        2*a**2*b**5*c**9*s + a*b**6*c**9*s - b**7*c**9*s -
        a**5*b*c**10*s + a**4*b**2*c**10*s + a**2*b**4*c**10*s -
        a*b**5*c**10*s + a**4*b*c**11*s - a**3*b**2*c**11*s -
        a**2*b**3*c**11*s + a*b**4*c**11*s), (a**8*b**8*c +
        a**7*b**9*c + a**9*b**6*c**2 + 9*a**8*b**7*c**2 +
        18*a**7*b**8*c**2 + 10*a**6*b**9*c**2 + 7*a**9*b**5*c**3 +
        36*a**8*b**6*c**3 + 81*a**7*b**7*c**3 + 83*a**6*b**8*c**3 +
        31*a**5*b**9*c**3 + 13*a**9*b**4*c**4 + 76*a**8*b**5*c**4 +
        187*a**7*b**6*c**4 + 246*a**6*b**7*c**4 + 166*a**5*b**8*c**4 +
        44*a**4*b**9*c**4 + 9*a**9*b**3*c**5 + 79*a**8*b**4*c**5 +
        245*a**7*b**5*c**5 + 388*a**6*b**6*c**5 + 348*a**5*b**7*c**5 +
        166*a**4*b**8*c**5 + 31*a**3*b**9*c**5 + 2*a**9*b**2*c**6 +
        37*a**8*b**3*c**6 + 172*a**7*b**4*c**6 + 352*a**6*b**5*c**6 +
        388*a**5*b**6*c**6 + 246*a**4*b**7*c**6 + 83*a**3*b**8*c**6 +
        10*a**2*b**9*c**6 + 6*a**8*b**2*c**7 + 56*a**7*b**3*c**7 +
        172*a**6*b**4*c**7 + 245*a**5*b**5*c**7 + 187*a**4*b**6*c**7 +
        81*a**3*b**7*c**7 + 18*a**2*b**8*c**7 + a*b**9*c**7 +
        6*a**7*b**2*c**8 + 37*a**6*b**3*c**8 + 79*a**5*b**4*c**8 +
        76*a**4*b**5*c**8 + 36*a**3*b**6*c**8 + 9*a**2*b**7*c**8 +
        a*b**8*c**8 + 2*a**6*b**2*c**9 + 9*a**5*b**3*c**9 +
        13*a**4*b**4*c**9 + 7*a**3*b**5*c**9 + a**2*b**6*c**9 +
        a**8*b**6*c*s**2 + 6*a**7*b**7*c*s**2 + 7*a**6*b**8*c*s**2 +
        2*a**5*b**9*c*s**2 + a**9*b**4*c**2*s**2 +
        9*a**8*b**5*c**2*s**2 + 33*a**7*b**6*c**2*s**2 +
        53*a**6*b**7*c**2*s**2 + 35*a**5*b**8*c**2*s**2 +
        7*a**4*b**9*c**2*s**2 + 2*a**9*b**3*c**3*s**2 +
        25*a**8*b**4*c**3*s**2 + 90*a**7*b**5*c**3*s**2 +
        164*a**6*b**6*c**3*s**2 + 157*a**5*b**7*c**3*s**2 +
        70*a**4*b**8*c**3*s**2 + 10*a**3*b**9*c**3*s**2 +
        a**9*b**2*c**4*s**2 + 26*a**8*b**3*c**4*s**2 +
        130*a**7*b**4*c**4*s**2 + 282*a**6*b**5*c**4*s**2 +
        334*a**5*b**6*c**4*s**2 + 220*a**4*b**7*c**4*s**2 +
        70*a**3*b**8*c**4*s**2 + 7*a**2*b**9*c**4*s**2 +
        9*a**8*b**2*c**5*s**2 + 89*a**7*b**3*c**5*s**2 +
        272*a**6*b**4*c**5*s**2 + 402*a**5*b**5*c**5*s**2 +
        334*a**4*b**6*c**5*s**2 + 157*a**3*b**7*c**5*s**2 +
        35*a**2*b**8*c**5*s**2 + 2*a*b**9*c**5*s**2 +
        22*a**7*b**2*c**6*s**2 + 130*a**6*b**3*c**6*s**2 +
        272*a**5*b**4*c**6*s**2 + 282*a**4*b**5*c**6*s**2 +
        164*a**3*b**6*c**6*s**2 + 53*a**2*b**7*c**6*s**2 +
        7*a*b**8*c**6*s**2 + 22*a**6*b**2*c**7*s**2 +
        89*a**5*b**3*c**7*s**2 + 130*a**4*b**4*c**7*s**2 +
        90*a**3*b**5*c**7*s**2 + 33*a**2*b**6*c**7*s**2 +
        6*a*b**7*c**7*s**2 + 9*a**5*b**2*c**8*s**2 +
        26*a**4*b**3*c**8*s**2 + 25*a**3*b**4*c**8*s**2 +
        9*a**2*b**5*c**8*s**2 + a*b**6*c**8*s**2 + a**4*b**2*c**9*s**2
        + 2*a**3*b**3*c**9*s**2 + a**2*b**4*c**9*s**2)/(a**8*b**8*s -
        a**7*b**9*s + a**9*b**6*c*s - a**8*b**7*c*s - a**7*b**8*c*s +
        a**6*b**9*c*s - a**5*b**10*c*s + a**4*b**11*c*s +
        a**10*b**4*c**2*s - a**9*b**5*c**2*s - 2*a**8*b**6*c**2*s +
        a**7*b**7*c**2*s - a**6*b**8*c**2*s + 2*a**5*b**9*c**2*s +
        a**4*b**10*c**2*s - a**3*b**11*c**2*s - 2*a**9*b**4*c**3*s +
        a**8*b**5*c**3*s + 3*a**6*b**7*c**3*s + a**5*b**8*c**3*s -
        2*a**4*b**9*c**3*s - a**2*b**11*c**3*s - a**10*b**2*c**4*s +
        a**8*b**4*c**4*s + 2*a**7*b**5*c**4*s + a**6*b**6*c**4*s -
        3*a**5*b**7*c**4*s - 2*a**3*b**9*c**4*s + a**2*b**10*c**4*s +
        a*b**11*c**4*s + a**9*b**2*c**5*s + a**8*b**3*c**5*s +
        a**7*b**4*c**5*s - 2*a**6*b**5*c**5*s - 3*a**4*b**7*c**5*s +
        a**3*b**8*c**5*s + 2*a**2*b**9*c**5*s - a*b**10*c**5*s +
        a**8*b**2*c**6*s - a**7*b**3*c**6*s - 2*a**6*b**4*c**6*s -
        2*a**5*b**5*c**6*s + a**4*b**6*c**6*s + 3*a**3*b**7*c**6*s -
        a**2*b**8*c**6*s + a*b**9*c**6*s + a**9*c**7*s -
        2*a**7*b**2*c**7*s - a**6*b**3*c**7*s + a**5*b**4*c**7*s +
        2*a**4*b**5*c**7*s + a**2*b**7*c**7*s - a*b**8*c**7*s -
        b**9*c**7*s - 2*a**8*c**8*s + a**6*b**2*c**8*s +
        a**5*b**3*c**8*s + a**4*b**4*c**8*s + a**3*b**5*c**8*s -
        2*a**2*b**6*c**8*s - a*b**7*c**8*s + b**8*c**8*s + a**7*c**9*s
        + a**5*b**2*c**9*s - 2*a**3*b**4*c**9*s - a**2*b**5*c**9*s +
        a*b**6*c**9*s - a**4*b**2*c**10*s + a**2*b**4*c**10*s),
        ((-1/3*zeta3 - 2/3)*a**8*b**6*c + (-2/3*zeta3 -
        4/3)*a**7*b**7*c + (-1/3*zeta3 - 2/3)*a**6*b**8*c +
        (-8/3*zeta3 - 16/3)*a**8*b**5*c**2 + (-8*zeta3 -
        16)*a**7*b**6*c**2 + (-8*zeta3 - 16)*a**6*b**7*c**2 +
        (-8/3*zeta3 - 16/3)*a**5*b**8*c**2 + (-19/3*zeta3 -
        38/3)*a**8*b**4*c**3 + (-27*zeta3 - 54)*a**7*b**5*c**3 +
        (-124/3*zeta3 - 248/3)*a**6*b**6*c**3 + (-27*zeta3 -
        54)*a**5*b**7*c**3 + (-19/3*zeta3 - 38/3)*a**4*b**8*c**3 +
        (-19/3*zeta3 - 38/3)*a**8*b**3*c**4 + (-118/3*zeta3 -
        236/3)*a**7*b**4*c**4 + (-259/3*zeta3 - 518/3)*a**6*b**5*c**4
        + (-259/3*zeta3 - 518/3)*a**5*b**6*c**4 + (-118/3*zeta3 -
        236/3)*a**4*b**7*c**4 + (-19/3*zeta3 - 38/3)*a**3*b**8*c**4 +
        (-8/3*zeta3 - 16/3)*a**8*b**2*c**5 + (-27*zeta3 -
        54)*a**7*b**3*c**5 + (-259/3*zeta3 - 518/3)*a**6*b**4*c**5 +
        (-124*zeta3 - 248)*a**5*b**5*c**5 + (-259/3*zeta3 -
        518/3)*a**4*b**6*c**5 + (-27*zeta3 - 54)*a**3*b**7*c**5 +
        (-8/3*zeta3 - 16/3)*a**2*b**8*c**5 + (-1/3*zeta3 -
        2/3)*a**8*b*c**6 + (-8*zeta3 - 16)*a**7*b**2*c**6 +
        (-124/3*zeta3 - 248/3)*a**6*b**3*c**6 + (-259/3*zeta3 -
        518/3)*a**5*b**4*c**6 + (-259/3*zeta3 - 518/3)*a**4*b**5*c**6
        + (-124/3*zeta3 - 248/3)*a**3*b**6*c**6 + (-8*zeta3 -
        16)*a**2*b**7*c**6 + (-1/3*zeta3 - 2/3)*a*b**8*c**6 +
        (-2/3*zeta3 - 4/3)*a**7*b*c**7 + (-8*zeta3 -
        16)*a**6*b**2*c**7 + (-27*zeta3 - 54)*a**5*b**3*c**7 +
        (-118/3*zeta3 - 236/3)*a**4*b**4*c**7 + (-27*zeta3 -
        54)*a**3*b**5*c**7 + (-8*zeta3 - 16)*a**2*b**6*c**7 +
        (-2/3*zeta3 - 4/3)*a*b**7*c**7 + (-1/3*zeta3 -
        2/3)*a**6*b*c**8 + (-8/3*zeta3 - 16/3)*a**5*b**2*c**8 +
        (-19/3*zeta3 - 38/3)*a**4*b**3*c**8 + (-19/3*zeta3 -
        38/3)*a**3*b**4*c**8 + (-8/3*zeta3 - 16/3)*a**2*b**5*c**8 +
        (-1/3*zeta3 - 2/3)*a*b**6*c**8 + (-1/3*zeta3 -
        2/3)*a**8*b**4*c*s**2 + (-7/3*zeta3 - 14/3)*a**7*b**5*c*s**2 +
        (-4*zeta3 - 8)*a**6*b**6*c*s**2 + (-7/3*zeta3 -
        14/3)*a**5*b**7*c*s**2 + (-1/3*zeta3 - 2/3)*a**4*b**8*c*s**2 +
        (-zeta3 - 2)*a**8*b**3*c**2*s**2 + (-10*zeta3 -
        19)*a**7*b**4*c**2*s**2 + (-25*zeta3 - 47)*a**6*b**5*c**2*s**2
        + (-25*zeta3 - 47)*a**5*b**6*c**2*s**2 + (-10*zeta3 -
        19)*a**4*b**7*c**2*s**2 + (-zeta3 - 2)*a**3*b**8*c**2*s**2 +
        (-zeta3 - 2)*a**8*b**2*c**3*s**2 + (-46/3*zeta3 -
        86/3)*a**7*b**3*c**3*s**2 + (-55*zeta3 -
        101)*a**6*b**4*c**3*s**2 + (-244/3*zeta3 -
        446/3)*a**5*b**5*c**3*s**2 + (-55*zeta3 -
        101)*a**4*b**6*c**3*s**2 + (-46/3*zeta3 -
        86/3)*a**3*b**7*c**3*s**2 + (-zeta3 - 2)*a**2*b**8*c**3*s**2 +
        (-1/3*zeta3 - 2/3)*a**8*b*c**4*s**2 + (-10*zeta3 -
        19)*a**7*b**2*c**4*s**2 + (-55*zeta3 -
        101)*a**6*b**3*c**4*s**2 + (-352/3*zeta3 -
        638/3)*a**5*b**4*c**4*s**2 + (-352/3*zeta3 -
        638/3)*a**4*b**5*c**4*s**2 + (-55*zeta3 -
        101)*a**3*b**6*c**4*s**2 + (-10*zeta3 -
        19)*a**2*b**7*c**4*s**2 + (-1/3*zeta3 - 2/3)*a*b**8*c**4*s**2
        + (-7/3*zeta3 - 14/3)*a**7*b*c**5*s**2 + (-25*zeta3 -
        47)*a**6*b**2*c**5*s**2 + (-244/3*zeta3 -
        446/3)*a**5*b**3*c**5*s**2 + (-352/3*zeta3 -
        638/3)*a**4*b**4*c**5*s**2 + (-244/3*zeta3 -
        446/3)*a**3*b**5*c**5*s**2 + (-25*zeta3 -
        47)*a**2*b**6*c**5*s**2 + (-7/3*zeta3 - 14/3)*a*b**7*c**5*s**2
        + (-4*zeta3 - 8)*a**6*b*c**6*s**2 + (-25*zeta3 -
        47)*a**5*b**2*c**6*s**2 + (-55*zeta3 -
        101)*a**4*b**3*c**6*s**2 + (-55*zeta3 -
        101)*a**3*b**4*c**6*s**2 + (-25*zeta3 -
        47)*a**2*b**5*c**6*s**2 + (-4*zeta3 - 8)*a*b**6*c**6*s**2 +
        (-7/3*zeta3 - 14/3)*a**5*b*c**7*s**2 + (-10*zeta3 -
        19)*a**4*b**2*c**7*s**2 + (-46/3*zeta3 -
        86/3)*a**3*b**3*c**7*s**2 + (-10*zeta3 -
        19)*a**2*b**4*c**7*s**2 + (-7/3*zeta3 - 14/3)*a*b**5*c**7*s**2
        + (-1/3*zeta3 - 2/3)*a**4*b*c**8*s**2 + (-zeta3 -
        2)*a**3*b**2*c**8*s**2 + (-zeta3 - 2)*a**2*b**3*c**8*s**2 +
        (-1/3*zeta3 - 2/3)*a*b**4*c**8*s**2)/(a**8*b**6*s -
        a**7*b**7*s + a**6*b**8*s + (zeta3 + 1)*a**9*b**4*c*s +
        (-zeta3 - 1)*a**8*b**5*c*s + (zeta3 + 1)*a**7*b**6*c*s +
        (zeta3 + 1)*a**6*b**7*c*s + (-zeta3 - 1)*a**5*b**8*c*s +
        (zeta3 + 1)*a**4*b**9*c*s - a**7*b**5*c**2*s +
        a**6*b**6*c**2*s - a**5*b**7*c**2*s + (-zeta3 +
        1)*a**8*b**3*c**3*s + zeta3*a**7*b**4*c**3*s + (-zeta3 +
        1)*a**6*b**5*c**3*s + (-zeta3 + 1)*a**5*b**6*c**3*s +
        zeta3*a**4*b**7*c**3*s + (-zeta3 + 1)*a**3*b**8*c**3*s +
        (zeta3 + 1)*a**9*b*c**4*s + zeta3*a**7*b**3*c**4*s + (3*zeta3
        + 3)*a**6*b**4*c**4*s + (-zeta3 - 2)*a**5*b**5*c**4*s +
        (3*zeta3 + 3)*a**4*b**6*c**4*s + zeta3*a**3*b**7*c**4*s +
        (zeta3 + 1)*a*b**9*c**4*s + (-zeta3 - 1)*a**8*b*c**5*s -
        a**7*b**2*c**5*s + (-zeta3 + 1)*a**6*b**3*c**5*s + (-zeta3 -
        2)*a**5*b**4*c**5*s + (-zeta3 - 2)*a**4*b**5*c**5*s + (-zeta3
        + 1)*a**3*b**6*c**5*s - a**2*b**7*c**5*s + (-zeta3 -
        1)*a*b**8*c**5*s + a**8*c**6*s + (zeta3 + 1)*a**7*b*c**6*s +
        a**6*b**2*c**6*s + (-zeta3 + 1)*a**5*b**3*c**6*s + (3*zeta3 +
        3)*a**4*b**4*c**6*s + (-zeta3 + 1)*a**3*b**5*c**6*s +
        a**2*b**6*c**6*s + (zeta3 + 1)*a*b**7*c**6*s + b**8*c**6*s -
        a**7*c**7*s + (zeta3 + 1)*a**6*b*c**7*s - a**5*b**2*c**7*s +
        zeta3*a**4*b**3*c**7*s + zeta3*a**3*b**4*c**7*s -
        a**2*b**5*c**7*s + (zeta3 + 1)*a*b**6*c**7*s - b**7*c**7*s +
        a**6*c**8*s + (-zeta3 - 1)*a**5*b*c**8*s + (-zeta3 +
        1)*a**3*b**3*c**8*s + (-zeta3 - 1)*a*b**5*c**8*s + b**6*c**8*s
        + (zeta3 + 1)*a**4*b*c**9*s + (zeta3 + 1)*a*b**4*c**9*s),
        ((1/3*zeta3 - 1/3)*a**8*b**6*c + (2/3*zeta3 - 2/3)*a**7*b**7*c
        + (1/3*zeta3 - 1/3)*a**6*b**8*c + (8/3*zeta3 -
        8/3)*a**8*b**5*c**2 + (8*zeta3 - 8)*a**7*b**6*c**2 + (8*zeta3
        - 8)*a**6*b**7*c**2 + (8/3*zeta3 - 8/3)*a**5*b**8*c**2 +
        (19/3*zeta3 - 19/3)*a**8*b**4*c**3 + (27*zeta3 -
        27)*a**7*b**5*c**3 + (124/3*zeta3 - 124/3)*a**6*b**6*c**3 +
        (27*zeta3 - 27)*a**5*b**7*c**3 + (19/3*zeta3 -
        19/3)*a**4*b**8*c**3 + (19/3*zeta3 - 19/3)*a**8*b**3*c**4 +
        (118/3*zeta3 - 118/3)*a**7*b**4*c**4 + (259/3*zeta3 -
        259/3)*a**6*b**5*c**4 + (259/3*zeta3 - 259/3)*a**5*b**6*c**4 +
        (118/3*zeta3 - 118/3)*a**4*b**7*c**4 + (19/3*zeta3 -
        19/3)*a**3*b**8*c**4 + (8/3*zeta3 - 8/3)*a**8*b**2*c**5 +
        (27*zeta3 - 27)*a**7*b**3*c**5 + (259/3*zeta3 -
        259/3)*a**6*b**4*c**5 + (124*zeta3 - 124)*a**5*b**5*c**5 +
        (259/3*zeta3 - 259/3)*a**4*b**6*c**5 + (27*zeta3 -
        27)*a**3*b**7*c**5 + (8/3*zeta3 - 8/3)*a**2*b**8*c**5 +
        (1/3*zeta3 - 1/3)*a**8*b*c**6 + (8*zeta3 - 8)*a**7*b**2*c**6 +
        (124/3*zeta3 - 124/3)*a**6*b**3*c**6 + (259/3*zeta3 -
        259/3)*a**5*b**4*c**6 + (259/3*zeta3 - 259/3)*a**4*b**5*c**6 +
        (124/3*zeta3 - 124/3)*a**3*b**6*c**6 + (8*zeta3 -
        8)*a**2*b**7*c**6 + (1/3*zeta3 - 1/3)*a*b**8*c**6 + (2/3*zeta3
        - 2/3)*a**7*b*c**7 + (8*zeta3 - 8)*a**6*b**2*c**7 + (27*zeta3
        - 27)*a**5*b**3*c**7 + (118/3*zeta3 - 118/3)*a**4*b**4*c**7 +
        (27*zeta3 - 27)*a**3*b**5*c**7 + (8*zeta3 - 8)*a**2*b**6*c**7
        + (2/3*zeta3 - 2/3)*a*b**7*c**7 + (1/3*zeta3 -
        1/3)*a**6*b*c**8 + (8/3*zeta3 - 8/3)*a**5*b**2*c**8 +
        (19/3*zeta3 - 19/3)*a**4*b**3*c**8 + (19/3*zeta3 -
        19/3)*a**3*b**4*c**8 + (8/3*zeta3 - 8/3)*a**2*b**5*c**8 +
        (1/3*zeta3 - 1/3)*a*b**6*c**8 + (1/3*zeta3 -
        1/3)*a**8*b**4*c*s**2 + (7/3*zeta3 - 7/3)*a**7*b**5*c*s**2 +
        (4*zeta3 - 4)*a**6*b**6*c*s**2 + (7/3*zeta3 -
        7/3)*a**5*b**7*c*s**2 + (1/3*zeta3 - 1/3)*a**4*b**8*c*s**2 +
        (zeta3 - 1)*a**8*b**3*c**2*s**2 + (10*zeta3 -
        9)*a**7*b**4*c**2*s**2 + (25*zeta3 - 22)*a**6*b**5*c**2*s**2 +
        (25*zeta3 - 22)*a**5*b**6*c**2*s**2 + (10*zeta3 -
        9)*a**4*b**7*c**2*s**2 + (zeta3 - 1)*a**3*b**8*c**2*s**2 +
        (zeta3 - 1)*a**8*b**2*c**3*s**2 + (46/3*zeta3 -
        40/3)*a**7*b**3*c**3*s**2 + (55*zeta3 -
        46)*a**6*b**4*c**3*s**2 + (244/3*zeta3 -
        202/3)*a**5*b**5*c**3*s**2 + (55*zeta3 -
        46)*a**4*b**6*c**3*s**2 + (46/3*zeta3 -
        40/3)*a**3*b**7*c**3*s**2 + (zeta3 - 1)*a**2*b**8*c**3*s**2 +
        (1/3*zeta3 - 1/3)*a**8*b*c**4*s**2 + (10*zeta3 -
        9)*a**7*b**2*c**4*s**2 + (55*zeta3 - 46)*a**6*b**3*c**4*s**2 +
        (352/3*zeta3 - 286/3)*a**5*b**4*c**4*s**2 + (352/3*zeta3 -
        286/3)*a**4*b**5*c**4*s**2 + (55*zeta3 -
        46)*a**3*b**6*c**4*s**2 + (10*zeta3 - 9)*a**2*b**7*c**4*s**2 +
        (1/3*zeta3 - 1/3)*a*b**8*c**4*s**2 + (7/3*zeta3 -
        7/3)*a**7*b*c**5*s**2 + (25*zeta3 - 22)*a**6*b**2*c**5*s**2 +
        (244/3*zeta3 - 202/3)*a**5*b**3*c**5*s**2 + (352/3*zeta3 -
        286/3)*a**4*b**4*c**5*s**2 + (244/3*zeta3 -
        202/3)*a**3*b**5*c**5*s**2 + (25*zeta3 -
        22)*a**2*b**6*c**5*s**2 + (7/3*zeta3 - 7/3)*a*b**7*c**5*s**2 +
        (4*zeta3 - 4)*a**6*b*c**6*s**2 + (25*zeta3 -
        22)*a**5*b**2*c**6*s**2 + (55*zeta3 - 46)*a**4*b**3*c**6*s**2
        + (55*zeta3 - 46)*a**3*b**4*c**6*s**2 + (25*zeta3 -
        22)*a**2*b**5*c**6*s**2 + (4*zeta3 - 4)*a*b**6*c**6*s**2 +
        (7/3*zeta3 - 7/3)*a**5*b*c**7*s**2 + (10*zeta3 -
        9)*a**4*b**2*c**7*s**2 + (46/3*zeta3 -
        40/3)*a**3*b**3*c**7*s**2 + (10*zeta3 - 9)*a**2*b**4*c**7*s**2
        + (7/3*zeta3 - 7/3)*a*b**5*c**7*s**2 + (1/3*zeta3 -
        1/3)*a**4*b*c**8*s**2 + (zeta3 - 1)*a**3*b**2*c**8*s**2 +
        (zeta3 - 1)*a**2*b**3*c**8*s**2 + (1/3*zeta3 -
        1/3)*a*b**4*c**8*s**2)/(a**8*b**6*s - a**7*b**7*s +
        a**6*b**8*s + (-zeta3)*a**9*b**4*c*s + zeta3*a**8*b**5*c*s +
        (-zeta3)*a**7*b**6*c*s + (-zeta3)*a**6*b**7*c*s +
        zeta3*a**5*b**8*c*s + (-zeta3)*a**4*b**9*c*s -
        a**7*b**5*c**2*s + a**6*b**6*c**2*s - a**5*b**7*c**2*s +
        (zeta3 + 2)*a**8*b**3*c**3*s + (-zeta3 - 1)*a**7*b**4*c**3*s +
        (zeta3 + 2)*a**6*b**5*c**3*s + (zeta3 + 2)*a**5*b**6*c**3*s +
        (-zeta3 - 1)*a**4*b**7*c**3*s + (zeta3 + 2)*a**3*b**8*c**3*s +
        (-zeta3)*a**9*b*c**4*s + (-zeta3 - 1)*a**7*b**3*c**4*s +
        (-3*zeta3)*a**6*b**4*c**4*s + (zeta3 - 1)*a**5*b**5*c**4*s +
        (-3*zeta3)*a**4*b**6*c**4*s + (-zeta3 - 1)*a**3*b**7*c**4*s +
        (-zeta3)*a*b**9*c**4*s + zeta3*a**8*b*c**5*s -
        a**7*b**2*c**5*s + (zeta3 + 2)*a**6*b**3*c**5*s + (zeta3 -
        1)*a**5*b**4*c**5*s + (zeta3 - 1)*a**4*b**5*c**5*s + (zeta3 +
        2)*a**3*b**6*c**5*s - a**2*b**7*c**5*s + zeta3*a*b**8*c**5*s +
        a**8*c**6*s + (-zeta3)*a**7*b*c**6*s + a**6*b**2*c**6*s +
        (zeta3 + 2)*a**5*b**3*c**6*s + (-3*zeta3)*a**4*b**4*c**6*s +
        (zeta3 + 2)*a**3*b**5*c**6*s + a**2*b**6*c**6*s +
        (-zeta3)*a*b**7*c**6*s + b**8*c**6*s - a**7*c**7*s +
        (-zeta3)*a**6*b*c**7*s - a**5*b**2*c**7*s + (-zeta3 -
        1)*a**4*b**3*c**7*s + (-zeta3 - 1)*a**3*b**4*c**7*s -
        a**2*b**5*c**7*s + (-zeta3)*a*b**6*c**7*s - b**7*c**7*s +
        a**6*c**8*s + zeta3*a**5*b*c**8*s + (zeta3 +
        2)*a**3*b**3*c**8*s + zeta3*a*b**5*c**8*s + b**6*c**8*s +
        (-zeta3)*a**4*b*c**9*s + (-zeta3)*a*b**4*c**9*s)], 'U4':
        [(a**18*b**6 + 6*a**18*b**5*c + 3*a**17*b**6*c +
        2*a**16*b**7*c - a**15*b**8*c + 15*a**18*b**4*c**2 +
        15*a**17*b**5*c**2 + 15*a**16*b**6*c**2 - 2*a**15*b**7*c**2 -
        2*a**13*b**9*c**2 + 20*a**18*b**3*c**3 + 30*a**17*b**4*c**3 +
        42*a**16*b**5*c**3 + 5*a**15*b**6*c**3 + 4*a**14*b**7*c**3 -
        10*a**13*b**8*c**3 - a**12*b**9*c**3 - 2*a**11*b**10*c**3 +
        15*a**18*b**2*c**4 + 30*a**17*b**3*c**4 + 58*a**16*b**4*c**4 +
        18*a**15*b**5*c**4 + 16*a**14*b**6*c**4 - 21*a**13*b**7*c**4 -
        2*a**12*b**8*c**4 - 10*a**11*b**9*c**4 - a**9*b**11*c**4 +
        6*a**18*b*c**5 + 15*a**17*b**2*c**5 + 42*a**16*b**3*c**5 +
        18*a**15*b**4*c**5 + 24*a**14*b**5*c**5 - 27*a**13*b**6*c**5 +
        a**12*b**7*c**5 - 21*a**11*b**8*c**5 + 4*a**10*b**9*c**5 -
        2*a**9*b**10*c**5 + 2*a**8*b**11*c**5 + a**18*c**6 +
        3*a**17*b*c**6 + 15*a**16*b**2*c**6 + 5*a**15*b**3*c**6 +
        16*a**14*b**4*c**6 - 27*a**13*b**5*c**6 + 4*a**12*b**6*c**6 -
        27*a**11*b**7*c**6 + 16*a**10*b**8*c**6 + 5*a**9*b**9*c**6 +
        15*a**8*b**10*c**6 + 3*a**7*b**11*c**6 + a**6*b**12*c**6 +
        2*a**16*b*c**7 - 2*a**15*b**2*c**7 + 4*a**14*b**3*c**7 -
        21*a**13*b**4*c**7 + a**12*b**5*c**7 - 27*a**11*b**6*c**7 +
        24*a**10*b**7*c**7 + 18*a**9*b**8*c**7 + 42*a**8*b**9*c**7 +
        15*a**7*b**10*c**7 + 6*a**6*b**11*c**7 - a**15*b*c**8 -
        10*a**13*b**3*c**8 - 2*a**12*b**4*c**8 - 21*a**11*b**5*c**8 +
        16*a**10*b**6*c**8 + 18*a**9*b**7*c**8 + 58*a**8*b**8*c**8 +
        30*a**7*b**9*c**8 + 15*a**6*b**10*c**8 - 2*a**13*b**2*c**9 -
        a**12*b**3*c**9 - 10*a**11*b**4*c**9 + 4*a**10*b**5*c**9 +
        5*a**9*b**6*c**9 + 42*a**8*b**7*c**9 + 30*a**7*b**8*c**9 +
        20*a**6*b**9*c**9 - 2*a**11*b**3*c**10 - 2*a**9*b**5*c**10 +
        15*a**8*b**6*c**10 + 15*a**7*b**7*c**10 + 15*a**6*b**8*c**10 -
        a**9*b**4*c**11 + 2*a**8*b**5*c**11 + 3*a**7*b**6*c**11 +
        6*a**6*b**7*c**11 + a**6*b**6*c**12)/(a**24 - 3*a**23*b +
        5*a**22*b**2 - 6*a**21*b**3 + 5*a**20*b**4 - 3*a**19*b**5 +
        a**18*b**6 - 3*a**23*c + 11*a**22*b*c - 22*a**21*b**2*c +
        31*a**20*b**3*c - 32*a**19*b**4*c + 25*a**18*b**5*c -
        14*a**17*b**6*c + 5*a**16*b**7*c - a**15*b**8*c + 5*a**22*c**2
        - 22*a**21*b*c**2 + 51*a**20*b**2*c**2 - 82*a**19*b**3*c**2 +
        98*a**18*b**4*c**2 - 90*a**17*b**5*c**2 + 63*a**16*b**6*c**2 -
        32*a**15*b**7*c**2 + 11*a**14*b**8*c**2 - 2*a**13*b**9*c**2 -
        6*a**21*c**3 + 31*a**20*b*c**3 - 82*a**19*b**2*c**3 +
        148*a**18*b**3*c**3 - 199*a**17*b**4*c**3 +
        207*a**16*b**5*c**3 - 168*a**15*b**6*c**3 +
        104*a**14*b**7*c**3 - 47*a**13*b**8*c**3 + 14*a**12*b**9*c**3
        - 2*a**11*b**10*c**3 + 5*a**20*c**4 - 32*a**19*b*c**4 +
        98*a**18*b**2*c**4 - 199*a**17*b**3*c**4 + 299*a**16*b**4*c**4
        - 347*a**15*b**5*c**4 + 317*a**14*b**6*c**4 -
        226*a**13*b**7*c**4 + 122*a**12*b**8*c**4 - 47*a**11*b**9*c**4
        + 11*a**10*b**10*c**4 - a**9*b**11*c**4 - 3*a**19*c**5 +
        25*a**18*b*c**5 - 90*a**17*b**2*c**5 + 207*a**16*b**3*c**5 -
        347*a**15*b**4*c**5 + 447*a**14*b**5*c**5 -
        454*a**13*b**6*c**5 + 364*a**12*b**7*c**5 -
        226*a**11*b**8*c**5 + 104*a**10*b**9*c**5 - 32*a**9*b**10*c**5
        + 5*a**8*b**11*c**5 + a**18*c**6 - 14*a**17*b*c**6 +
        63*a**16*b**2*c**6 - 168*a**15*b**3*c**6 + 317*a**14*b**4*c**6
        - 454*a**13*b**5*c**6 + 510*a**12*b**6*c**6 -
        454*a**11*b**7*c**6 + 317*a**10*b**8*c**6 - 168*a**9*b**9*c**6
        + 63*a**8*b**10*c**6 - 14*a**7*b**11*c**6 + a**6*b**12*c**6 +
        5*a**16*b*c**7 - 32*a**15*b**2*c**7 + 104*a**14*b**3*c**7 -
        226*a**13*b**4*c**7 + 364*a**12*b**5*c**7 -
        454*a**11*b**6*c**7 + 447*a**10*b**7*c**7 - 347*a**9*b**8*c**7
        + 207*a**8*b**9*c**7 - 90*a**7*b**10*c**7 + 25*a**6*b**11*c**7
        - 3*a**5*b**12*c**7 - a**15*b*c**8 + 11*a**14*b**2*c**8 -
        47*a**13*b**3*c**8 + 122*a**12*b**4*c**8 - 226*a**11*b**5*c**8
        + 317*a**10*b**6*c**8 - 347*a**9*b**7*c**8 +
        299*a**8*b**8*c**8 - 199*a**7*b**9*c**8 + 98*a**6*b**10*c**8 -
        32*a**5*b**11*c**8 + 5*a**4*b**12*c**8 - 2*a**13*b**2*c**9 +
        14*a**12*b**3*c**9 - 47*a**11*b**4*c**9 + 104*a**10*b**5*c**9
        - 168*a**9*b**6*c**9 + 207*a**8*b**7*c**9 - 199*a**7*b**8*c**9
        + 148*a**6*b**9*c**9 - 82*a**5*b**10*c**9 + 31*a**4*b**11*c**9
        - 6*a**3*b**12*c**9 - 2*a**11*b**3*c**10 + 11*a**10*b**4*c**10
        - 32*a**9*b**5*c**10 + 63*a**8*b**6*c**10 - 90*a**7*b**7*c**10
        + 98*a**6*b**8*c**10 - 82*a**5*b**9*c**10 +
        51*a**4*b**10*c**10 - 22*a**3*b**11*c**10 + 5*a**2*b**12*c**10
        - a**9*b**4*c**11 + 5*a**8*b**5*c**11 - 14*a**7*b**6*c**11 +
        25*a**6*b**7*c**11 - 32*a**5*b**8*c**11 + 31*a**4*b**9*c**11 -
        22*a**3*b**10*c**11 + 11*a**2*b**11*c**11 - 3*a*b**12*c**11 +
        a**6*b**6*c**12 - 3*a**5*b**7*c**12 + 5*a**4*b**8*c**12 -
        6*a**3*b**9*c**12 + 5*a**2*b**10*c**12 - 3*a*b**11*c**12 +
        b**12*c**12), (a**12*b**6*c**6 + 6*a**11*b**7*c**6 +
        15*a**10*b**8*c**6 + 20*a**9*b**9*c**6 + 15*a**8*b**10*c**6 +
        6*a**7*b**11*c**6 + a**6*b**12*c**6 + 3*a**11*b**6*c**7 +
        15*a**10*b**7*c**7 + 30*a**9*b**8*c**7 + 30*a**8*b**9*c**7 +
        15*a**7*b**10*c**7 + 3*a**6*b**11*c**7 + 2*a**11*b**5*c**8 +
        15*a**10*b**6*c**8 + 42*a**9*b**7*c**8 + 58*a**8*b**8*c**8 +
        42*a**7*b**9*c**8 + 15*a**6*b**10*c**8 + 2*a**5*b**11*c**8 -
        a**11*b**4*c**9 - 2*a**10*b**5*c**9 + 5*a**9*b**6*c**9 +
        18*a**8*b**7*c**9 + 18*a**7*b**8*c**9 + 5*a**6*b**9*c**9 -
        2*a**5*b**10*c**9 - a**4*b**11*c**9 + 4*a**9*b**5*c**10 +
        16*a**8*b**6*c**10 + 24*a**7*b**7*c**10 + 16*a**6*b**8*c**10 +
        4*a**5*b**9*c**10 - 2*a**10*b**3*c**11 - 10*a**9*b**4*c**11 -
        21*a**8*b**5*c**11 - 27*a**7*b**6*c**11 - 27*a**6*b**7*c**11 -
        21*a**5*b**8*c**11 - 10*a**4*b**9*c**11 - 2*a**3*b**10*c**11 -
        a**9*b**3*c**12 - 2*a**8*b**4*c**12 + a**7*b**5*c**12 +
        4*a**6*b**6*c**12 + a**5*b**7*c**12 - 2*a**4*b**8*c**12 -
        a**3*b**9*c**12 - 2*a**9*b**2*c**13 - 10*a**8*b**3*c**13 -
        21*a**7*b**4*c**13 - 27*a**6*b**5*c**13 - 27*a**5*b**6*c**13 -
        21*a**4*b**7*c**13 - 10*a**3*b**8*c**13 - 2*a**2*b**9*c**13 +
        4*a**7*b**3*c**14 + 16*a**6*b**4*c**14 + 24*a**5*b**5*c**14 +
        16*a**4*b**6*c**14 + 4*a**3*b**7*c**14 - a**8*b*c**15 -
        2*a**7*b**2*c**15 + 5*a**6*b**3*c**15 + 18*a**5*b**4*c**15 +
        18*a**4*b**5*c**15 + 5*a**3*b**6*c**15 - 2*a**2*b**7*c**15 -
        a*b**8*c**15 + 2*a**7*b*c**16 + 15*a**6*b**2*c**16 +
        42*a**5*b**3*c**16 + 58*a**4*b**4*c**16 + 42*a**3*b**5*c**16 +
        15*a**2*b**6*c**16 + 2*a*b**7*c**16 + 3*a**6*b*c**17 +
        15*a**5*b**2*c**17 + 30*a**4*b**3*c**17 + 30*a**3*b**4*c**17 +
        15*a**2*b**5*c**17 + 3*a*b**6*c**17 + a**6*c**18 +
        6*a**5*b*c**18 + 15*a**4*b**2*c**18 + 20*a**3*b**3*c**18 +
        15*a**2*b**4*c**18 + 6*a*b**5*c**18 + b**6*c**18)/(a**12*b**12
        - 3*a**12*b**11*c - 3*a**11*b**12*c + 5*a**12*b**10*c**2 +
        11*a**11*b**11*c**2 + 5*a**10*b**12*c**2 - 6*a**12*b**9*c**3 -
        22*a**11*b**10*c**3 - 22*a**10*b**11*c**3 - 6*a**9*b**12*c**3
        + 5*a**12*b**8*c**4 + 31*a**11*b**9*c**4 + 51*a**10*b**10*c**4
        + 31*a**9*b**11*c**4 + 5*a**8*b**12*c**4 - 3*a**12*b**7*c**5 -
        32*a**11*b**8*c**5 - 82*a**10*b**9*c**5 - 82*a**9*b**10*c**5 -
        32*a**8*b**11*c**5 - 3*a**7*b**12*c**5 + a**12*b**6*c**6 +
        25*a**11*b**7*c**6 + 98*a**10*b**8*c**6 + 148*a**9*b**9*c**6 +
        98*a**8*b**10*c**6 + 25*a**7*b**11*c**6 + a**6*b**12*c**6 -
        14*a**11*b**6*c**7 - 90*a**10*b**7*c**7 - 199*a**9*b**8*c**7 -
        199*a**8*b**9*c**7 - 90*a**7*b**10*c**7 - 14*a**6*b**11*c**7 +
        5*a**11*b**5*c**8 + 63*a**10*b**6*c**8 + 207*a**9*b**7*c**8 +
        299*a**8*b**8*c**8 + 207*a**7*b**9*c**8 + 63*a**6*b**10*c**8 +
        5*a**5*b**11*c**8 - a**11*b**4*c**9 - 32*a**10*b**5*c**9 -
        168*a**9*b**6*c**9 - 347*a**8*b**7*c**9 - 347*a**7*b**8*c**9 -
        168*a**6*b**9*c**9 - 32*a**5*b**10*c**9 - a**4*b**11*c**9 +
        11*a**10*b**4*c**10 + 104*a**9*b**5*c**10 +
        317*a**8*b**6*c**10 + 447*a**7*b**7*c**10 +
        317*a**6*b**8*c**10 + 104*a**5*b**9*c**10 +
        11*a**4*b**10*c**10 - 2*a**10*b**3*c**11 - 47*a**9*b**4*c**11
        - 226*a**8*b**5*c**11 - 454*a**7*b**6*c**11 -
        454*a**6*b**7*c**11 - 226*a**5*b**8*c**11 - 47*a**4*b**9*c**11
        - 2*a**3*b**10*c**11 + 14*a**9*b**3*c**12 +
        122*a**8*b**4*c**12 + 364*a**7*b**5*c**12 +
        510*a**6*b**6*c**12 + 364*a**5*b**7*c**12 +
        122*a**4*b**8*c**12 + 14*a**3*b**9*c**12 - 2*a**9*b**2*c**13 -
        47*a**8*b**3*c**13 - 226*a**7*b**4*c**13 - 454*a**6*b**5*c**13
        - 454*a**5*b**6*c**13 - 226*a**4*b**7*c**13 -
        47*a**3*b**8*c**13 - 2*a**2*b**9*c**13 + 11*a**8*b**2*c**14 +
        104*a**7*b**3*c**14 + 317*a**6*b**4*c**14 +
        447*a**5*b**5*c**14 + 317*a**4*b**6*c**14 +
        104*a**3*b**7*c**14 + 11*a**2*b**8*c**14 - a**8*b*c**15 -
        32*a**7*b**2*c**15 - 168*a**6*b**3*c**15 - 347*a**5*b**4*c**15
        - 347*a**4*b**5*c**15 - 168*a**3*b**6*c**15 -
        32*a**2*b**7*c**15 - a*b**8*c**15 + 5*a**7*b*c**16 +
        63*a**6*b**2*c**16 + 207*a**5*b**3*c**16 + 299*a**4*b**4*c**16
        + 207*a**3*b**5*c**16 + 63*a**2*b**6*c**16 + 5*a*b**7*c**16 -
        14*a**6*b*c**17 - 90*a**5*b**2*c**17 - 199*a**4*b**3*c**17 -
        199*a**3*b**4*c**17 - 90*a**2*b**5*c**17 - 14*a*b**6*c**17 +
        a**6*c**18 + 25*a**5*b*c**18 + 98*a**4*b**2*c**18 +
        148*a**3*b**3*c**18 + 98*a**2*b**4*c**18 + 25*a*b**5*c**18 +
        b**6*c**18 - 3*a**5*c**19 - 32*a**4*b*c**19 -
        82*a**3*b**2*c**19 - 82*a**2*b**3*c**19 - 32*a*b**4*c**19 -
        3*b**5*c**19 + 5*a**4*c**20 + 31*a**3*b*c**20 +
        51*a**2*b**2*c**20 + 31*a*b**3*c**20 + 5*b**4*c**20 -
        6*a**3*c**21 - 22*a**2*b*c**21 - 22*a*b**2*c**21 -
        6*b**3*c**21 + 5*a**2*c**22 + 11*a*b*c**22 + 5*b**2*c**22 -
        3*a*c**23 - 3*b*c**23 + c**24), (a**6*b**18 - a**8*b**15*c +
        2*a**7*b**16*c + 3*a**6*b**17*c + 6*a**5*b**18*c -
        2*a**9*b**13*c**2 - 2*a**7*b**15*c**2 + 15*a**6*b**16*c**2 +
        15*a**5*b**17*c**2 + 15*a**4*b**18*c**2 - 2*a**10*b**11*c**3 -
        a**9*b**12*c**3 - 10*a**8*b**13*c**3 + 4*a**7*b**14*c**3 +
        5*a**6*b**15*c**3 + 42*a**5*b**16*c**3 + 30*a**4*b**17*c**3 +
        20*a**3*b**18*c**3 - a**11*b**9*c**4 - 10*a**9*b**11*c**4 -
        2*a**8*b**12*c**4 - 21*a**7*b**13*c**4 + 16*a**6*b**14*c**4 +
        18*a**5*b**15*c**4 + 58*a**4*b**16*c**4 + 30*a**3*b**17*c**4 +
        15*a**2*b**18*c**4 + 2*a**11*b**8*c**5 - 2*a**10*b**9*c**5 +
        4*a**9*b**10*c**5 - 21*a**8*b**11*c**5 + a**7*b**12*c**5 -
        27*a**6*b**13*c**5 + 24*a**5*b**14*c**5 + 18*a**4*b**15*c**5 +
        42*a**3*b**16*c**5 + 15*a**2*b**17*c**5 + 6*a*b**18*c**5 +
        a**12*b**6*c**6 + 3*a**11*b**7*c**6 + 15*a**10*b**8*c**6 +
        5*a**9*b**9*c**6 + 16*a**8*b**10*c**6 - 27*a**7*b**11*c**6 +
        4*a**6*b**12*c**6 - 27*a**5*b**13*c**6 + 16*a**4*b**14*c**6 +
        5*a**3*b**15*c**6 + 15*a**2*b**16*c**6 + 3*a*b**17*c**6 +
        b**18*c**6 + 6*a**11*b**6*c**7 + 15*a**10*b**7*c**7 +
        42*a**9*b**8*c**7 + 18*a**8*b**9*c**7 + 24*a**7*b**10*c**7 -
        27*a**6*b**11*c**7 + a**5*b**12*c**7 - 21*a**4*b**13*c**7 +
        4*a**3*b**14*c**7 - 2*a**2*b**15*c**7 + 2*a*b**16*c**7 +
        15*a**10*b**6*c**8 + 30*a**9*b**7*c**8 + 58*a**8*b**8*c**8 +
        18*a**7*b**9*c**8 + 16*a**6*b**10*c**8 - 21*a**5*b**11*c**8 -
        2*a**4*b**12*c**8 - 10*a**3*b**13*c**8 - a*b**15*c**8 +
        20*a**9*b**6*c**9 + 30*a**8*b**7*c**9 + 42*a**7*b**8*c**9 +
        5*a**6*b**9*c**9 + 4*a**5*b**10*c**9 - 10*a**4*b**11*c**9 -
        a**3*b**12*c**9 - 2*a**2*b**13*c**9 + 15*a**8*b**6*c**10 +
        15*a**7*b**7*c**10 + 15*a**6*b**8*c**10 - 2*a**5*b**9*c**10 -
        2*a**3*b**11*c**10 + 6*a**7*b**6*c**11 + 3*a**6*b**7*c**11 +
        2*a**5*b**8*c**11 - a**4*b**9*c**11 +
        a**6*b**6*c**12)/(a**6*b**18 - 3*a**5*b**19 + 5*a**4*b**20 -
        6*a**3*b**21 + 5*a**2*b**22 - 3*a*b**23 + b**24 - a**8*b**15*c
        + 5*a**7*b**16*c - 14*a**6*b**17*c + 25*a**5*b**18*c -
        32*a**4*b**19*c + 31*a**3*b**20*c - 22*a**2*b**21*c +
        11*a*b**22*c - 3*b**23*c - 2*a**9*b**13*c**2 +
        11*a**8*b**14*c**2 - 32*a**7*b**15*c**2 + 63*a**6*b**16*c**2 -
        90*a**5*b**17*c**2 + 98*a**4*b**18*c**2 - 82*a**3*b**19*c**2 +
        51*a**2*b**20*c**2 - 22*a*b**21*c**2 + 5*b**22*c**2 -
        2*a**10*b**11*c**3 + 14*a**9*b**12*c**3 - 47*a**8*b**13*c**3 +
        104*a**7*b**14*c**3 - 168*a**6*b**15*c**3 +
        207*a**5*b**16*c**3 - 199*a**4*b**17*c**3 +
        148*a**3*b**18*c**3 - 82*a**2*b**19*c**3 + 31*a*b**20*c**3 -
        6*b**21*c**3 - a**11*b**9*c**4 + 11*a**10*b**10*c**4 -
        47*a**9*b**11*c**4 + 122*a**8*b**12*c**4 - 226*a**7*b**13*c**4
        + 317*a**6*b**14*c**4 - 347*a**5*b**15*c**4 +
        299*a**4*b**16*c**4 - 199*a**3*b**17*c**4 + 98*a**2*b**18*c**4
        - 32*a*b**19*c**4 + 5*b**20*c**4 + 5*a**11*b**8*c**5 -
        32*a**10*b**9*c**5 + 104*a**9*b**10*c**5 - 226*a**8*b**11*c**5
        + 364*a**7*b**12*c**5 - 454*a**6*b**13*c**5 +
        447*a**5*b**14*c**5 - 347*a**4*b**15*c**5 +
        207*a**3*b**16*c**5 - 90*a**2*b**17*c**5 + 25*a*b**18*c**5 -
        3*b**19*c**5 + a**12*b**6*c**6 - 14*a**11*b**7*c**6 +
        63*a**10*b**8*c**6 - 168*a**9*b**9*c**6 + 317*a**8*b**10*c**6
        - 454*a**7*b**11*c**6 + 510*a**6*b**12*c**6 -
        454*a**5*b**13*c**6 + 317*a**4*b**14*c**6 -
        168*a**3*b**15*c**6 + 63*a**2*b**16*c**6 - 14*a*b**17*c**6 +
        b**18*c**6 - 3*a**12*b**5*c**7 + 25*a**11*b**6*c**7 -
        90*a**10*b**7*c**7 + 207*a**9*b**8*c**7 - 347*a**8*b**9*c**7 +
        447*a**7*b**10*c**7 - 454*a**6*b**11*c**7 +
        364*a**5*b**12*c**7 - 226*a**4*b**13*c**7 +
        104*a**3*b**14*c**7 - 32*a**2*b**15*c**7 + 5*a*b**16*c**7 +
        5*a**12*b**4*c**8 - 32*a**11*b**5*c**8 + 98*a**10*b**6*c**8 -
        199*a**9*b**7*c**8 + 299*a**8*b**8*c**8 - 347*a**7*b**9*c**8 +
        317*a**6*b**10*c**8 - 226*a**5*b**11*c**8 +
        122*a**4*b**12*c**8 - 47*a**3*b**13*c**8 + 11*a**2*b**14*c**8
        - a*b**15*c**8 - 6*a**12*b**3*c**9 + 31*a**11*b**4*c**9 -
        82*a**10*b**5*c**9 + 148*a**9*b**6*c**9 - 199*a**8*b**7*c**9 +
        207*a**7*b**8*c**9 - 168*a**6*b**9*c**9 + 104*a**5*b**10*c**9
        - 47*a**4*b**11*c**9 + 14*a**3*b**12*c**9 - 2*a**2*b**13*c**9
        + 5*a**12*b**2*c**10 - 22*a**11*b**3*c**10 +
        51*a**10*b**4*c**10 - 82*a**9*b**5*c**10 + 98*a**8*b**6*c**10
        - 90*a**7*b**7*c**10 + 63*a**6*b**8*c**10 - 32*a**5*b**9*c**10
        + 11*a**4*b**10*c**10 - 2*a**3*b**11*c**10 - 3*a**12*b*c**11 +
        11*a**11*b**2*c**11 - 22*a**10*b**3*c**11 + 31*a**9*b**4*c**11
        - 32*a**8*b**5*c**11 + 25*a**7*b**6*c**11 - 14*a**6*b**7*c**11
        + 5*a**5*b**8*c**11 - a**4*b**9*c**11 + a**12*c**12 -
        3*a**11*b*c**12 + 5*a**10*b**2*c**12 - 6*a**9*b**3*c**12 +
        5*a**8*b**4*c**12 - 3*a**7*b**5*c**12 + a**6*b**6*c**12),
        (a**10*b**2*c**2 + 4*a**9*b**3*c**2 + 5*a**8*b**4*c**2 +
        a**7*b**5*c**2 - 2*a**6*b**6*c**2 - a**5*b**7*c**2 +
        4*a**9*b**2*c**3 + 14*a**8*b**3*c**3 + 15*a**7*b**4*c**3 +
        2*a**6*b**5*c**3 - 5*a**5*b**6*c**3 - 2*a**4*b**7*c**3 +
        5*a**8*b**2*c**4 + 15*a**7*b**3*c**4 + 15*a**6*b**4*c**4 +
        6*a**5*b**5*c**4 + 2*a**4*b**6*c**4 + a**3*b**7*c**4 +
        a**7*b**2*c**5 + 2*a**6*b**3*c**5 + 6*a**5*b**4*c**5 +
        15*a**4*b**5*c**5 + 15*a**3*b**6*c**5 + 5*a**2*b**7*c**5 -
        2*a**6*b**2*c**6 - 5*a**5*b**3*c**6 + 2*a**4*b**4*c**6 +
        15*a**3*b**5*c**6 + 14*a**2*b**6*c**6 + 4*a*b**7*c**6 -
        a**5*b**2*c**7 - 2*a**4*b**3*c**7 + a**3*b**4*c**7 +
        5*a**2*b**5*c**7 + 4*a*b**6*c**7 + b**7*c**7)/(a**10*b**4 -
        2*a**9*b**5 + a**8*b**6 - 3*a**10*b**3*c + 4*a**9*b**4*c +
        3*a**8*b**5*c - 6*a**7*b**6*c + 2*a**6*b**7*c +
        4*a**10*b**2*c**2 - 2*a**9*b**3*c**2 - 13*a**8*b**4*c**2 +
        12*a**7*b**5*c**2 + 5*a**6*b**6*c**2 - 8*a**5*b**7*c**2 +
        2*a**4*b**8*c**2 - 3*a**10*b*c**3 - 2*a**9*b**2*c**3 +
        18*a**8*b**3*c**3 - 6*a**7*b**4*c**3 - 23*a**6*b**5*c**3 +
        16*a**5*b**6*c**3 + 5*a**4*b**7*c**3 - 6*a**3*b**8*c**3 +
        a**2*b**9*c**3 + a**10*c**4 + 4*a**9*b*c**4 -
        13*a**8*b**2*c**4 - 6*a**7*b**3*c**4 + 32*a**6*b**4*c**4 -
        8*a**5*b**5*c**4 - 23*a**4*b**6*c**4 + 12*a**3*b**7*c**4 +
        3*a**2*b**8*c**4 - 2*a*b**9*c**4 - 2*a**9*c**5 + 3*a**8*b*c**5
        + 12*a**7*b**2*c**5 - 23*a**6*b**3*c**5 - 8*a**5*b**4*c**5 +
        32*a**4*b**5*c**5 - 6*a**3*b**6*c**5 - 13*a**2*b**7*c**5 +
        4*a*b**8*c**5 + b**9*c**5 + a**8*c**6 - 6*a**7*b*c**6 +
        5*a**6*b**2*c**6 + 16*a**5*b**3*c**6 - 23*a**4*b**4*c**6 -
        6*a**3*b**5*c**6 + 18*a**2*b**6*c**6 - 2*a*b**7*c**6 -
        3*b**8*c**6 + 2*a**6*b*c**7 - 8*a**5*b**2*c**7 +
        5*a**4*b**3*c**7 + 12*a**3*b**4*c**7 - 13*a**2*b**5*c**7 -
        2*a*b**6*c**7 + 4*b**7*c**7 + 2*a**4*b**2*c**8 -
        6*a**3*b**3*c**8 + 3*a**2*b**4*c**8 + 4*a*b**5*c**8 -
        3*b**6*c**8 + a**2*b**3*c**9 - 2*a*b**4*c**9 + b**5*c**9),
        (a**7*b**7 + 4*a**7*b**6*c + 4*a**6*b**7*c + 5*a**7*b**5*c**2
        + 14*a**6*b**6*c**2 + 5*a**5*b**7*c**2 + a**7*b**4*c**3 +
        15*a**6*b**5*c**3 + 15*a**5*b**6*c**3 + a**4*b**7*c**3 -
        2*a**7*b**3*c**4 + 2*a**6*b**4*c**4 + 15*a**5*b**5*c**4 +
        2*a**4*b**6*c**4 - 2*a**3*b**7*c**4 - a**7*b**2*c**5 -
        5*a**6*b**3*c**5 + 6*a**5*b**4*c**5 + 6*a**4*b**5*c**5 -
        5*a**3*b**6*c**5 - a**2*b**7*c**5 - 2*a**6*b**2*c**6 +
        2*a**5*b**3*c**6 + 15*a**4*b**4*c**6 + 2*a**3*b**5*c**6 -
        2*a**2*b**6*c**6 + a**5*b**2*c**7 + 15*a**4*b**3*c**7 +
        15*a**3*b**4*c**7 + a**2*b**5*c**7 + 5*a**4*b**2*c**8 +
        14*a**3*b**3*c**8 + 5*a**2*b**4*c**8 + 4*a**3*b**2*c**9 +
        4*a**2*b**3*c**9 + a**2*b**2*c**10)/(a**9*b**5 - 3*a**8*b**6 +
        4*a**7*b**7 - 3*a**6*b**8 + a**5*b**9 - 2*a**9*b**4*c +
        4*a**8*b**5*c - 2*a**7*b**6*c - 2*a**6*b**7*c + 4*a**5*b**8*c
        - 2*a**4*b**9*c + a**9*b**3*c**2 + 3*a**8*b**4*c**2 -
        13*a**7*b**5*c**2 + 18*a**6*b**6*c**2 - 13*a**5*b**7*c**2 +
        3*a**4*b**8*c**2 + a**3*b**9*c**2 - 6*a**8*b**3*c**3 +
        12*a**7*b**4*c**3 - 6*a**6*b**5*c**3 - 6*a**5*b**6*c**3 +
        12*a**4*b**7*c**3 - 6*a**3*b**8*c**3 + 2*a**8*b**2*c**4 +
        5*a**7*b**3*c**4 - 23*a**6*b**4*c**4 + 32*a**5*b**5*c**4 -
        23*a**4*b**6*c**4 + 5*a**3*b**7*c**4 + 2*a**2*b**8*c**4 -
        8*a**7*b**2*c**5 + 16*a**6*b**3*c**5 - 8*a**5*b**4*c**5 -
        8*a**4*b**5*c**5 + 16*a**3*b**6*c**5 - 8*a**2*b**7*c**5 +
        2*a**7*b*c**6 + 5*a**6*b**2*c**6 - 23*a**5*b**3*c**6 +
        32*a**4*b**4*c**6 - 23*a**3*b**5*c**6 + 5*a**2*b**6*c**6 +
        2*a*b**7*c**6 - 6*a**6*b*c**7 + 12*a**5*b**2*c**7 -
        6*a**4*b**3*c**7 - 6*a**3*b**4*c**7 + 12*a**2*b**5*c**7 -
        6*a*b**6*c**7 + a**6*c**8 + 3*a**5*b*c**8 - 13*a**4*b**2*c**8
        + 18*a**3*b**3*c**8 - 13*a**2*b**4*c**8 + 3*a*b**5*c**8 +
        b**6*c**8 - 2*a**5*c**9 + 4*a**4*b*c**9 - 2*a**3*b**2*c**9 -
        2*a**2*b**3*c**9 + 4*a*b**4*c**9 - 2*b**5*c**9 + a**4*c**10 -
        3*a**3*b*c**10 + 4*a**2*b**2*c**10 - 3*a*b**3*c**10 +
        b**4*c**10), (-a**7*b**5*c**2 - 2*a**6*b**6*c**2 +
        a**5*b**7*c**2 + 5*a**4*b**8*c**2 + 4*a**3*b**9*c**2 +
        a**2*b**10*c**2 - 2*a**7*b**4*c**3 - 5*a**6*b**5*c**3 +
        2*a**5*b**6*c**3 + 15*a**4*b**7*c**3 + 14*a**3*b**8*c**3 +
        4*a**2*b**9*c**3 + a**7*b**3*c**4 + 2*a**6*b**4*c**4 +
        6*a**5*b**5*c**4 + 15*a**4*b**6*c**4 + 15*a**3*b**7*c**4 +
        5*a**2*b**8*c**4 + 5*a**7*b**2*c**5 + 15*a**6*b**3*c**5 +
        15*a**5*b**4*c**5 + 6*a**4*b**5*c**5 + 2*a**3*b**6*c**5 +
        a**2*b**7*c**5 + 4*a**7*b*c**6 + 14*a**6*b**2*c**6 +
        15*a**5*b**3*c**6 + 2*a**4*b**4*c**6 - 5*a**3*b**5*c**6 -
        2*a**2*b**6*c**6 + a**7*c**7 + 4*a**6*b*c**7 +
        5*a**5*b**2*c**7 + a**4*b**3*c**7 - 2*a**3*b**4*c**7 -
        a**2*b**5*c**7)/(a**6*b**8 - 2*a**5*b**9 + a**4*b**10 +
        2*a**7*b**6*c - 6*a**6*b**7*c + 3*a**5*b**8*c + 4*a**4*b**9*c
        - 3*a**3*b**10*c + 2*a**8*b**4*c**2 - 8*a**7*b**5*c**2 +
        5*a**6*b**6*c**2 + 12*a**5*b**7*c**2 - 13*a**4*b**8*c**2 -
        2*a**3*b**9*c**2 + 4*a**2*b**10*c**2 + a**9*b**2*c**3 -
        6*a**8*b**3*c**3 + 5*a**7*b**4*c**3 + 16*a**6*b**5*c**3 -
        23*a**5*b**6*c**3 - 6*a**4*b**7*c**3 + 18*a**3*b**8*c**3 -
        2*a**2*b**9*c**3 - 3*a*b**10*c**3 - 2*a**9*b*c**4 +
        3*a**8*b**2*c**4 + 12*a**7*b**3*c**4 - 23*a**6*b**4*c**4 -
        8*a**5*b**5*c**4 + 32*a**4*b**6*c**4 - 6*a**3*b**7*c**4 -
        13*a**2*b**8*c**4 + 4*a*b**9*c**4 + b**10*c**4 + a**9*c**5 +
        4*a**8*b*c**5 - 13*a**7*b**2*c**5 - 6*a**6*b**3*c**5 +
        32*a**5*b**4*c**5 - 8*a**4*b**5*c**5 - 23*a**3*b**6*c**5 +
        12*a**2*b**7*c**5 + 3*a*b**8*c**5 - 2*b**9*c**5 - 3*a**8*c**6
        - 2*a**7*b*c**6 + 18*a**6*b**2*c**6 - 6*a**5*b**3*c**6 -
        23*a**4*b**4*c**6 + 16*a**3*b**5*c**6 + 5*a**2*b**6*c**6 -
        6*a*b**7*c**6 + b**8*c**6 + 4*a**7*c**7 - 2*a**6*b*c**7 -
        13*a**5*b**2*c**7 + 12*a**4*b**3*c**7 + 5*a**3*b**4*c**7 -
        8*a**2*b**5*c**7 + 2*a*b**6*c**7 - 3*a**6*c**8 + 4*a**5*b*c**8
        + 3*a**4*b**2*c**8 - 6*a**3*b**3*c**8 + 2*a**2*b**4*c**8 +
        a**5*c**9 - 2*a**4*b*c**9 + a**3*b**2*c**9), (-a**7*b**4*c -
        3*a**6*b**5*c - 3*a**5*b**6*c - a**4*b**7*c - 3*a**7*b**3*c**2
        - 14*a**6*b**4*c**2 - 22*a**5*b**5*c**2 - 14*a**4*b**6*c**2 -
        3*a**3*b**7*c**2 - 3*a**7*b**2*c**3 - 22*a**6*b**3*c**3 -
        51*a**5*b**4*c**3 - 51*a**4*b**5*c**3 - 22*a**3*b**6*c**3 -
        3*a**2*b**7*c**3 - a**7*b*c**4 - 14*a**6*b**2*c**4 -
        51*a**5*b**3*c**4 - 76*a**4*b**4*c**4 - 51*a**3*b**5*c**4 -
        14*a**2*b**6*c**4 - a*b**7*c**4 - 3*a**6*b*c**5 -
        22*a**5*b**2*c**5 - 51*a**4*b**3*c**5 - 51*a**3*b**4*c**5 -
        22*a**2*b**5*c**5 - 3*a*b**6*c**5 - 3*a**5*b*c**6 -
        14*a**4*b**2*c**6 - 22*a**3*b**3*c**6 - 14*a**2*b**4*c**6 -
        3*a*b**5*c**6 - a**4*b*c**7 - 3*a**3*b**2*c**7 -
        3*a**2*b**3*c**7 - a*b**4*c**7)/(a**7*b**5 - 2*a**6*b**6 +
        a**5*b**7 + a**8*b**3*c - 4*a**7*b**4*c + 3*a**6*b**5*c +
        3*a**5*b**6*c - 4*a**4*b**7*c + a**3*b**8*c - 2*a**8*b**2*c**2
        + 3*a**7*b**3*c**2 + 6*a**6*b**4*c**2 - 14*a**5*b**5*c**2 +
        6*a**4*b**6*c**2 + 3*a**3*b**7*c**2 - 2*a**2*b**8*c**2 +
        a**8*b*c**3 + 3*a**7*b**2*c**3 - 14*a**6*b**3*c**3 +
        10*a**5*b**4*c**3 + 10*a**4*b**5*c**3 - 14*a**3*b**6*c**3 +
        3*a**2*b**7*c**3 + a*b**8*c**3 - 4*a**7*b*c**4 +
        6*a**6*b**2*c**4 + 10*a**5*b**3*c**4 - 24*a**4*b**4*c**4 +
        10*a**3*b**5*c**4 + 6*a**2*b**6*c**4 - 4*a*b**7*c**4 +
        a**7*c**5 + 3*a**6*b*c**5 - 14*a**5*b**2*c**5 +
        10*a**4*b**3*c**5 + 10*a**3*b**4*c**5 - 14*a**2*b**5*c**5 +
        3*a*b**6*c**5 + b**7*c**5 - 2*a**6*c**6 + 3*a**5*b*c**6 +
        6*a**4*b**2*c**6 - 14*a**3*b**3*c**6 + 6*a**2*b**4*c**6 +
        3*a*b**5*c**6 - 2*b**6*c**6 + a**5*c**7 - 4*a**4*b*c**7 +
        3*a**3*b**2*c**7 + 3*a**2*b**3*c**7 - 4*a*b**4*c**7 +
        b**5*c**7 + a**3*b*c**8 - 2*a**2*b**2*c**8 + a*b**3*c**8),
        (-a**6*b**10 - a**7*b**8*c - 3*a**6*b**9*c - 5*a**5*b**10*c -
        2*a**7*b**7*c**2 - 7*a**6*b**8*c**2 - 13*a**5*b**9*c**2 -
        10*a**4*b**10*c**2 - 8*a**6*b**7*c**3 - 16*a**5*b**8*c**3 -
        22*a**4*b**9*c**3 - 10*a**3*b**10*c**3 + a**7*b**5*c**4 +
        a**6*b**6*c**4 - 11*a**5*b**7*c**4 - 15*a**4*b**8*c**4 -
        18*a**3*b**9*c**4 - 5*a**2*b**10*c**4 - a**7*b**4*c**5 +
        2*a**6*b**5*c**5 + a**5*b**6*c**5 - 5*a**4*b**7*c**5 -
        4*a**3*b**8*c**5 - 7*a**2*b**9*c**5 - a*b**10*c**5 -
        a**7*b**3*c**6 - 7*a**6*b**4*c**6 - 4*a**5*b**5*c**6 -
        5*a**4*b**6*c**6 + a**3*b**7*c**6 + 2*a**2*b**8*c**6 -
        a*b**9*c**6 - 5*a**6*b**3*c**7 - 18*a**5*b**4*c**7 -
        15*a**4*b**5*c**7 - 11*a**3*b**6*c**7 + a**2*b**7*c**7 +
        a*b**8*c**7 - 10*a**5*b**3*c**8 - 22*a**4*b**4*c**8 -
        16*a**3*b**5*c**8 - 8*a**2*b**6*c**8 - 10*a**4*b**3*c**9 -
        13*a**3*b**4*c**9 - 7*a**2*b**5*c**9 - 2*a*b**6*c**9 -
        5*a**3*b**3*c**10 - 3*a**2*b**4*c**10 - a*b**5*c**10 -
        a**2*b**3*c**11)/(a**7*b**9 - 2*a**6*b**10 + 2*a**5*b**11 -
        2*a**4*b**12 + a**3*b**13 + a**8*b**7*c - 5*a**7*b**8*c +
        7*a**6*b**9*c - 6*a**5*b**10*c + 5*a**4*b**11*c - a**3*b**12*c
        - a**2*b**13*c - 3*a**8*b**6*c**2 + 9*a**7*b**7*c**2 -
        8*a**6*b**8*c**2 + 4*a**5*b**9*c**2 - a**4*b**10*c**2 -
        5*a**3*b**11*c**2 + 4*a**2*b**12*c**2 + 4*a**8*b**5*c**3 -
        7*a**7*b**6*c**3 - 2*a**6*b**7*c**3 + 9*a**5*b**8*c**3 -
        12*a**4*b**9*c**3 + 15*a**3*b**10*c**3 - 6*a**2*b**11*c**3 -
        a*b**12*c**3 - 3*a**8*b**4*c**4 - a**7*b**5*c**4 +
        17*a**6*b**6*c**4 - 22*a**5*b**7*c**4 + 21*a**4*b**8*c**4 -
        17*a**3*b**9*c**4 + a**2*b**10*c**4 + 4*a*b**11*c**4 +
        a**8*b**3*c**5 + 8*a**7*b**4*c**5 - 22*a**6*b**5*c**5 +
        18*a**5*b**6*c**5 - 11*a**4*b**7*c**5 + 2*a**3*b**8*c**5 +
        12*a**2*b**9*c**5 - 8*a*b**10*c**5 - 8*a**7*b**3*c**6 +
        12*a**6*b**4*c**6 + 2*a**5*b**5*c**6 - 11*a**4*b**6*c**6 +
        18*a**3*b**7*c**6 - 22*a**2*b**8*c**6 + 8*a*b**9*c**6 +
        b**10*c**6 + 4*a**7*b**2*c**7 + a**6*b**3*c**7 -
        17*a**5*b**4*c**7 + 21*a**4*b**5*c**7 - 22*a**3*b**6*c**7 +
        17*a**2*b**7*c**7 - a*b**8*c**7 - 3*b**9*c**7 - a**7*b*c**8 -
        6*a**6*b**2*c**8 + 15*a**5*b**3*c**8 - 12*a**4*b**4*c**8 +
        9*a**3*b**5*c**8 - 2*a**2*b**6*c**8 - 7*a*b**7*c**8 +
        4*b**8*c**8 + 4*a**6*b*c**9 - 5*a**5*b**2*c**9 -
        a**4*b**3*c**9 + 4*a**3*b**4*c**9 - 8*a**2*b**5*c**9 +
        9*a*b**6*c**9 - 3*b**7*c**9 - a**6*c**10 - a**5*b*c**10 +
        5*a**4*b**2*c**10 - 6*a**3*b**3*c**10 + 7*a**2*b**4*c**10 -
        5*a*b**5*c**10 + b**6*c**10 + a**5*c**11 - 2*a**4*b*c**11 +
        2*a**3*b**2*c**11 - 2*a**2*b**3*c**11 + a*b**4*c**11),
        (-a**10*b**5*c - a**9*b**6*c + a**8*b**7*c - 2*a**6*b**9*c -
        a**5*b**10*c - 5*a**10*b**4*c**2 - 7*a**9*b**5*c**2 +
        2*a**8*b**6*c**2 + a**7*b**7*c**2 - 8*a**6*b**8*c**2 -
        7*a**5*b**9*c**2 - 3*a**4*b**10*c**2 - a**3*b**11*c**2 -
        10*a**10*b**3*c**3 - 18*a**9*b**4*c**3 - 4*a**8*b**5*c**3 +
        a**7*b**6*c**3 - 11*a**6*b**7*c**3 - 16*a**5*b**8*c**3 -
        13*a**4*b**9*c**3 - 5*a**3*b**10*c**3 - 10*a**10*b**2*c**4 -
        22*a**9*b**3*c**4 - 15*a**8*b**4*c**4 - 5*a**7*b**5*c**4 -
        5*a**6*b**6*c**4 - 15*a**5*b**7*c**4 - 22*a**4*b**8*c**4 -
        10*a**3*b**9*c**4 - 5*a**10*b*c**5 - 13*a**9*b**2*c**5 -
        16*a**8*b**3*c**5 - 11*a**7*b**4*c**5 + a**6*b**5*c**5 -
        4*a**5*b**6*c**5 - 18*a**4*b**7*c**5 - 10*a**3*b**8*c**5 -
        a**10*c**6 - 3*a**9*b*c**6 - 7*a**8*b**2*c**6 -
        8*a**7*b**3*c**6 + a**6*b**4*c**6 + 2*a**5*b**5*c**6 -
        7*a**4*b**6*c**6 - 5*a**3*b**7*c**6 - a**8*b*c**7 -
        2*a**7*b**2*c**7 + a**5*b**4*c**7 - a**4*b**5*c**7 -
        a**3*b**6*c**7)/(a**10*b**6 - 3*a**9*b**7 + 4*a**8*b**8 -
        3*a**7*b**9 + a**6*b**10 - a**12*b**3*c + 4*a**11*b**4*c -
        8*a**10*b**5*c + 8*a**9*b**6*c - a**8*b**7*c - 7*a**7*b**8*c +
        9*a**6*b**9*c - 5*a**5*b**10*c + a**4*b**11*c - a**13*b*c**2 +
        4*a**12*b**2*c**2 - 6*a**11*b**3*c**2 + a**10*b**4*c**2 +
        12*a**9*b**5*c**2 - 22*a**8*b**6*c**2 + 17*a**7*b**7*c**2 -
        2*a**6*b**8*c**2 - 8*a**5*b**9*c**2 + 7*a**4*b**10*c**2 -
        2*a**3*b**11*c**2 + a**13*c**3 - a**12*b*c**3 -
        5*a**11*b**2*c**3 + 15*a**10*b**3*c**3 - 17*a**9*b**4*c**3 +
        2*a**8*b**5*c**3 + 18*a**7*b**6*c**3 - 22*a**6*b**7*c**3 +
        9*a**5*b**8*c**3 + 4*a**4*b**9*c**3 - 6*a**3*b**10*c**3 +
        2*a**2*b**11*c**3 - 2*a**12*c**4 + 5*a**11*b*c**4 -
        a**10*b**2*c**4 - 12*a**9*b**3*c**4 + 21*a**8*b**4*c**4 -
        11*a**7*b**5*c**4 - 11*a**6*b**6*c**4 + 21*a**5*b**7*c**4 -
        12*a**4*b**8*c**4 - a**3*b**9*c**4 + 5*a**2*b**10*c**4 -
        2*a*b**11*c**4 + 2*a**11*c**5 - 6*a**10*b*c**5 +
        4*a**9*b**2*c**5 + 9*a**8*b**3*c**5 - 22*a**7*b**4*c**5 +
        18*a**6*b**5*c**5 + 2*a**5*b**6*c**5 - 17*a**4*b**7*c**5 +
        15*a**3*b**8*c**5 - 5*a**2*b**9*c**5 - a*b**10*c**5 +
        b**11*c**5 - 2*a**10*c**6 + 7*a**9*b*c**6 - 8*a**8*b**2*c**6 -
        2*a**7*b**3*c**6 + 17*a**6*b**4*c**6 - 22*a**5*b**5*c**6 +
        12*a**4*b**6*c**6 + a**3*b**7*c**6 - 6*a**2*b**8*c**6 +
        4*a*b**9*c**6 - b**10*c**6 + a**9*c**7 - 5*a**8*b*c**7 +
        9*a**7*b**2*c**7 - 7*a**6*b**3*c**7 - a**5*b**4*c**7 +
        8*a**4*b**5*c**7 - 8*a**3*b**6*c**7 + 4*a**2*b**7*c**7 -
        a*b**8*c**7 + a**7*b*c**8 - 3*a**6*b**2*c**8 +
        4*a**5*b**3*c**8 - 3*a**4*b**4*c**8 + a**3*b**5*c**8),
        (-a**11*b**2*c**3 - 5*a**10*b**3*c**3 - 10*a**9*b**4*c**3 -
        10*a**8*b**5*c**3 - 5*a**7*b**6*c**3 - a**6*b**7*c**3 -
        3*a**10*b**2*c**4 - 13*a**9*b**3*c**4 - 22*a**8*b**4*c**4 -
        18*a**7*b**5*c**4 - 7*a**6*b**6*c**4 - a**5*b**7*c**4 -
        a**10*b*c**5 - 7*a**9*b**2*c**5 - 16*a**8*b**3*c**5 -
        15*a**7*b**4*c**5 - 4*a**6*b**5*c**5 + 2*a**5*b**6*c**5 +
        a**4*b**7*c**5 - 2*a**9*b*c**6 - 8*a**8*b**2*c**6 -
        11*a**7*b**3*c**6 - 5*a**6*b**4*c**6 + a**5*b**5*c**6 +
        a**4*b**6*c**6 + a**7*b**2*c**7 + a**6*b**3*c**7 -
        5*a**5*b**4*c**7 - 11*a**4*b**5*c**7 - 8*a**3*b**6*c**7 -
        2*a**2*b**7*c**7 + a**7*b*c**8 + 2*a**6*b**2*c**8 -
        4*a**5*b**3*c**8 - 15*a**4*b**4*c**8 - 16*a**3*b**5*c**8 -
        7*a**2*b**6*c**8 - a*b**7*c**8 - a**6*b*c**9 -
        7*a**5*b**2*c**9 - 18*a**4*b**3*c**9 - 22*a**3*b**4*c**9 -
        13*a**2*b**5*c**9 - 3*a*b**6*c**9 - a**5*b*c**10 -
        5*a**4*b**2*c**10 - 10*a**3*b**3*c**10 - 10*a**2*b**4*c**10 -
        5*a*b**5*c**10 - b**6*c**10)/(a**11*b**5 - a**10*b**6 -
        2*a**11*b**4*c - a**10*b**5*c + 4*a**9*b**6*c - a**8*b**7*c +
        2*a**11*b**3*c**2 + 5*a**10*b**4*c**2 - 5*a**9*b**5*c**2 -
        6*a**8*b**6*c**2 + 4*a**7*b**7*c**2 - 2*a**11*b**2*c**3 -
        6*a**10*b**3*c**3 - a**9*b**4*c**3 + 15*a**8*b**5*c**3 +
        a**7*b**6*c**3 - 8*a**6*b**7*c**3 + a**5*b**8*c**3 +
        a**11*b*c**4 + 7*a**10*b**2*c**4 + 4*a**9*b**3*c**4 -
        12*a**8*b**4*c**4 - 17*a**7*b**5*c**4 + 12*a**6*b**6*c**4 +
        8*a**5*b**7*c**4 - 3*a**4*b**8*c**4 - 5*a**10*b*c**5 -
        8*a**9*b**2*c**5 + 9*a**8*b**3*c**5 + 21*a**7*b**4*c**5 +
        2*a**6*b**5*c**5 - 22*a**5*b**6*c**5 - a**4*b**7*c**5 +
        4*a**3*b**8*c**5 + a**10*c**6 + 9*a**9*b*c**6 -
        2*a**8*b**2*c**6 - 22*a**7*b**3*c**6 - 11*a**6*b**4*c**6 +
        18*a**5*b**5*c**6 + 17*a**4*b**6*c**6 - 7*a**3*b**7*c**6 -
        3*a**2*b**8*c**6 - 3*a**9*c**7 - 7*a**8*b*c**7 +
        17*a**7*b**2*c**7 + 18*a**6*b**3*c**7 - 11*a**5*b**4*c**7 -
        22*a**4*b**5*c**7 - 2*a**3*b**6*c**7 + 9*a**2*b**7*c**7 +
        a*b**8*c**7 + 4*a**8*c**8 - a**7*b*c**8 - 22*a**6*b**2*c**8 +
        2*a**5*b**3*c**8 + 21*a**4*b**4*c**8 + 9*a**3*b**5*c**8 -
        8*a**2*b**6*c**8 - 5*a*b**7*c**8 - 3*a**7*c**9 + 8*a**6*b*c**9
        + 12*a**5*b**2*c**9 - 17*a**4*b**3*c**9 - 12*a**3*b**4*c**9 +
        4*a**2*b**5*c**9 + 7*a*b**6*c**9 + b**7*c**9 + a**6*c**10 -
        8*a**5*b*c**10 + a**4*b**2*c**10 + 15*a**3*b**3*c**10 -
        a**2*b**4*c**10 - 6*a*b**5*c**10 - 2*b**6*c**10 +
        4*a**4*b*c**11 - 6*a**3*b**2*c**11 - 5*a**2*b**3*c**11 +
        5*a*b**4*c**11 + 2*b**5*c**11 - a**3*b*c**12 +
        4*a**2*b**2*c**12 - a*b**3*c**12 - 2*b**4*c**12 - a*b**2*c**13
        + b**3*c**13), (a**7*b**6*c**3 + 5*a**6*b**7*c**3 +
        10*a**5*b**8*c**3 + 10*a**4*b**9*c**3 + 5*a**3*b**10*c**3 +
        a**2*b**11*c**3 + a**7*b**5*c**4 + 7*a**6*b**6*c**4 +
        18*a**5*b**7*c**4 + 22*a**4*b**8*c**4 + 13*a**3*b**9*c**4 +
        3*a**2*b**10*c**4 - a**7*b**4*c**5 - 2*a**6*b**5*c**5 +
        4*a**5*b**6*c**5 + 15*a**4*b**7*c**5 + 16*a**3*b**8*c**5 +
        7*a**2*b**9*c**5 + a*b**10*c**5 - a**6*b**4*c**6 -
        a**5*b**5*c**6 + 5*a**4*b**6*c**6 + 11*a**3*b**7*c**6 +
        8*a**2*b**8*c**6 + 2*a*b**9*c**6 + 2*a**7*b**2*c**7 +
        8*a**6*b**3*c**7 + 11*a**5*b**4*c**7 + 5*a**4*b**5*c**7 -
        a**3*b**6*c**7 - a**2*b**7*c**7 + a**7*b*c**8 +
        7*a**6*b**2*c**8 + 16*a**5*b**3*c**8 + 15*a**4*b**4*c**8 +
        4*a**3*b**5*c**8 - 2*a**2*b**6*c**8 - a*b**7*c**8 +
        3*a**6*b*c**9 + 13*a**5*b**2*c**9 + 22*a**4*b**3*c**9 +
        18*a**3*b**4*c**9 + 7*a**2*b**5*c**9 + a*b**6*c**9 +
        a**6*c**10 + 5*a**5*b*c**10 + 10*a**4*b**2*c**10 +
        10*a**3*b**3*c**10 + 5*a**2*b**4*c**10 +
        a*b**5*c**10)/(a**6*b**10 - a**5*b**11 + a**7*b**8*c -
        4*a**6*b**9*c + a**5*b**10*c + 2*a**4*b**11*c -
        4*a**7*b**7*c**2 + 6*a**6*b**8*c**2 + 5*a**5*b**9*c**2 -
        5*a**4*b**10*c**2 - 2*a**3*b**11*c**2 - a**8*b**5*c**3 +
        8*a**7*b**6*c**3 - a**6*b**7*c**3 - 15*a**5*b**8*c**3 +
        a**4*b**9*c**3 + 6*a**3*b**10*c**3 + 2*a**2*b**11*c**3 +
        3*a**8*b**4*c**4 - 8*a**7*b**5*c**4 - 12*a**6*b**6*c**4 +
        17*a**5*b**7*c**4 + 12*a**4*b**8*c**4 - 4*a**3*b**9*c**4 -
        7*a**2*b**10*c**4 - a*b**11*c**4 - 4*a**8*b**3*c**5 +
        a**7*b**4*c**5 + 22*a**6*b**5*c**5 - 2*a**5*b**6*c**5 -
        21*a**4*b**7*c**5 - 9*a**3*b**8*c**5 + 8*a**2*b**9*c**5 +
        5*a*b**10*c**5 + 3*a**8*b**2*c**6 + 7*a**7*b**3*c**6 -
        17*a**6*b**4*c**6 - 18*a**5*b**5*c**6 + 11*a**4*b**6*c**6 +
        22*a**3*b**7*c**6 + 2*a**2*b**8*c**6 - 9*a*b**9*c**6 -
        b**10*c**6 - a**8*b*c**7 - 9*a**7*b**2*c**7 + 2*a**6*b**3*c**7
        + 22*a**5*b**4*c**7 + 11*a**4*b**5*c**7 - 18*a**3*b**6*c**7 -
        17*a**2*b**7*c**7 + 7*a*b**8*c**7 + 3*b**9*c**7 +
        5*a**7*b*c**8 + 8*a**6*b**2*c**8 - 9*a**5*b**3*c**8 -
        21*a**4*b**4*c**8 - 2*a**3*b**5*c**8 + 22*a**2*b**6*c**8 +
        a*b**7*c**8 - 4*b**8*c**8 - a**7*c**9 - 7*a**6*b*c**9 -
        4*a**5*b**2*c**9 + 12*a**4*b**3*c**9 + 17*a**3*b**4*c**9 -
        12*a**2*b**5*c**9 - 8*a*b**6*c**9 + 3*b**7*c**9 + 2*a**6*c**10
        + 6*a**5*b*c**10 + a**4*b**2*c**10 - 15*a**3*b**3*c**10 -
        a**2*b**4*c**10 + 8*a*b**5*c**10 - b**6*c**10 - 2*a**5*c**11 -
        5*a**4*b*c**11 + 5*a**3*b**2*c**11 + 6*a**2*b**3*c**11 -
        4*a*b**4*c**11 + 2*a**4*c**12 + a**3*b*c**12 -
        4*a**2*b**2*c**12 + a*b**3*c**12 - a**3*c**13 + a**2*b*c**13),
        (-a**10*b**6 - 5*a**10*b**5*c - 3*a**9*b**6*c - a**8*b**7*c -
        10*a**10*b**4*c**2 - 13*a**9*b**5*c**2 - 7*a**8*b**6*c**2 -
        2*a**7*b**7*c**2 - 10*a**10*b**3*c**3 - 22*a**9*b**4*c**3 -
        16*a**8*b**5*c**3 - 8*a**7*b**6*c**3 - 5*a**10*b**2*c**4 -
        18*a**9*b**3*c**4 - 15*a**8*b**4*c**4 - 11*a**7*b**5*c**4 +
        a**6*b**6*c**4 + a**5*b**7*c**4 - a**10*b*c**5 -
        7*a**9*b**2*c**5 - 4*a**8*b**3*c**5 - 5*a**7*b**4*c**5 +
        a**6*b**5*c**5 + 2*a**5*b**6*c**5 - a**4*b**7*c**5 -
        a**9*b*c**6 + 2*a**8*b**2*c**6 + a**7*b**3*c**6 -
        5*a**6*b**4*c**6 - 4*a**5*b**5*c**6 - 7*a**4*b**6*c**6 -
        a**3*b**7*c**6 + a**8*b*c**7 + a**7*b**2*c**7 -
        11*a**6*b**3*c**7 - 15*a**5*b**4*c**7 - 18*a**4*b**5*c**7 -
        5*a**3*b**6*c**7 - 8*a**6*b**2*c**8 - 16*a**5*b**3*c**8 -
        22*a**4*b**4*c**8 - 10*a**3*b**5*c**8 - 2*a**6*b*c**9 -
        7*a**5*b**2*c**9 - 13*a**4*b**3*c**9 - 10*a**3*b**4*c**9 -
        a**5*b*c**10 - 3*a**4*b**2*c**10 - 5*a**3*b**3*c**10 -
        a**3*b**2*c**11)/(a**13*b**3 - 2*a**12*b**4 + 2*a**11*b**5 -
        2*a**10*b**6 + a**9*b**7 - a**13*b**2*c - a**12*b**3*c +
        5*a**11*b**4*c - 6*a**10*b**5*c + 7*a**9*b**6*c -
        5*a**8*b**7*c + a**7*b**8*c + 4*a**12*b**2*c**2 -
        5*a**11*b**3*c**2 - a**10*b**4*c**2 + 4*a**9*b**5*c**2 -
        8*a**8*b**6*c**2 + 9*a**7*b**7*c**2 - 3*a**6*b**8*c**2 -
        a**12*b*c**3 - 6*a**11*b**2*c**3 + 15*a**10*b**3*c**3 -
        12*a**9*b**4*c**3 + 9*a**8*b**5*c**3 - 2*a**7*b**6*c**3 -
        7*a**6*b**7*c**3 + 4*a**5*b**8*c**3 + 4*a**11*b*c**4 +
        a**10*b**2*c**4 - 17*a**9*b**3*c**4 + 21*a**8*b**4*c**4 -
        22*a**7*b**5*c**4 + 17*a**6*b**6*c**4 - a**5*b**7*c**4 -
        3*a**4*b**8*c**4 - 8*a**10*b*c**5 + 12*a**9*b**2*c**5 +
        2*a**8*b**3*c**5 - 11*a**7*b**4*c**5 + 18*a**6*b**5*c**5 -
        22*a**5*b**6*c**5 + 8*a**4*b**7*c**5 + a**3*b**8*c**5 +
        a**10*c**6 + 8*a**9*b*c**6 - 22*a**8*b**2*c**6 +
        18*a**7*b**3*c**6 - 11*a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        12*a**4*b**6*c**6 - 8*a**3*b**7*c**6 - 3*a**9*c**7 -
        a**8*b*c**7 + 17*a**7*b**2*c**7 - 22*a**6*b**3*c**7 +
        21*a**5*b**4*c**7 - 17*a**4*b**5*c**7 + a**3*b**6*c**7 +
        4*a**2*b**7*c**7 + 4*a**8*c**8 - 7*a**7*b*c**8 -
        2*a**6*b**2*c**8 + 9*a**5*b**3*c**8 - 12*a**4*b**4*c**8 +
        15*a**3*b**5*c**8 - 6*a**2*b**6*c**8 - a*b**7*c**8 -
        3*a**7*c**9 + 9*a**6*b*c**9 - 8*a**5*b**2*c**9 +
        4*a**4*b**3*c**9 - a**3*b**4*c**9 - 5*a**2*b**5*c**9 +
        4*a*b**6*c**9 + a**6*c**10 - 5*a**5*b*c**10 +
        7*a**4*b**2*c**10 - 6*a**3*b**3*c**10 + 5*a**2*b**4*c**10 -
        a*b**5*c**10 - b**6*c**10 + a**4*b*c**11 - 2*a**3*b**2*c**11 +
        2*a**2*b**3*c**11 - 2*a*b**4*c**11 + b**5*c**11),
        (-a**10*b**5*c - 2*a**9*b**6*c + a**7*b**8*c - a**6*b**9*c -
        a**5*b**10*c - a**11*b**3*c**2 - 3*a**10*b**4*c**2 -
        7*a**9*b**5*c**2 - 8*a**8*b**6*c**2 + a**7*b**7*c**2 +
        2*a**6*b**8*c**2 - 7*a**5*b**9*c**2 - 5*a**4*b**10*c**2 -
        5*a**10*b**3*c**3 - 13*a**9*b**4*c**3 - 16*a**8*b**5*c**3 -
        11*a**7*b**6*c**3 + a**6*b**7*c**3 - 4*a**5*b**8*c**3 -
        18*a**4*b**9*c**3 - 10*a**3*b**10*c**3 - 10*a**9*b**3*c**4 -
        22*a**8*b**4*c**4 - 15*a**7*b**5*c**4 - 5*a**6*b**6*c**4 -
        5*a**5*b**7*c**4 - 15*a**4*b**8*c**4 - 22*a**3*b**9*c**4 -
        10*a**2*b**10*c**4 - 10*a**8*b**3*c**5 - 18*a**7*b**4*c**5 -
        4*a**6*b**5*c**5 + a**5*b**6*c**5 - 11*a**4*b**7*c**5 -
        16*a**3*b**8*c**5 - 13*a**2*b**9*c**5 - 5*a*b**10*c**5 -
        5*a**7*b**3*c**6 - 7*a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        a**4*b**6*c**6 - 8*a**3*b**7*c**6 - 7*a**2*b**8*c**6 -
        3*a*b**9*c**6 - b**10*c**6 - a**6*b**3*c**7 - a**5*b**4*c**7 +
        a**4*b**5*c**7 - 2*a**2*b**7*c**7 - a*b**8*c**7)/(a**10*b**6 -
        3*a**9*b**7 + 4*a**8*b**8 - 3*a**7*b**9 + a**6*b**10 +
        a**11*b**4*c - 5*a**10*b**5*c + 9*a**9*b**6*c - 7*a**8*b**7*c
        - a**7*b**8*c + 8*a**6*b**9*c - 8*a**5*b**10*c +
        4*a**4*b**11*c - a**3*b**12*c - 2*a**11*b**3*c**2 +
        7*a**10*b**4*c**2 - 8*a**9*b**5*c**2 - 2*a**8*b**6*c**2 +
        17*a**7*b**7*c**2 - 22*a**6*b**8*c**2 + 12*a**5*b**9*c**2 +
        a**4*b**10*c**2 - 6*a**3*b**11*c**2 + 4*a**2*b**12*c**2 -
        a*b**13*c**2 + 2*a**11*b**2*c**3 - 6*a**10*b**3*c**3 +
        4*a**9*b**4*c**3 + 9*a**8*b**5*c**3 - 22*a**7*b**6*c**3 +
        18*a**6*b**7*c**3 + 2*a**5*b**8*c**3 - 17*a**4*b**9*c**3 +
        15*a**3*b**10*c**3 - 5*a**2*b**11*c**3 - a*b**12*c**3 +
        b**13*c**3 - 2*a**11*b*c**4 + 5*a**10*b**2*c**4 -
        a**9*b**3*c**4 - 12*a**8*b**4*c**4 + 21*a**7*b**5*c**4 -
        11*a**6*b**6*c**4 - 11*a**5*b**7*c**4 + 21*a**4*b**8*c**4 -
        12*a**3*b**9*c**4 - a**2*b**10*c**4 + 5*a*b**11*c**4 -
        2*b**12*c**4 + a**11*c**5 - a**10*b*c**5 - 5*a**9*b**2*c**5 +
        15*a**8*b**3*c**5 - 17*a**7*b**4*c**5 + 2*a**6*b**5*c**5 +
        18*a**5*b**6*c**5 - 22*a**4*b**7*c**5 + 9*a**3*b**8*c**5 +
        4*a**2*b**9*c**5 - 6*a*b**10*c**5 + 2*b**11*c**5 - a**10*c**6
        + 4*a**9*b*c**6 - 6*a**8*b**2*c**6 + a**7*b**3*c**6 +
        12*a**6*b**4*c**6 - 22*a**5*b**5*c**6 + 17*a**4*b**6*c**6 -
        2*a**3*b**7*c**6 - 8*a**2*b**8*c**6 + 7*a*b**9*c**6 -
        2*b**10*c**6 - a**8*b*c**7 + 4*a**7*b**2*c**7 -
        8*a**6*b**3*c**7 + 8*a**5*b**4*c**7 - a**4*b**5*c**7 -
        7*a**3*b**6*c**7 + 9*a**2*b**7*c**7 - 5*a*b**8*c**7 +
        b**9*c**7 + a**5*b**3*c**8 - 3*a**4*b**4*c**8 +
        4*a**3*b**5*c**8 - 3*a**2*b**6*c**8 + a*b**7*c**8),
        (a**6*b**4*c**2 + 3*a**5*b**5*c**2 + 3*a**4*b**6*c**2 +
        a**3*b**7*c**2 + 2*a**6*b**3*c**3 + 8*a**5*b**4*c**3 +
        11*a**4*b**5*c**3 + 6*a**3*b**6*c**3 + a**2*b**7*c**3 +
        a**6*b**2*c**4 + 8*a**5*b**3*c**4 + 17*a**4*b**4*c**4 +
        14*a**3*b**5*c**4 + 4*a**2*b**6*c**4 + 4*a**5*b**2*c**5 +
        14*a**4*b**3*c**5 + 17*a**3*b**4*c**5 + 8*a**2*b**5*c**5 +
        a*b**6*c**5 + a**5*b*c**6 + 6*a**4*b**2*c**6 +
        11*a**3*b**3*c**6 + 8*a**2*b**4*c**6 + 2*a*b**5*c**6 +
        a**4*b*c**7 + 3*a**3*b**2*c**7 + 3*a**2*b**3*c**7 +
        a*b**4*c**7)/(a**7*b**5 - 2*a**6*b**6 + a**5*b**7 -
        3*a**7*b**4*c + 5*a**6*b**5*c - 3*a**4*b**7*c + a**3*b**8*c +
        4*a**7*b**3*c**2 - 5*a**6*b**4*c**2 - 5*a**5*b**5*c**2 +
        8*a**4*b**6*c**2 - a**3*b**7*c**2 - a**2*b**8*c**2 -
        3*a**7*b**2*c**3 + 2*a**6*b**3*c**3 + 8*a**5*b**4*c**3 -
        7*a**4*b**5*c**3 - 3*a**3*b**6*c**3 + 3*a**2*b**7*c**3 +
        a**7*b*c**4 + a**6*b**2*c**4 - 5*a**5*b**3*c**4 +
        5*a**3*b**5*c**4 - a**2*b**6*c**4 - a*b**7*c**4 - a**6*b*c**5
        - a**5*b**2*c**5 + 5*a**4*b**3*c**5 - 5*a**2*b**5*c**5 +
        a*b**6*c**5 + b**7*c**5 + 3*a**5*b*c**6 - 3*a**4*b**2*c**6 -
        7*a**3*b**3*c**6 + 8*a**2*b**4*c**6 + 2*a*b**5*c**6 -
        3*b**6*c**6 - a**5*c**7 - a**4*b*c**7 + 8*a**3*b**2*c**7 -
        5*a**2*b**3*c**7 - 5*a*b**4*c**7 + 4*b**5*c**7 + a**4*c**8 -
        3*a**3*b*c**8 + 5*a*b**3*c**8 - 3*b**4*c**8 + a**2*b*c**9 -
        2*a*b**2*c**9 + b**3*c**9), (a**6*b**5*c + 2*a**5*b**6*c +
        a**4*b**7*c + a**7*b**3*c**2 + 4*a**6*b**4*c**2 +
        8*a**5*b**5*c**2 + 8*a**4*b**6*c**2 + 3*a**3*b**7*c**2 +
        a**7*b**2*c**3 + 6*a**6*b**3*c**3 + 14*a**5*b**4*c**3 +
        17*a**4*b**5*c**3 + 11*a**3*b**6*c**3 + 3*a**2*b**7*c**3 +
        3*a**6*b**2*c**4 + 11*a**5*b**3*c**4 + 17*a**4*b**4*c**4 +
        14*a**3*b**5*c**4 + 6*a**2*b**6*c**4 + a*b**7*c**4 +
        3*a**5*b**2*c**5 + 8*a**4*b**3*c**5 + 8*a**3*b**4*c**5 +
        4*a**2*b**5*c**5 + a*b**6*c**5 + a**4*b**2*c**6 +
        2*a**3*b**3*c**6 + a**2*b**4*c**6)/(a**7*b**5 - 3*a**6*b**6 +
        4*a**5*b**7 - 3*a**4*b**8 + a**3*b**9 - a**7*b**4*c +
        a**6*b**5*c + 2*a**5*b**6*c - 5*a**4*b**7*c + 5*a**3*b**8*c -
        2*a**2*b**9*c - a**8*b**2*c**2 + 3*a**7*b**3*c**2 -
        a**6*b**4*c**2 - 5*a**5*b**5*c**2 + 8*a**4*b**6*c**2 -
        5*a**3*b**7*c**2 + a*b**9*c**2 + a**8*b*c**3 - a**7*b**2*c**3
        - 3*a**6*b**3*c**3 + 5*a**5*b**4*c**3 - 7*a**3*b**6*c**3 +
        8*a**2*b**7*c**3 - 3*a*b**8*c**3 - 3*a**7*b*c**4 +
        8*a**6*b**2*c**4 - 7*a**5*b**3*c**4 + 5*a**3*b**5*c**4 -
        3*a**2*b**6*c**4 - a*b**7*c**4 + b**8*c**4 + a**7*c**5 -
        5*a**5*b**2*c**5 + 8*a**4*b**3*c**5 - 5*a**3*b**4*c**5 -
        a**2*b**5*c**5 + 3*a*b**6*c**5 - b**7*c**5 - 2*a**6*c**6 +
        5*a**5*b*c**6 - 5*a**4*b**2*c**6 + 2*a**3*b**3*c**6 +
        a**2*b**4*c**6 - a*b**5*c**6 + a**5*c**7 - 3*a**4*b*c**7 +
        4*a**3*b**2*c**7 - 3*a**2*b**3*c**7 + a*b**4*c**7),
        (a**7*b**4*c + a**6*b**5*c + 3*a**7*b**3*c**2 +
        6*a**6*b**4*c**2 + 4*a**5*b**5*c**2 + a**4*b**6*c**2 +
        3*a**7*b**2*c**3 + 11*a**6*b**3*c**3 + 14*a**5*b**4*c**3 +
        8*a**4*b**5*c**3 + 2*a**3*b**6*c**3 + a**7*b*c**4 +
        8*a**6*b**2*c**4 + 17*a**5*b**3*c**4 + 17*a**4*b**4*c**4 +
        8*a**3*b**5*c**4 + a**2*b**6*c**4 + 2*a**6*b*c**5 +
        8*a**5*b**2*c**5 + 14*a**4*b**3*c**5 + 11*a**3*b**4*c**5 +
        3*a**2*b**5*c**5 + a**5*b*c**6 + 4*a**4*b**2*c**6 +
        6*a**3*b**3*c**6 + 3*a**2*b**4*c**6 + a**3*b**2*c**7 +
        a**2*b**3*c**7)/(a**8*b**4 - a**7*b**5 + a**9*b**2*c -
        3*a**8*b**3*c - a**7*b**4*c + 3*a**6*b**5*c - a**5*b**6*c +
        a**4*b**7*c - 2*a**9*b*c**2 + 8*a**7*b**3*c**2 -
        3*a**6*b**4*c**2 - a**5*b**5*c**2 + a**4*b**6*c**2 -
        3*a**3*b**7*c**2 + a**9*c**3 + 5*a**8*b*c**3 -
        5*a**7*b**2*c**3 - 7*a**6*b**3*c**3 + 5*a**5*b**4*c**3 -
        5*a**4*b**5*c**3 + 2*a**3*b**6*c**3 + 4*a**2*b**7*c**3 -
        3*a**8*c**4 - 5*a**7*b*c**4 + 8*a**6*b**2*c**4 +
        8*a**3*b**5*c**4 - 5*a**2*b**6*c**4 - 3*a*b**7*c**4 +
        4*a**7*c**5 + 2*a**6*b*c**5 - 5*a**5*b**2*c**5 +
        5*a**4*b**3*c**5 - 7*a**3*b**4*c**5 - 5*a**2*b**5*c**5 +
        5*a*b**6*c**5 + b**7*c**5 - 3*a**6*c**6 + a**5*b*c**6 -
        a**4*b**2*c**6 - 3*a**3*b**3*c**6 + 8*a**2*b**4*c**6 -
        2*b**6*c**6 + a**5*c**7 - a**4*b*c**7 + 3*a**3*b**2*c**7 -
        a**2*b**3*c**7 - 3*a*b**4*c**7 + b**5*c**7 - a**2*b**2*c**8 +
        a*b**3*c**8), (-a**5*b**6*c - a**4*b**7*c - a**6*b**4*c**2 -
        4*a**5*b**5*c**2 - 6*a**4*b**6*c**2 - 3*a**3*b**7*c**2 -
        2*a**6*b**3*c**3 - 8*a**5*b**4*c**3 - 14*a**4*b**5*c**3 -
        11*a**3*b**6*c**3 - 3*a**2*b**7*c**3 - a**6*b**2*c**4 -
        8*a**5*b**3*c**4 - 17*a**4*b**4*c**4 - 17*a**3*b**5*c**4 -
        8*a**2*b**6*c**4 - a*b**7*c**4 - 3*a**5*b**2*c**5 -
        11*a**4*b**3*c**5 - 14*a**3*b**4*c**5 - 8*a**2*b**5*c**5 -
        2*a*b**6*c**5 - 3*a**4*b**2*c**6 - 6*a**3*b**3*c**6 -
        4*a**2*b**4*c**6 - a*b**5*c**6 - a**3*b**2*c**7 -
        a**2*b**3*c**7)/(a**5*b**7 - a**4*b**8 - a**7*b**4*c +
        a**6*b**5*c - 3*a**5*b**6*c + a**4*b**7*c + 3*a**3*b**8*c -
        a**2*b**9*c + 3*a**7*b**3*c**2 - a**6*b**4*c**2 +
        a**5*b**5*c**2 + 3*a**4*b**6*c**2 - 8*a**3*b**7*c**2 +
        2*a*b**9*c**2 - 4*a**7*b**2*c**3 - 2*a**6*b**3*c**3 +
        5*a**5*b**4*c**3 - 5*a**4*b**5*c**3 + 7*a**3*b**6*c**3 +
        5*a**2*b**7*c**3 - 5*a*b**8*c**3 - b**9*c**3 + 3*a**7*b*c**4 +
        5*a**6*b**2*c**4 - 8*a**5*b**3*c**4 - 8*a**2*b**6*c**4 +
        5*a*b**7*c**4 + 3*b**8*c**4 - a**7*c**5 - 5*a**6*b*c**5 +
        5*a**5*b**2*c**5 + 7*a**4*b**3*c**5 - 5*a**3*b**4*c**5 +
        5*a**2*b**5*c**5 - 2*a*b**6*c**5 - 4*b**7*c**5 + 2*a**6*c**6 -
        8*a**4*b**2*c**6 + 3*a**3*b**3*c**6 + a**2*b**4*c**6 -
        a*b**5*c**6 + 3*b**6*c**6 - a**5*c**7 + 3*a**4*b*c**7 +
        a**3*b**2*c**7 - 3*a**2*b**3*c**7 + a*b**4*c**7 - b**5*c**7 -
        a**3*b*c**8 + a**2*b**2*c**8), (a**7*b**3*c**2 +
        3*a**6*b**4*c**2 + 3*a**5*b**5*c**2 + a**4*b**6*c**2 +
        a**7*b**2*c**3 + 6*a**6*b**3*c**3 + 11*a**5*b**4*c**3 +
        8*a**4*b**5*c**3 + 2*a**3*b**6*c**3 + 4*a**6*b**2*c**4 +
        14*a**5*b**3*c**4 + 17*a**4*b**4*c**4 + 8*a**3*b**5*c**4 +
        a**2*b**6*c**4 + a**6*b*c**5 + 8*a**5*b**2*c**5 +
        17*a**4*b**3*c**5 + 14*a**3*b**4*c**5 + 4*a**2*b**5*c**5 +
        2*a**5*b*c**6 + 8*a**4*b**2*c**6 + 11*a**3*b**3*c**6 +
        6*a**2*b**4*c**6 + a*b**5*c**6 + a**4*b*c**7 +
        3*a**3*b**2*c**7 + 3*a**2*b**3*c**7 + a*b**4*c**7)/(a**7*b**5
        - 2*a**6*b**6 + a**5*b**7 + a**8*b**3*c - 3*a**7*b**4*c +
        5*a**5*b**6*c - 3*a**4*b**7*c - a**8*b**2*c**2 -
        a**7*b**3*c**2 + 8*a**6*b**4*c**2 - 5*a**5*b**5*c**2 -
        5*a**4*b**6*c**2 + 4*a**3*b**7*c**2 + 3*a**7*b**2*c**3 -
        3*a**6*b**3*c**3 - 7*a**5*b**4*c**3 + 8*a**4*b**5*c**3 +
        2*a**3*b**6*c**3 - 3*a**2*b**7*c**3 - a**7*b*c**4 -
        a**6*b**2*c**4 + 5*a**5*b**3*c**4 - 5*a**3*b**5*c**4 +
        a**2*b**6*c**4 + a*b**7*c**4 + a**7*c**5 + a**6*b*c**5 -
        5*a**5*b**2*c**5 + 5*a**3*b**4*c**5 - a**2*b**5*c**5 -
        a*b**6*c**5 - 3*a**6*c**6 + 2*a**5*b*c**6 + 8*a**4*b**2*c**6 -
        7*a**3*b**3*c**6 - 3*a**2*b**4*c**6 + 3*a*b**5*c**6 +
        4*a**5*c**7 - 5*a**4*b*c**7 - 5*a**3*b**2*c**7 +
        8*a**2*b**3*c**7 - a*b**4*c**7 - b**5*c**7 - 3*a**4*c**8 +
        5*a**3*b*c**8 - 3*a*b**3*c**8 + b**4*c**8 + a**3*c**9 -
        2*a**2*b*c**9 + a*b**2*c**9), (a**7*b**4*c + 2*a**6*b**5*c +
        a**5*b**6*c + 3*a**7*b**3*c**2 + 8*a**6*b**4*c**2 +
        8*a**5*b**5*c**2 + 4*a**4*b**6*c**2 + a**3*b**7*c**2 +
        3*a**7*b**2*c**3 + 11*a**6*b**3*c**3 + 17*a**5*b**4*c**3 +
        14*a**4*b**5*c**3 + 6*a**3*b**6*c**3 + a**2*b**7*c**3 +
        a**7*b*c**4 + 6*a**6*b**2*c**4 + 14*a**5*b**3*c**4 +
        17*a**4*b**4*c**4 + 11*a**3*b**5*c**4 + 3*a**2*b**6*c**4 +
        a**6*b*c**5 + 4*a**5*b**2*c**5 + 8*a**4*b**3*c**5 +
        8*a**3*b**4*c**5 + 3*a**2*b**5*c**5 + a**4*b**2*c**6 +
        2*a**3*b**3*c**6 + a**2*b**4*c**6)/(a**9*b**3 - 3*a**8*b**4 +
        4*a**7*b**5 - 3*a**6*b**6 + a**5*b**7 - 2*a**9*b**2*c +
        5*a**8*b**3*c - 5*a**7*b**4*c + 2*a**6*b**5*c + a**5*b**6*c -
        a**4*b**7*c + a**9*b*c**2 - 5*a**7*b**3*c**2 +
        8*a**6*b**4*c**2 - 5*a**5*b**5*c**2 - a**4*b**6*c**2 +
        3*a**3*b**7*c**2 - a**2*b**8*c**2 - 3*a**8*b*c**3 +
        8*a**7*b**2*c**3 - 7*a**6*b**3*c**3 + 5*a**4*b**5*c**3 -
        3*a**3*b**6*c**3 - a**2*b**7*c**3 + a*b**8*c**3 + a**8*c**4 -
        a**7*b*c**4 - 3*a**6*b**2*c**4 + 5*a**5*b**3*c**4 -
        7*a**3*b**5*c**4 + 8*a**2*b**6*c**4 - 3*a*b**7*c**4 -
        a**7*c**5 + 3*a**6*b*c**5 - a**5*b**2*c**5 - 5*a**4*b**3*c**5
        + 8*a**3*b**4*c**5 - 5*a**2*b**5*c**5 + b**7*c**5 -
        a**5*b*c**6 + a**4*b**2*c**6 + 2*a**3*b**3*c**6 -
        5*a**2*b**4*c**6 + 5*a*b**5*c**6 - 2*b**6*c**6 + a**4*b*c**7 -
        3*a**3*b**2*c**7 + 4*a**2*b**3*c**7 - 3*a*b**4*c**7 +
        b**5*c**7), (a**8*b**5*c + 2*a**7*b**6*c + a**6*b**7*c +
        4*a**8*b**4*c**2 + 11*a**7*b**5*c**2 + 11*a**6*b**6*c**2 +
        5*a**5*b**7*c**2 + a**4*b**8*c**2 + 6*a**8*b**3*c**3 +
        23*a**7*b**4*c**3 + 35*a**6*b**5*c**3 + 27*a**5*b**6*c**3 +
        11*a**4*b**7*c**3 + 2*a**3*b**8*c**3 + 4*a**8*b**2*c**4 +
        23*a**7*b**3*c**4 + 50*a**6*b**4*c**4 + 56*a**5*b**5*c**4 +
        35*a**4*b**6*c**4 + 11*a**3*b**7*c**4 + a**2*b**8*c**4 +
        a**8*b*c**5 + 11*a**7*b**2*c**5 + 35*a**6*b**3*c**5 +
        56*a**5*b**4*c**5 + 50*a**4*b**5*c**5 + 23*a**3*b**6*c**5 +
        4*a**2*b**7*c**5 + 2*a**7*b*c**6 + 11*a**6*b**2*c**6 +
        27*a**5*b**3*c**6 + 35*a**4*b**4*c**6 + 23*a**3*b**5*c**6 +
        6*a**2*b**6*c**6 + a**6*b*c**7 + 5*a**5*b**2*c**7 +
        11*a**4*b**3*c**7 + 11*a**3*b**4*c**7 + 4*a**2*b**5*c**7 +
        a**4*b**2*c**8 + 2*a**3*b**3*c**8 + a**2*b**4*c**8)/(a**8*b**6
        - a**7*b**7 - a**10*b**3*c + a**9*b**4*c - 2*a**8*b**5*c +
        a**7*b**6*c + 2*a**6*b**7*c - a**5*b**8*c + 2*a**10*b**2*c**2
        - a**9*b**3*c**2 - a**8*b**4*c**2 + 2*a**7*b**5*c**2 -
        4*a**6*b**6*c**2 + a**5*b**7*c**2 + 2*a**4*b**8*c**2 -
        a**3*b**9*c**2 - a**10*b*c**3 - a**9*b**2*c**3 +
        4*a**8*b**3*c**3 - 2*a**7*b**4*c**3 - a**6*b**5*c**3 +
        3*a**5*b**6*c**3 - 4*a**4*b**7*c**3 + a**3*b**8*c**3 +
        a**2*b**9*c**3 + a**9*b*c**4 - a**8*b**2*c**4 -
        2*a**7*b**3*c**4 + 6*a**6*b**4*c**4 - 3*a**5*b**5*c**4 -
        a**4*b**6*c**4 + 2*a**3*b**7*c**4 - 2*a**2*b**8*c**4 -
        2*a**8*b*c**5 + 2*a**7*b**2*c**5 - a**6*b**3*c**5 -
        3*a**5*b**4*c**5 + 6*a**4*b**5*c**5 - 2*a**3*b**6*c**5 -
        a**2*b**7*c**5 + a*b**8*c**5 + a**8*c**6 + a**7*b*c**6 -
        4*a**6*b**2*c**6 + 3*a**5*b**3*c**6 - a**4*b**4*c**6 -
        2*a**3*b**5*c**6 + 4*a**2*b**6*c**6 - a*b**7*c**6 - b**8*c**6
        - a**7*c**7 + 2*a**6*b*c**7 + a**5*b**2*c**7 -
        4*a**4*b**3*c**7 + 2*a**3*b**4*c**7 - a**2*b**5*c**7 -
        a*b**6*c**7 + 2*b**7*c**7 - a**5*b*c**8 + 2*a**4*b**2*c**8 +
        a**3*b**3*c**8 - 2*a**2*b**4*c**8 + a*b**5*c**8 - b**6*c**8 -
        a**3*b**2*c**9 + a**2*b**3*c**9), (-a**8*b**4*c**2 -
        4*a**7*b**5*c**2 - 6*a**6*b**6*c**2 - 4*a**5*b**7*c**2 -
        a**4*b**8*c**2 - 2*a**8*b**3*c**3 - 11*a**7*b**4*c**3 -
        23*a**6*b**5*c**3 - 23*a**5*b**6*c**3 - 11*a**4*b**7*c**3 -
        2*a**3*b**8*c**3 - a**8*b**2*c**4 - 11*a**7*b**3*c**4 -
        35*a**6*b**4*c**4 - 50*a**5*b**5*c**4 - 35*a**4*b**6*c**4 -
        11*a**3*b**7*c**4 - a**2*b**8*c**4 - 5*a**7*b**2*c**5 -
        27*a**6*b**3*c**5 - 56*a**5*b**4*c**5 - 56*a**4*b**5*c**5 -
        27*a**3*b**6*c**5 - 5*a**2*b**7*c**5 - a**7*b*c**6 -
        11*a**6*b**2*c**6 - 35*a**5*b**3*c**6 - 50*a**4*b**4*c**6 -
        35*a**3*b**5*c**6 - 11*a**2*b**6*c**6 - a*b**7*c**6 -
        2*a**6*b*c**7 - 11*a**5*b**2*c**7 - 23*a**4*b**3*c**7 -
        23*a**3*b**4*c**7 - 11*a**2*b**5*c**7 - 2*a*b**6*c**7 -
        a**5*b*c**8 - 4*a**4*b**2*c**8 - 6*a**3*b**3*c**8 -
        4*a**2*b**4*c**8 - a*b**5*c**8)/(a**8*b**6 - 2*a**7*b**7 +
        a**6*b**8 - a**8*b**5*c + a**7*b**6*c + a**6*b**7*c -
        a**5*b**8*c - a**9*b**3*c**2 + 2*a**8*b**4*c**2 +
        a**7*b**5*c**2 - 4*a**6*b**6*c**2 + a**5*b**7*c**2 +
        2*a**4*b**8*c**2 - a**3*b**9*c**2 + a**9*b**2*c**3 -
        a**8*b**3*c**3 - 2*a**7*b**4*c**3 + 2*a**6*b**5*c**3 +
        2*a**5*b**6*c**3 - 2*a**4*b**7*c**3 - a**3*b**8*c**3 +
        a**2*b**9*c**3 - 2*a**8*b**2*c**4 + 4*a**7*b**3*c**4 +
        a**6*b**4*c**4 - 6*a**5*b**5*c**4 + a**4*b**6*c**4 +
        4*a**3*b**7*c**4 - 2*a**2*b**8*c**4 + a**8*b*c**5 -
        a**7*b**2*c**5 - 3*a**6*b**3*c**5 + 3*a**5*b**4*c**5 +
        3*a**4*b**5*c**5 - 3*a**3*b**6*c**5 - a**2*b**7*c**5 +
        a*b**8*c**5 - 2*a**7*b*c**6 + 4*a**6*b**2*c**6 +
        a**5*b**3*c**6 - 6*a**4*b**4*c**6 + a**3*b**5*c**6 +
        4*a**2*b**6*c**6 - 2*a*b**7*c**6 + a**7*c**7 - a**6*b*c**7 -
        2*a**5*b**2*c**7 + 2*a**4*b**3*c**7 + 2*a**3*b**4*c**7 -
        2*a**2*b**5*c**7 - a*b**6*c**7 + b**7*c**7 - a**6*c**8 +
        2*a**5*b*c**8 + a**4*b**2*c**8 - 4*a**3*b**3*c**8 +
        a**2*b**4*c**8 + 2*a*b**5*c**8 - b**6*c**8 - a**4*b*c**9 +
        a**3*b**2*c**9 + a**2*b**3*c**9 - a*b**4*c**9 + a**3*b*c**10 -
        2*a**2*b**2*c**10 + a*b**3*c**10), (-a**7*b**6*c -
        2*a**6*b**7*c - a**5*b**8*c - a**8*b**4*c**2 -
        5*a**7*b**5*c**2 - 11*a**6*b**6*c**2 - 11*a**5*b**7*c**2 -
        4*a**4*b**8*c**2 - 2*a**8*b**3*c**3 - 11*a**7*b**4*c**3 -
        27*a**6*b**5*c**3 - 35*a**5*b**6*c**3 - 23*a**4*b**7*c**3 -
        6*a**3*b**8*c**3 - a**8*b**2*c**4 - 11*a**7*b**3*c**4 -
        35*a**6*b**4*c**4 - 56*a**5*b**5*c**4 - 50*a**4*b**6*c**4 -
        23*a**3*b**7*c**4 - 4*a**2*b**8*c**4 - 4*a**7*b**2*c**5 -
        23*a**6*b**3*c**5 - 50*a**5*b**4*c**5 - 56*a**4*b**5*c**5 -
        35*a**3*b**6*c**5 - 11*a**2*b**7*c**5 - a*b**8*c**5 -
        6*a**6*b**2*c**6 - 23*a**5*b**3*c**6 - 35*a**4*b**4*c**6 -
        27*a**3*b**5*c**6 - 11*a**2*b**6*c**6 - 2*a*b**7*c**6 -
        4*a**5*b**2*c**7 - 11*a**4*b**3*c**7 - 11*a**3*b**4*c**7 -
        5*a**2*b**5*c**7 - a*b**6*c**7 - a**4*b**2*c**8 -
        2*a**3*b**3*c**8 - a**2*b**4*c**8)/(a**7*b**7 - a**6*b**8 +
        a**8*b**5*c - 2*a**7*b**6*c - a**6*b**7*c + 2*a**5*b**8*c -
        a**4*b**9*c + a**3*b**10*c + a**9*b**3*c**2 - 2*a**8*b**4*c**2
        - a**7*b**5*c**2 + 4*a**6*b**6*c**2 - 2*a**5*b**7*c**2 +
        a**4*b**8*c**2 + a**3*b**9*c**2 - 2*a**2*b**10*c**2 -
        a**9*b**2*c**3 - a**8*b**3*c**3 + 4*a**7*b**4*c**3 -
        3*a**6*b**5*c**3 + a**5*b**6*c**3 + 2*a**4*b**7*c**3 -
        4*a**3*b**8*c**3 + a**2*b**9*c**3 + a*b**10*c**3 +
        2*a**8*b**2*c**4 - 2*a**7*b**3*c**4 + a**6*b**4*c**4 +
        3*a**5*b**5*c**4 - 6*a**4*b**6*c**4 + 2*a**3*b**7*c**4 +
        a**2*b**8*c**4 - a*b**9*c**4 - a**8*b*c**5 + a**7*b**2*c**5 +
        2*a**6*b**3*c**5 - 6*a**5*b**4*c**5 + 3*a**4*b**5*c**5 +
        a**3*b**6*c**5 - 2*a**2*b**7*c**5 + 2*a*b**8*c**5 + a**8*c**6
        + a**7*b*c**6 - 4*a**6*b**2*c**6 + 2*a**5*b**3*c**6 +
        a**4*b**4*c**6 - 3*a**3*b**5*c**6 + 4*a**2*b**6*c**6 -
        a*b**7*c**6 - b**8*c**6 - 2*a**7*c**7 + a**6*b*c**7 +
        a**5*b**2*c**7 - 2*a**4*b**3*c**7 + 4*a**3*b**4*c**7 -
        a**2*b**5*c**7 - 2*a*b**6*c**7 + b**7*c**7 + a**6*c**8 -
        a**5*b*c**8 + 2*a**4*b**2*c**8 - a**3*b**3*c**8 -
        2*a**2*b**4*c**8 + a*b**5*c**8 - a**3*b**2*c**9 +
        a**2*b**3*c**9), ((1/3*zeta3 + 2/3)*a**7*b**4*c + (zeta3 +
        2)*a**6*b**5*c + (zeta3 + 2)*a**5*b**6*c + (1/3*zeta3 +
        2/3)*a**4*b**7*c + (zeta3 + 2)*a**7*b**3*c**2 + (4*zeta3 +
        8)*a**6*b**4*c**2 + (6*zeta3 + 12)*a**5*b**5*c**2 + (4*zeta3 +
        8)*a**4*b**6*c**2 + (zeta3 + 2)*a**3*b**7*c**2 + (zeta3 +
        2)*a**7*b**2*c**3 + (6*zeta3 + 12)*a**6*b**3*c**3 + (13*zeta3
        + 26)*a**5*b**4*c**3 + (13*zeta3 + 26)*a**4*b**5*c**3 +
        (6*zeta3 + 12)*a**3*b**6*c**3 + (zeta3 + 2)*a**2*b**7*c**3 +
        (1/3*zeta3 + 2/3)*a**7*b*c**4 + (4*zeta3 + 8)*a**6*b**2*c**4 +
        (13*zeta3 + 26)*a**5*b**3*c**4 + (56/3*zeta3 +
        112/3)*a**4*b**4*c**4 + (13*zeta3 + 26)*a**3*b**5*c**4 +
        (4*zeta3 + 8)*a**2*b**6*c**4 + (1/3*zeta3 + 2/3)*a*b**7*c**4 +
        (zeta3 + 2)*a**6*b*c**5 + (6*zeta3 + 12)*a**5*b**2*c**5 +
        (13*zeta3 + 26)*a**4*b**3*c**5 + (13*zeta3 +
        26)*a**3*b**4*c**5 + (6*zeta3 + 12)*a**2*b**5*c**5 + (zeta3 +
        2)*a*b**6*c**5 + (zeta3 + 2)*a**5*b*c**6 + (4*zeta3 +
        8)*a**4*b**2*c**6 + (6*zeta3 + 12)*a**3*b**3*c**6 + (4*zeta3 +
        8)*a**2*b**4*c**6 + (zeta3 + 2)*a*b**5*c**6 + (1/3*zeta3 +
        2/3)*a**4*b*c**7 + (zeta3 + 2)*a**3*b**2*c**7 + (zeta3 +
        2)*a**2*b**3*c**7 + (1/3*zeta3 + 2/3)*a*b**4*c**7)/(a**7*b**5
        - a**6*b**6 + a**5*b**7 + (zeta3 + 1)*a**8*b**3*c + (-zeta3 -
        2)*a**7*b**4*c + (zeta3 + 1)*a**6*b**5*c + (zeta3 +
        1)*a**5*b**6*c + (-zeta3 - 2)*a**4*b**7*c + (zeta3 +
        1)*a**3*b**8*c + (-zeta3 - 1)*a**8*b**2*c**2 + a**7*b**3*c**2
        + (-2*zeta3 - 1)*a**5*b**5*c**2 + a**3*b**7*c**2 + (-zeta3 -
        1)*a**2*b**8*c**2 + (zeta3 + 1)*a**8*b*c**3 + a**7*b**2*c**3 +
        (zeta3 - 1)*a**6*b**3*c**3 + (zeta3 + 2)*a**5*b**4*c**3 +
        (zeta3 + 2)*a**4*b**5*c**3 + (zeta3 - 1)*a**3*b**6*c**3 +
        a**2*b**7*c**3 + (zeta3 + 1)*a*b**8*c**3 + (-zeta3 -
        2)*a**7*b*c**4 + (zeta3 + 2)*a**5*b**3*c**4 + (-3*zeta3 -
        6)*a**4*b**4*c**4 + (zeta3 + 2)*a**3*b**5*c**4 + (-zeta3 -
        2)*a*b**7*c**4 + a**7*c**5 + (zeta3 + 1)*a**6*b*c**5 +
        (-2*zeta3 - 1)*a**5*b**2*c**5 + (zeta3 + 2)*a**4*b**3*c**5 +
        (zeta3 + 2)*a**3*b**4*c**5 + (-2*zeta3 - 1)*a**2*b**5*c**5 +
        (zeta3 + 1)*a*b**6*c**5 + b**7*c**5 - a**6*c**6 + (zeta3 +
        1)*a**5*b*c**6 + (zeta3 - 1)*a**3*b**3*c**6 + (zeta3 +
        1)*a*b**5*c**6 - b**6*c**6 + a**5*c**7 + (-zeta3 -
        2)*a**4*b*c**7 + a**3*b**2*c**7 + a**2*b**3*c**7 + (-zeta3 -
        2)*a*b**4*c**7 + b**5*c**7 + (zeta3 + 1)*a**3*b*c**8 + (-zeta3
        - 1)*a**2*b**2*c**8 + (zeta3 + 1)*a*b**3*c**8), ((-1/3*zeta3 +
        1/3)*a**7*b**4*c + (-zeta3 + 1)*a**6*b**5*c + (-zeta3 +
        1)*a**5*b**6*c + (-1/3*zeta3 + 1/3)*a**4*b**7*c + (-zeta3 +
        1)*a**7*b**3*c**2 + (-4*zeta3 + 4)*a**6*b**4*c**2 + (-6*zeta3
        + 6)*a**5*b**5*c**2 + (-4*zeta3 + 4)*a**4*b**6*c**2 + (-zeta3
        + 1)*a**3*b**7*c**2 + (-zeta3 + 1)*a**7*b**2*c**3 + (-6*zeta3
        + 6)*a**6*b**3*c**3 + (-13*zeta3 + 13)*a**5*b**4*c**3 +
        (-13*zeta3 + 13)*a**4*b**5*c**3 + (-6*zeta3 +
        6)*a**3*b**6*c**3 + (-zeta3 + 1)*a**2*b**7*c**3 + (-1/3*zeta3
        + 1/3)*a**7*b*c**4 + (-4*zeta3 + 4)*a**6*b**2*c**4 +
        (-13*zeta3 + 13)*a**5*b**3*c**4 + (-56/3*zeta3 +
        56/3)*a**4*b**4*c**4 + (-13*zeta3 + 13)*a**3*b**5*c**4 +
        (-4*zeta3 + 4)*a**2*b**6*c**4 + (-1/3*zeta3 + 1/3)*a*b**7*c**4
        + (-zeta3 + 1)*a**6*b*c**5 + (-6*zeta3 + 6)*a**5*b**2*c**5 +
        (-13*zeta3 + 13)*a**4*b**3*c**5 + (-13*zeta3 +
        13)*a**3*b**4*c**5 + (-6*zeta3 + 6)*a**2*b**5*c**5 + (-zeta3 +
        1)*a*b**6*c**5 + (-zeta3 + 1)*a**5*b*c**6 + (-4*zeta3 +
        4)*a**4*b**2*c**6 + (-6*zeta3 + 6)*a**3*b**3*c**6 + (-4*zeta3
        + 4)*a**2*b**4*c**6 + (-zeta3 + 1)*a*b**5*c**6 + (-1/3*zeta3 +
        1/3)*a**4*b*c**7 + (-zeta3 + 1)*a**3*b**2*c**7 + (-zeta3 +
        1)*a**2*b**3*c**7 + (-1/3*zeta3 + 1/3)*a*b**4*c**7)/(a**7*b**5
        - a**6*b**6 + a**5*b**7 + (-zeta3)*a**8*b**3*c + (zeta3 -
        1)*a**7*b**4*c + (-zeta3)*a**6*b**5*c + (-zeta3)*a**5*b**6*c +
        (zeta3 - 1)*a**4*b**7*c + (-zeta3)*a**3*b**8*c +
        zeta3*a**8*b**2*c**2 + a**7*b**3*c**2 + (2*zeta3 +
        1)*a**5*b**5*c**2 + a**3*b**7*c**2 + zeta3*a**2*b**8*c**2 +
        (-zeta3)*a**8*b*c**3 + a**7*b**2*c**3 + (-zeta3 -
        2)*a**6*b**3*c**3 + (-zeta3 + 1)*a**5*b**4*c**3 + (-zeta3 +
        1)*a**4*b**5*c**3 + (-zeta3 - 2)*a**3*b**6*c**3 +
        a**2*b**7*c**3 + (-zeta3)*a*b**8*c**3 + (zeta3 -
        1)*a**7*b*c**4 + (-zeta3 + 1)*a**5*b**3*c**4 + (3*zeta3 -
        3)*a**4*b**4*c**4 + (-zeta3 + 1)*a**3*b**5*c**4 + (zeta3 -
        1)*a*b**7*c**4 + a**7*c**5 + (-zeta3)*a**6*b*c**5 + (2*zeta3 +
        1)*a**5*b**2*c**5 + (-zeta3 + 1)*a**4*b**3*c**5 + (-zeta3 +
        1)*a**3*b**4*c**5 + (2*zeta3 + 1)*a**2*b**5*c**5 +
        (-zeta3)*a*b**6*c**5 + b**7*c**5 - a**6*c**6 +
        (-zeta3)*a**5*b*c**6 + (-zeta3 - 2)*a**3*b**3*c**6 +
        (-zeta3)*a*b**5*c**6 - b**6*c**6 + a**5*c**7 + (zeta3 -
        1)*a**4*b*c**7 + a**3*b**2*c**7 + a**2*b**3*c**7 + (zeta3 -
        1)*a*b**4*c**7 + b**5*c**7 + (-zeta3)*a**3*b*c**8 +
        zeta3*a**2*b**2*c**8 + (-zeta3)*a*b**3*c**8)], 'K4U':
        [(-4*a**18*b**6*c**2 - 16*a**18*b**5*c**3 - 10*a**17*b**6*c**3
        - 4*a**16*b**7*c**3 + 2*a**15*b**8*c**3 - 24*a**18*b**4*c**4 -
        30*a**17*b**5*c**4 - 24*a**16*b**6*c**4 + 3*a**15*b**7*c**4 +
        3*a**13*b**9*c**4 - 16*a**18*b**3*c**5 - 30*a**17*b**4*c**5 -
        40*a**16*b**5*c**5 - 3*a**15*b**6*c**5 - 3*a**14*b**7*c**5 +
        9*a**13*b**8*c**5 + a**12*b**9*c**5 + 2*a**11*b**10*c**5 -
        4*a**18*b**2*c**6 - 10*a**17*b**3*c**6 - 24*a**16*b**4*c**6 -
        3*a**15*b**5*c**6 - 6*a**14*b**6*c**6 + 12*a**13*b**7*c**6 +
        5*a**11*b**9*c**6 - 2*a**10*b**10*c**6 - 4*a**16*b**3*c**7 +
        3*a**15*b**4*c**7 - 3*a**14*b**5*c**7 + 12*a**13*b**6*c**7 -
        2*a**12*b**7*c**7 + 4*a**11*b**8*c**7 - 16*a**10*b**9*c**7 -
        13*a**9*b**10*c**7 - 5*a**8*b**11*c**7 + 2*a**15*b**3*c**8 +
        9*a**13*b**5*c**8 + 4*a**11*b**7*c**8 - 28*a**10*b**8*c**8 -
        42*a**9*b**9*c**8 - 28*a**8*b**10*c**8 - 5*a**7*b**11*c**8 +
        3*a**13*b**4*c**9 + a**12*b**5*c**9 + 5*a**11*b**6*c**9 -
        16*a**10*b**7*c**9 - 42*a**9*b**8*c**9 - 46*a**8*b**9*c**9 -
        15*a**7*b**10*c**9 + 2*a**11*b**5*c**10 - 2*a**10*b**6*c**10 -
        13*a**9*b**7*c**10 - 28*a**8*b**8*c**10 - 15*a**7*b**9*c**10 -
        5*a**8*b**7*c**11 - 5*a**7*b**8*c**11)/(a**25*b - 3*a**24*b**2
        + 5*a**23*b**3 - 6*a**22*b**4 + 5*a**21*b**5 - 3*a**20*b**6 +
        a**19*b**7 + a**25*c - 5*a**24*b*c + 13*a**23*b**2*c -
        23*a**22*b**3*c + 30*a**21*b**4*c - 30*a**20*b**5*c +
        23*a**19*b**6*c - 13*a**18*b**7*c + 5*a**17*b**8*c -
        a**16*b**9*c - 3*a**24*c**2 + 13*a**23*b*c**2 -
        33*a**22*b**2*c**2 + 60*a**21*b**3*c**2 - 83*a**20*b**4*c**2 +
        91*a**19*b**5*c**2 - 79*a**18*b**6*c**2 + 54*a**17*b**7*c**2 -
        28*a**16*b**8*c**2 + 10*a**15*b**9*c**2 - 2*a**14*b**10*c**2 +
        5*a**23*c**3 - 23*a**22*b*c**3 + 60*a**21*b**2*c**3 -
        113*a**20*b**3*c**3 + 164*a**19*b**4*c**3 -
        191*a**18*b**5*c**3 + 180*a**17*b**6*c**3 -
        137*a**16*b**7*c**3 + 83*a**15*b**8*c**3 - 38*a**14*b**9*c**3
        + 12*a**13*b**10*c**3 - 2*a**12*b**11*c**3 - 6*a**22*c**4 +
        30*a**21*b*c**4 - 83*a**20*b**2*c**4 + 164*a**19*b**3*c**4 -
        250*a**18*b**4*c**4 + 307*a**17*b**5*c**4 -
        308*a**16*b**6*c**4 + 253*a**15*b**7*c**4 -
        169*a**14*b**8*c**4 + 89*a**13*b**9*c**4 - 35*a**12*b**10*c**4
        + 9*a**11*b**11*c**4 - a**10*b**12*c**4 + 5*a**21*c**5 -
        30*a**20*b*c**5 + 91*a**19*b**2*c**5 - 191*a**18*b**3*c**5 +
        307*a**17*b**4*c**5 - 395*a**16*b**5*c**5 +
        417*a**15*b**6*c**5 - 363*a**14*b**7*c**5 +
        260*a**13*b**8*c**5 - 151*a**12*b**9*c**5 +
        68*a**11*b**10*c**5 - 22*a**10*b**11*c**5 + 4*a**9*b**12*c**5
        - 3*a**20*c**6 + 23*a**19*b*c**6 - 79*a**18*b**2*c**6 +
        180*a**17*b**3*c**6 - 308*a**16*b**4*c**6 +
        417*a**15*b**5*c**6 - 461*a**14*b**6*c**6 +
        420*a**13*b**7*c**6 - 316*a**12*b**8*c**6 +
        195*a**11*b**9*c**6 - 96*a**10*b**10*c**6 + 36*a**9*b**11*c**6
        - 9*a**8*b**12*c**6 + a**7*b**13*c**6 + a**19*c**7 -
        13*a**18*b*c**7 + 54*a**17*b**2*c**7 - 137*a**16*b**3*c**7 +
        253*a**15*b**4*c**7 - 363*a**14*b**5*c**7 +
        420*a**13*b**6*c**7 - 398*a**12*b**7*c**7 +
        310*a**11*b**8*c**7 - 198*a**10*b**9*c**7 +
        102*a**9*b**10*c**7 - 41*a**8*b**11*c**7 + 12*a**7*b**12*c**7
        - 2*a**6*b**13*c**7 + 5*a**17*b*c**8 - 28*a**16*b**2*c**8 +
        83*a**15*b**3*c**8 - 169*a**14*b**4*c**8 + 260*a**13*b**5*c**8
        - 316*a**12*b**6*c**8 + 310*a**11*b**7*c**8 -
        247*a**10*b**8*c**8 + 159*a**9*b**9*c**8 - 82*a**8*b**10*c**8
        + 33*a**7*b**11*c**8 - 10*a**6*b**12*c**8 + 2*a**5*b**13*c**8
        - a**16*b*c**9 + 10*a**15*b**2*c**9 - 38*a**14*b**3*c**9 +
        89*a**13*b**4*c**9 - 151*a**12*b**5*c**9 + 195*a**11*b**6*c**9
        - 198*a**10*b**7*c**9 + 159*a**9*b**8*c**9 - 99*a**8*b**9*c**9
        + 47*a**7*b**10*c**9 - 16*a**6*b**11*c**9 + 4*a**5*b**12*c**9
        - a**4*b**13*c**9 - 2*a**14*b**2*c**10 + 12*a**13*b**3*c**10 -
        35*a**12*b**4*c**10 + 68*a**11*b**5*c**10 -
        96*a**10*b**6*c**10 + 102*a**9*b**7*c**10 - 82*a**8*b**8*c**10
        + 47*a**7*b**9*c**10 - 16*a**6*b**10*c**10 +
        3*a**4*b**12*c**10 - a**3*b**13*c**10 - 2*a**12*b**3*c**11 +
        9*a**11*b**4*c**11 - 22*a**10*b**5*c**11 + 36*a**9*b**6*c**11
        - 41*a**8*b**7*c**11 + 33*a**7*b**8*c**11 - 16*a**6*b**9*c**11
        + 7*a**4*b**11*c**11 - 6*a**3*b**12*c**11 + 2*a**2*b**13*c**11
        - a**10*b**4*c**12 + 4*a**9*b**5*c**12 - 9*a**8*b**6*c**12 +
        12*a**7*b**7*c**12 - 10*a**6*b**8*c**12 + 4*a**5*b**9*c**12 +
        3*a**4*b**10*c**12 - 6*a**3*b**11*c**12 + 5*a**2*b**12*c**12 -
        2*a*b**13*c**12 + a**7*b**6*c**13 - 2*a**6*b**7*c**13 +
        2*a**5*b**8*c**13 - a**4*b**9*c**13 - a**3*b**10*c**13 +
        2*a**2*b**11*c**13 - 2*a*b**12*c**13 + b**13*c**13),
        (-5*a**11*b**8*c**7 - 15*a**10*b**9*c**7 - 15*a**9*b**10*c**7
        - 5*a**8*b**11*c**7 - 5*a**11*b**7*c**8 - 28*a**10*b**8*c**8 -
        46*a**9*b**9*c**8 - 28*a**8*b**10*c**8 - 5*a**7*b**11*c**8 -
        13*a**10*b**7*c**9 - 42*a**9*b**8*c**9 - 42*a**8*b**9*c**9 -
        13*a**7*b**10*c**9 - 2*a**10*b**6*c**10 - 16*a**9*b**7*c**10 -
        28*a**8*b**8*c**10 - 16*a**7*b**9*c**10 - 2*a**6*b**10*c**10 +
        2*a**10*b**5*c**11 + 5*a**9*b**6*c**11 + 4*a**8*b**7*c**11 +
        4*a**7*b**8*c**11 + 5*a**6*b**9*c**11 + 2*a**5*b**10*c**11 +
        a**9*b**5*c**12 - 2*a**7*b**7*c**12 + a**5*b**9*c**12 +
        3*a**9*b**4*c**13 + 9*a**8*b**5*c**13 + 12*a**7*b**6*c**13 +
        12*a**6*b**7*c**13 + 9*a**5*b**8*c**13 + 3*a**4*b**9*c**13 -
        3*a**7*b**5*c**14 - 6*a**6*b**6*c**14 - 3*a**5*b**7*c**14 +
        2*a**8*b**3*c**15 + 3*a**7*b**4*c**15 - 3*a**6*b**5*c**15 -
        3*a**5*b**6*c**15 + 3*a**4*b**7*c**15 + 2*a**3*b**8*c**15 -
        4*a**7*b**3*c**16 - 24*a**6*b**4*c**16 - 40*a**5*b**5*c**16 -
        24*a**4*b**6*c**16 - 4*a**3*b**7*c**16 - 10*a**6*b**3*c**17 -
        30*a**5*b**4*c**17 - 30*a**4*b**5*c**17 - 10*a**3*b**6*c**17 -
        4*a**6*b**2*c**18 - 16*a**5*b**3*c**18 - 24*a**4*b**4*c**18 -
        16*a**3*b**5*c**18 - 4*a**2*b**6*c**18)/(a**13*b**13 -
        2*a**13*b**12*c - 2*a**12*b**13*c + 2*a**13*b**11*c**2 +
        5*a**12*b**12*c**2 + 2*a**11*b**13*c**2 - a**13*b**10*c**3 -
        6*a**12*b**11*c**3 - 6*a**11*b**12*c**3 - a**10*b**13*c**3 -
        a**13*b**9*c**4 + 3*a**12*b**10*c**4 + 7*a**11*b**11*c**4 +
        3*a**10*b**12*c**4 - a**9*b**13*c**4 + 2*a**13*b**8*c**5 +
        4*a**12*b**9*c**5 + 4*a**9*b**12*c**5 + 2*a**8*b**13*c**5 -
        2*a**13*b**7*c**6 - 10*a**12*b**8*c**6 - 16*a**11*b**9*c**6 -
        16*a**10*b**10*c**6 - 16*a**9*b**11*c**6 - 10*a**8*b**12*c**6
        - 2*a**7*b**13*c**6 + a**13*b**6*c**7 + 12*a**12*b**7*c**7 +
        33*a**11*b**8*c**7 + 47*a**10*b**9*c**7 + 47*a**9*b**10*c**7 +
        33*a**8*b**11*c**7 + 12*a**7*b**12*c**7 + a**6*b**13*c**7 -
        9*a**12*b**6*c**8 - 41*a**11*b**7*c**8 - 82*a**10*b**8*c**8 -
        99*a**9*b**9*c**8 - 82*a**8*b**10*c**8 - 41*a**7*b**11*c**8 -
        9*a**6*b**12*c**8 + 4*a**12*b**5*c**9 + 36*a**11*b**6*c**9 +
        102*a**10*b**7*c**9 + 159*a**9*b**8*c**9 + 159*a**8*b**9*c**9
        + 102*a**7*b**10*c**9 + 36*a**6*b**11*c**9 + 4*a**5*b**12*c**9
        - a**12*b**4*c**10 - 22*a**11*b**5*c**10 - 96*a**10*b**6*c**10
        - 198*a**9*b**7*c**10 - 247*a**8*b**8*c**10 -
        198*a**7*b**9*c**10 - 96*a**6*b**10*c**10 -
        22*a**5*b**11*c**10 - a**4*b**12*c**10 + 9*a**11*b**4*c**11 +
        68*a**10*b**5*c**11 + 195*a**9*b**6*c**11 +
        310*a**8*b**7*c**11 + 310*a**7*b**8*c**11 +
        195*a**6*b**9*c**11 + 68*a**5*b**10*c**11 + 9*a**4*b**11*c**11
        - 2*a**11*b**3*c**12 - 35*a**10*b**4*c**12 -
        151*a**9*b**5*c**12 - 316*a**8*b**6*c**12 -
        398*a**7*b**7*c**12 - 316*a**6*b**8*c**12 -
        151*a**5*b**9*c**12 - 35*a**4*b**10*c**12 - 2*a**3*b**11*c**12
        + 12*a**10*b**3*c**13 + 89*a**9*b**4*c**13 +
        260*a**8*b**5*c**13 + 420*a**7*b**6*c**13 +
        420*a**6*b**7*c**13 + 260*a**5*b**8*c**13 + 89*a**4*b**9*c**13
        + 12*a**3*b**10*c**13 - 2*a**10*b**2*c**14 -
        38*a**9*b**3*c**14 - 169*a**8*b**4*c**14 - 363*a**7*b**5*c**14
        - 461*a**6*b**6*c**14 - 363*a**5*b**7*c**14 -
        169*a**4*b**8*c**14 - 38*a**3*b**9*c**14 - 2*a**2*b**10*c**14
        + 10*a**9*b**2*c**15 + 83*a**8*b**3*c**15 +
        253*a**7*b**4*c**15 + 417*a**6*b**5*c**15 +
        417*a**5*b**6*c**15 + 253*a**4*b**7*c**15 + 83*a**3*b**8*c**15
        + 10*a**2*b**9*c**15 - a**9*b*c**16 - 28*a**8*b**2*c**16 -
        137*a**7*b**3*c**16 - 308*a**6*b**4*c**16 -
        395*a**5*b**5*c**16 - 308*a**4*b**6*c**16 -
        137*a**3*b**7*c**16 - 28*a**2*b**8*c**16 - a*b**9*c**16 +
        5*a**8*b*c**17 + 54*a**7*b**2*c**17 + 180*a**6*b**3*c**17 +
        307*a**5*b**4*c**17 + 307*a**4*b**5*c**17 +
        180*a**3*b**6*c**17 + 54*a**2*b**7*c**17 + 5*a*b**8*c**17 -
        13*a**7*b*c**18 - 79*a**6*b**2*c**18 - 191*a**5*b**3*c**18 -
        250*a**4*b**4*c**18 - 191*a**3*b**5*c**18 - 79*a**2*b**6*c**18
        - 13*a*b**7*c**18 + a**7*c**19 + 23*a**6*b*c**19 +
        91*a**5*b**2*c**19 + 164*a**4*b**3*c**19 + 164*a**3*b**4*c**19
        + 91*a**2*b**5*c**19 + 23*a*b**6*c**19 + b**7*c**19 -
        3*a**6*c**20 - 30*a**5*b*c**20 - 83*a**4*b**2*c**20 -
        113*a**3*b**3*c**20 - 83*a**2*b**4*c**20 - 30*a*b**5*c**20 -
        3*b**6*c**20 + 5*a**5*c**21 + 30*a**4*b*c**21 +
        60*a**3*b**2*c**21 + 60*a**2*b**3*c**21 + 30*a*b**4*c**21 +
        5*b**5*c**21 - 6*a**4*c**22 - 23*a**3*b*c**22 -
        33*a**2*b**2*c**22 - 23*a*b**3*c**22 - 6*b**4*c**22 +
        5*a**3*c**23 + 13*a**2*b*c**23 + 13*a*b**2*c**23 +
        5*b**3*c**23 - 3*a**2*c**24 - 5*a*b*c**24 - 3*b**2*c**24 +
        a*c**25 + b*c**25), (-4*a**6*b**18*c**2 + 2*a**8*b**15*c**3 -
        4*a**7*b**16*c**3 - 10*a**6*b**17*c**3 - 16*a**5*b**18*c**3 +
        3*a**9*b**13*c**4 + 3*a**7*b**15*c**4 - 24*a**6*b**16*c**4 -
        30*a**5*b**17*c**4 - 24*a**4*b**18*c**4 + 2*a**10*b**11*c**5 +
        a**9*b**12*c**5 + 9*a**8*b**13*c**5 - 3*a**7*b**14*c**5 -
        3*a**6*b**15*c**5 - 40*a**5*b**16*c**5 - 30*a**4*b**17*c**5 -
        16*a**3*b**18*c**5 - 2*a**10*b**10*c**6 + 5*a**9*b**11*c**6 +
        12*a**7*b**13*c**6 - 6*a**6*b**14*c**6 - 3*a**5*b**15*c**6 -
        24*a**4*b**16*c**6 - 10*a**3*b**17*c**6 - 4*a**2*b**18*c**6 -
        5*a**11*b**8*c**7 - 13*a**10*b**9*c**7 - 16*a**9*b**10*c**7 +
        4*a**8*b**11*c**7 - 2*a**7*b**12*c**7 + 12*a**6*b**13*c**7 -
        3*a**5*b**14*c**7 + 3*a**4*b**15*c**7 - 4*a**3*b**16*c**7 -
        5*a**11*b**7*c**8 - 28*a**10*b**8*c**8 - 42*a**9*b**9*c**8 -
        28*a**8*b**10*c**8 + 4*a**7*b**11*c**8 + 9*a**5*b**13*c**8 +
        2*a**3*b**15*c**8 - 15*a**10*b**7*c**9 - 46*a**9*b**8*c**9 -
        42*a**8*b**9*c**9 - 16*a**7*b**10*c**9 + 5*a**6*b**11*c**9 +
        a**5*b**12*c**9 + 3*a**4*b**13*c**9 - 15*a**9*b**7*c**10 -
        28*a**8*b**8*c**10 - 13*a**7*b**9*c**10 - 2*a**6*b**10*c**10 +
        2*a**5*b**11*c**10 - 5*a**8*b**7*c**11 -
        5*a**7*b**8*c**11)/(a**7*b**19 - 3*a**6*b**20 + 5*a**5*b**21 -
        6*a**4*b**22 + 5*a**3*b**23 - 3*a**2*b**24 + a*b**25 -
        a**9*b**16*c + 5*a**8*b**17*c - 13*a**7*b**18*c +
        23*a**6*b**19*c - 30*a**5*b**20*c + 30*a**4*b**21*c -
        23*a**3*b**22*c + 13*a**2*b**23*c - 5*a*b**24*c + b**25*c -
        2*a**10*b**14*c**2 + 10*a**9*b**15*c**2 - 28*a**8*b**16*c**2 +
        54*a**7*b**17*c**2 - 79*a**6*b**18*c**2 + 91*a**5*b**19*c**2 -
        83*a**4*b**20*c**2 + 60*a**3*b**21*c**2 - 33*a**2*b**22*c**2 +
        13*a*b**23*c**2 - 3*b**24*c**2 - 2*a**11*b**12*c**3 +
        12*a**10*b**13*c**3 - 38*a**9*b**14*c**3 + 83*a**8*b**15*c**3
        - 137*a**7*b**16*c**3 + 180*a**6*b**17*c**3 -
        191*a**5*b**18*c**3 + 164*a**4*b**19*c**3 -
        113*a**3*b**20*c**3 + 60*a**2*b**21*c**3 - 23*a*b**22*c**3 +
        5*b**23*c**3 - a**12*b**10*c**4 + 9*a**11*b**11*c**4 -
        35*a**10*b**12*c**4 + 89*a**9*b**13*c**4 - 169*a**8*b**14*c**4
        + 253*a**7*b**15*c**4 - 308*a**6*b**16*c**4 +
        307*a**5*b**17*c**4 - 250*a**4*b**18*c**4 +
        164*a**3*b**19*c**4 - 83*a**2*b**20*c**4 + 30*a*b**21*c**4 -
        6*b**22*c**4 + 4*a**12*b**9*c**5 - 22*a**11*b**10*c**5 +
        68*a**10*b**11*c**5 - 151*a**9*b**12*c**5 +
        260*a**8*b**13*c**5 - 363*a**7*b**14*c**5 +
        417*a**6*b**15*c**5 - 395*a**5*b**16*c**5 +
        307*a**4*b**17*c**5 - 191*a**3*b**18*c**5 + 91*a**2*b**19*c**5
        - 30*a*b**20*c**5 + 5*b**21*c**5 + a**13*b**7*c**6 -
        9*a**12*b**8*c**6 + 36*a**11*b**9*c**6 - 96*a**10*b**10*c**6 +
        195*a**9*b**11*c**6 - 316*a**8*b**12*c**6 +
        420*a**7*b**13*c**6 - 461*a**6*b**14*c**6 +
        417*a**5*b**15*c**6 - 308*a**4*b**16*c**6 +
        180*a**3*b**17*c**6 - 79*a**2*b**18*c**6 + 23*a*b**19*c**6 -
        3*b**20*c**6 - 2*a**13*b**6*c**7 + 12*a**12*b**7*c**7 -
        41*a**11*b**8*c**7 + 102*a**10*b**9*c**7 - 198*a**9*b**10*c**7
        + 310*a**8*b**11*c**7 - 398*a**7*b**12*c**7 +
        420*a**6*b**13*c**7 - 363*a**5*b**14*c**7 +
        253*a**4*b**15*c**7 - 137*a**3*b**16*c**7 + 54*a**2*b**17*c**7
        - 13*a*b**18*c**7 + b**19*c**7 + 2*a**13*b**5*c**8 -
        10*a**12*b**6*c**8 + 33*a**11*b**7*c**8 - 82*a**10*b**8*c**8 +
        159*a**9*b**9*c**8 - 247*a**8*b**10*c**8 + 310*a**7*b**11*c**8
        - 316*a**6*b**12*c**8 + 260*a**5*b**13*c**8 -
        169*a**4*b**14*c**8 + 83*a**3*b**15*c**8 - 28*a**2*b**16*c**8
        + 5*a*b**17*c**8 - a**13*b**4*c**9 + 4*a**12*b**5*c**9 -
        16*a**11*b**6*c**9 + 47*a**10*b**7*c**9 - 99*a**9*b**8*c**9 +
        159*a**8*b**9*c**9 - 198*a**7*b**10*c**9 + 195*a**6*b**11*c**9
        - 151*a**5*b**12*c**9 + 89*a**4*b**13*c**9 -
        38*a**3*b**14*c**9 + 10*a**2*b**15*c**9 - a*b**16*c**9 -
        a**13*b**3*c**10 + 3*a**12*b**4*c**10 - 16*a**10*b**6*c**10 +
        47*a**9*b**7*c**10 - 82*a**8*b**8*c**10 + 102*a**7*b**9*c**10
        - 96*a**6*b**10*c**10 + 68*a**5*b**11*c**10 -
        35*a**4*b**12*c**10 + 12*a**3*b**13*c**10 - 2*a**2*b**14*c**10
        + 2*a**13*b**2*c**11 - 6*a**12*b**3*c**11 + 7*a**11*b**4*c**11
        - 16*a**9*b**6*c**11 + 33*a**8*b**7*c**11 - 41*a**7*b**8*c**11
        + 36*a**6*b**9*c**11 - 22*a**5*b**10*c**11 +
        9*a**4*b**11*c**11 - 2*a**3*b**12*c**11 - 2*a**13*b*c**12 +
        5*a**12*b**2*c**12 - 6*a**11*b**3*c**12 + 3*a**10*b**4*c**12 +
        4*a**9*b**5*c**12 - 10*a**8*b**6*c**12 + 12*a**7*b**7*c**12 -
        9*a**6*b**8*c**12 + 4*a**5*b**9*c**12 - a**4*b**10*c**12 +
        a**13*c**13 - 2*a**12*b*c**13 + 2*a**11*b**2*c**13 -
        a**10*b**3*c**13 - a**9*b**4*c**13 + 2*a**8*b**5*c**13 -
        2*a**7*b**6*c**13 + a**6*b**7*c**13), (-5*a**9*b**4*c**3 -
        8*a**8*b**5*c**3 + a**6*b**7*c**3 - 5*a**9*b**3*c**4 -
        20*a**8*b**4*c**4 - 14*a**7*b**5*c**4 + 3*a**6*b**6*c**4 +
        2*a**5*b**7*c**4 - 8*a**8*b**3*c**5 - 14*a**7*b**4*c**5 -
        4*a**6*b**5*c**5 - 4*a**5*b**6*c**5 - 5*a**4*b**7*c**5 +
        3*a**6*b**4*c**6 - 4*a**5*b**5*c**6 - 18*a**4*b**6*c**6 -
        10*a**3*b**7*c**6 + a**6*b**3*c**7 + 2*a**5*b**4*c**7 -
        5*a**4*b**5*c**7 - 10*a**3*b**6*c**7 -
        4*a**2*b**7*c**7)/(a**11*b**5 - 2*a**10*b**6 + a**9*b**7 -
        2*a**11*b**4*c + 3*a**10*b**5*c + 2*a**9*b**6*c -
        5*a**8*b**7*c + 2*a**7*b**8*c + a**11*b**3*c**2 -
        a**10*b**4*c**2 - 6*a**9*b**5*c**2 + 9*a**8*b**6*c**2 +
        a**7*b**7*c**2 - 6*a**6*b**8*c**2 + 2*a**5*b**9*c**2 +
        a**11*b**2*c**3 + 3*a**9*b**4*c**3 - 7*a**8*b**5*c**3 -
        6*a**7*b**6*c**3 + 13*a**6*b**7*c**3 - a**5*b**8*c**3 -
        4*a**4*b**9*c**3 + a**3*b**10*c**3 - 2*a**11*b*c**4 -
        a**10*b**2*c**4 + 3*a**9*b**3*c**4 + 6*a**8*b**4*c**4 +
        3*a**7*b**5*c**4 - 15*a**6*b**6*c**4 - 2*a**5*b**7*c**4 +
        11*a**4*b**8*c**4 - 2*a**3*b**9*c**4 - a**2*b**10*c**4 +
        a**11*c**5 + 3*a**10*b*c**5 - 6*a**9*b**2*c**5 -
        7*a**8*b**3*c**5 + 3*a**7*b**4*c**5 + 16*a**6*b**5*c**5 +
        a**5*b**6*c**5 - 17*a**4*b**7*c**5 + 2*a**3*b**8*c**5 +
        5*a**2*b**9*c**5 - a*b**10*c**5 - 2*a**10*c**6 + 2*a**9*b*c**6
        + 9*a**8*b**2*c**6 - 6*a**7*b**3*c**6 - 15*a**6*b**4*c**6 +
        a**5*b**5*c**6 + 20*a**4*b**6*c**6 - a**3*b**7*c**6 -
        11*a**2*b**8*c**6 + 2*a*b**9*c**6 + b**10*c**6 + a**9*c**7 -
        5*a**8*b*c**7 + a**7*b**2*c**7 + 13*a**6*b**3*c**7 -
        2*a**5*b**4*c**7 - 17*a**4*b**5*c**7 - a**3*b**6*c**7 +
        14*a**2*b**7*c**7 - a*b**8*c**7 - 3*b**9*c**7 + 2*a**7*b*c**8
        - 6*a**6*b**2*c**8 - a**5*b**3*c**8 + 11*a**4*b**4*c**8 +
        2*a**3*b**5*c**8 - 11*a**2*b**6*c**8 - a*b**7*c**8 +
        4*b**8*c**8 + 2*a**5*b**2*c**9 - 4*a**4*b**3*c**9 -
        2*a**3*b**4*c**9 + 5*a**2*b**5*c**9 + 2*a*b**6*c**9 -
        3*b**7*c**9 + a**3*b**3*c**10 - a**2*b**4*c**10 - a*b**5*c**10
        + b**6*c**10), (-4*a**7*b**7*c**2 - 10*a**7*b**6*c**3 -
        10*a**6*b**7*c**3 - 5*a**7*b**5*c**4 - 18*a**6*b**6*c**4 -
        5*a**5*b**7*c**4 + 2*a**7*b**4*c**5 - 4*a**6*b**5*c**5 -
        4*a**5*b**6*c**5 + 2*a**4*b**7*c**5 + a**7*b**3*c**6 +
        3*a**6*b**4*c**6 - 4*a**5*b**5*c**6 + 3*a**4*b**6*c**6 +
        a**3*b**7*c**6 - 14*a**5*b**4*c**7 - 14*a**4*b**5*c**7 -
        8*a**5*b**3*c**8 - 20*a**4*b**4*c**8 - 8*a**3*b**5*c**8 -
        5*a**4*b**3*c**9 - 5*a**3*b**4*c**9)/(a**10*b**6 - 3*a**9*b**7
        + 4*a**8*b**8 - 3*a**7*b**9 + a**6*b**10 - a**10*b**5*c +
        2*a**9*b**6*c - a**8*b**7*c - a**7*b**8*c + 2*a**6*b**9*c -
        a**5*b**10*c - a**10*b**4*c**2 + 5*a**9*b**5*c**2 -
        11*a**8*b**6*c**2 + 14*a**7*b**7*c**2 - 11*a**6*b**8*c**2 +
        5*a**5*b**9*c**2 - a**4*b**10*c**2 + a**10*b**3*c**3 -
        2*a**9*b**4*c**3 + 2*a**8*b**5*c**3 - a**7*b**6*c**3 -
        a**6*b**7*c**3 + 2*a**5*b**8*c**3 - 2*a**4*b**9*c**3 +
        a**3*b**10*c**3 - 4*a**9*b**3*c**4 + 11*a**8*b**4*c**4 -
        17*a**7*b**5*c**4 + 20*a**6*b**6*c**4 - 17*a**5*b**7*c**4 +
        11*a**4*b**8*c**4 - 4*a**3*b**9*c**4 + 2*a**9*b**2*c**5 -
        a**8*b**3*c**5 - 2*a**7*b**4*c**5 + a**6*b**5*c**5 +
        a**5*b**6*c**5 - 2*a**4*b**7*c**5 - a**3*b**8*c**5 +
        2*a**2*b**9*c**5 - 6*a**8*b**2*c**6 + 13*a**7*b**3*c**6 -
        15*a**6*b**4*c**6 + 16*a**5*b**5*c**6 - 15*a**4*b**6*c**6 +
        13*a**3*b**7*c**6 - 6*a**2*b**8*c**6 + 2*a**8*b*c**7 +
        a**7*b**2*c**7 - 6*a**6*b**3*c**7 + 3*a**5*b**4*c**7 +
        3*a**4*b**5*c**7 - 6*a**3*b**6*c**7 + a**2*b**7*c**7 +
        2*a*b**8*c**7 - 5*a**7*b*c**8 + 9*a**6*b**2*c**8 -
        7*a**5*b**3*c**8 + 6*a**4*b**4*c**8 - 7*a**3*b**5*c**8 +
        9*a**2*b**6*c**8 - 5*a*b**7*c**8 + a**7*c**9 + 2*a**6*b*c**9 -
        6*a**5*b**2*c**9 + 3*a**4*b**3*c**9 + 3*a**3*b**4*c**9 -
        6*a**2*b**5*c**9 + 2*a*b**6*c**9 + b**7*c**9 - 2*a**6*c**10 +
        3*a**5*b*c**10 - a**4*b**2*c**10 - a**2*b**4*c**10 +
        3*a*b**5*c**10 - 2*b**6*c**10 + a**5*c**11 - 2*a**4*b*c**11 +
        a**3*b**2*c**11 + a**2*b**3*c**11 - 2*a*b**4*c**11 +
        b**5*c**11), (a**7*b**6*c**3 - 8*a**5*b**8*c**3 -
        5*a**4*b**9*c**3 + 2*a**7*b**5*c**4 + 3*a**6*b**6*c**4 -
        14*a**5*b**7*c**4 - 20*a**4*b**8*c**4 - 5*a**3*b**9*c**4 -
        5*a**7*b**4*c**5 - 4*a**6*b**5*c**5 - 4*a**5*b**6*c**5 -
        14*a**4*b**7*c**5 - 8*a**3*b**8*c**5 - 10*a**7*b**3*c**6 -
        18*a**6*b**4*c**6 - 4*a**5*b**5*c**6 + 3*a**4*b**6*c**6 -
        4*a**7*b**2*c**7 - 10*a**6*b**3*c**7 - 5*a**5*b**4*c**7 +
        2*a**4*b**5*c**7 + a**3*b**6*c**7)/(a**7*b**9 - 2*a**6*b**10 +
        a**5*b**11 + 2*a**8*b**7*c - 5*a**7*b**8*c + 2*a**6*b**9*c +
        3*a**5*b**10*c - 2*a**4*b**11*c + 2*a**9*b**5*c**2 -
        6*a**8*b**6*c**2 + a**7*b**7*c**2 + 9*a**6*b**8*c**2 -
        6*a**5*b**9*c**2 - a**4*b**10*c**2 + a**3*b**11*c**2 +
        a**10*b**3*c**3 - 4*a**9*b**4*c**3 - a**8*b**5*c**3 +
        13*a**7*b**6*c**3 - 6*a**6*b**7*c**3 - 7*a**5*b**8*c**3 +
        3*a**4*b**9*c**3 + a**2*b**11*c**3 - a**10*b**2*c**4 -
        2*a**9*b**3*c**4 + 11*a**8*b**4*c**4 - 2*a**7*b**5*c**4 -
        15*a**6*b**6*c**4 + 3*a**5*b**7*c**4 + 6*a**4*b**8*c**4 +
        3*a**3*b**9*c**4 - a**2*b**10*c**4 - 2*a*b**11*c**4 -
        a**10*b*c**5 + 5*a**9*b**2*c**5 + 2*a**8*b**3*c**5 -
        17*a**7*b**4*c**5 + a**6*b**5*c**5 + 16*a**5*b**6*c**5 +
        3*a**4*b**7*c**5 - 7*a**3*b**8*c**5 - 6*a**2*b**9*c**5 +
        3*a*b**10*c**5 + b**11*c**5 + a**10*c**6 + 2*a**9*b*c**6 -
        11*a**8*b**2*c**6 - a**7*b**3*c**6 + 20*a**6*b**4*c**6 +
        a**5*b**5*c**6 - 15*a**4*b**6*c**6 - 6*a**3*b**7*c**6 +
        9*a**2*b**8*c**6 + 2*a*b**9*c**6 - 2*b**10*c**6 - 3*a**9*c**7
        - a**8*b*c**7 + 14*a**7*b**2*c**7 - a**6*b**3*c**7 -
        17*a**5*b**4*c**7 - 2*a**4*b**5*c**7 + 13*a**3*b**6*c**7 +
        a**2*b**7*c**7 - 5*a*b**8*c**7 + b**9*c**7 + 4*a**8*c**8 -
        a**7*b*c**8 - 11*a**6*b**2*c**8 + 2*a**5*b**3*c**8 +
        11*a**4*b**4*c**8 - a**3*b**5*c**8 - 6*a**2*b**6*c**8 +
        2*a*b**7*c**8 - 3*a**7*c**9 + 2*a**6*b*c**9 + 5*a**5*b**2*c**9
        - 2*a**4*b**3*c**9 - 4*a**3*b**4*c**9 + 2*a**2*b**5*c**9 +
        a**6*c**10 - a**5*b*c**10 - a**4*b**2*c**10 +
        a**3*b**3*c**10), (a**7*b**5*c**2 + 2*a**6*b**6*c**2 +
        a**5*b**7*c**2 + 4*a**7*b**4*c**3 + 22*a**6*b**5*c**3 +
        22*a**5*b**6*c**3 + 4*a**4*b**7*c**3 + 4*a**7*b**3*c**4 +
        40*a**6*b**4*c**4 + 72*a**5*b**5*c**4 + 40*a**4*b**6*c**4 +
        4*a**3*b**7*c**4 + a**7*b**2*c**5 + 22*a**6*b**3*c**5 +
        72*a**5*b**4*c**5 + 72*a**4*b**5*c**5 + 22*a**3*b**6*c**5 +
        a**2*b**7*c**5 + 2*a**6*b**2*c**6 + 22*a**5*b**3*c**6 +
        40*a**4*b**4*c**6 + 22*a**3*b**5*c**6 + 2*a**2*b**6*c**6 +
        a**5*b**2*c**7 + 4*a**4*b**3*c**7 + 4*a**3*b**4*c**7 +
        a**2*b**5*c**7)/(a**8*b**6 - 2*a**7*b**7 + a**6*b**8 +
        a**9*b**4*c - 3*a**8*b**5*c + 2*a**7*b**6*c + 2*a**6*b**7*c -
        3*a**5*b**8*c + a**4*b**9*c - a**9*b**3*c**2 +
        5*a**7*b**5*c**2 - 8*a**6*b**6*c**2 + 5*a**5*b**7*c**2 -
        a**3*b**9*c**2 - a**9*b**2*c**3 + 4*a**8*b**3*c**3 -
        5*a**7*b**4*c**3 + 2*a**6*b**5*c**3 + 2*a**5*b**6*c**3 -
        5*a**4*b**7*c**3 + 4*a**3*b**8*c**3 - a**2*b**9*c**3 +
        a**9*b*c**4 - 5*a**7*b**3*c**4 + 6*a**6*b**4*c**4 -
        4*a**5*b**5*c**4 + 6*a**4*b**6*c**4 - 5*a**3*b**7*c**4 +
        a*b**9*c**4 - 3*a**8*b*c**5 + 5*a**7*b**2*c**5 +
        2*a**6*b**3*c**5 - 4*a**5*b**4*c**5 - 4*a**4*b**5*c**5 +
        2*a**3*b**6*c**5 + 5*a**2*b**7*c**5 - 3*a*b**8*c**5 +
        a**8*c**6 + 2*a**7*b*c**6 - 8*a**6*b**2*c**6 +
        2*a**5*b**3*c**6 + 6*a**4*b**4*c**6 + 2*a**3*b**5*c**6 -
        8*a**2*b**6*c**6 + 2*a*b**7*c**6 + b**8*c**6 - 2*a**7*c**7 +
        2*a**6*b*c**7 + 5*a**5*b**2*c**7 - 5*a**4*b**3*c**7 -
        5*a**3*b**4*c**7 + 5*a**2*b**5*c**7 + 2*a*b**6*c**7 -
        2*b**7*c**7 + a**6*c**8 - 3*a**5*b*c**8 + 4*a**3*b**3*c**8 -
        3*a*b**5*c**8 + b**6*c**8 + a**4*b*c**9 - a**3*b**2*c**9 -
        a**2*b**3*c**9 + a*b**4*c**9), (4*a**6*b**10*c**2 +
        2*a**7*b**8*c**3 + 8*a**6*b**9*c**3 + 14*a**5*b**10*c**3 +
        a**7*b**7*c**4 + 10*a**6*b**8*c**4 + 19*a**5*b**9*c**4 +
        18*a**4*b**10*c**4 - 2*a**7*b**6*c**5 + a**6*b**7*c**5 +
        10*a**5*b**8*c**5 + 13*a**4*b**9*c**5 + 10*a**3*b**10*c**5 +
        a**7*b**5*c**6 - 3*a**6*b**6*c**6 - a**4*b**8*c**6 +
        a**3*b**9*c**6 + 2*a**2*b**10*c**6 + 3*a**7*b**4*c**7 +
        13*a**6*b**5*c**7 + 9*a**5*b**6*c**7 + 4*a**4*b**7*c**7 -
        4*a**3*b**8*c**7 - a**2*b**9*c**7 + 11*a**6*b**4*c**8 +
        30*a**5*b**5*c**8 + 18*a**4*b**6*c**8 + 6*a**3*b**7*c**8 -
        a**2*b**8*c**8 + 13*a**5*b**4*c**9 + 23*a**4*b**5*c**9 +
        8*a**3*b**6*c**9 + 2*a**2*b**7*c**9 + 5*a**4*b**4*c**10 +
        5*a**3*b**5*c**10)/(a**8*b**10 - 2*a**7*b**11 + 2*a**6*b**12 -
        2*a**5*b**13 + a**4*b**14 + a**9*b**8*c - 4*a**8*b**9*c +
        6*a**7*b**10*c - 6*a**6*b**11*c + 5*a**5*b**12*c -
        2*a**4*b**13*c - 2*a**9*b**7*c**2 + 5*a**8*b**8*c**2 -
        6*a**7*b**9*c**2 + 5*a**6*b**10*c**2 - 2*a**5*b**11*c**2 -
        a**4*b**12*c**2 + 2*a**3*b**13*c**2 - a**2*b**14*c**2 +
        a**9*b**6*c**3 - a**8*b**7*c**3 - a**7*b**8*c**3 +
        5*a**6*b**9*c**3 - 9*a**5*b**10*c**3 + 9*a**4*b**11*c**3 -
        7*a**3*b**12*c**3 + 3*a**2*b**13*c**3 + a**9*b**5*c**4 -
        4*a**8*b**6*c**4 + 8*a**7*b**7*c**4 - 15*a**6*b**8*c**4 +
        18*a**5*b**9*c**4 - 14*a**4*b**10*c**4 + 10*a**3*b**11*c**4 -
        3*a**2*b**12*c**4 - a*b**13*c**4 - 2*a**9*b**4*c**5 +
        4*a**8*b**5*c**5 - 6*a**7*b**6*c**5 + 13*a**6*b**7*c**5 -
        12*a**5*b**8*c**5 + 6*a**4*b**9*c**5 - 4*a**3*b**10*c**5 -
        3*a**2*b**11*c**5 + 4*a*b**12*c**5 + a**9*b**3*c**6 +
        a**8*b**4*c**6 - 2*a**7*b**5*c**6 - 2*a**6*b**6*c**6 -
        4*a**5*b**7*c**6 + 9*a**4*b**8*c**6 - 8*a**3*b**9*c**6 +
        12*a**2*b**10*c**6 - 7*a*b**11*c**6 - 4*a**8*b**3*c**7 +
        5*a**7*b**4*c**7 - 3*a**6*b**5*c**7 + 12*a**5*b**6*c**7 -
        15*a**4*b**7*c**7 + 13*a**3*b**8*c**7 - 15*a**2*b**9*c**7 +
        6*a*b**10*c**7 + b**11*c**7 + 3*a**8*b**2*c**8 -
        a**7*b**3*c**8 - a**6*b**4*c**8 - 8*a**5*b**5*c**8 +
        8*a**4*b**6*c**8 - 7*a**3*b**7*c**8 + 9*a**2*b**8*c**8 -
        3*b**10*c**8 - a**8*b*c**9 - 3*a**7*b**2*c**9 +
        4*a**6*b**3*c**9 + 2*a**5*b**4*c**9 + a**4*b**5*c**9 -
        a**3*b**6*c**9 - 6*a*b**8*c**9 + 4*b**9*c**9 + 3*a**7*b*c**10
        - 2*a**6*b**2*c**10 - a**5*b**3*c**10 - 3*a**4*b**4*c**10 +
        3*a**3*b**5*c**10 - 4*a**2*b**6*c**10 + 7*a*b**7*c**10 -
        3*b**8*c**10 - a**7*c**11 - a**6*b*c**11 + 2*a**5*b**2*c**11 +
        a**4*b**3*c**11 - a**3*b**4*c**11 + 3*a**2*b**5*c**11 -
        4*a*b**6*c**11 + b**7*c**11 + a**6*c**12 - a**5*b*c**12 -
        a**2*b**4*c**12 + a*b**5*c**12), (2*a**10*b**6*c**2 -
        a**9*b**7*c**2 - a**8*b**8*c**2 + 2*a**7*b**9*c**2 +
        10*a**10*b**5*c**3 + a**9*b**6*c**3 - 4*a**8*b**7*c**3 +
        6*a**7*b**8*c**3 + 8*a**6*b**9*c**3 + 5*a**5*b**10*c**3 +
        18*a**10*b**4*c**4 + 13*a**9*b**5*c**4 - a**8*b**6*c**4 +
        4*a**7*b**7*c**4 + 18*a**6*b**8*c**4 + 23*a**5*b**9*c**4 +
        5*a**4*b**10*c**4 + 14*a**10*b**3*c**5 + 19*a**9*b**4*c**5 +
        10*a**8*b**5*c**5 + 9*a**6*b**7*c**5 + 30*a**5*b**8*c**5 +
        13*a**4*b**9*c**5 + 4*a**10*b**2*c**6 + 8*a**9*b**3*c**6 +
        10*a**8*b**4*c**6 + a**7*b**5*c**6 - 3*a**6*b**6*c**6 +
        13*a**5*b**7*c**6 + 11*a**4*b**8*c**6 + 2*a**8*b**3*c**7 +
        a**7*b**4*c**7 - 2*a**6*b**5*c**7 + a**5*b**6*c**7 +
        3*a**4*b**7*c**7)/(a**11*b**7 - 3*a**10*b**8 + 4*a**9*b**9 -
        3*a**8*b**10 + a**7*b**11 - a**13*b**4*c + 4*a**12*b**5*c -
        7*a**11*b**6*c + 6*a**10*b**7*c - 6*a**8*b**9*c +
        7*a**7*b**10*c - 4*a**6*b**11*c + a**5*b**12*c -
        a**14*b**2*c**2 + 3*a**13*b**3*c**2 - 3*a**12*b**4*c**2 -
        3*a**11*b**5*c**2 + 12*a**10*b**6*c**2 - 15*a**9*b**7*c**2 +
        9*a**8*b**8*c**2 - 4*a**6*b**10*c**2 + 3*a**5*b**11*c**2 -
        a**4*b**12*c**2 + 2*a**13*b**2*c**3 - 7*a**12*b**3*c**3 +
        10*a**11*b**4*c**3 - 4*a**10*b**5*c**3 - 8*a**9*b**6*c**3 +
        13*a**8*b**7*c**3 - 7*a**7*b**8*c**3 - a**6*b**9*c**3 +
        3*a**5*b**10*c**3 - a**4*b**11*c**3 + a**14*c**4 -
        2*a**13*b*c**4 - a**12*b**2*c**4 + 9*a**11*b**3*c**4 -
        14*a**10*b**4*c**4 + 6*a**9*b**5*c**4 + 9*a**8*b**6*c**4 -
        15*a**7*b**7*c**4 + 8*a**6*b**8*c**4 + a**5*b**9*c**4 -
        3*a**4*b**10*c**4 + a**3*b**11*c**4 - 2*a**13*c**5 +
        5*a**12*b*c**5 - 2*a**11*b**2*c**5 - 9*a**10*b**3*c**5 +
        18*a**9*b**4*c**5 - 12*a**8*b**5*c**5 - 4*a**7*b**6*c**5 +
        12*a**6*b**7*c**5 - 8*a**5*b**8*c**5 + 2*a**4*b**9*c**5 -
        a**3*b**10*c**5 + 2*a**2*b**11*c**5 - a*b**12*c**5 +
        2*a**12*c**6 - 6*a**11*b*c**6 + 5*a**10*b**2*c**6 +
        5*a**9*b**3*c**6 - 15*a**8*b**4*c**6 + 13*a**7*b**5*c**6 -
        2*a**6*b**6*c**6 - 3*a**5*b**7*c**6 - a**4*b**8*c**6 +
        4*a**3*b**9*c**6 - 2*a**2*b**10*c**6 - a*b**11*c**6 +
        b**12*c**6 - 2*a**11*c**7 + 6*a**10*b*c**7 - 6*a**9*b**2*c**7
        - a**8*b**3*c**7 + 8*a**7*b**4*c**7 - 6*a**6*b**5*c**7 -
        2*a**5*b**6*c**7 + 5*a**4*b**7*c**7 - a**3*b**8*c**7 -
        3*a**2*b**9*c**7 + 3*a*b**10*c**7 - b**11*c**7 + a**10*c**8 -
        4*a**9*b*c**8 + 5*a**8*b**2*c**8 - a**7*b**3*c**8 -
        4*a**6*b**4*c**8 + 4*a**5*b**5*c**8 + a**4*b**6*c**8 -
        4*a**3*b**7*c**8 + 3*a**2*b**8*c**8 - a*b**9*c**8 +
        a**8*b*c**9 - 2*a**7*b**2*c**9 + a**6*b**3*c**9 +
        a**5*b**4*c**9 - 2*a**4*b**5*c**9 + a**3*b**6*c**9),
        (5*a**10*b**4*c**4 + 13*a**9*b**5*c**4 + 11*a**8*b**6*c**4 +
        3*a**7*b**7*c**4 + 5*a**10*b**3*c**5 + 23*a**9*b**4*c**5 +
        30*a**8*b**5*c**5 + 13*a**7*b**6*c**5 + a**6*b**7*c**5 +
        8*a**9*b**3*c**6 + 18*a**8*b**4*c**6 + 9*a**7*b**5*c**6 -
        3*a**6*b**6*c**6 - 2*a**5*b**7*c**6 + 2*a**9*b**2*c**7 +
        6*a**8*b**3*c**7 + 4*a**7*b**4*c**7 + a**5*b**6*c**7 +
        a**4*b**7*c**7 - a**8*b**2*c**8 - 4*a**7*b**3*c**8 -
        a**6*b**4*c**8 + 10*a**5*b**5*c**8 + 10*a**4*b**6*c**8 +
        2*a**3*b**7*c**8 - a**7*b**2*c**9 + a**6*b**3*c**9 +
        13*a**5*b**4*c**9 + 19*a**4*b**5*c**9 + 8*a**3*b**6*c**9 +
        2*a**6*b**2*c**10 + 10*a**5*b**3*c**10 + 18*a**4*b**4*c**10 +
        14*a**3*b**5*c**10 + 4*a**2*b**6*c**10)/(a**12*b**6 -
        a**11*b**7 - a**12*b**5*c - a**11*b**6*c + 3*a**10*b**7*c -
        a**9*b**8*c + 2*a**11*b**5*c**2 - 2*a**10*b**6*c**2 -
        3*a**9*b**7*c**2 + 3*a**8*b**8*c**2 + a**11*b**4*c**3 -
        a**10*b**5*c**3 + 4*a**9*b**6*c**3 - a**8*b**7*c**3 -
        4*a**7*b**8*c**3 + a**6*b**9*c**3 - a**12*b**2*c**4 -
        a**11*b**3*c**4 - 3*a**10*b**4*c**4 + 2*a**9*b**5*c**4 -
        a**8*b**6*c**4 + 5*a**7*b**7*c**4 + a**6*b**8*c**4 -
        2*a**5*b**9*c**4 + a**12*b*c**5 + 3*a**11*b**2*c**5 +
        3*a**10*b**3*c**5 + a**9*b**4*c**5 - 8*a**8*b**5*c**5 -
        3*a**7*b**6*c**5 - 2*a**6*b**7*c**5 + 4*a**5*b**8*c**5 +
        a**4*b**9*c**5 - 4*a**11*b*c**6 - 4*a**10*b**2*c**6 -
        a**9*b**3*c**6 + 8*a**8*b**4*c**6 + 12*a**7*b**5*c**6 -
        2*a**6*b**6*c**6 - 6*a**5*b**7*c**6 - 4*a**4*b**8*c**6 +
        a**3*b**9*c**6 + a**11*c**7 + 7*a**10*b*c**7 -
        7*a**8*b**3*c**7 - 15*a**7*b**4*c**7 - 4*a**6*b**5*c**7 +
        13*a**5*b**6*c**7 + 8*a**4*b**7*c**7 - a**3*b**8*c**7 -
        2*a**2*b**9*c**7 - 3*a**10*c**8 - 6*a**9*b*c**8 +
        9*a**8*b**2*c**8 + 13*a**7*b**3*c**8 + 9*a**6*b**4*c**8 -
        12*a**5*b**5*c**8 - 15*a**4*b**6*c**8 - a**3*b**7*c**8 +
        5*a**2*b**8*c**8 + a*b**9*c**8 + 4*a**9*c**9 -
        15*a**7*b**2*c**9 - 8*a**6*b**3*c**9 + 6*a**5*b**4*c**9 +
        18*a**4*b**5*c**9 + 5*a**3*b**6*c**9 - 6*a**2*b**7*c**9 -
        4*a*b**8*c**9 - 3*a**8*c**10 + 6*a**7*b*c**10 +
        12*a**6*b**2*c**10 - 4*a**5*b**3*c**10 - 14*a**4*b**4*c**10 -
        9*a**3*b**5*c**10 + 5*a**2*b**6*c**10 + 6*a*b**7*c**10 +
        b**8*c**10 + a**7*c**11 - 7*a**6*b*c**11 - 3*a**5*b**2*c**11 +
        10*a**4*b**3*c**11 + 9*a**3*b**4*c**11 - 2*a**2*b**5*c**11 -
        6*a*b**6*c**11 - 2*b**7*c**11 + 4*a**5*b*c**12 -
        3*a**4*b**2*c**12 - 7*a**3*b**3*c**12 - a**2*b**4*c**12 +
        5*a*b**5*c**12 + 2*b**6*c**12 - a**4*b*c**13 +
        3*a**3*b**2*c**13 + 2*a**2*b**3*c**13 - 2*a*b**4*c**13 -
        2*b**5*c**13 - a**2*b**2*c**14 + b**4*c**14),
        (-3*a**7*b**7*c**4 - 11*a**6*b**8*c**4 - 13*a**5*b**9*c**4 -
        5*a**4*b**10*c**4 - a**7*b**6*c**5 - 13*a**6*b**7*c**5 -
        30*a**5*b**8*c**5 - 23*a**4*b**9*c**5 - 5*a**3*b**10*c**5 +
        2*a**7*b**5*c**6 + 3*a**6*b**6*c**6 - 9*a**5*b**7*c**6 -
        18*a**4*b**8*c**6 - 8*a**3*b**9*c**6 - a**7*b**4*c**7 -
        a**6*b**5*c**7 - 4*a**4*b**7*c**7 - 6*a**3*b**8*c**7 -
        2*a**2*b**9*c**7 - 2*a**7*b**3*c**8 - 10*a**6*b**4*c**8 -
        10*a**5*b**5*c**8 + a**4*b**6*c**8 + 4*a**3*b**7*c**8 +
        a**2*b**8*c**8 - 8*a**6*b**3*c**9 - 19*a**5*b**4*c**9 -
        13*a**4*b**5*c**9 - a**3*b**6*c**9 + a**2*b**7*c**9 -
        4*a**6*b**2*c**10 - 14*a**5*b**3*c**10 - 18*a**4*b**4*c**10 -
        10*a**3*b**5*c**10 - 2*a**2*b**6*c**10)/(a**7*b**11 -
        a**6*b**12 + a**8*b**9*c - 3*a**7*b**10*c + a**6*b**11*c +
        a**5*b**12*c - 3*a**8*b**8*c**2 + 3*a**7*b**9*c**2 +
        2*a**6*b**10*c**2 - 2*a**5*b**11*c**2 - a**9*b**6*c**3 +
        4*a**8*b**7*c**3 + a**7*b**8*c**3 - 4*a**6*b**9*c**3 +
        a**5*b**10*c**3 - a**4*b**11*c**3 + 2*a**9*b**5*c**4 -
        a**8*b**6*c**4 - 5*a**7*b**7*c**4 + a**6*b**8*c**4 -
        2*a**5*b**9*c**4 + 3*a**4*b**10*c**4 + a**3*b**11*c**4 +
        a**2*b**12*c**4 - a**9*b**4*c**5 - 4*a**8*b**5*c**5 +
        2*a**7*b**6*c**5 + 3*a**6*b**7*c**5 + 8*a**5*b**8*c**5 -
        a**4*b**9*c**5 - 3*a**3*b**10*c**5 - 3*a**2*b**11*c**5 -
        a*b**12*c**5 - a**9*b**3*c**6 + 4*a**8*b**4*c**6 +
        6*a**7*b**5*c**6 + 2*a**6*b**6*c**6 - 12*a**5*b**7*c**6 -
        8*a**4*b**8*c**6 + a**3*b**9*c**6 + 4*a**2*b**10*c**6 +
        4*a*b**11*c**6 + 2*a**9*b**2*c**7 + a**8*b**3*c**7 -
        8*a**7*b**4*c**7 - 13*a**6*b**5*c**7 + 4*a**5*b**6*c**7 +
        15*a**4*b**7*c**7 + 7*a**3*b**8*c**7 - 7*a*b**10*c**7 -
        b**11*c**7 - a**9*b*c**8 - 5*a**8*b**2*c**8 + a**7*b**3*c**8 +
        15*a**6*b**4*c**8 + 12*a**5*b**5*c**8 - 9*a**4*b**6*c**8 -
        13*a**3*b**7*c**8 - 9*a**2*b**8*c**8 + 6*a*b**9*c**8 +
        3*b**10*c**8 + 4*a**8*b*c**9 + 6*a**7*b**2*c**9 -
        5*a**6*b**3*c**9 - 18*a**5*b**4*c**9 - 6*a**4*b**5*c**9 +
        8*a**3*b**6*c**9 + 15*a**2*b**7*c**9 - 4*b**9*c**9 -
        a**8*c**10 - 6*a**7*b*c**10 - 5*a**6*b**2*c**10 +
        9*a**5*b**3*c**10 + 14*a**4*b**4*c**10 + 4*a**3*b**5*c**10 -
        12*a**2*b**6*c**10 - 6*a*b**7*c**10 + 3*b**8*c**10 +
        2*a**7*c**11 + 6*a**6*b*c**11 + 2*a**5*b**2*c**11 -
        9*a**4*b**3*c**11 - 10*a**3*b**4*c**11 + 3*a**2*b**5*c**11 +
        7*a*b**6*c**11 - b**7*c**11 - 2*a**6*c**12 - 5*a**5*b*c**12 +
        a**4*b**2*c**12 + 7*a**3*b**3*c**12 + 3*a**2*b**4*c**12 -
        4*a*b**5*c**12 + 2*a**5*c**13 + 2*a**4*b*c**13 -
        2*a**3*b**2*c**13 - 3*a**2*b**3*c**13 + a*b**4*c**13 -
        a**4*c**14 + a**2*b**2*c**14), (4*a**10*b**6*c**2 +
        14*a**10*b**5*c**3 + 8*a**9*b**6*c**3 + 2*a**8*b**7*c**3 +
        18*a**10*b**4*c**4 + 19*a**9*b**5*c**4 + 10*a**8*b**6*c**4 +
        a**7*b**7*c**4 + 10*a**10*b**3*c**5 + 13*a**9*b**4*c**5 +
        10*a**8*b**5*c**5 + a**7*b**6*c**5 - 2*a**6*b**7*c**5 +
        2*a**10*b**2*c**6 + a**9*b**3*c**6 - a**8*b**4*c**6 -
        3*a**6*b**6*c**6 + a**5*b**7*c**6 - a**9*b**2*c**7 -
        4*a**8*b**3*c**7 + 4*a**7*b**4*c**7 + 9*a**6*b**5*c**7 +
        13*a**5*b**6*c**7 + 3*a**4*b**7*c**7 - a**8*b**2*c**8 +
        6*a**7*b**3*c**8 + 18*a**6*b**4*c**8 + 30*a**5*b**5*c**8 +
        11*a**4*b**6*c**8 + 2*a**7*b**2*c**9 + 8*a**6*b**3*c**9 +
        23*a**5*b**4*c**9 + 13*a**4*b**5*c**9 + 5*a**5*b**3*c**10 +
        5*a**4*b**4*c**10)/(a**14*b**4 - 2*a**13*b**5 + 2*a**12*b**6 -
        2*a**11*b**7 + a**10*b**8 - 2*a**13*b**4*c + 5*a**12*b**5*c -
        6*a**11*b**6*c + 6*a**10*b**7*c - 4*a**9*b**8*c + a**8*b**9*c
        - a**14*b**2*c**2 + 2*a**13*b**3*c**2 - a**12*b**4*c**2 -
        2*a**11*b**5*c**2 + 5*a**10*b**6*c**2 - 6*a**9*b**7*c**2 +
        5*a**8*b**8*c**2 - 2*a**7*b**9*c**2 + 3*a**13*b**2*c**3 -
        7*a**12*b**3*c**3 + 9*a**11*b**4*c**3 - 9*a**10*b**5*c**3 +
        5*a**9*b**6*c**3 - a**8*b**7*c**3 - a**7*b**8*c**3 +
        a**6*b**9*c**3 - a**13*b*c**4 - 3*a**12*b**2*c**4 +
        10*a**11*b**3*c**4 - 14*a**10*b**4*c**4 + 18*a**9*b**5*c**4 -
        15*a**8*b**6*c**4 + 8*a**7*b**7*c**4 - 4*a**6*b**8*c**4 +
        a**5*b**9*c**4 + 4*a**12*b*c**5 - 3*a**11*b**2*c**5 -
        4*a**10*b**3*c**5 + 6*a**9*b**4*c**5 - 12*a**8*b**5*c**5 +
        13*a**7*b**6*c**5 - 6*a**6*b**7*c**5 + 4*a**5*b**8*c**5 -
        2*a**4*b**9*c**5 - 7*a**11*b*c**6 + 12*a**10*b**2*c**6 -
        8*a**9*b**3*c**6 + 9*a**8*b**4*c**6 - 4*a**7*b**5*c**6 -
        2*a**6*b**6*c**6 - 2*a**5*b**7*c**6 + a**4*b**8*c**6 +
        a**3*b**9*c**6 + a**11*c**7 + 6*a**10*b*c**7 -
        15*a**9*b**2*c**7 + 13*a**8*b**3*c**7 - 15*a**7*b**4*c**7 +
        12*a**6*b**5*c**7 - 3*a**5*b**6*c**7 + 5*a**4*b**7*c**7 -
        4*a**3*b**8*c**7 - 3*a**10*c**8 + 9*a**8*b**2*c**8 -
        7*a**7*b**3*c**8 + 8*a**6*b**4*c**8 - 8*a**5*b**5*c**8 -
        a**4*b**6*c**8 - a**3*b**7*c**8 + 3*a**2*b**8*c**8 +
        4*a**9*c**9 - 6*a**8*b*c**9 - a**6*b**3*c**9 + a**5*b**4*c**9
        + 2*a**4*b**5*c**9 + 4*a**3*b**6*c**9 - 3*a**2*b**7*c**9 -
        a*b**8*c**9 - 3*a**8*c**10 + 7*a**7*b*c**10 -
        4*a**6*b**2*c**10 + 3*a**5*b**3*c**10 - 3*a**4*b**4*c**10 -
        a**3*b**5*c**10 - 2*a**2*b**6*c**10 + 3*a*b**7*c**10 +
        a**7*c**11 - 4*a**6*b*c**11 + 3*a**5*b**2*c**11 -
        a**4*b**3*c**11 + a**3*b**4*c**11 + 2*a**2*b**5*c**11 -
        a*b**6*c**11 - b**7*c**11 + a**5*b*c**12 - a**4*b**2*c**12 -
        a*b**5*c**12 + b**6*c**12), (2*a**9*b**7*c**2 - a**8*b**8*c**2
        - a**7*b**9*c**2 + 2*a**6*b**10*c**2 + 5*a**10*b**5*c**3 +
        8*a**9*b**6*c**3 + 6*a**8*b**7*c**3 - 4*a**7*b**8*c**3 +
        a**6*b**9*c**3 + 10*a**5*b**10*c**3 + 5*a**10*b**4*c**4 +
        23*a**9*b**5*c**4 + 18*a**8*b**6*c**4 + 4*a**7*b**7*c**4 -
        a**6*b**8*c**4 + 13*a**5*b**9*c**4 + 18*a**4*b**10*c**4 +
        13*a**9*b**4*c**5 + 30*a**8*b**5*c**5 + 9*a**7*b**6*c**5 +
        10*a**5*b**8*c**5 + 19*a**4*b**9*c**5 + 14*a**3*b**10*c**5 +
        11*a**8*b**4*c**6 + 13*a**7*b**5*c**6 - 3*a**6*b**6*c**6 +
        a**5*b**7*c**6 + 10*a**4*b**8*c**6 + 8*a**3*b**9*c**6 +
        4*a**2*b**10*c**6 + 3*a**7*b**4*c**7 + a**6*b**5*c**7 -
        2*a**5*b**6*c**7 + a**4*b**7*c**7 +
        2*a**3*b**8*c**7)/(a**11*b**7 - 3*a**10*b**8 + 4*a**9*b**9 -
        3*a**8*b**10 + a**7*b**11 + a**12*b**5*c - 4*a**11*b**6*c +
        7*a**10*b**7*c - 6*a**9*b**8*c + 6*a**7*b**10*c -
        7*a**6*b**11*c + 4*a**5*b**12*c - a**4*b**13*c -
        a**12*b**4*c**2 + 3*a**11*b**5*c**2 - 4*a**10*b**6*c**2 +
        9*a**8*b**8*c**2 - 15*a**7*b**9*c**2 + 12*a**6*b**10*c**2 -
        3*a**5*b**11*c**2 - 3*a**4*b**12*c**2 + 3*a**3*b**13*c**2 -
        a**2*b**14*c**2 - a**11*b**4*c**3 + 3*a**10*b**5*c**3 -
        a**9*b**6*c**3 - 7*a**8*b**7*c**3 + 13*a**7*b**8*c**3 -
        8*a**6*b**9*c**3 - 4*a**5*b**10*c**3 + 10*a**4*b**11*c**3 -
        7*a**3*b**12*c**3 + 2*a**2*b**13*c**3 + a**11*b**3*c**4 -
        3*a**10*b**4*c**4 + a**9*b**5*c**4 + 8*a**8*b**6*c**4 -
        15*a**7*b**7*c**4 + 9*a**6*b**8*c**4 + 6*a**5*b**9*c**4 -
        14*a**4*b**10*c**4 + 9*a**3*b**11*c**4 - a**2*b**12*c**4 -
        2*a*b**13*c**4 + b**14*c**4 - a**12*b*c**5 + 2*a**11*b**2*c**5
        - a**10*b**3*c**5 + 2*a**9*b**4*c**5 - 8*a**8*b**5*c**5 +
        12*a**7*b**6*c**5 - 4*a**6*b**7*c**5 - 12*a**5*b**8*c**5 +
        18*a**4*b**9*c**5 - 9*a**3*b**10*c**5 - 2*a**2*b**11*c**5 +
        5*a*b**12*c**5 - 2*b**13*c**5 + a**12*c**6 - a**11*b*c**6 -
        2*a**10*b**2*c**6 + 4*a**9*b**3*c**6 - a**8*b**4*c**6 -
        3*a**7*b**5*c**6 - 2*a**6*b**6*c**6 + 13*a**5*b**7*c**6 -
        15*a**4*b**8*c**6 + 5*a**3*b**9*c**6 + 5*a**2*b**10*c**6 -
        6*a*b**11*c**6 + 2*b**12*c**6 - a**11*c**7 + 3*a**10*b*c**7 -
        3*a**9*b**2*c**7 - a**8*b**3*c**7 + 5*a**7*b**4*c**7 -
        2*a**6*b**5*c**7 - 6*a**5*b**6*c**7 + 8*a**4*b**7*c**7 -
        a**3*b**8*c**7 - 6*a**2*b**9*c**7 + 6*a*b**10*c**7 -
        2*b**11*c**7 - a**9*b*c**8 + 3*a**8*b**2*c**8 -
        4*a**7*b**3*c**8 + a**6*b**4*c**8 + 4*a**5*b**5*c**8 -
        4*a**4*b**6*c**8 - a**3*b**7*c**8 + 5*a**2*b**8*c**8 -
        4*a*b**9*c**8 + b**10*c**8 + a**6*b**3*c**9 - 2*a**5*b**4*c**9
        + a**4*b**5*c**9 + a**3*b**6*c**9 - 2*a**2*b**7*c**9 +
        a*b**8*c**9), (-2*a**6*b**5*c**3 - 7*a**5*b**6*c**3 -
        3*a**4*b**7*c**3 - 2*a**6*b**4*c**4 - 14*a**5*b**5*c**4 -
        15*a**4*b**6*c**4 - 3*a**3*b**7*c**4 - a**6*b**3*c**5 -
        10*a**5*b**4*c**5 - 17*a**4*b**5*c**5 - 7*a**3*b**6*c**5 -
        6*a**5*b**3*c**6 - 14*a**4*b**4*c**6 - 8*a**3*b**5*c**6 -
        a**2*b**6*c**6 - 2*a**5*b**2*c**7 - 7*a**4*b**3*c**7 -
        6*a**3*b**4*c**7 - a**2*b**5*c**7)/(a**8*b**6 - 2*a**7*b**7 +
        a**6*b**8 - 2*a**8*b**5*c + 4*a**7*b**6*c - a**6*b**7*c -
        2*a**5*b**8*c + a**4*b**9*c + a**8*b**4*c**2 -
        3*a**7*b**5*c**2 + 5*a**5*b**7*c**2 - 3*a**4*b**8*c**2 +
        a**8*b**3*c**3 + a**7*b**4*c**3 - 2*a**6*b**5*c**3 -
        4*a**5*b**6*c**3 + 4*a**4*b**7*c**3 + a**3*b**8*c**3 -
        a**2*b**9*c**3 - 2*a**8*b**2*c**4 + 5*a**6*b**4*c**4 +
        a**5*b**5*c**4 - 5*a**4*b**6*c**4 - a**3*b**7*c**4 +
        2*a**2*b**8*c**4 + a**8*b*c**5 + a**7*b**2*c**5 -
        5*a**6*b**3*c**5 + 5*a**4*b**5*c**5 - a**3*b**6*c**5 -
        a**2*b**7*c**5 - a**7*b*c**6 + a**6*b**2*c**6 + a**5*b**3*c**6
        - 2*a**4*b**4*c**6 + 3*a**3*b**5*c**6 - 2*a**2*b**6*c**6 -
        a*b**7*c**6 + b**8*c**6 + 2*a**6*b*c**7 - a**5*b**2*c**7 -
        2*a**4*b**3*c**7 - 4*a**3*b**4*c**7 + 5*a**2*b**5*c**7 +
        3*a*b**6*c**7 - 3*b**7*c**7 - a**6*c**8 - a**5*b*c**8 +
        4*a**4*b**2*c**8 + 3*a**3*b**3*c**8 - 5*a**2*b**4*c**8 -
        4*a*b**5*c**8 + 4*b**6*c**8 + a**5*c**9 - 2*a**4*b*c**9 -
        2*a**3*b**2*c**9 + 3*a**2*b**3*c**9 + 3*a*b**4*c**9 -
        3*b**5*c**9 + a**3*b*c**10 - a**2*b**2*c**10 - a*b**3*c**10 +
        b**4*c**10), (-a**6*b**6*c**2 - a**5*b**7*c**2 -
        3*a**7*b**4*c**3 - 7*a**6*b**5*c**3 - 8*a**5*b**6*c**3 -
        6*a**4*b**7*c**3 - 3*a**7*b**3*c**4 - 15*a**6*b**4*c**4 -
        17*a**5*b**5*c**4 - 14*a**4*b**6*c**4 - 7*a**3*b**7*c**4 -
        7*a**6*b**3*c**5 - 14*a**5*b**4*c**5 - 10*a**4*b**5*c**5 -
        6*a**3*b**6*c**5 - 2*a**2*b**7*c**5 - 2*a**5*b**3*c**6 -
        2*a**4*b**4*c**6 - a**3*b**5*c**6)/(a**8*b**6 - 3*a**7*b**7 +
        4*a**6*b**8 - 3*a**5*b**9 + a**4*b**10 - a**7*b**6*c +
        3*a**6*b**7*c - 4*a**5*b**8*c + 3*a**4*b**9*c - a**3*b**10*c -
        a**9*b**3*c**2 + 2*a**8*b**4*c**2 - a**7*b**5*c**2 -
        2*a**6*b**6*c**2 + 5*a**5*b**7*c**2 - 5*a**4*b**8*c**2 +
        3*a**3*b**9*c**2 - a**2*b**10*c**2 + a**8*b**3*c**3 -
        a**7*b**4*c**3 - a**6*b**5*c**3 + 3*a**5*b**6*c**3 -
        4*a**4*b**7*c**3 + 3*a**3*b**8*c**3 - 2*a**2*b**9*c**3 +
        a*b**10*c**3 + a**9*b*c**4 - 3*a**8*b**2*c**4 +
        4*a**7*b**3*c**4 - 5*a**6*b**4*c**4 + 5*a**5*b**5*c**4 -
        2*a**4*b**6*c**4 - 2*a**3*b**7*c**4 + 4*a**2*b**8*c**4 -
        2*a*b**9*c**4 - 2*a**8*b*c**5 + 5*a**7*b**2*c**5 -
        4*a**6*b**3*c**5 + a**5*b**4*c**5 + a**3*b**6*c**5 -
        a**2*b**7*c**5 - a*b**8*c**5 + b**9*c**5 + a**8*c**6 -
        a**7*b*c**6 - 2*a**5*b**3*c**6 + 5*a**4*b**4*c**6 -
        5*a**3*b**5*c**6 + a**2*b**6*c**6 + 2*a*b**7*c**6 - b**8*c**6
        - 2*a**7*c**7 + 4*a**6*b*c**7 - 3*a**5*b**2*c**7 +
        a**4*b**3*c**7 + a**2*b**5*c**7 - a*b**6*c**7 + a**6*c**8 -
        2*a**5*b*c**8 + a**4*b**2*c**8 + a**3*b**3*c**8 -
        2*a**2*b**4*c**8 + a*b**5*c**8), (-2*a**7*b**5*c**2 -
        7*a**7*b**4*c**3 - 6*a**6*b**5*c**3 - a**5*b**6*c**3 -
        6*a**7*b**3*c**4 - 14*a**6*b**4*c**4 - 10*a**5*b**5*c**4 -
        2*a**4*b**6*c**4 - a**7*b**2*c**5 - 8*a**6*b**3*c**5 -
        17*a**5*b**4*c**5 - 14*a**4*b**5*c**5 - 2*a**3*b**6*c**5 -
        a**6*b**2*c**6 - 7*a**5*b**3*c**6 - 15*a**4*b**4*c**6 -
        7*a**3*b**5*c**6 - 3*a**4*b**3*c**7 -
        3*a**3*b**4*c**7)/(a**9*b**5 - a**8*b**6 + a**10*b**3*c -
        2*a**9*b**4*c - a**8*b**5*c + 2*a**7*b**6*c - a**6*b**7*c +
        a**5*b**8*c - a**10*b**2*c**2 - 2*a**9*b**3*c**2 +
        4*a**8*b**4*c**2 - a**7*b**5*c**2 + a**6*b**6*c**2 +
        a**5*b**7*c**2 - 2*a**4*b**8*c**2 - a**10*b*c**3 +
        3*a**9*b**2*c**3 + 3*a**8*b**3*c**3 - 2*a**7*b**4*c**3 +
        a**6*b**5*c**3 - 5*a**5*b**6*c**3 + a**3*b**8*c**3 +
        a**10*c**4 + 3*a**9*b*c**4 - 5*a**8*b**2*c**4 -
        4*a**7*b**3*c**4 - 2*a**6*b**4*c**4 + 5*a**4*b**6*c**4 +
        a**3*b**7*c**4 + a**2*b**8*c**4 - 3*a**9*c**5 - 4*a**8*b*c**5
        + 5*a**7*b**2*c**5 + 3*a**6*b**3*c**5 + 5*a**5*b**4*c**5 +
        a**4*b**5*c**5 - 2*a**3*b**6*c**5 - 3*a**2*b**7*c**5 -
        2*a*b**8*c**5 + 4*a**8*c**6 + 3*a**7*b*c**6 - 2*a**6*b**2*c**6
        - a**5*b**3*c**6 - 5*a**4*b**4*c**6 - 4*a**3*b**5*c**6 +
        4*a*b**7*c**6 + b**8*c**6 - 3*a**7*c**7 - a**6*b*c**7 -
        a**5*b**2*c**7 - a**4*b**3*c**7 + 4*a**3*b**4*c**7 +
        5*a**2*b**5*c**7 - a*b**6*c**7 - 2*b**7*c**7 + a**6*c**8 +
        2*a**4*b**2*c**8 + a**3*b**3*c**8 - 3*a**2*b**4*c**8 -
        2*a*b**5*c**8 + b**6*c**8 - a**3*b**2*c**9 + a*b**4*c**9),
        (2*a**5*b**7*c**2 + a**6*b**5*c**3 + 6*a**5*b**6*c**3 +
        7*a**4*b**7*c**3 + 2*a**6*b**4*c**4 + 10*a**5*b**5*c**4 +
        14*a**4*b**6*c**4 + 6*a**3*b**7*c**4 + 2*a**6*b**3*c**5 +
        14*a**5*b**4*c**5 + 17*a**4*b**5*c**5 + 8*a**3*b**6*c**5 +
        a**2*b**7*c**5 + 7*a**5*b**3*c**6 + 15*a**4*b**4*c**6 +
        7*a**3*b**5*c**6 + a**2*b**6*c**6 + 3*a**4*b**3*c**7 +
        3*a**3*b**4*c**7)/(a**6*b**8 - a**5*b**9 - a**8*b**5*c +
        a**7*b**6*c - 2*a**6*b**7*c + a**5*b**8*c + 2*a**4*b**9*c -
        a**3*b**10*c + 2*a**8*b**4*c**2 - a**7*b**5*c**2 -
        a**6*b**6*c**2 + a**5*b**7*c**2 - 4*a**4*b**8*c**2 +
        2*a**3*b**9*c**2 + a**2*b**10*c**2 - a**8*b**3*c**3 +
        5*a**6*b**5*c**3 - a**5*b**6*c**3 + 2*a**4*b**7*c**3 -
        3*a**3*b**8*c**3 - 3*a**2*b**9*c**3 + a*b**10*c**3 -
        a**8*b**2*c**4 - a**7*b**3*c**4 - 5*a**6*b**4*c**4 +
        2*a**4*b**6*c**4 + 4*a**3*b**7*c**4 + 5*a**2*b**8*c**4 -
        3*a*b**9*c**4 - b**10*c**4 + 2*a**8*b*c**5 + 3*a**7*b**2*c**5
        + 2*a**6*b**3*c**5 - a**5*b**4*c**5 - 5*a**4*b**5*c**5 -
        3*a**3*b**6*c**5 - 5*a**2*b**7*c**5 + 4*a*b**8*c**5 +
        3*b**9*c**5 - a**8*c**6 - 4*a**7*b*c**6 + 4*a**5*b**3*c**6 +
        5*a**4*b**4*c**6 + a**3*b**5*c**6 + 2*a**2*b**6*c**6 -
        3*a*b**7*c**6 - 4*b**8*c**6 + 2*a**7*c**7 + a**6*b*c**7 -
        5*a**5*b**2*c**7 - 4*a**4*b**3*c**7 + a**3*b**4*c**7 +
        a**2*b**5*c**7 + a*b**6*c**7 + 3*b**7*c**7 - a**6*c**8 +
        2*a**5*b*c**8 + 3*a**4*b**2*c**8 - a**3*b**3*c**8 -
        2*a**2*b**4*c**8 - b**6*c**8 - a**4*b*c**9 + a**2*b**3*c**9),
        (-3*a**7*b**4*c**3 - 7*a**6*b**5*c**3 - 2*a**5*b**6*c**3 -
        3*a**7*b**3*c**4 - 15*a**6*b**4*c**4 - 14*a**5*b**5*c**4 -
        2*a**4*b**6*c**4 - 7*a**6*b**3*c**5 - 17*a**5*b**4*c**5 -
        10*a**4*b**5*c**5 - a**3*b**6*c**5 - a**6*b**2*c**6 -
        8*a**5*b**3*c**6 - 14*a**4*b**4*c**6 - 6*a**3*b**5*c**6 -
        a**5*b**2*c**7 - 6*a**4*b**3*c**7 - 7*a**3*b**4*c**7 -
        2*a**2*b**5*c**7)/(a**8*b**6 - 2*a**7*b**7 + a**6*b**8 +
        a**9*b**4*c - 2*a**8*b**5*c - a**7*b**6*c + 4*a**6*b**7*c -
        2*a**5*b**8*c - 3*a**8*b**4*c**2 + 5*a**7*b**5*c**2 -
        3*a**5*b**7*c**2 + a**4*b**8*c**2 - a**9*b**2*c**3 +
        a**8*b**3*c**3 + 4*a**7*b**4*c**3 - 4*a**6*b**5*c**3 -
        2*a**5*b**6*c**3 + a**4*b**7*c**3 + a**3*b**8*c**3 +
        2*a**8*b**2*c**4 - a**7*b**3*c**4 - 5*a**6*b**4*c**4 +
        a**5*b**5*c**4 + 5*a**4*b**6*c**4 - 2*a**2*b**8*c**4 -
        a**7*b**2*c**5 - a**6*b**3*c**5 + 5*a**5*b**4*c**5 -
        5*a**3*b**6*c**5 + a**2*b**7*c**5 + a*b**8*c**5 + a**8*c**6 -
        a**7*b*c**6 - 2*a**6*b**2*c**6 + 3*a**5*b**3*c**6 -
        2*a**4*b**4*c**6 + a**3*b**5*c**6 + a**2*b**6*c**6 -
        a*b**7*c**6 - 3*a**7*c**7 + 3*a**6*b*c**7 + 5*a**5*b**2*c**7 -
        4*a**4*b**3*c**7 - 2*a**3*b**4*c**7 - a**2*b**5*c**7 +
        2*a*b**6*c**7 + 4*a**6*c**8 - 4*a**5*b*c**8 - 5*a**4*b**2*c**8
        + 3*a**3*b**3*c**8 + 4*a**2*b**4*c**8 - a*b**5*c**8 -
        b**6*c**8 - 3*a**5*c**9 + 3*a**4*b*c**9 + 3*a**3*b**2*c**9 -
        2*a**2*b**3*c**9 - 2*a*b**4*c**9 + b**5*c**9 + a**4*c**10 -
        a**3*b*c**10 - a**2*b**2*c**10 + a*b**3*c**10),
        (-a**7*b**5*c**2 - a**6*b**6*c**2 - 6*a**7*b**4*c**3 -
        8*a**6*b**5*c**3 - 7*a**5*b**6*c**3 - 3*a**4*b**7*c**3 -
        7*a**7*b**3*c**4 - 14*a**6*b**4*c**4 - 17*a**5*b**5*c**4 -
        15*a**4*b**6*c**4 - 3*a**3*b**7*c**4 - 2*a**7*b**2*c**5 -
        6*a**6*b**3*c**5 - 10*a**5*b**4*c**5 - 14*a**4*b**5*c**5 -
        7*a**3*b**6*c**5 - a**5*b**3*c**6 - 2*a**4*b**4*c**6 -
        2*a**3*b**5*c**6)/(a**10*b**4 - 3*a**9*b**5 + 4*a**8*b**6 -
        3*a**7*b**7 + a**6*b**8 - a**10*b**3*c + 3*a**9*b**4*c -
        4*a**8*b**5*c + 3*a**7*b**6*c - a**6*b**7*c - a**10*b**2*c**2
        + 3*a**9*b**3*c**2 - 5*a**8*b**4*c**2 + 5*a**7*b**5*c**2 -
        2*a**6*b**6*c**2 - a**5*b**7*c**2 + 2*a**4*b**8*c**2 -
        a**3*b**9*c**2 + a**10*b*c**3 - 2*a**9*b**2*c**3 +
        3*a**8*b**3*c**3 - 4*a**7*b**4*c**3 + 3*a**6*b**5*c**3 -
        a**5*b**6*c**3 - a**4*b**7*c**3 + a**3*b**8*c**3 -
        2*a**9*b*c**4 + 4*a**8*b**2*c**4 - 2*a**7*b**3*c**4 -
        2*a**6*b**4*c**4 + 5*a**5*b**5*c**4 - 5*a**4*b**6*c**4 +
        4*a**3*b**7*c**4 - 3*a**2*b**8*c**4 + a*b**9*c**4 + a**9*c**5
        - a**8*b*c**5 - a**7*b**2*c**5 + a**6*b**3*c**5 +
        a**4*b**5*c**5 - 4*a**3*b**6*c**5 + 5*a**2*b**7*c**5 -
        2*a*b**8*c**5 - a**8*c**6 + 2*a**7*b*c**6 + a**6*b**2*c**6 -
        5*a**5*b**3*c**6 + 5*a**4*b**4*c**6 - 2*a**3*b**5*c**6 -
        a*b**7*c**6 + b**8*c**6 - a**6*b*c**7 + a**5*b**2*c**7 +
        a**3*b**4*c**7 - 3*a**2*b**5*c**7 + 4*a*b**6*c**7 -
        2*b**7*c**7 + a**5*b*c**8 - 2*a**4*b**2*c**8 + a**3*b**3*c**8
        + a**2*b**4*c**8 - 2*a*b**5*c**8 + b**6*c**8),
        (-2*a**8*b**6*c**2 - a**7*b**7*c**2 - 8*a**8*b**5*c**3 -
        12*a**7*b**6*c**3 - 5*a**6*b**7*c**3 - a**5*b**8*c**3 -
        12*a**8*b**4*c**4 - 32*a**7*b**5*c**4 - 32*a**6*b**6*c**4 -
        17*a**5*b**7*c**4 - 4*a**4*b**8*c**4 - 8*a**8*b**3*c**5 -
        32*a**7*b**4*c**5 - 54*a**6*b**5*c**5 - 51*a**5*b**6*c**5 -
        23*a**4*b**7*c**5 - 3*a**3*b**8*c**5 - 2*a**8*b**2*c**6 -
        12*a**7*b**3*c**6 - 32*a**6*b**4*c**6 - 51*a**5*b**5*c**6 -
        38*a**4*b**6*c**6 - 9*a**3*b**7*c**6 - a**7*b**2*c**7 -
        5*a**6*b**3*c**7 - 17*a**5*b**4*c**7 - 23*a**4*b**5*c**7 -
        9*a**3*b**6*c**7 - a**5*b**3*c**8 - 4*a**4*b**4*c**8 -
        3*a**3*b**5*c**8)/(a**9*b**7 - a**8*b**8 - a**11*b**4*c +
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c + a**7*b**8*c -
        a**6*b**9*c + a**11*b**3*c**2 - a**10*b**4*c**2 -
        2*a**9*b**5*c**2 + a**8*b**6*c**2 - a**7*b**7*c**2 +
        2*a**6*b**8*c**2 + a**5*b**9*c**2 - a**4*b**10*c**2 +
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 - a**8*b**5*c**3 -
        3*a**7*b**6*c**3 - a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**11*b*c**4 - a**10*b**2*c**4 + 2*a**9*b**3*c**4 +
        3*a**7*b**5*c**4 - a**6*b**6*c**4 - 2*a**5*b**7*c**4 -
        a**4*b**8*c**4 + a**2*b**10*c**4 + a**10*b*c**5 -
        2*a**9*b**2*c**5 - a**8*b**3*c**5 + 3*a**7*b**4*c**5 +
        2*a**5*b**6*c**5 - a**4*b**7*c**5 - a**3*b**8*c**5 -
        a**2*b**9*c**5 - a**9*b*c**6 + a**8*b**2*c**6 -
        3*a**7*b**3*c**6 - a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        2*a**4*b**6*c**6 + a**3*b**7*c**6 - a**2*b**8*c**6 + a**9*c**7
        + a**8*b*c**7 - a**7*b**2*c**7 - 2*a**5*b**4*c**7 -
        a**4*b**5*c**7 + a**3*b**6*c**7 + 2*a**2*b**7*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + 2*a**6*b**2*c**8 - a**5*b**3*c**8
        - a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 +
        2*b**8*c**8 - a**6*b*c**9 + a**5*b**2*c**9 + 2*a**4*b**3*c**9
        - a**2*b**5*c**9 - b**7*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (3*a**8*b**5*c**3 + 9*a**7*b**6*c**3 +
        9*a**6*b**7*c**3 + 3*a**5*b**8*c**3 + 4*a**8*b**4*c**4 +
        23*a**7*b**5*c**4 + 38*a**6*b**6*c**4 + 23*a**5*b**7*c**4 +
        4*a**4*b**8*c**4 + a**8*b**3*c**5 + 17*a**7*b**4*c**5 +
        51*a**6*b**5*c**5 + 51*a**5*b**6*c**5 + 17*a**4*b**7*c**5 +
        a**3*b**8*c**5 + 5*a**7*b**3*c**6 + 32*a**6*b**4*c**6 +
        54*a**5*b**5*c**6 + 32*a**4*b**6*c**6 + 5*a**3*b**7*c**6 +
        a**7*b**2*c**7 + 12*a**6*b**3*c**7 + 32*a**5*b**4*c**7 +
        32*a**4*b**5*c**7 + 12*a**3*b**6*c**7 + a**2*b**7*c**7 +
        2*a**6*b**2*c**8 + 8*a**5*b**3*c**8 + 12*a**4*b**4*c**8 +
        8*a**3*b**5*c**8 + 2*a**2*b**6*c**8)/(a**9*b**7 - 2*a**8*b**8
        + a**7*b**9 - a**10*b**4*c**2 + a**9*b**5*c**2 +
        a**8*b**6*c**2 - 2*a**7*b**7*c**2 + a**6*b**8*c**2 +
        a**5*b**9*c**2 - a**4*b**10*c**2 + a**8*b**5*c**3 -
        a**7*b**6*c**3 - a**6*b**7*c**3 + a**5*b**8*c**3 +
        a**10*b**2*c**4 - 2*a**9*b**3*c**4 + a**8*b**4*c**4 +
        a**7*b**5*c**4 - 2*a**6*b**6*c**4 + a**5*b**7*c**4 +
        a**4*b**8*c**4 - 2*a**3*b**9*c**4 + a**2*b**10*c**4 -
        a**9*b**2*c**5 + a**8*b**3*c**5 + 2*a**7*b**4*c**5 -
        2*a**6*b**5*c**5 - 2*a**5*b**6*c**5 + 2*a**4*b**7*c**5 +
        a**3*b**8*c**5 - a**2*b**9*c**5 + a**9*b*c**6 -
        2*a**8*b**2*c**6 + a**6*b**4*c**6 + a**4*b**6*c**6 -
        2*a**2*b**8*c**6 + a*b**9*c**6 - a**8*b*c**7 + a**7*b**2*c**7
        + 3*a**6*b**3*c**7 - 3*a**5*b**4*c**7 - 3*a**4*b**5*c**7 +
        3*a**3*b**6*c**7 + a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8 -
        a**7*b*c**8 - a**6*b**2*c**8 + a**5*b**3*c**8 + a**3*b**5*c**8
        - a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 - a**7*c**9 +
        a**6*b*c**9 + 2*a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        2*a**3*b**4*c**9 + 2*a**2*b**5*c**9 + a*b**6*c**9 - b**7*c**9
        - a**5*b*c**10 + a**4*b**2*c**10 + a**2*b**4*c**10 -
        a*b**5*c**10 + a**4*b*c**11 - a**3*b**2*c**11 -
        a**2*b**3*c**11 + a*b**4*c**11), (a**7*b**7*c**2 +
        2*a**6*b**8*c**2 + a**8*b**5*c**3 + 5*a**7*b**6*c**3 +
        12*a**6*b**7*c**3 + 8*a**5*b**8*c**3 + 4*a**8*b**4*c**4 +
        17*a**7*b**5*c**4 + 32*a**6*b**6*c**4 + 32*a**5*b**7*c**4 +
        12*a**4*b**8*c**4 + 3*a**8*b**3*c**5 + 23*a**7*b**4*c**5 +
        51*a**6*b**5*c**5 + 54*a**5*b**6*c**5 + 32*a**4*b**7*c**5 +
        8*a**3*b**8*c**5 + 9*a**7*b**3*c**6 + 38*a**6*b**4*c**6 +
        51*a**5*b**5*c**6 + 32*a**4*b**6*c**6 + 12*a**3*b**7*c**6 +
        2*a**2*b**8*c**6 + 9*a**6*b**3*c**7 + 23*a**5*b**4*c**7 +
        17*a**4*b**5*c**7 + 5*a**3*b**6*c**7 + a**2*b**7*c**7 +
        3*a**5*b**3*c**8 + 4*a**4*b**4*c**8 +
        a**3*b**5*c**8)/(a**8*b**8 - a**7*b**9 + a**9*b**6*c -
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c - a**5*b**10*c +
        a**4*b**11*c + a**10*b**4*c**2 - a**9*b**5*c**2 -
        2*a**8*b**6*c**2 + a**7*b**7*c**2 - a**6*b**8*c**2 +
        2*a**5*b**9*c**2 + a**4*b**10*c**2 - a**3*b**11*c**2 -
        2*a**9*b**4*c**3 + a**8*b**5*c**3 + 3*a**6*b**7*c**3 +
        a**5*b**8*c**3 - 2*a**4*b**9*c**3 - a**2*b**11*c**3 -
        a**10*b**2*c**4 + a**8*b**4*c**4 + 2*a**7*b**5*c**4 +
        a**6*b**6*c**4 - 3*a**5*b**7*c**4 - 2*a**3*b**9*c**4 +
        a**2*b**10*c**4 + a*b**11*c**4 + a**9*b**2*c**5 +
        a**8*b**3*c**5 + a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        3*a**4*b**7*c**5 + a**3*b**8*c**5 + 2*a**2*b**9*c**5 -
        a*b**10*c**5 + a**8*b**2*c**6 - a**7*b**3*c**6 -
        2*a**6*b**4*c**6 - 2*a**5*b**5*c**6 + a**4*b**6*c**6 +
        3*a**3*b**7*c**6 - a**2*b**8*c**6 + a*b**9*c**6 + a**9*c**7 -
        2*a**7*b**2*c**7 - a**6*b**3*c**7 + a**5*b**4*c**7 +
        2*a**4*b**5*c**7 + a**2*b**7*c**7 - a*b**8*c**7 - b**9*c**7 -
        2*a**8*c**8 + a**6*b**2*c**8 + a**5*b**3*c**8 + a**4*b**4*c**8
        + a**3*b**5*c**8 - 2*a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8
        + a**7*c**9 + a**5*b**2*c**9 - 2*a**3*b**4*c**9 -
        a**2*b**5*c**9 + a*b**6*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), ((-1/3*zeta3 - 2/3)*a**7*b**5*c**2 +
        (-2/3*zeta3 - 4/3)*a**6*b**6*c**2 + (-1/3*zeta3 -
        2/3)*a**5*b**7*c**2 + (-5/3*zeta3 - 7/3)*a**7*b**4*c**3 +
        (-19/3*zeta3 - 29/3)*a**6*b**5*c**3 + (-19/3*zeta3 -
        29/3)*a**5*b**6*c**3 + (-5/3*zeta3 - 7/3)*a**4*b**7*c**3 +
        (-5/3*zeta3 - 7/3)*a**7*b**3*c**4 + (-34/3*zeta3 -
        50/3)*a**6*b**4*c**4 + (-58/3*zeta3 - 86/3)*a**5*b**5*c**4 +
        (-34/3*zeta3 - 50/3)*a**4*b**6*c**4 + (-5/3*zeta3 -
        7/3)*a**3*b**7*c**4 + (-1/3*zeta3 - 2/3)*a**7*b**2*c**5 +
        (-19/3*zeta3 - 29/3)*a**6*b**3*c**5 + (-58/3*zeta3 -
        86/3)*a**5*b**4*c**5 + (-58/3*zeta3 - 86/3)*a**4*b**5*c**5 +
        (-19/3*zeta3 - 29/3)*a**3*b**6*c**5 + (-1/3*zeta3 -
        2/3)*a**2*b**7*c**5 + (-2/3*zeta3 - 4/3)*a**6*b**2*c**6 +
        (-19/3*zeta3 - 29/3)*a**5*b**3*c**6 + (-34/3*zeta3 -
        50/3)*a**4*b**4*c**6 + (-19/3*zeta3 - 29/3)*a**3*b**5*c**6 +
        (-2/3*zeta3 - 4/3)*a**2*b**6*c**6 + (-1/3*zeta3 -
        2/3)*a**5*b**2*c**7 + (-5/3*zeta3 - 7/3)*a**4*b**3*c**7 +
        (-5/3*zeta3 - 7/3)*a**3*b**4*c**7 + (-1/3*zeta3 -
        2/3)*a**2*b**5*c**7)/(a**8*b**6 - a**7*b**7 + a**6*b**8 +
        (zeta3 + 1)*a**9*b**4*c + (-zeta3 - 1)*a**8*b**5*c + (zeta3 +
        1)*a**7*b**6*c + (zeta3 + 1)*a**6*b**7*c + (-zeta3 -
        1)*a**5*b**8*c + (zeta3 + 1)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (-zeta3 + 1)*a**8*b**3*c**3
        + zeta3*a**7*b**4*c**3 + (-zeta3 + 1)*a**6*b**5*c**3 + (-zeta3
        + 1)*a**5*b**6*c**3 + zeta3*a**4*b**7*c**3 + (-zeta3 +
        1)*a**3*b**8*c**3 + (zeta3 + 1)*a**9*b*c**4 +
        zeta3*a**7*b**3*c**4 + (3*zeta3 + 3)*a**6*b**4*c**4 + (-zeta3
        - 2)*a**5*b**5*c**4 + (3*zeta3 + 3)*a**4*b**6*c**4 +
        zeta3*a**3*b**7*c**4 + (zeta3 + 1)*a*b**9*c**4 + (-zeta3 -
        1)*a**8*b*c**5 - a**7*b**2*c**5 + (-zeta3 + 1)*a**6*b**3*c**5
        + (-zeta3 - 2)*a**5*b**4*c**5 + (-zeta3 - 2)*a**4*b**5*c**5 +
        (-zeta3 + 1)*a**3*b**6*c**5 - a**2*b**7*c**5 + (-zeta3 -
        1)*a*b**8*c**5 + a**8*c**6 + (zeta3 + 1)*a**7*b*c**6 +
        a**6*b**2*c**6 + (-zeta3 + 1)*a**5*b**3*c**6 + (3*zeta3 +
        3)*a**4*b**4*c**6 + (-zeta3 + 1)*a**3*b**5*c**6 +
        a**2*b**6*c**6 + (zeta3 + 1)*a*b**7*c**6 + b**8*c**6 -
        a**7*c**7 + (zeta3 + 1)*a**6*b*c**7 - a**5*b**2*c**7 +
        zeta3*a**4*b**3*c**7 + zeta3*a**3*b**4*c**7 - a**2*b**5*c**7 +
        (zeta3 + 1)*a*b**6*c**7 - b**7*c**7 + a**6*c**8 + (-zeta3 -
        1)*a**5*b*c**8 + (-zeta3 + 1)*a**3*b**3*c**8 + (-zeta3 -
        1)*a*b**5*c**8 + b**6*c**8 + (zeta3 + 1)*a**4*b*c**9 + (zeta3
        + 1)*a*b**4*c**9), ((1/3*zeta3 - 1/3)*a**7*b**5*c**2 +
        (2/3*zeta3 - 2/3)*a**6*b**6*c**2 + (1/3*zeta3 -
        1/3)*a**5*b**7*c**2 + (5/3*zeta3 - 2/3)*a**7*b**4*c**3 +
        (19/3*zeta3 - 10/3)*a**6*b**5*c**3 + (19/3*zeta3 -
        10/3)*a**5*b**6*c**3 + (5/3*zeta3 - 2/3)*a**4*b**7*c**3 +
        (5/3*zeta3 - 2/3)*a**7*b**3*c**4 + (34/3*zeta3 -
        16/3)*a**6*b**4*c**4 + (58/3*zeta3 - 28/3)*a**5*b**5*c**4 +
        (34/3*zeta3 - 16/3)*a**4*b**6*c**4 + (5/3*zeta3 -
        2/3)*a**3*b**7*c**4 + (1/3*zeta3 - 1/3)*a**7*b**2*c**5 +
        (19/3*zeta3 - 10/3)*a**6*b**3*c**5 + (58/3*zeta3 -
        28/3)*a**5*b**4*c**5 + (58/3*zeta3 - 28/3)*a**4*b**5*c**5 +
        (19/3*zeta3 - 10/3)*a**3*b**6*c**5 + (1/3*zeta3 -
        1/3)*a**2*b**7*c**5 + (2/3*zeta3 - 2/3)*a**6*b**2*c**6 +
        (19/3*zeta3 - 10/3)*a**5*b**3*c**6 + (34/3*zeta3 -
        16/3)*a**4*b**4*c**6 + (19/3*zeta3 - 10/3)*a**3*b**5*c**6 +
        (2/3*zeta3 - 2/3)*a**2*b**6*c**6 + (1/3*zeta3 -
        1/3)*a**5*b**2*c**7 + (5/3*zeta3 - 2/3)*a**4*b**3*c**7 +
        (5/3*zeta3 - 2/3)*a**3*b**4*c**7 + (1/3*zeta3 -
        1/3)*a**2*b**5*c**7)/(a**8*b**6 - a**7*b**7 + a**6*b**8 +
        (-zeta3)*a**9*b**4*c + zeta3*a**8*b**5*c +
        (-zeta3)*a**7*b**6*c + (-zeta3)*a**6*b**7*c +
        zeta3*a**5*b**8*c + (-zeta3)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (zeta3 + 2)*a**8*b**3*c**3 +
        (-zeta3 - 1)*a**7*b**4*c**3 + (zeta3 + 2)*a**6*b**5*c**3 +
        (zeta3 + 2)*a**5*b**6*c**3 + (-zeta3 - 1)*a**4*b**7*c**3 +
        (zeta3 + 2)*a**3*b**8*c**3 + (-zeta3)*a**9*b*c**4 + (-zeta3 -
        1)*a**7*b**3*c**4 + (-3*zeta3)*a**6*b**4*c**4 + (zeta3 -
        1)*a**5*b**5*c**4 + (-3*zeta3)*a**4*b**6*c**4 + (-zeta3 -
        1)*a**3*b**7*c**4 + (-zeta3)*a*b**9*c**4 + zeta3*a**8*b*c**5 -
        a**7*b**2*c**5 + (zeta3 + 2)*a**6*b**3*c**5 + (zeta3 -
        1)*a**5*b**4*c**5 + (zeta3 - 1)*a**4*b**5*c**5 + (zeta3 +
        2)*a**3*b**6*c**5 - a**2*b**7*c**5 + zeta3*a*b**8*c**5 +
        a**8*c**6 + (-zeta3)*a**7*b*c**6 + a**6*b**2*c**6 + (zeta3 +
        2)*a**5*b**3*c**6 + (-3*zeta3)*a**4*b**4*c**6 + (zeta3 +
        2)*a**3*b**5*c**6 + a**2*b**6*c**6 + (-zeta3)*a*b**7*c**6 +
        b**8*c**6 - a**7*c**7 + (-zeta3)*a**6*b*c**7 - a**5*b**2*c**7
        + (-zeta3 - 1)*a**4*b**3*c**7 + (-zeta3 - 1)*a**3*b**4*c**7 -
        a**2*b**5*c**7 + (-zeta3)*a*b**6*c**7 - b**7*c**7 + a**6*c**8
        + zeta3*a**5*b*c**8 + (zeta3 + 2)*a**3*b**3*c**8 +
        zeta3*a*b**5*c**8 + b**6*c**8 + (-zeta3)*a**4*b*c**9 +
        (-zeta3)*a*b**4*c**9)], 'K4': [(-2*a**19*b**6*c**2 -
        2*a**18*b**7*c**2 - 7*a**19*b**5*c**3 - 8*a**18*b**6*c**3 -
        7*a**17*b**7*c**3 - 10*a**19*b**4*c**4 - 13*a**18*b**5*c**4 -
        21*a**17*b**6*c**4 - 4*a**16*b**7*c**4 - 3*a**15*b**8*c**4 +
        a**14*b**9*c**4 - 7*a**19*b**3*c**5 - 13*a**18*b**4*c**5 -
        28*a**17*b**5*c**5 - 9*a**16*b**6*c**5 - 13*a**15*b**7*c**5 +
        5*a**14*b**8*c**5 - 3*a**13*b**9*c**5 + a**12*b**10*c**5 -
        2*a**19*b**2*c**6 - 8*a**18*b**3*c**6 - 21*a**17*b**4*c**6 -
        9*a**16*b**5*c**6 - 20*a**15*b**6*c**6 + 8*a**14*b**7*c**6 -
        8*a**13*b**8*c**6 + 4*a**12*b**9*c**6 - 2*a**11*b**10*c**6 -
        2*a**18*b**2*c**7 - 7*a**17*b**3*c**7 - 4*a**16*b**4*c**7 -
        13*a**15*b**5*c**7 + 8*a**14*b**6*c**7 - 10*a**13*b**7*c**7 +
        8*a**12*b**8*c**7 - 8*a**11*b**9*c**7 - 3*a**10*b**10*c**7 -
        4*a**9*b**11*c**7 - 3*a**15*b**4*c**8 + 5*a**14*b**5*c**8 -
        8*a**13*b**6*c**8 + 8*a**12*b**7*c**8 - 11*a**11*b**8*c**8 -
        14*a**10*b**9*c**8 - 19*a**9*b**10*c**8 - 4*a**8*b**11*c**8 +
        a**14*b**4*c**9 - 3*a**13*b**5*c**9 + 4*a**12*b**6*c**9 -
        8*a**11*b**7*c**9 - 14*a**10*b**8*c**9 - 35*a**9*b**9*c**9 -
        17*a**8*b**10*c**9 - 3*a**7*b**11*c**9 + a**12*b**5*c**10 -
        2*a**11*b**6*c**10 - 3*a**10*b**7*c**10 - 19*a**9*b**8*c**10 -
        17*a**8*b**9*c**10 - 5*a**7*b**10*c**10 - a**6*b**11*c**10 -
        4*a**9*b**7*c**11 - 4*a**8*b**8*c**11 - 3*a**7*b**9*c**11 -
        a**6*b**10*c**11 + a**5*b**11*c**11 + a**20*b**3*c**2*s**2 -
        2*a**19*b**4*c**2*s**2 + 5*a**18*b**5*c**2*s**2 +
        2*a**17*b**6*c**2*s**2 + a**20*b**2*c**3*s**2 -
        3*a**19*b**3*c**3*s**2 + 13*a**18*b**4*c**3*s**2 +
        17*a**17*b**5*c**3*s**2 + 12*a**16*b**6*c**3*s**2 -
        2*a**15*b**7*c**3*s**2 - 2*a**19*b**2*c**4*s**2 +
        13*a**18*b**3*c**4*s**2 + 30*a**17*b**4*c**4*s**2 +
        40*a**16*b**5*c**4*s**2 + 3*a**15*b**6*c**4*s**2 +
        3*a**14*b**7*c**4*s**2 - 5*a**13*b**8*c**4*s**2 +
        5*a**18*b**2*c**5*s**2 + 17*a**17*b**3*c**5*s**2 +
        40*a**16*b**4*c**5*s**2 + 10*a**15*b**5*c**5*s**2 +
        9*a**14*b**6*c**5*s**2 - 11*a**13*b**7*c**5*s**2 +
        a**12*b**8*c**5*s**2 - 4*a**11*b**9*c**5*s**2 +
        2*a**17*b**2*c**6*s**2 + 12*a**16*b**3*c**6*s**2 +
        3*a**15*b**4*c**6*s**2 + 9*a**14*b**5*c**6*s**2 -
        13*a**13*b**6*c**6*s**2 + 6*a**12*b**7*c**6*s**2 -
        9*a**11*b**8*c**6*s**2 + 4*a**10*b**9*c**6*s**2 -
        2*a**15*b**3*c**7*s**2 + 3*a**14*b**4*c**7*s**2 -
        11*a**13*b**5*c**7*s**2 + 6*a**12*b**6*c**7*s**2 -
        11*a**11*b**7*c**7*s**2 + 16*a**10*b**8*c**7*s**2 +
        22*a**9*b**9*c**7*s**2 + 13*a**8*b**10*c**7*s**2 -
        5*a**13*b**4*c**8*s**2 + a**12*b**5*c**8*s**2 -
        9*a**11*b**6*c**8*s**2 + 16*a**10*b**7*c**8*s**2 +
        47*a**9*b**8*c**8*s**2 + 53*a**8*b**9*c**8*s**2 +
        13*a**7*b**10*c**8*s**2 - 4*a**11*b**5*c**9*s**2 +
        4*a**10*b**6*c**9*s**2 + 22*a**9*b**7*c**9*s**2 +
        53*a**8*b**8*c**9*s**2 + 26*a**7*b**9*c**9*s**2 +
        13*a**8*b**7*c**10*s**2 + 13*a**7*b**8*c**10*s**2)/(a**25*b*s
        - 3*a**24*b**2*s + 5*a**23*b**3*s - 6*a**22*b**4*s +
        5*a**21*b**5*s - 3*a**20*b**6*s + a**19*b**7*s + a**25*c*s -
        5*a**24*b*c*s + 13*a**23*b**2*c*s - 23*a**22*b**3*c*s +
        30*a**21*b**4*c*s - 30*a**20*b**5*c*s + 23*a**19*b**6*c*s -
        13*a**18*b**7*c*s + 5*a**17*b**8*c*s - a**16*b**9*c*s -
        3*a**24*c**2*s + 13*a**23*b*c**2*s - 33*a**22*b**2*c**2*s +
        60*a**21*b**3*c**2*s - 83*a**20*b**4*c**2*s +
        91*a**19*b**5*c**2*s - 79*a**18*b**6*c**2*s +
        54*a**17*b**7*c**2*s - 28*a**16*b**8*c**2*s +
        10*a**15*b**9*c**2*s - 2*a**14*b**10*c**2*s + 5*a**23*c**3*s -
        23*a**22*b*c**3*s + 60*a**21*b**2*c**3*s -
        113*a**20*b**3*c**3*s + 164*a**19*b**4*c**3*s -
        191*a**18*b**5*c**3*s + 180*a**17*b**6*c**3*s -
        137*a**16*b**7*c**3*s + 83*a**15*b**8*c**3*s -
        38*a**14*b**9*c**3*s + 12*a**13*b**10*c**3*s -
        2*a**12*b**11*c**3*s - 6*a**22*c**4*s + 30*a**21*b*c**4*s -
        83*a**20*b**2*c**4*s + 164*a**19*b**3*c**4*s -
        250*a**18*b**4*c**4*s + 307*a**17*b**5*c**4*s -
        308*a**16*b**6*c**4*s + 253*a**15*b**7*c**4*s -
        169*a**14*b**8*c**4*s + 89*a**13*b**9*c**4*s -
        35*a**12*b**10*c**4*s + 9*a**11*b**11*c**4*s -
        a**10*b**12*c**4*s + 5*a**21*c**5*s - 30*a**20*b*c**5*s +
        91*a**19*b**2*c**5*s - 191*a**18*b**3*c**5*s +
        307*a**17*b**4*c**5*s - 395*a**16*b**5*c**5*s +
        417*a**15*b**6*c**5*s - 363*a**14*b**7*c**5*s +
        260*a**13*b**8*c**5*s - 151*a**12*b**9*c**5*s +
        68*a**11*b**10*c**5*s - 22*a**10*b**11*c**5*s +
        4*a**9*b**12*c**5*s - 3*a**20*c**6*s + 23*a**19*b*c**6*s -
        79*a**18*b**2*c**6*s + 180*a**17*b**3*c**6*s -
        308*a**16*b**4*c**6*s + 417*a**15*b**5*c**6*s -
        461*a**14*b**6*c**6*s + 420*a**13*b**7*c**6*s -
        316*a**12*b**8*c**6*s + 195*a**11*b**9*c**6*s -
        96*a**10*b**10*c**6*s + 36*a**9*b**11*c**6*s -
        9*a**8*b**12*c**6*s + a**7*b**13*c**6*s + a**19*c**7*s -
        13*a**18*b*c**7*s + 54*a**17*b**2*c**7*s -
        137*a**16*b**3*c**7*s + 253*a**15*b**4*c**7*s -
        363*a**14*b**5*c**7*s + 420*a**13*b**6*c**7*s -
        398*a**12*b**7*c**7*s + 310*a**11*b**8*c**7*s -
        198*a**10*b**9*c**7*s + 102*a**9*b**10*c**7*s -
        41*a**8*b**11*c**7*s + 12*a**7*b**12*c**7*s -
        2*a**6*b**13*c**7*s + 5*a**17*b*c**8*s - 28*a**16*b**2*c**8*s
        + 83*a**15*b**3*c**8*s - 169*a**14*b**4*c**8*s +
        260*a**13*b**5*c**8*s - 316*a**12*b**6*c**8*s +
        310*a**11*b**7*c**8*s - 247*a**10*b**8*c**8*s +
        159*a**9*b**9*c**8*s - 82*a**8*b**10*c**8*s +
        33*a**7*b**11*c**8*s - 10*a**6*b**12*c**8*s +
        2*a**5*b**13*c**8*s - a**16*b*c**9*s + 10*a**15*b**2*c**9*s -
        38*a**14*b**3*c**9*s + 89*a**13*b**4*c**9*s -
        151*a**12*b**5*c**9*s + 195*a**11*b**6*c**9*s -
        198*a**10*b**7*c**9*s + 159*a**9*b**8*c**9*s -
        99*a**8*b**9*c**9*s + 47*a**7*b**10*c**9*s -
        16*a**6*b**11*c**9*s + 4*a**5*b**12*c**9*s - a**4*b**13*c**9*s
        - 2*a**14*b**2*c**10*s + 12*a**13*b**3*c**10*s -
        35*a**12*b**4*c**10*s + 68*a**11*b**5*c**10*s -
        96*a**10*b**6*c**10*s + 102*a**9*b**7*c**10*s -
        82*a**8*b**8*c**10*s + 47*a**7*b**9*c**10*s -
        16*a**6*b**10*c**10*s + 3*a**4*b**12*c**10*s -
        a**3*b**13*c**10*s - 2*a**12*b**3*c**11*s +
        9*a**11*b**4*c**11*s - 22*a**10*b**5*c**11*s +
        36*a**9*b**6*c**11*s - 41*a**8*b**7*c**11*s +
        33*a**7*b**8*c**11*s - 16*a**6*b**9*c**11*s +
        7*a**4*b**11*c**11*s - 6*a**3*b**12*c**11*s +
        2*a**2*b**13*c**11*s - a**10*b**4*c**12*s +
        4*a**9*b**5*c**12*s - 9*a**8*b**6*c**12*s +
        12*a**7*b**7*c**12*s - 10*a**6*b**8*c**12*s +
        4*a**5*b**9*c**12*s + 3*a**4*b**10*c**12*s -
        6*a**3*b**11*c**12*s + 5*a**2*b**12*c**12*s -
        2*a*b**13*c**12*s + a**7*b**6*c**13*s - 2*a**6*b**7*c**13*s +
        2*a**5*b**8*c**13*s - a**4*b**9*c**13*s - a**3*b**10*c**13*s +
        2*a**2*b**11*c**13*s - 2*a*b**12*c**13*s + b**13*c**13*s),
        (a**11*b**11*c**5 - a**11*b**10*c**6 - a**10*b**11*c**6 -
        3*a**11*b**9*c**7 - 5*a**10*b**10*c**7 - 3*a**9*b**11*c**7 -
        4*a**11*b**8*c**8 - 17*a**10*b**9*c**8 - 17*a**9*b**10*c**8 -
        4*a**8*b**11*c**8 - 4*a**11*b**7*c**9 - 19*a**10*b**8*c**9 -
        35*a**9*b**9*c**9 - 19*a**8*b**10*c**9 - 4*a**7*b**11*c**9 -
        3*a**10*b**7*c**10 - 14*a**9*b**8*c**10 - 14*a**8*b**9*c**10 -
        3*a**7*b**10*c**10 - 2*a**10*b**6*c**11 - 8*a**9*b**7*c**11 -
        11*a**8*b**8*c**11 - 8*a**7*b**9*c**11 - 2*a**6*b**10*c**11 +
        a**10*b**5*c**12 + 4*a**9*b**6*c**12 + 8*a**8*b**7*c**12 +
        8*a**7*b**8*c**12 + 4*a**6*b**9*c**12 + a**5*b**10*c**12 -
        3*a**9*b**5*c**13 - 8*a**8*b**6*c**13 - 10*a**7*b**7*c**13 -
        8*a**6*b**8*c**13 - 3*a**5*b**9*c**13 + a**9*b**4*c**14 +
        5*a**8*b**5*c**14 + 8*a**7*b**6*c**14 + 8*a**6*b**7*c**14 +
        5*a**5*b**8*c**14 + a**4*b**9*c**14 - 3*a**8*b**4*c**15 -
        13*a**7*b**5*c**15 - 20*a**6*b**6*c**15 - 13*a**5*b**7*c**15 -
        3*a**4*b**8*c**15 - 4*a**7*b**4*c**16 - 9*a**6*b**5*c**16 -
        9*a**5*b**6*c**16 - 4*a**4*b**7*c**16 - 7*a**7*b**3*c**17 -
        21*a**6*b**4*c**17 - 28*a**5*b**5*c**17 - 21*a**4*b**6*c**17 -
        7*a**3*b**7*c**17 - 2*a**7*b**2*c**18 - 8*a**6*b**3*c**18 -
        13*a**5*b**4*c**18 - 13*a**4*b**5*c**18 - 8*a**3*b**6*c**18 -
        2*a**2*b**7*c**18 - 2*a**6*b**2*c**19 - 7*a**5*b**3*c**19 -
        10*a**4*b**4*c**19 - 7*a**3*b**5*c**19 - 2*a**2*b**6*c**19 +
        13*a**10*b**8*c**7*s**2 + 26*a**9*b**9*c**7*s**2 +
        13*a**8*b**10*c**7*s**2 + 13*a**10*b**7*c**8*s**2 +
        53*a**9*b**8*c**8*s**2 + 53*a**8*b**9*c**8*s**2 +
        13*a**7*b**10*c**8*s**2 + 22*a**9*b**7*c**9*s**2 +
        47*a**8*b**8*c**9*s**2 + 22*a**7*b**9*c**9*s**2 +
        4*a**9*b**6*c**10*s**2 + 16*a**8*b**7*c**10*s**2 +
        16*a**7*b**8*c**10*s**2 + 4*a**6*b**9*c**10*s**2 -
        4*a**9*b**5*c**11*s**2 - 9*a**8*b**6*c**11*s**2 -
        11*a**7*b**7*c**11*s**2 - 9*a**6*b**8*c**11*s**2 -
        4*a**5*b**9*c**11*s**2 + a**8*b**5*c**12*s**2 +
        6*a**7*b**6*c**12*s**2 + 6*a**6*b**7*c**12*s**2 +
        a**5*b**8*c**12*s**2 - 5*a**8*b**4*c**13*s**2 -
        11*a**7*b**5*c**13*s**2 - 13*a**6*b**6*c**13*s**2 -
        11*a**5*b**7*c**13*s**2 - 5*a**4*b**8*c**13*s**2 +
        3*a**7*b**4*c**14*s**2 + 9*a**6*b**5*c**14*s**2 +
        9*a**5*b**6*c**14*s**2 + 3*a**4*b**7*c**14*s**2 -
        2*a**7*b**3*c**15*s**2 + 3*a**6*b**4*c**15*s**2 +
        10*a**5*b**5*c**15*s**2 + 3*a**4*b**6*c**15*s**2 -
        2*a**3*b**7*c**15*s**2 + 12*a**6*b**3*c**16*s**2 +
        40*a**5*b**4*c**16*s**2 + 40*a**4*b**5*c**16*s**2 +
        12*a**3*b**6*c**16*s**2 + 2*a**6*b**2*c**17*s**2 +
        17*a**5*b**3*c**17*s**2 + 30*a**4*b**4*c**17*s**2 +
        17*a**3*b**5*c**17*s**2 + 2*a**2*b**6*c**17*s**2 +
        5*a**5*b**2*c**18*s**2 + 13*a**4*b**3*c**18*s**2 +
        13*a**3*b**4*c**18*s**2 + 5*a**2*b**5*c**18*s**2 -
        2*a**4*b**2*c**19*s**2 - 3*a**3*b**3*c**19*s**2 -
        2*a**2*b**4*c**19*s**2 + a**3*b**2*c**20*s**2 +
        a**2*b**3*c**20*s**2)/(a**13*b**13*s - 2*a**13*b**12*c*s -
        2*a**12*b**13*c*s + 2*a**13*b**11*c**2*s +
        5*a**12*b**12*c**2*s + 2*a**11*b**13*c**2*s -
        a**13*b**10*c**3*s - 6*a**12*b**11*c**3*s -
        6*a**11*b**12*c**3*s - a**10*b**13*c**3*s - a**13*b**9*c**4*s
        + 3*a**12*b**10*c**4*s + 7*a**11*b**11*c**4*s +
        3*a**10*b**12*c**4*s - a**9*b**13*c**4*s + 2*a**13*b**8*c**5*s
        + 4*a**12*b**9*c**5*s + 4*a**9*b**12*c**5*s +
        2*a**8*b**13*c**5*s - 2*a**13*b**7*c**6*s -
        10*a**12*b**8*c**6*s - 16*a**11*b**9*c**6*s -
        16*a**10*b**10*c**6*s - 16*a**9*b**11*c**6*s -
        10*a**8*b**12*c**6*s - 2*a**7*b**13*c**6*s + a**13*b**6*c**7*s
        + 12*a**12*b**7*c**7*s + 33*a**11*b**8*c**7*s +
        47*a**10*b**9*c**7*s + 47*a**9*b**10*c**7*s +
        33*a**8*b**11*c**7*s + 12*a**7*b**12*c**7*s +
        a**6*b**13*c**7*s - 9*a**12*b**6*c**8*s - 41*a**11*b**7*c**8*s
        - 82*a**10*b**8*c**8*s - 99*a**9*b**9*c**8*s -
        82*a**8*b**10*c**8*s - 41*a**7*b**11*c**8*s -
        9*a**6*b**12*c**8*s + 4*a**12*b**5*c**9*s +
        36*a**11*b**6*c**9*s + 102*a**10*b**7*c**9*s +
        159*a**9*b**8*c**9*s + 159*a**8*b**9*c**9*s +
        102*a**7*b**10*c**9*s + 36*a**6*b**11*c**9*s +
        4*a**5*b**12*c**9*s - a**12*b**4*c**10*s -
        22*a**11*b**5*c**10*s - 96*a**10*b**6*c**10*s -
        198*a**9*b**7*c**10*s - 247*a**8*b**8*c**10*s -
        198*a**7*b**9*c**10*s - 96*a**6*b**10*c**10*s -
        22*a**5*b**11*c**10*s - a**4*b**12*c**10*s +
        9*a**11*b**4*c**11*s + 68*a**10*b**5*c**11*s +
        195*a**9*b**6*c**11*s + 310*a**8*b**7*c**11*s +
        310*a**7*b**8*c**11*s + 195*a**6*b**9*c**11*s +
        68*a**5*b**10*c**11*s + 9*a**4*b**11*c**11*s -
        2*a**11*b**3*c**12*s - 35*a**10*b**4*c**12*s -
        151*a**9*b**5*c**12*s - 316*a**8*b**6*c**12*s -
        398*a**7*b**7*c**12*s - 316*a**6*b**8*c**12*s -
        151*a**5*b**9*c**12*s - 35*a**4*b**10*c**12*s -
        2*a**3*b**11*c**12*s + 12*a**10*b**3*c**13*s +
        89*a**9*b**4*c**13*s + 260*a**8*b**5*c**13*s +
        420*a**7*b**6*c**13*s + 420*a**6*b**7*c**13*s +
        260*a**5*b**8*c**13*s + 89*a**4*b**9*c**13*s +
        12*a**3*b**10*c**13*s - 2*a**10*b**2*c**14*s -
        38*a**9*b**3*c**14*s - 169*a**8*b**4*c**14*s -
        363*a**7*b**5*c**14*s - 461*a**6*b**6*c**14*s -
        363*a**5*b**7*c**14*s - 169*a**4*b**8*c**14*s -
        38*a**3*b**9*c**14*s - 2*a**2*b**10*c**14*s +
        10*a**9*b**2*c**15*s + 83*a**8*b**3*c**15*s +
        253*a**7*b**4*c**15*s + 417*a**6*b**5*c**15*s +
        417*a**5*b**6*c**15*s + 253*a**4*b**7*c**15*s +
        83*a**3*b**8*c**15*s + 10*a**2*b**9*c**15*s - a**9*b*c**16*s -
        28*a**8*b**2*c**16*s - 137*a**7*b**3*c**16*s -
        308*a**6*b**4*c**16*s - 395*a**5*b**5*c**16*s -
        308*a**4*b**6*c**16*s - 137*a**3*b**7*c**16*s -
        28*a**2*b**8*c**16*s - a*b**9*c**16*s + 5*a**8*b*c**17*s +
        54*a**7*b**2*c**17*s + 180*a**6*b**3*c**17*s +
        307*a**5*b**4*c**17*s + 307*a**4*b**5*c**17*s +
        180*a**3*b**6*c**17*s + 54*a**2*b**7*c**17*s +
        5*a*b**8*c**17*s - 13*a**7*b*c**18*s - 79*a**6*b**2*c**18*s -
        191*a**5*b**3*c**18*s - 250*a**4*b**4*c**18*s -
        191*a**3*b**5*c**18*s - 79*a**2*b**6*c**18*s -
        13*a*b**7*c**18*s + a**7*c**19*s + 23*a**6*b*c**19*s +
        91*a**5*b**2*c**19*s + 164*a**4*b**3*c**19*s +
        164*a**3*b**4*c**19*s + 91*a**2*b**5*c**19*s +
        23*a*b**6*c**19*s + b**7*c**19*s - 3*a**6*c**20*s -
        30*a**5*b*c**20*s - 83*a**4*b**2*c**20*s -
        113*a**3*b**3*c**20*s - 83*a**2*b**4*c**20*s -
        30*a*b**5*c**20*s - 3*b**6*c**20*s + 5*a**5*c**21*s +
        30*a**4*b*c**21*s + 60*a**3*b**2*c**21*s +
        60*a**2*b**3*c**21*s + 30*a*b**4*c**21*s + 5*b**5*c**21*s -
        6*a**4*c**22*s - 23*a**3*b*c**22*s - 33*a**2*b**2*c**22*s -
        23*a*b**3*c**22*s - 6*b**4*c**22*s + 5*a**3*c**23*s +
        13*a**2*b*c**23*s + 13*a*b**2*c**23*s + 5*b**3*c**23*s -
        3*a**2*c**24*s - 5*a*b*c**24*s - 3*b**2*c**24*s + a*c**25*s +
        b*c**25*s), (-2*a**7*b**18*c**2 - 2*a**6*b**19*c**2 -
        7*a**7*b**17*c**3 - 8*a**6*b**18*c**3 - 7*a**5*b**19*c**3 +
        a**9*b**14*c**4 - 3*a**8*b**15*c**4 - 4*a**7*b**16*c**4 -
        21*a**6*b**17*c**4 - 13*a**5*b**18*c**4 - 10*a**4*b**19*c**4 +
        a**10*b**12*c**5 - 3*a**9*b**13*c**5 + 5*a**8*b**14*c**5 -
        13*a**7*b**15*c**5 - 9*a**6*b**16*c**5 - 28*a**5*b**17*c**5 -
        13*a**4*b**18*c**5 - 7*a**3*b**19*c**5 - 2*a**10*b**11*c**6 +
        4*a**9*b**12*c**6 - 8*a**8*b**13*c**6 + 8*a**7*b**14*c**6 -
        20*a**6*b**15*c**6 - 9*a**5*b**16*c**6 - 21*a**4*b**17*c**6 -
        8*a**3*b**18*c**6 - 2*a**2*b**19*c**6 - 4*a**11*b**9*c**7 -
        3*a**10*b**10*c**7 - 8*a**9*b**11*c**7 + 8*a**8*b**12*c**7 -
        10*a**7*b**13*c**7 + 8*a**6*b**14*c**7 - 13*a**5*b**15*c**7 -
        4*a**4*b**16*c**7 - 7*a**3*b**17*c**7 - 2*a**2*b**18*c**7 -
        4*a**11*b**8*c**8 - 19*a**10*b**9*c**8 - 14*a**9*b**10*c**8 -
        11*a**8*b**11*c**8 + 8*a**7*b**12*c**8 - 8*a**6*b**13*c**8 +
        5*a**5*b**14*c**8 - 3*a**4*b**15*c**8 - 3*a**11*b**7*c**9 -
        17*a**10*b**8*c**9 - 35*a**9*b**9*c**9 - 14*a**8*b**10*c**9 -
        8*a**7*b**11*c**9 + 4*a**6*b**12*c**9 - 3*a**5*b**13*c**9 +
        a**4*b**14*c**9 - a**11*b**6*c**10 - 5*a**10*b**7*c**10 -
        17*a**9*b**8*c**10 - 19*a**8*b**9*c**10 - 3*a**7*b**10*c**10 -
        2*a**6*b**11*c**10 + a**5*b**12*c**10 + a**11*b**5*c**11 -
        a**10*b**6*c**11 - 3*a**9*b**7*c**11 - 4*a**8*b**8*c**11 -
        4*a**7*b**9*c**11 + 2*a**6*b**17*c**2*s**2 +
        5*a**5*b**18*c**2*s**2 - 2*a**4*b**19*c**2*s**2 +
        a**3*b**20*c**2*s**2 - 2*a**7*b**15*c**3*s**2 +
        12*a**6*b**16*c**3*s**2 + 17*a**5*b**17*c**3*s**2 +
        13*a**4*b**18*c**3*s**2 - 3*a**3*b**19*c**3*s**2 +
        a**2*b**20*c**3*s**2 - 5*a**8*b**13*c**4*s**2 +
        3*a**7*b**14*c**4*s**2 + 3*a**6*b**15*c**4*s**2 +
        40*a**5*b**16*c**4*s**2 + 30*a**4*b**17*c**4*s**2 +
        13*a**3*b**18*c**4*s**2 - 2*a**2*b**19*c**4*s**2 -
        4*a**9*b**11*c**5*s**2 + a**8*b**12*c**5*s**2 -
        11*a**7*b**13*c**5*s**2 + 9*a**6*b**14*c**5*s**2 +
        10*a**5*b**15*c**5*s**2 + 40*a**4*b**16*c**5*s**2 +
        17*a**3*b**17*c**5*s**2 + 5*a**2*b**18*c**5*s**2 +
        4*a**9*b**10*c**6*s**2 - 9*a**8*b**11*c**6*s**2 +
        6*a**7*b**12*c**6*s**2 - 13*a**6*b**13*c**6*s**2 +
        9*a**5*b**14*c**6*s**2 + 3*a**4*b**15*c**6*s**2 +
        12*a**3*b**16*c**6*s**2 + 2*a**2*b**17*c**6*s**2 +
        13*a**10*b**8*c**7*s**2 + 22*a**9*b**9*c**7*s**2 +
        16*a**8*b**10*c**7*s**2 - 11*a**7*b**11*c**7*s**2 +
        6*a**6*b**12*c**7*s**2 - 11*a**5*b**13*c**7*s**2 +
        3*a**4*b**14*c**7*s**2 - 2*a**3*b**15*c**7*s**2 +
        13*a**10*b**7*c**8*s**2 + 53*a**9*b**8*c**8*s**2 +
        47*a**8*b**9*c**8*s**2 + 16*a**7*b**10*c**8*s**2 -
        9*a**6*b**11*c**8*s**2 + a**5*b**12*c**8*s**2 -
        5*a**4*b**13*c**8*s**2 + 26*a**9*b**7*c**9*s**2 +
        53*a**8*b**8*c**9*s**2 + 22*a**7*b**9*c**9*s**2 +
        4*a**6*b**10*c**9*s**2 - 4*a**5*b**11*c**9*s**2 +
        13*a**8*b**7*c**10*s**2 +
        13*a**7*b**8*c**10*s**2)/(a**7*b**19*s - 3*a**6*b**20*s +
        5*a**5*b**21*s - 6*a**4*b**22*s + 5*a**3*b**23*s -
        3*a**2*b**24*s + a*b**25*s - a**9*b**16*c*s + 5*a**8*b**17*c*s
        - 13*a**7*b**18*c*s + 23*a**6*b**19*c*s - 30*a**5*b**20*c*s +
        30*a**4*b**21*c*s - 23*a**3*b**22*c*s + 13*a**2*b**23*c*s -
        5*a*b**24*c*s + b**25*c*s - 2*a**10*b**14*c**2*s +
        10*a**9*b**15*c**2*s - 28*a**8*b**16*c**2*s +
        54*a**7*b**17*c**2*s - 79*a**6*b**18*c**2*s +
        91*a**5*b**19*c**2*s - 83*a**4*b**20*c**2*s +
        60*a**3*b**21*c**2*s - 33*a**2*b**22*c**2*s +
        13*a*b**23*c**2*s - 3*b**24*c**2*s - 2*a**11*b**12*c**3*s +
        12*a**10*b**13*c**3*s - 38*a**9*b**14*c**3*s +
        83*a**8*b**15*c**3*s - 137*a**7*b**16*c**3*s +
        180*a**6*b**17*c**3*s - 191*a**5*b**18*c**3*s +
        164*a**4*b**19*c**3*s - 113*a**3*b**20*c**3*s +
        60*a**2*b**21*c**3*s - 23*a*b**22*c**3*s + 5*b**23*c**3*s -
        a**12*b**10*c**4*s + 9*a**11*b**11*c**4*s -
        35*a**10*b**12*c**4*s + 89*a**9*b**13*c**4*s -
        169*a**8*b**14*c**4*s + 253*a**7*b**15*c**4*s -
        308*a**6*b**16*c**4*s + 307*a**5*b**17*c**4*s -
        250*a**4*b**18*c**4*s + 164*a**3*b**19*c**4*s -
        83*a**2*b**20*c**4*s + 30*a*b**21*c**4*s - 6*b**22*c**4*s +
        4*a**12*b**9*c**5*s - 22*a**11*b**10*c**5*s +
        68*a**10*b**11*c**5*s - 151*a**9*b**12*c**5*s +
        260*a**8*b**13*c**5*s - 363*a**7*b**14*c**5*s +
        417*a**6*b**15*c**5*s - 395*a**5*b**16*c**5*s +
        307*a**4*b**17*c**5*s - 191*a**3*b**18*c**5*s +
        91*a**2*b**19*c**5*s - 30*a*b**20*c**5*s + 5*b**21*c**5*s +
        a**13*b**7*c**6*s - 9*a**12*b**8*c**6*s + 36*a**11*b**9*c**6*s
        - 96*a**10*b**10*c**6*s + 195*a**9*b**11*c**6*s -
        316*a**8*b**12*c**6*s + 420*a**7*b**13*c**6*s -
        461*a**6*b**14*c**6*s + 417*a**5*b**15*c**6*s -
        308*a**4*b**16*c**6*s + 180*a**3*b**17*c**6*s -
        79*a**2*b**18*c**6*s + 23*a*b**19*c**6*s - 3*b**20*c**6*s -
        2*a**13*b**6*c**7*s + 12*a**12*b**7*c**7*s -
        41*a**11*b**8*c**7*s + 102*a**10*b**9*c**7*s -
        198*a**9*b**10*c**7*s + 310*a**8*b**11*c**7*s -
        398*a**7*b**12*c**7*s + 420*a**6*b**13*c**7*s -
        363*a**5*b**14*c**7*s + 253*a**4*b**15*c**7*s -
        137*a**3*b**16*c**7*s + 54*a**2*b**17*c**7*s -
        13*a*b**18*c**7*s + b**19*c**7*s + 2*a**13*b**5*c**8*s -
        10*a**12*b**6*c**8*s + 33*a**11*b**7*c**8*s -
        82*a**10*b**8*c**8*s + 159*a**9*b**9*c**8*s -
        247*a**8*b**10*c**8*s + 310*a**7*b**11*c**8*s -
        316*a**6*b**12*c**8*s + 260*a**5*b**13*c**8*s -
        169*a**4*b**14*c**8*s + 83*a**3*b**15*c**8*s -
        28*a**2*b**16*c**8*s + 5*a*b**17*c**8*s - a**13*b**4*c**9*s +
        4*a**12*b**5*c**9*s - 16*a**11*b**6*c**9*s +
        47*a**10*b**7*c**9*s - 99*a**9*b**8*c**9*s +
        159*a**8*b**9*c**9*s - 198*a**7*b**10*c**9*s +
        195*a**6*b**11*c**9*s - 151*a**5*b**12*c**9*s +
        89*a**4*b**13*c**9*s - 38*a**3*b**14*c**9*s +
        10*a**2*b**15*c**9*s - a*b**16*c**9*s - a**13*b**3*c**10*s +
        3*a**12*b**4*c**10*s - 16*a**10*b**6*c**10*s +
        47*a**9*b**7*c**10*s - 82*a**8*b**8*c**10*s +
        102*a**7*b**9*c**10*s - 96*a**6*b**10*c**10*s +
        68*a**5*b**11*c**10*s - 35*a**4*b**12*c**10*s +
        12*a**3*b**13*c**10*s - 2*a**2*b**14*c**10*s +
        2*a**13*b**2*c**11*s - 6*a**12*b**3*c**11*s +
        7*a**11*b**4*c**11*s - 16*a**9*b**6*c**11*s +
        33*a**8*b**7*c**11*s - 41*a**7*b**8*c**11*s +
        36*a**6*b**9*c**11*s - 22*a**5*b**10*c**11*s +
        9*a**4*b**11*c**11*s - 2*a**3*b**12*c**11*s -
        2*a**13*b*c**12*s + 5*a**12*b**2*c**12*s -
        6*a**11*b**3*c**12*s + 3*a**10*b**4*c**12*s +
        4*a**9*b**5*c**12*s - 10*a**8*b**6*c**12*s +
        12*a**7*b**7*c**12*s - 9*a**6*b**8*c**12*s +
        4*a**5*b**9*c**12*s - a**4*b**10*c**12*s + a**13*c**13*s -
        2*a**12*b*c**13*s + 2*a**11*b**2*c**13*s - a**10*b**3*c**13*s
        - a**9*b**4*c**13*s + 2*a**8*b**5*c**13*s -
        2*a**7*b**6*c**13*s + a**6*b**7*c**13*s), (-3*a**11*b**5*c**3
        - 6*a**10*b**6*c**3 - 3*a**9*b**7*c**3 + a**8*b**8*c**3 -
        5*a**11*b**4*c**4 - 17*a**10*b**5*c**4 - 19*a**9*b**6*c**4 -
        7*a**8*b**7*c**4 - a**7*b**8*c**4 - a**6*b**9*c**4 -
        3*a**11*b**3*c**5 - 17*a**10*b**4*c**5 - 31*a**9*b**5*c**5 -
        17*a**8*b**6*c**5 - 12*a**7*b**7*c**5 - 12*a**6*b**8*c**5 -
        5*a**5*b**9*c**5 - 6*a**10*b**3*c**6 - 19*a**9*b**4*c**6 -
        17*a**8*b**5*c**6 - 9*a**7*b**6*c**6 - 16*a**6*b**7*c**6 -
        20*a**5*b**8*c**6 - 9*a**4*b**9*c**6 - 3*a**9*b**3*c**7 -
        7*a**8*b**4*c**7 - 12*a**7*b**5*c**7 - 16*a**6*b**6*c**7 -
        17*a**5*b**7*c**7 - 16*a**4*b**8*c**7 - 7*a**3*b**9*c**7 +
        a**8*b**3*c**8 - a**7*b**4*c**8 - 12*a**6*b**5*c**8 -
        20*a**5*b**6*c**8 - 16*a**4*b**7*c**8 - 8*a**3*b**8*c**8 -
        2*a**2*b**9*c**8 - a**6*b**4*c**9 - 5*a**5*b**5*c**9 -
        9*a**4*b**6*c**9 - 7*a**3*b**7*c**9 - 2*a**2*b**8*c**9 +
        13*a**10*b**4*c**3*s**2 + 22*a**9*b**5*c**3*s**2 +
        4*a**8*b**6*c**3*s**2 - 3*a**7*b**7*c**3*s**2 +
        13*a**10*b**3*c**4*s**2 + 57*a**9*b**4*c**4*s**2 +
        54*a**8*b**5*c**4*s**2 + 4*a**7*b**6*c**4*s**2 -
        6*a**6*b**7*c**4*s**2 + 22*a**9*b**3*c**5*s**2 +
        54*a**8*b**4*c**5*s**2 + 34*a**7*b**5*c**5*s**2 +
        13*a**6*b**6*c**5*s**2 + 12*a**5*b**7*c**5*s**2 +
        4*a**4*b**8*c**5*s**2 + 4*a**8*b**3*c**6*s**2 +
        4*a**7*b**4*c**6*s**2 + 13*a**6*b**5*c**6*s**2 +
        43*a**5*b**6*c**6*s**2 + 37*a**4*b**7*c**6*s**2 +
        7*a**3*b**8*c**6*s**2 - 3*a**7*b**3*c**7*s**2 -
        6*a**6*b**4*c**7*s**2 + 12*a**5*b**5*c**7*s**2 +
        37*a**4*b**6*c**7*s**2 + 24*a**3*b**7*c**7*s**2 +
        3*a**2*b**8*c**7*s**2 + 4*a**4*b**5*c**8*s**2 +
        7*a**3*b**6*c**8*s**2 + 3*a**2*b**7*c**8*s**2)/(a**13*b**5*s -
        a**12*b**6*s - a**11*b**7*s + a**10*b**8*s - 2*a**13*b**4*c*s
        + 2*a**12*b**5*c*s + 4*a**11*b**6*c*s - 4*a**10*b**7*c*s -
        2*a**9*b**8*c*s + 2*a**8*b**9*c*s + a**13*b**3*c**2*s -
        2*a**12*b**4*c**2*s - 6*a**11*b**5*c**2*s +
        8*a**10*b**6*c**2*s + 7*a**9*b**7*c**2*s - 8*a**8*b**8*c**2*s
        - 2*a**7*b**9*c**2*s + 2*a**6*b**10*c**2*s + a**13*b**2*c**3*s
        + 2*a**12*b**3*c**3*s + 3*a**11*b**4*c**3*s -
        11*a**10*b**5*c**3*s - 10*a**9*b**6*c**3*s +
        17*a**8*b**7*c**3*s + 7*a**7*b**8*c**3*s - 9*a**6*b**9*c**3*s
        - a**5*b**10*c**3*s + a**4*b**11*c**3*s - 2*a**13*b*c**4*s -
        2*a**12*b**2*c**4*s + 3*a**11*b**3*c**4*s +
        12*a**10*b**4*c**4*s + 5*a**9*b**5*c**4*s -
        25*a**8*b**6*c**4*s - 10*a**7*b**7*c**4*s +
        21*a**6*b**8*c**4*s + 4*a**5*b**9*c**4*s - 6*a**4*b**10*c**4*s
        + a**13*c**5*s + 2*a**12*b*c**5*s - 6*a**11*b**2*c**5*s -
        11*a**10*b**3*c**5*s + 5*a**9*b**4*c**5*s +
        28*a**8*b**5*c**5*s + 5*a**7*b**6*c**5*s - 33*a**6*b**7*c**5*s
        - 6*a**5*b**8*c**5*s + 16*a**4*b**9*c**5*s + a**3*b**10*c**5*s
        - 2*a**2*b**11*c**5*s - a**12*c**6*s + 4*a**11*b*c**6*s +
        8*a**10*b**2*c**6*s - 10*a**9*b**3*c**6*s -
        25*a**8*b**4*c**6*s + 5*a**7*b**5*c**6*s + 38*a**6*b**6*c**6*s
        + 3*a**5*b**7*c**6*s - 27*a**4*b**8*c**6*s -
        2*a**3*b**9*c**6*s + 7*a**2*b**10*c**6*s - a**11*c**7*s -
        4*a**10*b*c**7*s + 7*a**9*b**2*c**7*s + 17*a**8*b**3*c**7*s -
        10*a**7*b**4*c**7*s - 33*a**6*b**5*c**7*s + 3*a**5*b**6*c**7*s
        + 32*a**4*b**7*c**7*s + a**3*b**8*c**7*s - 13*a**2*b**9*c**7*s
        + b**11*c**7*s + a**10*c**8*s - 2*a**9*b*c**8*s -
        8*a**8*b**2*c**8*s + 7*a**7*b**3*c**8*s + 21*a**6*b**4*c**8*s
        - 6*a**5*b**5*c**8*s - 27*a**4*b**6*c**8*s + a**3*b**7*c**8*s
        + 16*a**2*b**8*c**8*s - 3*b**10*c**8*s + 2*a**8*b*c**9*s -
        2*a**7*b**2*c**9*s - 9*a**6*b**3*c**9*s + 4*a**5*b**4*c**9*s +
        16*a**4*b**5*c**9*s - 2*a**3*b**6*c**9*s - 13*a**2*b**7*c**9*s
        + 4*b**9*c**9*s + 2*a**6*b**2*c**10*s - a**5*b**3*c**10*s -
        6*a**4*b**4*c**10*s + a**3*b**5*c**10*s + 7*a**2*b**6*c**10*s
        - 3*b**8*c**10*s + a**4*b**3*c**11*s - 2*a**2*b**5*c**11*s +
        b**7*c**11*s), (-2*a**9*b**8*c**2 - 2*a**8*b**9*c**2 -
        7*a**9*b**7*c**3 - 8*a**8*b**8*c**3 - 7*a**7*b**9*c**3 -
        9*a**9*b**6*c**4 - 16*a**8*b**7*c**4 - 16*a**7*b**8*c**4 -
        9*a**6*b**9*c**4 - 5*a**9*b**5*c**5 - 20*a**8*b**6*c**5 -
        17*a**7*b**7*c**5 - 20*a**6*b**8*c**5 - 5*a**5*b**9*c**5 -
        a**9*b**4*c**6 - 12*a**8*b**5*c**6 - 16*a**7*b**6*c**6 -
        16*a**6*b**7*c**6 - 12*a**5*b**8*c**6 - a**4*b**9*c**6 -
        a**8*b**4*c**7 - 12*a**7*b**5*c**7 - 9*a**6*b**6*c**7 -
        12*a**5*b**7*c**7 - a**4*b**8*c**7 + a**8*b**3*c**8 -
        7*a**7*b**4*c**8 - 17*a**6*b**5*c**8 - 17*a**5*b**6*c**8 -
        7*a**4*b**7*c**8 + a**3*b**8*c**8 - 3*a**7*b**3*c**9 -
        19*a**6*b**4*c**9 - 31*a**5*b**5*c**9 - 19*a**4*b**6*c**9 -
        3*a**3*b**7*c**9 - 6*a**6*b**3*c**10 - 17*a**5*b**4*c**10 -
        17*a**4*b**5*c**10 - 6*a**3*b**6*c**10 - 3*a**5*b**3*c**11 -
        5*a**4*b**4*c**11 - 3*a**3*b**5*c**11 + 3*a**8*b**7*c**2*s**2
        + 3*a**7*b**8*c**2*s**2 + 7*a**8*b**6*c**3*s**2 +
        24*a**7*b**7*c**3*s**2 + 7*a**6*b**8*c**3*s**2 +
        4*a**8*b**5*c**4*s**2 + 37*a**7*b**6*c**4*s**2 +
        37*a**6*b**7*c**4*s**2 + 4*a**5*b**8*c**4*s**2 +
        12*a**7*b**5*c**5*s**2 + 43*a**6*b**6*c**5*s**2 +
        12*a**5*b**7*c**5*s**2 - 6*a**7*b**4*c**6*s**2 +
        13*a**6*b**5*c**6*s**2 + 13*a**5*b**6*c**6*s**2 -
        6*a**4*b**7*c**6*s**2 - 3*a**7*b**3*c**7*s**2 +
        4*a**6*b**4*c**7*s**2 + 34*a**5*b**5*c**7*s**2 +
        4*a**4*b**6*c**7*s**2 - 3*a**3*b**7*c**7*s**2 +
        4*a**6*b**3*c**8*s**2 + 54*a**5*b**4*c**8*s**2 +
        54*a**4*b**5*c**8*s**2 + 4*a**3*b**6*c**8*s**2 +
        22*a**5*b**3*c**9*s**2 + 57*a**4*b**4*c**9*s**2 +
        22*a**3*b**5*c**9*s**2 + 13*a**4*b**3*c**10*s**2 +
        13*a**3*b**4*c**10*s**2)/(a**11*b**7*s - 3*a**10*b**8*s +
        4*a**9*b**9*s - 3*a**8*b**10*s + a**7*b**11*s -
        2*a**11*b**5*c**2*s + 7*a**10*b**6*c**2*s -
        13*a**9*b**7*c**2*s + 16*a**8*b**8*c**2*s -
        13*a**7*b**9*c**2*s + 7*a**6*b**10*c**2*s -
        2*a**5*b**11*c**2*s + a**10*b**5*c**3*s - 2*a**9*b**6*c**3*s +
        a**8*b**7*c**3*s + a**7*b**8*c**3*s - 2*a**6*b**9*c**3*s +
        a**5*b**10*c**3*s + a**11*b**3*c**4*s - 6*a**10*b**4*c**4*s +
        16*a**9*b**5*c**4*s - 27*a**8*b**6*c**4*s +
        32*a**7*b**7*c**4*s - 27*a**6*b**8*c**4*s +
        16*a**5*b**9*c**4*s - 6*a**4*b**10*c**4*s + a**3*b**11*c**4*s
        - a**10*b**3*c**5*s + 4*a**9*b**4*c**5*s - 6*a**8*b**5*c**5*s
        + 3*a**7*b**6*c**5*s + 3*a**6*b**7*c**5*s - 6*a**5*b**8*c**5*s
        + 4*a**4*b**9*c**5*s - a**3*b**10*c**5*s + 2*a**10*b**2*c**6*s
        - 9*a**9*b**3*c**6*s + 21*a**8*b**4*c**6*s -
        33*a**7*b**5*c**6*s + 38*a**6*b**6*c**6*s -
        33*a**5*b**7*c**6*s + 21*a**4*b**8*c**6*s - 9*a**3*b**9*c**6*s
        + 2*a**2*b**10*c**6*s - 2*a**9*b**2*c**7*s +
        7*a**8*b**3*c**7*s - 10*a**7*b**4*c**7*s + 5*a**6*b**5*c**7*s
        + 5*a**5*b**6*c**7*s - 10*a**4*b**7*c**7*s +
        7*a**3*b**8*c**7*s - 2*a**2*b**9*c**7*s + 2*a**9*b*c**8*s -
        8*a**8*b**2*c**8*s + 17*a**7*b**3*c**8*s - 25*a**6*b**4*c**8*s
        + 28*a**5*b**5*c**8*s - 25*a**4*b**6*c**8*s +
        17*a**3*b**7*c**8*s - 8*a**2*b**8*c**8*s + 2*a*b**9*c**8*s -
        2*a**8*b*c**9*s + 7*a**7*b**2*c**9*s - 10*a**6*b**3*c**9*s +
        5*a**5*b**4*c**9*s + 5*a**4*b**5*c**9*s - 10*a**3*b**6*c**9*s
        + 7*a**2*b**7*c**9*s - 2*a*b**8*c**9*s + a**8*c**10*s -
        4*a**7*b*c**10*s + 8*a**6*b**2*c**10*s - 11*a**5*b**3*c**10*s
        + 12*a**4*b**4*c**10*s - 11*a**3*b**5*c**10*s +
        8*a**2*b**6*c**10*s - 4*a*b**7*c**10*s + b**8*c**10*s -
        a**7*c**11*s + 4*a**6*b*c**11*s - 6*a**5*b**2*c**11*s +
        3*a**4*b**3*c**11*s + 3*a**3*b**4*c**11*s -
        6*a**2*b**5*c**11*s + 4*a*b**6*c**11*s - b**7*c**11*s -
        a**6*c**12*s + 2*a**5*b*c**12*s - 2*a**4*b**2*c**12*s +
        2*a**3*b**3*c**12*s - 2*a**2*b**4*c**12*s + 2*a*b**5*c**12*s -
        b**6*c**12*s + a**5*c**13*s - 2*a**4*b*c**13*s +
        a**3*b**2*c**13*s + a**2*b**3*c**13*s - 2*a*b**4*c**13*s +
        b**5*c**13*s), (a**8*b**8*c**3 - 3*a**7*b**9*c**3 -
        6*a**6*b**10*c**3 - 3*a**5*b**11*c**3 - a**9*b**6*c**4 -
        a**8*b**7*c**4 - 7*a**7*b**8*c**4 - 19*a**6*b**9*c**4 -
        17*a**5*b**10*c**4 - 5*a**4*b**11*c**4 - 5*a**9*b**5*c**5 -
        12*a**8*b**6*c**5 - 12*a**7*b**7*c**5 - 17*a**6*b**8*c**5 -
        31*a**5*b**9*c**5 - 17*a**4*b**10*c**5 - 3*a**3*b**11*c**5 -
        9*a**9*b**4*c**6 - 20*a**8*b**5*c**6 - 16*a**7*b**6*c**6 -
        9*a**6*b**7*c**6 - 17*a**5*b**8*c**6 - 19*a**4*b**9*c**6 -
        6*a**3*b**10*c**6 - 7*a**9*b**3*c**7 - 16*a**8*b**4*c**7 -
        17*a**7*b**5*c**7 - 16*a**6*b**6*c**7 - 12*a**5*b**7*c**7 -
        7*a**4*b**8*c**7 - 3*a**3*b**9*c**7 - 2*a**9*b**2*c**8 -
        8*a**8*b**3*c**8 - 16*a**7*b**4*c**8 - 20*a**6*b**5*c**8 -
        12*a**5*b**6*c**8 - a**4*b**7*c**8 + a**3*b**8*c**8 -
        2*a**8*b**2*c**9 - 7*a**7*b**3*c**9 - 9*a**6*b**4*c**9 -
        5*a**5*b**5*c**9 - a**4*b**6*c**9 - 3*a**7*b**7*c**3*s**2 +
        4*a**6*b**8*c**3*s**2 + 22*a**5*b**9*c**3*s**2 +
        13*a**4*b**10*c**3*s**2 - 6*a**7*b**6*c**4*s**2 +
        4*a**6*b**7*c**4*s**2 + 54*a**5*b**8*c**4*s**2 +
        57*a**4*b**9*c**4*s**2 + 13*a**3*b**10*c**4*s**2 +
        4*a**8*b**4*c**5*s**2 + 12*a**7*b**5*c**5*s**2 +
        13*a**6*b**6*c**5*s**2 + 34*a**5*b**7*c**5*s**2 +
        54*a**4*b**8*c**5*s**2 + 22*a**3*b**9*c**5*s**2 +
        7*a**8*b**3*c**6*s**2 + 37*a**7*b**4*c**6*s**2 +
        43*a**6*b**5*c**6*s**2 + 13*a**5*b**6*c**6*s**2 +
        4*a**4*b**7*c**6*s**2 + 4*a**3*b**8*c**6*s**2 +
        3*a**8*b**2*c**7*s**2 + 24*a**7*b**3*c**7*s**2 +
        37*a**6*b**4*c**7*s**2 + 12*a**5*b**5*c**7*s**2 -
        6*a**4*b**6*c**7*s**2 - 3*a**3*b**7*c**7*s**2 +
        3*a**7*b**2*c**8*s**2 + 7*a**6*b**3*c**8*s**2 +
        4*a**5*b**4*c**8*s**2)/(a**8*b**10*s - a**7*b**11*s -
        a**6*b**12*s + a**5*b**13*s + 2*a**9*b**8*c*s -
        2*a**8*b**9*c*s - 4*a**7*b**10*c*s + 4*a**6*b**11*c*s +
        2*a**5*b**12*c*s - 2*a**4*b**13*c*s + 2*a**10*b**6*c**2*s -
        2*a**9*b**7*c**2*s - 8*a**8*b**8*c**2*s + 7*a**7*b**9*c**2*s +
        8*a**6*b**10*c**2*s - 6*a**5*b**11*c**2*s -
        2*a**4*b**12*c**2*s + a**3*b**13*c**2*s + a**11*b**4*c**3*s -
        a**10*b**5*c**3*s - 9*a**9*b**6*c**3*s + 7*a**8*b**7*c**3*s +
        17*a**7*b**8*c**3*s - 10*a**6*b**9*c**3*s -
        11*a**5*b**10*c**3*s + 3*a**4*b**11*c**3*s +
        2*a**3*b**12*c**3*s + a**2*b**13*c**3*s - 6*a**10*b**4*c**4*s
        + 4*a**9*b**5*c**4*s + 21*a**8*b**6*c**4*s -
        10*a**7*b**7*c**4*s - 25*a**6*b**8*c**4*s + 5*a**5*b**9*c**4*s
        + 12*a**4*b**10*c**4*s + 3*a**3*b**11*c**4*s -
        2*a**2*b**12*c**4*s - 2*a*b**13*c**4*s - 2*a**11*b**2*c**5*s +
        a**10*b**3*c**5*s + 16*a**9*b**4*c**5*s - 6*a**8*b**5*c**5*s -
        33*a**7*b**6*c**5*s + 5*a**6*b**7*c**5*s + 28*a**5*b**8*c**5*s
        + 5*a**4*b**9*c**5*s - 11*a**3*b**10*c**5*s -
        6*a**2*b**11*c**5*s + 2*a*b**12*c**5*s + b**13*c**5*s +
        7*a**10*b**2*c**6*s - 2*a**9*b**3*c**6*s - 27*a**8*b**4*c**6*s
        + 3*a**7*b**5*c**6*s + 38*a**6*b**6*c**6*s +
        5*a**5*b**7*c**6*s - 25*a**4*b**8*c**6*s - 10*a**3*b**9*c**6*s
        + 8*a**2*b**10*c**6*s + 4*a*b**11*c**6*s - b**12*c**6*s +
        a**11*c**7*s - 13*a**9*b**2*c**7*s + a**8*b**3*c**7*s +
        32*a**7*b**4*c**7*s + 3*a**6*b**5*c**7*s - 33*a**5*b**6*c**7*s
        - 10*a**4*b**7*c**7*s + 17*a**3*b**8*c**7*s +
        7*a**2*b**9*c**7*s - 4*a*b**10*c**7*s - b**11*c**7*s -
        3*a**10*c**8*s + 16*a**8*b**2*c**8*s + a**7*b**3*c**8*s -
        27*a**6*b**4*c**8*s - 6*a**5*b**5*c**8*s + 21*a**4*b**6*c**8*s
        + 7*a**3*b**7*c**8*s - 8*a**2*b**8*c**8*s - 2*a*b**9*c**8*s +
        b**10*c**8*s + 4*a**9*c**9*s - 13*a**7*b**2*c**9*s -
        2*a**6*b**3*c**9*s + 16*a**5*b**4*c**9*s + 4*a**4*b**5*c**9*s
        - 9*a**3*b**6*c**9*s - 2*a**2*b**7*c**9*s + 2*a*b**8*c**9*s -
        3*a**8*c**10*s + 7*a**6*b**2*c**10*s + a**5*b**3*c**10*s -
        6*a**4*b**4*c**10*s - a**3*b**5*c**10*s + 2*a**2*b**6*c**10*s
        + a**7*c**11*s - 2*a**5*b**2*c**11*s + a**3*b**4*c**11*s),
        (2*a**7*b**6*c**2 + 2*a**6*b**7*c**2 + 9*a**7*b**5*c**3 +
        15*a**6*b**6*c**3 + 9*a**5*b**7*c**3 + 13*a**7*b**4*c**4 +
        35*a**6*b**5*c**4 + 35*a**5*b**6*c**4 + 13*a**4*b**7*c**4 +
        9*a**7*b**3*c**5 + 35*a**6*b**4*c**5 + 54*a**5*b**5*c**5 +
        35*a**4*b**6*c**5 + 9*a**3*b**7*c**5 + 2*a**7*b**2*c**6 +
        15*a**6*b**3*c**6 + 35*a**5*b**4*c**6 + 35*a**4*b**5*c**6 +
        15*a**3*b**6*c**6 + 2*a**2*b**7*c**6 + 2*a**6*b**2*c**7 +
        9*a**5*b**3*c**7 + 13*a**4*b**4*c**7 + 9*a**3*b**5*c**7 +
        2*a**2*b**6*c**7 - 3*a**6*b**5*c**2*s**2 -
        3*a**5*b**6*c**2*s**2 - 17*a**6*b**4*c**3*s**2 -
        40*a**5*b**5*c**3*s**2 - 17*a**4*b**6*c**3*s**2 -
        17*a**6*b**3*c**4*s**2 - 82*a**5*b**4*c**4*s**2 -
        82*a**4*b**5*c**4*s**2 - 17*a**3*b**6*c**4*s**2 -
        3*a**6*b**2*c**5*s**2 - 40*a**5*b**3*c**5*s**2 -
        82*a**4*b**4*c**5*s**2 - 40*a**3*b**5*c**5*s**2 -
        3*a**2*b**6*c**5*s**2 - 3*a**5*b**2*c**6*s**2 -
        17*a**4*b**3*c**6*s**2 - 17*a**3*b**4*c**6*s**2 -
        3*a**2*b**5*c**6*s**2)/(a**8*b**6*s - 2*a**7*b**7*s +
        a**6*b**8*s + a**9*b**4*c*s - 3*a**8*b**5*c*s +
        2*a**7*b**6*c*s + 2*a**6*b**7*c*s - 3*a**5*b**8*c*s +
        a**4*b**9*c*s - a**9*b**3*c**2*s + 5*a**7*b**5*c**2*s -
        8*a**6*b**6*c**2*s + 5*a**5*b**7*c**2*s - a**3*b**9*c**2*s -
        a**9*b**2*c**3*s + 4*a**8*b**3*c**3*s - 5*a**7*b**4*c**3*s +
        2*a**6*b**5*c**3*s + 2*a**5*b**6*c**3*s - 5*a**4*b**7*c**3*s +
        4*a**3*b**8*c**3*s - a**2*b**9*c**3*s + a**9*b*c**4*s -
        5*a**7*b**3*c**4*s + 6*a**6*b**4*c**4*s - 4*a**5*b**5*c**4*s +
        6*a**4*b**6*c**4*s - 5*a**3*b**7*c**4*s + a*b**9*c**4*s -
        3*a**8*b*c**5*s + 5*a**7*b**2*c**5*s + 2*a**6*b**3*c**5*s -
        4*a**5*b**4*c**5*s - 4*a**4*b**5*c**5*s + 2*a**3*b**6*c**5*s +
        5*a**2*b**7*c**5*s - 3*a*b**8*c**5*s + a**8*c**6*s +
        2*a**7*b*c**6*s - 8*a**6*b**2*c**6*s + 2*a**5*b**3*c**6*s +
        6*a**4*b**4*c**6*s + 2*a**3*b**5*c**6*s - 8*a**2*b**6*c**6*s +
        2*a*b**7*c**6*s + b**8*c**6*s - 2*a**7*c**7*s +
        2*a**6*b*c**7*s + 5*a**5*b**2*c**7*s - 5*a**4*b**3*c**7*s -
        5*a**3*b**4*c**7*s + 5*a**2*b**5*c**7*s + 2*a*b**6*c**7*s -
        2*b**7*c**7*s + a**6*c**8*s - 3*a**5*b*c**8*s +
        4*a**3*b**3*c**8*s - 3*a*b**5*c**8*s + b**6*c**8*s +
        a**4*b*c**9*s - a**3*b**2*c**9*s - a**2*b**3*c**9*s +
        a*b**4*c**9*s), (2*a**7*b**11*c**2 + 2*a**6*b**12*c**2 +
        7*a**7*b**10*c**3 + 8*a**6*b**11*c**3 + 7*a**5*b**12*c**3 +
        7*a**7*b**9*c**4 + 18*a**6*b**10*c**4 + 15*a**5*b**11*c**4 +
        10*a**4*b**12*c**4 + 4*a**7*b**8*c**5 + 17*a**6*b**9*c**5 +
        22*a**5*b**10*c**5 + 17*a**4*b**11*c**5 + 7*a**3*b**12*c**5 +
        4*a**7*b**7*c**6 + 8*a**6*b**8*c**6 + 19*a**5*b**9*c**6 +
        15*a**4*b**10*c**6 + 10*a**3*b**11*c**6 + 2*a**2*b**12*c**6 +
        4*a**7*b**6*c**7 + 9*a**6*b**7*c**7 + 7*a**5*b**8*c**7 +
        10*a**4*b**9*c**7 + 3*a**3*b**10*c**7 + 2*a**2*b**11*c**7 +
        4*a**7*b**5*c**8 + 19*a**6*b**6*c**8 + 18*a**5*b**7*c**8 +
        5*a**4*b**8*c**8 + a**3*b**9*c**8 - a**2*b**10*c**8 +
        3*a**7*b**4*c**9 + 17*a**6*b**5*c**9 + 34*a**5*b**6*c**9 +
        17*a**4*b**7*c**9 + 4*a**3*b**8*c**9 + 5*a**6*b**4*c**10 +
        17*a**5*b**5*c**10 + 18*a**4*b**6*c**10 + 5*a**3*b**7*c**10 +
        a**2*b**8*c**10 + a**6*b**3*c**11 + 3*a**5*b**4*c**11 +
        4*a**4*b**5*c**11 + 3*a**3*b**6*c**11 - 3*a**6*b**10*c**2*s**2
        - 4*a**5*b**11*c**2*s**2 + a**4*b**12*c**2*s**2 -
        9*a**6*b**9*c**3*s**2 - 21*a**5*b**10*c**3*s**2 -
        9*a**4*b**11*c**3*s**2 + a**3*b**12*c**3*s**2 -
        9*a**6*b**8*c**4*s**2 - 32*a**5*b**9*c**4*s**2 -
        33*a**4*b**10*c**4*s**2 - 8*a**3*b**11*c**4*s**2 +
        a**6*b**7*c**5*s**2 - 19*a**5*b**8*c**5*s**2 -
        28*a**4*b**9*c**5*s**2 - 19*a**3*b**10*c**5*s**2 -
        2*a**2*b**11*c**5*s**2 + a**6*b**6*c**6*s**2 +
        a**5*b**7*c**6*s**2 - 8*a**4*b**8*c**6*s**2 -
        4*a**3*b**9*c**6*s**2 - 4*a**2*b**10*c**6*s**2 -
        12*a**6*b**5*c**7*s**2 - 21*a**5*b**6*c**7*s**2 -
        9*a**4*b**7*c**7*s**2 + 3*a**3*b**8*c**7*s**2 +
        3*a**2*b**9*c**7*s**2 - 9*a**6*b**4*c**8*s**2 -
        50*a**5*b**5*c**8*s**2 - 46*a**4*b**6*c**8*s**2 -
        12*a**3*b**7*c**8*s**2 + a**2*b**8*c**8*s**2 -
        22*a**5*b**4*c**9*s**2 - 53*a**4*b**5*c**9*s**2 -
        22*a**3*b**6*c**9*s**2 - 4*a**2*b**7*c**9*s**2 -
        13*a**4*b**4*c**10*s**2 -
        13*a**3*b**5*c**10*s**2)/(a**8*b**11*s - 2*a**7*b**12*s +
        2*a**6*b**13*s - 2*a**5*b**14*s + a**4*b**15*s + a**9*b**9*c*s
        - 3*a**8*b**10*c*s + 4*a**7*b**11*c*s - 4*a**6*b**12*c*s +
        3*a**5*b**13*c*s - a**4*b**14*c*s - a**9*b**8*c**2*s +
        a**8*b**9*c**2*s - a**6*b**11*c**2*s + 3*a**5*b**12*c**2*s -
        3*a**4*b**13*c**2*s + 2*a**3*b**14*c**2*s - a**2*b**15*c**2*s
        - a**9*b**7*c**3*s + 4*a**8*b**8*c**3*s - 7*a**7*b**9*c**3*s +
        10*a**6*b**10*c**3*s - 11*a**5*b**11*c**3*s +
        8*a**4*b**12*c**3*s - 5*a**3*b**13*c**3*s +
        2*a**2*b**14*c**3*s + 2*a**9*b**6*c**4*s - 5*a**8*b**7*c**4*s
        + 7*a**7*b**8*c**4*s - 10*a**6*b**9*c**4*s +
        9*a**5*b**10*c**4*s - 5*a**4*b**11*c**4*s +
        3*a**3*b**12*c**4*s - a*b**14*c**4*s - a**9*b**5*c**5*s +
        2*a**7*b**7*c**5*s - 2*a**6*b**8*c**5*s + 6*a**5*b**9*c**5*s -
        8*a**4*b**10*c**5*s + 6*a**3*b**11*c**5*s -
        6*a**2*b**12*c**5*s + 3*a*b**13*c**5*s - a**9*b**4*c**6*s +
        5*a**8*b**5*c**6*s - 8*a**7*b**6*c**6*s + 11*a**6*b**7*c**6*s
        - 16*a**5*b**8*c**6*s + 15*a**4*b**9*c**6*s -
        12*a**3*b**10*c**6*s + 9*a**2*b**11*c**6*s - 3*a*b**12*c**6*s
        + a**9*b**3*c**7*s - 3*a**8*b**4*c**7*s + 3*a**7*b**5*c**7*s -
        5*a**6*b**6*c**7*s + 8*a**5*b**7*c**7*s - 6*a**4*b**8*c**7*s +
        5*a**3*b**9*c**7*s - 3*a**2*b**10*c**7*s - a*b**11*c**7*s +
        b**12*c**7*s - a**8*b**3*c**8*s + 4*a**7*b**4*c**8*s -
        4*a**6*b**5*c**8*s + 4*a**5*b**6*c**8*s - 7*a**4*b**7*c**8*s +
        6*a**3*b**8*c**8*s - 6*a**2*b**9*c**8*s + 6*a*b**10*c**8*s -
        2*b**11*c**8*s + 2*a**8*b**2*c**9*s - 4*a**7*b**3*c**9*s +
        3*a**6*b**4*c**9*s - 6*a**5*b**5*c**9*s + 9*a**4*b**6*c**9*s -
        8*a**3*b**7*c**9*s + 9*a**2*b**8*c**9*s - 6*a*b**9*c**9*s +
        b**10*c**9*s - a**8*b*c**10*s + 2*a**6*b**3*c**10*s +
        a**5*b**4*c**10*s - 2*a**4*b**5*c**10*s + 2*a**3*b**6*c**10*s
        - 4*a**2*b**7*c**10*s + a*b**8*c**10*s + b**9*c**10*s +
        2*a**7*b*c**11*s - 3*a**6*b**2*c**11*s + a**5*b**3*c**11*s -
        2*a**4*b**4*c**11*s + 2*a**3*b**5*c**11*s - a**2*b**6*c**11*s
        + 3*a*b**7*c**11*s - 2*b**8*c**11*s - a**7*c**12*s +
        a**5*b**2*c**12*s + a**4*b**3*c**12*s - a**3*b**4*c**12*s +
        2*a**2*b**5*c**12*s - 3*a*b**6*c**12*s + b**7*c**12*s +
        a**6*c**13*s - a**5*b*c**13*s - a**2*b**4*c**13*s +
        a*b**5*c**13*s), (2*a**12*b**6*c**2 + 2*a**11*b**7*c**2 -
        a**10*b**8*c**2 + a**8*b**10*c**2 + 7*a**12*b**5*c**3 +
        10*a**11*b**6*c**3 + 3*a**10*b**7*c**3 + a**9*b**8*c**3 +
        4*a**8*b**9*c**3 + 5*a**7*b**10*c**3 + 3*a**6*b**11*c**3 +
        10*a**12*b**4*c**4 + 17*a**11*b**5*c**4 + 15*a**10*b**6*c**4 +
        10*a**9*b**7*c**4 + 5*a**8*b**8*c**4 + 17*a**7*b**9*c**4 +
        18*a**6*b**10*c**4 + 4*a**5*b**11*c**4 + 7*a**12*b**3*c**5 +
        15*a**11*b**4*c**5 + 22*a**10*b**5*c**5 + 19*a**9*b**6*c**5 +
        7*a**8*b**7*c**5 + 18*a**7*b**8*c**5 + 34*a**6*b**9*c**5 +
        17*a**5*b**10*c**5 + 3*a**4*b**11*c**5 + 2*a**12*b**2*c**6 +
        8*a**11*b**3*c**6 + 18*a**10*b**4*c**6 + 17*a**9*b**5*c**6 +
        8*a**8*b**6*c**6 + 9*a**7*b**7*c**6 + 19*a**6*b**8*c**6 +
        17*a**5*b**9*c**6 + 5*a**4*b**10*c**6 + a**3*b**11*c**6 +
        2*a**11*b**2*c**7 + 7*a**10*b**3*c**7 + 7*a**9*b**4*c**7 +
        4*a**8*b**5*c**7 + 4*a**7*b**6*c**7 + 4*a**6*b**7*c**7 +
        4*a**5*b**8*c**7 + 3*a**4*b**9*c**7 - 2*a**11*b**5*c**2*s**2 -
        4*a**10*b**6*c**2*s**2 + 3*a**9*b**7*c**2*s**2 +
        a**8*b**8*c**2*s**2 - 4*a**7*b**9*c**2*s**2 +
        a**12*b**3*c**3*s**2 - 8*a**11*b**4*c**3*s**2 -
        19*a**10*b**5*c**3*s**2 - 4*a**9*b**6*c**3*s**2 +
        3*a**8*b**7*c**3*s**2 - 12*a**7*b**8*c**3*s**2 -
        22*a**6*b**9*c**3*s**2 - 13*a**5*b**10*c**3*s**2 +
        a**12*b**2*c**4*s**2 - 9*a**11*b**3*c**4*s**2 -
        33*a**10*b**4*c**4*s**2 - 28*a**9*b**5*c**4*s**2 -
        8*a**8*b**6*c**4*s**2 - 9*a**7*b**7*c**4*s**2 -
        46*a**6*b**8*c**4*s**2 - 53*a**5*b**9*c**4*s**2 -
        13*a**4*b**10*c**4*s**2 - 4*a**11*b**2*c**5*s**2 -
        21*a**10*b**3*c**5*s**2 - 32*a**9*b**4*c**5*s**2 -
        19*a**8*b**5*c**5*s**2 + a**7*b**6*c**5*s**2 -
        21*a**6*b**7*c**5*s**2 - 50*a**5*b**8*c**5*s**2 -
        22*a**4*b**9*c**5*s**2 - 3*a**10*b**2*c**6*s**2 -
        9*a**9*b**3*c**6*s**2 - 9*a**8*b**4*c**6*s**2 +
        a**7*b**5*c**6*s**2 + a**6*b**6*c**6*s**2 -
        12*a**5*b**7*c**6*s**2 - 9*a**4*b**8*c**6*s**2)/(a**12*b**7*s
        - 2*a**11*b**8*s + a**10*b**9*s + a**9*b**10*s -
        2*a**8*b**11*s + a**7*b**12*s - a**14*b**4*c*s +
        3*a**13*b**5*c*s - 3*a**12*b**6*c*s - a**11*b**7*c*s +
        6*a**10*b**8*c*s - 6*a**9*b**9*c*s + a**8*b**10*c*s +
        3*a**7*b**11*c*s - 3*a**6*b**12*c*s + a**5*b**13*c*s -
        a**15*b**2*c**2*s + 2*a**14*b**3*c**2*s - 6*a**12*b**5*c**2*s
        + 9*a**11*b**6*c**2*s - 3*a**10*b**7*c**2*s -
        6*a**9*b**8*c**2*s + 9*a**8*b**9*c**2*s - 4*a**7*b**10*c**2*s
        - a**6*b**11*c**2*s + 2*a**5*b**12*c**2*s - a**4*b**13*c**2*s
        + 2*a**14*b**2*c**3*s - 5*a**13*b**3*c**3*s +
        3*a**12*b**4*c**3*s + 6*a**11*b**5*c**3*s -
        12*a**10*b**6*c**3*s + 5*a**9*b**7*c**3*s + 6*a**8*b**8*c**3*s
        - 8*a**7*b**9*c**3*s + 2*a**6*b**10*c**3*s +
        2*a**5*b**11*c**3*s - a**4*b**12*c**3*s + a**15*c**4*s -
        a**14*b*c**4*s - 3*a**13*b**2*c**4*s + 8*a**12*b**3*c**4*s -
        5*a**11*b**4*c**4*s - 8*a**10*b**5*c**4*s +
        15*a**9*b**6*c**4*s - 6*a**8*b**7*c**4*s - 7*a**7*b**8*c**4*s
        + 9*a**6*b**9*c**4*s - 2*a**5*b**10*c**4*s -
        2*a**4*b**11*c**4*s + a**3*b**12*c**4*s - 2*a**14*c**5*s +
        3*a**13*b*c**5*s + 3*a**12*b**2*c**5*s - 11*a**11*b**3*c**5*s
        + 9*a**10*b**4*c**5*s + 6*a**9*b**5*c**5*s -
        16*a**8*b**6*c**5*s + 8*a**7*b**7*c**5*s + 4*a**6*b**8*c**5*s
        - 6*a**5*b**9*c**5*s + a**4*b**10*c**5*s + a**3*b**11*c**5*s +
        a**2*b**12*c**5*s - a*b**13*c**5*s + 2*a**13*c**6*s -
        4*a**12*b*c**6*s - a**11*b**2*c**6*s + 10*a**10*b**3*c**6*s -
        10*a**9*b**4*c**6*s - 2*a**8*b**5*c**6*s + 11*a**7*b**6*c**6*s
        - 5*a**6*b**7*c**6*s - 4*a**5*b**8*c**6*s + 3*a**4*b**9*c**6*s
        + 2*a**3*b**10*c**6*s - 3*a**2*b**11*c**6*s + b**13*c**6*s -
        2*a**12*c**7*s + 4*a**11*b*c**7*s - 7*a**9*b**3*c**7*s +
        7*a**8*b**4*c**7*s + 2*a**7*b**5*c**7*s - 8*a**6*b**6*c**7*s +
        3*a**5*b**7*c**7*s + 4*a**4*b**8*c**7*s - 4*a**3*b**9*c**7*s +
        2*a*b**11*c**7*s - b**12*c**7*s + a**11*c**8*s -
        3*a**10*b*c**8*s + a**9*b**2*c**8*s + 4*a**8*b**3*c**8*s -
        5*a**7*b**4*c**8*s + 5*a**5*b**6*c**8*s - 3*a**4*b**7*c**8*s -
        a**3*b**8*c**8*s + 2*a**2*b**9*c**8*s - a*b**10*c**8*s +
        a**9*b*c**9*s - a**8*b**2*c**9*s - a**7*b**3*c**9*s +
        2*a**6*b**4*c**9*s - a**5*b**5*c**9*s - a**4*b**6*c**9*s +
        a**3*b**7*c**9*s), (a**11*b**6*c**3 + 3*a**11*b**5*c**4 +
        5*a**10*b**6*c**4 + 3*a**9*b**7*c**4 + 4*a**11*b**4*c**5 +
        17*a**10*b**5*c**5 + 17*a**9*b**6*c**5 + 4*a**8*b**7*c**5 +
        3*a**11*b**3*c**6 + 18*a**10*b**4*c**6 + 34*a**9*b**5*c**6 +
        19*a**8*b**6*c**6 + 4*a**7*b**7*c**6 + 5*a**10*b**3*c**7 +
        17*a**9*b**4*c**7 + 18*a**8*b**5*c**7 + 9*a**7*b**6*c**7 +
        4*a**6*b**7*c**7 + a**10*b**2*c**8 + 4*a**9*b**3*c**8 +
        5*a**8*b**4*c**8 + 7*a**7*b**5*c**8 + 8*a**6*b**6*c**8 +
        4*a**5*b**7*c**8 + a**8*b**3*c**9 + 10*a**7*b**4*c**9 +
        19*a**6*b**5*c**9 + 17*a**5*b**6*c**9 + 7*a**4*b**7*c**9 -
        a**8*b**2*c**10 + 3*a**7*b**3*c**10 + 15*a**6*b**4*c**10 +
        22*a**5*b**5*c**10 + 18*a**4*b**6*c**10 + 7*a**3*b**7*c**10 +
        2*a**7*b**2*c**11 + 10*a**6*b**3*c**11 + 17*a**5*b**4*c**11 +
        15*a**4*b**5*c**11 + 8*a**3*b**6*c**11 + 2*a**2*b**7*c**11 +
        2*a**6*b**2*c**12 + 7*a**5*b**3*c**12 + 10*a**4*b**4*c**12 +
        7*a**3*b**5*c**12 + 2*a**2*b**6*c**12 -
        13*a**10*b**4*c**4*s**2 - 22*a**9*b**5*c**4*s**2 -
        9*a**8*b**6*c**4*s**2 - 13*a**10*b**3*c**5*s**2 -
        53*a**9*b**4*c**5*s**2 - 50*a**8*b**5*c**5*s**2 -
        12*a**7*b**6*c**5*s**2 - 22*a**9*b**3*c**6*s**2 -
        46*a**8*b**4*c**6*s**2 - 21*a**7*b**5*c**6*s**2 +
        a**6*b**6*c**6*s**2 - 4*a**9*b**2*c**7*s**2 -
        12*a**8*b**3*c**7*s**2 - 9*a**7*b**4*c**7*s**2 +
        a**6*b**5*c**7*s**2 + a**5*b**6*c**7*s**2 +
        a**8*b**2*c**8*s**2 + 3*a**7*b**3*c**8*s**2 -
        8*a**6*b**4*c**8*s**2 - 19*a**5*b**5*c**8*s**2 -
        9*a**4*b**6*c**8*s**2 + 3*a**7*b**2*c**9*s**2 -
        4*a**6*b**3*c**9*s**2 - 28*a**5*b**4*c**9*s**2 -
        32*a**4*b**5*c**9*s**2 - 9*a**3*b**6*c**9*s**2 -
        4*a**6*b**2*c**10*s**2 - 19*a**5*b**3*c**10*s**2 -
        33*a**4*b**4*c**10*s**2 - 21*a**3*b**5*c**10*s**2 -
        3*a**2*b**6*c**10*s**2 - 2*a**5*b**2*c**11*s**2 -
        8*a**4*b**3*c**11*s**2 - 9*a**3*b**4*c**11*s**2 -
        4*a**2*b**5*c**11*s**2 + a**3*b**3*c**12*s**2 +
        a**2*b**4*c**12*s**2)/(a**13*b**6*s - a**12*b**7*s -
        a**13*b**5*c*s + 2*a**11*b**7*c*s - a**10*b**8*c*s +
        a**12*b**5*c**2*s - 3*a**11*b**6*c**2*s + 2*a**9*b**8*c**2*s +
        a**12*b**4*c**3*s + a**11*b**5*c**3*s + 2*a**10*b**6*c**3*s -
        4*a**9*b**7*c**3*s - a**8*b**8*c**3*s + a**7*b**9*c**3*s -
        a**13*b**2*c**4*s - a**12*b**3*c**4*s - 2*a**11*b**4*c**4*s +
        a**10*b**5*c**4*s + 3*a**9*b**6*c**4*s + 4*a**8*b**7*c**4*s -
        3*a**7*b**8*c**4*s - a**6*b**9*c**4*s + a**13*b*c**5*s +
        2*a**12*b**2*c**5*s + 2*a**11*b**3*c**5*s -
        2*a**10*b**4*c**5*s - 6*a**9*b**5*c**5*s - 4*a**8*b**6*c**5*s
        + 3*a**7*b**7*c**5*s + 5*a**6*b**8*c**5*s - a**5*b**9*c**5*s -
        3*a**12*b*c**6*s - a**11*b**2*c**6*s + 2*a**10*b**3*c**6*s +
        9*a**9*b**4*c**6*s + 4*a**8*b**5*c**6*s - 5*a**7*b**6*c**6*s -
        8*a**6*b**7*c**6*s + 2*a**4*b**9*c**6*s + a**12*c**7*s +
        3*a**11*b*c**7*s - 4*a**10*b**2*c**7*s - 8*a**9*b**3*c**7*s -
        7*a**8*b**4*c**7*s + 8*a**7*b**5*c**7*s + 11*a**6*b**6*c**7*s
        + 2*a**5*b**7*c**7*s - 5*a**4*b**8*c**7*s - a**3*b**9*c**7*s -
        2*a**11*c**8*s + a**10*b*c**8*s + 9*a**9*b**2*c**8*s +
        6*a**8*b**3*c**8*s - 6*a**7*b**4*c**8*s - 16*a**6*b**5*c**8*s
        - 2*a**5*b**6*c**8*s + 7*a**4*b**7*c**8*s + 4*a**3*b**8*c**8*s
        - a**2*b**9*c**8*s + a**10*c**9*s - 6*a**9*b*c**9*s -
        6*a**8*b**2*c**9*s + 5*a**7*b**3*c**9*s + 15*a**6*b**4*c**9*s
        + 6*a**5*b**5*c**9*s - 10*a**4*b**6*c**9*s -
        7*a**3*b**7*c**9*s + a**2*b**8*c**9*s + a*b**9*c**9*s +
        a**9*c**10*s + 6*a**8*b*c**10*s - 3*a**7*b**2*c**10*s -
        12*a**6*b**3*c**10*s - 8*a**5*b**4*c**10*s +
        9*a**4*b**5*c**10*s + 10*a**3*b**6*c**10*s - 3*a*b**8*c**10*s
        - 2*a**8*c**11*s - a**7*b*c**11*s + 9*a**6*b**2*c**11*s +
        6*a**5*b**3*c**11*s - 5*a**4*b**4*c**11*s -
        11*a**3*b**5*c**11*s - a**2*b**6*c**11*s + 4*a*b**7*c**11*s +
        b**8*c**11*s + a**7*c**12*s - 3*a**6*b*c**12*s -
        6*a**5*b**2*c**12*s + 3*a**4*b**3*c**12*s +
        8*a**3*b**4*c**12*s + 3*a**2*b**5*c**12*s - 4*a*b**6*c**12*s -
        2*b**7*c**12*s + 3*a**5*b*c**13*s - 5*a**3*b**3*c**13*s -
        3*a**2*b**4*c**13*s + 3*a*b**5*c**13*s + 2*b**6*c**13*s -
        a**4*b*c**14*s + 2*a**3*b**2*c**14*s + 2*a**2*b**3*c**14*s -
        a*b**4*c**14*s - 2*b**5*c**14*s - a**2*b**2*c**15*s +
        b**4*c**15*s), (-a**6*b**11*c**3 - 3*a**7*b**9*c**4 -
        5*a**6*b**10*c**4 - 3*a**5*b**11*c**4 - 4*a**7*b**8*c**5 -
        17*a**6*b**9*c**5 - 17*a**5*b**10*c**5 - 4*a**4*b**11*c**5 -
        4*a**7*b**7*c**6 - 19*a**6*b**8*c**6 - 34*a**5*b**9*c**6 -
        18*a**4*b**10*c**6 - 3*a**3*b**11*c**6 - 4*a**7*b**6*c**7 -
        9*a**6*b**7*c**7 - 18*a**5*b**8*c**7 - 17*a**4*b**9*c**7 -
        5*a**3*b**10*c**7 - 4*a**7*b**5*c**8 - 8*a**6*b**6*c**8 -
        7*a**5*b**7*c**8 - 5*a**4*b**8*c**8 - 4*a**3*b**9*c**8 -
        a**2*b**10*c**8 - 7*a**7*b**4*c**9 - 17*a**6*b**5*c**9 -
        19*a**5*b**6*c**9 - 10*a**4*b**7*c**9 - a**3*b**8*c**9 -
        7*a**7*b**3*c**10 - 18*a**6*b**4*c**10 - 22*a**5*b**5*c**10 -
        15*a**4*b**6*c**10 - 3*a**3*b**7*c**10 + a**2*b**8*c**10 -
        2*a**7*b**2*c**11 - 8*a**6*b**3*c**11 - 15*a**5*b**4*c**11 -
        17*a**4*b**5*c**11 - 10*a**3*b**6*c**11 - 2*a**2*b**7*c**11 -
        2*a**6*b**2*c**12 - 7*a**5*b**3*c**12 - 10*a**4*b**4*c**12 -
        7*a**3*b**5*c**12 - 2*a**2*b**6*c**12 + 9*a**6*b**8*c**4*s**2
        + 22*a**5*b**9*c**4*s**2 + 13*a**4*b**10*c**4*s**2 +
        12*a**6*b**7*c**5*s**2 + 50*a**5*b**8*c**5*s**2 +
        53*a**4*b**9*c**5*s**2 + 13*a**3*b**10*c**5*s**2 -
        a**6*b**6*c**6*s**2 + 21*a**5*b**7*c**6*s**2 +
        46*a**4*b**8*c**6*s**2 + 22*a**3*b**9*c**6*s**2 -
        a**6*b**5*c**7*s**2 - a**5*b**6*c**7*s**2 +
        9*a**4*b**7*c**7*s**2 + 12*a**3*b**8*c**7*s**2 +
        4*a**2*b**9*c**7*s**2 + 9*a**6*b**4*c**8*s**2 +
        19*a**5*b**5*c**8*s**2 + 8*a**4*b**6*c**8*s**2 -
        3*a**3*b**7*c**8*s**2 - a**2*b**8*c**8*s**2 +
        9*a**6*b**3*c**9*s**2 + 32*a**5*b**4*c**9*s**2 +
        28*a**4*b**5*c**9*s**2 + 4*a**3*b**6*c**9*s**2 -
        3*a**2*b**7*c**9*s**2 + 3*a**6*b**2*c**10*s**2 +
        21*a**5*b**3*c**10*s**2 + 33*a**4*b**4*c**10*s**2 +
        19*a**3*b**5*c**10*s**2 + 4*a**2*b**6*c**10*s**2 +
        4*a**5*b**2*c**11*s**2 + 9*a**4*b**3*c**11*s**2 +
        8*a**3*b**4*c**11*s**2 + 2*a**2*b**5*c**11*s**2 -
        a**4*b**2*c**12*s**2 - a**3*b**3*c**12*s**2)/(a**7*b**12*s -
        a**6*b**13*s + a**8*b**10*c*s - 2*a**7*b**11*c*s +
        a**5*b**13*c*s - 2*a**8*b**9*c**2*s + 3*a**6*b**11*c**2*s -
        a**5*b**12*c**2*s - a**9*b**7*c**3*s + a**8*b**8*c**3*s +
        4*a**7*b**9*c**3*s - 2*a**6*b**10*c**3*s - a**5*b**11*c**3*s -
        a**4*b**12*c**3*s + a**9*b**6*c**4*s + 3*a**8*b**7*c**4*s -
        4*a**7*b**8*c**4*s - 3*a**6*b**9*c**4*s - a**5*b**10*c**4*s +
        2*a**4*b**11*c**4*s + a**3*b**12*c**4*s + a**2*b**13*c**4*s +
        a**9*b**5*c**5*s - 5*a**8*b**6*c**5*s - 3*a**7*b**7*c**5*s +
        4*a**6*b**8*c**5*s + 6*a**5*b**9*c**5*s + 2*a**4*b**10*c**5*s
        - 2*a**3*b**11*c**5*s - 2*a**2*b**12*c**5*s - a*b**13*c**5*s -
        2*a**9*b**4*c**6*s + 8*a**7*b**6*c**6*s + 5*a**6*b**7*c**6*s -
        4*a**5*b**8*c**6*s - 9*a**4*b**9*c**6*s - 2*a**3*b**10*c**6*s
        + a**2*b**11*c**6*s + 3*a*b**12*c**6*s + a**9*b**3*c**7*s +
        5*a**8*b**4*c**7*s - 2*a**7*b**5*c**7*s - 11*a**6*b**6*c**7*s
        - 8*a**5*b**7*c**7*s + 7*a**4*b**8*c**7*s + 8*a**3*b**9*c**7*s
        + 4*a**2*b**10*c**7*s - 3*a*b**11*c**7*s - b**12*c**7*s +
        a**9*b**2*c**8*s - 4*a**8*b**3*c**8*s - 7*a**7*b**4*c**8*s +
        2*a**6*b**5*c**8*s + 16*a**5*b**6*c**8*s + 6*a**4*b**7*c**8*s
        - 6*a**3*b**8*c**8*s - 9*a**2*b**9*c**8*s - a*b**10*c**8*s +
        2*b**11*c**8*s - a**9*b*c**9*s - a**8*b**2*c**9*s +
        7*a**7*b**3*c**9*s + 10*a**6*b**4*c**9*s - 6*a**5*b**5*c**9*s
        - 15*a**4*b**6*c**9*s - 5*a**3*b**7*c**9*s +
        6*a**2*b**8*c**9*s + 6*a*b**9*c**9*s - b**10*c**9*s +
        3*a**8*b*c**10*s - 10*a**6*b**3*c**10*s - 9*a**5*b**4*c**10*s
        + 8*a**4*b**5*c**10*s + 12*a**3*b**6*c**10*s +
        3*a**2*b**7*c**10*s - 6*a*b**8*c**10*s - b**9*c**10*s -
        a**8*c**11*s - 4*a**7*b*c**11*s + a**6*b**2*c**11*s +
        11*a**5*b**3*c**11*s + 5*a**4*b**4*c**11*s -
        6*a**3*b**5*c**11*s - 9*a**2*b**6*c**11*s + a*b**7*c**11*s +
        2*b**8*c**11*s + 2*a**7*c**12*s + 4*a**6*b*c**12*s -
        3*a**5*b**2*c**12*s - 8*a**4*b**3*c**12*s -
        3*a**3*b**4*c**12*s + 6*a**2*b**5*c**12*s + 3*a*b**6*c**12*s -
        b**7*c**12*s - 2*a**6*c**13*s - 3*a**5*b*c**13*s +
        3*a**4*b**2*c**13*s + 5*a**3*b**3*c**13*s - 3*a*b**5*c**13*s +
        2*a**5*c**14*s + a**4*b*c**14*s - 2*a**3*b**2*c**14*s -
        2*a**2*b**3*c**14*s + a*b**4*c**14*s - a**4*c**15*s +
        a**2*b**2*c**15*s), (2*a**12*b**6*c**2 + 2*a**11*b**7*c**2 +
        7*a**12*b**5*c**3 + 8*a**11*b**6*c**3 + 7*a**10*b**7*c**3 +
        10*a**12*b**4*c**4 + 15*a**11*b**5*c**4 + 18*a**10*b**6*c**4 +
        7*a**9*b**7*c**4 + 7*a**12*b**3*c**5 + 17*a**11*b**4*c**5 +
        22*a**10*b**5*c**5 + 17*a**9*b**6*c**5 + 4*a**8*b**7*c**5 +
        2*a**12*b**2*c**6 + 10*a**11*b**3*c**6 + 15*a**10*b**4*c**6 +
        19*a**9*b**5*c**6 + 8*a**8*b**6*c**6 + 4*a**7*b**7*c**6 +
        2*a**11*b**2*c**7 + 3*a**10*b**3*c**7 + 10*a**9*b**4*c**7 +
        7*a**8*b**5*c**7 + 9*a**7*b**6*c**7 + 4*a**6*b**7*c**7 -
        a**10*b**2*c**8 + a**9*b**3*c**8 + 5*a**8*b**4*c**8 +
        18*a**7*b**5*c**8 + 19*a**6*b**6*c**8 + 4*a**5*b**7*c**8 +
        4*a**8*b**3*c**9 + 17*a**7*b**4*c**9 + 34*a**6*b**5*c**9 +
        17*a**5*b**6*c**9 + 3*a**4*b**7*c**9 + a**8*b**2*c**10 +
        5*a**7*b**3*c**10 + 18*a**6*b**4*c**10 + 17*a**5*b**5*c**10 +
        5*a**4*b**6*c**10 + 3*a**6*b**3*c**11 + 4*a**5*b**4*c**11 +
        3*a**4*b**5*c**11 + a**3*b**6*c**11 + a**12*b**4*c**2*s**2 -
        4*a**11*b**5*c**2*s**2 - 3*a**10*b**6*c**2*s**2 +
        a**12*b**3*c**3*s**2 - 9*a**11*b**4*c**3*s**2 -
        21*a**10*b**5*c**3*s**2 - 9*a**9*b**6*c**3*s**2 -
        8*a**11*b**3*c**4*s**2 - 33*a**10*b**4*c**4*s**2 -
        32*a**9*b**5*c**4*s**2 - 9*a**8*b**6*c**4*s**2 -
        2*a**11*b**2*c**5*s**2 - 19*a**10*b**3*c**5*s**2 -
        28*a**9*b**4*c**5*s**2 - 19*a**8*b**5*c**5*s**2 +
        a**7*b**6*c**5*s**2 - 4*a**10*b**2*c**6*s**2 -
        4*a**9*b**3*c**6*s**2 - 8*a**8*b**4*c**6*s**2 +
        a**7*b**5*c**6*s**2 + a**6*b**6*c**6*s**2 +
        3*a**9*b**2*c**7*s**2 + 3*a**8*b**3*c**7*s**2 -
        9*a**7*b**4*c**7*s**2 - 21*a**6*b**5*c**7*s**2 -
        12*a**5*b**6*c**7*s**2 + a**8*b**2*c**8*s**2 -
        12*a**7*b**3*c**8*s**2 - 46*a**6*b**4*c**8*s**2 -
        50*a**5*b**5*c**8*s**2 - 9*a**4*b**6*c**8*s**2 -
        4*a**7*b**2*c**9*s**2 - 22*a**6*b**3*c**9*s**2 -
        53*a**5*b**4*c**9*s**2 - 22*a**4*b**5*c**9*s**2 -
        13*a**5*b**3*c**10*s**2 -
        13*a**4*b**4*c**10*s**2)/(a**15*b**4*s - 2*a**14*b**5*s +
        2*a**13*b**6*s - 2*a**12*b**7*s + a**11*b**8*s -
        a**14*b**4*c*s + 3*a**13*b**5*c*s - 4*a**12*b**6*c*s +
        4*a**11*b**7*c*s - 3*a**10*b**8*c*s + a**9*b**9*c*s -
        a**15*b**2*c**2*s + 2*a**14*b**3*c**2*s - 3*a**13*b**4*c**2*s
        + 3*a**12*b**5*c**2*s - a**11*b**6*c**2*s + a**9*b**8*c**2*s -
        a**8*b**9*c**2*s + 2*a**14*b**2*c**3*s - 5*a**13*b**3*c**3*s +
        8*a**12*b**4*c**3*s - 11*a**11*b**5*c**3*s +
        10*a**10*b**6*c**3*s - 7*a**9*b**7*c**3*s + 4*a**8*b**8*c**3*s
        - a**7*b**9*c**3*s - a**14*b*c**4*s + 3*a**12*b**3*c**4*s -
        5*a**11*b**4*c**4*s + 9*a**10*b**5*c**4*s -
        10*a**9*b**6*c**4*s + 7*a**8*b**7*c**4*s - 5*a**7*b**8*c**4*s
        + 2*a**6*b**9*c**4*s + 3*a**13*b*c**5*s - 6*a**12*b**2*c**5*s
        + 6*a**11*b**3*c**5*s - 8*a**10*b**4*c**5*s +
        6*a**9*b**5*c**5*s - 2*a**8*b**6*c**5*s + 2*a**7*b**7*c**5*s -
        a**5*b**9*c**5*s - 3*a**12*b*c**6*s + 9*a**11*b**2*c**6*s -
        12*a**10*b**3*c**6*s + 15*a**9*b**4*c**6*s -
        16*a**8*b**5*c**6*s + 11*a**7*b**6*c**6*s - 8*a**6*b**7*c**6*s
        + 5*a**5*b**8*c**6*s - a**4*b**9*c**6*s + a**12*c**7*s -
        a**11*b*c**7*s - 3*a**10*b**2*c**7*s + 5*a**9*b**3*c**7*s -
        6*a**8*b**4*c**7*s + 8*a**7*b**5*c**7*s - 5*a**6*b**6*c**7*s +
        3*a**5*b**7*c**7*s - 3*a**4*b**8*c**7*s + a**3*b**9*c**7*s -
        2*a**11*c**8*s + 6*a**10*b*c**8*s - 6*a**9*b**2*c**8*s +
        6*a**8*b**3*c**8*s - 7*a**7*b**4*c**8*s + 4*a**6*b**5*c**8*s -
        4*a**5*b**6*c**8*s + 4*a**4*b**7*c**8*s - a**3*b**8*c**8*s +
        a**10*c**9*s - 6*a**9*b*c**9*s + 9*a**8*b**2*c**9*s -
        8*a**7*b**3*c**9*s + 9*a**6*b**4*c**9*s - 6*a**5*b**5*c**9*s +
        3*a**4*b**6*c**9*s - 4*a**3*b**7*c**9*s + 2*a**2*b**8*c**9*s +
        a**9*c**10*s + a**8*b*c**10*s - 4*a**7*b**2*c**10*s +
        2*a**6*b**3*c**10*s - 2*a**5*b**4*c**10*s + a**4*b**5*c**10*s
        + 2*a**3*b**6*c**10*s - a*b**8*c**10*s - 2*a**8*c**11*s +
        3*a**7*b*c**11*s - a**6*b**2*c**11*s + 2*a**5*b**3*c**11*s -
        2*a**4*b**4*c**11*s + a**3*b**5*c**11*s - 3*a**2*b**6*c**11*s
        + 2*a*b**7*c**11*s + a**7*c**12*s - 3*a**6*b*c**12*s +
        2*a**5*b**2*c**12*s - a**4*b**3*c**12*s + a**3*b**4*c**12*s +
        a**2*b**5*c**12*s - b**7*c**12*s + a**5*b*c**13*s -
        a**4*b**2*c**13*s - a*b**5*c**13*s + b**6*c**13*s),
        (a**10*b**8*c**2 - a**8*b**10*c**2 + 2*a**7*b**11*c**2 +
        2*a**6*b**12*c**2 + 3*a**11*b**6*c**3 + 5*a**10*b**7*c**3 +
        4*a**9*b**8*c**3 + a**8*b**9*c**3 + 3*a**7*b**10*c**3 +
        10*a**6*b**11*c**3 + 7*a**5*b**12*c**3 + 4*a**11*b**5*c**4 +
        18*a**10*b**6*c**4 + 17*a**9*b**7*c**4 + 5*a**8*b**8*c**4 +
        10*a**7*b**9*c**4 + 15*a**6*b**10*c**4 + 17*a**5*b**11*c**4 +
        10*a**4*b**12*c**4 + 3*a**11*b**4*c**5 + 17*a**10*b**5*c**5 +
        34*a**9*b**6*c**5 + 18*a**8*b**7*c**5 + 7*a**7*b**8*c**5 +
        19*a**6*b**9*c**5 + 22*a**5*b**10*c**5 + 15*a**4*b**11*c**5 +
        7*a**3*b**12*c**5 + a**11*b**3*c**6 + 5*a**10*b**4*c**6 +
        17*a**9*b**5*c**6 + 19*a**8*b**6*c**6 + 9*a**7*b**7*c**6 +
        8*a**6*b**8*c**6 + 17*a**5*b**9*c**6 + 18*a**4*b**10*c**6 +
        8*a**3*b**11*c**6 + 2*a**2*b**12*c**6 + 3*a**9*b**4*c**7 +
        4*a**8*b**5*c**7 + 4*a**7*b**6*c**7 + 4*a**6*b**7*c**7 +
        4*a**5*b**8*c**7 + 7*a**4*b**9*c**7 + 7*a**3*b**10*c**7 +
        2*a**2*b**11*c**7 - 4*a**9*b**7*c**2*s**2 +
        a**8*b**8*c**2*s**2 + 3*a**7*b**9*c**2*s**2 -
        4*a**6*b**10*c**2*s**2 - 2*a**5*b**11*c**2*s**2 -
        13*a**10*b**5*c**3*s**2 - 22*a**9*b**6*c**3*s**2 -
        12*a**8*b**7*c**3*s**2 + 3*a**7*b**8*c**3*s**2 -
        4*a**6*b**9*c**3*s**2 - 19*a**5*b**10*c**3*s**2 -
        8*a**4*b**11*c**3*s**2 + a**3*b**12*c**3*s**2 -
        13*a**10*b**4*c**4*s**2 - 53*a**9*b**5*c**4*s**2 -
        46*a**8*b**6*c**4*s**2 - 9*a**7*b**7*c**4*s**2 -
        8*a**6*b**8*c**4*s**2 - 28*a**5*b**9*c**4*s**2 -
        33*a**4*b**10*c**4*s**2 - 9*a**3*b**11*c**4*s**2 +
        a**2*b**12*c**4*s**2 - 22*a**9*b**4*c**5*s**2 -
        50*a**8*b**5*c**5*s**2 - 21*a**7*b**6*c**5*s**2 +
        a**6*b**7*c**5*s**2 - 19*a**5*b**8*c**5*s**2 -
        32*a**4*b**9*c**5*s**2 - 21*a**3*b**10*c**5*s**2 -
        4*a**2*b**11*c**5*s**2 - 9*a**8*b**4*c**6*s**2 -
        12*a**7*b**5*c**6*s**2 + a**6*b**6*c**6*s**2 +
        a**5*b**7*c**6*s**2 - 9*a**4*b**8*c**6*s**2 -
        9*a**3*b**9*c**6*s**2 - 3*a**2*b**10*c**6*s**2)/(a**12*b**7*s
        - 2*a**11*b**8*s + a**10*b**9*s + a**9*b**10*s -
        2*a**8*b**11*s + a**7*b**12*s + a**13*b**5*c*s -
        3*a**12*b**6*c*s + 3*a**11*b**7*c*s + a**10*b**8*c*s -
        6*a**9*b**9*c*s + 6*a**8*b**10*c*s - a**7*b**11*c*s -
        3*a**6*b**12*c*s + 3*a**5*b**13*c*s - a**4*b**14*c*s -
        a**13*b**4*c**2*s + 2*a**12*b**5*c**2*s - a**11*b**6*c**2*s -
        4*a**10*b**7*c**2*s + 9*a**9*b**8*c**2*s - 6*a**8*b**9*c**2*s
        - 3*a**7*b**10*c**2*s + 9*a**6*b**11*c**2*s -
        6*a**5*b**12*c**2*s + 2*a**3*b**14*c**2*s - a**2*b**15*c**2*s
        - a**12*b**4*c**3*s + 2*a**11*b**5*c**3*s +
        2*a**10*b**6*c**3*s - 8*a**9*b**7*c**3*s + 6*a**8*b**8*c**3*s
        + 5*a**7*b**9*c**3*s - 12*a**6*b**10*c**3*s +
        6*a**5*b**11*c**3*s + 3*a**4*b**12*c**3*s -
        5*a**3*b**13*c**3*s + 2*a**2*b**14*c**3*s + a**12*b**3*c**4*s
        - 2*a**11*b**4*c**4*s - 2*a**10*b**5*c**4*s +
        9*a**9*b**6*c**4*s - 7*a**8*b**7*c**4*s - 6*a**7*b**8*c**4*s +
        15*a**6*b**9*c**4*s - 8*a**5*b**10*c**4*s -
        5*a**4*b**11*c**4*s + 8*a**3*b**12*c**4*s -
        3*a**2*b**13*c**4*s - a*b**14*c**4*s + b**15*c**4*s -
        a**13*b*c**5*s + a**12*b**2*c**5*s + a**11*b**3*c**5*s +
        a**10*b**4*c**5*s - 6*a**9*b**5*c**5*s + 4*a**8*b**6*c**5*s +
        8*a**7*b**7*c**5*s - 16*a**6*b**8*c**5*s + 6*a**5*b**9*c**5*s
        + 9*a**4*b**10*c**5*s - 11*a**3*b**11*c**5*s +
        3*a**2*b**12*c**5*s + 3*a*b**13*c**5*s - 2*b**14*c**5*s +
        a**13*c**6*s - 3*a**11*b**2*c**6*s + 2*a**10*b**3*c**6*s +
        3*a**9*b**4*c**6*s - 4*a**8*b**5*c**6*s - 5*a**7*b**6*c**6*s +
        11*a**6*b**7*c**6*s - 2*a**5*b**8*c**6*s - 10*a**4*b**9*c**6*s
        + 10*a**3*b**10*c**6*s - a**2*b**11*c**6*s - 4*a*b**12*c**6*s
        + 2*b**13*c**6*s - a**12*c**7*s + 2*a**11*b*c**7*s -
        4*a**9*b**3*c**7*s + 4*a**8*b**4*c**7*s + 3*a**7*b**5*c**7*s -
        8*a**6*b**6*c**7*s + 2*a**5*b**7*c**7*s + 7*a**4*b**8*c**7*s -
        7*a**3*b**9*c**7*s + 4*a*b**11*c**7*s - 2*b**12*c**7*s -
        a**10*b*c**8*s + 2*a**9*b**2*c**8*s - a**8*b**3*c**8*s -
        3*a**7*b**4*c**8*s + 5*a**6*b**5*c**8*s - 5*a**4*b**7*c**8*s +
        4*a**3*b**8*c**8*s + a**2*b**9*c**8*s - 3*a*b**10*c**8*s +
        b**11*c**8*s + a**7*b**3*c**9*s - a**6*b**4*c**9*s -
        a**5*b**5*c**9*s + 2*a**4*b**6*c**9*s - a**3*b**7*c**9*s -
        a**2*b**8*c**9*s + a*b**9*c**9*s), (-4*a**7*b**7*c**3 -
        5*a**6*b**8*c**3 - 2*a**5*b**9*c**3 - 8*a**7*b**6*c**4 -
        21*a**6*b**7*c**4 - 17*a**5*b**8*c**4 - 4*a**4*b**9*c**4 -
        8*a**7*b**5*c**5 - 27*a**6*b**6*c**5 - 40*a**5*b**7*c**5 -
        19*a**4*b**8*c**5 - 3*a**3*b**9*c**5 - 7*a**7*b**4*c**6 -
        21*a**6*b**5*c**6 - 34*a**5*b**6*c**6 - 27*a**4*b**7*c**6 -
        7*a**3*b**8*c**6 - 6*a**7*b**3*c**7 - 18*a**6*b**4*c**7 -
        24*a**5*b**5*c**7 - 20*a**4*b**6*c**7 - 9*a**3*b**7*c**7 -
        a**2*b**8*c**7 - 2*a**7*b**2*c**8 - 10*a**6*b**3*c**8 -
        18*a**5*b**4*c**8 - 17*a**4*b**5*c**8 - 9*a**3*b**6*c**8 -
        2*a**2*b**7*c**8 - 2*a**6*b**2*c**9 - 7*a**5*b**3*c**9 -
        9*a**4*b**4*c**9 - 5*a**3*b**5*c**9 - a**2*b**6*c**9 +
        8*a**6*b**6*c**3*s**2 + 19*a**5*b**7*c**3*s**2 +
        9*a**4*b**8*c**3*s**2 + 15*a**6*b**5*c**4*s**2 +
        52*a**5*b**6*c**4*s**2 + 46*a**4*b**7*c**4*s**2 +
        9*a**3*b**8*c**4*s**2 + 10*a**6*b**4*c**5*s**2 +
        47*a**5*b**5*c**5*s**2 + 61*a**4*b**6*c**5*s**2 +
        21*a**3*b**7*c**5*s**2 + 5*a**6*b**3*c**6*s**2 +
        30*a**5*b**4*c**6*s**2 + 46*a**4*b**5*c**6*s**2 +
        24*a**3*b**6*c**6*s**2 + 3*a**2*b**7*c**6*s**2 +
        2*a**6*b**2*c**7*s**2 + 17*a**5*b**3*c**7*s**2 +
        29*a**4*b**4*c**7*s**2 + 16*a**3*b**5*c**7*s**2 +
        3*a**2*b**6*c**7*s**2 + 3*a**5*b**2*c**8*s**2 +
        7*a**4*b**3*c**8*s**2 + 4*a**3*b**4*c**8*s**2)/(a**9*b**7*s -
        a**8*b**8*s - a**7*b**9*s + a**6*b**10*s - a**9*b**6*c*s +
        a**8*b**7*c*s + 2*a**7*b**8*c*s - 2*a**6*b**9*c*s -
        a**5*b**10*c*s + a**4*b**11*c*s - a**9*b**5*c**2*s +
        2*a**6*b**8*c**2*s + a**5*b**9*c**2*s - 2*a**4*b**10*c**2*s +
        2*a**9*b**4*c**3*s - 4*a**7*b**6*c**3*s - a**6*b**7*c**3*s +
        2*a**5*b**8*c**3*s + 2*a**4*b**9*c**3*s - a**2*b**11*c**3*s -
        a**9*b**3*c**4*s + 4*a**7*b**5*c**4*s - 4*a**5*b**7*c**4*s -
        a**4*b**8*c**4*s + a**3*b**9*c**4*s + a**2*b**10*c**4*s -
        a**9*b**2*c**5*s + a**7*b**4*c**5*s + a**6*b**5*c**5*s +
        a**5*b**6*c**5*s - 2*a**4*b**7*c**5*s - a**3*b**8*c**5*s +
        a**2*b**9*c**5*s + a**9*b*c**6*s + a**8*b**2*c**6*s -
        4*a**7*b**3*c**6*s - 3*a**6*b**4*c**6*s + 4*a**5*b**5*c**6*s +
        5*a**4*b**6*c**6*s - a**3*b**7*c**6*s - 4*a**2*b**8*c**6*s +
        b**10*c**6*s - a**8*b*c**7*s + 2*a**7*b**2*c**7*s +
        3*a**6*b**3*c**7*s - 4*a**5*b**4*c**7*s - 5*a**4*b**5*c**7*s +
        2*a**3*b**6*c**7*s + 5*a**2*b**7*c**7*s - 2*b**9*c**7*s +
        a**7*b*c**8*s - a**6*b**2*c**8*s + a**4*b**4*c**8*s -
        a**3*b**5*c**8*s - a**2*b**6*c**8*s + b**8*c**8*s -
        a**7*c**9*s - a**6*b*c**9*s + 2*a**5*b**2*c**9*s +
        3*a**4*b**3*c**9*s - a**3*b**4*c**9*s - 3*a**2*b**5*c**9*s +
        b**7*c**9*s + a**6*c**10*s - a**5*b*c**10*s -
        3*a**4*b**2*c**10*s + a**3*b**3*c**10*s + 4*a**2*b**4*c**10*s
        - 2*b**6*c**10*s + a**4*b*c**11*s - 2*a**2*b**3*c**11*s +
        b**5*c**11*s), (-a**8*b**7*c**2 - 2*a**7*b**8*c**2 -
        a**6*b**9*c**2 - 3*a**9*b**5*c**3 - 7*a**8*b**6*c**3 -
        9*a**7*b**7*c**3 - 9*a**6*b**8*c**3 - 5*a**5*b**9*c**3 -
        4*a**9*b**4*c**4 - 19*a**8*b**5*c**4 - 27*a**7*b**6*c**4 -
        20*a**6*b**7*c**4 - 17*a**5*b**8*c**4 - 9*a**4*b**9*c**4 -
        2*a**9*b**3*c**5 - 17*a**8*b**4*c**5 - 40*a**7*b**5*c**5 -
        34*a**6*b**6*c**5 - 24*a**5*b**7*c**5 - 18*a**4*b**8*c**5 -
        7*a**3*b**9*c**5 - 5*a**8*b**3*c**6 - 21*a**7*b**4*c**6 -
        27*a**6*b**5*c**6 - 21*a**5*b**6*c**6 - 18*a**4*b**7*c**6 -
        10*a**3*b**8*c**6 - 2*a**2*b**9*c**6 - 4*a**7*b**3*c**7 -
        8*a**6*b**4*c**7 - 8*a**5*b**5*c**7 - 7*a**4*b**6*c**7 -
        6*a**3*b**7*c**7 - 2*a**2*b**8*c**7 + 3*a**7*b**6*c**2*s**2 +
        3*a**6*b**7*c**2*s**2 + 9*a**8*b**4*c**3*s**2 +
        21*a**7*b**5*c**3*s**2 + 24*a**6*b**6*c**3*s**2 +
        16*a**5*b**7*c**3*s**2 + 4*a**4*b**8*c**3*s**2 +
        9*a**8*b**3*c**4*s**2 + 46*a**7*b**4*c**4*s**2 +
        61*a**6*b**5*c**4*s**2 + 46*a**5*b**6*c**4*s**2 +
        29*a**4*b**7*c**4*s**2 + 7*a**3*b**8*c**4*s**2 +
        19*a**7*b**3*c**5*s**2 + 52*a**6*b**4*c**5*s**2 +
        47*a**5*b**5*c**5*s**2 + 30*a**4*b**6*c**5*s**2 +
        17*a**3*b**7*c**5*s**2 + 3*a**2*b**8*c**5*s**2 +
        8*a**6*b**3*c**6*s**2 + 15*a**5*b**4*c**6*s**2 +
        10*a**4*b**5*c**6*s**2 + 5*a**3*b**6*c**6*s**2 +
        2*a**2*b**7*c**6*s**2)/(a**10*b**6*s - 2*a**9*b**7*s +
        a**8*b**8*s + a**7*b**9*s - 2*a**6*b**10*s + a**5*b**11*s -
        a**11*b**3*c**2*s + a**10*b**4*c**2*s + a**9*b**5*c**2*s -
        4*a**8*b**6*c**2*s + 5*a**7*b**7*c**2*s - a**6*b**8*c**2*s -
        3*a**5*b**9*c**2*s + 4*a**4*b**10*c**2*s - 2*a**3*b**11*c**2*s
        + a**9*b**4*c**3*s - a**8*b**5*c**3*s - a**7*b**6*c**3*s +
        2*a**6*b**7*c**3*s - a**5*b**8*c**3*s - a**4*b**9*c**3*s +
        a**3*b**10*c**3*s + a**11*b*c**4*s - 2*a**10*b**2*c**4*s +
        2*a**9*b**3*c**4*s - a**8*b**4*c**4*s - 2*a**7*b**5*c**4*s +
        5*a**6*b**6*c**4*s - 5*a**5*b**7*c**4*s + a**4*b**8*c**4*s +
        3*a**3*b**9*c**4*s - 3*a**2*b**10*c**4*s + a*b**11*c**4*s -
        a**10*b*c**5*s + a**9*b**2*c**5*s + 2*a**8*b**3*c**5*s -
        4*a**7*b**4*c**5*s + a**6*b**5*c**5*s + 4*a**5*b**6*c**5*s -
        4*a**4*b**7*c**5*s + 2*a**2*b**9*c**5*s - a*b**10*c**5*s +
        a**10*c**6*s - 2*a**9*b*c**6*s + 2*a**8*b**2*c**6*s -
        a**7*b**3*c**6*s + a**5*b**5*c**6*s - 3*a**4*b**6*c**6*s +
        3*a**3*b**7*c**6*s - a**2*b**8*c**6*s - a*b**9*c**6*s +
        b**10*c**6*s - a**9*c**7*s + 2*a**8*b*c**7*s -
        4*a**6*b**3*c**7*s + 4*a**5*b**4*c**7*s + a**4*b**5*c**7*s -
        4*a**3*b**6*c**7*s + 2*a**2*b**7*c**7*s + a*b**8*c**7*s -
        b**9*c**7*s - a**8*c**8*s + a**7*b*c**8*s + a**2*b**6*c**8*s -
        a*b**7*c**8*s + a**7*c**9*s - a**6*b*c**9*s - a**5*b**2*c**9*s
        + 2*a**4*b**3*c**9*s - a**3*b**4*c**9*s - a**2*b**5*c**9*s +
        a*b**6*c**9*s), (-2*a**9*b**6*c**2 - 2*a**8*b**7*c**2 -
        7*a**9*b**5*c**3 - 10*a**8*b**6*c**3 - 6*a**7*b**7*c**3 -
        9*a**9*b**4*c**4 - 18*a**8*b**5*c**4 - 18*a**7*b**6*c**4 -
        7*a**6*b**7*c**4 - 5*a**9*b**3*c**5 - 17*a**8*b**4*c**5 -
        24*a**7*b**5*c**5 - 21*a**6*b**6*c**5 - 8*a**5*b**7*c**5 -
        a**9*b**2*c**6 - 9*a**8*b**3*c**6 - 20*a**7*b**4*c**6 -
        34*a**6*b**5*c**6 - 27*a**5*b**6*c**6 - 8*a**4*b**7*c**6 -
        2*a**8*b**2*c**7 - 9*a**7*b**3*c**7 - 27*a**6*b**4*c**7 -
        40*a**5*b**5*c**7 - 21*a**4*b**6*c**7 - 4*a**3*b**7*c**7 -
        a**7*b**2*c**8 - 7*a**6*b**3*c**8 - 19*a**5*b**4*c**8 -
        17*a**4*b**5*c**8 - 5*a**3*b**6*c**8 - 3*a**5*b**3*c**9 -
        4*a**4*b**4*c**9 - 2*a**3*b**5*c**9 + 3*a**8*b**5*c**2*s**2 +
        2*a**7*b**6*c**2*s**2 + 7*a**8*b**4*c**3*s**2 +
        17*a**7*b**5*c**3*s**2 + 5*a**6*b**6*c**3*s**2 +
        4*a**8*b**3*c**4*s**2 + 29*a**7*b**4*c**4*s**2 +
        30*a**6*b**5*c**4*s**2 + 10*a**5*b**6*c**4*s**2 +
        16*a**7*b**3*c**5*s**2 + 46*a**6*b**4*c**5*s**2 +
        47*a**5*b**5*c**5*s**2 + 15*a**4*b**6*c**5*s**2 +
        3*a**7*b**2*c**6*s**2 + 24*a**6*b**3*c**6*s**2 +
        61*a**5*b**4*c**6*s**2 + 52*a**4*b**5*c**6*s**2 +
        8*a**3*b**6*c**6*s**2 + 3*a**6*b**2*c**7*s**2 +
        21*a**5*b**3*c**7*s**2 + 46*a**4*b**4*c**7*s**2 +
        19*a**3*b**5*c**7*s**2 + 9*a**4*b**3*c**8*s**2 +
        9*a**3*b**4*c**8*s**2)/(a**10*b**6*s - a**9*b**7*s +
        a**11*b**4*c*s - a**10*b**5*c*s - a**9*b**6*c*s +
        a**8*b**7*c*s - a**7*b**8*c*s + a**6*b**9*c*s -
        3*a**10*b**4*c**2*s + 2*a**9*b**5*c**2*s - a**8*b**6*c**2*s +
        2*a**7*b**7*c**2*s + a**6*b**8*c**2*s - a**5*b**9*c**2*s -
        2*a**11*b**2*c**3*s + a**10*b**3*c**3*s + 3*a**9*b**4*c**3*s +
        3*a**7*b**6*c**3*s - 4*a**6*b**7*c**3*s - a**4*b**9*c**3*s +
        4*a**10*b**2*c**4*s - a**9*b**3*c**4*s + a**8*b**4*c**4*s -
        4*a**7*b**5*c**4*s - 3*a**6*b**6*c**4*s + a**5*b**7*c**4*s +
        2*a**3*b**9*c**4*s + a**11*c**5*s - 3*a**9*b**2*c**5*s -
        a**8*b**3*c**5*s - 5*a**7*b**4*c**5*s + 4*a**6*b**5*c**5*s +
        a**5*b**6*c**5*s + 4*a**4*b**7*c**5*s - a**2*b**9*c**5*s -
        2*a**10*c**6*s - a**8*b**2*c**6*s + 2*a**7*b**3*c**6*s +
        5*a**6*b**4*c**6*s + a**5*b**5*c**6*s - 4*a**3*b**7*c**6*s -
        a*b**9*c**6*s + a**9*c**7*s + 5*a**7*b**2*c**7*s -
        a**6*b**3*c**7*s - 2*a**5*b**4*c**7*s - 4*a**4*b**5*c**7*s -
        a**3*b**6*c**7*s + a*b**8*c**7*s + b**9*c**7*s + a**8*c**8*s -
        4*a**6*b**2*c**8*s - a**5*b**3*c**8*s - a**4*b**4*c**8*s +
        2*a**3*b**5*c**8*s + 2*a**2*b**6*c**8*s + 2*a*b**7*c**8*s -
        b**8*c**8*s - 2*a**7*c**9*s + a**5*b**2*c**9*s +
        a**4*b**3*c**9*s + 2*a**3*b**4*c**9*s + a**2*b**5*c**9*s -
        2*a*b**6*c**9*s - b**7*c**9*s + a**6*c**10*s +
        a**4*b**2*c**10*s - 2*a**2*b**4*c**10*s - a*b**5*c**10*s +
        b**6*c**10*s - a**3*b**2*c**11*s + a*b**4*c**11*s),
        (2*a**7*b**8*c**2 + 2*a**6*b**9*c**2 + 6*a**7*b**7*c**3 +
        10*a**6*b**8*c**3 + 7*a**5*b**9*c**3 + 7*a**7*b**6*c**4 +
        18*a**6*b**7*c**4 + 18*a**5*b**8*c**4 + 9*a**4*b**9*c**4 +
        8*a**7*b**5*c**5 + 21*a**6*b**6*c**5 + 24*a**5*b**7*c**5 +
        17*a**4*b**8*c**5 + 5*a**3*b**9*c**5 + 8*a**7*b**4*c**6 +
        27*a**6*b**5*c**6 + 34*a**5*b**6*c**6 + 20*a**4*b**7*c**6 +
        9*a**3*b**8*c**6 + a**2*b**9*c**6 + 4*a**7*b**3*c**7 +
        21*a**6*b**4*c**7 + 40*a**5*b**5*c**7 + 27*a**4*b**6*c**7 +
        9*a**3*b**7*c**7 + 2*a**2*b**8*c**7 + 5*a**6*b**3*c**8 +
        17*a**5*b**4*c**8 + 19*a**4*b**5*c**8 + 7*a**3*b**6*c**8 +
        a**2*b**7*c**8 + 2*a**5*b**3*c**9 + 4*a**4*b**4*c**9 +
        3*a**3*b**5*c**9 - 2*a**6*b**7*c**2*s**2 -
        3*a**5*b**8*c**2*s**2 - 5*a**6*b**6*c**3*s**2 -
        17*a**5*b**7*c**3*s**2 - 7*a**4*b**8*c**3*s**2 -
        10*a**6*b**5*c**4*s**2 - 30*a**5*b**6*c**4*s**2 -
        29*a**4*b**7*c**4*s**2 - 4*a**3*b**8*c**4*s**2 -
        15*a**6*b**4*c**5*s**2 - 47*a**5*b**5*c**5*s**2 -
        46*a**4*b**6*c**5*s**2 - 16*a**3*b**7*c**5*s**2 -
        8*a**6*b**3*c**6*s**2 - 52*a**5*b**4*c**6*s**2 -
        61*a**4*b**5*c**6*s**2 - 24*a**3*b**6*c**6*s**2 -
        3*a**2*b**7*c**6*s**2 - 19*a**5*b**3*c**7*s**2 -
        46*a**4*b**4*c**7*s**2 - 21*a**3*b**5*c**7*s**2 -
        3*a**2*b**6*c**7*s**2 - 9*a**4*b**3*c**8*s**2 -
        9*a**3*b**4*c**8*s**2)/(a**7*b**9*s - a**6*b**10*s -
        a**9*b**6*c*s + a**8*b**7*c*s - a**7*b**8*c*s + a**6*b**9*c*s
        + a**5*b**10*c*s - a**4*b**11*c*s + a**9*b**5*c**2*s -
        a**8*b**6*c**2*s - 2*a**7*b**7*c**2*s + a**6*b**8*c**2*s -
        2*a**5*b**9*c**2*s + 3*a**4*b**10*c**2*s + a**9*b**4*c**3*s +
        4*a**7*b**6*c**3*s - 3*a**6*b**7*c**3*s - 3*a**4*b**9*c**3*s -
        a**3*b**10*c**3*s + 2*a**2*b**11*c**3*s - 2*a**9*b**3*c**4*s -
        a**7*b**5*c**4*s + 3*a**6*b**6*c**4*s + 4*a**5*b**7*c**4*s -
        a**4*b**8*c**4*s + a**3*b**9*c**4*s - 4*a**2*b**10*c**4*s +
        a**9*b**2*c**5*s - 4*a**7*b**4*c**5*s - a**6*b**5*c**5*s -
        4*a**5*b**6*c**5*s + 5*a**4*b**7*c**5*s + a**3*b**8*c**5*s +
        3*a**2*b**9*c**5*s - b**11*c**5*s + a**9*b*c**6*s +
        4*a**7*b**3*c**6*s - a**5*b**5*c**6*s - 5*a**4*b**6*c**6*s -
        2*a**3*b**7*c**6*s + a**2*b**8*c**6*s + 2*b**10*c**6*s -
        a**9*c**7*s - a**8*b*c**7*s + a**6*b**3*c**7*s +
        4*a**5*b**4*c**7*s + 2*a**4*b**5*c**7*s + a**3*b**6*c**7*s -
        5*a**2*b**7*c**7*s - b**9*c**7*s + a**8*c**8*s -
        2*a**7*b*c**8*s - 2*a**6*b**2*c**8*s - 2*a**5*b**3*c**8*s +
        a**4*b**4*c**8*s + a**3*b**5*c**8*s + 4*a**2*b**6*c**8*s -
        b**8*c**8*s + a**7*c**9*s + 2*a**6*b*c**9*s - a**5*b**2*c**9*s
        - 2*a**4*b**3*c**9*s - a**3*b**4*c**9*s - a**2*b**5*c**9*s +
        2*b**7*c**9*s - a**6*c**10*s + a**5*b*c**10*s +
        2*a**4*b**2*c**10*s - a**2*b**4*c**10*s - b**6*c**10*s -
        a**4*b*c**11*s + a**2*b**3*c**11*s), (-2*a**9*b**5*c**3 -
        5*a**8*b**6*c**3 - 4*a**7*b**7*c**3 - 4*a**9*b**4*c**4 -
        17*a**8*b**5*c**4 - 21*a**7*b**6*c**4 - 8*a**6*b**7*c**4 -
        3*a**9*b**3*c**5 - 19*a**8*b**4*c**5 - 40*a**7*b**5*c**5 -
        27*a**6*b**6*c**5 - 8*a**5*b**7*c**5 - 7*a**8*b**3*c**6 -
        27*a**7*b**4*c**6 - 34*a**6*b**5*c**6 - 21*a**5*b**6*c**6 -
        7*a**4*b**7*c**6 - a**8*b**2*c**7 - 9*a**7*b**3*c**7 -
        20*a**6*b**4*c**7 - 24*a**5*b**5*c**7 - 18*a**4*b**6*c**7 -
        6*a**3*b**7*c**7 - 2*a**7*b**2*c**8 - 9*a**6*b**3*c**8 -
        17*a**5*b**4*c**8 - 18*a**4*b**5*c**8 - 10*a**3*b**6*c**8 -
        2*a**2*b**7*c**8 - a**6*b**2*c**9 - 5*a**5*b**3*c**9 -
        9*a**4*b**4*c**9 - 7*a**3*b**5*c**9 - 2*a**2*b**6*c**9 +
        9*a**8*b**4*c**3*s**2 + 19*a**7*b**5*c**3*s**2 +
        8*a**6*b**6*c**3*s**2 + 9*a**8*b**3*c**4*s**2 +
        46*a**7*b**4*c**4*s**2 + 52*a**6*b**5*c**4*s**2 +
        15*a**5*b**6*c**4*s**2 + 21*a**7*b**3*c**5*s**2 +
        61*a**6*b**4*c**5*s**2 + 47*a**5*b**5*c**5*s**2 +
        10*a**4*b**6*c**5*s**2 + 3*a**7*b**2*c**6*s**2 +
        24*a**6*b**3*c**6*s**2 + 46*a**5*b**4*c**6*s**2 +
        30*a**4*b**5*c**6*s**2 + 5*a**3*b**6*c**6*s**2 +
        3*a**6*b**2*c**7*s**2 + 16*a**5*b**3*c**7*s**2 +
        29*a**4*b**4*c**7*s**2 + 17*a**3*b**5*c**7*s**2 +
        2*a**2*b**6*c**7*s**2 + 4*a**4*b**3*c**8*s**2 +
        7*a**3*b**4*c**8*s**2 + 3*a**2*b**5*c**8*s**2)/(a**10*b**6*s -
        a**9*b**7*s - a**8*b**8*s + a**7*b**9*s + a**11*b**4*c*s -
        a**10*b**5*c*s - 2*a**9*b**6*c*s + 2*a**8*b**7*c*s +
        a**7*b**8*c*s - a**6*b**9*c*s - 2*a**10*b**4*c**2*s +
        a**9*b**5*c**2*s + 2*a**8*b**6*c**2*s - a**5*b**9*c**2*s -
        a**11*b**2*c**3*s + 2*a**9*b**4*c**3*s + 2*a**8*b**5*c**3*s -
        a**7*b**6*c**3*s - 4*a**6*b**7*c**3*s + 2*a**4*b**9*c**3*s +
        a**10*b**2*c**4*s + a**9*b**3*c**4*s - a**8*b**4*c**4*s -
        4*a**7*b**5*c**4*s + 4*a**5*b**7*c**4*s - a**3*b**9*c**4*s +
        a**9*b**2*c**5*s - a**8*b**3*c**5*s - 2*a**7*b**4*c**5*s +
        a**6*b**5*c**5*s + a**5*b**6*c**5*s + a**4*b**7*c**5*s -
        a**2*b**9*c**5*s + a**10*c**6*s - 4*a**8*b**2*c**6*s -
        a**7*b**3*c**6*s + 5*a**6*b**4*c**6*s + 4*a**5*b**5*c**6*s -
        3*a**4*b**6*c**6*s - 4*a**3*b**7*c**6*s + a**2*b**8*c**6*s +
        a*b**9*c**6*s - 2*a**9*c**7*s + 5*a**7*b**2*c**7*s +
        2*a**6*b**3*c**7*s - 5*a**5*b**4*c**7*s - 4*a**4*b**5*c**7*s +
        3*a**3*b**6*c**7*s + 2*a**2*b**7*c**7*s - a*b**8*c**7*s +
        a**8*c**8*s - a**6*b**2*c**8*s - a**5*b**3*c**8*s +
        a**4*b**4*c**8*s - a**2*b**6*c**8*s + a*b**7*c**8*s +
        a**7*c**9*s - 3*a**5*b**2*c**9*s - a**4*b**3*c**9*s +
        3*a**3*b**4*c**9*s + 2*a**2*b**5*c**9*s - a*b**6*c**9*s -
        b**7*c**9*s - 2*a**6*c**10*s + 4*a**4*b**2*c**10*s +
        a**3*b**3*c**10*s - 3*a**2*b**4*c**10*s - a*b**5*c**10*s +
        b**6*c**10*s + a**5*c**11*s - 2*a**3*b**2*c**11*s +
        a*b**4*c**11*s), (-a**9*b**6*c**2 - 2*a**8*b**7*c**2 -
        a**7*b**8*c**2 - 5*a**9*b**5*c**3 - 9*a**8*b**6*c**3 -
        9*a**7*b**7*c**3 - 7*a**6*b**8*c**3 - 3*a**5*b**9*c**3 -
        9*a**9*b**4*c**4 - 17*a**8*b**5*c**4 - 20*a**7*b**6*c**4 -
        27*a**6*b**7*c**4 - 19*a**5*b**8*c**4 - 4*a**4*b**9*c**4 -
        7*a**9*b**3*c**5 - 18*a**8*b**4*c**5 - 24*a**7*b**5*c**5 -
        34*a**6*b**6*c**5 - 40*a**5*b**7*c**5 - 17*a**4*b**8*c**5 -
        2*a**3*b**9*c**5 - 2*a**9*b**2*c**6 - 10*a**8*b**3*c**6 -
        18*a**7*b**4*c**6 - 21*a**6*b**5*c**6 - 27*a**5*b**6*c**6 -
        21*a**4*b**7*c**6 - 5*a**3*b**8*c**6 - 2*a**8*b**2*c**7 -
        6*a**7*b**3*c**7 - 7*a**6*b**4*c**7 - 8*a**5*b**5*c**7 -
        8*a**4*b**6*c**7 - 4*a**3*b**7*c**7 + 3*a**7*b**6*c**2*s**2 +
        3*a**6*b**7*c**2*s**2 + 4*a**8*b**4*c**3*s**2 +
        16*a**7*b**5*c**3*s**2 + 24*a**6*b**6*c**3*s**2 +
        21*a**5*b**7*c**3*s**2 + 9*a**4*b**8*c**3*s**2 +
        7*a**8*b**3*c**4*s**2 + 29*a**7*b**4*c**4*s**2 +
        46*a**6*b**5*c**4*s**2 + 61*a**5*b**6*c**4*s**2 +
        46*a**4*b**7*c**4*s**2 + 9*a**3*b**8*c**4*s**2 +
        3*a**8*b**2*c**5*s**2 + 17*a**7*b**3*c**5*s**2 +
        30*a**6*b**4*c**5*s**2 + 47*a**5*b**5*c**5*s**2 +
        52*a**4*b**6*c**5*s**2 + 19*a**3*b**7*c**5*s**2 +
        2*a**7*b**2*c**6*s**2 + 5*a**6*b**3*c**6*s**2 +
        10*a**5*b**4*c**6*s**2 + 15*a**4*b**5*c**6*s**2 +
        8*a**3*b**6*c**6*s**2)/(a**11*b**5*s - 2*a**10*b**6*s +
        a**9*b**7*s + a**8*b**8*s - 2*a**7*b**9*s + a**6*b**10*s -
        2*a**11*b**3*c**2*s + 4*a**10*b**4*c**2*s - 3*a**9*b**5*c**2*s
        - a**8*b**6*c**2*s + 5*a**7*b**7*c**2*s - 4*a**6*b**8*c**2*s +
        a**5*b**9*c**2*s + a**4*b**10*c**2*s - a**3*b**11*c**2*s +
        a**10*b**3*c**3*s - a**9*b**4*c**3*s - a**8*b**5*c**3*s +
        2*a**7*b**6*c**3*s - a**6*b**7*c**3*s - a**5*b**8*c**3*s +
        a**4*b**9*c**3*s + a**11*b*c**4*s - 3*a**10*b**2*c**4*s +
        3*a**9*b**3*c**4*s + a**8*b**4*c**4*s - 5*a**7*b**5*c**4*s +
        5*a**6*b**6*c**4*s - 2*a**5*b**7*c**4*s - a**4*b**8*c**4*s +
        2*a**3*b**9*c**4*s - 2*a**2*b**10*c**4*s + a*b**11*c**4*s -
        a**10*b*c**5*s + 2*a**9*b**2*c**5*s - 4*a**7*b**4*c**5*s +
        4*a**6*b**5*c**5*s + a**5*b**6*c**5*s - 4*a**4*b**7*c**5*s +
        2*a**3*b**8*c**5*s + a**2*b**9*c**5*s - a*b**10*c**5*s +
        a**10*c**6*s - a**9*b*c**6*s - a**8*b**2*c**6*s +
        3*a**7*b**3*c**6*s - 3*a**6*b**4*c**6*s + a**5*b**5*c**6*s -
        a**3*b**7*c**6*s + 2*a**2*b**8*c**6*s - 2*a*b**9*c**6*s +
        b**10*c**6*s - a**9*c**7*s + a**8*b*c**7*s +
        2*a**7*b**2*c**7*s - 4*a**6*b**3*c**7*s + a**5*b**4*c**7*s +
        4*a**4*b**5*c**7*s - 4*a**3*b**6*c**7*s + 2*a*b**8*c**7*s -
        b**9*c**7*s - a**7*b*c**8*s + a**6*b**2*c**8*s + a*b**7*c**8*s
        - b**8*c**8*s + a**6*b*c**9*s - a**5*b**2*c**9*s -
        a**4*b**3*c**9*s + 2*a**3*b**4*c**9*s - a**2*b**5*c**9*s -
        a*b**6*c**9*s + b**7*c**9*s), (-2*a**9*b**6*c**2 -
        2*a**8*b**7*c**2 - 6*a**9*b**5*c**3 - 10*a**8*b**6*c**3 -
        6*a**7*b**7*c**3 - a**6*b**8*c**3 - 8*a**9*b**4*c**4 -
        17*a**8*b**5*c**4 - 20*a**7*b**6*c**4 - 13*a**6*b**7*c**4 -
        4*a**5*b**8*c**4 - 6*a**9*b**3*c**5 - 17*a**8*b**4*c**5 -
        26*a**7*b**5*c**5 - 34*a**6*b**6*c**5 - 23*a**5*b**7*c**5 -
        5*a**4*b**8*c**5 - 2*a**9*b**2*c**6 - 10*a**8*b**3*c**6 -
        20*a**7*b**4*c**6 - 34*a**6*b**5*c**6 - 43*a**5*b**6*c**6 -
        20*a**4*b**7*c**6 - 3*a**3*b**8*c**6 - 2*a**8*b**2*c**7 -
        6*a**7*b**3*c**7 - 13*a**6*b**4*c**7 - 23*a**5*b**5*c**7 -
        20*a**4*b**6*c**7 - 5*a**3*b**7*c**7 - a**6*b**3*c**8 -
        4*a**5*b**4*c**8 - 5*a**4*b**5*c**8 - 3*a**3*b**6*c**8 +
        2*a**8*b**5*c**2*s**2 + 3*a**7*b**6*c**2*s**2 +
        5*a**8*b**4*c**3*s**2 + 17*a**7*b**5*c**3*s**2 +
        12*a**6*b**6*c**3*s**2 + 3*a**5*b**7*c**3*s**2 +
        5*a**8*b**3*c**4*s**2 + 27*a**7*b**4*c**4*s**2 +
        42*a**6*b**5*c**4*s**2 + 34*a**5*b**6*c**4*s**2 +
        12*a**4*b**7*c**4*s**2 + 2*a**8*b**2*c**5*s**2 +
        17*a**7*b**3*c**5*s**2 + 42*a**6*b**4*c**5*s**2 +
        65*a**5*b**5*c**5*s**2 + 49*a**4*b**6*c**5*s**2 +
        9*a**3*b**7*c**5*s**2 + 3*a**7*b**2*c**6*s**2 +
        12*a**6*b**3*c**6*s**2 + 34*a**5*b**4*c**6*s**2 +
        49*a**4*b**5*c**6*s**2 + 18*a**3*b**6*c**6*s**2 +
        3*a**5*b**3*c**7*s**2 + 12*a**4*b**4*c**7*s**2 +
        9*a**3*b**5*c**7*s**2)/(a**9*b**7*s - a**8*b**8*s -
        a**11*b**4*c*s + a**10*b**5*c*s - a**9*b**6*c*s +
        a**8*b**7*c*s + a**7*b**8*c*s - a**6*b**9*c*s +
        a**11*b**3*c**2*s - a**10*b**4*c**2*s - 2*a**9*b**5*c**2*s +
        a**8*b**6*c**2*s - a**7*b**7*c**2*s + 2*a**6*b**8*c**2*s +
        a**5*b**9*c**2*s - a**4*b**10*c**2*s + a**11*b**2*c**3*s +
        2*a**9*b**4*c**3*s - a**8*b**5*c**3*s - 3*a**7*b**6*c**3*s -
        a**5*b**8*c**3*s + 2*a**4*b**9*c**3*s - a**11*b*c**4*s -
        a**10*b**2*c**4*s + 2*a**9*b**3*c**4*s + 3*a**7*b**5*c**4*s -
        a**6*b**6*c**4*s - 2*a**5*b**7*c**4*s - a**4*b**8*c**4*s +
        a**2*b**10*c**4*s + a**10*b*c**5*s - 2*a**9*b**2*c**5*s -
        a**8*b**3*c**5*s + 3*a**7*b**4*c**5*s + 2*a**5*b**6*c**5*s -
        a**4*b**7*c**5*s - a**3*b**8*c**5*s - a**2*b**9*c**5*s -
        a**9*b*c**6*s + a**8*b**2*c**6*s - 3*a**7*b**3*c**6*s -
        a**6*b**4*c**6*s + 2*a**5*b**5*c**6*s + 2*a**4*b**6*c**6*s +
        a**3*b**7*c**6*s - a**2*b**8*c**6*s + a**9*c**7*s +
        a**8*b*c**7*s - a**7*b**2*c**7*s - 2*a**5*b**4*c**7*s -
        a**4*b**5*c**7*s + a**3*b**6*c**7*s + 2*a**2*b**7*c**7*s -
        b**9*c**7*s - a**8*c**8*s + a**7*b*c**8*s + 2*a**6*b**2*c**8*s
        - a**5*b**3*c**8*s - a**4*b**4*c**8*s - a**3*b**5*c**8*s -
        a**2*b**6*c**8*s + 2*b**8*c**8*s - a**6*b*c**9*s +
        a**5*b**2*c**9*s + 2*a**4*b**3*c**9*s - a**2*b**5*c**9*s -
        b**7*c**9*s - a**4*b**2*c**10*s + a**2*b**4*c**10*s),
        (3*a**8*b**6*c**3 + 5*a**7*b**7*c**3 + 3*a**6*b**8*c**3 +
        5*a**8*b**5*c**4 + 20*a**7*b**6*c**4 + 20*a**6*b**7*c**4 +
        5*a**5*b**8*c**4 + 4*a**8*b**4*c**5 + 23*a**7*b**5*c**5 +
        43*a**6*b**6*c**5 + 23*a**5*b**7*c**5 + 4*a**4*b**8*c**5 +
        a**8*b**3*c**6 + 13*a**7*b**4*c**6 + 34*a**6*b**5*c**6 +
        34*a**5*b**6*c**6 + 13*a**4*b**7*c**6 + a**3*b**8*c**6 +
        6*a**7*b**3*c**7 + 20*a**6*b**4*c**7 + 26*a**5*b**5*c**7 +
        20*a**4*b**6*c**7 + 6*a**3*b**7*c**7 + 2*a**7*b**2*c**8 +
        10*a**6*b**3*c**8 + 17*a**5*b**4*c**8 + 17*a**4*b**5*c**8 +
        10*a**3*b**6*c**8 + 2*a**2*b**7*c**8 + 2*a**6*b**2*c**9 +
        6*a**5*b**3*c**9 + 8*a**4*b**4*c**9 + 6*a**3*b**5*c**9 +
        2*a**2*b**6*c**9 - 9*a**7*b**5*c**3*s**2 -
        18*a**6*b**6*c**3*s**2 - 9*a**5*b**7*c**3*s**2 -
        12*a**7*b**4*c**4*s**2 - 49*a**6*b**5*c**4*s**2 -
        49*a**5*b**6*c**4*s**2 - 12*a**4*b**7*c**4*s**2 -
        3*a**7*b**3*c**5*s**2 - 34*a**6*b**4*c**5*s**2 -
        65*a**5*b**5*c**5*s**2 - 34*a**4*b**6*c**5*s**2 -
        3*a**3*b**7*c**5*s**2 - 12*a**6*b**3*c**6*s**2 -
        42*a**5*b**4*c**6*s**2 - 42*a**4*b**5*c**6*s**2 -
        12*a**3*b**6*c**6*s**2 - 3*a**6*b**2*c**7*s**2 -
        17*a**5*b**3*c**7*s**2 - 27*a**4*b**4*c**7*s**2 -
        17*a**3*b**5*c**7*s**2 - 3*a**2*b**6*c**7*s**2 -
        2*a**5*b**2*c**8*s**2 - 5*a**4*b**3*c**8*s**2 -
        5*a**3*b**4*c**8*s**2 - 2*a**2*b**5*c**8*s**2)/(a**9*b**7*s -
        2*a**8*b**8*s + a**7*b**9*s - a**10*b**4*c**2*s +
        a**9*b**5*c**2*s + a**8*b**6*c**2*s - 2*a**7*b**7*c**2*s +
        a**6*b**8*c**2*s + a**5*b**9*c**2*s - a**4*b**10*c**2*s +
        a**8*b**5*c**3*s - a**7*b**6*c**3*s - a**6*b**7*c**3*s +
        a**5*b**8*c**3*s + a**10*b**2*c**4*s - 2*a**9*b**3*c**4*s +
        a**8*b**4*c**4*s + a**7*b**5*c**4*s - 2*a**6*b**6*c**4*s +
        a**5*b**7*c**4*s + a**4*b**8*c**4*s - 2*a**3*b**9*c**4*s +
        a**2*b**10*c**4*s - a**9*b**2*c**5*s + a**8*b**3*c**5*s +
        2*a**7*b**4*c**5*s - 2*a**6*b**5*c**5*s - 2*a**5*b**6*c**5*s +
        2*a**4*b**7*c**5*s + a**3*b**8*c**5*s - a**2*b**9*c**5*s +
        a**9*b*c**6*s - 2*a**8*b**2*c**6*s + a**6*b**4*c**6*s +
        a**4*b**6*c**6*s - 2*a**2*b**8*c**6*s + a*b**9*c**6*s -
        a**8*b*c**7*s + a**7*b**2*c**7*s + 3*a**6*b**3*c**7*s -
        3*a**5*b**4*c**7*s - 3*a**4*b**5*c**7*s + 3*a**3*b**6*c**7*s +
        a**2*b**7*c**7*s - a*b**8*c**7*s + a**8*c**8*s - a**7*b*c**8*s
        - a**6*b**2*c**8*s + a**5*b**3*c**8*s + a**3*b**5*c**8*s -
        a**2*b**6*c**8*s - a*b**7*c**8*s + b**8*c**8*s - a**7*c**9*s +
        a**6*b*c**9*s + 2*a**5*b**2*c**9*s - 2*a**4*b**3*c**9*s -
        2*a**3*b**4*c**9*s + 2*a**2*b**5*c**9*s + a*b**6*c**9*s -
        b**7*c**9*s - a**5*b*c**10*s + a**4*b**2*c**10*s +
        a**2*b**4*c**10*s - a*b**5*c**10*s + a**4*b*c**11*s -
        a**3*b**2*c**11*s - a**2*b**3*c**11*s + a*b**4*c**11*s),
        (2*a**7*b**8*c**2 + 2*a**6*b**9*c**2 + a**8*b**6*c**3 +
        6*a**7*b**7*c**3 + 10*a**6*b**8*c**3 + 6*a**5*b**9*c**3 +
        4*a**8*b**5*c**4 + 13*a**7*b**6*c**4 + 20*a**6*b**7*c**4 +
        17*a**5*b**8*c**4 + 8*a**4*b**9*c**4 + 5*a**8*b**4*c**5 +
        23*a**7*b**5*c**5 + 34*a**6*b**6*c**5 + 26*a**5*b**7*c**5 +
        17*a**4*b**8*c**5 + 6*a**3*b**9*c**5 + 3*a**8*b**3*c**6 +
        20*a**7*b**4*c**6 + 43*a**6*b**5*c**6 + 34*a**5*b**6*c**6 +
        20*a**4*b**7*c**6 + 10*a**3*b**8*c**6 + 2*a**2*b**9*c**6 +
        5*a**7*b**3*c**7 + 20*a**6*b**4*c**7 + 23*a**5*b**5*c**7 +
        13*a**4*b**6*c**7 + 6*a**3*b**7*c**7 + 2*a**2*b**8*c**7 +
        3*a**6*b**3*c**8 + 5*a**5*b**4*c**8 + 4*a**4*b**5*c**8 +
        a**3*b**6*c**8 - 3*a**6*b**7*c**2*s**2 - 2*a**5*b**8*c**2*s**2
        - 3*a**7*b**5*c**3*s**2 - 12*a**6*b**6*c**3*s**2 -
        17*a**5*b**7*c**3*s**2 - 5*a**4*b**8*c**3*s**2 -
        12*a**7*b**4*c**4*s**2 - 34*a**6*b**5*c**4*s**2 -
        42*a**5*b**6*c**4*s**2 - 27*a**4*b**7*c**4*s**2 -
        5*a**3*b**8*c**4*s**2 - 9*a**7*b**3*c**5*s**2 -
        49*a**6*b**4*c**5*s**2 - 65*a**5*b**5*c**5*s**2 -
        42*a**4*b**6*c**5*s**2 - 17*a**3*b**7*c**5*s**2 -
        2*a**2*b**8*c**5*s**2 - 18*a**6*b**3*c**6*s**2 -
        49*a**5*b**4*c**6*s**2 - 34*a**4*b**5*c**6*s**2 -
        12*a**3*b**6*c**6*s**2 - 3*a**2*b**7*c**6*s**2 -
        9*a**5*b**3*c**7*s**2 - 12*a**4*b**4*c**7*s**2 -
        3*a**3*b**5*c**7*s**2)/(a**8*b**8*s - a**7*b**9*s +
        a**9*b**6*c*s - a**8*b**7*c*s - a**7*b**8*c*s + a**6*b**9*c*s
        - a**5*b**10*c*s + a**4*b**11*c*s + a**10*b**4*c**2*s -
        a**9*b**5*c**2*s - 2*a**8*b**6*c**2*s + a**7*b**7*c**2*s -
        a**6*b**8*c**2*s + 2*a**5*b**9*c**2*s + a**4*b**10*c**2*s -
        a**3*b**11*c**2*s - 2*a**9*b**4*c**3*s + a**8*b**5*c**3*s +
        3*a**6*b**7*c**3*s + a**5*b**8*c**3*s - 2*a**4*b**9*c**3*s -
        a**2*b**11*c**3*s - a**10*b**2*c**4*s + a**8*b**4*c**4*s +
        2*a**7*b**5*c**4*s + a**6*b**6*c**4*s - 3*a**5*b**7*c**4*s -
        2*a**3*b**9*c**4*s + a**2*b**10*c**4*s + a*b**11*c**4*s +
        a**9*b**2*c**5*s + a**8*b**3*c**5*s + a**7*b**4*c**5*s -
        2*a**6*b**5*c**5*s - 3*a**4*b**7*c**5*s + a**3*b**8*c**5*s +
        2*a**2*b**9*c**5*s - a*b**10*c**5*s + a**8*b**2*c**6*s -
        a**7*b**3*c**6*s - 2*a**6*b**4*c**6*s - 2*a**5*b**5*c**6*s +
        a**4*b**6*c**6*s + 3*a**3*b**7*c**6*s - a**2*b**8*c**6*s +
        a*b**9*c**6*s + a**9*c**7*s - 2*a**7*b**2*c**7*s -
        a**6*b**3*c**7*s + a**5*b**4*c**7*s + 2*a**4*b**5*c**7*s +
        a**2*b**7*c**7*s - a*b**8*c**7*s - b**9*c**7*s - 2*a**8*c**8*s
        + a**6*b**2*c**8*s + a**5*b**3*c**8*s + a**4*b**4*c**8*s +
        a**3*b**5*c**8*s - 2*a**2*b**6*c**8*s - a*b**7*c**8*s +
        b**8*c**8*s + a**7*c**9*s + a**5*b**2*c**9*s -
        2*a**3*b**4*c**9*s - a**2*b**5*c**9*s + a*b**6*c**9*s -
        a**4*b**2*c**10*s + a**2*b**4*c**10*s), (-a**7*b**6*c**2 -
        a**6*b**7*c**2 + (-zeta3 - 3)*a**7*b**5*c**3 + (-4/3*zeta3 -
        17/3)*a**6*b**6*c**3 + (-zeta3 - 3)*a**5*b**7*c**3 +
        (-4/3*zeta3 - 11/3)*a**7*b**4*c**4 + (-20/3*zeta3 -
        34/3)*a**6*b**5*c**4 + (-20/3*zeta3 - 34/3)*a**5*b**6*c**4 +
        (-4/3*zeta3 - 11/3)*a**4*b**7*c**4 + (-zeta3 -
        3)*a**7*b**3*c**5 + (-20/3*zeta3 - 34/3)*a**6*b**4*c**5 +
        (-15*zeta3 - 18)*a**5*b**5*c**5 + (-20/3*zeta3 -
        34/3)*a**4*b**6*c**5 + (-zeta3 - 3)*a**3*b**7*c**5 -
        a**7*b**2*c**6 + (-4/3*zeta3 - 17/3)*a**6*b**3*c**6 +
        (-20/3*zeta3 - 34/3)*a**5*b**4*c**6 + (-20/3*zeta3 -
        34/3)*a**4*b**5*c**6 + (-4/3*zeta3 - 17/3)*a**3*b**6*c**6 -
        a**2*b**7*c**6 - a**6*b**2*c**7 + (-zeta3 - 3)*a**5*b**3*c**7
        + (-4/3*zeta3 - 11/3)*a**4*b**4*c**7 + (-zeta3 -
        3)*a**3*b**5*c**7 - a**2*b**6*c**7 + (zeta3 +
        2)*a**6*b**5*c**2*s**2 + (zeta3 + 2)*a**5*b**6*c**2*s**2 +
        (16/3*zeta3 + 23/3)*a**6*b**4*c**3*s**2 + (35/3*zeta3 +
        49/3)*a**5*b**5*c**3*s**2 + (16/3*zeta3 +
        23/3)*a**4*b**6*c**3*s**2 + (16/3*zeta3 +
        23/3)*a**6*b**3*c**4*s**2 + (71/3*zeta3 +
        91/3)*a**5*b**4*c**4*s**2 + (71/3*zeta3 +
        91/3)*a**4*b**5*c**4*s**2 + (16/3*zeta3 +
        23/3)*a**3*b**6*c**4*s**2 + (zeta3 + 2)*a**6*b**2*c**5*s**2 +
        (35/3*zeta3 + 49/3)*a**5*b**3*c**5*s**2 + (71/3*zeta3 +
        91/3)*a**4*b**4*c**5*s**2 + (35/3*zeta3 +
        49/3)*a**3*b**5*c**5*s**2 + (zeta3 + 2)*a**2*b**6*c**5*s**2 +
        (zeta3 + 2)*a**5*b**2*c**6*s**2 + (16/3*zeta3 +
        23/3)*a**4*b**3*c**6*s**2 + (16/3*zeta3 +
        23/3)*a**3*b**4*c**6*s**2 + (zeta3 +
        2)*a**2*b**5*c**6*s**2)/(a**8*b**6*s - a**7*b**7*s +
        a**6*b**8*s + (zeta3 + 1)*a**9*b**4*c*s + (-zeta3 -
        1)*a**8*b**5*c*s + (zeta3 + 1)*a**7*b**6*c*s + (zeta3 +
        1)*a**6*b**7*c*s + (-zeta3 - 1)*a**5*b**8*c*s + (zeta3 +
        1)*a**4*b**9*c*s - a**7*b**5*c**2*s + a**6*b**6*c**2*s -
        a**5*b**7*c**2*s + (-zeta3 + 1)*a**8*b**3*c**3*s +
        zeta3*a**7*b**4*c**3*s + (-zeta3 + 1)*a**6*b**5*c**3*s +
        (-zeta3 + 1)*a**5*b**6*c**3*s + zeta3*a**4*b**7*c**3*s +
        (-zeta3 + 1)*a**3*b**8*c**3*s + (zeta3 + 1)*a**9*b*c**4*s +
        zeta3*a**7*b**3*c**4*s + (3*zeta3 + 3)*a**6*b**4*c**4*s +
        (-zeta3 - 2)*a**5*b**5*c**4*s + (3*zeta3 + 3)*a**4*b**6*c**4*s
        + zeta3*a**3*b**7*c**4*s + (zeta3 + 1)*a*b**9*c**4*s + (-zeta3
        - 1)*a**8*b*c**5*s - a**7*b**2*c**5*s + (-zeta3 +
        1)*a**6*b**3*c**5*s + (-zeta3 - 2)*a**5*b**4*c**5*s + (-zeta3
        - 2)*a**4*b**5*c**5*s + (-zeta3 + 1)*a**3*b**6*c**5*s -
        a**2*b**7*c**5*s + (-zeta3 - 1)*a*b**8*c**5*s + a**8*c**6*s +
        (zeta3 + 1)*a**7*b*c**6*s + a**6*b**2*c**6*s + (-zeta3 +
        1)*a**5*b**3*c**6*s + (3*zeta3 + 3)*a**4*b**4*c**6*s + (-zeta3
        + 1)*a**3*b**5*c**6*s + a**2*b**6*c**6*s + (zeta3 +
        1)*a*b**7*c**6*s + b**8*c**6*s - a**7*c**7*s + (zeta3 +
        1)*a**6*b*c**7*s - a**5*b**2*c**7*s + zeta3*a**4*b**3*c**7*s +
        zeta3*a**3*b**4*c**7*s - a**2*b**5*c**7*s + (zeta3 +
        1)*a*b**6*c**7*s - b**7*c**7*s + a**6*c**8*s + (-zeta3 -
        1)*a**5*b*c**8*s + (-zeta3 + 1)*a**3*b**3*c**8*s + (-zeta3 -
        1)*a*b**5*c**8*s + b**6*c**8*s + (zeta3 + 1)*a**4*b*c**9*s +
        (zeta3 + 1)*a*b**4*c**9*s), (-a**7*b**6*c**2 - a**6*b**7*c**2
        + (zeta3 - 2)*a**7*b**5*c**3 + (4/3*zeta3 -
        13/3)*a**6*b**6*c**3 + (zeta3 - 2)*a**5*b**7*c**3 + (4/3*zeta3
        - 7/3)*a**7*b**4*c**4 + (20/3*zeta3 - 14/3)*a**6*b**5*c**4 +
        (20/3*zeta3 - 14/3)*a**5*b**6*c**4 + (4/3*zeta3 -
        7/3)*a**4*b**7*c**4 + (zeta3 - 2)*a**7*b**3*c**5 + (20/3*zeta3
        - 14/3)*a**6*b**4*c**5 + (15*zeta3 - 3)*a**5*b**5*c**5 +
        (20/3*zeta3 - 14/3)*a**4*b**6*c**5 + (zeta3 -
        2)*a**3*b**7*c**5 - a**7*b**2*c**6 + (4/3*zeta3 -
        13/3)*a**6*b**3*c**6 + (20/3*zeta3 - 14/3)*a**5*b**4*c**6 +
        (20/3*zeta3 - 14/3)*a**4*b**5*c**6 + (4/3*zeta3 -
        13/3)*a**3*b**6*c**6 - a**2*b**7*c**6 - a**6*b**2*c**7 +
        (zeta3 - 2)*a**5*b**3*c**7 + (4/3*zeta3 - 7/3)*a**4*b**4*c**7
        + (zeta3 - 2)*a**3*b**5*c**7 - a**2*b**6*c**7 + (-zeta3 +
        1)*a**6*b**5*c**2*s**2 + (-zeta3 + 1)*a**5*b**6*c**2*s**2 +
        (-16/3*zeta3 + 7/3)*a**6*b**4*c**3*s**2 + (-35/3*zeta3 +
        14/3)*a**5*b**5*c**3*s**2 + (-16/3*zeta3 +
        7/3)*a**4*b**6*c**3*s**2 + (-16/3*zeta3 +
        7/3)*a**6*b**3*c**4*s**2 + (-71/3*zeta3 +
        20/3)*a**5*b**4*c**4*s**2 + (-71/3*zeta3 +
        20/3)*a**4*b**5*c**4*s**2 + (-16/3*zeta3 +
        7/3)*a**3*b**6*c**4*s**2 + (-zeta3 + 1)*a**6*b**2*c**5*s**2 +
        (-35/3*zeta3 + 14/3)*a**5*b**3*c**5*s**2 + (-71/3*zeta3 +
        20/3)*a**4*b**4*c**5*s**2 + (-35/3*zeta3 +
        14/3)*a**3*b**5*c**5*s**2 + (-zeta3 + 1)*a**2*b**6*c**5*s**2 +
        (-zeta3 + 1)*a**5*b**2*c**6*s**2 + (-16/3*zeta3 +
        7/3)*a**4*b**3*c**6*s**2 + (-16/3*zeta3 +
        7/3)*a**3*b**4*c**6*s**2 + (-zeta3 +
        1)*a**2*b**5*c**6*s**2)/(a**8*b**6*s - a**7*b**7*s +
        a**6*b**8*s + (-zeta3)*a**9*b**4*c*s + zeta3*a**8*b**5*c*s +
        (-zeta3)*a**7*b**6*c*s + (-zeta3)*a**6*b**7*c*s +
        zeta3*a**5*b**8*c*s + (-zeta3)*a**4*b**9*c*s -
        a**7*b**5*c**2*s + a**6*b**6*c**2*s - a**5*b**7*c**2*s +
        (zeta3 + 2)*a**8*b**3*c**3*s + (-zeta3 - 1)*a**7*b**4*c**3*s +
        (zeta3 + 2)*a**6*b**5*c**3*s + (zeta3 + 2)*a**5*b**6*c**3*s +
        (-zeta3 - 1)*a**4*b**7*c**3*s + (zeta3 + 2)*a**3*b**8*c**3*s +
        (-zeta3)*a**9*b*c**4*s + (-zeta3 - 1)*a**7*b**3*c**4*s +
        (-3*zeta3)*a**6*b**4*c**4*s + (zeta3 - 1)*a**5*b**5*c**4*s +
        (-3*zeta3)*a**4*b**6*c**4*s + (-zeta3 - 1)*a**3*b**7*c**4*s +
        (-zeta3)*a*b**9*c**4*s + zeta3*a**8*b*c**5*s -
        a**7*b**2*c**5*s + (zeta3 + 2)*a**6*b**3*c**5*s + (zeta3 -
        1)*a**5*b**4*c**5*s + (zeta3 - 1)*a**4*b**5*c**5*s + (zeta3 +
        2)*a**3*b**6*c**5*s - a**2*b**7*c**5*s + zeta3*a*b**8*c**5*s +
        a**8*c**6*s + (-zeta3)*a**7*b*c**6*s + a**6*b**2*c**6*s +
        (zeta3 + 2)*a**5*b**3*c**6*s + (-3*zeta3)*a**4*b**4*c**6*s +
        (zeta3 + 2)*a**3*b**5*c**6*s + a**2*b**6*c**6*s +
        (-zeta3)*a*b**7*c**6*s + b**8*c**6*s - a**7*c**7*s +
        (-zeta3)*a**6*b*c**7*s - a**5*b**2*c**7*s + (-zeta3 -
        1)*a**4*b**3*c**7*s + (-zeta3 - 1)*a**3*b**4*c**7*s -
        a**2*b**5*c**7*s + (-zeta3)*a*b**6*c**7*s - b**7*c**7*s +
        a**6*c**8*s + zeta3*a**5*b*c**8*s + (zeta3 +
        2)*a**3*b**3*c**8*s + zeta3*a*b**5*c**8*s + b**6*c**8*s +
        (-zeta3)*a**4*b*c**9*s + (-zeta3)*a*b**4*c**9*s)], 'K6':
        [(2*a**18*b**5*c**2 + 2*a**17*b**6*c**2 + 5*a**18*b**4*c**3 +
        8*a**17*b**5*c**3 + 5*a**16*b**6*c**3 + 5*a**18*b**3*c**4 +
        12*a**17*b**4*c**4 + 14*a**16*b**5*c**4 + 3*a**15*b**6*c**4 +
        a**14*b**7*c**4 - a**13*b**8*c**4 + 2*a**18*b**2*c**5 +
        8*a**17*b**3*c**5 + 14*a**16*b**4*c**5 + 6*a**15*b**5*c**5 +
        4*a**14*b**6*c**5 - 3*a**13*b**7*c**5 + a**12*b**8*c**5 -
        a**11*b**9*c**5 + 2*a**17*b**2*c**6 + 5*a**16*b**3*c**6 +
        3*a**15*b**4*c**6 + 4*a**14*b**5*c**6 - 3*a**13*b**6*c**6 +
        2*a**12*b**7*c**6 - 2*a**11*b**8*c**6 + a**10*b**9*c**6 +
        a**14*b**4*c**7 - 3*a**13*b**5*c**7 + 2*a**12*b**6*c**7 -
        3*a**11*b**7*c**7 + 2*a**10*b**8*c**7 + a**9*b**9*c**7 +
        a**8*b**10*c**7 - a**13*b**4*c**8 + a**12*b**5*c**8 -
        2*a**11*b**6*c**8 + 2*a**10*b**7*c**8 + 2*a**9*b**8*c**8 +
        3*a**8*b**9*c**8 + a**7*b**10*c**8 - a**11*b**5*c**9 +
        a**10*b**6*c**9 + a**9*b**7*c**9 + 3*a**8*b**8*c**9 +
        2*a**7*b**9*c**9 + a**8*b**7*c**10 + a**7*b**8*c**10)/(a**25*b
        - 3*a**24*b**2 + 5*a**23*b**3 - 6*a**22*b**4 + 5*a**21*b**5 -
        3*a**20*b**6 + a**19*b**7 + a**25*c - 5*a**24*b*c +
        13*a**23*b**2*c - 23*a**22*b**3*c + 30*a**21*b**4*c -
        30*a**20*b**5*c + 23*a**19*b**6*c - 13*a**18*b**7*c +
        5*a**17*b**8*c - a**16*b**9*c - 3*a**24*c**2 + 13*a**23*b*c**2
        - 33*a**22*b**2*c**2 + 60*a**21*b**3*c**2 - 83*a**20*b**4*c**2
        + 91*a**19*b**5*c**2 - 79*a**18*b**6*c**2 + 54*a**17*b**7*c**2
        - 28*a**16*b**8*c**2 + 10*a**15*b**9*c**2 - 2*a**14*b**10*c**2
        + 5*a**23*c**3 - 23*a**22*b*c**3 + 60*a**21*b**2*c**3 -
        113*a**20*b**3*c**3 + 164*a**19*b**4*c**3 -
        191*a**18*b**5*c**3 + 180*a**17*b**6*c**3 -
        137*a**16*b**7*c**3 + 83*a**15*b**8*c**3 - 38*a**14*b**9*c**3
        + 12*a**13*b**10*c**3 - 2*a**12*b**11*c**3 - 6*a**22*c**4 +
        30*a**21*b*c**4 - 83*a**20*b**2*c**4 + 164*a**19*b**3*c**4 -
        250*a**18*b**4*c**4 + 307*a**17*b**5*c**4 -
        308*a**16*b**6*c**4 + 253*a**15*b**7*c**4 -
        169*a**14*b**8*c**4 + 89*a**13*b**9*c**4 - 35*a**12*b**10*c**4
        + 9*a**11*b**11*c**4 - a**10*b**12*c**4 + 5*a**21*c**5 -
        30*a**20*b*c**5 + 91*a**19*b**2*c**5 - 191*a**18*b**3*c**5 +
        307*a**17*b**4*c**5 - 395*a**16*b**5*c**5 +
        417*a**15*b**6*c**5 - 363*a**14*b**7*c**5 +
        260*a**13*b**8*c**5 - 151*a**12*b**9*c**5 +
        68*a**11*b**10*c**5 - 22*a**10*b**11*c**5 + 4*a**9*b**12*c**5
        - 3*a**20*c**6 + 23*a**19*b*c**6 - 79*a**18*b**2*c**6 +
        180*a**17*b**3*c**6 - 308*a**16*b**4*c**6 +
        417*a**15*b**5*c**6 - 461*a**14*b**6*c**6 +
        420*a**13*b**7*c**6 - 316*a**12*b**8*c**6 +
        195*a**11*b**9*c**6 - 96*a**10*b**10*c**6 + 36*a**9*b**11*c**6
        - 9*a**8*b**12*c**6 + a**7*b**13*c**6 + a**19*c**7 -
        13*a**18*b*c**7 + 54*a**17*b**2*c**7 - 137*a**16*b**3*c**7 +
        253*a**15*b**4*c**7 - 363*a**14*b**5*c**7 +
        420*a**13*b**6*c**7 - 398*a**12*b**7*c**7 +
        310*a**11*b**8*c**7 - 198*a**10*b**9*c**7 +
        102*a**9*b**10*c**7 - 41*a**8*b**11*c**7 + 12*a**7*b**12*c**7
        - 2*a**6*b**13*c**7 + 5*a**17*b*c**8 - 28*a**16*b**2*c**8 +
        83*a**15*b**3*c**8 - 169*a**14*b**4*c**8 + 260*a**13*b**5*c**8
        - 316*a**12*b**6*c**8 + 310*a**11*b**7*c**8 -
        247*a**10*b**8*c**8 + 159*a**9*b**9*c**8 - 82*a**8*b**10*c**8
        + 33*a**7*b**11*c**8 - 10*a**6*b**12*c**8 + 2*a**5*b**13*c**8
        - a**16*b*c**9 + 10*a**15*b**2*c**9 - 38*a**14*b**3*c**9 +
        89*a**13*b**4*c**9 - 151*a**12*b**5*c**9 + 195*a**11*b**6*c**9
        - 198*a**10*b**7*c**9 + 159*a**9*b**8*c**9 - 99*a**8*b**9*c**9
        + 47*a**7*b**10*c**9 - 16*a**6*b**11*c**9 + 4*a**5*b**12*c**9
        - a**4*b**13*c**9 - 2*a**14*b**2*c**10 + 12*a**13*b**3*c**10 -
        35*a**12*b**4*c**10 + 68*a**11*b**5*c**10 -
        96*a**10*b**6*c**10 + 102*a**9*b**7*c**10 - 82*a**8*b**8*c**10
        + 47*a**7*b**9*c**10 - 16*a**6*b**10*c**10 +
        3*a**4*b**12*c**10 - a**3*b**13*c**10 - 2*a**12*b**3*c**11 +
        9*a**11*b**4*c**11 - 22*a**10*b**5*c**11 + 36*a**9*b**6*c**11
        - 41*a**8*b**7*c**11 + 33*a**7*b**8*c**11 - 16*a**6*b**9*c**11
        + 7*a**4*b**11*c**11 - 6*a**3*b**12*c**11 + 2*a**2*b**13*c**11
        - a**10*b**4*c**12 + 4*a**9*b**5*c**12 - 9*a**8*b**6*c**12 +
        12*a**7*b**7*c**12 - 10*a**6*b**8*c**12 + 4*a**5*b**9*c**12 +
        3*a**4*b**10*c**12 - 6*a**3*b**11*c**12 + 5*a**2*b**12*c**12 -
        2*a*b**13*c**12 + a**7*b**6*c**13 - 2*a**6*b**7*c**13 +
        2*a**5*b**8*c**13 - a**4*b**9*c**13 - a**3*b**10*c**13 +
        2*a**2*b**11*c**13 - 2*a*b**12*c**13 + b**13*c**13),
        (a**10*b**8*c**7 + 2*a**9*b**9*c**7 + a**8*b**10*c**7 +
        a**10*b**7*c**8 + 3*a**9*b**8*c**8 + 3*a**8*b**9*c**8 +
        a**7*b**10*c**8 + a**9*b**7*c**9 + 2*a**8*b**8*c**9 +
        a**7*b**9*c**9 + a**9*b**6*c**10 + 2*a**8*b**7*c**10 +
        2*a**7*b**8*c**10 + a**6*b**9*c**10 - a**9*b**5*c**11 -
        2*a**8*b**6*c**11 - 3*a**7*b**7*c**11 - 2*a**6*b**8*c**11 -
        a**5*b**9*c**11 + a**8*b**5*c**12 + 2*a**7*b**6*c**12 +
        2*a**6*b**7*c**12 + a**5*b**8*c**12 - a**8*b**4*c**13 -
        3*a**7*b**5*c**13 - 3*a**6*b**6*c**13 - 3*a**5*b**7*c**13 -
        a**4*b**8*c**13 + a**7*b**4*c**14 + 4*a**6*b**5*c**14 +
        4*a**5*b**6*c**14 + a**4*b**7*c**14 + 3*a**6*b**4*c**15 +
        6*a**5*b**5*c**15 + 3*a**4*b**6*c**15 + 5*a**6*b**3*c**16 +
        14*a**5*b**4*c**16 + 14*a**4*b**5*c**16 + 5*a**3*b**6*c**16 +
        2*a**6*b**2*c**17 + 8*a**5*b**3*c**17 + 12*a**4*b**4*c**17 +
        8*a**3*b**5*c**17 + 2*a**2*b**6*c**17 + 2*a**5*b**2*c**18 +
        5*a**4*b**3*c**18 + 5*a**3*b**4*c**18 +
        2*a**2*b**5*c**18)/(a**13*b**13 - 2*a**13*b**12*c -
        2*a**12*b**13*c + 2*a**13*b**11*c**2 + 5*a**12*b**12*c**2 +
        2*a**11*b**13*c**2 - a**13*b**10*c**3 - 6*a**12*b**11*c**3 -
        6*a**11*b**12*c**3 - a**10*b**13*c**3 - a**13*b**9*c**4 +
        3*a**12*b**10*c**4 + 7*a**11*b**11*c**4 + 3*a**10*b**12*c**4 -
        a**9*b**13*c**4 + 2*a**13*b**8*c**5 + 4*a**12*b**9*c**5 +
        4*a**9*b**12*c**5 + 2*a**8*b**13*c**5 - 2*a**13*b**7*c**6 -
        10*a**12*b**8*c**6 - 16*a**11*b**9*c**6 - 16*a**10*b**10*c**6
        - 16*a**9*b**11*c**6 - 10*a**8*b**12*c**6 - 2*a**7*b**13*c**6
        + a**13*b**6*c**7 + 12*a**12*b**7*c**7 + 33*a**11*b**8*c**7 +
        47*a**10*b**9*c**7 + 47*a**9*b**10*c**7 + 33*a**8*b**11*c**7 +
        12*a**7*b**12*c**7 + a**6*b**13*c**7 - 9*a**12*b**6*c**8 -
        41*a**11*b**7*c**8 - 82*a**10*b**8*c**8 - 99*a**9*b**9*c**8 -
        82*a**8*b**10*c**8 - 41*a**7*b**11*c**8 - 9*a**6*b**12*c**8 +
        4*a**12*b**5*c**9 + 36*a**11*b**6*c**9 + 102*a**10*b**7*c**9 +
        159*a**9*b**8*c**9 + 159*a**8*b**9*c**9 + 102*a**7*b**10*c**9
        + 36*a**6*b**11*c**9 + 4*a**5*b**12*c**9 - a**12*b**4*c**10 -
        22*a**11*b**5*c**10 - 96*a**10*b**6*c**10 -
        198*a**9*b**7*c**10 - 247*a**8*b**8*c**10 -
        198*a**7*b**9*c**10 - 96*a**6*b**10*c**10 -
        22*a**5*b**11*c**10 - a**4*b**12*c**10 + 9*a**11*b**4*c**11 +
        68*a**10*b**5*c**11 + 195*a**9*b**6*c**11 +
        310*a**8*b**7*c**11 + 310*a**7*b**8*c**11 +
        195*a**6*b**9*c**11 + 68*a**5*b**10*c**11 + 9*a**4*b**11*c**11
        - 2*a**11*b**3*c**12 - 35*a**10*b**4*c**12 -
        151*a**9*b**5*c**12 - 316*a**8*b**6*c**12 -
        398*a**7*b**7*c**12 - 316*a**6*b**8*c**12 -
        151*a**5*b**9*c**12 - 35*a**4*b**10*c**12 - 2*a**3*b**11*c**12
        + 12*a**10*b**3*c**13 + 89*a**9*b**4*c**13 +
        260*a**8*b**5*c**13 + 420*a**7*b**6*c**13 +
        420*a**6*b**7*c**13 + 260*a**5*b**8*c**13 + 89*a**4*b**9*c**13
        + 12*a**3*b**10*c**13 - 2*a**10*b**2*c**14 -
        38*a**9*b**3*c**14 - 169*a**8*b**4*c**14 - 363*a**7*b**5*c**14
        - 461*a**6*b**6*c**14 - 363*a**5*b**7*c**14 -
        169*a**4*b**8*c**14 - 38*a**3*b**9*c**14 - 2*a**2*b**10*c**14
        + 10*a**9*b**2*c**15 + 83*a**8*b**3*c**15 +
        253*a**7*b**4*c**15 + 417*a**6*b**5*c**15 +
        417*a**5*b**6*c**15 + 253*a**4*b**7*c**15 + 83*a**3*b**8*c**15
        + 10*a**2*b**9*c**15 - a**9*b*c**16 - 28*a**8*b**2*c**16 -
        137*a**7*b**3*c**16 - 308*a**6*b**4*c**16 -
        395*a**5*b**5*c**16 - 308*a**4*b**6*c**16 -
        137*a**3*b**7*c**16 - 28*a**2*b**8*c**16 - a*b**9*c**16 +
        5*a**8*b*c**17 + 54*a**7*b**2*c**17 + 180*a**6*b**3*c**17 +
        307*a**5*b**4*c**17 + 307*a**4*b**5*c**17 +
        180*a**3*b**6*c**17 + 54*a**2*b**7*c**17 + 5*a*b**8*c**17 -
        13*a**7*b*c**18 - 79*a**6*b**2*c**18 - 191*a**5*b**3*c**18 -
        250*a**4*b**4*c**18 - 191*a**3*b**5*c**18 - 79*a**2*b**6*c**18
        - 13*a*b**7*c**18 + a**7*c**19 + 23*a**6*b*c**19 +
        91*a**5*b**2*c**19 + 164*a**4*b**3*c**19 + 164*a**3*b**4*c**19
        + 91*a**2*b**5*c**19 + 23*a*b**6*c**19 + b**7*c**19 -
        3*a**6*c**20 - 30*a**5*b*c**20 - 83*a**4*b**2*c**20 -
        113*a**3*b**3*c**20 - 83*a**2*b**4*c**20 - 30*a*b**5*c**20 -
        3*b**6*c**20 + 5*a**5*c**21 + 30*a**4*b*c**21 +
        60*a**3*b**2*c**21 + 60*a**2*b**3*c**21 + 30*a*b**4*c**21 +
        5*b**5*c**21 - 6*a**4*c**22 - 23*a**3*b*c**22 -
        33*a**2*b**2*c**22 - 23*a*b**3*c**22 - 6*b**4*c**22 +
        5*a**3*c**23 + 13*a**2*b*c**23 + 13*a*b**2*c**23 +
        5*b**3*c**23 - 3*a**2*c**24 - 5*a*b*c**24 - 3*b**2*c**24 +
        a*c**25 + b*c**25), (2*a**6*b**17*c**2 + 2*a**5*b**18*c**2 +
        5*a**6*b**16*c**3 + 8*a**5*b**17*c**3 + 5*a**4*b**18*c**3 -
        a**8*b**13*c**4 + a**7*b**14*c**4 + 3*a**6*b**15*c**4 +
        14*a**5*b**16*c**4 + 12*a**4*b**17*c**4 + 5*a**3*b**18*c**4 -
        a**9*b**11*c**5 + a**8*b**12*c**5 - 3*a**7*b**13*c**5 +
        4*a**6*b**14*c**5 + 6*a**5*b**15*c**5 + 14*a**4*b**16*c**5 +
        8*a**3*b**17*c**5 + 2*a**2*b**18*c**5 + a**9*b**10*c**6 -
        2*a**8*b**11*c**6 + 2*a**7*b**12*c**6 - 3*a**6*b**13*c**6 +
        4*a**5*b**14*c**6 + 3*a**4*b**15*c**6 + 5*a**3*b**16*c**6 +
        2*a**2*b**17*c**6 + a**10*b**8*c**7 + a**9*b**9*c**7 +
        2*a**8*b**10*c**7 - 3*a**7*b**11*c**7 + 2*a**6*b**12*c**7 -
        3*a**5*b**13*c**7 + a**4*b**14*c**7 + a**10*b**7*c**8 +
        3*a**9*b**8*c**8 + 2*a**8*b**9*c**8 + 2*a**7*b**10*c**8 -
        2*a**6*b**11*c**8 + a**5*b**12*c**8 - a**4*b**13*c**8 +
        2*a**9*b**7*c**9 + 3*a**8*b**8*c**9 + a**7*b**9*c**9 +
        a**6*b**10*c**9 - a**5*b**11*c**9 + a**8*b**7*c**10 +
        a**7*b**8*c**10)/(a**7*b**19 - 3*a**6*b**20 + 5*a**5*b**21 -
        6*a**4*b**22 + 5*a**3*b**23 - 3*a**2*b**24 + a*b**25 -
        a**9*b**16*c + 5*a**8*b**17*c - 13*a**7*b**18*c +
        23*a**6*b**19*c - 30*a**5*b**20*c + 30*a**4*b**21*c -
        23*a**3*b**22*c + 13*a**2*b**23*c - 5*a*b**24*c + b**25*c -
        2*a**10*b**14*c**2 + 10*a**9*b**15*c**2 - 28*a**8*b**16*c**2 +
        54*a**7*b**17*c**2 - 79*a**6*b**18*c**2 + 91*a**5*b**19*c**2 -
        83*a**4*b**20*c**2 + 60*a**3*b**21*c**2 - 33*a**2*b**22*c**2 +
        13*a*b**23*c**2 - 3*b**24*c**2 - 2*a**11*b**12*c**3 +
        12*a**10*b**13*c**3 - 38*a**9*b**14*c**3 + 83*a**8*b**15*c**3
        - 137*a**7*b**16*c**3 + 180*a**6*b**17*c**3 -
        191*a**5*b**18*c**3 + 164*a**4*b**19*c**3 -
        113*a**3*b**20*c**3 + 60*a**2*b**21*c**3 - 23*a*b**22*c**3 +
        5*b**23*c**3 - a**12*b**10*c**4 + 9*a**11*b**11*c**4 -
        35*a**10*b**12*c**4 + 89*a**9*b**13*c**4 - 169*a**8*b**14*c**4
        + 253*a**7*b**15*c**4 - 308*a**6*b**16*c**4 +
        307*a**5*b**17*c**4 - 250*a**4*b**18*c**4 +
        164*a**3*b**19*c**4 - 83*a**2*b**20*c**4 + 30*a*b**21*c**4 -
        6*b**22*c**4 + 4*a**12*b**9*c**5 - 22*a**11*b**10*c**5 +
        68*a**10*b**11*c**5 - 151*a**9*b**12*c**5 +
        260*a**8*b**13*c**5 - 363*a**7*b**14*c**5 +
        417*a**6*b**15*c**5 - 395*a**5*b**16*c**5 +
        307*a**4*b**17*c**5 - 191*a**3*b**18*c**5 + 91*a**2*b**19*c**5
        - 30*a*b**20*c**5 + 5*b**21*c**5 + a**13*b**7*c**6 -
        9*a**12*b**8*c**6 + 36*a**11*b**9*c**6 - 96*a**10*b**10*c**6 +
        195*a**9*b**11*c**6 - 316*a**8*b**12*c**6 +
        420*a**7*b**13*c**6 - 461*a**6*b**14*c**6 +
        417*a**5*b**15*c**6 - 308*a**4*b**16*c**6 +
        180*a**3*b**17*c**6 - 79*a**2*b**18*c**6 + 23*a*b**19*c**6 -
        3*b**20*c**6 - 2*a**13*b**6*c**7 + 12*a**12*b**7*c**7 -
        41*a**11*b**8*c**7 + 102*a**10*b**9*c**7 - 198*a**9*b**10*c**7
        + 310*a**8*b**11*c**7 - 398*a**7*b**12*c**7 +
        420*a**6*b**13*c**7 - 363*a**5*b**14*c**7 +
        253*a**4*b**15*c**7 - 137*a**3*b**16*c**7 + 54*a**2*b**17*c**7
        - 13*a*b**18*c**7 + b**19*c**7 + 2*a**13*b**5*c**8 -
        10*a**12*b**6*c**8 + 33*a**11*b**7*c**8 - 82*a**10*b**8*c**8 +
        159*a**9*b**9*c**8 - 247*a**8*b**10*c**8 + 310*a**7*b**11*c**8
        - 316*a**6*b**12*c**8 + 260*a**5*b**13*c**8 -
        169*a**4*b**14*c**8 + 83*a**3*b**15*c**8 - 28*a**2*b**16*c**8
        + 5*a*b**17*c**8 - a**13*b**4*c**9 + 4*a**12*b**5*c**9 -
        16*a**11*b**6*c**9 + 47*a**10*b**7*c**9 - 99*a**9*b**8*c**9 +
        159*a**8*b**9*c**9 - 198*a**7*b**10*c**9 + 195*a**6*b**11*c**9
        - 151*a**5*b**12*c**9 + 89*a**4*b**13*c**9 -
        38*a**3*b**14*c**9 + 10*a**2*b**15*c**9 - a*b**16*c**9 -
        a**13*b**3*c**10 + 3*a**12*b**4*c**10 - 16*a**10*b**6*c**10 +
        47*a**9*b**7*c**10 - 82*a**8*b**8*c**10 + 102*a**7*b**9*c**10
        - 96*a**6*b**10*c**10 + 68*a**5*b**11*c**10 -
        35*a**4*b**12*c**10 + 12*a**3*b**13*c**10 - 2*a**2*b**14*c**10
        + 2*a**13*b**2*c**11 - 6*a**12*b**3*c**11 + 7*a**11*b**4*c**11
        - 16*a**9*b**6*c**11 + 33*a**8*b**7*c**11 - 41*a**7*b**8*c**11
        + 36*a**6*b**9*c**11 - 22*a**5*b**10*c**11 +
        9*a**4*b**11*c**11 - 2*a**3*b**12*c**11 - 2*a**13*b*c**12 +
        5*a**12*b**2*c**12 - 6*a**11*b**3*c**12 + 3*a**10*b**4*c**12 +
        4*a**9*b**5*c**12 - 10*a**8*b**6*c**12 + 12*a**7*b**7*c**12 -
        9*a**6*b**8*c**12 + 4*a**5*b**9*c**12 - a**4*b**10*c**12 +
        a**13*c**13 - 2*a**12*b*c**13 + 2*a**11*b**2*c**13 -
        a**10*b**3*c**13 - a**9*b**4*c**13 + 2*a**8*b**5*c**13 -
        2*a**7*b**6*c**13 + a**6*b**7*c**13), (a**10*b**4*c**3 +
        a**9*b**5*c**3 - a**7*b**7*c**3 + a**10*b**3*c**4 +
        4*a**9*b**4*c**4 + 3*a**8*b**5*c**4 + a**6*b**7*c**4 +
        a**5*b**8*c**4 + a**9*b**3*c**5 + 3*a**8*b**4*c**5 +
        3*a**7*b**5*c**5 + 5*a**6*b**6*c**5 + 8*a**5*b**7*c**5 +
        4*a**4*b**8*c**5 + 5*a**6*b**5*c**6 + 13*a**5*b**6*c**6 +
        13*a**4*b**7*c**6 + 5*a**3*b**8*c**6 - a**7*b**3*c**7 +
        a**6*b**4*c**7 + 8*a**5*b**5*c**7 + 13*a**4*b**6*c**7 +
        8*a**3*b**7*c**7 + 2*a**2*b**8*c**7 + a**5*b**4*c**8 +
        4*a**4*b**5*c**8 + 5*a**3*b**6*c**8 +
        2*a**2*b**7*c**8)/(a**13*b**5 - a**12*b**6 - a**11*b**7 +
        a**10*b**8 - 2*a**13*b**4*c + 2*a**12*b**5*c + 4*a**11*b**6*c
        - 4*a**10*b**7*c - 2*a**9*b**8*c + 2*a**8*b**9*c +
        a**13*b**3*c**2 - 2*a**12*b**4*c**2 - 6*a**11*b**5*c**2 +
        8*a**10*b**6*c**2 + 7*a**9*b**7*c**2 - 8*a**8*b**8*c**2 -
        2*a**7*b**9*c**2 + 2*a**6*b**10*c**2 + a**13*b**2*c**3 +
        2*a**12*b**3*c**3 + 3*a**11*b**4*c**3 - 11*a**10*b**5*c**3 -
        10*a**9*b**6*c**3 + 17*a**8*b**7*c**3 + 7*a**7*b**8*c**3 -
        9*a**6*b**9*c**3 - a**5*b**10*c**3 + a**4*b**11*c**3 -
        2*a**13*b*c**4 - 2*a**12*b**2*c**4 + 3*a**11*b**3*c**4 +
        12*a**10*b**4*c**4 + 5*a**9*b**5*c**4 - 25*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 + 21*a**6*b**8*c**4 + 4*a**5*b**9*c**4 -
        6*a**4*b**10*c**4 + a**13*c**5 + 2*a**12*b*c**5 -
        6*a**11*b**2*c**5 - 11*a**10*b**3*c**5 + 5*a**9*b**4*c**5 +
        28*a**8*b**5*c**5 + 5*a**7*b**6*c**5 - 33*a**6*b**7*c**5 -
        6*a**5*b**8*c**5 + 16*a**4*b**9*c**5 + a**3*b**10*c**5 -
        2*a**2*b**11*c**5 - a**12*c**6 + 4*a**11*b*c**6 +
        8*a**10*b**2*c**6 - 10*a**9*b**3*c**6 - 25*a**8*b**4*c**6 +
        5*a**7*b**5*c**6 + 38*a**6*b**6*c**6 + 3*a**5*b**7*c**6 -
        27*a**4*b**8*c**6 - 2*a**3*b**9*c**6 + 7*a**2*b**10*c**6 -
        a**11*c**7 - 4*a**10*b*c**7 + 7*a**9*b**2*c**7 +
        17*a**8*b**3*c**7 - 10*a**7*b**4*c**7 - 33*a**6*b**5*c**7 +
        3*a**5*b**6*c**7 + 32*a**4*b**7*c**7 + a**3*b**8*c**7 -
        13*a**2*b**9*c**7 + b**11*c**7 + a**10*c**8 - 2*a**9*b*c**8 -
        8*a**8*b**2*c**8 + 7*a**7*b**3*c**8 + 21*a**6*b**4*c**8 -
        6*a**5*b**5*c**8 - 27*a**4*b**6*c**8 + a**3*b**7*c**8 +
        16*a**2*b**8*c**8 - 3*b**10*c**8 + 2*a**8*b*c**9 -
        2*a**7*b**2*c**9 - 9*a**6*b**3*c**9 + 4*a**5*b**4*c**9 +
        16*a**4*b**5*c**9 - 2*a**3*b**6*c**9 - 13*a**2*b**7*c**9 +
        4*b**9*c**9 + 2*a**6*b**2*c**10 - a**5*b**3*c**10 -
        6*a**4*b**4*c**10 + a**3*b**5*c**10 + 7*a**2*b**6*c**10 -
        3*b**8*c**10 + a**4*b**3*c**11 - 2*a**2*b**5*c**11 +
        b**7*c**11), (2*a**8*b**7*c**2 + 2*a**7*b**8*c**2 +
        5*a**8*b**6*c**3 + 8*a**7*b**7*c**3 + 5*a**6*b**8*c**3 +
        4*a**8*b**5*c**4 + 13*a**7*b**6*c**4 + 13*a**6*b**7*c**4 +
        4*a**5*b**8*c**4 + a**8*b**4*c**5 + 8*a**7*b**5*c**5 +
        13*a**6*b**6*c**5 + 8*a**5*b**7*c**5 + a**4*b**8*c**5 +
        a**7*b**4*c**6 + 5*a**6*b**5*c**6 + 5*a**5*b**6*c**6 +
        a**4*b**7*c**6 - a**7*b**3*c**7 + 3*a**5*b**5*c**7 -
        a**3*b**7*c**7 + 3*a**5*b**4*c**8 + 3*a**4*b**5*c**8 +
        a**5*b**3*c**9 + 4*a**4*b**4*c**9 + a**3*b**5*c**9 +
        a**4*b**3*c**10 + a**3*b**4*c**10)/(a**11*b**7 - 3*a**10*b**8
        + 4*a**9*b**9 - 3*a**8*b**10 + a**7*b**11 - 2*a**11*b**5*c**2
        + 7*a**10*b**6*c**2 - 13*a**9*b**7*c**2 + 16*a**8*b**8*c**2 -
        13*a**7*b**9*c**2 + 7*a**6*b**10*c**2 - 2*a**5*b**11*c**2 +
        a**10*b**5*c**3 - 2*a**9*b**6*c**3 + a**8*b**7*c**3 +
        a**7*b**8*c**3 - 2*a**6*b**9*c**3 + a**5*b**10*c**3 +
        a**11*b**3*c**4 - 6*a**10*b**4*c**4 + 16*a**9*b**5*c**4 -
        27*a**8*b**6*c**4 + 32*a**7*b**7*c**4 - 27*a**6*b**8*c**4 +
        16*a**5*b**9*c**4 - 6*a**4*b**10*c**4 + a**3*b**11*c**4 -
        a**10*b**3*c**5 + 4*a**9*b**4*c**5 - 6*a**8*b**5*c**5 +
        3*a**7*b**6*c**5 + 3*a**6*b**7*c**5 - 6*a**5*b**8*c**5 +
        4*a**4*b**9*c**5 - a**3*b**10*c**5 + 2*a**10*b**2*c**6 -
        9*a**9*b**3*c**6 + 21*a**8*b**4*c**6 - 33*a**7*b**5*c**6 +
        38*a**6*b**6*c**6 - 33*a**5*b**7*c**6 + 21*a**4*b**8*c**6 -
        9*a**3*b**9*c**6 + 2*a**2*b**10*c**6 - 2*a**9*b**2*c**7 +
        7*a**8*b**3*c**7 - 10*a**7*b**4*c**7 + 5*a**6*b**5*c**7 +
        5*a**5*b**6*c**7 - 10*a**4*b**7*c**7 + 7*a**3*b**8*c**7 -
        2*a**2*b**9*c**7 + 2*a**9*b*c**8 - 8*a**8*b**2*c**8 +
        17*a**7*b**3*c**8 - 25*a**6*b**4*c**8 + 28*a**5*b**5*c**8 -
        25*a**4*b**6*c**8 + 17*a**3*b**7*c**8 - 8*a**2*b**8*c**8 +
        2*a*b**9*c**8 - 2*a**8*b*c**9 + 7*a**7*b**2*c**9 -
        10*a**6*b**3*c**9 + 5*a**5*b**4*c**9 + 5*a**4*b**5*c**9 -
        10*a**3*b**6*c**9 + 7*a**2*b**7*c**9 - 2*a*b**8*c**9 +
        a**8*c**10 - 4*a**7*b*c**10 + 8*a**6*b**2*c**10 -
        11*a**5*b**3*c**10 + 12*a**4*b**4*c**10 - 11*a**3*b**5*c**10 +
        8*a**2*b**6*c**10 - 4*a*b**7*c**10 + b**8*c**10 - a**7*c**11 +
        4*a**6*b*c**11 - 6*a**5*b**2*c**11 + 3*a**4*b**3*c**11 +
        3*a**3*b**4*c**11 - 6*a**2*b**5*c**11 + 4*a*b**6*c**11 -
        b**7*c**11 - a**6*c**12 + 2*a**5*b*c**12 - 2*a**4*b**2*c**12 +
        2*a**3*b**3*c**12 - 2*a**2*b**4*c**12 + 2*a*b**5*c**12 -
        b**6*c**12 + a**5*c**13 - 2*a**4*b*c**13 + a**3*b**2*c**13 +
        a**2*b**3*c**13 - 2*a*b**4*c**13 + b**5*c**13),
        (-a**7*b**7*c**3 + a**5*b**9*c**3 + a**4*b**10*c**3 +
        a**8*b**5*c**4 + a**7*b**6*c**4 + 3*a**5*b**8*c**4 +
        4*a**4*b**9*c**4 + a**3*b**10*c**4 + 4*a**8*b**4*c**5 +
        8*a**7*b**5*c**5 + 5*a**6*b**6*c**5 + 3*a**5*b**7*c**5 +
        3*a**4*b**8*c**5 + a**3*b**9*c**5 + 5*a**8*b**3*c**6 +
        13*a**7*b**4*c**6 + 13*a**6*b**5*c**6 + 5*a**5*b**6*c**6 +
        2*a**8*b**2*c**7 + 8*a**7*b**3*c**7 + 13*a**6*b**4*c**7 +
        8*a**5*b**5*c**7 + a**4*b**6*c**7 - a**3*b**7*c**7 +
        2*a**7*b**2*c**8 + 5*a**6*b**3*c**8 + 4*a**5*b**4*c**8 +
        a**4*b**5*c**8)/(a**8*b**10 - a**7*b**11 - a**6*b**12 +
        a**5*b**13 + 2*a**9*b**8*c - 2*a**8*b**9*c - 4*a**7*b**10*c +
        4*a**6*b**11*c + 2*a**5*b**12*c - 2*a**4*b**13*c +
        2*a**10*b**6*c**2 - 2*a**9*b**7*c**2 - 8*a**8*b**8*c**2 +
        7*a**7*b**9*c**2 + 8*a**6*b**10*c**2 - 6*a**5*b**11*c**2 -
        2*a**4*b**12*c**2 + a**3*b**13*c**2 + a**11*b**4*c**3 -
        a**10*b**5*c**3 - 9*a**9*b**6*c**3 + 7*a**8*b**7*c**3 +
        17*a**7*b**8*c**3 - 10*a**6*b**9*c**3 - 11*a**5*b**10*c**3 +
        3*a**4*b**11*c**3 + 2*a**3*b**12*c**3 + a**2*b**13*c**3 -
        6*a**10*b**4*c**4 + 4*a**9*b**5*c**4 + 21*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 - 25*a**6*b**8*c**4 + 5*a**5*b**9*c**4 +
        12*a**4*b**10*c**4 + 3*a**3*b**11*c**4 - 2*a**2*b**12*c**4 -
        2*a*b**13*c**4 - 2*a**11*b**2*c**5 + a**10*b**3*c**5 +
        16*a**9*b**4*c**5 - 6*a**8*b**5*c**5 - 33*a**7*b**6*c**5 +
        5*a**6*b**7*c**5 + 28*a**5*b**8*c**5 + 5*a**4*b**9*c**5 -
        11*a**3*b**10*c**5 - 6*a**2*b**11*c**5 + 2*a*b**12*c**5 +
        b**13*c**5 + 7*a**10*b**2*c**6 - 2*a**9*b**3*c**6 -
        27*a**8*b**4*c**6 + 3*a**7*b**5*c**6 + 38*a**6*b**6*c**6 +
        5*a**5*b**7*c**6 - 25*a**4*b**8*c**6 - 10*a**3*b**9*c**6 +
        8*a**2*b**10*c**6 + 4*a*b**11*c**6 - b**12*c**6 + a**11*c**7 -
        13*a**9*b**2*c**7 + a**8*b**3*c**7 + 32*a**7*b**4*c**7 +
        3*a**6*b**5*c**7 - 33*a**5*b**6*c**7 - 10*a**4*b**7*c**7 +
        17*a**3*b**8*c**7 + 7*a**2*b**9*c**7 - 4*a*b**10*c**7 -
        b**11*c**7 - 3*a**10*c**8 + 16*a**8*b**2*c**8 + a**7*b**3*c**8
        - 27*a**6*b**4*c**8 - 6*a**5*b**5*c**8 + 21*a**4*b**6*c**8 +
        7*a**3*b**7*c**8 - 8*a**2*b**8*c**8 - 2*a*b**9*c**8 +
        b**10*c**8 + 4*a**9*c**9 - 13*a**7*b**2*c**9 -
        2*a**6*b**3*c**9 + 16*a**5*b**4*c**9 + 4*a**4*b**5*c**9 -
        9*a**3*b**6*c**9 - 2*a**2*b**7*c**9 + 2*a*b**8*c**9 -
        3*a**8*c**10 + 7*a**6*b**2*c**10 + a**5*b**3*c**10 -
        6*a**4*b**4*c**10 - a**3*b**5*c**10 + 2*a**2*b**6*c**10 +
        a**7*c**11 - 2*a**5*b**2*c**11 + a**3*b**4*c**11),
        (-2*a**6*b**5*c**2 - 2*a**5*b**6*c**2 - 5*a**6*b**4*c**3 -
        9*a**5*b**5*c**3 - 5*a**4*b**6*c**3 - 5*a**6*b**3*c**4 -
        15*a**5*b**4*c**4 - 15*a**4*b**5*c**4 - 5*a**3*b**6*c**4 -
        2*a**6*b**2*c**5 - 9*a**5*b**3*c**5 - 15*a**4*b**4*c**5 -
        9*a**3*b**5*c**5 - 2*a**2*b**6*c**5 - 2*a**5*b**2*c**6 -
        5*a**4*b**3*c**6 - 5*a**3*b**4*c**6 -
        2*a**2*b**5*c**6)/(a**8*b**6 - 2*a**7*b**7 + a**6*b**8 +
        a**9*b**4*c - 3*a**8*b**5*c + 2*a**7*b**6*c + 2*a**6*b**7*c -
        3*a**5*b**8*c + a**4*b**9*c - a**9*b**3*c**2 +
        5*a**7*b**5*c**2 - 8*a**6*b**6*c**2 + 5*a**5*b**7*c**2 -
        a**3*b**9*c**2 - a**9*b**2*c**3 + 4*a**8*b**3*c**3 -
        5*a**7*b**4*c**3 + 2*a**6*b**5*c**3 + 2*a**5*b**6*c**3 -
        5*a**4*b**7*c**3 + 4*a**3*b**8*c**3 - a**2*b**9*c**3 +
        a**9*b*c**4 - 5*a**7*b**3*c**4 + 6*a**6*b**4*c**4 -
        4*a**5*b**5*c**4 + 6*a**4*b**6*c**4 - 5*a**3*b**7*c**4 +
        a*b**9*c**4 - 3*a**8*b*c**5 + 5*a**7*b**2*c**5 +
        2*a**6*b**3*c**5 - 4*a**5*b**4*c**5 - 4*a**4*b**5*c**5 +
        2*a**3*b**6*c**5 + 5*a**2*b**7*c**5 - 3*a*b**8*c**5 +
        a**8*c**6 + 2*a**7*b*c**6 - 8*a**6*b**2*c**6 +
        2*a**5*b**3*c**6 + 6*a**4*b**4*c**6 + 2*a**3*b**5*c**6 -
        8*a**2*b**6*c**6 + 2*a*b**7*c**6 + b**8*c**6 - 2*a**7*c**7 +
        2*a**6*b*c**7 + 5*a**5*b**2*c**7 - 5*a**4*b**3*c**7 -
        5*a**3*b**4*c**7 + 5*a**2*b**5*c**7 + 2*a*b**6*c**7 -
        2*b**7*c**7 + a**6*c**8 - 3*a**5*b*c**8 + 4*a**3*b**3*c**8 -
        3*a*b**5*c**8 + b**6*c**8 + a**4*b*c**9 - a**3*b**2*c**9 -
        a**2*b**3*c**9 + a*b**4*c**9), (-2*a**6*b**10*c**2 -
        2*a**5*b**11*c**2 - 5*a**6*b**9*c**3 - 8*a**5*b**10*c**3 -
        5*a**4*b**11*c**3 - 4*a**6*b**8*c**4 - 13*a**5*b**9*c**4 -
        12*a**4*b**10*c**4 - 5*a**3*b**11*c**4 - a**6*b**7*c**5 -
        8*a**5*b**8*c**5 - 12*a**4*b**9*c**5 - 8*a**3*b**10*c**5 -
        2*a**2*b**11*c**5 - a**6*b**6*c**6 - a**5*b**7*c**6 -
        5*a**4*b**8*c**6 - 3*a**3*b**9*c**6 - 2*a**2*b**10*c**6 -
        a**6*b**5*c**7 - a**5*b**6*c**7 + a**2*b**9*c**7 -
        3*a**5*b**5*c**8 - 2*a**4*b**6*c**8 - a**3*b**7*c**8 -
        a**5*b**4*c**9 - 3*a**4*b**5*c**9 - a**3*b**6*c**9 -
        a**2*b**7*c**9 - a**4*b**4*c**10 -
        a**3*b**5*c**10)/(a**8*b**11 - 2*a**7*b**12 + 2*a**6*b**13 -
        2*a**5*b**14 + a**4*b**15 + a**9*b**9*c - 3*a**8*b**10*c +
        4*a**7*b**11*c - 4*a**6*b**12*c + 3*a**5*b**13*c -
        a**4*b**14*c - a**9*b**8*c**2 + a**8*b**9*c**2 -
        a**6*b**11*c**2 + 3*a**5*b**12*c**2 - 3*a**4*b**13*c**2 +
        2*a**3*b**14*c**2 - a**2*b**15*c**2 - a**9*b**7*c**3 +
        4*a**8*b**8*c**3 - 7*a**7*b**9*c**3 + 10*a**6*b**10*c**3 -
        11*a**5*b**11*c**3 + 8*a**4*b**12*c**3 - 5*a**3*b**13*c**3 +
        2*a**2*b**14*c**3 + 2*a**9*b**6*c**4 - 5*a**8*b**7*c**4 +
        7*a**7*b**8*c**4 - 10*a**6*b**9*c**4 + 9*a**5*b**10*c**4 -
        5*a**4*b**11*c**4 + 3*a**3*b**12*c**4 - a*b**14*c**4 -
        a**9*b**5*c**5 + 2*a**7*b**7*c**5 - 2*a**6*b**8*c**5 +
        6*a**5*b**9*c**5 - 8*a**4*b**10*c**5 + 6*a**3*b**11*c**5 -
        6*a**2*b**12*c**5 + 3*a*b**13*c**5 - a**9*b**4*c**6 +
        5*a**8*b**5*c**6 - 8*a**7*b**6*c**6 + 11*a**6*b**7*c**6 -
        16*a**5*b**8*c**6 + 15*a**4*b**9*c**6 - 12*a**3*b**10*c**6 +
        9*a**2*b**11*c**6 - 3*a*b**12*c**6 + a**9*b**3*c**7 -
        3*a**8*b**4*c**7 + 3*a**7*b**5*c**7 - 5*a**6*b**6*c**7 +
        8*a**5*b**7*c**7 - 6*a**4*b**8*c**7 + 5*a**3*b**9*c**7 -
        3*a**2*b**10*c**7 - a*b**11*c**7 + b**12*c**7 - a**8*b**3*c**8
        + 4*a**7*b**4*c**8 - 4*a**6*b**5*c**8 + 4*a**5*b**6*c**8 -
        7*a**4*b**7*c**8 + 6*a**3*b**8*c**8 - 6*a**2*b**9*c**8 +
        6*a*b**10*c**8 - 2*b**11*c**8 + 2*a**8*b**2*c**9 -
        4*a**7*b**3*c**9 + 3*a**6*b**4*c**9 - 6*a**5*b**5*c**9 +
        9*a**4*b**6*c**9 - 8*a**3*b**7*c**9 + 9*a**2*b**8*c**9 -
        6*a*b**9*c**9 + b**10*c**9 - a**8*b*c**10 + 2*a**6*b**3*c**10
        + a**5*b**4*c**10 - 2*a**4*b**5*c**10 + 2*a**3*b**6*c**10 -
        4*a**2*b**7*c**10 + a*b**8*c**10 + b**9*c**10 + 2*a**7*b*c**11
        - 3*a**6*b**2*c**11 + a**5*b**3*c**11 - 2*a**4*b**4*c**11 +
        2*a**3*b**5*c**11 - a**2*b**6*c**11 + 3*a*b**7*c**11 -
        2*b**8*c**11 - a**7*c**12 + a**5*b**2*c**12 + a**4*b**3*c**12
        - a**3*b**4*c**12 + 2*a**2*b**5*c**12 - 3*a*b**6*c**12 +
        b**7*c**12 + a**6*c**13 - a**5*b*c**13 - a**2*b**4*c**13 +
        a*b**5*c**13), (-2*a**11*b**5*c**2 - 2*a**10*b**6*c**2 +
        a**9*b**7*c**2 - a**7*b**9*c**2 - 5*a**11*b**4*c**3 -
        8*a**10*b**5*c**3 - 3*a**9*b**6*c**3 - a**7*b**8*c**3 -
        a**6*b**9*c**3 - a**5*b**10*c**3 - 5*a**11*b**3*c**4 -
        12*a**10*b**4*c**4 - 12*a**9*b**5*c**4 - 5*a**8*b**6*c**4 -
        2*a**6*b**8*c**4 - 3*a**5*b**9*c**4 - a**4*b**10*c**4 -
        2*a**11*b**2*c**5 - 8*a**10*b**3*c**5 - 13*a**9*b**4*c**5 -
        8*a**8*b**5*c**5 - a**7*b**6*c**5 - a**6*b**7*c**5 -
        3*a**5*b**8*c**5 - a**4*b**9*c**5 - 2*a**10*b**2*c**6 -
        5*a**9*b**3*c**6 - 4*a**8*b**4*c**6 - a**7*b**5*c**6 -
        a**6*b**6*c**6 - a**5*b**7*c**6)/(a**12*b**7 - 2*a**11*b**8 +
        a**10*b**9 + a**9*b**10 - 2*a**8*b**11 + a**7*b**12 -
        a**14*b**4*c + 3*a**13*b**5*c - 3*a**12*b**6*c - a**11*b**7*c
        + 6*a**10*b**8*c - 6*a**9*b**9*c + a**8*b**10*c +
        3*a**7*b**11*c - 3*a**6*b**12*c + a**5*b**13*c -
        a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 6*a**12*b**5*c**2 +
        9*a**11*b**6*c**2 - 3*a**10*b**7*c**2 - 6*a**9*b**8*c**2 +
        9*a**8*b**9*c**2 - 4*a**7*b**10*c**2 - a**6*b**11*c**2 +
        2*a**5*b**12*c**2 - a**4*b**13*c**2 + 2*a**14*b**2*c**3 -
        5*a**13*b**3*c**3 + 3*a**12*b**4*c**3 + 6*a**11*b**5*c**3 -
        12*a**10*b**6*c**3 + 5*a**9*b**7*c**3 + 6*a**8*b**8*c**3 -
        8*a**7*b**9*c**3 + 2*a**6*b**10*c**3 + 2*a**5*b**11*c**3 -
        a**4*b**12*c**3 + a**15*c**4 - a**14*b*c**4 -
        3*a**13*b**2*c**4 + 8*a**12*b**3*c**4 - 5*a**11*b**4*c**4 -
        8*a**10*b**5*c**4 + 15*a**9*b**6*c**4 - 6*a**8*b**7*c**4 -
        7*a**7*b**8*c**4 + 9*a**6*b**9*c**4 - 2*a**5*b**10*c**4 -
        2*a**4*b**11*c**4 + a**3*b**12*c**4 - 2*a**14*c**5 +
        3*a**13*b*c**5 + 3*a**12*b**2*c**5 - 11*a**11*b**3*c**5 +
        9*a**10*b**4*c**5 + 6*a**9*b**5*c**5 - 16*a**8*b**6*c**5 +
        8*a**7*b**7*c**5 + 4*a**6*b**8*c**5 - 6*a**5*b**9*c**5 +
        a**4*b**10*c**5 + a**3*b**11*c**5 + a**2*b**12*c**5 -
        a*b**13*c**5 + 2*a**13*c**6 - 4*a**12*b*c**6 - a**11*b**2*c**6
        + 10*a**10*b**3*c**6 - 10*a**9*b**4*c**6 - 2*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 +
        3*a**4*b**9*c**6 + 2*a**3*b**10*c**6 - 3*a**2*b**11*c**6 +
        b**13*c**6 - 2*a**12*c**7 + 4*a**11*b*c**7 - 7*a**9*b**3*c**7
        + 7*a**8*b**4*c**7 + 2*a**7*b**5*c**7 - 8*a**6*b**6*c**7 +
        3*a**5*b**7*c**7 + 4*a**4*b**8*c**7 - 4*a**3*b**9*c**7 +
        2*a*b**11*c**7 - b**12*c**7 + a**11*c**8 - 3*a**10*b*c**8 +
        a**9*b**2*c**8 + 4*a**8*b**3*c**8 - 5*a**7*b**4*c**8 +
        5*a**5*b**6*c**8 - 3*a**4*b**7*c**8 - a**3*b**8*c**8 +
        2*a**2*b**9*c**8 - a*b**10*c**8 + a**9*b*c**9 - a**8*b**2*c**9
        - a**7*b**3*c**9 + 2*a**6*b**4*c**9 - a**5*b**5*c**9 -
        a**4*b**6*c**9 + a**3*b**7*c**9), (-a**10*b**4*c**4 -
        a**9*b**5*c**4 - a**10*b**3*c**5 - 3*a**9*b**4*c**5 -
        3*a**8*b**5*c**5 - a**7*b**6*c**5 - a**9*b**3*c**6 -
        2*a**8*b**4*c**6 - a**7*b**5*c**6 - a**6*b**6*c**6 -
        a**9*b**2*c**7 - a**8*b**3*c**7 - a**6*b**5*c**7 -
        a**5*b**6*c**7 - 5*a**6*b**4*c**8 - 8*a**5*b**5*c**8 -
        4*a**4*b**6*c**8 + a**7*b**2*c**9 - 3*a**6*b**3*c**9 -
        12*a**5*b**4*c**9 - 13*a**4*b**5*c**9 - 5*a**3*b**6*c**9 -
        2*a**6*b**2*c**10 - 8*a**5*b**3*c**10 - 12*a**4*b**4*c**10 -
        8*a**3*b**5*c**10 - 2*a**2*b**6*c**10 - 2*a**5*b**2*c**11 -
        5*a**4*b**3*c**11 - 5*a**3*b**4*c**11 -
        2*a**2*b**5*c**11)/(a**13*b**6 - a**12*b**7 - a**13*b**5*c +
        2*a**11*b**7*c - a**10*b**8*c + a**12*b**5*c**2 -
        3*a**11*b**6*c**2 + 2*a**9*b**8*c**2 + a**12*b**4*c**3 +
        a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 4*a**9*b**7*c**3 -
        a**8*b**8*c**3 + a**7*b**9*c**3 - a**13*b**2*c**4 -
        a**12*b**3*c**4 - 2*a**11*b**4*c**4 + a**10*b**5*c**4 +
        3*a**9*b**6*c**4 + 4*a**8*b**7*c**4 - 3*a**7*b**8*c**4 -
        a**6*b**9*c**4 + a**13*b*c**5 + 2*a**12*b**2*c**5 +
        2*a**11*b**3*c**5 - 2*a**10*b**4*c**5 - 6*a**9*b**5*c**5 -
        4*a**8*b**6*c**5 + 3*a**7*b**7*c**5 + 5*a**6*b**8*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 - a**11*b**2*c**6 +
        2*a**10*b**3*c**6 + 9*a**9*b**4*c**6 + 4*a**8*b**5*c**6 -
        5*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 2*a**4*b**9*c**6 +
        a**12*c**7 + 3*a**11*b*c**7 - 4*a**10*b**2*c**7 -
        8*a**9*b**3*c**7 - 7*a**8*b**4*c**7 + 8*a**7*b**5*c**7 +
        11*a**6*b**6*c**7 + 2*a**5*b**7*c**7 - 5*a**4*b**8*c**7 -
        a**3*b**9*c**7 - 2*a**11*c**8 + a**10*b*c**8 +
        9*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 6*a**7*b**4*c**8 -
        16*a**6*b**5*c**8 - 2*a**5*b**6*c**8 + 7*a**4*b**7*c**8 +
        4*a**3*b**8*c**8 - a**2*b**9*c**8 + a**10*c**9 - 6*a**9*b*c**9
        - 6*a**8*b**2*c**9 + 5*a**7*b**3*c**9 + 15*a**6*b**4*c**9 +
        6*a**5*b**5*c**9 - 10*a**4*b**6*c**9 - 7*a**3*b**7*c**9 +
        a**2*b**8*c**9 + a*b**9*c**9 + a**9*c**10 + 6*a**8*b*c**10 -
        3*a**7*b**2*c**10 - 12*a**6*b**3*c**10 - 8*a**5*b**4*c**10 +
        9*a**4*b**5*c**10 + 10*a**3*b**6*c**10 - 3*a*b**8*c**10 -
        2*a**8*c**11 - a**7*b*c**11 + 9*a**6*b**2*c**11 +
        6*a**5*b**3*c**11 - 5*a**4*b**4*c**11 - 11*a**3*b**5*c**11 -
        a**2*b**6*c**11 + 4*a*b**7*c**11 + b**8*c**11 + a**7*c**12 -
        3*a**6*b*c**12 - 6*a**5*b**2*c**12 + 3*a**4*b**3*c**12 +
        8*a**3*b**4*c**12 + 3*a**2*b**5*c**12 - 4*a*b**6*c**12 -
        2*b**7*c**12 + 3*a**5*b*c**13 - 5*a**3*b**3*c**13 -
        3*a**2*b**4*c**13 + 3*a*b**5*c**13 + 2*b**6*c**13 -
        a**4*b*c**14 + 2*a**3*b**2*c**14 + 2*a**2*b**3*c**14 -
        a*b**4*c**14 - 2*b**5*c**14 - a**2*b**2*c**15 + b**4*c**15),
        (a**5*b**9*c**4 + a**4*b**10*c**4 + a**6*b**7*c**5 +
        3*a**5*b**8*c**5 + 3*a**4*b**9*c**5 + a**3*b**10*c**5 +
        a**6*b**6*c**6 + a**5*b**7*c**6 + 2*a**4*b**8*c**6 +
        a**3*b**9*c**6 + a**6*b**5*c**7 + a**5*b**6*c**7 +
        a**3*b**8*c**7 + a**2*b**9*c**7 + 4*a**6*b**4*c**8 +
        8*a**5*b**5*c**8 + 5*a**4*b**6*c**8 + 5*a**6*b**3*c**9 +
        13*a**5*b**4*c**9 + 12*a**4*b**5*c**9 + 3*a**3*b**6*c**9 -
        a**2*b**7*c**9 + 2*a**6*b**2*c**10 + 8*a**5*b**3*c**10 +
        12*a**4*b**4*c**10 + 8*a**3*b**5*c**10 + 2*a**2*b**6*c**10 +
        2*a**5*b**2*c**11 + 5*a**4*b**3*c**11 + 5*a**3*b**4*c**11 +
        2*a**2*b**5*c**11)/(a**7*b**12 - a**6*b**13 + a**8*b**10*c -
        2*a**7*b**11*c + a**5*b**13*c - 2*a**8*b**9*c**2 +
        3*a**6*b**11*c**2 - a**5*b**12*c**2 - a**9*b**7*c**3 +
        a**8*b**8*c**3 + 4*a**7*b**9*c**3 - 2*a**6*b**10*c**3 -
        a**5*b**11*c**3 - a**4*b**12*c**3 + a**9*b**6*c**4 +
        3*a**8*b**7*c**4 - 4*a**7*b**8*c**4 - 3*a**6*b**9*c**4 -
        a**5*b**10*c**4 + 2*a**4*b**11*c**4 + a**3*b**12*c**4 +
        a**2*b**13*c**4 + a**9*b**5*c**5 - 5*a**8*b**6*c**5 -
        3*a**7*b**7*c**5 + 4*a**6*b**8*c**5 + 6*a**5*b**9*c**5 +
        2*a**4*b**10*c**5 - 2*a**3*b**11*c**5 - 2*a**2*b**12*c**5 -
        a*b**13*c**5 - 2*a**9*b**4*c**6 + 8*a**7*b**6*c**6 +
        5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 - 9*a**4*b**9*c**6 -
        2*a**3*b**10*c**6 + a**2*b**11*c**6 + 3*a*b**12*c**6 +
        a**9*b**3*c**7 + 5*a**8*b**4*c**7 - 2*a**7*b**5*c**7 -
        11*a**6*b**6*c**7 - 8*a**5*b**7*c**7 + 7*a**4*b**8*c**7 +
        8*a**3*b**9*c**7 + 4*a**2*b**10*c**7 - 3*a*b**11*c**7 -
        b**12*c**7 + a**9*b**2*c**8 - 4*a**8*b**3*c**8 -
        7*a**7*b**4*c**8 + 2*a**6*b**5*c**8 + 16*a**5*b**6*c**8 +
        6*a**4*b**7*c**8 - 6*a**3*b**8*c**8 - 9*a**2*b**9*c**8 -
        a*b**10*c**8 + 2*b**11*c**8 - a**9*b*c**9 - a**8*b**2*c**9 +
        7*a**7*b**3*c**9 + 10*a**6*b**4*c**9 - 6*a**5*b**5*c**9 -
        15*a**4*b**6*c**9 - 5*a**3*b**7*c**9 + 6*a**2*b**8*c**9 +
        6*a*b**9*c**9 - b**10*c**9 + 3*a**8*b*c**10 -
        10*a**6*b**3*c**10 - 9*a**5*b**4*c**10 + 8*a**4*b**5*c**10 +
        12*a**3*b**6*c**10 + 3*a**2*b**7*c**10 - 6*a*b**8*c**10 -
        b**9*c**10 - a**8*c**11 - 4*a**7*b*c**11 + a**6*b**2*c**11 +
        11*a**5*b**3*c**11 + 5*a**4*b**4*c**11 - 6*a**3*b**5*c**11 -
        9*a**2*b**6*c**11 + a*b**7*c**11 + 2*b**8*c**11 + 2*a**7*c**12
        + 4*a**6*b*c**12 - 3*a**5*b**2*c**12 - 8*a**4*b**3*c**12 -
        3*a**3*b**4*c**12 + 6*a**2*b**5*c**12 + 3*a*b**6*c**12 -
        b**7*c**12 - 2*a**6*c**13 - 3*a**5*b*c**13 + 3*a**4*b**2*c**13
        + 5*a**3*b**3*c**13 - 3*a*b**5*c**13 + 2*a**5*c**14 +
        a**4*b*c**14 - 2*a**3*b**2*c**14 - 2*a**2*b**3*c**14 +
        a*b**4*c**14 - a**4*c**15 + a**2*b**2*c**15),
        (-2*a**11*b**5*c**2 - 2*a**10*b**6*c**2 - 5*a**11*b**4*c**3 -
        8*a**10*b**5*c**3 - 5*a**9*b**6*c**3 - 5*a**11*b**3*c**4 -
        12*a**10*b**4*c**4 - 13*a**9*b**5*c**4 - 4*a**8*b**6*c**4 -
        2*a**11*b**2*c**5 - 8*a**10*b**3*c**5 - 12*a**9*b**4*c**5 -
        8*a**8*b**5*c**5 - a**7*b**6*c**5 - 2*a**10*b**2*c**6 -
        3*a**9*b**3*c**6 - 5*a**8*b**4*c**6 - a**7*b**5*c**6 -
        a**6*b**6*c**6 + a**9*b**2*c**7 - a**6*b**5*c**7 -
        a**5*b**6*c**7 - a**7*b**3*c**8 - 2*a**6*b**4*c**8 -
        3*a**5*b**5*c**8 - a**7*b**2*c**9 - a**6*b**3*c**9 -
        3*a**5*b**4*c**9 - a**4*b**5*c**9 - a**5*b**3*c**10 -
        a**4*b**4*c**10)/(a**15*b**4 - 2*a**14*b**5 + 2*a**13*b**6 -
        2*a**12*b**7 + a**11*b**8 - a**14*b**4*c + 3*a**13*b**5*c -
        4*a**12*b**6*c + 4*a**11*b**7*c - 3*a**10*b**8*c + a**9*b**9*c
        - a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 3*a**13*b**4*c**2 +
        3*a**12*b**5*c**2 - a**11*b**6*c**2 + a**9*b**8*c**2 -
        a**8*b**9*c**2 + 2*a**14*b**2*c**3 - 5*a**13*b**3*c**3 +
        8*a**12*b**4*c**3 - 11*a**11*b**5*c**3 + 10*a**10*b**6*c**3 -
        7*a**9*b**7*c**3 + 4*a**8*b**8*c**3 - a**7*b**9*c**3 -
        a**14*b*c**4 + 3*a**12*b**3*c**4 - 5*a**11*b**4*c**4 +
        9*a**10*b**5*c**4 - 10*a**9*b**6*c**4 + 7*a**8*b**7*c**4 -
        5*a**7*b**8*c**4 + 2*a**6*b**9*c**4 + 3*a**13*b*c**5 -
        6*a**12*b**2*c**5 + 6*a**11*b**3*c**5 - 8*a**10*b**4*c**5 +
        6*a**9*b**5*c**5 - 2*a**8*b**6*c**5 + 2*a**7*b**7*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 + 9*a**11*b**2*c**6 -
        12*a**10*b**3*c**6 + 15*a**9*b**4*c**6 - 16*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 5*a**5*b**8*c**6 -
        a**4*b**9*c**6 + a**12*c**7 - a**11*b*c**7 - 3*a**10*b**2*c**7
        + 5*a**9*b**3*c**7 - 6*a**8*b**4*c**7 + 8*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 3*a**5*b**7*c**7 - 3*a**4*b**8*c**7 +
        a**3*b**9*c**7 - 2*a**11*c**8 + 6*a**10*b*c**8 -
        6*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 7*a**7*b**4*c**8 +
        4*a**6*b**5*c**8 - 4*a**5*b**6*c**8 + 4*a**4*b**7*c**8 -
        a**3*b**8*c**8 + a**10*c**9 - 6*a**9*b*c**9 + 9*a**8*b**2*c**9
        - 8*a**7*b**3*c**9 + 9*a**6*b**4*c**9 - 6*a**5*b**5*c**9 +
        3*a**4*b**6*c**9 - 4*a**3*b**7*c**9 + 2*a**2*b**8*c**9 +
        a**9*c**10 + a**8*b*c**10 - 4*a**7*b**2*c**10 +
        2*a**6*b**3*c**10 - 2*a**5*b**4*c**10 + a**4*b**5*c**10 +
        2*a**3*b**6*c**10 - a*b**8*c**10 - 2*a**8*c**11 +
        3*a**7*b*c**11 - a**6*b**2*c**11 + 2*a**5*b**3*c**11 -
        2*a**4*b**4*c**11 + a**3*b**5*c**11 - 3*a**2*b**6*c**11 +
        2*a*b**7*c**11 + a**7*c**12 - 3*a**6*b*c**12 +
        2*a**5*b**2*c**12 - a**4*b**3*c**12 + a**3*b**4*c**12 +
        a**2*b**5*c**12 - b**7*c**12 + a**5*b*c**13 - a**4*b**2*c**13
        - a*b**5*c**13 + b**6*c**13), (-a**9*b**7*c**2 +
        a**7*b**9*c**2 - 2*a**6*b**10*c**2 - 2*a**5*b**11*c**2 -
        a**10*b**5*c**3 - a**9*b**6*c**3 - a**8*b**7*c**3 -
        3*a**6*b**9*c**3 - 8*a**5*b**10*c**3 - 5*a**4*b**11*c**3 -
        a**10*b**4*c**4 - 3*a**9*b**5*c**4 - 2*a**8*b**6*c**4 -
        5*a**6*b**8*c**4 - 12*a**5*b**9*c**4 - 12*a**4*b**10*c**4 -
        5*a**3*b**11*c**4 - a**9*b**4*c**5 - 3*a**8*b**5*c**5 -
        a**7*b**6*c**5 - a**6*b**7*c**5 - 8*a**5*b**8*c**5 -
        13*a**4*b**9*c**5 - 8*a**3*b**10*c**5 - 2*a**2*b**11*c**5 -
        a**7*b**5*c**6 - a**6*b**6*c**6 - a**5*b**7*c**6 -
        4*a**4*b**8*c**6 - 5*a**3*b**9*c**6 -
        2*a**2*b**10*c**6)/(a**12*b**7 - 2*a**11*b**8 + a**10*b**9 +
        a**9*b**10 - 2*a**8*b**11 + a**7*b**12 + a**13*b**5*c -
        3*a**12*b**6*c + 3*a**11*b**7*c + a**10*b**8*c - 6*a**9*b**9*c
        + 6*a**8*b**10*c - a**7*b**11*c - 3*a**6*b**12*c +
        3*a**5*b**13*c - a**4*b**14*c - a**13*b**4*c**2 +
        2*a**12*b**5*c**2 - a**11*b**6*c**2 - 4*a**10*b**7*c**2 +
        9*a**9*b**8*c**2 - 6*a**8*b**9*c**2 - 3*a**7*b**10*c**2 +
        9*a**6*b**11*c**2 - 6*a**5*b**12*c**2 + 2*a**3*b**14*c**2 -
        a**2*b**15*c**2 - a**12*b**4*c**3 + 2*a**11*b**5*c**3 +
        2*a**10*b**6*c**3 - 8*a**9*b**7*c**3 + 6*a**8*b**8*c**3 +
        5*a**7*b**9*c**3 - 12*a**6*b**10*c**3 + 6*a**5*b**11*c**3 +
        3*a**4*b**12*c**3 - 5*a**3*b**13*c**3 + 2*a**2*b**14*c**3 +
        a**12*b**3*c**4 - 2*a**11*b**4*c**4 - 2*a**10*b**5*c**4 +
        9*a**9*b**6*c**4 - 7*a**8*b**7*c**4 - 6*a**7*b**8*c**4 +
        15*a**6*b**9*c**4 - 8*a**5*b**10*c**4 - 5*a**4*b**11*c**4 +
        8*a**3*b**12*c**4 - 3*a**2*b**13*c**4 - a*b**14*c**4 +
        b**15*c**4 - a**13*b*c**5 + a**12*b**2*c**5 + a**11*b**3*c**5
        + a**10*b**4*c**5 - 6*a**9*b**5*c**5 + 4*a**8*b**6*c**5 +
        8*a**7*b**7*c**5 - 16*a**6*b**8*c**5 + 6*a**5*b**9*c**5 +
        9*a**4*b**10*c**5 - 11*a**3*b**11*c**5 + 3*a**2*b**12*c**5 +
        3*a*b**13*c**5 - 2*b**14*c**5 + a**13*c**6 - 3*a**11*b**2*c**6
        + 2*a**10*b**3*c**6 + 3*a**9*b**4*c**6 - 4*a**8*b**5*c**6 -
        5*a**7*b**6*c**6 + 11*a**6*b**7*c**6 - 2*a**5*b**8*c**6 -
        10*a**4*b**9*c**6 + 10*a**3*b**10*c**6 - a**2*b**11*c**6 -
        4*a*b**12*c**6 + 2*b**13*c**6 - a**12*c**7 + 2*a**11*b*c**7 -
        4*a**9*b**3*c**7 + 4*a**8*b**4*c**7 + 3*a**7*b**5*c**7 -
        8*a**6*b**6*c**7 + 2*a**5*b**7*c**7 + 7*a**4*b**8*c**7 -
        7*a**3*b**9*c**7 + 4*a*b**11*c**7 - 2*b**12*c**7 -
        a**10*b*c**8 + 2*a**9*b**2*c**8 - a**8*b**3*c**8 -
        3*a**7*b**4*c**8 + 5*a**6*b**5*c**8 - 5*a**4*b**7*c**8 +
        4*a**3*b**8*c**8 + a**2*b**9*c**8 - 3*a*b**10*c**8 +
        b**11*c**8 + a**7*b**3*c**9 - a**6*b**4*c**9 - a**5*b**5*c**9
        + 2*a**4*b**6*c**9 - a**3*b**7*c**9 - a**2*b**8*c**9 +
        a*b**9*c**9), (a**6*b**6*c**3 + 3*a**6*b**5*c**4 +
        5*a**5*b**6*c**4 + 2*a**4*b**7*c**4 + 4*a**6*b**4*c**5 +
        10*a**5*b**5*c**5 + 8*a**4*b**6*c**5 + 2*a**3*b**7*c**5 +
        4*a**6*b**3*c**6 + 12*a**5*b**4*c**6 + 13*a**4*b**5*c**6 +
        6*a**3*b**6*c**6 + a**2*b**7*c**6 + 2*a**6*b**2*c**7 +
        8*a**5*b**3*c**7 + 12*a**4*b**4*c**7 + 7*a**3*b**5*c**7 +
        2*a**2*b**6*c**7 + 2*a**5*b**2*c**8 + 5*a**4*b**3*c**8 +
        4*a**3*b**4*c**8 + a**2*b**5*c**8)/(a**9*b**7 - a**8*b**8 -
        a**7*b**9 + a**6*b**10 - a**9*b**6*c + a**8*b**7*c +
        2*a**7*b**8*c - 2*a**6*b**9*c - a**5*b**10*c + a**4*b**11*c -
        a**9*b**5*c**2 + 2*a**6*b**8*c**2 + a**5*b**9*c**2 -
        2*a**4*b**10*c**2 + 2*a**9*b**4*c**3 - 4*a**7*b**6*c**3 -
        a**6*b**7*c**3 + 2*a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**2*b**11*c**3 - a**9*b**3*c**4 + 4*a**7*b**5*c**4 -
        4*a**5*b**7*c**4 - a**4*b**8*c**4 + a**3*b**9*c**4 +
        a**2*b**10*c**4 - a**9*b**2*c**5 + a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 - 2*a**4*b**7*c**5 -
        a**3*b**8*c**5 + a**2*b**9*c**5 + a**9*b*c**6 + a**8*b**2*c**6
        - 4*a**7*b**3*c**6 - 3*a**6*b**4*c**6 + 4*a**5*b**5*c**6 +
        5*a**4*b**6*c**6 - a**3*b**7*c**6 - 4*a**2*b**8*c**6 +
        b**10*c**6 - a**8*b*c**7 + 2*a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 4*a**5*b**4*c**7 - 5*a**4*b**5*c**7 + 2*a**3*b**6*c**7 +
        5*a**2*b**7*c**7 - 2*b**9*c**7 + a**7*b*c**8 - a**6*b**2*c**8
        + a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 + b**8*c**8
        - a**7*c**9 - a**6*b*c**9 + 2*a**5*b**2*c**9 +
        3*a**4*b**3*c**9 - a**3*b**4*c**9 - 3*a**2*b**5*c**9 +
        b**7*c**9 + a**6*c**10 - a**5*b*c**10 - 3*a**4*b**2*c**10 +
        a**3*b**3*c**10 + 4*a**2*b**4*c**10 - 2*b**6*c**10 +
        a**4*b*c**11 - 2*a**2*b**3*c**11 + b**5*c**11),
        (a**7*b**6*c**2 + 2*a**6*b**7*c**2 + a**5*b**8*c**2 +
        2*a**7*b**5*c**3 + 6*a**6*b**6*c**3 + 7*a**5*b**7*c**3 +
        4*a**4*b**8*c**3 + 2*a**7*b**4*c**4 + 8*a**6*b**5*c**4 +
        13*a**5*b**6*c**4 + 12*a**4*b**7*c**4 + 5*a**3*b**8*c**4 +
        5*a**6*b**4*c**5 + 10*a**5*b**5*c**5 + 12*a**4*b**6*c**5 +
        8*a**3*b**7*c**5 + 2*a**2*b**8*c**5 + a**6*b**3*c**6 +
        3*a**5*b**4*c**6 + 4*a**4*b**5*c**6 + 4*a**3*b**6*c**6 +
        2*a**2*b**7*c**6)/(a**10*b**6 - 2*a**9*b**7 + a**8*b**8 +
        a**7*b**9 - 2*a**6*b**10 + a**5*b**11 - a**11*b**3*c**2 +
        a**10*b**4*c**2 + a**9*b**5*c**2 - 4*a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - a**6*b**8*c**2 - 3*a**5*b**9*c**2 +
        4*a**4*b**10*c**2 - 2*a**3*b**11*c**2 + a**9*b**4*c**3 -
        a**8*b**5*c**3 - a**7*b**6*c**3 + 2*a**6*b**7*c**3 -
        a**5*b**8*c**3 - a**4*b**9*c**3 + a**3*b**10*c**3 +
        a**11*b*c**4 - 2*a**10*b**2*c**4 + 2*a**9*b**3*c**4 -
        a**8*b**4*c**4 - 2*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        5*a**5*b**7*c**4 + a**4*b**8*c**4 + 3*a**3*b**9*c**4 -
        3*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        a**9*b**2*c**5 + 2*a**8*b**3*c**5 - 4*a**7*b**4*c**5 +
        a**6*b**5*c**5 + 4*a**5*b**6*c**5 - 4*a**4*b**7*c**5 +
        2*a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - 2*a**9*b*c**6 +
        2*a**8*b**2*c**6 - a**7*b**3*c**6 + a**5*b**5*c**6 -
        3*a**4*b**6*c**6 + 3*a**3*b**7*c**6 - a**2*b**8*c**6 -
        a*b**9*c**6 + b**10*c**6 - a**9*c**7 + 2*a**8*b*c**7 -
        4*a**6*b**3*c**7 + 4*a**5*b**4*c**7 + a**4*b**5*c**7 -
        4*a**3*b**6*c**7 + 2*a**2*b**7*c**7 + a*b**8*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + a**2*b**6*c**8 - a*b**7*c**8 +
        a**7*c**9 - a**6*b*c**9 - a**5*b**2*c**9 + 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + a*b**6*c**9),
        (2*a**8*b**5*c**2 + 2*a**7*b**6*c**2 + 5*a**8*b**4*c**3 +
        8*a**7*b**5*c**3 + 4*a**6*b**6*c**3 + 4*a**8*b**3*c**4 +
        12*a**7*b**4*c**4 + 12*a**6*b**5*c**4 + 4*a**5*b**6*c**4 +
        a**8*b**2*c**5 + 7*a**7*b**3*c**5 + 13*a**6*b**4*c**5 +
        10*a**5*b**5*c**5 + 3*a**4*b**6*c**5 + 2*a**7*b**2*c**6 +
        6*a**6*b**3*c**6 + 8*a**5*b**4*c**6 + 5*a**4*b**5*c**6 +
        a**3*b**6*c**6 + a**6*b**2*c**7 + 2*a**5*b**3*c**7 +
        2*a**4*b**4*c**7)/(a**10*b**6 - a**9*b**7 + a**11*b**4*c -
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c - a**7*b**8*c +
        a**6*b**9*c - 3*a**10*b**4*c**2 + 2*a**9*b**5*c**2 -
        a**8*b**6*c**2 + 2*a**7*b**7*c**2 + a**6*b**8*c**2 -
        a**5*b**9*c**2 - 2*a**11*b**2*c**3 + a**10*b**3*c**3 +
        3*a**9*b**4*c**3 + 3*a**7*b**6*c**3 - 4*a**6*b**7*c**3 -
        a**4*b**9*c**3 + 4*a**10*b**2*c**4 - a**9*b**3*c**4 +
        a**8*b**4*c**4 - 4*a**7*b**5*c**4 - 3*a**6*b**6*c**4 +
        a**5*b**7*c**4 + 2*a**3*b**9*c**4 + a**11*c**5 -
        3*a**9*b**2*c**5 - a**8*b**3*c**5 - 5*a**7*b**4*c**5 +
        4*a**6*b**5*c**5 + a**5*b**6*c**5 + 4*a**4*b**7*c**5 -
        a**2*b**9*c**5 - 2*a**10*c**6 - a**8*b**2*c**6 +
        2*a**7*b**3*c**6 + 5*a**6*b**4*c**6 + a**5*b**5*c**6 -
        4*a**3*b**7*c**6 - a*b**9*c**6 + a**9*c**7 + 5*a**7*b**2*c**7
        - a**6*b**3*c**7 - 2*a**5*b**4*c**7 - 4*a**4*b**5*c**7 -
        a**3*b**6*c**7 + a*b**8*c**7 + b**9*c**7 + a**8*c**8 -
        4*a**6*b**2*c**8 - a**5*b**3*c**8 - a**4*b**4*c**8 +
        2*a**3*b**5*c**8 + 2*a**2*b**6*c**8 + 2*a*b**7*c**8 -
        b**8*c**8 - 2*a**7*c**9 + a**5*b**2*c**9 + a**4*b**3*c**9 +
        2*a**3*b**4*c**9 + a**2*b**5*c**9 - 2*a*b**6*c**9 - b**7*c**9
        + a**6*c**10 + a**4*b**2*c**10 - 2*a**2*b**4*c**10 -
        a*b**5*c**10 + b**6*c**10 - a**3*b**2*c**11 + a*b**4*c**11),
        (-2*a**6*b**7*c**2 - 2*a**5*b**8*c**2 - 4*a**6*b**6*c**3 -
        8*a**5*b**7*c**3 - 5*a**4*b**8*c**3 - 4*a**6*b**5*c**4 -
        12*a**5*b**6*c**4 - 12*a**4*b**7*c**4 - 4*a**3*b**8*c**4 -
        3*a**6*b**4*c**5 - 10*a**5*b**5*c**5 - 13*a**4*b**6*c**5 -
        7*a**3*b**7*c**5 - a**2*b**8*c**5 - a**6*b**3*c**6 -
        5*a**5*b**4*c**6 - 8*a**4*b**5*c**6 - 6*a**3*b**6*c**6 -
        2*a**2*b**7*c**6 - 2*a**4*b**4*c**7 - 2*a**3*b**5*c**7 -
        a**2*b**6*c**7)/(a**7*b**9 - a**6*b**10 - a**9*b**6*c +
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c + a**5*b**10*c -
        a**4*b**11*c + a**9*b**5*c**2 - a**8*b**6*c**2 -
        2*a**7*b**7*c**2 + a**6*b**8*c**2 - 2*a**5*b**9*c**2 +
        3*a**4*b**10*c**2 + a**9*b**4*c**3 + 4*a**7*b**6*c**3 -
        3*a**6*b**7*c**3 - 3*a**4*b**9*c**3 - a**3*b**10*c**3 +
        2*a**2*b**11*c**3 - 2*a**9*b**3*c**4 - a**7*b**5*c**4 +
        3*a**6*b**6*c**4 + 4*a**5*b**7*c**4 - a**4*b**8*c**4 +
        a**3*b**9*c**4 - 4*a**2*b**10*c**4 + a**9*b**2*c**5 -
        4*a**7*b**4*c**5 - a**6*b**5*c**5 - 4*a**5*b**6*c**5 +
        5*a**4*b**7*c**5 + a**3*b**8*c**5 + 3*a**2*b**9*c**5 -
        b**11*c**5 + a**9*b*c**6 + 4*a**7*b**3*c**6 - a**5*b**5*c**6 -
        5*a**4*b**6*c**6 - 2*a**3*b**7*c**6 + a**2*b**8*c**6 +
        2*b**10*c**6 - a**9*c**7 - a**8*b*c**7 + a**6*b**3*c**7 +
        4*a**5*b**4*c**7 + 2*a**4*b**5*c**7 + a**3*b**6*c**7 -
        5*a**2*b**7*c**7 - b**9*c**7 + a**8*c**8 - 2*a**7*b*c**8 -
        2*a**6*b**2*c**8 - 2*a**5*b**3*c**8 + a**4*b**4*c**8 +
        a**3*b**5*c**8 + 4*a**2*b**6*c**8 - b**8*c**8 + a**7*c**9 +
        2*a**6*b*c**9 - a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + 2*b**7*c**9 - a**6*c**10 +
        a**5*b*c**10 + 2*a**4*b**2*c**10 - a**2*b**4*c**10 -
        b**6*c**10 - a**4*b*c**11 + a**2*b**3*c**11), (a**6*b**6*c**3
        + 2*a**7*b**4*c**4 + 5*a**6*b**5*c**4 + 3*a**5*b**6*c**4 +
        2*a**7*b**3*c**5 + 8*a**6*b**4*c**5 + 10*a**5*b**5*c**5 +
        4*a**4*b**6*c**5 + a**7*b**2*c**6 + 6*a**6*b**3*c**6 +
        13*a**5*b**4*c**6 + 12*a**4*b**5*c**6 + 4*a**3*b**6*c**6 +
        2*a**6*b**2*c**7 + 7*a**5*b**3*c**7 + 12*a**4*b**4*c**7 +
        8*a**3*b**5*c**7 + 2*a**2*b**6*c**7 + a**5*b**2*c**8 +
        4*a**4*b**3*c**8 + 5*a**3*b**4*c**8 +
        2*a**2*b**5*c**8)/(a**10*b**6 - a**9*b**7 - a**8*b**8 +
        a**7*b**9 + a**11*b**4*c - a**10*b**5*c - 2*a**9*b**6*c +
        2*a**8*b**7*c + a**7*b**8*c - a**6*b**9*c - 2*a**10*b**4*c**2
        + a**9*b**5*c**2 + 2*a**8*b**6*c**2 - a**5*b**9*c**2 -
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 + 2*a**8*b**5*c**3 -
        a**7*b**6*c**3 - 4*a**6*b**7*c**3 + 2*a**4*b**9*c**3 +
        a**10*b**2*c**4 + a**9*b**3*c**4 - a**8*b**4*c**4 -
        4*a**7*b**5*c**4 + 4*a**5*b**7*c**4 - a**3*b**9*c**4 +
        a**9*b**2*c**5 - a**8*b**3*c**5 - 2*a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 + a**4*b**7*c**5 -
        a**2*b**9*c**5 + a**10*c**6 - 4*a**8*b**2*c**6 -
        a**7*b**3*c**6 + 5*a**6*b**4*c**6 + 4*a**5*b**5*c**6 -
        3*a**4*b**6*c**6 - 4*a**3*b**7*c**6 + a**2*b**8*c**6 +
        a*b**9*c**6 - 2*a**9*c**7 + 5*a**7*b**2*c**7 +
        2*a**6*b**3*c**7 - 5*a**5*b**4*c**7 - 4*a**4*b**5*c**7 +
        3*a**3*b**6*c**7 + 2*a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8
        - a**6*b**2*c**8 - a**5*b**3*c**8 + a**4*b**4*c**8 -
        a**2*b**6*c**8 + a*b**7*c**8 + a**7*c**9 - 3*a**5*b**2*c**9 -
        a**4*b**3*c**9 + 3*a**3*b**4*c**9 + 2*a**2*b**5*c**9 -
        a*b**6*c**9 - b**7*c**9 - 2*a**6*c**10 + 4*a**4*b**2*c**10 +
        a**3*b**3*c**10 - 3*a**2*b**4*c**10 - a*b**5*c**10 +
        b**6*c**10 + a**5*c**11 - 2*a**3*b**2*c**11 + a*b**4*c**11),
        (a**8*b**5*c**2 + 2*a**7*b**6*c**2 + a**6*b**7*c**2 +
        4*a**8*b**4*c**3 + 7*a**7*b**5*c**3 + 6*a**6*b**6*c**3 +
        2*a**5*b**7*c**3 + 5*a**8*b**3*c**4 + 12*a**7*b**4*c**4 +
        13*a**6*b**5*c**4 + 8*a**5*b**6*c**4 + 2*a**4*b**7*c**4 +
        2*a**8*b**2*c**5 + 8*a**7*b**3*c**5 + 12*a**6*b**4*c**5 +
        10*a**5*b**5*c**5 + 5*a**4*b**6*c**5 + 2*a**7*b**2*c**6 +
        4*a**6*b**3*c**6 + 4*a**5*b**4*c**6 + 3*a**4*b**5*c**6 +
        a**3*b**6*c**6)/(a**11*b**5 - 2*a**10*b**6 + a**9*b**7 +
        a**8*b**8 - 2*a**7*b**9 + a**6*b**10 - 2*a**11*b**3*c**2 +
        4*a**10*b**4*c**2 - 3*a**9*b**5*c**2 - a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - 4*a**6*b**8*c**2 + a**5*b**9*c**2 +
        a**4*b**10*c**2 - a**3*b**11*c**2 + a**10*b**3*c**3 -
        a**9*b**4*c**3 - a**8*b**5*c**3 + 2*a**7*b**6*c**3 -
        a**6*b**7*c**3 - a**5*b**8*c**3 + a**4*b**9*c**3 +
        a**11*b*c**4 - 3*a**10*b**2*c**4 + 3*a**9*b**3*c**4 +
        a**8*b**4*c**4 - 5*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        2*a**5*b**7*c**4 - a**4*b**8*c**4 + 2*a**3*b**9*c**4 -
        2*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        2*a**9*b**2*c**5 - 4*a**7*b**4*c**5 + 4*a**6*b**5*c**5 +
        a**5*b**6*c**5 - 4*a**4*b**7*c**5 + 2*a**3*b**8*c**5 +
        a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - a**9*b*c**6 -
        a**8*b**2*c**6 + 3*a**7*b**3*c**6 - 3*a**6*b**4*c**6 +
        a**5*b**5*c**6 - a**3*b**7*c**6 + 2*a**2*b**8*c**6 -
        2*a*b**9*c**6 + b**10*c**6 - a**9*c**7 + a**8*b*c**7 +
        2*a**7*b**2*c**7 - 4*a**6*b**3*c**7 + a**5*b**4*c**7 +
        4*a**4*b**5*c**7 - 4*a**3*b**6*c**7 + 2*a*b**8*c**7 -
        b**9*c**7 - a**7*b*c**8 + a**6*b**2*c**8 + a*b**7*c**8 -
        b**8*c**8 + a**6*b*c**9 - a**5*b**2*c**9 - a**4*b**3*c**9 +
        2*a**3*b**4*c**9 - a**2*b**5*c**9 - a*b**6*c**9 + b**7*c**9),
        (2*a**8*b**5*c**2 + 2*a**7*b**6*c**2 + 4*a**8*b**4*c**3 +
        8*a**7*b**5*c**3 + 5*a**6*b**6*c**3 + a**5*b**7*c**3 +
        4*a**8*b**3*c**4 + 11*a**7*b**4*c**4 + 13*a**6*b**5*c**4 +
        6*a**5*b**6*c**4 + a**4*b**7*c**4 + 2*a**8*b**2*c**5 +
        8*a**7*b**3*c**5 + 13*a**6*b**4*c**5 + 10*a**5*b**5*c**5 +
        4*a**4*b**6*c**5 + 2*a**7*b**2*c**6 + 5*a**6*b**3*c**6 +
        6*a**5*b**4*c**6 + 4*a**4*b**5*c**6 + a**3*b**6*c**6 +
        a**5*b**3*c**7 + a**4*b**4*c**7)/(a**9*b**7 - a**8*b**8 -
        a**11*b**4*c + a**10*b**5*c - a**9*b**6*c + a**8*b**7*c +
        a**7*b**8*c - a**6*b**9*c + a**11*b**3*c**2 - a**10*b**4*c**2
        - 2*a**9*b**5*c**2 + a**8*b**6*c**2 - a**7*b**7*c**2 +
        2*a**6*b**8*c**2 + a**5*b**9*c**2 - a**4*b**10*c**2 +
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 - a**8*b**5*c**3 -
        3*a**7*b**6*c**3 - a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**11*b*c**4 - a**10*b**2*c**4 + 2*a**9*b**3*c**4 +
        3*a**7*b**5*c**4 - a**6*b**6*c**4 - 2*a**5*b**7*c**4 -
        a**4*b**8*c**4 + a**2*b**10*c**4 + a**10*b*c**5 -
        2*a**9*b**2*c**5 - a**8*b**3*c**5 + 3*a**7*b**4*c**5 +
        2*a**5*b**6*c**5 - a**4*b**7*c**5 - a**3*b**8*c**5 -
        a**2*b**9*c**5 - a**9*b*c**6 + a**8*b**2*c**6 -
        3*a**7*b**3*c**6 - a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        2*a**4*b**6*c**6 + a**3*b**7*c**6 - a**2*b**8*c**6 + a**9*c**7
        + a**8*b*c**7 - a**7*b**2*c**7 - 2*a**5*b**4*c**7 -
        a**4*b**5*c**7 + a**3*b**6*c**7 + 2*a**2*b**7*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + 2*a**6*b**2*c**8 - a**5*b**3*c**8
        - a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 +
        2*b**8*c**8 - a**6*b*c**9 + a**5*b**2*c**9 + 2*a**4*b**3*c**9
        - a**2*b**5*c**9 - b**7*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (-a**6*b**6*c**3 - a**7*b**4*c**4 -
        4*a**6*b**5*c**4 - 4*a**5*b**6*c**4 - a**4*b**7*c**4 -
        a**7*b**3*c**5 - 6*a**6*b**4*c**5 - 10*a**5*b**5*c**5 -
        6*a**4*b**6*c**5 - a**3*b**7*c**5 - 5*a**6*b**3*c**6 -
        13*a**5*b**4*c**6 - 13*a**4*b**5*c**6 - 5*a**3*b**6*c**6 -
        2*a**6*b**2*c**7 - 8*a**5*b**3*c**7 - 11*a**4*b**4*c**7 -
        8*a**3*b**5*c**7 - 2*a**2*b**6*c**7 - 2*a**5*b**2*c**8 -
        4*a**4*b**3*c**8 - 4*a**3*b**4*c**8 -
        2*a**2*b**5*c**8)/(a**9*b**7 - 2*a**8*b**8 + a**7*b**9 -
        a**10*b**4*c**2 + a**9*b**5*c**2 + a**8*b**6*c**2 -
        2*a**7*b**7*c**2 + a**6*b**8*c**2 + a**5*b**9*c**2 -
        a**4*b**10*c**2 + a**8*b**5*c**3 - a**7*b**6*c**3 -
        a**6*b**7*c**3 + a**5*b**8*c**3 + a**10*b**2*c**4 -
        2*a**9*b**3*c**4 + a**8*b**4*c**4 + a**7*b**5*c**4 -
        2*a**6*b**6*c**4 + a**5*b**7*c**4 + a**4*b**8*c**4 -
        2*a**3*b**9*c**4 + a**2*b**10*c**4 - a**9*b**2*c**5 +
        a**8*b**3*c**5 + 2*a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        2*a**5*b**6*c**5 + 2*a**4*b**7*c**5 + a**3*b**8*c**5 -
        a**2*b**9*c**5 + a**9*b*c**6 - 2*a**8*b**2*c**6 +
        a**6*b**4*c**6 + a**4*b**6*c**6 - 2*a**2*b**8*c**6 +
        a*b**9*c**6 - a**8*b*c**7 + a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 3*a**5*b**4*c**7 - 3*a**4*b**5*c**7 + 3*a**3*b**6*c**7 +
        a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8 - a**7*b*c**8 -
        a**6*b**2*c**8 + a**5*b**3*c**8 + a**3*b**5*c**8 -
        a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 - a**7*c**9 +
        a**6*b*c**9 + 2*a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        2*a**3*b**4*c**9 + 2*a**2*b**5*c**9 + a*b**6*c**9 - b**7*c**9
        - a**5*b*c**10 + a**4*b**2*c**10 + a**2*b**4*c**10 -
        a*b**5*c**10 + a**4*b*c**11 - a**3*b**2*c**11 -
        a**2*b**3*c**11 + a*b**4*c**11), (-2*a**6*b**7*c**2 -
        2*a**5*b**8*c**2 - a**7*b**5*c**3 - 5*a**6*b**6*c**3 -
        8*a**5*b**7*c**3 - 4*a**4*b**8*c**3 - a**7*b**4*c**4 -
        6*a**6*b**5*c**4 - 13*a**5*b**6*c**4 - 11*a**4*b**7*c**4 -
        4*a**3*b**8*c**4 - 4*a**6*b**4*c**5 - 10*a**5*b**5*c**5 -
        13*a**4*b**6*c**5 - 8*a**3*b**7*c**5 - 2*a**2*b**8*c**5 -
        a**6*b**3*c**6 - 4*a**5*b**4*c**6 - 6*a**4*b**5*c**6 -
        5*a**3*b**6*c**6 - 2*a**2*b**7*c**6 - a**4*b**4*c**7 -
        a**3*b**5*c**7)/(a**8*b**8 - a**7*b**9 + a**9*b**6*c -
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c - a**5*b**10*c +
        a**4*b**11*c + a**10*b**4*c**2 - a**9*b**5*c**2 -
        2*a**8*b**6*c**2 + a**7*b**7*c**2 - a**6*b**8*c**2 +
        2*a**5*b**9*c**2 + a**4*b**10*c**2 - a**3*b**11*c**2 -
        2*a**9*b**4*c**3 + a**8*b**5*c**3 + 3*a**6*b**7*c**3 +
        a**5*b**8*c**3 - 2*a**4*b**9*c**3 - a**2*b**11*c**3 -
        a**10*b**2*c**4 + a**8*b**4*c**4 + 2*a**7*b**5*c**4 +
        a**6*b**6*c**4 - 3*a**5*b**7*c**4 - 2*a**3*b**9*c**4 +
        a**2*b**10*c**4 + a*b**11*c**4 + a**9*b**2*c**5 +
        a**8*b**3*c**5 + a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        3*a**4*b**7*c**5 + a**3*b**8*c**5 + 2*a**2*b**9*c**5 -
        a*b**10*c**5 + a**8*b**2*c**6 - a**7*b**3*c**6 -
        2*a**6*b**4*c**6 - 2*a**5*b**5*c**6 + a**4*b**6*c**6 +
        3*a**3*b**7*c**6 - a**2*b**8*c**6 + a*b**9*c**6 + a**9*c**7 -
        2*a**7*b**2*c**7 - a**6*b**3*c**7 + a**5*b**4*c**7 +
        2*a**4*b**5*c**7 + a**2*b**7*c**7 - a*b**8*c**7 - b**9*c**7 -
        2*a**8*c**8 + a**6*b**2*c**8 + a**5*b**3*c**8 + a**4*b**4*c**8
        + a**3*b**5*c**8 - 2*a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8
        + a**7*c**9 + a**5*b**2*c**9 - 2*a**3*b**4*c**9 -
        a**2*b**5*c**9 + a*b**6*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (a**6*b**5*c**2 + a**5*b**6*c**2 +
        (-2/3*zeta3 + 5/3)*a**6*b**4*c**3 + (-zeta3 +
        4)*a**5*b**5*c**3 + (-2/3*zeta3 + 5/3)*a**4*b**6*c**3 +
        (-2/3*zeta3 + 5/3)*a**6*b**3*c**4 + (-7/3*zeta3 +
        16/3)*a**5*b**4*c**4 + (-7/3*zeta3 + 16/3)*a**4*b**5*c**4 +
        (-2/3*zeta3 + 5/3)*a**3*b**6*c**4 + a**6*b**2*c**5 + (-zeta3 +
        4)*a**5*b**3*c**5 + (-7/3*zeta3 + 16/3)*a**4*b**4*c**5 +
        (-zeta3 + 4)*a**3*b**5*c**5 + a**2*b**6*c**5 + a**5*b**2*c**6
        + (-2/3*zeta3 + 5/3)*a**4*b**3*c**6 + (-2/3*zeta3 +
        5/3)*a**3*b**4*c**6 + a**2*b**5*c**6)/(a**8*b**6 - a**7*b**7 +
        a**6*b**8 + (zeta3 + 1)*a**9*b**4*c + (-zeta3 - 1)*a**8*b**5*c
        + (zeta3 + 1)*a**7*b**6*c + (zeta3 + 1)*a**6*b**7*c + (-zeta3
        - 1)*a**5*b**8*c + (zeta3 + 1)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (-zeta3 + 1)*a**8*b**3*c**3
        + zeta3*a**7*b**4*c**3 + (-zeta3 + 1)*a**6*b**5*c**3 + (-zeta3
        + 1)*a**5*b**6*c**3 + zeta3*a**4*b**7*c**3 + (-zeta3 +
        1)*a**3*b**8*c**3 + (zeta3 + 1)*a**9*b*c**4 +
        zeta3*a**7*b**3*c**4 + (3*zeta3 + 3)*a**6*b**4*c**4 + (-zeta3
        - 2)*a**5*b**5*c**4 + (3*zeta3 + 3)*a**4*b**6*c**4 +
        zeta3*a**3*b**7*c**4 + (zeta3 + 1)*a*b**9*c**4 + (-zeta3 -
        1)*a**8*b*c**5 - a**7*b**2*c**5 + (-zeta3 + 1)*a**6*b**3*c**5
        + (-zeta3 - 2)*a**5*b**4*c**5 + (-zeta3 - 2)*a**4*b**5*c**5 +
        (-zeta3 + 1)*a**3*b**6*c**5 - a**2*b**7*c**5 + (-zeta3 -
        1)*a*b**8*c**5 + a**8*c**6 + (zeta3 + 1)*a**7*b*c**6 +
        a**6*b**2*c**6 + (-zeta3 + 1)*a**5*b**3*c**6 + (3*zeta3 +
        3)*a**4*b**4*c**6 + (-zeta3 + 1)*a**3*b**5*c**6 +
        a**2*b**6*c**6 + (zeta3 + 1)*a*b**7*c**6 + b**8*c**6 -
        a**7*c**7 + (zeta3 + 1)*a**6*b*c**7 - a**5*b**2*c**7 +
        zeta3*a**4*b**3*c**7 + zeta3*a**3*b**4*c**7 - a**2*b**5*c**7 +
        (zeta3 + 1)*a*b**6*c**7 - b**7*c**7 + a**6*c**8 + (-zeta3 -
        1)*a**5*b*c**8 + (-zeta3 + 1)*a**3*b**3*c**8 + (-zeta3 -
        1)*a*b**5*c**8 + b**6*c**8 + (zeta3 + 1)*a**4*b*c**9 + (zeta3
        + 1)*a*b**4*c**9), (a**6*b**5*c**2 + a**5*b**6*c**2 +
        (2/3*zeta3 + 7/3)*a**6*b**4*c**3 + (zeta3 + 5)*a**5*b**5*c**3
        + (2/3*zeta3 + 7/3)*a**4*b**6*c**3 + (2/3*zeta3 +
        7/3)*a**6*b**3*c**4 + (7/3*zeta3 + 23/3)*a**5*b**4*c**4 +
        (7/3*zeta3 + 23/3)*a**4*b**5*c**4 + (2/3*zeta3 +
        7/3)*a**3*b**6*c**4 + a**6*b**2*c**5 + (zeta3 +
        5)*a**5*b**3*c**5 + (7/3*zeta3 + 23/3)*a**4*b**4*c**5 + (zeta3
        + 5)*a**3*b**5*c**5 + a**2*b**6*c**5 + a**5*b**2*c**6 +
        (2/3*zeta3 + 7/3)*a**4*b**3*c**6 + (2/3*zeta3 +
        7/3)*a**3*b**4*c**6 + a**2*b**5*c**6)/(a**8*b**6 - a**7*b**7 +
        a**6*b**8 + (-zeta3)*a**9*b**4*c + zeta3*a**8*b**5*c +
        (-zeta3)*a**7*b**6*c + (-zeta3)*a**6*b**7*c +
        zeta3*a**5*b**8*c + (-zeta3)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (zeta3 + 2)*a**8*b**3*c**3 +
        (-zeta3 - 1)*a**7*b**4*c**3 + (zeta3 + 2)*a**6*b**5*c**3 +
        (zeta3 + 2)*a**5*b**6*c**3 + (-zeta3 - 1)*a**4*b**7*c**3 +
        (zeta3 + 2)*a**3*b**8*c**3 + (-zeta3)*a**9*b*c**4 + (-zeta3 -
        1)*a**7*b**3*c**4 + (-3*zeta3)*a**6*b**4*c**4 + (zeta3 -
        1)*a**5*b**5*c**4 + (-3*zeta3)*a**4*b**6*c**4 + (-zeta3 -
        1)*a**3*b**7*c**4 + (-zeta3)*a*b**9*c**4 + zeta3*a**8*b*c**5 -
        a**7*b**2*c**5 + (zeta3 + 2)*a**6*b**3*c**5 + (zeta3 -
        1)*a**5*b**4*c**5 + (zeta3 - 1)*a**4*b**5*c**5 + (zeta3 +
        2)*a**3*b**6*c**5 - a**2*b**7*c**5 + zeta3*a*b**8*c**5 +
        a**8*c**6 + (-zeta3)*a**7*b*c**6 + a**6*b**2*c**6 + (zeta3 +
        2)*a**5*b**3*c**6 + (-3*zeta3)*a**4*b**4*c**6 + (zeta3 +
        2)*a**3*b**5*c**6 + a**2*b**6*c**6 + (-zeta3)*a*b**7*c**6 +
        b**8*c**6 - a**7*c**7 + (-zeta3)*a**6*b*c**7 - a**5*b**2*c**7
        + (-zeta3 - 1)*a**4*b**3*c**7 + (-zeta3 - 1)*a**3*b**4*c**7 -
        a**2*b**5*c**7 + (-zeta3)*a*b**6*c**7 - b**7*c**7 + a**6*c**8
        + zeta3*a**5*b*c**8 + (zeta3 + 2)*a**3*b**3*c**8 +
        zeta3*a*b**5*c**8 + b**6*c**8 + (-zeta3)*a**4*b*c**9 +
        (-zeta3)*a*b**4*c**9)], 'K7': [(-2*a**16*b**4*c -
        5*a**16*b**3*c**2 - 5*a**15*b**4*c**2 - 5*a**16*b**2*c**3 -
        9*a**15*b**3*c**3 - 4*a**14*b**4*c**3 - a**13*b**5*c**3 +
        a**12*b**6*c**3 - 2*a**16*b*c**4 - 5*a**15*b**2*c**4 -
        4*a**14*b**3*c**4 - 3*a**13*b**4*c**4 + 2*a**12*b**5*c**4 -
        a**11*b**6*c**4 + a**10*b**7*c**4 - a**13*b**3*c**5 +
        2*a**12*b**4*c**5 - 2*a**11*b**5*c**5 + 2*a**10*b**6*c**5 -
        a**9*b**7*c**5 + a**12*b**3*c**6 - a**11*b**4*c**6 +
        2*a**10*b**5*c**6 - a**9*b**6*c**6 - 3*a**8*b**7*c**6 -
        4*a**7*b**8*c**6 + a**10*b**4*c**7 - a**9*b**5*c**7 -
        3*a**8*b**6*c**7 - 10*a**7*b**7*c**7 - 4*a**6*b**8*c**7 -
        4*a**7*b**6*c**8 - 4*a**6*b**7*c**8)/(a**25*b - 3*a**24*b**2 +
        5*a**23*b**3 - 6*a**22*b**4 + 5*a**21*b**5 - 3*a**20*b**6 +
        a**19*b**7 + a**25*c - 5*a**24*b*c + 13*a**23*b**2*c -
        23*a**22*b**3*c + 30*a**21*b**4*c - 30*a**20*b**5*c +
        23*a**19*b**6*c - 13*a**18*b**7*c + 5*a**17*b**8*c -
        a**16*b**9*c - 3*a**24*c**2 + 13*a**23*b*c**2 -
        33*a**22*b**2*c**2 + 60*a**21*b**3*c**2 - 83*a**20*b**4*c**2 +
        91*a**19*b**5*c**2 - 79*a**18*b**6*c**2 + 54*a**17*b**7*c**2 -
        28*a**16*b**8*c**2 + 10*a**15*b**9*c**2 - 2*a**14*b**10*c**2 +
        5*a**23*c**3 - 23*a**22*b*c**3 + 60*a**21*b**2*c**3 -
        113*a**20*b**3*c**3 + 164*a**19*b**4*c**3 -
        191*a**18*b**5*c**3 + 180*a**17*b**6*c**3 -
        137*a**16*b**7*c**3 + 83*a**15*b**8*c**3 - 38*a**14*b**9*c**3
        + 12*a**13*b**10*c**3 - 2*a**12*b**11*c**3 - 6*a**22*c**4 +
        30*a**21*b*c**4 - 83*a**20*b**2*c**4 + 164*a**19*b**3*c**4 -
        250*a**18*b**4*c**4 + 307*a**17*b**5*c**4 -
        308*a**16*b**6*c**4 + 253*a**15*b**7*c**4 -
        169*a**14*b**8*c**4 + 89*a**13*b**9*c**4 - 35*a**12*b**10*c**4
        + 9*a**11*b**11*c**4 - a**10*b**12*c**4 + 5*a**21*c**5 -
        30*a**20*b*c**5 + 91*a**19*b**2*c**5 - 191*a**18*b**3*c**5 +
        307*a**17*b**4*c**5 - 395*a**16*b**5*c**5 +
        417*a**15*b**6*c**5 - 363*a**14*b**7*c**5 +
        260*a**13*b**8*c**5 - 151*a**12*b**9*c**5 +
        68*a**11*b**10*c**5 - 22*a**10*b**11*c**5 + 4*a**9*b**12*c**5
        - 3*a**20*c**6 + 23*a**19*b*c**6 - 79*a**18*b**2*c**6 +
        180*a**17*b**3*c**6 - 308*a**16*b**4*c**6 +
        417*a**15*b**5*c**6 - 461*a**14*b**6*c**6 +
        420*a**13*b**7*c**6 - 316*a**12*b**8*c**6 +
        195*a**11*b**9*c**6 - 96*a**10*b**10*c**6 + 36*a**9*b**11*c**6
        - 9*a**8*b**12*c**6 + a**7*b**13*c**6 + a**19*c**7 -
        13*a**18*b*c**7 + 54*a**17*b**2*c**7 - 137*a**16*b**3*c**7 +
        253*a**15*b**4*c**7 - 363*a**14*b**5*c**7 +
        420*a**13*b**6*c**7 - 398*a**12*b**7*c**7 +
        310*a**11*b**8*c**7 - 198*a**10*b**9*c**7 +
        102*a**9*b**10*c**7 - 41*a**8*b**11*c**7 + 12*a**7*b**12*c**7
        - 2*a**6*b**13*c**7 + 5*a**17*b*c**8 - 28*a**16*b**2*c**8 +
        83*a**15*b**3*c**8 - 169*a**14*b**4*c**8 + 260*a**13*b**5*c**8
        - 316*a**12*b**6*c**8 + 310*a**11*b**7*c**8 -
        247*a**10*b**8*c**8 + 159*a**9*b**9*c**8 - 82*a**8*b**10*c**8
        + 33*a**7*b**11*c**8 - 10*a**6*b**12*c**8 + 2*a**5*b**13*c**8
        - a**16*b*c**9 + 10*a**15*b**2*c**9 - 38*a**14*b**3*c**9 +
        89*a**13*b**4*c**9 - 151*a**12*b**5*c**9 + 195*a**11*b**6*c**9
        - 198*a**10*b**7*c**9 + 159*a**9*b**8*c**9 - 99*a**8*b**9*c**9
        + 47*a**7*b**10*c**9 - 16*a**6*b**11*c**9 + 4*a**5*b**12*c**9
        - a**4*b**13*c**9 - 2*a**14*b**2*c**10 + 12*a**13*b**3*c**10 -
        35*a**12*b**4*c**10 + 68*a**11*b**5*c**10 -
        96*a**10*b**6*c**10 + 102*a**9*b**7*c**10 - 82*a**8*b**8*c**10
        + 47*a**7*b**9*c**10 - 16*a**6*b**10*c**10 +
        3*a**4*b**12*c**10 - a**3*b**13*c**10 - 2*a**12*b**3*c**11 +
        9*a**11*b**4*c**11 - 22*a**10*b**5*c**11 + 36*a**9*b**6*c**11
        - 41*a**8*b**7*c**11 + 33*a**7*b**8*c**11 - 16*a**6*b**9*c**11
        + 7*a**4*b**11*c**11 - 6*a**3*b**12*c**11 + 2*a**2*b**13*c**11
        - a**10*b**4*c**12 + 4*a**9*b**5*c**12 - 9*a**8*b**6*c**12 +
        12*a**7*b**7*c**12 - 10*a**6*b**8*c**12 + 4*a**5*b**9*c**12 +
        3*a**4*b**10*c**12 - 6*a**3*b**11*c**12 + 5*a**2*b**12*c**12 -
        2*a*b**13*c**12 + a**7*b**6*c**13 - 2*a**6*b**7*c**13 +
        2*a**5*b**8*c**13 - a**4*b**9*c**13 - a**3*b**10*c**13 +
        2*a**2*b**11*c**13 - 2*a*b**12*c**13 + b**13*c**13),
        (-4*a**8*b**7*c**6 - 4*a**7*b**8*c**6 - 4*a**8*b**6*c**7 -
        10*a**7*b**7*c**7 - 4*a**6*b**8*c**7 - 3*a**7*b**6*c**8 -
        3*a**6*b**7*c**8 - a**7*b**5*c**9 - a**6*b**6*c**9 -
        a**5*b**7*c**9 + a**7*b**4*c**10 + 2*a**6*b**5*c**10 +
        2*a**5*b**6*c**10 + a**4*b**7*c**10 - a**6*b**4*c**11 -
        2*a**5*b**5*c**11 - a**4*b**6*c**11 + a**6*b**3*c**12 +
        2*a**5*b**4*c**12 + 2*a**4*b**5*c**12 + a**3*b**6*c**12 -
        a**5*b**3*c**13 - 3*a**4*b**4*c**13 - a**3*b**5*c**13 -
        4*a**4*b**3*c**14 - 4*a**3*b**4*c**14 - 5*a**4*b**2*c**15 -
        9*a**3*b**3*c**15 - 5*a**2*b**4*c**15 - 2*a**4*b*c**16 -
        5*a**3*b**2*c**16 - 5*a**2*b**3*c**16 -
        2*a*b**4*c**16)/(a**13*b**13 - 2*a**13*b**12*c -
        2*a**12*b**13*c + 2*a**13*b**11*c**2 + 5*a**12*b**12*c**2 +
        2*a**11*b**13*c**2 - a**13*b**10*c**3 - 6*a**12*b**11*c**3 -
        6*a**11*b**12*c**3 - a**10*b**13*c**3 - a**13*b**9*c**4 +
        3*a**12*b**10*c**4 + 7*a**11*b**11*c**4 + 3*a**10*b**12*c**4 -
        a**9*b**13*c**4 + 2*a**13*b**8*c**5 + 4*a**12*b**9*c**5 +
        4*a**9*b**12*c**5 + 2*a**8*b**13*c**5 - 2*a**13*b**7*c**6 -
        10*a**12*b**8*c**6 - 16*a**11*b**9*c**6 - 16*a**10*b**10*c**6
        - 16*a**9*b**11*c**6 - 10*a**8*b**12*c**6 - 2*a**7*b**13*c**6
        + a**13*b**6*c**7 + 12*a**12*b**7*c**7 + 33*a**11*b**8*c**7 +
        47*a**10*b**9*c**7 + 47*a**9*b**10*c**7 + 33*a**8*b**11*c**7 +
        12*a**7*b**12*c**7 + a**6*b**13*c**7 - 9*a**12*b**6*c**8 -
        41*a**11*b**7*c**8 - 82*a**10*b**8*c**8 - 99*a**9*b**9*c**8 -
        82*a**8*b**10*c**8 - 41*a**7*b**11*c**8 - 9*a**6*b**12*c**8 +
        4*a**12*b**5*c**9 + 36*a**11*b**6*c**9 + 102*a**10*b**7*c**9 +
        159*a**9*b**8*c**9 + 159*a**8*b**9*c**9 + 102*a**7*b**10*c**9
        + 36*a**6*b**11*c**9 + 4*a**5*b**12*c**9 - a**12*b**4*c**10 -
        22*a**11*b**5*c**10 - 96*a**10*b**6*c**10 -
        198*a**9*b**7*c**10 - 247*a**8*b**8*c**10 -
        198*a**7*b**9*c**10 - 96*a**6*b**10*c**10 -
        22*a**5*b**11*c**10 - a**4*b**12*c**10 + 9*a**11*b**4*c**11 +
        68*a**10*b**5*c**11 + 195*a**9*b**6*c**11 +
        310*a**8*b**7*c**11 + 310*a**7*b**8*c**11 +
        195*a**6*b**9*c**11 + 68*a**5*b**10*c**11 + 9*a**4*b**11*c**11
        - 2*a**11*b**3*c**12 - 35*a**10*b**4*c**12 -
        151*a**9*b**5*c**12 - 316*a**8*b**6*c**12 -
        398*a**7*b**7*c**12 - 316*a**6*b**8*c**12 -
        151*a**5*b**9*c**12 - 35*a**4*b**10*c**12 - 2*a**3*b**11*c**12
        + 12*a**10*b**3*c**13 + 89*a**9*b**4*c**13 +
        260*a**8*b**5*c**13 + 420*a**7*b**6*c**13 +
        420*a**6*b**7*c**13 + 260*a**5*b**8*c**13 + 89*a**4*b**9*c**13
        + 12*a**3*b**10*c**13 - 2*a**10*b**2*c**14 -
        38*a**9*b**3*c**14 - 169*a**8*b**4*c**14 - 363*a**7*b**5*c**14
        - 461*a**6*b**6*c**14 - 363*a**5*b**7*c**14 -
        169*a**4*b**8*c**14 - 38*a**3*b**9*c**14 - 2*a**2*b**10*c**14
        + 10*a**9*b**2*c**15 + 83*a**8*b**3*c**15 +
        253*a**7*b**4*c**15 + 417*a**6*b**5*c**15 +
        417*a**5*b**6*c**15 + 253*a**4*b**7*c**15 + 83*a**3*b**8*c**15
        + 10*a**2*b**9*c**15 - a**9*b*c**16 - 28*a**8*b**2*c**16 -
        137*a**7*b**3*c**16 - 308*a**6*b**4*c**16 -
        395*a**5*b**5*c**16 - 308*a**4*b**6*c**16 -
        137*a**3*b**7*c**16 - 28*a**2*b**8*c**16 - a*b**9*c**16 +
        5*a**8*b*c**17 + 54*a**7*b**2*c**17 + 180*a**6*b**3*c**17 +
        307*a**5*b**4*c**17 + 307*a**4*b**5*c**17 +
        180*a**3*b**6*c**17 + 54*a**2*b**7*c**17 + 5*a*b**8*c**17 -
        13*a**7*b*c**18 - 79*a**6*b**2*c**18 - 191*a**5*b**3*c**18 -
        250*a**4*b**4*c**18 - 191*a**3*b**5*c**18 - 79*a**2*b**6*c**18
        - 13*a*b**7*c**18 + a**7*c**19 + 23*a**6*b*c**19 +
        91*a**5*b**2*c**19 + 164*a**4*b**3*c**19 + 164*a**3*b**4*c**19
        + 91*a**2*b**5*c**19 + 23*a*b**6*c**19 + b**7*c**19 -
        3*a**6*c**20 - 30*a**5*b*c**20 - 83*a**4*b**2*c**20 -
        113*a**3*b**3*c**20 - 83*a**2*b**4*c**20 - 30*a*b**5*c**20 -
        3*b**6*c**20 + 5*a**5*c**21 + 30*a**4*b*c**21 +
        60*a**3*b**2*c**21 + 60*a**2*b**3*c**21 + 30*a*b**4*c**21 +
        5*b**5*c**21 - 6*a**4*c**22 - 23*a**3*b*c**22 -
        33*a**2*b**2*c**22 - 23*a*b**3*c**22 - 6*b**4*c**22 +
        5*a**3*c**23 + 13*a**2*b*c**23 + 13*a*b**2*c**23 +
        5*b**3*c**23 - 3*a**2*c**24 - 5*a*b*c**24 - 3*b**2*c**24 +
        a*c**25 + b*c**25), (-2*a**4*b**16*c - 5*a**4*b**15*c**2 -
        5*a**3*b**16*c**2 + a**6*b**12*c**3 - a**5*b**13*c**3 -
        4*a**4*b**14*c**3 - 9*a**3*b**15*c**3 - 5*a**2*b**16*c**3 +
        a**7*b**10*c**4 - a**6*b**11*c**4 + 2*a**5*b**12*c**4 -
        3*a**4*b**13*c**4 - 4*a**3*b**14*c**4 - 5*a**2*b**15*c**4 -
        2*a*b**16*c**4 - a**7*b**9*c**5 + 2*a**6*b**10*c**5 -
        2*a**5*b**11*c**5 + 2*a**4*b**12*c**5 - a**3*b**13*c**5 -
        4*a**8*b**7*c**6 - 3*a**7*b**8*c**6 - a**6*b**9*c**6 +
        2*a**5*b**10*c**6 - a**4*b**11*c**6 + a**3*b**12*c**6 -
        4*a**8*b**6*c**7 - 10*a**7*b**7*c**7 - 3*a**6*b**8*c**7 -
        a**5*b**9*c**7 + a**4*b**10*c**7 - 4*a**7*b**6*c**8 -
        4*a**6*b**7*c**8)/(a**7*b**19 - 3*a**6*b**20 + 5*a**5*b**21 -
        6*a**4*b**22 + 5*a**3*b**23 - 3*a**2*b**24 + a*b**25 -
        a**9*b**16*c + 5*a**8*b**17*c - 13*a**7*b**18*c +
        23*a**6*b**19*c - 30*a**5*b**20*c + 30*a**4*b**21*c -
        23*a**3*b**22*c + 13*a**2*b**23*c - 5*a*b**24*c + b**25*c -
        2*a**10*b**14*c**2 + 10*a**9*b**15*c**2 - 28*a**8*b**16*c**2 +
        54*a**7*b**17*c**2 - 79*a**6*b**18*c**2 + 91*a**5*b**19*c**2 -
        83*a**4*b**20*c**2 + 60*a**3*b**21*c**2 - 33*a**2*b**22*c**2 +
        13*a*b**23*c**2 - 3*b**24*c**2 - 2*a**11*b**12*c**3 +
        12*a**10*b**13*c**3 - 38*a**9*b**14*c**3 + 83*a**8*b**15*c**3
        - 137*a**7*b**16*c**3 + 180*a**6*b**17*c**3 -
        191*a**5*b**18*c**3 + 164*a**4*b**19*c**3 -
        113*a**3*b**20*c**3 + 60*a**2*b**21*c**3 - 23*a*b**22*c**3 +
        5*b**23*c**3 - a**12*b**10*c**4 + 9*a**11*b**11*c**4 -
        35*a**10*b**12*c**4 + 89*a**9*b**13*c**4 - 169*a**8*b**14*c**4
        + 253*a**7*b**15*c**4 - 308*a**6*b**16*c**4 +
        307*a**5*b**17*c**4 - 250*a**4*b**18*c**4 +
        164*a**3*b**19*c**4 - 83*a**2*b**20*c**4 + 30*a*b**21*c**4 -
        6*b**22*c**4 + 4*a**12*b**9*c**5 - 22*a**11*b**10*c**5 +
        68*a**10*b**11*c**5 - 151*a**9*b**12*c**5 +
        260*a**8*b**13*c**5 - 363*a**7*b**14*c**5 +
        417*a**6*b**15*c**5 - 395*a**5*b**16*c**5 +
        307*a**4*b**17*c**5 - 191*a**3*b**18*c**5 + 91*a**2*b**19*c**5
        - 30*a*b**20*c**5 + 5*b**21*c**5 + a**13*b**7*c**6 -
        9*a**12*b**8*c**6 + 36*a**11*b**9*c**6 - 96*a**10*b**10*c**6 +
        195*a**9*b**11*c**6 - 316*a**8*b**12*c**6 +
        420*a**7*b**13*c**6 - 461*a**6*b**14*c**6 +
        417*a**5*b**15*c**6 - 308*a**4*b**16*c**6 +
        180*a**3*b**17*c**6 - 79*a**2*b**18*c**6 + 23*a*b**19*c**6 -
        3*b**20*c**6 - 2*a**13*b**6*c**7 + 12*a**12*b**7*c**7 -
        41*a**11*b**8*c**7 + 102*a**10*b**9*c**7 - 198*a**9*b**10*c**7
        + 310*a**8*b**11*c**7 - 398*a**7*b**12*c**7 +
        420*a**6*b**13*c**7 - 363*a**5*b**14*c**7 +
        253*a**4*b**15*c**7 - 137*a**3*b**16*c**7 + 54*a**2*b**17*c**7
        - 13*a*b**18*c**7 + b**19*c**7 + 2*a**13*b**5*c**8 -
        10*a**12*b**6*c**8 + 33*a**11*b**7*c**8 - 82*a**10*b**8*c**8 +
        159*a**9*b**9*c**8 - 247*a**8*b**10*c**8 + 310*a**7*b**11*c**8
        - 316*a**6*b**12*c**8 + 260*a**5*b**13*c**8 -
        169*a**4*b**14*c**8 + 83*a**3*b**15*c**8 - 28*a**2*b**16*c**8
        + 5*a*b**17*c**8 - a**13*b**4*c**9 + 4*a**12*b**5*c**9 -
        16*a**11*b**6*c**9 + 47*a**10*b**7*c**9 - 99*a**9*b**8*c**9 +
        159*a**8*b**9*c**9 - 198*a**7*b**10*c**9 + 195*a**6*b**11*c**9
        - 151*a**5*b**12*c**9 + 89*a**4*b**13*c**9 -
        38*a**3*b**14*c**9 + 10*a**2*b**15*c**9 - a*b**16*c**9 -
        a**13*b**3*c**10 + 3*a**12*b**4*c**10 - 16*a**10*b**6*c**10 +
        47*a**9*b**7*c**10 - 82*a**8*b**8*c**10 + 102*a**7*b**9*c**10
        - 96*a**6*b**10*c**10 + 68*a**5*b**11*c**10 -
        35*a**4*b**12*c**10 + 12*a**3*b**13*c**10 - 2*a**2*b**14*c**10
        + 2*a**13*b**2*c**11 - 6*a**12*b**3*c**11 + 7*a**11*b**4*c**11
        - 16*a**9*b**6*c**11 + 33*a**8*b**7*c**11 - 41*a**7*b**8*c**11
        + 36*a**6*b**9*c**11 - 22*a**5*b**10*c**11 +
        9*a**4*b**11*c**11 - 2*a**3*b**12*c**11 - 2*a**13*b*c**12 +
        5*a**12*b**2*c**12 - 6*a**11*b**3*c**12 + 3*a**10*b**4*c**12 +
        4*a**9*b**5*c**12 - 10*a**8*b**6*c**12 + 12*a**7*b**7*c**12 -
        9*a**6*b**8*c**12 + 4*a**5*b**9*c**12 - a**4*b**10*c**12 +
        a**13*c**13 - 2*a**12*b*c**13 + 2*a**11*b**2*c**13 -
        a**10*b**3*c**13 - a**9*b**4*c**13 + 2*a**8*b**5*c**13 -
        2*a**7*b**6*c**13 + a**6*b**7*c**13), (-4*a**8*b**3*c**2 -
        3*a**7*b**4*c**2 + a**6*b**5*c**2 - 4*a**8*b**2*c**3 -
        11*a**7*b**3*c**3 - 4*a**6*b**4*c**3 + a**5*b**5*c**3 -
        a**4*b**6*c**3 - 3*a**7*b**2*c**4 - 4*a**6*b**3*c**4 -
        2*a**5*b**4*c**4 - 5*a**4*b**5*c**4 - 4*a**3*b**6*c**4 +
        a**6*b**2*c**5 + a**5*b**3*c**5 - 5*a**4*b**4*c**5 -
        10*a**3*b**5*c**5 - 5*a**2*b**6*c**5 - a**4*b**3*c**6 -
        4*a**3*b**4*c**6 - 5*a**2*b**5*c**6 -
        2*a*b**6*c**6)/(a**13*b**5 - a**12*b**6 - a**11*b**7 +
        a**10*b**8 - 2*a**13*b**4*c + 2*a**12*b**5*c + 4*a**11*b**6*c
        - 4*a**10*b**7*c - 2*a**9*b**8*c + 2*a**8*b**9*c +
        a**13*b**3*c**2 - 2*a**12*b**4*c**2 - 6*a**11*b**5*c**2 +
        8*a**10*b**6*c**2 + 7*a**9*b**7*c**2 - 8*a**8*b**8*c**2 -
        2*a**7*b**9*c**2 + 2*a**6*b**10*c**2 + a**13*b**2*c**3 +
        2*a**12*b**3*c**3 + 3*a**11*b**4*c**3 - 11*a**10*b**5*c**3 -
        10*a**9*b**6*c**3 + 17*a**8*b**7*c**3 + 7*a**7*b**8*c**3 -
        9*a**6*b**9*c**3 - a**5*b**10*c**3 + a**4*b**11*c**3 -
        2*a**13*b*c**4 - 2*a**12*b**2*c**4 + 3*a**11*b**3*c**4 +
        12*a**10*b**4*c**4 + 5*a**9*b**5*c**4 - 25*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 + 21*a**6*b**8*c**4 + 4*a**5*b**9*c**4 -
        6*a**4*b**10*c**4 + a**13*c**5 + 2*a**12*b*c**5 -
        6*a**11*b**2*c**5 - 11*a**10*b**3*c**5 + 5*a**9*b**4*c**5 +
        28*a**8*b**5*c**5 + 5*a**7*b**6*c**5 - 33*a**6*b**7*c**5 -
        6*a**5*b**8*c**5 + 16*a**4*b**9*c**5 + a**3*b**10*c**5 -
        2*a**2*b**11*c**5 - a**12*c**6 + 4*a**11*b*c**6 +
        8*a**10*b**2*c**6 - 10*a**9*b**3*c**6 - 25*a**8*b**4*c**6 +
        5*a**7*b**5*c**6 + 38*a**6*b**6*c**6 + 3*a**5*b**7*c**6 -
        27*a**4*b**8*c**6 - 2*a**3*b**9*c**6 + 7*a**2*b**10*c**6 -
        a**11*c**7 - 4*a**10*b*c**7 + 7*a**9*b**2*c**7 +
        17*a**8*b**3*c**7 - 10*a**7*b**4*c**7 - 33*a**6*b**5*c**7 +
        3*a**5*b**6*c**7 + 32*a**4*b**7*c**7 + a**3*b**8*c**7 -
        13*a**2*b**9*c**7 + b**11*c**7 + a**10*c**8 - 2*a**9*b*c**8 -
        8*a**8*b**2*c**8 + 7*a**7*b**3*c**8 + 21*a**6*b**4*c**8 -
        6*a**5*b**5*c**8 - 27*a**4*b**6*c**8 + a**3*b**7*c**8 +
        16*a**2*b**8*c**8 - 3*b**10*c**8 + 2*a**8*b*c**9 -
        2*a**7*b**2*c**9 - 9*a**6*b**3*c**9 + 4*a**5*b**4*c**9 +
        16*a**4*b**5*c**9 - 2*a**3*b**6*c**9 - 13*a**2*b**7*c**9 +
        4*b**9*c**9 + 2*a**6*b**2*c**10 - a**5*b**3*c**10 -
        6*a**4*b**4*c**10 + a**3*b**5*c**10 + 7*a**2*b**6*c**10 -
        3*b**8*c**10 + a**4*b**3*c**11 - 2*a**2*b**5*c**11 +
        b**7*c**11), (-2*a**6*b**6*c - 5*a**6*b**5*c**2 -
        5*a**5*b**6*c**2 - 4*a**6*b**4*c**3 - 10*a**5*b**5*c**3 -
        4*a**4*b**6*c**3 - a**6*b**3*c**4 - 5*a**5*b**4*c**4 -
        5*a**4*b**5*c**4 - a**3*b**6*c**4 + a**5*b**3*c**5 -
        2*a**4*b**4*c**5 + a**3*b**5*c**5 + a**5*b**2*c**6 -
        4*a**4*b**3*c**6 - 4*a**3*b**4*c**6 + a**2*b**5*c**6 -
        3*a**4*b**2*c**7 - 11*a**3*b**3*c**7 - 3*a**2*b**4*c**7 -
        4*a**3*b**2*c**8 - 4*a**2*b**3*c**8)/(a**11*b**7 -
        3*a**10*b**8 + 4*a**9*b**9 - 3*a**8*b**10 + a**7*b**11 -
        2*a**11*b**5*c**2 + 7*a**10*b**6*c**2 - 13*a**9*b**7*c**2 +
        16*a**8*b**8*c**2 - 13*a**7*b**9*c**2 + 7*a**6*b**10*c**2 -
        2*a**5*b**11*c**2 + a**10*b**5*c**3 - 2*a**9*b**6*c**3 +
        a**8*b**7*c**3 + a**7*b**8*c**3 - 2*a**6*b**9*c**3 +
        a**5*b**10*c**3 + a**11*b**3*c**4 - 6*a**10*b**4*c**4 +
        16*a**9*b**5*c**4 - 27*a**8*b**6*c**4 + 32*a**7*b**7*c**4 -
        27*a**6*b**8*c**4 + 16*a**5*b**9*c**4 - 6*a**4*b**10*c**4 +
        a**3*b**11*c**4 - a**10*b**3*c**5 + 4*a**9*b**4*c**5 -
        6*a**8*b**5*c**5 + 3*a**7*b**6*c**5 + 3*a**6*b**7*c**5 -
        6*a**5*b**8*c**5 + 4*a**4*b**9*c**5 - a**3*b**10*c**5 +
        2*a**10*b**2*c**6 - 9*a**9*b**3*c**6 + 21*a**8*b**4*c**6 -
        33*a**7*b**5*c**6 + 38*a**6*b**6*c**6 - 33*a**5*b**7*c**6 +
        21*a**4*b**8*c**6 - 9*a**3*b**9*c**6 + 2*a**2*b**10*c**6 -
        2*a**9*b**2*c**7 + 7*a**8*b**3*c**7 - 10*a**7*b**4*c**7 +
        5*a**6*b**5*c**7 + 5*a**5*b**6*c**7 - 10*a**4*b**7*c**7 +
        7*a**3*b**8*c**7 - 2*a**2*b**9*c**7 + 2*a**9*b*c**8 -
        8*a**8*b**2*c**8 + 17*a**7*b**3*c**8 - 25*a**6*b**4*c**8 +
        28*a**5*b**5*c**8 - 25*a**4*b**6*c**8 + 17*a**3*b**7*c**8 -
        8*a**2*b**8*c**8 + 2*a*b**9*c**8 - 2*a**8*b*c**9 +
        7*a**7*b**2*c**9 - 10*a**6*b**3*c**9 + 5*a**5*b**4*c**9 +
        5*a**4*b**5*c**9 - 10*a**3*b**6*c**9 + 7*a**2*b**7*c**9 -
        2*a*b**8*c**9 + a**8*c**10 - 4*a**7*b*c**10 +
        8*a**6*b**2*c**10 - 11*a**5*b**3*c**10 + 12*a**4*b**4*c**10 -
        11*a**3*b**5*c**10 + 8*a**2*b**6*c**10 - 4*a*b**7*c**10 +
        b**8*c**10 - a**7*c**11 + 4*a**6*b*c**11 - 6*a**5*b**2*c**11 +
        3*a**4*b**3*c**11 + 3*a**3*b**4*c**11 - 6*a**2*b**5*c**11 +
        4*a*b**6*c**11 - b**7*c**11 - a**6*c**12 + 2*a**5*b*c**12 -
        2*a**4*b**2*c**12 + 2*a**3*b**3*c**12 - 2*a**2*b**4*c**12 +
        2*a*b**5*c**12 - b**6*c**12 + a**5*c**13 - 2*a**4*b*c**13 +
        a**3*b**2*c**13 + a**2*b**3*c**13 - 2*a*b**4*c**13 +
        b**5*c**13), (a**5*b**6*c**2 - 3*a**4*b**7*c**2 -
        4*a**3*b**8*c**2 - a**6*b**4*c**3 + a**5*b**5*c**3 -
        4*a**4*b**6*c**3 - 11*a**3*b**7*c**3 - 4*a**2*b**8*c**3 -
        4*a**6*b**3*c**4 - 5*a**5*b**4*c**4 - 2*a**4*b**5*c**4 -
        4*a**3*b**6*c**4 - 3*a**2*b**7*c**4 - 5*a**6*b**2*c**5 -
        10*a**5*b**3*c**5 - 5*a**4*b**4*c**5 + a**3*b**5*c**5 +
        a**2*b**6*c**5 - 2*a**6*b*c**6 - 5*a**5*b**2*c**6 -
        4*a**4*b**3*c**6 - a**3*b**4*c**6)/(a**8*b**10 - a**7*b**11 -
        a**6*b**12 + a**5*b**13 + 2*a**9*b**8*c - 2*a**8*b**9*c -
        4*a**7*b**10*c + 4*a**6*b**11*c + 2*a**5*b**12*c -
        2*a**4*b**13*c + 2*a**10*b**6*c**2 - 2*a**9*b**7*c**2 -
        8*a**8*b**8*c**2 + 7*a**7*b**9*c**2 + 8*a**6*b**10*c**2 -
        6*a**5*b**11*c**2 - 2*a**4*b**12*c**2 + a**3*b**13*c**2 +
        a**11*b**4*c**3 - a**10*b**5*c**3 - 9*a**9*b**6*c**3 +
        7*a**8*b**7*c**3 + 17*a**7*b**8*c**3 - 10*a**6*b**9*c**3 -
        11*a**5*b**10*c**3 + 3*a**4*b**11*c**3 + 2*a**3*b**12*c**3 +
        a**2*b**13*c**3 - 6*a**10*b**4*c**4 + 4*a**9*b**5*c**4 +
        21*a**8*b**6*c**4 - 10*a**7*b**7*c**4 - 25*a**6*b**8*c**4 +
        5*a**5*b**9*c**4 + 12*a**4*b**10*c**4 + 3*a**3*b**11*c**4 -
        2*a**2*b**12*c**4 - 2*a*b**13*c**4 - 2*a**11*b**2*c**5 +
        a**10*b**3*c**5 + 16*a**9*b**4*c**5 - 6*a**8*b**5*c**5 -
        33*a**7*b**6*c**5 + 5*a**6*b**7*c**5 + 28*a**5*b**8*c**5 +
        5*a**4*b**9*c**5 - 11*a**3*b**10*c**5 - 6*a**2*b**11*c**5 +
        2*a*b**12*c**5 + b**13*c**5 + 7*a**10*b**2*c**6 -
        2*a**9*b**3*c**6 - 27*a**8*b**4*c**6 + 3*a**7*b**5*c**6 +
        38*a**6*b**6*c**6 + 5*a**5*b**7*c**6 - 25*a**4*b**8*c**6 -
        10*a**3*b**9*c**6 + 8*a**2*b**10*c**6 + 4*a*b**11*c**6 -
        b**12*c**6 + a**11*c**7 - 13*a**9*b**2*c**7 + a**8*b**3*c**7 +
        32*a**7*b**4*c**7 + 3*a**6*b**5*c**7 - 33*a**5*b**6*c**7 -
        10*a**4*b**7*c**7 + 17*a**3*b**8*c**7 + 7*a**2*b**9*c**7 -
        4*a*b**10*c**7 - b**11*c**7 - 3*a**10*c**8 + 16*a**8*b**2*c**8
        + a**7*b**3*c**8 - 27*a**6*b**4*c**8 - 6*a**5*b**5*c**8 +
        21*a**4*b**6*c**8 + 7*a**3*b**7*c**8 - 8*a**2*b**8*c**8 -
        2*a*b**9*c**8 + b**10*c**8 + 4*a**9*c**9 - 13*a**7*b**2*c**9 -
        2*a**6*b**3*c**9 + 16*a**5*b**4*c**9 + 4*a**4*b**5*c**9 -
        9*a**3*b**6*c**9 - 2*a**2*b**7*c**9 + 2*a*b**8*c**9 -
        3*a**8*c**10 + 7*a**6*b**2*c**10 + a**5*b**3*c**10 -
        6*a**4*b**4*c**10 - a**3*b**5*c**10 + 2*a**2*b**6*c**10 +
        a**7*c**11 - 2*a**5*b**2*c**11 + a**3*b**4*c**11),
        (2*a**4*b**4*c + 8*a**4*b**3*c**2 + 8*a**3*b**4*c**2 +
        8*a**4*b**2*c**3 + 19*a**3*b**3*c**3 + 8*a**2*b**4*c**3 +
        2*a**4*b*c**4 + 8*a**3*b**2*c**4 + 8*a**2*b**3*c**4 +
        2*a*b**4*c**4)/(a**8*b**6 - 2*a**7*b**7 + a**6*b**8 +
        a**9*b**4*c - 3*a**8*b**5*c + 2*a**7*b**6*c + 2*a**6*b**7*c -
        3*a**5*b**8*c + a**4*b**9*c - a**9*b**3*c**2 +
        5*a**7*b**5*c**2 - 8*a**6*b**6*c**2 + 5*a**5*b**7*c**2 -
        a**3*b**9*c**2 - a**9*b**2*c**3 + 4*a**8*b**3*c**3 -
        5*a**7*b**4*c**3 + 2*a**6*b**5*c**3 + 2*a**5*b**6*c**3 -
        5*a**4*b**7*c**3 + 4*a**3*b**8*c**3 - a**2*b**9*c**3 +
        a**9*b*c**4 - 5*a**7*b**3*c**4 + 6*a**6*b**4*c**4 -
        4*a**5*b**5*c**4 + 6*a**4*b**6*c**4 - 5*a**3*b**7*c**4 +
        a*b**9*c**4 - 3*a**8*b*c**5 + 5*a**7*b**2*c**5 +
        2*a**6*b**3*c**5 - 4*a**5*b**4*c**5 - 4*a**4*b**5*c**5 +
        2*a**3*b**6*c**5 + 5*a**2*b**7*c**5 - 3*a*b**8*c**5 +
        a**8*c**6 + 2*a**7*b*c**6 - 8*a**6*b**2*c**6 +
        2*a**5*b**3*c**6 + 6*a**4*b**4*c**6 + 2*a**3*b**5*c**6 -
        8*a**2*b**6*c**6 + 2*a*b**7*c**6 + b**8*c**6 - 2*a**7*c**7 +
        2*a**6*b*c**7 + 5*a**5*b**2*c**7 - 5*a**4*b**3*c**7 -
        5*a**3*b**4*c**7 + 5*a**2*b**5*c**7 + 2*a*b**6*c**7 -
        2*b**7*c**7 + a**6*c**8 - 3*a**5*b*c**8 + 4*a**3*b**3*c**8 -
        3*a*b**5*c**8 + b**6*c**8 + a**4*b*c**9 - a**3*b**2*c**9 -
        a**2*b**3*c**9 + a*b**4*c**9), (2*a**4*b**9*c +
        5*a**4*b**8*c**2 + 5*a**3*b**9*c**2 + 5*a**4*b**7*c**3 +
        8*a**3*b**8*c**3 + 5*a**2*b**9*c**3 + a**4*b**6*c**4 +
        5*a**3*b**7*c**4 + 4*a**2*b**8*c**4 + 2*a*b**9*c**4 +
        4*a**4*b**4*c**6 + 3*a**3*b**5*c**6 - a*b**7*c**6 +
        3*a**4*b**3*c**7 + 10*a**3*b**4*c**7 + 3*a**2*b**5*c**7 +
        a*b**6*c**7 + 4*a**3*b**3*c**8 + 4*a**2*b**4*c**8)/(a**8*b**11
        - 2*a**7*b**12 + 2*a**6*b**13 - 2*a**5*b**14 + a**4*b**15 +
        a**9*b**9*c - 3*a**8*b**10*c + 4*a**7*b**11*c - 4*a**6*b**12*c
        + 3*a**5*b**13*c - a**4*b**14*c - a**9*b**8*c**2 +
        a**8*b**9*c**2 - a**6*b**11*c**2 + 3*a**5*b**12*c**2 -
        3*a**4*b**13*c**2 + 2*a**3*b**14*c**2 - a**2*b**15*c**2 -
        a**9*b**7*c**3 + 4*a**8*b**8*c**3 - 7*a**7*b**9*c**3 +
        10*a**6*b**10*c**3 - 11*a**5*b**11*c**3 + 8*a**4*b**12*c**3 -
        5*a**3*b**13*c**3 + 2*a**2*b**14*c**3 + 2*a**9*b**6*c**4 -
        5*a**8*b**7*c**4 + 7*a**7*b**8*c**4 - 10*a**6*b**9*c**4 +
        9*a**5*b**10*c**4 - 5*a**4*b**11*c**4 + 3*a**3*b**12*c**4 -
        a*b**14*c**4 - a**9*b**5*c**5 + 2*a**7*b**7*c**5 -
        2*a**6*b**8*c**5 + 6*a**5*b**9*c**5 - 8*a**4*b**10*c**5 +
        6*a**3*b**11*c**5 - 6*a**2*b**12*c**5 + 3*a*b**13*c**5 -
        a**9*b**4*c**6 + 5*a**8*b**5*c**6 - 8*a**7*b**6*c**6 +
        11*a**6*b**7*c**6 - 16*a**5*b**8*c**6 + 15*a**4*b**9*c**6 -
        12*a**3*b**10*c**6 + 9*a**2*b**11*c**6 - 3*a*b**12*c**6 +
        a**9*b**3*c**7 - 3*a**8*b**4*c**7 + 3*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 8*a**5*b**7*c**7 - 6*a**4*b**8*c**7 +
        5*a**3*b**9*c**7 - 3*a**2*b**10*c**7 - a*b**11*c**7 +
        b**12*c**7 - a**8*b**3*c**8 + 4*a**7*b**4*c**8 -
        4*a**6*b**5*c**8 + 4*a**5*b**6*c**8 - 7*a**4*b**7*c**8 +
        6*a**3*b**8*c**8 - 6*a**2*b**9*c**8 + 6*a*b**10*c**8 -
        2*b**11*c**8 + 2*a**8*b**2*c**9 - 4*a**7*b**3*c**9 +
        3*a**6*b**4*c**9 - 6*a**5*b**5*c**9 + 9*a**4*b**6*c**9 -
        8*a**3*b**7*c**9 + 9*a**2*b**8*c**9 - 6*a*b**9*c**9 +
        b**10*c**9 - a**8*b*c**10 + 2*a**6*b**3*c**10 +
        a**5*b**4*c**10 - 2*a**4*b**5*c**10 + 2*a**3*b**6*c**10 -
        4*a**2*b**7*c**10 + a*b**8*c**10 + b**9*c**10 + 2*a**7*b*c**11
        - 3*a**6*b**2*c**11 + a**5*b**3*c**11 - 2*a**4*b**4*c**11 +
        2*a**3*b**5*c**11 - a**2*b**6*c**11 + 3*a*b**7*c**11 -
        2*b**8*c**11 - a**7*c**12 + a**5*b**2*c**12 + a**4*b**3*c**12
        - a**3*b**4*c**12 + 2*a**2*b**5*c**12 - 3*a*b**6*c**12 +
        b**7*c**12 + a**6*c**13 - a**5*b*c**13 - a**2*b**4*c**13 +
        a*b**5*c**13), (2*a**9*b**4*c - a**7*b**6*c + a**6*b**7*c +
        5*a**9*b**3*c**2 + 4*a**8*b**4*c**2 + 3*a**5*b**7*c**2 +
        4*a**4*b**8*c**2 + 5*a**9*b**2*c**3 + 8*a**8*b**3*c**3 +
        5*a**7*b**4*c**3 + 3*a**5*b**6*c**3 + 10*a**4*b**7*c**3 +
        4*a**3*b**8*c**3 + 2*a**9*b*c**4 + 5*a**8*b**2*c**4 +
        5*a**7*b**3*c**4 + a**6*b**4*c**4 + 4*a**4*b**6*c**4 +
        3*a**3*b**7*c**4)/(a**12*b**7 - 2*a**11*b**8 + a**10*b**9 +
        a**9*b**10 - 2*a**8*b**11 + a**7*b**12 - a**14*b**4*c +
        3*a**13*b**5*c - 3*a**12*b**6*c - a**11*b**7*c +
        6*a**10*b**8*c - 6*a**9*b**9*c + a**8*b**10*c + 3*a**7*b**11*c
        - 3*a**6*b**12*c + a**5*b**13*c - a**15*b**2*c**2 +
        2*a**14*b**3*c**2 - 6*a**12*b**5*c**2 + 9*a**11*b**6*c**2 -
        3*a**10*b**7*c**2 - 6*a**9*b**8*c**2 + 9*a**8*b**9*c**2 -
        4*a**7*b**10*c**2 - a**6*b**11*c**2 + 2*a**5*b**12*c**2 -
        a**4*b**13*c**2 + 2*a**14*b**2*c**3 - 5*a**13*b**3*c**3 +
        3*a**12*b**4*c**3 + 6*a**11*b**5*c**3 - 12*a**10*b**6*c**3 +
        5*a**9*b**7*c**3 + 6*a**8*b**8*c**3 - 8*a**7*b**9*c**3 +
        2*a**6*b**10*c**3 + 2*a**5*b**11*c**3 - a**4*b**12*c**3 +
        a**15*c**4 - a**14*b*c**4 - 3*a**13*b**2*c**4 +
        8*a**12*b**3*c**4 - 5*a**11*b**4*c**4 - 8*a**10*b**5*c**4 +
        15*a**9*b**6*c**4 - 6*a**8*b**7*c**4 - 7*a**7*b**8*c**4 +
        9*a**6*b**9*c**4 - 2*a**5*b**10*c**4 - 2*a**4*b**11*c**4 +
        a**3*b**12*c**4 - 2*a**14*c**5 + 3*a**13*b*c**5 +
        3*a**12*b**2*c**5 - 11*a**11*b**3*c**5 + 9*a**10*b**4*c**5 +
        6*a**9*b**5*c**5 - 16*a**8*b**6*c**5 + 8*a**7*b**7*c**5 +
        4*a**6*b**8*c**5 - 6*a**5*b**9*c**5 + a**4*b**10*c**5 +
        a**3*b**11*c**5 + a**2*b**12*c**5 - a*b**13*c**5 +
        2*a**13*c**6 - 4*a**12*b*c**6 - a**11*b**2*c**6 +
        10*a**10*b**3*c**6 - 10*a**9*b**4*c**6 - 2*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 +
        3*a**4*b**9*c**6 + 2*a**3*b**10*c**6 - 3*a**2*b**11*c**6 +
        b**13*c**6 - 2*a**12*c**7 + 4*a**11*b*c**7 - 7*a**9*b**3*c**7
        + 7*a**8*b**4*c**7 + 2*a**7*b**5*c**7 - 8*a**6*b**6*c**7 +
        3*a**5*b**7*c**7 + 4*a**4*b**8*c**7 - 4*a**3*b**9*c**7 +
        2*a*b**11*c**7 - b**12*c**7 + a**11*c**8 - 3*a**10*b*c**8 +
        a**9*b**2*c**8 + 4*a**8*b**3*c**8 - 5*a**7*b**4*c**8 +
        5*a**5*b**6*c**8 - 3*a**4*b**7*c**8 - a**3*b**8*c**8 +
        2*a**2*b**9*c**8 - a*b**10*c**8 + a**9*b*c**9 - a**8*b**2*c**9
        - a**7*b**3*c**9 + 2*a**6*b**4*c**9 - a**5*b**5*c**9 -
        a**4*b**6*c**9 + a**3*b**7*c**9), (4*a**8*b**3*c**3 +
        3*a**7*b**4*c**3 + 4*a**8*b**2*c**4 + 10*a**7*b**3*c**4 +
        4*a**6*b**4*c**4 + 3*a**7*b**2*c**5 + 3*a**6*b**3*c**5 +
        a**7*b*c**6 + a**4*b**4*c**6 - a**6*b*c**7 + 5*a**4*b**3*c**7
        + 5*a**3*b**4*c**7 + 4*a**4*b**2*c**8 + 8*a**3*b**3*c**8 +
        5*a**2*b**4*c**8 + 2*a**4*b*c**9 + 5*a**3*b**2*c**9 +
        5*a**2*b**3*c**9 + 2*a*b**4*c**9)/(a**13*b**6 - a**12*b**7 -
        a**13*b**5*c + 2*a**11*b**7*c - a**10*b**8*c + a**12*b**5*c**2
        - 3*a**11*b**6*c**2 + 2*a**9*b**8*c**2 + a**12*b**4*c**3 +
        a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 4*a**9*b**7*c**3 -
        a**8*b**8*c**3 + a**7*b**9*c**3 - a**13*b**2*c**4 -
        a**12*b**3*c**4 - 2*a**11*b**4*c**4 + a**10*b**5*c**4 +
        3*a**9*b**6*c**4 + 4*a**8*b**7*c**4 - 3*a**7*b**8*c**4 -
        a**6*b**9*c**4 + a**13*b*c**5 + 2*a**12*b**2*c**5 +
        2*a**11*b**3*c**5 - 2*a**10*b**4*c**5 - 6*a**9*b**5*c**5 -
        4*a**8*b**6*c**5 + 3*a**7*b**7*c**5 + 5*a**6*b**8*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 - a**11*b**2*c**6 +
        2*a**10*b**3*c**6 + 9*a**9*b**4*c**6 + 4*a**8*b**5*c**6 -
        5*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 2*a**4*b**9*c**6 +
        a**12*c**7 + 3*a**11*b*c**7 - 4*a**10*b**2*c**7 -
        8*a**9*b**3*c**7 - 7*a**8*b**4*c**7 + 8*a**7*b**5*c**7 +
        11*a**6*b**6*c**7 + 2*a**5*b**7*c**7 - 5*a**4*b**8*c**7 -
        a**3*b**9*c**7 - 2*a**11*c**8 + a**10*b*c**8 +
        9*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 6*a**7*b**4*c**8 -
        16*a**6*b**5*c**8 - 2*a**5*b**6*c**8 + 7*a**4*b**7*c**8 +
        4*a**3*b**8*c**8 - a**2*b**9*c**8 + a**10*c**9 - 6*a**9*b*c**9
        - 6*a**8*b**2*c**9 + 5*a**7*b**3*c**9 + 15*a**6*b**4*c**9 +
        6*a**5*b**5*c**9 - 10*a**4*b**6*c**9 - 7*a**3*b**7*c**9 +
        a**2*b**8*c**9 + a*b**9*c**9 + a**9*c**10 + 6*a**8*b*c**10 -
        3*a**7*b**2*c**10 - 12*a**6*b**3*c**10 - 8*a**5*b**4*c**10 +
        9*a**4*b**5*c**10 + 10*a**3*b**6*c**10 - 3*a*b**8*c**10 -
        2*a**8*c**11 - a**7*b*c**11 + 9*a**6*b**2*c**11 +
        6*a**5*b**3*c**11 - 5*a**4*b**4*c**11 - 11*a**3*b**5*c**11 -
        a**2*b**6*c**11 + 4*a*b**7*c**11 + b**8*c**11 + a**7*c**12 -
        3*a**6*b*c**12 - 6*a**5*b**2*c**12 + 3*a**4*b**3*c**12 +
        8*a**3*b**4*c**12 + 3*a**2*b**5*c**12 - 4*a*b**6*c**12 -
        2*b**7*c**12 + 3*a**5*b*c**13 - 5*a**3*b**3*c**13 -
        3*a**2*b**4*c**13 + 3*a*b**5*c**13 + 2*b**6*c**13 -
        a**4*b*c**14 + 2*a**3*b**2*c**14 + 2*a**2*b**3*c**14 -
        a*b**4*c**14 - 2*b**5*c**14 - a**2*b**2*c**15 + b**4*c**15),
        (-3*a**4*b**7*c**3 - 4*a**3*b**8*c**3 - 4*a**4*b**6*c**4 -
        10*a**3*b**7*c**4 - 4*a**2*b**8*c**4 - 3*a**3*b**6*c**5 -
        3*a**2*b**7*c**5 - a**4*b**4*c**6 - a*b**7*c**6 -
        5*a**4*b**3*c**7 - 5*a**3*b**4*c**7 + a*b**6*c**7 -
        5*a**4*b**2*c**8 - 8*a**3*b**3*c**8 - 4*a**2*b**4*c**8 -
        2*a**4*b*c**9 - 5*a**3*b**2*c**9 - 5*a**2*b**3*c**9 -
        2*a*b**4*c**9)/(a**7*b**12 - a**6*b**13 + a**8*b**10*c -
        2*a**7*b**11*c + a**5*b**13*c - 2*a**8*b**9*c**2 +
        3*a**6*b**11*c**2 - a**5*b**12*c**2 - a**9*b**7*c**3 +
        a**8*b**8*c**3 + 4*a**7*b**9*c**3 - 2*a**6*b**10*c**3 -
        a**5*b**11*c**3 - a**4*b**12*c**3 + a**9*b**6*c**4 +
        3*a**8*b**7*c**4 - 4*a**7*b**8*c**4 - 3*a**6*b**9*c**4 -
        a**5*b**10*c**4 + 2*a**4*b**11*c**4 + a**3*b**12*c**4 +
        a**2*b**13*c**4 + a**9*b**5*c**5 - 5*a**8*b**6*c**5 -
        3*a**7*b**7*c**5 + 4*a**6*b**8*c**5 + 6*a**5*b**9*c**5 +
        2*a**4*b**10*c**5 - 2*a**3*b**11*c**5 - 2*a**2*b**12*c**5 -
        a*b**13*c**5 - 2*a**9*b**4*c**6 + 8*a**7*b**6*c**6 +
        5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 - 9*a**4*b**9*c**6 -
        2*a**3*b**10*c**6 + a**2*b**11*c**6 + 3*a*b**12*c**6 +
        a**9*b**3*c**7 + 5*a**8*b**4*c**7 - 2*a**7*b**5*c**7 -
        11*a**6*b**6*c**7 - 8*a**5*b**7*c**7 + 7*a**4*b**8*c**7 +
        8*a**3*b**9*c**7 + 4*a**2*b**10*c**7 - 3*a*b**11*c**7 -
        b**12*c**7 + a**9*b**2*c**8 - 4*a**8*b**3*c**8 -
        7*a**7*b**4*c**8 + 2*a**6*b**5*c**8 + 16*a**5*b**6*c**8 +
        6*a**4*b**7*c**8 - 6*a**3*b**8*c**8 - 9*a**2*b**9*c**8 -
        a*b**10*c**8 + 2*b**11*c**8 - a**9*b*c**9 - a**8*b**2*c**9 +
        7*a**7*b**3*c**9 + 10*a**6*b**4*c**9 - 6*a**5*b**5*c**9 -
        15*a**4*b**6*c**9 - 5*a**3*b**7*c**9 + 6*a**2*b**8*c**9 +
        6*a*b**9*c**9 - b**10*c**9 + 3*a**8*b*c**10 -
        10*a**6*b**3*c**10 - 9*a**5*b**4*c**10 + 8*a**4*b**5*c**10 +
        12*a**3*b**6*c**10 + 3*a**2*b**7*c**10 - 6*a*b**8*c**10 -
        b**9*c**10 - a**8*c**11 - 4*a**7*b*c**11 + a**6*b**2*c**11 +
        11*a**5*b**3*c**11 + 5*a**4*b**4*c**11 - 6*a**3*b**5*c**11 -
        9*a**2*b**6*c**11 + a*b**7*c**11 + 2*b**8*c**11 + 2*a**7*c**12
        + 4*a**6*b*c**12 - 3*a**5*b**2*c**12 - 8*a**4*b**3*c**12 -
        3*a**3*b**4*c**12 + 6*a**2*b**5*c**12 + 3*a*b**6*c**12 -
        b**7*c**12 - 2*a**6*c**13 - 3*a**5*b*c**13 + 3*a**4*b**2*c**13
        + 5*a**3*b**3*c**13 - 3*a*b**5*c**13 + 2*a**5*c**14 +
        a**4*b*c**14 - 2*a**3*b**2*c**14 - 2*a**2*b**3*c**14 +
        a*b**4*c**14 - a**4*c**15 + a**2*b**2*c**15), (2*a**9*b**4*c +
        5*a**9*b**3*c**2 + 5*a**8*b**4*c**2 + 5*a**9*b**2*c**3 +
        8*a**8*b**3*c**3 + 5*a**7*b**4*c**3 + 2*a**9*b*c**4 +
        4*a**8*b**2*c**4 + 5*a**7*b**3*c**4 + a**6*b**4*c**4 -
        a**7*b*c**6 + 3*a**5*b**3*c**6 + 4*a**4*b**4*c**6 +
        a**6*b*c**7 + 3*a**5*b**2*c**7 + 10*a**4*b**3*c**7 +
        3*a**3*b**4*c**7 + 4*a**4*b**2*c**8 +
        4*a**3*b**3*c**8)/(a**15*b**4 - 2*a**14*b**5 + 2*a**13*b**6 -
        2*a**12*b**7 + a**11*b**8 - a**14*b**4*c + 3*a**13*b**5*c -
        4*a**12*b**6*c + 4*a**11*b**7*c - 3*a**10*b**8*c + a**9*b**9*c
        - a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 3*a**13*b**4*c**2 +
        3*a**12*b**5*c**2 - a**11*b**6*c**2 + a**9*b**8*c**2 -
        a**8*b**9*c**2 + 2*a**14*b**2*c**3 - 5*a**13*b**3*c**3 +
        8*a**12*b**4*c**3 - 11*a**11*b**5*c**3 + 10*a**10*b**6*c**3 -
        7*a**9*b**7*c**3 + 4*a**8*b**8*c**3 - a**7*b**9*c**3 -
        a**14*b*c**4 + 3*a**12*b**3*c**4 - 5*a**11*b**4*c**4 +
        9*a**10*b**5*c**4 - 10*a**9*b**6*c**4 + 7*a**8*b**7*c**4 -
        5*a**7*b**8*c**4 + 2*a**6*b**9*c**4 + 3*a**13*b*c**5 -
        6*a**12*b**2*c**5 + 6*a**11*b**3*c**5 - 8*a**10*b**4*c**5 +
        6*a**9*b**5*c**5 - 2*a**8*b**6*c**5 + 2*a**7*b**7*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 + 9*a**11*b**2*c**6 -
        12*a**10*b**3*c**6 + 15*a**9*b**4*c**6 - 16*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 5*a**5*b**8*c**6 -
        a**4*b**9*c**6 + a**12*c**7 - a**11*b*c**7 - 3*a**10*b**2*c**7
        + 5*a**9*b**3*c**7 - 6*a**8*b**4*c**7 + 8*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 3*a**5*b**7*c**7 - 3*a**4*b**8*c**7 +
        a**3*b**9*c**7 - 2*a**11*c**8 + 6*a**10*b*c**8 -
        6*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 7*a**7*b**4*c**8 +
        4*a**6*b**5*c**8 - 4*a**5*b**6*c**8 + 4*a**4*b**7*c**8 -
        a**3*b**8*c**8 + a**10*c**9 - 6*a**9*b*c**9 + 9*a**8*b**2*c**9
        - 8*a**7*b**3*c**9 + 9*a**6*b**4*c**9 - 6*a**5*b**5*c**9 +
        3*a**4*b**6*c**9 - 4*a**3*b**7*c**9 + 2*a**2*b**8*c**9 +
        a**9*c**10 + a**8*b*c**10 - 4*a**7*b**2*c**10 +
        2*a**6*b**3*c**10 - 2*a**5*b**4*c**10 + a**4*b**5*c**10 +
        2*a**3*b**6*c**10 - a*b**8*c**10 - 2*a**8*c**11 +
        3*a**7*b*c**11 - a**6*b**2*c**11 + 2*a**5*b**3*c**11 -
        2*a**4*b**4*c**11 + a**3*b**5*c**11 - 3*a**2*b**6*c**11 +
        2*a*b**7*c**11 + a**7*c**12 - 3*a**6*b*c**12 +
        2*a**5*b**2*c**12 - a**4*b**3*c**12 + a**3*b**4*c**12 +
        a**2*b**5*c**12 - b**7*c**12 + a**5*b*c**13 - a**4*b**2*c**13
        - a*b**5*c**13 + b**6*c**13), (a**7*b**6*c - a**6*b**7*c +
        2*a**4*b**9*c + 4*a**8*b**4*c**2 + 3*a**7*b**5*c**2 +
        4*a**4*b**8*c**2 + 5*a**3*b**9*c**2 + 4*a**8*b**3*c**3 +
        10*a**7*b**4*c**3 + 3*a**6*b**5*c**3 + 5*a**4*b**7*c**3 +
        8*a**3*b**8*c**3 + 5*a**2*b**9*c**3 + 3*a**7*b**3*c**4 +
        4*a**6*b**4*c**4 + a**4*b**6*c**4 + 5*a**3*b**7*c**4 +
        5*a**2*b**8*c**4 + 2*a*b**9*c**4)/(a**12*b**7 - 2*a**11*b**8 +
        a**10*b**9 + a**9*b**10 - 2*a**8*b**11 + a**7*b**12 +
        a**13*b**5*c - 3*a**12*b**6*c + 3*a**11*b**7*c + a**10*b**8*c
        - 6*a**9*b**9*c + 6*a**8*b**10*c - a**7*b**11*c -
        3*a**6*b**12*c + 3*a**5*b**13*c - a**4*b**14*c -
        a**13*b**4*c**2 + 2*a**12*b**5*c**2 - a**11*b**6*c**2 -
        4*a**10*b**7*c**2 + 9*a**9*b**8*c**2 - 6*a**8*b**9*c**2 -
        3*a**7*b**10*c**2 + 9*a**6*b**11*c**2 - 6*a**5*b**12*c**2 +
        2*a**3*b**14*c**2 - a**2*b**15*c**2 - a**12*b**4*c**3 +
        2*a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 8*a**9*b**7*c**3 +
        6*a**8*b**8*c**3 + 5*a**7*b**9*c**3 - 12*a**6*b**10*c**3 +
        6*a**5*b**11*c**3 + 3*a**4*b**12*c**3 - 5*a**3*b**13*c**3 +
        2*a**2*b**14*c**3 + a**12*b**3*c**4 - 2*a**11*b**4*c**4 -
        2*a**10*b**5*c**4 + 9*a**9*b**6*c**4 - 7*a**8*b**7*c**4 -
        6*a**7*b**8*c**4 + 15*a**6*b**9*c**4 - 8*a**5*b**10*c**4 -
        5*a**4*b**11*c**4 + 8*a**3*b**12*c**4 - 3*a**2*b**13*c**4 -
        a*b**14*c**4 + b**15*c**4 - a**13*b*c**5 + a**12*b**2*c**5 +
        a**11*b**3*c**5 + a**10*b**4*c**5 - 6*a**9*b**5*c**5 +
        4*a**8*b**6*c**5 + 8*a**7*b**7*c**5 - 16*a**6*b**8*c**5 +
        6*a**5*b**9*c**5 + 9*a**4*b**10*c**5 - 11*a**3*b**11*c**5 +
        3*a**2*b**12*c**5 + 3*a*b**13*c**5 - 2*b**14*c**5 + a**13*c**6
        - 3*a**11*b**2*c**6 + 2*a**10*b**3*c**6 + 3*a**9*b**4*c**6 -
        4*a**8*b**5*c**6 - 5*a**7*b**6*c**6 + 11*a**6*b**7*c**6 -
        2*a**5*b**8*c**6 - 10*a**4*b**9*c**6 + 10*a**3*b**10*c**6 -
        a**2*b**11*c**6 - 4*a*b**12*c**6 + 2*b**13*c**6 - a**12*c**7 +
        2*a**11*b*c**7 - 4*a**9*b**3*c**7 + 4*a**8*b**4*c**7 +
        3*a**7*b**5*c**7 - 8*a**6*b**6*c**7 + 2*a**5*b**7*c**7 +
        7*a**4*b**8*c**7 - 7*a**3*b**9*c**7 + 4*a*b**11*c**7 -
        2*b**12*c**7 - a**10*b*c**8 + 2*a**9*b**2*c**8 -
        a**8*b**3*c**8 - 3*a**7*b**4*c**8 + 5*a**6*b**5*c**8 -
        5*a**4*b**7*c**8 + 4*a**3*b**8*c**8 + a**2*b**9*c**8 -
        3*a*b**10*c**8 + b**11*c**8 + a**7*b**3*c**9 - a**6*b**4*c**9
        - a**5*b**5*c**9 + 2*a**4*b**6*c**9 - a**3*b**7*c**9 -
        a**2*b**8*c**9 + a*b**9*c**9), (-3*a**4*b**5*c**2 -
        3*a**3*b**6*c**2 - 6*a**4*b**4*c**3 - 10*a**3*b**5*c**3 -
        3*a**2*b**6*c**3 - 5*a**4*b**3*c**4 - 9*a**3*b**4*c**4 -
        4*a**2*b**5*c**4 - 4*a**4*b**2*c**5 - 8*a**3*b**3*c**5 -
        5*a**2*b**4*c**5 - a*b**5*c**5 - 2*a**4*b*c**6 -
        5*a**3*b**2*c**6 - 4*a**2*b**3*c**6 - a*b**4*c**6)/(a**9*b**7
        - a**8*b**8 - a**7*b**9 + a**6*b**10 - a**9*b**6*c +
        a**8*b**7*c + 2*a**7*b**8*c - 2*a**6*b**9*c - a**5*b**10*c +
        a**4*b**11*c - a**9*b**5*c**2 + 2*a**6*b**8*c**2 +
        a**5*b**9*c**2 - 2*a**4*b**10*c**2 + 2*a**9*b**4*c**3 -
        4*a**7*b**6*c**3 - a**6*b**7*c**3 + 2*a**5*b**8*c**3 +
        2*a**4*b**9*c**3 - a**2*b**11*c**3 - a**9*b**3*c**4 +
        4*a**7*b**5*c**4 - 4*a**5*b**7*c**4 - a**4*b**8*c**4 +
        a**3*b**9*c**4 + a**2*b**10*c**4 - a**9*b**2*c**5 +
        a**7*b**4*c**5 + a**6*b**5*c**5 + a**5*b**6*c**5 -
        2*a**4*b**7*c**5 - a**3*b**8*c**5 + a**2*b**9*c**5 +
        a**9*b*c**6 + a**8*b**2*c**6 - 4*a**7*b**3*c**6 -
        3*a**6*b**4*c**6 + 4*a**5*b**5*c**6 + 5*a**4*b**6*c**6 -
        a**3*b**7*c**6 - 4*a**2*b**8*c**6 + b**10*c**6 - a**8*b*c**7 +
        2*a**7*b**2*c**7 + 3*a**6*b**3*c**7 - 4*a**5*b**4*c**7 -
        5*a**4*b**5*c**7 + 2*a**3*b**6*c**7 + 5*a**2*b**7*c**7 -
        2*b**9*c**7 + a**7*b*c**8 - a**6*b**2*c**8 + a**4*b**4*c**8 -
        a**3*b**5*c**8 - a**2*b**6*c**8 + b**8*c**8 - a**7*c**9 -
        a**6*b*c**9 + 2*a**5*b**2*c**9 + 3*a**4*b**3*c**9 -
        a**3*b**4*c**9 - 3*a**2*b**5*c**9 + b**7*c**9 + a**6*c**10 -
        a**5*b*c**10 - 3*a**4*b**2*c**10 + a**3*b**3*c**10 +
        4*a**2*b**4*c**10 - 2*b**6*c**10 + a**4*b*c**11 -
        2*a**2*b**3*c**11 + b**5*c**11), (-a**5*b**5*c - a**4*b**6*c -
        3*a**6*b**3*c**2 - 4*a**5*b**4*c**2 - 5*a**4*b**5*c**2 -
        4*a**3*b**6*c**2 - 3*a**6*b**2*c**3 - 10*a**5*b**3*c**3 -
        9*a**4*b**4*c**3 - 8*a**3*b**5*c**3 - 5*a**2*b**6*c**3 -
        3*a**5*b**2*c**4 - 6*a**4*b**3*c**4 - 5*a**3*b**4*c**4 -
        4*a**2*b**5*c**4 - 2*a*b**6*c**4)/(a**10*b**6 - 2*a**9*b**7 +
        a**8*b**8 + a**7*b**9 - 2*a**6*b**10 + a**5*b**11 -
        a**11*b**3*c**2 + a**10*b**4*c**2 + a**9*b**5*c**2 -
        4*a**8*b**6*c**2 + 5*a**7*b**7*c**2 - a**6*b**8*c**2 -
        3*a**5*b**9*c**2 + 4*a**4*b**10*c**2 - 2*a**3*b**11*c**2 +
        a**9*b**4*c**3 - a**8*b**5*c**3 - a**7*b**6*c**3 +
        2*a**6*b**7*c**3 - a**5*b**8*c**3 - a**4*b**9*c**3 +
        a**3*b**10*c**3 + a**11*b*c**4 - 2*a**10*b**2*c**4 +
        2*a**9*b**3*c**4 - a**8*b**4*c**4 - 2*a**7*b**5*c**4 +
        5*a**6*b**6*c**4 - 5*a**5*b**7*c**4 + a**4*b**8*c**4 +
        3*a**3*b**9*c**4 - 3*a**2*b**10*c**4 + a*b**11*c**4 -
        a**10*b*c**5 + a**9*b**2*c**5 + 2*a**8*b**3*c**5 -
        4*a**7*b**4*c**5 + a**6*b**5*c**5 + 4*a**5*b**6*c**5 -
        4*a**4*b**7*c**5 + 2*a**2*b**9*c**5 - a*b**10*c**5 +
        a**10*c**6 - 2*a**9*b*c**6 + 2*a**8*b**2*c**6 - a**7*b**3*c**6
        + a**5*b**5*c**6 - 3*a**4*b**6*c**6 + 3*a**3*b**7*c**6 -
        a**2*b**8*c**6 - a*b**9*c**6 + b**10*c**6 - a**9*c**7 +
        2*a**8*b*c**7 - 4*a**6*b**3*c**7 + 4*a**5*b**4*c**7 +
        a**4*b**5*c**7 - 4*a**3*b**6*c**7 + 2*a**2*b**7*c**7 +
        a*b**8*c**7 - b**9*c**7 - a**8*c**8 + a**7*b*c**8 +
        a**2*b**6*c**8 - a*b**7*c**8 + a**7*c**9 - a**6*b*c**9 -
        a**5*b**2*c**9 + 2*a**4*b**3*c**9 - a**3*b**4*c**9 -
        a**2*b**5*c**9 + a*b**6*c**9), (-2*a**6*b**4*c -
        5*a**6*b**3*c**2 - 4*a**5*b**4*c**2 - 4*a**6*b**2*c**3 -
        8*a**5*b**3*c**3 - 5*a**4*b**4*c**3 - a**6*b*c**4 -
        5*a**5*b**2*c**4 - 9*a**4*b**3*c**4 - 6*a**3*b**4*c**4 -
        a**5*b*c**5 - 4*a**4*b**2*c**5 - 10*a**3*b**3*c**5 -
        3*a**2*b**4*c**5 - 3*a**3*b**2*c**6 -
        3*a**2*b**3*c**6)/(a**10*b**6 - a**9*b**7 + a**11*b**4*c -
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c - a**7*b**8*c +
        a**6*b**9*c - 3*a**10*b**4*c**2 + 2*a**9*b**5*c**2 -
        a**8*b**6*c**2 + 2*a**7*b**7*c**2 + a**6*b**8*c**2 -
        a**5*b**9*c**2 - 2*a**11*b**2*c**3 + a**10*b**3*c**3 +
        3*a**9*b**4*c**3 + 3*a**7*b**6*c**3 - 4*a**6*b**7*c**3 -
        a**4*b**9*c**3 + 4*a**10*b**2*c**4 - a**9*b**3*c**4 +
        a**8*b**4*c**4 - 4*a**7*b**5*c**4 - 3*a**6*b**6*c**4 +
        a**5*b**7*c**4 + 2*a**3*b**9*c**4 + a**11*c**5 -
        3*a**9*b**2*c**5 - a**8*b**3*c**5 - 5*a**7*b**4*c**5 +
        4*a**6*b**5*c**5 + a**5*b**6*c**5 + 4*a**4*b**7*c**5 -
        a**2*b**9*c**5 - 2*a**10*c**6 - a**8*b**2*c**6 +
        2*a**7*b**3*c**6 + 5*a**6*b**4*c**6 + a**5*b**5*c**6 -
        4*a**3*b**7*c**6 - a*b**9*c**6 + a**9*c**7 + 5*a**7*b**2*c**7
        - a**6*b**3*c**7 - 2*a**5*b**4*c**7 - 4*a**4*b**5*c**7 -
        a**3*b**6*c**7 + a*b**8*c**7 + b**9*c**7 + a**8*c**8 -
        4*a**6*b**2*c**8 - a**5*b**3*c**8 - a**4*b**4*c**8 +
        2*a**3*b**5*c**8 + 2*a**2*b**6*c**8 + 2*a*b**7*c**8 -
        b**8*c**8 - 2*a**7*c**9 + a**5*b**2*c**9 + a**4*b**3*c**9 +
        2*a**3*b**4*c**9 + a**2*b**5*c**9 - 2*a*b**6*c**9 - b**7*c**9
        + a**6*c**10 + a**4*b**2*c**10 - 2*a**2*b**4*c**10 -
        a*b**5*c**10 + b**6*c**10 - a**3*b**2*c**11 + a*b**4*c**11),
        (2*a**4*b**6*c + 4*a**4*b**5*c**2 + 5*a**3*b**6*c**2 +
        5*a**4*b**4*c**3 + 8*a**3*b**5*c**3 + 4*a**2*b**6*c**3 +
        6*a**4*b**3*c**4 + 9*a**3*b**4*c**4 + 5*a**2*b**5*c**4 +
        a*b**6*c**4 + 3*a**4*b**2*c**5 + 10*a**3*b**3*c**5 +
        4*a**2*b**4*c**5 + a*b**5*c**5 + 3*a**3*b**2*c**6 +
        3*a**2*b**3*c**6)/(a**7*b**9 - a**6*b**10 - a**9*b**6*c +
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c + a**5*b**10*c -
        a**4*b**11*c + a**9*b**5*c**2 - a**8*b**6*c**2 -
        2*a**7*b**7*c**2 + a**6*b**8*c**2 - 2*a**5*b**9*c**2 +
        3*a**4*b**10*c**2 + a**9*b**4*c**3 + 4*a**7*b**6*c**3 -
        3*a**6*b**7*c**3 - 3*a**4*b**9*c**3 - a**3*b**10*c**3 +
        2*a**2*b**11*c**3 - 2*a**9*b**3*c**4 - a**7*b**5*c**4 +
        3*a**6*b**6*c**4 + 4*a**5*b**7*c**4 - a**4*b**8*c**4 +
        a**3*b**9*c**4 - 4*a**2*b**10*c**4 + a**9*b**2*c**5 -
        4*a**7*b**4*c**5 - a**6*b**5*c**5 - 4*a**5*b**6*c**5 +
        5*a**4*b**7*c**5 + a**3*b**8*c**5 + 3*a**2*b**9*c**5 -
        b**11*c**5 + a**9*b*c**6 + 4*a**7*b**3*c**6 - a**5*b**5*c**6 -
        5*a**4*b**6*c**6 - 2*a**3*b**7*c**6 + a**2*b**8*c**6 +
        2*b**10*c**6 - a**9*c**7 - a**8*b*c**7 + a**6*b**3*c**7 +
        4*a**5*b**4*c**7 + 2*a**4*b**5*c**7 + a**3*b**6*c**7 -
        5*a**2*b**7*c**7 - b**9*c**7 + a**8*c**8 - 2*a**7*b*c**8 -
        2*a**6*b**2*c**8 - 2*a**5*b**3*c**8 + a**4*b**4*c**8 +
        a**3*b**5*c**8 + 4*a**2*b**6*c**8 - b**8*c**8 + a**7*c**9 +
        2*a**6*b*c**9 - a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + 2*b**7*c**9 - a**6*c**10 +
        a**5*b*c**10 + 2*a**4*b**2*c**10 - a**2*b**4*c**10 -
        b**6*c**10 - a**4*b*c**11 + a**2*b**3*c**11),
        (-3*a**6*b**3*c**2 - 3*a**5*b**4*c**2 - 3*a**6*b**2*c**3 -
        10*a**5*b**3*c**3 - 6*a**4*b**4*c**3 - 4*a**5*b**2*c**4 -
        9*a**4*b**3*c**4 - 5*a**3*b**4*c**4 - a**5*b*c**5 -
        5*a**4*b**2*c**5 - 8*a**3*b**3*c**5 - 4*a**2*b**4*c**5 -
        a**4*b*c**6 - 4*a**3*b**2*c**6 - 5*a**2*b**3*c**6 -
        2*a*b**4*c**6)/(a**10*b**6 - a**9*b**7 - a**8*b**8 + a**7*b**9
        + a**11*b**4*c - a**10*b**5*c - 2*a**9*b**6*c + 2*a**8*b**7*c
        + a**7*b**8*c - a**6*b**9*c - 2*a**10*b**4*c**2 +
        a**9*b**5*c**2 + 2*a**8*b**6*c**2 - a**5*b**9*c**2 -
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 + 2*a**8*b**5*c**3 -
        a**7*b**6*c**3 - 4*a**6*b**7*c**3 + 2*a**4*b**9*c**3 +
        a**10*b**2*c**4 + a**9*b**3*c**4 - a**8*b**4*c**4 -
        4*a**7*b**5*c**4 + 4*a**5*b**7*c**4 - a**3*b**9*c**4 +
        a**9*b**2*c**5 - a**8*b**3*c**5 - 2*a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 + a**4*b**7*c**5 -
        a**2*b**9*c**5 + a**10*c**6 - 4*a**8*b**2*c**6 -
        a**7*b**3*c**6 + 5*a**6*b**4*c**6 + 4*a**5*b**5*c**6 -
        3*a**4*b**6*c**6 - 4*a**3*b**7*c**6 + a**2*b**8*c**6 +
        a*b**9*c**6 - 2*a**9*c**7 + 5*a**7*b**2*c**7 +
        2*a**6*b**3*c**7 - 5*a**5*b**4*c**7 - 4*a**4*b**5*c**7 +
        3*a**3*b**6*c**7 + 2*a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8
        - a**6*b**2*c**8 - a**5*b**3*c**8 + a**4*b**4*c**8 -
        a**2*b**6*c**8 + a*b**7*c**8 + a**7*c**9 - 3*a**5*b**2*c**9 -
        a**4*b**3*c**9 + 3*a**3*b**4*c**9 + 2*a**2*b**5*c**9 -
        a*b**6*c**9 - b**7*c**9 - 2*a**6*c**10 + 4*a**4*b**2*c**10 +
        a**3*b**3*c**10 - 3*a**2*b**4*c**10 - a*b**5*c**10 +
        b**6*c**10 + a**5*c**11 - 2*a**3*b**2*c**11 + a*b**4*c**11),
        (-a**6*b**4*c - a**5*b**5*c - 4*a**6*b**3*c**2 -
        5*a**5*b**4*c**2 - 4*a**4*b**5*c**2 - 3*a**3*b**6*c**2 -
        5*a**6*b**2*c**3 - 8*a**5*b**3*c**3 - 9*a**4*b**4*c**3 -
        10*a**3*b**5*c**3 - 3*a**2*b**6*c**3 - 2*a**6*b*c**4 -
        4*a**5*b**2*c**4 - 5*a**4*b**3*c**4 - 6*a**3*b**4*c**4 -
        3*a**2*b**5*c**4)/(a**11*b**5 - 2*a**10*b**6 + a**9*b**7 +
        a**8*b**8 - 2*a**7*b**9 + a**6*b**10 - 2*a**11*b**3*c**2 +
        4*a**10*b**4*c**2 - 3*a**9*b**5*c**2 - a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - 4*a**6*b**8*c**2 + a**5*b**9*c**2 +
        a**4*b**10*c**2 - a**3*b**11*c**2 + a**10*b**3*c**3 -
        a**9*b**4*c**3 - a**8*b**5*c**3 + 2*a**7*b**6*c**3 -
        a**6*b**7*c**3 - a**5*b**8*c**3 + a**4*b**9*c**3 +
        a**11*b*c**4 - 3*a**10*b**2*c**4 + 3*a**9*b**3*c**4 +
        a**8*b**4*c**4 - 5*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        2*a**5*b**7*c**4 - a**4*b**8*c**4 + 2*a**3*b**9*c**4 -
        2*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        2*a**9*b**2*c**5 - 4*a**7*b**4*c**5 + 4*a**6*b**5*c**5 +
        a**5*b**6*c**5 - 4*a**4*b**7*c**5 + 2*a**3*b**8*c**5 +
        a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - a**9*b*c**6 -
        a**8*b**2*c**6 + 3*a**7*b**3*c**6 - 3*a**6*b**4*c**6 +
        a**5*b**5*c**6 - a**3*b**7*c**6 + 2*a**2*b**8*c**6 -
        2*a*b**9*c**6 + b**10*c**6 - a**9*c**7 + a**8*b*c**7 +
        2*a**7*b**2*c**7 - 4*a**6*b**3*c**7 + a**5*b**4*c**7 +
        4*a**4*b**5*c**7 - 4*a**3*b**6*c**7 + 2*a*b**8*c**7 -
        b**9*c**7 - a**7*b*c**8 + a**6*b**2*c**8 + a*b**7*c**8 -
        b**8*c**8 + a**6*b*c**9 - a**5*b**2*c**9 - a**4*b**3*c**9 +
        2*a**3*b**4*c**9 - a**2*b**5*c**9 - a*b**6*c**9 + b**7*c**9),
        (-2*a**6*b**4*c - 4*a**6*b**3*c**2 - 5*a**5*b**4*c**2 -
        a**4*b**5*c**2 - 4*a**6*b**2*c**3 - 8*a**5*b**3*c**3 -
        8*a**4*b**4*c**3 - 4*a**3*b**5*c**3 - 2*a**6*b*c**4 -
        5*a**5*b**2*c**4 - 8*a**4*b**3*c**4 - 11*a**3*b**4*c**4 -
        3*a**2*b**5*c**4 - a**4*b**2*c**5 - 4*a**3*b**3*c**5 -
        3*a**2*b**4*c**5)/(a**9*b**7 - a**8*b**8 - a**11*b**4*c +
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c + a**7*b**8*c -
        a**6*b**9*c + a**11*b**3*c**2 - a**10*b**4*c**2 -
        2*a**9*b**5*c**2 + a**8*b**6*c**2 - a**7*b**7*c**2 +
        2*a**6*b**8*c**2 + a**5*b**9*c**2 - a**4*b**10*c**2 +
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 - a**8*b**5*c**3 -
        3*a**7*b**6*c**3 - a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**11*b*c**4 - a**10*b**2*c**4 + 2*a**9*b**3*c**4 +
        3*a**7*b**5*c**4 - a**6*b**6*c**4 - 2*a**5*b**7*c**4 -
        a**4*b**8*c**4 + a**2*b**10*c**4 + a**10*b*c**5 -
        2*a**9*b**2*c**5 - a**8*b**3*c**5 + 3*a**7*b**4*c**5 +
        2*a**5*b**6*c**5 - a**4*b**7*c**5 - a**3*b**8*c**5 -
        a**2*b**9*c**5 - a**9*b*c**6 + a**8*b**2*c**6 -
        3*a**7*b**3*c**6 - a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        2*a**4*b**6*c**6 + a**3*b**7*c**6 - a**2*b**8*c**6 + a**9*c**7
        + a**8*b*c**7 - a**7*b**2*c**7 - 2*a**5*b**4*c**7 -
        a**4*b**5*c**7 + a**3*b**6*c**7 + 2*a**2*b**7*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + 2*a**6*b**2*c**8 - a**5*b**3*c**8
        - a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 +
        2*b**8*c**8 - a**6*b*c**9 + a**5*b**2*c**9 + 2*a**4*b**3*c**9
        - a**2*b**5*c**9 - b**7*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (3*a**5*b**4*c**2 + 3*a**4*b**5*c**2 +
        4*a**5*b**3*c**3 + 11*a**4*b**4*c**3 + 4*a**3*b**5*c**3 +
        a**5*b**2*c**4 + 8*a**4*b**3*c**4 + 8*a**3*b**4*c**4 +
        a**2*b**5*c**4 + 5*a**4*b**2*c**5 + 8*a**3*b**3*c**5 +
        5*a**2*b**4*c**5 + 2*a**4*b*c**6 + 4*a**3*b**2*c**6 +
        4*a**2*b**3*c**6 + 2*a*b**4*c**6)/(a**9*b**7 - 2*a**8*b**8 +
        a**7*b**9 - a**10*b**4*c**2 + a**9*b**5*c**2 + a**8*b**6*c**2
        - 2*a**7*b**7*c**2 + a**6*b**8*c**2 + a**5*b**9*c**2 -
        a**4*b**10*c**2 + a**8*b**5*c**3 - a**7*b**6*c**3 -
        a**6*b**7*c**3 + a**5*b**8*c**3 + a**10*b**2*c**4 -
        2*a**9*b**3*c**4 + a**8*b**4*c**4 + a**7*b**5*c**4 -
        2*a**6*b**6*c**4 + a**5*b**7*c**4 + a**4*b**8*c**4 -
        2*a**3*b**9*c**4 + a**2*b**10*c**4 - a**9*b**2*c**5 +
        a**8*b**3*c**5 + 2*a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        2*a**5*b**6*c**5 + 2*a**4*b**7*c**5 + a**3*b**8*c**5 -
        a**2*b**9*c**5 + a**9*b*c**6 - 2*a**8*b**2*c**6 +
        a**6*b**4*c**6 + a**4*b**6*c**6 - 2*a**2*b**8*c**6 +
        a*b**9*c**6 - a**8*b*c**7 + a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 3*a**5*b**4*c**7 - 3*a**4*b**5*c**7 + 3*a**3*b**6*c**7 +
        a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8 - a**7*b*c**8 -
        a**6*b**2*c**8 + a**5*b**3*c**8 + a**3*b**5*c**8 -
        a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 - a**7*c**9 +
        a**6*b*c**9 + 2*a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        2*a**3*b**4*c**9 + 2*a**2*b**5*c**9 + a*b**6*c**9 - b**7*c**9
        - a**5*b*c**10 + a**4*b**2*c**10 + a**2*b**4*c**10 -
        a*b**5*c**10 + a**4*b*c**11 - a**3*b**2*c**11 -
        a**2*b**3*c**11 + a*b**4*c**11), (2*a**4*b**6*c +
        a**5*b**4*c**2 + 5*a**4*b**5*c**2 + 4*a**3*b**6*c**2 +
        4*a**5*b**3*c**3 + 8*a**4*b**4*c**3 + 8*a**3*b**5*c**3 +
        4*a**2*b**6*c**3 + 3*a**5*b**2*c**4 + 11*a**4*b**3*c**4 +
        8*a**3*b**4*c**4 + 5*a**2*b**5*c**4 + 2*a*b**6*c**4 +
        3*a**4*b**2*c**5 + 4*a**3*b**3*c**5 +
        a**2*b**4*c**5)/(a**8*b**8 - a**7*b**9 + a**9*b**6*c -
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c - a**5*b**10*c +
        a**4*b**11*c + a**10*b**4*c**2 - a**9*b**5*c**2 -
        2*a**8*b**6*c**2 + a**7*b**7*c**2 - a**6*b**8*c**2 +
        2*a**5*b**9*c**2 + a**4*b**10*c**2 - a**3*b**11*c**2 -
        2*a**9*b**4*c**3 + a**8*b**5*c**3 + 3*a**6*b**7*c**3 +
        a**5*b**8*c**3 - 2*a**4*b**9*c**3 - a**2*b**11*c**3 -
        a**10*b**2*c**4 + a**8*b**4*c**4 + 2*a**7*b**5*c**4 +
        a**6*b**6*c**4 - 3*a**5*b**7*c**4 - 2*a**3*b**9*c**4 +
        a**2*b**10*c**4 + a*b**11*c**4 + a**9*b**2*c**5 +
        a**8*b**3*c**5 + a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        3*a**4*b**7*c**5 + a**3*b**8*c**5 + 2*a**2*b**9*c**5 -
        a*b**10*c**5 + a**8*b**2*c**6 - a**7*b**3*c**6 -
        2*a**6*b**4*c**6 - 2*a**5*b**5*c**6 + a**4*b**6*c**6 +
        3*a**3*b**7*c**6 - a**2*b**8*c**6 + a*b**9*c**6 + a**9*c**7 -
        2*a**7*b**2*c**7 - a**6*b**3*c**7 + a**5*b**4*c**7 +
        2*a**4*b**5*c**7 + a**2*b**7*c**7 - a*b**8*c**7 - b**9*c**7 -
        2*a**8*c**8 + a**6*b**2*c**8 + a**5*b**3*c**8 + a**4*b**4*c**8
        + a**3*b**5*c**8 - 2*a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8
        + a**7*c**9 + a**5*b**2*c**9 - 2*a**3*b**4*c**9 -
        a**2*b**5*c**9 + a*b**6*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (-a**4*b**4*c + (-zeta3 - 3)*a**4*b**3*c**2
        + (-zeta3 - 3)*a**3*b**4*c**2 + (-zeta3 - 3)*a**4*b**2*c**3 +
        (-11/3*zeta3 - 19/3)*a**3*b**3*c**3 + (-zeta3 -
        3)*a**2*b**4*c**3 - a**4*b*c**4 + (-zeta3 - 3)*a**3*b**2*c**4
        + (-zeta3 - 3)*a**2*b**3*c**4 - a*b**4*c**4)/(a**8*b**6 -
        a**7*b**7 + a**6*b**8 + (zeta3 + 1)*a**9*b**4*c + (-zeta3 -
        1)*a**8*b**5*c + (zeta3 + 1)*a**7*b**6*c + (zeta3 +
        1)*a**6*b**7*c + (-zeta3 - 1)*a**5*b**8*c + (zeta3 +
        1)*a**4*b**9*c - a**7*b**5*c**2 + a**6*b**6*c**2 -
        a**5*b**7*c**2 + (-zeta3 + 1)*a**8*b**3*c**3 +
        zeta3*a**7*b**4*c**3 + (-zeta3 + 1)*a**6*b**5*c**3 + (-zeta3 +
        1)*a**5*b**6*c**3 + zeta3*a**4*b**7*c**3 + (-zeta3 +
        1)*a**3*b**8*c**3 + (zeta3 + 1)*a**9*b*c**4 +
        zeta3*a**7*b**3*c**4 + (3*zeta3 + 3)*a**6*b**4*c**4 + (-zeta3
        - 2)*a**5*b**5*c**4 + (3*zeta3 + 3)*a**4*b**6*c**4 +
        zeta3*a**3*b**7*c**4 + (zeta3 + 1)*a*b**9*c**4 + (-zeta3 -
        1)*a**8*b*c**5 - a**7*b**2*c**5 + (-zeta3 + 1)*a**6*b**3*c**5
        + (-zeta3 - 2)*a**5*b**4*c**5 + (-zeta3 - 2)*a**4*b**5*c**5 +
        (-zeta3 + 1)*a**3*b**6*c**5 - a**2*b**7*c**5 + (-zeta3 -
        1)*a*b**8*c**5 + a**8*c**6 + (zeta3 + 1)*a**7*b*c**6 +
        a**6*b**2*c**6 + (-zeta3 + 1)*a**5*b**3*c**6 + (3*zeta3 +
        3)*a**4*b**4*c**6 + (-zeta3 + 1)*a**3*b**5*c**6 +
        a**2*b**6*c**6 + (zeta3 + 1)*a*b**7*c**6 + b**8*c**6 -
        a**7*c**7 + (zeta3 + 1)*a**6*b*c**7 - a**5*b**2*c**7 +
        zeta3*a**4*b**3*c**7 + zeta3*a**3*b**4*c**7 - a**2*b**5*c**7 +
        (zeta3 + 1)*a*b**6*c**7 - b**7*c**7 + a**6*c**8 + (-zeta3 -
        1)*a**5*b*c**8 + (-zeta3 + 1)*a**3*b**3*c**8 + (-zeta3 -
        1)*a*b**5*c**8 + b**6*c**8 + (zeta3 + 1)*a**4*b*c**9 + (zeta3
        + 1)*a*b**4*c**9), (-a**4*b**4*c + (zeta3 - 2)*a**4*b**3*c**2
        + (zeta3 - 2)*a**3*b**4*c**2 + (zeta3 - 2)*a**4*b**2*c**3 +
        (11/3*zeta3 - 8/3)*a**3*b**3*c**3 + (zeta3 - 2)*a**2*b**4*c**3
        - a**4*b*c**4 + (zeta3 - 2)*a**3*b**2*c**4 + (zeta3 -
        2)*a**2*b**3*c**4 - a*b**4*c**4)/(a**8*b**6 - a**7*b**7 +
        a**6*b**8 + (-zeta3)*a**9*b**4*c + zeta3*a**8*b**5*c +
        (-zeta3)*a**7*b**6*c + (-zeta3)*a**6*b**7*c +
        zeta3*a**5*b**8*c + (-zeta3)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (zeta3 + 2)*a**8*b**3*c**3 +
        (-zeta3 - 1)*a**7*b**4*c**3 + (zeta3 + 2)*a**6*b**5*c**3 +
        (zeta3 + 2)*a**5*b**6*c**3 + (-zeta3 - 1)*a**4*b**7*c**3 +
        (zeta3 + 2)*a**3*b**8*c**3 + (-zeta3)*a**9*b*c**4 + (-zeta3 -
        1)*a**7*b**3*c**4 + (-3*zeta3)*a**6*b**4*c**4 + (zeta3 -
        1)*a**5*b**5*c**4 + (-3*zeta3)*a**4*b**6*c**4 + (-zeta3 -
        1)*a**3*b**7*c**4 + (-zeta3)*a*b**9*c**4 + zeta3*a**8*b*c**5 -
        a**7*b**2*c**5 + (zeta3 + 2)*a**6*b**3*c**5 + (zeta3 -
        1)*a**5*b**4*c**5 + (zeta3 - 1)*a**4*b**5*c**5 + (zeta3 +
        2)*a**3*b**6*c**5 - a**2*b**7*c**5 + zeta3*a*b**8*c**5 +
        a**8*c**6 + (-zeta3)*a**7*b*c**6 + a**6*b**2*c**6 + (zeta3 +
        2)*a**5*b**3*c**6 + (-3*zeta3)*a**4*b**4*c**6 + (zeta3 +
        2)*a**3*b**5*c**6 + a**2*b**6*c**6 + (-zeta3)*a*b**7*c**6 +
        b**8*c**6 - a**7*c**7 + (-zeta3)*a**6*b*c**7 - a**5*b**2*c**7
        + (-zeta3 - 1)*a**4*b**3*c**7 + (-zeta3 - 1)*a**3*b**4*c**7 -
        a**2*b**5*c**7 + (-zeta3)*a*b**6*c**7 - b**7*c**7 + a**6*c**8
        + zeta3*a**5*b*c**8 + (zeta3 + 2)*a**3*b**3*c**8 +
        zeta3*a*b**5*c**8 + b**6*c**8 + (-zeta3)*a**4*b*c**9 +
        (-zeta3)*a*b**4*c**9)], 'K91': [a**17*b**5*c**5/(a**25*b -
        3*a**24*b**2 + 5*a**23*b**3 - 6*a**22*b**4 + 5*a**21*b**5 -
        3*a**20*b**6 + a**19*b**7 + a**25*c - 5*a**24*b*c +
        13*a**23*b**2*c - 23*a**22*b**3*c + 30*a**21*b**4*c -
        30*a**20*b**5*c + 23*a**19*b**6*c - 13*a**18*b**7*c +
        5*a**17*b**8*c - a**16*b**9*c - 3*a**24*c**2 + 13*a**23*b*c**2
        - 33*a**22*b**2*c**2 + 60*a**21*b**3*c**2 - 83*a**20*b**4*c**2
        + 91*a**19*b**5*c**2 - 79*a**18*b**6*c**2 + 54*a**17*b**7*c**2
        - 28*a**16*b**8*c**2 + 10*a**15*b**9*c**2 - 2*a**14*b**10*c**2
        + 5*a**23*c**3 - 23*a**22*b*c**3 + 60*a**21*b**2*c**3 -
        113*a**20*b**3*c**3 + 164*a**19*b**4*c**3 -
        191*a**18*b**5*c**3 + 180*a**17*b**6*c**3 -
        137*a**16*b**7*c**3 + 83*a**15*b**8*c**3 - 38*a**14*b**9*c**3
        + 12*a**13*b**10*c**3 - 2*a**12*b**11*c**3 - 6*a**22*c**4 +
        30*a**21*b*c**4 - 83*a**20*b**2*c**4 + 164*a**19*b**3*c**4 -
        250*a**18*b**4*c**4 + 307*a**17*b**5*c**4 -
        308*a**16*b**6*c**4 + 253*a**15*b**7*c**4 -
        169*a**14*b**8*c**4 + 89*a**13*b**9*c**4 - 35*a**12*b**10*c**4
        + 9*a**11*b**11*c**4 - a**10*b**12*c**4 + 5*a**21*c**5 -
        30*a**20*b*c**5 + 91*a**19*b**2*c**5 - 191*a**18*b**3*c**5 +
        307*a**17*b**4*c**5 - 395*a**16*b**5*c**5 +
        417*a**15*b**6*c**5 - 363*a**14*b**7*c**5 +
        260*a**13*b**8*c**5 - 151*a**12*b**9*c**5 +
        68*a**11*b**10*c**5 - 22*a**10*b**11*c**5 + 4*a**9*b**12*c**5
        - 3*a**20*c**6 + 23*a**19*b*c**6 - 79*a**18*b**2*c**6 +
        180*a**17*b**3*c**6 - 308*a**16*b**4*c**6 +
        417*a**15*b**5*c**6 - 461*a**14*b**6*c**6 +
        420*a**13*b**7*c**6 - 316*a**12*b**8*c**6 +
        195*a**11*b**9*c**6 - 96*a**10*b**10*c**6 + 36*a**9*b**11*c**6
        - 9*a**8*b**12*c**6 + a**7*b**13*c**6 + a**19*c**7 -
        13*a**18*b*c**7 + 54*a**17*b**2*c**7 - 137*a**16*b**3*c**7 +
        253*a**15*b**4*c**7 - 363*a**14*b**5*c**7 +
        420*a**13*b**6*c**7 - 398*a**12*b**7*c**7 +
        310*a**11*b**8*c**7 - 198*a**10*b**9*c**7 +
        102*a**9*b**10*c**7 - 41*a**8*b**11*c**7 + 12*a**7*b**12*c**7
        - 2*a**6*b**13*c**7 + 5*a**17*b*c**8 - 28*a**16*b**2*c**8 +
        83*a**15*b**3*c**8 - 169*a**14*b**4*c**8 + 260*a**13*b**5*c**8
        - 316*a**12*b**6*c**8 + 310*a**11*b**7*c**8 -
        247*a**10*b**8*c**8 + 159*a**9*b**9*c**8 - 82*a**8*b**10*c**8
        + 33*a**7*b**11*c**8 - 10*a**6*b**12*c**8 + 2*a**5*b**13*c**8
        - a**16*b*c**9 + 10*a**15*b**2*c**9 - 38*a**14*b**3*c**9 +
        89*a**13*b**4*c**9 - 151*a**12*b**5*c**9 + 195*a**11*b**6*c**9
        - 198*a**10*b**7*c**9 + 159*a**9*b**8*c**9 - 99*a**8*b**9*c**9
        + 47*a**7*b**10*c**9 - 16*a**6*b**11*c**9 + 4*a**5*b**12*c**9
        - a**4*b**13*c**9 - 2*a**14*b**2*c**10 + 12*a**13*b**3*c**10 -
        35*a**12*b**4*c**10 + 68*a**11*b**5*c**10 -
        96*a**10*b**6*c**10 + 102*a**9*b**7*c**10 - 82*a**8*b**8*c**10
        + 47*a**7*b**9*c**10 - 16*a**6*b**10*c**10 +
        3*a**4*b**12*c**10 - a**3*b**13*c**10 - 2*a**12*b**3*c**11 +
        9*a**11*b**4*c**11 - 22*a**10*b**5*c**11 + 36*a**9*b**6*c**11
        - 41*a**8*b**7*c**11 + 33*a**7*b**8*c**11 - 16*a**6*b**9*c**11
        + 7*a**4*b**11*c**11 - 6*a**3*b**12*c**11 + 2*a**2*b**13*c**11
        - a**10*b**4*c**12 + 4*a**9*b**5*c**12 - 9*a**8*b**6*c**12 +
        12*a**7*b**7*c**12 - 10*a**6*b**8*c**12 + 4*a**5*b**9*c**12 +
        3*a**4*b**10*c**12 - 6*a**3*b**11*c**12 + 5*a**2*b**12*c**12 -
        2*a*b**13*c**12 + a**7*b**6*c**13 - 2*a**6*b**7*c**13 +
        2*a**5*b**8*c**13 - a**4*b**9*c**13 - a**3*b**10*c**13 +
        2*a**2*b**11*c**13 - 2*a*b**12*c**13 + b**13*c**13),
        a**5*b**5*c**17/(a**13*b**13 - 2*a**13*b**12*c -
        2*a**12*b**13*c + 2*a**13*b**11*c**2 + 5*a**12*b**12*c**2 +
        2*a**11*b**13*c**2 - a**13*b**10*c**3 - 6*a**12*b**11*c**3 -
        6*a**11*b**12*c**3 - a**10*b**13*c**3 - a**13*b**9*c**4 +
        3*a**12*b**10*c**4 + 7*a**11*b**11*c**4 + 3*a**10*b**12*c**4 -
        a**9*b**13*c**4 + 2*a**13*b**8*c**5 + 4*a**12*b**9*c**5 +
        4*a**9*b**12*c**5 + 2*a**8*b**13*c**5 - 2*a**13*b**7*c**6 -
        10*a**12*b**8*c**6 - 16*a**11*b**9*c**6 - 16*a**10*b**10*c**6
        - 16*a**9*b**11*c**6 - 10*a**8*b**12*c**6 - 2*a**7*b**13*c**6
        + a**13*b**6*c**7 + 12*a**12*b**7*c**7 + 33*a**11*b**8*c**7 +
        47*a**10*b**9*c**7 + 47*a**9*b**10*c**7 + 33*a**8*b**11*c**7 +
        12*a**7*b**12*c**7 + a**6*b**13*c**7 - 9*a**12*b**6*c**8 -
        41*a**11*b**7*c**8 - 82*a**10*b**8*c**8 - 99*a**9*b**9*c**8 -
        82*a**8*b**10*c**8 - 41*a**7*b**11*c**8 - 9*a**6*b**12*c**8 +
        4*a**12*b**5*c**9 + 36*a**11*b**6*c**9 + 102*a**10*b**7*c**9 +
        159*a**9*b**8*c**9 + 159*a**8*b**9*c**9 + 102*a**7*b**10*c**9
        + 36*a**6*b**11*c**9 + 4*a**5*b**12*c**9 - a**12*b**4*c**10 -
        22*a**11*b**5*c**10 - 96*a**10*b**6*c**10 -
        198*a**9*b**7*c**10 - 247*a**8*b**8*c**10 -
        198*a**7*b**9*c**10 - 96*a**6*b**10*c**10 -
        22*a**5*b**11*c**10 - a**4*b**12*c**10 + 9*a**11*b**4*c**11 +
        68*a**10*b**5*c**11 + 195*a**9*b**6*c**11 +
        310*a**8*b**7*c**11 + 310*a**7*b**8*c**11 +
        195*a**6*b**9*c**11 + 68*a**5*b**10*c**11 + 9*a**4*b**11*c**11
        - 2*a**11*b**3*c**12 - 35*a**10*b**4*c**12 -
        151*a**9*b**5*c**12 - 316*a**8*b**6*c**12 -
        398*a**7*b**7*c**12 - 316*a**6*b**8*c**12 -
        151*a**5*b**9*c**12 - 35*a**4*b**10*c**12 - 2*a**3*b**11*c**12
        + 12*a**10*b**3*c**13 + 89*a**9*b**4*c**13 +
        260*a**8*b**5*c**13 + 420*a**7*b**6*c**13 +
        420*a**6*b**7*c**13 + 260*a**5*b**8*c**13 + 89*a**4*b**9*c**13
        + 12*a**3*b**10*c**13 - 2*a**10*b**2*c**14 -
        38*a**9*b**3*c**14 - 169*a**8*b**4*c**14 - 363*a**7*b**5*c**14
        - 461*a**6*b**6*c**14 - 363*a**5*b**7*c**14 -
        169*a**4*b**8*c**14 - 38*a**3*b**9*c**14 - 2*a**2*b**10*c**14
        + 10*a**9*b**2*c**15 + 83*a**8*b**3*c**15 +
        253*a**7*b**4*c**15 + 417*a**6*b**5*c**15 +
        417*a**5*b**6*c**15 + 253*a**4*b**7*c**15 + 83*a**3*b**8*c**15
        + 10*a**2*b**9*c**15 - a**9*b*c**16 - 28*a**8*b**2*c**16 -
        137*a**7*b**3*c**16 - 308*a**6*b**4*c**16 -
        395*a**5*b**5*c**16 - 308*a**4*b**6*c**16 -
        137*a**3*b**7*c**16 - 28*a**2*b**8*c**16 - a*b**9*c**16 +
        5*a**8*b*c**17 + 54*a**7*b**2*c**17 + 180*a**6*b**3*c**17 +
        307*a**5*b**4*c**17 + 307*a**4*b**5*c**17 +
        180*a**3*b**6*c**17 + 54*a**2*b**7*c**17 + 5*a*b**8*c**17 -
        13*a**7*b*c**18 - 79*a**6*b**2*c**18 - 191*a**5*b**3*c**18 -
        250*a**4*b**4*c**18 - 191*a**3*b**5*c**18 - 79*a**2*b**6*c**18
        - 13*a*b**7*c**18 + a**7*c**19 + 23*a**6*b*c**19 +
        91*a**5*b**2*c**19 + 164*a**4*b**3*c**19 + 164*a**3*b**4*c**19
        + 91*a**2*b**5*c**19 + 23*a*b**6*c**19 + b**7*c**19 -
        3*a**6*c**20 - 30*a**5*b*c**20 - 83*a**4*b**2*c**20 -
        113*a**3*b**3*c**20 - 83*a**2*b**4*c**20 - 30*a*b**5*c**20 -
        3*b**6*c**20 + 5*a**5*c**21 + 30*a**4*b*c**21 +
        60*a**3*b**2*c**21 + 60*a**2*b**3*c**21 + 30*a*b**4*c**21 +
        5*b**5*c**21 - 6*a**4*c**22 - 23*a**3*b*c**22 -
        33*a**2*b**2*c**22 - 23*a*b**3*c**22 - 6*b**4*c**22 +
        5*a**3*c**23 + 13*a**2*b*c**23 + 13*a*b**2*c**23 +
        5*b**3*c**23 - 3*a**2*c**24 - 5*a*b*c**24 - 3*b**2*c**24 +
        a*c**25 + b*c**25), a**5*b**17*c**5/(a**7*b**19 - 3*a**6*b**20
        + 5*a**5*b**21 - 6*a**4*b**22 + 5*a**3*b**23 - 3*a**2*b**24 +
        a*b**25 - a**9*b**16*c + 5*a**8*b**17*c - 13*a**7*b**18*c +
        23*a**6*b**19*c - 30*a**5*b**20*c + 30*a**4*b**21*c -
        23*a**3*b**22*c + 13*a**2*b**23*c - 5*a*b**24*c + b**25*c -
        2*a**10*b**14*c**2 + 10*a**9*b**15*c**2 - 28*a**8*b**16*c**2 +
        54*a**7*b**17*c**2 - 79*a**6*b**18*c**2 + 91*a**5*b**19*c**2 -
        83*a**4*b**20*c**2 + 60*a**3*b**21*c**2 - 33*a**2*b**22*c**2 +
        13*a*b**23*c**2 - 3*b**24*c**2 - 2*a**11*b**12*c**3 +
        12*a**10*b**13*c**3 - 38*a**9*b**14*c**3 + 83*a**8*b**15*c**3
        - 137*a**7*b**16*c**3 + 180*a**6*b**17*c**3 -
        191*a**5*b**18*c**3 + 164*a**4*b**19*c**3 -
        113*a**3*b**20*c**3 + 60*a**2*b**21*c**3 - 23*a*b**22*c**3 +
        5*b**23*c**3 - a**12*b**10*c**4 + 9*a**11*b**11*c**4 -
        35*a**10*b**12*c**4 + 89*a**9*b**13*c**4 - 169*a**8*b**14*c**4
        + 253*a**7*b**15*c**4 - 308*a**6*b**16*c**4 +
        307*a**5*b**17*c**4 - 250*a**4*b**18*c**4 +
        164*a**3*b**19*c**4 - 83*a**2*b**20*c**4 + 30*a*b**21*c**4 -
        6*b**22*c**4 + 4*a**12*b**9*c**5 - 22*a**11*b**10*c**5 +
        68*a**10*b**11*c**5 - 151*a**9*b**12*c**5 +
        260*a**8*b**13*c**5 - 363*a**7*b**14*c**5 +
        417*a**6*b**15*c**5 - 395*a**5*b**16*c**5 +
        307*a**4*b**17*c**5 - 191*a**3*b**18*c**5 + 91*a**2*b**19*c**5
        - 30*a*b**20*c**5 + 5*b**21*c**5 + a**13*b**7*c**6 -
        9*a**12*b**8*c**6 + 36*a**11*b**9*c**6 - 96*a**10*b**10*c**6 +
        195*a**9*b**11*c**6 - 316*a**8*b**12*c**6 +
        420*a**7*b**13*c**6 - 461*a**6*b**14*c**6 +
        417*a**5*b**15*c**6 - 308*a**4*b**16*c**6 +
        180*a**3*b**17*c**6 - 79*a**2*b**18*c**6 + 23*a*b**19*c**6 -
        3*b**20*c**6 - 2*a**13*b**6*c**7 + 12*a**12*b**7*c**7 -
        41*a**11*b**8*c**7 + 102*a**10*b**9*c**7 - 198*a**9*b**10*c**7
        + 310*a**8*b**11*c**7 - 398*a**7*b**12*c**7 +
        420*a**6*b**13*c**7 - 363*a**5*b**14*c**7 +
        253*a**4*b**15*c**7 - 137*a**3*b**16*c**7 + 54*a**2*b**17*c**7
        - 13*a*b**18*c**7 + b**19*c**7 + 2*a**13*b**5*c**8 -
        10*a**12*b**6*c**8 + 33*a**11*b**7*c**8 - 82*a**10*b**8*c**8 +
        159*a**9*b**9*c**8 - 247*a**8*b**10*c**8 + 310*a**7*b**11*c**8
        - 316*a**6*b**12*c**8 + 260*a**5*b**13*c**8 -
        169*a**4*b**14*c**8 + 83*a**3*b**15*c**8 - 28*a**2*b**16*c**8
        + 5*a*b**17*c**8 - a**13*b**4*c**9 + 4*a**12*b**5*c**9 -
        16*a**11*b**6*c**9 + 47*a**10*b**7*c**9 - 99*a**9*b**8*c**9 +
        159*a**8*b**9*c**9 - 198*a**7*b**10*c**9 + 195*a**6*b**11*c**9
        - 151*a**5*b**12*c**9 + 89*a**4*b**13*c**9 -
        38*a**3*b**14*c**9 + 10*a**2*b**15*c**9 - a*b**16*c**9 -
        a**13*b**3*c**10 + 3*a**12*b**4*c**10 - 16*a**10*b**6*c**10 +
        47*a**9*b**7*c**10 - 82*a**8*b**8*c**10 + 102*a**7*b**9*c**10
        - 96*a**6*b**10*c**10 + 68*a**5*b**11*c**10 -
        35*a**4*b**12*c**10 + 12*a**3*b**13*c**10 - 2*a**2*b**14*c**10
        + 2*a**13*b**2*c**11 - 6*a**12*b**3*c**11 + 7*a**11*b**4*c**11
        - 16*a**9*b**6*c**11 + 33*a**8*b**7*c**11 - 41*a**7*b**8*c**11
        + 36*a**6*b**9*c**11 - 22*a**5*b**10*c**11 +
        9*a**4*b**11*c**11 - 2*a**3*b**12*c**11 - 2*a**13*b*c**12 +
        5*a**12*b**2*c**12 - 6*a**11*b**3*c**12 + 3*a**10*b**4*c**12 +
        4*a**9*b**5*c**12 - 10*a**8*b**6*c**12 + 12*a**7*b**7*c**12 -
        9*a**6*b**8*c**12 + 4*a**5*b**9*c**12 - a**4*b**10*c**12 +
        a**13*c**13 - 2*a**12*b*c**13 + 2*a**11*b**2*c**13 -
        a**10*b**3*c**13 - a**9*b**4*c**13 + 2*a**8*b**5*c**13 -
        2*a**7*b**6*c**13 + a**6*b**7*c**13),
        a**5*b**7*c**7/(a**13*b**5 - a**12*b**6 - a**11*b**7 +
        a**10*b**8 - 2*a**13*b**4*c + 2*a**12*b**5*c + 4*a**11*b**6*c
        - 4*a**10*b**7*c - 2*a**9*b**8*c + 2*a**8*b**9*c +
        a**13*b**3*c**2 - 2*a**12*b**4*c**2 - 6*a**11*b**5*c**2 +
        8*a**10*b**6*c**2 + 7*a**9*b**7*c**2 - 8*a**8*b**8*c**2 -
        2*a**7*b**9*c**2 + 2*a**6*b**10*c**2 + a**13*b**2*c**3 +
        2*a**12*b**3*c**3 + 3*a**11*b**4*c**3 - 11*a**10*b**5*c**3 -
        10*a**9*b**6*c**3 + 17*a**8*b**7*c**3 + 7*a**7*b**8*c**3 -
        9*a**6*b**9*c**3 - a**5*b**10*c**3 + a**4*b**11*c**3 -
        2*a**13*b*c**4 - 2*a**12*b**2*c**4 + 3*a**11*b**3*c**4 +
        12*a**10*b**4*c**4 + 5*a**9*b**5*c**4 - 25*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 + 21*a**6*b**8*c**4 + 4*a**5*b**9*c**4 -
        6*a**4*b**10*c**4 + a**13*c**5 + 2*a**12*b*c**5 -
        6*a**11*b**2*c**5 - 11*a**10*b**3*c**5 + 5*a**9*b**4*c**5 +
        28*a**8*b**5*c**5 + 5*a**7*b**6*c**5 - 33*a**6*b**7*c**5 -
        6*a**5*b**8*c**5 + 16*a**4*b**9*c**5 + a**3*b**10*c**5 -
        2*a**2*b**11*c**5 - a**12*c**6 + 4*a**11*b*c**6 +
        8*a**10*b**2*c**6 - 10*a**9*b**3*c**6 - 25*a**8*b**4*c**6 +
        5*a**7*b**5*c**6 + 38*a**6*b**6*c**6 + 3*a**5*b**7*c**6 -
        27*a**4*b**8*c**6 - 2*a**3*b**9*c**6 + 7*a**2*b**10*c**6 -
        a**11*c**7 - 4*a**10*b*c**7 + 7*a**9*b**2*c**7 +
        17*a**8*b**3*c**7 - 10*a**7*b**4*c**7 - 33*a**6*b**5*c**7 +
        3*a**5*b**6*c**7 + 32*a**4*b**7*c**7 + a**3*b**8*c**7 -
        13*a**2*b**9*c**7 + b**11*c**7 + a**10*c**8 - 2*a**9*b*c**8 -
        8*a**8*b**2*c**8 + 7*a**7*b**3*c**8 + 21*a**6*b**4*c**8 -
        6*a**5*b**5*c**8 - 27*a**4*b**6*c**8 + a**3*b**7*c**8 +
        16*a**2*b**8*c**8 - 3*b**10*c**8 + 2*a**8*b*c**9 -
        2*a**7*b**2*c**9 - 9*a**6*b**3*c**9 + 4*a**5*b**4*c**9 +
        16*a**4*b**5*c**9 - 2*a**3*b**6*c**9 - 13*a**2*b**7*c**9 +
        4*b**9*c**9 + 2*a**6*b**2*c**10 - a**5*b**3*c**10 -
        6*a**4*b**4*c**10 + a**3*b**5*c**10 + 7*a**2*b**6*c**10 -
        3*b**8*c**10 + a**4*b**3*c**11 - 2*a**2*b**5*c**11 +
        b**7*c**11), a**7*b**7*c**5/(a**11*b**7 - 3*a**10*b**8 +
        4*a**9*b**9 - 3*a**8*b**10 + a**7*b**11 - 2*a**11*b**5*c**2 +
        7*a**10*b**6*c**2 - 13*a**9*b**7*c**2 + 16*a**8*b**8*c**2 -
        13*a**7*b**9*c**2 + 7*a**6*b**10*c**2 - 2*a**5*b**11*c**2 +
        a**10*b**5*c**3 - 2*a**9*b**6*c**3 + a**8*b**7*c**3 +
        a**7*b**8*c**3 - 2*a**6*b**9*c**3 + a**5*b**10*c**3 +
        a**11*b**3*c**4 - 6*a**10*b**4*c**4 + 16*a**9*b**5*c**4 -
        27*a**8*b**6*c**4 + 32*a**7*b**7*c**4 - 27*a**6*b**8*c**4 +
        16*a**5*b**9*c**4 - 6*a**4*b**10*c**4 + a**3*b**11*c**4 -
        a**10*b**3*c**5 + 4*a**9*b**4*c**5 - 6*a**8*b**5*c**5 +
        3*a**7*b**6*c**5 + 3*a**6*b**7*c**5 - 6*a**5*b**8*c**5 +
        4*a**4*b**9*c**5 - a**3*b**10*c**5 + 2*a**10*b**2*c**6 -
        9*a**9*b**3*c**6 + 21*a**8*b**4*c**6 - 33*a**7*b**5*c**6 +
        38*a**6*b**6*c**6 - 33*a**5*b**7*c**6 + 21*a**4*b**8*c**6 -
        9*a**3*b**9*c**6 + 2*a**2*b**10*c**6 - 2*a**9*b**2*c**7 +
        7*a**8*b**3*c**7 - 10*a**7*b**4*c**7 + 5*a**6*b**5*c**7 +
        5*a**5*b**6*c**7 - 10*a**4*b**7*c**7 + 7*a**3*b**8*c**7 -
        2*a**2*b**9*c**7 + 2*a**9*b*c**8 - 8*a**8*b**2*c**8 +
        17*a**7*b**3*c**8 - 25*a**6*b**4*c**8 + 28*a**5*b**5*c**8 -
        25*a**4*b**6*c**8 + 17*a**3*b**7*c**8 - 8*a**2*b**8*c**8 +
        2*a*b**9*c**8 - 2*a**8*b*c**9 + 7*a**7*b**2*c**9 -
        10*a**6*b**3*c**9 + 5*a**5*b**4*c**9 + 5*a**4*b**5*c**9 -
        10*a**3*b**6*c**9 + 7*a**2*b**7*c**9 - 2*a*b**8*c**9 +
        a**8*c**10 - 4*a**7*b*c**10 + 8*a**6*b**2*c**10 -
        11*a**5*b**3*c**10 + 12*a**4*b**4*c**10 - 11*a**3*b**5*c**10 +
        8*a**2*b**6*c**10 - 4*a*b**7*c**10 + b**8*c**10 - a**7*c**11 +
        4*a**6*b*c**11 - 6*a**5*b**2*c**11 + 3*a**4*b**3*c**11 +
        3*a**3*b**4*c**11 - 6*a**2*b**5*c**11 + 4*a*b**6*c**11 -
        b**7*c**11 - a**6*c**12 + 2*a**5*b*c**12 - 2*a**4*b**2*c**12 +
        2*a**3*b**3*c**12 - 2*a**2*b**4*c**12 + 2*a*b**5*c**12 -
        b**6*c**12 + a**5*c**13 - 2*a**4*b*c**13 + a**3*b**2*c**13 +
        a**2*b**3*c**13 - 2*a*b**4*c**13 + b**5*c**13),
        a**7*b**5*c**7/(a**8*b**10 - a**7*b**11 - a**6*b**12 +
        a**5*b**13 + 2*a**9*b**8*c - 2*a**8*b**9*c - 4*a**7*b**10*c +
        4*a**6*b**11*c + 2*a**5*b**12*c - 2*a**4*b**13*c +
        2*a**10*b**6*c**2 - 2*a**9*b**7*c**2 - 8*a**8*b**8*c**2 +
        7*a**7*b**9*c**2 + 8*a**6*b**10*c**2 - 6*a**5*b**11*c**2 -
        2*a**4*b**12*c**2 + a**3*b**13*c**2 + a**11*b**4*c**3 -
        a**10*b**5*c**3 - 9*a**9*b**6*c**3 + 7*a**8*b**7*c**3 +
        17*a**7*b**8*c**3 - 10*a**6*b**9*c**3 - 11*a**5*b**10*c**3 +
        3*a**4*b**11*c**3 + 2*a**3*b**12*c**3 + a**2*b**13*c**3 -
        6*a**10*b**4*c**4 + 4*a**9*b**5*c**4 + 21*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 - 25*a**6*b**8*c**4 + 5*a**5*b**9*c**4 +
        12*a**4*b**10*c**4 + 3*a**3*b**11*c**4 - 2*a**2*b**12*c**4 -
        2*a*b**13*c**4 - 2*a**11*b**2*c**5 + a**10*b**3*c**5 +
        16*a**9*b**4*c**5 - 6*a**8*b**5*c**5 - 33*a**7*b**6*c**5 +
        5*a**6*b**7*c**5 + 28*a**5*b**8*c**5 + 5*a**4*b**9*c**5 -
        11*a**3*b**10*c**5 - 6*a**2*b**11*c**5 + 2*a*b**12*c**5 +
        b**13*c**5 + 7*a**10*b**2*c**6 - 2*a**9*b**3*c**6 -
        27*a**8*b**4*c**6 + 3*a**7*b**5*c**6 + 38*a**6*b**6*c**6 +
        5*a**5*b**7*c**6 - 25*a**4*b**8*c**6 - 10*a**3*b**9*c**6 +
        8*a**2*b**10*c**6 + 4*a*b**11*c**6 - b**12*c**6 + a**11*c**7 -
        13*a**9*b**2*c**7 + a**8*b**3*c**7 + 32*a**7*b**4*c**7 +
        3*a**6*b**5*c**7 - 33*a**5*b**6*c**7 - 10*a**4*b**7*c**7 +
        17*a**3*b**8*c**7 + 7*a**2*b**9*c**7 - 4*a*b**10*c**7 -
        b**11*c**7 - 3*a**10*c**8 + 16*a**8*b**2*c**8 + a**7*b**3*c**8
        - 27*a**6*b**4*c**8 - 6*a**5*b**5*c**8 + 21*a**4*b**6*c**8 +
        7*a**3*b**7*c**8 - 8*a**2*b**8*c**8 - 2*a*b**9*c**8 +
        b**10*c**8 + 4*a**9*c**9 - 13*a**7*b**2*c**9 -
        2*a**6*b**3*c**9 + 16*a**5*b**4*c**9 + 4*a**4*b**5*c**9 -
        9*a**3*b**6*c**9 - 2*a**2*b**7*c**9 + 2*a*b**8*c**9 -
        3*a**8*c**10 + 7*a**6*b**2*c**10 + a**5*b**3*c**10 -
        6*a**4*b**4*c**10 - a**3*b**5*c**10 + 2*a**2*b**6*c**10 +
        a**7*c**11 - 2*a**5*b**2*c**11 + a**3*b**4*c**11),
        (-a**5*b**5*c**5)/(a**8*b**6 - 2*a**7*b**7 + a**6*b**8 +
        a**9*b**4*c - 3*a**8*b**5*c + 2*a**7*b**6*c + 2*a**6*b**7*c -
        3*a**5*b**8*c + a**4*b**9*c - a**9*b**3*c**2 +
        5*a**7*b**5*c**2 - 8*a**6*b**6*c**2 + 5*a**5*b**7*c**2 -
        a**3*b**9*c**2 - a**9*b**2*c**3 + 4*a**8*b**3*c**3 -
        5*a**7*b**4*c**3 + 2*a**6*b**5*c**3 + 2*a**5*b**6*c**3 -
        5*a**4*b**7*c**3 + 4*a**3*b**8*c**3 - a**2*b**9*c**3 +
        a**9*b*c**4 - 5*a**7*b**3*c**4 + 6*a**6*b**4*c**4 -
        4*a**5*b**5*c**4 + 6*a**4*b**6*c**4 - 5*a**3*b**7*c**4 +
        a*b**9*c**4 - 3*a**8*b*c**5 + 5*a**7*b**2*c**5 +
        2*a**6*b**3*c**5 - 4*a**5*b**4*c**5 - 4*a**4*b**5*c**5 +
        2*a**3*b**6*c**5 + 5*a**2*b**7*c**5 - 3*a*b**8*c**5 +
        a**8*c**6 + 2*a**7*b*c**6 - 8*a**6*b**2*c**6 +
        2*a**5*b**3*c**6 + 6*a**4*b**4*c**6 + 2*a**3*b**5*c**6 -
        8*a**2*b**6*c**6 + 2*a*b**7*c**6 + b**8*c**6 - 2*a**7*c**7 +
        2*a**6*b*c**7 + 5*a**5*b**2*c**7 - 5*a**4*b**3*c**7 -
        5*a**3*b**4*c**7 + 5*a**2*b**5*c**7 + 2*a*b**6*c**7 -
        2*b**7*c**7 + a**6*c**8 - 3*a**5*b*c**8 + 4*a**3*b**3*c**8 -
        3*a*b**5*c**8 + b**6*c**8 + a**4*b*c**9 - a**3*b**2*c**9 -
        a**2*b**3*c**9 + a*b**4*c**9), (-a**5*b**10*c**5)/(a**8*b**11
        - 2*a**7*b**12 + 2*a**6*b**13 - 2*a**5*b**14 + a**4*b**15 +
        a**9*b**9*c - 3*a**8*b**10*c + 4*a**7*b**11*c - 4*a**6*b**12*c
        + 3*a**5*b**13*c - a**4*b**14*c - a**9*b**8*c**2 +
        a**8*b**9*c**2 - a**6*b**11*c**2 + 3*a**5*b**12*c**2 -
        3*a**4*b**13*c**2 + 2*a**3*b**14*c**2 - a**2*b**15*c**2 -
        a**9*b**7*c**3 + 4*a**8*b**8*c**3 - 7*a**7*b**9*c**3 +
        10*a**6*b**10*c**3 - 11*a**5*b**11*c**3 + 8*a**4*b**12*c**3 -
        5*a**3*b**13*c**3 + 2*a**2*b**14*c**3 + 2*a**9*b**6*c**4 -
        5*a**8*b**7*c**4 + 7*a**7*b**8*c**4 - 10*a**6*b**9*c**4 +
        9*a**5*b**10*c**4 - 5*a**4*b**11*c**4 + 3*a**3*b**12*c**4 -
        a*b**14*c**4 - a**9*b**5*c**5 + 2*a**7*b**7*c**5 -
        2*a**6*b**8*c**5 + 6*a**5*b**9*c**5 - 8*a**4*b**10*c**5 +
        6*a**3*b**11*c**5 - 6*a**2*b**12*c**5 + 3*a*b**13*c**5 -
        a**9*b**4*c**6 + 5*a**8*b**5*c**6 - 8*a**7*b**6*c**6 +
        11*a**6*b**7*c**6 - 16*a**5*b**8*c**6 + 15*a**4*b**9*c**6 -
        12*a**3*b**10*c**6 + 9*a**2*b**11*c**6 - 3*a*b**12*c**6 +
        a**9*b**3*c**7 - 3*a**8*b**4*c**7 + 3*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 8*a**5*b**7*c**7 - 6*a**4*b**8*c**7 +
        5*a**3*b**9*c**7 - 3*a**2*b**10*c**7 - a*b**11*c**7 +
        b**12*c**7 - a**8*b**3*c**8 + 4*a**7*b**4*c**8 -
        4*a**6*b**5*c**8 + 4*a**5*b**6*c**8 - 7*a**4*b**7*c**8 +
        6*a**3*b**8*c**8 - 6*a**2*b**9*c**8 + 6*a*b**10*c**8 -
        2*b**11*c**8 + 2*a**8*b**2*c**9 - 4*a**7*b**3*c**9 +
        3*a**6*b**4*c**9 - 6*a**5*b**5*c**9 + 9*a**4*b**6*c**9 -
        8*a**3*b**7*c**9 + 9*a**2*b**8*c**9 - 6*a*b**9*c**9 +
        b**10*c**9 - a**8*b*c**10 + 2*a**6*b**3*c**10 +
        a**5*b**4*c**10 - 2*a**4*b**5*c**10 + 2*a**3*b**6*c**10 -
        4*a**2*b**7*c**10 + a*b**8*c**10 + b**9*c**10 + 2*a**7*b*c**11
        - 3*a**6*b**2*c**11 + a**5*b**3*c**11 - 2*a**4*b**4*c**11 +
        2*a**3*b**5*c**11 - a**2*b**6*c**11 + 3*a*b**7*c**11 -
        2*b**8*c**11 - a**7*c**12 + a**5*b**2*c**12 + a**4*b**3*c**12
        - a**3*b**4*c**12 + 2*a**2*b**5*c**12 - 3*a*b**6*c**12 +
        b**7*c**12 + a**6*c**13 - a**5*b*c**13 - a**2*b**4*c**13 +
        a*b**5*c**13), (-a**10*b**5*c**5)/(a**12*b**7 - 2*a**11*b**8 +
        a**10*b**9 + a**9*b**10 - 2*a**8*b**11 + a**7*b**12 -
        a**14*b**4*c + 3*a**13*b**5*c - 3*a**12*b**6*c - a**11*b**7*c
        + 6*a**10*b**8*c - 6*a**9*b**9*c + a**8*b**10*c +
        3*a**7*b**11*c - 3*a**6*b**12*c + a**5*b**13*c -
        a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 6*a**12*b**5*c**2 +
        9*a**11*b**6*c**2 - 3*a**10*b**7*c**2 - 6*a**9*b**8*c**2 +
        9*a**8*b**9*c**2 - 4*a**7*b**10*c**2 - a**6*b**11*c**2 +
        2*a**5*b**12*c**2 - a**4*b**13*c**2 + 2*a**14*b**2*c**3 -
        5*a**13*b**3*c**3 + 3*a**12*b**4*c**3 + 6*a**11*b**5*c**3 -
        12*a**10*b**6*c**3 + 5*a**9*b**7*c**3 + 6*a**8*b**8*c**3 -
        8*a**7*b**9*c**3 + 2*a**6*b**10*c**3 + 2*a**5*b**11*c**3 -
        a**4*b**12*c**3 + a**15*c**4 - a**14*b*c**4 -
        3*a**13*b**2*c**4 + 8*a**12*b**3*c**4 - 5*a**11*b**4*c**4 -
        8*a**10*b**5*c**4 + 15*a**9*b**6*c**4 - 6*a**8*b**7*c**4 -
        7*a**7*b**8*c**4 + 9*a**6*b**9*c**4 - 2*a**5*b**10*c**4 -
        2*a**4*b**11*c**4 + a**3*b**12*c**4 - 2*a**14*c**5 +
        3*a**13*b*c**5 + 3*a**12*b**2*c**5 - 11*a**11*b**3*c**5 +
        9*a**10*b**4*c**5 + 6*a**9*b**5*c**5 - 16*a**8*b**6*c**5 +
        8*a**7*b**7*c**5 + 4*a**6*b**8*c**5 - 6*a**5*b**9*c**5 +
        a**4*b**10*c**5 + a**3*b**11*c**5 + a**2*b**12*c**5 -
        a*b**13*c**5 + 2*a**13*c**6 - 4*a**12*b*c**6 - a**11*b**2*c**6
        + 10*a**10*b**3*c**6 - 10*a**9*b**4*c**6 - 2*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 +
        3*a**4*b**9*c**6 + 2*a**3*b**10*c**6 - 3*a**2*b**11*c**6 +
        b**13*c**6 - 2*a**12*c**7 + 4*a**11*b*c**7 - 7*a**9*b**3*c**7
        + 7*a**8*b**4*c**7 + 2*a**7*b**5*c**7 - 8*a**6*b**6*c**7 +
        3*a**5*b**7*c**7 + 4*a**4*b**8*c**7 - 4*a**3*b**9*c**7 +
        2*a*b**11*c**7 - b**12*c**7 + a**11*c**8 - 3*a**10*b*c**8 +
        a**9*b**2*c**8 + 4*a**8*b**3*c**8 - 5*a**7*b**4*c**8 +
        5*a**5*b**6*c**8 - 3*a**4*b**7*c**8 - a**3*b**8*c**8 +
        2*a**2*b**9*c**8 - a*b**10*c**8 + a**9*b*c**9 - a**8*b**2*c**9
        - a**7*b**3*c**9 + 2*a**6*b**4*c**9 - a**5*b**5*c**9 -
        a**4*b**6*c**9 + a**3*b**7*c**9),
        (-a**5*b**5*c**10)/(a**13*b**6 - a**12*b**7 - a**13*b**5*c +
        2*a**11*b**7*c - a**10*b**8*c + a**12*b**5*c**2 -
        3*a**11*b**6*c**2 + 2*a**9*b**8*c**2 + a**12*b**4*c**3 +
        a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 4*a**9*b**7*c**3 -
        a**8*b**8*c**3 + a**7*b**9*c**3 - a**13*b**2*c**4 -
        a**12*b**3*c**4 - 2*a**11*b**4*c**4 + a**10*b**5*c**4 +
        3*a**9*b**6*c**4 + 4*a**8*b**7*c**4 - 3*a**7*b**8*c**4 -
        a**6*b**9*c**4 + a**13*b*c**5 + 2*a**12*b**2*c**5 +
        2*a**11*b**3*c**5 - 2*a**10*b**4*c**5 - 6*a**9*b**5*c**5 -
        4*a**8*b**6*c**5 + 3*a**7*b**7*c**5 + 5*a**6*b**8*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 - a**11*b**2*c**6 +
        2*a**10*b**3*c**6 + 9*a**9*b**4*c**6 + 4*a**8*b**5*c**6 -
        5*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 2*a**4*b**9*c**6 +
        a**12*c**7 + 3*a**11*b*c**7 - 4*a**10*b**2*c**7 -
        8*a**9*b**3*c**7 - 7*a**8*b**4*c**7 + 8*a**7*b**5*c**7 +
        11*a**6*b**6*c**7 + 2*a**5*b**7*c**7 - 5*a**4*b**8*c**7 -
        a**3*b**9*c**7 - 2*a**11*c**8 + a**10*b*c**8 +
        9*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 6*a**7*b**4*c**8 -
        16*a**6*b**5*c**8 - 2*a**5*b**6*c**8 + 7*a**4*b**7*c**8 +
        4*a**3*b**8*c**8 - a**2*b**9*c**8 + a**10*c**9 - 6*a**9*b*c**9
        - 6*a**8*b**2*c**9 + 5*a**7*b**3*c**9 + 15*a**6*b**4*c**9 +
        6*a**5*b**5*c**9 - 10*a**4*b**6*c**9 - 7*a**3*b**7*c**9 +
        a**2*b**8*c**9 + a*b**9*c**9 + a**9*c**10 + 6*a**8*b*c**10 -
        3*a**7*b**2*c**10 - 12*a**6*b**3*c**10 - 8*a**5*b**4*c**10 +
        9*a**4*b**5*c**10 + 10*a**3*b**6*c**10 - 3*a*b**8*c**10 -
        2*a**8*c**11 - a**7*b*c**11 + 9*a**6*b**2*c**11 +
        6*a**5*b**3*c**11 - 5*a**4*b**4*c**11 - 11*a**3*b**5*c**11 -
        a**2*b**6*c**11 + 4*a*b**7*c**11 + b**8*c**11 + a**7*c**12 -
        3*a**6*b*c**12 - 6*a**5*b**2*c**12 + 3*a**4*b**3*c**12 +
        8*a**3*b**4*c**12 + 3*a**2*b**5*c**12 - 4*a*b**6*c**12 -
        2*b**7*c**12 + 3*a**5*b*c**13 - 5*a**3*b**3*c**13 -
        3*a**2*b**4*c**13 + 3*a*b**5*c**13 + 2*b**6*c**13 -
        a**4*b*c**14 + 2*a**3*b**2*c**14 + 2*a**2*b**3*c**14 -
        a*b**4*c**14 - 2*b**5*c**14 - a**2*b**2*c**15 + b**4*c**15),
        a**5*b**5*c**10/(a**7*b**12 - a**6*b**13 + a**8*b**10*c -
        2*a**7*b**11*c + a**5*b**13*c - 2*a**8*b**9*c**2 +
        3*a**6*b**11*c**2 - a**5*b**12*c**2 - a**9*b**7*c**3 +
        a**8*b**8*c**3 + 4*a**7*b**9*c**3 - 2*a**6*b**10*c**3 -
        a**5*b**11*c**3 - a**4*b**12*c**3 + a**9*b**6*c**4 +
        3*a**8*b**7*c**4 - 4*a**7*b**8*c**4 - 3*a**6*b**9*c**4 -
        a**5*b**10*c**4 + 2*a**4*b**11*c**4 + a**3*b**12*c**4 +
        a**2*b**13*c**4 + a**9*b**5*c**5 - 5*a**8*b**6*c**5 -
        3*a**7*b**7*c**5 + 4*a**6*b**8*c**5 + 6*a**5*b**9*c**5 +
        2*a**4*b**10*c**5 - 2*a**3*b**11*c**5 - 2*a**2*b**12*c**5 -
        a*b**13*c**5 - 2*a**9*b**4*c**6 + 8*a**7*b**6*c**6 +
        5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 - 9*a**4*b**9*c**6 -
        2*a**3*b**10*c**6 + a**2*b**11*c**6 + 3*a*b**12*c**6 +
        a**9*b**3*c**7 + 5*a**8*b**4*c**7 - 2*a**7*b**5*c**7 -
        11*a**6*b**6*c**7 - 8*a**5*b**7*c**7 + 7*a**4*b**8*c**7 +
        8*a**3*b**9*c**7 + 4*a**2*b**10*c**7 - 3*a*b**11*c**7 -
        b**12*c**7 + a**9*b**2*c**8 - 4*a**8*b**3*c**8 -
        7*a**7*b**4*c**8 + 2*a**6*b**5*c**8 + 16*a**5*b**6*c**8 +
        6*a**4*b**7*c**8 - 6*a**3*b**8*c**8 - 9*a**2*b**9*c**8 -
        a*b**10*c**8 + 2*b**11*c**8 - a**9*b*c**9 - a**8*b**2*c**9 +
        7*a**7*b**3*c**9 + 10*a**6*b**4*c**9 - 6*a**5*b**5*c**9 -
        15*a**4*b**6*c**9 - 5*a**3*b**7*c**9 + 6*a**2*b**8*c**9 +
        6*a*b**9*c**9 - b**10*c**9 + 3*a**8*b*c**10 -
        10*a**6*b**3*c**10 - 9*a**5*b**4*c**10 + 8*a**4*b**5*c**10 +
        12*a**3*b**6*c**10 + 3*a**2*b**7*c**10 - 6*a*b**8*c**10 -
        b**9*c**10 - a**8*c**11 - 4*a**7*b*c**11 + a**6*b**2*c**11 +
        11*a**5*b**3*c**11 + 5*a**4*b**4*c**11 - 6*a**3*b**5*c**11 -
        9*a**2*b**6*c**11 + a*b**7*c**11 + 2*b**8*c**11 + 2*a**7*c**12
        + 4*a**6*b*c**12 - 3*a**5*b**2*c**12 - 8*a**4*b**3*c**12 -
        3*a**3*b**4*c**12 + 6*a**2*b**5*c**12 + 3*a*b**6*c**12 -
        b**7*c**12 - 2*a**6*c**13 - 3*a**5*b*c**13 + 3*a**4*b**2*c**13
        + 5*a**3*b**3*c**13 - 3*a*b**5*c**13 + 2*a**5*c**14 +
        a**4*b*c**14 - 2*a**3*b**2*c**14 - 2*a**2*b**3*c**14 +
        a*b**4*c**14 - a**4*c**15 + a**2*b**2*c**15),
        (-a**10*b**5*c**5)/(a**15*b**4 - 2*a**14*b**5 + 2*a**13*b**6 -
        2*a**12*b**7 + a**11*b**8 - a**14*b**4*c + 3*a**13*b**5*c -
        4*a**12*b**6*c + 4*a**11*b**7*c - 3*a**10*b**8*c + a**9*b**9*c
        - a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 3*a**13*b**4*c**2 +
        3*a**12*b**5*c**2 - a**11*b**6*c**2 + a**9*b**8*c**2 -
        a**8*b**9*c**2 + 2*a**14*b**2*c**3 - 5*a**13*b**3*c**3 +
        8*a**12*b**4*c**3 - 11*a**11*b**5*c**3 + 10*a**10*b**6*c**3 -
        7*a**9*b**7*c**3 + 4*a**8*b**8*c**3 - a**7*b**9*c**3 -
        a**14*b*c**4 + 3*a**12*b**3*c**4 - 5*a**11*b**4*c**4 +
        9*a**10*b**5*c**4 - 10*a**9*b**6*c**4 + 7*a**8*b**7*c**4 -
        5*a**7*b**8*c**4 + 2*a**6*b**9*c**4 + 3*a**13*b*c**5 -
        6*a**12*b**2*c**5 + 6*a**11*b**3*c**5 - 8*a**10*b**4*c**5 +
        6*a**9*b**5*c**5 - 2*a**8*b**6*c**5 + 2*a**7*b**7*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 + 9*a**11*b**2*c**6 -
        12*a**10*b**3*c**6 + 15*a**9*b**4*c**6 - 16*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 5*a**5*b**8*c**6 -
        a**4*b**9*c**6 + a**12*c**7 - a**11*b*c**7 - 3*a**10*b**2*c**7
        + 5*a**9*b**3*c**7 - 6*a**8*b**4*c**7 + 8*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 3*a**5*b**7*c**7 - 3*a**4*b**8*c**7 +
        a**3*b**9*c**7 - 2*a**11*c**8 + 6*a**10*b*c**8 -
        6*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 7*a**7*b**4*c**8 +
        4*a**6*b**5*c**8 - 4*a**5*b**6*c**8 + 4*a**4*b**7*c**8 -
        a**3*b**8*c**8 + a**10*c**9 - 6*a**9*b*c**9 + 9*a**8*b**2*c**9
        - 8*a**7*b**3*c**9 + 9*a**6*b**4*c**9 - 6*a**5*b**5*c**9 +
        3*a**4*b**6*c**9 - 4*a**3*b**7*c**9 + 2*a**2*b**8*c**9 +
        a**9*c**10 + a**8*b*c**10 - 4*a**7*b**2*c**10 +
        2*a**6*b**3*c**10 - 2*a**5*b**4*c**10 + a**4*b**5*c**10 +
        2*a**3*b**6*c**10 - a*b**8*c**10 - 2*a**8*c**11 +
        3*a**7*b*c**11 - a**6*b**2*c**11 + 2*a**5*b**3*c**11 -
        2*a**4*b**4*c**11 + a**3*b**5*c**11 - 3*a**2*b**6*c**11 +
        2*a*b**7*c**11 + a**7*c**12 - 3*a**6*b*c**12 +
        2*a**5*b**2*c**12 - a**4*b**3*c**12 + a**3*b**4*c**12 +
        a**2*b**5*c**12 - b**7*c**12 + a**5*b*c**13 - a**4*b**2*c**13
        - a*b**5*c**13 + b**6*c**13), (-a**5*b**10*c**5)/(a**12*b**7 -
        2*a**11*b**8 + a**10*b**9 + a**9*b**10 - 2*a**8*b**11 +
        a**7*b**12 + a**13*b**5*c - 3*a**12*b**6*c + 3*a**11*b**7*c +
        a**10*b**8*c - 6*a**9*b**9*c + 6*a**8*b**10*c - a**7*b**11*c -
        3*a**6*b**12*c + 3*a**5*b**13*c - a**4*b**14*c -
        a**13*b**4*c**2 + 2*a**12*b**5*c**2 - a**11*b**6*c**2 -
        4*a**10*b**7*c**2 + 9*a**9*b**8*c**2 - 6*a**8*b**9*c**2 -
        3*a**7*b**10*c**2 + 9*a**6*b**11*c**2 - 6*a**5*b**12*c**2 +
        2*a**3*b**14*c**2 - a**2*b**15*c**2 - a**12*b**4*c**3 +
        2*a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 8*a**9*b**7*c**3 +
        6*a**8*b**8*c**3 + 5*a**7*b**9*c**3 - 12*a**6*b**10*c**3 +
        6*a**5*b**11*c**3 + 3*a**4*b**12*c**3 - 5*a**3*b**13*c**3 +
        2*a**2*b**14*c**3 + a**12*b**3*c**4 - 2*a**11*b**4*c**4 -
        2*a**10*b**5*c**4 + 9*a**9*b**6*c**4 - 7*a**8*b**7*c**4 -
        6*a**7*b**8*c**4 + 15*a**6*b**9*c**4 - 8*a**5*b**10*c**4 -
        5*a**4*b**11*c**4 + 8*a**3*b**12*c**4 - 3*a**2*b**13*c**4 -
        a*b**14*c**4 + b**15*c**4 - a**13*b*c**5 + a**12*b**2*c**5 +
        a**11*b**3*c**5 + a**10*b**4*c**5 - 6*a**9*b**5*c**5 +
        4*a**8*b**6*c**5 + 8*a**7*b**7*c**5 - 16*a**6*b**8*c**5 +
        6*a**5*b**9*c**5 + 9*a**4*b**10*c**5 - 11*a**3*b**11*c**5 +
        3*a**2*b**12*c**5 + 3*a*b**13*c**5 - 2*b**14*c**5 + a**13*c**6
        - 3*a**11*b**2*c**6 + 2*a**10*b**3*c**6 + 3*a**9*b**4*c**6 -
        4*a**8*b**5*c**6 - 5*a**7*b**6*c**6 + 11*a**6*b**7*c**6 -
        2*a**5*b**8*c**6 - 10*a**4*b**9*c**6 + 10*a**3*b**10*c**6 -
        a**2*b**11*c**6 - 4*a*b**12*c**6 + 2*b**13*c**6 - a**12*c**7 +
        2*a**11*b*c**7 - 4*a**9*b**3*c**7 + 4*a**8*b**4*c**7 +
        3*a**7*b**5*c**7 - 8*a**6*b**6*c**7 + 2*a**5*b**7*c**7 +
        7*a**4*b**8*c**7 - 7*a**3*b**9*c**7 + 4*a*b**11*c**7 -
        2*b**12*c**7 - a**10*b*c**8 + 2*a**9*b**2*c**8 -
        a**8*b**3*c**8 - 3*a**7*b**4*c**8 + 5*a**6*b**5*c**8 -
        5*a**4*b**7*c**8 + 4*a**3*b**8*c**8 + a**2*b**9*c**8 -
        3*a*b**10*c**8 + b**11*c**8 + a**7*b**3*c**9 - a**6*b**4*c**9
        - a**5*b**5*c**9 + 2*a**4*b**6*c**9 - a**3*b**7*c**9 -
        a**2*b**8*c**9 + a*b**9*c**9), a**5*b**5*c**7/(a**9*b**7 -
        a**8*b**8 - a**7*b**9 + a**6*b**10 - a**9*b**6*c + a**8*b**7*c
        + 2*a**7*b**8*c - 2*a**6*b**9*c - a**5*b**10*c + a**4*b**11*c
        - a**9*b**5*c**2 + 2*a**6*b**8*c**2 + a**5*b**9*c**2 -
        2*a**4*b**10*c**2 + 2*a**9*b**4*c**3 - 4*a**7*b**6*c**3 -
        a**6*b**7*c**3 + 2*a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**2*b**11*c**3 - a**9*b**3*c**4 + 4*a**7*b**5*c**4 -
        4*a**5*b**7*c**4 - a**4*b**8*c**4 + a**3*b**9*c**4 +
        a**2*b**10*c**4 - a**9*b**2*c**5 + a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 - 2*a**4*b**7*c**5 -
        a**3*b**8*c**5 + a**2*b**9*c**5 + a**9*b*c**6 + a**8*b**2*c**6
        - 4*a**7*b**3*c**6 - 3*a**6*b**4*c**6 + 4*a**5*b**5*c**6 +
        5*a**4*b**6*c**6 - a**3*b**7*c**6 - 4*a**2*b**8*c**6 +
        b**10*c**6 - a**8*b*c**7 + 2*a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 4*a**5*b**4*c**7 - 5*a**4*b**5*c**7 + 2*a**3*b**6*c**7 +
        5*a**2*b**7*c**7 - 2*b**9*c**7 + a**7*b*c**8 - a**6*b**2*c**8
        + a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 + b**8*c**8
        - a**7*c**9 - a**6*b*c**9 + 2*a**5*b**2*c**9 +
        3*a**4*b**3*c**9 - a**3*b**4*c**9 - 3*a**2*b**5*c**9 +
        b**7*c**9 + a**6*c**10 - a**5*b*c**10 - 3*a**4*b**2*c**10 +
        a**3*b**3*c**10 + 4*a**2*b**4*c**10 - 2*b**6*c**10 +
        a**4*b*c**11 - 2*a**2*b**3*c**11 + b**5*c**11),
        a**5*b**7*c**5/(a**10*b**6 - 2*a**9*b**7 + a**8*b**8 +
        a**7*b**9 - 2*a**6*b**10 + a**5*b**11 - a**11*b**3*c**2 +
        a**10*b**4*c**2 + a**9*b**5*c**2 - 4*a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - a**6*b**8*c**2 - 3*a**5*b**9*c**2 +
        4*a**4*b**10*c**2 - 2*a**3*b**11*c**2 + a**9*b**4*c**3 -
        a**8*b**5*c**3 - a**7*b**6*c**3 + 2*a**6*b**7*c**3 -
        a**5*b**8*c**3 - a**4*b**9*c**3 + a**3*b**10*c**3 +
        a**11*b*c**4 - 2*a**10*b**2*c**4 + 2*a**9*b**3*c**4 -
        a**8*b**4*c**4 - 2*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        5*a**5*b**7*c**4 + a**4*b**8*c**4 + 3*a**3*b**9*c**4 -
        3*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        a**9*b**2*c**5 + 2*a**8*b**3*c**5 - 4*a**7*b**4*c**5 +
        a**6*b**5*c**5 + 4*a**5*b**6*c**5 - 4*a**4*b**7*c**5 +
        2*a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - 2*a**9*b*c**6 +
        2*a**8*b**2*c**6 - a**7*b**3*c**6 + a**5*b**5*c**6 -
        3*a**4*b**6*c**6 + 3*a**3*b**7*c**6 - a**2*b**8*c**6 -
        a*b**9*c**6 + b**10*c**6 - a**9*c**7 + 2*a**8*b*c**7 -
        4*a**6*b**3*c**7 + 4*a**5*b**4*c**7 + a**4*b**5*c**7 -
        4*a**3*b**6*c**7 + 2*a**2*b**7*c**7 + a*b**8*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + a**2*b**6*c**8 - a*b**7*c**8 +
        a**7*c**9 - a**6*b*c**9 - a**5*b**2*c**9 + 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + a*b**6*c**9),
        a**7*b**5*c**5/(a**10*b**6 - a**9*b**7 + a**11*b**4*c -
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c - a**7*b**8*c +
        a**6*b**9*c - 3*a**10*b**4*c**2 + 2*a**9*b**5*c**2 -
        a**8*b**6*c**2 + 2*a**7*b**7*c**2 + a**6*b**8*c**2 -
        a**5*b**9*c**2 - 2*a**11*b**2*c**3 + a**10*b**3*c**3 +
        3*a**9*b**4*c**3 + 3*a**7*b**6*c**3 - 4*a**6*b**7*c**3 -
        a**4*b**9*c**3 + 4*a**10*b**2*c**4 - a**9*b**3*c**4 +
        a**8*b**4*c**4 - 4*a**7*b**5*c**4 - 3*a**6*b**6*c**4 +
        a**5*b**7*c**4 + 2*a**3*b**9*c**4 + a**11*c**5 -
        3*a**9*b**2*c**5 - a**8*b**3*c**5 - 5*a**7*b**4*c**5 +
        4*a**6*b**5*c**5 + a**5*b**6*c**5 + 4*a**4*b**7*c**5 -
        a**2*b**9*c**5 - 2*a**10*c**6 - a**8*b**2*c**6 +
        2*a**7*b**3*c**6 + 5*a**6*b**4*c**6 + a**5*b**5*c**6 -
        4*a**3*b**7*c**6 - a*b**9*c**6 + a**9*c**7 + 5*a**7*b**2*c**7
        - a**6*b**3*c**7 - 2*a**5*b**4*c**7 - 4*a**4*b**5*c**7 -
        a**3*b**6*c**7 + a*b**8*c**7 + b**9*c**7 + a**8*c**8 -
        4*a**6*b**2*c**8 - a**5*b**3*c**8 - a**4*b**4*c**8 +
        2*a**3*b**5*c**8 + 2*a**2*b**6*c**8 + 2*a*b**7*c**8 -
        b**8*c**8 - 2*a**7*c**9 + a**5*b**2*c**9 + a**4*b**3*c**9 +
        2*a**3*b**4*c**9 + a**2*b**5*c**9 - 2*a*b**6*c**9 - b**7*c**9
        + a**6*c**10 + a**4*b**2*c**10 - 2*a**2*b**4*c**10 -
        a*b**5*c**10 + b**6*c**10 - a**3*b**2*c**11 + a*b**4*c**11),
        (-a**5*b**7*c**5)/(a**7*b**9 - a**6*b**10 - a**9*b**6*c +
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c + a**5*b**10*c -
        a**4*b**11*c + a**9*b**5*c**2 - a**8*b**6*c**2 -
        2*a**7*b**7*c**2 + a**6*b**8*c**2 - 2*a**5*b**9*c**2 +
        3*a**4*b**10*c**2 + a**9*b**4*c**3 + 4*a**7*b**6*c**3 -
        3*a**6*b**7*c**3 - 3*a**4*b**9*c**3 - a**3*b**10*c**3 +
        2*a**2*b**11*c**3 - 2*a**9*b**3*c**4 - a**7*b**5*c**4 +
        3*a**6*b**6*c**4 + 4*a**5*b**7*c**4 - a**4*b**8*c**4 +
        a**3*b**9*c**4 - 4*a**2*b**10*c**4 + a**9*b**2*c**5 -
        4*a**7*b**4*c**5 - a**6*b**5*c**5 - 4*a**5*b**6*c**5 +
        5*a**4*b**7*c**5 + a**3*b**8*c**5 + 3*a**2*b**9*c**5 -
        b**11*c**5 + a**9*b*c**6 + 4*a**7*b**3*c**6 - a**5*b**5*c**6 -
        5*a**4*b**6*c**6 - 2*a**3*b**7*c**6 + a**2*b**8*c**6 +
        2*b**10*c**6 - a**9*c**7 - a**8*b*c**7 + a**6*b**3*c**7 +
        4*a**5*b**4*c**7 + 2*a**4*b**5*c**7 + a**3*b**6*c**7 -
        5*a**2*b**7*c**7 - b**9*c**7 + a**8*c**8 - 2*a**7*b*c**8 -
        2*a**6*b**2*c**8 - 2*a**5*b**3*c**8 + a**4*b**4*c**8 +
        a**3*b**5*c**8 + 4*a**2*b**6*c**8 - b**8*c**8 + a**7*c**9 +
        2*a**6*b*c**9 - a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + 2*b**7*c**9 - a**6*c**10 +
        a**5*b*c**10 + 2*a**4*b**2*c**10 - a**2*b**4*c**10 -
        b**6*c**10 - a**4*b*c**11 + a**2*b**3*c**11),
        a**5*b**5*c**7/(a**10*b**6 - a**9*b**7 - a**8*b**8 + a**7*b**9
        + a**11*b**4*c - a**10*b**5*c - 2*a**9*b**6*c + 2*a**8*b**7*c
        + a**7*b**8*c - a**6*b**9*c - 2*a**10*b**4*c**2 +
        a**9*b**5*c**2 + 2*a**8*b**6*c**2 - a**5*b**9*c**2 -
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 + 2*a**8*b**5*c**3 -
        a**7*b**6*c**3 - 4*a**6*b**7*c**3 + 2*a**4*b**9*c**3 +
        a**10*b**2*c**4 + a**9*b**3*c**4 - a**8*b**4*c**4 -
        4*a**7*b**5*c**4 + 4*a**5*b**7*c**4 - a**3*b**9*c**4 +
        a**9*b**2*c**5 - a**8*b**3*c**5 - 2*a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 + a**4*b**7*c**5 -
        a**2*b**9*c**5 + a**10*c**6 - 4*a**8*b**2*c**6 -
        a**7*b**3*c**6 + 5*a**6*b**4*c**6 + 4*a**5*b**5*c**6 -
        3*a**4*b**6*c**6 - 4*a**3*b**7*c**6 + a**2*b**8*c**6 +
        a*b**9*c**6 - 2*a**9*c**7 + 5*a**7*b**2*c**7 +
        2*a**6*b**3*c**7 - 5*a**5*b**4*c**7 - 4*a**4*b**5*c**7 +
        3*a**3*b**6*c**7 + 2*a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8
        - a**6*b**2*c**8 - a**5*b**3*c**8 + a**4*b**4*c**8 -
        a**2*b**6*c**8 + a*b**7*c**8 + a**7*c**9 - 3*a**5*b**2*c**9 -
        a**4*b**3*c**9 + 3*a**3*b**4*c**9 + 2*a**2*b**5*c**9 -
        a*b**6*c**9 - b**7*c**9 - 2*a**6*c**10 + 4*a**4*b**2*c**10 +
        a**3*b**3*c**10 - 3*a**2*b**4*c**10 - a*b**5*c**10 +
        b**6*c**10 + a**5*c**11 - 2*a**3*b**2*c**11 + a*b**4*c**11),
        a**7*b**5*c**5/(a**11*b**5 - 2*a**10*b**6 + a**9*b**7 +
        a**8*b**8 - 2*a**7*b**9 + a**6*b**10 - 2*a**11*b**3*c**2 +
        4*a**10*b**4*c**2 - 3*a**9*b**5*c**2 - a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - 4*a**6*b**8*c**2 + a**5*b**9*c**2 +
        a**4*b**10*c**2 - a**3*b**11*c**2 + a**10*b**3*c**3 -
        a**9*b**4*c**3 - a**8*b**5*c**3 + 2*a**7*b**6*c**3 -
        a**6*b**7*c**3 - a**5*b**8*c**3 + a**4*b**9*c**3 +
        a**11*b*c**4 - 3*a**10*b**2*c**4 + 3*a**9*b**3*c**4 +
        a**8*b**4*c**4 - 5*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        2*a**5*b**7*c**4 - a**4*b**8*c**4 + 2*a**3*b**9*c**4 -
        2*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        2*a**9*b**2*c**5 - 4*a**7*b**4*c**5 + 4*a**6*b**5*c**5 +
        a**5*b**6*c**5 - 4*a**4*b**7*c**5 + 2*a**3*b**8*c**5 +
        a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - a**9*b*c**6 -
        a**8*b**2*c**6 + 3*a**7*b**3*c**6 - 3*a**6*b**4*c**6 +
        a**5*b**5*c**6 - a**3*b**7*c**6 + 2*a**2*b**8*c**6 -
        2*a*b**9*c**6 + b**10*c**6 - a**9*c**7 + a**8*b*c**7 +
        2*a**7*b**2*c**7 - 4*a**6*b**3*c**7 + a**5*b**4*c**7 +
        4*a**4*b**5*c**7 - 4*a**3*b**6*c**7 + 2*a*b**8*c**7 -
        b**9*c**7 - a**7*b*c**8 + a**6*b**2*c**8 + a*b**7*c**8 -
        b**8*c**8 + a**6*b*c**9 - a**5*b**2*c**9 - a**4*b**3*c**9 +
        2*a**3*b**4*c**9 - a**2*b**5*c**9 - a*b**6*c**9 + b**7*c**9),
        a**7*b**5*c**5/(a**9*b**7 - a**8*b**8 - a**11*b**4*c +
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c + a**7*b**8*c -
        a**6*b**9*c + a**11*b**3*c**2 - a**10*b**4*c**2 -
        2*a**9*b**5*c**2 + a**8*b**6*c**2 - a**7*b**7*c**2 +
        2*a**6*b**8*c**2 + a**5*b**9*c**2 - a**4*b**10*c**2 +
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 - a**8*b**5*c**3 -
        3*a**7*b**6*c**3 - a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**11*b*c**4 - a**10*b**2*c**4 + 2*a**9*b**3*c**4 +
        3*a**7*b**5*c**4 - a**6*b**6*c**4 - 2*a**5*b**7*c**4 -
        a**4*b**8*c**4 + a**2*b**10*c**4 + a**10*b*c**5 -
        2*a**9*b**2*c**5 - a**8*b**3*c**5 + 3*a**7*b**4*c**5 +
        2*a**5*b**6*c**5 - a**4*b**7*c**5 - a**3*b**8*c**5 -
        a**2*b**9*c**5 - a**9*b*c**6 + a**8*b**2*c**6 -
        3*a**7*b**3*c**6 - a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        2*a**4*b**6*c**6 + a**3*b**7*c**6 - a**2*b**8*c**6 + a**9*c**7
        + a**8*b*c**7 - a**7*b**2*c**7 - 2*a**5*b**4*c**7 -
        a**4*b**5*c**7 + a**3*b**6*c**7 + 2*a**2*b**7*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + 2*a**6*b**2*c**8 - a**5*b**3*c**8
        - a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 +
        2*b**8*c**8 - a**6*b*c**9 + a**5*b**2*c**9 + 2*a**4*b**3*c**9
        - a**2*b**5*c**9 - b**7*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (-a**5*b**5*c**7)/(a**9*b**7 - 2*a**8*b**8 +
        a**7*b**9 - a**10*b**4*c**2 + a**9*b**5*c**2 + a**8*b**6*c**2
        - 2*a**7*b**7*c**2 + a**6*b**8*c**2 + a**5*b**9*c**2 -
        a**4*b**10*c**2 + a**8*b**5*c**3 - a**7*b**6*c**3 -
        a**6*b**7*c**3 + a**5*b**8*c**3 + a**10*b**2*c**4 -
        2*a**9*b**3*c**4 + a**8*b**4*c**4 + a**7*b**5*c**4 -
        2*a**6*b**6*c**4 + a**5*b**7*c**4 + a**4*b**8*c**4 -
        2*a**3*b**9*c**4 + a**2*b**10*c**4 - a**9*b**2*c**5 +
        a**8*b**3*c**5 + 2*a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        2*a**5*b**6*c**5 + 2*a**4*b**7*c**5 + a**3*b**8*c**5 -
        a**2*b**9*c**5 + a**9*b*c**6 - 2*a**8*b**2*c**6 +
        a**6*b**4*c**6 + a**4*b**6*c**6 - 2*a**2*b**8*c**6 +
        a*b**9*c**6 - a**8*b*c**7 + a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 3*a**5*b**4*c**7 - 3*a**4*b**5*c**7 + 3*a**3*b**6*c**7 +
        a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8 - a**7*b*c**8 -
        a**6*b**2*c**8 + a**5*b**3*c**8 + a**3*b**5*c**8 -
        a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 - a**7*c**9 +
        a**6*b*c**9 + 2*a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        2*a**3*b**4*c**9 + 2*a**2*b**5*c**9 + a*b**6*c**9 - b**7*c**9
        - a**5*b*c**10 + a**4*b**2*c**10 + a**2*b**4*c**10 -
        a*b**5*c**10 + a**4*b*c**11 - a**3*b**2*c**11 -
        a**2*b**3*c**11 + a*b**4*c**11), (-a**5*b**7*c**5)/(a**8*b**8
        - a**7*b**9 + a**9*b**6*c - a**8*b**7*c - a**7*b**8*c +
        a**6*b**9*c - a**5*b**10*c + a**4*b**11*c + a**10*b**4*c**2 -
        a**9*b**5*c**2 - 2*a**8*b**6*c**2 + a**7*b**7*c**2 -
        a**6*b**8*c**2 + 2*a**5*b**9*c**2 + a**4*b**10*c**2 -
        a**3*b**11*c**2 - 2*a**9*b**4*c**3 + a**8*b**5*c**3 +
        3*a**6*b**7*c**3 + a**5*b**8*c**3 - 2*a**4*b**9*c**3 -
        a**2*b**11*c**3 - a**10*b**2*c**4 + a**8*b**4*c**4 +
        2*a**7*b**5*c**4 + a**6*b**6*c**4 - 3*a**5*b**7*c**4 -
        2*a**3*b**9*c**4 + a**2*b**10*c**4 + a*b**11*c**4 +
        a**9*b**2*c**5 + a**8*b**3*c**5 + a**7*b**4*c**5 -
        2*a**6*b**5*c**5 - 3*a**4*b**7*c**5 + a**3*b**8*c**5 +
        2*a**2*b**9*c**5 - a*b**10*c**5 + a**8*b**2*c**6 -
        a**7*b**3*c**6 - 2*a**6*b**4*c**6 - 2*a**5*b**5*c**6 +
        a**4*b**6*c**6 + 3*a**3*b**7*c**6 - a**2*b**8*c**6 +
        a*b**9*c**6 + a**9*c**7 - 2*a**7*b**2*c**7 - a**6*b**3*c**7 +
        a**5*b**4*c**7 + 2*a**4*b**5*c**7 + a**2*b**7*c**7 -
        a*b**8*c**7 - b**9*c**7 - 2*a**8*c**8 + a**6*b**2*c**8 +
        a**5*b**3*c**8 + a**4*b**4*c**8 + a**3*b**5*c**8 -
        2*a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 + a**7*c**9 +
        a**5*b**2*c**9 - 2*a**3*b**4*c**9 - a**2*b**5*c**9 +
        a*b**6*c**9 - a**4*b**2*c**10 + a**2*b**4*c**10), ((-1/3*zeta3
        + 1/3)*a**5*b**5*c**5)/(a**8*b**6 - a**7*b**7 + a**6*b**8 +
        (zeta3 + 1)*a**9*b**4*c + (-zeta3 - 1)*a**8*b**5*c + (zeta3 +
        1)*a**7*b**6*c + (zeta3 + 1)*a**6*b**7*c + (-zeta3 -
        1)*a**5*b**8*c + (zeta3 + 1)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (-zeta3 + 1)*a**8*b**3*c**3
        + zeta3*a**7*b**4*c**3 + (-zeta3 + 1)*a**6*b**5*c**3 + (-zeta3
        + 1)*a**5*b**6*c**3 + zeta3*a**4*b**7*c**3 + (-zeta3 +
        1)*a**3*b**8*c**3 + (zeta3 + 1)*a**9*b*c**4 +
        zeta3*a**7*b**3*c**4 + (3*zeta3 + 3)*a**6*b**4*c**4 + (-zeta3
        - 2)*a**5*b**5*c**4 + (3*zeta3 + 3)*a**4*b**6*c**4 +
        zeta3*a**3*b**7*c**4 + (zeta3 + 1)*a*b**9*c**4 + (-zeta3 -
        1)*a**8*b*c**5 - a**7*b**2*c**5 + (-zeta3 + 1)*a**6*b**3*c**5
        + (-zeta3 - 2)*a**5*b**4*c**5 + (-zeta3 - 2)*a**4*b**5*c**5 +
        (-zeta3 + 1)*a**3*b**6*c**5 - a**2*b**7*c**5 + (-zeta3 -
        1)*a*b**8*c**5 + a**8*c**6 + (zeta3 + 1)*a**7*b*c**6 +
        a**6*b**2*c**6 + (-zeta3 + 1)*a**5*b**3*c**6 + (3*zeta3 +
        3)*a**4*b**4*c**6 + (-zeta3 + 1)*a**3*b**5*c**6 +
        a**2*b**6*c**6 + (zeta3 + 1)*a*b**7*c**6 + b**8*c**6 -
        a**7*c**7 + (zeta3 + 1)*a**6*b*c**7 - a**5*b**2*c**7 +
        zeta3*a**4*b**3*c**7 + zeta3*a**3*b**4*c**7 - a**2*b**5*c**7 +
        (zeta3 + 1)*a*b**6*c**7 - b**7*c**7 + a**6*c**8 + (-zeta3 -
        1)*a**5*b*c**8 + (-zeta3 + 1)*a**3*b**3*c**8 + (-zeta3 -
        1)*a*b**5*c**8 + b**6*c**8 + (zeta3 + 1)*a**4*b*c**9 + (zeta3
        + 1)*a*b**4*c**9), ((1/3*zeta3 +
        2/3)*a**5*b**5*c**5)/(a**8*b**6 - a**7*b**7 + a**6*b**8 +
        (-zeta3)*a**9*b**4*c + zeta3*a**8*b**5*c +
        (-zeta3)*a**7*b**6*c + (-zeta3)*a**6*b**7*c +
        zeta3*a**5*b**8*c + (-zeta3)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (zeta3 + 2)*a**8*b**3*c**3 +
        (-zeta3 - 1)*a**7*b**4*c**3 + (zeta3 + 2)*a**6*b**5*c**3 +
        (zeta3 + 2)*a**5*b**6*c**3 + (-zeta3 - 1)*a**4*b**7*c**3 +
        (zeta3 + 2)*a**3*b**8*c**3 + (-zeta3)*a**9*b*c**4 + (-zeta3 -
        1)*a**7*b**3*c**4 + (-3*zeta3)*a**6*b**4*c**4 + (zeta3 -
        1)*a**5*b**5*c**4 + (-3*zeta3)*a**4*b**6*c**4 + (-zeta3 -
        1)*a**3*b**7*c**4 + (-zeta3)*a*b**9*c**4 + zeta3*a**8*b*c**5 -
        a**7*b**2*c**5 + (zeta3 + 2)*a**6*b**3*c**5 + (zeta3 -
        1)*a**5*b**4*c**5 + (zeta3 - 1)*a**4*b**5*c**5 + (zeta3 +
        2)*a**3*b**6*c**5 - a**2*b**7*c**5 + zeta3*a*b**8*c**5 +
        a**8*c**6 + (-zeta3)*a**7*b*c**6 + a**6*b**2*c**6 + (zeta3 +
        2)*a**5*b**3*c**6 + (-3*zeta3)*a**4*b**4*c**6 + (zeta3 +
        2)*a**3*b**5*c**6 + a**2*b**6*c**6 + (-zeta3)*a*b**7*c**6 +
        b**8*c**6 - a**7*c**7 + (-zeta3)*a**6*b*c**7 - a**5*b**2*c**7
        + (-zeta3 - 1)*a**4*b**3*c**7 + (-zeta3 - 1)*a**3*b**4*c**7 -
        a**2*b**5*c**7 + (-zeta3)*a*b**6*c**7 - b**7*c**7 + a**6*c**8
        + zeta3*a**5*b*c**8 + (zeta3 + 2)*a**3*b**3*c**8 +
        zeta3*a*b**5*c**8 + b**6*c**8 + (-zeta3)*a**4*b*c**9 +
        (-zeta3)*a*b**4*c**9)], 'K92': [a**9*b**9*c**9/(a**25*b -
        3*a**24*b**2 + 5*a**23*b**3 - 6*a**22*b**4 + 5*a**21*b**5 -
        3*a**20*b**6 + a**19*b**7 + a**25*c - 5*a**24*b*c +
        13*a**23*b**2*c - 23*a**22*b**3*c + 30*a**21*b**4*c -
        30*a**20*b**5*c + 23*a**19*b**6*c - 13*a**18*b**7*c +
        5*a**17*b**8*c - a**16*b**9*c - 3*a**24*c**2 + 13*a**23*b*c**2
        - 33*a**22*b**2*c**2 + 60*a**21*b**3*c**2 - 83*a**20*b**4*c**2
        + 91*a**19*b**5*c**2 - 79*a**18*b**6*c**2 + 54*a**17*b**7*c**2
        - 28*a**16*b**8*c**2 + 10*a**15*b**9*c**2 - 2*a**14*b**10*c**2
        + 5*a**23*c**3 - 23*a**22*b*c**3 + 60*a**21*b**2*c**3 -
        113*a**20*b**3*c**3 + 164*a**19*b**4*c**3 -
        191*a**18*b**5*c**3 + 180*a**17*b**6*c**3 -
        137*a**16*b**7*c**3 + 83*a**15*b**8*c**3 - 38*a**14*b**9*c**3
        + 12*a**13*b**10*c**3 - 2*a**12*b**11*c**3 - 6*a**22*c**4 +
        30*a**21*b*c**4 - 83*a**20*b**2*c**4 + 164*a**19*b**3*c**4 -
        250*a**18*b**4*c**4 + 307*a**17*b**5*c**4 -
        308*a**16*b**6*c**4 + 253*a**15*b**7*c**4 -
        169*a**14*b**8*c**4 + 89*a**13*b**9*c**4 - 35*a**12*b**10*c**4
        + 9*a**11*b**11*c**4 - a**10*b**12*c**4 + 5*a**21*c**5 -
        30*a**20*b*c**5 + 91*a**19*b**2*c**5 - 191*a**18*b**3*c**5 +
        307*a**17*b**4*c**5 - 395*a**16*b**5*c**5 +
        417*a**15*b**6*c**5 - 363*a**14*b**7*c**5 +
        260*a**13*b**8*c**5 - 151*a**12*b**9*c**5 +
        68*a**11*b**10*c**5 - 22*a**10*b**11*c**5 + 4*a**9*b**12*c**5
        - 3*a**20*c**6 + 23*a**19*b*c**6 - 79*a**18*b**2*c**6 +
        180*a**17*b**3*c**6 - 308*a**16*b**4*c**6 +
        417*a**15*b**5*c**6 - 461*a**14*b**6*c**6 +
        420*a**13*b**7*c**6 - 316*a**12*b**8*c**6 +
        195*a**11*b**9*c**6 - 96*a**10*b**10*c**6 + 36*a**9*b**11*c**6
        - 9*a**8*b**12*c**6 + a**7*b**13*c**6 + a**19*c**7 -
        13*a**18*b*c**7 + 54*a**17*b**2*c**7 - 137*a**16*b**3*c**7 +
        253*a**15*b**4*c**7 - 363*a**14*b**5*c**7 +
        420*a**13*b**6*c**7 - 398*a**12*b**7*c**7 +
        310*a**11*b**8*c**7 - 198*a**10*b**9*c**7 +
        102*a**9*b**10*c**7 - 41*a**8*b**11*c**7 + 12*a**7*b**12*c**7
        - 2*a**6*b**13*c**7 + 5*a**17*b*c**8 - 28*a**16*b**2*c**8 +
        83*a**15*b**3*c**8 - 169*a**14*b**4*c**8 + 260*a**13*b**5*c**8
        - 316*a**12*b**6*c**8 + 310*a**11*b**7*c**8 -
        247*a**10*b**8*c**8 + 159*a**9*b**9*c**8 - 82*a**8*b**10*c**8
        + 33*a**7*b**11*c**8 - 10*a**6*b**12*c**8 + 2*a**5*b**13*c**8
        - a**16*b*c**9 + 10*a**15*b**2*c**9 - 38*a**14*b**3*c**9 +
        89*a**13*b**4*c**9 - 151*a**12*b**5*c**9 + 195*a**11*b**6*c**9
        - 198*a**10*b**7*c**9 + 159*a**9*b**8*c**9 - 99*a**8*b**9*c**9
        + 47*a**7*b**10*c**9 - 16*a**6*b**11*c**9 + 4*a**5*b**12*c**9
        - a**4*b**13*c**9 - 2*a**14*b**2*c**10 + 12*a**13*b**3*c**10 -
        35*a**12*b**4*c**10 + 68*a**11*b**5*c**10 -
        96*a**10*b**6*c**10 + 102*a**9*b**7*c**10 - 82*a**8*b**8*c**10
        + 47*a**7*b**9*c**10 - 16*a**6*b**10*c**10 +
        3*a**4*b**12*c**10 - a**3*b**13*c**10 - 2*a**12*b**3*c**11 +
        9*a**11*b**4*c**11 - 22*a**10*b**5*c**11 + 36*a**9*b**6*c**11
        - 41*a**8*b**7*c**11 + 33*a**7*b**8*c**11 - 16*a**6*b**9*c**11
        + 7*a**4*b**11*c**11 - 6*a**3*b**12*c**11 + 2*a**2*b**13*c**11
        - a**10*b**4*c**12 + 4*a**9*b**5*c**12 - 9*a**8*b**6*c**12 +
        12*a**7*b**7*c**12 - 10*a**6*b**8*c**12 + 4*a**5*b**9*c**12 +
        3*a**4*b**10*c**12 - 6*a**3*b**11*c**12 + 5*a**2*b**12*c**12 -
        2*a*b**13*c**12 + a**7*b**6*c**13 - 2*a**6*b**7*c**13 +
        2*a**5*b**8*c**13 - a**4*b**9*c**13 - a**3*b**10*c**13 +
        2*a**2*b**11*c**13 - 2*a*b**12*c**13 + b**13*c**13),
        a**9*b**9*c**9/(a**13*b**13 - 2*a**13*b**12*c -
        2*a**12*b**13*c + 2*a**13*b**11*c**2 + 5*a**12*b**12*c**2 +
        2*a**11*b**13*c**2 - a**13*b**10*c**3 - 6*a**12*b**11*c**3 -
        6*a**11*b**12*c**3 - a**10*b**13*c**3 - a**13*b**9*c**4 +
        3*a**12*b**10*c**4 + 7*a**11*b**11*c**4 + 3*a**10*b**12*c**4 -
        a**9*b**13*c**4 + 2*a**13*b**8*c**5 + 4*a**12*b**9*c**5 +
        4*a**9*b**12*c**5 + 2*a**8*b**13*c**5 - 2*a**13*b**7*c**6 -
        10*a**12*b**8*c**6 - 16*a**11*b**9*c**6 - 16*a**10*b**10*c**6
        - 16*a**9*b**11*c**6 - 10*a**8*b**12*c**6 - 2*a**7*b**13*c**6
        + a**13*b**6*c**7 + 12*a**12*b**7*c**7 + 33*a**11*b**8*c**7 +
        47*a**10*b**9*c**7 + 47*a**9*b**10*c**7 + 33*a**8*b**11*c**7 +
        12*a**7*b**12*c**7 + a**6*b**13*c**7 - 9*a**12*b**6*c**8 -
        41*a**11*b**7*c**8 - 82*a**10*b**8*c**8 - 99*a**9*b**9*c**8 -
        82*a**8*b**10*c**8 - 41*a**7*b**11*c**8 - 9*a**6*b**12*c**8 +
        4*a**12*b**5*c**9 + 36*a**11*b**6*c**9 + 102*a**10*b**7*c**9 +
        159*a**9*b**8*c**9 + 159*a**8*b**9*c**9 + 102*a**7*b**10*c**9
        + 36*a**6*b**11*c**9 + 4*a**5*b**12*c**9 - a**12*b**4*c**10 -
        22*a**11*b**5*c**10 - 96*a**10*b**6*c**10 -
        198*a**9*b**7*c**10 - 247*a**8*b**8*c**10 -
        198*a**7*b**9*c**10 - 96*a**6*b**10*c**10 -
        22*a**5*b**11*c**10 - a**4*b**12*c**10 + 9*a**11*b**4*c**11 +
        68*a**10*b**5*c**11 + 195*a**9*b**6*c**11 +
        310*a**8*b**7*c**11 + 310*a**7*b**8*c**11 +
        195*a**6*b**9*c**11 + 68*a**5*b**10*c**11 + 9*a**4*b**11*c**11
        - 2*a**11*b**3*c**12 - 35*a**10*b**4*c**12 -
        151*a**9*b**5*c**12 - 316*a**8*b**6*c**12 -
        398*a**7*b**7*c**12 - 316*a**6*b**8*c**12 -
        151*a**5*b**9*c**12 - 35*a**4*b**10*c**12 - 2*a**3*b**11*c**12
        + 12*a**10*b**3*c**13 + 89*a**9*b**4*c**13 +
        260*a**8*b**5*c**13 + 420*a**7*b**6*c**13 +
        420*a**6*b**7*c**13 + 260*a**5*b**8*c**13 + 89*a**4*b**9*c**13
        + 12*a**3*b**10*c**13 - 2*a**10*b**2*c**14 -
        38*a**9*b**3*c**14 - 169*a**8*b**4*c**14 - 363*a**7*b**5*c**14
        - 461*a**6*b**6*c**14 - 363*a**5*b**7*c**14 -
        169*a**4*b**8*c**14 - 38*a**3*b**9*c**14 - 2*a**2*b**10*c**14
        + 10*a**9*b**2*c**15 + 83*a**8*b**3*c**15 +
        253*a**7*b**4*c**15 + 417*a**6*b**5*c**15 +
        417*a**5*b**6*c**15 + 253*a**4*b**7*c**15 + 83*a**3*b**8*c**15
        + 10*a**2*b**9*c**15 - a**9*b*c**16 - 28*a**8*b**2*c**16 -
        137*a**7*b**3*c**16 - 308*a**6*b**4*c**16 -
        395*a**5*b**5*c**16 - 308*a**4*b**6*c**16 -
        137*a**3*b**7*c**16 - 28*a**2*b**8*c**16 - a*b**9*c**16 +
        5*a**8*b*c**17 + 54*a**7*b**2*c**17 + 180*a**6*b**3*c**17 +
        307*a**5*b**4*c**17 + 307*a**4*b**5*c**17 +
        180*a**3*b**6*c**17 + 54*a**2*b**7*c**17 + 5*a*b**8*c**17 -
        13*a**7*b*c**18 - 79*a**6*b**2*c**18 - 191*a**5*b**3*c**18 -
        250*a**4*b**4*c**18 - 191*a**3*b**5*c**18 - 79*a**2*b**6*c**18
        - 13*a*b**7*c**18 + a**7*c**19 + 23*a**6*b*c**19 +
        91*a**5*b**2*c**19 + 164*a**4*b**3*c**19 + 164*a**3*b**4*c**19
        + 91*a**2*b**5*c**19 + 23*a*b**6*c**19 + b**7*c**19 -
        3*a**6*c**20 - 30*a**5*b*c**20 - 83*a**4*b**2*c**20 -
        113*a**3*b**3*c**20 - 83*a**2*b**4*c**20 - 30*a*b**5*c**20 -
        3*b**6*c**20 + 5*a**5*c**21 + 30*a**4*b*c**21 +
        60*a**3*b**2*c**21 + 60*a**2*b**3*c**21 + 30*a*b**4*c**21 +
        5*b**5*c**21 - 6*a**4*c**22 - 23*a**3*b*c**22 -
        33*a**2*b**2*c**22 - 23*a*b**3*c**22 - 6*b**4*c**22 +
        5*a**3*c**23 + 13*a**2*b*c**23 + 13*a*b**2*c**23 +
        5*b**3*c**23 - 3*a**2*c**24 - 5*a*b*c**24 - 3*b**2*c**24 +
        a*c**25 + b*c**25), a**9*b**9*c**9/(a**7*b**19 - 3*a**6*b**20
        + 5*a**5*b**21 - 6*a**4*b**22 + 5*a**3*b**23 - 3*a**2*b**24 +
        a*b**25 - a**9*b**16*c + 5*a**8*b**17*c - 13*a**7*b**18*c +
        23*a**6*b**19*c - 30*a**5*b**20*c + 30*a**4*b**21*c -
        23*a**3*b**22*c + 13*a**2*b**23*c - 5*a*b**24*c + b**25*c -
        2*a**10*b**14*c**2 + 10*a**9*b**15*c**2 - 28*a**8*b**16*c**2 +
        54*a**7*b**17*c**2 - 79*a**6*b**18*c**2 + 91*a**5*b**19*c**2 -
        83*a**4*b**20*c**2 + 60*a**3*b**21*c**2 - 33*a**2*b**22*c**2 +
        13*a*b**23*c**2 - 3*b**24*c**2 - 2*a**11*b**12*c**3 +
        12*a**10*b**13*c**3 - 38*a**9*b**14*c**3 + 83*a**8*b**15*c**3
        - 137*a**7*b**16*c**3 + 180*a**6*b**17*c**3 -
        191*a**5*b**18*c**3 + 164*a**4*b**19*c**3 -
        113*a**3*b**20*c**3 + 60*a**2*b**21*c**3 - 23*a*b**22*c**3 +
        5*b**23*c**3 - a**12*b**10*c**4 + 9*a**11*b**11*c**4 -
        35*a**10*b**12*c**4 + 89*a**9*b**13*c**4 - 169*a**8*b**14*c**4
        + 253*a**7*b**15*c**4 - 308*a**6*b**16*c**4 +
        307*a**5*b**17*c**4 - 250*a**4*b**18*c**4 +
        164*a**3*b**19*c**4 - 83*a**2*b**20*c**4 + 30*a*b**21*c**4 -
        6*b**22*c**4 + 4*a**12*b**9*c**5 - 22*a**11*b**10*c**5 +
        68*a**10*b**11*c**5 - 151*a**9*b**12*c**5 +
        260*a**8*b**13*c**5 - 363*a**7*b**14*c**5 +
        417*a**6*b**15*c**5 - 395*a**5*b**16*c**5 +
        307*a**4*b**17*c**5 - 191*a**3*b**18*c**5 + 91*a**2*b**19*c**5
        - 30*a*b**20*c**5 + 5*b**21*c**5 + a**13*b**7*c**6 -
        9*a**12*b**8*c**6 + 36*a**11*b**9*c**6 - 96*a**10*b**10*c**6 +
        195*a**9*b**11*c**6 - 316*a**8*b**12*c**6 +
        420*a**7*b**13*c**6 - 461*a**6*b**14*c**6 +
        417*a**5*b**15*c**6 - 308*a**4*b**16*c**6 +
        180*a**3*b**17*c**6 - 79*a**2*b**18*c**6 + 23*a*b**19*c**6 -
        3*b**20*c**6 - 2*a**13*b**6*c**7 + 12*a**12*b**7*c**7 -
        41*a**11*b**8*c**7 + 102*a**10*b**9*c**7 - 198*a**9*b**10*c**7
        + 310*a**8*b**11*c**7 - 398*a**7*b**12*c**7 +
        420*a**6*b**13*c**7 - 363*a**5*b**14*c**7 +
        253*a**4*b**15*c**7 - 137*a**3*b**16*c**7 + 54*a**2*b**17*c**7
        - 13*a*b**18*c**7 + b**19*c**7 + 2*a**13*b**5*c**8 -
        10*a**12*b**6*c**8 + 33*a**11*b**7*c**8 - 82*a**10*b**8*c**8 +
        159*a**9*b**9*c**8 - 247*a**8*b**10*c**8 + 310*a**7*b**11*c**8
        - 316*a**6*b**12*c**8 + 260*a**5*b**13*c**8 -
        169*a**4*b**14*c**8 + 83*a**3*b**15*c**8 - 28*a**2*b**16*c**8
        + 5*a*b**17*c**8 - a**13*b**4*c**9 + 4*a**12*b**5*c**9 -
        16*a**11*b**6*c**9 + 47*a**10*b**7*c**9 - 99*a**9*b**8*c**9 +
        159*a**8*b**9*c**9 - 198*a**7*b**10*c**9 + 195*a**6*b**11*c**9
        - 151*a**5*b**12*c**9 + 89*a**4*b**13*c**9 -
        38*a**3*b**14*c**9 + 10*a**2*b**15*c**9 - a*b**16*c**9 -
        a**13*b**3*c**10 + 3*a**12*b**4*c**10 - 16*a**10*b**6*c**10 +
        47*a**9*b**7*c**10 - 82*a**8*b**8*c**10 + 102*a**7*b**9*c**10
        - 96*a**6*b**10*c**10 + 68*a**5*b**11*c**10 -
        35*a**4*b**12*c**10 + 12*a**3*b**13*c**10 - 2*a**2*b**14*c**10
        + 2*a**13*b**2*c**11 - 6*a**12*b**3*c**11 + 7*a**11*b**4*c**11
        - 16*a**9*b**6*c**11 + 33*a**8*b**7*c**11 - 41*a**7*b**8*c**11
        + 36*a**6*b**9*c**11 - 22*a**5*b**10*c**11 +
        9*a**4*b**11*c**11 - 2*a**3*b**12*c**11 - 2*a**13*b*c**12 +
        5*a**12*b**2*c**12 - 6*a**11*b**3*c**12 + 3*a**10*b**4*c**12 +
        4*a**9*b**5*c**12 - 10*a**8*b**6*c**12 + 12*a**7*b**7*c**12 -
        9*a**6*b**8*c**12 + 4*a**5*b**9*c**12 - a**4*b**10*c**12 +
        a**13*c**13 - 2*a**12*b*c**13 + 2*a**11*b**2*c**13 -
        a**10*b**3*c**13 - a**9*b**4*c**13 + 2*a**8*b**5*c**13 -
        2*a**7*b**6*c**13 + a**6*b**7*c**13),
        a**9*b**5*c**5/(a**13*b**5 - a**12*b**6 - a**11*b**7 +
        a**10*b**8 - 2*a**13*b**4*c + 2*a**12*b**5*c + 4*a**11*b**6*c
        - 4*a**10*b**7*c - 2*a**9*b**8*c + 2*a**8*b**9*c +
        a**13*b**3*c**2 - 2*a**12*b**4*c**2 - 6*a**11*b**5*c**2 +
        8*a**10*b**6*c**2 + 7*a**9*b**7*c**2 - 8*a**8*b**8*c**2 -
        2*a**7*b**9*c**2 + 2*a**6*b**10*c**2 + a**13*b**2*c**3 +
        2*a**12*b**3*c**3 + 3*a**11*b**4*c**3 - 11*a**10*b**5*c**3 -
        10*a**9*b**6*c**3 + 17*a**8*b**7*c**3 + 7*a**7*b**8*c**3 -
        9*a**6*b**9*c**3 - a**5*b**10*c**3 + a**4*b**11*c**3 -
        2*a**13*b*c**4 - 2*a**12*b**2*c**4 + 3*a**11*b**3*c**4 +
        12*a**10*b**4*c**4 + 5*a**9*b**5*c**4 - 25*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 + 21*a**6*b**8*c**4 + 4*a**5*b**9*c**4 -
        6*a**4*b**10*c**4 + a**13*c**5 + 2*a**12*b*c**5 -
        6*a**11*b**2*c**5 - 11*a**10*b**3*c**5 + 5*a**9*b**4*c**5 +
        28*a**8*b**5*c**5 + 5*a**7*b**6*c**5 - 33*a**6*b**7*c**5 -
        6*a**5*b**8*c**5 + 16*a**4*b**9*c**5 + a**3*b**10*c**5 -
        2*a**2*b**11*c**5 - a**12*c**6 + 4*a**11*b*c**6 +
        8*a**10*b**2*c**6 - 10*a**9*b**3*c**6 - 25*a**8*b**4*c**6 +
        5*a**7*b**5*c**6 + 38*a**6*b**6*c**6 + 3*a**5*b**7*c**6 -
        27*a**4*b**8*c**6 - 2*a**3*b**9*c**6 + 7*a**2*b**10*c**6 -
        a**11*c**7 - 4*a**10*b*c**7 + 7*a**9*b**2*c**7 +
        17*a**8*b**3*c**7 - 10*a**7*b**4*c**7 - 33*a**6*b**5*c**7 +
        3*a**5*b**6*c**7 + 32*a**4*b**7*c**7 + a**3*b**8*c**7 -
        13*a**2*b**9*c**7 + b**11*c**7 + a**10*c**8 - 2*a**9*b*c**8 -
        8*a**8*b**2*c**8 + 7*a**7*b**3*c**8 + 21*a**6*b**4*c**8 -
        6*a**5*b**5*c**8 - 27*a**4*b**6*c**8 + a**3*b**7*c**8 +
        16*a**2*b**8*c**8 - 3*b**10*c**8 + 2*a**8*b*c**9 -
        2*a**7*b**2*c**9 - 9*a**6*b**3*c**9 + 4*a**5*b**4*c**9 +
        16*a**4*b**5*c**9 - 2*a**3*b**6*c**9 - 13*a**2*b**7*c**9 +
        4*b**9*c**9 + 2*a**6*b**2*c**10 - a**5*b**3*c**10 -
        6*a**4*b**4*c**10 + a**3*b**5*c**10 + 7*a**2*b**6*c**10 -
        3*b**8*c**10 + a**4*b**3*c**11 - 2*a**2*b**5*c**11 +
        b**7*c**11), a**5*b**5*c**9/(a**11*b**7 - 3*a**10*b**8 +
        4*a**9*b**9 - 3*a**8*b**10 + a**7*b**11 - 2*a**11*b**5*c**2 +
        7*a**10*b**6*c**2 - 13*a**9*b**7*c**2 + 16*a**8*b**8*c**2 -
        13*a**7*b**9*c**2 + 7*a**6*b**10*c**2 - 2*a**5*b**11*c**2 +
        a**10*b**5*c**3 - 2*a**9*b**6*c**3 + a**8*b**7*c**3 +
        a**7*b**8*c**3 - 2*a**6*b**9*c**3 + a**5*b**10*c**3 +
        a**11*b**3*c**4 - 6*a**10*b**4*c**4 + 16*a**9*b**5*c**4 -
        27*a**8*b**6*c**4 + 32*a**7*b**7*c**4 - 27*a**6*b**8*c**4 +
        16*a**5*b**9*c**4 - 6*a**4*b**10*c**4 + a**3*b**11*c**4 -
        a**10*b**3*c**5 + 4*a**9*b**4*c**5 - 6*a**8*b**5*c**5 +
        3*a**7*b**6*c**5 + 3*a**6*b**7*c**5 - 6*a**5*b**8*c**5 +
        4*a**4*b**9*c**5 - a**3*b**10*c**5 + 2*a**10*b**2*c**6 -
        9*a**9*b**3*c**6 + 21*a**8*b**4*c**6 - 33*a**7*b**5*c**6 +
        38*a**6*b**6*c**6 - 33*a**5*b**7*c**6 + 21*a**4*b**8*c**6 -
        9*a**3*b**9*c**6 + 2*a**2*b**10*c**6 - 2*a**9*b**2*c**7 +
        7*a**8*b**3*c**7 - 10*a**7*b**4*c**7 + 5*a**6*b**5*c**7 +
        5*a**5*b**6*c**7 - 10*a**4*b**7*c**7 + 7*a**3*b**8*c**7 -
        2*a**2*b**9*c**7 + 2*a**9*b*c**8 - 8*a**8*b**2*c**8 +
        17*a**7*b**3*c**8 - 25*a**6*b**4*c**8 + 28*a**5*b**5*c**8 -
        25*a**4*b**6*c**8 + 17*a**3*b**7*c**8 - 8*a**2*b**8*c**8 +
        2*a*b**9*c**8 - 2*a**8*b*c**9 + 7*a**7*b**2*c**9 -
        10*a**6*b**3*c**9 + 5*a**5*b**4*c**9 + 5*a**4*b**5*c**9 -
        10*a**3*b**6*c**9 + 7*a**2*b**7*c**9 - 2*a*b**8*c**9 +
        a**8*c**10 - 4*a**7*b*c**10 + 8*a**6*b**2*c**10 -
        11*a**5*b**3*c**10 + 12*a**4*b**4*c**10 - 11*a**3*b**5*c**10 +
        8*a**2*b**6*c**10 - 4*a*b**7*c**10 + b**8*c**10 - a**7*c**11 +
        4*a**6*b*c**11 - 6*a**5*b**2*c**11 + 3*a**4*b**3*c**11 +
        3*a**3*b**4*c**11 - 6*a**2*b**5*c**11 + 4*a*b**6*c**11 -
        b**7*c**11 - a**6*c**12 + 2*a**5*b*c**12 - 2*a**4*b**2*c**12 +
        2*a**3*b**3*c**12 - 2*a**2*b**4*c**12 + 2*a*b**5*c**12 -
        b**6*c**12 + a**5*c**13 - 2*a**4*b*c**13 + a**3*b**2*c**13 +
        a**2*b**3*c**13 - 2*a*b**4*c**13 + b**5*c**13),
        a**5*b**9*c**5/(a**8*b**10 - a**7*b**11 - a**6*b**12 +
        a**5*b**13 + 2*a**9*b**8*c - 2*a**8*b**9*c - 4*a**7*b**10*c +
        4*a**6*b**11*c + 2*a**5*b**12*c - 2*a**4*b**13*c +
        2*a**10*b**6*c**2 - 2*a**9*b**7*c**2 - 8*a**8*b**8*c**2 +
        7*a**7*b**9*c**2 + 8*a**6*b**10*c**2 - 6*a**5*b**11*c**2 -
        2*a**4*b**12*c**2 + a**3*b**13*c**2 + a**11*b**4*c**3 -
        a**10*b**5*c**3 - 9*a**9*b**6*c**3 + 7*a**8*b**7*c**3 +
        17*a**7*b**8*c**3 - 10*a**6*b**9*c**3 - 11*a**5*b**10*c**3 +
        3*a**4*b**11*c**3 + 2*a**3*b**12*c**3 + a**2*b**13*c**3 -
        6*a**10*b**4*c**4 + 4*a**9*b**5*c**4 + 21*a**8*b**6*c**4 -
        10*a**7*b**7*c**4 - 25*a**6*b**8*c**4 + 5*a**5*b**9*c**4 +
        12*a**4*b**10*c**4 + 3*a**3*b**11*c**4 - 2*a**2*b**12*c**4 -
        2*a*b**13*c**4 - 2*a**11*b**2*c**5 + a**10*b**3*c**5 +
        16*a**9*b**4*c**5 - 6*a**8*b**5*c**5 - 33*a**7*b**6*c**5 +
        5*a**6*b**7*c**5 + 28*a**5*b**8*c**5 + 5*a**4*b**9*c**5 -
        11*a**3*b**10*c**5 - 6*a**2*b**11*c**5 + 2*a*b**12*c**5 +
        b**13*c**5 + 7*a**10*b**2*c**6 - 2*a**9*b**3*c**6 -
        27*a**8*b**4*c**6 + 3*a**7*b**5*c**6 + 38*a**6*b**6*c**6 +
        5*a**5*b**7*c**6 - 25*a**4*b**8*c**6 - 10*a**3*b**9*c**6 +
        8*a**2*b**10*c**6 + 4*a*b**11*c**6 - b**12*c**6 + a**11*c**7 -
        13*a**9*b**2*c**7 + a**8*b**3*c**7 + 32*a**7*b**4*c**7 +
        3*a**6*b**5*c**7 - 33*a**5*b**6*c**7 - 10*a**4*b**7*c**7 +
        17*a**3*b**8*c**7 + 7*a**2*b**9*c**7 - 4*a*b**10*c**7 -
        b**11*c**7 - 3*a**10*c**8 + 16*a**8*b**2*c**8 + a**7*b**3*c**8
        - 27*a**6*b**4*c**8 - 6*a**5*b**5*c**8 + 21*a**4*b**6*c**8 +
        7*a**3*b**7*c**8 - 8*a**2*b**8*c**8 - 2*a*b**9*c**8 +
        b**10*c**8 + 4*a**9*c**9 - 13*a**7*b**2*c**9 -
        2*a**6*b**3*c**9 + 16*a**5*b**4*c**9 + 4*a**4*b**5*c**9 -
        9*a**3*b**6*c**9 - 2*a**2*b**7*c**9 + 2*a*b**8*c**9 -
        3*a**8*c**10 + 7*a**6*b**2*c**10 + a**5*b**3*c**10 -
        6*a**4*b**4*c**10 - a**3*b**5*c**10 + 2*a**2*b**6*c**10 +
        a**7*c**11 - 2*a**5*b**2*c**11 + a**3*b**4*c**11),
        (-a**5*b**5*c**5)/(a**8*b**6 - 2*a**7*b**7 + a**6*b**8 +
        a**9*b**4*c - 3*a**8*b**5*c + 2*a**7*b**6*c + 2*a**6*b**7*c -
        3*a**5*b**8*c + a**4*b**9*c - a**9*b**3*c**2 +
        5*a**7*b**5*c**2 - 8*a**6*b**6*c**2 + 5*a**5*b**7*c**2 -
        a**3*b**9*c**2 - a**9*b**2*c**3 + 4*a**8*b**3*c**3 -
        5*a**7*b**4*c**3 + 2*a**6*b**5*c**3 + 2*a**5*b**6*c**3 -
        5*a**4*b**7*c**3 + 4*a**3*b**8*c**3 - a**2*b**9*c**3 +
        a**9*b*c**4 - 5*a**7*b**3*c**4 + 6*a**6*b**4*c**4 -
        4*a**5*b**5*c**4 + 6*a**4*b**6*c**4 - 5*a**3*b**7*c**4 +
        a*b**9*c**4 - 3*a**8*b*c**5 + 5*a**7*b**2*c**5 +
        2*a**6*b**3*c**5 - 4*a**5*b**4*c**5 - 4*a**4*b**5*c**5 +
        2*a**3*b**6*c**5 + 5*a**2*b**7*c**5 - 3*a*b**8*c**5 +
        a**8*c**6 + 2*a**7*b*c**6 - 8*a**6*b**2*c**6 +
        2*a**5*b**3*c**6 + 6*a**4*b**4*c**6 + 2*a**3*b**5*c**6 -
        8*a**2*b**6*c**6 + 2*a*b**7*c**6 + b**8*c**6 - 2*a**7*c**7 +
        2*a**6*b*c**7 + 5*a**5*b**2*c**7 - 5*a**4*b**3*c**7 -
        5*a**3*b**4*c**7 + 5*a**2*b**5*c**7 + 2*a*b**6*c**7 -
        2*b**7*c**7 + a**6*c**8 - 3*a**5*b*c**8 + 4*a**3*b**3*c**8 -
        3*a*b**5*c**8 + b**6*c**8 + a**4*b*c**9 - a**3*b**2*c**9 -
        a**2*b**3*c**9 + a*b**4*c**9), (-a**5*b**6*c**9)/(a**8*b**11 -
        2*a**7*b**12 + 2*a**6*b**13 - 2*a**5*b**14 + a**4*b**15 +
        a**9*b**9*c - 3*a**8*b**10*c + 4*a**7*b**11*c - 4*a**6*b**12*c
        + 3*a**5*b**13*c - a**4*b**14*c - a**9*b**8*c**2 +
        a**8*b**9*c**2 - a**6*b**11*c**2 + 3*a**5*b**12*c**2 -
        3*a**4*b**13*c**2 + 2*a**3*b**14*c**2 - a**2*b**15*c**2 -
        a**9*b**7*c**3 + 4*a**8*b**8*c**3 - 7*a**7*b**9*c**3 +
        10*a**6*b**10*c**3 - 11*a**5*b**11*c**3 + 8*a**4*b**12*c**3 -
        5*a**3*b**13*c**3 + 2*a**2*b**14*c**3 + 2*a**9*b**6*c**4 -
        5*a**8*b**7*c**4 + 7*a**7*b**8*c**4 - 10*a**6*b**9*c**4 +
        9*a**5*b**10*c**4 - 5*a**4*b**11*c**4 + 3*a**3*b**12*c**4 -
        a*b**14*c**4 - a**9*b**5*c**5 + 2*a**7*b**7*c**5 -
        2*a**6*b**8*c**5 + 6*a**5*b**9*c**5 - 8*a**4*b**10*c**5 +
        6*a**3*b**11*c**5 - 6*a**2*b**12*c**5 + 3*a*b**13*c**5 -
        a**9*b**4*c**6 + 5*a**8*b**5*c**6 - 8*a**7*b**6*c**6 +
        11*a**6*b**7*c**6 - 16*a**5*b**8*c**6 + 15*a**4*b**9*c**6 -
        12*a**3*b**10*c**6 + 9*a**2*b**11*c**6 - 3*a*b**12*c**6 +
        a**9*b**3*c**7 - 3*a**8*b**4*c**7 + 3*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 8*a**5*b**7*c**7 - 6*a**4*b**8*c**7 +
        5*a**3*b**9*c**7 - 3*a**2*b**10*c**7 - a*b**11*c**7 +
        b**12*c**7 - a**8*b**3*c**8 + 4*a**7*b**4*c**8 -
        4*a**6*b**5*c**8 + 4*a**5*b**6*c**8 - 7*a**4*b**7*c**8 +
        6*a**3*b**8*c**8 - 6*a**2*b**9*c**8 + 6*a*b**10*c**8 -
        2*b**11*c**8 + 2*a**8*b**2*c**9 - 4*a**7*b**3*c**9 +
        3*a**6*b**4*c**9 - 6*a**5*b**5*c**9 + 9*a**4*b**6*c**9 -
        8*a**3*b**7*c**9 + 9*a**2*b**8*c**9 - 6*a*b**9*c**9 +
        b**10*c**9 - a**8*b*c**10 + 2*a**6*b**3*c**10 +
        a**5*b**4*c**10 - 2*a**4*b**5*c**10 + 2*a**3*b**6*c**10 -
        4*a**2*b**7*c**10 + a*b**8*c**10 + b**9*c**10 + 2*a**7*b*c**11
        - 3*a**6*b**2*c**11 + a**5*b**3*c**11 - 2*a**4*b**4*c**11 +
        2*a**3*b**5*c**11 - a**2*b**6*c**11 + 3*a*b**7*c**11 -
        2*b**8*c**11 - a**7*c**12 + a**5*b**2*c**12 + a**4*b**3*c**12
        - a**3*b**4*c**12 + 2*a**2*b**5*c**12 - 3*a*b**6*c**12 +
        b**7*c**12 + a**6*c**13 - a**5*b*c**13 - a**2*b**4*c**13 +
        a*b**5*c**13), (-a**6*b**9*c**5)/(a**12*b**7 - 2*a**11*b**8 +
        a**10*b**9 + a**9*b**10 - 2*a**8*b**11 + a**7*b**12 -
        a**14*b**4*c + 3*a**13*b**5*c - 3*a**12*b**6*c - a**11*b**7*c
        + 6*a**10*b**8*c - 6*a**9*b**9*c + a**8*b**10*c +
        3*a**7*b**11*c - 3*a**6*b**12*c + a**5*b**13*c -
        a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 6*a**12*b**5*c**2 +
        9*a**11*b**6*c**2 - 3*a**10*b**7*c**2 - 6*a**9*b**8*c**2 +
        9*a**8*b**9*c**2 - 4*a**7*b**10*c**2 - a**6*b**11*c**2 +
        2*a**5*b**12*c**2 - a**4*b**13*c**2 + 2*a**14*b**2*c**3 -
        5*a**13*b**3*c**3 + 3*a**12*b**4*c**3 + 6*a**11*b**5*c**3 -
        12*a**10*b**6*c**3 + 5*a**9*b**7*c**3 + 6*a**8*b**8*c**3 -
        8*a**7*b**9*c**3 + 2*a**6*b**10*c**3 + 2*a**5*b**11*c**3 -
        a**4*b**12*c**3 + a**15*c**4 - a**14*b*c**4 -
        3*a**13*b**2*c**4 + 8*a**12*b**3*c**4 - 5*a**11*b**4*c**4 -
        8*a**10*b**5*c**4 + 15*a**9*b**6*c**4 - 6*a**8*b**7*c**4 -
        7*a**7*b**8*c**4 + 9*a**6*b**9*c**4 - 2*a**5*b**10*c**4 -
        2*a**4*b**11*c**4 + a**3*b**12*c**4 - 2*a**14*c**5 +
        3*a**13*b*c**5 + 3*a**12*b**2*c**5 - 11*a**11*b**3*c**5 +
        9*a**10*b**4*c**5 + 6*a**9*b**5*c**5 - 16*a**8*b**6*c**5 +
        8*a**7*b**7*c**5 + 4*a**6*b**8*c**5 - 6*a**5*b**9*c**5 +
        a**4*b**10*c**5 + a**3*b**11*c**5 + a**2*b**12*c**5 -
        a*b**13*c**5 + 2*a**13*c**6 - 4*a**12*b*c**6 - a**11*b**2*c**6
        + 10*a**10*b**3*c**6 - 10*a**9*b**4*c**6 - 2*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 +
        3*a**4*b**9*c**6 + 2*a**3*b**10*c**6 - 3*a**2*b**11*c**6 +
        b**13*c**6 - 2*a**12*c**7 + 4*a**11*b*c**7 - 7*a**9*b**3*c**7
        + 7*a**8*b**4*c**7 + 2*a**7*b**5*c**7 - 8*a**6*b**6*c**7 +
        3*a**5*b**7*c**7 + 4*a**4*b**8*c**7 - 4*a**3*b**9*c**7 +
        2*a*b**11*c**7 - b**12*c**7 + a**11*c**8 - 3*a**10*b*c**8 +
        a**9*b**2*c**8 + 4*a**8*b**3*c**8 - 5*a**7*b**4*c**8 +
        5*a**5*b**6*c**8 - 3*a**4*b**7*c**8 - a**3*b**8*c**8 +
        2*a**2*b**9*c**8 - a*b**10*c**8 + a**9*b*c**9 - a**8*b**2*c**9
        - a**7*b**3*c**9 + 2*a**6*b**4*c**9 - a**5*b**5*c**9 -
        a**4*b**6*c**9 + a**3*b**7*c**9),
        (-a**9*b**5*c**6)/(a**13*b**6 - a**12*b**7 - a**13*b**5*c +
        2*a**11*b**7*c - a**10*b**8*c + a**12*b**5*c**2 -
        3*a**11*b**6*c**2 + 2*a**9*b**8*c**2 + a**12*b**4*c**3 +
        a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 4*a**9*b**7*c**3 -
        a**8*b**8*c**3 + a**7*b**9*c**3 - a**13*b**2*c**4 -
        a**12*b**3*c**4 - 2*a**11*b**4*c**4 + a**10*b**5*c**4 +
        3*a**9*b**6*c**4 + 4*a**8*b**7*c**4 - 3*a**7*b**8*c**4 -
        a**6*b**9*c**4 + a**13*b*c**5 + 2*a**12*b**2*c**5 +
        2*a**11*b**3*c**5 - 2*a**10*b**4*c**5 - 6*a**9*b**5*c**5 -
        4*a**8*b**6*c**5 + 3*a**7*b**7*c**5 + 5*a**6*b**8*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 - a**11*b**2*c**6 +
        2*a**10*b**3*c**6 + 9*a**9*b**4*c**6 + 4*a**8*b**5*c**6 -
        5*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 2*a**4*b**9*c**6 +
        a**12*c**7 + 3*a**11*b*c**7 - 4*a**10*b**2*c**7 -
        8*a**9*b**3*c**7 - 7*a**8*b**4*c**7 + 8*a**7*b**5*c**7 +
        11*a**6*b**6*c**7 + 2*a**5*b**7*c**7 - 5*a**4*b**8*c**7 -
        a**3*b**9*c**7 - 2*a**11*c**8 + a**10*b*c**8 +
        9*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 6*a**7*b**4*c**8 -
        16*a**6*b**5*c**8 - 2*a**5*b**6*c**8 + 7*a**4*b**7*c**8 +
        4*a**3*b**8*c**8 - a**2*b**9*c**8 + a**10*c**9 - 6*a**9*b*c**9
        - 6*a**8*b**2*c**9 + 5*a**7*b**3*c**9 + 15*a**6*b**4*c**9 +
        6*a**5*b**5*c**9 - 10*a**4*b**6*c**9 - 7*a**3*b**7*c**9 +
        a**2*b**8*c**9 + a*b**9*c**9 + a**9*c**10 + 6*a**8*b*c**10 -
        3*a**7*b**2*c**10 - 12*a**6*b**3*c**10 - 8*a**5*b**4*c**10 +
        9*a**4*b**5*c**10 + 10*a**3*b**6*c**10 - 3*a*b**8*c**10 -
        2*a**8*c**11 - a**7*b*c**11 + 9*a**6*b**2*c**11 +
        6*a**5*b**3*c**11 - 5*a**4*b**4*c**11 - 11*a**3*b**5*c**11 -
        a**2*b**6*c**11 + 4*a*b**7*c**11 + b**8*c**11 + a**7*c**12 -
        3*a**6*b*c**12 - 6*a**5*b**2*c**12 + 3*a**4*b**3*c**12 +
        8*a**3*b**4*c**12 + 3*a**2*b**5*c**12 - 4*a*b**6*c**12 -
        2*b**7*c**12 + 3*a**5*b*c**13 - 5*a**3*b**3*c**13 -
        3*a**2*b**4*c**13 + 3*a*b**5*c**13 + 2*b**6*c**13 -
        a**4*b*c**14 + 2*a**3*b**2*c**14 + 2*a**2*b**3*c**14 -
        a*b**4*c**14 - 2*b**5*c**14 - a**2*b**2*c**15 + b**4*c**15),
        a**5*b**9*c**6/(a**7*b**12 - a**6*b**13 + a**8*b**10*c -
        2*a**7*b**11*c + a**5*b**13*c - 2*a**8*b**9*c**2 +
        3*a**6*b**11*c**2 - a**5*b**12*c**2 - a**9*b**7*c**3 +
        a**8*b**8*c**3 + 4*a**7*b**9*c**3 - 2*a**6*b**10*c**3 -
        a**5*b**11*c**3 - a**4*b**12*c**3 + a**9*b**6*c**4 +
        3*a**8*b**7*c**4 - 4*a**7*b**8*c**4 - 3*a**6*b**9*c**4 -
        a**5*b**10*c**4 + 2*a**4*b**11*c**4 + a**3*b**12*c**4 +
        a**2*b**13*c**4 + a**9*b**5*c**5 - 5*a**8*b**6*c**5 -
        3*a**7*b**7*c**5 + 4*a**6*b**8*c**5 + 6*a**5*b**9*c**5 +
        2*a**4*b**10*c**5 - 2*a**3*b**11*c**5 - 2*a**2*b**12*c**5 -
        a*b**13*c**5 - 2*a**9*b**4*c**6 + 8*a**7*b**6*c**6 +
        5*a**6*b**7*c**6 - 4*a**5*b**8*c**6 - 9*a**4*b**9*c**6 -
        2*a**3*b**10*c**6 + a**2*b**11*c**6 + 3*a*b**12*c**6 +
        a**9*b**3*c**7 + 5*a**8*b**4*c**7 - 2*a**7*b**5*c**7 -
        11*a**6*b**6*c**7 - 8*a**5*b**7*c**7 + 7*a**4*b**8*c**7 +
        8*a**3*b**9*c**7 + 4*a**2*b**10*c**7 - 3*a*b**11*c**7 -
        b**12*c**7 + a**9*b**2*c**8 - 4*a**8*b**3*c**8 -
        7*a**7*b**4*c**8 + 2*a**6*b**5*c**8 + 16*a**5*b**6*c**8 +
        6*a**4*b**7*c**8 - 6*a**3*b**8*c**8 - 9*a**2*b**9*c**8 -
        a*b**10*c**8 + 2*b**11*c**8 - a**9*b*c**9 - a**8*b**2*c**9 +
        7*a**7*b**3*c**9 + 10*a**6*b**4*c**9 - 6*a**5*b**5*c**9 -
        15*a**4*b**6*c**9 - 5*a**3*b**7*c**9 + 6*a**2*b**8*c**9 +
        6*a*b**9*c**9 - b**10*c**9 + 3*a**8*b*c**10 -
        10*a**6*b**3*c**10 - 9*a**5*b**4*c**10 + 8*a**4*b**5*c**10 +
        12*a**3*b**6*c**10 + 3*a**2*b**7*c**10 - 6*a*b**8*c**10 -
        b**9*c**10 - a**8*c**11 - 4*a**7*b*c**11 + a**6*b**2*c**11 +
        11*a**5*b**3*c**11 + 5*a**4*b**4*c**11 - 6*a**3*b**5*c**11 -
        9*a**2*b**6*c**11 + a*b**7*c**11 + 2*b**8*c**11 + 2*a**7*c**12
        + 4*a**6*b*c**12 - 3*a**5*b**2*c**12 - 8*a**4*b**3*c**12 -
        3*a**3*b**4*c**12 + 6*a**2*b**5*c**12 + 3*a*b**6*c**12 -
        b**7*c**12 - 2*a**6*c**13 - 3*a**5*b*c**13 + 3*a**4*b**2*c**13
        + 5*a**3*b**3*c**13 - 3*a*b**5*c**13 + 2*a**5*c**14 +
        a**4*b*c**14 - 2*a**3*b**2*c**14 - 2*a**2*b**3*c**14 +
        a*b**4*c**14 - a**4*c**15 + a**2*b**2*c**15),
        (-a**6*b**5*c**9)/(a**15*b**4 - 2*a**14*b**5 + 2*a**13*b**6 -
        2*a**12*b**7 + a**11*b**8 - a**14*b**4*c + 3*a**13*b**5*c -
        4*a**12*b**6*c + 4*a**11*b**7*c - 3*a**10*b**8*c + a**9*b**9*c
        - a**15*b**2*c**2 + 2*a**14*b**3*c**2 - 3*a**13*b**4*c**2 +
        3*a**12*b**5*c**2 - a**11*b**6*c**2 + a**9*b**8*c**2 -
        a**8*b**9*c**2 + 2*a**14*b**2*c**3 - 5*a**13*b**3*c**3 +
        8*a**12*b**4*c**3 - 11*a**11*b**5*c**3 + 10*a**10*b**6*c**3 -
        7*a**9*b**7*c**3 + 4*a**8*b**8*c**3 - a**7*b**9*c**3 -
        a**14*b*c**4 + 3*a**12*b**3*c**4 - 5*a**11*b**4*c**4 +
        9*a**10*b**5*c**4 - 10*a**9*b**6*c**4 + 7*a**8*b**7*c**4 -
        5*a**7*b**8*c**4 + 2*a**6*b**9*c**4 + 3*a**13*b*c**5 -
        6*a**12*b**2*c**5 + 6*a**11*b**3*c**5 - 8*a**10*b**4*c**5 +
        6*a**9*b**5*c**5 - 2*a**8*b**6*c**5 + 2*a**7*b**7*c**5 -
        a**5*b**9*c**5 - 3*a**12*b*c**6 + 9*a**11*b**2*c**6 -
        12*a**10*b**3*c**6 + 15*a**9*b**4*c**6 - 16*a**8*b**5*c**6 +
        11*a**7*b**6*c**6 - 8*a**6*b**7*c**6 + 5*a**5*b**8*c**6 -
        a**4*b**9*c**6 + a**12*c**7 - a**11*b*c**7 - 3*a**10*b**2*c**7
        + 5*a**9*b**3*c**7 - 6*a**8*b**4*c**7 + 8*a**7*b**5*c**7 -
        5*a**6*b**6*c**7 + 3*a**5*b**7*c**7 - 3*a**4*b**8*c**7 +
        a**3*b**9*c**7 - 2*a**11*c**8 + 6*a**10*b*c**8 -
        6*a**9*b**2*c**8 + 6*a**8*b**3*c**8 - 7*a**7*b**4*c**8 +
        4*a**6*b**5*c**8 - 4*a**5*b**6*c**8 + 4*a**4*b**7*c**8 -
        a**3*b**8*c**8 + a**10*c**9 - 6*a**9*b*c**9 + 9*a**8*b**2*c**9
        - 8*a**7*b**3*c**9 + 9*a**6*b**4*c**9 - 6*a**5*b**5*c**9 +
        3*a**4*b**6*c**9 - 4*a**3*b**7*c**9 + 2*a**2*b**8*c**9 +
        a**9*c**10 + a**8*b*c**10 - 4*a**7*b**2*c**10 +
        2*a**6*b**3*c**10 - 2*a**5*b**4*c**10 + a**4*b**5*c**10 +
        2*a**3*b**6*c**10 - a*b**8*c**10 - 2*a**8*c**11 +
        3*a**7*b*c**11 - a**6*b**2*c**11 + 2*a**5*b**3*c**11 -
        2*a**4*b**4*c**11 + a**3*b**5*c**11 - 3*a**2*b**6*c**11 +
        2*a*b**7*c**11 + a**7*c**12 - 3*a**6*b*c**12 +
        2*a**5*b**2*c**12 - a**4*b**3*c**12 + a**3*b**4*c**12 +
        a**2*b**5*c**12 - b**7*c**12 + a**5*b*c**13 - a**4*b**2*c**13
        - a*b**5*c**13 + b**6*c**13), (-a**9*b**6*c**5)/(a**12*b**7 -
        2*a**11*b**8 + a**10*b**9 + a**9*b**10 - 2*a**8*b**11 +
        a**7*b**12 + a**13*b**5*c - 3*a**12*b**6*c + 3*a**11*b**7*c +
        a**10*b**8*c - 6*a**9*b**9*c + 6*a**8*b**10*c - a**7*b**11*c -
        3*a**6*b**12*c + 3*a**5*b**13*c - a**4*b**14*c -
        a**13*b**4*c**2 + 2*a**12*b**5*c**2 - a**11*b**6*c**2 -
        4*a**10*b**7*c**2 + 9*a**9*b**8*c**2 - 6*a**8*b**9*c**2 -
        3*a**7*b**10*c**2 + 9*a**6*b**11*c**2 - 6*a**5*b**12*c**2 +
        2*a**3*b**14*c**2 - a**2*b**15*c**2 - a**12*b**4*c**3 +
        2*a**11*b**5*c**3 + 2*a**10*b**6*c**3 - 8*a**9*b**7*c**3 +
        6*a**8*b**8*c**3 + 5*a**7*b**9*c**3 - 12*a**6*b**10*c**3 +
        6*a**5*b**11*c**3 + 3*a**4*b**12*c**3 - 5*a**3*b**13*c**3 +
        2*a**2*b**14*c**3 + a**12*b**3*c**4 - 2*a**11*b**4*c**4 -
        2*a**10*b**5*c**4 + 9*a**9*b**6*c**4 - 7*a**8*b**7*c**4 -
        6*a**7*b**8*c**4 + 15*a**6*b**9*c**4 - 8*a**5*b**10*c**4 -
        5*a**4*b**11*c**4 + 8*a**3*b**12*c**4 - 3*a**2*b**13*c**4 -
        a*b**14*c**4 + b**15*c**4 - a**13*b*c**5 + a**12*b**2*c**5 +
        a**11*b**3*c**5 + a**10*b**4*c**5 - 6*a**9*b**5*c**5 +
        4*a**8*b**6*c**5 + 8*a**7*b**7*c**5 - 16*a**6*b**8*c**5 +
        6*a**5*b**9*c**5 + 9*a**4*b**10*c**5 - 11*a**3*b**11*c**5 +
        3*a**2*b**12*c**5 + 3*a*b**13*c**5 - 2*b**14*c**5 + a**13*c**6
        - 3*a**11*b**2*c**6 + 2*a**10*b**3*c**6 + 3*a**9*b**4*c**6 -
        4*a**8*b**5*c**6 - 5*a**7*b**6*c**6 + 11*a**6*b**7*c**6 -
        2*a**5*b**8*c**6 - 10*a**4*b**9*c**6 + 10*a**3*b**10*c**6 -
        a**2*b**11*c**6 - 4*a*b**12*c**6 + 2*b**13*c**6 - a**12*c**7 +
        2*a**11*b*c**7 - 4*a**9*b**3*c**7 + 4*a**8*b**4*c**7 +
        3*a**7*b**5*c**7 - 8*a**6*b**6*c**7 + 2*a**5*b**7*c**7 +
        7*a**4*b**8*c**7 - 7*a**3*b**9*c**7 + 4*a*b**11*c**7 -
        2*b**12*c**7 - a**10*b*c**8 + 2*a**9*b**2*c**8 -
        a**8*b**3*c**8 - 3*a**7*b**4*c**8 + 5*a**6*b**5*c**8 -
        5*a**4*b**7*c**8 + 4*a**3*b**8*c**8 + a**2*b**9*c**8 -
        3*a*b**10*c**8 + b**11*c**8 + a**7*b**3*c**9 - a**6*b**4*c**9
        - a**5*b**5*c**9 + 2*a**4*b**6*c**9 - a**3*b**7*c**9 -
        a**2*b**8*c**9 + a*b**9*c**9), a**5*b**7*c**5/(a**9*b**7 -
        a**8*b**8 - a**7*b**9 + a**6*b**10 - a**9*b**6*c + a**8*b**7*c
        + 2*a**7*b**8*c - 2*a**6*b**9*c - a**5*b**10*c + a**4*b**11*c
        - a**9*b**5*c**2 + 2*a**6*b**8*c**2 + a**5*b**9*c**2 -
        2*a**4*b**10*c**2 + 2*a**9*b**4*c**3 - 4*a**7*b**6*c**3 -
        a**6*b**7*c**3 + 2*a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**2*b**11*c**3 - a**9*b**3*c**4 + 4*a**7*b**5*c**4 -
        4*a**5*b**7*c**4 - a**4*b**8*c**4 + a**3*b**9*c**4 +
        a**2*b**10*c**4 - a**9*b**2*c**5 + a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 - 2*a**4*b**7*c**5 -
        a**3*b**8*c**5 + a**2*b**9*c**5 + a**9*b*c**6 + a**8*b**2*c**6
        - 4*a**7*b**3*c**6 - 3*a**6*b**4*c**6 + 4*a**5*b**5*c**6 +
        5*a**4*b**6*c**6 - a**3*b**7*c**6 - 4*a**2*b**8*c**6 +
        b**10*c**6 - a**8*b*c**7 + 2*a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 4*a**5*b**4*c**7 - 5*a**4*b**5*c**7 + 2*a**3*b**6*c**7 +
        5*a**2*b**7*c**7 - 2*b**9*c**7 + a**7*b*c**8 - a**6*b**2*c**8
        + a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 + b**8*c**8
        - a**7*c**9 - a**6*b*c**9 + 2*a**5*b**2*c**9 +
        3*a**4*b**3*c**9 - a**3*b**4*c**9 - 3*a**2*b**5*c**9 +
        b**7*c**9 + a**6*c**10 - a**5*b*c**10 - 3*a**4*b**2*c**10 +
        a**3*b**3*c**10 + 4*a**2*b**4*c**10 - 2*b**6*c**10 +
        a**4*b*c**11 - 2*a**2*b**3*c**11 + b**5*c**11),
        a**7*b**5*c**5/(a**10*b**6 - 2*a**9*b**7 + a**8*b**8 +
        a**7*b**9 - 2*a**6*b**10 + a**5*b**11 - a**11*b**3*c**2 +
        a**10*b**4*c**2 + a**9*b**5*c**2 - 4*a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - a**6*b**8*c**2 - 3*a**5*b**9*c**2 +
        4*a**4*b**10*c**2 - 2*a**3*b**11*c**2 + a**9*b**4*c**3 -
        a**8*b**5*c**3 - a**7*b**6*c**3 + 2*a**6*b**7*c**3 -
        a**5*b**8*c**3 - a**4*b**9*c**3 + a**3*b**10*c**3 +
        a**11*b*c**4 - 2*a**10*b**2*c**4 + 2*a**9*b**3*c**4 -
        a**8*b**4*c**4 - 2*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        5*a**5*b**7*c**4 + a**4*b**8*c**4 + 3*a**3*b**9*c**4 -
        3*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        a**9*b**2*c**5 + 2*a**8*b**3*c**5 - 4*a**7*b**4*c**5 +
        a**6*b**5*c**5 + 4*a**5*b**6*c**5 - 4*a**4*b**7*c**5 +
        2*a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - 2*a**9*b*c**6 +
        2*a**8*b**2*c**6 - a**7*b**3*c**6 + a**5*b**5*c**6 -
        3*a**4*b**6*c**6 + 3*a**3*b**7*c**6 - a**2*b**8*c**6 -
        a*b**9*c**6 + b**10*c**6 - a**9*c**7 + 2*a**8*b*c**7 -
        4*a**6*b**3*c**7 + 4*a**5*b**4*c**7 + a**4*b**5*c**7 -
        4*a**3*b**6*c**7 + 2*a**2*b**7*c**7 + a*b**8*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + a**2*b**6*c**8 - a*b**7*c**8 +
        a**7*c**9 - a**6*b*c**9 - a**5*b**2*c**9 + 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + a*b**6*c**9),
        a**5*b**5*c**7/(a**10*b**6 - a**9*b**7 + a**11*b**4*c -
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c - a**7*b**8*c +
        a**6*b**9*c - 3*a**10*b**4*c**2 + 2*a**9*b**5*c**2 -
        a**8*b**6*c**2 + 2*a**7*b**7*c**2 + a**6*b**8*c**2 -
        a**5*b**9*c**2 - 2*a**11*b**2*c**3 + a**10*b**3*c**3 +
        3*a**9*b**4*c**3 + 3*a**7*b**6*c**3 - 4*a**6*b**7*c**3 -
        a**4*b**9*c**3 + 4*a**10*b**2*c**4 - a**9*b**3*c**4 +
        a**8*b**4*c**4 - 4*a**7*b**5*c**4 - 3*a**6*b**6*c**4 +
        a**5*b**7*c**4 + 2*a**3*b**9*c**4 + a**11*c**5 -
        3*a**9*b**2*c**5 - a**8*b**3*c**5 - 5*a**7*b**4*c**5 +
        4*a**6*b**5*c**5 + a**5*b**6*c**5 + 4*a**4*b**7*c**5 -
        a**2*b**9*c**5 - 2*a**10*c**6 - a**8*b**2*c**6 +
        2*a**7*b**3*c**6 + 5*a**6*b**4*c**6 + a**5*b**5*c**6 -
        4*a**3*b**7*c**6 - a*b**9*c**6 + a**9*c**7 + 5*a**7*b**2*c**7
        - a**6*b**3*c**7 - 2*a**5*b**4*c**7 - 4*a**4*b**5*c**7 -
        a**3*b**6*c**7 + a*b**8*c**7 + b**9*c**7 + a**8*c**8 -
        4*a**6*b**2*c**8 - a**5*b**3*c**8 - a**4*b**4*c**8 +
        2*a**3*b**5*c**8 + 2*a**2*b**6*c**8 + 2*a*b**7*c**8 -
        b**8*c**8 - 2*a**7*c**9 + a**5*b**2*c**9 + a**4*b**3*c**9 +
        2*a**3*b**4*c**9 + a**2*b**5*c**9 - 2*a*b**6*c**9 - b**7*c**9
        + a**6*c**10 + a**4*b**2*c**10 - 2*a**2*b**4*c**10 -
        a*b**5*c**10 + b**6*c**10 - a**3*b**2*c**11 + a*b**4*c**11),
        (-a**5*b**5*c**7)/(a**7*b**9 - a**6*b**10 - a**9*b**6*c +
        a**8*b**7*c - a**7*b**8*c + a**6*b**9*c + a**5*b**10*c -
        a**4*b**11*c + a**9*b**5*c**2 - a**8*b**6*c**2 -
        2*a**7*b**7*c**2 + a**6*b**8*c**2 - 2*a**5*b**9*c**2 +
        3*a**4*b**10*c**2 + a**9*b**4*c**3 + 4*a**7*b**6*c**3 -
        3*a**6*b**7*c**3 - 3*a**4*b**9*c**3 - a**3*b**10*c**3 +
        2*a**2*b**11*c**3 - 2*a**9*b**3*c**4 - a**7*b**5*c**4 +
        3*a**6*b**6*c**4 + 4*a**5*b**7*c**4 - a**4*b**8*c**4 +
        a**3*b**9*c**4 - 4*a**2*b**10*c**4 + a**9*b**2*c**5 -
        4*a**7*b**4*c**5 - a**6*b**5*c**5 - 4*a**5*b**6*c**5 +
        5*a**4*b**7*c**5 + a**3*b**8*c**5 + 3*a**2*b**9*c**5 -
        b**11*c**5 + a**9*b*c**6 + 4*a**7*b**3*c**6 - a**5*b**5*c**6 -
        5*a**4*b**6*c**6 - 2*a**3*b**7*c**6 + a**2*b**8*c**6 +
        2*b**10*c**6 - a**9*c**7 - a**8*b*c**7 + a**6*b**3*c**7 +
        4*a**5*b**4*c**7 + 2*a**4*b**5*c**7 + a**3*b**6*c**7 -
        5*a**2*b**7*c**7 - b**9*c**7 + a**8*c**8 - 2*a**7*b*c**8 -
        2*a**6*b**2*c**8 - 2*a**5*b**3*c**8 + a**4*b**4*c**8 +
        a**3*b**5*c**8 + 4*a**2*b**6*c**8 - b**8*c**8 + a**7*c**9 +
        2*a**6*b*c**9 - a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        a**3*b**4*c**9 - a**2*b**5*c**9 + 2*b**7*c**9 - a**6*c**10 +
        a**5*b*c**10 + 2*a**4*b**2*c**10 - a**2*b**4*c**10 -
        b**6*c**10 - a**4*b*c**11 + a**2*b**3*c**11),
        a**7*b**5*c**5/(a**10*b**6 - a**9*b**7 - a**8*b**8 + a**7*b**9
        + a**11*b**4*c - a**10*b**5*c - 2*a**9*b**6*c + 2*a**8*b**7*c
        + a**7*b**8*c - a**6*b**9*c - 2*a**10*b**4*c**2 +
        a**9*b**5*c**2 + 2*a**8*b**6*c**2 - a**5*b**9*c**2 -
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 + 2*a**8*b**5*c**3 -
        a**7*b**6*c**3 - 4*a**6*b**7*c**3 + 2*a**4*b**9*c**3 +
        a**10*b**2*c**4 + a**9*b**3*c**4 - a**8*b**4*c**4 -
        4*a**7*b**5*c**4 + 4*a**5*b**7*c**4 - a**3*b**9*c**4 +
        a**9*b**2*c**5 - a**8*b**3*c**5 - 2*a**7*b**4*c**5 +
        a**6*b**5*c**5 + a**5*b**6*c**5 + a**4*b**7*c**5 -
        a**2*b**9*c**5 + a**10*c**6 - 4*a**8*b**2*c**6 -
        a**7*b**3*c**6 + 5*a**6*b**4*c**6 + 4*a**5*b**5*c**6 -
        3*a**4*b**6*c**6 - 4*a**3*b**7*c**6 + a**2*b**8*c**6 +
        a*b**9*c**6 - 2*a**9*c**7 + 5*a**7*b**2*c**7 +
        2*a**6*b**3*c**7 - 5*a**5*b**4*c**7 - 4*a**4*b**5*c**7 +
        3*a**3*b**6*c**7 + 2*a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8
        - a**6*b**2*c**8 - a**5*b**3*c**8 + a**4*b**4*c**8 -
        a**2*b**6*c**8 + a*b**7*c**8 + a**7*c**9 - 3*a**5*b**2*c**9 -
        a**4*b**3*c**9 + 3*a**3*b**4*c**9 + 2*a**2*b**5*c**9 -
        a*b**6*c**9 - b**7*c**9 - 2*a**6*c**10 + 4*a**4*b**2*c**10 +
        a**3*b**3*c**10 - 3*a**2*b**4*c**10 - a*b**5*c**10 +
        b**6*c**10 + a**5*c**11 - 2*a**3*b**2*c**11 + a*b**4*c**11),
        a**5*b**7*c**5/(a**11*b**5 - 2*a**10*b**6 + a**9*b**7 +
        a**8*b**8 - 2*a**7*b**9 + a**6*b**10 - 2*a**11*b**3*c**2 +
        4*a**10*b**4*c**2 - 3*a**9*b**5*c**2 - a**8*b**6*c**2 +
        5*a**7*b**7*c**2 - 4*a**6*b**8*c**2 + a**5*b**9*c**2 +
        a**4*b**10*c**2 - a**3*b**11*c**2 + a**10*b**3*c**3 -
        a**9*b**4*c**3 - a**8*b**5*c**3 + 2*a**7*b**6*c**3 -
        a**6*b**7*c**3 - a**5*b**8*c**3 + a**4*b**9*c**3 +
        a**11*b*c**4 - 3*a**10*b**2*c**4 + 3*a**9*b**3*c**4 +
        a**8*b**4*c**4 - 5*a**7*b**5*c**4 + 5*a**6*b**6*c**4 -
        2*a**5*b**7*c**4 - a**4*b**8*c**4 + 2*a**3*b**9*c**4 -
        2*a**2*b**10*c**4 + a*b**11*c**4 - a**10*b*c**5 +
        2*a**9*b**2*c**5 - 4*a**7*b**4*c**5 + 4*a**6*b**5*c**5 +
        a**5*b**6*c**5 - 4*a**4*b**7*c**5 + 2*a**3*b**8*c**5 +
        a**2*b**9*c**5 - a*b**10*c**5 + a**10*c**6 - a**9*b*c**6 -
        a**8*b**2*c**6 + 3*a**7*b**3*c**6 - 3*a**6*b**4*c**6 +
        a**5*b**5*c**6 - a**3*b**7*c**6 + 2*a**2*b**8*c**6 -
        2*a*b**9*c**6 + b**10*c**6 - a**9*c**7 + a**8*b*c**7 +
        2*a**7*b**2*c**7 - 4*a**6*b**3*c**7 + a**5*b**4*c**7 +
        4*a**4*b**5*c**7 - 4*a**3*b**6*c**7 + 2*a*b**8*c**7 -
        b**9*c**7 - a**7*b*c**8 + a**6*b**2*c**8 + a*b**7*c**8 -
        b**8*c**8 + a**6*b*c**9 - a**5*b**2*c**9 - a**4*b**3*c**9 +
        2*a**3*b**4*c**9 - a**2*b**5*c**9 - a*b**6*c**9 + b**7*c**9),
        a**5*b**6*c**6/(a**9*b**7 - a**8*b**8 - a**11*b**4*c +
        a**10*b**5*c - a**9*b**6*c + a**8*b**7*c + a**7*b**8*c -
        a**6*b**9*c + a**11*b**3*c**2 - a**10*b**4*c**2 -
        2*a**9*b**5*c**2 + a**8*b**6*c**2 - a**7*b**7*c**2 +
        2*a**6*b**8*c**2 + a**5*b**9*c**2 - a**4*b**10*c**2 +
        a**11*b**2*c**3 + 2*a**9*b**4*c**3 - a**8*b**5*c**3 -
        3*a**7*b**6*c**3 - a**5*b**8*c**3 + 2*a**4*b**9*c**3 -
        a**11*b*c**4 - a**10*b**2*c**4 + 2*a**9*b**3*c**4 +
        3*a**7*b**5*c**4 - a**6*b**6*c**4 - 2*a**5*b**7*c**4 -
        a**4*b**8*c**4 + a**2*b**10*c**4 + a**10*b*c**5 -
        2*a**9*b**2*c**5 - a**8*b**3*c**5 + 3*a**7*b**4*c**5 +
        2*a**5*b**6*c**5 - a**4*b**7*c**5 - a**3*b**8*c**5 -
        a**2*b**9*c**5 - a**9*b*c**6 + a**8*b**2*c**6 -
        3*a**7*b**3*c**6 - a**6*b**4*c**6 + 2*a**5*b**5*c**6 +
        2*a**4*b**6*c**6 + a**3*b**7*c**6 - a**2*b**8*c**6 + a**9*c**7
        + a**8*b*c**7 - a**7*b**2*c**7 - 2*a**5*b**4*c**7 -
        a**4*b**5*c**7 + a**3*b**6*c**7 + 2*a**2*b**7*c**7 - b**9*c**7
        - a**8*c**8 + a**7*b*c**8 + 2*a**6*b**2*c**8 - a**5*b**3*c**8
        - a**4*b**4*c**8 - a**3*b**5*c**8 - a**2*b**6*c**8 +
        2*b**8*c**8 - a**6*b*c**9 + a**5*b**2*c**9 + 2*a**4*b**3*c**9
        - a**2*b**5*c**9 - b**7*c**9 - a**4*b**2*c**10 +
        a**2*b**4*c**10), (-a**6*b**6*c**5)/(a**9*b**7 - 2*a**8*b**8 +
        a**7*b**9 - a**10*b**4*c**2 + a**9*b**5*c**2 + a**8*b**6*c**2
        - 2*a**7*b**7*c**2 + a**6*b**8*c**2 + a**5*b**9*c**2 -
        a**4*b**10*c**2 + a**8*b**5*c**3 - a**7*b**6*c**3 -
        a**6*b**7*c**3 + a**5*b**8*c**3 + a**10*b**2*c**4 -
        2*a**9*b**3*c**4 + a**8*b**4*c**4 + a**7*b**5*c**4 -
        2*a**6*b**6*c**4 + a**5*b**7*c**4 + a**4*b**8*c**4 -
        2*a**3*b**9*c**4 + a**2*b**10*c**4 - a**9*b**2*c**5 +
        a**8*b**3*c**5 + 2*a**7*b**4*c**5 - 2*a**6*b**5*c**5 -
        2*a**5*b**6*c**5 + 2*a**4*b**7*c**5 + a**3*b**8*c**5 -
        a**2*b**9*c**5 + a**9*b*c**6 - 2*a**8*b**2*c**6 +
        a**6*b**4*c**6 + a**4*b**6*c**6 - 2*a**2*b**8*c**6 +
        a*b**9*c**6 - a**8*b*c**7 + a**7*b**2*c**7 + 3*a**6*b**3*c**7
        - 3*a**5*b**4*c**7 - 3*a**4*b**5*c**7 + 3*a**3*b**6*c**7 +
        a**2*b**7*c**7 - a*b**8*c**7 + a**8*c**8 - a**7*b*c**8 -
        a**6*b**2*c**8 + a**5*b**3*c**8 + a**3*b**5*c**8 -
        a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 - a**7*c**9 +
        a**6*b*c**9 + 2*a**5*b**2*c**9 - 2*a**4*b**3*c**9 -
        2*a**3*b**4*c**9 + 2*a**2*b**5*c**9 + a*b**6*c**9 - b**7*c**9
        - a**5*b*c**10 + a**4*b**2*c**10 + a**2*b**4*c**10 -
        a*b**5*c**10 + a**4*b*c**11 - a**3*b**2*c**11 -
        a**2*b**3*c**11 + a*b**4*c**11), (-a**6*b**5*c**6)/(a**8*b**8
        - a**7*b**9 + a**9*b**6*c - a**8*b**7*c - a**7*b**8*c +
        a**6*b**9*c - a**5*b**10*c + a**4*b**11*c + a**10*b**4*c**2 -
        a**9*b**5*c**2 - 2*a**8*b**6*c**2 + a**7*b**7*c**2 -
        a**6*b**8*c**2 + 2*a**5*b**9*c**2 + a**4*b**10*c**2 -
        a**3*b**11*c**2 - 2*a**9*b**4*c**3 + a**8*b**5*c**3 +
        3*a**6*b**7*c**3 + a**5*b**8*c**3 - 2*a**4*b**9*c**3 -
        a**2*b**11*c**3 - a**10*b**2*c**4 + a**8*b**4*c**4 +
        2*a**7*b**5*c**4 + a**6*b**6*c**4 - 3*a**5*b**7*c**4 -
        2*a**3*b**9*c**4 + a**2*b**10*c**4 + a*b**11*c**4 +
        a**9*b**2*c**5 + a**8*b**3*c**5 + a**7*b**4*c**5 -
        2*a**6*b**5*c**5 - 3*a**4*b**7*c**5 + a**3*b**8*c**5 +
        2*a**2*b**9*c**5 - a*b**10*c**5 + a**8*b**2*c**6 -
        a**7*b**3*c**6 - 2*a**6*b**4*c**6 - 2*a**5*b**5*c**6 +
        a**4*b**6*c**6 + 3*a**3*b**7*c**6 - a**2*b**8*c**6 +
        a*b**9*c**6 + a**9*c**7 - 2*a**7*b**2*c**7 - a**6*b**3*c**7 +
        a**5*b**4*c**7 + 2*a**4*b**5*c**7 + a**2*b**7*c**7 -
        a*b**8*c**7 - b**9*c**7 - 2*a**8*c**8 + a**6*b**2*c**8 +
        a**5*b**3*c**8 + a**4*b**4*c**8 + a**3*b**5*c**8 -
        2*a**2*b**6*c**8 - a*b**7*c**8 + b**8*c**8 + a**7*c**9 +
        a**5*b**2*c**9 - 2*a**3*b**4*c**9 - a**2*b**5*c**9 +
        a*b**6*c**9 - a**4*b**2*c**10 + a**2*b**4*c**10), ((2/3*zeta3
        + 1/3)*a**5*b**5*c**5)/(a**8*b**6 - a**7*b**7 + a**6*b**8 +
        (zeta3 + 1)*a**9*b**4*c + (-zeta3 - 1)*a**8*b**5*c + (zeta3 +
        1)*a**7*b**6*c + (zeta3 + 1)*a**6*b**7*c + (-zeta3 -
        1)*a**5*b**8*c + (zeta3 + 1)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (-zeta3 + 1)*a**8*b**3*c**3
        + zeta3*a**7*b**4*c**3 + (-zeta3 + 1)*a**6*b**5*c**3 + (-zeta3
        + 1)*a**5*b**6*c**3 + zeta3*a**4*b**7*c**3 + (-zeta3 +
        1)*a**3*b**8*c**3 + (zeta3 + 1)*a**9*b*c**4 +
        zeta3*a**7*b**3*c**4 + (3*zeta3 + 3)*a**6*b**4*c**4 + (-zeta3
        - 2)*a**5*b**5*c**4 + (3*zeta3 + 3)*a**4*b**6*c**4 +
        zeta3*a**3*b**7*c**4 + (zeta3 + 1)*a*b**9*c**4 + (-zeta3 -
        1)*a**8*b*c**5 - a**7*b**2*c**5 + (-zeta3 + 1)*a**6*b**3*c**5
        + (-zeta3 - 2)*a**5*b**4*c**5 + (-zeta3 - 2)*a**4*b**5*c**5 +
        (-zeta3 + 1)*a**3*b**6*c**5 - a**2*b**7*c**5 + (-zeta3 -
        1)*a*b**8*c**5 + a**8*c**6 + (zeta3 + 1)*a**7*b*c**6 +
        a**6*b**2*c**6 + (-zeta3 + 1)*a**5*b**3*c**6 + (3*zeta3 +
        3)*a**4*b**4*c**6 + (-zeta3 + 1)*a**3*b**5*c**6 +
        a**2*b**6*c**6 + (zeta3 + 1)*a*b**7*c**6 + b**8*c**6 -
        a**7*c**7 + (zeta3 + 1)*a**6*b*c**7 - a**5*b**2*c**7 +
        zeta3*a**4*b**3*c**7 + zeta3*a**3*b**4*c**7 - a**2*b**5*c**7 +
        (zeta3 + 1)*a*b**6*c**7 - b**7*c**7 + a**6*c**8 + (-zeta3 -
        1)*a**5*b*c**8 + (-zeta3 + 1)*a**3*b**3*c**8 + (-zeta3 -
        1)*a*b**5*c**8 + b**6*c**8 + (zeta3 + 1)*a**4*b*c**9 + (zeta3
        + 1)*a*b**4*c**9), ((-2/3*zeta3 -
        1/3)*a**5*b**5*c**5)/(a**8*b**6 - a**7*b**7 + a**6*b**8 +
        (-zeta3)*a**9*b**4*c + zeta3*a**8*b**5*c +
        (-zeta3)*a**7*b**6*c + (-zeta3)*a**6*b**7*c +
        zeta3*a**5*b**8*c + (-zeta3)*a**4*b**9*c - a**7*b**5*c**2 +
        a**6*b**6*c**2 - a**5*b**7*c**2 + (zeta3 + 2)*a**8*b**3*c**3 +
        (-zeta3 - 1)*a**7*b**4*c**3 + (zeta3 + 2)*a**6*b**5*c**3 +
        (zeta3 + 2)*a**5*b**6*c**3 + (-zeta3 - 1)*a**4*b**7*c**3 +
        (zeta3 + 2)*a**3*b**8*c**3 + (-zeta3)*a**9*b*c**4 + (-zeta3 -
        1)*a**7*b**3*c**4 + (-3*zeta3)*a**6*b**4*c**4 + (zeta3 -
        1)*a**5*b**5*c**4 + (-3*zeta3)*a**4*b**6*c**4 + (-zeta3 -
        1)*a**3*b**7*c**4 + (-zeta3)*a*b**9*c**4 + zeta3*a**8*b*c**5 -
        a**7*b**2*c**5 + (zeta3 + 2)*a**6*b**3*c**5 + (zeta3 -
        1)*a**5*b**4*c**5 + (zeta3 - 1)*a**4*b**5*c**5 + (zeta3 +
        2)*a**3*b**6*c**5 - a**2*b**7*c**5 + zeta3*a*b**8*c**5 +
        a**8*c**6 + (-zeta3)*a**7*b*c**6 + a**6*b**2*c**6 + (zeta3 +
        2)*a**5*b**3*c**6 + (-3*zeta3)*a**4*b**4*c**6 + (zeta3 +
        2)*a**3*b**5*c**6 + a**2*b**6*c**6 + (-zeta3)*a*b**7*c**6 +
        b**8*c**6 - a**7*c**7 + (-zeta3)*a**6*b*c**7 - a**5*b**2*c**7
        + (-zeta3 - 1)*a**4*b**3*c**7 + (-zeta3 - 1)*a**3*b**4*c**7 -
        a**2*b**5*c**7 + (-zeta3)*a*b**6*c**7 - b**7*c**7 + a**6*c**8
        + zeta3*a**5*b*c**8 + (zeta3 + 2)*a**3*b**3*c**8 +
        zeta3*a*b**5*c**8 + b**6*c**8 + (-zeta3)*a**4*b*c**9 +
        (-zeta3)*a*b**4*c**9)]}
    return data[num_strands][bas_ele]

