/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class Iterables {
    public static <K, T> Iterator<Map<K, T>> combine(Map<K, ? extends Iterable<T>> map) {
        return new CrossProductIterator(map);
    }

    private static class CrossProductIterator<K, T>
    implements Iterator<Map<K, T>> {
        private final Map<K, ? extends Iterable<T>> iterables;
        private final Map<K, Iterator<T>> iterators = new LinkedHashMap<K, Iterator<T>>();
        private final List<K> keys = new ArrayList<K>();
        private Map<K, T> current;
        private boolean loaded;
        private boolean exhausted;

        private CrossProductIterator(Map<K, ? extends Iterable<T>> iterables) {
            this.iterables = iterables;
            for (Map.Entry<K, Iterable<T>> entry : iterables.entrySet()) {
                K key = entry.getKey();
                this.keys.add(key);
                this.iterators.put(key, entry.getValue().iterator());
            }
        }

        private void loadFirst() {
            this.current = new LinkedHashMap<K, T>();
            for (K key : this.keys) {
                Iterator<T> iterator = this.iterators.get(key);
                if (!iterator.hasNext()) {
                    this.exhausted = true;
                    return;
                }
                T next = iterator.next();
                this.current.put(key, next);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.loaded) {
                this.loadNext();
                this.loaded = true;
            }
            return !this.exhausted;
        }

        @Override
        public Map<K, T> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("CrossProductIterator has been exhausted and contains no more elements");
            }
            Map<K, T> ret = this.current;
            this.loaded = false;
            return ret;
        }

        private void loadNext() {
            if (this.current == null) {
                this.loadFirst();
            } else {
                this.current = new LinkedHashMap<K, T>(this.current);
                for (int i = this.keys.size() - 1; i >= 0; --i) {
                    K key = this.keys.get(i);
                    if (this.iterators.get(key).hasNext()) {
                        T next = this.iterators.get(key).next();
                        this.current.put(key, next);
                        break;
                    }
                    if (i > 0) {
                        this.iterators.put(key, this.iterables.get(key).iterator());
                        this.current.put(key, this.iterators.get(key).next());
                        continue;
                    }
                    this.exhausted = true;
                }
            }
        }
    }
}

