/*
 * devst_string.c  - Return device status string.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#pragma ident "$Revision$"


#include <sys/types.h>
#include "sam/types.h"
#include "sam/param.h"
#include "aml/device.h"

static char str[11];	/* Device status string	*/

char *
sam_devstr(uint_t p)
{
	dev_status_t	*dev_st;

	dev_st = (dev_status_t *)&p;

	str[0] = dev_st->scanning   	? 's': '-';
	str[0] = dev_st->mounted    	? 'm': str[0];
	str[0] = dev_st->maint		? 'M': str[0];
	str[1] = (dev_st->scan_err|dev_st->bad_media)? 'E' : (dev_st->audit ? 'a' : '-');
	str[2] = dev_st->labeled    	? 'l': '-';
	str[2] = dev_st->strange    	? 'N': str[2];
	str[2] = dev_st->labelling  	? 'L': str[2];
	str[3] = dev_st->wait_idle  	? 'I' : dev_st->attention  ? 'A': '-';
	str[4] = dev_st->unload		? 'U': dev_st->cleaning  ? 'C': '-';
#if defined(DEVICE_STRING)
	str[5] = dev_st->requested  	? 'R': dev_st->stripe  ? 'S': '-';
#else
	str[5] = dev_st->requested  	? 'R': '-';
#endif
	str[6] = dev_st->wr_lock	? 'w': '-';
	str[7] = dev_st->opened		? 'o': '-';
	str[8] = dev_st->positioning   	? 'P' : dev_st->stor_full  ? 'F': '-';
	str[9] = dev_st->ready		?
		(dev_st->write_protect 	? 'W' :
		(dev_st->read_only	? 'R': 'r')) : (dev_st->present ? 'p': '-');

	str[10] = '\0';
	return (str);
}
