/*
 * checksumf.h - checksum function (and array) declarations.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Revision$
 */

#ifdef sun
#pragma ident "$Revision$"
#endif


typedef void (*csum_func)();

/*
 * The checksum processing function
 * A non-null cookie (pointer) indicates an initialization pass.
 */

/* 0 */
extern void cs_empty(u_longlong_t *cookie, uchar_t *buf, int len, csum_t * val);

/* 1 */
extern void cs_simple(u_longlong_t *cookie, uchar_t *buf, int len, csum_t * val);

/* user */
extern void cs_user(u_longlong_t *cookie, int	algo, uchar_t *buf, int len, csum_t * val);

#if defined(DEC_INIT)
csum_func csum[] = {
	cs_empty,
	cs_simple
};
#else 	/* defined(DEC_INIT) */
extern 	csum_func csum[];
#endif 	/* defined(DEC_INIT) */
