; NOTE: Assertions have been autogenerated by utils/update_mir_test_checks.py
; RUN: llc -mtriple=riscv64 -mattr=+f -target-abi lp64 -stop-after=finalize-isel < %s | FileCheck %s

define dso_local void @buz(i1 %pred, float %a, float %b) {
  ; CHECK-LABEL: name: buz
  ; CHECK: bb.0.entry:
  ; CHECK-NEXT:   successors: %bb.1(0x40000000), %bb.2(0x40000000)
  ; CHECK-NEXT:   liveins: $x10, $x11, $x12
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[COPY:%[0-9]+]]:gpr = COPY $x12
  ; CHECK-NEXT:   [[COPY1:%[0-9]+]]:gpr = COPY $x11
  ; CHECK-NEXT:   [[COPY2:%[0-9]+]]:gpr = COPY $x10
  ; CHECK-NEXT:   [[FMV_W_X:%[0-9]+]]:fpr32 = FMV_W_X [[COPY]]
  ; CHECK-NEXT:   [[ANDI:%[0-9]+]]:gpr = ANDI [[COPY2]], 1
  ; CHECK-NEXT:   [[FMV_W_X1:%[0-9]+]]:fpr32 = FMV_W_X [[COPY1]]
  ; CHECK-NEXT:   [[LUI:%[0-9]+]]:gpr = LUI 307200
  ; CHECK-NEXT:   [[FMV_W_X2:%[0-9]+]]:fpr32 = FMV_W_X killed [[LUI]]
  ; CHECK-NEXT:   [[FSGNJX_S:%[0-9]+]]:fpr32 = FSGNJX_S [[FMV_W_X1]], [[FMV_W_X1]]
  ; CHECK-NEXT:   [[FLT_S:%[0-9]+]]:gpr = nofpexcept FLT_S [[FSGNJX_S]], [[FMV_W_X2]]
  ; CHECK-NEXT:   BEQ [[FLT_S]], $x0, %bb.2
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.1.entry:
  ; CHECK-NEXT:   successors: %bb.2(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[FCVT_W_S:%[0-9]+]]:gpr = nofpexcept FCVT_W_S [[FMV_W_X1]], 4
  ; CHECK-NEXT:   [[FCVT_S_W:%[0-9]+]]:fpr32 = nofpexcept FCVT_S_W [[FCVT_W_S]], 4
  ; CHECK-NEXT:   [[FSGNJ_S:%[0-9]+]]:fpr32 = FSGNJ_S [[FCVT_S_W]], [[FMV_W_X1]]
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.2.entry:
  ; CHECK-NEXT:   successors: %bb.3(0x40000000), %bb.4(0x40000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[PHI:%[0-9]+]]:fpr32 = PHI [[FMV_W_X1]], %bb.0, [[FSGNJ_S]], %bb.1
  ; CHECK-NEXT:   BNE [[ANDI]], $x0, %bb.4
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.3.entry:
  ; CHECK-NEXT:   successors: %bb.4(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.4.entry:
  ; CHECK-NEXT:   successors: %bb.5(0x40000000), %bb.6(0x40000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[PHI1:%[0-9]+]]:fpr32 = PHI [[PHI]], %bb.2, [[FMV_W_X1]], %bb.3
  ; CHECK-NEXT:   [[FSGNJX_S1:%[0-9]+]]:fpr32 = FSGNJX_S [[FMV_W_X]], [[FMV_W_X]]
  ; CHECK-NEXT:   [[FLT_S1:%[0-9]+]]:gpr = nofpexcept FLT_S [[FSGNJX_S1]], [[FMV_W_X2]]
  ; CHECK-NEXT:   BEQ [[FLT_S1]], $x0, %bb.6
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.5.entry:
  ; CHECK-NEXT:   successors: %bb.6(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[FCVT_W_S1:%[0-9]+]]:gpr = nofpexcept FCVT_W_S [[FMV_W_X]], 4
  ; CHECK-NEXT:   [[FCVT_S_W1:%[0-9]+]]:fpr32 = nofpexcept FCVT_S_W [[FCVT_W_S1]], 4
  ; CHECK-NEXT:   [[FSGNJ_S1:%[0-9]+]]:fpr32 = FSGNJ_S [[FCVT_S_W1]], [[FMV_W_X]]
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.6.entry:
  ; CHECK-NEXT:   successors: %bb.7(0x40000000), %bb.8(0x40000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT:   [[PHI2:%[0-9]+]]:fpr32 = PHI [[FMV_W_X]], %bb.4, [[FSGNJ_S1]], %bb.5
  ; CHECK-NEXT:   BNE [[ANDI]], $x0, %bb.8
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.7.entry:
  ; CHECK-NEXT:   successors: %bb.8(0x80000000)
  ; CHECK-NEXT: {{  $}}
  ; CHECK-NEXT: bb.8.entry:
  ; CHECK-NEXT:   [[PHI3:%[0-9]+]]:fpr32 = PHI [[PHI2]], %bb.6, [[FMV_W_X]], %bb.7
  ; CHECK-NEXT:   [[FCVT_L_S:%[0-9]+]]:gpr = nofpexcept FCVT_L_S killed [[PHI3]], 1
  ; CHECK-NEXT:   [[FMV_X_W:%[0-9]+]]:gpr = FMV_X_W killed [[PHI1]]
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $x2, implicit $x2
  ; CHECK-NEXT:   $x10 = COPY [[FMV_X_W]]
  ; CHECK-NEXT:   PseudoCALL target-flags(riscv-call) @bar, csr_ilp32_lp64, implicit-def dead $x1, implicit $x10, implicit-def $x2
  ; CHECK-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $x2, implicit $x2
  ; CHECK-NEXT:   ADJCALLSTACKDOWN 0, 0, implicit-def dead $x2, implicit $x2
  ; CHECK-NEXT:   $x10 = COPY [[FCVT_L_S]]
  ; CHECK-NEXT:   PseudoCALL target-flags(riscv-call) @foo, csr_ilp32_lp64, implicit-def dead $x1, implicit $x10, implicit-def $x2
  ; CHECK-NEXT:   ADJCALLSTACKUP 0, 0, implicit-def dead $x2, implicit $x2
  ; CHECK-NEXT:   PseudoRET
entry:
  %0 = call float @llvm.round.f32(float %a)
  %cond = select i1 %pred, float %0, float %a
  %1 = call float @llvm.round.f32(float %b)
  %cond2 = select i1 %pred, float %1, float %b
  %conv = fptosi float %cond2 to i64
  call void @bar(float %cond)
  call void @foo(i64 %conv)
  ret void
}

declare void @foo(i64)

declare void @bar(float)

declare float @llvm.round.f32(float)
