; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=gvn -S < %s | FileCheck %s

define i32 @test1(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test1(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA0:![0-9]+]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !0
  %b = call i32 @foo(ptr %p)
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test2(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test2(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !0
  %b = call i32 @foo(ptr %p), !tbaa !0
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test3(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test3(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA4:![0-9]+]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !3
  %b = call i32 @foo(ptr %p), !tbaa !3
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test4(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test4(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA6:![0-9]+]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !1
  %b = call i32 @foo(ptr %p), !tbaa !0
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test5(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test5(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !0
  %b = call i32 @foo(ptr %p), !tbaa !1
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test6(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test6(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA0]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !0
  %b = call i32 @foo(ptr %p), !tbaa !3
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test7(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test7(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA7:![0-9]+]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !4
  %b = call i32 @foo(ptr %p), !tbaa !3
  %c = add i32 %a, %b
  ret i32 %c
}

define i32 @test8(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test8(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    store i32 15, ptr [[P]], align 4
; CHECK-NEXT:    ret i32 0
;
; Since we know the location is invariant, we can forward the
; load across the potentially aliasing store.

  %a = load i32, ptr %q, !tbaa !10
  store i32 15, ptr %p
  %b = load i32, ptr %q, !tbaa !10
  %c = sub i32 %a, %b
  ret i32 %c
}

define i32 @test9(ptr %p, ptr %q) {
; CHECK-LABEL: define i32 @test9(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    call void @clobber()
; CHECK-NEXT:    ret i32 0
;
; Since we know the location is invariant, we can forward the
; load across the potentially aliasing store (within the call).

  %a = load i32, ptr %q, !tbaa !10
  call void @clobber()
  %b = load i32, ptr %q, !tbaa !10
  %c = sub i32 %a, %b
  ret i32 %c
}

define i32 @test10(ptr %p, ptr %q) {
; If one access encloses the other, then the merged access is the enclosed one
; and not just the common final access type.
; CHECK-LABEL: define i32 @test10(
; CHECK-SAME: ptr [[P:%.*]], ptr [[Q:%.*]]) {
; CHECK-NEXT:    [[A:%.*]] = call i32 @foo(ptr [[P]]), !tbaa [[TBAA10:![0-9]+]]
; CHECK-NEXT:    [[C:%.*]] = add i32 [[A]], [[A]]
; CHECK-NEXT:    ret i32 [[C]]
;
  %a = call i32 @foo(ptr %p), !tbaa !15  ; TAG_X_i
  %b = call i32 @foo(ptr %p), !tbaa !19  ; TAG_Y_x_i
  %c = add i32 %a, %b
  ret i32 %c
}

declare void @clobber()
declare i32 @foo(ptr) readonly

!0 = !{!5, !5, i64 0}
!1 = !{!6, !6, i64 0}
!2 = !{!"tbaa root"}
!3 = !{!7, !7, i64 0}
!4 = !{!11, !11, i64 0}
!5 = !{!"C", !6}
!6 = !{!"A", !2}
!7 = !{!"B", !6}
!8 = !{!"another root"}
!11 = !{!"scalar type", !8}

!15 = !{!16, !17, i64 0}            ; TAG_X_i
!16 = !{!"struct X", !17, i64 0}    ; struct X { int i; };
!17 = !{!"int", !18, i64 0}
!18 = !{!"char", !2, i64 0}

!19 = !{!20, !17, i64 0}            ; TAG_Y_x_i
!20 = !{!"struct Y", !16, i64 0}    ; struct Y { struct X x; };

; A TBAA structure who's only point is to have a constant location.
!9 = !{!"yet another root"}
!10 = !{!"node", !9, i64 1}
;.
; CHECK: [[TBAA0]] = !{[[META1:![0-9]+]], [[META1]], i64 0}
; CHECK: [[META1]] = !{!"C", [[META2:![0-9]+]]}
; CHECK: [[META2]] = !{!"A", [[META3:![0-9]+]]}
; CHECK: [[META3]] = !{!"tbaa root"}
; CHECK: [[TBAA4]] = !{[[META5:![0-9]+]], [[META5]], i64 0}
; CHECK: [[META5]] = !{!"B", [[META2]]}
; CHECK: [[TBAA6]] = !{[[META2]], [[META2]], i64 0}
; CHECK: [[TBAA7]] = !{[[META8:![0-9]+]], [[META8]], i64 0}
; CHECK: [[META8]] = !{!"scalar type", [[META9:![0-9]+]]}
; CHECK: [[META9]] = !{!"another root"}
; CHECK: [[TBAA10]] = !{[[META11:![0-9]+]], [[META12:![0-9]+]], i64 0}
; CHECK: [[META11]] = !{!"struct X", [[META12]], i64 0}
; CHECK: [[META12]] = !{!"int", [[META13:![0-9]+]], i64 0}
; CHECK: [[META13]] = !{!"char", [[META3]], i64 0}
;.
