; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV32I,RV32I-NO-INTEGRATED %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I,RV64I-NO-INTEGRATED %s
; RUN: llc -mtriple=riscv32 -code-model=medium -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV32I-MEDIUM,RV32I-MEDIUM-NO-INTEGRATED %s
; RUN: llc -mtriple=riscv64 -code-model=medium -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I-MEDIUM,RV64I-MEDIUM-NO-INTEGRATED %s
; RUN: llc -mtriple=riscv64 -code-model=large -verify-machineinstrs -no-integrated-as < %s \
; RUN:   | FileCheck -check-prefixes=RV64I-LARGE,RV64I-LARGE-NO-INTEGRATED %s
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32I,RV32I-INTEGRATED %s
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64I,RV64I-INTEGRATED %s
; RUN: llc -mtriple=riscv32 -code-model=medium -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV32I-MEDIUM,RV32I-MEDIUM-INTEGRATED %s
; RUN: llc -mtriple=riscv64 -code-model=medium -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64I-MEDIUM,RV64I-MEDIUM-INTEGRATED %s
; RUN: llc -mtriple=riscv64 -code-model=large -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefixes=RV64I-LARGE,RV64I-LARGE-INTEGRATED %s

@eg = external global [4000 x i32], align 4
@ewg = extern_weak global [4000 x i32], align 4

define void @constraint_m_1(ptr %a) nounwind {
; RV32I-LABEL: constraint_m_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm sideeffect "", "=*m"(ptr elementtype(i32) %a)
  ret void
}

define i32 @constraint_m_2(ptr %a) nounwind {
; RV32I-LABEL: constraint_m_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw a0, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  %1 = tail call i32 asm "lw $0, $1", "=r,*m"(ptr elementtype(i32) %a)
  ret i32 %1
}

define i32 @constraint_m_with_offset(ptr %a) nounwind {
; RV32I-LABEL: constraint_m_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_offset:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_offset:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_offset:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw a0, 4(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 1
  %2 = tail call i32 asm "lw $0, $1", "=r,*m"(ptr elementtype(i32) %1)
  ret i32 %2
}

define void @constraint_m_with_global_1() nounwind {
; RV32I-LABEL: constraint_m_with_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi0:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi0:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_global_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi0:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI3_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi0)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_m_with_global_2() nounwind {
; RV32I-LABEL: constraint_m_with_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg+4)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg+4)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi1:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+4)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi1)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi1:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+4)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi1)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_global_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi1:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI4_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi1)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 4(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @eg, i32 0, i32 1))
  ret void
}

define void @constraint_m_with_global_3() nounwind {
; RV32I-LABEL: constraint_m_with_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg+8000)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg+8000)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi2:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi2)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi2:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi2)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_global_3:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi2:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI5_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi2)(a0)
; RV64I-LARGE-NEXT:    lui a1, 2
; RV64I-LARGE-NEXT:    addiw a1, a1, -192
; RV64I-LARGE-NEXT:    add a0, a0, a1
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @eg, i32 0, i32 2000))
  ret void
}

define void @constraint_m_with_extern_weak_global_1() nounwind {
; RV32I-LABEL: constraint_m_with_extern_weak_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_extern_weak_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi3:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi3:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_extern_weak_global_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi3:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI6_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi3)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) @ewg)
  ret void
}

define void @constraint_m_with_extern_weak_global_2() nounwind {
; RV32I-LABEL: constraint_m_with_extern_weak_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg+4)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_extern_weak_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg+4)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi4:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi4:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_extern_weak_global_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi4:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI7_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi4)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 4(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @ewg, i32 0, i32 1))
  ret void
}

define void @constraint_m_with_extern_weak_global_3() nounwind {
; RV32I-LABEL: constraint_m_with_extern_weak_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg+8000)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_extern_weak_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg+8000)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi5:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV32I-MEDIUM-NEXT:    lui a1, 2
; RV32I-MEDIUM-NEXT:    addi a1, a1, -192
; RV32I-MEDIUM-NEXT:    add a0, a0, a1
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_extern_weak_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi5:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV64I-MEDIUM-NEXT:    lui a1, 2
; RV64I-MEDIUM-NEXT:    addiw a1, a1, -192
; RV64I-MEDIUM-NEXT:    add a0, a0, a1
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_extern_weak_global_3:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi5:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI8_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi5)(a0)
; RV64I-LARGE-NEXT:    lui a1, 2
; RV64I-LARGE-NEXT:    addiw a1, a1, -192
; RV64I-LARGE-NEXT:    add a0, a0, a1
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @ewg, i32 0, i32 2000))
  ret void
}

define void @constraint_m_with_local_1() nounwind {
; RV32I-LABEL: constraint_m_with_local_1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp0: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp0)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, %lo(.Ltmp0)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_local_1:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp0: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp0)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, %lo(.Ltmp0)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_local_1:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp0: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi6:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi6)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_local_1:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp0: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi6:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi6)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_local_1:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp0: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi6:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi6)(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  tail call void asm sideeffect "lw zero, $0", "*m"(ptr elementtype(ptr) blockaddress(@constraint_m_with_local_1, %label))
  ret void
}

define void @constraint_m_with_local_2() nounwind {
; RV32I-LABEL: constraint_m_with_local_2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp1: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp1+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, %lo(.Ltmp1+4)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_local_2:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp1: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp1+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, %lo(.Ltmp1+4)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_local_2:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp1: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi7:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp1+4)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi7)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_local_2:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp1: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi7:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp1+4)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi7)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_local_2:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp1: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi7:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp1+4)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi7)(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  call void asm "lw zero, $0", "*m"(ptr elementtype(i32) getelementptr (i8, ptr blockaddress(@constraint_m_with_local_2, %label), i32 4))
  ret void
}

define void @constraint_m_with_local_3() nounwind {
; RV32I-LABEL: constraint_m_with_local_3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp2: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp2+2000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, %lo(.Ltmp2+2000)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_local_3:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp2: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp2+2000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, %lo(.Ltmp2+2000)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_local_3:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp2: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi8:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp2+2000)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi8)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_local_3:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp2: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi8:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp2+2000)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi8)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_local_3:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp2: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi8:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp2+2000)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi8)(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  call void asm "lw zero, $0", "*m"(ptr elementtype(i32) getelementptr (i8, ptr blockaddress(@constraint_m_with_local_3, %label), i32 2000))
  ret void
}

define void @constraint_m_with_multi_operands() nounwind {
; RV32I-NO-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV32I-NO-INTEGRATED:       # %bb.0:
; RV32I-NO-INTEGRATED-NEXT:    lui a0, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a0); sw zero, %lo(eg)(a0)
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV64I-NO-INTEGRATED:       # %bb.0:
; RV64I-NO-INTEGRATED-NEXT:    lui a0, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a0); sw zero, %lo(eg)(a0)
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi9:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi9)(a0); sw zero, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi9:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi9)(a0); sw zero, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0:
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi9:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a0, %pcrel_hi(.LCPI12_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a0); sw zero, 0(a0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV32I-INTEGRATED:       # %bb.0:
; RV32I-INTEGRATED-NEXT:    lui a0, %hi(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV64I-INTEGRATED:       # %bb.0:
; RV64I-INTEGRATED-NEXT:    lui a0, %hi(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0:
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi9:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0:
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi9:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_m_with_multi_operands:
; RV64I-LARGE-INTEGRATED:       # %bb.0:
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi9:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a0, %pcrel_hi(.LCPI12_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi9)(a0)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:    ret
  call void asm "sw zero, $0; sw zero, $1", "=*m,=*m"(ptr elementtype(i32) @eg, ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_m_with_multi_asm() nounwind {
; RV32I-LABEL: constraint_m_with_multi_asm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_m_with_multi_asm:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_m_with_multi_asm:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi10:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_m_with_multi_asm:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi10:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_m_with_multi_asm:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi10:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI13_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi10)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) @eg)
  call void asm "sw zero, $0", "=*m"(ptr elementtype(i32) @eg)
  ret void
}

define i32 @constraint_m_with_callbr_multi_operands(i32 %a) {
; RV32I-NO-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV32I-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); sw zero, %lo(eg)(a1); beqz a0, .LBB14_2
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-NO-INTEGRATED-NEXT:    ret
; RV32I-NO-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV32I-NO-INTEGRATED-NEXT:    # %fail
; RV32I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV64I-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); sw zero, %lo(eg)(a1); beqz a0, .LBB14_2
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-NO-INTEGRATED-NEXT:    ret
; RV64I-NO-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV64I-NO-INTEGRATED-NEXT:    # %fail
; RV64I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi11:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi11)(a1); sw zero, %pcrel_lo(.Lpcrel_hi11)(a1); beqz a0, .LBB14_2
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi11:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi11)(a1); sw zero, %pcrel_lo(.Lpcrel_hi11)(a1); beqz a0, .LBB14_2
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi11:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI14_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi11)(a1)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB14_2
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV32I-INTEGRATED:       # %bb.0: # %entry
; RV32I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB14_2
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-INTEGRATED-NEXT:    li a0, 0
; RV32I-INTEGRATED-NEXT:    ret
; RV32I-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV32I-INTEGRATED-NEXT:    # %fail
; RV32I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-INTEGRATED-NEXT:    li a0, 1
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV64I-INTEGRATED:       # %bb.0: # %entry
; RV64I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB14_2
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-INTEGRATED-NEXT:    li a0, 0
; RV64I-INTEGRATED-NEXT:    ret
; RV64I-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV64I-INTEGRATED-NEXT:    # %fail
; RV64I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-INTEGRATED-NEXT:    li a0, 1
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi11:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi11)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi11)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB14_2
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV32I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi11:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi11)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi11)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB14_2
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV64I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_m_with_callbr_multi_operands:
; RV64I-LARGE-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi11:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI14_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi11)(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB14_2
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-INTEGRATED-NEXT:    ret
; RV64I-LARGE-INTEGRATED-NEXT:  .LBB14_2: # Block address taken
; RV64I-LARGE-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-INTEGRATED-NEXT:    ret
entry:
  callbr void asm "sw zero, $0; sw zero, $1; beqz $2, $3", "=*m,=*m,r,!i"(ptr elementtype(i32) @eg, ptr elementtype(i32) @eg, i32 %a) to label %normal [label %fail]

normal:
  ret i32 0

fail:
  ret i32 1
}

define i32 @constraint_m_with_multi_callbr_asm(i32 %a) {
; RV32I-NO-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV32I-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB15_3
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB15_3
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-NO-INTEGRATED-NEXT:    ret
; RV32I-NO-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV32I-NO-INTEGRATED-NEXT:    # %fail
; RV32I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV64I-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB15_3
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB15_3
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-NO-INTEGRATED-NEXT:    ret
; RV64I-NO-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV64I-NO-INTEGRATED-NEXT:    # %fail
; RV64I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi12:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1); beqz a0, .LBB15_3
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1); beqz a0, .LBB15_3
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi12:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1); beqz a0, .LBB15_3
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1); beqz a0, .LBB15_3
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi12:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI15_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi12)(a1)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB15_3
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB15_3
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV32I-INTEGRATED:       # %bb.0: # %entry
; RV32I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-INTEGRATED-NEXT:    li a0, 0
; RV32I-INTEGRATED-NEXT:    ret
; RV32I-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV32I-INTEGRATED-NEXT:    # %fail
; RV32I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-INTEGRATED-NEXT:    li a0, 1
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV64I-INTEGRATED:       # %bb.0: # %entry
; RV64I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-INTEGRATED-NEXT:    li a0, 0
; RV64I-INTEGRATED-NEXT:    ret
; RV64I-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV64I-INTEGRATED-NEXT:    # %fail
; RV64I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-INTEGRATED-NEXT:    li a0, 1
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi12:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV32I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi12:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi12)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV64I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_m_with_multi_callbr_asm:
; RV64I-LARGE-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi12:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI15_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi12)(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB15_3
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-INTEGRATED-NEXT:    ret
; RV64I-LARGE-INTEGRATED-NEXT:  .LBB15_3: # Block address taken
; RV64I-LARGE-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-INTEGRATED-NEXT:    ret
entry:
  callbr void asm "sw zero, $0; beqz $1, $2", "=*m,r,!i"(ptr elementtype(i32) @eg, i32 %a) to label %normal0 [label %fail]

normal0:
  callbr void asm "sw zero, $0; beqz $1, $2", "=*m,r,!i"(ptr elementtype(i32) @eg, i32 %a) to label %normal1 [label %fail]

normal1:
  ret i32 0

fail:
  ret i32 1
}

define void @constraint_o_1(ptr %a) nounwind {
; RV32I-LABEL: constraint_o_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm sideeffect "", "=*o"(ptr elementtype(i32) %a)
  ret void
}

define i32 @constraint_o_2(ptr %a) nounwind {
; RV32I-LABEL: constraint_o_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw a0, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  %1 = tail call i32 asm "lw $0, $1", "=r,*o"(ptr elementtype(i32) %a)
  ret i32 %1
}

define i32 @constraint_o_with_offset(ptr %a) nounwind {
; RV32I-LABEL: constraint_o_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 4(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 4(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_offset:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_offset:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_offset:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw a0, 4(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 1
  %2 = tail call i32 asm "lw $0, $1", "=r,*o"(ptr elementtype(i32) %1)
  ret i32 %2
}

define void @constraint_o_with_global_1() nounwind {
; RV32I-LABEL: constraint_o_with_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi13:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi13)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi13:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi13)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_global_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi13:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI19_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi13)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_o_with_global_2() nounwind {
; RV32I-LABEL: constraint_o_with_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg+4)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg+4)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi14:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+4)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi14)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi14:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+4)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi14)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_global_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi14:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI20_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi14)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 4(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @eg, i32 0, i32 1))
  ret void
}

define void @constraint_o_with_global_3() nounwind {
; RV32I-LABEL: constraint_o_with_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg+8000)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg+8000)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi15:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi15)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi15:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi15)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_global_3:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi15:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI21_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi15)(a0)
; RV64I-LARGE-NEXT:    lui a1, 2
; RV64I-LARGE-NEXT:    addiw a1, a1, -192
; RV64I-LARGE-NEXT:    add a0, a0, a1
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @eg, i32 0, i32 2000))
  ret void
}

define void @constraint_o_with_extern_weak_global_1() nounwind {
; RV32I-LABEL: constraint_o_with_extern_weak_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_extern_weak_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi16:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi16)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi16:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi16)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_extern_weak_global_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi16:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI22_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi16)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) @ewg)
  ret void
}

define void @constraint_o_with_extern_weak_global_2() nounwind {
; RV32I-LABEL: constraint_o_with_extern_weak_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg+4)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_extern_weak_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg+4)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi17:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi17)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi17:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi17)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 4(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_extern_weak_global_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi17:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI23_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi17)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 4(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @ewg, i32 0, i32 1))
  ret void
}

define void @constraint_o_with_extern_weak_global_3() nounwind {
; RV32I-LABEL: constraint_o_with_extern_weak_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(ewg+8000)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_extern_weak_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(ewg+8000)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi18:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi18)(a0)
; RV32I-MEDIUM-NEXT:    lui a1, 2
; RV32I-MEDIUM-NEXT:    addi a1, a1, -192
; RV32I-MEDIUM-NEXT:    add a0, a0, a1
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_extern_weak_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi18:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi18)(a0)
; RV64I-MEDIUM-NEXT:    lui a1, 2
; RV64I-MEDIUM-NEXT:    addiw a1, a1, -192
; RV64I-MEDIUM-NEXT:    add a0, a0, a1
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_extern_weak_global_3:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi18:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI24_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi18)(a0)
; RV64I-LARGE-NEXT:    lui a1, 2
; RV64I-LARGE-NEXT:    addiw a1, a1, -192
; RV64I-LARGE-NEXT:    add a0, a0, a1
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @ewg, i32 0, i32 2000))
  ret void
}

define void @constraint_o_with_multi_asm() nounwind {
; RV32I-LABEL: constraint_o_with_multi_asm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, %lo(eg)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_multi_asm:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, %lo(eg)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_multi_asm:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi19:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi19)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi19)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_multi_asm:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi19:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi19)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi19)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_multi_asm:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi19:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI25_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi19)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) @eg)
  call void asm "sw zero, $0", "=*o"(ptr elementtype(i32) @eg)
  ret void
}

define i32 @constraint_o_with_callbr_multi_operands(i32 %a) {
; RV32I-NO-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV32I-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); sw zero, %lo(eg)(a1); beqz a0, .LBB26_2
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-NO-INTEGRATED-NEXT:    ret
; RV32I-NO-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV32I-NO-INTEGRATED-NEXT:    # %fail
; RV32I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV64I-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); sw zero, %lo(eg)(a1); beqz a0, .LBB26_2
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-NO-INTEGRATED-NEXT:    ret
; RV64I-NO-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV64I-NO-INTEGRATED-NEXT:    # %fail
; RV64I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi20:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi20)(a1); sw zero, %pcrel_lo(.Lpcrel_hi20)(a1); beqz a0, .LBB26_2
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi20:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi20)(a1); sw zero, %pcrel_lo(.Lpcrel_hi20)(a1); beqz a0, .LBB26_2
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi20:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI26_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi20)(a1)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB26_2
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV32I-INTEGRATED:       # %bb.0: # %entry
; RV32I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB26_2
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-INTEGRATED-NEXT:    li a0, 0
; RV32I-INTEGRATED-NEXT:    ret
; RV32I-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV32I-INTEGRATED-NEXT:    # %fail
; RV32I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-INTEGRATED-NEXT:    li a0, 1
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV64I-INTEGRATED:       # %bb.0: # %entry
; RV64I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB26_2
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-INTEGRATED-NEXT:    li a0, 0
; RV64I-INTEGRATED-NEXT:    ret
; RV64I-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV64I-INTEGRATED-NEXT:    # %fail
; RV64I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-INTEGRATED-NEXT:    li a0, 1
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi20:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi20)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi20)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB26_2
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV32I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi20:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi20)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi20)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB26_2
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV64I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_o_with_callbr_multi_operands:
; RV64I-LARGE-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi20:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI26_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi20)(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB26_2
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-INTEGRATED-NEXT:    ret
; RV64I-LARGE-INTEGRATED-NEXT:  .LBB26_2: # Block address taken
; RV64I-LARGE-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-INTEGRATED-NEXT:    ret
entry:
  callbr void asm "sw zero, $0; sw zero, $1; beqz $2, $3", "=*m,=*m,r,!i"(ptr elementtype(i32) @eg, ptr elementtype(i32) @eg, i32 %a) to label %normal [label %fail]

normal:
  ret i32 0

fail:
  ret i32 1
}

define i32 @constraint_o_with_multi_callbr_asm(i32 %a) {
; RV32I-NO-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV32I-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB27_3
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB27_3
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-NO-INTEGRATED-NEXT:    ret
; RV32I-NO-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV32I-NO-INTEGRATED-NEXT:    # %fail
; RV32I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV64I-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB27_3
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1); beqz a0, .LBB27_3
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-NO-INTEGRATED-NEXT:    ret
; RV64I-NO-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV64I-NO-INTEGRATED-NEXT:    # %fail
; RV64I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi21:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1); beqz a0, .LBB27_3
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1); beqz a0, .LBB27_3
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi21:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1); beqz a0, .LBB27_3
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1); beqz a0, .LBB27_3
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi21:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI27_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi21)(a1)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB27_3
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB27_3
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV32I-INTEGRATED:       # %bb.0: # %entry
; RV32I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-INTEGRATED-NEXT:    li a0, 0
; RV32I-INTEGRATED-NEXT:    ret
; RV32I-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV32I-INTEGRATED-NEXT:    # %fail
; RV32I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-INTEGRATED-NEXT:    li a0, 1
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV64I-INTEGRATED:       # %bb.0: # %entry
; RV64I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, %lo(eg)(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-INTEGRATED-NEXT:    li a0, 0
; RV64I-INTEGRATED-NEXT:    ret
; RV64I-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV64I-INTEGRATED-NEXT:    # %fail
; RV64I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-INTEGRATED-NEXT:    li a0, 1
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi21:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV32I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi21:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, %pcrel_lo(.Lpcrel_hi21)(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV64I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_o_with_multi_callbr_asm:
; RV64I-LARGE-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi21:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI27_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi21)(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB27_3
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-INTEGRATED-NEXT:    ret
; RV64I-LARGE-INTEGRATED-NEXT:  .LBB27_3: # Block address taken
; RV64I-LARGE-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-INTEGRATED-NEXT:    ret
entry:
  callbr void asm "sw zero, $0; beqz $1, $2", "=*o,r,!i"(ptr elementtype(i32) @eg, i32 %a) to label %normal0 [label %fail]

normal0:
  callbr void asm "sw zero, $0; beqz $1, $2", "=*o,r,!i"(ptr elementtype(i32) @eg, i32 %a) to label %normal1 [label %fail]

normal1:
  ret i32 0

fail:
  ret i32 1
}

define void @constraint_o_with_local_1() nounwind {
; RV32I-LABEL: constraint_o_with_local_1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp3: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp3)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, %lo(.Ltmp3)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_local_1:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp3: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp3)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, %lo(.Ltmp3)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_local_1:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp3: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi22:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp3)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi22)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_local_1:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp3: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi22:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp3)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi22)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_local_1:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp3: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi22:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp3)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi22)(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  tail call void asm sideeffect "lw zero, $0", "*o"(ptr elementtype(ptr) blockaddress(@constraint_o_with_local_1, %label))
  ret void
}

define void @constraint_o_with_local_2() nounwind {
; RV32I-LABEL: constraint_o_with_local_2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp4: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp4+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, %lo(.Ltmp4+4)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_local_2:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp4: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp4+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, %lo(.Ltmp4+4)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_local_2:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp4: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi23:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp4+4)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi23)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_local_2:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp4: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi23:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp4+4)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi23)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_local_2:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp4: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi23:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp4+4)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi23)(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  call void asm "lw zero, $0", "*o"(ptr elementtype(i32) getelementptr (i8, ptr blockaddress(@constraint_o_with_local_2, %label), i32 4))
  ret void
}

define void @constraint_o_with_local_3() nounwind {
; RV32I-LABEL: constraint_o_with_local_3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp5: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp5+2000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, %lo(.Ltmp5+2000)(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_o_with_local_3:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp5: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp5+2000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, %lo(.Ltmp5+2000)(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_o_with_local_3:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp5: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi24:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp5+2000)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi24)(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_o_with_local_3:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp5: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi24:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp5+2000)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi24)(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_o_with_local_3:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp5: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi24:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp5+2000)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, %pcrel_lo(.Lpcrel_hi24)(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  call void asm "lw zero, $0", "*o"(ptr elementtype(i32) getelementptr (i8, ptr blockaddress(@constraint_o_with_local_3, %label), i32 2000))
  ret void
}

define void @constraint_A(ptr %a) nounwind {
; RV32I-LABEL: constraint_A:
; RV32I:       # %bb.0:
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sb s0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lb s1, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A:
; RV64I:       # %bb.0:
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sb s0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lb s1, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sb s0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lb s1, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sb s0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lb s1, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sb s0, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lb s1, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  tail call void asm sideeffect "sb s0, $0", "*A"(ptr elementtype(i8) %a)
  tail call void asm sideeffect "lb s1, $0", "*A"(ptr elementtype(i8) %a)
  ret void
}

define i32 @constraint_A_with_offset(ptr %a) nounwind {
; RV32I-LABEL: constraint_A_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 4
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw a0, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 4
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw a0, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_offset:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:    addi a0, a0, 4
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_offset:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:    addi a0, a0, 4
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw a0, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_offset:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:    addi a0, a0, 4
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw a0, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  %1 = getelementptr i32, ptr %a, i32 1
  %2 = tail call i32 asm "lw $0, $1", "=r,*A"(ptr elementtype(i32) %1)
  ret i32 %2
}

define void @constraint_A_with_global_1() nounwind {
; RV32I-LABEL: constraint_A_with_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    addi a0, a0, %lo(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    addi a0, a0, %lo(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi25:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi25)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi25:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi25)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_global_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi25:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI33_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi25)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) @eg)
  ret void
}

define void @constraint_A_with_global_2() nounwind {
; RV32I-LABEL: constraint_A_with_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+4)
; RV32I-NEXT:    addi a0, a0, %lo(eg+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+4)
; RV64I-NEXT:    addi a0, a0, %lo(eg+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi26:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+4)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi26)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi26:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+4)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi26)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_global_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi26:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI34_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi26)(a0)
; RV64I-LARGE-NEXT:    addi a0, a0, 4
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @eg, i32 0, i32 1))
  ret void
}

define void @constraint_A_with_global_3() nounwind {
; RV32I-LABEL: constraint_A_with_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg+8000)
; RV32I-NEXT:    addi a0, a0, %lo(eg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg+8000)
; RV64I-NEXT:    addi a0, a0, %lo(eg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi27:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi27)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi27:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg+8000)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi27)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_global_3:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi27:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI35_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi27)(a0)
; RV64I-LARGE-NEXT:    lui a1, 2
; RV64I-LARGE-NEXT:    addiw a1, a1, -192
; RV64I-LARGE-NEXT:    add a0, a0, a1
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @eg, i32 0, i32 2000))
  ret void
}

define void @constraint_A_with_extern_weak_global_1() nounwind {
; RV32I-LABEL: constraint_A_with_extern_weak_global_1:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg)
; RV32I-NEXT:    addi a0, a0, %lo(ewg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_extern_weak_global_1:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg)
; RV64I-NEXT:    addi a0, a0, %lo(ewg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_extern_weak_global_1:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi28:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi28)(a0)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_extern_weak_global_1:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi28:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi28)(a0)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_extern_weak_global_1:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi28:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI36_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi28)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) @ewg)
  ret void
}

define void @constraint_A_with_extern_weak_global_2() nounwind {
; RV32I-LABEL: constraint_A_with_extern_weak_global_2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+4)
; RV32I-NEXT:    addi a0, a0, %lo(ewg+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_extern_weak_global_2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+4)
; RV64I-NEXT:    addi a0, a0, %lo(ewg+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_extern_weak_global_2:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi29:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi29)(a0)
; RV32I-MEDIUM-NEXT:    addi a0, a0, 4
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_extern_weak_global_2:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi29:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi29)(a0)
; RV64I-MEDIUM-NEXT:    addi a0, a0, 4
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_extern_weak_global_2:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi29:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI37_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi29)(a0)
; RV64I-LARGE-NEXT:    addi a0, a0, 4
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @ewg, i32 0, i32 1))
  ret void
}

define void @constraint_A_with_extern_weak_global_3() nounwind {
; RV32I-LABEL: constraint_A_with_extern_weak_global_3:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(ewg+8000)
; RV32I-NEXT:    addi a0, a0, %lo(ewg+8000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_extern_weak_global_3:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(ewg+8000)
; RV64I-NEXT:    addi a0, a0, %lo(ewg+8000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_extern_weak_global_3:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi30:
; RV32I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV32I-MEDIUM-NEXT:    lw a0, %pcrel_lo(.Lpcrel_hi30)(a0)
; RV32I-MEDIUM-NEXT:    lui a1, 2
; RV32I-MEDIUM-NEXT:    addi a1, a1, -192
; RV32I-MEDIUM-NEXT:    add a0, a0, a1
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_extern_weak_global_3:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi30:
; RV64I-MEDIUM-NEXT:    auipc a0, %got_pcrel_hi(ewg)
; RV64I-MEDIUM-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi30)(a0)
; RV64I-MEDIUM-NEXT:    lui a1, 2
; RV64I-MEDIUM-NEXT:    addiw a1, a1, -192
; RV64I-MEDIUM-NEXT:    add a0, a0, a1
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_extern_weak_global_3:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi30:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI38_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi30)(a0)
; RV64I-LARGE-NEXT:    lui a1, 2
; RV64I-LARGE-NEXT:    addiw a1, a1, -192
; RV64I-LARGE-NEXT:    add a0, a0, a1
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) getelementptr ([400000 x i32], ptr @ewg, i32 0, i32 2000))
  ret void
}

define void @constraint_A_with_multi_asm() nounwind {
; RV32I-LABEL: constraint_A_with_multi_asm:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, %hi(eg)
; RV32I-NEXT:    addi a0, a0, %lo(eg)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    #APP
; RV32I-NEXT:    sw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_multi_asm:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, %hi(eg)
; RV64I-NEXT:    addi a0, a0, %lo(eg)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    #APP
; RV64I-NEXT:    sw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_multi_asm:
; RV32I-MEDIUM:       # %bb.0:
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi31:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi31)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_multi_asm:
; RV64I-MEDIUM:       # %bb.0:
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi31:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(eg)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi31)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    sw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_multi_asm:
; RV64I-LARGE:       # %bb.0:
; RV64I-LARGE-NEXT:  .Lpcrel_hi31:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI39_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi31)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    sw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) @eg)
  call void asm "sw zero, $0", "=*A"(ptr elementtype(i32) @eg)
  ret void
}

define i32 @constraint_A_with_callbr_multi_operands(i32 %a) {
; RV32I-NO-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV32I-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB40_2
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-NO-INTEGRATED-NEXT:    ret
; RV32I-NO-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV32I-NO-INTEGRATED-NEXT:    # %fail
; RV32I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV64I-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB40_2
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-NO-INTEGRATED-NEXT:    ret
; RV64I-NO-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV64I-NO-INTEGRATED-NEXT:    # %fail
; RV64I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi32:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi32)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB40_2
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi32:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi32)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB40_2
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi32:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI40_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi32)(a1)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); sw zero, 0(a1); beqz a0, .LBB40_2
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV32I-INTEGRATED:       # %bb.0: # %entry
; RV32I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB40_2
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-INTEGRATED-NEXT:    li a0, 0
; RV32I-INTEGRATED-NEXT:    ret
; RV32I-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV32I-INTEGRATED-NEXT:    # %fail
; RV32I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-INTEGRATED-NEXT:    li a0, 1
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV64I-INTEGRATED:       # %bb.0: # %entry
; RV64I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB40_2
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-INTEGRATED-NEXT:    li a0, 0
; RV64I-INTEGRATED-NEXT:    ret
; RV64I-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV64I-INTEGRATED-NEXT:    # %fail
; RV64I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-INTEGRATED-NEXT:    li a0, 1
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi32:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi32)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB40_2
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV32I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi32:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi32)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB40_2
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV64I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_A_with_callbr_multi_operands:
; RV64I-LARGE-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi32:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI40_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi32)(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB40_2
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.1: # %normal
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-INTEGRATED-NEXT:    ret
; RV64I-LARGE-INTEGRATED-NEXT:  .LBB40_2: # Block address taken
; RV64I-LARGE-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-INTEGRATED-NEXT:    ret
entry:
  callbr void asm "sw zero, $0; sw zero, $1; beqz $2, $3", "*A,*A,r,!i"(ptr elementtype(i32) @eg, ptr elementtype(i32) @eg, i32 %a) to label %normal [label %fail]

normal:
  ret i32 0

fail:
  ret i32 1
}

define i32 @constraint_A_with_multi_callbr_asm(i32 %a) {
; RV32I-NO-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV32I-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-NO-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-NO-INTEGRATED-NEXT:    #APP
; RV32I-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV32I-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-NO-INTEGRATED-NEXT:    ret
; RV32I-NO-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV32I-NO-INTEGRATED-NEXT:    # %fail
; RV32I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-NO-INTEGRATED-NEXT:    ret
;
; RV64I-NO-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV64I-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-NO-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-NO-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-NO-INTEGRATED-NEXT:    #APP
; RV64I-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV64I-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-NO-INTEGRATED-NEXT:    ret
; RV64I-NO-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV64I-NO-INTEGRATED-NEXT:    # %fail
; RV64I-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-NO-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-NO-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV32I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi33:
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi33)
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-NO-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV64I-MEDIUM-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .Lpcrel_hi33:
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi33)
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-NO-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-NO-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV64I-LARGE-NO-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .Lpcrel_hi33:
; RV64I-LARGE-NO-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI41_0)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi33)(a1)
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:    sw zero, 0(a1); beqz a0, .LBB41_3
; RV64I-LARGE-NO-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-NO-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
; RV64I-LARGE-NO-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-NO-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-NO-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-NO-INTEGRATED-NEXT:    ret
;
; RV32I-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV32I-INTEGRATED:       # %bb.0: # %entry
; RV32I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV32I-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-INTEGRATED-NEXT:    #APP
; RV32I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV32I-INTEGRATED-NEXT:    #NO_APP
; RV32I-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-INTEGRATED-NEXT:    li a0, 0
; RV32I-INTEGRATED-NEXT:    ret
; RV32I-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV32I-INTEGRATED-NEXT:    # %fail
; RV32I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-INTEGRATED-NEXT:    li a0, 1
; RV32I-INTEGRATED-NEXT:    ret
;
; RV64I-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV64I-INTEGRATED:       # %bb.0: # %entry
; RV64I-INTEGRATED-NEXT:    lui a1, %hi(eg)
; RV64I-INTEGRATED-NEXT:    addi a1, a1, %lo(eg)
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-INTEGRATED-NEXT:    #APP
; RV64I-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV64I-INTEGRATED-NEXT:    #NO_APP
; RV64I-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-INTEGRATED-NEXT:    li a0, 0
; RV64I-INTEGRATED-NEXT:    ret
; RV64I-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV64I-INTEGRATED-NEXT:    # %fail
; RV64I-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-INTEGRATED-NEXT:    li a0, 1
; RV64I-INTEGRATED-NEXT:    ret
;
; RV32I-MEDIUM-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV32I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV32I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi33:
; RV32I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV32I-MEDIUM-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi33)
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV32I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV32I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV32I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV32I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV32I-MEDIUM-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
; RV32I-MEDIUM-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV32I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV32I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV32I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV32I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-MEDIUM-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV64I-MEDIUM-INTEGRATED:       # %bb.0: # %entry
; RV64I-MEDIUM-INTEGRATED-NEXT:  .Lpcrel_hi33:
; RV64I-MEDIUM-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(eg)
; RV64I-MEDIUM-INTEGRATED-NEXT:    addi a1, a1, %pcrel_lo(.Lpcrel_hi33)
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-MEDIUM-INTEGRATED-NEXT:    #APP
; RV64I-MEDIUM-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-MEDIUM-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV64I-MEDIUM-INTEGRATED-NEXT:    #NO_APP
; RV64I-MEDIUM-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 0
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
; RV64I-MEDIUM-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV64I-MEDIUM-INTEGRATED-NEXT:    # %fail
; RV64I-MEDIUM-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-MEDIUM-INTEGRATED-NEXT:    li a0, 1
; RV64I-MEDIUM-INTEGRATED-NEXT:    ret
;
; RV64I-LARGE-INTEGRATED-LABEL: constraint_A_with_multi_callbr_asm:
; RV64I-LARGE-INTEGRATED:       # %bb.0: # %entry
; RV64I-LARGE-INTEGRATED-NEXT:  .Lpcrel_hi33:
; RV64I-LARGE-INTEGRATED-NEXT:    auipc a1, %pcrel_hi(.LCPI41_0)
; RV64I-LARGE-INTEGRATED-NEXT:    ld a1, %pcrel_lo(.Lpcrel_hi33)(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.1: # %normal0
; RV64I-LARGE-INTEGRATED-NEXT:    #APP
; RV64I-LARGE-INTEGRATED-NEXT:    sw zero, 0(a1)
; RV64I-LARGE-INTEGRATED-NEXT:    beqz a0, .LBB41_3
; RV64I-LARGE-INTEGRATED-NEXT:    #NO_APP
; RV64I-LARGE-INTEGRATED-NEXT:  # %bb.2: # %normal1
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 0
; RV64I-LARGE-INTEGRATED-NEXT:    ret
; RV64I-LARGE-INTEGRATED-NEXT:  .LBB41_3: # Block address taken
; RV64I-LARGE-INTEGRATED-NEXT:    # %fail
; RV64I-LARGE-INTEGRATED-NEXT:    # Label of block must be emitted
; RV64I-LARGE-INTEGRATED-NEXT:    li a0, 1
; RV64I-LARGE-INTEGRATED-NEXT:    ret
entry:
  callbr void asm "sw zero, $0; beqz $1, $2", "=*A,r,!i"(ptr elementtype(i32) @eg, i32 %a) to label %normal0 [label %fail]

normal0:
  callbr void asm "sw zero, $0; beqz $1, $2", "=*A,r,!i"(ptr elementtype(i32) @eg, i32 %a) to label %normal1 [label %fail]

normal1:
  ret i32 0

fail:
  ret i32 1
}

define void @constraint_A_with_local_1() nounwind {
; RV32I-LABEL: constraint_A_with_local_1:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp6: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp6)
; RV32I-NEXT:    addi a0, a0, %lo(.Ltmp6)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_local_1:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp6: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp6)
; RV64I-NEXT:    addi a0, a0, %lo(.Ltmp6)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_local_1:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp6: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi34:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp6)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi34)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_local_1:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp6: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi34:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp6)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi34)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_local_1:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp6: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi34:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp6)
; RV64I-LARGE-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi34)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  tail call void asm sideeffect "lw zero, $0", "*A"(ptr elementtype(ptr) blockaddress(@constraint_A_with_local_1, %label))
  ret void
}

define void @constraint_A_with_local_2() nounwind {
; RV32I-LABEL: constraint_A_with_local_2:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp7: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp7+4)
; RV32I-NEXT:    addi a0, a0, %lo(.Ltmp7+4)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_local_2:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp7: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp7+4)
; RV64I-NEXT:    addi a0, a0, %lo(.Ltmp7+4)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_local_2:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp7: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi35:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp7+4)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi35)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_local_2:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp7: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi35:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp7+4)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi35)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_local_2:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp7: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi35:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp7+4)
; RV64I-LARGE-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi35)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  call void asm "lw zero, $0", "*A"(ptr elementtype(i32) getelementptr (i8, ptr blockaddress(@constraint_A_with_local_2, %label), i32 4))
  ret void
}

define void @constraint_A_with_local_3() nounwind {
; RV32I-LABEL: constraint_A_with_local_3:
; RV32I:       # %bb.0: # %entry
; RV32I-NEXT:  .Ltmp8: # Block address taken
; RV32I-NEXT:  # %bb.1: # %label
; RV32I-NEXT:    lui a0, %hi(.Ltmp8+2000)
; RV32I-NEXT:    addi a0, a0, %lo(.Ltmp8+2000)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    lw zero, 0(a0)
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: constraint_A_with_local_3:
; RV64I:       # %bb.0: # %entry
; RV64I-NEXT:  .Ltmp8: # Block address taken
; RV64I-NEXT:  # %bb.1: # %label
; RV64I-NEXT:    lui a0, %hi(.Ltmp8+2000)
; RV64I-NEXT:    addi a0, a0, %lo(.Ltmp8+2000)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    lw zero, 0(a0)
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: constraint_A_with_local_3:
; RV32I-MEDIUM:       # %bb.0: # %entry
; RV32I-MEDIUM-NEXT:  .Ltmp8: # Block address taken
; RV32I-MEDIUM-NEXT:  # %bb.1: # %label
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi36:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp8+2000)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi36)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    lw zero, 0(a0)
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: constraint_A_with_local_3:
; RV64I-MEDIUM:       # %bb.0: # %entry
; RV64I-MEDIUM-NEXT:  .Ltmp8: # Block address taken
; RV64I-MEDIUM-NEXT:  # %bb.1: # %label
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi36:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(.Ltmp8+2000)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi36)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    lw zero, 0(a0)
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: constraint_A_with_local_3:
; RV64I-LARGE:       # %bb.0: # %entry
; RV64I-LARGE-NEXT:  .Ltmp8: # Block address taken
; RV64I-LARGE-NEXT:  # %bb.1: # %label
; RV64I-LARGE-NEXT:  .Lpcrel_hi36:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.Ltmp8+2000)
; RV64I-LARGE-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi36)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    lw zero, 0(a0)
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
entry:
  br label %label

label:
  call void asm "lw zero, $0", "*A"(ptr elementtype(i32) getelementptr (i8, ptr blockaddress(@constraint_A_with_local_3, %label), i32 2000))
  ret void
}

@_ZN5repro9MY_BUFFER17hb0f674501d5980a6E = external global <{ [16 x i8] }>

; Address is not used by a memory constraint.
define void @should_not_fold() {
; RV32I-LABEL: should_not_fold:
; RV32I:       # %bb.0: # %start
; RV32I-NEXT:    lui a0, %hi(_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
; RV32I-NEXT:    addi a0, a0, %lo(_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
; RV32I-NEXT:    #APP
; RV32I-NEXT:    ecall
; RV32I-NEXT:    #NO_APP
; RV32I-NEXT:    ret
;
; RV64I-LABEL: should_not_fold:
; RV64I:       # %bb.0: # %start
; RV64I-NEXT:    lui a0, %hi(_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
; RV64I-NEXT:    addi a0, a0, %lo(_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
; RV64I-NEXT:    #APP
; RV64I-NEXT:    ecall
; RV64I-NEXT:    #NO_APP
; RV64I-NEXT:    ret
;
; RV32I-MEDIUM-LABEL: should_not_fold:
; RV32I-MEDIUM:       # %bb.0: # %start
; RV32I-MEDIUM-NEXT:  .Lpcrel_hi37:
; RV32I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
; RV32I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi37)
; RV32I-MEDIUM-NEXT:    #APP
; RV32I-MEDIUM-NEXT:    ecall
; RV32I-MEDIUM-NEXT:    #NO_APP
; RV32I-MEDIUM-NEXT:    ret
;
; RV64I-MEDIUM-LABEL: should_not_fold:
; RV64I-MEDIUM:       # %bb.0: # %start
; RV64I-MEDIUM-NEXT:  .Lpcrel_hi37:
; RV64I-MEDIUM-NEXT:    auipc a0, %pcrel_hi(_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
; RV64I-MEDIUM-NEXT:    addi a0, a0, %pcrel_lo(.Lpcrel_hi37)
; RV64I-MEDIUM-NEXT:    #APP
; RV64I-MEDIUM-NEXT:    ecall
; RV64I-MEDIUM-NEXT:    #NO_APP
; RV64I-MEDIUM-NEXT:    ret
;
; RV64I-LARGE-LABEL: should_not_fold:
; RV64I-LARGE:       # %bb.0: # %start
; RV64I-LARGE-NEXT:  .Lpcrel_hi37:
; RV64I-LARGE-NEXT:    auipc a0, %pcrel_hi(.LCPI45_0)
; RV64I-LARGE-NEXT:    ld a0, %pcrel_lo(.Lpcrel_hi37)(a0)
; RV64I-LARGE-NEXT:    #APP
; RV64I-LARGE-NEXT:    ecall
; RV64I-LARGE-NEXT:    #NO_APP
; RV64I-LARGE-NEXT:    ret
start:
  %0 = tail call ptr asm sideeffect alignstack "ecall", "=&{x10},0,~{vtype},~{vl},~{vxsat},~{vxrm},~{memory}"(ptr @_ZN5repro9MY_BUFFER17hb0f674501d5980a6E)
  ret void
}
