; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=SMALL-DATA
; RUN: llc -mtriple=riscv64 -global-merge-min-data-size=0 -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=MINSIZE

@ig1 = internal global i32 0, align 4
@ig2 = internal global i32 0, align 4

@eg1 = dso_local global i32 0, align 4
@eg2 = dso_local global i32 0, align 4

; This test shows that GlobalDataMinSize is set to SmallDataLimit + 1 when
; SmallDataLimit module flag is set as non-zero, and that global-merge-min-data-size
; overrides the small data limit.

define void @f1(i32 %a) nounwind {
; SMALL-DATA-LABEL: f1:
; SMALL-DATA:       # %bb.0:
; SMALL-DATA-NEXT:    lui a1, %hi(ig1)
; SMALL-DATA-NEXT:    sw a0, %lo(ig1)(a1)
; SMALL-DATA-NEXT:    lui a1, %hi(ig2)
; SMALL-DATA-NEXT:    sw a0, %lo(ig2)(a1)
; SMALL-DATA-NEXT:    lui a1, %hi(eg1)
; SMALL-DATA-NEXT:    sw a0, %lo(eg1)(a1)
; SMALL-DATA-NEXT:    lui a1, %hi(eg2)
; SMALL-DATA-NEXT:    sw a0, %lo(eg2)(a1)
; SMALL-DATA-NEXT:    ret
;
; MINSIZE-LABEL: f1:
; MINSIZE:       # %bb.0:
; MINSIZE-NEXT:    lui a1, %hi(.L_MergedGlobals)
; MINSIZE-NEXT:    sw a0, %lo(.L_MergedGlobals)(a1)
; MINSIZE-NEXT:    addi a1, a1, %lo(.L_MergedGlobals)
; MINSIZE-NEXT:    sw a0, 4(a1)
; MINSIZE-NEXT:    sw a0, 8(a1)
; MINSIZE-NEXT:    sw a0, 12(a1)
; MINSIZE-NEXT:    ret
  store i32 %a, ptr @ig1, align 4
  store i32 %a, ptr @ig2, align 4
  store i32 %a, ptr @eg1, align 4
  store i32 %a, ptr @eg2, align 4
  ret void
}


!llvm.module.flags = !{!0}
!0 = !{i32 8, !"SmallDataLimit", i32 8}
