; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=correlated-propagation -S | FileCheck %s

declare void @use.f32(float)

define void @test1(i32 %n) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[N:%.*]], -1
; CHECK-NEXT:    br i1 [[CMP]], label [[BB:%.*]], label [[EXIT:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[EXT_WIDE:%.*]] = uitofp nneg i32 [[N]] to float
; CHECK-NEXT:    call void @use.f32(float [[EXT_WIDE]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sgt i32 %n, -1
  br i1 %cmp, label %bb, label %exit

bb:
  %ext.wide = uitofp i32 %n to float
  call void @use.f32(float %ext.wide)
  br label %exit

exit:
  ret void
}

define void @test2_fail(i32 %n) {
; CHECK-LABEL: @test2_fail(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[N:%.*]], -2
; CHECK-NEXT:    br i1 [[CMP]], label [[BB:%.*]], label [[EXIT:%.*]]
; CHECK:       bb:
; CHECK-NEXT:    [[EXT_WIDE:%.*]] = uitofp i32 [[N]] to float
; CHECK-NEXT:    call void @use.f32(float [[EXT_WIDE]])
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %cmp = icmp sgt i32 %n, -2
  br i1 %cmp, label %bb, label %exit

bb:
  %ext.wide = uitofp i32 %n to float
  call void @use.f32(float %ext.wide)
  br label %exit

exit:
  ret void
}

define float @may_including_undef(i1 %c.1, i1 %c.2) {
; CHECK-LABEL: @may_including_undef(
; CHECK-NEXT:    br i1 [[C_1:%.*]], label [[TRUE_1:%.*]], label [[FALSE:%.*]]
; CHECK:       true.1:
; CHECK-NEXT:    br i1 [[C_2:%.*]], label [[TRUE_2:%.*]], label [[EXIT:%.*]]
; CHECK:       true.2:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       false:
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ 0, [[TRUE_1]] ], [ 1, [[TRUE_2]] ], [ undef, [[FALSE]] ]
; CHECK-NEXT:    [[EXT:%.*]] = uitofp i32 [[P]] to float
; CHECK-NEXT:    ret float [[EXT]]
;
  br i1 %c.1, label %true.1, label %false

true.1:
  br i1 %c.2, label %true.2, label %exit

true.2:
  br label %exit

false:
  br label %exit

exit:
  %p = phi i32 [ 0, %true.1 ], [ 1, %true.2], [ undef, %false ]
  %ext = uitofp i32 %p to float
  ret float %ext
}

define double @test_infer_at_use(i32 noundef %n) {
; CHECK-LABEL: @test_infer_at_use(
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i32 [[N:%.*]], -1
; CHECK-NEXT:    [[EXT:%.*]] = uitofp nneg i32 [[N]] to double
; CHECK-NEXT:    [[SELECT:%.*]] = select i1 [[CMP]], double [[EXT]], double 0.000000e+00
; CHECK-NEXT:    ret double [[SELECT]]
;
  %cmp = icmp sgt i32 %n, -1
  %ext = uitofp i32 %n to double
  %select = select i1 %cmp, double %ext, double 0.0
  ret double %select
}
