; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 2
; RUN: opt -passes=inline -S < %s | FileCheck %s
target datalayout = "e-p:64:64:64-i1:8:8-i8:8:8-i16:16:16-i32:32:32-i64:64:64-f32:32:32-f64:64:64-v64:64:64-v128:128:128-a0:0:64-s0:64:64-f80:128:128-n8:16:32:64-S128"

declare void @llvm.lifetime.start.p0(i64, ptr)
declare void @llvm.lifetime.end.p0(i64, ptr)

define void @helper_both_markers() {
; CHECK-LABEL: define void @helper_both_markers() {
; CHECK-NEXT:    [[A:%.*]] = alloca i8, align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 2, ptr [[A]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 2, ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i8
  ; Size in llvm.lifetime.start / llvm.lifetime.end differs from
  ; allocation size. We should use the former.
  call void @llvm.lifetime.start.p0(i64 2, ptr %a)
  call void @llvm.lifetime.end.p0(i64 2, ptr %a)
  ret void
}

define void @test_both_markers() {
; CHECK-LABEL: define void @test_both_markers() {
; CHECK-NEXT:    [[A_I1:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[A_I:%.*]] = alloca i8, align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 2, ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 2, ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 2, ptr [[A_I1]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 2, ptr [[A_I1]])
; CHECK-NEXT:    ret void
;
  call void @helper_both_markers()
  call void @helper_both_markers()
  ret void
}

;; Without this, the inliner will simplify out @test_no_marker before adding
;; any lifetime markers.
declare void @use(ptr %a)

define void @helper_no_markers() {
; CHECK-LABEL: define void @helper_no_markers() {
; CHECK-NEXT:    [[A:%.*]] = alloca i8, align 1
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i8 ; Allocation size is 1 byte.
  call void @use(ptr %a)
  ret void
}

define void @test_no_marker() {
; CHECK-LABEL: define void @test_no_marker() {
; CHECK-NEXT:    [[A_I1:%.*]] = alloca i8, align 1
; CHECK-NEXT:    [[A_I:%.*]] = alloca i8, align 1
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 1, ptr [[A_I]])
; CHECK-NEXT:    call void @use(ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 1, ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 1, ptr [[A_I1]])
; CHECK-NEXT:    call void @use(ptr [[A_I1]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 1, ptr [[A_I1]])
; CHECK-NEXT:    ret void
;
  call void @helper_no_markers()
  call void @helper_no_markers()
  ret void
}

define void @helper_two_casts() {
; CHECK-LABEL: define void @helper_two_casts() {
; CHECK-NEXT:    [[A:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr [[A]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 4, ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca i32
  call void @llvm.lifetime.start.p0(i64 4, ptr %a)
  call void @llvm.lifetime.end.p0(i64 4, ptr %a)
  ret void
}

define void @test_two_casts() {
; CHECK-LABEL: define void @test_two_casts() {
; CHECK-NEXT:    [[A_I1:%.*]] = alloca i32, align 4
; CHECK-NEXT:    [[A_I:%.*]] = alloca i32, align 4
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 4, ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 4, ptr [[A_I1]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 4, ptr [[A_I1]])
; CHECK-NEXT:    ret void
;
  call void @helper_two_casts()
  call void @helper_two_casts()
  ret void
}

define void @helper_arrays_alloca() {
; CHECK-LABEL: define void @helper_arrays_alloca() {
; CHECK-NEXT:    [[A:%.*]] = alloca [10 x i32], align 16
; CHECK-NEXT:    call void @use(ptr [[A]])
; CHECK-NEXT:    ret void
;
  %a = alloca [10 x i32], align 16
  call void @use(ptr %a)
  ret void
}

define void @test_arrays_alloca() {
; CHECK-LABEL: define void @test_arrays_alloca() {
; CHECK-NEXT:    [[A_I:%.*]] = alloca [10 x i32], align 16
; CHECK-NEXT:    call void @llvm.lifetime.start.p0(i64 40, ptr [[A_I]])
; CHECK-NEXT:    call void @use(ptr [[A_I]])
; CHECK-NEXT:    call void @llvm.lifetime.end.p0(i64 40, ptr [[A_I]])
; CHECK-NEXT:    ret void
;
  call void @helper_arrays_alloca()
  ret void
}

%swift.error = type opaque

define void @helper_swifterror_alloca() {
; CHECK-LABEL: define void @helper_swifterror_alloca() {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[SWIFTERROR:%.*]] = alloca swifterror ptr, align 8
; CHECK-NEXT:    store ptr null, ptr [[SWIFTERROR]], align 8
; CHECK-NEXT:    ret void
;
entry:
  %swifterror = alloca swifterror ptr, align 8
  store ptr null, ptr %swifterror, align 8
  ret void
}

define void @test_swifterror_alloca() {
; CHECK-LABEL: define void @test_swifterror_alloca() {
; CHECK-NEXT:    [[SWIFTERROR_I:%.*]] = alloca swifterror ptr, align 8
; CHECK-NEXT:    store ptr null, ptr [[SWIFTERROR_I]], align 8
; CHECK-NEXT:    ret void
;
  call void @helper_swifterror_alloca()
  ret void
}
