# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=x86_64-unknown-unknown -mcpu=icelake-server -instruction-tables < %s | FileCheck %s

vpcompressb       %zmm16, %zmm19
vpcompressb       %zmm16, (%rax)
vpcompressb       %zmm16, %zmm19 {k1}
vpcompressb       %zmm16, (%rax) {k1}
vpcompressb       %zmm16, %zmm19 {k1}{z}

vpcompressw       %zmm16, %zmm19
vpcompressw       %zmm16, (%rax)
vpcompressw       %zmm16, %zmm19 {k1}
vpcompressw       %zmm16, (%rax) {k1}
vpcompressw       %zmm16, %zmm19 {k1}{z}

vpexpandb         %zmm16, %zmm19
vpexpandb         (%rax), %zmm19
vpexpandb         %zmm16, %zmm19 {k1}
vpexpandb         (%rax), %zmm19 {k1}
vpexpandb         %zmm16, %zmm19 {k1}{z}

vpexpandw         %zmm16, %zmm19
vpexpandw         (%rax), %zmm19
vpexpandw         %zmm16, %zmm19 {k1}
vpexpandw         (%rax), %zmm19 {k1}
vpexpandw         %zmm16, %zmm19 {k1}{z}

vpshldd           $1, %zmm16, %zmm17, %zmm19
vpshldd           $1, (%rax), %zmm17, %zmm19
vpshldd           $1, (%rax){1to16}, %zmm17, %zmm19
vpshldd           $1, %zmm16, %zmm17, %zmm19 {k1}
vpshldd           $1, (%rax), %zmm17, %zmm19 {k1}
vpshldd           $1, (%rax){1to16}, %zmm17, %zmm19 {k1}
vpshldd           $1, %zmm16, %zmm17, %zmm19 {k1}{z}
vpshldd           $1, (%rax), %zmm17, %zmm19 {k1}{z}
vpshldd           $1, (%rax){1to16}, %zmm17, %zmm19 {k1}{z}

vpshldq           $1, %zmm16, %zmm17, %zmm19
vpshldq           $1, (%rax), %zmm17, %zmm19
vpshldq           $1, (%rax){1to8}, %zmm17, %zmm19
vpshldq           $1, %zmm16, %zmm17, %zmm19 {k1}
vpshldq           $1, (%rax), %zmm17, %zmm19 {k1}
vpshldq           $1, (%rax){1to8}, %zmm17, %zmm19 {k1}
vpshldq           $1, %zmm16, %zmm17, %zmm19 {k1}{z}
vpshldq           $1, (%rax), %zmm17, %zmm19 {k1}{z}
vpshldq           $1, (%rax){1to8}, %zmm17, %zmm19 {k1}{z}

vpshldvd          %zmm16, %zmm17, %zmm19
vpshldvd          (%rax), %zmm17, %zmm19
vpshldvd          (%rax){1to16}, %zmm17, %zmm19
vpshldvd          %zmm16, %zmm17, %zmm19 {k1}
vpshldvd          (%rax), %zmm17, %zmm19 {k1}
vpshldvd          (%rax){1to16}, %zmm17, %zmm19 {k1}
vpshldvd          %zmm16, %zmm17, %zmm19 {k1}{z}
vpshldvd          (%rax), %zmm17, %zmm19 {k1}{z}
vpshldvd          (%rax){1to16}, %zmm17, %zmm19 {k1}{z}

vpshldvq          %zmm16, %zmm17, %zmm19
vpshldvq          (%rax), %zmm17, %zmm19
vpshldvq          (%rax){1to8}, %zmm17, %zmm19
vpshldvq          %zmm16, %zmm17, %zmm19 {k1}
vpshldvq          (%rax), %zmm17, %zmm19 {k1}
vpshldvq          (%rax){1to8}, %zmm17, %zmm19 {k1}
vpshldvq          %zmm16, %zmm17, %zmm19 {k1}{z}
vpshldvq          (%rax), %zmm17, %zmm19 {k1}{z}
vpshldvq          (%rax){1to8}, %zmm17, %zmm19 {k1}{z}

vpshldvw          %zmm16, %zmm17, %zmm19
vpshldvw          (%rax), %zmm17, %zmm19
vpshldvw          %zmm16, %zmm17, %zmm19 {k1}
vpshldvw          (%rax), %zmm17, %zmm19 {k1}
vpshldvw          %zmm16, %zmm17, %zmm19 {k1}{z}
vpshldvw          (%rax), %zmm17, %zmm19 {k1}{z}

vpshldw           $1, %zmm16, %zmm17, %zmm19
vpshldw           $1, (%rax), %zmm17, %zmm19
vpshldw           $1, %zmm16, %zmm17, %zmm19 {k1}
vpshldw           $1, (%rax), %zmm17, %zmm19 {k1}
vpshldw           $1, %zmm16, %zmm17, %zmm19 {k1}{z}
vpshldw           $1, (%rax), %zmm17, %zmm19 {k1}{z}

vpshrdd           $1, %zmm16, %zmm17, %zmm19
vpshrdd           $1, (%rax), %zmm17, %zmm19
vpshrdd           $1, (%rax){1to16}, %zmm17, %zmm19
vpshrdd           $1, %zmm16, %zmm17, %zmm19 {k1}
vpshrdd           $1, (%rax), %zmm17, %zmm19 {k1}
vpshrdd           $1, (%rax){1to16}, %zmm17, %zmm19 {k1}
vpshrdd           $1, %zmm16, %zmm17, %zmm19 {k1}{z}
vpshrdd           $1, (%rax), %zmm17, %zmm19 {k1}{z}
vpshrdd           $1, (%rax){1to16}, %zmm17, %zmm19 {k1}{z}

vpshrdq           $1, %zmm16, %zmm17, %zmm19
vpshrdq           $1, (%rax), %zmm17, %zmm19
vpshrdq           $1, (%rax){1to8}, %zmm17, %zmm19
vpshrdq           $1, %zmm16, %zmm17, %zmm19 {k1}
vpshrdq           $1, (%rax), %zmm17, %zmm19 {k1}
vpshrdq           $1, (%rax){1to8}, %zmm17, %zmm19 {k1}
vpshrdq           $1, %zmm16, %zmm17, %zmm19 {k1}{z}
vpshrdq           $1, (%rax), %zmm17, %zmm19 {k1}{z}
vpshrdq           $1, (%rax){1to8}, %zmm17, %zmm19 {k1}{z}

vpshrdvd          %zmm16, %zmm17, %zmm19
vpshrdvd          (%rax), %zmm17, %zmm19
vpshrdvd          (%rax){1to16}, %zmm17, %zmm19
vpshrdvd          %zmm16, %zmm17, %zmm19 {k1}
vpshrdvd          (%rax), %zmm17, %zmm19 {k1}
vpshrdvd          (%rax){1to16}, %zmm17, %zmm19 {k1}
vpshrdvd          %zmm16, %zmm17, %zmm19 {k1}{z}
vpshrdvd          (%rax), %zmm17, %zmm19 {k1}{z}
vpshrdvd          (%rax){1to16}, %zmm17, %zmm19 {k1}{z}

vpshrdvq          %zmm16, %zmm17, %zmm19
vpshrdvq          (%rax), %zmm17, %zmm19
vpshrdvq          (%rax){1to8}, %zmm17, %zmm19
vpshrdvq          %zmm16, %zmm17, %zmm19 {k1}
vpshrdvq          (%rax), %zmm17, %zmm19 {k1}
vpshrdvq          (%rax){1to8}, %zmm17, %zmm19 {k1}
vpshrdvq          %zmm16, %zmm17, %zmm19 {k1}{z}
vpshrdvq          (%rax), %zmm17, %zmm19 {k1}{z}
vpshrdvq          (%rax){1to8}, %zmm17, %zmm19 {k1}{z}

vpshrdvw          %zmm16, %zmm17, %zmm19
vpshrdvw          (%rax), %zmm17, %zmm19
vpshrdvw          %zmm16, %zmm17, %zmm19 {k1}
vpshrdvw          (%rax), %zmm17, %zmm19 {k1}
vpshrdvw          %zmm16, %zmm17, %zmm19 {k1}{z}
vpshrdvw          (%rax), %zmm17, %zmm19 {k1}{z}

vpshrdw           $1, %zmm16, %zmm17, %zmm19
vpshrdw           $1, (%rax), %zmm17, %zmm19
vpshrdw           $1, %zmm16, %zmm17, %zmm19 {k1}
vpshrdw           $1, (%rax), %zmm17, %zmm19 {k1}
vpshrdw           $1, %zmm16, %zmm17, %zmm19 {k1}{z}
vpshrdw           $1, (%rax), %zmm17, %zmm19 {k1}{z}

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      3     1.00                  U     vpcompressb	%zmm16, %zmm19
# CHECK-NEXT:  2      10    1.00           *            vpcompressb	%zmm16, (%rax)
# CHECK-NEXT:  1      3     1.00                        vpcompressb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      10    1.00           *            vpcompressb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      3     1.00                        vpcompressb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                  U     vpcompressw	%zmm16, %zmm19
# CHECK-NEXT:  2      10    1.00           *            vpcompressw	%zmm16, (%rax)
# CHECK-NEXT:  1      3     1.00                        vpcompressw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      10    1.00           *            vpcompressw	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  1      3     1.00                        vpcompressw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                  U     vpexpandb	%zmm16, %zmm19
# CHECK-NEXT:  2      10    1.00                  U     vpexpandb	(%rax), %zmm19
# CHECK-NEXT:  1      3     1.00                        vpexpandb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      10    1.00    *                   vpexpandb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpexpandb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      3     1.00                  U     vpexpandw	%zmm16, %zmm19
# CHECK-NEXT:  2      10    1.00                  U     vpexpandw	(%rax), %zmm19
# CHECK-NEXT:  1      3     1.00                        vpexpandw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  2      10    1.00    *                   vpexpandw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  1      3     1.00                        vpexpandw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshldd	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldd	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldd	$1, (%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshldd	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldd	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshldd	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldd	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshldq	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldq	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldq	$1, (%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshldq	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldq	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshldq	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldq	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshldvd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldvd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldvd	(%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshldvd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvd	(%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshldvd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvd	(%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshldvq	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldvq	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldvq	(%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshldvq	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvq	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvq	(%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshldvq	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvq	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvq	(%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshldvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshldvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshldvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshldw	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshldw	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshldw	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshldw	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshldw	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshldw	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshrdd	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdd	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdd	$1, (%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshrdd	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdd	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshrdd	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdd	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshrdq	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdq	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdq	$1, (%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshrdq	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdq	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshrdq	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdq	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshrdvd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvd	(%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshrdvd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvd	(%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshrdvd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvd	(%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshrdvq	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvq	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvq	(%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshrdvq	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvq	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvq	(%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshrdvq	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvq	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvq	(%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshrdvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshrdvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshrdvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  1      5     0.50                        vpshrdw	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  2      12    0.50    *                   vpshrdw	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  1      5     0.50                        vpshrdw	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdw	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  1      5     0.50                        vpshrdw	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  2      12    0.50    *                   vpshrdw	$1, (%rax), %zmm17, %zmm19 {%k1} {z}

# CHECK:      Resources:
# CHECK-NEXT: [0]   - ICXDivider
# CHECK-NEXT: [1]   - ICXFPDivider
# CHECK-NEXT: [2]   - ICXPort0
# CHECK-NEXT: [3]   - ICXPort1
# CHECK-NEXT: [4]   - ICXPort2
# CHECK-NEXT: [5]   - ICXPort3
# CHECK-NEXT: [6]   - ICXPort4
# CHECK-NEXT: [7]   - ICXPort5
# CHECK-NEXT: [8]   - ICXPort6
# CHECK-NEXT: [9]   - ICXPort7
# CHECK-NEXT: [10]  - ICXPort8
# CHECK-NEXT: [11]  - ICXPort9

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]
# CHECK-NEXT:  -      -     48.00   -     34.00  34.00   -     68.00   -      -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcompressb	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpcompressb	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcompressb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpcompressb	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcompressb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcompressw	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpcompressw	%zmm16, (%rax)
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcompressw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpcompressw	%zmm16, (%rax) {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpcompressw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpexpandb	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpexpandb	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpexpandb	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpexpandb	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpexpandb	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpexpandw	%zmm16, %zmm19
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpexpandw	(%rax), %zmm19
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpexpandw	%zmm16, %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -     0.50   0.50    -     1.00    -      -      -      -     vpexpandw	(%rax), %zmm19 {%k1}
# CHECK-NEXT:  -      -      -      -      -      -      -     1.00    -      -      -      -     vpexpandw	%zmm16, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldd	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldd	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldd	$1, (%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldd	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldd	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldd	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldd	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldq	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldq	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldq	$1, (%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldq	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldq	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldq	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldq	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvd	(%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvd	(%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvd	(%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvq	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvq	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvq	(%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvq	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvq	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvq	(%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvq	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvq	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvq	(%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldw	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldw	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldw	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldw	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshldw	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshldw	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdd	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdd	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdd	$1, (%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdd	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdd	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdd	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdd	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdd	$1, (%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdq	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdq	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdq	$1, (%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdq	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdq	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdq	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdq	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdq	$1, (%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvd	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvd	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvd	(%rax){1to16}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvd	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvd	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvd	(%rax){1to16}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvd	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvd	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvd	(%rax){1to16}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvq	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvq	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvq	(%rax){1to8}, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvq	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvq	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvq	(%rax){1to8}, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvq	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvq	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvq	(%rax){1to8}, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvw	%zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvw	(%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvw	%zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvw	(%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdvw	%zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdvw	(%rax), %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdw	$1, %zmm16, %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdw	$1, (%rax), %zmm17, %zmm19
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdw	$1, %zmm16, %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdw	$1, (%rax), %zmm17, %zmm19 {%k1}
# CHECK-NEXT:  -      -     0.50    -      -      -      -     0.50    -      -      -      -     vpshrdw	$1, %zmm16, %zmm17, %zmm19 {%k1} {z}
# CHECK-NEXT:  -      -     0.50    -     0.50   0.50    -     0.50    -      -      -      -     vpshrdw	$1, (%rax), %zmm17, %zmm19 {%k1} {z}
