; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mattr=+sve -force-streaming-compatible  < %s | FileCheck %s
; RUN: llc -mattr=+sme -force-streaming  < %s | FileCheck %s
; RUN: llc -force-streaming-compatible < %s | FileCheck %s --check-prefix=NONEON-NOSVE

target triple = "aarch64-unknown-linux-gnu"

;
; SMAX
;

define <8 x i8> @smax_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: smax_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i8> @llvm.smax.v8i8(<8 x i8> %op1, <8 x i8> %op2)
  ret <8 x i8> %res
}

define <16 x i8> @smax_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: smax_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <16 x i8> @llvm.smax.v16i8(<16 x i8> %op1, <16 x i8> %op2)
  ret <16 x i8> %res
}

define void @smax_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: smax_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smax z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = call <32 x i8> @llvm.smax.v32i8(<32 x i8> %op1, <32 x i8> %op2)
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @smax_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: smax_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i16> @llvm.smax.v4i16(<4 x i16> %op1, <4 x i16> %op2)
  ret <4 x i16> %res
}

define <8 x i16> @smax_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: smax_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i16> @llvm.smax.v8i16(<8 x i16> %op1, <8 x i16> %op2)
  ret <8 x i16> %res
}

define void @smax_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: smax_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smax z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = call <16 x i16> @llvm.smax.v16i16(<16 x i16> %op1, <16 x i16> %op2)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @smax_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: smax_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i32> @llvm.smax.v2i32(<2 x i32> %op1, <2 x i32> %op2)
  ret <2 x i32> %res
}

define <4 x i32> @smax_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: smax_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i32> @llvm.smax.v4i32(<4 x i32> %op1, <4 x i32> %op2)
  ret <4 x i32> %res
}

define void @smax_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: smax_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smax z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, gt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, gt
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = call <8 x i32> @llvm.smax.v8i32(<8 x i32> %op1, <8 x i32> %op2)
  store <8 x i32> %res, ptr %a
  ret void
}

; Vector i64 max are not legal for NEON so use SVE when available.
define <1 x i64> @smax_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: smax_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, gt
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <1 x i64> @llvm.smax.v1i64(<1 x i64> %op1, <1 x i64> %op2)
  ret <1 x i64> %res
}

; Vector i64 max are not legal for NEON so use SVE when available.
define <2 x i64> @smax_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: smax_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, gt
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, gt
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i64> @llvm.smax.v2i64(<2 x i64> %op1, <2 x i64> %op2)
  ret <2 x i64> %res
}

define void @smax_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: smax_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smax z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smax_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, gt
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, gt
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, gt
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, gt
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = call <4 x i64> @llvm.smax.v4i64(<4 x i64> %op1, <4 x i64> %op2)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; SMIN
;

define <8 x i8> @smin_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: smin_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i8> @llvm.smin.v8i8(<8 x i8> %op1, <8 x i8> %op2)
  ret <8 x i8> %res
}

define <16 x i8> @smin_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: smin_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <16 x i8> @llvm.smin.v16i8(<16 x i8> %op1, <16 x i8> %op2)
  ret <16 x i8> %res
}

define void @smin_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: smin_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smin z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrsb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = call <32 x i8> @llvm.smin.v32i8(<32 x i8> %op1, <32 x i8> %op2)
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @smin_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: smin_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i16> @llvm.smin.v4i16(<4 x i16> %op1, <4 x i16> %op2)
  ret <4 x i16> %res
}

define <8 x i16> @smin_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: smin_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i16> @llvm.smin.v8i16(<8 x i16> %op1, <8 x i16> %op2)
  ret <8 x i16> %res
}

define void @smin_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: smin_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smin z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldrsh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrsh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = call <16 x i16> @llvm.smin.v16i16(<16 x i16> %op1, <16 x i16> %op2)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @smin_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: smin_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i32> @llvm.smin.v2i32(<2 x i32> %op1, <2 x i32> %op2)
  ret <2 x i32> %res
}

define <4 x i32> @smin_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: smin_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i32> @llvm.smin.v4i32(<4 x i32> %op1, <4 x i32> %op2)
  ret <4 x i32> %res
}

define void @smin_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: smin_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smin z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lt
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lt
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = call <8 x i32> @llvm.smin.v8i32(<8 x i32> %op1, <8 x i32> %op2)
  store <8 x i32> %res, ptr %a
  ret void
}

; Vector i64 min are not legal for NEON so use SVE when available.
define <1 x i64> @smin_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: smin_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    smin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lt
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <1 x i64> @llvm.smin.v1i64(<1 x i64> %op1, <1 x i64> %op2)
  ret <1 x i64> %res
}

; Vector i64 min are not legal for NEON so use SVE when available.
define <2 x i64> @smin_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: smin_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    smin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, lt
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lt
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i64> @llvm.smin.v2i64(<2 x i64> %op1, <2 x i64> %op2)
  ret <2 x i64> %res
}

define void @smin_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: smin_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    smin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    smin z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: smin_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, lt
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lt
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, lt
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lt
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = call <4 x i64> @llvm.smin.v4i64(<4 x i64> %op1, <4 x i64> %op2)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; UMAX
;

define <8 x i8> @umax_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: umax_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i8> @llvm.umax.v8i8(<8 x i8> %op1, <8 x i8> %op2)
  ret <8 x i8> %res
}

define <16 x i8> @umax_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: umax_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <16 x i8> @llvm.umax.v16i8(<16 x i8> %op1, <16 x i8> %op2)
  ret <16 x i8> %res
}

define void @umax_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: umax_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umax z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umax z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = call <32 x i8> @llvm.umax.v32i8(<32 x i8> %op1, <32 x i8> %op2)
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @umax_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: umax_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i16> @llvm.umax.v4i16(<4 x i16> %op1, <4 x i16> %op2)
  ret <4 x i16> %res
}

define <8 x i16> @umax_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: umax_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i16> @llvm.umax.v8i16(<8 x i16> %op1, <8 x i16> %op2)
  ret <8 x i16> %res
}

define void @umax_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: umax_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umax z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umax z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = call <16 x i16> @llvm.umax.v16i16(<16 x i16> %op1, <16 x i16> %op2)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @umax_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: umax_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i32> @llvm.umax.v2i32(<2 x i32> %op1, <2 x i32> %op2)
  ret <2 x i32> %res
}

define <4 x i32> @umax_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: umax_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i32> @llvm.umax.v4i32(<4 x i32> %op1, <4 x i32> %op2)
  ret <4 x i32> %res
}

define void @umax_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: umax_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umax z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umax z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, hi
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, hi
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = call <8 x i32> @llvm.umax.v8i32(<8 x i32> %op1, <8 x i32> %op2)
  store <8 x i32> %res, ptr %a
  ret void
}

; Vector i64 max are not legal for NEON so use SVE when available.
define <1 x i64> @umax_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: umax_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, hi
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <1 x i64> @llvm.umax.v1i64(<1 x i64> %op1, <1 x i64> %op2)
  ret <1 x i64> %res
}

; Vector i64 max are not legal for NEON so use SVE when available.
define <2 x i64> @umax_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: umax_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, hi
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, hi
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i64> @llvm.umax.v2i64(<2 x i64> %op1, <2 x i64> %op2)
  ret <2 x i64> %res
}

define void @umax_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: umax_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umax z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umax z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umax_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, hi
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, hi
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, hi
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, hi
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = call <4 x i64> @llvm.umax.v4i64(<4 x i64> %op1, <4 x i64> %op2)
  store <4 x i64> %res, ptr %a
  ret void
}

;
; UMIN
;

define <8 x i8> @umin_v8i8(<8 x i8> %op1, <8 x i8> %op2) {
; CHECK-LABEL: umin_v8i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl8
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v8i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i8> @llvm.umin.v8i8(<8 x i8> %op1, <8 x i8> %op2)
  ret <8 x i8> %res
}

define <16 x i8> @umin_v16i8(<16 x i8> %op1, <16 x i8> %op2) {
; CHECK-LABEL: umin_v16i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v16i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #47]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #45]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #43]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #41]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #39]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #37]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #35]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #33]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <16 x i8> @llvm.umin.v16i8(<16 x i8> %op1, <16 x i8> %op2)
  ret <16 x i8> %res
}

define void @umin_v32i8(ptr %a, ptr %b) {
; CHECK-LABEL: umin_v32i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.b, vl16
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umin z0.b, p0/m, z0.b, z1.b
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umin z1.b, p0/m, z1.b, z3.b
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v32i8:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #63]
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #47]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #46]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #95]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #62]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #45]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #61]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #93]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #43]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #59]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #91]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #41]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #57]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #89]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #39]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #55]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #87]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #37]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #53]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #85]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #35]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #51]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #83]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #33]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #49]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #81]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #15]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #31]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #79]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #13]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #29]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #77]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #11]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #27]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #75]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #9]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #25]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #73]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #7]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #23]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #71]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #5]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #21]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #69]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #3]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #19]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #67]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp, #1]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #17]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrb w9, [sp]
; NONEON-NOSVE-NEXT:    strb w8, [sp, #65]
; NONEON-NOSVE-NEXT:    ldrb w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strb w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <32 x i8>, ptr %a
  %op2 = load <32 x i8>, ptr %b
  %res = call <32 x i8> @llvm.umin.v32i8(<32 x i8> %op1, <32 x i8> %op2)
  store <32 x i8> %res, ptr %a
  ret void
}

define <4 x i16> @umin_v4i16(<4 x i16> %op1, <4 x i16> %op2) {
; CHECK-LABEL: umin_v4i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl4
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v4i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i16> @llvm.umin.v4i16(<4 x i16> %op1, <4 x i16> %op2)
  ret <4 x i16> %res
}

define <8 x i16> @umin_v8i16(<8 x i16> %op1, <8 x i16> %op2) {
; CHECK-LABEL: umin_v8i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v8i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #46]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #44]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #42]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #40]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #38]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #36]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #34]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w8, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <8 x i16> @llvm.umin.v8i16(<8 x i16> %op1, <8 x i16> %op2)
  ret <8 x i16> %res
}

define void @umin_v16i16(ptr %a, ptr %b) {
; CHECK-LABEL: umin_v16i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.h, vl8
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umin z0.h, p0/m, z0.h, z1.h
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umin z1.h, p0/m, z1.h, z3.h
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v16i16:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #62]
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #46]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #44]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #94]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #42]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #92]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #58]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #40]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #90]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #38]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #88]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #54]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #36]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #86]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #34]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #84]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #50]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #32]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #82]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #14]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #80]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #30]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #12]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #78]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #10]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #76]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #26]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #8]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #74]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #6]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #72]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #22]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #4]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #70]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp, #2]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #68]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #18]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldrh w9, [sp]
; NONEON-NOSVE-NEXT:    strh w8, [sp, #66]
; NONEON-NOSVE-NEXT:    ldrh w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    strh w8, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <16 x i16>, ptr %a
  %op2 = load <16 x i16>, ptr %b
  %res = call <16 x i16> @llvm.umin.v16i16(<16 x i16> %op1, <16 x i16> %op2)
  store <16 x i16> %res, ptr %a
  ret void
}

define <2 x i32> @umin_v2i32(<2 x i32> %op1, <2 x i32> %op2) {
; CHECK-LABEL: umin_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl2
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v2i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #32
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 32
; NONEON-NOSVE-NEXT:    stp d0, d1, [sp, #8]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #24]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #24]
; NONEON-NOSVE-NEXT:    add sp, sp, #32
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i32> @llvm.umin.v2i32(<2 x i32> %op1, <2 x i32> %op2)
  ret <2 x i32> %res
}

define <4 x i32> @umin_v4i32(<4 x i32> %op1, <4 x i32> %op2) {
; CHECK-LABEL: umin_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v4i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <4 x i32> @llvm.umin.v4i32(<4 x i32> %op1, <4 x i32> %op2)
  ret <4 x i32> %res
}

define void @umin_v8i32(ptr %a, ptr %b) {
; CHECK-LABEL: umin_v8i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.s, vl4
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umin z0.s, p0/m, z0.s, z1.s
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umin z1.s, p0/m, z1.s, z3.s
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v8i32:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #40]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #60]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #32]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #88]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #52]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp, #8]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #28]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    ldp w9, w10, [sp]
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #72]
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #20]
; NONEON-NOSVE-NEXT:    cmp w10, w8
; NONEON-NOSVE-NEXT:    csel w11, w10, w8, lo
; NONEON-NOSVE-NEXT:    ldr w8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp w9, w8
; NONEON-NOSVE-NEXT:    csel w8, w9, w8, lo
; NONEON-NOSVE-NEXT:    stp w8, w11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <8 x i32>, ptr %a
  %op2 = load <8 x i32>, ptr %b
  %res = call <8 x i32> @llvm.umin.v8i32(<8 x i32> %op1, <8 x i32> %op2)
  store <8 x i32> %res, ptr %a
  ret void
}

; Vector i64 min are not legal for NEON so use SVE when available.
define <1 x i64> @umin_v1i64(<1 x i64> %op1, <1 x i64> %op2) {
; CHECK-LABEL: umin_v1i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl1
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $z0
; CHECK-NEXT:    // kill: def $d1 killed $d1 def $z1
; CHECK-NEXT:    umin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v1i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #16
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 16
; NONEON-NOSVE-NEXT:    fmov x8, d1
; NONEON-NOSVE-NEXT:    fmov x9, d0
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lo
; NONEON-NOSVE-NEXT:    str x8, [sp, #8]
; NONEON-NOSVE-NEXT:    ldr d0, [sp, #8]
; NONEON-NOSVE-NEXT:    add sp, sp, #16
; NONEON-NOSVE-NEXT:    ret
  %res = call <1 x i64> @llvm.umin.v1i64(<1 x i64> %op1, <1 x i64> %op2)
  ret <1 x i64> %res
}

; Vector i64 min are not legal for NEON so use SVE when available.
define <2 x i64> @umin_v2i64(<2 x i64> %op1, <2 x i64> %op2) {
; CHECK-LABEL: umin_v2i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    // kill: def $q0 killed $q0 def $z0
; CHECK-NEXT:    // kill: def $q1 killed $q1 def $z1
; CHECK-NEXT:    umin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    // kill: def $q0 killed $q0 killed $z0
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v2i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    stp q0, q1, [sp, #-48]!
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 48
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, lo
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lo
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr q0, [sp, #32]
; NONEON-NOSVE-NEXT:    add sp, sp, #48
; NONEON-NOSVE-NEXT:    ret
  %res = call <2 x i64> @llvm.umin.v2i64(<2 x i64> %op1, <2 x i64> %op2)
  ret <2 x i64> %res
}

define void @umin_v4i64(ptr %a, ptr %b) {
; CHECK-LABEL: umin_v4i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    ldp q0, q3, [x1]
; CHECK-NEXT:    ptrue p0.d, vl2
; CHECK-NEXT:    ldp q1, q2, [x0]
; CHECK-NEXT:    umin z0.d, p0/m, z0.d, z1.d
; CHECK-NEXT:    movprfx z1, z2
; CHECK-NEXT:    umin z1.d, p0/m, z1.d, z3.d
; CHECK-NEXT:    stp q0, q1, [x0]
; CHECK-NEXT:    ret
;
; NONEON-NOSVE-LABEL: umin_v4i64:
; NONEON-NOSVE:       // %bb.0:
; NONEON-NOSVE-NEXT:    sub sp, sp, #96
; NONEON-NOSVE-NEXT:    .cfi_def_cfa_offset 96
; NONEON-NOSVE-NEXT:    ldp q3, q0, [x1]
; NONEON-NOSVE-NEXT:    ldp q2, q1, [x0]
; NONEON-NOSVE-NEXT:    stp q2, q3, [sp]
; NONEON-NOSVE-NEXT:    stp q1, q0, [sp, #32]
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp, #32]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #56]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, lo
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #48]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lo
; NONEON-NOSVE-NEXT:    ldp x9, x10, [sp]
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #80]
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #24]
; NONEON-NOSVE-NEXT:    cmp x10, x8
; NONEON-NOSVE-NEXT:    csel x11, x10, x8, lo
; NONEON-NOSVE-NEXT:    ldr x8, [sp, #16]
; NONEON-NOSVE-NEXT:    cmp x9, x8
; NONEON-NOSVE-NEXT:    csel x8, x9, x8, lo
; NONEON-NOSVE-NEXT:    stp x8, x11, [sp, #64]
; NONEON-NOSVE-NEXT:    ldp q0, q1, [sp, #64]
; NONEON-NOSVE-NEXT:    stp q0, q1, [x0]
; NONEON-NOSVE-NEXT:    add sp, sp, #96
; NONEON-NOSVE-NEXT:    ret
  %op1 = load <4 x i64>, ptr %a
  %op2 = load <4 x i64>, ptr %b
  %res = call <4 x i64> @llvm.umin.v4i64(<4 x i64> %op1, <4 x i64> %op2)
  store <4 x i64> %res, ptr %a
  ret void
}

declare <8 x i8> @llvm.smin.v8i8(<8 x i8>, <8 x i8>)
declare <16 x i8> @llvm.smin.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.smin.v32i8(<32 x i8>, <32 x i8>)
declare <4 x i16> @llvm.smin.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.smin.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.smin.v16i16(<16 x i16>, <16 x i16>)
declare <2 x i32> @llvm.smin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smin.v8i32(<8 x i32>, <8 x i32>)
declare <1 x i64> @llvm.smin.v1i64(<1 x i64>, <1 x i64>)
declare <2 x i64> @llvm.smin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smin.v4i64(<4 x i64>, <4 x i64>)

declare <8 x i8> @llvm.smax.v8i8(<8 x i8>, <8 x i8>)
declare <16 x i8> @llvm.smax.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.smax.v32i8(<32 x i8>, <32 x i8>)
declare <4 x i16> @llvm.smax.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.smax.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.smax.v16i16(<16 x i16>, <16 x i16>)
declare <2 x i32> @llvm.smax.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.smax.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.smax.v8i32(<8 x i32>, <8 x i32>)
declare <1 x i64> @llvm.smax.v1i64(<1 x i64>, <1 x i64>)
declare <2 x i64> @llvm.smax.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.smax.v4i64(<4 x i64>, <4 x i64>)

declare <8 x i8> @llvm.umin.v8i8(<8 x i8>, <8 x i8>)
declare <16 x i8> @llvm.umin.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.umin.v32i8(<32 x i8>, <32 x i8>)
declare <4 x i16> @llvm.umin.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.umin.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.umin.v16i16(<16 x i16>, <16 x i16>)
declare <2 x i32> @llvm.umin.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.umin.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.umin.v8i32(<8 x i32>, <8 x i32>)
declare <1 x i64> @llvm.umin.v1i64(<1 x i64>, <1 x i64>)
declare <2 x i64> @llvm.umin.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.umin.v4i64(<4 x i64>, <4 x i64>)

declare <8 x i8> @llvm.umax.v8i8(<8 x i8>, <8 x i8>)
declare <16 x i8> @llvm.umax.v16i8(<16 x i8>, <16 x i8>)
declare <32 x i8> @llvm.umax.v32i8(<32 x i8>, <32 x i8>)
declare <4 x i16> @llvm.umax.v4i16(<4 x i16>, <4 x i16>)
declare <8 x i16> @llvm.umax.v8i16(<8 x i16>, <8 x i16>)
declare <16 x i16> @llvm.umax.v16i16(<16 x i16>, <16 x i16>)
declare <2 x i32> @llvm.umax.v2i32(<2 x i32>, <2 x i32>)
declare <4 x i32> @llvm.umax.v4i32(<4 x i32>, <4 x i32>)
declare <8 x i32> @llvm.umax.v8i32(<8 x i32>, <8 x i32>)
declare <1 x i64> @llvm.umax.v1i64(<1 x i64>, <1 x i64>)
declare <2 x i64> @llvm.umax.v2i64(<2 x i64>, <2 x i64>)
declare <4 x i64> @llvm.umax.v4i64(<4 x i64>, <4 x i64>)
