; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -mtriple mips | FileCheck %s -check-prefixes=CHECK-32-BE
; RUN: llc < %s -mtriple mipsel | FileCheck %s -check-prefixes=CHECK-32-LE
; RUN: llc < %s -mtriple mips64 | FileCheck %s -check-prefixes=CHECK-64-BE
; RUN: llc < %s -mtriple mips64el | FileCheck %s -check-prefixes=CHECK-64-LE

declare dso_local void @main()

define dso_local void @naked() naked "frame-pointer"="all" {
; CHECK-32-BE-LABEL: naked:
; CHECK-32-BE:       # %bb.0:
; CHECK-32-BE-NEXT:    jal main
; CHECK-32-BE-NEXT:    nop
;
; CHECK-32-LE-LABEL: naked:
; CHECK-32-LE:       # %bb.0:
; CHECK-32-LE-NEXT:    jal main
; CHECK-32-LE-NEXT:    nop
;
; CHECK-64-BE-LABEL: naked:
; CHECK-64-BE:       # %bb.0:
; CHECK-64-BE-NEXT:    jal main
; CHECK-64-BE-NEXT:    nop
;
; CHECK-64-LE-LABEL: naked:
; CHECK-64-LE:       # %bb.0:
; CHECK-64-LE-NEXT:    jal main
; CHECK-64-LE-NEXT:    nop
  call void @main()
  unreachable
}

define dso_local void @normal() "frame-pointer"="all" {
; CHECK-32-BE-LABEL: normal:
; CHECK-32-BE:       # %bb.0:
; CHECK-32-BE-NEXT:    addiu $sp, $sp, -24
; CHECK-32-BE-NEXT:    .cfi_def_cfa_offset 24
; CHECK-32-BE-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; CHECK-32-BE-NEXT:    sw $fp, 16($sp) # 4-byte Folded Spill
; CHECK-32-BE-NEXT:    .cfi_offset 31, -4
; CHECK-32-BE-NEXT:    .cfi_offset 30, -8
; CHECK-32-BE-NEXT:    move $fp, $sp
; CHECK-32-BE-NEXT:    .cfi_def_cfa_register 30
; CHECK-32-BE-NEXT:    jal main
; CHECK-32-BE-NEXT:    nop
;
; CHECK-32-LE-LABEL: normal:
; CHECK-32-LE:       # %bb.0:
; CHECK-32-LE-NEXT:    addiu $sp, $sp, -24
; CHECK-32-LE-NEXT:    .cfi_def_cfa_offset 24
; CHECK-32-LE-NEXT:    sw $ra, 20($sp) # 4-byte Folded Spill
; CHECK-32-LE-NEXT:    sw $fp, 16($sp) # 4-byte Folded Spill
; CHECK-32-LE-NEXT:    .cfi_offset 31, -4
; CHECK-32-LE-NEXT:    .cfi_offset 30, -8
; CHECK-32-LE-NEXT:    move $fp, $sp
; CHECK-32-LE-NEXT:    .cfi_def_cfa_register 30
; CHECK-32-LE-NEXT:    jal main
; CHECK-32-LE-NEXT:    nop
;
; CHECK-64-BE-LABEL: normal:
; CHECK-64-BE:       # %bb.0:
; CHECK-64-BE-NEXT:    daddiu $sp, $sp, -16
; CHECK-64-BE-NEXT:    .cfi_def_cfa_offset 16
; CHECK-64-BE-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; CHECK-64-BE-NEXT:    sd $fp, 0($sp) # 8-byte Folded Spill
; CHECK-64-BE-NEXT:    .cfi_offset 31, -8
; CHECK-64-BE-NEXT:    .cfi_offset 30, -16
; CHECK-64-BE-NEXT:    move $fp, $sp
; CHECK-64-BE-NEXT:    .cfi_def_cfa_register 30
; CHECK-64-BE-NEXT:    jal main
; CHECK-64-BE-NEXT:    nop
;
; CHECK-64-LE-LABEL: normal:
; CHECK-64-LE:       # %bb.0:
; CHECK-64-LE-NEXT:    daddiu $sp, $sp, -16
; CHECK-64-LE-NEXT:    .cfi_def_cfa_offset 16
; CHECK-64-LE-NEXT:    sd $ra, 8($sp) # 8-byte Folded Spill
; CHECK-64-LE-NEXT:    sd $fp, 0($sp) # 8-byte Folded Spill
; CHECK-64-LE-NEXT:    .cfi_offset 31, -8
; CHECK-64-LE-NEXT:    .cfi_offset 30, -16
; CHECK-64-LE-NEXT:    move $fp, $sp
; CHECK-64-LE-NEXT:    .cfi_def_cfa_register 30
; CHECK-64-LE-NEXT:    jal main
; CHECK-64-LE-NEXT:    nop
  call void @main()
  unreachable
}
