; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx512f | FileCheck %s --check-prefix=AVX512
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=avx512fp16 | FileCheck %s --check-prefix=AVX512FP16

; This test makes sure that a vector that needs to be promoted that is bitcasted to fp16 is legalized correctly without causing a width mismatch.
define void @constant_fold_vector_to_half() {
; SSE2-LABEL: constant_fold_vector_to_half:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movw $16384, -{{[0-9]+}}(%rsp) # imm = 0x4000
; SSE2-NEXT:    pinsrw $0, -{{[0-9]+}}(%rsp), %xmm0
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rax)
; SSE2-NEXT:    retq
;
; AVX512-LABEL: constant_fold_vector_to_half:
; AVX512:       # %bb.0:
; AVX512-NEXT:    movw $16384, -{{[0-9]+}}(%rsp) # imm = 0x4000
; AVX512-NEXT:    vpinsrw $0, -{{[0-9]+}}(%rsp), %xmm0, %xmm0
; AVX512-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX512-NEXT:    retq
;
; AVX512FP16-LABEL: constant_fold_vector_to_half:
; AVX512FP16:       # %bb.0:
; AVX512FP16-NEXT:    movw $16384, -{{[0-9]+}}(%rsp) # imm = 0x4000
; AVX512FP16-NEXT:    vmovsh -{{[0-9]+}}(%rsp), %xmm0
; AVX512FP16-NEXT:    vmovsh %xmm0, (%rax)
; AVX512FP16-NEXT:    retq
  store volatile half bitcast (<4 x i4> <i4 0, i4 0, i4 0, i4 4> to half), ptr undef
  ret void
}

; Similarly this makes sure that the opposite bitcast of the above is also legalized without crashing.
define void @pr38533_2(half %x) {
; SSE2-LABEL: pr38533_2:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rax)
; SSE2-NEXT:    retq
;
; AVX512-LABEL: pr38533_2:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX512-NEXT:    retq
;
; AVX512FP16-LABEL: pr38533_2:
; AVX512FP16:       # %bb.0:
; AVX512FP16-NEXT:    vmovsh %xmm0, (%rax)
; AVX512FP16-NEXT:    retq
  %a = bitcast half %x to <4 x i4>
  store volatile <4 x i4> %a, ptr undef
  ret void
}

; This case is a bitcast from fp16 to a 16-bit wide legal vector type. In this case the result type is legal when the bitcast gets type legalized.
define void @pr38533_3(half %x) {
; SSE2-LABEL: pr38533_3:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    movw %ax, (%rax)
; SSE2-NEXT:    retq
;
; AVX512-LABEL: pr38533_3:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpextrw $0, %xmm0, (%rax)
; AVX512-NEXT:    retq
;
; AVX512FP16-LABEL: pr38533_3:
; AVX512FP16:       # %bb.0:
; AVX512FP16-NEXT:    vmovsh %xmm0, (%rax)
; AVX512FP16-NEXT:    retq
  %a = bitcast half %x to <16 x i1>
  store volatile <16 x i1> %a, ptr undef
  ret void
}
