; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN:  sed 's/iXLen/i32/g' %s | llc -mtriple=riscv32 -mattr=+v,+zvfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s
; RUN:  sed 's/iXLen/i64/g' %s | llc -mtriple=riscv64 -mattr=+v,+zvfh,+xsfvcp \
; RUN:    -verify-machineinstrs | FileCheck %s

define void @test_sf_vc_vvw_se_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1i16.nxv1i8.nxv1i8.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1i16.nxv1i8.nxv1i8.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, <vscale x 1 x i8>, iXLen)

define void @test_sf_vc_vvw_se_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2i16.nxv2i8.nxv2i8.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2i16.nxv2i8.nxv2i8.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, <vscale x 2 x i8>, iXLen)

define void @test_sf_vc_vvw_se_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4i16.nxv4i8.nxv4i8.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4i16.nxv4i8.nxv4i8.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, <vscale x 4 x i8>, iXLen)

define void @test_sf_vc_vvw_se_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8i16.nxv8i8.nxv8i8.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8i16.nxv8i8.nxv8i8.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, <vscale x 8 x i8>, iXLen)

define void @test_sf_vc_vvw_se_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv16i16.nxv16i8.nxv16i8.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv16i16.nxv16i8.nxv16i8.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, <vscale x 16 x i8>, iXLen)

define void @test_sf_vc_vvw_se_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv32i16.nxv32i8.nxv32i8.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv32i16.nxv32i8.nxv32i8.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, <vscale x 32 x i8>, iXLen)

define void @test_sf_vc_vvw_se_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1i32.nxv1i16.nxv1i16.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1i32.nxv1i16.nxv1i16.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define void @test_sf_vc_vvw_se_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2i32.nxv2i16.nxv2i16.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2i32.nxv2i16.nxv2i16.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define void @test_sf_vc_vvw_se_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4i32.nxv4i16.nxv4i16.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4i32.nxv4i16.nxv4i16.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define void @test_sf_vc_vvw_se_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8i32.nxv8i16.nxv8i16.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8i32.nxv8i16.nxv8i16.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define void @test_sf_vc_vvw_se_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv16i32.nxv16i16.nxv16i16.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv16i32.nxv16i16.nxv16i16.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define void @test_sf_vc_vvw_se_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1i64.nxv1i32.nxv1i32.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1i64.nxv1i32.nxv1i32.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define void @test_sf_vc_vvw_se_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2i64.nxv2i32.nxv2i32.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2i64.nxv2i32.nxv2i32.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define void @test_sf_vc_vvw_se_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4i64.nxv4i32.nxv4i32.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4i64.nxv4i32.nxv4i32.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define void @test_sf_vc_vvw_se_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_vvw_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8i64.nxv8i32.nxv8i32.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8i64.nxv8i32.nxv8i32.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_vvw_se_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv1i16.iXLen.nxv1i8.nxv1i8.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv1i16.iXLen.nxv1i8.nxv1i8.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, <vscale x 1 x i8>, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_vvw_se_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv2i16.iXLen.nxv2i8.nxv2i8.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv2i16.iXLen.nxv2i8.nxv2i8.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, <vscale x 2 x i8>, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_vvw_se_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv4i16.iXLen.nxv4i8.nxv4i8.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv4i16.iXLen.nxv4i8.nxv4i8.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, <vscale x 4 x i8>, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_vvw_se_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv8i16.iXLen.nxv8i8.nxv8i8.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv8i16.iXLen.nxv8i8.nxv8i8.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, <vscale x 8 x i8>, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_vvw_se_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv16i16.iXLen.nxv16i8.nxv16i8.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv16i16.iXLen.nxv16i8.nxv16i8.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, <vscale x 16 x i8>, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_vvw_se_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv32i16.iXLen.nxv32i8.nxv32i8.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvw.se.nxv32i16.iXLen.nxv32i8.nxv32i8.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, <vscale x 32 x i8>, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_vvw_se_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv1i32.iXLen.nxv1i16.nxv1i16.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv1i32.iXLen.nxv1i16.nxv1i16.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_vvw_se_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv2i32.iXLen.nxv2i16.nxv2i16.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv2i32.iXLen.nxv2i16.nxv2i16.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_vvw_se_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv4i32.iXLen.nxv4i16.nxv4i16.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv4i32.iXLen.nxv4i16.nxv4i16.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_vvw_se_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv8i32.iXLen.nxv8i16.nxv8i16.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv8i32.iXLen.nxv8i16.nxv8i16.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_vvw_se_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv16i32.iXLen.nxv16i16.nxv16i16.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvw.se.nxv16i32.iXLen.nxv16i16.nxv16i16.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_vvw_se_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv1i64.iXLen.nxv1i32.nxv1i32.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv1i64.iXLen.nxv1i32.nxv1i32.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_vvw_se_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv2i64.iXLen.nxv2i32.nxv2i32.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv2i64.iXLen.nxv2i32.nxv2i32.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_vvw_se_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv4i64.iXLen.nxv4i32.nxv4i32.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv4i64.iXLen.nxv4i32.nxv4i32.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_vvw_se_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv8i64.iXLen.nxv8i32.nxv8i32.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvw.se.nxv8i64.iXLen.nxv8i32.nxv8i32.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_vvw_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvw.nxv1i16.iXLen.nxv1i8.nxv1i8.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, <vscale x 1 x i8> %vs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.vvw.nxv1i16.iXLen.nxv1i8.nxv1i8.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, <vscale x 1 x i8>, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_vvw_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvw.nxv2i16.iXLen.nxv2i8.nxv2i8.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, <vscale x 2 x i8> %vs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.vvw.nxv2i16.iXLen.nxv2i8.nxv2i8.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, <vscale x 2 x i8>, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_vvw_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvw.nxv4i16.iXLen.nxv4i8.nxv4i8.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, <vscale x 4 x i8> %vs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.vvw.nxv4i16.iXLen.nxv4i8.nxv4i8.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, <vscale x 4 x i8>, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_vvw_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvw.nxv8i16.iXLen.nxv8i8.nxv8i8.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, <vscale x 8 x i8> %vs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.vvw.nxv8i16.iXLen.nxv8i8.nxv8i8.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, <vscale x 8 x i8>, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_vvw_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvw.nxv16i16.iXLen.nxv16i8.nxv16i8.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, <vscale x 16 x i8> %vs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.vvw.nxv16i16.iXLen.nxv16i8.nxv16i8.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, <vscale x 16 x i8>, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_vvw_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvw.nxv32i16.iXLen.nxv32i8.nxv32i8.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, <vscale x 32 x i8> %vs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.vvw.nxv32i16.iXLen.nxv32i8.nxv32i8.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, <vscale x 32 x i8>, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_vvw_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvw.nxv1i32.iXLen.nxv1i16.nxv1i16.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.vvw.nxv1i32.iXLen.nxv1i16.nxv1i16.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_vvw_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvw.nxv2i32.iXLen.nxv2i16.nxv2i16.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.vvw.nxv2i32.iXLen.nxv2i16.nxv2i16.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_vvw_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvw.nxv4i32.iXLen.nxv4i16.nxv4i16.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.vvw.nxv4i32.iXLen.nxv4i16.nxv4i16.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_vvw_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvw.nxv8i32.iXLen.nxv8i16.nxv8i16.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.vvw.nxv8i32.iXLen.nxv8i16.nxv8i16.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_vvw_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvw.nxv16i32.iXLen.nxv16i16.nxv16i16.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.vvw.nxv16i32.iXLen.nxv16i16.nxv16i16.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_vvw_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvw.nxv1i64.iXLen.nxv1i32.nxv1i32.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.vvw.nxv1i64.iXLen.nxv1i32.nxv1i32.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_vvw_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvw.nxv2i64.iXLen.nxv2i32.nxv2i32.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.vvw.nxv2i64.iXLen.nxv2i32.nxv2i32.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_vvw_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvw.nxv4i64.iXLen.nxv4i32.nxv4i32.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.vvw.nxv4i64.iXLen.nxv4i32.nxv4i32.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_vvw_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_vvw_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvw.nxv8i64.iXLen.nxv8i32.nxv8i32.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.vvw.nxv8i64.iXLen.nxv8i32.nxv8i32.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define void @test_sf_vc_xvw_se_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1i16.nxv1i8.i8.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1i16.nxv1i8.i8.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, i8, iXLen)

define void @test_sf_vc_xvw_se_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2i16.nxv2i8.i8.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2i16.nxv2i8.i8.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, i8, iXLen)

define void @test_sf_vc_xvw_se_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4i16.nxv4i8.i8.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4i16.nxv4i8.i8.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, i8, iXLen)

define void @test_sf_vc_xvw_se_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8i16.nxv8i8.i8.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8i16.nxv8i8.i8.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, i8, iXLen)

define void @test_sf_vc_xvw_se_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv16i16.nxv16i8.i8.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv16i16.nxv16i8.i8.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, i8, iXLen)

define void @test_sf_vc_xvw_se_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv32i16.nxv32i8.i8.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv32i16.nxv32i8.i8.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, i8, iXLen)

define void @test_sf_vc_xvw_se_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1i32.nxv1i16.i16.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1i32.nxv1i16.i16.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, i16, iXLen)

define void @test_sf_vc_xvw_se_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2i32.nxv2i16.i16.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2i32.nxv2i16.i16.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, i16, iXLen)

define void @test_sf_vc_xvw_se_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4i32.nxv4i16.i16.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4i32.nxv4i16.i16.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, i16, iXLen)

define void @test_sf_vc_xvw_se_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8i32.nxv8i16.i16.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8i32.nxv8i16.i16.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, i16, iXLen)

define void @test_sf_vc_xvw_se_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv16i32.nxv16i16.i16.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv16i32.nxv16i16.i16.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, i16, iXLen)

define void @test_sf_vc_xvw_se_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1i64.nxv1i32.i32.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1i64.nxv1i32.i32.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, i32, iXLen)

define void @test_sf_vc_xvw_se_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2i64.nxv2i32.i32.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2i64.nxv2i32.i32.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, i32, iXLen)

define void @test_sf_vc_xvw_se_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4i64.nxv4i32.i32.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4i64.nxv4i32.i32.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, i32, iXLen)

define void @test_sf_vc_xvw_se_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_xvw_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8i64.nxv8i32.i32.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8i64.nxv8i32.i32.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, i32, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_xvw_se_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv1i16.iXLen.nxv1i8.i8.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv1i16.iXLen.nxv1i8.i8.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, i8, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_xvw_se_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv2i16.iXLen.nxv2i8.i8.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv2i16.iXLen.nxv2i8.i8.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, i8, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_xvw_se_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv4i16.iXLen.nxv4i8.i8.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv4i16.iXLen.nxv4i8.i8.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, i8, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_xvw_se_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv8i16.iXLen.nxv8i8.i8.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv8i16.iXLen.nxv8i8.i8.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, i8, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_xvw_se_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv16i16.iXLen.nxv16i8.i8.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv16i16.iXLen.nxv16i8.i8.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, i8, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_xvw_se_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv32i16.iXLen.nxv32i8.i8.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvw.se.nxv32i16.iXLen.nxv32i8.i8.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, i8, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_xvw_se_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv1i32.iXLen.nxv1i16.i16.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv1i32.iXLen.nxv1i16.i16.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, i16, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_xvw_se_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv2i32.iXLen.nxv2i16.i16.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv2i32.iXLen.nxv2i16.i16.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, i16, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_xvw_se_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv4i32.iXLen.nxv4i16.i16.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv4i32.iXLen.nxv4i16.i16.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, i16, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_xvw_se_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv8i32.iXLen.nxv8i16.i16.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv8i32.iXLen.nxv8i16.i16.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, i16, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_xvw_se_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv16i32.iXLen.nxv16i16.i16.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvw.se.nxv16i32.iXLen.nxv16i16.i16.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, i16, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_xvw_se_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv1i64.i32.nxv1i32.iXLen.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv1i64.i32.nxv1i32.iXLen.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, i32, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_xvw_se_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv2i64.i32.nxv2i32.iXLen.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv2i64.i32.nxv2i32.iXLen.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, i32, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_xvw_se_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv4i64.i32.nxv4i32.iXLen.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv4i64.i32.nxv4i32.iXLen.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, i32, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_xvw_se_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv8i64.i32.nxv8i32.iXLen.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.xvw.se.nxv8i64.i32.nxv8i32.iXLen.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, i32, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_xvw_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvw.nxv1i16.iXLen.nxv1i8.i8.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.xvw.nxv1i16.iXLen.nxv1i8.i8.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, i8, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_xvw_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvw.nxv2i16.iXLen.nxv2i8.i8.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.xvw.nxv2i16.iXLen.nxv2i8.i8.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, i8, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_xvw_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvw.nxv4i16.iXLen.nxv4i8.i8.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.xvw.nxv4i16.iXLen.nxv4i8.i8.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, i8, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_xvw_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvw.nxv8i16.iXLen.nxv8i8.i8.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.xvw.nxv8i16.iXLen.nxv8i8.i8.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, i8, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_xvw_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvw.nxv16i16.iXLen.nxv16i8.i8.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.xvw.nxv16i16.iXLen.nxv16i8.i8.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, i8, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_xvw_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, i8 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvw.nxv32i16.iXLen.nxv32i8.i8.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, i8 %rs1, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.xvw.nxv32i16.iXLen.nxv32i8.i8.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, i8, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_xvw_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvw.nxv1i32.iXLen.nxv1i16.i16.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.xvw.nxv1i32.iXLen.nxv1i16.i16.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, i16, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_xvw_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvw.nxv2i32.iXLen.nxv2i16.i16.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.xvw.nxv2i32.iXLen.nxv2i16.i16.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, i16, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_xvw_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvw.nxv4i32.iXLen.nxv4i16.i16.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.xvw.nxv4i32.iXLen.nxv4i16.i16.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, i16, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_xvw_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvw.nxv8i32.iXLen.nxv8i16.i16.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.xvw.nxv8i32.iXLen.nxv8i16.i16.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, i16, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_xvw_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, i16 zeroext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvw.nxv16i32.iXLen.nxv16i16.i16.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.xvw.nxv16i32.iXLen.nxv16i16.i16.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, i16, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_xvw_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.xvw.nxv1i64.iXLen.nxv1i32.i32.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.xvw.nxv1i64.iXLen.nxv1i32.i32.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, i32, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_xvw_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.xvw.nxv2i64.iXLen.nxv2i32.i32.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.xvw.nxv2i64.iXLen.nxv2i32.i32.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, i32, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_xvw_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.xvw.nxv4i64.iXLen.nxv4i32.i32.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.xvw.nxv4i64.iXLen.nxv4i32.i32.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, i32, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_xvw_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, i32 signext %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_xvw_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.xvw.nxv8i64.iXLen.nxv8i32.i32.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.xvw.nxv8i64.iXLen.nxv8i32.i32.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, i32, iXLen)

define void @test_sf_vc_ivw_se_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1i16.nxv1i8.iXLen.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1i16.nxv1i8.iXLen.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2i16.nxv2i8.iXLen.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2i16.nxv2i8.iXLen.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4i16.nxv4i8.iXLen.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4i16.nxv4i8.iXLen.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8i16.nxv8i8.iXLen.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8i16.nxv8i8.iXLen.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv16i16.nxv16i8.iXLen.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv16i16.nxv16i8.iXLen.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv32i16.nxv32i8.iXLen.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv32i16.nxv32i8.iXLen.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1i32.nxv1i16.iXLen.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1i32.nxv1i16.iXLen.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2i32.nxv2i16.iXLen.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2i32.nxv2i16.iXLen.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4i32.nxv4i16.iXLen.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4i32.nxv4i16.iXLen.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8i32.nxv8i16.iXLen.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8i32.nxv8i16.iXLen.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv16i32.nxv16i16.iXLen.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv16i32.nxv16i16.iXLen.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1i64.nxv1i32.iXLen.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1i64.nxv1i32.iXLen.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2i64.nxv2i32.iXLen.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2i64.nxv2i32.iXLen.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4i64.nxv4i32.iXLen.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4i64.nxv4i32.iXLen.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, iXLen, iXLen)

define void @test_sf_vc_ivw_se_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_ivw_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8i64.nxv8i32.iXLen.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8i64.nxv8i32.iXLen.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, iXLen, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_ivw_se_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv1i16.iXLen.nxv1i8.iXLen.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv1i16.iXLen.nxv1i8.iXLen.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, iXLen, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_ivw_se_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv2i16.iXLen.nxv2i8.iXLen.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv2i16.iXLen.nxv2i8.iXLen.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, iXLen, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_ivw_se_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv4i16.iXLen.nxv4i8.iXLen.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv4i16.iXLen.nxv4i8.iXLen.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, iXLen, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_ivw_se_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv8i16.iXLen.nxv8i8.iXLen.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv8i16.iXLen.nxv8i8.iXLen.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, iXLen, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_ivw_se_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv16i16.iXLen.nxv16i8.iXLen.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv16i16.iXLen.nxv16i8.iXLen.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, iXLen, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_ivw_se_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv32i16.iXLen.nxv32i8.iXLen.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivw.se.nxv32i16.iXLen.nxv32i8.iXLen.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, iXLen, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_ivw_se_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv1i32.iXLen.nxv1i16.iXLen.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv1i32.iXLen.nxv1i16.iXLen.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, iXLen, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_ivw_se_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv2i32.iXLen.nxv2i16.iXLen.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv2i32.iXLen.nxv2i16.iXLen.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, iXLen, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_ivw_se_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv4i32.iXLen.nxv4i16.iXLen.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv4i32.iXLen.nxv4i16.iXLen.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, iXLen, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_ivw_se_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv8i32.iXLen.nxv8i16.iXLen.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv8i32.iXLen.nxv8i16.iXLen.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, iXLen, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_ivw_se_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv16i32.iXLen.nxv16i16.iXLen.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivw.se.nxv16i32.iXLen.nxv16i16.iXLen.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, iXLen, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_ivw_se_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv1i64.iXLen.nxv1i32.iXLen.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv1i64.iXLen.nxv1i32.iXLen.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, iXLen, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_ivw_se_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv2i64.iXLen.nxv2i32.iXLen.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv2i64.iXLen.nxv2i32.iXLen.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, iXLen, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_ivw_se_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv4i64.iXLen.nxv4i32.iXLen.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv4i64.iXLen.nxv4i32.iXLen.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, iXLen, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_ivw_se_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv8i64.iXLen.nxv8i32.iXLen.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivw.se.nxv8i64.iXLen.nxv8i32.iXLen.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, iXLen, iXLen)

define <vscale x 1 x i16> @test_sf_vc_v_ivw_e8mf8(<vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e8mf8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf8, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivw.nxv1i16.iXLen.nxv1i8.iXLen.iXLen(iXLen 3, <vscale x 1 x i16> %vd, <vscale x 1 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i16> %0
}

declare <vscale x 1 x i16> @llvm.riscv.sf.vc.v.ivw.nxv1i16.iXLen.nxv1i8.iXLen.iXLen(iXLen, <vscale x 1 x i16>, <vscale x 1 x i8>, iXLen, iXLen)

define <vscale x 2 x i16> @test_sf_vc_v_ivw_e8mf4(<vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e8mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivw.nxv2i16.iXLen.nxv2i8.iXLen.iXLen(iXLen 3, <vscale x 2 x i16> %vd, <vscale x 2 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i16> %0
}

declare <vscale x 2 x i16> @llvm.riscv.sf.vc.v.ivw.nxv2i16.iXLen.nxv2i8.iXLen.iXLen(iXLen, <vscale x 2 x i16>, <vscale x 2 x i8>, iXLen, iXLen)

define <vscale x 4 x i16> @test_sf_vc_v_ivw_e8mf2(<vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e8mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivw.nxv4i16.iXLen.nxv4i8.iXLen.iXLen(iXLen 3, <vscale x 4 x i16> %vd, <vscale x 4 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i16> %0
}

declare <vscale x 4 x i16> @llvm.riscv.sf.vc.v.ivw.nxv4i16.iXLen.nxv4i8.iXLen.iXLen(iXLen, <vscale x 4 x i16>, <vscale x 4 x i8>, iXLen, iXLen)

define <vscale x 8 x i16> @test_sf_vc_v_ivw_e8m1(<vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e8m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivw.nxv8i16.iXLen.nxv8i8.iXLen.iXLen(iXLen 3, <vscale x 8 x i16> %vd, <vscale x 8 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i16> %0
}

declare <vscale x 8 x i16> @llvm.riscv.sf.vc.v.ivw.nxv8i16.iXLen.nxv8i8.iXLen.iXLen(iXLen, <vscale x 8 x i16>, <vscale x 8 x i8>, iXLen, iXLen)

define <vscale x 16 x i16> @test_sf_vc_v_ivw_e8m2(<vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e8m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivw.nxv16i16.iXLen.nxv16i8.iXLen.iXLen(iXLen 3, <vscale x 16 x i16> %vd, <vscale x 16 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i16> %0
}

declare <vscale x 16 x i16> @llvm.riscv.sf.vc.v.ivw.nxv16i16.iXLen.nxv16i8.iXLen.iXLen(iXLen, <vscale x 16 x i16>, <vscale x 16 x i8>, iXLen, iXLen)

define <vscale x 32 x i16> @test_sf_vc_v_ivw_e8m4(<vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e8m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e8, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivw.nxv32i16.iXLen.nxv32i8.iXLen.iXLen(iXLen 3, <vscale x 32 x i16> %vd, <vscale x 32 x i8> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 32 x i16> %0
}

declare <vscale x 32 x i16> @llvm.riscv.sf.vc.v.ivw.nxv32i16.iXLen.nxv32i8.iXLen.iXLen(iXLen, <vscale x 32 x i16>, <vscale x 32 x i8>, iXLen, iXLen)

define <vscale x 1 x i32> @test_sf_vc_v_ivw_e16mf4(<vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e16mf4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivw.nxv1i32.iXLen.nxv1i16.iXLen.iXLen(iXLen 3, <vscale x 1 x i32> %vd, <vscale x 1 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i32> %0
}

declare <vscale x 1 x i32> @llvm.riscv.sf.vc.v.ivw.nxv1i32.iXLen.nxv1i16.iXLen.iXLen(iXLen, <vscale x 1 x i32>, <vscale x 1 x i16>, iXLen, iXLen)

define <vscale x 2 x i32> @test_sf_vc_v_ivw_e16mf2(<vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e16mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivw.nxv2i32.iXLen.nxv2i16.iXLen.iXLen(iXLen 3, <vscale x 2 x i32> %vd, <vscale x 2 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i32> %0
}

declare <vscale x 2 x i32> @llvm.riscv.sf.vc.v.ivw.nxv2i32.iXLen.nxv2i16.iXLen.iXLen(iXLen, <vscale x 2 x i32>, <vscale x 2 x i16>, iXLen, iXLen)

define <vscale x 4 x i32> @test_sf_vc_v_ivw_e16m1(<vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e16m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivw.nxv4i32.iXLen.nxv4i16.iXLen.iXLen(iXLen 3, <vscale x 4 x i32> %vd, <vscale x 4 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i32> %0
}

declare <vscale x 4 x i32> @llvm.riscv.sf.vc.v.ivw.nxv4i32.iXLen.nxv4i16.iXLen.iXLen(iXLen, <vscale x 4 x i32>, <vscale x 4 x i16>, iXLen, iXLen)

define <vscale x 8 x i32> @test_sf_vc_v_ivw_e16m2(<vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e16m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivw.nxv8i32.iXLen.nxv8i16.iXLen.iXLen(iXLen 3, <vscale x 8 x i32> %vd, <vscale x 8 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i32> %0
}

declare <vscale x 8 x i32> @llvm.riscv.sf.vc.v.ivw.nxv8i32.iXLen.nxv8i16.iXLen.iXLen(iXLen, <vscale x 8 x i32>, <vscale x 8 x i16>, iXLen, iXLen)

define <vscale x 16 x i32> @test_sf_vc_v_ivw_e16m4(<vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e16m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivw.nxv16i32.iXLen.nxv16i16.iXLen.iXLen(iXLen 3, <vscale x 16 x i32> %vd, <vscale x 16 x i16> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 16 x i32> %0
}

declare <vscale x 16 x i32> @llvm.riscv.sf.vc.v.ivw.nxv16i32.iXLen.nxv16i16.iXLen.iXLen(iXLen, <vscale x 16 x i32>, <vscale x 16 x i16>, iXLen, iXLen)

define <vscale x 1 x i64> @test_sf_vc_v_ivw_e32mf2(<vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivw.nxv1i64.iXLen.nxv1i32.iXLen.iXLen(iXLen 3, <vscale x 1 x i64> %vd, <vscale x 1 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 1 x i64> %0
}

declare <vscale x 1 x i64> @llvm.riscv.sf.vc.v.ivw.nxv1i64.iXLen.nxv1i32.iXLen.iXLen(iXLen, <vscale x 1 x i64>, <vscale x 1 x i32>, iXLen, iXLen)

define <vscale x 2 x i64> @test_sf_vc_v_ivw_e32m1(<vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivw.nxv2i64.iXLen.nxv2i32.iXLen.iXLen(iXLen 3, <vscale x 2 x i64> %vd, <vscale x 2 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 2 x i64> %0
}

declare <vscale x 2 x i64> @llvm.riscv.sf.vc.v.ivw.nxv2i64.iXLen.nxv2i32.iXLen.iXLen(iXLen, <vscale x 2 x i64>, <vscale x 2 x i32>, iXLen, iXLen)

define <vscale x 4 x i64> @test_sf_vc_v_ivw_e32m2(<vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivw.nxv4i64.iXLen.nxv4i32.iXLen.iXLen(iXLen 3, <vscale x 4 x i64> %vd, <vscale x 4 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 4 x i64> %0
}

declare <vscale x 4 x i64> @llvm.riscv.sf.vc.v.ivw.nxv4i64.iXLen.nxv4i32.iXLen.iXLen(iXLen, <vscale x 4 x i64>, <vscale x 4 x i32>, iXLen, iXLen)

define <vscale x 8 x i64> @test_sf_vc_v_ivw_e32m4(<vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_v_ivw_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivw.nxv8i64.iXLen.nxv8i32.iXLen.iXLen(iXLen 3, <vscale x 8 x i64> %vd, <vscale x 8 x i32> %vs2, iXLen 10, iXLen %vl)
  ret <vscale x 8 x i64> %0
}

declare <vscale x 8 x i64> @llvm.riscv.sf.vc.v.ivw.nxv8i64.iXLen.nxv8i32.iXLen.iXLen(iXLen, <vscale x 8 x i64>, <vscale x 8 x i32>, iXLen, iXLen)

define void @test_sf_vc_fwvv_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1f32.nxv1i16.nxv1i16.iXLen(iXLen 3, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1f32.nxv1i16.nxv1i16.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define <vscale x 1 x float> @test_sf_vc_fw_fwvvv_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv1f32.nxv1i16.nxv1i16.iXLen(iXLen 3, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, <vscale x 1 x i16> %vs1, iXLen %vl)
  ret <vscale x 1 x float> %0
}

declare <vscale x 1 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv1f32.nxv1i16.nxv1i16.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, <vscale x 1 x i16>, iXLen)

define void @test_sf_vc_fwvv_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2f32.nxv2i16.nxv2i16.iXLen(iXLen 3, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2f32.nxv2i16.nxv2i16.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define <vscale x 2 x float> @test_sf_vc_fw_fwvvv_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv2f32.nxv2i16.nxv2i16.iXLen(iXLen 3, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, <vscale x 2 x i16> %vs1, iXLen %vl)
  ret <vscale x 2 x float> %0
}

declare <vscale x 2 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv2f32.nxv2i16.nxv2i16.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, <vscale x 2 x i16>, iXLen)

define void @test_sf_vc_fwvv_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4f32.nxv4i16.nxv4i16.iXLen(iXLen 3, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4f32.nxv4i16.nxv4i16.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define <vscale x 4 x float> @test_sf_vc_fw_fwvvv_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv4f32.nxv4i16.nxv4i16.iXLen(iXLen 3, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, <vscale x 4 x i16> %vs1, iXLen %vl)
  ret <vscale x 4 x float> %0
}

declare <vscale x 4 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv4f32.nxv4i16.nxv4i16.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, <vscale x 4 x i16>, iXLen)

define void @test_sf_vc_fwvv_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8f32.nxv8i16.nxv8i16.iXLen(iXLen 3, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8f32.nxv8i16.nxv8i16.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define <vscale x 8 x float> @test_sf_vc_fw_fwvvv_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv8f32.nxv8i16.nxv8i16.iXLen(iXLen 3, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, <vscale x 8 x i16> %vs1, iXLen %vl)
  ret <vscale x 8 x float> %0
}

declare <vscale x 8 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv8f32.nxv8i16.nxv8i16.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, <vscale x 8 x i16>, iXLen)

define void @test_sf_vc_fwvv_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv16f32.nxv16i16.nxv16i16.iXLen(iXLen 3, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv16f32.nxv16i16.nxv16i16.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define <vscale x 16 x float> @test_sf_vc_fw_fwvvv_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv16f32.nxv16i16.nxv16i16.iXLen(iXLen 3, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, <vscale x 16 x i16> %vs1, iXLen %vl)
  ret <vscale x 16 x float> %0
}

declare <vscale x 16 x float> @llvm.riscv.sf.vc.v.vvw.se.nxv16f32.nxv16i16.nxv16i16.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, <vscale x 16 x i16>, iXLen)

define void @test_sf_vc_fwvv_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1f64.nxv1i32.nxv1i32.iXLen(iXLen 3, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv1f64.nxv1i32.nxv1i32.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define <vscale x 1 x double> @test_sf_vc_fw_fwvvv_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v9, v10
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv1f64.nxv1i32.nxv1i32.iXLen(iXLen 3, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, <vscale x 1 x i32> %vs1, iXLen %vl)
  ret <vscale x 1 x double> %0
}

declare <vscale x 1 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv1f64.nxv1i32.nxv1i32.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, <vscale x 1 x i32>, iXLen)

define void @test_sf_vc_fwvv_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2f64.nxv2i32.nxv2i32.iXLen(iXLen 3, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv2f64.nxv2i32.nxv2i32.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define <vscale x 2 x double> @test_sf_vc_fw_fwvvv_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v10, v11
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv2f64.nxv2i32.nxv2i32.iXLen(iXLen 3, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, <vscale x 2 x i32> %vs1, iXLen %vl)
  ret <vscale x 2 x double> %0
}

declare <vscale x 2 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv2f64.nxv2i32.nxv2i32.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, <vscale x 2 x i32>, iXLen)

define void @test_sf_vc_fwvv_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4f64.nxv4i32.nxv4i32.iXLen(iXLen 3, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv4f64.nxv4i32.nxv4i32.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define <vscale x 4 x double> @test_sf_vc_fw_fwvvv_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v12, v14
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv4f64.nxv4i32.nxv4i32.iXLen(iXLen 3, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, <vscale x 4 x i32> %vs1, iXLen %vl)
  ret <vscale x 4 x double> %0
}

declare <vscale x 4 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv4f64.nxv4i32.nxv4i32.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, <vscale x 4 x i32>, iXLen)

define void @test_sf_vc_fwvv_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8f64.nxv8i32.nxv8i32.iXLen(iXLen 3, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.vvw.se.iXLen.nxv8f64.nxv8i32.nxv8i32.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define <vscale x 8 x double> @test_sf_vc_fw_fwvvv_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvvv_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.vvw 3, v8, v16, v20
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv8f64.nxv8i32.nxv8i32.iXLen(iXLen 3, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, <vscale x 8 x i32> %vs1, iXLen %vl)
  ret <vscale x 8 x double> %0
}

declare <vscale x 8 x double> @llvm.riscv.sf.vc.v.vvw.se.nxv8f64.nxv8i32.nxv8i32.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, <vscale x 8 x i32>, iXLen)

define void @test_sf_vc_fwvx_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1f32.nxv1i16.i16.iXLen(iXLen 3, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1f32.nxv1i16.i16.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, i16, iXLen)

define <vscale x 1 x float> @test_sf_vc_w_fwvx_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv1f32.nxv1f16.nxv1i16.i16.iXLen(iXLen 3, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 1 x float> %0
}

declare <vscale x 1 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv1f32.nxv1f16.nxv1i16.i16.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, i16, iXLen)

define void @test_sf_vc_fwvx_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2f32.nxv2i16.i16.iXLen(iXLen 3, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2f32.nxv2i16.i16.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, i16, iXLen)

define <vscale x 2 x float> @test_sf_vc_w_fwvx_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv2f32.nxv2f16.nxv2i16.i16.iXLen(iXLen 3, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 2 x float> %0
}

declare <vscale x 2 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv2f32.nxv2f16.nxv2i16.i16.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, i16, iXLen)

define void @test_sf_vc_fwvx_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4f32.nxv4i16.i16.iXLen(iXLen 3, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4f32.nxv4i16.i16.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, i16, iXLen)

define <vscale x 4 x float> @test_sf_vc_w_fwvx_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv4f32.nxv4f16.nxv4i16.i16.iXLen(iXLen 3, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 4 x float> %0
}

declare <vscale x 4 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv4f32.nxv4f16.nxv4i16.i16.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, i16, iXLen)

define void @test_sf_vc_fwvx_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8f32.nxv8i16.i16.iXLen(iXLen 3, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8f32.nxv8i16.i16.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, i16, iXLen)

define <vscale x 8 x float> @test_sf_vc_w_fwvx_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv8f32.nxv8f16.nxv8i16.i16.iXLen(iXLen 3, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 8 x float> %0
}

declare <vscale x 8 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv8f32.nxv8f16.nxv8i16.i16.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, i16, iXLen)

define void @test_sf_vc_fwvx_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv16f32.nxv16i16.i16.iXLen(iXLen 3, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv16f32.nxv16i16.i16.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, i16, iXLen)

define <vscale x 16 x float> @test_sf_vc_w_fwvx_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv16f32.nxv16f16.nxv16i16.i16.iXLen(iXLen 3, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, i16 %rs1, iXLen %vl)
  ret <vscale x 16 x float> %0
}

declare <vscale x 16 x float> @llvm.riscv.sf.vc.v.xvw.se.nxv16f32.nxv16f16.nxv16i16.i16.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, i16, iXLen)

define void @test_sf_vc_fwvx_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1f64.nxv1i32.i32.iXLen(iXLen 3, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv1f64.nxv1i32.i32.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, i32, iXLen)

define <vscale x 1 x double> @test_sf_vc_w_fwvx_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v9, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv1f64.nxv1f32.nxv1i32.i32.iXLen(iXLen 3, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 1 x double> %0
}

declare <vscale x 1 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv1f64.nxv1f32.nxv1i32.i32.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, i32, iXLen)

define void @test_sf_vc_fwvx_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2f64.nxv2i32.i32.iXLen(iXLen 3, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv2f64.nxv2i32.i32.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, i32, iXLen)

define <vscale x 2 x double> @test_sf_vc_w_fwvx_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v10, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv2f64.nxv2f32.nxv2i32.i32.iXLen(iXLen 3, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 2 x double> %0
}

declare <vscale x 2 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv2f64.nxv2f32.nxv2i32.i32.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, i32, iXLen)

define void @test_sf_vc_fwvx_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4f64.nxv4i32.i32.iXLen(iXLen 3, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv4f64.nxv4i32.i32.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, i32, iXLen)

define <vscale x 4 x double> @test_sf_vc_w_fwvx_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v12, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv4f64.nxv4f32.nxv4i32.i32.iXLen(iXLen 3, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 4 x double> %0
}

declare <vscale x 4 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv4f64.nxv4f32.nxv4i32.i32.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, i32, iXLen)

define void @test_sf_vc_fwvx_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvx_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8f64.nxv8i32.i32.iXLen(iXLen 3, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.xvw.se.iXLen.nxv8f64.nxv8i32.i32.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, i32, iXLen)

define <vscale x 8 x double> @test_sf_vc_w_fwvx_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_w_fwvx_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a1, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.xvw 3, v8, v16, a0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv8f64.nxv8f32.nxv8i32.i32.iXLen(iXLen 3, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, i32 %rs1, iXLen %vl)
  ret <vscale x 8 x double> %0
}

declare <vscale x 8 x double> @llvm.riscv.sf.vc.v.xvw.se.nxv8f64.nxv8f32.nxv8i32.i32.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, i32, iXLen)

define void @test_sf_vc_fwvi_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1f32.nxv1i16.iXLen.iXLen(iXLen 3, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1f32.nxv1i16.iXLen.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, iXLen, iXLen)

define <vscale x 1 x float> @test_sf_vc_fw_fwvi_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv1f32.nxv1f16.nxv1i16.iXLen.iXLen(iXLen 3, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 1 x float> %0
}

declare <vscale x 1 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv1f32.nxv1f16.nxv1i16.iXLen.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2f32.nxv2i16.iXLen.iXLen(iXLen 3, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2f32.nxv2i16.iXLen.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, iXLen, iXLen)

define <vscale x 2 x float> @test_sf_vc_fw_fwvi_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv2f32.nxv2f16.nxv2i16.iXLen.iXLen(iXLen 3, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 2 x float> %0
}

declare <vscale x 2 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv2f32.nxv2f16.nxv2i16.iXLen.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4f32.nxv4i16.iXLen.iXLen(iXLen 3, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4f32.nxv4i16.iXLen.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, iXLen, iXLen)

define <vscale x 4 x float> @test_sf_vc_fw_fwvi_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv4f32.nxv4f16.nxv4i16.iXLen.iXLen(iXLen 3, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 4 x float> %0
}

declare <vscale x 4 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv4f32.nxv4f16.nxv4i16.iXLen.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8f32.nxv8i16.iXLen.iXLen(iXLen 3, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8f32.nxv8i16.iXLen.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, iXLen, iXLen)

define <vscale x 8 x float> @test_sf_vc_fw_fwvi_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv8f32.nxv8f16.nxv8i16.iXLen.iXLen(iXLen 3, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 8 x float> %0
}

declare <vscale x 8 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv8f32.nxv8f16.nxv8i16.iXLen.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v16, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv16f32.nxv16i16.iXLen.iXLen(iXLen 3, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv16f32.nxv16i16.iXLen.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, iXLen, iXLen)

define <vscale x 16 x float> @test_sf_vc_fw_fwvi_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv16f32.nxv16f16.nxv16i16.iXLen.iXLen(iXLen 3, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 16 x float> %0
}

declare <vscale x 16 x float> @llvm.riscv.sf.vc.v.ivw.se.nxv16f32.nxv16f16.nxv16i16.iXLen.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1f64.nxv1i32.iXLen.iXLen(iXLen 3, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv1f64.nxv1i32.iXLen.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, iXLen, iXLen)

define <vscale x 1 x double> @test_sf_vc_fw_fwvi_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v9, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv1f64.nxv1f32.nxv1i32.iXLen.iXLen(iXLen 3, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 1 x double> %0
}

declare <vscale x 1 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv1f64.nxv1f32.nxv1i32.iXLen.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2f64.nxv2i32.iXLen.iXLen(iXLen 3, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv2f64.nxv2i32.iXLen.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, iXLen, iXLen)

define <vscale x 2 x double> @test_sf_vc_fw_fwvi_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v10, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv2f64.nxv2f32.nxv2i32.iXLen.iXLen(iXLen 3, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 2 x double> %0
}

declare <vscale x 2 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv2f64.nxv2f32.nxv2i32.iXLen.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4f64.nxv4i32.iXLen.iXLen(iXLen 3, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv4f64.nxv4i32.iXLen.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, iXLen, iXLen)

define <vscale x 4 x double> @test_sf_vc_fw_fwvi_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v12, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv4f64.nxv4f32.nxv4i32.iXLen.iXLen(iXLen 3, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 4 x double> %0
}

declare <vscale x 4 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv4f64.nxv4f32.nxv4i32.iXLen.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, iXLen, iXLen)

define void @test_sf_vc_fwvi_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvi_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.ivw 3, v8, v16, 3
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8f64.nxv8i32.iXLen.iXLen(iXLen 3, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, iXLen 3, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.ivw.se.iXLen.nxv8f64.nxv8i32.iXLen.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, iXLen, iXLen)

define <vscale x 8 x double> @test_sf_vc_fw_fwvi_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvi_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.ivw 3, v8, v16, 3
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv8f64.nxv8f32.nxv8i32.iXLen.iXLen(iXLen 3, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, iXLen 3, iXLen %vl)
  ret <vscale x 8 x double> %0
}

declare <vscale x 8 x double> @llvm.riscv.sf.vc.v.ivw.se.nxv8f64.nxv8f32.nxv8i32.iXLen.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, iXLen, iXLen)

define void @test_sf_vc_fwvf_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv1f32.nxv1i16.f16.iXLen(iXLen 1, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv1f32.nxv1i16.f16.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, half, iXLen)

define <vscale x 1 x float> @test_sf_vc_fw_fwvf_se_e32mf2(<vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e32mf2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv1f32.nxv1f16.nxv1i16.f16.iXLen(iXLen 1, <vscale x 1 x float> %vd, <vscale x 1 x i16> %vs2, half %rs1, iXLen %vl)
  ret <vscale x 1 x float> %0
}

declare <vscale x 1 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv1f32.nxv1f16.nxv1i16.f16.iXLen(iXLen, <vscale x 1 x float>, <vscale x 1 x i16>, half, iXLen)

define void @test_sf_vc_fwvf_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv2f32.nxv2i16.f16.iXLen(iXLen 1, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv2f32.nxv2i16.f16.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, half, iXLen)

define <vscale x 2 x float> @test_sf_vc_fw_fwvf_se_e32m1(<vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e32m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv2f32.nxv2f16.nxv2i16.f16.iXLen(iXLen 1, <vscale x 2 x float> %vd, <vscale x 2 x i16> %vs2, half %rs1, iXLen %vl)
  ret <vscale x 2 x float> %0
}

declare <vscale x 2 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv2f32.nxv2f16.nxv2i16.f16.iXLen(iXLen, <vscale x 2 x float>, <vscale x 2 x i16>, half, iXLen)

define void @test_sf_vc_fwvf_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv4f32.nxv4i16.f16.iXLen(iXLen 1, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv4f32.nxv4i16.f16.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, half, iXLen)

define <vscale x 4 x float> @test_sf_vc_fw_fwvf_se_e32m2(<vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e32m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv4f32.nxv4f16.nxv4i16.f16.iXLen(iXLen 1, <vscale x 4 x float> %vd, <vscale x 4 x i16> %vs2, half %rs1, iXLen %vl)
  ret <vscale x 4 x float> %0
}

declare <vscale x 4 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv4f32.nxv4f16.nxv4i16.f16.iXLen(iXLen, <vscale x 4 x float>, <vscale x 4 x i16>, half, iXLen)

define void @test_sf_vc_fwvf_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv8f32.nxv8i16.f16.iXLen(iXLen 1, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv8f32.nxv8i16.f16.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, half, iXLen)

define <vscale x 8 x float> @test_sf_vc_fw_fwvf_se_e32m4(<vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e32m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv8f32.nxv8f16.nxv8i16.f16.iXLen(iXLen 1, <vscale x 8 x float> %vd, <vscale x 8 x i16> %vs2, half %rs1, iXLen %vl)
  ret <vscale x 8 x float> %0
}

declare <vscale x 8 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv8f32.nxv8f16.nxv8i16.f16.iXLen(iXLen, <vscale x 8 x float>, <vscale x 8 x i16>, half, iXLen)

define void @test_sf_vc_fwvf_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v16, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv16f32.nxv16i16.f16.iXLen(iXLen 1, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, half %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv16f32.nxv16i16.f16.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, half, iXLen)

define <vscale x 16 x float> @test_sf_vc_fw_fwvf_se_e32m8(<vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, half %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e32m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e16, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v16, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 16 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv16f32.nxv16f16.nxv16i16.f16.iXLen(iXLen 1, <vscale x 16 x float> %vd, <vscale x 16 x i16> %vs2, half %rs1, iXLen %vl)
  ret <vscale x 16 x float> %0
}

declare <vscale x 16 x float> @llvm.riscv.sf.vc.v.fvw.se.nxv16f32.nxv16f16.nxv16i16.f16.iXLen(iXLen, <vscale x 16 x float>, <vscale x 16 x i16>, half, iXLen)

define void @test_sf_vc_fwvf_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv1f64.nxv1i32.f32.iXLen(iXLen 1, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv1f64.nxv1i32.f32.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, float, iXLen)

define <vscale x 1 x double> @test_sf_vc_fw_fwvf_se_e64m1(<vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e64m1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, mf2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v9, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 1 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv1f64.nxv1f32.nxv1i32.f32.iXLen(iXLen 1, <vscale x 1 x double> %vd, <vscale x 1 x i32> %vs2, float %rs1, iXLen %vl)
  ret <vscale x 1 x double> %0
}

declare <vscale x 1 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv1f64.nxv1f32.nxv1i32.f32.iXLen(iXLen, <vscale x 1 x double>, <vscale x 1 x i32>, float, iXLen)

define void @test_sf_vc_fwvf_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv2f64.nxv2i32.f32.iXLen(iXLen 1, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv2f64.nxv2i32.f32.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, float, iXLen)

define <vscale x 2 x double> @test_sf_vc_fw_fwvf_se_e64m2(<vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e64m2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m1, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v10, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 2 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv2f64.nxv2f32.nxv2i32.f32.iXLen(iXLen 1, <vscale x 2 x double> %vd, <vscale x 2 x i32> %vs2, float %rs1, iXLen %vl)
  ret <vscale x 2 x double> %0
}

declare <vscale x 2 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv2f64.nxv2f32.nxv2i32.f32.iXLen(iXLen, <vscale x 2 x double>, <vscale x 2 x i32>, float, iXLen)

define void @test_sf_vc_fwvf_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv4f64.nxv4i32.f32.iXLen(iXLen 1, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv4f64.nxv4i32.f32.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, float, iXLen)

define <vscale x 4 x double> @test_sf_vc_fw_fwvf_se_e64m4(<vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e64m4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m2, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v12, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 4 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv4f64.nxv4f32.nxv4i32.f32.iXLen(iXLen 1, <vscale x 4 x double> %vd, <vscale x 4 x i32> %vs2, float %rs1, iXLen %vl)
  ret <vscale x 4 x double> %0
}

declare <vscale x 4 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv4f64.nxv4f32.nxv4i32.f32.iXLen(iXLen, <vscale x 4 x double>, <vscale x 4 x i32>, float, iXLen)

define void @test_sf_vc_fwvf_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fwvf_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, ta, ma
; CHECK-NEXT:    sf.vc.fvw 1, v8, v16, fa0
; CHECK-NEXT:    ret
entry:
  tail call void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv8f64.nxv8i32.f32.iXLen(iXLen 1, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, float %rs1, iXLen %vl)
  ret void
}

declare void @llvm.riscv.sf.vc.fvw.se.iXLen.nxv8f64.nxv8i32.f32.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, float, iXLen)

define <vscale x 8 x double> @test_sf_vc_fw_fwvf_se_e64m8(<vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, float %rs1, iXLen %vl) {
; CHECK-LABEL: test_sf_vc_fw_fwvf_se_e64m8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vsetvli zero, a0, e32, m4, tu, ma
; CHECK-NEXT:    sf.vc.v.fvw 1, v8, v16, fa0
; CHECK-NEXT:    ret
entry:
  %0 = tail call <vscale x 8 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv8f64.nxv8f32.nxv8i32.f32.iXLen(iXLen 1, <vscale x 8 x double> %vd, <vscale x 8 x i32> %vs2, float %rs1, iXLen %vl)
  ret <vscale x 8 x double> %0
}

declare <vscale x 8 x double> @llvm.riscv.sf.vc.v.fvw.se.nxv8f64.nxv8f32.nxv8i32.f32.iXLen(iXLen, <vscale x 8 x double>, <vscale x 8 x i32>, float, iXLen)
