/* { dg-do run { target { riscv_v } } } */
/* { dg-additional-options "-std=c99" } */

#include "vec_sat_arith.h"

#define T                  uint32_t
#define N                  16
#define RUN_VEC_SAT_BINARY RUN_VEC_SAT_U_SUB_FMT_7

DEF_VEC_SAT_U_SUB_FMT_7(T)

T test_data[][3][N] = {
  {
    {
      0, 0, 4, 0,
      0, 0, 4, 0,
      0, 0, 4, 0,
      0, 0, 4, 0,
    }, /* arg_0 */
    {
      0, 1, 2, 3,
      0, 1, 2, 3,
      0, 1, 2, 3,
      0, 1, 2, 3,
    }, /* arg_1 */
    {
      0, 0, 2, 0,
      0, 0, 2, 0,
      0, 0, 2, 0,
      0, 0, 2, 0,
    }, /* expect */
  },
  {
    {
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
      4294967295, 4294967295, 4294967295, 4294967295,
    },
    {
      1294967295, 2294967295, 3294967295, 4294967295,
      1294967295, 2294967295, 3294967295, 4294967295,
      1294967295, 2294967295, 3294967295, 4294967295,
      1294967295, 2294967295, 3294967295, 4294967295,
    },
    {
      3000000000, 2000000000, 1000000000,          0,
      3000000000, 2000000000, 1000000000,          0,
      3000000000, 2000000000, 1000000000,          0,
      3000000000, 2000000000, 1000000000,          0,
    },
  },
  {
    {
	       0,          0,          9,          0,
	       1, 4294967295,          3,          0,
	       1,          2,          3,          4,
	       5, 4294967294, 4294967295, 4294967295,
    },
    {
	       0,          1,          1, 4294967294,
	       1,          2, 4294967294, 4294967295,
	       1, 4294967295, 4294967295,          1,
	       1, 4294967295, 4294967290,          9,
    },
    {
	       0,          0,          8,          0,
	       0, 4294967293,          0,          0,
	       0,          0,          0,          3,
	       4,          0,          5, 4294967286,
    },
  },
};

#include "vec_sat_binary_vvv_run.h"
