/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_propgrid.h"
        #include <wx/propgrid/propgridiface.h>
        #include <wx/propgrid/editors.h>
        #include <wx/propgrid/property.h>
        #include <wx/propgrid/propgridiface.h>
        #include <wx/datetime.h>
        #include <wx/object.h>
        #include <wx/validate.h>
        #include <wx/colour.h>
        #include <wx/bmpbndl.h>
        #include <wx/propgrid/propgridpagestate.h>
        #include <wx/propgrid/propgridpagestate.h>
        #include <wx/bitmap.h>
        #include <wx/propgrid/property.h>
        #include <wx/propgrid/property.h>
        #include <wx/propgrid/propgridpagestate.h>


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetIterator, "GetIterator(flags=PG_ITERATE_DEFAULT, firstProp=None) -> PropertyGridIterator\n"
"GetIterator(flags, startPos) -> PropertyGridIterator\n"
"\n"
"Returns iterator class instance.\n"
"");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetIterator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetIterator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags = wxPG_ITERATE_DEFAULT;
        ::wxPGProperty* firstProp = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_firstProp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|iJ8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags, sipType_wxPGProperty, &firstProp))
        {
            ::wxPropertyGridIterator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPropertyGridIterator(sipCpp->GetIterator(flags, firstProp));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPropertyGridIterator, SIP_NULLPTR);
        }
    }

    {
        int flags;
        int startPos;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
            sipName_startPos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags, &startPos))
        {
            ::wxPropertyGridIterator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPropertyGridIterator(sipCpp->GetIterator(flags, startPos));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPropertyGridIterator, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetIterator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetFirst, "GetFirst(flags=PG_ITERATE_ALL) -> PGProperty\n"
"\n"
"Returns id of first item that matches given criteria.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetFirst(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetFirst(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags = wxPG_ITERATE_ALL;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFirst(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetFirst, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Append, "Append(property) -> PGProperty\n"
"\n"
"Appends property to the list.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Append(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Append(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPGProperty* property;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_property,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGProperty, &property))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Append(property);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Append, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_AppendIn, "AppendIn(id, newProperty) -> PGProperty\n"
"\n"
"Same as Append(), but appends under given parent property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_AppendIn(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_AppendIn(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPGProperty* newProperty;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newProperty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGProperty, &newProperty))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->AppendIn(*id, newProperty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_AppendIn, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_BeginAddChildren, "BeginAddChildren(id)\n"
"\n"
"In order to add new items into a property with private children (for\n"
"instance, wxFlagsProperty), you need to call this method.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_BeginAddChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_BeginAddChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->BeginAddChildren(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_BeginAddChildren, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Clear, "Clear()\n"
"\n"
"Deletes all properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_PropertyGridInterface, sipName_Clear);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ClearSelection, "ClearSelection(validation=False) -> bool\n"
"\n"
"Clears current selection, if any.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ClearSelection(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ClearSelection(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool validation = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_validation,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &validation))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ClearSelection(validation);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ClearSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ClearModifiedStatus, "ClearModifiedStatus()\n"
"\n"
"Resets modified status of all properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ClearModifiedStatus(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ClearModifiedStatus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->ClearModifiedStatus();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ClearModifiedStatus, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Collapse, "Collapse(id) -> bool\n"
"\n"
"Collapses given category or property with children.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Collapse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Collapse(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Collapse(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Collapse, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_CollapseAll, "CollapseAll() -> bool\n"
"\n"
"Collapses all items that can be collapsed.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_CollapseAll(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_CollapseAll(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->CollapseAll();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_CollapseAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ChangePropertyValue, "ChangePropertyValue(id, newValue) -> bool\n"
"\n"
"Changes value of a property, as if by user.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ChangePropertyValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ChangePropertyValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPGVariant* newValue;
        int newValueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newValue,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGVariant, &newValue, &newValueState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ChangePropertyValue(*id, *newValue);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(newValue, sipType_wxPGVariant, newValueState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ChangePropertyValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_DeleteProperty, "DeleteProperty(id)\n"
"\n"
"Removes and deletes a property and any children.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_DeleteProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_DeleteProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->DeleteProperty(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_DeleteProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_DisableProperty, "DisableProperty(id) -> bool\n"
"\n"
"Disables a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_DisableProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_DisableProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->DisableProperty(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_DisableProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_EditorValidate, "EditorValidate() -> bool\n"
"\n"
"Returns true if all property grid data changes have been committed.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_EditorValidate(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_EditorValidate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EditorValidate();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_EditorValidate, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_EnableProperty, "EnableProperty(id, enable=True) -> bool\n"
"\n"
"Enables or disables property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_EnableProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_EnableProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        bool enable = 1;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_enable,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &enable))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->EnableProperty(*id, enable);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_EnableProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_EndAddChildren, "EndAddChildren(id)\n"
"\n"
"Called after population of property with fixed children has finished.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_EndAddChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_EndAddChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->EndAddChildren(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_EndAddChildren, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Expand, "Expand(id) -> bool\n"
"\n"
"Expands given category or property with children.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Expand(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Expand(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Expand(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Expand, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ExpandAll, "ExpandAll(expand=True) -> bool\n"
"\n"
"Expands all items that can be expanded.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ExpandAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ExpandAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        bool expand = 1;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_expand,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &expand))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ExpandAll(expand);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ExpandAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetColumnProportion, "GetColumnProportion(column) -> int\n"
"\n"
"Returns auto-resize proportion of the given column.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetColumnProportion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetColumnProportion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        uint column;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bu", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &column))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetColumnProportion(column);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetColumnProportion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetFirstChild, "GetFirstChild(id) -> PGProperty\n"
"\n"
"Returns id of first child of given property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetFirstChild(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetFirstChild(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetFirstChild(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetFirstChild, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetProperty, "GetProperty(name) -> PGProperty\n"
"\n"
"Returns pointer to a property with given name (case-sensitive).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetProperty(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertiesWithFlag, "GetPropertiesWithFlag(targetArr, flags, inverse=False, iterFlags=PG_ITERATE_PROPERTIES|PG_ITERATE_HIDDEN|PG_ITERATE_CATEGORIES)\n"
"\n"
"Adds to targetArr pointers to properties that have given flags set.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertiesWithFlag(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertiesWithFlag(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxArrayPGProperty* targetArr;
        ::wxPGProperty::FlagType flags;
        bool inverse = 0;
        int iterFlags = wxPG_ITERATE_PROPERTIES|wxPG_ITERATE_HIDDEN|wxPG_ITERATE_CATEGORIES;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_targetArr,
            sipName_flags,
            sipName_inverse,
            sipName_iterFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8u|bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxArrayPGProperty, &targetArr, &flags, &inverse, &iterFlags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->GetPropertiesWithFlag(targetArr, flags, inverse, iterFlags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertiesWithFlag, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyAttribute, "GetPropertyAttribute(id, attrName) -> PGVariant\n"
"\n"
"Returns value of given attribute.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* attrName;
        int attrNameState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_attrName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &attrName, &attrNameState))
        {
            ::wxPGVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPGVariant(sipCpp->GetPropertyAttribute(*id, *attrName));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(attrName), sipType_wxString, attrNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPGVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyAttributes, "GetPropertyAttributes(id) -> PGAttributeStorage\n"
"\n"
"Returns map-like storage of property's attributes.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyAttributes(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyAttributes(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxPGAttributeStorage*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPGAttributeStorage(sipCpp->GetPropertyAttributes(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPGAttributeStorage, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyAttributes, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyBackgroundColour, "GetPropertyBackgroundColour(id) -> wx.Colour\n"
"\n"
"Returns background colour of first cell of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetPropertyBackgroundColour(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyCategory, "GetPropertyCategory(id) -> PropertyCategory\n"
"\n"
"Returns pointer of property's nearest parent category.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyCategory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyCategory(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxPropertyCategory*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyCategory(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPropertyCategory, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyCategory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyByLabel, "GetPropertyByLabel(label) -> PGProperty\n"
"\n"
"Returns first property which label matches given string.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyByLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyByLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* label;
        int labelState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_label,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &label, &labelState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByLabel(*label);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(label), sipType_wxString, labelState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyByLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyByName, "GetPropertyByName(name) -> PGProperty\n"
"GetPropertyByName(name, subname) -> PGProperty\n"
"\n"
"Returns pointer to a property with given name (case-sensitive).\n"
"");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyByName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyByName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByName(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    {
        const ::wxString* name;
        int nameState = 0;
        const ::wxString* subname;
        int subnameState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_subname,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &name, &nameState, sipType_wxString, &subname, &subnameState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByName(*name, *subname);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast<::wxString *>(subname), sipType_wxString, subnameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyByName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyEditor, "GetPropertyEditor(id) -> PGEditor\n"
"\n"
"Returns property's editor.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyEditor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyEditor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            const ::wxPGEditor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyEditor(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(const_cast<::wxPGEditor *>(sipRes), sipType_wxPGEditor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyEditor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyHelpString, "GetPropertyHelpString(id) -> String\n"
"\n"
"Returns help string associated with a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyHelpString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyHelpString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetPropertyHelpString(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyHelpString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyImage, "GetPropertyImage(id) -> wx.Bitmap\n"
"\n"
"Returns property's custom value image (NULL of none).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyImage(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyLabel, "GetPropertyLabel(id) -> String\n"
"\n"
"Returns label of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetPropertyLabel(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyName, "GetPropertyName(property) -> String\n"
"\n"
"Returns property's name, by which it is globally accessible.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxPGProperty* property;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_property,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGProperty, &property))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetPropertyName(property));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyParent, "GetPropertyParent(id) -> PGProperty\n"
"\n"
"Returns parent item of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyParent(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyParent(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyParent(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyParent, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyTextColour, "GetPropertyTextColour(id) -> wx.Colour\n"
"\n"
"Returns text colour of first cell of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxColour*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxColour(sipCpp->GetPropertyTextColour(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxColour, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValidator, "GetPropertyValidator(id) -> wx.Validator\n"
"\n"
"Returns validator of a property as a reference, which you can pass to\n"
"any number of SetPropertyValidator.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValidator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValidator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxValidator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValidator(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxValidator, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValidator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValue, "GetPropertyValue(id) -> PGVariant\n"
"\n"
"Returns property's value as wxVariant.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxPGVariant*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPGVariant(sipCpp->GetPropertyValue(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPGVariant, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsArrayInt, "GetPropertyValueAsArrayInt(id) -> ArrayInt\n"
"\n"
"Return's property's value as wxArrayInt.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxArrayInt*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayInt(sipCpp->GetPropertyValueAsArrayInt(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayInt, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsArrayInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsArrayString, "GetPropertyValueAsArrayString(id) -> ArrayString\n"
"\n"
"Returns property's value as wxArrayString.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsArrayString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxArrayString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayString(sipCpp->GetPropertyValueAsArrayString(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsArrayString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsBool, "GetPropertyValueAsBool(id) -> bool\n"
"\n"
"Returns property's value as bool.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsBool(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsBool(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsBool(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsBool, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsDateTime, "GetPropertyValueAsDateTime(id) -> wx.DateTime\n"
"\n"
"Return's property's value as wxDateTime.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDateTime(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDateTime(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxDateTime*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxDateTime(sipCpp->GetPropertyValueAsDateTime(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxDateTime, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsDateTime, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsDouble, "GetPropertyValueAsDouble(id) -> double\n"
"\n"
"Returns property's value as double-precision floating point number.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDouble(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsDouble(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            double sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsDouble(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyFloat_FromDouble(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsDouble, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsInt, "GetPropertyValueAsInt(id) -> int\n"
"\n"
"Returns property's value as integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsInt(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsInt(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsLong, "GetPropertyValueAsLong(id) -> long\n"
"\n"
"Returns property's value as integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsLong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsLongLong, "GetPropertyValueAsLongLong(id) -> LongLong_t\n"
"\n"
"Returns property's value as native signed 64-bit integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsLongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            long long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsLongLong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsLongLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsString, "GetPropertyValueAsString(id) -> String\n"
"\n"
"Returns property's value as wxString.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetPropertyValueAsString(*id));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsULong, "GetPropertyValueAsULong(id) -> unsignedlong\n"
"\n"
"Returns property's value as unsigned integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            unsigned long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsULong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsULong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyValueAsULongLong, "GetPropertyValueAsULongLong(id) -> ULongLong_t\n"
"\n"
"Returns property's value as native unsigned 64-bit integer.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULongLong(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyValueAsULongLong(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            unsigned long long sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyValueAsULongLong(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyValueAsULongLong, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetSelectedProperties, "GetSelectedProperties() -> ArrayPGProperty\n"
"\n"
"Returns list of currently selected properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetSelectedProperties(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetSelectedProperties(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            ::wxArrayPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxArrayPGProperty(sipCpp->GetSelectedProperties());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxArrayPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetSelectedProperties, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetSelection, "GetSelection() -> PGProperty\n"
"\n"
"Returns currently selected property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetSelection(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetSelection(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPropertyGridInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetSelection();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetSelection, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetVIterator, "GetVIterator(flags) -> PGVIterator\n"
"\n"
"Similar to GetIterator(), but instead returns wxPGVIterator instance,\n"
"which can be useful for forward-iterating through arbitrary property\n"
"containers.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetVIterator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetVIterator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        int flags;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags))
        {
            ::wxPGVIterator*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxPGVIterator((sipSelfWasArg ? sipCpp->::wxPropertyGridInterface::GetVIterator(flags) : sipCpp->GetVIterator(flags)));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxPGVIterator, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetVIterator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_HideProperty, "HideProperty(id, hide=True, flags=PG_RECURSE) -> bool\n"
"\n"
"Hides or reveals a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_HideProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_HideProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        bool hide = 1;
        int flags = wxPG_RECURSE;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_hide,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &hide, &flags))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HideProperty(*id, hide, flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_HideProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Insert, "Insert(priorThis, newProperty) -> PGProperty\n"
"Insert(parent, index, newProperty) -> PGProperty\n"
"\n"
"Inserts property to the property container.\n"
"");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Insert(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Insert(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* priorThis;
        int priorThisState = 0;
        ::wxPGProperty* newProperty;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_priorThis,
            sipName_newProperty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &priorThis, &priorThisState, sipType_wxPGProperty, &newProperty))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*priorThis, newProperty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(priorThis), sipType_wxPGPropArgCls, priorThisState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    {
        const ::wxPGPropArgCls* parent;
        int parentState = 0;
        int index;
        ::wxPGProperty* newProperty;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_parent,
            sipName_index,
            sipName_newProperty,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1iJ:", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &parent, &parentState, &index, sipType_wxPGProperty, &newProperty))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Insert(*parent, index, newProperty);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(parent), sipType_wxPGPropArgCls, parentState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Insert, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyCategory, "IsPropertyCategory(id) -> bool\n"
"\n"
"Returns true if property is a category.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyCategory(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyCategory(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyCategory(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyCategory, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyEnabled, "IsPropertyEnabled(id) -> bool\n"
"\n"
"Returns true if property is enabled.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyEnabled(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyEnabled(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyEnabled(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyEnabled, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyExpanded, "IsPropertyExpanded(id) -> bool\n"
"\n"
"Returns true if given property is expanded.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyExpanded(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyExpanded(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyExpanded(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyExpanded, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyModified, "IsPropertyModified(id) -> bool\n"
"\n"
"Returns true if property has been modified after value set or modify\n"
"flag clear by software.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyModified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyModified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyModified(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyModified, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertySelected, "IsPropertySelected(id) -> bool\n"
"\n"
"Returns true if property is selected.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertySelected(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertySelected(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertySelected(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertySelected, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyShown, "IsPropertyShown(id) -> bool\n"
"\n"
"Returns true if property is shown (i.e.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyShown(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyShown(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyShown(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyShown, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_IsPropertyValueUnspecified, "IsPropertyValueUnspecified(id) -> bool\n"
"\n"
"Returns true if property value is set to unspecified.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_IsPropertyValueUnspecified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_IsPropertyValueUnspecified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsPropertyValueUnspecified(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_IsPropertyValueUnspecified, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_LimitPropertyEditing, "LimitPropertyEditing(id, limit=True)\n"
"\n"
"Disables (limit = true) or enables (limit = false) wxTextCtrl editor\n"
"of a property, if it is not the sole mean to edit the value.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_LimitPropertyEditing(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_LimitPropertyEditing(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        bool limit = 1;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_limit,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|b", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &limit))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->LimitPropertyEditing(*id, limit);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_LimitPropertyEditing, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RefreshGrid, "RefreshGrid(state=None)\n"
"\n"
"If state is shown in its grid, refresh it now.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RefreshGrid(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RefreshGrid(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        ::wxPropertyGridPageState* state = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_state,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPropertyGridPageState, &state))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            (sipSelfWasArg ? sipCpp->::wxPropertyGridInterface::RefreshGrid(state) : sipCpp->RefreshGrid(state));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RefreshGrid, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RemoveProperty, "RemoveProperty(id) -> PGProperty\n"
"\n"
"Removes a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RemoveProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RemoveProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RemoveProperty(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RemoveProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_ReplaceProperty, "ReplaceProperty(id, property) -> PGProperty\n"
"\n"
"Replaces property with id with newly created one.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_ReplaceProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_ReplaceProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPGProperty* property;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_property,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGProperty, &property))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->ReplaceProperty(*id, property);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_ReplaceProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RestoreEditableState, "RestoreEditableState(src, restoreStates=AllStates) -> bool\n"
"\n"
"Restores user-editable state.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RestoreEditableState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RestoreEditableState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* src;
        int srcState = 0;
        int restoreStates = ::wxPropertyGridInterface::AllStates;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_src,
            sipName_restoreStates,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &src, &srcState, &restoreStates))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->RestoreEditableState(*src, restoreStates);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(src), sipType_wxString, srcState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RestoreEditableState, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SaveEditableState, "SaveEditableState(includedStates=AllStates) -> String\n"
"\n"
"Used to acquire user-editable state (selected property, expanded\n"
"properties, scrolled position, splitter positions).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SaveEditableState(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SaveEditableState(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int includedStates = ::wxPropertyGridInterface::AllStates;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_includedStates,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &includedStates))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->SaveEditableState(includedStates));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SaveEditableState, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetColumnProportion, "SetColumnProportion(column, proportion) -> bool\n"
"\n"
"Set proportion of an auto-stretchable column.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetColumnProportion(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetColumnProportion(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        uint column;
        int proportion;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_column,
            sipName_proportion,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bui", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &column, &proportion))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetColumnProportion(column, proportion);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetColumnProportion, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyAttribute, "SetPropertyAttribute(id, attrName, value, argFlags=0)\n"
"\n"
"Sets an attribute for this property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyAttribute(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyAttribute(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* attrName;
        int attrNameState = 0;
        ::wxPGVariant* value;
        int valueState = 0;
        long argFlags = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_attrName,
            sipName_value,
            sipName_argFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1J1|l", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &attrName, &attrNameState, sipType_wxPGVariant, &value, &valueState, &argFlags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyAttribute(*id, *attrName, *value, argFlags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(attrName), sipType_wxString, attrNameState);
            sipReleaseType(value, sipType_wxPGVariant, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyAttribute, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyAttributeAll, "SetPropertyAttributeAll(attrName, value)\n"
"\n"
"Sets property attribute for all applicable properties.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyAttributeAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyAttributeAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* attrName;
        int attrNameState = 0;
        ::wxPGVariant* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_attrName,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &attrName, &attrNameState, sipType_wxPGVariant, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyAttributeAll(*attrName, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(attrName), sipType_wxString, attrNameState);
            sipReleaseType(value, sipType_wxPGVariant, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyAttributeAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyBackgroundColour, "SetPropertyBackgroundColour(id, colour, flags=PG_RECURSE)\n"
"\n"
"Sets background colour of given property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxColour* colour;
        int colourState = 0;
        int flags = wxPG_RECURSE;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_colour,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxColour, &colour, &colourState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyBackgroundColour(*id, *colour, flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyCell, "SetPropertyCell(id, column, text=wx.EmptyString, bitmap=wx.BitmapBundle(), fgCol=wx.NullColour, bgCol=wx.NullColour)\n"
"\n"
"Sets text, bitmap, and colours for given column's cell.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyCell(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyCell(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        int column;
        const ::wxString& textdef = wxEmptyString;
        const ::wxString* text = &textdef;
        int textState = 0;
        const ::wxBitmapBundle& bitmapdef = wxBitmapBundle();
        const ::wxBitmapBundle* bitmap = &bitmapdef;
        int bitmapState = 0;
        const ::wxColour& fgColdef = wxNullColour;
        const ::wxColour* fgCol = &fgColdef;
        int fgColState = 0;
        const ::wxColour& bgColdef = wxNullColour;
        const ::wxColour* bgCol = &bgColdef;
        int bgColState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_column,
            sipName_text,
            sipName_bitmap,
            sipName_fgCol,
            sipName_bgCol,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1i|J1J1J1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &column, sipType_wxString, &text, &textState, sipType_wxBitmapBundle, &bitmap, &bitmapState, sipType_wxColour, &fgCol, &fgColState, sipType_wxColour, &bgCol, &bgColState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyCell(*id, column, *text, *bitmap, *fgCol, *bgCol);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(text), sipType_wxString, textState);
            sipReleaseType(const_cast<::wxBitmapBundle *>(bitmap), sipType_wxBitmapBundle, bitmapState);
            sipReleaseType(const_cast<::wxColour *>(fgCol), sipType_wxColour, fgColState);
            sipReleaseType(const_cast<::wxColour *>(bgCol), sipType_wxColour, bgColState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyCell, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyColoursToDefault, "SetPropertyColoursToDefault(id, flags=PG_DONT_RECURSE)\n"
"\n"
"Resets text and background colours of given property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyColoursToDefault(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyColoursToDefault(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        int flags = wxPG_DONT_RECURSE;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyColoursToDefault(*id, flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyColoursToDefault, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyEditor, "SetPropertyEditor(id, editor)\n"
"SetPropertyEditor(id, editorName)\n"
"\n"
"Sets editor for a property.\n"
"");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyEditor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyEditor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxPGEditor* editor;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_editor,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGEditor, &editor))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyEditor(*id, editor);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* editorName;
        int editorNameState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_editorName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &editorName, &editorNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyEditor(*id, *editorName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(editorName), sipType_wxString, editorNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyEditor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyLabel, "SetPropertyLabel(id, newproplabel)\n"
"\n"
"Sets label of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyLabel(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyLabel(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* newproplabel;
        int newproplabelState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newproplabel,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &newproplabel, &newproplabelState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyLabel(*id, *newproplabel);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(newproplabel), sipType_wxString, newproplabelState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyLabel, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyName, "SetPropertyName(id, newName)\n"
"\n"
"Sets name of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* newName;
        int newNameState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_newName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &newName, &newNameState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyName(*id, *newName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(newName), sipType_wxString, newNameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyReadOnly, "SetPropertyReadOnly(id, set=True, flags=PG_RECURSE)\n"
"\n"
"Sets property (and, recursively, its children) to have read-only\n"
"value.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyReadOnly(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyReadOnly(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        bool set = 1;
        int flags = wxPG_RECURSE;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_set,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &set, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyReadOnly(*id, set, flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyReadOnly, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValueUnspecified, "SetPropertyValueUnspecified(id)\n"
"\n"
"Sets property's value to unspecified.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValueUnspecified(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValueUnspecified(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValueUnspecified(*id);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValueUnspecified, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyHelpString, "SetPropertyHelpString(id, helpString)\n"
"\n"
"Associates the help string with property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyHelpString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyHelpString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* helpString;
        int helpStringState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_helpString,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &helpString, &helpStringState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyHelpString(*id, *helpString);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(helpString), sipType_wxString, helpStringState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyHelpString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyImage, "SetPropertyImage(id, bmp)\n"
"\n"
"Set wxBitmap taken from wxBitmapBundle in front of the value.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxBitmapBundle* bmp;
        int bmpState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxBitmapBundle, &bmp, &bmpState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyImage(*id, *bmp);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(bmp, sipType_wxBitmapBundle, bmpState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyMaxLength, "SetPropertyMaxLength(id, maxLen) -> bool\n"
"\n"
"Sets maximum length of text in property text editor.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyMaxLength(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyMaxLength(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        int maxLen;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_maxLen,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &maxLen))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SetPropertyMaxLength(*id, maxLen);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyMaxLength, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyTextColour, "SetPropertyTextColour(id, colour, flags=PG_RECURSE)\n"
"\n"
"Sets text colour of given property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyTextColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyTextColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxColour* colour;
        int colourState = 0;
        int flags = wxPG_RECURSE;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_colour,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxColour, &colour, &colourState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyTextColour(*id, *colour, flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxColour *>(colour), sipType_wxColour, colourState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyTextColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValidator, "SetPropertyValidator(id, validator)\n"
"\n"
"Sets validator of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValidator(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValidator(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxValidator* validator;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_validator,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxValidator, &validator))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValidator(*id, *validator);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValidator, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValue, "SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"SetPropertyValue(id, value)\n"
"\n"
"Sets value (floating point) of a property.\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValue(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValue(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        double value;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1Xd", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        bool value;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1Xb", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(value), sipType_wxString, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxArrayString* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxArrayString, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxArrayString *>(value), sipType_wxArrayString, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxDateTime* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxDateTime, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxDateTime *>(value), sipType_wxDateTime, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxObject* value;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J9", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxObject, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxArrayInt* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxArrayInt, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxArrayInt *>(value), sipType_wxArrayInt, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPGVariant* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGVariant, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(value, sipType_wxPGVariant, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        long value;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1l", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValue(*id, value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValue, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropertyValueString, "SetPropertyValueString(id, value)\n"
"\n"
"Sets value (wxString) of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropertyValueString(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropertyValueString(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        const ::wxString* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxString, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropertyValueString(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(const_cast<::wxString *>(value), sipType_wxString, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropertyValueString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetPropVal, "SetPropVal(id, value)\n"
"\n"
"Sets value (wxVariant&) of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetPropVal(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetPropVal(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        ::wxPGVariant* value;
        int valueState = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1J1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, sipType_wxPGVariant, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetPropVal(*id, *value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);
            sipReleaseType(value, sipType_wxPGVariant, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetPropVal, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetValidationFailureBehavior, "SetValidationFailureBehavior(vfbFlags)\n"
"\n"
"Adjusts how wxPropertyGrid behaves when invalid value is entered in a\n"
"property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetValidationFailureBehavior(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetValidationFailureBehavior(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int vfbFlags;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_vfbFlags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &vfbFlags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetValidationFailureBehavior(vfbFlags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetValidationFailureBehavior, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_Sort, "Sort(flags=0)\n"
"\n"
"Sorts all properties recursively.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_Sort(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_Sort(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int flags = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Sort(flags);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_Sort, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SortChildren, "SortChildren(id, flags=0)\n"
"\n"
"Sorts children of a property.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SortChildren(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SortChildren(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxPGPropArgCls* id;
        int idState = 0;
        int flags = 0;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_flags,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1|i", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGPropArgCls, &id, &idState, &flags))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SortChildren(*id, flags);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxPGPropArgCls *>(id), sipType_wxPGPropArgCls, idState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SortChildren, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetPropertyByNameA, "GetPropertyByNameA(name) -> PGProperty\n"
"\n"
"GetPropertyByName() with assertion error message.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetPropertyByNameA(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetPropertyByNameA(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* name;
        int nameState = 0;
        const ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxString, &name, &nameState))
        {
            ::wxPGProperty*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetPropertyByNameA(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGProperty, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetPropertyByNameA, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RefreshProperty, "RefreshProperty(p)");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RefreshProperty(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RefreshProperty(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        ::wxPGProperty* p;
        ::wxPropertyGridInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_p,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxPropertyGridInterface, &sipCpp, sipType_wxPGProperty, &p))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_PropertyGridInterface, sipName_RefreshProperty);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->RefreshProperty(p);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RefreshProperty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_InitAllTypeHandlers, "InitAllTypeHandlers()\n"
"\n"
"Initializes all property types.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_InitAllTypeHandlers(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_InitAllTypeHandlers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxPropertyGridInterface::InitAllTypeHandlers();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_InitAllTypeHandlers, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_RegisterAdditionalEditors, "RegisterAdditionalEditors()\n"
"\n"
"Initializes additional property editors (SpinCtrl etc.).");

extern "C" {static PyObject *meth_wxPropertyGridInterface_RegisterAdditionalEditors(PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_RegisterAdditionalEditors(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxPropertyGridInterface::RegisterAdditionalEditors();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_RegisterAdditionalEditors, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_SetBoolChoices, "SetBoolChoices(trueChoice, falseChoice)\n"
"\n"
"Sets strings listed in the choice dropdown of a wxBoolProperty.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_SetBoolChoices(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_SetBoolChoices(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* trueChoice;
        int trueChoiceState = 0;
        const ::wxString* falseChoice;
        int falseChoiceState = 0;

        static const char *sipKwdList[] = {
            sipName_trueChoice,
            sipName_falseChoice,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1", sipType_wxString, &trueChoice, &trueChoiceState, sipType_wxString, &falseChoice, &falseChoiceState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            ::wxPropertyGridInterface::SetBoolChoices(*trueChoice, *falseChoice);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(trueChoice), sipType_wxString, trueChoiceState);
            sipReleaseType(const_cast<::wxString *>(falseChoice), sipType_wxString, falseChoiceState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_SetBoolChoices, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxPropertyGridInterface_GetEditorByName, "GetEditorByName(editorName) -> PGEditor\n"
"\n"
"Returns editor pointer of editor with given name.");

extern "C" {static PyObject *meth_wxPropertyGridInterface_GetEditorByName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxPropertyGridInterface_GetEditorByName(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxString* editorName;
        int editorNameState = 0;

        static const char *sipKwdList[] = {
            sipName_editorName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &editorName, &editorNameState))
        {
            ::wxPGEditor*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = ::wxPropertyGridInterface::GetEditorByName(*editorName);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(editorName), sipType_wxString, editorNameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxPGEditor, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_PropertyGridInterface, sipName_GetEditorByName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxPropertyGridInterface(void *, int);}
static void release_wxPropertyGridInterface(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxPropertyGridInterface *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxPropertyGridInterface(sipSimpleWrapper *);}
static void dealloc_wxPropertyGridInterface(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxPropertyGridInterface(sipGetAddress(sipSelf), 0);
    }
}


static PyMethodDef methods_wxPropertyGridInterface[] = {
    {sipName_Append, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_Append), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_Append},
    {sipName_AppendIn, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_AppendIn), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_AppendIn},
    {sipName_BeginAddChildren, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_BeginAddChildren), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_BeginAddChildren},
    {sipName_ChangePropertyValue, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_ChangePropertyValue), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_ChangePropertyValue},
    {sipName_Clear, meth_wxPropertyGridInterface_Clear, METH_VARARGS, doc_wxPropertyGridInterface_Clear},
    {sipName_ClearModifiedStatus, meth_wxPropertyGridInterface_ClearModifiedStatus, METH_VARARGS, doc_wxPropertyGridInterface_ClearModifiedStatus},
    {sipName_ClearSelection, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_ClearSelection), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_ClearSelection},
    {sipName_Collapse, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_Collapse), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_Collapse},
    {sipName_CollapseAll, meth_wxPropertyGridInterface_CollapseAll, METH_VARARGS, doc_wxPropertyGridInterface_CollapseAll},
    {sipName_DeleteProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_DeleteProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_DeleteProperty},
    {sipName_DisableProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_DisableProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_DisableProperty},
    {sipName_EditorValidate, meth_wxPropertyGridInterface_EditorValidate, METH_VARARGS, doc_wxPropertyGridInterface_EditorValidate},
    {sipName_EnableProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_EnableProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_EnableProperty},
    {sipName_EndAddChildren, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_EndAddChildren), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_EndAddChildren},
    {sipName_Expand, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_Expand), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_Expand},
    {sipName_ExpandAll, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_ExpandAll), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_ExpandAll},
    {sipName_GetColumnProportion, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetColumnProportion), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetColumnProportion},
    {sipName_GetEditorByName, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetEditorByName), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetEditorByName},
    {sipName_GetFirst, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetFirst), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetFirst},
    {sipName_GetFirstChild, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetFirstChild), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetFirstChild},
    {sipName_GetIterator, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetIterator), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetIterator},
    {sipName_GetPropertiesWithFlag, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertiesWithFlag), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertiesWithFlag},
    {sipName_GetProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetProperty},
    {sipName_GetPropertyAttribute, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyAttribute), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyAttribute},
    {sipName_GetPropertyAttributes, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyAttributes), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyAttributes},
    {sipName_GetPropertyBackgroundColour, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyBackgroundColour), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyBackgroundColour},
    {sipName_GetPropertyByLabel, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyByLabel), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyByLabel},
    {sipName_GetPropertyByName, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyByName), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyByName},
    {sipName_GetPropertyByNameA, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyByNameA), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyByNameA},
    {sipName_GetPropertyCategory, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyCategory), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyCategory},
    {sipName_GetPropertyEditor, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyEditor), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyEditor},
    {sipName_GetPropertyHelpString, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyHelpString), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyHelpString},
    {sipName_GetPropertyImage, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyImage), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyImage},
    {sipName_GetPropertyLabel, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyLabel), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyLabel},
    {sipName_GetPropertyName, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyName), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyName},
    {sipName_GetPropertyParent, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyParent), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyParent},
    {sipName_GetPropertyTextColour, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyTextColour), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyTextColour},
    {sipName_GetPropertyValidator, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValidator), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValidator},
    {sipName_GetPropertyValue, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValue), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValue},
    {sipName_GetPropertyValueAsArrayInt, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsArrayInt), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsArrayInt},
    {sipName_GetPropertyValueAsArrayString, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsArrayString), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsArrayString},
    {sipName_GetPropertyValueAsBool, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsBool), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsBool},
    {sipName_GetPropertyValueAsDateTime, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsDateTime), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsDateTime},
    {sipName_GetPropertyValueAsDouble, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsDouble), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsDouble},
    {sipName_GetPropertyValueAsInt, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsInt), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsInt},
    {sipName_GetPropertyValueAsLong, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsLong), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsLong},
    {sipName_GetPropertyValueAsLongLong, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsLongLong), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsLongLong},
    {sipName_GetPropertyValueAsString, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsString), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsString},
    {sipName_GetPropertyValueAsULong, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsULong), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsULong},
    {sipName_GetPropertyValueAsULongLong, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetPropertyValueAsULongLong), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetPropertyValueAsULongLong},
    {sipName_GetSelectedProperties, meth_wxPropertyGridInterface_GetSelectedProperties, METH_VARARGS, doc_wxPropertyGridInterface_GetSelectedProperties},
    {sipName_GetSelection, meth_wxPropertyGridInterface_GetSelection, METH_VARARGS, doc_wxPropertyGridInterface_GetSelection},
    {sipName_GetVIterator, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_GetVIterator), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_GetVIterator},
    {sipName_HideProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_HideProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_HideProperty},
    {sipName_InitAllTypeHandlers, meth_wxPropertyGridInterface_InitAllTypeHandlers, METH_VARARGS, doc_wxPropertyGridInterface_InitAllTypeHandlers},
    {sipName_Insert, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_Insert), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_Insert},
    {sipName_IsPropertyCategory, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertyCategory), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertyCategory},
    {sipName_IsPropertyEnabled, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertyEnabled), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertyEnabled},
    {sipName_IsPropertyExpanded, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertyExpanded), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertyExpanded},
    {sipName_IsPropertyModified, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertyModified), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertyModified},
    {sipName_IsPropertySelected, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertySelected), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertySelected},
    {sipName_IsPropertyShown, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertyShown), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertyShown},
    {sipName_IsPropertyValueUnspecified, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_IsPropertyValueUnspecified), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_IsPropertyValueUnspecified},
    {sipName_LimitPropertyEditing, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_LimitPropertyEditing), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_LimitPropertyEditing},
    {sipName_RefreshGrid, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_RefreshGrid), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_RefreshGrid},
    {sipName_RefreshProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_RefreshProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_RefreshProperty},
    {sipName_RegisterAdditionalEditors, meth_wxPropertyGridInterface_RegisterAdditionalEditors, METH_VARARGS, doc_wxPropertyGridInterface_RegisterAdditionalEditors},
    {sipName_RemoveProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_RemoveProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_RemoveProperty},
    {sipName_ReplaceProperty, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_ReplaceProperty), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_ReplaceProperty},
    {sipName_RestoreEditableState, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_RestoreEditableState), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_RestoreEditableState},
    {sipName_SaveEditableState, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SaveEditableState), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SaveEditableState},
    {sipName_SetBoolChoices, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetBoolChoices), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetBoolChoices},
    {sipName_SetColumnProportion, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetColumnProportion), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetColumnProportion},
    {sipName_SetPropVal, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropVal), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropVal},
    {sipName_SetPropertyAttribute, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyAttribute), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyAttribute},
    {sipName_SetPropertyAttributeAll, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyAttributeAll), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyAttributeAll},
    {sipName_SetPropertyBackgroundColour, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyBackgroundColour), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyBackgroundColour},
    {sipName_SetPropertyCell, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyCell), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyCell},
    {sipName_SetPropertyColoursToDefault, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyColoursToDefault), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyColoursToDefault},
    {sipName_SetPropertyEditor, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyEditor), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyEditor},
    {sipName_SetPropertyHelpString, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyHelpString), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyHelpString},
    {sipName_SetPropertyImage, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyImage), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyImage},
    {sipName_SetPropertyLabel, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyLabel), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyLabel},
    {sipName_SetPropertyMaxLength, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyMaxLength), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyMaxLength},
    {sipName_SetPropertyName, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyName), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyName},
    {sipName_SetPropertyReadOnly, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyReadOnly), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyReadOnly},
    {sipName_SetPropertyTextColour, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyTextColour), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyTextColour},
    {sipName_SetPropertyValidator, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyValidator), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyValidator},
    {sipName_SetPropertyValue, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyValue), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyValue},
    {sipName_SetPropertyValueString, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyValueString), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyValueString},
    {sipName_SetPropertyValueUnspecified, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetPropertyValueUnspecified), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetPropertyValueUnspecified},
    {sipName_SetValidationFailureBehavior, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SetValidationFailureBehavior), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SetValidationFailureBehavior},
    {sipName_Sort, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_Sort), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_Sort},
    {sipName_SortChildren, SIP_MLMETH_CAST(meth_wxPropertyGridInterface_SortChildren), METH_VARARGS|METH_KEYWORDS, doc_wxPropertyGridInterface_SortChildren}
};

static sipEnumMemberDef enummembers_wxPropertyGridInterface[] = {
    {sipName_AllStates, static_cast<int>(::wxPropertyGridInterface::AllStates), 67},
    {sipName_DescBoxState, static_cast<int>(::wxPropertyGridInterface::DescBoxState), 67},
    {sipName_ExpandedState, static_cast<int>(::wxPropertyGridInterface::ExpandedState), 67},
    {sipName_PageState, static_cast<int>(::wxPropertyGridInterface::PageState), 67},
    {sipName_ScrollPosState, static_cast<int>(::wxPropertyGridInterface::ScrollPosState), 67},
    {sipName_SelectionState, static_cast<int>(::wxPropertyGridInterface::SelectionState), 67},
    {sipName_SplitterPosState, static_cast<int>(::wxPropertyGridInterface::SplitterPosState), 67},
};

PyDoc_STRVAR(doc_wxPropertyGridInterface, "Most of the shared property manipulation interface shared by\n"
"wxPropertyGrid, wxPropertyGridPage, and wxPropertyGridManager is\n"
"defined in this class.");


sipClassTypeDef sipTypeDef__propgrid_wxPropertyGridInterface = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxPropertyGridInterface,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_PropertyGridInterface,
        {0, 0, 1},
        94, methods_wxPropertyGridInterface,
        7, enummembers_wxPropertyGridInterface,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxPropertyGridInterface,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxPropertyGridInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxPropertyGridInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
