/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.8.5
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/versioninfo.h>



PyDoc_STRVAR(doc_wxVersionInfo_GetName, "GetName() -> String\n"
"\n"
"Get the name of the object (library).");

extern "C" {static PyObject *meth_wxVersionInfo_GetName(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetName());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetName, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetMajor, "GetMajor() -> int\n"
"\n"
"Get the major version number.");

extern "C" {static PyObject *meth_wxVersionInfo_GetMajor(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetMajor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMajor();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetMajor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetMinor, "GetMinor() -> int\n"
"\n"
"Get the minor version number.");

extern "C" {static PyObject *meth_wxVersionInfo_GetMinor(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetMinor(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMinor();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetMinor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetMicro, "GetMicro() -> int\n"
"\n"
"Get the micro version, or release number.");

extern "C" {static PyObject *meth_wxVersionInfo_GetMicro(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetMicro(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetMicro();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetMicro, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetRevision, "GetRevision() -> int\n"
"\n"
"Get the revision version, or build number.");

extern "C" {static PyObject *meth_wxVersionInfo_GetRevision(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetRevision(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetRevision();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetRevision, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_ToString, "ToString() -> String\n"
"\n"
"Get the string representation of this version object.");

extern "C" {static PyObject *meth_wxVersionInfo_ToString(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_ToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->ToString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_ToString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetVersionString, "GetVersionString() -> String\n"
"\n"
"Get the string representation.");

extern "C" {static PyObject *meth_wxVersionInfo_GetVersionString(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetVersionString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetVersionString());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetVersionString, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_HasDescription, "HasDescription() -> bool\n"
"\n"
"Return true if a description string has been specified.");

extern "C" {static PyObject *meth_wxVersionInfo_HasDescription(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_HasDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasDescription();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_HasDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetDescription, "GetDescription() -> String\n"
"\n"
"Get the description string.");

extern "C" {static PyObject *meth_wxVersionInfo_GetDescription(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetDescription(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetDescription());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetDescription, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_HasCopyright, "HasCopyright() -> bool\n"
"\n"
"Returns true if a copyright string has been specified.");

extern "C" {static PyObject *meth_wxVersionInfo_HasCopyright(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_HasCopyright(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->HasCopyright();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_HasCopyright, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxVersionInfo_GetCopyright, "GetCopyright() -> String\n"
"\n"
"Get the copyright string.");

extern "C" {static PyObject *meth_wxVersionInfo_GetCopyright(PyObject *, PyObject *);}
static PyObject *meth_wxVersionInfo_GetCopyright(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxVersionInfo *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxVersionInfo, &sipCpp))
        {
            ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxString(sipCpp->GetCopyright());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_VersionInfo, sipName_GetCopyright, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxVersionInfo(void *, int);}
static void release_wxVersionInfo(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxVersionInfo *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxVersionInfo(Py_ssize_t);}
static void *array_wxVersionInfo(Py_ssize_t sipNrElem)
{
    return new ::wxVersionInfo[sipNrElem];
}


extern "C" {static void assign_wxVersionInfo(void *, Py_ssize_t, void *);}
static void assign_wxVersionInfo(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast<::wxVersionInfo *>(sipDst)[sipDstIdx] = *reinterpret_cast<::wxVersionInfo *>(sipSrc);
}


extern "C" {static void *copy_wxVersionInfo(const void *, Py_ssize_t);}
static void *copy_wxVersionInfo(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxVersionInfo(reinterpret_cast<const ::wxVersionInfo *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxVersionInfo(sipSimpleWrapper *);}
static void dealloc_wxVersionInfo(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxVersionInfo(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxVersionInfo(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxVersionInfo(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxVersionInfo *sipCpp = SIP_NULLPTR;

    {
        const ::wxString& namedef = wxString();
        const ::wxString* name = &namedef;
        int nameState = 0;
        int major = 0;
        int minor = 0;
        int micro = 0;
        int revision = 0;
        const ::wxString& descriptiondef = wxString();
        const ::wxString* description = &descriptiondef;
        int descriptionState = 0;
        const ::wxString& copyrightdef = wxString();
        const ::wxString* copyright = &copyrightdef;
        int copyrightState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_major,
            sipName_minor,
            sipName_micro,
            sipName_revision,
            sipName_description,
            sipName_copyright,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|J1iiiiJ1J1", sipType_wxString, &name, &nameState, &major, &minor, &micro, &revision, sipType_wxString, &description, &descriptionState, sipType_wxString, &copyright, &copyrightState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxVersionInfo(*name, major, minor, micro, revision, *description, *copyright);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast<::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast<::wxString *>(description), sipType_wxString, descriptionState);
            sipReleaseType(const_cast<::wxString *>(copyright), sipType_wxString, copyrightState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxVersionInfo* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxVersionInfo, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxVersionInfo(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxVersionInfo[] = {
    {sipName_GetCopyright, meth_wxVersionInfo_GetCopyright, METH_VARARGS, doc_wxVersionInfo_GetCopyright},
    {sipName_GetDescription, meth_wxVersionInfo_GetDescription, METH_VARARGS, doc_wxVersionInfo_GetDescription},
    {sipName_GetMajor, meth_wxVersionInfo_GetMajor, METH_VARARGS, doc_wxVersionInfo_GetMajor},
    {sipName_GetMicro, meth_wxVersionInfo_GetMicro, METH_VARARGS, doc_wxVersionInfo_GetMicro},
    {sipName_GetMinor, meth_wxVersionInfo_GetMinor, METH_VARARGS, doc_wxVersionInfo_GetMinor},
    {sipName_GetName, meth_wxVersionInfo_GetName, METH_VARARGS, doc_wxVersionInfo_GetName},
    {sipName_GetRevision, meth_wxVersionInfo_GetRevision, METH_VARARGS, doc_wxVersionInfo_GetRevision},
    {sipName_GetVersionString, meth_wxVersionInfo_GetVersionString, METH_VARARGS, doc_wxVersionInfo_GetVersionString},
    {sipName_HasCopyright, meth_wxVersionInfo_HasCopyright, METH_VARARGS, doc_wxVersionInfo_HasCopyright},
    {sipName_HasDescription, meth_wxVersionInfo_HasDescription, METH_VARARGS, doc_wxVersionInfo_HasDescription},
    {sipName_ToString, meth_wxVersionInfo_ToString, METH_VARARGS, doc_wxVersionInfo_ToString}
};

sipVariableDef variables_wxVersionInfo[] = {
    {PropertyVariable, sipName_VersionString, &methods_wxVersionInfo[7], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Revision, &methods_wxVersionInfo[6], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Name, &methods_wxVersionInfo[5], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Minor, &methods_wxVersionInfo[4], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Micro, &methods_wxVersionInfo[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Major, &methods_wxVersionInfo[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Description, &methods_wxVersionInfo[1], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_Copyright, &methods_wxVersionInfo[0], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxVersionInfo, "VersionInfo(name=\"\", major=0, minor=0, micro=0, revision=0, description=\"\", copyright=\"\")\n"
"\n"
"wxVersionInfo contains version information.");


sipClassTypeDef sipTypeDef__core_wxVersionInfo = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxVersionInfo,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_VersionInfo,
        {0, 0, 1},
        11, methods_wxVersionInfo,
        0, SIP_NULLPTR,
        8, variables_wxVersionInfo,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxVersionInfo,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxVersionInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxVersionInfo,
    assign_wxVersionInfo,
    array_wxVersionInfo,
    copy_wxVersionInfo,
    release_wxVersionInfo,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
