/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_adv.h"
        #include <wx/sashwin.h>
        #include <wx/event.h>
        #include <wx/gdicmn.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


class sipwxSashEvent : public  ::wxSashEvent
{
public:
    sipwxSashEvent(int, ::wxSashEdgePosition);
    sipwxSashEvent(const  ::wxSashEvent&);
    virtual ~sipwxSashEvent();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxEventCategory GetEventCategory() const SIP_OVERRIDE;
     ::wxEvent* Clone() const SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxSashEvent(const sipwxSashEvent &);
    sipwxSashEvent &operator = (const sipwxSashEvent &);

    char sipPyMethods[2];
};

sipwxSashEvent::sipwxSashEvent(int id, ::wxSashEdgePosition edge):  ::wxSashEvent(id,edge), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxSashEvent::sipwxSashEvent(const  ::wxSashEvent& a0):  ::wxSashEvent(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxSashEvent::~sipwxSashEvent()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxEventCategory sipwxSashEvent::GetEventCategory() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[0]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_GetEventCategory);

    if (!sipMeth)
        return  ::wxSashEvent::GetEventCategory();

    extern  ::wxEventCategory sipVH__adv_28(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__adv_28(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxEvent* sipwxSashEvent::Clone() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState, const_cast<char *>(&sipPyMethods[1]), const_cast<sipSimpleWrapper **>(&sipPySelf), SIP_NULLPTR, sipName_Clone);

    if (!sipMeth)
        return  ::wxSashEvent::Clone();

    extern  ::wxEvent* sipVH__adv_27(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__adv_27(sipGILState, 0, sipPySelf, sipMeth);
}


PyDoc_STRVAR(doc_wxSashEvent_GetDragRect, "GetDragRect() -> wx.Rect\n"
"\n"
"Returns the rectangle representing the new size the window would be if\n"
"the resize was applied.");

extern "C" {static PyObject *meth_wxSashEvent_GetDragRect(PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_GetDragRect(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSashEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSashEvent, &sipCpp))
        {
             ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxRect(sipCpp->GetDragRect());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxRect,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_GetDragRect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSashEvent_GetDragStatus, "GetDragStatus() -> SashDragStatus\n"
"\n"
"Returns the status of the sash: one of wxSASH_STATUS_OK,\n"
"wxSASH_STATUS_OUT_OF_RANGE.");

extern "C" {static PyObject *meth_wxSashEvent_GetDragStatus(PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_GetDragStatus(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSashEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSashEvent, &sipCpp))
        {
             ::wxSashDragStatus sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetDragStatus();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxSashDragStatus);
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_GetDragStatus, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSashEvent_GetEdge, "GetEdge() -> SashEdgePosition\n"
"\n"
"Returns the dragged edge.");

extern "C" {static PyObject *meth_wxSashEvent_GetEdge(PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_GetEdge(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxSashEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSashEvent, &sipCpp))
        {
             ::wxSashEdgePosition sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetEdge();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxSashEdgePosition);
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_GetEdge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSashEvent_SetEdge, "SetEdge(edge)");

extern "C" {static PyObject *meth_wxSashEvent_SetEdge(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_SetEdge(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxSashEdgePosition edge;
         ::wxSashEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_edge,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxSashEvent, &sipCpp, sipType_wxSashEdgePosition, &edge))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetEdge(edge);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_SetEdge, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSashEvent_SetDragRect, "SetDragRect(rect)");

extern "C" {static PyObject *meth_wxSashEvent_SetDragRect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_SetDragRect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRect* rect;
        int rectState = 0;
         ::wxSashEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxSashEvent, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDragRect(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_SetDragRect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSashEvent_SetDragStatus, "SetDragStatus(status)");

extern "C" {static PyObject *meth_wxSashEvent_SetDragStatus(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_SetDragStatus(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxSashDragStatus status;
         ::wxSashEvent *sipCpp;

        static const char *sipKwdList[] = {
            sipName_status,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxSashEvent, &sipCpp, sipType_wxSashDragStatus, &status))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetDragStatus(status);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_SetDragStatus, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSashEvent_Clone, "Clone(self) -> Event");

extern "C" {static PyObject *meth_wxSashEvent_Clone(PyObject *, PyObject *);}
static PyObject *meth_wxSashEvent_Clone(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    bool sipSelfWasArg = (!sipSelf || sipIsDerivedClass((sipSimpleWrapper *)sipSelf));

    {
        const  ::wxSashEvent *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxSashEvent, &sipCpp))
        {
             ::wxEvent*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = (sipSelfWasArg ? sipCpp-> ::wxSashEvent::Clone() : sipCpp->Clone());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxEvent,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SashEvent, sipName_Clone, doc_wxSashEvent_Clone);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxSashEvent(void *, const sipTypeDef *);}
static void *cast_wxSashEvent(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxSashEvent *sipCpp = reinterpret_cast< ::wxSashEvent *>(sipCppV);

    if (targetType == sipType_wxSashEvent)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxCommandEvent)->ctd_cast(static_cast< ::wxCommandEvent *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSashEvent(void *, int);}
static void release_wxSashEvent(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxSashEvent *>(sipCppV);
    else
        delete reinterpret_cast< ::wxSashEvent *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxSashEvent(sipSimpleWrapper *);}
static void dealloc_wxSashEvent(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxSashEvent *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSashEvent(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxSashEvent(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSashEvent(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxSashEvent *sipCpp = SIP_NULLPTR;

    {
        int id = 0;
         ::wxSashEdgePosition edge = wxSASH_NONE;

        static const char *sipKwdList[] = {
            sipName_id,
            sipName_edge,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "|iE", &id, sipType_wxSashEdgePosition, &edge))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxSashEvent(id,edge);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxSashEvent* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxSashEvent, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxSashEvent(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxSashEvent[] = {{14, 0, 1}};


static PyMethodDef methods_wxSashEvent[] = {
    {sipName_Clone, meth_wxSashEvent_Clone, METH_VARARGS, doc_wxSashEvent_Clone},
    {sipName_GetDragRect, meth_wxSashEvent_GetDragRect, METH_VARARGS, doc_wxSashEvent_GetDragRect},
    {sipName_GetDragStatus, meth_wxSashEvent_GetDragStatus, METH_VARARGS, doc_wxSashEvent_GetDragStatus},
    {sipName_GetEdge, meth_wxSashEvent_GetEdge, METH_VARARGS, doc_wxSashEvent_GetEdge},
    {sipName_SetDragRect, SIP_MLMETH_CAST(meth_wxSashEvent_SetDragRect), METH_VARARGS|METH_KEYWORDS, doc_wxSashEvent_SetDragRect},
    {sipName_SetDragStatus, SIP_MLMETH_CAST(meth_wxSashEvent_SetDragStatus), METH_VARARGS|METH_KEYWORDS, doc_wxSashEvent_SetDragStatus},
    {sipName_SetEdge, SIP_MLMETH_CAST(meth_wxSashEvent_SetEdge), METH_VARARGS|METH_KEYWORDS, doc_wxSashEvent_SetEdge}
};

sipVariableDef variables_wxSashEvent[] = {
    {PropertyVariable, sipName_Edge, &methods_wxSashEvent[3], &methods_wxSashEvent[6], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DragStatus, &methods_wxSashEvent[2], &methods_wxSashEvent[5], SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_DragRect, &methods_wxSashEvent[1], &methods_wxSashEvent[4], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxSashEvent, "SashEvent(id=0, edge=SASH_NONE)\n"
"\n"
"A sash event is sent when the sash of a wxSashWindow has been dragged\n"
"by the user.");


sipClassTypeDef sipTypeDef__adv_wxSashEvent = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxSashEvent,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_SashEvent,
        {0, 0, 1},
        7, methods_wxSashEvent,
        0, SIP_NULLPTR,
        3, variables_wxSashEvent,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxSashEvent,
    -1,
    -1,
    supers_wxSashEvent,
    SIP_NULLPTR,
    init_type_wxSashEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxSashEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxSashEvent,
    cast_wxSashEvent,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
