# tail

> Display the last part of a file.
> See also: `head`.
> More information: <https://keith.github.io/xcode-man-pages/tail.1.html>.

- Show last 8 lines in file:

`tail -n 8 {{path/to/file}}`

- Print a file from a specific line number:

`tail -n +{{8}} {{path/to/file}}`

- Print a specific count of bytes from the end of a given file:

`tail -c {{8}} {{path/to/file}}`

- Print the last lines of a given file and keep reading it until `<Ctrl c>`:

`tail -f {{path/to/file}}`

- Keep reading file until `<Ctrl c>`, even if the file is inaccessible:

`tail -F {{path/to/file}}`

- Show last `count` lines in a file and refresh every `seconds` seconds:

`tail -n {{count}} -s {{seconds}} -f {{path/to/file}}`
