[comment {-*- tcl -*- doctools manpage}]
[manpage_begin "Printers" n ""]
[copyright "2006-2009 Ashok P. Nadkarni"]
[moddesc "Printers"]
[titledesc "Printer management"]
[require twapi_printer]
[description]
[para]

This module provides commands related to Windows printer management.

[section "Printer Management"]
The command [uri \#enumerate_printers [cmd enumerate_printers]] returns
all the printers on the system. The command
[uri #get_default_printer [cmd get_default_printer]] returns the
name of the default printer.

[section Commands]

[list_begin definitions]
[call [cmd enumerate_printers] [opt "[cmd -proximity] [arg PROXIMITY]"]]
Returns information about the printers on the system.
The data is returned as a [uri base.html#recordarrays "record array"]
with the following fields:
[list_begin opt]
[opt_def [cmd -name]] The following value is the name of the printer.
[opt_def [cmd -server]] The following value is the server on which
the printer resides.
[opt_def [cmd -attrs]] The following value is a list of attributes for
the printer. This is a list of zero or more symbols from the following list:
[const queued], [const direct], [const default], [const shared],
[const network], [const hidden], [const local], [const enabledevq],
[const keepprintedjobs], [const docompletefirst], [const workoffline],
[const enablebidi],
[const rawonly], [const published], [const fax], [const ts].
Refer to the Windows SDK documentation for the meaning of these attributes.
[list_end]

[arg PROXIMITY] may be one of [const all] (default), [const local]
or [const remote] depending on whether all printers, local printers
or remote printers are to be included in the returned list.

[call [cmd get_default_printer]]
Returns the name of the default printer.


[list_end]

[keywords printers fax "printer properties dialog"]
[manpage_end]
