# ✨ Sponsor Starlette & Uvicorn ✨

Thank you for your interest in sponsoring Starlette and Uvicorn! ❤️

Your support *directly* contributes to the ongoing development, maintenance, and long-term sustainability of both projects.

<div style="display: flex; justify-content: center; gap: 4rem; margin: 2rem 0; text-align: center;">
    <div style="padding: 1rem;">
        <h3 style="color: #6e5494; font-size: 2em; margin-bottom: 0.5rem;">67M+</h3>
        <p>Starlette Downloads/Month</p>
    </div>
    <div style="padding: 1rem;">
        <h3 style="color: #6e5494; font-size: 2em; margin-bottom: 0.5rem;">57M+</h3>
        <p>Uvicorn Downloads/Month</p>
    </div>
    <div style="padding: 1rem;">
        <h3 style="color: #6e5494; font-size: 2em; margin-bottom: 0.5rem;">19K+</h3>
        <p>Combined GitHub Stars</p>
    </div>
</div>

## Why Sponsor?

While Starlette and Uvicorn are part of the [Encode](https://github.com/encode) organization,
they have been primarily maintained by [**Marcelo Trylesinski (Kludex)**](https://github.com/Kludex)
for the past several years. His dedication and consistent work have been instrumental in keeping
these projects robust, secure, and up-to-date.

This sponsorship page was created to give the community an opportunity to support Marcelo's continued
efforts in maintaining and improving both projects. Your sponsorship directly enables him to
dedicate more time and resources to maintaining and improving these essential tools:

- [x] **Active Development:** Developing new features, enhancing existing ones, and
  keeping both projects aligned with the latest developments in the Python and ASGI ecosystems. 💻
- [x] **Community Support:** Providing better support, addressing user issues,
  and cultivating a welcoming environment for contributors. 🤝
- [x] **Long-Term Stability:** Ensuring the long-term viability of both projects through strategic
  planning and addressing technical debt. 🌳
- [x] **Bug Fixes & Maintenance:** Providing prompt attention to bug reports and
  general maintenance to keep the projects reliable. 🔨
- [x] **Security:** Ensuring robust security practices, conducting regular security audits, and
  promptly addressing vulnerabilities to protect millions of production deployments. 🔒
- [x] **Documentation:** Creating comprehensive guides, tutorials, and examples to help users of all skill levels. 📖

## How Sponsorship Works

We currently manage sponsorships *exclusively* through **GitHub Sponsors**. This platform integrates seamlessly with the GitHub ecosystem, making it easy for organizations to contribute.

<div style="text-align: center; padding: 2rem; margin: 2rem 0; background: linear-gradient(135deg, #6e5494, #24292e); border-radius: 10px; color: white;">
    <h2 style="color: white; margin-bottom: 1rem;">🌟 Become a Sponsor Today! 🌟</h2>
    <p style="margin-bottom: 1.5rem; font-size: 1.1em;">Your support helps keep Starlette and Uvicorn growing stronger!</p>
    <a href="https://github.com/sponsors/Kludex"
       style="display: inline-block; padding: 1rem 2rem; background-color: #238636; color: white; text-decoration: none; border-radius: 6px; font-size: 1.2em; font-weight: bold; transition: all 0.3s ease-in-out;"
       onmouseover="this.style.backgroundColor='#2ea043';this.style.transform='translateY(-2px)'"
       onmouseout="this.style.backgroundColor='#238636';this.style.transform='translateY(0)'">
        ❤️ Sponsor on GitHub
    </a>
</div>

## Sponsorship Tiers 🎁

<div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(250px, 1fr)); gap: 1.5rem; margin: 2rem 0;">
    <div style="padding: 1.5rem; border: 1px solid #e1e4e8; border-radius: 6px; background: #fff; display: flex; flex-direction: column;">
        <h3 style="color: #cd7f32;">🥉 Bronze Sponsor</h3>
        <div style="font-size: 1.5em; margin: 1rem 0;">$100<span style="font-size: 0.6em;">/month</span></div>
        <ul style="list-style: none; padding: 0; margin-bottom: 1rem; min-height: 90px;">
            <li>✓ Company name on Sponsors page</li>
            <li>✓ Small logo with link</li>
            <li>✓ Our eternal gratitude</li>
        </ul>
        <div style="text-align: center; margin-top: auto;">
            <a href="https://github.com/sponsors/Kludex" style="display: inline-block; padding: 0.5rem 1rem; background-color: #cd7f32; color: white; text-decoration: none; border-radius: 6px; font-weight: bold; transition: opacity 0.2s;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                Become a Bronze Sponsor
            </a>
        </div>
    </div>
    <div style="padding: 1.5rem; border: 1px solid #e1e4e8; border-radius: 6px; background: #fff; display: flex; flex-direction: column;">
        <h3 style="color: #c0c0c0;">🥈 Silver Sponsor</h3>
        <div style="font-size: 1.5em; margin: 1rem 0;">$250<span style="font-size: 0.6em;">/month</span></div>
        <ul style="list-style: none; padding: 0; margin-bottom: 1rem; min-height: 90px;">
            <li>✓ All Bronze benefits</li>
            <li>✓ Medium-sized logo</li>
            <li>✓ Release notes mention</li>
        </ul>
        <div style="text-align: center; margin-top: auto;">
            <a href="https://github.com/sponsors/Kludex" style="display: inline-block; padding: 0.5rem 1rem; background-color: #c0c0c0; color: white; text-decoration: none; border-radius: 6px; font-weight: bold; transition: opacity 0.2s;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                Become a Silver Sponsor
            </a>
        </div>
    </div>
    <div style="padding: 1.5rem; border: 1px solid #e1e4e8; border-radius: 6px; background: #fff; position: relative; overflow: hidden; display: flex; flex-direction: column;">
        <div style="position: absolute; top: 10px; right: -25px; background: #238636; color: white; padding: 5px 30px; transform: rotate(45deg);">
            Popular
        </div>
        <h3 style="color: #ffd700;">🥇 Gold Sponsor</h3>
        <div style="font-size: 1.5em; margin: 1rem 0;">$500<span style="font-size: 0.6em;">/month</span></div>
        <ul style="list-style: none; padding: 0; margin-bottom: 1rem; min-height: 90px;">
            <li>✓ All Silver benefits</li>
            <li>✓ Large logo on main pages</li>
            <li>✓ Priority support</li>
        </ul>
        <div style="text-align: center; margin-top: auto;">
            <a href="https://github.com/sponsors/Kludex" style="display: inline-block; padding: 0.5rem 1rem; background-color: #ffd700; color: black; text-decoration: none; border-radius: 6px; font-weight: bold; transition: opacity 0.2s;" onmouseover="this.style.opacity='0.8'" onmouseout="this.style.opacity='1'">
                Become a Gold Sponsor
            </a>
        </div>
    </div>
</div>

<div style="text-align: center; margin: 2rem 0;">
    <h3>🤝 Custom Sponsor</h3>
    <p>Looking for something different? <a href="mailto:marcelotryle@gmail.com">Contact us</a> to discuss custom sponsorship options!</p>
</div>

## Current Sponsors

**Thank you to our generous sponsors!** 🙏

<div style="display: flex; flex-direction: column; gap: 3rem; margin: 2rem 0;">
    <div>
        <h3 style="text-align: center; color: #ffd700; margin-bottom: 1.5rem;">🏆 Gold Sponsors</h3>
        <div style="display: flex; flex-wrap: wrap; justify-content: center; gap: 2rem; align-items: center;">
            <a href="https://fastapi.tiangolo.com" style="text-decoration: none;">
                <div style="width: 200px; background: #f6f8fa; border-radius: 8px; padding: 1rem; text-align: center;">
                    <div style="height: 100px; display: flex; align-items: center; justify-content: center; margin-bottom: 0.75rem;">
                        <img src="https://fastapi.tiangolo.com/img/logo-margin/logo-teal.png" alt="FastAPI" style="max-width: 100%; max-height: 100%; object-fit: contain;">
                    </div>
                    <p style="margin: 0; color: #57606a; font-size: 0.9em;">Modern, fast web framework for building APIs with Python 3.8+</p>
                </div>
            </a>
        </div>
    </div>

    <div>
        <h3 style="text-align: center; color: #c0c0c0; margin-bottom: 1.5rem;">🥈 Silver Sponsors</h3>
        <div style="display: flex; flex-wrap: wrap; justify-content: center; gap: 2rem; align-items: center;">
            <!-- Add Silver Sponsors here -->
        </div>
    </div>

    <div>
        <h3 style="text-align: center; color: #cd7f32; margin-bottom: 1.5rem;">🥉 Bronze Sponsors</h3>
        <div style="display: flex; flex-wrap: wrap; justify-content: center; gap: 2rem; align-items: center;">
            <!-- Add Bronze Sponsors here -->
        </div>
    </div>
</div>

## Alternative Sponsorship Platforms

<div style="background: #f6f8fa; padding: 1.5rem; border-radius: 8px; margin: 2rem 0;">
    <h3>📢 We Want Your Input!</h3>
    <p>We are currently evaluating whether to expand our sponsorship options beyond GitHub Sponsors. If your company would be interested in sponsoring Starlette and Uvicorn but prefers to use a different platform (e.g., Open Collective, direct invoicing), please let us know!</p>
    <p>Your feedback is invaluable in helping us make sponsorship as accessible as possible. Share your thoughts by:</p>
    <ul>
        <li>Opening a discussion on our <a href="https://github.com/encode/starlette/discussions">GitHub repository</a></li>
        <li>Contacting us directly at <a href="mailto:marcelotryle@gmail.com">marcelotryle@gmail.com</a></li>
    </ul>
</div>

<a id="acknowledgments"></a>

## Community & Future Plans 🌟

We want to express our deepest gratitude to all the contributors who have helped shape Starlette and
Uvicorn over the years. These projects wouldn't be what they are today without the incredible work of
every single contributor.

Special thanks to some of our most impactful contributors:

- **Tom Christie** ([@tomchristie](https://github.com/tomchristie)) - The original creator of Starlette and Uvicorn.
- **Adrian Garcia Badaracco** ([@adriangb](https://github.com/adriangb)) - Major contributor to Starlette.
- **Thomas Grainger** ([@graingert](https://github.com/graingert)) - Major contributor to AnyIO, and significant contributions to Starlette and Uvicorn.
- **Alex Grönholm** ([@agronholm](https://github.com/agronholm)) - Creator of AnyIO.
- **Florimond Manca** ([@florimondmanca](https://github.com/florimondmanca)) - Important contributions to Starlette and Uvicorn.

If you want your name removed from the list above, or if I forgot a significant contributor, please let me know.
You can view all contributors on GitHub:
[Starlette Contributors](https://github.com/encode/starlette/graphs/contributors) / [Uvicorn Contributors](https://github.com/encode/uvicorn/graphs/contributors).

While the current sponsorship program directly supports Marcelo's maintenance work, we are exploring ways
to distribute funding to other key contributors in the future. This initiative is still in early planning
stages, as we want to ensure a fair and sustainable model that recognizes the valuable contributions of
our community members.

