# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rdflib',
 'rdflib.extras',
 'rdflib.namespace',
 'rdflib.plugins',
 'rdflib.plugins.parsers',
 'rdflib.plugins.serializers',
 'rdflib.plugins.shared',
 'rdflib.plugins.shared.jsonld',
 'rdflib.plugins.sparql',
 'rdflib.plugins.sparql.results',
 'rdflib.plugins.stores',
 'rdflib.tools']

package_data = \
{'': ['*']}

install_requires = \
['pyparsing>=2.1.0,<4']

extras_require = \
{':python_version < "3.11"': ['isodate>=0.7.2,<1.0.0'],
 'berkeleydb': ['berkeleydb>=18.1.0,<19.0.0'],
 'html': ['html5rdf>=1.2,<2'],
 'lxml': ['lxml>=4.3,<6.0'],
 'networkx': ['networkx>=2,<4'],
 'orjson': ['orjson>=3.9.14,<4']}

entry_points = \
{'console_scripts': ['csv2rdf = rdflib.tools.csv2rdf:main',
                     'rdf2dot = rdflib.tools.rdf2dot:main',
                     'rdfgraphisomorphism = rdflib.tools.graphisomorphism:main',
                     'rdfpipe = rdflib.tools.rdfpipe:main',
                     'rdfs2dot = rdflib.tools.rdfs2dot:main']}

setup_kwargs = {
    'name': 'rdflib',
    'version': '7.1.1',
    'description': 'RDFLib is a Python library for working with RDF, a simple yet powerful language for representing information.',
    'long_description': '![](docs/_static/RDFlib.png)    \n\nRDFLib\n======\n[![Build Status](https://github.com/RDFLib/rdflib/actions/workflows/validate.yaml/badge.svg?branch=main)](https://github.com/RDFLib/rdflib/actions?query=branch%3Amain)\n[![Documentation Status](https://readthedocs.org/projects/rdflib/badge/?version=latest)](https://rdflib.readthedocs.io/en/latest/?badge=latest)\n[![Coveralls branch](https://img.shields.io/coveralls/RDFLib/rdflib/main.svg)](https://coveralls.io/r/RDFLib/rdflib?branch=main)\n\n[![GitHub stars](https://img.shields.io/github/stars/RDFLib/rdflib.svg)](https://github.com/RDFLib/rdflib/stargazers)\n[![Downloads](https://pepy.tech/badge/rdflib/week)](https://pepy.tech/project/rdflib)\n[![PyPI](https://img.shields.io/pypi/v/rdflib.svg)](https://pypi.python.org/pypi/rdflib)\n[![PyPI](https://img.shields.io/pypi/pyversions/rdflib.svg)](https://pypi.python.org/pypi/rdflib)\n[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.6845245.svg)](https://doi.org/10.5281/zenodo.6845245)\n\n[![Contribute with Gitpod](https://img.shields.io/badge/Contribute%20with-Gitpod-908a85?logo=gitpod)](https://gitpod.io/#https://github.com/RDFLib/rdflib)\n[![Gitter](https://badges.gitter.im/RDFLib/rdflib.svg)](https://gitter.im/RDFLib/rdflib?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge)\n[![Matrix](https://img.shields.io/matrix/rdflib:matrix.org?label=matrix.org%20chat)](https://matrix.to/#/#RDFLib_rdflib:gitter.im)\n\nRDFLib is a pure Python package for working with [RDF](http://www.w3.org/RDF/). RDFLib contains most things you need to work with RDF, including:\n\n* parsers and serializers for RDF/XML, N3, NTriples, N-Quads, Turtle, TriX, Trig and JSON-LD\n* a Graph interface which can be backed by any one of a number of Store implementations\n* store implementations for in-memory, persistent on disk (Berkeley DB) and remote SPARQL endpoints\n* a SPARQL 1.1 implementation - supporting SPARQL 1.1 Queries and Update statements\n* SPARQL function extension mechanisms\n\n## RDFlib Family of packages\nThe RDFlib community maintains many RDF-related Python code repositories with different purposes. For example:\n\n* [rdflib](https://github.com/RDFLib/rdflib) - the RDFLib core\n* [sparqlwrapper](https://github.com/RDFLib/sparqlwrapper) - a simple Python wrapper around a SPARQL service to remotely execute your queries\n* [pyLODE](https://github.com/RDFLib/pyLODE) - An OWL ontology documentation tool using Python and templating, based on LODE.\n* [pyrdfa3](https://github.com/RDFLib/pyrdfa3) - RDFa 1.1 distiller/parser library: can extract RDFa 1.1/1.0 from (X)HTML, SVG, or XML in general.\n* [pymicrodata](https://github.com/RDFLib/pymicrodata) - A module to extract RDF from an HTML5 page annotated with microdata. \n* [pySHACL](https://github.com/RDFLib/pySHACL) - A pure Python module which allows for the validation of RDF graphs against SHACL graphs.\n* [OWL-RL](https://github.com/RDFLib/OWL-RL) - A simple implementation of the OWL2 RL Profile which expands the graph with all possible triples that OWL RL defines.\n\nPlease see the list for all packages/repositories here:\n\n* <https://github.com/RDFLib>\n\nHelp with maintenance of all of the RDFLib family of packages is always welcome and appreciated.\n\n## Versions & Releases\n\n* `main` branch in this repository is the unstable release\n* `7.1.1` current stable release, bugfixes to 7.1.0\n* `7.0.0` previous stable release, supports Python 3.8.1+ only.\n    * see [Releases](https://github.com/RDFLib/rdflib/releases)\n* `6.x.y` supports Python 3.7+ only. Many improvements over 5.0.0\n    * see [Releases](https://github.com/RDFLib/rdflib/releases)\n* `5.x.y` supports Python 2.7 and 3.4+ and is [mostly backwards compatible with 4.2.2](https://rdflib.readthedocs.io/en/stable/upgrade4to5.html).\n\nSee <https://github.com/RDFLib/rdflib/releases/> for the release details.\n\n## Documentation\nSee <https://rdflib.readthedocs.io> for our documentation built from the code. Note that there are `latest`, `stable` and versioned builds, such as `5.0.0`, matching releases.\n\n## Installation\nThe stable release of RDFLib may be installed with Python\'s package management tool *pip*:\n\n    $ pip install rdflib\n\nSome features of RDFLib require optional dependencies which may be installed using *pip* extras:\n\n    $ pip install rdflib[berkeleydb,networkx,html,lxml,orjson]\n\nAlternatively manually download the package from the Python Package\nIndex (PyPI) at https://pypi.python.org/pypi/rdflib\n\nThe current version of RDFLib is 7.1.1, see the ``CHANGELOG.md`` file for what\'s new in this release.\n\n### Installation of the current main branch (for developers)\n\nWith *pip* you can also install rdflib from the git repository with one of the following options:\n\n    $ pip install git+https://github.com/rdflib/rdflib@main\n\nor\n\n    $ pip install -e git+https://github.com/rdflib/rdflib@main#egg=rdflib\n\nor from your locally cloned repository you can install it with one of the following options:\n\n    $ poetry install  # installs into a poetry-managed venv\n\nor\n\n    $ pip install -e .\n\n## Getting Started\nRDFLib aims to be a pythonic RDF API. RDFLib\'s main data object is a `Graph` which is a Python collection\nof RDF *Subject, Predicate, Object* Triples:\n\nTo create graph and load it with RDF data from DBPedia then print the results:\n\n```python\nfrom rdflib import Graph\ng = Graph()\ng.parse(\'http://dbpedia.org/resource/Semantic_Web\')\n\nfor s, p, o in g:\n    print(s, p, o)\n```\nThe components of the triples are URIs (resources) or Literals\n(values).\n\nURIs are grouped together by *namespace*, common namespaces are included in RDFLib:\n\n```python\nfrom rdflib.namespace import DC, DCTERMS, DOAP, FOAF, SKOS, OWL, RDF, RDFS, VOID, XMLNS, XSD\n```\n\nYou can use them like this:\n\n```python\nfrom rdflib import Graph, URIRef, Literal\nfrom rdflib.namespace import RDFS, XSD\n\ng = Graph()\nsemweb = URIRef(\'http://dbpedia.org/resource/Semantic_Web\')\ntype = g.value(semweb, RDFS.label)\n```\nWhere `RDFS` is the RDFS namespace, `XSD` the XML Schema Datatypes namespace and `g.value` returns an object of the triple-pattern given (or an arbitrary one if multiple exist).\n\nOr like this, adding a triple to a graph `g`:\n\n```python\ng.add((\n    URIRef("http://example.com/person/nick"),\n    FOAF.givenName,\n    Literal("Nick", datatype=XSD.string)\n))\n```\nThe triple (in n-triples notation) `<http://example.com/person/nick> <http://xmlns.com/foaf/0.1/givenName> "Nick"^^<http://www.w3.org/2001/XMLSchema#string> .`\nis created where the property `FOAF.givenName` is the URI `<http://xmlns.com/foaf/0.1/givenName>` and `XSD.string` is the\nURI `<http://www.w3.org/2001/XMLSchema#string>`.\n\nYou can bind namespaces to prefixes to shorten the URIs for RDF/XML, Turtle, N3, TriG, TriX & JSON-LD serializations:\n\n ```python\ng.bind("foaf", FOAF)\ng.bind("xsd", XSD)\n```\nThis will allow the n-triples triple above to be serialised like this:\n ```python\nprint(g.serialize(format="turtle"))\n```\n\nWith these results:\n```turtle\nPREFIX foaf: <http://xmlns.com/foaf/0.1/>\nPREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\n\n<http://example.com/person/nick> foaf:givenName "Nick"^^xsd:string .\n```\n\nNew Namespaces can also be defined:\n\n```python\ndbpedia = Namespace(\'http://dbpedia.org/ontology/\')\n\nabstracts = list(x for x in g.objects(semweb, dbpedia[\'abstract\']) if x.language==\'en\')\n```\n\nSee also [./examples](./examples)\n\n\n## Features\nThe library contains parsers and serializers for RDF/XML, N3,\nNTriples, N-Quads, Turtle, TriX, JSON-LD, RDFa and Microdata.\n\nThe library presents a Graph interface which can be backed by\nany one of a number of Store implementations.\n\nThis core RDFLib package includes store implementations for\nin-memory storage and persistent storage on top of the Berkeley DB.\n\nA SPARQL 1.1 implementation is included - supporting SPARQL 1.1 Queries and Update statements.\n\nRDFLib is open source and is maintained on [GitHub](https://github.com/RDFLib/rdflib/). RDFLib releases, current and previous\nare listed on [PyPI](https://pypi.python.org/pypi/rdflib/)\n\nMultiple other projects are contained within the RDFlib "family", see <https://github.com/RDFLib/>.\n\n## Running tests\n\n### Running the tests on the host\n\nRun the test suite with `pytest`.\n```shell\npoetry install\npoetry run pytest\n```\n\n### Running test coverage on the host with coverage report\n\nRun the test suite and generate a HTML coverage report with `pytest` and `pytest-cov`.\n```shell\npoetry run pytest --cov\n```\n\n### Viewing test coverage\n\nOnce tests have produced HTML output of the coverage report, view it by running:\n```shell\npoetry run pytest --cov --cov-report term --cov-report html\npython -m http.server --directory=htmlcov\n```\n\n## Contributing\n\nRDFLib survives and grows via user contributions!\nPlease read our [contributing guide](https://rdflib.readthedocs.io/en/latest/CONTRIBUTING.html) and [developers guide](https://rdflib.readthedocs.io/en/latest/developers.html) to get started.\nPlease consider lodging Pull Requests here:\n\n* <https://github.com/RDFLib/rdflib/pulls>\n\nTo get a development environment consider using Gitpod or Google Cloud Shell.\n\n[![Open in Gitpod](https://gitpod.io/button/open-in-gitpod.svg)](https://gitpod.io/#https://github.com/RDFLib/rdflib)\n[![Open in Cloud Shell](https://gstatic.com/cloudssh/images/open-btn.svg)](https://shell.cloud.google.com/cloudshell/editor?cloudshell_git_repo=https%3A%2F%2Fgithub.com%2FRDFLib%2Frdflib&cloudshell_git_branch=main&cloudshell_open_in_editor=README.md)\n\nYou can also raise issues here:\n\n* <https://github.com/RDFLib/rdflib/issues>\n\n## Support & Contacts\nFor general "how do I..." queries, please use https://stackoverflow.com and tag your question with `rdflib`.\nExisting questions:\n\n* <https://stackoverflow.com/questions/tagged/rdflib>\n\nIf you want to contact the rdflib maintainers, please do so via:\n\n* the rdflib-dev mailing list: <https://groups.google.com/group/rdflib-dev>\n* the chat, which is available at [gitter](https://gitter.im/RDFLib/rdflib) or via matrix [#RDFLib_rdflib:gitter.im](https://matrix.to/#/#RDFLib_rdflib:gitter.im)\n',
    'author': "Daniel 'eikeon' Krech",
    'author_email': 'eikeon@eikeon.com',
    'maintainer': 'RDFLib Team',
    'maintainer_email': 'rdflib-dev@googlegroups.com',
    'url': 'https://github.com/RDFLib/rdflib',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8.1,<4.0.0',
}


setup(**setup_kwargs)
