<!--
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

(c-glib)=
# Apache Arrow GLib (C)

Apache Arrow GLib is a wrapper library for Apache Arrow C++. Apache Arrow GLib provides C API.

Apache Arrow GLib supports [GObject Introspection][gobject-introspection]. It means that you can create language bindings at runtime or compile time automatically.

## API reference manuals

```{toctree}
:maxdepth: 1

Apache Arrow GLib <arrow-glib/index>
Apache Arrow CUDA GLib <arrow-cuda-glib/index>
Apache Arrow Dataset <arrow-dataset-glib/index>
Apache Arrow Flight GLib <arrow-flight-glib/index>
Apache Arrow Flight SQL GLib <arrow-flight-sql-glib/index>
Apache Parquet GLib <parquet-glib/index>
Gandiva GLib <gandiva-glib/index>
```

[gobject-introspection]: https://gi.readthedocs.io/en/latest/

