# Статичні файли

Ви можете автоматично надавати статичні файли з каталогу, використовуючи `StaticFiles`.

## Використання `StaticFiles`

* Імпортуйте `StaticFiles`.
* "Під'єднати" екземпляр `StaticFiles()` з вказанням необхідного шляху.

{* ../../docs_src/static_files/tutorial001.py hl[2,6] *}

/// note | Технічні деталі

Ви також можете використовувати `from starlette.staticfiles import StaticFiles`.

**FastAPI** надає той самий `starlette.staticfiles`, що й `fastapi.staticfiles` для зручності розробників. Але фактично він безпосередньо походить із Starlette.

///

### Що таке "Під'єднання"

"Під'єднання" означає додавання повноцінного "незалежного" застосунку за певним шляхом, який потім обробляє всі під шляхи.

Це відрізняється від використання `APIRouter`, оскільки під'єднаний застосунок є повністю незалежним. OpenAPI та документація вашого основного застосунку не будуть знати нічого про ваш під'єднаний застосунок.

Ви можете дізнатися більше про це в [Посібнику для просунутих користувачів](../advanced/index.md){.internal-link target=_blank}.

## Деталі

Перше `"/static"` вказує на під шлях, за яким буде "під'єднано" цей новий "застосунок". Тому будь-який шлях, який починається з `"/static"`, буде оброблятися ним.

`directory="static"` визначає каталог, що містить ваші статичні файли.

`name="static"` це ім'я, яке можна використовувати всередині **FastAPI**.

Усі ці параметри можуть бути змінені відповідно до потреб і особливостей вашого застосунку.

## Додаткова інформація

Детальніше про налаштування та можливості можна дізнатися в <a href="https://www.starlette.dev/staticfiles/" class="external-link" target="_blank">документації Starlette про статичні файли</a>.
